import logging

import click
from mythx_models.response import GroupCreationResponse

from mythx_cli.util import write_or_print

LOGGER = logging.getLogger("mythx-cli")


@click.command("open")
@click.argument("name", default="", nargs=1)
@click.pass_obj
def group_open(ctx, name: str) -> None:
    """Create a new group to assign future analyses to.

    \f

    :param ctx: Click context holding group-level parameters
    :param name: The name of the group to be created (autogenerated if empty)
    """

    LOGGER.debug(f"Opening group with name {name}")
    resp: GroupCreationResponse = ctx["client"].create_group(group_name=name)
    write_or_print(
        "Opened group with ID {} and name '{}'".format(resp.identifier, resp.name)
    )
