<!-- 
Thank you for your contribution to the repo :)

Pull Request (PR) Instructions:
Provide a general summary of your changes in the Title above. Fill out each section of the template, and replace the space with an `x` in all the boxes that apply. If you're unsure about any of these, don't hesitate to ask. We're here to help! Once you are satisfied with the pull request, click the "Create pull request" button to submit it for review.

Before submitting this PR, please ensure that your input and responses are entered in the designated space provided below each section to keep all project-related information organized and easily accessible.
 
How to link to a PR:
https://docs.github.com/en/issues/tracking-your-work-with-issues/linking-a-pull-request-to-an-issue 
-->

## Change Description
<!--- 
Describe your changes in detail. In your description, you should answer questions like "Why is this change required? What problem does it solve?".

If it fixes an open issue, please link to the issue here. If this PR closes an issue, put the word 'closes' before the issue link to auto-close the issue when the PR is merged.
-->
- [ ] My PR includes a link to the issue that I am addressing



## Solution Description
<!-- Please explain the technical solution that I have provided and how it addresses the issue or feature being implemented -->



## Code Quality
- [ ] I have read the [Contribution Guide](https://hats-import.readthedocs.io/en/stable/guide/contributing.html) and [LINCC Frameworks Code of Conduct](https://lsstdiscoveryalliance.org/programs/lincc-frameworks/code-conduct/)
- [ ] My code follows the code style of this project
- [ ] My code builds (or compiles) cleanly without any errors or warnings
- [ ] My code contains relevant comments and necessary documentation

## Project-Specific Pull Request Checklists
<!--- Please only use the checklist that apply to your change type(s) -->

### Bug Fix Checklist
- [ ] My fix includes a new test that breaks as a result of the bug (if possible)
- [ ] My change includes a breaking change
  - [ ] My change includes backwards compatibility and deprecation warnings (if possible)

### New Feature Checklist
- [ ] I have added or updated the docstrings associated with my feature using the [NumPy docstring format](https://numpydoc.readthedocs.io/en/latest/format.html)
- [ ] I have updated the tutorial to highlight my new feature (if appropriate)
- [ ] I have added unit/End-to-End (E2E) test cases to cover my new feature
- [ ] My change includes a breaking change
  - [ ] My change includes backwards compatibility and deprecation warnings (if possible)

### Documentation Change Checklist
- [ ] Any updated docstrings use the [NumPy docstring format](https://numpydoc.readthedocs.io/en/latest/format.html)

### Build/CI Change Checklist
- [ ] If required or optional dependencies have changed (including version numbers), I have updated the README to reflect this
- [ ] If this is a new CI setup, I have added the associated badge to the README

<!-- ### Version Change Checklist [For Future Use] -->

### Other Change Checklist
- [ ] Any new or updated docstrings use the [NumPy docstring format](https://numpydoc.readthedocs.io/en/latest/format.html).
- [ ] I have updated the tutorial to highlight my new feature (if appropriate)
- [ ] I have added unit/End-to-End (E2E) test cases to cover any changes
- [ ] My change includes a breaking change
  - [ ] My change includes backwards compatibility and deprecation warnings (if possible)
