""" SA-Pydantic bridge between SqlAlchemy and Pydantic """


# Convert SqlAlchemy models to Pydantic models
from .sa_model import sa_model, ALL_BUT_PRIMARY_KEY

# Namespace for models that can relate to one another
from .models import Models

# Base models for Pydantic-SqlAlchemy models
from .base_model import SAModel, SALoadedModel

# (low-level) getter dicts that implement SA attribute access
from .getter_dict import SAGetterDict, SALoadedGetterDict

# Shortcuts
from sa2schema import AttributeType  # noqa
