#!/usr/bin/env python
# -*- encoding: utf-8 -*-
#
# This file is auto-generated by h2o-3/h2o-bindings/bin/gen_python.py
# Copyright 2016 H2O.ai;  Apache License Version 2.0 (see LICENSE for details)
#
from __future__ import absolute_import, division, print_function, unicode_literals

from h2o.utils.metaclass import deprecated_params, deprecated_property
import h2o
from h2o.utils.typechecks import U
from h2o.estimators.estimator_base import H2OEstimator
from h2o.exceptions import H2OValueError
from h2o.frame import H2OFrame
from h2o.utils.typechecks import assert_is_type, Enum, numeric


class H2OGeneralizedAdditiveEstimator(H2OEstimator):
    """
    Generalized Additive Model

    Fits a generalized additive model, specified by a response variable, a set of predictors, and a
    description of the error distribution.

    A subclass of :class:`ModelBase` is returned. The specific subclass depends on the machine learning task
    at hand (if it's binomial classification, then an H2OBinomialModel is returned, if it's regression then a
    H2ORegressionModel is returned). The default print-out of the models is shown, but further GAM-specific
    information can be queried out of the object. Upon completion of the GAM, the resulting object has
    coefficients, normalized coefficients, residual/null deviance, aic, and a host of model metrics including
    MSE, AUC (for logistic regression), degrees of freedom, and confusion matrices.
    """

    algo = "gam"
    supervised_learning = True
    _options_ = {'model_extensions': ['h2o.model.extensions.ScoringHistoryGLM']}

    @deprecated_params({'Lambda': 'lambda_'})
    def __init__(self,
                 model_id=None,  # type: Optional[Union[None, str, H2OEstimator]]
                 training_frame=None,  # type: Optional[Union[None, str, H2OFrame]]
                 validation_frame=None,  # type: Optional[Union[None, str, H2OFrame]]
                 nfolds=0,  # type: int
                 seed=-1,  # type: int
                 keep_cross_validation_models=True,  # type: bool
                 keep_cross_validation_predictions=False,  # type: bool
                 keep_cross_validation_fold_assignment=False,  # type: bool
                 fold_assignment="auto",  # type: Literal["auto", "random", "modulo", "stratified"]
                 fold_column=None,  # type: Optional[str]
                 response_column=None,  # type: Optional[str]
                 ignored_columns=None,  # type: Optional[List[str]]
                 ignore_const_cols=True,  # type: bool
                 score_each_iteration=False,  # type: bool
                 offset_column=None,  # type: Optional[str]
                 weights_column=None,  # type: Optional[str]
                 family="auto",  # type: Literal["auto", "gaussian", "binomial", "quasibinomial", "ordinal", "multinomial", "poisson", "gamma", "tweedie", "negativebinomial", "fractionalbinomial"]
                 tweedie_variance_power=0.0,  # type: float
                 tweedie_link_power=0.0,  # type: float
                 theta=0.0,  # type: float
                 solver="auto",  # type: Literal["auto", "irlsm", "l_bfgs", "coordinate_descent_naive", "coordinate_descent", "gradient_descent_lh", "gradient_descent_sqerr"]
                 alpha=None,  # type: Optional[List[float]]
                 lambda_=None,  # type: Optional[List[float]]
                 lambda_search=False,  # type: bool
                 early_stopping=True,  # type: bool
                 nlambdas=-1,  # type: int
                 standardize=False,  # type: bool
                 missing_values_handling="mean_imputation",  # type: Literal["mean_imputation", "skip", "plug_values"]
                 plug_values=None,  # type: Optional[Union[None, str, H2OFrame]]
                 compute_p_values=False,  # type: bool
                 remove_collinear_columns=False,  # type: bool
                 intercept=True,  # type: bool
                 non_negative=False,  # type: bool
                 max_iterations=-1,  # type: int
                 objective_epsilon=-1.0,  # type: float
                 beta_epsilon=0.0001,  # type: float
                 gradient_epsilon=-1.0,  # type: float
                 link="family_default",  # type: Literal["family_default", "identity", "logit", "log", "inverse", "tweedie", "ologit"]
                 startval=None,  # type: Optional[List[float]]
                 prior=-1.0,  # type: float
                 cold_start=False,  # type: bool
                 lambda_min_ratio=-1.0,  # type: float
                 beta_constraints=None,  # type: Optional[Union[None, str, H2OFrame]]
                 max_active_predictors=-1,  # type: int
                 interactions=None,  # type: Optional[List[str]]
                 interaction_pairs=None,  # type: Optional[List[tuple]]
                 obj_reg=-1.0,  # type: float
                 export_checkpoints_dir=None,  # type: Optional[str]
                 stopping_rounds=0,  # type: int
                 stopping_metric="auto",  # type: Literal["auto", "deviance", "logloss", "mse", "rmse", "mae", "rmsle", "auc", "aucpr", "lift_top_group", "misclassification", "mean_per_class_error", "custom", "custom_increasing"]
                 stopping_tolerance=0.001,  # type: float
                 balance_classes=False,  # type: bool
                 class_sampling_factors=None,  # type: Optional[List[float]]
                 max_after_balance_size=5.0,  # type: float
                 max_confusion_matrix_size=20,  # type: int
                 max_runtime_secs=0.0,  # type: float
                 custom_metric_func=None,  # type: Optional[str]
                 num_knots=None,  # type: Optional[List[int]]
                 knot_ids=None,  # type: Optional[List[str]]
                 gam_columns=None,  # type: Optional[List[List[str]]]
                 standardize_tp_gam_cols=False,  # type: bool
                 scale_tp_penalty_mat=False,  # type: bool
                 bs=None,  # type: Optional[List[int]]
                 scale=None,  # type: Optional[List[float]]
                 keep_gam_cols=False,  # type: bool
                 auc_type="auto",  # type: Literal["auto", "none", "macro_ovr", "weighted_ovr", "macro_ovo", "weighted_ovo"]
                 ):
        """
        :param model_id: Destination id for this model; auto-generated if not specified.
               Defaults to ``None``.
        :type model_id: Union[None, str, H2OEstimator], optional
        :param training_frame: Id of the training data frame.
               Defaults to ``None``.
        :type training_frame: Union[None, str, H2OFrame], optional
        :param validation_frame: Id of the validation data frame.
               Defaults to ``None``.
        :type validation_frame: Union[None, str, H2OFrame], optional
        :param nfolds: Number of folds for K-fold cross-validation (0 to disable or >= 2).
               Defaults to ``0``.
        :type nfolds: int
        :param seed: Seed for pseudo random number generator (if applicable)
               Defaults to ``-1``.
        :type seed: int
        :param keep_cross_validation_models: Whether to keep the cross-validation models.
               Defaults to ``True``.
        :type keep_cross_validation_models: bool
        :param keep_cross_validation_predictions: Whether to keep the predictions of the cross-validation models.
               Defaults to ``False``.
        :type keep_cross_validation_predictions: bool
        :param keep_cross_validation_fold_assignment: Whether to keep the cross-validation fold assignment.
               Defaults to ``False``.
        :type keep_cross_validation_fold_assignment: bool
        :param fold_assignment: Cross-validation fold assignment scheme, if fold_column is not specified. The
               'Stratified' option will stratify the folds based on the response variable, for classification problems.
               Defaults to ``"auto"``.
        :type fold_assignment: Literal["auto", "random", "modulo", "stratified"]
        :param fold_column: Column with cross-validation fold index assignment per observation.
               Defaults to ``None``.
        :type fold_column: str, optional
        :param response_column: Response variable column.
               Defaults to ``None``.
        :type response_column: str, optional
        :param ignored_columns: Names of columns to ignore for training.
               Defaults to ``None``.
        :type ignored_columns: List[str], optional
        :param ignore_const_cols: Ignore constant columns.
               Defaults to ``True``.
        :type ignore_const_cols: bool
        :param score_each_iteration: Whether to score during each iteration of model training.
               Defaults to ``False``.
        :type score_each_iteration: bool
        :param offset_column: Offset column. This will be added to the combination of columns before applying the link
               function.
               Defaults to ``None``.
        :type offset_column: str, optional
        :param weights_column: Column with observation weights. Giving some observation a weight of zero is equivalent
               to excluding it from the dataset; giving an observation a relative weight of 2 is equivalent to repeating
               that row twice. Negative weights are not allowed. Note: Weights are per-row observation weights and do
               not increase the size of the data frame. This is typically the number of times a row is repeated, but
               non-integer values are supported as well. During training, rows with higher weights matter more, due to
               the larger loss function pre-factor. If you set weight = 0 for a row, the returned prediction frame at
               that row is zero and this is incorrect. To get an accurate prediction, remove all rows with weight == 0.
               Defaults to ``None``.
        :type weights_column: str, optional
        :param family: Family. Use binomial for classification with logistic regression, others are for regression
               problems.
               Defaults to ``"auto"``.
        :type family: Literal["auto", "gaussian", "binomial", "quasibinomial", "ordinal", "multinomial", "poisson", "gamma",
               "tweedie", "negativebinomial", "fractionalbinomial"]
        :param tweedie_variance_power: Tweedie variance power
               Defaults to ``0.0``.
        :type tweedie_variance_power: float
        :param tweedie_link_power: Tweedie link power
               Defaults to ``0.0``.
        :type tweedie_link_power: float
        :param theta: Theta
               Defaults to ``0.0``.
        :type theta: float
        :param solver: AUTO will set the solver based on given data and the other parameters. IRLSM is fast on on
               problems with small number of predictors and for lambda-search with L1 penalty, L_BFGS scales better for
               datasets with many columns.
               Defaults to ``"auto"``.
        :type solver: Literal["auto", "irlsm", "l_bfgs", "coordinate_descent_naive", "coordinate_descent",
               "gradient_descent_lh", "gradient_descent_sqerr"]
        :param alpha: Distribution of regularization between the L1 (Lasso) and L2 (Ridge) penalties. A value of 1 for
               alpha represents Lasso regression, a value of 0 produces Ridge regression, and anything in between
               specifies the amount of mixing between the two. Default value of alpha is 0 when SOLVER = 'L-BFGS'; 0.5
               otherwise.
               Defaults to ``None``.
        :type alpha: List[float], optional
        :param lambda_: Regularization strength
               Defaults to ``None``.
        :type lambda_: List[float], optional
        :param lambda_search: Use lambda search starting at lambda max, given lambda is then interpreted as lambda min
               Defaults to ``False``.
        :type lambda_search: bool
        :param early_stopping: Stop early when there is no more relative improvement on train or validation (if
               provided)
               Defaults to ``True``.
        :type early_stopping: bool
        :param nlambdas: Number of lambdas to be used in a search. Default indicates: If alpha is zero, with lambda
               search set to True, the value of nlamdas is set to 30 (fewer lambdas are needed for ridge regression)
               otherwise it is set to 100.
               Defaults to ``-1``.
        :type nlambdas: int
        :param standardize: Standardize numeric columns to have zero mean and unit variance
               Defaults to ``False``.
        :type standardize: bool
        :param missing_values_handling: Handling of missing values. Either MeanImputation, Skip or PlugValues.
               Defaults to ``"mean_imputation"``.
        :type missing_values_handling: Literal["mean_imputation", "skip", "plug_values"]
        :param plug_values: Plug Values (a single row frame containing values that will be used to impute missing values
               of the training/validation frame, use with conjunction missing_values_handling = PlugValues)
               Defaults to ``None``.
        :type plug_values: Union[None, str, H2OFrame], optional
        :param compute_p_values: Request p-values computation, p-values work only with IRLSM solver and no
               regularization
               Defaults to ``False``.
        :type compute_p_values: bool
        :param remove_collinear_columns: In case of linearly dependent columns, remove some of the dependent columns
               Defaults to ``False``.
        :type remove_collinear_columns: bool
        :param intercept: Include constant term in the model
               Defaults to ``True``.
        :type intercept: bool
        :param non_negative: Restrict coefficients (not intercept) to be non-negative
               Defaults to ``False``.
        :type non_negative: bool
        :param max_iterations: Maximum number of iterations
               Defaults to ``-1``.
        :type max_iterations: int
        :param objective_epsilon: Converge if  objective value changes less than this. Default indicates: If
               lambda_search is set to True the value of objective_epsilon is set to .0001. If the lambda_search is set
               to False and lambda is equal to zero, the value of objective_epsilon is set to .000001, for any other
               value of lambda the default value of objective_epsilon is set to .0001.
               Defaults to ``-1.0``.
        :type objective_epsilon: float
        :param beta_epsilon: Converge if  beta changes less (using L-infinity norm) than beta esilon, ONLY applies to
               IRLSM solver
               Defaults to ``0.0001``.
        :type beta_epsilon: float
        :param gradient_epsilon: Converge if  objective changes less (using L-infinity norm) than this, ONLY applies to
               L-BFGS solver. Default indicates: If lambda_search is set to False and lambda is equal to zero, the
               default value of gradient_epsilon is equal to .000001, otherwise the default value is .0001. If
               lambda_search is set to True, the conditional values above are 1E-8 and 1E-6 respectively.
               Defaults to ``-1.0``.
        :type gradient_epsilon: float
        :param link: Link function.
               Defaults to ``"family_default"``.
        :type link: Literal["family_default", "identity", "logit", "log", "inverse", "tweedie", "ologit"]
        :param startval: double array to initialize coefficients for GAM.
               Defaults to ``None``.
        :type startval: List[float], optional
        :param prior: Prior probability for y==1. To be used only for logistic regression iff the data has been sampled
               and the mean of response does not reflect reality.
               Defaults to ``-1.0``.
        :type prior: float
        :param cold_start: Only applicable to multiple alpha/lambda values when calling GLM from GAM.  If false, build
               the next model for next set of alpha/lambda values starting from the values provided by current model.
               If true will start GLM model from scratch.
               Defaults to ``False``.
        :type cold_start: bool
        :param lambda_min_ratio: Minimum lambda used in lambda search, specified as a ratio of lambda_max (the smallest
               lambda that drives all coefficients to zero). Default indicates: if the number of observations is greater
               than the number of variables, then lambda_min_ratio is set to 0.0001; if the number of observations is
               less than the number of variables, then lambda_min_ratio is set to 0.01.
               Defaults to ``-1.0``.
        :type lambda_min_ratio: float
        :param beta_constraints: Beta constraints
               Defaults to ``None``.
        :type beta_constraints: Union[None, str, H2OFrame], optional
        :param max_active_predictors: Maximum number of active predictors during computation. Use as a stopping
               criterion to prevent expensive model building with many predictors. Default indicates: If the IRLSM
               solver is used, the value of max_active_predictors is set to 5000 otherwise it is set to 100000000.
               Defaults to ``-1``.
        :type max_active_predictors: int
        :param interactions: A list of predictor column indices to interact. All pairwise combinations will be computed
               for the list.
               Defaults to ``None``.
        :type interactions: List[str], optional
        :param interaction_pairs: A list of pairwise (first order) column interactions.
               Defaults to ``None``.
        :type interaction_pairs: List[tuple], optional
        :param obj_reg: Likelihood divider in objective value computation, default is 1/nobs
               Defaults to ``-1.0``.
        :type obj_reg: float
        :param export_checkpoints_dir: Automatically export generated models to this directory.
               Defaults to ``None``.
        :type export_checkpoints_dir: str, optional
        :param stopping_rounds: Early stopping based on convergence of stopping_metric. Stop if simple moving average of
               length k of the stopping_metric does not improve for k:=stopping_rounds scoring events (0 to disable)
               Defaults to ``0``.
        :type stopping_rounds: int
        :param stopping_metric: Metric to use for early stopping (AUTO: logloss for classification, deviance for
               regression and anonomaly_score for Isolation Forest). Note that custom and custom_increasing can only be
               used in GBM and DRF with the Python client.
               Defaults to ``"auto"``.
        :type stopping_metric: Literal["auto", "deviance", "logloss", "mse", "rmse", "mae", "rmsle", "auc", "aucpr", "lift_top_group",
               "misclassification", "mean_per_class_error", "custom", "custom_increasing"]
        :param stopping_tolerance: Relative tolerance for metric-based stopping criterion (stop if relative improvement
               is not at least this much)
               Defaults to ``0.001``.
        :type stopping_tolerance: float
        :param balance_classes: Balance training data class counts via over/under-sampling (for imbalanced data).
               Defaults to ``False``.
        :type balance_classes: bool
        :param class_sampling_factors: Desired over/under-sampling ratios per class (in lexicographic order). If not
               specified, sampling factors will be automatically computed to obtain class balance during training.
               Requires balance_classes.
               Defaults to ``None``.
        :type class_sampling_factors: List[float], optional
        :param max_after_balance_size: Maximum relative size of the training data after balancing class counts (can be
               less than 1.0). Requires balance_classes.
               Defaults to ``5.0``.
        :type max_after_balance_size: float
        :param max_confusion_matrix_size: [Deprecated] Maximum size (# classes) for confusion matrices to be printed in
               the Logs
               Defaults to ``20``.
        :type max_confusion_matrix_size: int
        :param max_runtime_secs: Maximum allowed runtime in seconds for model training. Use 0 to disable.
               Defaults to ``0.0``.
        :type max_runtime_secs: float
        :param custom_metric_func: Reference to custom evaluation function, format: `language:keyName=funcName`
               Defaults to ``None``.
        :type custom_metric_func: str, optional
        :param num_knots: Number of knots for gam predictors
               Defaults to ``None``.
        :type num_knots: List[int], optional
        :param knot_ids: String arrays storing frame keys of knots.  One for each gam column set specified in
               gam_columns
               Defaults to ``None``.
        :type knot_ids: List[str], optional
        :param gam_columns: Arrays of predictor column names for gam for smoothers using single or multiple predictors
               like {{'c1'},{'c2','c3'},{'c4'},...}
               Defaults to ``None``.
        :type gam_columns: List[List[str]], optional
        :param standardize_tp_gam_cols: standardize tp (thin plate) predictor columns
               Defaults to ``False``.
        :type standardize_tp_gam_cols: bool
        :param scale_tp_penalty_mat: Scale penalty matrix for tp (thin plate) smoothers as in R
               Defaults to ``False``.
        :type scale_tp_penalty_mat: bool
        :param bs: Basis function type for each gam predictors, 0 for cr, 1 for thin plate regression with knots, 2 for
               thin plate regression with SVD.  If specified, must be the same size as gam_columns
               Defaults to ``None``.
        :type bs: List[int], optional
        :param scale: Smoothing parameter for gam predictors.  If specified, must be of the same length as gam_columns
               Defaults to ``None``.
        :type scale: List[float], optional
        :param keep_gam_cols: Save keys of model matrix
               Defaults to ``False``.
        :type keep_gam_cols: bool
        :param auc_type: Set default multinomial AUC type.
               Defaults to ``"auto"``.
        :type auc_type: Literal["auto", "none", "macro_ovr", "weighted_ovr", "macro_ovo", "weighted_ovo"]
        """
        super(H2OGeneralizedAdditiveEstimator, self).__init__()
        self._parms = {}
        self._id = self._parms['model_id'] = model_id
        self.training_frame = training_frame
        self.validation_frame = validation_frame
        self.nfolds = nfolds
        self.seed = seed
        self.keep_cross_validation_models = keep_cross_validation_models
        self.keep_cross_validation_predictions = keep_cross_validation_predictions
        self.keep_cross_validation_fold_assignment = keep_cross_validation_fold_assignment
        self.fold_assignment = fold_assignment
        self.fold_column = fold_column
        self.response_column = response_column
        self.ignored_columns = ignored_columns
        self.ignore_const_cols = ignore_const_cols
        self.score_each_iteration = score_each_iteration
        self.offset_column = offset_column
        self.weights_column = weights_column
        self.family = family
        self.tweedie_variance_power = tweedie_variance_power
        self.tweedie_link_power = tweedie_link_power
        self.theta = theta
        self.solver = solver
        self.alpha = alpha
        self.lambda_ = lambda_
        self.lambda_search = lambda_search
        self.early_stopping = early_stopping
        self.nlambdas = nlambdas
        self.standardize = standardize
        self.missing_values_handling = missing_values_handling
        self.plug_values = plug_values
        self.compute_p_values = compute_p_values
        self.remove_collinear_columns = remove_collinear_columns
        self.intercept = intercept
        self.non_negative = non_negative
        self.max_iterations = max_iterations
        self.objective_epsilon = objective_epsilon
        self.beta_epsilon = beta_epsilon
        self.gradient_epsilon = gradient_epsilon
        self.link = link
        self.startval = startval
        self.prior = prior
        self.cold_start = cold_start
        self.lambda_min_ratio = lambda_min_ratio
        self.beta_constraints = beta_constraints
        self.max_active_predictors = max_active_predictors
        self.interactions = interactions
        self.interaction_pairs = interaction_pairs
        self.obj_reg = obj_reg
        self.export_checkpoints_dir = export_checkpoints_dir
        self.stopping_rounds = stopping_rounds
        self.stopping_metric = stopping_metric
        self.stopping_tolerance = stopping_tolerance
        self.balance_classes = balance_classes
        self.class_sampling_factors = class_sampling_factors
        self.max_after_balance_size = max_after_balance_size
        self.max_confusion_matrix_size = max_confusion_matrix_size
        self.max_runtime_secs = max_runtime_secs
        self.custom_metric_func = custom_metric_func
        self.num_knots = num_knots
        self.knot_ids = knot_ids
        self.gam_columns = gam_columns
        self.standardize_tp_gam_cols = standardize_tp_gam_cols
        self.scale_tp_penalty_mat = scale_tp_penalty_mat
        self.bs = bs
        self.scale = scale
        self.keep_gam_cols = keep_gam_cols
        self.auc_type = auc_type

    @property
    def training_frame(self):
        """
        Id of the training data frame.

        Type: ``Union[None, str, H2OFrame]``.
        """
        return self._parms.get("training_frame")

    @training_frame.setter
    def training_frame(self, training_frame):
        self._parms["training_frame"] = H2OFrame._validate(training_frame, 'training_frame')

    @property
    def validation_frame(self):
        """
        Id of the validation data frame.

        Type: ``Union[None, str, H2OFrame]``.
        """
        return self._parms.get("validation_frame")

    @validation_frame.setter
    def validation_frame(self, validation_frame):
        self._parms["validation_frame"] = H2OFrame._validate(validation_frame, 'validation_frame')

    @property
    def nfolds(self):
        """
        Number of folds for K-fold cross-validation (0 to disable or >= 2).

        Type: ``int``, defaults to ``0``.
        """
        return self._parms.get("nfolds")

    @nfolds.setter
    def nfolds(self, nfolds):
        assert_is_type(nfolds, None, int)
        self._parms["nfolds"] = nfolds

    @property
    def seed(self):
        """
        Seed for pseudo random number generator (if applicable)

        Type: ``int``, defaults to ``-1``.
        """
        return self._parms.get("seed")

    @seed.setter
    def seed(self, seed):
        assert_is_type(seed, None, int)
        self._parms["seed"] = seed

    @property
    def keep_cross_validation_models(self):
        """
        Whether to keep the cross-validation models.

        Type: ``bool``, defaults to ``True``.
        """
        return self._parms.get("keep_cross_validation_models")

    @keep_cross_validation_models.setter
    def keep_cross_validation_models(self, keep_cross_validation_models):
        assert_is_type(keep_cross_validation_models, None, bool)
        self._parms["keep_cross_validation_models"] = keep_cross_validation_models

    @property
    def keep_cross_validation_predictions(self):
        """
        Whether to keep the predictions of the cross-validation models.

        Type: ``bool``, defaults to ``False``.
        """
        return self._parms.get("keep_cross_validation_predictions")

    @keep_cross_validation_predictions.setter
    def keep_cross_validation_predictions(self, keep_cross_validation_predictions):
        assert_is_type(keep_cross_validation_predictions, None, bool)
        self._parms["keep_cross_validation_predictions"] = keep_cross_validation_predictions

    @property
    def keep_cross_validation_fold_assignment(self):
        """
        Whether to keep the cross-validation fold assignment.

        Type: ``bool``, defaults to ``False``.
        """
        return self._parms.get("keep_cross_validation_fold_assignment")

    @keep_cross_validation_fold_assignment.setter
    def keep_cross_validation_fold_assignment(self, keep_cross_validation_fold_assignment):
        assert_is_type(keep_cross_validation_fold_assignment, None, bool)
        self._parms["keep_cross_validation_fold_assignment"] = keep_cross_validation_fold_assignment

    @property
    def fold_assignment(self):
        """
        Cross-validation fold assignment scheme, if fold_column is not specified. The 'Stratified' option will stratify
        the folds based on the response variable, for classification problems.

        Type: ``Literal["auto", "random", "modulo", "stratified"]``, defaults to ``"auto"``.
        """
        return self._parms.get("fold_assignment")

    @fold_assignment.setter
    def fold_assignment(self, fold_assignment):
        assert_is_type(fold_assignment, None, Enum("auto", "random", "modulo", "stratified"))
        self._parms["fold_assignment"] = fold_assignment

    @property
    def fold_column(self):
        """
        Column with cross-validation fold index assignment per observation.

        Type: ``str``.
        """
        return self._parms.get("fold_column")

    @fold_column.setter
    def fold_column(self, fold_column):
        assert_is_type(fold_column, None, str)
        self._parms["fold_column"] = fold_column

    @property
    def response_column(self):
        """
        Response variable column.

        Type: ``str``.
        """
        return self._parms.get("response_column")

    @response_column.setter
    def response_column(self, response_column):
        assert_is_type(response_column, None, str)
        self._parms["response_column"] = response_column

    @property
    def ignored_columns(self):
        """
        Names of columns to ignore for training.

        Type: ``List[str]``.
        """
        return self._parms.get("ignored_columns")

    @ignored_columns.setter
    def ignored_columns(self, ignored_columns):
        assert_is_type(ignored_columns, None, [str])
        self._parms["ignored_columns"] = ignored_columns

    @property
    def ignore_const_cols(self):
        """
        Ignore constant columns.

        Type: ``bool``, defaults to ``True``.
        """
        return self._parms.get("ignore_const_cols")

    @ignore_const_cols.setter
    def ignore_const_cols(self, ignore_const_cols):
        assert_is_type(ignore_const_cols, None, bool)
        self._parms["ignore_const_cols"] = ignore_const_cols

    @property
    def score_each_iteration(self):
        """
        Whether to score during each iteration of model training.

        Type: ``bool``, defaults to ``False``.
        """
        return self._parms.get("score_each_iteration")

    @score_each_iteration.setter
    def score_each_iteration(self, score_each_iteration):
        assert_is_type(score_each_iteration, None, bool)
        self._parms["score_each_iteration"] = score_each_iteration

    @property
    def offset_column(self):
        """
        Offset column. This will be added to the combination of columns before applying the link function.

        Type: ``str``.
        """
        return self._parms.get("offset_column")

    @offset_column.setter
    def offset_column(self, offset_column):
        assert_is_type(offset_column, None, str)
        self._parms["offset_column"] = offset_column

    @property
    def weights_column(self):
        """
        Column with observation weights. Giving some observation a weight of zero is equivalent to excluding it from the
        dataset; giving an observation a relative weight of 2 is equivalent to repeating that row twice. Negative
        weights are not allowed. Note: Weights are per-row observation weights and do not increase the size of the data
        frame. This is typically the number of times a row is repeated, but non-integer values are supported as well.
        During training, rows with higher weights matter more, due to the larger loss function pre-factor. If you set
        weight = 0 for a row, the returned prediction frame at that row is zero and this is incorrect. To get an
        accurate prediction, remove all rows with weight == 0.

        Type: ``str``.
        """
        return self._parms.get("weights_column")

    @weights_column.setter
    def weights_column(self, weights_column):
        assert_is_type(weights_column, None, str)
        self._parms["weights_column"] = weights_column

    @property
    def family(self):
        """
        Family. Use binomial for classification with logistic regression, others are for regression problems.

        Type: ``Literal["auto", "gaussian", "binomial", "quasibinomial", "ordinal", "multinomial", "poisson", "gamma",
        "tweedie", "negativebinomial", "fractionalbinomial"]``, defaults to ``"auto"``.
        """
        return self._parms.get("family")

    @family.setter
    def family(self, family):
        assert_is_type(family, None, Enum("auto", "gaussian", "binomial", "quasibinomial", "ordinal", "multinomial", "poisson", "gamma", "tweedie", "negativebinomial", "fractionalbinomial"))
        self._parms["family"] = family

    @property
    def tweedie_variance_power(self):
        """
        Tweedie variance power

        Type: ``float``, defaults to ``0.0``.
        """
        return self._parms.get("tweedie_variance_power")

    @tweedie_variance_power.setter
    def tweedie_variance_power(self, tweedie_variance_power):
        assert_is_type(tweedie_variance_power, None, numeric)
        self._parms["tweedie_variance_power"] = tweedie_variance_power

    @property
    def tweedie_link_power(self):
        """
        Tweedie link power

        Type: ``float``, defaults to ``0.0``.
        """
        return self._parms.get("tweedie_link_power")

    @tweedie_link_power.setter
    def tweedie_link_power(self, tweedie_link_power):
        assert_is_type(tweedie_link_power, None, numeric)
        self._parms["tweedie_link_power"] = tweedie_link_power

    @property
    def theta(self):
        """
        Theta

        Type: ``float``, defaults to ``0.0``.
        """
        return self._parms.get("theta")

    @theta.setter
    def theta(self, theta):
        assert_is_type(theta, None, numeric)
        self._parms["theta"] = theta

    @property
    def solver(self):
        """
        AUTO will set the solver based on given data and the other parameters. IRLSM is fast on on problems with small
        number of predictors and for lambda-search with L1 penalty, L_BFGS scales better for datasets with many columns.

        Type: ``Literal["auto", "irlsm", "l_bfgs", "coordinate_descent_naive", "coordinate_descent",
        "gradient_descent_lh", "gradient_descent_sqerr"]``, defaults to ``"auto"``.
        """
        return self._parms.get("solver")

    @solver.setter
    def solver(self, solver):
        assert_is_type(solver, None, Enum("auto", "irlsm", "l_bfgs", "coordinate_descent_naive", "coordinate_descent", "gradient_descent_lh", "gradient_descent_sqerr"))
        self._parms["solver"] = solver

    @property
    def alpha(self):
        """
        Distribution of regularization between the L1 (Lasso) and L2 (Ridge) penalties. A value of 1 for alpha
        represents Lasso regression, a value of 0 produces Ridge regression, and anything in between specifies the
        amount of mixing between the two. Default value of alpha is 0 when SOLVER = 'L-BFGS'; 0.5 otherwise.

        Type: ``List[float]``.
        """
        return self._parms.get("alpha")

    @alpha.setter
    def alpha(self, alpha):
        # For `alpha` and `lambda` the server reports type float[], while in practice simple floats are also ok
        assert_is_type(alpha, None, numeric, [numeric])
        self._parms["alpha"] = alpha

    @property
    def lambda_(self):
        """
        Regularization strength

        Type: ``List[float]``.
        """
        return self._parms.get("lambda")

    @lambda_.setter
    def lambda_(self, lambda_):
        assert_is_type(lambda_, None, numeric, [numeric])
        self._parms["lambda"] = lambda_

    @property
    def lambda_search(self):
        """
        Use lambda search starting at lambda max, given lambda is then interpreted as lambda min

        Type: ``bool``, defaults to ``False``.
        """
        return self._parms.get("lambda_search")

    @lambda_search.setter
    def lambda_search(self, lambda_search):
        assert_is_type(lambda_search, None, bool)
        self._parms["lambda_search"] = lambda_search

    @property
    def early_stopping(self):
        """
        Stop early when there is no more relative improvement on train or validation (if provided)

        Type: ``bool``, defaults to ``True``.
        """
        return self._parms.get("early_stopping")

    @early_stopping.setter
    def early_stopping(self, early_stopping):
        assert_is_type(early_stopping, None, bool)
        self._parms["early_stopping"] = early_stopping

    @property
    def nlambdas(self):
        """
        Number of lambdas to be used in a search. Default indicates: If alpha is zero, with lambda search set to True,
        the value of nlamdas is set to 30 (fewer lambdas are needed for ridge regression) otherwise it is set to 100.

        Type: ``int``, defaults to ``-1``.
        """
        return self._parms.get("nlambdas")

    @nlambdas.setter
    def nlambdas(self, nlambdas):
        assert_is_type(nlambdas, None, int)
        self._parms["nlambdas"] = nlambdas

    @property
    def standardize(self):
        """
        Standardize numeric columns to have zero mean and unit variance

        Type: ``bool``, defaults to ``False``.
        """
        return self._parms.get("standardize")

    @standardize.setter
    def standardize(self, standardize):
        assert_is_type(standardize, None, bool)
        self._parms["standardize"] = standardize

    @property
    def missing_values_handling(self):
        """
        Handling of missing values. Either MeanImputation, Skip or PlugValues.

        Type: ``Literal["mean_imputation", "skip", "plug_values"]``, defaults to ``"mean_imputation"``.
        """
        return self._parms.get("missing_values_handling")

    @missing_values_handling.setter
    def missing_values_handling(self, missing_values_handling):
        assert_is_type(missing_values_handling, None, Enum("mean_imputation", "skip", "plug_values"))
        self._parms["missing_values_handling"] = missing_values_handling

    @property
    def plug_values(self):
        """
        Plug Values (a single row frame containing values that will be used to impute missing values of the
        training/validation frame, use with conjunction missing_values_handling = PlugValues)

        Type: ``Union[None, str, H2OFrame]``.
        """
        return self._parms.get("plug_values")

    @plug_values.setter
    def plug_values(self, plug_values):
        self._parms["plug_values"] = H2OFrame._validate(plug_values, 'plug_values')

    @property
    def compute_p_values(self):
        """
        Request p-values computation, p-values work only with IRLSM solver and no regularization

        Type: ``bool``, defaults to ``False``.
        """
        return self._parms.get("compute_p_values")

    @compute_p_values.setter
    def compute_p_values(self, compute_p_values):
        assert_is_type(compute_p_values, None, bool)
        self._parms["compute_p_values"] = compute_p_values

    @property
    def remove_collinear_columns(self):
        """
        In case of linearly dependent columns, remove some of the dependent columns

        Type: ``bool``, defaults to ``False``.
        """
        return self._parms.get("remove_collinear_columns")

    @remove_collinear_columns.setter
    def remove_collinear_columns(self, remove_collinear_columns):
        assert_is_type(remove_collinear_columns, None, bool)
        self._parms["remove_collinear_columns"] = remove_collinear_columns

    @property
    def intercept(self):
        """
        Include constant term in the model

        Type: ``bool``, defaults to ``True``.
        """
        return self._parms.get("intercept")

    @intercept.setter
    def intercept(self, intercept):
        assert_is_type(intercept, None, bool)
        self._parms["intercept"] = intercept

    @property
    def non_negative(self):
        """
        Restrict coefficients (not intercept) to be non-negative

        Type: ``bool``, defaults to ``False``.
        """
        return self._parms.get("non_negative")

    @non_negative.setter
    def non_negative(self, non_negative):
        assert_is_type(non_negative, None, bool)
        self._parms["non_negative"] = non_negative

    @property
    def max_iterations(self):
        """
        Maximum number of iterations

        Type: ``int``, defaults to ``-1``.
        """
        return self._parms.get("max_iterations")

    @max_iterations.setter
    def max_iterations(self, max_iterations):
        assert_is_type(max_iterations, None, int)
        self._parms["max_iterations"] = max_iterations

    @property
    def objective_epsilon(self):
        """
        Converge if  objective value changes less than this. Default indicates: If lambda_search is set to True the
        value of objective_epsilon is set to .0001. If the lambda_search is set to False and lambda is equal to zero,
        the value of objective_epsilon is set to .000001, for any other value of lambda the default value of
        objective_epsilon is set to .0001.

        Type: ``float``, defaults to ``-1.0``.
        """
        return self._parms.get("objective_epsilon")

    @objective_epsilon.setter
    def objective_epsilon(self, objective_epsilon):
        assert_is_type(objective_epsilon, None, numeric)
        self._parms["objective_epsilon"] = objective_epsilon

    @property
    def beta_epsilon(self):
        """
        Converge if  beta changes less (using L-infinity norm) than beta esilon, ONLY applies to IRLSM solver

        Type: ``float``, defaults to ``0.0001``.
        """
        return self._parms.get("beta_epsilon")

    @beta_epsilon.setter
    def beta_epsilon(self, beta_epsilon):
        assert_is_type(beta_epsilon, None, numeric)
        self._parms["beta_epsilon"] = beta_epsilon

    @property
    def gradient_epsilon(self):
        """
        Converge if  objective changes less (using L-infinity norm) than this, ONLY applies to L-BFGS solver. Default
        indicates: If lambda_search is set to False and lambda is equal to zero, the default value of gradient_epsilon
        is equal to .000001, otherwise the default value is .0001. If lambda_search is set to True, the conditional
        values above are 1E-8 and 1E-6 respectively.

        Type: ``float``, defaults to ``-1.0``.
        """
        return self._parms.get("gradient_epsilon")

    @gradient_epsilon.setter
    def gradient_epsilon(self, gradient_epsilon):
        assert_is_type(gradient_epsilon, None, numeric)
        self._parms["gradient_epsilon"] = gradient_epsilon

    @property
    def link(self):
        """
        Link function.

        Type: ``Literal["family_default", "identity", "logit", "log", "inverse", "tweedie", "ologit"]``, defaults to
        ``"family_default"``.
        """
        return self._parms.get("link")

    @link.setter
    def link(self, link):
        assert_is_type(link, None, Enum("family_default", "identity", "logit", "log", "inverse", "tweedie", "ologit"))
        self._parms["link"] = link

    @property
    def startval(self):
        """
        double array to initialize coefficients for GAM.

        Type: ``List[float]``.
        """
        return self._parms.get("startval")

    @startval.setter
    def startval(self, startval):
        assert_is_type(startval, None, [numeric])
        self._parms["startval"] = startval

    @property
    def prior(self):
        """
        Prior probability for y==1. To be used only for logistic regression iff the data has been sampled and the mean
        of response does not reflect reality.

        Type: ``float``, defaults to ``-1.0``.
        """
        return self._parms.get("prior")

    @prior.setter
    def prior(self, prior):
        assert_is_type(prior, None, numeric)
        self._parms["prior"] = prior

    @property
    def cold_start(self):
        """
        Only applicable to multiple alpha/lambda values when calling GLM from GAM.  If false, build the next model for
        next set of alpha/lambda values starting from the values provided by current model.  If true will start GLM
        model from scratch.

        Type: ``bool``, defaults to ``False``.
        """
        return self._parms.get("cold_start")

    @cold_start.setter
    def cold_start(self, cold_start):
        assert_is_type(cold_start, None, bool)
        self._parms["cold_start"] = cold_start

    @property
    def lambda_min_ratio(self):
        """
        Minimum lambda used in lambda search, specified as a ratio of lambda_max (the smallest lambda that drives all
        coefficients to zero). Default indicates: if the number of observations is greater than the number of variables,
        then lambda_min_ratio is set to 0.0001; if the number of observations is less than the number of variables, then
        lambda_min_ratio is set to 0.01.

        Type: ``float``, defaults to ``-1.0``.
        """
        return self._parms.get("lambda_min_ratio")

    @lambda_min_ratio.setter
    def lambda_min_ratio(self, lambda_min_ratio):
        assert_is_type(lambda_min_ratio, None, numeric)
        self._parms["lambda_min_ratio"] = lambda_min_ratio

    @property
    def beta_constraints(self):
        """
        Beta constraints

        Type: ``Union[None, str, H2OFrame]``.
        """
        return self._parms.get("beta_constraints")

    @beta_constraints.setter
    def beta_constraints(self, beta_constraints):
        self._parms["beta_constraints"] = H2OFrame._validate(beta_constraints, 'beta_constraints')

    @property
    def max_active_predictors(self):
        """
        Maximum number of active predictors during computation. Use as a stopping criterion to prevent expensive model
        building with many predictors. Default indicates: If the IRLSM solver is used, the value of
        max_active_predictors is set to 5000 otherwise it is set to 100000000.

        Type: ``int``, defaults to ``-1``.
        """
        return self._parms.get("max_active_predictors")

    @max_active_predictors.setter
    def max_active_predictors(self, max_active_predictors):
        assert_is_type(max_active_predictors, None, int)
        self._parms["max_active_predictors"] = max_active_predictors

    @property
    def interactions(self):
        """
        A list of predictor column indices to interact. All pairwise combinations will be computed for the list.

        Type: ``List[str]``.
        """
        return self._parms.get("interactions")

    @interactions.setter
    def interactions(self, interactions):
        assert_is_type(interactions, None, [str])
        self._parms["interactions"] = interactions

    @property
    def interaction_pairs(self):
        """
        A list of pairwise (first order) column interactions.

        Type: ``List[tuple]``.
        """
        return self._parms.get("interaction_pairs")

    @interaction_pairs.setter
    def interaction_pairs(self, interaction_pairs):
        assert_is_type(interaction_pairs, None, [tuple])
        self._parms["interaction_pairs"] = interaction_pairs

    @property
    def obj_reg(self):
        """
        Likelihood divider in objective value computation, default is 1/nobs

        Type: ``float``, defaults to ``-1.0``.
        """
        return self._parms.get("obj_reg")

    @obj_reg.setter
    def obj_reg(self, obj_reg):
        assert_is_type(obj_reg, None, numeric)
        self._parms["obj_reg"] = obj_reg

    @property
    def export_checkpoints_dir(self):
        """
        Automatically export generated models to this directory.

        Type: ``str``.
        """
        return self._parms.get("export_checkpoints_dir")

    @export_checkpoints_dir.setter
    def export_checkpoints_dir(self, export_checkpoints_dir):
        assert_is_type(export_checkpoints_dir, None, str)
        self._parms["export_checkpoints_dir"] = export_checkpoints_dir

    @property
    def stopping_rounds(self):
        """
        Early stopping based on convergence of stopping_metric. Stop if simple moving average of length k of the
        stopping_metric does not improve for k:=stopping_rounds scoring events (0 to disable)

        Type: ``int``, defaults to ``0``.
        """
        return self._parms.get("stopping_rounds")

    @stopping_rounds.setter
    def stopping_rounds(self, stopping_rounds):
        assert_is_type(stopping_rounds, None, int)
        self._parms["stopping_rounds"] = stopping_rounds

    @property
    def stopping_metric(self):
        """
        Metric to use for early stopping (AUTO: logloss for classification, deviance for regression and anonomaly_score
        for Isolation Forest). Note that custom and custom_increasing can only be used in GBM and DRF with the Python
        client.

        Type: ``Literal["auto", "deviance", "logloss", "mse", "rmse", "mae", "rmsle", "auc", "aucpr", "lift_top_group",
        "misclassification", "mean_per_class_error", "custom", "custom_increasing"]``, defaults to ``"auto"``.
        """
        return self._parms.get("stopping_metric")

    @stopping_metric.setter
    def stopping_metric(self, stopping_metric):
        assert_is_type(stopping_metric, None, Enum("auto", "deviance", "logloss", "mse", "rmse", "mae", "rmsle", "auc", "aucpr", "lift_top_group", "misclassification", "mean_per_class_error", "custom", "custom_increasing"))
        self._parms["stopping_metric"] = stopping_metric

    @property
    def stopping_tolerance(self):
        """
        Relative tolerance for metric-based stopping criterion (stop if relative improvement is not at least this much)

        Type: ``float``, defaults to ``0.001``.
        """
        return self._parms.get("stopping_tolerance")

    @stopping_tolerance.setter
    def stopping_tolerance(self, stopping_tolerance):
        assert_is_type(stopping_tolerance, None, numeric)
        self._parms["stopping_tolerance"] = stopping_tolerance

    @property
    def balance_classes(self):
        """
        Balance training data class counts via over/under-sampling (for imbalanced data).

        Type: ``bool``, defaults to ``False``.
        """
        return self._parms.get("balance_classes")

    @balance_classes.setter
    def balance_classes(self, balance_classes):
        assert_is_type(balance_classes, None, bool)
        self._parms["balance_classes"] = balance_classes

    @property
    def class_sampling_factors(self):
        """
        Desired over/under-sampling ratios per class (in lexicographic order). If not specified, sampling factors will
        be automatically computed to obtain class balance during training. Requires balance_classes.

        Type: ``List[float]``.
        """
        return self._parms.get("class_sampling_factors")

    @class_sampling_factors.setter
    def class_sampling_factors(self, class_sampling_factors):
        assert_is_type(class_sampling_factors, None, [float])
        self._parms["class_sampling_factors"] = class_sampling_factors

    @property
    def max_after_balance_size(self):
        """
        Maximum relative size of the training data after balancing class counts (can be less than 1.0). Requires
        balance_classes.

        Type: ``float``, defaults to ``5.0``.
        """
        return self._parms.get("max_after_balance_size")

    @max_after_balance_size.setter
    def max_after_balance_size(self, max_after_balance_size):
        assert_is_type(max_after_balance_size, None, float)
        self._parms["max_after_balance_size"] = max_after_balance_size

    @property
    def max_confusion_matrix_size(self):
        """
        [Deprecated] Maximum size (# classes) for confusion matrices to be printed in the Logs

        Type: ``int``, defaults to ``20``.
        """
        return self._parms.get("max_confusion_matrix_size")

    @max_confusion_matrix_size.setter
    def max_confusion_matrix_size(self, max_confusion_matrix_size):
        assert_is_type(max_confusion_matrix_size, None, int)
        self._parms["max_confusion_matrix_size"] = max_confusion_matrix_size

    @property
    def max_runtime_secs(self):
        """
        Maximum allowed runtime in seconds for model training. Use 0 to disable.

        Type: ``float``, defaults to ``0.0``.
        """
        return self._parms.get("max_runtime_secs")

    @max_runtime_secs.setter
    def max_runtime_secs(self, max_runtime_secs):
        assert_is_type(max_runtime_secs, None, numeric)
        self._parms["max_runtime_secs"] = max_runtime_secs

    @property
    def custom_metric_func(self):
        """
        Reference to custom evaluation function, format: `language:keyName=funcName`

        Type: ``str``.
        """
        return self._parms.get("custom_metric_func")

    @custom_metric_func.setter
    def custom_metric_func(self, custom_metric_func):
        assert_is_type(custom_metric_func, None, str)
        self._parms["custom_metric_func"] = custom_metric_func

    @property
    def num_knots(self):
        """
        Number of knots for gam predictors

        Type: ``List[int]``.
        """
        return self._parms.get("num_knots")

    @num_knots.setter
    def num_knots(self, num_knots):
        assert_is_type(num_knots, None, [int])
        self._parms["num_knots"] = num_knots

    @property
    def knot_ids(self):
        """
        String arrays storing frame keys of knots.  One for each gam column set specified in gam_columns

        Type: ``List[str]``.
        """
        return self._parms.get("knot_ids")

    @knot_ids.setter
    def knot_ids(self, knot_ids):
        assert_is_type(knot_ids, None, [str])
        self._parms["knot_ids"] = knot_ids

    @property
    def gam_columns(self):
        """
        Arrays of predictor column names for gam for smoothers using single or multiple predictors like
        {{'c1'},{'c2','c3'},{'c4'},...}

        Type: ``List[List[str]]``.
        """
        return self._parms.get("gam_columns")

    @gam_columns.setter
    def gam_columns(self, gam_columns):
        assert_is_type(gam_columns, None, [U(str, [str])])
        if gam_columns:  # standardize as a nested list
            gam_columns = [[g] if isinstance(g, str) else g for g in gam_columns]
        self._parms["gam_columns"] = gam_columns

    @property
    def standardize_tp_gam_cols(self):
        """
        standardize tp (thin plate) predictor columns

        Type: ``bool``, defaults to ``False``.
        """
        return self._parms.get("standardize_tp_gam_cols")

    @standardize_tp_gam_cols.setter
    def standardize_tp_gam_cols(self, standardize_tp_gam_cols):
        assert_is_type(standardize_tp_gam_cols, None, bool)
        self._parms["standardize_tp_gam_cols"] = standardize_tp_gam_cols

    @property
    def scale_tp_penalty_mat(self):
        """
        Scale penalty matrix for tp (thin plate) smoothers as in R

        Type: ``bool``, defaults to ``False``.
        """
        return self._parms.get("scale_tp_penalty_mat")

    @scale_tp_penalty_mat.setter
    def scale_tp_penalty_mat(self, scale_tp_penalty_mat):
        assert_is_type(scale_tp_penalty_mat, None, bool)
        self._parms["scale_tp_penalty_mat"] = scale_tp_penalty_mat

    @property
    def bs(self):
        """
        Basis function type for each gam predictors, 0 for cr, 1 for thin plate regression with knots, 2 for thin plate
        regression with SVD.  If specified, must be the same size as gam_columns

        Type: ``List[int]``.
        """
        return self._parms.get("bs")

    @bs.setter
    def bs(self, bs):
        assert_is_type(bs, None, [int])
        self._parms["bs"] = bs

    @property
    def scale(self):
        """
        Smoothing parameter for gam predictors.  If specified, must be of the same length as gam_columns

        Type: ``List[float]``.
        """
        return self._parms.get("scale")

    @scale.setter
    def scale(self, scale):
        assert_is_type(scale, None, [numeric])
        self._parms["scale"] = scale

    @property
    def keep_gam_cols(self):
        """
        Save keys of model matrix

        Type: ``bool``, defaults to ``False``.
        """
        return self._parms.get("keep_gam_cols")

    @keep_gam_cols.setter
    def keep_gam_cols(self, keep_gam_cols):
        assert_is_type(keep_gam_cols, None, bool)
        self._parms["keep_gam_cols"] = keep_gam_cols

    @property
    def auc_type(self):
        """
        Set default multinomial AUC type.

        Type: ``Literal["auto", "none", "macro_ovr", "weighted_ovr", "macro_ovo", "weighted_ovo"]``, defaults to
        ``"auto"``.
        """
        return self._parms.get("auc_type")

    @auc_type.setter
    def auc_type(self, auc_type):
        assert_is_type(auc_type, None, Enum("auto", "none", "macro_ovr", "weighted_ovr", "macro_ovo", "weighted_ovo"))
        self._parms["auc_type"] = auc_type

    Lambda = deprecated_property('Lambda', lambda_)

    def _additional_used_columns(self, parms):
        """
        :return: Gam columns if specified.
        """
        return parms["gam_columns"]

    def summary(self):
        """Print a detailed summary of the model."""
        model = self._model_json["output"]
        if "glm_model_summary" in model and model["glm_model_summary"] is not None:
            return model["glm_model_summary"]
        print("No model summary for this model")

    def scoring_history(self):
        """
        Retrieve Model Score History.

        :returns: The score history as an H2OTwoDimTable or a Pandas DataFrame.
        """
        model = self._model_json["output"]
        if "glm_scoring_history" in model and model["glm_scoring_history"] is not None:
            return model["glm_scoring_history"].as_data_frame()
        print("No score history for this model")
