# Generated by Django 3.2.5 on 2021-07-28 15:14

from django.db import migrations, models
import django.db.models.deletion
import django.utils.timezone
import model_utils.fields
import uuid


class Migration(migrations.Migration):

    initial = True

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='App',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('modified', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, editable=False, verbose_name='modified')),
                ('ios_url', models.URLField(blank=True, help_text='If blank, users will be redirected to the Default URL.', verbose_name='iOS URL')),
                ('ios_app', models.BooleanField(default=False, verbose_name='I have an iOS App')),
                ('ios_uri_scheme', models.CharField(blank=True, help_text='myapp://', max_length=255, verbose_name='iOS URI Scheme')),
                ('ios_bundle_id', models.CharField(blank=True, help_text='e.g. - id1234567890', max_length=36, verbose_name='iOS Bundle ID')),
                ('ios_custom_url', models.URLField(blank=True, help_text='A URL to fallback to when the app is not installed.', verbose_name='Custom URL')),
                ('android_url', models.URLField(blank=True, help_text='If blank, users will be redirected to the Default URL.', verbose_name='Android URL')),
                ('android_app', models.BooleanField(default=False, verbose_name='I have an Android App')),
                ('android_uri_scheme', models.CharField(blank=True, help_text='e.g. - myapp://', max_length=255, verbose_name='Android URI Scheme')),
                ('android_package_name', models.CharField(blank=True, help_text='e.g. - com.company.appname. If blank, users will be redirected to the Default URL', max_length=255, verbose_name='Android Package Name')),
                ('android_custom_url', models.URLField(blank=True, help_text='A URL to fallback to when the app is not installed.', verbose_name='Custom URL')),
                ('mac_uri_scheme', models.CharField(blank=True, help_text='e.g. - myapp://', max_length=255, verbose_name='Mac URI Scheme')),
                ('mac_app_store_url', models.CharField(blank=True, help_text='A URL to fallback to when the app is not installed.', max_length=255, verbose_name='Mac App Store URL')),
                ('windows_uri_scheme', models.CharField(blank=True, help_text='e.g. - myapp://', max_length=255, verbose_name='Windows URI Scheme')),
                ('windows_app_store_url', models.CharField(blank=True, help_text='A URL to fallback to when the app is not installed.', max_length=255, verbose_name='Windows App Store URL')),
                ('windows_package_name', models.CharField(blank=True, max_length=36, verbose_name='Windows Package Family name')),
                ('code', models.UUIDField(default=uuid.uuid4, editable=False)),
                ('name', models.CharField(help_text='The application display name.', max_length=255)),
                ('default_url', models.URLField(help_text='Your fallback URL for mobile devices that do not have a specified redirect.', verbose_name='Default URL')),
            ],
            options={
                'ordering': ['name'],
            },
        ),
        migrations.CreateModel(
            name='Visit',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('modified', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, editable=False, verbose_name='modified')),
                ('ip_address', models.CharField(blank=True, default='', max_length=255, null=True)),
                ('ip_data', models.JSONField(blank=True, default=dict, help_text='Must be valid JSON', null=True, verbose_name='IP geodata')),
                ('ua_data', models.JSONField(blank=True, default=dict, help_text='Must be valid JSON', null=True, verbose_name='User agent data')),
                ('deep_link', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='scans', to='django_deep_link.app')),
            ],
            options={
                'abstract': False,
            },
        ),
    ]
