# AUTOGENERATED! DO NOT EDIT! File to edit: Schema.ipynb (unless otherwise specified).

__all__ = ['Response', 'Event', 'Product', 'Products']

# Cell
from dataclasses import field
from dataclasses import dataclass
from dataclasses_json import dataclass_json
from typing import Optional, List
import json

@dataclass_json
@dataclass
class Response:
  body: str
  statusCode: int = 200
  header: dict = field(default_factory = dict)
  @classmethod
  def fromDict(cls, dictInput:dict):
    body = dictInput.pop('body')
    return cls(
      body = json.loads(body),
      **dictInput
    )
  @classmethod
  def getReturn(cls, body:dict, header:dict = {}, statusCode = 200)->dict:
    returnObj = cls(
      body = json.dumps(body),
      header = header,
      statusCode = statusCode
                   ).to_dict()
    return returnObj
@dataclass_json
@dataclass
class Event:
  body: str
  header: dict = field(default_factory = dict)
  def getBody(self):
    return json.loads(self.body)
  def getProducts(self):
    return Products.from_json(self.body)
  key = lambda self: json.loads(self.body)['key']
  firstKey = lambda self: next(iter(json.loads(self.body).items()))
@dataclass_json
@dataclass
class Product:
  cprcode: str
  iprcode: str
  oprcode: str
  ordertype: str
  pr_abb: str
@dataclass_json
@dataclass
class Products:
  products: List[Product]