"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const core_1 = require("@aws-cdk/core");
const region_info_1 = require("@aws-cdk/region-info");
const ec2_generated_1 = require("./ec2.generated");
/**
 * A VPC endpoint service
 * @resource AWS::EC2::VPCEndpointService
 * @experimental
 */
class VpcEndpointService extends core_1.Resource {
    constructor(scope, id, props) {
        var _a;
        super(scope, id);
        if (props.vpcEndpointServiceLoadBalancers === undefined || props.vpcEndpointServiceLoadBalancers.length === 0) {
            throw new Error('VPC Endpoint Service must have at least one load balancer specified.');
        }
        this.vpcEndpointServiceLoadBalancers = props.vpcEndpointServiceLoadBalancers;
        this.acceptanceRequired = props.acceptanceRequired !== undefined ? props.acceptanceRequired : true;
        this.whitelistedPrincipals = props.whitelistedPrincipals !== undefined ? props.whitelistedPrincipals : [];
        this.endpointService = new ec2_generated_1.CfnVPCEndpointService(this, id, {
            networkLoadBalancerArns: this.vpcEndpointServiceLoadBalancers.map(lb => lb.loadBalancerArn),
            acceptanceRequired: this.acceptanceRequired,
        });
        this.vpcEndpointServiceId = this.endpointService.ref;
        const { region } = core_1.Stack.of(this);
        const serviceNamePrefix = !core_1.Token.isUnresolved(region) ? (_a = region_info_1.RegionInfo.get(region).vpcEndpointServiceNamePrefix) !== null && _a !== void 0 ? _a : region_info_1.Default.VPC_ENDPOINT_SERVICE_NAME_PREFIX :
            region_info_1.Default.VPC_ENDPOINT_SERVICE_NAME_PREFIX;
        this.vpcEndpointServiceName = core_1.Fn.join('.', [serviceNamePrefix, core_1.Aws.REGION, this.vpcEndpointServiceId]);
        if (this.whitelistedPrincipals.length > 0) {
            new ec2_generated_1.CfnVPCEndpointServicePermissions(this, 'Permissions', {
                serviceId: this.endpointService.ref,
                allowedPrincipals: this.whitelistedPrincipals.map(x => x.arn),
            });
        }
    }
}
exports.VpcEndpointService = VpcEndpointService;
//# sourceMappingURL=data:application/json;base64,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