import abc
from typing import TypeVar, Generic

T = TypeVar("T")


class Task(abc.ABC, Generic[T]):
    """
    A task in the workflow which executes a specific action.

    The task can generate data and return it from the `execute` function.
    This data will be made available to the other tasks of the workflow.

    The task can also depend on data by other tasks by specifying dependencies in the constructor.
    The type annotation of the constructor parameters determine which dependency will be injected.
    If the data is generated by a task in the same step, the task will be executed before this one.
    """

    @abc.abstractmethod
    def execute(self) -> T:
        pass
