# Generated by Django 3.2.13 on 2022-04-15 17:27

from django.db import migrations, models
import django.db.models.deletion
import lunes_cms.cms.models.static
import lunes_cms.cms.validators
import mptt.fields


class Migration(migrations.Migration):

    initial = True

    dependencies = []

    operations = [
        migrations.CreateModel(
            name="Discipline",
            fields=[
                ("id", models.AutoField(primary_key=True, serialize=False)),
                (
                    "released",
                    models.BooleanField(default=False, verbose_name="released"),
                ),
                ("title", models.CharField(max_length=255, verbose_name="discipline")),
                (
                    "description",
                    models.CharField(
                        blank=True, max_length=255, verbose_name="description"
                    ),
                ),
                (
                    "icon",
                    models.ImageField(
                        blank=True,
                        upload_to=lunes_cms.cms.models.static.convert_umlaute_images,
                        verbose_name="icon",
                    ),
                ),
                (
                    "creator_is_admin",
                    models.BooleanField(default=True, verbose_name="admin"),
                ),
                ("lft", models.PositiveIntegerField(editable=False)),
                ("rght", models.PositiveIntegerField(editable=False)),
                ("tree_id", models.PositiveIntegerField(db_index=True, editable=False)),
                ("level", models.PositiveIntegerField(editable=False)),
                (
                    "created_by",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="discipline",
                        to="auth.group",
                        verbose_name="created by",
                    ),
                ),
                (
                    "parent",
                    mptt.fields.TreeForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="children",
                        to="cms.discipline",
                        verbose_name="parent",
                    ),
                ),
            ],
            options={
                "verbose_name": "discipline",
                "verbose_name_plural": "disciplines",
            },
        ),
        migrations.CreateModel(
            name="Document",
            fields=[
                ("id", models.AutoField(primary_key=True, serialize=False)),
                (
                    "word_type",
                    models.CharField(
                        choices=[
                            ("Nomen", "Substantiv"),
                            ("Verb", "Verb"),
                            ("Adjektiv", "Adjektiv"),
                        ],
                        default="",
                        max_length=255,
                        verbose_name="word type",
                    ),
                ),
                ("word", models.CharField(max_length=255, verbose_name="word")),
                (
                    "article",
                    models.IntegerField(
                        choices=[
                            (0, "keiner"),
                            (1, "der"),
                            (2, "die"),
                            (3, "das"),
                            (4, "die (Plural)"),
                        ],
                        default="",
                        verbose_name="article",
                    ),
                ),
                (
                    "audio",
                    models.FileField(
                        blank=True,
                        null=True,
                        upload_to=lunes_cms.cms.models.static.convert_umlaute_audio,
                        validators=[
                            lunes_cms.cms.validators.validate_file_extension,
                            lunes_cms.cms.validators.validate_file_size,
                            lunes_cms.cms.validators.validate_multiple_extensions,
                        ],
                        verbose_name="audio",
                    ),
                ),
                (
                    "creation_date",
                    models.DateTimeField(
                        auto_now_add=True, verbose_name="creation date"
                    ),
                ),
                (
                    "created_by",
                    models.CharField(
                        blank=True, max_length=255, null=True, verbose_name="created by"
                    ),
                ),
                (
                    "creator_is_admin",
                    models.BooleanField(default=True, verbose_name="admin"),
                ),
            ],
            options={
                "verbose_name": "vocabulary",
                "verbose_name_plural": "vocabulary",
            },
        ),
        migrations.CreateModel(
            name="TrainingSet",
            fields=[
                ("id", models.AutoField(primary_key=True, serialize=False)),
                (
                    "released",
                    models.BooleanField(default=False, verbose_name="released"),
                ),
                (
                    "title",
                    models.CharField(max_length=255, verbose_name="training set"),
                ),
                (
                    "description",
                    models.CharField(
                        blank=True, max_length=255, verbose_name="description"
                    ),
                ),
                (
                    "icon",
                    models.ImageField(
                        blank=True,
                        upload_to=lunes_cms.cms.models.static.convert_umlaute_images,
                        verbose_name="icon",
                    ),
                ),
                (
                    "creator_is_admin",
                    models.BooleanField(default=True, verbose_name="admin"),
                ),
                ("lft", models.PositiveIntegerField(editable=False)),
                ("rght", models.PositiveIntegerField(editable=False)),
                ("tree_id", models.PositiveIntegerField(db_index=True, editable=False)),
                ("level", models.PositiveIntegerField(editable=False)),
                (
                    "created_by",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        to="auth.group",
                        verbose_name="created by",
                    ),
                ),
                (
                    "discipline",
                    models.ManyToManyField(
                        related_name="training_sets",
                        to="cms.Discipline",
                        verbose_name="discipline",
                    ),
                ),
                (
                    "documents",
                    models.ManyToManyField(
                        related_name="training_sets",
                        to="cms.Document",
                        verbose_name="document",
                    ),
                ),
                (
                    "parent",
                    mptt.fields.TreeForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="children",
                        to="cms.trainingset",
                        verbose_name="parent",
                    ),
                ),
            ],
            options={
                "verbose_name": "training set",
                "verbose_name_plural": "training sets",
            },
        ),
        migrations.CreateModel(
            name="GroupAPIKey",
            fields=[
                (
                    "id",
                    models.CharField(
                        editable=False,
                        max_length=150,
                        primary_key=True,
                        serialize=False,
                        unique=True,
                    ),
                ),
                ("prefix", models.CharField(editable=False, max_length=8, unique=True)),
                ("hashed_key", models.CharField(editable=False, max_length=150)),
                ("created", models.DateTimeField(auto_now_add=True, db_index=True)),
                (
                    "name",
                    models.CharField(
                        default=None,
                        help_text="A free-form name for the API key. Need not be unique. 50 characters max.",
                        max_length=50,
                    ),
                ),
                (
                    "revoked",
                    models.BooleanField(
                        blank=True,
                        default=False,
                        help_text="If the API key is revoked, clients cannot use it anymore. (This cannot be undone.)",
                    ),
                ),
                (
                    "expiry_date",
                    models.DateTimeField(
                        blank=True,
                        help_text="Once API key expires, clients cannot use it anymore.",
                        null=True,
                        verbose_name="Expires",
                    ),
                ),
                (
                    "organization",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="api_keys",
                        to="auth.group",
                    ),
                ),
            ],
            options={
                "verbose_name": "API Key",
                "verbose_name_plural": "API Keys",
            },
        ),
        migrations.CreateModel(
            name="DocumentImage",
            fields=[
                ("id", models.AutoField(primary_key=True, serialize=False)),
                ("name", models.CharField(blank=True, max_length=255)),
                (
                    "image",
                    models.ImageField(
                        upload_to=lunes_cms.cms.models.static.convert_umlaute_images,
                        validators=[
                            lunes_cms.cms.validators.validate_multiple_extensions
                        ],
                    ),
                ),
                (
                    "confirmed",
                    models.BooleanField(default=True, verbose_name="confirmed"),
                ),
                (
                    "document",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="document_image",
                        to="cms.document",
                    ),
                ),
            ],
            options={
                "verbose_name": "image",
                "verbose_name_plural": "images",
            },
        ),
        migrations.CreateModel(
            name="AlternativeWord",
            fields=[
                ("id", models.AutoField(primary_key=True, serialize=False)),
                (
                    "alt_word",
                    models.CharField(max_length=255, verbose_name="alternative word"),
                ),
                (
                    "article",
                    models.IntegerField(
                        choices=[
                            (0, "keiner"),
                            (1, "der"),
                            (2, "die"),
                            (3, "das"),
                            (4, "die (Plural)"),
                        ],
                        default="",
                        verbose_name="article",
                    ),
                ),
                (
                    "document",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="alternatives",
                        to="cms.document",
                    ),
                ),
            ],
            options={
                "verbose_name": "alternative word",
                "verbose_name_plural": "alternative words",
            },
        ),
    ]
