# -*- coding: utf-8 -*-
"""
    pip_services3_commons.validate.ValidationResult
    ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    
    Validation result implementation
    
    :copyright: Conceptual Vision Consulting LLC 2018-2019, see AUTHORS for more details.
    :license: MIT, see LICENSE for more details.
"""

class ValidationResult(object):
    """
    Result generated by schema validation
    """
    path = None
    type = None
    code = None
    message = None
    expected = None
    actual = None

    def __init__(self, path = None, type = None, code = None, message = None, expected = None, actual = None):
        """
        Creates a new instance of validation ressult and sets its values.

        :param path: a dot notation path of the validated element.

        :param type: a type of the validation result: Information, Warning, or Error.

        :param code: an error code.

        :param message: a human readable message.

        :param expected: an value expected by schema validation.

        :param actual: an actual value found by schema validation.
        """
        self.path = path
        self.type = type
        self.code = code
        self.message = message
        self.expected = expected
        self.actual = actual
