# Generated by Django 2.2.9 on 2020-01-31 13:54

from django.db import migrations, models
import django.db.models.deletion
import djangocms_attributes_field.fields
import djangocms_call_to_action.validators
import filer.fields.file


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('cms', '0022_auto_20180620_1551'),
        ('filer', '0011_auto_20190418_0137'),
    ]

    operations = [
        migrations.CreateModel(
            name='Campaign',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('label', models.CharField(max_length=100, verbose_name='Label')),
                ('redirect_external_link', models.CharField(blank=True, help_text='Provide a link to an external source to redirect the user to once form validated.', max_length=2040, validators=[djangocms_call_to_action.validators.IntranetURLValidator(intranet_host_re=None)], verbose_name='Redirect to an external link')),
                ('deny_internal_link_access', models.BooleanField(db_index=True, default=False, verbose_name="Deny access to the internal link redirect page if the user hasn't validate the form")),
                ('value', models.PositiveIntegerField(blank=True, help_text='A positive integer used in the "value" field of Google Analytics', null=True, verbose_name='Value')),
                ('file_link', filer.fields.file.FilerFileField(blank=True, help_text='If provided links a file from the filer app.', null=True, on_delete=django.db.models.deletion.SET_NULL, to='filer.File', verbose_name='File link')),
                ('form_page', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='form_cta_campaigns', to='cms.Page', verbose_name='Page containing CTA form')),
                ('redirect_internal_link', models.ForeignKey(blank=True, help_text='If provided, overrides the external link to redirect the user to once form validated.', null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='redirect_cta_campaigns', to='cms.Page', verbose_name='Redirect to an internal link')),
            ],
            options={
                'verbose_name': 'Campaign',
            },
        ),
        migrations.CreateModel(
            name='CTAPluginSettings',
            fields=[
                ('cmsplugin_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, related_name='djangocms_call_to_action_ctapluginsettings', serialize=False, to='cms.CMSPlugin')),
                ('name', models.CharField(blank=True, max_length=255, verbose_name='Display name')),
                ('template', models.CharField(choices=[('default.html', 'Link')], default='default.html', max_length=100, verbose_name='Template')),
                ('label', models.CharField(default='Button', help_text='ex: Top page button', max_length=100, verbose_name='Label')),
                ('target', models.CharField(blank=True, choices=[('_blank', 'Open in new window'), ('_self', 'Open in same window'), ('_parent', 'Delegate to parent'), ('_top', 'Delegate to top')], max_length=255, verbose_name='Target')),
                ('attributes', djangocms_attributes_field.fields.AttributesField(blank=True, default=dict, verbose_name='Attributes')),
                ('campaign', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='djangocms_call_to_action.Campaign', verbose_name='Campaign')),
            ],
            options={
                'abstract': False,
            },
            bases=('cms.cmsplugin',),
        ),
    ]
