from genice2.cell import cellvectors
import genice2.lattices
import numpy as np
desc = {
    "ref": {
        "PCOD8036144": "Engel 2018"
    },
    "usage": "No options available.",
    "brief": "Hypothetical zeolitic ice"
}


class Lattice(genice2.lattices.Lattice):
    def __init__(self):
        self.cell = cellvectors(
            a=25.25236,
            b=25.6546,
            c=29.89573,
            A=89.51475,
            B=65.21508,
            C=88.80198
        )
        self.waters = np.array([
            [0.401197, 0.472395, 0.447650],
            [0.379980, 0.175177, 0.435562],
            [0.407669, 0.277616, 0.193165],
            [0.086977, 0.222193, 0.307101],
            [0.319874, 0.433597, 0.318284],
            [0.178805, 0.066568, 0.182295],
            [0.111309, 0.422302, 0.317706],
            [0.176331, 0.180283, 0.429958],
            [0.320471, 0.322444, 0.072573],
            [0.095550, 0.029795, 0.055153],
            [0.383587, 0.077800, 0.182036],
            [0.116982, 0.327493, 0.067595],
            [-0.098802, 0.472395, 0.447650],
            [0.879981, 0.175170, 0.435562],
            [-0.092329, 0.277616, 0.193165],
            [0.586976, 0.222193, 0.307101],
            [0.819875, 0.433600, 0.318283],
            [0.678806, 0.066567, 0.182296],
            [0.611308, 0.422302, 0.317707],
            [0.676328, 0.180281, 0.429958],
            [0.820471, 0.322444, 0.072572],
            [0.595548, 0.029795, 0.055153],
            [-0.116412, 0.077799, 0.182036],
            [0.616984, 0.327493, 0.067595],
            [0.401196, -0.027606, 0.447650],
            [0.379978, 0.675179, 0.435565],
            [0.407673, -0.222385, 0.193166],
            [0.086977, 0.722193, 0.307102],
            [0.319874, -0.066402, 0.318284],
            [0.178805, 0.566569, 0.182295],
            [0.111310, -0.077699, 0.317705],
            [0.176331, 0.680284, 0.429958],
            [0.320470, -0.177556, 0.072574],
            [0.095550, 0.529794, 0.055153],
            [0.383587, 0.577801, 0.182036],
            [0.116982, -0.172507, 0.067595],
            [-0.098803, -0.027606, 0.447650],
            [0.879979, 0.675175, 0.435565],
            [-0.092329, -0.222384, 0.193165],
            [0.586976, 0.722193, 0.307102],
            [0.819871, -0.066402, 0.318283],
            [0.678806, 0.566569, 0.182296],
            [0.611312, -0.077699, 0.317705],
            [0.676332, 0.680284, 0.429958],
            [0.820470, -0.177557, 0.072572],
            [0.595549, 0.529794, 0.055153],
            [-0.116412, 0.577801, 0.182036],
            [0.616983, -0.172507, 0.067595],
            [0.401197, 0.472394, -0.052349],
            [0.379979, 0.175177, -0.064436],
            [0.407671, 0.277616, 0.693166],
            [0.086976, 0.222193, -0.192898],
            [0.319872, 0.433600, -0.181716],
            [0.178802, 0.066567, 0.682298],
            [0.111309, 0.422305, -0.182294],
            [0.176331, 0.180283, -0.070041],
            [0.320471, 0.322444, 0.572575],
            [0.095549, 0.029795, 0.555155],
            [0.383589, 0.077800, 0.682036],
            [0.116980, 0.327493, 0.567597],
            [-0.098803, 0.472394, -0.052349],
            [0.879981, 0.175175, -0.064437],
            [-0.092329, 0.277617, 0.693163],
            [0.586977, 0.222193, -0.192898],
            [0.819873, 0.433600, -0.181717],
            [0.678803, 0.066567, 0.682298],
            [0.611310, 0.422301, -0.182294],
            [0.676329, 0.180282, -0.070041],
            [0.820470, 0.322444, 0.572571],
            [0.595550, 0.029795, 0.555155],
            [-0.116412, 0.077800, 0.682036],
            [0.616983, 0.327493, 0.567593],
            [0.401197, -0.027605, -0.052349],
            [0.379978, 0.675182, -0.064436],
            [0.407671, -0.222384, 0.693166],
            [0.086976, 0.722192, -0.192898],
            [0.319871, -0.066402, -0.181715],
            [0.178802, 0.566565, 0.682298],
            [0.111310, -0.077698, -0.182295],
            [0.176331, 0.680283, -0.070041],
            [0.320471, -0.177557, 0.572575],
            [0.095549, 0.529795, 0.555155],
            [0.383589, 0.577798, 0.682036],
            [0.116981, -0.172507, 0.567597],
            [-0.098803, -0.027605, -0.052349],
            [0.879978, 0.675174, -0.064437],
            [-0.092330, -0.222384, 0.693166],
            [0.586977, 0.722192, -0.192897],
            [0.819872, -0.066402, -0.181716],
            [0.678805, 0.566569, 0.682294],
            [0.611310, -0.077698, -0.182294],
            [0.676330, 0.680283, -0.070042],
            [0.820472, -0.177557, 0.572575],
            [0.595550, 0.529795, 0.555155],
            [-0.116411, 0.577802, 0.682036],
            [0.616981, -0.172507, 0.567597],
        ])
        self.coord = 'relative'
