import hashlib

from tqdm import tqdm

from testgear_cli.apiclient import ApiClient
from testgear_cli.configurator import Configurator
from testgear_cli.converter import Converter
from testgear_cli.models.testcase import TestCase


class Importer:
    def __init__(self, api_client: ApiClient, config: Configurator):
        self.__api_client = api_client
        self.__config = config

    def send_results(self, results: [TestCase]):
        for result in tqdm(results, desc="Uploading"):
            external_id = self.__get_external_id(
                result.get_name_space()
                + result.get_class_name()
                + result.get_name()
            )

            autotest = self.__api_client.get_autotest(
                external_id, self.__config.get_project_id()
            )

            if not autotest:
                self.__api_client.create_autotest(
                    Converter.test_result_to_autotest_post_model(
                        result, external_id, self.__config.get_project_id()
                    )
                )
            else:
                self.__api_client.update_autotest(
                    Converter.test_result_to_autotest_put_model(
                        result, external_id, self.__config.get_project_id()
                    )
                )

            self.__api_client.send_test_result(
                self.__config.get_testrun_id(),
                Converter.test_result_to_testrun_result_post_model(
                    result, external_id, self.__config.get_configuration_id()
                ),
            )

    @staticmethod
    def __get_external_id(value: str):
        return hashlib.md5(value.encode("utf-8")).hexdigest()
