# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['properties_tools']

package_data = \
{'': ['*']}

install_requires = \
['colorama']

entry_points = \
{'console_scripts': ['properties-diff = properties_tools.diff:run',
                     'properties-patch = properties_tools.patch:run']}

setup_kwargs = {
    'name': 'properties-tools',
    'version': '0.5.1',
    'description': 'Collection of command line tools to work with properties files (diff-like, patch-like)',
    'long_description': '![Github](https://img.shields.io/github/tag/essembeh/properties-diff.svg)\n![PyPi](https://img.shields.io/pypi/v/properties-tools.svg)\n![Python](https://img.shields.io/pypi/pyversions/properties-tools.svg)\n![](https://github.com/essembeh/properties-tools/actions/workflows/poetry.yml/badge.svg)\n\n\n# properties-tools\n\n**properties-tools** is a collection of command line tools to work with *properties* files: comparing like `wdiff`, updating like `patch`... \n\nThe idea is to work with the *content* (`key/value` pairs) instead of the *text*, to ignore order or format and deal with the data.\n\n\n* [`properties-diff`](#properties-diff) can compare and print differences between 2 *properties* files, with fancy colors as if you were using `wdiff` or `diff` tools. It does not compare the *text* files.\n* [`properties-patch`](#properties-patch) can update a *properties* file using values from others, you can choose to *add* new keys and/or *update* existing and/or *remove* others.\n\n\n\n# Install\n\nInstall the latest release from [PyPI](https://pypi.org/project/properties-tools/)\n```sh\n$ pip3 install properties-diff\n$ properties-diff --help\n```\n\nInstall from the sources\n```sh\n$ pip3 install --user --upgrade git+https://github.com/essembeh/properties-tools\n$ properties-diff --help\n```\n\n\n# properties-diff\n\n\n## Usage\n\n```sh\n$ properties-diff --help\nusage: properties-diff [-h] [-q] [--quote] [--sep SEP] [-m {simple,diff,wdiff}] [-A] [-D] [-U] left.properties right.properties\n\npositional arguments:\n  left.properties       left file to compare\n  right.properties      right file to compare\n\noptional arguments:\n  -h, --help            show this help message and exit\n  -q, --quiet           print less information\n  --quote               use double quotes for values, example: foo="bar"\n  --sep SEP             key/value separator, default is \'=\'\n  -m {simple,diff,wdiff}, --mode {simple,diff,wdiff}\n                        select a format to show differences: using colors only (simple), using diff-like format (diff) or wdiff-like (wdiff) format. Default is \'wdiff\'\n  -A, --added           print added properties\n  -D, --deleted         print deleted properties\n  -U, --updated         print updated properties\n```\n\n\n## Examples\n\nComparing *properties* files like `wdiff`\n```sh\n$ properties-diff tests/sample1.properties tests/sample2.properties\n--- tests/sample1.properties (left)    2022-04-07 12:48:44\n+++ tests/sample2.properties (right)    2022-04-07 12:49:02\n# Only in tests/sample1.properties (left)\n[-database.host=localhost-]\n# Only in tests/sample2.properties (right)\n{+database.version=12+}\n# Updated from tests/sample1.properties (left) to tests/sample2.properties (right)\ndatabase.type=[-postgresql-]{+mysql+}\ndatabase.user=[-test-]{+dbuser+}\n```\n\nComparing *properties* files like `diff`\n```sh\n$ properties-diff tests/sample1.properties tests/sample2.properties --mode diff\n--- tests/sample1.properties (left)    2022-04-07 12:48:44\n+++ tests/sample2.properties (right)    2022-04-07 12:49:02\n# Only in tests/sample1.properties (left)\n- database.host=localhost\n# Only in tests/sample2.properties (right)\n+ database.version=12\n# Updated from tests/sample1.properties (left) to tests/sample2.properties (right)\n- database.type=postgresql\n+ database.type=mysql\n- database.user=test\n+ database.user=dbuser\n```\n\nCompare files, but only show `updateed` and `added` values\n```sh\n$ properties-diff tests/sample1.properties tests/sample2.properties --add --update\n--- tests/sample1.properties (left)    2022-04-07 12:48:44\n+++ tests/sample2.properties (right)    2022-04-07 12:49:02\n# Only in tests/sample2.properties (right)\n{+database.version=12+}\n# Updated from tests/sample1.properties (left) to tests/sample2.properties (right)\ndatabase.type=[-postgresql-]{+mysql+}\ndatabase.user=[-test-]{+dbuser+}\n```\n\n\n## Viewing modes\n\nYou can see *differences* between the *properties* files using 3 modes using `--mode <MODE>` or `-m <MODE>`\n* `wdiff`, prints the changes like `wdiff` tool would do (this is the default mode)\n* `diff`, prints the changes like `diff` tool would do\n* `simple`, based on colors, *red* for removed lines, *green* for added lines\n\n![wdiff](images/wdiff.png)\n![diff](images/diff.png)\n![simple](images/simple.png)\n\n\n\n\n# properties-patch\n\n\n## Usage\n\n```sh\n$ properties-patch --help\nusage: properties-patch [-h] [-c] [--comments] [-f] [-i] [--quote] [--sep SEP] [-A] [-D] [-U] -p patch.properties [-o output.properties] source.properties\n\npositional arguments:\n  source.properties     file to modify\n\noptional arguments:\n  -h, --help            show this help message and exit\n  -c, --color           print colors\n  --comments            insert comment when property is added, updated or deleted\n  -f, --force           force output file (--output) overwrite if it already exists\n  -i, --interactive     ask for confirmation to add, update or delete a property\n  --quote               use double quotes for values, example: foo="bar"\n  --sep SEP             key/value separator, default is \'=\'\n  -p patch.properties, --patch patch.properties\n                        patch file\n  -o output.properties, --output output.properties\n                        modified file\n\n  -A, --add             add new properties from patches\n  -D, --delete          delete properties not in patches\n  -U, --update          update properties from patches\n```\n\n\n## Examples\n\nBuild a properties file from `tests/sample1.properties` and add missing keys from  `tests/sample2.properties` \n```sh\n$ properties-patch tests/sample1.properties --patch tests/sample2.properties --add     \n# just a comment\ndatabase.type=postgresql\ndatabase.host=localhost\ndatabase.port=5432\n# and another comment\ndatabase.user=test\ndatabase.password=foobar\ndatabase.version=12\n```\n\nYou can use multiple *patch* files, if a value is present in multiple *patch* files, the latest value will be used. \n```sh\n$ properties-patch tests/sample1.properties --patch tests/sample2.properties --patch tests/sample3.properties -A    \n# just a comment\ndatabase.type=postgresql\ndatabase.host=localhost\ndatabase.port=5432\n# and another comment\ndatabase.user=test\ndatabase.password=foobar\ndatabase.version=42\n```\n\nYou can choose to *add* missing values and *update* values that are different in the *patch* files\n```sh\n$ properties-patch tests/sample1.properties --patch tests/sample2.properties -AU\n# just a comment\ndatabase.type=mysql\ndatabase.host=localhost\ndatabase.port=5432\n# and another comment\ndatabase.user=dbuser\ndatabase.password=foobar\ndatabase.version=12\n```\n\nThere is an *interactive* mode, which ask for confirmation before every change (usefull to take only some changes, equivalent to `git add --interactive`)\n```sh\n$ properties-patch tests/sample1.properties --patch tests/sample2.properties -AU --interactive\n# just a comment\n💬  Update database.type=postgresql,mysql ? [Y/n] \ndatabase.type=mysql\ndatabase.host=localhost\ndatabase.port=5432\n# and another comment\n💬  Update database.user=test,dbuser ? [Y/n] \ndatabase.user=dbuser\ndatabase.password=foobar\n💬  Add database.version=12 ? [Y/n] \ndatabase.version=12\n```\n\nTo track changes, you can add comments for every change applied\n```sh\n$ properties-patch tests/sample1.properties --patch tests/sample2.properties -ADU --comments\n# just a comment\n# 2022-04-07 23:12:11  update: database.type=postgresql\ndatabase.type=mysql\n# 2022-04-07 23:12:11  remove: database.host=localhost\ndatabase.port=5432\n# and another comment\n# 2022-04-07 23:12:11  update: database.user=test\ndatabase.user=dbuser\ndatabase.password=foobar\n# 2022-04-07 23:12:11  add: database.version\ndatabase.version=12\n```',
    'author': 'Sébastien MB',
    'author_email': 'seb@essembeh.org',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/essembeh/properties-tools',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.7,<4.0',
}


setup(**setup_kwargs)
