fastxtend
================

<!-- WARNING: THIS FILE WAS AUTOGENERATED! DO NOT EDIT! -->

<div>

### Train fastai models faster (and other useful tools)

</div>

<div>

![fastxtend accelerates fastai](nbs/images/imagenette_benchmark.png)

</div>

Train fastai models faster with fastxtend’s [fused
optimizers](optimizer.fused.html), [Progressive
Resizing](callback.progresize.html) callback, and integrated [FFCV
DataLoader](ffcv.tutorial.html).

## Feature overview

**Train Models Faster**

- Drop in [fused optimizers](optimizer.fused.html), which are 21 to 293
  percent faster then fastai native optimizers.
- Increase GPU throughput and decrease training time with the
  [Progressive Resizing](callback.progresize.html) callback.
- Use the highly optimized [FFCV DataLoader](ffcv.tutorial.html), fully
  integrated with fastai.

**General Features**

- Fused implementations of modern optimizers, such as
  [Adan](optimizer.adan.html) and [Lion](optimizer.lion.html).
- Flexible [metrics](metrics.html) which can log on train, valid, or
  both. Backwards compatible with fastai metrics.
- Easily use [multiple losses](multiloss.html) and log each individual
  loss on train and valid.
- [Multiple profilers](callback.profiler.html) for profiling training
  and identifying bottlenecks.
- A fast [Exponential Moving Average](callback.ema.html) callback for
  smoother training.

**Vision**

- Apply
  [`MixUp`](https://fastxtend.benjaminwarner.dev/callback.cutmixup.html#mixup),
  [`CutMix`](https://fastxtend.benjaminwarner.dev/callback.cutmixup.html#cutmix),
  or Augmentations at once with
  [`CutMixUp`](https://fastxtend.benjaminwarner.dev/callback.cutmixup.html#cutmixup)
  or
  [`CutMixUpAugment`](https://fastxtend.benjaminwarner.dev/callback.cutmixup.html#cutmixupaugment).
- Additional [image augmentations](vision.augment.batch.html).
- Support for running fastai [batch transforms on
  CPU](vision.data.html).
- More [attention](vision.models.attention_modules.html) and
  [pooling](vision.models.pooling.html) modules
- A flexible implementation of fastai’s
  [`XResNet`](https://fastxtend.benjaminwarner.dev/vision.models.xresnet.html#xresnet).

**Audio**

- [`TensorAudio`](https://fastxtend.benjaminwarner.dev/audio.01_core.html#tensoraudio),
  [`TensorSpec`](https://fastxtend.benjaminwarner.dev/audio.01_core.html#tensorspec),
  [`TensorMelSpec`](https://fastxtend.benjaminwarner.dev/audio.01_core.html#tensormelspec)
  objects which maintain metadata and support plotting themselves using
  librosa.
- A selection of performant [audio augmentations](audio.augment.html)
  inspired by fastaudio and torch-audiomentations.
- Uses TorchAudio to quickly convert
  [`TensorAudio`](https://fastxtend.benjaminwarner.dev/audio.01_core.html#tensoraudio)
  waveforms into
  [`TensorSpec`](https://fastxtend.benjaminwarner.dev/audio.01_core.html#tensorspec)
  spectrograms or
  [`TensorMelSpec`](https://fastxtend.benjaminwarner.dev/audio.01_core.html#tensormelspec)
  mel spectrograms using the GPU.
- Out of the box support for converting one
  [`TensorAudio`](https://fastxtend.benjaminwarner.dev/audio.01_core.html#tensoraudio)
  to one or multiple
  [`TensorSpec`](https://fastxtend.benjaminwarner.dev/audio.01_core.html#tensorspec)
  or
  [`TensorMelSpec`](https://fastxtend.benjaminwarner.dev/audio.01_core.html#tensormelspec)
  objects from the Datablock api.
- Audio [MixUp and CutMix](audio.mixup.html) Callbacks.
- [`audio_learner`](https://fastxtend.benjaminwarner.dev/audio.04_learner.html#audio_learner)
  which merges multiple
  [`TensorSpec`](https://fastxtend.benjaminwarner.dev/audio.01_core.html#tensorspec)
  or
  [`TensorMelSpec`](https://fastxtend.benjaminwarner.dev/audio.01_core.html#tensormelspec)
  objects before passing to the model.

Check out the documentation for additional splitters, callbacks,
schedulers, utilities, and more.

<div>

## Documentation

<https://fastxtend.benjaminwarner.dev>

</div>

## Install

fastxtend is avalible on pypi:

``` bash
pip install fastxtend
```

To install with dependencies for vision, FFCV, audio, or all tasks run
one of:

``` bash
pip install fastxtend[vision]

pip install fastxtend[ffcv]

pip install fastxtend[audio]

pip install fastxtend[all]
```

Or to create an editable development install:

``` bash
git clone https://github.com/warner-benjamin/fastxtend.git
cd fastxtend
pip install -e ".[dev]"
```

To easily install prerequisites for all fastxtend features, use
[Conda](https://docs.conda.io/en/latest) or
[Miniconda](https://docs.conda.io/en/latest/miniconda.html):

``` bash
conda create -n fastxtend python=3.10 pytorch torchvision \
torchaudio pytorch-cuda=11.8 cuda fastai nbdev pkg-config \
libjpeg-turbo opencv tqdm terminaltables psutil numpy=1.23.5 \
numba librosa=0.9.2 timm kornia rich typer wandb -c pytorch \
-c nvidia/label/cuda-11.8.0 -c fastai -c huggingface -c conda-forge

conda activate fastxtend
```

replacing `pytorch-cuda=11.8` and `nvidia/label/cuda-11.8.0` with your
preferred [supported version of
Cuda](https://pytorch.org/get-started/locally). Then install fastxtend
using `pip`:

``` bash
pip install fastxtend[all]
```

## Usage

Like fastai, fastxtend provides safe wildcard imports using python’s
`__all__`.

``` python
from fastai.vision.all import *
from fastxtend.vision.all import *
from fastxtend.ffcv.all import *
```

In general, import fastxtend after all fastai imports, as fastxtend
modifies fastai. Any method modified by fastxtend is backwards
compatible with the original fastai code.

## Examples

Use a fused ForEach optimizer:

``` python
Learner(..., opt_func=adam(foreach=True))
```

Log an accuracy metric on the training set as a smoothed metric and
validation set like normal:

``` python
Learner(..., metrics=[Accuracy(log_metric=LogMetric.Train, metric_type=MetricType.Smooth),
                      Accuracy()])
```

Log multiple losses as individual metrics on train and valid:

``` python
mloss = MultiLoss(loss_funcs=[nn.MSELoss, nn.L1Loss],
                  weights=[1, 3.5], loss_names=['mse_loss', 'l1_loss'])

Learner(..., loss_func=mloss, metrics=RMSE(), cbs=MultiLossCallback)
```

Apply MixUp, CutMix, or Augmentation while training:

``` python
Learner(..., cbs=CutMixUpAugment)
```

Profile a fastai training loop:

``` python
from fastxtend.callback import simpleprofiler

learn = Learner(...).profile()
learn.fit_one_cycle(2, 3e-3)
```
