"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SnsTopicAction = exports.SnsActionMessageFormat = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const role_1 = require("./private/role");
/**
 * SNS topic action message format options.
 */
var SnsActionMessageFormat;
(function (SnsActionMessageFormat) {
    /**
     * RAW message format.
     */
    SnsActionMessageFormat["RAW"] = "RAW";
    /**
     * JSON message format.
     */
    SnsActionMessageFormat["JSON"] = "JSON";
})(SnsActionMessageFormat = exports.SnsActionMessageFormat || (exports.SnsActionMessageFormat = {}));
/**
 * The action to write the data from an MQTT message to an Amazon SNS topic.
 *
 * @see https://docs.aws.amazon.com/iot/latest/developerguide/sns-rule-action.html
 */
class SnsTopicAction {
    /**
     * @param topic The Amazon SNS topic to publish data on. Must not be a FIFO topic.
     * @param props Properties to configure the action.
     */
    constructor(topic, props = {}) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_iot_actions_SnsTopicActionProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.constructor);
            }
            throw error;
        }
        if (topic.fifo) {
            throw Error('IoT Rule actions cannot be used with FIFO SNS Topics, please pass a non-FIFO Topic instead');
        }
        this.topic = topic;
        this.role = props.role;
        this.messageFormat = props.messageFormat;
    }
    bind(rule) {
        var _b;
        const role = (_b = this.role) !== null && _b !== void 0 ? _b : role_1.singletonActionRole(rule);
        this.topic.grantPublish(role);
        return {
            configuration: {
                sns: {
                    targetArn: this.topic.topicArn,
                    roleArn: role.roleArn,
                    messageFormat: this.messageFormat,
                },
            },
        };
    }
}
exports.SnsTopicAction = SnsTopicAction;
_a = JSII_RTTI_SYMBOL_1;
SnsTopicAction[_a] = { fqn: "@aws-cdk/aws-iot-actions.SnsTopicAction", version: "1.157.0" };
//# sourceMappingURL=data:application/json;base64,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