"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CloudWatchSetAlarmStateAction = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const iam = require("@aws-cdk/aws-iam");
const role_1 = require("./private/role");
/**
 * The action to change the state of an Amazon CloudWatch alarm.
 */
class CloudWatchSetAlarmStateAction {
    constructor(alarm, props) {
        this.alarm = alarm;
        this.props = props;
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_iot_actions_CloudWatchSetAlarmStateActionProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.constructor);
            }
            throw error;
        }
    }
    bind(topicRule) {
        var _b, _c;
        const role = (_b = this.props.role) !== null && _b !== void 0 ? _b : role_1.singletonActionRole(topicRule);
        role.addToPrincipalPolicy(new iam.PolicyStatement({
            actions: ['cloudwatch:SetAlarmState'],
            resources: [this.alarm.alarmArn],
        }));
        return {
            configuration: {
                cloudwatchAlarm: {
                    alarmName: this.alarm.alarmName,
                    roleArn: role.roleArn,
                    stateReason: (_c = this.props.reason) !== null && _c !== void 0 ? _c : `Set state of '${this.alarm.alarmName}' to '${this.props.alarmStateToSet}'`,
                    stateValue: this.props.alarmStateToSet,
                },
            },
        };
    }
}
exports.CloudWatchSetAlarmStateAction = CloudWatchSetAlarmStateAction;
_a = JSII_RTTI_SYMBOL_1;
CloudWatchSetAlarmStateAction[_a] = { fqn: "@aws-cdk/aws-iot-actions.CloudWatchSetAlarmStateAction", version: "1.157.0" };
//# sourceMappingURL=data:application/json;base64,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