"use strict";
(self["webpackChunkxautoml"] = self["webpackChunkxautoml"] || []).push([["lib_index_js"],{

/***/ "./lib/components/candidate_inspections.js":
/*!*************************************************!*\
  !*** ./lib/components/candidate_inspections.js ***!
  \*************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "CandidateInspections": () => (/* binding */ CandidateInspections)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _util__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../util */ "./lib/util.js");
/* harmony import */ var _util_layout__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../util/layout */ "./lib/util/layout.js");
/* harmony import */ var _details_local_surrogate__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./details/local_surrogate */ "./lib/components/details/local_surrogate.js");
/* harmony import */ var _details_feature_importance__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./details/feature_importance */ "./lib/components/details/feature_importance.js");
/* harmony import */ var _util_raw_dataset__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../util/raw_dataset */ "./lib/util/raw_dataset.js");
/* harmony import */ var _details_model__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./details/model */ "./lib/components/details/model.js");
/* harmony import */ var _details_global_surrogate__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./details/global_surrogate */ "./lib/components/details/global_surrogate.js");
/* harmony import */ var _util_collapse__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../util/collapse */ "./lib/util/collapse.js");
/* harmony import */ var _details_performance_details__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./details/performance_details */ "./lib/components/details/performance_details.js");
/* harmony import */ var _details_hp_importance__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ./details/hp_importance */ "./lib/components/details/hp_importance.js");
/* harmony import */ var _details_configuration__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ./details/configuration */ "./lib/components/details/configuration.js");












class CandidateInspections extends (react__WEBPACK_IMPORTED_MODULE_0___default().Component) {
    constructor(props) {
        super(props);
        this.state = { selectedSample: undefined };
        this.handleSampleSelection = this.handleSampleSelection.bind(this);
        this.onComparisonRequest = this.onComparisonRequest.bind(this);
    }
    handleSampleSelection(idx) {
        this.setState({ selectedSample: idx });
    }
    onComparisonRequest(type) {
        this.props.onComparisonRequest(type, this.state.selectedSample);
    }
    render() {
        const { candidate, structure, meta, componentId, componentLabel, structures, explanations } = this.props;
        const { selectedSample } = this.state;
        const model = new _details_model__WEBPACK_IMPORTED_MODULE_1__.DetailsModel(structure, candidate, componentId, componentLabel, selectedSample);
        return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement((react__WEBPACK_IMPORTED_MODULE_0___default().Fragment), null,
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement("h3", null,
                "Insights for ",
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement("i", null, _util__WEBPACK_IMPORTED_MODULE_2__.Components.isPipEnd(model.component) ? `${model.component === _util__WEBPACK_IMPORTED_MODULE_2__.Components.SOURCE ? 'Beginning' : 'End'} of the Pipeline` : `${model.algorithm} (${model.component})`)),
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement("p", { style: { marginBottom: '15px', marginTop: '-15px' } }, "Select any step in the pipeline above to calculate the analysis in the following views for the output generated by the selected pipeline step."),
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_util_collapse__WEBPACK_IMPORTED_MODULE_3__.CollapseComp, { name: 'performance', showInitial: false, help: _details_performance_details__WEBPACK_IMPORTED_MODULE_4__.PerformanceDetailsComponent.HELP, onComparisonRequest: () => this.onComparisonRequest('performance') },
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement("h3", null, "Performance Details"),
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_details_performance_details__WEBPACK_IMPORTED_MODULE_4__.PerformanceDetailsComponent, { model: model, meta: meta })),
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_util_collapse__WEBPACK_IMPORTED_MODULE_3__.CollapseComp, { name: 'raw-dataset', showInitial: false, help: _util_raw_dataset__WEBPACK_IMPORTED_MODULE_5__.RawDataset.HELP },
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement("h3", null, "Data Set Preview"),
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_util_layout__WEBPACK_IMPORTED_MODULE_6__.TwoColumnLayout, { widthRight: '25%' },
                    react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_util_raw_dataset__WEBPACK_IMPORTED_MODULE_5__.RawDataset, { model: model, onSampleClick: this.handleSampleSelection }),
                    react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_details_local_surrogate__WEBPACK_IMPORTED_MODULE_7__.LocalSurrogateComponent, { model: model, orientation: 'vertical', onComparisonRequest: this.onComparisonRequest }))),
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_util_collapse__WEBPACK_IMPORTED_MODULE_3__.CollapseComp, { name: 'feature-importance', showInitial: false, help: _details_feature_importance__WEBPACK_IMPORTED_MODULE_8__.FeatureImportanceComponent.HELP, onComparisonRequest: () => this.onComparisonRequest('feature_importance') },
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement("h3", null, "Feature Importance"),
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_details_feature_importance__WEBPACK_IMPORTED_MODULE_8__.FeatureImportanceComponent, { model: model })),
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_util_collapse__WEBPACK_IMPORTED_MODULE_3__.CollapseComp, { name: 'global-surrogate', showInitial: false, help: _details_global_surrogate__WEBPACK_IMPORTED_MODULE_9__.GlobalSurrogateComponent.HELP, onComparisonRequest: () => this.onComparisonRequest('global_surrogate') },
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement("h3", null, "Global Surrogate"),
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_details_global_surrogate__WEBPACK_IMPORTED_MODULE_9__.GlobalSurrogateComponent, { model: model })),
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement("hr", null),
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_util_collapse__WEBPACK_IMPORTED_MODULE_3__.CollapseComp, { name: 'config-origin', showInitial: false, help: _details_configuration__WEBPACK_IMPORTED_MODULE_10__.ConfigurationComponent.HELP, onComparisonRequest: () => this.onComparisonRequest('configuration') },
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement("h3", null, "Configuration"),
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_details_configuration__WEBPACK_IMPORTED_MODULE_10__.ConfigurationComponent, { model: model, structures: structures, explanations: explanations })),
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_util_collapse__WEBPACK_IMPORTED_MODULE_3__.CollapseComp, { name: 'hp-importance', showInitial: false, help: _details_hp_importance__WEBPACK_IMPORTED_MODULE_11__.HPImportanceComp.HELP, onComparisonRequest: () => this.onComparisonRequest('hp_importance') },
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement("h3", null, "Hyperparameter Importance"),
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_details_hp_importance__WEBPACK_IMPORTED_MODULE_11__.HPImportanceComp, { model: model, metric: meta.metric }))));
    }
}
CandidateInspections.contextType = _util__WEBPACK_IMPORTED_MODULE_2__.JupyterContext;


/***/ }),

/***/ "./lib/components/comparison.js":
/*!**************************************!*\
  !*** ./lib/components/comparison.js ***!
  \**************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Comparison": () => (/* binding */ Comparison)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _details_feature_importance__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./details/feature_importance */ "./lib/components/details/feature_importance.js");
/* harmony import */ var _details_local_surrogate__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./details/local_surrogate */ "./lib/components/details/local_surrogate.js");
/* harmony import */ var _details_global_surrogate__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./details/global_surrogate */ "./lib/components/details/global_surrogate.js");
/* harmony import */ var _details_hp_importance__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./details/hp_importance */ "./lib/components/details/hp_importance.js");
/* harmony import */ var _util_collapse__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../util/collapse */ "./lib/util/collapse.js");
/* harmony import */ var _material_ui_icons__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @material-ui/icons */ "webpack/sharing/consume/default/@material-ui/icons/@material-ui/icons");
/* harmony import */ var _material_ui_icons__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_material_ui_icons__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _material_ui_core__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @material-ui/core */ "webpack/sharing/consume/default/@material-ui/core/@material-ui/core?df94");
/* harmony import */ var _material_ui_core__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_material_ui_core__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _details_pipeline_hyperparameters__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./details/pipeline_hyperparameters */ "./lib/components/details/pipeline_hyperparameters.js");
/* harmony import */ var _details_performance_details__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./details/performance_details */ "./lib/components/details/performance_details.js");










class Comparison extends (react__WEBPACK_IMPORTED_MODULE_0___default().Component) {
    constructor(props) {
        super(props);
        this.state = {
            limeLabel: undefined,
            dtSelectedIndex: 1,
            featureImportanceSelectedFeature: undefined,
            hpImportanceSelectedHp1: undefined,
            hpImportanceSelectedHp2: undefined
        };
        this.onLimeLabelChange = this.onLimeLabelChange.bind(this);
        this.onDTIndexChange = this.onDTIndexChange.bind(this);
        this.onFeatureImportanceFeatureChange = this.onFeatureImportanceFeatureChange.bind(this);
        this.onHpImportanceChange = this.onHpImportanceChange.bind(this);
    }
    onLimeLabelChange(label) {
        this.setState({ limeLabel: label });
    }
    onDTIndexChange(idx) {
        this.setState({ dtSelectedIndex: idx });
    }
    onFeatureImportanceFeatureChange(feature) {
        this.setState({ featureImportanceSelectedFeature: feature });
    }
    onHpImportanceChange(hp1, hp2) {
        this.setState({ hpImportanceSelectedHp1: hp1, hpImportanceSelectedHp2: hp2 });
    }
    render() {
        const { models, meta, type } = this.props;
        const n = 3;
        return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: 'comparison-container container' },
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { style: { display: "flex", marginBottom: '10px' } },
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_material_ui_core__WEBPACK_IMPORTED_MODULE_2__.IconButton, { style: { flexShrink: 1, maxHeight: '18px' }, size: 'small', onClick: this.props.onClose },
                    react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_material_ui_icons__WEBPACK_IMPORTED_MODULE_1__.ArrowForwardIos, null)),
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement("h3", { style: { margin: 0, lineHeight: '24px', textAlign: 'center' } }, "Comparisons")),
            models.length > n && react__WEBPACK_IMPORTED_MODULE_0___default().createElement("p", null,
                "Only up to ",
                n,
                " models can be compared at once"),
            models.slice(0, n).map(model => react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_util_collapse__WEBPACK_IMPORTED_MODULE_3__.CollapseComp, { showInitial: true, key: model.candidate.id },
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement("h4", null, model.candidate.id),
                type === 'performance' &&
                    react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_details_performance_details__WEBPACK_IMPORTED_MODULE_4__.PerformanceDetailsComponent, { model: model, meta: meta }),
                type === 'lime' &&
                    react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_details_local_surrogate__WEBPACK_IMPORTED_MODULE_5__.LocalSurrogateComponent, { model: model, selectedLabel: this.state.limeLabel, orientation: 'horizontal', onLabelChange: this.onLimeLabelChange }),
                type === 'global_surrogate' &&
                    react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_details_global_surrogate__WEBPACK_IMPORTED_MODULE_6__.GlobalSurrogateComponent, { model: model, onDTIndexChange: this.onDTIndexChange, dtIndex: this.state.dtSelectedIndex }),
                type === 'feature_importance' &&
                    react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_details_feature_importance__WEBPACK_IMPORTED_MODULE_7__.FeatureImportanceComponent, { model: model, onFeatureSelection: this.onFeatureImportanceFeatureChange, selectedFeature: this.state.featureImportanceSelectedFeature }),
                type === 'hp_importance' &&
                    react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_details_hp_importance__WEBPACK_IMPORTED_MODULE_8__.HPImportanceComp, { model: model, metric: meta.metric, onHpChange: this.onHpImportanceChange, selectedHp1: this.state.hpImportanceSelectedHp1, selectedHp2: this.state.hpImportanceSelectedHp2 }),
                type === 'configuration' &&
                    react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_details_pipeline_hyperparameters__WEBPACK_IMPORTED_MODULE_9__.HyperparameterTable, { config: model.candidate.config, twoColumns: true })))));
    }
}


/***/ }),

/***/ "./lib/components/details/configuration.js":
/*!*************************************************!*\
  !*** ./lib/components/details/configuration.js ***!
  \*************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "ConfigurationComponent": () => (/* binding */ ConfigurationComponent)
/* harmony export */ });
/* harmony import */ var _util__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../util */ "./lib/util.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _pc_parallel_corrdinates__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../pc/parallel_corrdinates */ "./lib/components/pc/parallel_corrdinates.js");
/* harmony import */ var _jupyter__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../jupyter */ "./lib/jupyter.js");
/* harmony import */ var _search_space_structure_search_graph__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../search_space/structure_search_graph */ "./lib/components/search_space/structure_search_graph.js");
/* harmony import */ var _util_loading__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../util/loading */ "./lib/util/loading.js");
/* harmony import */ var _util_warning__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../util/warning */ "./lib/util/warning.js");







class SMBOSurrogateCPC extends (react__WEBPACK_IMPORTED_MODULE_0___default().Component) {
    constructor(props) {
        super(props);
        this.state = { explanation: this.props.explanation, loading: this.props.explanation === undefined };
    }
    componentDidMount() {
        if (this.state.explanation === undefined)
            this.simulateExplanation();
    }
    simulateExplanation() {
        const { model } = this.props;
        this.setState({ loading: true });
        this.context.requestSimulatedSurrogate(model.structure.cid, model.candidate.runtime.timestamp)
            .then(resp => {
            this.setState({ explanation: resp, loading: false });
        })
            .catch(error => {
            console.error(`Failed to fetch simulated surrogate data.\n${error.name}: ${error.message}`);
            this.setState({ explanation: undefined, loading: false });
        });
    }
    render() {
        const { model } = this.props;
        const { explanation, loading } = this.state;
        const candidates = explanation && explanation.candidates.length > 0 ?
            explanation.candidates.map(c => [c, model.structure]) : [[model.candidate, model.structure]];
        const loss = candidates.map(([c, _]) => c.loss);
        const domain = [Math.min(...loss), Math.max(...loss)];
        const perfAxis = domain[0] === domain[1] ? undefined : { label: explanation.metric, domain: domain, log: true };
        const selected = new Set([loss.length > 1 ? loss.reduce((argMax, x, idx, array) => {
                return x > array[argMax] ? idx : argMax;
            }, 0).toString() : model.candidate.id]);
        return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: 'surrogate_explanation' },
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_util_loading__WEBPACK_IMPORTED_MODULE_1__.LoadingIndicator, { loading: loading }),
            !loading &&
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement((react__WEBPACK_IMPORTED_MODULE_0___default().Fragment), null,
                    (this.props.explanation === undefined && explanation !== undefined) &&
                        react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_util_warning__WEBPACK_IMPORTED_MODULE_2__.WarningIndicator, { message: 'The run history did not contain information about ' +
                                'the surrogate model. The surrogate state is only simulated via hyperparameter ' +
                                'importance and may differ significantly from the real surrogate model.' }),
                    (this.props.explanation === undefined && explanation === undefined) &&
                        react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_util_warning__WEBPACK_IMPORTED_MODULE_2__.WarningIndicator, { message: 'Failed to simulate surrogate model.' }),
                    react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_pc_parallel_corrdinates__WEBPACK_IMPORTED_MODULE_3__.ParallelCoordinates, { structures: [model.structure], candidates: candidates, selectedCandidates: selected, explanation: explanation, showExplanations: true, expand: true, onExport: this.props.onExport, perfAxis: perfAxis }))));
    }
}
SMBOSurrogateCPC.HELP = 'The line highlighted in blue represents the the actual selected configuration. In case ' +
    'of a model-based selection of the configuration, other potential configurations, that are worse ' +
    'than the selected configuration according to the internal model, are also displayed.';
SMBOSurrogateCPC.contextType = _util__WEBPACK_IMPORTED_MODULE_4__.JupyterContext;
class ConfigurationComponent extends (react__WEBPACK_IMPORTED_MODULE_0___default().Component) {
    constructor(props) {
        super(props);
        this.exportConfiguration = this.exportConfiguration.bind(this);
    }
    static getHelp(origin) {
        switch (origin) {
            case 'Default':
                return 'Default hyperparameters as specified in the component declaration.';
            case 'Hyperopt':
                return 'The candidate is obtained by optimizing an internal model of the performance of ' +
                    'potential candidates. More specifically, the selected candidate maximizes the posterior ' +
                    'in a Bayesian optimization. ';
            case 'Initial design':
                return 'This fixed candidate is selected based on some initial design. This initial design ' +
                    'could, for example, be a set of configurations obtained via via meta-learning that performed ' +
                    'well on a variety of data sets in the past.';
            case 'Random Search':
                return 'The candidate was selected at random.';
            case 'Local Search':
                return 'Candidate obtained via local search around all-ready evaluated candidates maximizing the acquisition function';
            case 'Random Search (sorted)':
                return 'Candidate obtained via random search maximizing the acquisition function';
            case 'Sobol':
                return 'Quasi-random selection of configuration based on a Sobol sequence';
        }
    }
    exportConfiguration() {
        const { id } = this.props.model.candidate;
        this.context.createCell(`
${_jupyter__WEBPACK_IMPORTED_MODULE_5__.ID}_hp = gcx().config('${id}')
${_jupyter__WEBPACK_IMPORTED_MODULE_5__.ID}_hp
        `.trim());
    }
    render() {
        const { explanations, model } = this.props;
        const { candidate } = model;
        return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement((react__WEBPACK_IMPORTED_MODULE_0___default().Fragment), null,
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement("h4", null, "Hyperparameters Optimization"),
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement(SMBOSurrogateCPC, { model: model, onExport: this.exportConfiguration, explanation: explanations === null || explanations === void 0 ? void 0 : explanations.configs.get(candidate.id) }),
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement("hr", null),
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement("h4", null, "Pipeline Structure Search"),
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_search_space_structure_search_graph__WEBPACK_IMPORTED_MODULE_6__.StructureSearchGraph, { timestamp: candidate.index })));
    }
}
ConfigurationComponent.HELP = 'Contains details about the selected hyperparameter configuration. Displayed are the raw ' +
    'hyperparameters for each step in the pipeline and how this configuration was obtained. If the configuration ' +
    'was obtained some kind of guided search strategy, the reasoning of the internal AutoML optimizer are' +
    'visualized.';
ConfigurationComponent.contextType = _util__WEBPACK_IMPORTED_MODULE_4__.JupyterContext;


/***/ }),

/***/ "./lib/components/details/confusion_matrix.js":
/*!****************************************************!*\
  !*** ./lib/components/details/confusion_matrix.js ***!
  \****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "ConfusionMatrix": () => (/* binding */ ConfusionMatrix)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _material_ui_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @material-ui/core */ "webpack/sharing/consume/default/@material-ui/core/@material-ui/core?df94");
/* harmony import */ var _material_ui_core__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_material_ui_core__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _util__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../util */ "./lib/util.js");



class ConfusionMatrix extends (react__WEBPACK_IMPORTED_MODULE_0___default().Component) {
    render() {
        const { cm } = this.props;
        return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_material_ui_core__WEBPACK_IMPORTED_MODULE_1__.Table, { className: 'jp-RenderedHTMLCommon' },
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_material_ui_core__WEBPACK_IMPORTED_MODULE_1__.TableBody, null,
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_material_ui_core__WEBPACK_IMPORTED_MODULE_1__.TableRow, null,
                    react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_material_ui_core__WEBPACK_IMPORTED_MODULE_1__.TableCell, { component: "th", rowSpan: cm.values.length + 2, style: { writingMode: "vertical-rl", minWidth: "16px" } }, "True Classes"),
                    react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_material_ui_core__WEBPACK_IMPORTED_MODULE_1__.TableCell, { component: "th", scope: "row", colSpan: cm.classes.length + 1 }, "Predicted Class")),
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_material_ui_core__WEBPACK_IMPORTED_MODULE_1__.TableRow, null,
                    react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_material_ui_core__WEBPACK_IMPORTED_MODULE_1__.TableCell, { component: "th", scope: "row" }),
                    cm.classes.map(clazz => react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_material_ui_core__WEBPACK_IMPORTED_MODULE_1__.TableCell, { key: clazz, component: "th", scope: "row", align: "right" }, clazz))),
                cm.values.map((row, idx) => (react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_material_ui_core__WEBPACK_IMPORTED_MODULE_1__.TableRow, { key: cm.classes[idx] },
                    react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_material_ui_core__WEBPACK_IMPORTED_MODULE_1__.TableCell, { component: "th", scope: "col" }, cm.classes[idx]),
                    row.map(cell => react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_material_ui_core__WEBPACK_IMPORTED_MODULE_1__.TableCell, { align: "right" }, (0,_util__WEBPACK_IMPORTED_MODULE_2__.prettyPrint)(cell, 5)))))))));
    }
}


/***/ }),

/***/ "./lib/components/details/dataset_table.js":
/*!*************************************************!*\
  !*** ./lib/components/details/dataset_table.js ***!
  \*************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "DataSetTable": () => (/* binding */ DataSetTable)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);

class DataSetTable extends (react__WEBPACK_IMPORTED_MODULE_0___default().Component) {
    constructor(props) {
        super(props);
        this.dfTableRef = react__WEBPACK_IMPORTED_MODULE_0___default().createRef();
        this.handleSampleClick = this.handleSampleClick.bind(this);
    }
    componentDidMount() {
        this.registerClickListener();
    }
    componentDidUpdate(prevProps, prevState, snapshot) {
        this.registerClickListener();
    }
    registerClickListener() {
        if (!!this.dfTableRef.current) {
            [...this.dfTableRef.current.getElementsByTagName('tr')].forEach(tr => {
                tr.onclick = this.handleSampleClick;
                // Highlight previously selected row
                if (this.props.selectedSample !== undefined &&
                    this.props.selectedSample === Number.parseInt(tr.firstElementChild.textContent)) {
                    tr.classList.add(DataSetTable.selectedClassName);
                }
            });
        }
    }
    handleSampleClick(event) {
        const row = event.target instanceof HTMLTableRowElement ? event.target : event.target.parentElement;
        const idx = Number.parseInt(row.firstElementChild.textContent);
        if (isNaN(idx))
            // Abort processing as no valid row selected
            return;
        // Highlight selected row
        row.parentElement.querySelectorAll(`.${DataSetTable.selectedClassName}`)
            .forEach(el => el.classList.remove(DataSetTable.selectedClassName));
        row.classList.add(DataSetTable.selectedClassName);
        this.props.onSampleClick(idx);
    }
    render() {
        return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { style: { overflowX: 'auto' } },
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: 'jp-RenderedHTMLCommon raw-dataset', ref: this.dfTableRef, dangerouslySetInnerHTML: { __html: this.props.data } })));
    }
}
DataSetTable.selectedClassName = 'selected-config';


/***/ }),

/***/ "./lib/components/details/feature_importance.js":
/*!******************************************************!*\
  !*** ./lib/components/details/feature_importance.js ***!
  \******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "FeatureImportanceComponent": () => (/* binding */ FeatureImportanceComponent)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _util_loading__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../util/loading */ "./lib/util/loading.js");
/* harmony import */ var _util_error__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../../util/error */ "./lib/util/error.js");
/* harmony import */ var _util__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../util */ "./lib/util.js");
/* harmony import */ var _util_warning__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../../util/warning */ "./lib/util/warning.js");
/* harmony import */ var _util_jupyter_button__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../../util/jupyter-button */ "./lib/util/jupyter-button.js");
/* harmony import */ var _util_importance_overview__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../../util/importance_overview */ "./lib/util/importance_overview.js");
/* harmony import */ var recharts__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! recharts */ "webpack/sharing/consume/default/recharts/recharts");
/* harmony import */ var recharts__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(recharts__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _util_heading__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../util/heading */ "./lib/util/heading.js");
/* harmony import */ var _material_ui_core__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @material-ui/core */ "webpack/sharing/consume/default/@material-ui/core/@material-ui/core?df94");
/* harmony import */ var _material_ui_core__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_material_ui_core__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _jupyter__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../jupyter */ "./lib/jupyter.js");











class LabelEncoder {
    fit(data) {
        this.labels = [...new Set(data)];
        return this;
    }
    transform(x) {
        return this.labels.indexOf(x);
    }
    inverse(i) {
        return this.labels[i];
    }
}
class PDPComp extends (react__WEBPACK_IMPORTED_MODULE_0___default().Component) {
    constructor(props) {
        super(props);
        this.state = { clazz: undefined };
        this.handleClassChange = this.handleClassChange.bind(this);
        this.exportDataFrame = this.exportDataFrame.bind(this);
    }
    componentDidUpdate(prevProps, prevState, snapshot) {
        if (prevProps.data === undefined && this.props.data !== undefined)
            this.setState({ clazz: this.props.data.keys().next().value });
    }
    handleClassChange(event) {
        this.setState({ clazz: event.target.value });
    }
    exportDataFrame() {
        const { cid, component, feature } = this.props;
        this.context.createCell(`
${_jupyter__WEBPACK_IMPORTED_MODULE_3__.ID}_pdp = gcx().pdp('${cid}', '${component}', ['${feature}'])
${_jupyter__WEBPACK_IMPORTED_MODULE_3__.ID}_pdp
        `.trim());
    }
    renderNumerical(data) {
        const yRange = data.y_range;
        const pdp = data.features.get(this.props.feature);
        return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement(recharts__WEBPACK_IMPORTED_MODULE_1__.ResponsiveContainer, null,
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement(recharts__WEBPACK_IMPORTED_MODULE_1__.LineChart, { data: pdp.avg, margin: { left: 30 } },
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement(recharts__WEBPACK_IMPORTED_MODULE_1__.CartesianGrid, { strokeDasharray: "3 3" }),
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement(recharts__WEBPACK_IMPORTED_MODULE_1__.XAxis, { type: "number", dataKey: "x", label: { value: this.props.feature, dy: 10 }, domain: ['dataMin', 'dataMax'], tickFormatter: _util__WEBPACK_IMPORTED_MODULE_4__.prettyPrint }),
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement(recharts__WEBPACK_IMPORTED_MODULE_1__.YAxis, { type: "number", dataKey: "y", label: { value: `Partial dependence`, angle: -90, dx: -40 }, domain: yRange, tickFormatter: _util__WEBPACK_IMPORTED_MODULE_4__.prettyPrint }),
                pdp.ice.map((points, idx) => (react__WEBPACK_IMPORTED_MODULE_0___default().createElement(recharts__WEBPACK_IMPORTED_MODULE_1__.Line, { key: idx, data: points, type: "monotone", dataKey: "y", stroke: _util__WEBPACK_IMPORTED_MODULE_4__.Colors.DEFAULT, strokeWidth: 1, dot: false }))),
                pdp.avg && react__WEBPACK_IMPORTED_MODULE_0___default().createElement(recharts__WEBPACK_IMPORTED_MODULE_1__.Line, { data: pdp.avg, type: "monotone", dataKey: "y", stroke: _util__WEBPACK_IMPORTED_MODULE_4__.Colors.HIGHLIGHT, strokeWidth: 2, dot: false }))));
    }
    renderCategorical(data) {
        const yRange = data.y_range;
        const pdp = data.features.get(this.props.feature);
        const ice = [].concat(...pdp.ice);
        const avg = pdp.avg;
        const encoder = new LabelEncoder().fit(avg.map(i => i.x));
        return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement(recharts__WEBPACK_IMPORTED_MODULE_1__.ResponsiveContainer, null,
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement(recharts__WEBPACK_IMPORTED_MODULE_1__.ScatterChart, { margin: { left: 30 } },
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement(recharts__WEBPACK_IMPORTED_MODULE_1__.CartesianGrid, { strokeDasharray: "3 3" }),
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement(recharts__WEBPACK_IMPORTED_MODULE_1__.XAxis, { type: "number", dataKey: "x", label: { value: this.props.feature, dy: 10 }, domain: [-0.5, encoder.labels.length - 0.5], ticks: [...Array(encoder.labels.length).keys()].map((_, i) => i), tickFormatter: (i) => encoder.inverse(i) }),
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement(recharts__WEBPACK_IMPORTED_MODULE_1__.YAxis, { type: "number", dataKey: "y", label: { value: `Partial dependence`, angle: -90, dx: -40 }, domain: yRange, tickFormatter: _util__WEBPACK_IMPORTED_MODULE_4__.prettyPrint }),
                ice && react__WEBPACK_IMPORTED_MODULE_0___default().createElement(recharts__WEBPACK_IMPORTED_MODULE_1__.Scatter, { data: ice.map(i => ({ x: encoder.transform(i.x), y: i.y })), fill: _util__WEBPACK_IMPORTED_MODULE_4__.Colors.DEFAULT, radius: 1 }),
                avg && react__WEBPACK_IMPORTED_MODULE_0___default().createElement(recharts__WEBPACK_IMPORTED_MODULE_1__.Scatter, { data: avg.map(i => ({ x: encoder.transform(i.x), y: i.y })), fill: _util__WEBPACK_IMPORTED_MODULE_4__.Colors.HIGHLIGHT, radius: 3 }))));
    }
    render() {
        var _a, _b;
        const { feature } = this.props;
        const data = (_b = (_a = this.props) === null || _a === void 0 ? void 0 : _a.data) === null || _b === void 0 ? void 0 : _b.get(this.state.clazz);
        const pdp = data ? data.features.get(feature) : undefined;
        return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement((react__WEBPACK_IMPORTED_MODULE_0___default().Fragment), null,
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { style: { height: '250px', flexGrow: 1 } },
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_util_loading__WEBPACK_IMPORTED_MODULE_5__.LoadingIndicator, { loading: data === undefined }),
                pdp &&
                    react__WEBPACK_IMPORTED_MODULE_0___default().createElement((react__WEBPACK_IMPORTED_MODULE_0___default().Fragment), null,
                        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { style: { display: "flex", justifyContent: "space-between", marginBottom: '1em' }, className: 'pdp' },
                            react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_util_heading__WEBPACK_IMPORTED_MODULE_6__.Heading, { help: PDPComp.HELP },
                                react__WEBPACK_IMPORTED_MODULE_0___default().createElement("h4", null,
                                    "Partial Dependencies for Feature ",
                                    react__WEBPACK_IMPORTED_MODULE_0___default().createElement("i", null, feature),
                                    " and class\u00A0",
                                    this.props.data.size > 2 ?
                                        react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_material_ui_core__WEBPACK_IMPORTED_MODULE_2__.FormControl, { variant: "standard", size: "small" },
                                            react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_material_ui_core__WEBPACK_IMPORTED_MODULE_2__.Select, { value: this.state.clazz, onChange: this.handleClassChange, style: { marginLeft: '10px', marginRight: '10px' } }, Array.from(this.props.data.keys()).map(clazz => react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_material_ui_core__WEBPACK_IMPORTED_MODULE_2__.MenuItem, { value: clazz }, clazz)))) : react__WEBPACK_IMPORTED_MODULE_0___default().createElement("i", null, this.state.clazz))),
                            react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_util_jupyter_button__WEBPACK_IMPORTED_MODULE_7__.JupyterButton, { onClick: this.exportDataFrame })),
                        typeof pdp.avg[0].x === 'number' && this.renderNumerical(data),
                        typeof pdp.avg[0].x === 'string' && this.renderCategorical(data)))));
    }
}
PDPComp.HELP = 'Partial dependence plots (PDP) and individual conditional expectation (ICE) plots can be ' +
    'used to visualize and analyze interaction between the target class and a input feature of  interest. PDPs ' +
    'are calculated by, marginalizing over the values of all other input features (the ‘complement’ features). ' +
    'Intuitively, you can interpret the partial dependence as the expected target response as a function of the ' +
    'input features of interest.' +
    '\n\n' +
    'Similar to a PDP, an ICE plot shows the dependence between the target function and an input feature of ' +
    'interest. However, unlike a PDP, which shows the average effect of the input feature, an ICE plot ' +
    'visualizes the dependence of the prediction on a feature for each sample separately with one line per ' +
    'sample.' +
    '\n\n' +
    'The PDP line for the selected component is rendered in dark blue while a subset of the ICE lines is ' +
    'rendered in light blue. The x axis contains the possible range of the selected feature while the y axis ' +
    'contains the partial dependence on the target class.';
PDPComp.contextType = _util__WEBPACK_IMPORTED_MODULE_4__.JupyterContext;
class FeatureImportanceComponent extends (react__WEBPACK_IMPORTED_MODULE_0___default().Component) {
    constructor(props) {
        super(props);
        this.state = {
            data: undefined,
            pdp: undefined,
            error: undefined,
            selectedRow: undefined,
            detailsError: undefined
        };
        this.exportDataFrame = this.exportDataFrame.bind(this);
        this.selectRow = this.selectRow.bind(this);
    }
    componentDidMount() {
        window.setTimeout(() => {
            this.queryFeatureImportance().then(() => { var _a; return this.selectRow((_a = this.state) === null || _a === void 0 ? void 0 : _a.data.data.column_names.indexOf(this.props.selectedFeature)); });
        }, 100);
    }
    componentDidUpdate(prevProps, prevState, snapshot) {
        if (prevProps.model.component !== this.props.model.component)
            this.queryFeatureImportance();
        if (prevProps.selectedFeature !== this.props.selectedFeature)
            this.selectRow(this.state.data.data.column_names.indexOf(this.props.selectedFeature));
    }
    queryFeatureImportance() {
        const { candidate, component } = this.props.model;
        if (!component)
            return;
        this.setState({ error: undefined, selectedRow: undefined, pdp: undefined, detailsError: undefined });
        return this.context.requestFeatureImportance(candidate.id, component)
            .then(data => this.setState({ data: data, error: undefined }))
            .catch(error => {
            console.error(`Failed to fetch FeatureImportance data.\n${error.name}: ${error.message}`);
            this.setState({ error: error });
        });
    }
    selectRow(idx) {
        if (idx === undefined)
            return;
        if (idx === -1)
            this.setState({ selectedRow: undefined, pdp: undefined });
        else {
            const feature = this.state.data.data.column_names[idx];
            this.setState({ selectedRow: idx });
            this.queryPDP(feature);
            if (this.props.onFeatureSelection !== undefined && this.props.selectedFeature !== feature)
                this.props.onFeatureSelection(feature);
        }
    }
    queryPDP(feature) {
        this.setState({ pdp: undefined, detailsError: undefined });
        this.context.requestPDP(this.props.model.candidate.id, this.props.model.component, [feature])
            .then(data => this.setState({ pdp: data, detailsError: undefined }))
            .catch(error => {
            console.error(`Failed to fetch FeatureImportance data.\n${error.name}: ${error.message}`);
            this.setState({ detailsError: error });
        });
    }
    exportDataFrame() {
        const { candidate, component } = this.props.model;
        this.context.createCell(`
${_jupyter__WEBPACK_IMPORTED_MODULE_3__.ID}_feature_importance = gcx().feature_importance('${candidate.id}', '${component}')
${_jupyter__WEBPACK_IMPORTED_MODULE_3__.ID}_feature_importance
        `.trim());
    }
    render() {
        const { data, error, selectedRow, pdp, detailsError } = this.state;
        const marginTop = data ? (0,_util__WEBPACK_IMPORTED_MODULE_4__.maxLabelLength)(data.data.column_names) : 0;
        return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement((react__WEBPACK_IMPORTED_MODULE_0___default().Fragment), null,
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_util_error__WEBPACK_IMPORTED_MODULE_8__.ErrorIndicator, { error: error }),
            !error &&
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement((react__WEBPACK_IMPORTED_MODULE_0___default().Fragment), null,
                    react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_util_loading__WEBPACK_IMPORTED_MODULE_5__.LoadingIndicator, { loading: data === undefined }),
                    data && data.data.column_names.length > 0 &&
                        react__WEBPACK_IMPORTED_MODULE_0___default().createElement((react__WEBPACK_IMPORTED_MODULE_0___default().Fragment), null,
                            react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_util_warning__WEBPACK_IMPORTED_MODULE_9__.CommonWarnings, { additionalFeatures: data.additional_features.length > 0 }),
                            react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { style: { display: 'flex' } },
                                react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_util_importance_overview__WEBPACK_IMPORTED_MODULE_10__.ImportanceOverviewComp, { overview: data.data, selectedRow: selectedRow, onExportClick: this.exportDataFrame, onSelectRow: this.selectRow }),
                                react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { style: {
                                        marginLeft: '20px',
                                        flexGrow: 1,
                                        flexShrink: 1,
                                        minWidth: 'auto'
                                    } }, selectedRow === undefined ?
                                    react__WEBPACK_IMPORTED_MODULE_0___default().createElement("p", { style: { marginTop: marginTop } }, "Select a feature on the left side to get a detailed visualization how the different values of this feature correlate with the predicted class.") :
                                    react__WEBPACK_IMPORTED_MODULE_0___default().createElement((react__WEBPACK_IMPORTED_MODULE_0___default().Fragment), null,
                                        react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_util_error__WEBPACK_IMPORTED_MODULE_8__.ErrorIndicator, { error: detailsError }),
                                        detailsError === undefined &&
                                            react__WEBPACK_IMPORTED_MODULE_0___default().createElement(PDPComp, { data: pdp, feature: data.data.column_names[selectedRow], cid: this.props.model.candidate.id, component: this.props.model.component }))))),
                    data && data.data.column_names.length === 0 &&
                        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("p", null, "Feature importance not available for the actual predictions."))));
    }
}
FeatureImportanceComponent.HELP = 'Visualizes the importance of each features. The feature importance is calculated by ' +
    'shuffling a single feature randomly. The permutation feature importance is defined to be the decrease in a ' +
    'model score after shuffling. This procedure breaks the relationship between the feature and the target, ' +
    'thus the drop in the model score is indicative of how much the model depends on the feature.';
FeatureImportanceComponent.contextType = _util__WEBPACK_IMPORTED_MODULE_4__.JupyterContext;


/***/ }),

/***/ "./lib/components/details/global_surrogate.js":
/*!****************************************************!*\
  !*** ./lib/components/details/global_surrogate.js ***!
  \****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "GlobalSurrogateComponent": () => (/* binding */ GlobalSurrogateComponent)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _util_loading__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../util/loading */ "./lib/util/loading.js");
/* harmony import */ var _util_tree_structure__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../util/tree_structure */ "./lib/util/tree_structure.js");
/* harmony import */ var rc_slider__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! rc-slider */ "webpack/sharing/consume/default/rc-slider/rc-slider");
/* harmony import */ var rc_slider__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(rc_slider__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _util_error__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../util/error */ "./lib/util/error.js");
/* harmony import */ var _util_KeyValue__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../util/KeyValue */ "./lib/util/KeyValue.js");
/* harmony import */ var _util_warning__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../../util/warning */ "./lib/util/warning.js");
/* harmony import */ var _util_jupyter_button__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../../util/jupyter-button */ "./lib/util/jupyter-button.js");
/* harmony import */ var _util__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../../util */ "./lib/util.js");
/* harmony import */ var _jupyter__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../jupyter */ "./lib/jupyter.js");










class GlobalSurrogateComponent extends (react__WEBPACK_IMPORTED_MODULE_0___default().Component) {
    constructor(props) {
        super(props);
        this.ticks = [2, 3, 5, 7, 10, 15, 25, 50, 100];
        this.state = { loading: true, data: undefined, dt: undefined, error: undefined };
        this.onMaxLeavesChange = this.onMaxLeavesChange.bind(this);
        this.exportTree = this.exportTree.bind(this);
        this.renderNodes = this.renderNodes.bind(this);
    }
    componentDidMount() {
        this.queryDT();
    }
    componentDidUpdate(prevProps, prevState, snapshot) {
        if (prevProps.model.component !== this.props.model.component)
            this.queryDT();
        if (prevProps.dtIndex !== this.props.dtIndex) {
            const dt = this.state.data.candidates[this.props.dtIndex];
            this.setState({ dt: dt });
        }
    }
    queryDT() {
        const { candidate, component } = this.props.model;
        if (component === undefined)
            return;
        const promise = this.context.requestGlobalSurrogate(candidate.id, component);
        this.setState({ loading: true });
        promise
            .then(data => {
            const idx = this.props.dtIndex !== undefined ? this.props.dtIndex : data.best;
            const dt = data.candidates[idx];
            this.setState({ data: data, dt: dt, loading: false });
        })
            .catch(error => {
            console.error(`Failed to fetch DecisionTreeResult data.\n${error.name}: ${error.message}`);
            this.setState({ error: error, loading: false });
        });
    }
    renderNodes(root) {
        const { additional_features } = this.state.data;
        const renderedNodes = root.descendants().map(node => react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_util_tree_structure__WEBPACK_IMPORTED_MODULE_2__.GraphNode, { node: node, className: `global-surrogate_node ${additional_features.filter(a => node.data.label.startsWith(a))
                .length > 0 ? 'global-surrogate_additional-feature' : ''}`, nodeWidth: GlobalSurrogateComponent.NODE_WIDTH, nodeHeight: GlobalSurrogateComponent.NODE_HEIGHT },
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement("p", { title: node.data.label }, node.data.label),
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_util_KeyValue__WEBPACK_IMPORTED_MODULE_3__.KeyValue, { key_: 'Impurity', value: node.data.impurity })));
        const renderedEdges = root.links().map(link => {
            const edgeLabel = link.source.data.child_labels[link.source.data.children.map(l => `${l.label}-${l.impurity}`)
                .indexOf(`${link.target.data.label}-${link.target.data.impurity}`)];
            return react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_util_tree_structure__WEBPACK_IMPORTED_MODULE_2__.GraphEdge, { link: link, label: edgeLabel, nodeWidth: GlobalSurrogateComponent.NODE_WIDTH, nodeHeight: GlobalSurrogateComponent.NODE_HEIGHT });
        });
        return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement((react__WEBPACK_IMPORTED_MODULE_0___default().Fragment), null,
            renderedEdges,
            renderedNodes));
    }
    onMaxLeavesChange(idx) {
        this.setState({ dt: this.state.data.candidates[idx] });
        if (this.props.onDTIndexChange !== undefined)
            this.props.onDTIndexChange(idx);
    }
    exportTree() {
        const { candidate, component } = this.props.model;
        const { dt } = this.state;
        this.context.createCell(`
${_jupyter__WEBPACK_IMPORTED_MODULE_4__.ID}_dt = gcx().global_surrogate('${candidate.id}', '${component}', ${dt.max_leaf_nodes})
${_jupyter__WEBPACK_IMPORTED_MODULE_4__.ID}_dt
        `.trim());
    }
    render() {
        const { data, dt, loading, error } = this.state;
        const marks = {};
        this.ticks.forEach((v, idx) => marks[idx] = v);
        return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement((react__WEBPACK_IMPORTED_MODULE_0___default().Fragment), null,
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_util_error__WEBPACK_IMPORTED_MODULE_5__.ErrorIndicator, { error: error }),
            !error && react__WEBPACK_IMPORTED_MODULE_0___default().createElement((react__WEBPACK_IMPORTED_MODULE_0___default().Fragment), null,
                data === undefined && react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_util_loading__WEBPACK_IMPORTED_MODULE_6__.LoadingIndicator, { loading: true }),
                (dt === null || dt === void 0 ? void 0 : dt.root) && react__WEBPACK_IMPORTED_MODULE_0___default().createElement((react__WEBPACK_IMPORTED_MODULE_0___default().Fragment), null,
                    react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { style: { display: 'flex' } },
                        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { style: { flexGrow: 1 } },
                            react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { style: {
                                    display: "flex", flexDirection: "column", justifyContent: "space-between"
                                } },
                                react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_util_KeyValue__WEBPACK_IMPORTED_MODULE_3__.KeyValue, { key_: 'Fidelity', value: react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { style: {
                                            backgroundColor: _util__WEBPACK_IMPORTED_MODULE_7__.Colors.DEFAULT,
                                            borderRadius: '5px',
                                            marginLeft: '10px',
                                            padding: '1px',
                                            height: '16px',
                                            width: '200px',
                                            display: 'inline-block'
                                        } },
                                        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { style: {
                                                width: `${dt.fidelity * 100}%`,
                                                height: '100%',
                                                backgroundColor: dt.fidelity < 0.9 ? 'red' : _util__WEBPACK_IMPORTED_MODULE_7__.Colors.HIGHLIGHT,
                                                textAlign: 'center'
                                            } }, (0,_util__WEBPACK_IMPORTED_MODULE_7__.prettyPrint)(dt.fidelity))), help: 'Measure how good the surrogate represents the real model. ' +
                                        'A value of 1 means that the surrogate perfectly resembles the ' +
                                        'model, a value below 0.9 indicates that the model is no good ' +
                                        'surrogate and the number of nodes should be increased.' }),
                                react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_util_KeyValue__WEBPACK_IMPORTED_MODULE_3__.KeyValue, { key_: 'Leave Nodes', value: dt.n_leaves }))),
                        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { style: { padding: '0 10px 1em', flexGrow: 2 } },
                            react__WEBPACK_IMPORTED_MODULE_0___default().createElement("span", null, "Max. Leaf Nodes"),
                            react__WEBPACK_IMPORTED_MODULE_0___default().createElement((rc_slider__WEBPACK_IMPORTED_MODULE_1___default()), { min: 0, max: this.ticks.length - 1, defaultValue: this.ticks.indexOf(dt.max_leaf_nodes), step: null, marks: marks, onChange: this.onMaxLeavesChange })),
                        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { style: { flexGrow: 1, alignSelf: "center" } },
                            react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_util_jupyter_button__WEBPACK_IMPORTED_MODULE_8__.JupyterButton, { style: { float: "right" }, onClick: this.exportTree }))),
                    loading ? react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_util_loading__WEBPACK_IMPORTED_MODULE_6__.LoadingIndicator, { loading: loading }) :
                        react__WEBPACK_IMPORTED_MODULE_0___default().createElement((react__WEBPACK_IMPORTED_MODULE_0___default().Fragment), null,
                            react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_util_warning__WEBPACK_IMPORTED_MODULE_9__.CommonWarnings, { additionalFeatures: data.additional_features.length > 0 }),
                            react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_util_tree_structure__WEBPACK_IMPORTED_MODULE_2__.HierarchicalTree, { nodeHeight: GlobalSurrogateComponent.NODE_HEIGHT, nodeWidth: GlobalSurrogateComponent.NODE_WIDTH, data: dt.root, count: dt.max_leaf_nodes, render: this.renderNodes }))))));
    }
}
GlobalSurrogateComponent.HELP = 'Approximates the pipeline using a global surrogate model. The surrogate model is a ' +
    'decision tree that is trained to approximate the predictions of a black-box model. By adjusting the maximum ' +
    'number of leaves in the decision tree, the fidelity of the surrogate can be weighted against the ' +
    'simplicity of the explanation.';
GlobalSurrogateComponent.contextType = _util__WEBPACK_IMPORTED_MODULE_7__.JupyterContext;
GlobalSurrogateComponent.NODE_HEIGHT = 56;
GlobalSurrogateComponent.NODE_WIDTH = 100;


/***/ }),

/***/ "./lib/components/details/hp_importance.js":
/*!*************************************************!*\
  !*** ./lib/components/details/hp_importance.js ***!
  \*************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "HPImportanceComp": () => (/* binding */ HPImportanceComp)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var d3__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! d3 */ "webpack/sharing/consume/default/d3/d3");
/* harmony import */ var d3__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(d3__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _util__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../util */ "./lib/util.js");
/* harmony import */ var recharts__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! recharts */ "webpack/sharing/consume/default/recharts/recharts");
/* harmony import */ var recharts__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(recharts__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _util_error__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../../util/error */ "./lib/util/error.js");
/* harmony import */ var _util_loading__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../../util/loading */ "./lib/util/loading.js");
/* harmony import */ var _util_recharts__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../util/recharts */ "./lib/util/recharts.js");
/* harmony import */ var _util_importance_overview__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../../util/importance_overview */ "./lib/util/importance_overview.js");
/* harmony import */ var _jupyter__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../jupyter */ "./lib/jupyter.js");
/* harmony import */ var _util_jupyter_button__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../util/jupyter-button */ "./lib/util/jupyter-button.js");










class SingleHP extends (react__WEBPACK_IMPORTED_MODULE_0___default().Component) {
    render() {
        const { data, metric } = this.props;
        let description;
        let plot;
        let additionalData;
        if (data.mode === 'discrete') {
            description = 'On the x axis, the different values of the selected categorical hyperparameter are ' +
                'displayed. For each possible value, the marginal performance is calculated by averaging over all ' +
                'other possible hyperparameter constellations. The according marginal performance is displayed on ' +
                'the y axis.';
            const whiskers = [];
            Object.entries(data.data).forEach(([key, value]) => {
                whiskers.push({ label: key, y: value });
            });
            plot = (react__WEBPACK_IMPORTED_MODULE_0___default().createElement(recharts__WEBPACK_IMPORTED_MODULE_2__.BarChart, { data: whiskers, margin: { left: 30, bottom: 5 } },
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement(recharts__WEBPACK_IMPORTED_MODULE_2__.CartesianGrid, { strokeDasharray: "3 3" }),
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement(recharts__WEBPACK_IMPORTED_MODULE_2__.XAxis, { dataKey: "label", label: { value: data.name[0], dy: 10 } }),
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement(recharts__WEBPACK_IMPORTED_MODULE_2__.YAxis, { label: { value: `Marginal ${metric}`, angle: -90, dx: -40 }, domain: ['auto', 'auto'] }),
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement(recharts__WEBPACK_IMPORTED_MODULE_2__.Tooltip, { content: react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_util_recharts__WEBPACK_IMPORTED_MODULE_3__.MinimalisticTooltip, null) }),
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement(recharts__WEBPACK_IMPORTED_MODULE_2__.Bar, { dataKey: "y", fill: _util__WEBPACK_IMPORTED_MODULE_4__.Colors.DEFAULT })));
        }
        else if (data.mode === 'continuous') {
            if (data.name.length === 1) {
                description = 'On the x axis, the range of the selected numerical hyperparameter is displayed. For 20 ' +
                    'evenly distributed values on this range, the marginal performance is calculated by averaging over ' +
                    'all other possible hyperparameter constellations. The according marginal performance is displayed ' +
                    'on the y axis.';
                plot = (react__WEBPACK_IMPORTED_MODULE_0___default().createElement(recharts__WEBPACK_IMPORTED_MODULE_2__.ComposedChart, { data: data.data, margin: { left: 30, bottom: 5 } },
                    react__WEBPACK_IMPORTED_MODULE_0___default().createElement(recharts__WEBPACK_IMPORTED_MODULE_2__.CartesianGrid, { strokeDasharray: "3 3" }),
                    react__WEBPACK_IMPORTED_MODULE_0___default().createElement(recharts__WEBPACK_IMPORTED_MODULE_2__.XAxis, { dataKey: "x", label: { value: data.name[0], dy: 10 }, type: 'number', domain: ['dataMin', 'dataMax'] }),
                    react__WEBPACK_IMPORTED_MODULE_0___default().createElement(recharts__WEBPACK_IMPORTED_MODULE_2__.YAxis, { label: { value: `Marginal ${metric}`, angle: -90, dx: -40 }, domain: ['auto', 'auto'] }),
                    react__WEBPACK_IMPORTED_MODULE_0___default().createElement(recharts__WEBPACK_IMPORTED_MODULE_2__.Area, { type: "monotone", dataKey: "area", fill: _util__WEBPACK_IMPORTED_MODULE_4__.Colors.DEFAULT, stroke: _util__WEBPACK_IMPORTED_MODULE_4__.Colors.DEFAULT }),
                    react__WEBPACK_IMPORTED_MODULE_0___default().createElement(recharts__WEBPACK_IMPORTED_MODULE_2__.Line, { type: "monotone", dataKey: 'y', stroke: _util__WEBPACK_IMPORTED_MODULE_4__.Colors.HIGHLIGHT, strokeWidth: 2, dot: false })));
            }
            else {
                description = 'On the x axis, the range of the selected numerical hyperparameter is displayed. For ' +
                    'each possible value of the selected numerical hyperparameter, an additional line is plotted. ' +
                    'For each line, 20 evenly distributed values on the numerical range are created and the marginal ' +
                    'performance is calculated by averaging over all other possible hyperparameter constellations. ' +
                    'The according marginal performance is displayed on the y axis.';
                const keys = Object.keys(data.data[0]).filter(k => k !== 'x');
                plot = (react__WEBPACK_IMPORTED_MODULE_0___default().createElement(recharts__WEBPACK_IMPORTED_MODULE_2__.LineChart, { data: data.data, margin: { left: 30 } },
                    react__WEBPACK_IMPORTED_MODULE_0___default().createElement(recharts__WEBPACK_IMPORTED_MODULE_2__.CartesianGrid, { strokeDasharray: "3 3" }),
                    react__WEBPACK_IMPORTED_MODULE_0___default().createElement(recharts__WEBPACK_IMPORTED_MODULE_2__.XAxis, { dataKey: "x", label: { value: data.name[1], dy: 10 }, type: 'number', domain: ['dataMin', 'dataMax'] }),
                    react__WEBPACK_IMPORTED_MODULE_0___default().createElement(recharts__WEBPACK_IMPORTED_MODULE_2__.YAxis, { label: { value: `Marginal ${metric}`, angle: -90, dx: -40 }, domain: ['auto', 'auto'] }),
                    react__WEBPACK_IMPORTED_MODULE_0___default().createElement(recharts__WEBPACK_IMPORTED_MODULE_2__.Legend, null),
                    keys.map((key, idx) => (react__WEBPACK_IMPORTED_MODULE_0___default().createElement(recharts__WEBPACK_IMPORTED_MODULE_2__.Line, { key: key, type: "monotone", name: key, dataKey: key, stroke: _util__WEBPACK_IMPORTED_MODULE_4__.Colors.getColor(idx), strokeWidth: 2, dot: false })))));
            }
        }
        else if (data.mode === 'heatmap') {
            description = 'On the x axis, the range of the first selected numerical hyperparameter and on the ' +
                'y axis the range of the second selected numerical hyperparameter is displayed. For both ' +
                'hyperparameters, 20 evenly distributed values are created and the marginal performance of each ' +
                'possible combination of those 20 points is calculated by averaging over all other possible ' +
                'hyperparameter constellations. The according marginal performance is displayed using a color ' +
                'scale. The range of the color scale is displayed above the heat map.';
            const rows = Object.keys(data.data);
            const columns = Object.keys(data.data[rows[0]]);
            const values = Object.values(data.data)
                .map(d => Object.values(d)).reduce((a, b) => a.concat(b), []);
            const min = Math.min(...values);
            const max = Math.max(...values);
            const scale = d3__WEBPACK_IMPORTED_MODULE_1__.scaleSequential(d3__WEBPACK_IMPORTED_MODULE_1__.interpolateSpectral)
                .domain([min, max]);
            const marginLeft = columns.map(r => r.length).reduce((a, b) => Math.max(a, b), 0) * 5;
            plot = (react__WEBPACK_IMPORTED_MODULE_0___default().createElement(recharts__WEBPACK_IMPORTED_MODULE_2__.LineChart, { margin: { left: marginLeft, bottom: 5 } },
                this.generateHeatMap(columns, rows).map(sector => (react__WEBPACK_IMPORTED_MODULE_0___default().createElement(recharts__WEBPACK_IMPORTED_MODULE_2__.ReferenceArea, { key: `${sector.x1}_${sector.y1}`, x1: sector.x1, x2: sector.x2, y1: sector.y1, y2: sector.y2, fill: scale(data.data[sector.row][sector.column]), fillOpacity: 1, stroke: "white", strokeOpacity: 0 }))),
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement(recharts__WEBPACK_IMPORTED_MODULE_2__.XAxis, { type: "number", dataKey: "x", domain: [0, rows.length], ticks: [...Array(rows.length).keys()].map((_, i) => i + 0.5), interval: 0, tickFormatter: x => (0,_util__WEBPACK_IMPORTED_MODULE_4__.prettyPrint)(rows[x - 0.5], 2), label: { value: data.name[1], dy: 10 } }),
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement(recharts__WEBPACK_IMPORTED_MODULE_2__.YAxis, { type: "number", dataKey: "y", domain: [0, columns.length], ticks: [...Array(columns.length).keys()].map((_, i) => i + 0.5), interval: 0, tickFormatter: y => (0,_util__WEBPACK_IMPORTED_MODULE_4__.prettyPrint)(columns[y - 0.5], 2), label: { value: data.name[0], angle: -90, dx: -marginLeft - 20 } }),
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement(recharts__WEBPACK_IMPORTED_MODULE_2__.Tooltip, { cursor: { strokeDasharray: '3 3' } })));
            additionalData = (react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_util_recharts__WEBPACK_IMPORTED_MODULE_3__.Heatbar, { scale: scale, marginLeft: marginLeft, label: metric }));
        }
        return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", null,
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { style: { display: "flex", alignItems: "end" } },
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", null,
                    react__WEBPACK_IMPORTED_MODULE_0___default().createElement("p", null, description),
                    react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_util_jupyter_button__WEBPACK_IMPORTED_MODULE_5__.JupyterButton, { onClick: this.props.onExportClick }))),
            additionalData && additionalData,
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { style: { height: '250px', width: '100%' } },
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement(recharts__WEBPACK_IMPORTED_MODULE_2__.ResponsiveContainer, null, plot))));
    }
    generateHeatMap(columns, rows) {
        return rows.map((r, i) => columns.map((c, j) => ({
            row: r,
            column: c,
            x1: i + 0.01,
            x2: i + 0.99,
            y1: j + 0.01,
            y2: j + 0.99
        }))).reduce((a, b) => a.concat(b), []);
    }
}
class HPImportanceComp extends (react__WEBPACK_IMPORTED_MODULE_0___default().Component) {
    constructor(props) {
        super(props);
        this.state = { overview: undefined, details: undefined, error: undefined, selectedRow: undefined };
        this.selectRow = this.selectRow.bind(this);
        this.exportOverview = this.exportOverview.bind(this);
        this.exportDetails = this.exportDetails.bind(this);
    }
    componentDidMount() {
        window.setTimeout(() => this.queryHPImportance()
            .then(() => this.selectRow(this.state.overview.keys
            .findIndex(k => k[0] === this.props.selectedHp1 && k[1] === this.props.selectedHp2))), 100);
    }
    componentDidUpdate(prevProps, prevState, snapshot) {
        if (prevProps.model.component !== this.props.model.component)
            this.queryHPImportance();
        if (prevProps.selectedHp1 !== this.props.selectedHp1 || prevProps.selectedHp2 !== this.props.selectedHp2)
            this.selectRow(this.state.overview.keys
                .findIndex(k => k[0] === this.props.selectedHp1 && k[1] === this.props.selectedHp2));
    }
    queryHPImportance() {
        const { model } = this.props;
        this.setState({ error: undefined, overview: undefined, selectedRow: undefined, details: undefined });
        return this.context.requestFANOVA(model.structure.cid, model.component)
            .then(resp => {
            if (resp.error)
                this.setState({ error: new Error(resp.error) });
            else
                this.setState({ overview: resp.overview });
        })
            .catch(error => {
            console.error(`Failed to fetch HPImportance data.\n${error.name}: ${error.message}`);
            this.setState({ error: error });
        });
    }
    selectRow(idx) {
        if (idx === -1) {
            this.setState({ selectedRow: undefined, details: undefined });
            return;
        }
        const { model } = this.props;
        this.setState({ selectedRow: idx, details: undefined });
        const [hp1, hp2] = this.state.overview.keys[idx];
        this.context.requestFANOVADetails(model.structure.cid, model.component, [hp1, hp2])
            .then(resp => {
            if (resp.error)
                this.setState({ error: new Error(resp.error) });
            else
                this.setState({ details: resp.details });
        })
            .catch(error => {
            console.error(`Failed to fetch HPImportance data.\n${error.name}: ${error.message}`);
            this.setState({ error: error });
        });
        if (this.props.onHpChange !== undefined && (this.props.selectedHp1 !== hp1 || this.props.selectedHp2 !== hp2))
            this.props.onHpChange(hp1, hp2);
    }
    getDetails(selectedRow) {
        var _a;
        if (selectedRow === undefined)
            return undefined;
        const [hp0, hp1] = this.state.overview.keys[selectedRow];
        return (_a = this.state.details.get(hp0)) === null || _a === void 0 ? void 0 : _a.get(hp1);
    }
    exportOverview() {
        const { model } = this.props;
        this.context.createCell(`
${_jupyter__WEBPACK_IMPORTED_MODULE_6__.ID}_hp_importance = gcx().hp_importance('${model.structure.cid}', '${model.component}')
${_jupyter__WEBPACK_IMPORTED_MODULE_6__.ID}_hp_importance
        `.trim());
    }
    exportDetails() {
        const { model } = this.props;
        const [hp1, hp2] = this.state.overview.keys[this.state.selectedRow];
        this.context.createCell(`
${_jupyter__WEBPACK_IMPORTED_MODULE_6__.ID}_hp_interactions = gcx().hp_interactions('${model.structure.cid}', '${model.component}', '${hp1}', '${hp2}')
${_jupyter__WEBPACK_IMPORTED_MODULE_6__.ID}_hp_interactions
        `.trim());
    }
    render() {
        const { error, overview, selectedRow } = this.state;
        const marginTop = (overview === null || overview === void 0 ? void 0 : overview.column_names) ? (0,_util__WEBPACK_IMPORTED_MODULE_4__.maxLabelLength)(overview.column_names) : 0;
        return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement((react__WEBPACK_IMPORTED_MODULE_0___default().Fragment), null,
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_util_error__WEBPACK_IMPORTED_MODULE_7__.ErrorIndicator, { error: error }),
            !error && react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { style: { display: 'flex' } },
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_util_loading__WEBPACK_IMPORTED_MODULE_8__.LoadingIndicator, { loading: overview === undefined }),
                (overview === null || overview === void 0 ? void 0 : overview.keys.length) === 0 && react__WEBPACK_IMPORTED_MODULE_0___default().createElement("p", null, "The selected component does not have any hyperparameters. "),
                (overview === null || overview === void 0 ? void 0 : overview.keys.length) > 0 && react__WEBPACK_IMPORTED_MODULE_0___default().createElement((react__WEBPACK_IMPORTED_MODULE_0___default().Fragment), null,
                    react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_util_importance_overview__WEBPACK_IMPORTED_MODULE_9__.ImportanceOverviewComp, { overview: overview, selectedRow: selectedRow, onExportClick: this.exportOverview, onSelectRow: this.selectRow }),
                    react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { style: {
                            marginLeft: '20px',
                            flexGrow: 1,
                            flexShrink: 1,
                            minWidth: 'auto'
                        } }, selectedRow === undefined ?
                        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("p", { style: { marginTop: marginTop } }, "Select a hyperparameter (pair) on the left side to get a detailed visualization of the correlation of the selected hyperparameter (pairs) in combination with the marginal performance.") :
                        react__WEBPACK_IMPORTED_MODULE_0___default().createElement((react__WEBPACK_IMPORTED_MODULE_0___default().Fragment), null,
                            react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_util_loading__WEBPACK_IMPORTED_MODULE_8__.LoadingIndicator, { loading: this.state.details === undefined }),
                            this.state.details && react__WEBPACK_IMPORTED_MODULE_0___default().createElement(SingleHP, { data: this.getDetails(selectedRow), metric: this.props.metric, onExportClick: this.exportDetails })))))));
    }
}
HPImportanceComp.HELP = 'Visualizes the impact of each hyperparameter (pair) on the marginal performance. This ' +
    'allows the identification of hyperparameters with a large impact on the performance of the pipeline. ' +
    'Additionally, hyperparameter regions having a high correlation with a good performance can be identified. ' +
    'By selecting a single step in the structure graph above, only the hyperparameters of the selected step are ' +
    'shown. To view the overall most important hyperparameters, select either the pipeline source or sink.';
HPImportanceComp.contextType = _util__WEBPACK_IMPORTED_MODULE_4__.JupyterContext;


/***/ }),

/***/ "./lib/components/details/local_surrogate.js":
/*!***************************************************!*\
  !*** ./lib/components/details/local_surrogate.js ***!
  \***************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "LocalSurrogateComponent": () => (/* binding */ LocalSurrogateComponent)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _util__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../util */ "./lib/util.js");
/* harmony import */ var _util_loading__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../../util/loading */ "./lib/util/loading.js");
/* harmony import */ var _util_error__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../util/error */ "./lib/util/error.js");
/* harmony import */ var _util_collapse__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../../util/collapse */ "./lib/util/collapse.js");
/* harmony import */ var _util_warning__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../../util/warning */ "./lib/util/warning.js");
/* harmony import */ var recharts__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! recharts */ "webpack/sharing/consume/default/recharts/recharts");
/* harmony import */ var recharts__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(recharts__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var resize_observer_polyfill__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! resize-observer-polyfill */ "./node_modules/resize-observer-polyfill/dist/ResizeObserver.es.js");
/* harmony import */ var _util_recharts__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../../util/recharts */ "./lib/util/recharts.js");
/* harmony import */ var _material_ui_icons__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @material-ui/icons */ "webpack/sharing/consume/default/@material-ui/icons/@material-ui/icons");
/* harmony import */ var _material_ui_icons__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_material_ui_icons__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _material_ui_core__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @material-ui/core */ "webpack/sharing/consume/default/@material-ui/core/@material-ui/core?df94");
/* harmony import */ var _material_ui_core__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(_material_ui_core__WEBPACK_IMPORTED_MODULE_4__);











class CustomizedTick extends (react__WEBPACK_IMPORTED_MODULE_0___default().PureComponent) {
    render() {
        const { x, y, payload, additionalFeatures } = this.props;
        const isAdditional = additionalFeatures.filter((a) => payload.value.startsWith(a)).length > 0 ||
            additionalFeatures.filter((a) => payload.value.includes(` ${a} `)).length > 0;
        return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement("text", { x: x, y: y, dy: 0, textAnchor: "end", fill: isAdditional ? _util__WEBPACK_IMPORTED_MODULE_5__.Colors.ADDITIONAL_FEATURE : _util__WEBPACK_IMPORTED_MODULE_5__.Colors.SELECTED_FEATURE },
            payload.value.toLocaleString().replace(/ /g, '\u00A0'),
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement("title", null, payload.value.toLocaleString())));
    }
}
class LocalSurrogateComponent extends (react__WEBPACK_IMPORTED_MODULE_0___default().Component) {
    constructor(props) {
        super(props);
        this.container = react__WEBPACK_IMPORTED_MODULE_0___default().createRef();
        this.state = {
            selectedLabel: undefined,
            loading: false,
            data: undefined,
            error: undefined,
            x1: undefined,
            x2: undefined
        };
        this.onLabelClick = this.onLabelClick.bind(this);
        this.onTickClick = this.onTickClick.bind(this);
    }
    componentDidMount() {
        if (this.props.model.selectedSample !== undefined)
            this.queryLime(this.props.model.selectedSample);
    }
    componentDidUpdate(prevProps, prevState, snapshot) {
        if (prevProps.model.component !== this.props.model.component ||
            prevProps.model.selectedSample !== this.props.model.selectedSample)
            this.queryLime(this.props.model.selectedSample);
        if (prevProps.selectedLabel !== this.props.selectedLabel)
            this.setState({ selectedLabel: this.props.selectedLabel });
        if (this.container.current && this.resizeObserver === undefined) {
            this.resizeObserver = new resize_observer_polyfill__WEBPACK_IMPORTED_MODULE_2__["default"](() => {
                this.container.current.querySelectorAll('.recharts-cartesian-axis-line')
                    .forEach(e => {
                    const x1 = e.x1.animVal.value;
                    const x2 = e.x2.animVal.value;
                    if (x1 !== x2)
                        this.setState({ x1: x1, x2: x2 });
                });
            });
            this.resizeObserver.observe(this.container.current);
        }
    }
    componentWillUnmount() {
        var _a;
        (_a = this.resizeObserver) === null || _a === void 0 ? void 0 : _a.disconnect();
    }
    queryLime(idx) {
        const { candidate, component } = this.props.model;
        if (component === undefined || idx === undefined)
            return;
        const promise = this.context.requestLimeSurrogate(candidate.id, idx, component);
        this.setState({ loading: true, data: undefined, selectedLabel: undefined, error: undefined });
        promise
            .then(data => this.setState({ loading: false, data: data, selectedLabel: data.label }))
            .catch(error => {
            console.error(`Failed to fetch LimeResult data.\n${error.name}: ${error.message}`);
            this.setState({ error: error, loading: undefined });
        });
    }
    onLabelClick(point) {
        this.setState({ selectedLabel: point.label });
        if (this.props.onLabelChange !== undefined)
            this.props.onLabelChange(point.label);
    }
    onTickClick(e) {
        // @ts-ignore
        this.setState({ selectedLabel: e.value });
    }
    render() {
        var _a, _b;
        const { selectedSample } = this.props.model;
        const { selectedLabel, data, loading, error } = this.state;
        const probs = [];
        data === null || data === void 0 ? void 0 : data.prob.forEach((p, label) => probs.push({ label: label, y: p }));
        let maxLabelLength = 0;
        const expl = (_a = data === null || data === void 0 ? void 0 : data.expl.get(selectedLabel.toString())) === null || _a === void 0 ? void 0 : _a.map(([label, score]) => {
            maxLabelLength = Math.max(maxLabelLength, label.length * 5);
            return { x: score, label: label };
        });
        maxLabelLength = Math.min(this.props.orientation === 'vertical' ? 150 : 500, maxLabelLength);
        const explHeight = ((_b = data === null || data === void 0 ? void 0 : data.expl.get(selectedLabel.toString())) === null || _b === void 0 ? void 0 : _b.length) * 30;
        return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: `lime ${this.props.orientation}` },
            this.props.orientation === 'vertical' &&
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { style: { display: "flex", justifyContent: "space-between" } },
                    react__WEBPACK_IMPORTED_MODULE_0___default().createElement("h3", null, "Local Surrogate"),
                    this.props.onComparisonRequest && selectedSample !== undefined &&
                        react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_material_ui_core__WEBPACK_IMPORTED_MODULE_4__.IconButton, { style: { flexShrink: 1, maxHeight: '24px' }, size: 'small', title: 'Compare With Selected Candidates', onClick: () => this.props.onComparisonRequest('lime') },
                            react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_material_ui_icons__WEBPACK_IMPORTED_MODULE_3__.CompareArrows, null))),
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_util_error__WEBPACK_IMPORTED_MODULE_6__.ErrorIndicator, { error: error }),
            !error && react__WEBPACK_IMPORTED_MODULE_0___default().createElement((react__WEBPACK_IMPORTED_MODULE_0___default().Fragment), null,
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_util_loading__WEBPACK_IMPORTED_MODULE_7__.LoadingIndicator, { loading: loading }),
                (!loading && selectedSample === undefined) &&
                    react__WEBPACK_IMPORTED_MODULE_0___default().createElement((react__WEBPACK_IMPORTED_MODULE_0___default().Fragment), null,
                        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("p", null, "Select a data set sample to calculate a local model surrogate (LIME)."),
                        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("p", null, "LIME, the acronym for local interpretable model-agnostic explanations, is a technique that approximates any black box machine learning model with a local, interpretable model to explain each individual prediction. The algorithm perturbs the original data points, feeds them into the black box model, and then observes the corresponding outputs. The method then weighs those new data points as a function of their proximity to the original point. Ultimately, it fits a linear regression on the dataset with variations using those sample weights.")),
                (data === null || data === void 0 ? void 0 : data.categorical_input) && react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_util_error__WEBPACK_IMPORTED_MODULE_6__.ErrorIndicator, { error: {
                        name: "Calculation Failed",
                        message: 'Calculation of LIME failed, probably due to categorical input. If the selected data frame ' +
                            'contains any categorical features, please select a later stage in the pipeline after imputation ' +
                            'being applied. See the <a class="hyperlink" ' +
                            'href="https://marcotcr.github.io/lime/tutorials/Tutorial%20-%20continuous%20and%20categorical%20features.html">LIME ' +
                            'documentation</a> for more information.'
                    } }),
                !(data === null || data === void 0 ? void 0 : data.categorical_input) && (data === null || data === void 0 ? void 0 : data.expl.size) === 0 && react__WEBPACK_IMPORTED_MODULE_0___default().createElement("p", null, "LIME explanations are not available for the actual predictions."),
                (data === null || data === void 0 ? void 0 : data.expl.size) > 0 && react__WEBPACK_IMPORTED_MODULE_0___default().createElement((react__WEBPACK_IMPORTED_MODULE_0___default().Fragment), null,
                    react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: 'lime_plot' },
                        react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_util_warning__WEBPACK_IMPORTED_MODULE_8__.CommonWarnings, { additionalFeatures: data.additional_features.length > 0 }),
                        react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_util_collapse__WEBPACK_IMPORTED_MODULE_9__.CollapseComp, { name: 'lime-classes', showInitial: true, help: 'In this plot you can see the predicted class probabilities of the model ' +
                                'for all available classes. The probabilities range between 0 (the model is' +
                                'certain that this is not the correct class) to 1 (the model is certain ' +
                                'that this is the correct class). If the model is uncertain about the ' +
                                'correct class, two or more classes have roughly the same probabilities.' +
                                '\n\n' +
                                'The actual correct class is given above the plot.' },
                            react__WEBPACK_IMPORTED_MODULE_0___default().createElement("h4", null, "Predicted Class Probabilities"),
                            react__WEBPACK_IMPORTED_MODULE_0___default().createElement((react__WEBPACK_IMPORTED_MODULE_0___default().Fragment), null,
                                react__WEBPACK_IMPORTED_MODULE_0___default().createElement("p", null,
                                    "Correct Class: ",
                                    data.label),
                                react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { style: { height: 100 } },
                                    react__WEBPACK_IMPORTED_MODULE_0___default().createElement(recharts__WEBPACK_IMPORTED_MODULE_1__.ResponsiveContainer, null,
                                        react__WEBPACK_IMPORTED_MODULE_0___default().createElement(recharts__WEBPACK_IMPORTED_MODULE_1__.BarChart, { data: probs },
                                            react__WEBPACK_IMPORTED_MODULE_0___default().createElement(recharts__WEBPACK_IMPORTED_MODULE_1__.CartesianGrid, { strokeDasharray: "3 3" }),
                                            react__WEBPACK_IMPORTED_MODULE_0___default().createElement(recharts__WEBPACK_IMPORTED_MODULE_1__.XAxis, { dataKey: "label", type: "category", onClick: this.onTickClick, className: 'selectable-ticks' }),
                                            react__WEBPACK_IMPORTED_MODULE_0___default().createElement(recharts__WEBPACK_IMPORTED_MODULE_1__.YAxis, null),
                                            react__WEBPACK_IMPORTED_MODULE_0___default().createElement(recharts__WEBPACK_IMPORTED_MODULE_1__.Bar, { dataKey: "y", fill: _util__WEBPACK_IMPORTED_MODULE_5__.Colors.DEFAULT, onClick: this.onLabelClick, className: 'lime-class' }, probs.map((d, index) => (react__WEBPACK_IMPORTED_MODULE_0___default().createElement(recharts__WEBPACK_IMPORTED_MODULE_1__.Cell, { key: `cell-${index}`, fill: selectedLabel === d.label ? _util__WEBPACK_IMPORTED_MODULE_5__.Colors.HIGHLIGHT : _util__WEBPACK_IMPORTED_MODULE_5__.Colors.DEFAULT })))))))))),
                    react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: 'lime_plot' },
                        react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_util_collapse__WEBPACK_IMPORTED_MODULE_9__.CollapseComp, { name: 'lime-explanations', showInitial: true, help: 'This plots contains the most important factors influencing the ' +
                                'prediction of the selected sample. In each row, a true statement about ' +
                                'the selected sample is given. The according plot on the right side ' +
                                'indicates how this statement changes the prediction probability. Values' +
                                'smaller than zero are an argument against the selected class, values ' +
                                'larger than zero for the selected class.' +
                                '\n\n' +
                                'To switch the class, you can chose any class in the plot above by ' +
                                'clicking the x axis ticks or box plots. The currently selected class is ' +
                                'displayed above the plot.' },
                            react__WEBPACK_IMPORTED_MODULE_0___default().createElement("h4", null,
                                "Explanations for Class ",
                                selectedLabel),
                            react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { style: { height: explHeight, overflow: "hidden" }, ref: this.container },
                                react__WEBPACK_IMPORTED_MODULE_0___default().createElement(recharts__WEBPACK_IMPORTED_MODULE_1__.ResponsiveContainer, null,
                                    react__WEBPACK_IMPORTED_MODULE_0___default().createElement(recharts__WEBPACK_IMPORTED_MODULE_1__.BarChart, { data: expl, layout: 'vertical', margin: { left: maxLabelLength, top: 20, right: 0, bottom: 0 } },
                                        react__WEBPACK_IMPORTED_MODULE_0___default().createElement(recharts__WEBPACK_IMPORTED_MODULE_1__.CartesianGrid, { strokeDasharray: "3 3" }),
                                        react__WEBPACK_IMPORTED_MODULE_0___default().createElement(recharts__WEBPACK_IMPORTED_MODULE_1__.XAxis, { type: 'number' }),
                                        react__WEBPACK_IMPORTED_MODULE_0___default().createElement(recharts__WEBPACK_IMPORTED_MODULE_1__.YAxis, { dataKey: "label", type: "category", interval: 0, tick: react__WEBPACK_IMPORTED_MODULE_0___default().createElement(CustomizedTick, { additionalFeatures: data.additional_features }) }),
                                        react__WEBPACK_IMPORTED_MODULE_0___default().createElement(recharts__WEBPACK_IMPORTED_MODULE_1__.Tooltip, { content: react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_util_recharts__WEBPACK_IMPORTED_MODULE_10__.MinimalisticTooltip, null) }),
                                        react__WEBPACK_IMPORTED_MODULE_0___default().createElement(recharts__WEBPACK_IMPORTED_MODULE_1__.Bar, { dataKey: "x", fill: _util__WEBPACK_IMPORTED_MODULE_5__.Colors.DEFAULT, className: 'lime-explanation' }),
                                        this.state.x1 &&
                                            react__WEBPACK_IMPORTED_MODULE_0___default().createElement("text", { x: this.state.x1, y: 15 }, `Not ${selectedLabel}`),
                                        this.state.x2 &&
                                            react__WEBPACK_IMPORTED_MODULE_0___default().createElement("text", { x: this.state.x2, textAnchor: "end", y: 15 }, selectedLabel.toString()),
                                        react__WEBPACK_IMPORTED_MODULE_0___default().createElement(recharts__WEBPACK_IMPORTED_MODULE_1__.ReferenceLine, { x: "0", stroke: "#666666" }))))))))));
    }
}
LocalSurrogateComponent.contextType = _util__WEBPACK_IMPORTED_MODULE_5__.JupyterContext;


/***/ }),

/***/ "./lib/components/details/model.js":
/*!*****************************************!*\
  !*** ./lib/components/details/model.js ***!
  \*****************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "DetailsModel": () => (/* binding */ DetailsModel)
/* harmony export */ });
class DetailsModel {
    constructor(structure, candidate, component, algorithm, selectedSample) {
        this.structure = structure;
        this.candidate = candidate;
        this.component = component;
        this.algorithm = algorithm;
        this.selectedSample = selectedSample;
    }
}


/***/ }),

/***/ "./lib/components/details/performance_details.js":
/*!*******************************************************!*\
  !*** ./lib/components/details/performance_details.js ***!
  \*******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "PerformanceDetailsComponent": () => (/* binding */ PerformanceDetailsComponent)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _util_KeyValue__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../util/KeyValue */ "./lib/util/KeyValue.js");
/* harmony import */ var _util__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../../util */ "./lib/util.js");
/* harmony import */ var _confusion_matrix__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./confusion_matrix */ "./lib/components/details/confusion_matrix.js");
/* harmony import */ var _general_roc_curve__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../general/roc_curve */ "./lib/components/general/roc_curve.js");
/* harmony import */ var _util_error__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../util/error */ "./lib/util/error.js");
/* harmony import */ var _util_loading__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../util/loading */ "./lib/util/loading.js");
/* harmony import */ var _material_ui_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @material-ui/core */ "webpack/sharing/consume/default/@material-ui/core/@material-ui/core?df94");
/* harmony import */ var _material_ui_core__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_material_ui_core__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _util_heading__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../util/heading */ "./lib/util/heading.js");
/* harmony import */ var _util_jupyter_button__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../../util/jupyter-button */ "./lib/util/jupyter-button.js");
/* harmony import */ var _jupyter__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../jupyter */ "./lib/jupyter.js");











class PerformanceDetailsComponent extends (react__WEBPACK_IMPORTED_MODULE_0___default().Component) {
    constructor(props) {
        super(props);
        this.state = { data: undefined, loading: false, error: undefined };
        this.exportConfusionMatrix = this.exportConfusionMatrix.bind(this);
        this.exportClassReport = this.exportClassReport.bind(this);
    }
    componentDidMount() {
        this.queryPerformanceData();
    }
    queryPerformanceData() {
        if (this.state.loading)
            return;
        const { model } = this.props;
        this.setState({ loading: true });
        this.context.requestPerformanceData(model.candidate.id)
            .then(data => this.setState({ data: data, loading: false }))
            .catch(error => {
            console.error(`Failed to fetch confusion matrix: \n${error.name}: ${error.message}`);
            this.setState({ error: error, loading: false });
        });
    }
    exportClassReport() {
        this.context.createCell(`
${_jupyter__WEBPACK_IMPORTED_MODULE_2__.ID}_report = gcx().class_report('${this.props.model.candidate.id}')
${_jupyter__WEBPACK_IMPORTED_MODULE_2__.ID}_report
        `.trim());
    }
    exportConfusionMatrix() {
        this.context.createCell(`
${_jupyter__WEBPACK_IMPORTED_MODULE_2__.ID}_cm = gcx().confusion_matrix('${this.props.model.candidate.id}')
${_jupyter__WEBPACK_IMPORTED_MODULE_2__.ID}_cm
        `.trim());
    }
    render() {
        const { model, meta } = this.props;
        const { data, loading, error } = this.state;
        return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement((react__WEBPACK_IMPORTED_MODULE_0___default().Fragment), null,
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_util_error__WEBPACK_IMPORTED_MODULE_3__.ErrorIndicator, { error: error }),
            !error && react__WEBPACK_IMPORTED_MODULE_0___default().createElement((react__WEBPACK_IMPORTED_MODULE_0___default().Fragment), null,
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_util_loading__WEBPACK_IMPORTED_MODULE_4__.LoadingIndicator, { loading: loading }),
                data &&
                    react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: 'performance-wrapper' },
                        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { style: { flexGrow: 0, flexShrink: 1, } },
                            react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_util_heading__WEBPACK_IMPORTED_MODULE_5__.Heading, { help: 'Displays the training and validation performance in addition with the' +
                                    'validation accuracy. Furthermore, the training duration and time for creating' +
                                    'predictions using this model are displayed.' },
                                react__WEBPACK_IMPORTED_MODULE_0___default().createElement("h4", null, "Metrics")),
                            react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_util_KeyValue__WEBPACK_IMPORTED_MODULE_6__.KeyValue, { key_: `Training ${meta.metric}`, value: model.candidate.loss, prec: 4 }),
                            react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_util_KeyValue__WEBPACK_IMPORTED_MODULE_6__.KeyValue, { key_: `Validation ${meta.metric}`, value: data.val_score, prec: 4 }),
                            meta.metric !== 'accuracy' &&
                                react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_util_KeyValue__WEBPACK_IMPORTED_MODULE_6__.KeyValue, { key_: `Validation Accuracy`, value: data.accuracy, prec: 4 }),
                            react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_util_KeyValue__WEBPACK_IMPORTED_MODULE_6__.KeyValue, { key_: 'Training Duration', value: `${(0,_util__WEBPACK_IMPORTED_MODULE_7__.prettyPrint)(model.candidate.runtime.training_time)} sec` }),
                            react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_util_KeyValue__WEBPACK_IMPORTED_MODULE_6__.KeyValue, { key_: 'Prediction Duration', value: `${(0,_util__WEBPACK_IMPORTED_MODULE_7__.prettyPrint)(data.duration)} sec` }),
                            react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_util_KeyValue__WEBPACK_IMPORTED_MODULE_6__.KeyValue, { key_: 'Budget', value: model.candidate.budget })),
                        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: 'flex-column', style: { flexGrow: 0, margin: "0 10px" } },
                            react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_util_heading__WEBPACK_IMPORTED_MODULE_5__.Heading, { help: 'For each possible class, relevance metrics are displayed. Precision ' +
                                    '(also called positive predictive value) is the fraction of relevant instances ' +
                                    'among the retrieved instances, while recall (also known as sensitivity) is the ' +
                                    'fraction of relevant instances that were retrieved. Support is the number of ' +
                                    'total items in the respective class.' },
                                react__WEBPACK_IMPORTED_MODULE_0___default().createElement("h4", null, "Class Report")),
                            react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_material_ui_core__WEBPACK_IMPORTED_MODULE_1__.Table, { className: 'jp-RenderedHTMLCommon' },
                                react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_material_ui_core__WEBPACK_IMPORTED_MODULE_1__.TableBody, null,
                                    react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_material_ui_core__WEBPACK_IMPORTED_MODULE_1__.TableRow, null,
                                        react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_material_ui_core__WEBPACK_IMPORTED_MODULE_1__.TableCell, { component: "th" }),
                                        react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_material_ui_core__WEBPACK_IMPORTED_MODULE_1__.TableCell, { component: "th", scope: "row" }, "Precision"),
                                        react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_material_ui_core__WEBPACK_IMPORTED_MODULE_1__.TableCell, { component: "th", scope: "row" }, "Recall"),
                                        react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_material_ui_core__WEBPACK_IMPORTED_MODULE_1__.TableCell, { component: "th", scope: "row" }, "Support")),
                                    Array.from(data.report.keys()).map(clazz => react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_material_ui_core__WEBPACK_IMPORTED_MODULE_1__.TableRow, { key: clazz },
                                        react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_material_ui_core__WEBPACK_IMPORTED_MODULE_1__.TableCell, { component: "th", scope: "col" }, clazz),
                                        react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_material_ui_core__WEBPACK_IMPORTED_MODULE_1__.TableCell, null, (0,_util__WEBPACK_IMPORTED_MODULE_7__.prettyPrint)(data.report.get(clazz).precision)),
                                        react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_material_ui_core__WEBPACK_IMPORTED_MODULE_1__.TableCell, null, (0,_util__WEBPACK_IMPORTED_MODULE_7__.prettyPrint)(data.report.get(clazz).recall)),
                                        react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_material_ui_core__WEBPACK_IMPORTED_MODULE_1__.TableCell, null, (0,_util__WEBPACK_IMPORTED_MODULE_7__.prettyPrint)(data.report.get(clazz).support)))))),
                            react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_util_jupyter_button__WEBPACK_IMPORTED_MODULE_8__.JupyterButton, { onClick: this.exportClassReport })),
                        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: 'flex-column', style: { flexGrow: 0, margin: "0 10px" } },
                            react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_util_heading__WEBPACK_IMPORTED_MODULE_5__.Heading, { help: 'A confusion matrix is a table layout that allows visualization of ' +
                                    'the performance of a classifier. Each row of the matrix represents the ' +
                                    'instances in an actual class while each column represents the instances in a ' +
                                    'predicted class.' },
                                react__WEBPACK_IMPORTED_MODULE_0___default().createElement("h4", null, "Confusion Matrix")),
                            react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_confusion_matrix__WEBPACK_IMPORTED_MODULE_9__.ConfusionMatrix, { cm: data.cm }),
                            react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_util_jupyter_button__WEBPACK_IMPORTED_MODULE_8__.JupyterButton, { onClick: this.exportConfusionMatrix })),
                        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { style: { flexGrow: 0, flexBasis: "25%" } },
                            react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_util_heading__WEBPACK_IMPORTED_MODULE_5__.Heading, { help: _general_roc_curve__WEBPACK_IMPORTED_MODULE_10__.RocCurve.HELP },
                                react__WEBPACK_IMPORTED_MODULE_0___default().createElement("h4", null, "Receiver Operating Characteristic (ROC) Curve")),
                            react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_general_roc_curve__WEBPACK_IMPORTED_MODULE_10__.RocCurve, { selectedCandidates: new Set([model.candidate.id]), height: 175 }))))));
    }
}
PerformanceDetailsComponent.HELP = 'Displays basic performance details like train and test performance. Additionally, a ' +
    'confusion matrix for all classes is computed. Finally, the ROC curve for this candidate is displayed.';
PerformanceDetailsComponent.contextType = _util__WEBPACK_IMPORTED_MODULE_7__.JupyterContext;


/***/ }),

/***/ "./lib/components/details/pipeline_hyperparameters.js":
/*!************************************************************!*\
  !*** ./lib/components/details/pipeline_hyperparameters.js ***!
  \************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "HyperparameterTable": () => (/* binding */ HyperparameterTable),
/* harmony export */   "PipelineHyperparameters": () => (/* binding */ PipelineHyperparameters)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _material_ui_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @material-ui/core */ "webpack/sharing/consume/default/@material-ui/core/@material-ui/core?df94");
/* harmony import */ var _material_ui_core__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_material_ui_core__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _util__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../util */ "./lib/util.js");



class HyperparameterTable extends (react__WEBPACK_IMPORTED_MODULE_0___default().Component) {
    renderSingleColumn() {
        const configTable = [];
        Array.from(this.props.config.entries())
            .forEach(([name, value]) => {
            configTable.push([name, value]);
        });
        return configTable.map(([name, value]) => react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_material_ui_core__WEBPACK_IMPORTED_MODULE_1__.TableRow, { key: name },
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_material_ui_core__WEBPACK_IMPORTED_MODULE_1__.TableCell, { component: "th", scope: "row" }, name),
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_material_ui_core__WEBPACK_IMPORTED_MODULE_1__.TableCell, { align: "right" }, (0,_util__WEBPACK_IMPORTED_MODULE_2__.prettyPrint)(value, 5))));
    }
    renderTwoColumns() {
        const configTable = [[], []];
        Array.from(this.props.config.entries())
            .forEach(([name, value], idx) => {
            configTable[idx % 2].push([name, value]);
        });
        // Ensure that left and right array have exactly the same amount of elements
        if (configTable[0].length != configTable[1].length)
            configTable[1].push(["", ""]);
        return configTable[0]
            .map(([name, value], idx) => {
            const name2 = configTable[1][idx][0];
            const value2 = configTable[1][idx][1];
            return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_material_ui_core__WEBPACK_IMPORTED_MODULE_1__.TableRow, { key: name },
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_material_ui_core__WEBPACK_IMPORTED_MODULE_1__.TableCell, { component: "th", scope: "row" }, name),
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_material_ui_core__WEBPACK_IMPORTED_MODULE_1__.TableCell, { align: "right" }, (0,_util__WEBPACK_IMPORTED_MODULE_2__.prettyPrint)(value, 5)),
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_material_ui_core__WEBPACK_IMPORTED_MODULE_1__.TableCell, { component: "th", scope: "row" }, name2),
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_material_ui_core__WEBPACK_IMPORTED_MODULE_1__.TableCell, { align: "right" }, (0,_util__WEBPACK_IMPORTED_MODULE_2__.prettyPrint)(value2, 5))));
        });
    }
    render() {
        if (this.props.config.size === 0)
            return react__WEBPACK_IMPORTED_MODULE_0___default().createElement("p", null, "No Configuration");
        else
            return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_material_ui_core__WEBPACK_IMPORTED_MODULE_1__.Table, { className: 'jp-RenderedHTMLCommon' },
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_material_ui_core__WEBPACK_IMPORTED_MODULE_1__.TableBody, null, this.props.twoColumns ? this.renderTwoColumns() : this.renderSingleColumn())));
    }
}
class PipelineHyperparameters extends (react__WEBPACK_IMPORTED_MODULE_0___default().Component) {
    render() {
        const { candidate, structure } = this.props;
        return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { style: { display: 'flex', flexDirection: 'row', justifyContent: 'space-around', flexWrap: 'wrap' } }, structure.pipeline
            .slice(1)
            .map(step => react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { key: step.label },
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement("h4", null, step.label),
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement(HyperparameterTable, { config: candidate.subConfig(step, true), twoColumns: false })))));
    }
}


/***/ }),

/***/ "./lib/components/details/pipeline_visualization.js":
/*!**********************************************************!*\
  !*** ./lib/components/details/pipeline_visualization.js ***!
  \**********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "PipelineVisualizationComponent": () => (/* binding */ PipelineVisualizationComponent)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _util__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../util */ "./lib/util.js");
/* harmony import */ var _util_tree_structure__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../util/tree_structure */ "./lib/util/tree_structure.js");



var isPipEnd = _util__WEBPACK_IMPORTED_MODULE_1__.Components.isPipEnd;
class SingleComponent extends (react__WEBPACK_IMPORTED_MODULE_0___default().Component) {
    render() {
        // const {step, error, loading, output, onHover} = this.props
        //
        // const tooltipContent = <>
        //     <Typography color="inherit" component={'h4'}>Configuration</Typography>
        //     <ConfigurationTable config={step.config} twoColumns={true}/>
        //     <Typography color="inherit" component={'h4'}>Output</Typography>
        //
        //     <ErrorIndicator error={error}/>
        //     {!error &&
        //         <>
        //             <LoadingIndicator loading={loading}/>
        //             {!loading && (output ?
        //                 <div style={{overflowX: "auto", marginBottom: 0}}
        //                      dangerouslySetInnerHTML={{__html: output}}/> : <div>Missing</div>)
        //             }
        //         </>
        //     }
        // </>
        return (
        // <Tooltip placement={'top'}
        //          classes={{tooltip: 'structure-graph_tooltip jp-RenderedHTMLCommon'}}
        //          title={tooltipContent}
        //          enterDelay={500}
        //          enterNextDelay={500}
        //          leaveDelay={500}
        //          interactive={true}
        //          onOpen={onHover}>
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement((react__WEBPACK_IMPORTED_MODULE_0___default().Fragment), null, _util__WEBPACK_IMPORTED_MODULE_1__.Components.isPipEnd(this.props.step.id) ?
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement("p", { className: 'structure-graph_end-node' }) :
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement("p", null, this.props.step.label))
        // </Tooltip>
        );
    }
}
class PipelineVisualizationComponent extends (react__WEBPACK_IMPORTED_MODULE_0___default().Component) {
    constructor(props) {
        super(props);
        this.state = { loading: false, outputs: new Map(), error: undefined };
        this.fetchOutputs = this.fetchOutputs.bind(this);
        this.renderNodes = this.renderNodes.bind(this);
        this.onComponentSelection = this.onComponentSelection.bind(this);
    }
    fetchOutputs() {
        if (this.state.loading)
            // Loading already in progress
            return;
        if (this.state.outputs.size > 0)
            // Outputs already cached
            return;
        this.setState({ loading: true });
        this.context.requestOutputDescription(this.props.candidate.id)
            .then(data => this.setState({ outputs: data, loading: false }))
            .catch(error => {
            console.error(`Failed to fetch output data.\n${error.name}: ${error.message}`);
            this.setState({ error: error });
        });
    }
    onComponentSelection(step, e) {
        const { onComponentSelection } = this.props;
        if (!!onComponentSelection) {
            onComponentSelection(step);
            e.stopPropagation();
        }
    }
    renderNodes(root) {
        const { selectedComponent } = this.props;
        const { outputs, loading, error } = this.state;
        const renderedNodes = root.descendants().map(node => {
            return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_util_tree_structure__WEBPACK_IMPORTED_MODULE_2__.GraphNode, { key: node.data.label, node: node, highlight: node.data.step_name === selectedComponent || node.data.id === selectedComponent, virtual: isPipEnd(node.data.id), nodeWidth: PipelineVisualizationComponent.NODE_WIDTH, nodeHeight: PipelineVisualizationComponent.NODE_HEIGHT, className: 'structure-graph_node', onClick: this.onComponentSelection },
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement(SingleComponent, { step: node.data, error: error, loading: loading, output: outputs.get(node.data.id), onHover: this.fetchOutputs })));
        });
        const renderedEdges = root.links().map(link => react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_util_tree_structure__WEBPACK_IMPORTED_MODULE_2__.GraphEdge, { key: link.source.data.label + '-' + link.target.data.label, link: link, label: link.target.data.getLabel(link.source.data.id), nodeWidth: isPipEnd(link.source.data.id) ? PipelineVisualizationComponent.NODE_HEIGHT : PipelineVisualizationComponent.NODE_WIDTH, nodeHeight: PipelineVisualizationComponent.NODE_HEIGHT }));
        return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement((react__WEBPACK_IMPORTED_MODULE_0___default().Fragment), null,
            renderedEdges,
            renderedNodes));
    }
    render() {
        return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_util_tree_structure__WEBPACK_IMPORTED_MODULE_2__.HierarchicalTree, { nodeHeight: PipelineVisualizationComponent.NODE_HEIGHT, nodeWidth: PipelineVisualizationComponent.NODE_WIDTH, data: this.props.structure, render: this.renderNodes }));
    }
}
PipelineVisualizationComponent.NODE_HEIGHT = 26;
PipelineVisualizationComponent.NODE_WIDTH = 100;
PipelineVisualizationComponent.contextType = _util__WEBPACK_IMPORTED_MODULE_1__.JupyterContext;


/***/ }),

/***/ "./lib/components/ensemble.js":
/*!************************************!*\
  !*** ./lib/components/ensemble.js ***!
  \************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Ensemble": () => (/* binding */ Ensemble)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _util__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ../util */ "./lib/util.js");
/* harmony import */ var _util_collapse__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../util/collapse */ "./lib/util/collapse.js");
/* harmony import */ var _util_layout__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../util/layout */ "./lib/util/layout.js");
/* harmony import */ var _util_error__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../util/error */ "./lib/util/error.js");
/* harmony import */ var _util_loading__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../util/loading */ "./lib/util/loading.js");
/* harmony import */ var _details_dataset_table__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./details/dataset_table */ "./lib/components/details/dataset_table.js");
/* harmony import */ var _ensemble_ensemble_table__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./ensemble/ensemble_table */ "./lib/components/ensemble/ensemble_table.js");
/* harmony import */ var _ensemble_decision_surface__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ./ensemble/decision_surface */ "./lib/components/ensemble/decision_surface.js");
/* harmony import */ var _material_ui_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @material-ui/core */ "webpack/sharing/consume/default/@material-ui/core/@material-ui/core?df94");
/* harmony import */ var _material_ui_core__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_material_ui_core__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _util_heading__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../util/heading */ "./lib/util/heading.js");
/* harmony import */ var _ensemble_ensemble_details__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./ensemble/ensemble_details */ "./lib/components/ensemble/ensemble_details.js");












class Ensemble extends (react__WEBPACK_IMPORTED_MODULE_0___default().Component) {
    constructor(props) {
        super(props);
        this.state = {
            overview: undefined,
            overviewError: undefined,
            predictions: new Map(),
            selectedSample: undefined,
            decisionSurface: undefined,
            surfaceError: undefined,
            showScatter: false
        };
        this.selectSampleIdx = this.selectSampleIdx.bind(this);
        this.toggleShowScatter = this.toggleShowScatter.bind(this);
    }
    componentDidMount() {
        this.context.requestEnsembleOverview()
            .then(data => this.setState({ overview: data }))
            .catch(error => {
            console.error(`Failed to fetch ensemble overview: \n${error.name}: ${error.message}`);
            this.setState({ overviewError: error });
        });
        this.context.requestEnsembleDecisionSurface()
            .then(data => this.setState({ decisionSurface: data }))
            .catch(error => {
            console.error(`Failed to fetch decision surface: \n${error.name}: ${error.message}`);
            this.setState({ surfaceError: error });
        });
    }
    selectSampleIdx(idx) {
        this.context.requestEnsemblePredictions(idx)
            .then((data) => this.setState({ predictions: data }));
    }
    toggleShowScatter(_, checked) {
        this.setState({ showScatter: checked });
    }
    render() {
        const { overview, selectedSample, predictions, overviewError, surfaceError, decisionSurface, showScatter } = this.state;
        return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement((react__WEBPACK_IMPORTED_MODULE_0___default().Fragment), null,
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_util_collapse__WEBPACK_IMPORTED_MODULE_2__.CollapseComp, { name: 'ensemble-details', showInitial: true, help: '' },
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement("h3", null, "Insights for Ensemble"),
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_ensemble_ensemble_details__WEBPACK_IMPORTED_MODULE_3__.EnsembleDetailsComponent, { meta: this.props.meta })),
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_util_collapse__WEBPACK_IMPORTED_MODULE_2__.CollapseComp, { name: 'ensemble', showInitial: true, help: 'Displays the individual ensemble members and some basic statics. In addition ' +
                    'a selection of data set samples with conflicting predictions in the ensemble is ' +
                    'given.' },
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement("h3", null, "Ensemble Overview"),
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement((react__WEBPACK_IMPORTED_MODULE_0___default().Fragment), null,
                    react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_util_error__WEBPACK_IMPORTED_MODULE_4__.ErrorIndicator, { error: overviewError }),
                    !overviewError &&
                        react__WEBPACK_IMPORTED_MODULE_0___default().createElement((react__WEBPACK_IMPORTED_MODULE_0___default().Fragment), null,
                            react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_util_loading__WEBPACK_IMPORTED_MODULE_5__.LoadingIndicator, { loading: overview === undefined }),
                            overview &&
                                react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_util_layout__WEBPACK_IMPORTED_MODULE_6__.TwoColumnLayout, { flexShrinkLeft: '1', flexGrowLeft: '0', flexGrowRight: '1', flexShrinkRight: '0' },
                                    react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { style: { marginTop: '10px' } },
                                        react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_util_heading__WEBPACK_IMPORTED_MODULE_7__.Heading, { help: 'A selection of input data samples, where at least one ' +
                                                'ensemble member had another prediction than the rest.' },
                                            react__WEBPACK_IMPORTED_MODULE_0___default().createElement("h4", null, "Samples with Conflicting Predictions ")),
                                        react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_details_dataset_table__WEBPACK_IMPORTED_MODULE_8__.DataSetTable, { data: overview.df, selectedSample: selectedSample, onSampleClick: this.selectSampleIdx })),
                                    react__WEBPACK_IMPORTED_MODULE_0___default().createElement((react__WEBPACK_IMPORTED_MODULE_0___default().Fragment), null,
                                        react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_util_heading__WEBPACK_IMPORTED_MODULE_7__.Heading, { help: _ensemble_ensemble_table__WEBPACK_IMPORTED_MODULE_9__.EnsembleTable.HELP },
                                            react__WEBPACK_IMPORTED_MODULE_0___default().createElement("h4", null, "Ensemble Members")),
                                        react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_ensemble_ensemble_table__WEBPACK_IMPORTED_MODULE_9__.EnsembleTable, { metrics: overview.metrics, predictions: predictions, onCandidateSelection: this.props.onCandidateSelection })))))),
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_util_collapse__WEBPACK_IMPORTED_MODULE_2__.CollapseComp, { name: 'decision-surface', showInitial: true, help: _ensemble_decision_surface__WEBPACK_IMPORTED_MODULE_10__.DecisionSurface.HELP },
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement("h3", null, "Decision Surface"),
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement((react__WEBPACK_IMPORTED_MODULE_0___default().Fragment), null,
                    react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_util_error__WEBPACK_IMPORTED_MODULE_4__.ErrorIndicator, { error: surfaceError }),
                    !surfaceError &&
                        react__WEBPACK_IMPORTED_MODULE_0___default().createElement((react__WEBPACK_IMPORTED_MODULE_0___default().Fragment), null,
                            react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_util_loading__WEBPACK_IMPORTED_MODULE_5__.LoadingIndicator, { loading: decisionSurface === undefined }),
                            decisionSurface &&
                                react__WEBPACK_IMPORTED_MODULE_0___default().createElement((react__WEBPACK_IMPORTED_MODULE_0___default().Fragment), null,
                                    react__WEBPACK_IMPORTED_MODULE_0___default().createElement("label", { className: 'MuiFormControlLabel-root' },
                                        react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_material_ui_core__WEBPACK_IMPORTED_MODULE_1__.Checkbox, { checked: showScatter, onChange: this.toggleShowScatter }),
                                        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("span", null, "Show\u00A0Scatter\u00A0Plot")),
                                    react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: 'decision-surface' }, Array.from(decisionSurface.contours.entries()).map(([cid, value]) => {
                                        return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { key: cid },
                                            react__WEBPACK_IMPORTED_MODULE_0___default().createElement("h4", { onClick: () => {
                                                    if (cid !== 'Ensemble')
                                                        this.props.onCandidateSelection(new Set([cid]), true);
                                                }, style: { cursor: 'pointer' } }, cid),
                                            react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_ensemble_decision_surface__WEBPACK_IMPORTED_MODULE_10__.DecisionSurface, { contour: value, X: decisionSurface.X, y: decisionSurface.y, colors: decisionSurface.colors, showScatter: showScatter })));
                                    }))))))));
    }
}
Ensemble.contextType = _util__WEBPACK_IMPORTED_MODULE_11__.JupyterContext;


/***/ }),

/***/ "./lib/components/ensemble/decision_surface.js":
/*!*****************************************************!*\
  !*** ./lib/components/ensemble/decision_surface.js ***!
  \*****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "DecisionSurface": () => (/* binding */ DecisionSurface)
/* harmony export */ });
/* harmony import */ var recharts__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! recharts */ "webpack/sharing/consume/default/recharts/recharts");
/* harmony import */ var recharts__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(recharts__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _util__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../util */ "./lib/util.js");



class LabelEncoder {
    fit(data) {
        this.labels = [...new Set(data)];
        return this;
    }
    transform(y) {
        return this.labels.indexOf(y);
    }
}
class DecisionSurface extends (react__WEBPACK_IMPORTED_MODULE_1___default().Component) {
    render() {
        const { width, height, X, y, contour, colors, showScatter } = this.props;
        const encoder = new LabelEncoder().fit(y);
        return (react__WEBPACK_IMPORTED_MODULE_1___default().createElement(recharts__WEBPACK_IMPORTED_MODULE_0__.ComposedChart, { width: width, height: height },
            react__WEBPACK_IMPORTED_MODULE_1___default().createElement("g", { transform: `translate(65, 5) scale(${(width - 70) / 720}, ${(height - 40) / 720})`, dangerouslySetInnerHTML: { __html: contour } }),
            react__WEBPACK_IMPORTED_MODULE_1___default().createElement(recharts__WEBPACK_IMPORTED_MODULE_0__.CartesianGrid, { strokeDasharray: "3 3" }),
            react__WEBPACK_IMPORTED_MODULE_1___default().createElement(recharts__WEBPACK_IMPORTED_MODULE_0__.XAxis, { dataKey: "x", type: 'number', domain: ['dataMin', 'dataMax'], tickFormatter: _util__WEBPACK_IMPORTED_MODULE_2__.prettyPrint, label: { value: 'Dimension 1', dy: 10 } }),
            react__WEBPACK_IMPORTED_MODULE_1___default().createElement(recharts__WEBPACK_IMPORTED_MODULE_0__.YAxis, { dataKey: "y", type: 'number', domain: ['dataMin', 'dataMax'], tickFormatter: _util__WEBPACK_IMPORTED_MODULE_2__.prettyPrint, label: { value: 'Dimension 2', angle: -90, dx: -40 } }),
            react__WEBPACK_IMPORTED_MODULE_1___default().createElement(recharts__WEBPACK_IMPORTED_MODULE_0__.Scatter, { data: X }, X.map((entry, idx) => react__WEBPACK_IMPORTED_MODULE_1___default().createElement(recharts__WEBPACK_IMPORTED_MODULE_0__.Cell, { key: `cell-${idx}`, fill: showScatter ? colors[encoder.transform(y[idx])] : 'none', stroke: showScatter ? _util__WEBPACK_IMPORTED_MODULE_2__.Colors.BORDER : 'none' })))));
    }
}
DecisionSurface.HELP = 'Visualization of the decision surface of each ensemble member mapped into a 2D space. ' +
    'The background color indicates the predicted class in this region. In addition, a subset of the data can ' +
    'be plotted in the 2D space using a scatter plot. Each scatter dot is colored by the correct class.' +
    '\n\n' +
    'Important: The mapping of the high-dimensional input space to 2D in combination with a low sampling rate ' +
    'of the input space due computational restrictions may lead to an under-sampling and seemingly wrong' +
    'decision surfaces, e.g. constant predictions of a classifier or sample colors not being aligned with the ' +
    'decision surface.';
DecisionSurface.defaultProps = {
    width: 300,
    height: 300
};


/***/ }),

/***/ "./lib/components/ensemble/ensemble_details.js":
/*!*****************************************************!*\
  !*** ./lib/components/ensemble/ensemble_details.js ***!
  \*****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "EnsembleDetailsComponent": () => (/* binding */ EnsembleDetailsComponent)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _model__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../model */ "./lib/model.js");
/* harmony import */ var _util__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../util */ "./lib/util.js");
/* harmony import */ var _details_model__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../details/model */ "./lib/components/details/model.js");
/* harmony import */ var _util_collapse__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../util/collapse */ "./lib/util/collapse.js");
/* harmony import */ var _details_performance_details__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../details/performance_details */ "./lib/components/details/performance_details.js");
/* harmony import */ var _util_layout__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../../util/layout */ "./lib/util/layout.js");
/* harmony import */ var _util_raw_dataset__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../util/raw_dataset */ "./lib/util/raw_dataset.js");
/* harmony import */ var _details_local_surrogate__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../details/local_surrogate */ "./lib/components/details/local_surrogate.js");
/* harmony import */ var _details_global_surrogate__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../details/global_surrogate */ "./lib/components/details/global_surrogate.js");










var SOURCE = _util__WEBPACK_IMPORTED_MODULE_1__.Components.SOURCE;
var ENSEMBLE = _util__WEBPACK_IMPORTED_MODULE_1__.Components.ENSEMBLE;
class EnsembleDetailsComponent extends (react__WEBPACK_IMPORTED_MODULE_0___default().Component) {
    constructor(props) {
        super(props);
        this.state = { selectedSample: undefined };
        this.handleSampleSelection = this.handleSampleSelection.bind(this);
    }
    handleSampleSelection(idx) {
        this.setState({ selectedSample: idx });
    }
    render() {
        const { meta } = this.props;
        const { selectedSample } = this.state;
        const candidate = new _model__WEBPACK_IMPORTED_MODULE_2__.Candidate(ENSEMBLE, '', 0, 0, new _model__WEBPACK_IMPORTED_MODULE_2__.Runtime(0, 0, 0), undefined, undefined, false);
        const model = new _details_model__WEBPACK_IMPORTED_MODULE_3__.DetailsModel(undefined, candidate, SOURCE, SOURCE, selectedSample);
        return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement((react__WEBPACK_IMPORTED_MODULE_0___default().Fragment), null,
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_util_collapse__WEBPACK_IMPORTED_MODULE_4__.CollapseComp, { name: 'performance', showInitial: false, help: _details_performance_details__WEBPACK_IMPORTED_MODULE_5__.PerformanceDetailsComponent.HELP },
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement("h3", null, "Performance Details"),
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_details_performance_details__WEBPACK_IMPORTED_MODULE_5__.PerformanceDetailsComponent, { model: model, meta: meta })),
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_util_collapse__WEBPACK_IMPORTED_MODULE_4__.CollapseComp, { name: 'raw-dataset', showInitial: false, help: _util_raw_dataset__WEBPACK_IMPORTED_MODULE_6__.RawDataset.HELP },
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement("h3", null, "Data Set Preview"),
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_util_layout__WEBPACK_IMPORTED_MODULE_7__.TwoColumnLayout, { widthRight: '25%' },
                    react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_util_raw_dataset__WEBPACK_IMPORTED_MODULE_6__.RawDataset, { model: model, onSampleClick: this.handleSampleSelection }),
                    react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_details_local_surrogate__WEBPACK_IMPORTED_MODULE_8__.LocalSurrogateComponent, { model: model, orientation: 'vertical' }))),
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_util_collapse__WEBPACK_IMPORTED_MODULE_4__.CollapseComp, { name: 'global-surrogate', showInitial: false, help: _details_global_surrogate__WEBPACK_IMPORTED_MODULE_9__.GlobalSurrogateComponent.HELP },
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement("h3", null, "Global Surrogate"),
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_details_global_surrogate__WEBPACK_IMPORTED_MODULE_9__.GlobalSurrogateComponent, { model: model }))));
    }
}
EnsembleDetailsComponent.contextType = _util__WEBPACK_IMPORTED_MODULE_1__.JupyterContext;


/***/ }),

/***/ "./lib/components/ensemble/ensemble_table.js":
/*!***************************************************!*\
  !*** ./lib/components/ensemble/ensemble_table.js ***!
  \***************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "EnsembleTable": () => (/* binding */ EnsembleTable)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _material_ui_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @material-ui/core */ "webpack/sharing/consume/default/@material-ui/core/@material-ui/core?df94");
/* harmony import */ var _material_ui_core__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_material_ui_core__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _material_ui_core_TableBody__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @material-ui/core/TableBody */ "./node_modules/@material-ui/core/esm/TableBody/TableBody.js");
/* harmony import */ var _material_ui_core_TableRow__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @material-ui/core/TableRow */ "./node_modules/@material-ui/core/esm/TableRow/TableRow.js");
/* harmony import */ var _material_ui_core_TableCell__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @material-ui/core/TableCell */ "./node_modules/@material-ui/core/esm/TableCell/TableCell.js");
/* harmony import */ var _material_ui_core_TableSortLabel__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @material-ui/core/TableSortLabel */ "./node_modules/@material-ui/core/esm/TableSortLabel/TableSortLabel.js");
/* harmony import */ var _material_ui_core_TableHead__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @material-ui/core/TableHead */ "./node_modules/@material-ui/core/esm/TableHead/TableHead.js");
/* harmony import */ var _util__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../../util */ "./lib/util.js");








class EnsembleTable extends (react__WEBPACK_IMPORTED_MODULE_0___default().Component) {
    constructor(props) {
        super(props);
        this.state = { order: 'desc', orderBy: 'weight' };
        this.onRequestSort = this.onRequestSort.bind(this);
    }
    onRequestSort(_, property) {
        const isAsc = this.state.orderBy === property && this.state.order === 'asc';
        this.setState({ order: isAsc ? 'desc' : 'asc', orderBy: property });
    }
    onRowClick(e, cid) {
        if (e.ctrlKey) {
            this.props.onCandidateSelection(new Set([cid]), true);
            e.stopPropagation();
            e.preventDefault();
        }
    }
    render() {
        const { order, orderBy } = this.state;
        const headCells = [
            { id: 'id', numeric: false, label: 'Id' },
            { id: 'prediction', numeric: true, label: 'Prediction' },
            { id: 'weight', numeric: true, label: 'Weight' },
            { id: 'consensus', numeric: true, label: 'Consensus' },
        ];
        const comp = (a, b) => {
            const sign = order === 'desc' ? 1 : -1;
            if (b[orderBy] < a[orderBy])
                return sign * -1;
            if (b[orderBy] > a[orderBy])
                return sign * 1;
            return 0;
        };
        const rows = [];
        this.props.metrics.forEach((value, cid) => rows.push({
            id: cid,
            weight: value.weight,
            consensus: value.consensus,
            prediction: this.props.predictions.get(cid)
        }));
        return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_material_ui_core__WEBPACK_IMPORTED_MODULE_1__.TableContainer, null,
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_material_ui_core__WEBPACK_IMPORTED_MODULE_1__.Table, { size: "small", onMouseDown: (e => {
                    // Prevent browser from highlighting clicked table cells.
                    // See https://stackoverflow.com/questions/5067644/html-table-when-i-ctrlclick-the-border-of-the-cell-appears
                    if (e.ctrlKey)
                        e.preventDefault();
                }) },
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_material_ui_core_TableHead__WEBPACK_IMPORTED_MODULE_2__["default"], null,
                    react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_material_ui_core_TableRow__WEBPACK_IMPORTED_MODULE_3__["default"], null, headCells.map(headCell => (react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_material_ui_core_TableCell__WEBPACK_IMPORTED_MODULE_4__["default"], { key: headCell.id, align: headCell.numeric ? 'right' : 'left', sortDirection: orderBy === headCell.id ? order : false },
                        react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_material_ui_core_TableSortLabel__WEBPACK_IMPORTED_MODULE_5__["default"], { active: orderBy === headCell.id, direction: orderBy === headCell.id ? order : 'asc', onClick: (event) => this.onRequestSort(event, headCell.id) },
                            headCell.label,
                            orderBy === headCell.id ? (react__WEBPACK_IMPORTED_MODULE_0___default().createElement("span", { className: 'candidate-table_visually-hidden' }, order === 'desc' ? 'sorted descending' : 'sorted ascending')) : null)))))),
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_material_ui_core_TableBody__WEBPACK_IMPORTED_MODULE_6__["default"], null, rows
                    .sort(comp)
                    .map(row => {
                    return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_material_ui_core_TableRow__WEBPACK_IMPORTED_MODULE_3__["default"], { key: row.id, hover: true, tabIndex: -1, onClick: (e) => this.onRowClick(e, row.id) },
                        react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_material_ui_core_TableCell__WEBPACK_IMPORTED_MODULE_4__["default"], { scope: 'row', padding: 'none' }, row.id),
                        react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_material_ui_core_TableCell__WEBPACK_IMPORTED_MODULE_4__["default"], { align: 'right' }, row.prediction),
                        react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_material_ui_core_TableCell__WEBPACK_IMPORTED_MODULE_4__["default"], { align: 'right' }, (0,_util__WEBPACK_IMPORTED_MODULE_7__.prettyPrint)(row.weight)),
                        react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_material_ui_core_TableCell__WEBPACK_IMPORTED_MODULE_4__["default"], { align: 'right' }, (0,_util__WEBPACK_IMPORTED_MODULE_7__.prettyPrint)(row.consensus))));
                })))));
    }
}
EnsembleTable.HELP = 'List of all pipelines in the ensemble. For each member, the weight in the ensemble and ' +
    'how much the prediction of this member align with the ensemble prediction (consensus) are displayed. By ' +
    'selecting a single sample in the data set preview on the right, the actual predictions of each ensemble ' +
    'member can be computed. ';


/***/ }),

/***/ "./lib/components/general/meta_information.js":
/*!****************************************************!*\
  !*** ./lib/components/general/meta_information.js ***!
  \****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ MetaInformationTable)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _util_collapse__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../util/collapse */ "./lib/util/collapse.js");
/* harmony import */ var _util_KeyValue__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../util/KeyValue */ "./lib/util/KeyValue.js");
/* harmony import */ var _util__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../util */ "./lib/util.js");




class MetaInformationTable extends (react__WEBPACK_IMPORTED_MODULE_0___default().Component) {
    render() {
        const { meta } = this.props;
        const start = new Date(0);
        start.setUTCSeconds(meta.start_time);
        const end = new Date(0);
        end.setUTCSeconds(meta.end_time);
        const configValues = [];
        meta.config.forEach((value, key) => configValues.push([key, value]));
        return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement((react__WEBPACK_IMPORTED_MODULE_0___default().Fragment), null,
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_util_collapse__WEBPACK_IMPORTED_MODULE_1__.CollapseComp, { name: 'optimization-statistics', showInitial: true, help: 'View the most important settings and statistics for this optimization run.' },
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement("h4", null, "Optimization Overview"),
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement((react__WEBPACK_IMPORTED_MODULE_0___default().Fragment), null,
                    react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_util_KeyValue__WEBPACK_IMPORTED_MODULE_2__.KeyValue, { key_: 'Framework', value: meta.framework }),
                    meta.openml_task !== undefined && meta.openml_fold !== undefined &&
                        react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_util_KeyValue__WEBPACK_IMPORTED_MODULE_2__.KeyValue, { key_: 'Data Set', value: `Task ${meta.openml_task} on Fold ${meta.openml_fold}`, href: `https://www.openml.org/t/${meta.openml_task}` }),
                    react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_util_KeyValue__WEBPACK_IMPORTED_MODULE_2__.KeyValue, { key_: 'Start Time', value: start }),
                    react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_util_KeyValue__WEBPACK_IMPORTED_MODULE_2__.KeyValue, { key_: 'End Time', value: end }),
                    react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_util_KeyValue__WEBPACK_IMPORTED_MODULE_2__.KeyValue, { key_: 'Metric', value: meta.metric }),
                    react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_util_KeyValue__WEBPACK_IMPORTED_MODULE_2__.KeyValue, { key_: 'Best Performance', prec: 4, value: meta.bestPerformance }),
                    react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_util_KeyValue__WEBPACK_IMPORTED_MODULE_2__.KeyValue, { key_: 'Total Nr. Candidates', value: meta.n_configs }),
                    react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_util_KeyValue__WEBPACK_IMPORTED_MODULE_2__.KeyValue, { key_: 'Unique Structures', value: meta.n_structures }))),
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_util_collapse__WEBPACK_IMPORTED_MODULE_1__.CollapseComp, { name: 'optimization-settings', showInitial: false, help: 'View additional settings for this optimization run.' },
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement("h4", null, "Optimization Configuration"),
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement((react__WEBPACK_IMPORTED_MODULE_0___default().Fragment), null, configValues.map(([key, value]) => react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: 'overview-row', key: key },
                    key,
                    ": ",
                    (0,_util__WEBPACK_IMPORTED_MODULE_3__.prettyPrint)(value)))))));
    }
}


/***/ }),

/***/ "./lib/components/general/performance_distribution.js":
/*!************************************************************!*\
  !*** ./lib/components/general/performance_distribution.js ***!
  \************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ PerformanceDistribution)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var recharts__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! recharts */ "webpack/sharing/consume/default/recharts/recharts");
/* harmony import */ var recharts__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(recharts__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _util_loading__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../util/loading */ "./lib/util/loading.js");
/* harmony import */ var d3__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! d3 */ "webpack/sharing/consume/default/d3/d3");
/* harmony import */ var d3__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(d3__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _util__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../util */ "./lib/util.js");
/* harmony import */ var _util_recharts__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../util/recharts */ "./lib/util/recharts.js");






class PerformanceDistribution extends (react__WEBPACK_IMPORTED_MODULE_0___default().Component) {
    render() {
        const { data } = this.props;
        const bins = (0,d3__WEBPACK_IMPORTED_MODULE_2__.bin)()(data.map(d => d.performance))
            .map(bin => ({ frequency: bin.length, performance: (bin.x0 + bin.x1) / 2 }));
        return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { style: { height: this.props.height } },
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_util_loading__WEBPACK_IMPORTED_MODULE_3__.LoadingIndicator, { loading: data.length === 0 }),
            data.length > 0 &&
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement(recharts__WEBPACK_IMPORTED_MODULE_1__.ResponsiveContainer, null,
                    react__WEBPACK_IMPORTED_MODULE_0___default().createElement(recharts__WEBPACK_IMPORTED_MODULE_1__.BarChart, { data: bins },
                        react__WEBPACK_IMPORTED_MODULE_0___default().createElement(recharts__WEBPACK_IMPORTED_MODULE_1__.CartesianGrid, { strokeDasharray: "3 3" }),
                        react__WEBPACK_IMPORTED_MODULE_0___default().createElement(recharts__WEBPACK_IMPORTED_MODULE_1__.XAxis, { dataKey: "performance", label: { value: this.props.meta.metric, dy: 10 } }),
                        react__WEBPACK_IMPORTED_MODULE_0___default().createElement(recharts__WEBPACK_IMPORTED_MODULE_1__.YAxis, { label: { value: 'Number of Candidates', angle: -90, dx: -25 } }),
                        react__WEBPACK_IMPORTED_MODULE_0___default().createElement(recharts__WEBPACK_IMPORTED_MODULE_1__.Tooltip, { content: react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_util_recharts__WEBPACK_IMPORTED_MODULE_4__.MinimalisticTooltip, null) }),
                        react__WEBPACK_IMPORTED_MODULE_0___default().createElement(recharts__WEBPACK_IMPORTED_MODULE_1__.Bar, { dataKey: "frequency", fill: _util__WEBPACK_IMPORTED_MODULE_5__.Colors.DEFAULT })))));
    }
}


/***/ }),

/***/ "./lib/components/general/performance_timeline.js":
/*!********************************************************!*\
  !*** ./lib/components/general/performance_timeline.js ***!
  \********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ PerformanceTimeline)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _util__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../util */ "./lib/util.js");
/* harmony import */ var recharts__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! recharts */ "webpack/sharing/consume/default/recharts/recharts");
/* harmony import */ var recharts__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(recharts__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _util_loading__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../util/loading */ "./lib/util/loading.js");




class PerformanceTimeline extends (react__WEBPACK_IMPORTED_MODULE_0___default().Component) {
    constructor(props) {
        super(props);
        this.state = { data: this.calcIncumbent() };
        this.onScatterClick = this.onScatterClick.bind(this);
    }
    componentDidUpdate(prevProps, prevState, snapshot) {
        if (prevProps.data.length !== this.props.data.length)
            this.setState({ data: this.calcIncumbent() });
    }
    calcIncumbent() {
        const optimFunction = this.props.meta.is_minimization ? Math.min : Math.max;
        let best = this.props.meta.is_minimization ? Infinity : -Infinity;
        return this.props.data
            .map(v => {
            best = optimFunction(best, v.performance);
            return {
                timestamp: (0,_util__WEBPACK_IMPORTED_MODULE_2__.fixedPrec)(v.timestamp),
                performance: (0,_util__WEBPACK_IMPORTED_MODULE_2__.fixedPrec)(v.performance),
                Incumbent: (0,_util__WEBPACK_IMPORTED_MODULE_2__.fixedPrec)(best),
                cid: v.cid
            };
        });
    }
    onScatterClick(x, _, e) {
        const cid = x.cid;
        if (!e.ctrlKey) {
            const selected = new Set(this.props.selectedCandidates);
            if (this.props.selectedCandidates.has(cid))
                selected.delete(cid);
            else
                selected.add(cid);
            this.props.onCandidateSelection(selected);
        }
        else
            this.props.onCandidateSelection(new Set([cid]), true);
    }
    render() {
        const { data } = this.state;
        const { selectedCandidates } = this.props;
        return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { style: { height: this.props.height } },
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_util_loading__WEBPACK_IMPORTED_MODULE_3__.LoadingIndicator, { loading: data.length === 0 }),
            data.length > 0 &&
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement(recharts__WEBPACK_IMPORTED_MODULE_1__.ResponsiveContainer, null,
                    react__WEBPACK_IMPORTED_MODULE_0___default().createElement(recharts__WEBPACK_IMPORTED_MODULE_1__.ComposedChart, { data: data, margin: this.props.margin },
                        react__WEBPACK_IMPORTED_MODULE_0___default().createElement(recharts__WEBPACK_IMPORTED_MODULE_1__.CartesianGrid, { strokeDasharray: "3 3" }),
                        react__WEBPACK_IMPORTED_MODULE_0___default().createElement(recharts__WEBPACK_IMPORTED_MODULE_1__.XAxis, { dataKey: "timestamp", label: { value: 'Timestamp', dy: 10 }, type: 'number', unit: 's', domain: this.props.xDomain }),
                        react__WEBPACK_IMPORTED_MODULE_0___default().createElement(recharts__WEBPACK_IMPORTED_MODULE_1__.YAxis, { domain: ['dataMin', 'dataMax'], label: {
                                value: this.props.meta.metric,
                                angle: -90,
                                dx: this.props.margin ? -this.props.margin.left - 10 : -25
                            } }),
                        react__WEBPACK_IMPORTED_MODULE_0___default().createElement(recharts__WEBPACK_IMPORTED_MODULE_1__.Line, { dataKey: 'Incumbent', stroke: _util__WEBPACK_IMPORTED_MODULE_2__.Colors.HIGHLIGHT, dot: false }),
                        react__WEBPACK_IMPORTED_MODULE_0___default().createElement(recharts__WEBPACK_IMPORTED_MODULE_1__.Scatter, { dataKey: "performance", onClick: this.onScatterClick }, data.map((d, index) => (react__WEBPACK_IMPORTED_MODULE_0___default().createElement(recharts__WEBPACK_IMPORTED_MODULE_1__.Cell, { key: `cell-${index}`, fill: selectedCandidates.has(d.cid) ? _util__WEBPACK_IMPORTED_MODULE_2__.Colors.HIGHLIGHT : _util__WEBPACK_IMPORTED_MODULE_2__.Colors.DEFAULT, stroke: _util__WEBPACK_IMPORTED_MODULE_2__.Colors.BORDER, cursor: 'pointer' }))))))));
    }
}
PerformanceTimeline.HELP = 'This view provides an overview of the performance of each evaluated candidate. Results ' +
    'can either be aggregated over time or group by achieved performance. In the temporal plot each scatter dot ' +
    'represents a single candidate and the line plot shows the performance of the best candidate over time. ' +
    'The distribution plot aggregates candidates by their performance.';
PerformanceTimeline.defaultProps = {
    margin: undefined,
    xDomain: [0, 'auto'],
    onCandidateSelection: (_) => {
    }
};


/***/ }),

/***/ "./lib/components/general/roc_curve.js":
/*!*********************************************!*\
  !*** ./lib/components/general/roc_curve.js ***!
  \*********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "RocCurve": () => (/* binding */ RocCurve)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _util_loading__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../util/loading */ "./lib/util/loading.js");
/* harmony import */ var _util_error__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../util/error */ "./lib/util/error.js");
/* harmony import */ var recharts__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! recharts */ "webpack/sharing/consume/default/recharts/recharts");
/* harmony import */ var recharts__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(recharts__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _util__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../util */ "./lib/util.js");





class RocCurve extends (react__WEBPACK_IMPORTED_MODULE_0___default().Component) {
    constructor(props) {
        super(props);
        this.state = {
            data: new Map(),
            loading: false,
            error: undefined,
            pendingCount: 0
        };
    }
    componentDidMount() {
        if (this.props.selectedCandidates.size > 0) {
            const cids = Array.from(this.props.selectedCandidates);
            this.queryROCCurve(cids);
        }
    }
    componentDidUpdate(prevProps, prevState, snapshot) {
        if (prevProps.selectedCandidates.size !== this.props.selectedCandidates.size) {
            let newCandidates;
            if (!this.state.loading) {
                // Remove previously selected candidates
                const superfluousCandidates = Array.from(prevProps.selectedCandidates).filter(c => !this.props.selectedCandidates.has(c));
                const currentCandidates = this.state.data;
                const currentKeys = Array.from(currentCandidates.keys());
                superfluousCandidates.forEach(c => {
                    currentKeys.filter(k => k.startsWith(c)).forEach(k => currentCandidates.delete(k));
                });
                this.setState({ data: currentCandidates });
                newCandidates = Array.from(this.props.selectedCandidates).filter(c => !prevProps.selectedCandidates.has(c));
                if (currentCandidates.size === 0)
                    this.setState({ error: undefined });
            }
            else {
                // Request for data is currently still pending. Erase complete state and load everything from scratch to
                // prevent incoherent states
                this.setState({ data: new Map(), loading: false });
                newCandidates = Array.from(this.props.selectedCandidates);
            }
            // Fetch new selected candidates
            if (newCandidates.length > 0) {
                this.queryROCCurve(newCandidates);
            }
        }
    }
    queryROCCurve(candidates) {
        const promise = this.context.requestROCCurve(candidates);
        this.setState({ loading: true, error: undefined, pendingCount: candidates.length });
        promise
            .then(data => {
            const currentCandidates = this.state.data;
            data.forEach((v, k) => currentCandidates.set(k, v));
            this.setState({ data: currentCandidates, loading: false });
        })
            .catch(error => {
            console.error(`Failed to fetch Roc Curve data.\n${error.name}: ${error.message}`);
            this.setState({ error: error, loading: false });
        });
    }
    render() {
        const { loading, pendingCount, error } = this.state;
        let content;
        if (loading && pendingCount > 2)
            content = react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_util_loading__WEBPACK_IMPORTED_MODULE_2__.LoadingIndicator, { loading: true });
        else {
            const labels = [];
            const data = [];
            this.state.data.forEach((v, k) => {
                const prunedName = k.split(' ')[0];
                if (this.props.selectedCandidates.has(prunedName)) {
                    labels.push(prunedName);
                    data.push(v);
                }
            });
            if (data.length > 0) {
                content = (react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { style: { height: this.props.height } },
                    react__WEBPACK_IMPORTED_MODULE_0___default().createElement(recharts__WEBPACK_IMPORTED_MODULE_1__.ResponsiveContainer, null,
                        react__WEBPACK_IMPORTED_MODULE_0___default().createElement(recharts__WEBPACK_IMPORTED_MODULE_1__.LineChart, null,
                            react__WEBPACK_IMPORTED_MODULE_0___default().createElement(recharts__WEBPACK_IMPORTED_MODULE_1__.CartesianGrid, { strokeDasharray: "3 3" }),
                            react__WEBPACK_IMPORTED_MODULE_0___default().createElement(recharts__WEBPACK_IMPORTED_MODULE_1__.XAxis, { dataKey: "x", label: { value: 'False Positive Rate', dy: 10 }, type: 'number', domain: [0, 1] }),
                            react__WEBPACK_IMPORTED_MODULE_0___default().createElement(recharts__WEBPACK_IMPORTED_MODULE_1__.YAxis, { label: { value: 'True Positive Rate', angle: -90, dx: -15 } }),
                            data.length <= 12 && react__WEBPACK_IMPORTED_MODULE_0___default().createElement(recharts__WEBPACK_IMPORTED_MODULE_1__.Legend, null),
                            data.map((s, idx) => (react__WEBPACK_IMPORTED_MODULE_0___default().createElement(recharts__WEBPACK_IMPORTED_MODULE_1__.Line, { key: labels[idx], name: labels[idx], data: s, dataKey: 'y', stroke: _util__WEBPACK_IMPORTED_MODULE_3__.Colors.getColor(idx), strokeWidth: 2, dot: false })))))));
            }
            else
                content = react__WEBPACK_IMPORTED_MODULE_0___default().createElement("p", null, "No Configuration selected");
        }
        return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement((react__WEBPACK_IMPORTED_MODULE_0___default().Fragment), null,
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_util_error__WEBPACK_IMPORTED_MODULE_4__.ErrorIndicator, { error: error }),
            !error && content));
    }
}
RocCurve.HELP = 'Displays the ROC curve for all selected candidates.' +
    '\n\n' +
    'A ROC curve, is a graphical plot that illustrates the diagnostic ability of a classifier system as its ' +
    'discrimination threshold is varied. The ROC curve is created by plotting the true positive rate (TPR) ' +
    'against the false positive rate (FPR) at various threshold settings.';
RocCurve.contextType = _util__WEBPACK_IMPORTED_MODULE_3__.JupyterContext;


/***/ }),

/***/ "./lib/components/leaderboard.js":
/*!***************************************!*\
  !*** ./lib/components/leaderboard.js ***!
  \***************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Leaderboard": () => (/* binding */ Leaderboard)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _material_ui_core_TableBody__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! @material-ui/core/TableBody */ "./node_modules/@material-ui/core/esm/TableBody/TableBody.js");
/* harmony import */ var _material_ui_core_TableCell__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @material-ui/core/TableCell */ "./node_modules/@material-ui/core/esm/TableCell/TableCell.js");
/* harmony import */ var _material_ui_core_TableHead__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @material-ui/core/TableHead */ "./node_modules/@material-ui/core/esm/TableHead/TableHead.js");
/* harmony import */ var _material_ui_core_TablePagination__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! @material-ui/core/TablePagination */ "./node_modules/@material-ui/core/esm/TablePagination/TablePagination.js");
/* harmony import */ var _material_ui_core_TableRow__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @material-ui/core/TableRow */ "./node_modules/@material-ui/core/esm/TableRow/TableRow.js");
/* harmony import */ var _material_ui_core_TableSortLabel__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @material-ui/core/TableSortLabel */ "./node_modules/@material-ui/core/esm/TableSortLabel/TableSortLabel.js");
/* harmony import */ var _material_ui_core_Checkbox__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @material-ui/core/Checkbox */ "./node_modules/@material-ui/core/esm/Checkbox/Checkbox.js");
/* harmony import */ var _material_ui_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @material-ui/core */ "webpack/sharing/consume/default/@material-ui/core/@material-ui/core?df94");
/* harmony import */ var _material_ui_core__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_material_ui_core__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _util__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../util */ "./lib/util.js");
/* harmony import */ var _details_pipeline_visualization__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ./details/pipeline_visualization */ "./lib/components/details/pipeline_visualization.js");
/* harmony import */ var _material_ui_icons_KeyboardArrowDown__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! @material-ui/icons/KeyboardArrowDown */ "./node_modules/@material-ui/icons/KeyboardArrowDown.js");
/* harmony import */ var _material_ui_icons_KeyboardArrowUp__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! @material-ui/icons/KeyboardArrowUp */ "./node_modules/@material-ui/icons/KeyboardArrowUp.js");
/* harmony import */ var _material_ui_core_Collapse__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! @material-ui/core/Collapse */ "./node_modules/@material-ui/core/esm/Collapse/Collapse.js");
/* harmony import */ var _candidate_inspections__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! ./candidate_inspections */ "./lib/components/candidate_inspections.js");
/* harmony import */ var _util_jupyter_button__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ../util/jupyter-button */ "./lib/util/jupyter-button.js");
/* harmony import */ var _jupyter__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../jupyter */ "./lib/jupyter.js");
/* harmony import */ var _material_ui_icons__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @material-ui/icons */ "webpack/sharing/consume/default/@material-ui/icons/@material-ui/icons");
/* harmony import */ var _material_ui_icons__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_material_ui_icons__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _comparison__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! ./comparison */ "./lib/components/comparison.js");
/* harmony import */ var _details_model__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(/*! ./details/model */ "./lib/components/details/model.js");




















class LeaderboardHeader extends (react__WEBPACK_IMPORTED_MODULE_0___default().Component) {
    constructor(props) {
        super(props);
    }
    render() {
        const { headCells, numSelected, onRequestSort, onSelectAllClick, order, orderBy, rowCount } = this.props;
        return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_material_ui_core_TableHead__WEBPACK_IMPORTED_MODULE_3__["default"], null,
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_material_ui_core_TableRow__WEBPACK_IMPORTED_MODULE_4__["default"], null,
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_material_ui_core_TableCell__WEBPACK_IMPORTED_MODULE_5__["default"], { padding: 'checkbox' },
                    react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_material_ui_core_Checkbox__WEBPACK_IMPORTED_MODULE_6__["default"], { indeterminate: numSelected > 0 && numSelected < rowCount, checked: rowCount > 0 && numSelected === rowCount, onChange: onSelectAllClick, color: 'primary' })),
                headCells.map(headCell => (react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_material_ui_core_TableCell__WEBPACK_IMPORTED_MODULE_5__["default"], { key: headCell.id, align: headCell.numeric ? 'right' : 'left', sortDirection: orderBy === headCell.id ? order : false, style: { width: headCell.width } }, headCell.sortable ?
                    react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_material_ui_core_TableSortLabel__WEBPACK_IMPORTED_MODULE_7__["default"], { active: orderBy === headCell.id, direction: orderBy === headCell.id ? order : 'asc', onClick: (event) => onRequestSort(event, headCell.id) },
                        headCell.label,
                        orderBy === headCell.id ? (react__WEBPACK_IMPORTED_MODULE_0___default().createElement("span", { className: 'candidate-table_visually-hidden' }, order === 'desc' ? 'sorted descending' : 'sorted ascending')) : null)
                    : headCell.label))),
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_material_ui_core_TableCell__WEBPACK_IMPORTED_MODULE_5__["default"], { style: { width: '205px' } }))));
    }
}
class LeaderboardRow extends (react__WEBPACK_IMPORTED_MODULE_0___default().Component) {
    constructor(props) {
        super(props);
        this.state = { open: this.props.open, selectedComponent: [undefined, undefined] };
        this.toggleDetails = this.toggleDetails.bind(this);
        this.openComponent = this.openComponent.bind(this);
        this.openCandidateInJupyter = this.openCandidateInJupyter.bind(this);
        this.onRowClick = this.onRowClick.bind(this);
        this.onCheckBoxClick = this.onCheckBoxClick.bind(this);
        this.onHide = this.onHide.bind(this);
    }
    componentDidUpdate(prevProps, prevState, snapshot) {
        if (!prevProps.open && this.props.open)
            this.setState({ open: true });
    }
    toggleDetails(e) {
        this.setState(state => {
            if (state.open)
                return { open: false, selectedComponent: [undefined, undefined] };
            else
                return { open: true, selectedComponent: [_util__WEBPACK_IMPORTED_MODULE_8__.Components.SOURCE, _util__WEBPACK_IMPORTED_MODULE_8__.Components.SOURCE] };
        });
        e.stopPropagation();
    }
    openComponent(step) {
        if (this.state.open && this.state.selectedComponent[0] === step.id) {
            // Close details when selecting the same step again
            this.setState({ open: false, selectedComponent: [undefined, undefined] });
        }
        else {
            if (this.props.meta.framework === 'dswizard')
                this.setState({ open: true, selectedComponent: [step.id, step.label] });
            else
                this.setState({ open: true, selectedComponent: [step.step_name, step.label] });
        }
    }
    openCandidateInJupyter(e) {
        this.context.createCell(`
${_jupyter__WEBPACK_IMPORTED_MODULE_9__.ID}_X, ${_jupyter__WEBPACK_IMPORTED_MODULE_9__.ID}_y, ${_jupyter__WEBPACK_IMPORTED_MODULE_9__.ID}_pipeline = gcx().pipeline('${this.props.candidate.candidate[1].id}')
${_jupyter__WEBPACK_IMPORTED_MODULE_9__.ID}_pipeline
        `.trim());
        e.stopPropagation();
    }
    onRowClick(e) {
        if (e.ctrlKey)
            this.props.onRowClick(this.props.candidate.id);
        else
            this.toggleDetails(e);
    }
    onCheckBoxClick(e) {
        this.props.onRowClick(this.props.candidate.id);
        e.stopPropagation();
    }
    onHide() {
        this.props.onRowHide(this.props.candidate.id);
    }
    render() {
        const { candidate, meta, selected, structures, explanations, onComparisonRequest } = this.props;
        const { open } = this.state;
        const selectedComponent = (open && this.state.selectedComponent[0] === undefined) ?
            [_util__WEBPACK_IMPORTED_MODULE_8__.Components.SOURCE, _util__WEBPACK_IMPORTED_MODULE_8__.Components.SOURCE] : this.state.selectedComponent;
        return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement((react__WEBPACK_IMPORTED_MODULE_0___default().Fragment), null,
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_material_ui_core_TableRow__WEBPACK_IMPORTED_MODULE_4__["default"], { hover: true, onClick: this.onRowClick, role: 'checkbox', tabIndex: -1, selected: selected },
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_material_ui_core_TableCell__WEBPACK_IMPORTED_MODULE_5__["default"], { padding: 'checkbox' },
                    react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_material_ui_core_Checkbox__WEBPACK_IMPORTED_MODULE_6__["default"], { checked: selected, color: 'primary', onClick: this.onCheckBoxClick })),
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_material_ui_core_TableCell__WEBPACK_IMPORTED_MODULE_5__["default"], { scope: 'row', padding: 'none' }, candidate.id),
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_material_ui_core_TableCell__WEBPACK_IMPORTED_MODULE_5__["default"], { align: 'right' }, (0,_util__WEBPACK_IMPORTED_MODULE_8__.prettyPrint)(candidate.performance, 4)),
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_material_ui_core_TableCell__WEBPACK_IMPORTED_MODULE_5__["default"], { align: 'right' }, (0,_util__WEBPACK_IMPORTED_MODULE_8__.prettyPrint)(candidate.pred_time, 3)),
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_material_ui_core_TableCell__WEBPACK_IMPORTED_MODULE_5__["default"], { align: 'right', style: { height: '50px' }, padding: 'none' },
                    react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_details_pipeline_visualization__WEBPACK_IMPORTED_MODULE_10__.PipelineVisualizationComponent, { structure: candidate.candidate[0].pipeline, candidate: candidate.candidate[1], selectedComponent: selectedComponent[0], onComponentSelection: this.openComponent })),
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_material_ui_core_TableCell__WEBPACK_IMPORTED_MODULE_5__["default"], null,
                    react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_util_jupyter_button__WEBPACK_IMPORTED_MODULE_11__.JupyterButton, { onClick: this.openCandidateInJupyter }),
                    react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_material_ui_core__WEBPACK_IMPORTED_MODULE_1__.IconButton, { "aria-label": 'expand row', size: 'small', onClick: this.toggleDetails }, this.state.open ? react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_material_ui_icons_KeyboardArrowUp__WEBPACK_IMPORTED_MODULE_12__["default"], null) : react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_material_ui_icons_KeyboardArrowDown__WEBPACK_IMPORTED_MODULE_13__["default"], null)))),
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_material_ui_core_TableRow__WEBPACK_IMPORTED_MODULE_4__["default"], null,
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_material_ui_core_TableCell__WEBPACK_IMPORTED_MODULE_5__["default"], { style: { padding: 0 }, colSpan: 6 },
                    react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_material_ui_core_Collapse__WEBPACK_IMPORTED_MODULE_14__["default"], { in: this.state.open, timeout: 'auto', unmountOnExit: false, mountOnEnter: true },
                        react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_material_ui_core__WEBPACK_IMPORTED_MODULE_1__.Box, { margin: 1, style: { marginBottom: '5em' } },
                            react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_candidate_inspections__WEBPACK_IMPORTED_MODULE_15__.CandidateInspections, { structure: candidate.candidate[0], candidate: candidate.candidate[1], componentId: selectedComponent[0], componentLabel: selectedComponent[1], meta: meta, explanations: explanations, onComparisonRequest: onComparisonRequest, structures: structures })))))));
    }
}
LeaderboardRow.contextType = _util__WEBPACK_IMPORTED_MODULE_8__.JupyterContext;
class BasicMenu extends (react__WEBPACK_IMPORTED_MODULE_0___default().Component) {
    constructor(props) {
        super(props);
        this.ref = react__WEBPACK_IMPORTED_MODULE_0___default().createRef();
        this.state = { open: false };
        this.handleClick = this.handleClick.bind(this);
        this.handleClose = this.handleClose.bind(this);
        this.handleHide = this.handleHide.bind(this);
    }
    handleClick(e) {
        this.setState((state) => ({ open: !state.open }));
        e.stopPropagation();
    }
    handleClose(e) {
        this.setState({ open: false });
        e.stopPropagation();
    }
    handleHide(e) {
        this.props.onHide();
        this.handleClose(e);
    }
    render() {
        var _a;
        return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { ref: this.ref, style: { display: 'inline' } },
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_material_ui_core__WEBPACK_IMPORTED_MODULE_1__.IconButton, { "aria-label": 'expand row', size: 'small', onClick: this.handleClick },
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_material_ui_icons__WEBPACK_IMPORTED_MODULE_2__.MoreVert, null)),
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_material_ui_core__WEBPACK_IMPORTED_MODULE_1__.Menu, { anchorEl: (_a = this.ref) === null || _a === void 0 ? void 0 : _a.current, open: this.state.open, onClose: this.handleClose },
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_material_ui_core__WEBPACK_IMPORTED_MODULE_1__.MenuItem, { onClick: this.handleHide }, "Hide"))));
    }
}
class Leaderboard extends (react__WEBPACK_IMPORTED_MODULE_0___default().Component) {
    constructor(props) {
        super(props);
        const order = this.props.meta.is_minimization ? 'asc' : 'desc';
        const orderBy = 'performance';
        this.state = {
            rows: this.calculateData(order, orderBy),
            order: order,
            orderBy: orderBy,
            page: 0,
            rowsPerPage: 10,
            selectedRow: undefined,
            comparisonType: undefined
        };
        this.handleRequestSort = this.handleRequestSort.bind(this);
        this.handleSelectAllClick = this.handleSelectAllClick.bind(this);
        this.handleRowClick = this.handleRowClick.bind(this);
        this.handleChangePage = this.handleChangePage.bind(this);
        this.handleChangeRowsPerPage = this.handleChangeRowsPerPage.bind(this);
        this.handleComparisonRequest = this.handleComparisonRequest.bind(this);
    }
    handleComparisonRequest(type, selectedRow) {
        this.setState({ comparisonType: type, selectedRow: selectedRow });
    }
    handleRequestSort(_, property) {
        const isAsc = this.state.orderBy === property && this.state.order === 'asc';
        const order = isAsc ? 'desc' : 'asc';
        this.setState({ rows: this.calculateData(order, property), order: order, orderBy: property });
    }
    handleSelectAllClick(event) {
        if (event.target.checked) {
            const newSelected = this.state.rows.map((n) => n.id);
            this.props.onCandidateSelection(new Set(newSelected));
        }
        else {
            this.props.onCandidateSelection(new Set());
        }
    }
    handleRowClick(id) {
        const selected = new Set(this.props.selectedCandidates);
        if (selected.has(id)) {
            selected.delete(id);
        }
        else {
            selected.add(id);
        }
        this.props.onCandidateSelection(selected);
    }
    handleChangePage(_, newPage) {
        this.setState({ page: newPage });
    }
    handleChangeRowsPerPage(event) {
        this.setState({ rowsPerPage: parseInt(event.target.value, 10), page: 0 });
    }
    componentDidUpdate(prevProps, prevState, snapshot) {
        if (prevProps.structures !== this.props.structures || prevProps.hideUnselectedCandidates !== this.props.hideUnselectedCandidates)
            this.setState({ rows: this.calculateData(this.state.order, this.state.orderBy) });
        if (prevProps.showCandidate !== this.props.showCandidate && this.props.showCandidate !== undefined) {
            const idx = this.state.rows.map(c => c.id).indexOf(this.props.showCandidate);
            const page = Math.trunc(idx / this.state.rowsPerPage);
            this.setState({ page: page });
        }
    }
    calculateData(order, orderBy) {
        const rows = [];
        const comp = (a, b) => {
            const sign = order === 'desc' ? 1 : -1;
            if (b[orderBy] < a[orderBy])
                return sign * -1;
            if (b[orderBy] > a[orderBy])
                return sign * 1;
            return 0;
        };
        this.props.structures.forEach(structure => {
            structure.configs
                .filter(c => c.filled)
                .filter(c => !this.props.hideUnselectedCandidates || this.props.selectedCandidates.has(c.id))
                .forEach(c => {
                rows.push({
                    id: c.id,
                    pred_time: c.runtime.prediction_time,
                    performance: c.loss,
                    candidate: [structure, c]
                });
            });
        });
        return rows.sort(comp);
    }
    render() {
        const { structures, explanations, hiddenCandidates } = this.props;
        const { rows, order, orderBy, page, rowsPerPage } = this.state;
        const headCells = [
            { id: 'id', numeric: false, sortable: true, label: 'Id', width: '40px' },
            { id: 'performance', numeric: true, sortable: true, label: 'Performance', width: '100px' },
            { id: 'pred_time', numeric: true, sortable: true, label: 'Pred. Time', width: '60px' },
            { id: 'candidate', numeric: false, sortable: false, label: 'Pipeline', width: 'auto' }
        ];
        return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: 'comparison-anchor' },
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_material_ui_core__WEBPACK_IMPORTED_MODULE_1__.TableContainer, null,
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_material_ui_core__WEBPACK_IMPORTED_MODULE_1__.Table, { style: { tableLayout: 'fixed' }, size: "small", onMouseDown: (e => {
                        // Prevent browser from highlighting clicked table cells.
                        // See https://stackoverflow.com/questions/5067644/html-table-when-i-ctrlclick-the-border-of-the-cell-appears
                        if (e.ctrlKey)
                            e.preventDefault();
                    }) },
                    react__WEBPACK_IMPORTED_MODULE_0___default().createElement(LeaderboardHeader, { headCells: headCells, numSelected: this.props.selectedCandidates.size, order: order, orderBy: orderBy, onSelectAllClick: this.handleSelectAllClick, onRequestSort: this.handleRequestSort, rowCount: rows.length }),
                    react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_material_ui_core_TableBody__WEBPACK_IMPORTED_MODULE_16__["default"], null, rows
                        .filter(s => !hiddenCandidates.has(s.id))
                        .slice(page * rowsPerPage, page * rowsPerPage + rowsPerPage)
                        .map(row => {
                        return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement(LeaderboardRow, { key: row.id, candidate: row, meta: this.props.meta, selected: this.props.selectedCandidates.has(row.id), onRowClick: this.handleRowClick, onRowHide: this.props.onCandidateHide, structures: structures, explanations: explanations, onComparisonRequest: this.handleComparisonRequest, open: row.id === this.props.showCandidate }));
                    })))),
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_material_ui_core_TablePagination__WEBPACK_IMPORTED_MODULE_17__["default"], { rowsPerPageOptions: [10, 20, 30], component: 'div', count: rows.length - hiddenCandidates.size, rowsPerPage: rowsPerPage, page: page, onPageChange: this.handleChangePage, onRowsPerPageChange: this.handleChangeRowsPerPage }),
            this.state.comparisonType !== undefined &&
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_comparison__WEBPACK_IMPORTED_MODULE_18__.Comparison, { meta: this.props.meta, type: this.state.comparisonType, onClose: () => this.handleComparisonRequest(undefined, undefined), models: rows.filter(r => this.props.selectedCandidates.has(r.id))
                        .map(r => new _details_model__WEBPACK_IMPORTED_MODULE_19__.DetailsModel(r.candidate[0], r.candidate[1], _util__WEBPACK_IMPORTED_MODULE_8__.Components.SOURCE, _util__WEBPACK_IMPORTED_MODULE_8__.Components.SOURCE, this.state.selectedRow)) })));
    }
}


/***/ }),

/***/ "./lib/components/optimization_overview.js":
/*!*************************************************!*\
  !*** ./lib/components/optimization_overview.js ***!
  \*************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "GeneralInformation": () => (/* binding */ GeneralInformation)
/* harmony export */ });
/* harmony import */ var _general_meta_information__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./general/meta_information */ "./lib/components/general/meta_information.js");
/* harmony import */ var _util_collapse__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../util/collapse */ "./lib/util/collapse.js");
/* harmony import */ var _general_performance_timeline__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./general/performance_timeline */ "./lib/components/general/performance_timeline.js");
/* harmony import */ var _general_roc_curve__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./general/roc_curve */ "./lib/components/general/roc_curve.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _material_ui_lab__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @material-ui/lab */ "webpack/sharing/consume/default/@material-ui/lab/@material-ui/lab");
/* harmony import */ var _material_ui_lab__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_material_ui_lab__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _material_ui_core__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @material-ui/core */ "webpack/sharing/consume/default/@material-ui/core/@material-ui/core?df94");
/* harmony import */ var _material_ui_core__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_material_ui_core__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _util__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../util */ "./lib/util.js");
/* harmony import */ var _general_performance_distribution__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./general/performance_distribution */ "./lib/components/general/performance_distribution.js");









class GeneralInformation extends (react__WEBPACK_IMPORTED_MODULE_0___default().Component) {
    constructor(props) {
        super(props);
        this.state = { timeline: [], openTab: '1' };
        this.switchTab = this.switchTab.bind(this);
    }
    componentDidMount() {
        const runTimeline = [].concat(...this.props.structures.map(s => s.configs))
            .map((c) => ({ timestamp: c.runtime.timestamp, performance: c.loss, cid: c.id }))
            .sort((a, b) => a.timestamp - b.timestamp);
        this.setState({ timeline: runTimeline });
    }
    switchTab(_, selectedTab) {
        this.setState({ openTab: selectedTab });
    }
    render() {
        const { meta, selectedCandidates, onCandidateSelection } = this.props;
        const { openTab } = this.state;
        return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement((react__WEBPACK_IMPORTED_MODULE_0___default().Fragment), null,
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_general_meta_information__WEBPACK_IMPORTED_MODULE_3__["default"], { meta: meta }),
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_util_collapse__WEBPACK_IMPORTED_MODULE_4__.CollapseComp, { name: 'performance-overview', showInitial: true, help: _general_performance_timeline__WEBPACK_IMPORTED_MODULE_5__["default"].HELP },
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement("h4", null, "Performance Overview"),
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_material_ui_lab__WEBPACK_IMPORTED_MODULE_1__.TabContext, { value: openTab },
                    react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_material_ui_core__WEBPACK_IMPORTED_MODULE_2__.Box, { sx: { borderBottom: 1, borderColor: 'divider' } },
                        react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_material_ui_core__WEBPACK_IMPORTED_MODULE_2__.Tabs, { value: openTab, onChange: this.switchTab, style: { minHeight: 0 }, TabIndicatorProps: {
                                style: { backgroundColor: _util__WEBPACK_IMPORTED_MODULE_6__.Colors.HIGHLIGHT }
                            } },
                            react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_material_ui_core__WEBPACK_IMPORTED_MODULE_2__.Tab, { className: 'tab-small', label: "Timeline", value: '1' }),
                            react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_material_ui_core__WEBPACK_IMPORTED_MODULE_2__.Tab, { className: 'tab-small', label: "Distribution", value: '2' }))),
                    react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_material_ui_lab__WEBPACK_IMPORTED_MODULE_1__.TabPanel, { value: '1' },
                        react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_general_performance_timeline__WEBPACK_IMPORTED_MODULE_5__["default"], { data: this.state.timeline, meta: meta, height: 220, selectedCandidates: selectedCandidates, onCandidateSelection: onCandidateSelection })),
                    react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_material_ui_lab__WEBPACK_IMPORTED_MODULE_1__.TabPanel, { value: '2', style: { padding: 0, paddingTop: "5px" } },
                        react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_general_performance_distribution__WEBPACK_IMPORTED_MODULE_7__["default"], { data: this.state.timeline, meta: meta, height: 220 })))),
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_util_collapse__WEBPACK_IMPORTED_MODULE_4__.CollapseComp, { name: 'roc-curve', showInitial: true, help: _general_roc_curve__WEBPACK_IMPORTED_MODULE_8__.RocCurve.HELP },
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement("h4", null, "ROC Curve"),
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_general_roc_curve__WEBPACK_IMPORTED_MODULE_8__.RocCurve, { selectedCandidates: selectedCandidates, height: 250 }))));
    }
}


/***/ }),

/***/ "./lib/components/pc/brush.js":
/*!************************************!*\
  !*** ./lib/components/pc/brush.js ***!
  \************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "SVGBrush": () => (/* binding */ SVGBrush)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);

class SVGBrush extends (react__WEBPACK_IMPORTED_MODULE_0___default().Component) {
    constructor(props) {
        super(props);
        this.container = react__WEBPACK_IMPORTED_MODULE_0___default().createRef();
        this.state = { selection: undefined };
        this.initialPosition = undefined;
        this.handleBrushStart = this.handleBrushStart.bind(this);
        this.handleBrushMove = this.handleBrushMove.bind(this);
        this.handleBrushEnd = this.handleBrushEnd.bind(this);
    }
    handleBrushStart(e) {
        if (this.point === undefined)
            this.point = this.props.svg.current.createSVGPoint();
        const scale = this.props.layout.yScale;
        e.target.setPointerCapture(e.pointerId);
        this.initialPosition = scale.invert(this.getPosition(e));
        this.props.onBrushStart({
            type: 'start',
            selection: [this.initialPosition, this.initialPosition],
            sourceEvent: e
        });
        e.preventDefault();
        e.stopPropagation();
    }
    ;
    handleBrushMove(e) {
        if (this.initialPosition) {
            const scale = this.props.layout.yScale;
            const y = this.getPosition(e);
            const capped = Math.max(Math.min(y, scale.range()[1]), scale.range()[0]);
            const minY = Math.min(this.initialPosition, scale.invert(capped));
            const maxY = Math.max(this.initialPosition, scale.invert(capped));
            const selection = [minY, maxY];
            this.setState({ selection });
            this.props.onBrush({
                type: 'brush',
                selection: selection,
                sourceEvent: e
            });
        }
    }
    handleBrushEnd(e) {
        const scale = this.props.layout.yScale;
        const move = this.getPosition(e);
        let selection = this.state.selection;
        if (selection != undefined) {
            // Delete selection from previous brushing if only click
            if (Math.abs(scale(this.initialPosition) - move) < 10)
                selection = undefined;
            this.setState({ selection: selection });
            SVGBrush.preventClick();
            this.props.onBrushEnd({
                type: 'end',
                selection: selection,
                sourceEvent: e
            });
        }
        this.initialPosition = undefined;
    }
    static preventClick() {
        // capture onClick event to prevent collapsing axis
        window.addEventListener('click', (e) => e.stopPropagation(), { once: true, capture: true });
    }
    getPosition(event) {
        this.point.x = event.clientX;
        this.point.y = event.clientY;
        return this.point.matrixTransform(this.container.current.getScreenCTM().inverse()).y;
    }
    render() {
        const { layout, svg } = this.props;
        const { selection } = this.state;
        const scale = layout.yScale;
        return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement((react__WEBPACK_IMPORTED_MODULE_0___default().Fragment), null, svg !== undefined &&
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement("g", { className: "brush", ref: this.container },
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement("rect", { className: "pc-brush-overlay", x: layout.x, y: layout.y, width: layout.width, height: layout.height, onPointerDown: this.handleBrushStart, onPointerMove: this.handleBrushMove, onPointerUp: this.handleBrushEnd }),
                selection && react__WEBPACK_IMPORTED_MODULE_0___default().createElement("rect", { className: "pc-brush-selection", x: layout.x, y: scale(selection[1]), width: layout.width, height: scale(selection[0]) - scale(selection[1]) }))));
    }
}
SVGBrush.defaultProps = {
    onBrushStart: (_) => {
    },
    onBrush: (_) => {
    },
    onBrushEnd: (_) => {
    },
};


/***/ }),

/***/ "./lib/components/pc/constants.js":
/*!****************************************!*\
  !*** ./lib/components/pc/constants.js ***!
  \****************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Constants": () => (/* binding */ Constants)
/* harmony export */ });
var Constants;
(function (Constants) {
    Constants.TEXT_ROTATION = -25;
    Constants.CIRCLE_SIZE = 15;
    Constants.TEXT_HEIGHT = 17;
    Constants.TICK_LENGTH = 10;
})(Constants || (Constants = {}));


/***/ }),

/***/ "./lib/components/pc/model.js":
/*!************************************!*\
  !*** ./lib/components/pc/model.js ***!
  \************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "CPCContext": () => (/* binding */ CPCContext),
/* harmony export */   "Model": () => (/* binding */ Model),
/* harmony export */   "Axis": () => (/* binding */ Axis),
/* harmony export */   "Choice": () => (/* binding */ Choice),
/* harmony export */   "Domain": () => (/* binding */ Domain),
/* harmony export */   "Layout": () => (/* binding */ Layout),
/* harmony export */   "Line": () => (/* binding */ Line),
/* harmony export */   "LinePoint": () => (/* binding */ LinePoint),
/* harmony export */   "Type": () => (/* binding */ Type),
/* harmony export */   "PARENT_MARKER": () => (/* binding */ PARENT_MARKER)
/* harmony export */ });
/* harmony import */ var _util__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./util */ "./lib/components/pc/util.js");
/* harmony import */ var d3__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! d3 */ "webpack/sharing/consume/default/d3/d3");
/* harmony import */ var d3__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(d3__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _constants__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./constants */ "./lib/components/pc/constants.js");
/* harmony import */ var _util__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../util */ "./lib/util.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);





const CPCContext = react__WEBPACK_IMPORTED_MODULE_1___default().createContext(undefined);
class Model {
    constructor(axes, lines) {
        this.axes = axes;
        this.lines = lines;
        this.memState_ = Math.random();
        this.axesMap = new Map();
        this.cacheAxes(axes);
    }
    getAxis(id) {
        return this.axesMap.get(id);
    }
    set explanations(explanation) {
        this.explanations_ = explanation;
    }
    getExplanations(axis) {
        var _a;
        return (_a = this.explanations_) === null || _a === void 0 ? void 0 : _a.get(axis.name);
    }
    updateMemState() {
        this.memState_ = Math.random();
    }
    get memState() {
        return this.memState_;
    }
    // noinspection JSMethodCanBeStatic
    cacheAxes(columns) {
        columns.forEach(column => {
            column.forEach(row => {
                this.axesMap.set(row.id, row);
                row.choices.forEach(c => this.cacheAxes(c.axes));
            });
        });
    }
}
class Axis {
    constructor(id, name, label, type, domain, choices) {
        this.id = id;
        this.name = name;
        this.label = label;
        this.type = type;
        if (this.isNumerical()) {
            if (domain === undefined)
                throw new Error('Domain has to be provided for a numerical axis');
            choices = new Array();
        }
        else {
            if (choices === undefined)
                throw new Error('Choices has to be provided for a categorical axis');
            domain = new Domain(0, choices.length, false);
        }
        this.domain = domain;
        this.choices = choices;
    }
    static Numerical(id, name, domain) {
        const tokens = name.split(':');
        return new Axis(id, name, tokens[tokens.length - 1], Type.NUMERICAL, domain);
    }
    static Categorical(id, name, choices) {
        const tokens = (choices.length === 1 ? (0,_util__WEBPACK_IMPORTED_MODULE_2__.prettyPrint)(choices[0].label) : name).split(':');
        return new Axis(id, name, tokens[tokens.length - 1], Type.CATEGORICAL, undefined, choices);
    }
    isNumerical() {
        return this.type == Type.NUMERICAL;
    }
    getWidthWeight() {
        return Math.max(1, ...this.choices.map(c => c.getWidthWeight()));
    }
    getHeightWeight() {
        if (this.isNumerical()) {
            return 3;
        }
        else {
            return Math.max(1, this.choices.map(c => c.getHeightWeight()).reduce((a, b) => a + b, 0));
        }
    }
    layout(xScale, yRange) {
        const adjustedYRange = [
            yRange[0] + 1.5 * _constants__WEBPACK_IMPORTED_MODULE_3__.Constants.TEXT_HEIGHT,
            yRange[1] - 1.5 * _constants__WEBPACK_IMPORTED_MODULE_3__.Constants.TEXT_HEIGHT
        ];
        const yScale = this.isNumerical() ?
            this.domain.asScale(adjustedYRange) :
            _util__WEBPACK_IMPORTED_MODULE_4__.ParCord.yScale(this.choices, adjustedYRange);
        const x = xScale(this.id);
        const y = yScale.range()[0];
        const width = this.getWidthWeight() * xScale.bandwidth();
        const height = yScale.range()[1] - yScale.range()[0];
        this.layout_ = new Layout(x, y, width, height, yScale);
        this.choices.forEach(c => c.layout([x, x + width], yScale));
    }
    clearLayout() {
        this.layout_ = undefined;
        this.choices.forEach(c => c.axes.forEach(column => column.forEach(row => row.clearLayout())));
    }
    getLayout() {
        return this.layout_;
    }
    resetSelection(choice) {
        this.choices.filter(c => (choice === null || choice === void 0 ? void 0 : choice.value) !== c.value).forEach(c => c.resetSelected());
    }
}
class Choice {
    constructor(value, axes = [], collapsible = true, label) {
        this.value = value;
        this.axes = axes;
        this.collapsible = collapsible;
        this.label = label;
        this.collapsed = collapsible;
        if (!label)
            this.label = value;
        this.selected = false;
    }
    collapse() {
        if (this.collapsible && !this.collapsed) {
            this.collapsed = true;
            this.axes.forEach(column => column.forEach(row => row.choices.forEach(c => c.collapse())));
        }
    }
    expand() {
        if (this.isExpandable())
            this.collapsed = false;
    }
    isCollapsed() {
        return this.collapsed;
    }
    isExpandable() {
        return this.collapsed && Math.max(...this.axes.map(a => a.length)) === 1 && this.axes[0].length > 0;
    }
    toggleSelected() {
        this.selected = !this.selected;
        return this.selected;
    }
    getSelected() {
        return this.selected ? this : undefined;
    }
    resetSelected() {
        this.selected = false;
    }
    getWidthWeight() {
        if (this.collapsed || this.axes.length === 0) {
            return 1;
        }
        else {
            return this.axes.map(column => Math.max(...column.map(row => row.getWidthWeight()))).reduce((a, b) => a + b);
        }
    }
    getHeightWeight() {
        if (this.collapsed || this.axes.length === 0) {
            return 1;
        }
        else {
            // noinspection UnnecessaryLocalVariableJS
            const columns = this.axes;
            return Math.max(1, ...columns.map(column => column.map(row => row.getHeightWeight()).reduce((a, b) => a + b) + column.length));
        }
    }
    layout(xRange, yScale) {
        const xScales = _util__WEBPACK_IMPORTED_MODULE_4__.ParCord.xScale(this.axes, xRange);
        const x = xRange[0];
        const width = xRange[1] - xRange[0];
        const y = yScale(this.value.toString());
        const height = this.getHeightWeight() * yScale.bandwidth();
        this.layout_ = new Layout(x, y, width, height, yScale);
        const columns = this.axes;
        if (!this.isCollapsed()) {
            columns.forEach(column => {
                const cumHeight = column.map(r => r.getHeightWeight()).reduce((a, b) => a + b, 0);
                let start = y;
                column.forEach((row, rowIdx) => {
                    const fracHeight = height * (row.getHeightWeight() / cumHeight);
                    row.layout(xScales[rowIdx], [start, start + fracHeight]);
                    start += fracHeight;
                });
            });
        }
        else {
            columns.forEach(column => column.forEach(row => row.clearLayout()));
        }
    }
    getLayout() {
        return this.layout_;
    }
}
class Domain {
    constructor(min, max, log) {
        this.log = log;
        if (min == max) {
            min = _util__WEBPACK_IMPORTED_MODULE_4__.ParCord.guessMinimum(min);
            max = _util__WEBPACK_IMPORTED_MODULE_4__.ParCord.guessMaximum(max);
        }
        this.min = min;
        this.max = max;
    }
    asScale(range) {
        const domain = [this.max, this.min];
        if (this.log && this.min > 0 && this.max > 0)
            return d3__WEBPACK_IMPORTED_MODULE_0__.scaleLog(domain, range);
        else
            return d3__WEBPACK_IMPORTED_MODULE_0__.scaleLinear(domain, range);
    }
}
class Layout {
    constructor(x, y, width, height, yScale) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.yScale = yScale;
    }
    centeredX() {
        return this.x + this.width / 2;
    }
    centeredY() {
        return this.y + this.height / 2;
    }
    perfEstScale(domain = [[0, 1]]) {
        const max = Math.max(...domain.map(([_, v]) => v));
        return d3__WEBPACK_IMPORTED_MODULE_0__.scaleLinear([0, max * 1.1], [0, this.width / 2]);
    }
}
class Line {
    constructor(id, points, timestamp) {
        this.id = id;
        this.points = points;
        this.timestamp = timestamp;
        this.choices = new Set();
        points
            .filter(p => typeof p.value === 'string' || typeof p.value === 'boolean')
            .map(p => this.choices.add(`${p.axis}_${p.value}`));
        this.pointMap = new Map(points.map(p => [p.axis, p.value]));
    }
    intersects(axis, filter) {
        if (filter instanceof Choice)
            return this.choices.has(`${axis.id}_${filter.value}`);
        else {
            const value = this.pointMap.get(axis.id);
            return filter[0] <= value && value <= filter[1];
        }
    }
}
class LinePoint {
    constructor(axis, value) {
        this.axis = axis;
        this.value = value;
    }
}
var Type;
(function (Type) {
    Type[Type["CATEGORICAL"] = 0] = "CATEGORICAL";
    Type[Type["NUMERICAL"] = 1] = "NUMERICAL";
})(Type || (Type = {}));
const PARENT_MARKER = '__parent__';


/***/ }),

/***/ "./lib/components/pc/parallel_corrdinates.js":
/*!***************************************************!*\
  !*** ./lib/components/pc/parallel_corrdinates.js ***!
  \***************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "ParallelCoordinates": () => (/* binding */ ParallelCoordinates)
/* harmony export */ });
/* harmony import */ var _model__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./model */ "./lib/components/pc/model.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var d3__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! d3 */ "webpack/sharing/consume/default/d3/d3");
/* harmony import */ var d3__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(d3__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _util__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./util */ "./lib/components/pc/util.js");
/* harmony import */ var _pc_choice__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./pc_choice */ "./lib/components/pc/pc_choice.js");
/* harmony import */ var _pc_line__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./pc_line */ "./lib/components/pc/pc_line.js");
/* harmony import */ var _util_flexible_svg__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../../util/flexible-svg */ "./lib/util/flexible-svg.js");
/* harmony import */ var _material_ui_core__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @material-ui/core */ "webpack/sharing/consume/default/@material-ui/core/@material-ui/core?df94");
/* harmony import */ var _material_ui_core__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_material_ui_core__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _util_warning__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../../util/warning */ "./lib/util/warning.js");
/* harmony import */ var _util_jupyter_button__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../util/jupyter-button */ "./lib/util/jupyter-button.js");










class ParallelCoordinates extends (react__WEBPACK_IMPORTED_MODULE_0___default().Component) {
    constructor(props) {
        super(props);
        this.NODE_HEIGHT = 55;
        this.svg = react__WEBPACK_IMPORTED_MODULE_0___default().createRef();
        const [model, filter] = this.calcModel();
        this.model = model;
        const [root, height] = this.doLayout();
        this.state = {
            root: root,
            height: height,
            filter: filter,
            highlightedLines: this.props.selectedCandidates,
            container: undefined,
            showCandidates: true,
            showExplanations: this.props.showExplanations,
        };
        this.onCollapse = this.onCollapse.bind(this);
        this.onExpand = this.onExpand.bind(this);
        this.highlightLines = this.highlightLines.bind(this);
        this.updateContainer = this.updateContainer.bind(this);
        this.onSelectLine = this.onSelectLine.bind(this);
        this.onShowCandidate = this.onShowCandidate.bind(this);
        this.onAxisSelection = this.onAxisSelection.bind(this);
    }
    calcModel() {
        const candidates = this.props.candidates !== undefined ?
            this.props.candidates : [].concat(...this.props.structures.map(s => s.configs.map(c => [c, s])));
        const axes = _util__WEBPACK_IMPORTED_MODULE_3__.ParCord.parseConfigSpace(this.props.structures, this.props.perfAxis);
        if (this.props.expand || axes.length <= 3)
            axes.forEach(column => column.filter(row => !row.isNumerical() && row.choices.length === 1)
                .forEach(row => row.choices[0].expand()));
        const lines = _util__WEBPACK_IMPORTED_MODULE_3__.ParCord.parseCandidates(candidates, axes);
        const filter = new Map();
        return [new _model__WEBPACK_IMPORTED_MODULE_4__.Model(axes, lines), filter];
    }
    doLayout() {
        var _a;
        const container = (_a = this === null || this === void 0 ? void 0 : this.state) === null || _a === void 0 ? void 0 : _a.container;
        const width = (container && container.current) ? container.current.clientWidth : 0;
        const root = new _model__WEBPACK_IMPORTED_MODULE_4__.Choice('', this.model.axes, false);
        // Estimate height based on maximum number of choices in all coordinates
        const maxNodes = Math.max(...root.axes.map(column => column.map(row => row.getHeightWeight()).reduce((a, b) => a + b)));
        const height = this.NODE_HEIGHT * maxNodes;
        const yScale = d3__WEBPACK_IMPORTED_MODULE_1__.scaleBand([root.value.toString()], [0, height / root.getHeightWeight()]);
        root.layout([0, width], yScale);
        this.model.updateMemState();
        return [root, height];
    }
    componentDidUpdate(prevProps, prevState, snapshot) {
        if (prevProps.selectedCandidates.size !== this.props.selectedCandidates.size)
            this.setState({ highlightedLines: this.props.selectedCandidates });
        if (prevProps.structures.length !== this.props.structures.length ||
            prevProps.structures.map(c => c.configs.length).reduce((a, b) => a + b, 0) !== this.props.structures.map(c => c.configs.length).reduce((a, b) => a + b, 0)) {
            const [model, filter] = this.calcModel();
            this.model = model;
            const [root, height] = this.doLayout();
            this.setState({ root: root, height: height, filter: filter });
        }
    }
    componentDidMount() {
        window.setTimeout(() => {
            const [root, height] = this.doLayout();
            this.setState({ root: root, height: height });
        }, 100);
    }
    onCollapse(choice) {
        choice.collapse();
        const [root, height] = this.doLayout();
        this.setState({ root: root, height: height });
    }
    onExpand(choice) {
        choice.expand();
        const [root, height] = this.doLayout();
        this.setState({ root: root, height: height });
    }
    highlightLines(axis, filter) {
        if (axis === undefined)
            return;
        else if (filter === undefined)
            this.state.filter.delete(axis);
        else
            this.state.filter.set(axis, filter);
        const highlights = this.calculateHighlightedLines(this.model.lines, this.state.filter);
        this.setState({ highlightedLines: highlights, filter: this.state.filter });
        this.props.onCandidateSelection(highlights);
    }
    onAxisSelection(axis) {
        this.props.onAxisSelection(axis.id);
    }
    calculateHighlightedLines(lines, filter) {
        const normal = [];
        const highlights = [];
        lines.forEach(l => {
            let matches = undefined;
            filter.forEach((value, key) => matches = (matches || matches === undefined) && l.intersects(key, value));
            (matches !== undefined && matches) ? highlights.push(l) : normal.push(l);
        });
        return new Set(highlights.map(l => l.id));
    }
    updateContainer(container) {
        this.setState({ container: container });
    }
    onSelectLine(cid) {
        const selected = new Set(this.props.selectedCandidates);
        if (this.props.selectedCandidates.has(cid))
            selected.delete(cid);
        else
            selected.add(cid);
        this.props.onCandidateSelection(selected);
    }
    onShowCandidate(cid) {
        this.props.onCandidateSelection(new Set([cid]), true);
    }
    renderLine(line, idx, onlyHighlighted, missing) {
        if (idx == this.props.timestamp || onlyHighlighted === this.state.highlightedLines.has(line.id))
            return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_pc_line__WEBPACK_IMPORTED_MODULE_5__.PCLine, { key: line.id, line: line, missing: missing, selected: idx == this.props.timestamp, highlight: this.state.highlightedLines.has(line.id), onClick: this.onSelectLine, onAlternativeClick: this.onShowCandidate }));
    }
    render() {
        this.model.explanations = this.props.explanation;
        const lines = this.model.lines
            .slice(0, this.props.timestamp + 1)
            .filter(line => !this.props.hideUnselectedCandidates || this.props.selectedCandidates.has(line.id));
        return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement((react__WEBPACK_IMPORTED_MODULE_0___default().Fragment), null,
            this.props.explanation &&
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { style: { float: 'right', height: '53px' } },
                    react__WEBPACK_IMPORTED_MODULE_0___default().createElement("label", { className: 'MuiFormControlLabel-root' },
                        react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_material_ui_core__WEBPACK_IMPORTED_MODULE_2__.Checkbox, { checked: this.state.showExplanations, onChange: (_, checked) => this.setState({ showExplanations: checked }) }),
                        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("span", null, "Show\u00A0Surrogate\u00A0Model")),
                    react__WEBPACK_IMPORTED_MODULE_0___default().createElement("label", { className: 'MuiFormControlLabel-root' },
                        react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_material_ui_core__WEBPACK_IMPORTED_MODULE_2__.Checkbox, { checked: this.state.showCandidates, onChange: (_, checked) => this.setState({ showCandidates: checked }) }),
                        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("span", null, "Show\u00A0Candidates")),
                    this.props.onExport && react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_util_jupyter_button__WEBPACK_IMPORTED_MODULE_6__.JupyterButton, { onClick: this.props.onExport })),
            !this.props.explanation && react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_util_warning__WEBPACK_IMPORTED_MODULE_7__.WarningIndicator, { message: 'Surrogate model visualization not available' }),
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_util_flexible_svg__WEBPACK_IMPORTED_MODULE_8__.RefableFlexibleSvg, { height: this.state.height, onContainerChange: this.updateContainer, ref: this.svg },
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_model__WEBPACK_IMPORTED_MODULE_4__.CPCContext.Provider, { value: {
                        svg: this.model.lines.length > 1 ? this.svg : undefined,
                        showExplanations: this.state.showExplanations,
                        model: this.model,
                        selectedAxis: this.props.selectedAxis
                    } },
                    this.state.showCandidates &&
                        react__WEBPACK_IMPORTED_MODULE_0___default().createElement((react__WEBPACK_IMPORTED_MODULE_0___default().Fragment), null,
                            lines.map((line, idx) => this.renderLine(line, idx, false, true)),
                            lines.map((line, idx) => this.renderLine(line, idx, true, true))),
                    react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_pc_choice__WEBPACK_IMPORTED_MODULE_9__.PCChoice, { choice: this.state.root, parent: undefined, onCollapse: this.onCollapse, onExpand: this.onExpand, onHighlight: this.highlightLines, onAxisSelection: this.onAxisSelection }),
                    this.state.showCandidates &&
                        react__WEBPACK_IMPORTED_MODULE_0___default().createElement((react__WEBPACK_IMPORTED_MODULE_0___default().Fragment), null,
                            lines.map((line, idx) => this.renderLine(line, idx, false, false)),
                            lines.map((line, idx) => this.renderLine(line, idx, true, false)))))));
    }
}
ParallelCoordinates.HELP = 'Overview of the complete search space traversed by the Bayesian optimizer including ' +
    'selected configurations. Each axis represents a single tunable hyperparameter. For a better overview, ' +
    'related hyperparameters, e.g. all hyperparameters of a single component, can be collapsed. Each horizontal ' +
    'line represents a single selected configuration. Configurations can be selected via brushing numerical ' +
    'axes, hovering categorical values or clicking/hovering single lines.' +
    '\n\n' +
    'In case of a model-based selection of the configuration, the areas in the background visualize the internal ' +
    'estimate of well performing regions of the surrogate model. If no information about the actual internal ' +
    'surrogate model are available, a surrogate model is simulated.' +
    '\n\n' +
    'If information about the surrogate model are available, the rendering of the surrogate model and/or the ' +
    'evaluated configurations can be controlled using the checkboxes at the top.';
ParallelCoordinates.defaultProps = {
    candidates: undefined,
    explanation: undefined,
    selectedCandidates: new Set(),
    selectedAxis: new Set(),
    hideUnselectedCandidates: false,
    showExplanations: false,
    expand: false,
    onCandidateSelection: () => {
    },
    onAxisSelection: () => {
    },
    onExport: undefined,
    timestamp: Infinity
};


/***/ }),

/***/ "./lib/components/pc/pc_axis.js":
/*!**************************************!*\
  !*** ./lib/components/pc/pc_axis.js ***!
  \**************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "PCAxis": () => (/* binding */ PCAxis)
/* harmony export */ });
/* harmony import */ var d3__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! d3 */ "webpack/sharing/consume/default/d3/d3");
/* harmony import */ var d3__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(d3__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _model__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./model */ "./lib/components/pc/model.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _pc_choice__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./pc_choice */ "./lib/components/pc/pc_choice.js");
/* harmony import */ var _util__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../util */ "./lib/util.js");
/* harmony import */ var _constants__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./constants */ "./lib/components/pc/constants.js");
/* harmony import */ var _brush__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./brush */ "./lib/components/pc/brush.js");
/* harmony import */ var uuid__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! uuid */ "./node_modules/uuid/index.js");
/* harmony import */ var uuid__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(uuid__WEBPACK_IMPORTED_MODULE_2__);









class DiscretePerfEstimates extends (react__WEBPACK_IMPORTED_MODULE_1___default().Component) {
    renderSingle(layout, scale, performance) {
        const { y, height } = layout;
        const centeredX = layout.centeredX();
        const perf = performance === undefined ? [0, scale.domain()[0]] : performance;
        return (react__WEBPACK_IMPORTED_MODULE_1___default().createElement("rect", { key: perf[0], className: 'pc-importance', fill: _util__WEBPACK_IMPORTED_MODULE_3__.Colors.DEFAULT, x: centeredX, y: y + height * 0.1, width: scale(perf[1]), height: height * 0.8 }));
    }
    render() {
        const { xScale, choices, perfEstimate } = this.props;
        if (perfEstimate === undefined)
            return react__WEBPACK_IMPORTED_MODULE_1___default().createElement((react__WEBPACK_IMPORTED_MODULE_1___default().Fragment), null);
        return (react__WEBPACK_IMPORTED_MODULE_1___default().createElement((react__WEBPACK_IMPORTED_MODULE_1___default().Fragment), null, choices.filter(c => c.isCollapsed())
            .map((c, i) => this.renderSingle(c.getLayout(), xScale, this.props.perfEstimate[i]))));
    }
}
class ContinuousPerfEstimate extends (react__WEBPACK_IMPORTED_MODULE_1___default().Component) {
    render() {
        const { xScale, yScale, layout, perfEstimate } = this.props;
        const centeredX = layout.centeredX();
        if (perfEstimate === undefined)
            return react__WEBPACK_IMPORTED_MODULE_1___default().createElement((react__WEBPACK_IMPORTED_MODULE_1___default().Fragment), null);
        const line = d3__WEBPACK_IMPORTED_MODULE_0__.area()
            .curve(d3__WEBPACK_IMPORTED_MODULE_0__.curveCardinal)
            .x0(() => centeredX)
            .x1(d => centeredX + xScale(d[1]))
            .y(d => yScale(d[0]));
        return (react__WEBPACK_IMPORTED_MODULE_1___default().createElement("path", { className: 'pc-importance', d: line(perfEstimate), fill: _util__WEBPACK_IMPORTED_MODULE_3__.Colors.DEFAULT }));
    }
}
class Axis extends (react__WEBPACK_IMPORTED_MODULE_1___default().Component) {
    tickPath(x, y) {
        const path = d3__WEBPACK_IMPORTED_MODULE_0__.path();
        if (this.props.direction == 'y') {
            path.moveTo(x - 0.8 * _constants__WEBPACK_IMPORTED_MODULE_4__.Constants.TICK_LENGTH, y);
        }
        else {
            path.moveTo(x, y + 0.8 * _constants__WEBPACK_IMPORTED_MODULE_4__.Constants.TICK_LENGTH);
        }
        path.lineTo(x, y);
        path.closePath();
        return path;
    }
    ticks(scale, tickCount) {
        const range = scale.range();
        return [...Array(tickCount)].map((_, i) => {
            const v = range[0] + i * (range[1] - range[0]) / (tickCount - 1);
            return { value: scale.invert(v), pos: v };
        });
    }
    renderYAxis() {
        const { y, height, yScale } = this.props.layout;
        const centeredX = this.props.layout.centeredX();
        const yTicks = this.props.showTicks ? this.ticks(yScale, 4) : [];
        return (react__WEBPACK_IMPORTED_MODULE_1___default().createElement((react__WEBPACK_IMPORTED_MODULE_1___default().Fragment), null,
            react__WEBPACK_IMPORTED_MODULE_1___default().createElement("path", { d: (0,d3__WEBPACK_IMPORTED_MODULE_0__.linkVertical)().x(d => d[0]).y(d => d[1])({
                    source: [centeredX, y],
                    target: [centeredX, y + height]
                }) }),
            yTicks.map(v => react__WEBPACK_IMPORTED_MODULE_1___default().createElement((react__WEBPACK_IMPORTED_MODULE_1___default().Fragment), null,
                react__WEBPACK_IMPORTED_MODULE_1___default().createElement("path", { d: this.tickPath(centeredX, v.pos).toString() }),
                react__WEBPACK_IMPORTED_MODULE_1___default().createElement("text", { x: centeredX - _constants__WEBPACK_IMPORTED_MODULE_4__.Constants.TICK_LENGTH, y: v.pos, className: 'pc-axis-tick pc-axis-y-tick' }, (0,_util__WEBPACK_IMPORTED_MODULE_3__.prettyPrint)(v.value))))));
    }
    renderXAxis() {
        const { x, y, width, height } = this.props.layout;
        const centeredX = this.props.layout.centeredX();
        const xTicks = this.ticks(this.props.xScale, 3);
        return (react__WEBPACK_IMPORTED_MODULE_1___default().createElement((react__WEBPACK_IMPORTED_MODULE_1___default().Fragment), null,
            react__WEBPACK_IMPORTED_MODULE_1___default().createElement("path", { d: (0,d3__WEBPACK_IMPORTED_MODULE_0__.linkHorizontal)().x(d => d[0]).y(d => d[1])({
                    source: [centeredX, y + height],
                    target: [x + width, y + height]
                }) }),
            xTicks.map(v => react__WEBPACK_IMPORTED_MODULE_1___default().createElement((react__WEBPACK_IMPORTED_MODULE_1___default().Fragment), null,
                react__WEBPACK_IMPORTED_MODULE_1___default().createElement("path", { d: this.tickPath(centeredX + v.pos, y + height).toString() }),
                react__WEBPACK_IMPORTED_MODULE_1___default().createElement("text", { x: centeredX + v.pos, y: y + height + _constants__WEBPACK_IMPORTED_MODULE_4__.Constants.TICK_LENGTH, className: 'pc-axis-tick pc-axis-x-tick' },
                    (0,_util__WEBPACK_IMPORTED_MODULE_3__.prettyPrint)(v.value, 2),
                    react__WEBPACK_IMPORTED_MODULE_1___default().createElement("title", null, (0,_util__WEBPACK_IMPORTED_MODULE_3__.prettyPrint)(v.value, 5)))))));
    }
    render() {
        if (this.props.direction === 'x')
            return this.renderXAxis();
        else
            return this.renderYAxis();
    }
}
class PCAxis extends (react__WEBPACK_IMPORTED_MODULE_1___default().Component) {
    constructor(props) {
        super(props);
        this.state = { hover: false };
        this.collapse = this.collapse.bind(this);
        this.onBrushEnd = this.onBrushEnd.bind(this);
    }
    isNumerical() {
        return this.props.axis.type == _model__WEBPACK_IMPORTED_MODULE_5__.Type.NUMERICAL;
    }
    collapse(e) {
        const { parent, onCollapse } = this.props;
        if (!parent.isCollapsed())
            onCollapse(parent);
        e.preventDefault();
        e.stopPropagation();
    }
    onBrushEnd(event) {
        this.props.onHighlight(this.props.axis, event.selection);
    }
    render() {
        const { axis, onExpand, onCollapse, onHighlight, onClick } = this.props;
        const { x, y, width, yScale } = axis.getLayout();
        const explanation = this.context.model.getExplanations(axis);
        const xScale = axis.getLayout().perfEstScale(explanation);
        const choices = axis.choices.map(c => react__WEBPACK_IMPORTED_MODULE_1___default().createElement(_pc_choice__WEBPACK_IMPORTED_MODULE_6__.PCChoice, { choice: c, parent: axis, onExpand: onExpand, onCollapse: onCollapse, onHighlight: onHighlight, onAxisSelection: onClick }));
        const id = `path-${(0,uuid__WEBPACK_IMPORTED_MODULE_2__.v4)()}`;
        const selectableTitle = (axis.isNumerical() || (choices.length > 1 && !PCAxis.STEP_AXIS.test(axis.id))) &&
            axis.id !== '__performance__';
        if (!axis.isNumerical() && choices.length === 0)
            return react__WEBPACK_IMPORTED_MODULE_1___default().createElement((react__WEBPACK_IMPORTED_MODULE_1___default().Fragment), null);
        return (react__WEBPACK_IMPORTED_MODULE_1___default().createElement("g", { className: 'pc-axis', onClick: this.collapse },
            react__WEBPACK_IMPORTED_MODULE_1___default().createElement(Axis, { direction: 'y', layout: axis.getLayout(), showTicks: this.isNumerical(), xScale: xScale }),
            (this.context.showExplanations && explanation) && react__WEBPACK_IMPORTED_MODULE_1___default().createElement((react__WEBPACK_IMPORTED_MODULE_1___default().Fragment), null,
                react__WEBPACK_IMPORTED_MODULE_1___default().createElement(Axis, { direction: 'x', layout: axis.getLayout(), showTicks: true, xScale: xScale }),
                this.isNumerical() ?
                    react__WEBPACK_IMPORTED_MODULE_1___default().createElement(ContinuousPerfEstimate, { xScale: xScale, yScale: yScale, layout: axis.getLayout(), perfEstimate: explanation }) :
                    react__WEBPACK_IMPORTED_MODULE_1___default().createElement(DiscretePerfEstimates, { xScale: xScale, choices: axis.choices, perfEstimate: explanation })),
            this.isNumerical() && react__WEBPACK_IMPORTED_MODULE_1___default().createElement(_brush__WEBPACK_IMPORTED_MODULE_7__.SVGBrush, { svg: this.context.svg, layout: axis.getLayout(), onBrushEnd: this.onBrushEnd }),
            react__WEBPACK_IMPORTED_MODULE_1___default().createElement("text", { className: `${selectableTitle ? 'pc-axis-label' : ''} ${this.context.selectedAxis.has(axis.id) ? 'selected' : ''}`, onClick: (e) => {
                    if (selectableTitle)
                        onClick(axis);
                    e.stopPropagation();
                } },
                react__WEBPACK_IMPORTED_MODULE_1___default().createElement("path", { id: id, d: (0,d3__WEBPACK_IMPORTED_MODULE_0__.linkHorizontal)().x(d => d[0]).y(d => d[1])({
                        source: [x, y - 0.5 * _constants__WEBPACK_IMPORTED_MODULE_4__.Constants.TEXT_HEIGHT],
                        target: [x + width, y - 0.5 * _constants__WEBPACK_IMPORTED_MODULE_4__.Constants.TEXT_HEIGHT]
                    }) }),
                react__WEBPACK_IMPORTED_MODULE_1___default().createElement("textPath", { xlinkHref: `#${id}`, startOffset: '50%', textAnchor: 'middle' },
                    axis.label,
                    react__WEBPACK_IMPORTED_MODULE_1___default().createElement("title", null, axis.label))),
            choices));
    }
    ;
}
PCAxis.STEP_AXIS = /^\d+\..+/;
PCAxis.contextType = _model__WEBPACK_IMPORTED_MODULE_5__.CPCContext;


/***/ }),

/***/ "./lib/components/pc/pc_choice.js":
/*!****************************************!*\
  !*** ./lib/components/pc/pc_choice.js ***!
  \****************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "PCChoice": () => (/* binding */ PCChoice)
/* harmony export */ });
/* harmony import */ var _model__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./model */ "./lib/components/pc/model.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _pc_axis__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./pc_axis */ "./lib/components/pc/pc_axis.js");
/* harmony import */ var _constants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./constants */ "./lib/components/pc/constants.js");
/* harmony import */ var _util__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../util */ "./lib/util.js");





class PCChoice extends (react__WEBPACK_IMPORTED_MODULE_0___default().Component) {
    constructor(props) {
        super(props);
        this.onClick = this.onClick.bind(this);
        this.collapse = this.collapse.bind(this);
    }
    onClick(e) {
        const { choice, onExpand } = this.props;
        if (e.ctrlKey) {
            this.props.choice.toggleSelected();
            this.props.parent.resetSelection(this.props.choice.getSelected());
            this.props.onHighlight(this.props.parent, this.props.choice.getSelected());
        }
        else if (choice.isExpandable())
            onExpand(choice);
        e.preventDefault();
        e.stopPropagation();
    }
    collapse(e) {
        const { choice, onCollapse } = this.props;
        if (!choice.isCollapsed())
            onCollapse(choice);
        e.preventDefault();
        e.stopPropagation();
    }
    render() {
        const { choice, parent, onCollapse, onExpand, onHighlight, onAxisSelection } = this.props;
        const { x, y, width, height } = choice.getLayout();
        const centeredX = choice.getLayout().centeredX();
        const centeredY = choice.getLayout().centeredY();
        const columns = choice.axes;
        const maxRows = Math.max(1, ...columns.map(column => column.length));
        return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement("g", { className: `pc-choice ${choice.isExpandable() ? 'pc-choice-expandable' : ''} ${choice.getSelected() ? 'selected' : ''}`, onClick: this.onClick },
            maxRows === 1 &&
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement((react__WEBPACK_IMPORTED_MODULE_0___default().Fragment), null,
                    choice.isCollapsed() && react__WEBPACK_IMPORTED_MODULE_0___default().createElement("circle", { cx: centeredX, cy: centeredY, r: _constants__WEBPACK_IMPORTED_MODULE_1__.Constants.CIRCLE_SIZE }),
                    react__WEBPACK_IMPORTED_MODULE_0___default().createElement("text", { x: centeredX, y: centeredY, transform: `rotate(${_constants__WEBPACK_IMPORTED_MODULE_1__.Constants.TEXT_ROTATION}, ${centeredX}, ${centeredY})` }, (0,_util__WEBPACK_IMPORTED_MODULE_2__.prettyPrint)(choice.label))),
            !choice.isCollapsed() && react__WEBPACK_IMPORTED_MODULE_0___default().createElement((react__WEBPACK_IMPORTED_MODULE_0___default().Fragment), null,
                parent && react__WEBPACK_IMPORTED_MODULE_0___default().createElement("rect", { x: x, y: y, width: width, height: height, onClick: this.collapse, className: 'pc-border' }),
                columns.map(column => (react__WEBPACK_IMPORTED_MODULE_0___default().createElement("g", null, column.map(row => react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_pc_axis__WEBPACK_IMPORTED_MODULE_3__.PCAxis, { key: row.id, axis: row, parent: choice, onCollapse: onCollapse, onExpand: onExpand, onHighlight: onHighlight, onClick: onAxisSelection }))))))));
    }
}
PCChoice.contextType = _model__WEBPACK_IMPORTED_MODULE_4__.CPCContext;


/***/ }),

/***/ "./lib/components/pc/pc_line.js":
/*!**************************************!*\
  !*** ./lib/components/pc/pc_line.js ***!
  \**************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "PCLine": () => (/* binding */ PCLine)
/* harmony export */ });
/* harmony import */ var d3__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! d3 */ "webpack/sharing/consume/default/d3/d3");
/* harmony import */ var d3__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(d3__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _model__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./model */ "./lib/components/pc/model.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _util__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../util */ "./lib/util.js");
/* harmony import */ var _constants__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./constants */ "./lib/components/pc/constants.js");
/* harmony import */ var memoize_one__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! memoize-one */ "webpack/sharing/consume/default/memoize-one/memoize-one");
/* harmony import */ var memoize_one__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(memoize_one__WEBPACK_IMPORTED_MODULE_2__);






class PCLine extends (react__WEBPACK_IMPORTED_MODULE_1___default().Component) {
    constructor(props) {
        super(props);
        this.memRenderPath = memoize_one__WEBPACK_IMPORTED_MODULE_2___default()(this.renderPath);
        this.state = { selected: false };
        this.onMouseEnter = this.onMouseEnter.bind(this);
        this.onMouseLeave = this.onMouseLeave.bind(this);
        this.onClick = this.onClick.bind(this);
    }
    onMouseEnter() {
        this.setState(() => ({ selected: true }));
    }
    onMouseLeave() {
        this.setState(() => ({ selected: false }));
    }
    onClick(e) {
        if (e.ctrlKey)
            this.props.onAlternativeClick(this.props.line.id);
        else
            this.props.onClick(this.props.line.id);
        e.stopPropagation();
    }
    renderPath(_) {
        const { line } = this.props;
        const { model } = this.context;
        const path = d3__WEBPACK_IMPORTED_MODULE_0__.path();
        const missingPath = d3__WEBPACK_IMPORTED_MODULE_0__.path();
        const tooltips = [];
        let lastPosition = undefined;
        let openEnd = undefined;
        line.points.map(point => {
            const axis = model.getAxis(point.axis);
            if (axis === undefined) {
                // Should not happen. Maybe rendering different structures at once
                return;
            }
            const layout = axis.getLayout();
            if (!layout)
                // Don't render axis that are not visible
                return;
            const { x, width, yScale } = axis.getLayout();
            const xStart = x + width * 0.025;
            const xEnd = xStart + width * 0.95;
            if (point.value !== undefined) {
                let y;
                const skipCenterX = !axis.isNumerical();
                if (axis.isNumerical()) {
                    y = yScale(point.value);
                }
                else {
                    if (axis.choices.length === 0) {
                        // y = lastPosition[1]
                    }
                    else {
                        const choice = axis.choices.filter(c => c.value == point.value).pop();
                        if (!choice.isCollapsed())
                            // Don't render axis that are expanded
                            return;
                        y = choice.getLayout().centeredY();
                    }
                }
                // Close potential open parallel path
                if (openEnd !== undefined && openEnd[0] < x) {
                    path.lineTo(openEnd[0], lastPosition[1]);
                    path.lineTo(xStart, y);
                    path.moveTo(...openEnd);
                    openEnd = undefined;
                }
                if (lastPosition === undefined)
                    path.moveTo(xStart, y);
                else if (xStart < lastPosition[0]) {
                    openEnd = [lastPosition[0], lastPosition[1]];
                    path.moveTo(xStart, y);
                }
                else
                    path.lineTo(xStart, y);
                if (skipCenterX) {
                    const centeredX = axis.getLayout().centeredX();
                    path.lineTo(centeredX - _constants__WEBPACK_IMPORTED_MODULE_3__.Constants.CIRCLE_SIZE, y);
                    path.moveTo(centeredX + _constants__WEBPACK_IMPORTED_MODULE_3__.Constants.CIRCLE_SIZE, y);
                }
                path.lineTo(xEnd, y);
                lastPosition = [xEnd, y];
                if (axis.isNumerical())
                    tooltips.push({ x: layout.centeredX(), y: y, text: (0,_util__WEBPACK_IMPORTED_MODULE_4__.fixedPrec)(point.value) });
            }
            else {
                if (lastPosition === undefined)
                    return;
                missingPath.moveTo(lastPosition[0], lastPosition[1]);
                missingPath.lineTo(xStart + width * 0.95, lastPosition[1]);
                path.moveTo(xEnd, lastPosition[1]);
            }
        });
        return [path, missingPath, tooltips];
    }
    render() {
        const { missing } = this.props;
        const [path, missingPath, tooltips] = this.memRenderPath(this.context.model.memState);
        const tooltipHeight = 20;
        return (react__WEBPACK_IMPORTED_MODULE_1___default().createElement("g", { className: `${this.props.highlight ? 'pc-highlighted' : ''} ${this.state.selected || this.props.selected ? 'pc-selected' : ''}` },
            missing && react__WEBPACK_IMPORTED_MODULE_1___default().createElement("path", { className: 'pc-line pc-missing-line', d: missingPath.toString() }),
            !missing &&
                react__WEBPACK_IMPORTED_MODULE_1___default().createElement((react__WEBPACK_IMPORTED_MODULE_1___default().Fragment), null,
                    react__WEBPACK_IMPORTED_MODULE_1___default().createElement("path", { className: 'pc-line', d: path.toString() }),
                    react__WEBPACK_IMPORTED_MODULE_1___default().createElement("path", { className: 'pc-fat-line', d: path.toString(), onMouseEnter: this.onMouseEnter, onMouseLeave: this.onMouseLeave, onClick: this.onClick }),
                    tooltips.map(t => react__WEBPACK_IMPORTED_MODULE_1___default().createElement("foreignObject", { x: t.x - 20, y: t.y - (tooltipHeight + 2), width: 100, height: tooltipHeight, style: { pointerEvents: 'none' } },
                        react__WEBPACK_IMPORTED_MODULE_1___default().createElement("span", { className: 'pc-tooltip' }, t.text))))));
    }
    ;
}
PCLine.defaultProps = {
    onClick: () => {
    },
    onAlternativeClick: () => {
    }
};
PCLine.contextType = _model__WEBPACK_IMPORTED_MODULE_5__.CPCContext;


/***/ }),

/***/ "./lib/components/pc/util.js":
/*!***********************************!*\
  !*** ./lib/components/pc/util.js ***!
  \***********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "ParCord": () => (/* binding */ ParCord)
/* harmony export */ });
/* harmony import */ var _model__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./model */ "./lib/components/pc/model.js");
/* harmony import */ var d3__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! d3 */ "webpack/sharing/consume/default/d3/d3");
/* harmony import */ var d3__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(d3__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _model__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../model */ "./lib/model.js");




var ParCord;
(function (ParCord) {
    var NumericalHyperparameter = _model__WEBPACK_IMPORTED_MODULE_1__.BO.NumericalHyperparameter;
    function guessMinimum(value) {
        const pos = getPositionOfMostSignificantDecimal(value);
        return value - Math.pow(10, pos);
    }
    ParCord.guessMinimum = guessMinimum;
    function guessMaximum(value) {
        const pos = getPositionOfMostSignificantDecimal(value);
        return value + Math.pow(10, pos);
    }
    ParCord.guessMaximum = guessMaximum;
    function getPositionOfMostSignificantDecimal(number) {
        let pos = 0;
        number = Math.abs(number);
        if (isInt(number)) {
            while (number >= 10) {
                number /= 10;
                pos++;
            }
        }
        else {
            number = number % 1;
            while (number < 1) {
                number *= 10;
                pos--;
            }
        }
        return pos;
    }
    function isInt(n) {
        return n % 1 === 0;
    }
    ParCord.isInt = isInt;
    function xScale(columns, range) {
        const maxRows = Math.max(...columns.map(row => row.length));
        const scales = [];
        for (let rowIdx = 0; rowIdx < maxRows; rowIdx++) {
            const axes = columns.map(rows => rows[Math.min(rows.length - 1, rowIdx)]);
            const weights = axes.map(a => a.getWidthWeight() - 1);
            const ids = [].concat(...axes.map((a, i) => [a.id, ...Array(...Array(weights[i])).map((_, j) => `_${a.id}_${j}_`)]));
            const scale = d3__WEBPACK_IMPORTED_MODULE_0__.scaleBand(ids, range).padding(0.1);
            scales.push(scale);
        }
        return scales;
    }
    ParCord.xScale = xScale;
    function yScale(choices, range) {
        const weights = choices.map(c => c.getHeightWeight() - 1);
        const ids = [].concat(...choices.map((c, i) => [c.value, ...Array(...Array(weights[i])).map((_, j) => `_${c.value}_${j}_`)]));
        return d3__WEBPACK_IMPORTED_MODULE_0__.scaleBand(ids, range);
    }
    ParCord.yScale = yScale;
    class ParallelAxes {
        constructor(commonStepName, otherPaths) {
            this.commonStepName = commonStepName;
            this.otherPaths = otherPaths;
            this.choices = new Map();
        }
        has(step) {
            return this.choices.has(step);
        }
    }
    function parseConfigSpace(structures, perfAxis) {
        // TODO: clean-up this mess...
        function parseHyperparameter(hp, conditions, stepId) {
            const id = hp.name;
            if (hp instanceof NumericalHyperparameter)
                return _model__WEBPACK_IMPORTED_MODULE_2__.Axis.Numerical(`${stepId}::${id}`, hp.name, new _model__WEBPACK_IMPORTED_MODULE_2__.Domain(hp.lower, hp.upper, hp.log));
            else {
                const choices = hp.choices
                    .map(choice => new _model__WEBPACK_IMPORTED_MODULE_2__.Choice(choice, []));
                hp.subParameters.forEach(child => {
                    conditions.filter(con => con.parent === hp.name && con.child === child.name)[0].values
                        .forEach(v => choices.filter(c => c.value === v)
                        .forEach(c => c.axes.push([parseHyperparameter(child, conditions, stepId)])));
                });
                return _model__WEBPACK_IMPORTED_MODULE_2__.Axis.Categorical(`${stepId}::${id}`, hp.name, choices);
            }
        }
        const nameToIndex = new Map();
        const comp = [];
        structures.forEach(structure => {
            structure.pipeline.slice(1).forEach(step => {
                const idx = Math.max(-1, ...step.parentIds.map(pid => nameToIndex.get(pid))
                    .filter(pid => pid !== undefined)) + 1;
                nameToIndex.set(step.id, idx);
                if (comp.length === idx)
                    comp.push(new Map());
                const commonStepName = step.step_name;
                if (!comp[idx].has(commonStepName))
                    comp[idx].set(commonStepName, new ParallelAxes(commonStepName, step.parallel_paths.length === 0 ? [step.step_name] : step.parallel_paths));
                if (!comp[idx].get(commonStepName).has(step.id)) {
                    const axes_ = structure.configspace.getHyperparameters(step.config_prefix)
                        .map(hp => [parseHyperparameter(hp, structure.configspace.conditions, step.id)]);
                    const axes = axes_.length === 0 ? [[]] : axes_;
                    const label = !Number.isNaN(Number.parseInt(step.label)) || !step.label ? step.label : undefined;
                    const parAxes = comp[idx].get(commonStepName);
                    parAxes.choices.set(step.id, new _model__WEBPACK_IMPORTED_MODULE_2__.Choice(step.label, axes, true, label));
                }
            });
        });
        const columns = comp.map((steps, idx) => {
            const parallelAxes = [];
            const addedAxes = new Set();
            steps.forEach(parAxes => {
                // TODO longer path has to be the first one. Ensure this!
                parAxes.otherPaths.forEach(pathId => {
                    if (addedAxes.has(pathId))
                        return;
                    let key;
                    if (steps.has(pathId))
                        key = pathId;
                    else
                        key = Array.from(steps.keys()).filter(k => k.startsWith(pathId)).pop();
                    const values = key !== undefined && steps.has(key) ? Array.from(steps.get(key).choices.values()) : [];
                    const name = key !== undefined ? key : pathId;
                    addedAxes.add(pathId);
                    parallelAxes.push(_model__WEBPACK_IMPORTED_MODULE_2__.Axis.Categorical(`${idx}.${name}`, name, values));
                });
            });
            return parallelAxes;
        });
        if (perfAxis !== undefined) {
            const lowerPerf = Math.min(...perfAxis.domain);
            const upperPerf = Math.max(...perfAxis.domain);
            columns.push([
                _model__WEBPACK_IMPORTED_MODULE_2__.Axis.Numerical('__performance__', perfAxis.label, new _model__WEBPACK_IMPORTED_MODULE_2__.Domain(lowerPerf, upperPerf, perfAxis.log))
            ]);
        }
        return columns.map(rows => {
            return rows.map(axis => {
                if (axis.isNumerical())
                    return axis;
                if (axis.choices.length <= 1)
                    return axis;
                return _model__WEBPACK_IMPORTED_MODULE_2__.Axis.Categorical(`${axis.id}.${_model__WEBPACK_IMPORTED_MODULE_2__.PARENT_MARKER}`, axis.name, [new _model__WEBPACK_IMPORTED_MODULE_2__.Choice(axis.name, [[axis]], true, axis.label)]);
            });
        });
    }
    ParCord.parseConfigSpace = parseConfigSpace;
    function parseCandidates(candidates, axes) {
        const nameToIndex = new Map();
        candidates.forEach(([_, structure]) => {
            structure.pipeline.slice(1).forEach(step => {
                const idx = Math.max(-1, ...step.parentIds.map(pid => nameToIndex.get(pid))
                    .filter(pid => pid !== undefined)) + 1;
                nameToIndex.set(step.id, idx);
            });
        });
        // noinspection UnnecessaryLocalVariableJS
        const lines = candidates.map(([candidate, structure]) => {
            const points = new Array();
            structure.pipeline.slice(1).map(step => {
                const commonStepName = step.step_name;
                points.push(new _model__WEBPACK_IMPORTED_MODULE_2__.LinePoint(`${nameToIndex.get(step.id)}.${commonStepName}.${_model__WEBPACK_IMPORTED_MODULE_2__.PARENT_MARKER}`, commonStepName));
                points.push(new _model__WEBPACK_IMPORTED_MODULE_2__.LinePoint(`${nameToIndex.get(step.id)}.${commonStepName}`, step.label));
                candidate.subConfig(step, false)
                    .forEach((value, name) => {
                    points.push(new _model__WEBPACK_IMPORTED_MODULE_2__.LinePoint(`${step.id}::${name}`, value));
                });
            });
            // Fill missing steps in pipeline and final performance measure
            // noinspection UnnecessaryLocalVariableJS
            const lastStep = structure.pipeline[structure.pipeline.length - 1].id;
            axes.slice(nameToIndex.get(lastStep) + 1).forEach((axes) => {
                axes.forEach(axis => {
                    const value = axis.id === '__performance__' ? candidate.loss : undefined;
                    points.push(new _model__WEBPACK_IMPORTED_MODULE_2__.LinePoint(axis.id, value));
                });
            });
            return new _model__WEBPACK_IMPORTED_MODULE_2__.Line(candidate.id, points, candidate.runtime ? candidate.runtime.timestamp : 0);
        }).sort((a, b) => a.timestamp - b.timestamp);
        return lines;
    }
    ParCord.parseCandidates = parseCandidates;
})(ParCord || (ParCord = {}));


/***/ }),

/***/ "./lib/components/search_space.js":
/*!****************************************!*\
  !*** ./lib/components/search_space.js ***!
  \****************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "SearchSpace": () => (/* binding */ SearchSpace)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _util_collapse__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../util/collapse */ "./lib/util/collapse.js");
/* harmony import */ var _pc_parallel_corrdinates__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./pc/parallel_corrdinates */ "./lib/components/pc/parallel_corrdinates.js");
/* harmony import */ var _model__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../model */ "./lib/model.js");
/* harmony import */ var rc_slider__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! rc-slider */ "webpack/sharing/consume/default/rc-slider/rc-slider");
/* harmony import */ var rc_slider__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(rc_slider__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _search_space_optimization_progress__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./search_space/optimization_progress */ "./lib/components/search_space/optimization_progress.js");
/* harmony import */ var _search_space_sampling_history__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./search_space/sampling_history */ "./lib/components/search_space/sampling_history.js");
/* harmony import */ var d3__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! d3 */ "webpack/sharing/consume/default/d3/d3");
/* harmony import */ var d3__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(d3__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _search_space_structure_search_graph__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./search_space/structure_search_graph */ "./lib/components/search_space/structure_search_graph.js");









var CategoricalHyperparameter = _model__WEBPACK_IMPORTED_MODULE_3__.BO.CategoricalHyperparameter;
var NumericalHyperparameter = _model__WEBPACK_IMPORTED_MODULE_3__.BO.NumericalHyperparameter;
class SearchSpace extends (react__WEBPACK_IMPORTED_MODULE_0___default().Component) {
    constructor(props) {
        super(props);
        const sliderMarks = {};
        this.cids = [].concat(...this.props.structures.map(s => s.configs))
            .sort((a, b) => a.runtime.timestamp - b.runtime.timestamp)
            .map(c => c.id);
        let keys;
        let timestamp = this.cids.length - 1;
        if (this.cids.length <= 10)
            keys = this.cids;
        else if (this.cids.length <= 50)
            keys = this.cids.map(c => c.split(':').slice(1).join(':'));
        else if (this.cids.length <= 100)
            keys = this.cids.map((c, idx) => idx.toString());
        else {
            const stepSize = Math.ceil(this.cids.length / 100);
            keys = this.cids
                .map((c, idx) => idx)
                .filter(idx => idx % stepSize === 0)
                .map(idx => idx.toString());
            timestamp = Number.parseInt(keys.slice(-1)[0]);
        }
        keys.forEach((k, idx) => sliderMarks[idx] = k);
        this.state = {
            sliderMarks: sliderMarks,
            timestamp: timestamp,
            configSimilarity: undefined,
            hpHistories: new Map()
        };
        this.changeTimestamp = this.changeTimestamp.bind(this);
        this.onHyperparameterSelection = this.onHyperparameterSelection.bind(this);
        this.onHyperparameterReset = this.onHyperparameterReset.bind(this);
    }
    changeTimestamp(v) {
        if (this.cids.length <= 100)
            this.setState({ timestamp: v });
        else
            this.setState({ timestamp: Number.parseInt(this.state.sliderMarks[v]) });
    }
    onHyperparameterSelection(fullyQualifiedHP) {
        if (!this.state.hpHistories.has(fullyQualifiedHP)) {
            const tokens = fullyQualifiedHP.split('::');
            const hyperparameter = tokens[tokens.length - 1];
            let scale = undefined;
            let type = undefined;
            const data = [].concat(...this.props.structures
                .map(structure => {
                if (scale === undefined) {
                    const hp = structure.configspace.hyperparameters.find(hp => hp.name === hyperparameter);
                    if (hp instanceof CategoricalHyperparameter) {
                        scale = d3__WEBPACK_IMPORTED_MODULE_2__.scaleBand(hp.choices, [0, 1]);
                        type = 'category';
                    }
                    else if (hp instanceof NumericalHyperparameter) {
                        const numHp = hp;
                        type = 'number';
                        if (numHp.log)
                            scale = d3__WEBPACK_IMPORTED_MODULE_2__.scaleLog([numHp.lower, numHp.upper], [0, 1]);
                        else
                            scale = d3__WEBPACK_IMPORTED_MODULE_2__.scaleLinear([numHp.lower, numHp.upper], [0, 1]);
                    }
                }
                return structure.configs
                    .filter(c => !this.props.hideUnselectedCandidates || this.props.selectedCandidates.has(c.id))
                    .filter(c => c.config.has(hyperparameter))
                    .map(c => ({
                    cid: c.id,
                    value: c.config.get(hyperparameter),
                    performance: c.loss,
                    timestamp: c.runtime.timestamp
                }));
            }));
            this.state.hpHistories.set(fullyQualifiedHP, {
                name: hyperparameter,
                type: type,
                scale: scale,
                data: data
            });
        }
        else
            this.state.hpHistories.delete(fullyQualifiedHP);
        this.setState({ hpHistories: this.state.hpHistories });
    }
    onHyperparameterReset() {
        this.state.hpHistories.clear();
        this.setState({ hpHistories: this.state.hpHistories });
    }
    render() {
        const { explanations, structures, meta, selectedCandidates, onCandidateSelection, hideUnselectedCandidates } = this.props;
        const nSteps = Object.keys(this.state.sliderMarks).length - 1;
        return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement((react__WEBPACK_IMPORTED_MODULE_0___default().Fragment), null,
            nSteps > 0 &&
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { style: { margin: '20px', marginBottom: '30px' } },
                    react__WEBPACK_IMPORTED_MODULE_0___default().createElement((rc_slider__WEBPACK_IMPORTED_MODULE_1___default()), { min: 0, max: nSteps, marks: this.state.sliderMarks, defaultValue: nSteps, included: false, onChange: this.changeTimestamp })),
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_util_collapse__WEBPACK_IMPORTED_MODULE_4__.CollapseComp, { name: 'reinforcement-explanations', showInitial: true, help: _search_space_structure_search_graph__WEBPACK_IMPORTED_MODULE_5__.StructureSearchGraph.HELP },
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement("h3", null, "Structure Search Graph"),
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_search_space_structure_search_graph__WEBPACK_IMPORTED_MODULE_5__.StructureSearchGraph, { timestamp: this.state.timestamp, selectedCandidates: selectedCandidates, onCandidateSelection: onCandidateSelection })),
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_util_collapse__WEBPACK_IMPORTED_MODULE_4__.CollapseComp, { name: 'bayesian-explanations', showInitial: true, help: _pc_parallel_corrdinates__WEBPACK_IMPORTED_MODULE_6__.ParallelCoordinates.HELP },
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement("h3", null, "Hyperparameter Optimization"),
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_pc_parallel_corrdinates__WEBPACK_IMPORTED_MODULE_6__.ParallelCoordinates, { structures: structures, perfAxis: {
                        domain: [meta.bestPerformance, meta.worstPerformance],
                        log: false,
                        label: meta.metric
                    }, hideUnselectedCandidates: hideUnselectedCandidates, selectedCandidates: selectedCandidates, selectedAxis: new Set(this.state.hpHistories.keys()), onCandidateSelection: onCandidateSelection, onAxisSelection: this.onHyperparameterSelection, explanation: explanations.configs.get(this.cids[this.state.timestamp]), timestamp: this.state.timestamp })),
            structures.length > 0 &&
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { style: { display: 'flex' } },
                    react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { style: { flex: '1', overflowX: 'hidden', margin: 0, marginRight: '5px' } },
                        react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_util_collapse__WEBPACK_IMPORTED_MODULE_4__.CollapseComp, { name: 'config-similarity', showInitial: true, help: _search_space_optimization_progress__WEBPACK_IMPORTED_MODULE_7__.OptimizationProgress.HELP },
                            react__WEBPACK_IMPORTED_MODULE_0___default().createElement("h3", null, "Optimization Progress"),
                            react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_search_space_optimization_progress__WEBPACK_IMPORTED_MODULE_7__.OptimizationProgress, { structures: structures, selectedCandidates: selectedCandidates, hideUnselectedCandidates: hideUnselectedCandidates, meta: meta, height: '300px', timestamp: this.state.timestamp, onCandidateSelection: onCandidateSelection }))),
                    react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { style: { flex: '1', margin: 0, marginLeft: '5px' } },
                        react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_util_collapse__WEBPACK_IMPORTED_MODULE_4__.CollapseComp, { name: 'sampling-history', showInitial: true, help: _search_space_sampling_history__WEBPACK_IMPORTED_MODULE_8__.SamplingHistory.HELP },
                            react__WEBPACK_IMPORTED_MODULE_0___default().createElement("h3", null, "Sampling History"),
                            react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_search_space_sampling_history__WEBPACK_IMPORTED_MODULE_8__.SamplingHistory, { histories: Array.from(this.state.hpHistories.values()), meta: meta, selectedCandidates: selectedCandidates, hideUnselectedCandidates: hideUnselectedCandidates, onReset: this.onHyperparameterReset, onCandidateSelection: onCandidateSelection })))),
            nSteps > 0 &&
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { style: { margin: '20px', marginBottom: '30px' } },
                    react__WEBPACK_IMPORTED_MODULE_0___default().createElement((rc_slider__WEBPACK_IMPORTED_MODULE_1___default()), { min: 0, max: nSteps, marks: this.state.sliderMarks, defaultValue: nSteps, included: false, onChange: this.changeTimestamp }))));
    }
}


/***/ }),

/***/ "./lib/components/search_space/optimization_progress.js":
/*!**************************************************************!*\
  !*** ./lib/components/search_space/optimization_progress.js ***!
  \**************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "OptimizationProgress": () => (/* binding */ OptimizationProgress)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var recharts__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! recharts */ "webpack/sharing/consume/default/recharts/recharts");
/* harmony import */ var recharts__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(recharts__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _util__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../util */ "./lib/util.js");
/* harmony import */ var d3__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! d3 */ "webpack/sharing/consume/default/d3/d3");
/* harmony import */ var d3__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(d3__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _util_loading__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../util/loading */ "./lib/util/loading.js");
/* harmony import */ var _util_recharts__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../util/recharts */ "./lib/util/recharts.js");
/* harmony import */ var _util_error__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../util/error */ "./lib/util/error.js");







class OptimizationProgress extends (react__WEBPACK_IMPORTED_MODULE_0___default().Component) {
    constructor(props) {
        super(props);
        this.state = { cids: [], data: undefined, error: undefined };
        this.onScatterClick = this.onScatterClick.bind(this);
    }
    componentDidMount() {
        this.setState({ cids: [].concat(...this.props.structures.map(s => s.configs.map(c => c.id))) });
        this.queryConfigSimilarity();
    }
    queryConfigSimilarity() {
        this.context.requestConfigSimilarity()
            .then(res => this.setState({ data: res }))
            .catch(error => {
            console.error(`Failed to fetch Roc Curve data.\n${error.name}: ${error.message}`);
            this.setState({ error: error });
        });
    }
    onScatterClick(point, _, e) {
        const cid = this.state.cids[point.idx];
        if (!e.ctrlKey) {
            const selected = new Set(this.props.selectedCandidates);
            if (this.props.selectedCandidates.has(cid))
                selected.delete(cid);
            else
                selected.add(cid);
            this.props.onCandidateSelection(selected);
        }
        else {
            this.props.onCandidateSelection(new Set([cid]), true);
        }
    }
    render() {
        const { selectedCandidates, hideUnselectedCandidates } = this.props;
        const { cids, data, error } = this.state;
        const values = data ? data.surface.map(s => s.z) : [0, 1];
        const scale = d3__WEBPACK_IMPORTED_MODULE_2__.scaleSequential(d3__WEBPACK_IMPORTED_MODULE_2__.interpolateSpectral)
            .domain([Math.min(...values), Math.max(...values)]);
        // Calculate padding for axes to ensure that all patches are actually plotted
        const patchPadding = data ? data.surface.slice(0, 1)
            .map(p => [(p.x2 - p.x1) / 1.9, (p.y2 - p.y1) / 1.9])[0] : [0, 0];
        return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { style: { height: this.props.height } },
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_util_loading__WEBPACK_IMPORTED_MODULE_3__.LoadingIndicator, { loading: data === undefined && error === undefined }),
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_util_error__WEBPACK_IMPORTED_MODULE_4__.ErrorIndicator, { error: error }),
            data &&
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { style: { height: '100%', display: "flex", flexDirection: "column" } },
                    react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { style: { flex: '1 1 auto' } },
                        react__WEBPACK_IMPORTED_MODULE_0___default().createElement(recharts__WEBPACK_IMPORTED_MODULE_1__.ResponsiveContainer, null,
                            react__WEBPACK_IMPORTED_MODULE_0___default().createElement(recharts__WEBPACK_IMPORTED_MODULE_1__.ComposedChart, null,
                                react__WEBPACK_IMPORTED_MODULE_0___default().createElement(recharts__WEBPACK_IMPORTED_MODULE_1__.CartesianGrid, { strokeDasharray: "3 3" }),
                                react__WEBPACK_IMPORTED_MODULE_0___default().createElement(recharts__WEBPACK_IMPORTED_MODULE_1__.XAxis, { type: "number", dataKey: "x", label: { value: 'Dimension 1', dy: 10 }, domain: [`dataMin - ${patchPadding[0]}`, `dataMax + ${patchPadding[0]}`], tickFormatter: _util__WEBPACK_IMPORTED_MODULE_5__.prettyPrint }),
                                react__WEBPACK_IMPORTED_MODULE_0___default().createElement(recharts__WEBPACK_IMPORTED_MODULE_1__.YAxis, { type: "number", dataKey: "y", label: { value: 'Dimension 2', angle: -90, dx: -20 }, domain: [`dataMin - ${patchPadding[1]}`, `dataMax + ${patchPadding[1]}`], tickFormatter: _util__WEBPACK_IMPORTED_MODULE_5__.prettyPrint }),
                                data.surface.map(patch => (react__WEBPACK_IMPORTED_MODULE_0___default().createElement(recharts__WEBPACK_IMPORTED_MODULE_1__.ReferenceArea, { key: `${patch.x1}_${patch.y1}`, x1: patch.x1, x2: patch.x2, y1: patch.y1, y2: patch.y2, fill: scale(patch.z), fillOpacity: 1, stroke: "white", strokeOpacity: 0 }))),
                                react__WEBPACK_IMPORTED_MODULE_0___default().createElement(recharts__WEBPACK_IMPORTED_MODULE_1__.Scatter, { dataKey: "y", data: data.config, fill: 'none', stroke: 'none', name: 'Candidates', onClick: this.onScatterClick }, data.config
                                    .filter(c => c.idx <= this.props.timestamp && (!hideUnselectedCandidates || selectedCandidates.has(cids[c.idx])))
                                    .map((d, index) => (react__WEBPACK_IMPORTED_MODULE_0___default().createElement(recharts__WEBPACK_IMPORTED_MODULE_1__.Cell, { key: `cell-${index}`, fill: selectedCandidates.has(cids[d.idx]) ? _util__WEBPACK_IMPORTED_MODULE_5__.Colors.HIGHLIGHT : _util__WEBPACK_IMPORTED_MODULE_5__.Colors.DEFAULT, stroke: _util__WEBPACK_IMPORTED_MODULE_5__.Colors.BORDER, cursor: 'pointer' })))),
                                react__WEBPACK_IMPORTED_MODULE_0___default().createElement(recharts__WEBPACK_IMPORTED_MODULE_1__.Scatter, { dataKey: "y", data: data.incumbents, shape: react__WEBPACK_IMPORTED_MODULE_0___default().createElement("rect", { width: 15, height: 15 }), fill: 'none', stroke: 'none', name: 'Incumbents', legendType: 'rect', onClick: this.onScatterClick }, data.incumbents
                                    .filter(c => c.idx <= this.props.timestamp && (!hideUnselectedCandidates || selectedCandidates.has(cids[c.idx])))
                                    .map((d, index) => (react__WEBPACK_IMPORTED_MODULE_0___default().createElement(recharts__WEBPACK_IMPORTED_MODULE_1__.Cell, { key: `cell-${index}`, fill: selectedCandidates.has(cids[d.idx]) ? _util__WEBPACK_IMPORTED_MODULE_5__.Colors.HIGHLIGHT : _util__WEBPACK_IMPORTED_MODULE_5__.Colors.DEFAULT, width: 15, height: 15, stroke: _util__WEBPACK_IMPORTED_MODULE_5__.Colors.BORDER, cursor: 'pointer' })))),
                                react__WEBPACK_IMPORTED_MODULE_0___default().createElement(recharts__WEBPACK_IMPORTED_MODULE_1__.Legend, { verticalAlign: "top", content: react__WEBPACK_IMPORTED_MODULE_0___default().createElement("ul", { className: "recharts-default-legend", style: { padding: '0px', margin: '0px', textAlign: 'center' } },
                                        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("li", { className: "recharts-legend-item legend-item-0", style: { display: 'inline-block', marginRight: '10px' } },
                                            react__WEBPACK_IMPORTED_MODULE_0___default().createElement("svg", { className: "recharts-surface", width: "14", height: "14", viewBox: "0 0 32 32", version: "1.1" },
                                                react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", { fill: "#abe2fb", cx: "16", cy: "16", type: "circle", className: "recharts-symbols", transform: "translate(16, 16)", d: "M16,0A16,16,0,1,1,-16,0A16,16,0,1,1,16,0" })),
                                            react__WEBPACK_IMPORTED_MODULE_0___default().createElement("span", { className: "recharts-legend-item-text" }, "Candidates")),
                                        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("li", { className: "recharts-legend-item legend-item-1", style: { display: 'inline-block', marginRight: '10px' } },
                                            react__WEBPACK_IMPORTED_MODULE_0___default().createElement("svg", { className: "recharts-surface", width: "14", height: "14", viewBox: "0 0 32 32", version: "1.1" },
                                                react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", { stroke: "none", fill: "#abe2fb", d: "M0,0h30v30h-30z", className: "recharts-legend-icon" })),
                                            react__WEBPACK_IMPORTED_MODULE_0___default().createElement("span", { className: "recharts-legend-item-text" }, "Incumbents"))) })))),
                    react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { style: { flex: '0 1 auto' } },
                        react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_util_recharts__WEBPACK_IMPORTED_MODULE_6__.Heatbar, { scale: scale, label: this.props.meta.metric })))));
    }
}
OptimizationProgress.HELP = 'Visualizes the distribution of the selected configurations in the complete search space. ' +
    'For the visualization, the search space as well as all configurations are mapped into 2D space. Similar ' +
    'configurations are mapped into the same region in the 2D space. Each scatter dot represents a single ' +
    'configuration, squares are incumbent configurations. In addition, the marginal performance is displayed ' +
    'using a color scale. The range of the color scale is displayed above the heat map.';
OptimizationProgress.contextType = _util__WEBPACK_IMPORTED_MODULE_5__.JupyterContext;
OptimizationProgress.defaultProps = {
    onCandidateSelection: () => {
    }
};


/***/ }),

/***/ "./lib/components/search_space/sampling_history.js":
/*!*********************************************************!*\
  !*** ./lib/components/search_space/sampling_history.js ***!
  \*********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "SamplingHistory": () => (/* binding */ SamplingHistory)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var recharts__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! recharts */ "webpack/sharing/consume/default/recharts/recharts");
/* harmony import */ var recharts__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(recharts__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _util__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../util */ "./lib/util.js");
/* harmony import */ var d3__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! d3 */ "webpack/sharing/consume/default/d3/d3");
/* harmony import */ var d3__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(d3__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var memoizee__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! memoizee */ "webpack/sharing/consume/default/memoizee/memoizee");
/* harmony import */ var memoizee__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(memoizee__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var memoize_one__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! memoize-one */ "webpack/sharing/consume/default/memoize-one/memoize-one");
/* harmony import */ var memoize_one__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(memoize_one__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _util_recharts__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../../util/recharts */ "./lib/util/recharts.js");
/* harmony import */ var _material_ui_core__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @material-ui/core */ "webpack/sharing/consume/default/@material-ui/core/@material-ui/core?df94");
/* harmony import */ var _material_ui_core__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(_material_ui_core__WEBPACK_IMPORTED_MODULE_5__);









class LabelEncoder {
    fit(data) {
        this.labels = ['', ...new Set(data.map(d => d.value)), ''];
        return data.map((x) => ({
            cid: x.cid,
            timestamp: x.timestamp,
            value: this.labels.indexOf(x.value),
            performance: x.performance
        }));
    }
}
class SamplingHistory extends (react__WEBPACK_IMPORTED_MODULE_0___default().Component) {
    constructor(props) {
        super(props);
        this.memCalcData = memoizee__WEBPACK_IMPORTED_MODULE_3___default()(this.calcData, {
            primitive: true, length: 1, max: 100, normalizer: args => args[0].name
        });
        this.memCalcPerfHistory = memoize_one__WEBPACK_IMPORTED_MODULE_4___default()(SamplingHistory.calcPerfHistory);
        this.onScatterClick = this.onScatterClick.bind(this);
    }
    calcData(history) {
        let records = history.data;
        let yAxisProps;
        let marginLeft = 0;
        let bins;
        if (history.type === 'category') {
            const encoder = new LabelEncoder();
            records = encoder.fit(records);
            yAxisProps = {
                ticks: [...Array(encoder.labels.length).keys()],
                interval: 0,
                tickFormatter: (y) => (0,_util__WEBPACK_IMPORTED_MODULE_6__.prettyPrint)(encoder.labels[y]),
                domain: [0, encoder.labels.length - 1]
            };
            marginLeft = encoder.labels.map(l => (0,_util__WEBPACK_IMPORTED_MODULE_6__.prettyPrint)(l).length).reduce((a, b) => Math.max(a, b), 0) * 5;
            bins = (0,d3__WEBPACK_IMPORTED_MODULE_2__.bin)()
                .domain([1, encoder.labels.length - 1])
                .thresholds(encoder.labels.length - 2)(records.map(d => d.value));
        }
        else {
            yAxisProps = { tickFormatter: (y) => (0,_util__WEBPACK_IMPORTED_MODULE_6__.prettyPrint)(y), domain: history.scale.domain() };
            bins = (0,d3__WEBPACK_IMPORTED_MODULE_2__.bin)()
                .domain(history.scale.domain())(records.map(d => d.value));
        }
        records = !records ? [] :
            records.filter(x => !this.props.hideUnselectedCandidates || this.props.selectedCandidates.has(x.cid))
                .sort((a, b) => a.timestamp - b.timestamp);
        let trimmedName = '';
        for (const token of history.name.split(':').reverse()) {
            if (trimmedName === '')
                trimmedName = token;
            else if (trimmedName.length + token.length < 25)
                trimmedName = token + ':' + trimmedName;
            else
                break;
        }
        return {
            yAxisProps: yAxisProps,
            marginLeft: marginLeft,
            xMax: Math.ceil(records[records.length - 1].timestamp),
            data: records,
            bins: bins,
            name: trimmedName
        };
    }
    static calcPerfHistory(plotData) {
        return [].concat(...plotData.map(data => data.data))
            .map(d => d.performance);
    }
    onScatterClick(x, _, e) {
        const cid = x.cid;
        if (!e.ctrlKey) {
            const selected = new Set(this.props.selectedCandidates);
            if (this.props.selectedCandidates.has(cid))
                selected.delete(cid);
            else
                selected.add(cid);
            this.props.onCandidateSelection(selected);
        }
        else
            this.props.onCandidateSelection(new Set([cid]), true);
    }
    renderSingleHp(history, plotData, xMax, marginLeft, scale) {
        const { selectedCandidates } = this.props;
        const { yAxisProps, data, bins } = plotData;
        if (data.length === 0)
            return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement("p", null,
                "The hyperparameter ",
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement("i", null, history.name),
                " has no evaluations. Please select a hyperparameter with at least one evaluation."));
        const maxLength = bins ? Math.max(...bins.map(b => b.length)) : 0;
        const xDomain = [0, xMax * 1.25];
        return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement((react__WEBPACK_IMPORTED_MODULE_0___default().Fragment), null,
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement("h4", null, history.name),
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement(recharts__WEBPACK_IMPORTED_MODULE_1__.ResponsiveContainer, { key: history.name, height: SamplingHistory.PLOT_HEIGHT },
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement(recharts__WEBPACK_IMPORTED_MODULE_1__.ScatterChart, { margin: { left: marginLeft, bottom: 5 } },
                    react__WEBPACK_IMPORTED_MODULE_0___default().createElement(recharts__WEBPACK_IMPORTED_MODULE_1__.CartesianGrid, { strokeDasharray: "3 3" }),
                    react__WEBPACK_IMPORTED_MODULE_0___default().createElement(recharts__WEBPACK_IMPORTED_MODULE_1__.XAxis, { type: "number", dataKey: "timestamp", name: "Timestamp", label: { value: 'Timestamp', dy: 10 }, unit: 's', domain: xDomain, tickFormatter: (x) => (0,_util__WEBPACK_IMPORTED_MODULE_6__.prettyPrint)(x) }),
                    react__WEBPACK_IMPORTED_MODULE_0___default().createElement(recharts__WEBPACK_IMPORTED_MODULE_1__.YAxis, Object.assign({ yAxisId: "density", type: "number", dataKey: "value", name: "Density", label: { value: 'Density', angle: -90 }, orientation: "right", tick: false, width: 20 }, yAxisProps)),
                    react__WEBPACK_IMPORTED_MODULE_0___default().createElement(recharts__WEBPACK_IMPORTED_MODULE_1__.YAxis, Object.assign({ yAxisId: "value", type: "number", dataKey: "value", name: "Value", orientation: "left" }, yAxisProps)),
                    bins.map(patch => {
                        const xOffset = history.type === 'category' ? (patch.x1 - patch.x0) / 2 : 0;
                        const padding = history.type === 'category' ? 0.1 : 0;
                        return react__WEBPACK_IMPORTED_MODULE_0___default().createElement(recharts__WEBPACK_IMPORTED_MODULE_1__.ReferenceArea, { yAxisId: 'density', className: 'barchart-xxx', key: `${patch.x0}_${patch.x1}`, x1: xMax * (1.25 - Math.max(0.01, (patch.length / maxLength)) / 5), x2: xMax * 1.25, y1: patch.x0 - xOffset + padding, y2: patch.x1 - xOffset - padding, fill: _util__WEBPACK_IMPORTED_MODULE_6__.Colors.DEFAULT, fillOpacity: 1, stroke: _util__WEBPACK_IMPORTED_MODULE_6__.Colors.BORDER });
                    }),
                    react__WEBPACK_IMPORTED_MODULE_0___default().createElement(recharts__WEBPACK_IMPORTED_MODULE_1__.Scatter, { yAxisId: "value", data: data, onClick: this.onScatterClick }, data.map((d, index) => (react__WEBPACK_IMPORTED_MODULE_0___default().createElement(recharts__WEBPACK_IMPORTED_MODULE_1__.Cell, { key: `cell-${index}`, fill: selectedCandidates.has(d.cid) ? _util__WEBPACK_IMPORTED_MODULE_6__.Colors.HIGHLIGHT : scale(d.performance), stroke: _util__WEBPACK_IMPORTED_MODULE_6__.Colors.BORDER, cursor: 'pointer' }))))))));
    }
    render() {
        const { histories, meta, onReset } = this.props;
        const plotData = histories.sort((a, b) => a.name.localeCompare(b.name))
            .map(h => this.memCalcData(h));
        const marginLeft = Math.max(...plotData.map(h => h.marginLeft));
        const xMax = Math.max(...plotData.map(h => h.xMax));
        const perfRecords = this.memCalcPerfHistory(plotData);
        const scale = d3__WEBPACK_IMPORTED_MODULE_2__.scaleSequential(d3__WEBPACK_IMPORTED_MODULE_2__.interpolateReds)
            .domain([Math.min(...perfRecords), Math.max(...perfRecords)]);
        return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", null,
            histories.length === 0 &&
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement("p", null, "Select hyperparameters name in the parallel coordinate plot (Bayesian Optimization) above by clicking on the name of a hyperparameter. In the resulting to get more details about the sampled values of this hyperparameter."),
            histories.length > 0 &&
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { style: { display: 'flex', flexDirection: 'column', height: '100%' } },
                    react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { style: { flex: '1 1 auto', padding: '5px' } },
                        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { style: { display: 'flex' } },
                            react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_util_recharts__WEBPACK_IMPORTED_MODULE_7__.Heatbar, { label: meta.metric, scale: scale }),
                            react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_material_ui_core__WEBPACK_IMPORTED_MODULE_5__.Button, { style: { marginLeft: '20px', marginTop: '3px' }, onClick: () => onReset() }, "Reset")),
                        histories.map((hp, i) => this.renderSingleHp(hp, plotData[i], xMax, marginLeft, scale))))));
    }
}
SamplingHistory.HELP = 'Shows the distribution and performance of a single hyperparameter over time. This ' +
    'view can be used to validate that the complete range of the hyperparameter is searched. Furthermore, it can ' +
    'be verified that the search algorithm converges to a well performing region of the hyperparameter.';
SamplingHistory.PLOT_HEIGHT = 125;


/***/ }),

/***/ "./lib/components/search_space/structure_search_graph.js":
/*!***************************************************************!*\
  !*** ./lib/components/search_space/structure_search_graph.js ***!
  \***************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "StructureSearchGraph": () => (/* binding */ StructureSearchGraph)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var rc_slider_assets_index_css__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! rc-slider/assets/index.css */ "./node_modules/rc-slider/assets/index.css");
/* harmony import */ var _util__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../util */ "./lib/util.js");
/* harmony import */ var _util_tree_structure__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../util/tree_structure */ "./lib/util/tree_structure.js");
/* harmony import */ var _util_loading__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../util/loading */ "./lib/util/loading.js");
/* harmony import */ var _util_error__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../util/error */ "./lib/util/error.js");






var SOURCE = _util__WEBPACK_IMPORTED_MODULE_2__.Components.SOURCE;
const NODE_HEIGHT = 36;
const NODE_WIDTH = 130;
class SingleNode extends (react__WEBPACK_IMPORTED_MODULE_0___default().Component) {
    constructor(props) {
        super(props);
        this.state = { show: false };
        this.toggleShow = this.toggleShow.bind(this);
    }
    toggleShow(_, e) {
        this.setState((state) => ({ show: !state.show }));
        e.stopPropagation();
    }
    render() {
        const { node, selected, highlight } = this.props;
        const data = node.data;
        return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_util_tree_structure__WEBPACK_IMPORTED_MODULE_3__.GraphNode, { key: data.id, node: node, className: `structure-graph_node ${selected ? 'selected ' : ''}` +
                `${highlight ? 'highlight ' : ''}` +
                `${data.splitter ? 'hierarchical-tree_node-content-splitter ' : ''}` +
                `${data.merger ? 'hierarchical-tree_node-content-merger ' : ''}`, nodeWidth: NODE_WIDTH, virtual: data.label === SOURCE, nodeHeight: NODE_HEIGHT, onClick: this.props.onSelectNode, onAlternativeClick: this.toggleShow },
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", null,
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { style: { display: 'flex', alignItems: 'center' } },
                    react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { style: { flexGrow: 1 } },
                        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("p", null, data.label !== SOURCE && data.label.substring(0, 20)))))));
    }
}
class StructureSearchGraph extends (react__WEBPACK_IMPORTED_MODULE_0___default().Component) {
    constructor(props) {
        super(props);
        this.state = { data: undefined, error: undefined };
        this.renderTree = this.renderTree.bind(this);
        this.selectNode = this.selectNode.bind(this);
    }
    componentDidMount() {
        this.context.requestPipelineHistory()
            .then(data => this.setState({ data: data }))
            .catch(error => {
            console.error(`Failed to fetch pipeline history.\n${error.name}: ${error.message}`);
            this.setState({ error: error });
        });
    }
    selectNode(node) {
        const candidates = node.cids;
        const intersection = candidates.filter(c => this.props.selectedCandidates.has(c));
        if (intersection.length === candidates.length) {
            const tmp = Array.from(this.props.selectedCandidates.values()).filter(v => !candidates.includes(v));
            this.props.onCandidateSelection(new Set(tmp));
        }
        else {
            const tmp = [...this.props.selectedCandidates, ...candidates];
            this.props.onCandidateSelection(new Set(tmp));
        }
    }
    renderTree(root) {
        const { selectedCandidates } = this.props;
        const currentSteps = new Set(this.state.data.individual[this.props.timestamp].map(s => s.id));
        const renderedNodes = root.descendants().map(node => {
            const highlight = currentSteps.has(node.data.id);
            const selected = node.data.isSelected(selectedCandidates);
            return react__WEBPACK_IMPORTED_MODULE_0___default().createElement(SingleNode, { key: node.data.id, node: node, highlight: highlight, selected: selected, onSelectNode: this.selectNode });
        });
        const renderedEdges = root.links()
            .map(link => {
            const key = link.source.data.id + '-' + link.target.data.id;
            const label = link.target.data.getLabel(link.source.data.id);
            const highlight = (currentSteps.has(link.source.data.id) && currentSteps.has(link.target.data.id)) ||
                (link.source.data.isSelected(selectedCandidates) && link.target.data.isSelected(selectedCandidates));
            let startOffset = 0;
            if (link.source.data.splitter && link.source.children().length > 1) {
                const idx = link.source.children()
                    .sort((a, b) => a.x - b.x)
                    .findIndex(v => v.data.id === link.target.data.id);
                startOffset = idx === 0 ? -NODE_HEIGHT / 8 : NODE_HEIGHT / 8;
            }
            return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement((react__WEBPACK_IMPORTED_MODULE_0___default().Fragment), null, (!this.props.hideUnselectedCandidates || highlight) &&
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_util_tree_structure__WEBPACK_IMPORTED_MODULE_3__.GraphEdge, { key: key, link: link, label: label, startOffset: startOffset, nodeWidth: link.source.data.label === SOURCE ? NODE_HEIGHT : NODE_WIDTH, nodeHeight: NODE_HEIGHT, highlight: highlight })));
        });
        return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement((react__WEBPACK_IMPORTED_MODULE_0___default().Fragment), null,
            renderedEdges,
            renderedNodes));
    }
    render() {
        const { timestamp } = this.props;
        const { data, error } = this.state;
        return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement((react__WEBPACK_IMPORTED_MODULE_0___default().Fragment), null,
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_util_loading__WEBPACK_IMPORTED_MODULE_4__.LoadingIndicator, { loading: data === undefined && error === undefined }),
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_util_error__WEBPACK_IMPORTED_MODULE_5__.ErrorIndicator, { error: error }),
            data !== undefined && react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_util_tree_structure__WEBPACK_IMPORTED_MODULE_3__.HierarchicalTree, { nodeHeight: NODE_HEIGHT, nodeWidth: NODE_WIDTH, data: data.merged[timestamp], count: data.merged[timestamp].length, render: this.renderTree })));
    }
}
StructureSearchGraph.HELP = "Visualizes the underlying search procedure for pipeline structures. Highlighted in " +
    "light-blue is the latest selected pipeline. You can select pipelines by clicking on any node.";
StructureSearchGraph.contextType = _util__WEBPACK_IMPORTED_MODULE_2__.JupyterContext;
StructureSearchGraph.defaultProps = {
    selectedCandidates: new Set(),
    hideUnselectedCandidates: false,
    onCandidateSelection: (_) => {
    }
};


/***/ }),

/***/ "./lib/index.js":
/*!**********************!*\
  !*** ./lib/index.js ***!
  \**********************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _jupyterlab_rendermime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @jupyterlab/rendermime */ "webpack/sharing/consume/default/@jupyterlab/rendermime");
/* harmony import */ var _jupyterlab_rendermime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_rendermime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _jupyterlab_notebook__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @jupyterlab/notebook */ "webpack/sharing/consume/default/@jupyterlab/notebook");
/* harmony import */ var _jupyterlab_notebook__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_notebook__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _root__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./root */ "./lib/root.js");
/* harmony import */ var _jupyterlab_celltags__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @jupyterlab/celltags */ "webpack/sharing/consume/default/@jupyterlab/celltags");
/* harmony import */ var _jupyterlab_celltags__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_celltags__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _jupyter__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./jupyter */ "./lib/jupyter.js");





const MIME_TYPE = 'application/xautoml+json';
const extension = {
    id: 'xautoml:plugin',
    autoStart: true,
    requires: [_jupyterlab_rendermime__WEBPACK_IMPORTED_MODULE_0__.IRenderMimeRegistry, _jupyterlab_notebook__WEBPACK_IMPORTED_MODULE_1__.INotebookTracker],
    activate: (app, rendermime, notebooks) => {
        const rendererFactory = {
            safe: true,
            mimeTypes: [MIME_TYPE],
            createRenderer: (options) => new _root__WEBPACK_IMPORTED_MODULE_3__.JupyterWidget(options, new _jupyter__WEBPACK_IMPORTED_MODULE_4__.Jupyter(notebooks, new _jupyterlab_celltags__WEBPACK_IMPORTED_MODULE_2__.TagTool(notebooks, app))),
        };
        // Add a renderer factory to application rendermime registry.
        rendermime.addFactory(rendererFactory, 0);
        notebooks.widgetAdded.connect((sender, panel) => {
            // Get the notebook's context and rendermime;
            const { content: { rendermime } } = panel;
            // Add the renderer factory to the notebook's rendermime registry;
            rendermime.addFactory(rendererFactory, 0);
        });
        app.docRegistry.addFileType({
            name: 'xautoml',
            mimeTypes: [MIME_TYPE],
            extensions: ['.xautoml', '.xautoml.json']
        });
    }
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (extension);


/***/ }),

/***/ "./lib/jupyter.js":
/*!************************!*\
  !*** ./lib/jupyter.js ***!
  \************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "ServerError": () => (/* binding */ ServerError),
/* harmony export */   "OpenedCache": () => (/* binding */ OpenedCache),
/* harmony export */   "Jupyter": () => (/* binding */ Jupyter),
/* harmony export */   "ID": () => (/* binding */ ID)
/* harmony export */ });
/* harmony import */ var _jupyterlab_notebook__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @jupyterlab/notebook */ "webpack/sharing/consume/default/@jupyterlab/notebook");
/* harmony import */ var _jupyterlab_notebook__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_notebook__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _model__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./model */ "./lib/model.js");
/* harmony import */ var _util__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./util */ "./lib/util.js");
/* harmony import */ var memoizee__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! memoizee */ "webpack/sharing/consume/default/memoizee/memoizee");
/* harmony import */ var memoizee__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(memoizee__WEBPACK_IMPORTED_MODULE_1__);




var SOURCE = _util__WEBPACK_IMPORTED_MODULE_2__.Components.SOURCE;
class ServerError extends Error {
    constructor(name, message, traceback) {
        super(message);
        this.name = name;
        this.traceback = traceback;
        super.name = name;
    }
}
class OpenedCache {
    constructor() {
        this.cache = new Map();
    }
    setIfNotPresent(key, value) {
        if (key === undefined)
            return;
        if (!this.cache.has(key))
            this.cache.set(key, value);
    }
    get(key) {
        if (key === undefined)
            return false;
        if (!this.cache.has(key))
            return true;
        return this.cache.get(key);
    }
    set(key, value) {
        if (key === undefined)
            return;
        this.cache.set(key, value);
    }
}
class Jupyter {
    constructor(notebooks, tags) {
        this.notebooks = notebooks;
        this.tags = tags;
        this.LOCAL_STORAGE_CONTENT = 'xautoml-previousCellContent';
        this.TAG_NAME = 'xautoml-generated';
        this.previousCellContent = undefined;
        this.collapsedState = new OpenedCache();
        this.memExecuteCode = memoizee__WEBPACK_IMPORTED_MODULE_1___default()(this.executeCode, {
            promise: true, primitive: true, length: 1, max: 100
        });
        this.previousCellContent = localStorage.getItem(this.LOCAL_STORAGE_CONTENT);
        this.initialized = false;
    }
    unmount() {
        this.memExecuteCode.clear();
        this.initialized = false;
    }
    executeCode(code) {
        var _a, _b, _c;
        if (!this.initialized) {
            this.initialized = true;
            return this.executeCode('from xautoml._helper import gcx')
                .then(() => this.executeCode(code));
        }
        const sessionContext = this.notebooks.currentWidget.context.sessionContext;
        if (!sessionContext || !((_a = sessionContext.session) === null || _a === void 0 ? void 0 : _a.kernel))
            return new Promise((resolve, reject) => reject('Not connected to kernel'));
        const request = (_c = (_b = sessionContext.session) === null || _b === void 0 ? void 0 : _b.kernel) === null || _c === void 0 ? void 0 : _c.requestExecute({ code });
        const outputBuffer = [];
        let result = undefined;
        let error = undefined;
        request.onIOPub = (msg) => {
            const msgType = msg.header.msg_type;
            switch (msgType) {
                case 'error':
                    error = msg.content;
                    break;
                case 'stream':
                    const text = msg.content.text;
                    outputBuffer.push(typeof text === 'string' ? text : text.join('\n'));
                    break;
                case 'execute_result':
                    result = msg.content;
                    break;
                default:
                    break;
            }
            return;
        };
        return request.done.then(() => {
            console.log(outputBuffer.join('\n'));
            if (error) {
                throw new ServerError(error.ename, error.evalue, error.traceback);
            }
            if (result !== undefined)
                return result.data['application/json'];
            return undefined;
        });
    }
    createCell(content = '') {
        const current = this.notebooks.currentWidget;
        const notebook = current.content;
        const xautomlCell = notebook.activeCellIndex;
        _jupyterlab_notebook__WEBPACK_IMPORTED_MODULE_0__.NotebookActions.selectBelow(notebook);
        const currentContent = notebook.activeCell.model.value.text;
        if (this.tags.checkApplied(this.TAG_NAME) && currentContent === this.previousCellContent) {
            // Cell was autogenerated and not changed by user.
            _jupyterlab_notebook__WEBPACK_IMPORTED_MODULE_0__.NotebookActions.clearOutputs(notebook);
        }
        else {
            notebook.activeCellIndex = xautomlCell;
            notebook.deselectAll();
            _jupyterlab_notebook__WEBPACK_IMPORTED_MODULE_0__.NotebookActions.insertBelow(notebook);
            this.tags.addTag(this.TAG_NAME);
        }
        notebook.activeCell.model.value.text = content;
        this.previousCellContent = content;
        localStorage.setItem(this.LOCAL_STORAGE_CONTENT, content);
        notebook.activeCell.editor.focus();
    }
    requestPerformanceData(cid) {
        return this.memExecuteCode(`gcx()._performance_data('${cid}')`)
            .then(data => {
            return {
                duration: data.duration,
                val_score: data.val_score,
                accuracy: data.accuracy,
                cm: data.cm,
                report: new Map(Object.entries(data.report))
            };
        });
    }
    requestOutputComplete(cid) {
        return this.memExecuteCode(`gcx()._output_complete('${cid}')`)
            .then(data => new Map(Object.entries(data)));
    }
    requestOutputDescription(cid) {
        return this.memExecuteCode(`gcx()._output_description('${cid}')`)
            .then(data => new Map(Object.entries(data)));
    }
    requestLimeSurrogate(cid, idx = 0, step = SOURCE) {
        return this.memExecuteCode(`gcx()._lime('${cid}', ${idx}, '${step}')`)
            .then(data => {
            return {
                idx: data.idx,
                label: data.label,
                categorical_input: data.categorical_input,
                additional_features: data.additional_features,
                expl: new Map(Object.entries(data.expl)),
                prob: new Map(Object.entries(data.prob))
            };
        });
    }
    requestGlobalSurrogate(cid, step, max_leaf_nodes = 'None') {
        return this.memExecuteCode(`gcx()._decision_tree_surrogate('${cid}', '${step}', ${max_leaf_nodes})`);
    }
    requestFeatureImportance(cid, step = SOURCE) {
        return this.memExecuteCode(`gcx()._feature_importance('${cid}', '${step}')`);
    }
    requestPDP(cid, step = SOURCE, features = undefined) {
        const list = features.join('\', \'');
        return this.memExecuteCode(`gcx()._pdp('${cid}', '${step}', ['${list}'])`).then(data => {
            const x = Object.entries(data)
                .map(([clazz, pdpResponse]) => {
                return [clazz, {
                        y_range: pdpResponse.y_range,
                        features: new Map(Object.entries(pdpResponse.features))
                    }];
            });
            return new Map(x);
        });
    }
    requestFANOVA(sid, step = 'None') {
        return this.memExecuteCode(`gcx()._fanova_overview('${sid}', '${step}')`);
    }
    requestFANOVADetails(sid, step = 'None', hps) {
        return this.memExecuteCode(`gcx()._fanova_details('${sid}', '${step}', '${hps[0]}', '${hps[1]}')`).then(data => {
            const details = new Map(Object.entries(data.details).map(t => [t[0], new Map(Object.entries(t[1]))]));
            return { details: details, error: data.error };
        });
    }
    requestSimulatedSurrogate(sid, timestamp) {
        return this.memExecuteCode(`gcx()._simulate_surrogate('${sid}', ${timestamp})`).then(data => {
            // @ts-ignore
            return _model__WEBPACK_IMPORTED_MODULE_3__.BO.Explanation.fromJson({
                candidates: [],
                loss: [],
                marginalization: data,
                selected: undefined,
                metric: 'Performance'
            });
        });
    }
    requestConfigSimilarity() {
        return this.memExecuteCode(`gcx()._config_similarity()`);
    }
    requestROCCurve(cid) {
        const list = cid.join('\', \'');
        return this.memExecuteCode(`gcx()._roc_curve(['${list}'])`)
            .then(data => new Map(Object.entries(data)));
    }
    requestEnsembleOverview() {
        return this.memExecuteCode(`gcx()._ensemble_overview()`)
            .then(data => {
            return {
                df: data.df,
                metrics: new Map(Object.entries(data.metrics))
            };
        });
    }
    requestEnsemblePredictions(idx) {
        return this.memExecuteCode(`gcx()._ensemble_predictions(${idx})`)
            .then(data => new Map(Object.entries(data)));
    }
    requestEnsembleDecisionSurface() {
        return this.memExecuteCode(`gcx()._ensemble_decision_surface()`)
            .then(data => {
            return {
                colors: data.colors,
                contours: new Map(Object.entries(data.contours)),
                X: data.X,
                y: data.y
            };
        });
    }
    requestPipelineHistory() {
        return this.memExecuteCode(`gcx()._get_pipeline_history()`)
            .then(data => {
            return {
                'merged': data.merged.map(pipeline => pipeline.map(d => _model__WEBPACK_IMPORTED_MODULE_3__.PipelineStep.fromJson(d))),
                'individual': data.individual.map(pipeline => pipeline.map(d => _model__WEBPACK_IMPORTED_MODULE_3__.PipelineStep.fromJson(d)))
            };
        });
    }
}
// Prefix used in python to prevent accidental name clashes
const ID = 'xautoml';


/***/ }),

/***/ "./lib/model.js":
/*!**********************!*\
  !*** ./lib/model.js ***!
  \**********************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "BO": () => (/* binding */ BO),
/* harmony export */   "RL": () => (/* binding */ RL),
/* harmony export */   "Explanations": () => (/* binding */ Explanations),
/* harmony export */   "Runtime": () => (/* binding */ Runtime),
/* harmony export */   "Candidate": () => (/* binding */ Candidate),
/* harmony export */   "MetaInformation": () => (/* binding */ MetaInformation),
/* harmony export */   "PipelineStep": () => (/* binding */ PipelineStep),
/* harmony export */   "Structure": () => (/* binding */ Structure),
/* harmony export */   "RunHistory": () => (/* binding */ RunHistory)
/* harmony export */ });
/* harmony import */ var _util__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./util */ "./lib/util.js");

var BO;
(function (BO) {
    class ConfigSpace {
        constructor(conditions, hyperparameters) {
            this.conditions = conditions;
            this.hyperparameters = hyperparameters;
            this.conditions.forEach(con => {
                const parent = this.hyperparameters.filter(hp => hp.name === con.parent)[0];
                const child = this.hyperparameters.filter(hp => hp.name === con.child)[0];
                parent.subParameters.push(child);
            });
        }
        static fromJson(configSpace) {
            const cs = JSON.parse(configSpace);
            const hyperparameters = cs.hyperparameters.map(hp => HyperParameter.fromJSON(hp));
            const conditions = cs.conditions.map(con => Condition.fromJSON(con));
            return new ConfigSpace(conditions, hyperparameters);
        }
        getHyperparameters(name) {
            const candidates = this.hyperparameters
                .filter(hp => hp.name.startsWith(name));
            const names = new Set(candidates.map(c => c.name));
            return candidates
                .filter(hp => this.conditions.filter(con => con.child === hp.name && names.has(con.parent)).length === 0);
        }
    }
    BO.ConfigSpace = ConfigSpace;
    class Condition {
        constructor(parent, child, values) {
            this.parent = parent;
            this.child = child;
            this.values = values;
        }
        static fromJSON(condition) {
            const values = condition.hasOwnProperty('value') ? [condition['value']] : condition['values'];
            return new Condition(condition.parent, condition.child, values);
        }
    }
    BO.Condition = Condition;
    class HyperParameter {
        constructor(name, subParameters) {
            this.name = name;
            this.subParameters = subParameters;
        }
        static fromJSON(hp) {
            if (hp['type'] === 'categorical')
                return CategoricalHyperparameter.fromJSON(hp);
            else if (hp['type'] === 'constant')
                return new CategoricalHyperparameter(hp.name, [hp.value]);
            else
                return NumericalHyperparameter.fromJSON(hp);
        }
    }
    BO.HyperParameter = HyperParameter;
    class CategoricalHyperparameter extends HyperParameter {
        constructor(name, choices) {
            super(name, []);
            this.name = name;
            this.choices = choices;
        }
        static fromJSON(hp) {
            return new CategoricalHyperparameter(hp.name, hp.choices);
        }
    }
    BO.CategoricalHyperparameter = CategoricalHyperparameter;
    class NumericalHyperparameter extends HyperParameter {
        constructor(name, lower, upper, log) {
            super(name, []);
            this.name = name;
            this.lower = lower;
            this.upper = upper;
            this.log = log;
        }
        static fromJSON(hp) {
            return new NumericalHyperparameter(hp.name, hp.lower, hp.upper, hp.log);
        }
    }
    BO.NumericalHyperparameter = NumericalHyperparameter;
    class Explanation {
        constructor(candidates, loss, marginalization, selected, metric = 'Expected Improvement') {
            this.loss = loss;
            this.marginalization = marginalization;
            this.selected = selected;
            this.metric = metric;
            this.candidates = candidates.map((c, idx) => new Candidate(idx.toString(), undefined, undefined, loss[idx], undefined, c, undefined, false));
        }
        get(id, key = 'bad') {
            const map = this.marginalization.get(id);
            if (map === undefined || map.size === 0)
                return undefined;
            if (key === undefined || !map.has(key))
                return map.values().next().value;
            else
                return map.get(key);
        }
        static fromJson(explanation) {
            return new Explanation(explanation.candidates.map(c => new Map(Object.entries(c))), explanation.loss, new Map(Object.entries(explanation.marginalization).map(([key, value]) => [key, new Map(Object.entries(value))])), explanation.selected, explanation.metric);
        }
    }
    BO.Explanation = Explanation;
})(BO || (BO = {}));
var RL;
(function (RL) {
    class StateDetails {
        constructor(failure_message, score, selected, policy) {
            this.failure_message = failure_message;
            this.score = score;
            this.selected = selected;
            this.policy = policy;
        }
        static fromJson(stateDetails) {
            return new StateDetails(stateDetails.failure_message, stateDetails.score, stateDetails.selected, new Map(Object.entries(stateDetails.policy)));
        }
        isUnvisited() {
            return this.failure_message === 'Unvisited' || this.policy.get('visits') === 0;
        }
        isFailure() {
            return !!this.failure_message && !this.isUnvisited();
        }
    }
    RL.StateDetails = StateDetails;
    class Explanation {
        constructor(id, label, details, children) {
            this.id = id;
            this.label = label;
            this.details = details;
            this.children = children;
        }
        static fromJson(graphNode) {
            var _a;
            if (Object.keys(graphNode).length === 0)
                return undefined;
            const details = new Map();
            Object.entries(graphNode.details)
                .forEach(k => details.set(k[0], StateDetails.fromJson(k[1])));
            return new Explanation(graphNode.id, (0,_util__WEBPACK_IMPORTED_MODULE_0__.normalizeComponent)(graphNode.label), details, (_a = graphNode.children) === null || _a === void 0 ? void 0 : _a.map(d => Explanation.fromJson(d)));
        }
        getDetails(key) {
            return this.details.get(key);
        }
        shouldDisplay(key) {
            return this.details.has(key);
        }
    }
    RL.Explanation = Explanation;
})(RL || (RL = {}));
class Explanations {
    constructor(structures, configs) {
        this.structures = structures;
        this.configs = configs;
    }
    static fromJson(xai) {
        return new Explanations(RL.Explanation.fromJson(xai.structures), xai.configs !== undefined ? new Map(Object.entries(xai.configs).map(([key, value]) => [key, BO.Explanation.fromJson(value)])) : new Map());
    }
}
class Runtime {
    constructor(training_time, timestamp, prediction_time) {
        this.training_time = training_time;
        this.timestamp = timestamp;
        this.prediction_time = prediction_time;
    }
    static fromJson(runtime) {
        return new Runtime(runtime.training_time, runtime.timestamp, runtime.prediction_time);
    }
}
class Candidate {
    constructor(id, status, budget, loss, runtime, config, origin, filled) {
        this.id = id;
        this.status = status;
        this.budget = budget;
        this.loss = loss;
        this.runtime = runtime;
        this.config = config;
        this.origin = origin;
        this.filled = filled;
        // Computed after creating all candidates
        this.index = 0;
    }
    static fromJson(candidate) {
        const config = new Map();
        Object.entries(candidate.config)
            .forEach(k => config.set(k[0], k[1]));
        return new Candidate(candidate.id, candidate.status, candidate.budget, candidate.loss, Runtime.fromJson(candidate.runtime), config, candidate.origin, candidate.filled);
    }
    subConfig(step, prune) {
        const subConfig = new Map();
        Array.from(this.config.keys())
            .filter(k => k.startsWith(step.config_prefix + ':'))
            .forEach(key => {
            const tokens = key.split(':');
            subConfig.set(prune ? tokens[tokens.length - 1] : key, this.config.get(key));
        });
        return subConfig;
    }
}
Candidate.SUCCESS = 'SUCCESS';
class MetaInformation {
    constructor(framework, start_time, end_time, metric, is_minimization, openml_task, openml_fold, n_structures, n_configs, bestPerformance, worstPerformance, config) {
        this.framework = framework;
        this.start_time = start_time;
        this.end_time = end_time;
        this.metric = metric;
        this.is_minimization = is_minimization;
        this.openml_task = openml_task;
        this.openml_fold = openml_fold;
        this.n_structures = n_structures;
        this.n_configs = n_configs;
        this.bestPerformance = bestPerformance;
        this.worstPerformance = worstPerformance;
        this.config = config;
    }
    static fromJson(meta, losses) {
        const bestPerformance = meta.is_minimization ? Math.min(...losses) : Math.max(...losses);
        const worstPerformance = meta.is_minimization ? Math.max(...losses) : Math.min(...losses);
        return new MetaInformation(meta.framework, meta.start_time, meta.end_time, meta.metric, meta.is_minimization, meta.openml_task, meta.openml_fold, meta.n_structures, meta.n_configs, bestPerformance, worstPerformance, new Map(Object.entries(meta.config)));
    }
}
class PipelineStep {
    constructor(id, label, step_name, config_prefix, splitter, merger, parallel_paths, edge_labels, cids, parentIds) {
        this.id = id;
        this.label = label;
        this.step_name = step_name;
        this.config_prefix = config_prefix;
        this.splitter = splitter;
        this.merger = merger;
        this.parallel_paths = parallel_paths;
        this.edge_labels = edge_labels;
        this.cids = cids;
        this.parentIds = parentIds;
    }
    isSelected(selectedCandidates) {
        return this.cids.filter(id => selectedCandidates.has(id)).length > 0;
    }
    getLabel(parent) {
        // parent id may have been changed to omit "transparent" steps like pipeline or column transformer.
        if (this.edge_labels.size === 1)
            return this.edge_labels.values().next().value;
        return this.edge_labels.get(parent);
    }
    static fromJson(data) {
        return new PipelineStep(data.id, (0,_util__WEBPACK_IMPORTED_MODULE_0__.normalizeComponent)(data.label), data.step_name, data.config_prefix, data.splitter, data.merger, data.parallel_paths, new Map(Object.entries(data.edge_labels)), data.cids, data.parentIds);
    }
}
class Structure {
    constructor(cid, pipeline, configspace, configs) {
        this.cid = cid;
        this.pipeline = pipeline;
        this.configspace = configspace;
        this.configs = configs;
    }
    static fromJson(structure, defaultConfigSpace) {
        const pipeline = structure.pipeline.map(s => PipelineStep.fromJson(s));
        const configs = structure.configs.map(c => Candidate.fromJson(c));
        const configSpace = structure.configspace ?
            BO.ConfigSpace.fromJson(structure.configspace) : defaultConfigSpace;
        if (!configSpace)
            throw new Error(`Neither configspace nor default_configspace provided for structure ${structure.cid}`);
        return new Structure(structure.cid, pipeline, configSpace, configs);
    }
}
class RunHistory {
    constructor(meta, structures, explanations) {
        this.meta = meta;
        this.structures = structures;
        this.explanations = explanations;
        this.candidateMap = new Map();
        const array = [];
        structures.map(s => s.configs.forEach(c => {
            this.candidateMap.set(c.id, c);
            array.push(c);
        }));
        array.sort((a, b) => a.runtime.timestamp - b.runtime.timestamp)
            .forEach((c, idx) => c.index = idx);
    }
    static fromJson(runhistory) {
        // @ts-ignore
        const default_configspace = runhistory.default_configspace ? BO.ConfigSpace.fromJson(runhistory.default_configspace) : undefined;
        const structures = runhistory.structures.map(s => Structure.fromJson(s, default_configspace));
        const losses = [].concat(...structures.map(s => s.configs.map(c => c.loss)));
        return new RunHistory(MetaInformation.fromJson(runhistory.meta, losses), structures, Explanations.fromJson(runhistory.explanations));
    }
}


/***/ }),

/***/ "./lib/root.js":
/*!*********************!*\
  !*** ./lib/root.js ***!
  \*********************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "JupyterWidget": () => (/* binding */ JupyterWidget),
/* harmony export */   "default": () => (/* binding */ ReactRoot)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @jupyterlab/apputils */ "webpack/sharing/consume/default/@jupyterlab/apputils");
/* harmony import */ var _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _model__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./model */ "./lib/model.js");
/* harmony import */ var _util__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./util */ "./lib/util.js");
/* harmony import */ var _components_leaderboard__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./components/leaderboard */ "./lib/components/leaderboard.js");
/* harmony import */ var _util_loading__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./util/loading */ "./lib/util/loading.js");
/* harmony import */ var _material_ui_core__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @material-ui/core */ "webpack/sharing/consume/default/@material-ui/core/@material-ui/core?df94");
/* harmony import */ var _material_ui_core__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_material_ui_core__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _material_ui_lab__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @material-ui/lab */ "webpack/sharing/consume/default/@material-ui/lab/@material-ui/lab");
/* harmony import */ var _material_ui_lab__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_material_ui_lab__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _util_tabpanel__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./util/tabpanel */ "./lib/util/tabpanel.js");
/* harmony import */ var _components_search_space__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ./components/search_space */ "./lib/components/search_space.js");
/* harmony import */ var _components_optimization_overview__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./components/optimization_overview */ "./lib/components/optimization_overview.js");
/* harmony import */ var _components_ensemble__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ./components/ensemble */ "./lib/components/ensemble.js");












/**
 * The class name added to the extension.
 */
const CLASS_NAME = 'mimerenderer-xautoml';
/**
 * A widget for rendering application/xautoml.
 */
class JupyterWidget extends _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_1__.ReactWidget {
    constructor(options, jupyter) {
        super();
        this.runHistory = undefined;
        this._mimeType = options.mimeType;
        this.jupyter = jupyter;
        this.addClass(CLASS_NAME);
    }
    renderModel(model) {
        try {
            this.runHistory = _model__WEBPACK_IMPORTED_MODULE_4__.RunHistory.fromJson(model.data[this._mimeType]);
        }
        catch (e) {
            console.error('Failed to parse runHistory', e);
        }
        // Trigger call of render().
        this.onUpdateRequest(undefined);
        return this.renderPromise;
    }
    render() {
        if (!this.runHistory)
            return react__WEBPACK_IMPORTED_MODULE_0___default().createElement("p", null, "Error loading data...");
        return react__WEBPACK_IMPORTED_MODULE_0___default().createElement(ReactRoot, { runHistory: this.runHistory, jupyter: this.jupyter });
    }
}
class ReactRoot extends (react__WEBPACK_IMPORTED_MODULE_0___default().Component) {
    constructor(props) {
        super(props);
        this.container = react__WEBPACK_IMPORTED_MODULE_0___default().createRef();
        this.state = {
            selectedCandidates: new Set(),
            hiddenCandidates: new Set(),
            mounted: false,
            openTab: '1',
            showCandidate: undefined,
            hideUnselected: false
        };
        this.onCandidateSelection = this.onCandidateSelection.bind(this);
        this.onCandidateHide = this.onCandidateHide.bind(this);
        this.resetHidden = this.resetHidden.bind(this);
        this.switchTab = this.switchTab.bind(this);
        this.toggleHideUnselected = this.toggleHideUnselected.bind(this);
    }
    onCandidateSelection(cids, show = false) {
        if (show && cids.size === 1) {
            const cid = cids.values().next().value;
            this.setState({ showCandidate: cid, openTab: '1' });
        }
        else {
            this.setState({ selectedCandidates: cids });
        }
    }
    onCandidateHide(cid) {
        this.state.hiddenCandidates.add(cid);
        this.setState({ hiddenCandidates: this.state.hiddenCandidates });
    }
    resetHidden() {
        this.state.hiddenCandidates.clear();
        this.setState({ hiddenCandidates: this.state.hiddenCandidates });
    }
    componentDidMount() {
        if (this.container.current.clientWidth > 0)
            this.setState({ mounted: true });
        else
            // Jupyter renders all components before output containers are rendered.
            // Delay rendering to get the container width.
            window.setTimeout(() => this.setState({ mounted: true }), 100);
    }
    componentWillUnmount() {
        this.props.jupyter.unmount();
    }
    switchTab(_, selectedTab) {
        this.setState({ openTab: selectedTab });
    }
    toggleHideUnselected(_, checked) {
        this.setState({ hideUnselected: checked });
    }
    render() {
        const { runHistory, jupyter } = this.props;
        const { selectedCandidates, showCandidate, mounted, openTab, hideUnselected } = this.state;
        class DivInTabs extends (react__WEBPACK_IMPORTED_MODULE_0___default().Component) {
            render() {
                let { children, style } = this.props;
                return react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { style: style, className: 'MuiButtonBase-root MuiTab-root MuiTab-textColorInherit', onClick: e => e.stopPropagation(), children: children });
            }
        }
        if (!mounted) {
            // Render loading indicator while waiting for delayed re-rendering with mounted container
            return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { ref: this.container, style: { width: '100%' } },
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_util_loading__WEBPACK_IMPORTED_MODULE_5__.LoadingIndicator, { loading: true })));
        }
        if (!runHistory) {
            return react__WEBPACK_IMPORTED_MODULE_0___default().createElement("p", null, "Error loading data...");
        }
        return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_util__WEBPACK_IMPORTED_MODULE_6__.JupyterContext.Provider, { value: jupyter },
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { style: { display: 'flex' } },
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { style: { flexGrow: 0, flexShrink: 0, flexBasis: '275px', marginRight: '20px' } },
                    react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_components_optimization_overview__WEBPACK_IMPORTED_MODULE_7__.GeneralInformation, { structures: runHistory.structures, meta: runHistory.meta, selectedCandidates: selectedCandidates, onCandidateSelection: this.onCandidateSelection })),
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { style: { flexGrow: 2 } },
                    react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_material_ui_lab__WEBPACK_IMPORTED_MODULE_3__.TabContext, { value: openTab },
                        react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_material_ui_core__WEBPACK_IMPORTED_MODULE_2__.Box, { sx: { borderBottom: 1, borderColor: 'divider' } },
                            react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_material_ui_core__WEBPACK_IMPORTED_MODULE_2__.Tabs, { value: openTab, onChange: this.switchTab, TabIndicatorProps: {
                                    style: { backgroundColor: _util__WEBPACK_IMPORTED_MODULE_6__.Colors.HIGHLIGHT }
                                } },
                                react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_material_ui_core__WEBPACK_IMPORTED_MODULE_2__.Tab, { label: "Candidates", value: '1' }),
                                react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_material_ui_core__WEBPACK_IMPORTED_MODULE_2__.Tab, { label: "Search Space", value: '2' }),
                                react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_material_ui_core__WEBPACK_IMPORTED_MODULE_2__.Tab, { label: "Ensembles", value: '3' }),
                                react__WEBPACK_IMPORTED_MODULE_0___default().createElement(DivInTabs, { style: { marginLeft: 'auto', cursor: 'default' } },
                                    react__WEBPACK_IMPORTED_MODULE_0___default().createElement("span", { className: 'MuiTab-wrapper' },
                                        "Selected Candidates: ",
                                        selectedCandidates.size,
                                        " / ",
                                        runHistory.meta.n_configs - this.state.hiddenCandidates.size)),
                                react__WEBPACK_IMPORTED_MODULE_0___default().createElement(DivInTabs, null,
                                    react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_material_ui_core__WEBPACK_IMPORTED_MODULE_2__.Button, { onClick: () => this.onCandidateSelection(new Set()) }, "Clear Selected")))),
                        react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_util_tabpanel__WEBPACK_IMPORTED_MODULE_8__.TabPanel, { value: '1' },
                            react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_components_leaderboard__WEBPACK_IMPORTED_MODULE_9__.Leaderboard, { structures: runHistory.structures, selectedCandidates: selectedCandidates, hiddenCandidates: this.state.hiddenCandidates, hideUnselectedCandidates: hideUnselected, meta: runHistory.meta, explanations: runHistory.explanations, showCandidate: showCandidate, onCandidateSelection: this.onCandidateSelection, onCandidateHide: this.onCandidateHide })),
                        react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_util_tabpanel__WEBPACK_IMPORTED_MODULE_8__.TabPanel, { value: '2' },
                            react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_components_search_space__WEBPACK_IMPORTED_MODULE_10__.SearchSpace, { structures: runHistory.structures, meta: runHistory.meta, explanations: runHistory.explanations, selectedCandidates: selectedCandidates, hideUnselectedCandidates: hideUnselected, onCandidateSelection: this.onCandidateSelection })),
                        react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_util_tabpanel__WEBPACK_IMPORTED_MODULE_8__.TabPanel, { value: '3' },
                            react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_components_ensemble__WEBPACK_IMPORTED_MODULE_11__.Ensemble, { onCandidateSelection: this.onCandidateSelection, meta: runHistory.meta })))))));
    }
}


/***/ }),

/***/ "./lib/util.js":
/*!*********************!*\
  !*** ./lib/util.js ***!
  \*********************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "JupyterContext": () => (/* binding */ JupyterContext),
/* harmony export */   "cidToSid": () => (/* binding */ cidToSid),
/* harmony export */   "prettyPrint": () => (/* binding */ prettyPrint),
/* harmony export */   "fixedPrec": () => (/* binding */ fixedPrec),
/* harmony export */   "normalizeComponent": () => (/* binding */ normalizeComponent),
/* harmony export */   "areSetInputsEqual": () => (/* binding */ areSetInputsEqual),
/* harmony export */   "maxLabelLength": () => (/* binding */ maxLabelLength),
/* harmony export */   "Colors": () => (/* binding */ Colors),
/* harmony export */   "Components": () => (/* binding */ Components)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);

// For reasons, JupyterContext can not be declared in root.tsx and imported in dataset_details.tsx...
const JupyterContext = react__WEBPACK_IMPORTED_MODULE_0___default().createContext(undefined);
function cidToSid(cid) {
    return cid.substring(0, cid.indexOf(':', 4));
}
const floatRegex = /^-?\d+(?:[.,]\d*?)?$/;
function prettyPrint(value, prec = 3) {
    if (value === undefined || value === null)
        return 'None';
    else if (typeof value === 'number')
        return fixedPrec(value, prec).toString();
    else if (value instanceof Date)
        return value.toLocaleString();
    else if (typeof value === 'string') {
        const num = parseFloat(value);
        if (floatRegex.test(value) && !isNaN(num))
            return fixedPrec(num, prec).toString();
        else
            return value;
    }
    else
        return String(value);
}
function fixedPrec(number, prec = 3) {
    return Math.round(number * Math.pow(10, prec)) / Math.pow(10, prec);
}
function normalizeComponent(component) {
    return component.split('.').pop()
        .replace('Classifier', '')
        .replace('Classification', '')
        .replace('Component', '');
}
function areSetInputsEqual(newInputs, lastInputs) {
    const a = newInputs[0];
    const b = lastInputs[0];
    return a.size === b.size && [...a].every(value => b.has(value));
}
function maxLabelLength(labels) {
    return Math.max(...labels.map(d => d
        .replace('data_preprocessor:feature_type:numerical_transformer:', '')
        .replace('data_preprocessor:feature_type:categorical_transformer:', '')
        .length)) * 5;
}
var Colors;
(function (Colors) {
    Colors.DEFAULT = '#abe2fb';
    Colors.HIGHLIGHT = '#2196f3';
    Colors.BORDER = '#b8b8b8';
    Colors.ADDITIONAL_FEATURE = '#aaa';
    Colors.SELECTED_FEATURE = '#444';
    Colors.EXTENDED_DISCRETE_COLOR_RANGE = [
        Colors.HIGHLIGHT,
        '#DDB27C',
        '#88572C',
        '#FF991F',
        '#F15C17',
        '#223F9A',
        '#DA70BF',
        '#125C77',
        '#4DC19C',
        '#776E57',
        '#12939A',
        '#17B8BE',
        '#F6D18A',
        '#B7885E',
        '#FFCB99',
        '#F89570',
        '#829AE3',
        '#E79FD5',
        '#1E96BE',
        '#89DAC1',
        '#B3AD9E'
    ];
    function getColor(idx) {
        return Colors.EXTENDED_DISCRETE_COLOR_RANGE[idx % Colors.EXTENDED_DISCRETE_COLOR_RANGE.length];
    }
    Colors.getColor = getColor;
})(Colors || (Colors = {}));
var Components;
(function (Components) {
    Components.SOURCE = 'SOURCE';
    Components.SINK = 'SINK';
    Components.ENSEMBLE = 'ENSEMBLE';
    function isPipEnd(id) {
        return id === Components.SOURCE || id === Components.SINK;
    }
    Components.isPipEnd = isPipEnd;
})(Components || (Components = {}));


/***/ }),

/***/ "./lib/util/KeyValue.js":
/*!******************************!*\
  !*** ./lib/util/KeyValue.js ***!
  \******************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "KeyValue": () => (/* binding */ KeyValue)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _util__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../util */ "./lib/util.js");
/* harmony import */ var _help__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./help */ "./lib/util/help.js");



class KeyValue extends (react__WEBPACK_IMPORTED_MODULE_0___default().PureComponent) {
    render() {
        const { key_, value, help, href, tight, prec } = this.props;
        return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { style: { margin: tight ? '2px' : '4px' }, className: 'key-value-pair' },
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement("strong", { style: { display: "inline-block", marginRight: '2px' } },
                key_,
                ": "),
            react__WEBPACK_IMPORTED_MODULE_0___default().isValidElement(value) ? value :
                href ?
                    react__WEBPACK_IMPORTED_MODULE_0___default().createElement("a", { href: href, target: '_blank', className: 'hyperlink' }, (0,_util__WEBPACK_IMPORTED_MODULE_1__.prettyPrint)(value)) :
                    react__WEBPACK_IMPORTED_MODULE_0___default().createElement("span", null, (0,_util__WEBPACK_IMPORTED_MODULE_1__.prettyPrint)(value, prec)),
            help && react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: "icon baseline" },
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_help__WEBPACK_IMPORTED_MODULE_2__.HelpIcon, { help: help }))));
    }
}
KeyValue.defaultProps = {
    tight: false,
    prec: 3
};


/***/ }),

/***/ "./lib/util/collapse.js":
/*!******************************!*\
  !*** ./lib/util/collapse.js ***!
  \******************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "CollapseComp": () => (/* binding */ CollapseComp)
/* harmony export */ });
/* harmony import */ var _material_ui_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @material-ui/core */ "webpack/sharing/consume/default/@material-ui/core/@material-ui/core?df94");
/* harmony import */ var _material_ui_core__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_material_ui_core__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _material_ui_icons_KeyboardArrowUp__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @material-ui/icons/KeyboardArrowUp */ "./node_modules/@material-ui/icons/KeyboardArrowUp.js");
/* harmony import */ var _material_ui_icons_KeyboardArrowDown__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @material-ui/icons/KeyboardArrowDown */ "./node_modules/@material-ui/icons/KeyboardArrowDown.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _help__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./help */ "./lib/util/help.js");
/* harmony import */ var _util__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../util */ "./lib/util.js");
/* harmony import */ var _material_ui_icons__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @material-ui/icons */ "webpack/sharing/consume/default/@material-ui/icons/@material-ui/icons");
/* harmony import */ var _material_ui_icons__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_material_ui_icons__WEBPACK_IMPORTED_MODULE_2__);







class CollapseComp extends (react__WEBPACK_IMPORTED_MODULE_1___default().Component) {
    constructor(props, context) {
        super(props, context);
        this.context.collapsedState.setIfNotPresent(this.props.name, this.props.showInitial);
        this.state = { show: this.context.collapsedState.get(this.props.name) || (this.props.name === undefined && this.props.showInitial) };
        this.toggleShow = this.toggleShow.bind(this);
        this.toggleShowOpen = this.toggleShowOpen.bind(this);
        this.onComparisonRequest = this.onComparisonRequest.bind(this);
    }
    toggleShow(e) {
        this.setState((state) => {
            this.context.collapsedState.set(this.props.name, !state.show);
            return { show: !state.show };
        });
        e.stopPropagation();
    }
    toggleShowOpen(e) {
        if (!this.state.show)
            this.toggleShow(e);
    }
    onComparisonRequest(e) {
        this.props.onComparisonRequest();
        e.stopPropagation();
    }
    render() {
        const children = react__WEBPACK_IMPORTED_MODULE_1___default().Children.toArray(this.props.children);
        return (react__WEBPACK_IMPORTED_MODULE_1___default().createElement("div", { className: this.props.className, onClick: this.toggleShowOpen, style: { cursor: this.state.show ? 'default' : 'pointer' } },
            react__WEBPACK_IMPORTED_MODULE_1___default().createElement("div", { style: { display: 'flex', alignItems: 'center' } },
                react__WEBPACK_IMPORTED_MODULE_1___default().createElement("div", { style: { flexGrow: 1, cursor: 'pointer' }, onClick: this.toggleShow }, children[0]),
                this.props.onComparisonRequest &&
                    react__WEBPACK_IMPORTED_MODULE_1___default().createElement(_material_ui_core__WEBPACK_IMPORTED_MODULE_0__.IconButton, { style: { flexShrink: 1, maxHeight: '24px' }, size: 'small', title: 'Compare With Selected Candidates', onClick: this.onComparisonRequest },
                        react__WEBPACK_IMPORTED_MODULE_1___default().createElement(_material_ui_icons__WEBPACK_IMPORTED_MODULE_2__.CompareArrows, null)),
                this.props.help && this.state.show && react__WEBPACK_IMPORTED_MODULE_1___default().createElement(_help__WEBPACK_IMPORTED_MODULE_3__.HelpIcon, { help: this.props.help }),
                react__WEBPACK_IMPORTED_MODULE_1___default().createElement(_material_ui_core__WEBPACK_IMPORTED_MODULE_0__.IconButton, { style: { flexShrink: 1, maxHeight: '24px' }, size: 'small', onClick: this.toggleShow }, this.state.show ? react__WEBPACK_IMPORTED_MODULE_1___default().createElement(_material_ui_icons_KeyboardArrowUp__WEBPACK_IMPORTED_MODULE_4__["default"], null) : react__WEBPACK_IMPORTED_MODULE_1___default().createElement(_material_ui_icons_KeyboardArrowDown__WEBPACK_IMPORTED_MODULE_5__["default"], null))),
            this.props.help && !this.state.show && react__WEBPACK_IMPORTED_MODULE_1___default().createElement("p", { style: { fontSize: '13px' } }, this.props.help),
            react__WEBPACK_IMPORTED_MODULE_1___default().createElement(_material_ui_core__WEBPACK_IMPORTED_MODULE_0__.Collapse, { in: this.state.show },
                react__WEBPACK_IMPORTED_MODULE_1___default().createElement("div", { style: { marginTop: '5px' } }, children[1]))));
    }
}
CollapseComp.defaultProps = {
    className: 'container',
    name: undefined,
    showInitial: false
};
CollapseComp.contextType = _util__WEBPACK_IMPORTED_MODULE_6__.JupyterContext;


/***/ }),

/***/ "./lib/util/error.js":
/*!***************************!*\
  !*** ./lib/util/error.js ***!
  \***************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "ErrorIndicator": () => (/* binding */ ErrorIndicator)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _material_ui_lab__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @material-ui/lab */ "webpack/sharing/consume/default/@material-ui/lab/@material-ui/lab");
/* harmony import */ var _material_ui_lab__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_material_ui_lab__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _jupyter__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../jupyter */ "./lib/jupyter.js");



class ErrorIndicator extends (react__WEBPACK_IMPORTED_MODULE_0___default().PureComponent) {
    render() {
        const { error } = this.props;
        return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement((react__WEBPACK_IMPORTED_MODULE_0___default().Fragment), null, error &&
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_material_ui_lab__WEBPACK_IMPORTED_MODULE_1__.Alert, { severity: "error" },
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement("strong", null, error.name),
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement("p", { dangerouslySetInnerHTML: { __html: error.message } }),
                error instanceof _jupyter__WEBPACK_IMPORTED_MODULE_2__.ServerError &&
                    react__WEBPACK_IMPORTED_MODULE_0___default().createElement("details", null,
                        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("summary", null, "Stacktrace"),
                        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("pre", null, error.traceback)))));
    }
}


/***/ }),

/***/ "./lib/util/flexible-svg.js":
/*!**********************************!*\
  !*** ./lib/util/flexible-svg.js ***!
  \**********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "FlexibleSvg": () => (/* binding */ FlexibleSvg),
/* harmony export */   "RefableFlexibleSvg": () => (/* binding */ RefableFlexibleSvg)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _loading__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./loading */ "./lib/util/loading.js");
/* harmony import */ var resize_observer_polyfill__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! resize-observer-polyfill */ "./node_modules/resize-observer-polyfill/dist/ResizeObserver.es.js");



class FlexibleSvg extends (react__WEBPACK_IMPORTED_MODULE_0___default().Component) {
    constructor(props) {
        super(props);
        this.container = react__WEBPACK_IMPORTED_MODULE_0___default().createRef();
        this.state = { width: 0 };
    }
    componentDidMount() {
        const width = this.container.current.clientWidth;
        this.setState({ width: width });
        this.resizeObserver = new resize_observer_polyfill__WEBPACK_IMPORTED_MODULE_1__["default"](entries => {
            const newWidth = Math.max(...entries.map(e => e.contentRect.width));
            if (Math.abs(this.state.width - newWidth) > 30) {
                this.setState({ width: newWidth });
                if (this.props.onContainerChange)
                    this.props.onContainerChange(this.container);
            }
        });
        this.resizeObserver.observe(this.container.current);
        if (this.props.onContainerChange)
            this.props.onContainerChange(this.container);
    }
    componentWillUnmount() {
        var _a;
        (_a = this.resizeObserver) === null || _a === void 0 ? void 0 : _a.disconnect();
    }
    render() {
        const { height, children, _svg } = this.props;
        const { width } = this.state;
        if (!width) {
            // Render loading indicator while waiting for delayed re-rendering with mounted container
            return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { ref: this.container, style: { width: '100%' } },
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_loading__WEBPACK_IMPORTED_MODULE_2__.LoadingIndicator, { loading: true })));
        }
        return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: 'flexible-svg-container', ref: this.container, style: { paddingBottom: `${(height / width) * 100}%` } },
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement("svg", { className: `flexible-svg`, preserveAspectRatio: "xMinYMin meet", xmlns: "http://www.w3.org/2000/svg", viewBox: `0 0 ${width} ${height + 1}`, ref: _svg }, children)));
    }
}
const RefableFlexibleSvg = react__WEBPACK_IMPORTED_MODULE_0___default().forwardRef((props, ref) => react__WEBPACK_IMPORTED_MODULE_0___default().createElement(FlexibleSvg, Object.assign({ _svg: ref }, props)));


/***/ }),

/***/ "./lib/util/heading.js":
/*!*****************************!*\
  !*** ./lib/util/heading.js ***!
  \*****************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Heading": () => (/* binding */ Heading)
/* harmony export */ });
/* harmony import */ var _help__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./help */ "./lib/util/help.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);


class Heading extends (react__WEBPACK_IMPORTED_MODULE_0___default().Component) {
    render() {
        return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: 'custom-header' },
            this.props.children,
            this.props.help && react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: "icon baseline" },
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_help__WEBPACK_IMPORTED_MODULE_1__.HelpIcon, { help: this.props.help }))));
    }
}


/***/ }),

/***/ "./lib/util/help.js":
/*!**************************!*\
  !*** ./lib/util/help.js ***!
  \**************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "HelpIcon": () => (/* binding */ HelpIcon)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _material_ui_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @material-ui/core */ "webpack/sharing/consume/default/@material-ui/core/@material-ui/core?df94");
/* harmony import */ var _material_ui_core__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_material_ui_core__WEBPACK_IMPORTED_MODULE_1__);
var __rest = (undefined && undefined.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};


const CustomWidthTooltip = (0,_material_ui_core__WEBPACK_IMPORTED_MODULE_1__.styled)((_a) => {
    var { className } = _a, props = __rest(_a, ["className"]);
    return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_material_ui_core__WEBPACK_IMPORTED_MODULE_1__.Tooltip, Object.assign({}, props, { classes: { popper: className } })));
})({
    [`& .MuiTooltip-tooltip`]: {
        maxWidth: 500,
    },
});
class HelpIcon extends (react__WEBPACK_IMPORTED_MODULE_0___default().Component) {
    render() {
        return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement(CustomWidthTooltip, { title: react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: 'collapse-tooltip' },
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement("p", null, this.props.help)) },
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_material_ui_core__WEBPACK_IMPORTED_MODULE_1__.SvgIcon, null,
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", { fill: 'rgba(0, 0, 0, 0.54)', d: "M11 18h2v-2h-2v2zm1-16C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm0 18c-4.41 0-8-3.59-8-8s3.59-8 8-8 8 3.59 8 8-3.59 8-8 8zm0-14c-2.21 0-4 1.79-4 4h2c0-1.1.9-2 2-2s2 .9 2 2c0 2-3 1.75-3 5h2c0-2.25 3-2.5 3-5 0-2.21-1.79-4-4-4z" }))));
    }
}


/***/ }),

/***/ "./lib/util/importance_overview.js":
/*!*****************************************!*\
  !*** ./lib/util/importance_overview.js ***!
  \*****************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "ImportanceOverviewComp": () => (/* binding */ ImportanceOverviewComp)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _util__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../util */ "./lib/util.js");
/* harmony import */ var d3__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! d3 */ "webpack/sharing/consume/default/d3/d3");
/* harmony import */ var d3__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(d3__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var recharts__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! recharts */ "webpack/sharing/consume/default/recharts/recharts");
/* harmony import */ var recharts__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(recharts__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _jupyter_button__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./jupyter-button */ "./lib/util/jupyter-button.js");





class ImportanceOverviewComp extends (react__WEBPACK_IMPORTED_MODULE_0___default().Component) {
    render() {
        const { overview, selectedRow, onSelectRow } = this.props;
        if (overview === undefined)
            return react__WEBPACK_IMPORTED_MODULE_0___default().createElement((react__WEBPACK_IMPORTED_MODULE_0___default().Fragment), null);
        const radius = 8;
        const margin = 2;
        const marginTop = (overview === null || overview === void 0 ? void 0 : overview.column_names) ? (0,_util__WEBPACK_IMPORTED_MODULE_3__.maxLabelLength)(overview.column_names) : 0;
        const stepSize = (2 * radius) + margin;
        const nColumns = overview.column_names.length;
        const nRows = overview.keys.length;
        const width = nColumns * stepSize;
        const height = nRows * stepSize;
        const rows = [...Array(nRows).keys()].map(i => {
            const activeColumns = overview.keys[i];
            return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement("g", { key: `${activeColumns[0]}-${activeColumns[1]}`, onClick: () => onSelectRow(i), className: 'hp-importance_row' },
                selectedRow === i &&
                    react__WEBPACK_IMPORTED_MODULE_0___default().createElement("rect", { x: -1.25 * radius, width: width + radius, y: i * stepSize - 1.25 * radius, height: 2.5 * radius, fill: 'var(--md-grey-300)' }),
                [...Array(nColumns).keys()].map(j => {
                    const name = overview.column_names[j];
                    return react__WEBPACK_IMPORTED_MODULE_0___default().createElement("circle", { key: name, cx: j * stepSize, cy: i * stepSize, r: radius, fill: activeColumns.includes(name) ? _util__WEBPACK_IMPORTED_MODULE_3__.Colors.SELECTED_FEATURE : _util__WEBPACK_IMPORTED_MODULE_3__.Colors.ADDITIONAL_FEATURE });
                }),
                d3__WEBPACK_IMPORTED_MODULE_1__.pairs(activeColumns)
                    .map(([a, b]) => [overview.column_names.indexOf(a), overview.column_names.indexOf(b)])
                    .map(([a, b]) => (react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", { d: `M ${a * stepSize} ${i * stepSize} H ${b * stepSize}`, stroke: _util__WEBPACK_IMPORTED_MODULE_3__.Colors.SELECTED_FEATURE, strokeWidth: radius / 2 })))));
        });
        const boldHeaders = selectedRow !== undefined ? overview.keys[selectedRow] : ['', ''];
        const headers = [...Array(nColumns).keys()].map(i => (react__WEBPACK_IMPORTED_MODULE_0___default().createElement("g", { transform: `translate(${i * stepSize + (radius / 2)}, ${marginTop - 20})` },
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement("text", { transform: 'rotate(-50)', className: boldHeaders.includes(overview.column_names[i]) ? 'selected-header' : '' }, overview.column_names[i]
                .replace('data_preprocessor:feature_type:numerical_transformer:', '')
                .replace('data_preprocessor:feature_type:categorical_transformer:', '')))));
        const errorBarImportance = overview.importance.map(i => ({
            mean: i.mean,
            std: i.std,
            idx: i.idx,
            errorBars: [Math.min(i.mean, i.std), Math.min(1 - i.mean, i.std)]
        }));
        return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement((react__WEBPACK_IMPORTED_MODULE_0___default().Fragment), null,
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { style: { display: "flex", minWidth: 'auto', flexDirection: "column" } },
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { style: { display: "flex", minWidth: 'auto' } },
                    react__WEBPACK_IMPORTED_MODULE_0___default().createElement("svg", { width: width, height: height + marginTop, style: { overflow: "visible" } },
                        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("g", { transform: 'translate(10, 10)' },
                            react__WEBPACK_IMPORTED_MODULE_0___default().createElement("g", { transform: `translate(0, ${marginTop})` }, rows),
                            react__WEBPACK_IMPORTED_MODULE_0___default().createElement("g", null, headers))),
                    react__WEBPACK_IMPORTED_MODULE_0___default().createElement(recharts__WEBPACK_IMPORTED_MODULE_2__.BarChart, { data: errorBarImportance, layout: 'vertical', className: 'hp-importance', width: 125, height: height + marginTop, margin: { top: marginTop - 32, bottom: 0, left: 5, right: 5 }, barSize: 2 * radius, barGap: margin, style: { overflow: "visible" } },
                        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("text", { x: 125 / 2, y: marginTop - 30, textAnchor: 'middle' }, "Importance"),
                        react__WEBPACK_IMPORTED_MODULE_0___default().createElement(recharts__WEBPACK_IMPORTED_MODULE_2__.CartesianGrid, { strokeDasharray: "3 3" }),
                        react__WEBPACK_IMPORTED_MODULE_0___default().createElement(recharts__WEBPACK_IMPORTED_MODULE_2__.XAxis, { dataKey: 'mean', type: 'number', orientation: 'top', domain: [0, 1], ticks: [0, 0.25, 0.5, 0.75, 1] }),
                        react__WEBPACK_IMPORTED_MODULE_0___default().createElement(recharts__WEBPACK_IMPORTED_MODULE_2__.YAxis, { dataKey: "idx", type: "category", interval: 0, hide: true }),
                        selectedRow !== undefined && react__WEBPACK_IMPORTED_MODULE_0___default().createElement(recharts__WEBPACK_IMPORTED_MODULE_2__.ReferenceArea, { x1: 0, x2: 1, y1: selectedRow, y2: selectedRow, fill: 'var(--md-grey-300)', fillOpacity: 1 }),
                        react__WEBPACK_IMPORTED_MODULE_0___default().createElement(recharts__WEBPACK_IMPORTED_MODULE_2__.Bar, { dataKey: "mean", fill: _util__WEBPACK_IMPORTED_MODULE_3__.Colors.DEFAULT, onClick: (d) => onSelectRow(d.idx), isAnimationActive: selectedRow === undefined },
                            react__WEBPACK_IMPORTED_MODULE_0___default().createElement(recharts__WEBPACK_IMPORTED_MODULE_2__.ErrorBar, { dataKey: "errorBars", height: radius / 2, strokeWidth: 2, stroke: _util__WEBPACK_IMPORTED_MODULE_3__.Colors.HIGHLIGHT, direction: "x" })))),
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_jupyter_button__WEBPACK_IMPORTED_MODULE_4__.JupyterButton, { onClick: this.props.onExportClick }))));
    }
}


/***/ }),

/***/ "./lib/util/jupyter-button.js":
/*!************************************!*\
  !*** ./lib/util/jupyter-button.js ***!
  \************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "JupyterButton": () => (/* binding */ JupyterButton)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _material_ui_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @material-ui/core */ "webpack/sharing/consume/default/@material-ui/core/@material-ui/core?df94");
/* harmony import */ var _material_ui_core__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_material_ui_core__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _style_jupyter_svg__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../style/jupyter.svg */ "./style/jupyter.svg");


// @ts-ignore

class JupyterButton extends (react__WEBPACK_IMPORTED_MODULE_0___default().Component) {
    render() {
        const { onClick, style } = this.props;
        return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_material_ui_core__WEBPACK_IMPORTED_MODULE_1__.Button, { className: 'jupyter-button', onClick: onClick, style: style },
            "Continue in ",
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { style: { marginLeft: '-5px' }, dangerouslySetInnerHTML: { __html: _style_jupyter_svg__WEBPACK_IMPORTED_MODULE_2__["default"] } })));
    }
}


/***/ }),

/***/ "./lib/util/layout.js":
/*!****************************!*\
  !*** ./lib/util/layout.js ***!
  \****************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "TwoColumnLayout": () => (/* binding */ TwoColumnLayout)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);

class TwoColumnLayout extends (react__WEBPACK_IMPORTED_MODULE_0___default().PureComponent) {
    render() {
        const { widthLeft, widthRight, flexShrinkLeft, flexShrinkRight, flexGrowLeft, flexGrowRight } = this.props;
        const children = react__WEBPACK_IMPORTED_MODULE_0___default().Children.toArray(this.props.children);
        return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { style: { display: 'flex', justifyContent: 'space-around' } },
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { style: { flex: `${flexGrowLeft} ${flexShrinkLeft} ${widthLeft}`, overflowX: 'hidden', margin: '5px', marginRight: '10px' } }, children[0]),
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { style: { flex: `${flexGrowRight} ${flexShrinkRight} ${widthRight}`, margin: '5px', marginLeft: '10px', minWidth: 'auto' } }, children[1])));
    }
}
TwoColumnLayout.defaultProps = {
    widthLeft: 'auto',
    widthRight: 'auto',
    flexShrinkLeft: '1',
    flexShrinkRight: '1',
    flexGrowLeft: '1',
    flexGrowRight: '1'
};


/***/ }),

/***/ "./lib/util/loading.js":
/*!*****************************!*\
  !*** ./lib/util/loading.js ***!
  \*****************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "LoadingIndicator": () => (/* binding */ LoadingIndicator)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);

class LoadingIndicator extends (react__WEBPACK_IMPORTED_MODULE_0___default().Component) {
    render() {
        return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement((react__WEBPACK_IMPORTED_MODULE_0___default().Fragment), null, this.props.loading && react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: 'jp-SpinnerContent' })));
    }
}


/***/ }),

/***/ "./lib/util/raw_dataset.js":
/*!*********************************!*\
  !*** ./lib/util/raw_dataset.js ***!
  \*********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "RawDataset": () => (/* binding */ RawDataset)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _loading__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./loading */ "./lib/util/loading.js");
/* harmony import */ var _layout__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./layout */ "./lib/util/layout.js");
/* harmony import */ var _jupyter_button__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./jupyter-button */ "./lib/util/jupyter-button.js");
/* harmony import */ var _util__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../util */ "./lib/util.js");
/* harmony import */ var _error__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./error */ "./lib/util/error.js");
/* harmony import */ var _jupyter__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../jupyter */ "./lib/jupyter.js");
/* harmony import */ var _components_details_dataset_table__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../components/details/dataset_table */ "./lib/components/details/dataset_table.js");








class RawDataset extends (react__WEBPACK_IMPORTED_MODULE_0___default().Component) {
    constructor(props) {
        super(props);
        this.state = {
            loadingDf: false,
            outputs: new Map(),
            error: undefined
        };
        this.handleLoadDataframe = this.handleLoadDataframe.bind(this);
    }
    componentDidMount() {
        this.queryOutputs();
    }
    componentDidUpdate(prevProps, prevState, snapshot) {
        if (prevProps.model.component !== this.props.model.component)
            this.queryOutputs();
    }
    queryOutputs() {
        if (this.state.loadingDf) {
            // Loading already in progress
            return;
        }
        if (this.state.outputs.size == 0) {
            const { candidate } = this.props.model;
            // Outputs not cached yet
            this.setState({ loadingDf: true });
            this.context.requestOutputComplete(candidate.id)
                .then(data => this.setState({ outputs: data, loadingDf: false }))
                .catch(error => {
                console.error(`Failed to fetch output data: \n${error.name}: ${error.message}`);
                this.setState({ error: error });
            });
        }
    }
    handleLoadDataframe() {
        const { candidate, component } = this.props.model;
        this.context.createCell(`
${_jupyter__WEBPACK_IMPORTED_MODULE_1__.ID}_X, ${_jupyter__WEBPACK_IMPORTED_MODULE_1__.ID}_y, ${_jupyter__WEBPACK_IMPORTED_MODULE_1__.ID}_pipeline = gcx().sub_pipeline('${candidate.id}', '${component}')
${_jupyter__WEBPACK_IMPORTED_MODULE_1__.ID}_X
        `.trim());
    }
    render() {
        const { component, algorithm, selectedSample } = this.props.model;
        const { loadingDf, outputs, error } = this.state;
        return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement((react__WEBPACK_IMPORTED_MODULE_0___default().Fragment), null,
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_layout__WEBPACK_IMPORTED_MODULE_2__.TwoColumnLayout, null,
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement("h3", null,
                    "Output of ",
                    react__WEBPACK_IMPORTED_MODULE_0___default().createElement("i", null,
                        algorithm,
                        " (",
                        component,
                        ")")),
                (!loadingDf && outputs.has(component)) &&
                    react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_jupyter_button__WEBPACK_IMPORTED_MODULE_3__.JupyterButton, { style: { marginTop: 0, float: 'right' }, onClick: this.handleLoadDataframe })),
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_error__WEBPACK_IMPORTED_MODULE_4__.ErrorIndicator, { error: error }),
            !error &&
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement((react__WEBPACK_IMPORTED_MODULE_0___default().Fragment), null,
                    react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_loading__WEBPACK_IMPORTED_MODULE_5__.LoadingIndicator, { loading: loadingDf }),
                    !loadingDf &&
                        react__WEBPACK_IMPORTED_MODULE_0___default().createElement((react__WEBPACK_IMPORTED_MODULE_0___default().Fragment), null, outputs.has(component) ?
                            react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_components_details_dataset_table__WEBPACK_IMPORTED_MODULE_6__.DataSetTable, { data: outputs.get(component), selectedSample: selectedSample, onSampleClick: this.props.onSampleClick }) :
                            react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", null, "Missing")))));
    }
}
RawDataset.HELP = 'Displays a preview of the data set generated by the selected (sub) pipeline in addition ' +
    'with the target label and the confidence of the pipeline.' +
    '\n\n' +
    'It is possible to transfer the previewed data set into a new Jupyter cell to continue with further ' +
    'analysis. By selecting a single record in the data set table, local explanations for this records are ' +
    'calculated based on a LIME analysis.';
RawDataset.contextType = _util__WEBPACK_IMPORTED_MODULE_7__.JupyterContext;


/***/ }),

/***/ "./lib/util/recharts.js":
/*!******************************!*\
  !*** ./lib/util/recharts.js ***!
  \******************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Heatbar": () => (/* binding */ Heatbar),
/* harmony export */   "MinimalisticTooltip": () => (/* binding */ MinimalisticTooltip)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _util__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../util */ "./lib/util.js");
/* harmony import */ var uuid__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! uuid */ "./node_modules/uuid/index.js");
/* harmony import */ var uuid__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(uuid__WEBPACK_IMPORTED_MODULE_1__);



class Heatbar extends (react__WEBPACK_IMPORTED_MODULE_0___default().Component) {
    render() {
        const { marginLeft, scale, label } = this.props;
        const [min, max] = this.props.scale.domain();
        const nSteps = 10;
        const step = (max - min) / nSteps;
        const id = `gradient-${(0,uuid__WEBPACK_IMPORTED_MODULE_1__.v4)()}`;
        return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { style: { width: "100%", paddingLeft: marginLeft, marginTop: "10px", boxSizing: 'border-box' } },
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement("svg", { height: "20", width: "100%" },
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement("defs", null,
                    react__WEBPACK_IMPORTED_MODULE_0___default().createElement("linearGradient", { id: id, x1: "0%", y1: "0%", x2: "100%", y2: "0%" }, Array.from(Array(10).keys()).map(idx => {
                        return react__WEBPACK_IMPORTED_MODULE_0___default().createElement("stop", { offset: `${idx * 100 / nSteps}%`, style: { stopColor: scale(min + idx * step), stopOpacity: 1 } });
                    }))),
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement("rect", { x: "0", y: "0", width: "100%", height: "100%", fill: `url(#${id})` }),
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement("text", { x: '5%', y: '50%', dominantBaseline: 'middle' }, (0,_util__WEBPACK_IMPORTED_MODULE_2__.prettyPrint)(min, 5)),
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement("text", { x: '95%', y: '50%', dominantBaseline: 'middle', textAnchor: 'end' }, (0,_util__WEBPACK_IMPORTED_MODULE_2__.prettyPrint)(max, 5)),
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement("text", { x: '50%', y: '50%', dominantBaseline: 'middle', textAnchor: 'middle' }, label))));
    }
}
Heatbar.defaultProps = {
    marginLeft: 0
};
class MinimalisticTooltip extends (react__WEBPACK_IMPORTED_MODULE_0___default().PureComponent) {
    render() {
        const { active, payload } = this.props;
        if (active && payload && payload.length) {
            return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: "recharts-default-tooltip", style: {
                    margin: '0px',
                    padding: '10px',
                    backgroundColor: '#fff',
                    border: `1px solid ${_util__WEBPACK_IMPORTED_MODULE_2__.Colors.ADDITIONAL_FEATURE}`,
                    whiteSpace: 'nowrap'
                } },
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement("p", { className: "label" }, (0,_util__WEBPACK_IMPORTED_MODULE_2__.prettyPrint)(payload[0].value, 3))));
        }
        return null;
    }
}


/***/ }),

/***/ "./lib/util/tabpanel.js":
/*!******************************!*\
  !*** ./lib/util/tabpanel.js ***!
  \******************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "TabPanel": () => (/* binding */ TabPanel)
/* harmony export */ });
/* harmony import */ var _material_ui_lab__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @material-ui/lab */ "webpack/sharing/consume/default/@material-ui/lab/@material-ui/lab");
/* harmony import */ var _material_ui_lab__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_material_ui_lab__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
var __rest = (undefined && undefined.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};


function TabPanel(props) {
    const { children, className, style, value: id } = props, other = __rest(props, ["children", "className", "style", "value"]);
    const context = (0,_material_ui_lab__WEBPACK_IMPORTED_MODULE_0__.useTabContext)();
    if (context === null) {
        throw new TypeError("No TabContext provided");
    }
    const tabId = context.value;
    const [visited, setVisited] = (0,react__WEBPACK_IMPORTED_MODULE_1__.useState)(false);
    (0,react__WEBPACK_IMPORTED_MODULE_1__.useEffect)(() => {
        if (id === tabId) {
            setVisited(true);
        }
    }, [id, tabId]);
    return (react__WEBPACK_IMPORTED_MODULE_1___default().createElement((react__WEBPACK_IMPORTED_MODULE_1___default().Fragment), null, visited &&
        // @ts-ignore
        react__WEBPACK_IMPORTED_MODULE_1___default().createElement("div", Object.assign({ className: 'MuiTabPanel-root', style: Object.assign(Object.assign({ paddingTop: '10px' }, style), { display: id === tabId ? "block" : "none" }) }, other), children)));
}


/***/ }),

/***/ "./lib/util/tree_structure.js":
/*!************************************!*\
  !*** ./lib/util/tree_structure.js ***!
  \************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "GraphNode": () => (/* binding */ GraphNode),
/* harmony export */   "GraphEdge": () => (/* binding */ GraphEdge),
/* harmony export */   "HierarchicalTree": () => (/* binding */ HierarchicalTree)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react_move__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react-move */ "webpack/sharing/consume/default/react-move/react-move");
/* harmony import */ var react_move__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react_move__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var d3_ease__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! d3-ease */ "./node_modules/d3-ease/src/exp.js");
/* harmony import */ var d3_dag__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! d3-dag */ "webpack/sharing/consume/default/d3-dag/d3-dag");
/* harmony import */ var d3_dag__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(d3_dag__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _flexible_svg__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./flexible-svg */ "./lib/util/flexible-svg.js");
/* harmony import */ var d3__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! d3 */ "webpack/sharing/consume/default/d3/d3");
/* harmony import */ var d3__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(d3__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var uuid__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! uuid */ "./node_modules/uuid/index.js");
/* harmony import */ var uuid__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(uuid__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var memoize_one__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! memoize-one */ "webpack/sharing/consume/default/memoize-one/memoize-one");
/* harmony import */ var memoize_one__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(memoize_one__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var _util__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../util */ "./lib/util.js");









const ANIMATION_DURATION = 300;
class GraphNode extends (react__WEBPACK_IMPORTED_MODULE_0___default().Component) {
    constructor(props) {
        super(props);
        this.handleClick = this.handleClick.bind(this);
    }
    handleClick(e) {
        const { node } = this.props;
        if (e.ctrlKey) {
            this.props.onAlternativeClick(node.data, e);
        }
        else if (this.props.onClick) {
            this.props.onClick(node.data, e);
        }
    }
    render() {
        const { node, className, nodeWidth, nodeHeight, virtual, highlight } = this.props;
        const parent = node;
        const width = virtual ? nodeHeight : nodeWidth;
        return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement(react_move__WEBPACK_IMPORTED_MODULE_1__.Animate, { start: { x: parent.x, y: parent.y }, update: { x: [node.x], y: [node.y], timing: { duration: ANIMATION_DURATION, ease: d3_ease__WEBPACK_IMPORTED_MODULE_6__.expInOut } }, enter: { x: [node.x], y: [node.y], timing: { duration: ANIMATION_DURATION, ease: d3_ease__WEBPACK_IMPORTED_MODULE_6__.expInOut } } }, ({ x: x, y: y }) => react__WEBPACK_IMPORTED_MODULE_0___default().createElement("g", { className: `hierarchical-tree_node ${className} ${highlight ? 'selected' : ''}`, transform: `translate(${y}, ${x})` },
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement("foreignObject", { x: 0, y: -nodeHeight / 2, width: width, height: nodeHeight },
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: `hierarchical-tree_node-container` },
                    react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { onClick: this.handleClick, className: `hierarchical-tree_node-content ${virtual ? 'hierarchical-tree_node-content-virtual' : ''}` }, this.props.children))))));
    }
}
GraphNode.defaultProps = {
    className: '',
    virtual: false,
    highlight: false,
    onClick: () => {
    },
    onAlternativeClick: () => {
    }
};
class GraphEdge extends (react__WEBPACK_IMPORTED_MODULE_0___default().Component) {
    render() {
        const { link, label, className, nodeWidth, highlight, startOffset } = this.props;
        let labelOffset = -5;
        if (label !== undefined) {
            const idx = link.source.children()
                .sort((a, b) => a.x - b.x)
                .findIndex(c => c === link.target);
            if (idx >= link.source.children().length / 2)
                labelOffset = 10;
        }
        // noinspection JSSuspiciousNameCombination
        return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement(react_move__WEBPACK_IMPORTED_MODULE_1__.Animate, { start: {
                source: { x: link.source.y + nodeWidth, y: link.source.x },
                target: { x: link.target.y, y: link.target.x }
            }, update: {
                source: { x: [link.source.y + nodeWidth], y: [link.source.x] },
                target: { x: [link.target.y], y: [link.target.x] },
                timing: { duration: ANIMATION_DURATION, ease: d3_ease__WEBPACK_IMPORTED_MODULE_6__.expInOut }
            }, enter: {
                source: { x: [link.source.y + nodeWidth], y: [link.source.x] },
                target: { x: [link.target.y], y: [link.target.x] },
                timing: { duration: ANIMATION_DURATION, ease: d3_ease__WEBPACK_IMPORTED_MODULE_6__.expInOut }
            } }, ({ source: source, target: target }) => {
            const id = `edge-${(0,uuid__WEBPACK_IMPORTED_MODULE_4__.v4)()}`;
            const labelSpace = target.x - source.x;
            return react__WEBPACK_IMPORTED_MODULE_0___default().createElement((react__WEBPACK_IMPORTED_MODULE_0___default().Fragment), null,
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", { id: id, className: `hierarchical-tree_link ${className} ${highlight ? 'selected' : ''}`, d: (0,d3__WEBPACK_IMPORTED_MODULE_3__.linkHorizontal)().x(d => d[0]).y(d => d[1])({
                        source: [source.x, source.y + startOffset],
                        target: [target.x, target.y]
                    }) }),
                (label !== undefined && (labelSpace > 10)) &&
                    react__WEBPACK_IMPORTED_MODULE_0___default().createElement("text", { className: 'hierarchical-tree_link-label', dy: labelOffset, fill: 'black' },
                        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("textPath", { xlinkHref: `#${id}`, startOffset: '60%', textAnchor: 'middle' },
                            labelSpace > 40 ? (0,_util__WEBPACK_IMPORTED_MODULE_7__.prettyPrint)(label) : '[...]',
                            react__WEBPACK_IMPORTED_MODULE_0___default().createElement("title", null, (0,_util__WEBPACK_IMPORTED_MODULE_7__.prettyPrint)(label)))));
        }));
    }
}
GraphEdge.defaultProps = {
    className: '',
    highlight: false,
    startOffset: 0,
    label: undefined
};
class HierarchicalTree extends (react__WEBPACK_IMPORTED_MODULE_0___default().Component) {
    constructor(props) {
        super(props);
        this.previousCount = -1;
        this.layout = memoize_one__WEBPACK_IMPORTED_MODULE_5___default()(this.doLayout);
        this.state = { width: null };
        this.updateContainer = this.updateContainer.bind(this);
        this.doLayout = this.doLayout.bind(this);
    }
    updateContainer(container) {
        container.current.style.overflow = 'hidden';
        this.setState({ width: container.current.clientWidth });
    }
    doLayout(width, _) {
        // @ts-ignore
        const root = this.props.data instanceof Array ? d3_dag__WEBPACK_IMPORTED_MODULE_2__.dagStratify()(this.props.data) : d3_dag__WEBPACK_IMPORTED_MODULE_2__.dagHierarchy()(this.props.data);
        // Layout without size first to calculate new height
        const layout = d3_dag__WEBPACK_IMPORTED_MODULE_2__.sugiyama()
            .coord(d3_dag__WEBPACK_IMPORTED_MODULE_2__.coordCenter())
            .size(null)
            .nodeSize(() => [this.props.nodeHeight, this.props.nodeWidth]);
        if (width) {
            // @ts-ignore
            // noinspection JSSuspiciousNameCombination
            const newHeight = layout(root).width;
            const padding = this.props.containsTerminalNodes ? 2 * (this.props.nodeWidth - this.props.nodeHeight) : 0;
            // Adjust layout to actual width and new height
            return [root, layout.size([newHeight, width + padding])];
        }
        else
            return [root, layout];
    }
    render() {
        if (this.props.data === undefined)
            return react__WEBPACK_IMPORTED_MODULE_0___default().createElement((react__WEBPACK_IMPORTED_MODULE_0___default().Fragment), null);
        // Pass number of nodes to force recalculation if data has changed
        const [root, layout] = this.layout(this.state.width, this.props.count);
        this.previousCount = this.props.count;
        // noinspection JSSuspiciousNameCombination
        const height = layout(root).width;
        return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_flexible_svg__WEBPACK_IMPORTED_MODULE_8__.FlexibleSvg, { height: height, onContainerChange: this.updateContainer },
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement("g", { transform: `translate(${-this.props.nodeWidth / 2},0)` }, root && this.props.render(root))));
    }
}
HierarchicalTree.defaultProps = {
    count: 1,
    containsTerminalNodes: false
};


/***/ }),

/***/ "./lib/util/warning.js":
/*!*****************************!*\
  !*** ./lib/util/warning.js ***!
  \*****************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "WarningIndicator": () => (/* binding */ WarningIndicator),
/* harmony export */   "CommonWarnings": () => (/* binding */ CommonWarnings)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _material_ui_lab__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @material-ui/lab */ "webpack/sharing/consume/default/@material-ui/lab/@material-ui/lab");
/* harmony import */ var _material_ui_lab__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_material_ui_lab__WEBPACK_IMPORTED_MODULE_1__);


class WarningIndicator extends (react__WEBPACK_IMPORTED_MODULE_0___default().PureComponent) {
    render() {
        const { title, message } = this.props;
        return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_material_ui_lab__WEBPACK_IMPORTED_MODULE_1__.Alert, { severity: "warning", style: { margin: '5px' } },
            title && react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_material_ui_lab__WEBPACK_IMPORTED_MODULE_1__.AlertTitle, null, title),
            message));
    }
}
WarningIndicator.defaultProps = {
    title: ''
};
class CommonWarnings extends (react__WEBPACK_IMPORTED_MODULE_0___default().PureComponent) {
    render() {
        const { additionalFeatures } = this.props;
        const warnings = [];
        if (additionalFeatures)
            warnings.push('You have selected a component inside either a FeatureUnion or ColumnTransformer. ' +
                'In order to still have a functional pipeline, the output of the corresponding sibling components has to be passed to all subsequent components. ' +
                'Additional features are displayed in lighter colors.');
        return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement((react__WEBPACK_IMPORTED_MODULE_0___default().Fragment), null, warnings.length > 0 && react__WEBPACK_IMPORTED_MODULE_0___default().createElement(WarningIndicator, { message: '\n'.concat(...warnings) })));
    }
}


/***/ }),

/***/ "./style/jupyter.svg":
/*!***************************!*\
  !*** ./style/jupyter.svg ***!
  \***************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ("<svg width=\"39\" height=\"51\" viewBox=\"0 0 39 51\" xmlns=\"http://www.w3.org/2000/svg\"\n     xmlns:xlink=\"http://www.w3.org/1999/xlink\">\n    <title>logo-5.svg</title>\n    <desc>Created using Figma 0.90</desc>\n    <g id=\"Canvas\" transform=\"translate(-1638 -2281)\">\n        <g id=\"logo\" style=\"mix-blend-mode:normal;\" >\n            <g id=\"g\" style=\"mix-blend-mode:normal;\" >\n                <g id=\"path\" style=\"mix-blend-mode:normal;\">\n                    <g id=\"path7 fill\" style=\"mix-blend-mode:normal;\">\n                        <use xlink:href=\"#path0_fill\" transform=\"translate(1669.3 2281.31)\" fill=\"#767677\"\n                             style=\"mix-blend-mode:normal;\"/>\n                    </g>\n                </g>\n                <g id=\"path\" style=\"mix-blend-mode:normal;\">\n                    <g id=\"path8 fill\" style=\"mix-blend-mode:normal;\">\n                        <use xlink:href=\"#path1_fill\" transform=\"translate(1639.74 2311.98)\" fill=\"#F37726\"\n                             style=\"mix-blend-mode:normal;\"/>\n                    </g>\n                </g>\n                <g id=\"path\" style=\"mix-blend-mode:normal;\">\n                    <g id=\"path9 fill\" style=\"mix-blend-mode:normal;\">\n                        <use xlink:href=\"#path2_fill\" transform=\"translate(1639.73 2285.48)\" fill=\"#F37726\"\n                             style=\"mix-blend-mode:normal;\"/>\n                    </g>\n                </g>\n                <g id=\"path\" style=\"mix-blend-mode:normal;\">\n                    <g id=\"path10 fill\" style=\"mix-blend-mode:normal;\">\n                        <use xlink:href=\"#path3_fill\" transform=\"translate(1639.8 2323.81)\" fill=\"#989798\"\n                             style=\"mix-blend-mode:normal;\"/>\n                    </g>\n                </g>\n                <g id=\"path\" style=\"mix-blend-mode:normal;\">\n                    <g id=\"path11 fill\" style=\"mix-blend-mode:normal;\">\n                        <use xlink:href=\"#path4_fill\" transform=\"translate(1638.36 2286.06)\" fill=\"#6F7070\"\n                             style=\"mix-blend-mode:normal;\"/>\n                    </g>\n                </g>\n            </g>\n        </g>\n    </g>\n    <defs>\n        <path id=\"path0_fill\"\n              d=\"M 5.89353 2.844C 5.91889 3.43165 5.77085 4.01367 5.46815 4.51645C 5.16545 5.01922 4.72168 5.42015 4.19299 5.66851C 3.6643 5.91688 3.07444 6.00151 2.49805 5.91171C 1.92166 5.8219 1.38463 5.5617 0.954898 5.16401C 0.52517 4.76633 0.222056 4.24903 0.0839037 3.67757C -0.0542483 3.10611 -0.02123 2.50617 0.178781 1.95364C 0.378793 1.4011 0.736809 0.920817 1.20754 0.573538C 1.67826 0.226259 2.24055 0.0275919 2.82326 0.00267229C 3.60389 -0.0307115 4.36573 0.249789 4.94142 0.782551C 5.51711 1.31531 5.85956 2.05676 5.89353 2.844Z\"/>\n        <path id=\"path1_fill\"\n              d=\"M 18.2646 7.13411C 10.4145 7.13411 3.55872 4.2576 0 0C 1.32539 3.8204 3.79556 7.13081 7.0686 9.47303C 10.3417 11.8152 14.2557 13.0734 18.269 13.0734C 22.2823 13.0734 26.1963 11.8152 29.4694 9.47303C 32.7424 7.13081 35.2126 3.8204 36.538 0C 32.9705 4.2576 26.1148 7.13411 18.2646 7.13411Z\"/>\n        <path id=\"path2_fill\"\n              d=\"M 18.2733 5.93931C 26.1235 5.93931 32.9793 8.81583 36.538 13.0734C 35.2126 9.25303 32.7424 5.94262 29.4694 3.6004C 26.1963 1.25818 22.2823 0 18.269 0C 14.2557 0 10.3417 1.25818 7.0686 3.6004C 3.79556 5.94262 1.32539 9.25303 0 13.0734C 3.56745 8.82463 10.4232 5.93931 18.2733 5.93931Z\"/>\n        <path id=\"path3_fill\"\n              d=\"M 7.42789 3.58338C 7.46008 4.3243 7.27355 5.05819 6.89193 5.69213C 6.51031 6.32607 5.95075 6.83156 5.28411 7.1446C 4.61747 7.45763 3.87371 7.56414 3.14702 7.45063C 2.42032 7.33712 1.74336 7.0087 1.20184 6.50695C 0.660328 6.0052 0.27861 5.35268 0.105017 4.63202C -0.0685757 3.91135 -0.0262361 3.15494 0.226675 2.45856C 0.479587 1.76217 0.931697 1.15713 1.52576 0.720033C 2.11983 0.282935 2.82914 0.0334395 3.56389 0.00313344C 4.54667 -0.0374033 5.50529 0.316706 6.22961 0.987835C 6.95393 1.65896 7.38484 2.59235 7.42789 3.58338L 7.42789 3.58338Z\"/>\n        <path id=\"path4_fill\"\n              d=\"M 2.27471 4.39629C 1.84363 4.41508 1.41671 4.30445 1.04799 4.07843C 0.679268 3.8524 0.385328 3.52114 0.203371 3.12656C 0.0214136 2.73198 -0.0403798 2.29183 0.0258116 1.86181C 0.0920031 1.4318 0.283204 1.03126 0.575213 0.710883C 0.867222 0.39051 1.24691 0.164708 1.66622 0.0620592C 2.08553 -0.0405897 2.52561 -0.0154714 2.93076 0.134235C 3.33591 0.283941 3.68792 0.551505 3.94222 0.90306C 4.19652 1.25462 4.34169 1.67436 4.35935 2.10916C 4.38299 2.69107 4.17678 3.25869 3.78597 3.68746C 3.39516 4.11624 2.85166 4.37116 2.27471 4.39629L 2.27471 4.39629Z\"/>\n    </defs>\n</svg>\n");

/***/ })

}]);
//# sourceMappingURL=lib_index_js.9b5313ccecf3b93fdb20.js.map