import { Operator, Stream } from '../index';
export declare class SplitOperator<T> implements Operator<T, Stream<T>> {
    s: Stream<any>;
    ins: Stream<T>;
    type: string;
    curr: Stream<T>;
    out: Stream<Stream<T>>;
    private sil;
    constructor(s: Stream<any>, // s = separator
    ins: Stream<T>);
    _start(out: Stream<Stream<T>>): void;
    _stop(): void;
    up(): void;
    _n(t: T): void;
    _e(err: any): void;
    _c(): void;
}
/**
 * Splits a stream using a separator stream. Returns a stream that emits
 * streams.
 *
 * Marble diagram:
 *
 * ```text
 * --1--2--3--4--5--6--7--8--9|
 *  split( --a----b--- )
 * ---------------------------|
 *   :        :    :
 *   1--2--3-|:    :
 *            4--5|:
 *                 -6--7--8--9|
 * ```
 *
 * Example:
 *
 * ```js
 * import split from 'xstream/extra/split'
 * import concat from 'xstream/extra/concat'
 *
 * const source = xs.periodic(50).take(10)
 * const separator = concat(xs.periodic(167).take(2), xs.never())
 * const result = source.compose(split(separator))
 *
 * result.addListener({
 *   next: stream => {
 *     stream.addListener({
 *       next: i => console.log(i),
 *       error: err => console.error(err),
 *       complete: () => console.log('inner completed')
 *     })
 *   },
 *   error: err => console.error(err),
 *   complete: () => console.log('outer completed')
 * })
 * ```
 *
 * ```text
 * > 0
 * > 1
 * > 2
 * > inner completed
 * > 3
 * > 4
 * > 5
 * > inner completed
 * > 6
 * > 7
 * > 8
 * > 9
 * > inner completed
 * > outer completed
 * ```
 *
 * @param {Stream} separator Some other stream that is used to know when to
 * split the output stream.
 * @return {Stream}
 */
export default function split<T>(separator: Stream<any>): (ins: Stream<T>) => Stream<Stream<T>>;
