"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.NodeEventProducer = exports.DOMEventProducer = void 0;
var index_1 = require("../index");
var DOMEventProducer = /** @class */ (function () {
    function DOMEventProducer(node, eventType, useCapture) {
        this.node = node;
        this.eventType = eventType;
        this.useCapture = useCapture;
        this.type = 'fromEvent';
    }
    DOMEventProducer.prototype._start = function (out) {
        this.listener = function (e) { return out._n(e); };
        this.node.addEventListener(this.eventType, this.listener, this.useCapture);
    };
    DOMEventProducer.prototype._stop = function () {
        this.node.removeEventListener(this.eventType, this.listener, this.useCapture);
        this.listener = null;
    };
    return DOMEventProducer;
}());
exports.DOMEventProducer = DOMEventProducer;
var NodeEventProducer = /** @class */ (function () {
    function NodeEventProducer(node, eventName) {
        this.node = node;
        this.eventName = eventName;
        this.type = 'fromEvent';
    }
    NodeEventProducer.prototype._start = function (out) {
        this.listener = function () {
            var args = [];
            for (var _i = 0; _i < arguments.length; _i++) {
                args[_i] = arguments[_i];
            }
            return (args.length > 1) ? out._n(args) : out._n(args[0]);
        };
        this.node.addListener(this.eventName, this.listener);
    };
    NodeEventProducer.prototype._stop = function () {
        this.node.removeListener(this.eventName, this.listener);
        this.listener = null;
    };
    return NodeEventProducer;
}());
exports.NodeEventProducer = NodeEventProducer;
function isEmitter(element) {
    return element.emit && element.addListener;
}
/**
 * Creates a stream based on either:
 * - DOM events with the name `eventName` from a provided target node
 * - Events with the name `eventName` from a provided NodeJS EventEmitter
 *
 * When creating a stream from EventEmitters, if the source event has more than
 * one argument all the arguments will be aggregated into an array in the
 * result stream.
 *
 * (Tip: when using this factory with TypeScript, you will need types for
 * Node.js because fromEvent knows how to handle both DOM events and Node.js
 * EventEmitter. Just install `@types/node`)
 *
 * Marble diagram:
 *
 * ```text
 *   fromEvent(element, eventName)
 * ---ev--ev----ev---------------
 * ```
 *
 * Examples:
 *
 * ```js
 * import fromEvent from 'xstream/extra/fromEvent'
 *
 * const stream = fromEvent(document.querySelector('.button'), 'click')
 *   .mapTo('Button clicked!')
 *
 * stream.addListener({
 *   next: i => console.log(i),
 *   error: err => console.error(err),
 *   complete: () => console.log('completed')
 * })
 * ```
 *
 * ```text
 * > 'Button clicked!'
 * > 'Button clicked!'
 * > 'Button clicked!'
 * ```
 *
 * ```js
 * import fromEvent from 'xstream/extra/fromEvent'
 * import {EventEmitter} from 'events'
 *
 * const MyEmitter = new EventEmitter()
 * const stream = fromEvent(MyEmitter, 'foo')
 *
 * stream.addListener({
 *   next: i => console.log(i),
 *   error: err => console.error(err),
 *   complete: () => console.log('completed')
 * })
 *
 * MyEmitter.emit('foo', 'bar')
 * ```
 *
 * ```text
 * > 'bar'
 * ```
 *
 * ```js
 * import fromEvent from 'xstream/extra/fromEvent'
 * import {EventEmitter} from 'events'
 *
 * const MyEmitter = new EventEmitter()
 * const stream = fromEvent(MyEmitter, 'foo')
 *
 * stream.addListener({
 *   next: i => console.log(i),
 *   error: err => console.error(err),
 *   complete: () => console.log('completed')
 * })
 *
 * MyEmitter.emit('foo', 'bar', 'baz', 'buzz')
 * ```
 *
 * ```text
 * > ['bar', 'baz', 'buzz']
 * ```
 *
 * @factory true
 * @param {EventTarget|EventEmitter} element The element upon which to listen.
 * @param {string} eventName The name of the event for which to listen.
 * @param {boolean?} useCapture An optional boolean that indicates that events of
 * this type will be dispatched to the registered listener before being
 * dispatched to any EventTarget beneath it in the DOM tree. Defaults to false.
 * @return {Stream}
 */
function fromEvent(element, eventName, useCapture) {
    if (useCapture === void 0) { useCapture = false; }
    if (isEmitter(element)) {
        return new index_1.Stream(new NodeEventProducer(element, eventName));
    }
    else {
        return new index_1.Stream(new DOMEventProducer(element, eventName, useCapture));
    }
}
exports.default = fromEvent;
//# sourceMappingURL=data:application/json;base64,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