export interface Selector {
    tag: string;
    id: string;
    classList: string[];
    attributes: Attributes;
    nextSelector: [Combinator, Selector] | undefined;
    pseudos: Pseudo[];
}
export declare type Pseudo = ['first-child', undefined] | ['last-child', undefined] | ['nth-child', string] | ['empty', undefined] | ['root', undefined] | ['contains', string];
export interface Attributes {
    [attr: string]: [AttributeMatch, string | number | boolean];
}
export declare type AttributeMatch = 'exact' | 'has' | 'startsWith' | 'endsWith' | 'contains' | 'whitespace' | 'dash';
export declare type Combinator = 'subtree' | 'child' | 'nextSibling' | 'sibling';
/**
 * Parses a css selector into a normalized object.
 * Expects a selector for a single element only, no `>` or the like!
 */
export declare function parseSelector(selector: string): Selector;
