"use strict";
var Rx = require('rx');
var RxJSAdapter = {
    adapt: function (originStream, originStreamSubscribe) {
        if (this.isValidStream(originStream)) {
            return originStream;
        }
        return Rx.Observable.create(function (destinationObserver) {
            var originObserver = {
                next: function (x) { return destinationObserver.onNext(x); },
                error: function (e) { return destinationObserver.onError(e); },
                complete: function () { return destinationObserver.onCompleted(); },
            };
            var dispose = originStreamSubscribe(originStream, originObserver);
            return function () {
                if (typeof dispose === 'function') {
                    dispose.call(null);
                }
            };
        });
    },
    remember: function (observable) {
        return observable.shareReplay(1);
    },
    makeSubject: function () {
        var stream = new Rx.Subject();
        var observer = {
            next: function (x) { stream.onNext(x); },
            error: function (err) { stream.onError(err); },
            complete: function (x) { stream.onCompleted(); },
        };
        return { stream: stream, observer: observer };
    },
    isValidStream: function (stream) {
        return (typeof stream.subscribeOnNext === 'function' &&
            typeof stream.onValue !== 'function');
    },
    streamSubscribe: function (stream, observer) {
        var subscription = stream.subscribe(function (x) { return observer.next(x); }, function (e) { return observer.error(e); }, function (x) { return observer.complete(x); });
        return function () {
            subscription.dispose();
        };
    },
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.default = RxJSAdapter;
//# sourceMappingURL=index.js.map