import { Stream, MemoryStream } from 'xstream';
import { EventsFnOptions } from './DOMSource';
import { DocumentDOMSource } from './DocumentDOMSource';
import { BodyDOMSource } from './BodyDOMSource';
import { VNode } from 'snabbdom/vnode';
import { Scope, IsolateSink } from './isolate';
import { IsolateModule } from './IsolateModule';
import { EventDelegator } from './EventDelegator';
export interface SpecialSelector {
    body: BodyDOMSource;
    document: DocumentDOMSource;
}
export declare class MainDOMSource {
    private _rootElement$;
    private _sanitation$;
    private _namespace;
    _isolateModule: IsolateModule;
    private _eventDelegator;
    private _name;
    constructor(_rootElement$: Stream<Element>, _sanitation$: Stream<null>, _namespace: Array<Scope>, _isolateModule: IsolateModule, _eventDelegator: EventDelegator, _name: string);
    private _elements;
    elements(): MemoryStream<Array<Element>>;
    element(): MemoryStream<Element>;
    readonly namespace: Array<Scope>;
    select<T extends keyof SpecialSelector>(selector: T): SpecialSelector[T];
    select(selector: string): MainDOMSource;
    events<K extends keyof HTMLElementEventMap>(eventType: K, options?: EventsFnOptions, bubbles?: boolean): Stream<HTMLElementEventMap[K]>;
    dispose(): void;
    isolateSource: (source: MainDOMSource, scope: string) => MainDOMSource;
    isolateSink: IsolateSink<VNode>;
}
