import { VNode } from 'snabbdom/vnode';
import { EventDelegator } from './EventDelegator';
import { Scope } from './isolate';
export declare class IsolateModule {
    private namespaceTree;
    private namespaceByElement;
    private eventDelegator;
    /**
     * A registry that keeps track of all the nodes that are removed from
     * the virtual DOM in a single patch. Those nodes are cleaned once snabbdom
     * has finished patching the DOM.
     */
    private vnodesBeingRemoved;
    constructor();
    setEventDelegator(del: EventDelegator): void;
    private insertElement;
    private removeElement;
    getElement(namespace: Array<Scope>, max?: number): Element | undefined;
    getRootElement(elm: Element): Element | undefined;
    getNamespace(elm: Element): Array<Scope> | undefined;
    createModule(): {
        create(emptyVNode: VNode, vNode: VNode): void;
        update(oldVNode: VNode, vNode: VNode): void;
        destroy(vNode: VNode): void;
        remove(vNode: VNode, cb: Function): void;
        post(): void;
    };
}
