import { Stream } from 'xstream';
import { IsolateModule } from './IsolateModule';
import { EventsFnOptions } from './DOMSource';
import { Scope } from './isolate';
export interface CycleDOMEvent extends Event {
    propagationHasBeenStopped: boolean;
    ownerTarget: Element;
}
export declare const eventTypesThatDontBubble: string[];
/**
 * Manages "Event delegation", by connecting an origin with multiple
 * destinations.
 *
 * Attaches a DOM event listener to the DOM element called the "origin",
 * and delegates events to "destinations", which are subjects as outputs
 * for the DOMSource. Simulates bubbling or capturing, with regards to
 * isolation boundaries too.
 */
export declare class EventDelegator {
    private rootElement$;
    isolateModule: IsolateModule;
    private virtualListeners;
    private origin;
    private domListeners;
    private nonBubblingListeners;
    private domListenersToAdd;
    private nonBubblingListenersToAdd;
    private virtualNonBubblingListener;
    constructor(rootElement$: Stream<Element>, isolateModule: IsolateModule);
    addEventListener(eventType: string, namespace: Array<Scope>, options: EventsFnOptions, bubbles?: boolean): Stream<Event>;
    removeElement(element: Element, namespace?: Array<Scope>): void;
    private insertListener;
    /**
     * Returns a set of all virtual listeners in the scope of the namespace
     * Set `exact` to true to treat sibiling isolated scopes as total scopes
     */
    private getVirtualListeners;
    private setupDOMListener;
    private setupNonBubblingListener;
    private resetEventListeners;
    private putNonBubblingListener;
    private onEvent;
    private bubble;
    private doBubbleStep;
    private patchEvent;
    private mutateEventCurrentTarget;
}
