export default class SymbolTree<Payload, T> {
    private mapper;
    private tree;
    constructor(mapper: (t: T) => string);
    set(path: Array<T>, element: Payload | undefined, max?: number): void;
    getDefault(path: Array<T>, mkDefaultElement: () => Payload, max?: number): Payload;
    /**
     * Returns the payload of the path
     * If a default element creator is given, it will insert it at the path
     */
    get(path: Array<T>, mkDefaultElement?: () => Payload, max?: number): Payload | undefined;
    delete(path: Array<T>): void;
}
