import { IsolateModule } from './IsolateModule';
import { Scope } from './isolate';
export declare class ScopeChecker {
    readonly namespace: Array<Scope>;
    private isolateModule;
    readonly _namespace: Array<Scope>;
    constructor(namespace: Array<Scope>, isolateModule: IsolateModule);
    /**
     * Checks whether the given element is *directly* in the scope of this
     * scope checker. Being contained *indirectly* through other scopes
     * is not valid. This is crucial for implementing parent-child isolation,
     * so that the parent selectors don't search inside a child scope.
     */
    isDirectlyInScope(leaf: Element): boolean;
}
