"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

var _asyncToGenerator2 = _interopRequireDefault(require("@babel/runtime/helpers/asyncToGenerator"));

const Asset = require('../Asset');

const localRequire = require('../utils/localRequire');

const isAccessedVarChanged = require('../utils/isAccessedVarChanged');

class TypeScriptAsset extends Asset {
  constructor(name, options) {
    super(name, options);
    this.type = 'js';
    this.cacheData.env = {};
  }

  shouldInvalidate(cacheData) {
    return isAccessedVarChanged(cacheData);
  }

  generate() {
    var _this = this;

    return (0, _asyncToGenerator2.default)(function* () {
      // require typescript, installed locally in the app
      let typescript = yield localRequire('typescript', _this.name);
      let transpilerOptions = {
        compilerOptions: {
          module: _this.options.scopeHoist ? typescript.ModuleKind.ESNext : typescript.ModuleKind.CommonJS,
          jsx: typescript.JsxEmit.Preserve,
          // it brings the generated output from TypeScript closer to that generated by Babel
          // see https://www.typescriptlang.org/docs/handbook/release-notes/typescript-2-7.html
          esModuleInterop: true
        },
        fileName: _this.relativeName
      };
      let tsconfig = yield _this.getConfig(['tsconfig.json']); // Overwrite default if config is found

      if (tsconfig) {
        transpilerOptions.compilerOptions = Object.assign(transpilerOptions.compilerOptions, tsconfig.compilerOptions);
      }

      transpilerOptions.compilerOptions.noEmit = false;
      transpilerOptions.compilerOptions.sourceMap = _this.options.sourceMaps; // Transpile Module using TypeScript and parse result as ast format through babylon

      let transpiled = typescript.transpileModule(_this.contents, transpilerOptions);
      let sourceMap = transpiled.sourceMapText;

      if (sourceMap) {
        sourceMap = JSON.parse(sourceMap);
        sourceMap.sources = [_this.relativeName];
        sourceMap.sourcesContent = [_this.contents]; // Remove the source map URL

        let content = transpiled.outputText;
        transpiled.outputText = content.substring(0, content.lastIndexOf('//# sourceMappingURL'));
      }

      return [{
        type: 'js',
        value: transpiled.outputText,
        map: sourceMap
      }];
    })();
  }

}

module.exports = TypeScriptAsset;