# -*- coding: utf-8 -*-
from setuptools import setup

package_dir = \
{'': 'src'}

packages = \
['opendata_pipeline']

package_data = \
{'': ['*']}

install_requires = \
['aiohttp>=3.8.1,<4.0.0',
 'orjson>=3.8.0,<4.0.0',
 'pandas>=1.4.4,<2.0.0',
 'pydantic[dotenv]>=1.10.2,<2.0.0',
 'requests>=2.28.1,<3.0.0',
 'rich>=12.5.1,<13.0.0',
 'typer>=0.6.1,<0.7.0']

entry_points = \
{'console_scripts': ['opendata-pipeline = opendata_pipeline:app']}

setup_kwargs = {
    'name': 'opendata-pipeline',
    'version': '0.2.1',
    'description': "A pipeline for processing open medical examier's data using GitHub Actions CI/CD.",
    'long_description': "TODO:\n\n- [ ] Add A LOT more PRINT statements\n- [x] Add comments\n- [ ] Add documentation (README and docs site)\n  - The latter will be necesarry once we move to dockerfiles and actions\n- [ ] Add tests 😅\n  - [ ] including CLI tests\n- [x] Use arcgis package for geocoding\n  - [ ] Use batch geocoding (had problem with Token... can register as anonymous user?)\n~~- [x] Use Socrata package (register API key) for data fetching from datasets published on Socrata~~\n  - [x] Use `requests` package for data fetching from datasets published on odata\n- [x] Use github python package to keep config.yaml updated after successful runs\n  - [ ] Can also use to update JS datafiles at end of analysis (see below)\n  - [x] Just used requests and api directly\n    - These should be very small and generated by pandas analysis of the data\n- [ ] results should be in a github release (data files) (can zip them)\n  - [ ] Use GH CLI in bash script because pre-installed in Actions\n  - [ ] We can then just use the OctoKit JS package to point to the LINKS of the files and when you click on them it will download them\n  - [ ] then web page to enable file downloads and show some graphs (basic --> records over time for each dataset)\n    -  what charting frameowkr to use?\n    -  Need an action to update the frontend codebase with the new data\n       -  Store in JSON format\n~~-  [ ] add website to socrata key~~\n-  [x] Make a container to run the whole pipeline (so no downloads for users)\n   -  [ ] Host on GHCR\n-  [x] MAKE OUR OWN UNIQUE IDENTIFIERS FOR ALL DATASETS COMBINED\n   -  [x] SAME COLUMN NAME IN ALL DATASETS, THEN DON'T HAVE TO PROVIDE IDENTIFIER COLUMN IN config.yaml\n   -  [x] Also allows for better merging of datasets (i.e. records + drugs + geo)\n~~- [ ] DO we want to publish a Web API as well?~~\n  ~~- [ ] Then weould need DB~~\n- [x] No Windows support due to drug extraction tool usage\n\nI think, if my math is right, we can do ~20 minutes / day of actions... (2,000 minutes per month limit for free)\n\n\n*** make a note it is very important to often PULL to stay updated with the CONFIG",
    'author': 'Nick Anthony',
    'author_email': 'nanthony007@gmail.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': None,
    'package_dir': package_dir,
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.10,<4.0',
}


setup(**setup_kwargs)
