"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.TlsCertificate = exports.TlsMode = void 0;
/**
 * (experimental) Enum of supported TLS modes.
 *
 * @experimental
 */
var TlsMode;
(function (TlsMode) {
    TlsMode["STRICT"] = "STRICT";
    TlsMode["PERMISSIVE"] = "PERMISSIVE";
    TlsMode["DISABLED"] = "DISABLED";
})(TlsMode = exports.TlsMode || (exports.TlsMode = {}));
/**
 * (experimental) Represents a TLS certificate.
 *
 * @experimental
 */
class TlsCertificate {
    /**
     * (experimental) Returns an File TLS Certificate.
     *
     * @experimental
     */
    static file(props) {
        return new FileTlsCertificate(props);
    }
    /**
     * (experimental) Returns an ACM TLS Certificate.
     *
     * @experimental
     */
    static acm(props) {
        return new AcmTlsCertificate(props);
    }
}
exports.TlsCertificate = TlsCertificate;
/**
 * Represents a ACM provided TLS certificate
 */
class AcmTlsCertificate extends TlsCertificate {
    constructor(props) {
        super();
        this.tlsMode = props.tlsMode;
        this.acmCertificate = props.certificate;
    }
    bind(_scope) {
        return {
            tlsCertificate: {
                acm: {
                    certificateArn: this.acmCertificate.certificateArn,
                },
            },
            tlsMode: this.tlsMode,
        };
    }
}
/**
 * Represents a file provided TLS certificate
 */
class FileTlsCertificate extends TlsCertificate {
    constructor(props) {
        super();
        this.tlsMode = props.tlsMode;
        this.certificateChain = props.certificateChainPath;
        this.privateKey = props.privateKeyPath;
    }
    bind(_scope) {
        return {
            tlsCertificate: {
                file: {
                    certificateChain: this.certificateChain,
                    privateKey: this.privateKey,
                },
            },
            tlsMode: this.tlsMode,
        };
    }
}
//# sourceMappingURL=data:application/json;base64,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