from django.http import HttpResponse, HttpResponseRedirect
from django.shortcuts import get_object_or_404, render
from django.urls import reverse
from django.views import generic
# # Create your views here.
from . import urls
from .models import Question, Choice
from django.utils import timezone

def index(request): 
    latest_question_list = Question.objects.order_by('-pub_date')[:5]
    context = {'latest_question_list': latest_question_list} 
    return render(request, 'polls/index.html', context)

def detail(request, question_id): 
    question = get_object_or_404(Question, pk=question_id) 
    return render(request, 'polls/detail.html', {'question': question})


def results(request, question_id): 
    question = get_object_or_404(Question, pk=question_id) 
    return render(request, 'polls/results.html', {'question': question})

def vote(request, question_id): 
    # same as above, no changes needed.
    question = get_object_or_404(Question, pk=question_id)
    try:
        selected_choice = question.choice_set.get(pk=request.POST['choice']) 
    except (KeyError, Choice.DoesNotExist):
        # Redisplay the question voting form. 
        return render(request, 'polls/detail.html', { 
            'question': question, 
            'error_message': "You didn't select a choice.",                                             
        }) 
    else: 
        selected_choice.votes += 1
        selected_choice.save()   
        # Always return an HttpResponseRedirect after successfully dealing
        # with POST data. This prevents data from being posted twice if a
        # user hits the Back button.
        return HttpResponseRedirect(reverse('polls:results', args=(question.id,)))  

