# coding: utf-8
#
# Copyright 2022 :Barry-Thomas-Paul: Moss
#
# Licensed under the Apache License, Version 2.0 (the "License")
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http: // www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Const
# this is a auto generated file generated by Cheetah
# Libre Office Version: 7.2
# Namespace: com.sun.star.text
from typing_extensions import Literal
"""
Const

These values define parts of bibliographic data.

They are used to create a bibliography in a text document.

Depending on the type of the data some of the fields will usually be left empty.

See Also:
    `API BibliographyDataField <https://api.libreoffice.org/docs/idl/ref/namespacecom_1_1sun_1_1star_1_1text_1_1BibliographyDataField.html>`_
"""
IDENTIFIER: Literal[0]
"""
This field contains a unique identifier for the bibliographic data.
"""
BIBILIOGRAPHIC_TYPE: Literal[1]
"""
This field contains the type of the bibliographic reference.

It is of the type BibliographyDataType.
"""
ADDRESS: Literal[2]
"""
This field contains the address of the publisher.
"""
ANNOTE: Literal[3]
"""
This field contains an annotation.
"""
AUTHOR: Literal[4]
"""
This field contains the name(s) of the author(s)
"""
BOOKTITLE: Literal[5]
"""
This field contains the title of the book.
"""
CHAPTER: Literal[6]
"""
This field contains the name or number of the chapter.
"""
EDITION: Literal[7]
"""
This field contains the number or name of the edition.
"""
EDITOR: Literal[8]
"""
This field contains the name(s) of the editor(s)
"""
HOWPUBLISHED: Literal[9]
"""
This field contains a description of the type of the publishing.
"""
INSTITUTION: Literal[10]
"""
This field contains the name of the institution where the publishing was created.
"""
JOURNAL: Literal[11]
"""
This field contains the name of the journal.
"""
MONTH: Literal[12]
"""
This field contains number or name of the month of the publishing.
"""
NOTE: Literal[13]
"""
This field contains a note.
"""
NUMBER: Literal[14]
"""
This field contains the number of the publishing.
"""
ORGANIZATIONS: Literal[15]
"""
This field contains the name of the organizations where the publishing was created.
"""
PAGES: Literal[16]
"""
This field contains the number(s) of the page(s) of the reference into a publishing.
"""
PUBLISHER: Literal[17]
"""
This field contains the name of the publisher.
"""
SCHOOL: Literal[18]
"""
This field contains the name of the university or school where the publishing was created.
"""
SERIES: Literal[19]
"""
This field contains the series of the publishing.
"""
TITLE: Literal[20]
"""
This field contains the title of the publishing.
"""
REPORT_TYPE: Literal[21]
"""
This field contains a description of the type of the report.
"""
VOLUME: Literal[22]
"""
This field contains the volume of the publishing.
"""
YEAR: Literal[23]
"""
This field contains the year when the publishing was created.
"""
URL: Literal[24]
"""
This field contains URL of the publishing.
"""
CUSTOM1: Literal[25]
"""
This field contains user defined data.
"""
CUSTOM2: Literal[26]
"""
This field contains user defined data.
"""
CUSTOM3: Literal[27]
"""
This field contains user defined data.
"""
CUSTOM4: Literal[28]
"""
This field contains user defined data.
"""
CUSTOM5: Literal[29]
"""
This field contains user defined data.
"""
ISBN: Literal[30]
"""
This field contains the ISBN data of the publishing.
"""

