# coding: utf-8
#
# Copyright 2022 :Barry-Thomas-Paul: Moss
#
# Licensed under the Apache License, Version 2.0 (the "License")
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http: // www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Struct Class
# this is a auto generated file generated by Cheetah
# Namespace: com.sun.star.linguistic2
# Libre Office Version: 7.2
from typing_extensions import Literal
import typing
from ..beans.property_value import PropertyValue as PropertyValue_c9610c73
from ..lang.locale import Locale as Locale_70d308fa
from .single_proofreading_error import SingleProofreadingError as SingleProofreadingError_c54812c1
from .x_proofreader import XProofreader as XProofreader_dab0e46
from ..text.x_flat_paragraph import XFlatParagraph as XFlatParagraph_c8310c42


class ProofreadingResult(object):
    """
    Struct Class

    holds the results from proofreading a sentence.
    
    **since**
    
        OOo 3.0.1

    See Also:
        `API ProofreadingResult <https://api.libreoffice.org/docs/idl/ref/structcom_1_1sun_1_1star_1_1linguistic2_1_1ProofreadingResult.html>`_
    """
    typeName: Literal['com.sun.star.linguistic2.ProofreadingResult']

    def __init__(self, aErrors: typing.Optional[typing.Tuple[SingleProofreadingError_c54812c1, ...]] = ..., aProperties: typing.Optional[typing.Tuple[PropertyValue_c9610c73, ...]] = ..., aDocumentIdentifier: typing.Optional[str] = ..., xFlatParagraph: typing.Optional[XFlatParagraph_c8310c42] = ..., aText: typing.Optional[str] = ..., aLocale: typing.Optional[Locale_70d308fa] = ..., nStartOfSentencePosition: typing.Optional[int] = ..., nBehindEndOfSentencePosition: typing.Optional[int] = ..., nStartOfNextSentencePosition: typing.Optional[int] = ..., xProofreader: typing.Optional[XProofreader_dab0e46] = ...) -> None:
        """
        Constructor

        Arguments:
            aErrors (typing.Tuple[SingleProofreadingError, ...], optional): aErrors value.
            aProperties (typing.Tuple[PropertyValue, ...], optional): aProperties value.
            aDocumentIdentifier (str, optional): aDocumentIdentifier value.
            xFlatParagraph (XFlatParagraph, optional): xFlatParagraph value.
            aText (str, optional): aText value.
            aLocale (Locale, optional): aLocale value.
            nStartOfSentencePosition (int, optional): nStartOfSentencePosition value.
            nBehindEndOfSentencePosition (int, optional): nBehindEndOfSentencePosition value.
            nStartOfNextSentencePosition (int, optional): nStartOfNextSentencePosition value.
            xProofreader (XProofreader, optional): xProofreader value.
        """
        ...


    @property
    def aErrors(self) -> typing.Tuple[SingleProofreadingError_c54812c1, ...]:
        ...


    @property
    def aProperties(self) -> typing.Tuple[PropertyValue_c9610c73, ...]:
        ...


    @property
    def aDocumentIdentifier(self) -> str:
        ...


    @property
    def xFlatParagraph(self) -> XFlatParagraph_c8310c42:
        ...


    @property
    def aText(self) -> str:
        ...


    @property
    def aLocale(self) -> Locale_70d308fa:
        ...


    @property
    def nStartOfSentencePosition(self) -> int:
        ...


    @property
    def nBehindEndOfSentencePosition(self) -> int:
        ...


    @property
    def nStartOfNextSentencePosition(self) -> int:
        ...


    @property
    def xProofreader(self) -> XProofreader_dab0e46:
        ...


