# coding: utf-8
#
# Copyright 2022 :Barry-Thomas-Paul: Moss
#
# Licensed under the Apache License, Version 2.0 (the "License")
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http: // www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Service Class
# this is a auto generated file generated by Cheetah
# Libre Office Version: 7.2
# Namespace: com.sun.star.drawing.framework
from .x_resource_id import XResourceId as XResourceId_5be3103d

class ResourceId(XResourceId_5be3103d):
    """
    Service Class

    The ResourceId service provides several constructors for resource ids.
    
    They mainly differ in how the anchor is specified.

    See Also:
        `API ResourceId <https://api.libreoffice.org/docs/idl/ref/servicecom_1_1sun_1_1star_1_1drawing_1_1framework_1_1ResourceId.html>`_
    """
    def create(self, sResourceURL: str) -> None:
        """
        Create a resource id that has no anchor.
        
        This constructor can be used to create resource ids for panes.
        """
        ...
    def createEmpty(self) -> None:
        """
        Create an empty resource id.
        
        It does not specify a specific resource but describes the absence of one.
        """
        ...
    def createWithAnchor(self, sResourceURL: str, xAnchor: 'XResourceId_5be3103d') -> None:
        """
        Create a resource id for an anchor that is given as XResourceId object.
        
        This is the most general of the constructor variants.
        """
        ...
    def createWithAnchorURL(self, sResourceURL: str, sAnchorURL: str) -> None:
        """
        Create a resource id for a resource that is bound to an anchor that can be specified by a single URL.
        
        This constructor can be used to create resources ids for views where the anchor is a pane.
        """
        ...


