# codat-bankfeeds

<!-- Start SDK Installation -->
## SDK Installation

```bash
pip install codat-bankfeeds
```
<!-- End SDK Installation -->

## SDK Example Usage
<!-- Start SDK Example Usage -->
```python
import bankfeeds
from bankfeeds.models import operations, shared

s = bankfeeds.BankFeeds(
    security=shared.Security(
        auth_header="YOUR_API_KEY_HERE",
    ),
)


req = operations.CreateBankFeedRequest(
    request_body=[
        operations.CreateBankFeedBankFeedBankAccount(
            account_name="deserunt",
            account_number="porro",
            account_type="Debit",
            balance=6027.63,
            currency="vero",
            feed_start_date="2022-08-29T22:24:53.491Z",
            id="nulla",
            modified_date="2022-10-13T04:22:31.580Z",
            sort_code="fuga",
            status="facilis",
        ),
        operations.CreateBankFeedBankFeedBankAccount(
            account_name="eum",
            account_number="iusto",
            account_type="Unknown",
            balance=8917.73,
            currency="inventore",
            feed_start_date="2022-03-30T01:54:20.865Z",
            id="enim",
            modified_date="2022-10-27T20:38:37.396Z",
            sort_code="voluptatum",
            status="autem",
        ),
        operations.CreateBankFeedBankFeedBankAccount(
            account_name="vel",
            account_number="non",
            account_type="Credit",
            balance=5680.45,
            currency="reprehenderit",
            feed_start_date="2022-04-12T23:21:54.329Z",
            id="quo",
            modified_date="2023-02-18T21:18:55.753Z",
            sort_code="laboriosam",
            status="dicta",
        ),
    ],
    company_id="est",
    connection_id="voluptatem",
)
    
res = s.create_bank_feed(req)

if res.bank_feed_bank_accounts is not None:
    # handle response
```
<!-- End SDK Example Usage -->

<!-- Start SDK Available Operations -->
## SDK Available Operations

### BankFeeds SDK

* `create_bank_feed` - Create bank feed bank accounts
* `get_bank_account_push_options` - List push options for bank account bank transactions
* `get_bank_feeds` - List bank feed bank accounts
* `list_bank_account_transactions` - List bank transactions for bank account
* `post_bank_transactions` - Create bank transactions
* `update_bank_feed` - Update bank feed bank account
<!-- End SDK Available Operations -->

### SDK Generated by [Speakeasy](https://docs.speakeasyapi.dev/docs/using-speakeasy/client-sdks)
