# coding: utf-8

"""
    Fincura API

    This [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer) allows you to interact with the Fincura processing and insights engine.   # Authentication  This API uses API keys generated from a Fincura User account. To get access to your User account, speak with you Fincura account manager.  # Accepted Media Types  | File&nbsp;Type&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | Extension(s)     | Content-Type(s) | | -------------------------------- |-------------- | ------------ | | PDF File | .pdf | `application/pdf` , `application/x-pdf` | | Excel File | .xls | `application/vnd.ms-excel`  | | Excel File | .xlsx | `application/vnd.openxmlformats-officedocument.spreadsheetml.sheet`  | | Excel File | .xlsm | `application/vnd.ms-excel.sheet.macroEnabled.12`  | | PNG Image | .png | `image/png`  | | GIF Image | .gif | `image/gif`  | | JPG Image | .jpg, .jpeg | `image/jpeg`  | | GIF Image | .gif | `image/gif`  |   # Getting Started  1. [Create a Borrower](#operation/createBorrower)  2. [Add a file](#operation/createDocumentFile) for that Borrower. 3. Analyze in the Fincura App  ****  # noqa: E501

    The version of the OpenAPI document: 1.2.6
    Contact: support@fincura.com
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from fincura.api_client import ApiClient, Endpoint
from fincura.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from fincura.model.bulk_file_create import BulkFileCreate
from fincura.model.bulk_file_read import BulkFileRead
from fincura.model.document_file_create import DocumentFileCreate
from fincura.model.document_file_read import DocumentFileRead
from fincura.model.inline_response200 import InlineResponse200


class FilesApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

        def __create_bulk_file(
            self,
            **kwargs
        ):
            """Submit a new BulkFile  # noqa: E501

            Add a new file to Fincura that maps to many borrowers. Requires use of a specific file processor per file format. Speak with you Fincura account manager about available options on your account.       POST /v1/bulk-file HTTP/1.1     Host: api-local.fincura.com:8000     Accept: application/json     Authorization: Bearer eyJ0e...nFTRKTbcg     Content-Type: application/json      {         \"processor_key\": \"6e64724a-25fc-4e1a-8071-1ef29845ab1d\",         \"media_type\": \"application/pdf\"\"     }       The above request will create a new document record in Fincura and return a url to send the file to, as seen below.      {         \"uuid\": \"0f3274f4-e3e3-463a-8290-7b7a6a7a62cb\",         \"upload_url\": \"https://upload.fincura.com/0f3274f4-e3e3-463a-8290-7b7a6a7a62cb/document.pdf?signature=mWFg4xsgm4EtFEt\"     }  In a subsequent request, the file can be sent to the `upload_url` via [HTTP PUT](https://developer.mozilla.org/en-US/docs/Web/HTTP/Methods/PUT). The `Content-Length` and `Content-Type` headers are required. The `Content-Type` should match the `media_type` from the previous request.      PUT /0f3274f4-e3e3-463a-8290-7b7a6a7a62cb/document.pdf?signature=mWFg4xsgm4EtFEt HTTP/1.1     Host: upload.fincura.com     Content-Length: 18828     Content-Type: application/pdf          {FILE  DATA}  Fincura will begin processing the file once it has been completely uploaded.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.create_bulk_file(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                bulk_file_create (BulkFileCreate): [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                BulkFileCreate
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        self.create_bulk_file = Endpoint(
            settings={
                'response_type': (BulkFileCreate,),
                'auth': [
                    'API_Key'
                ],
                'endpoint_path': '/v1/bulk-file',
                'operation_id': 'create_bulk_file',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'bulk_file_create',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'bulk_file_create':
                        (BulkFileCreate,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'bulk_file_create': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json',
                    'application/x-www-form-urlencoded',
                    'multipart/form-data'
                ]
            },
            api_client=api_client,
            callable=__create_bulk_file
        )

        def __create_document_file(
            self,
            **kwargs
        ):
            """Submit a new DocumentFile  # noqa: E501

            Add a new file to Fincura for processing.  The minimal document creation request requires just a borrower_uuid and the media_type of the file to process.       POST /v1/document-file HTTP/1.1     Host: api-local.fincura.com:8000     Accept: application/json     Authorization: Bearer eyJ0e...nFTRKTbcg     Content-Type: application/json      {         \"borrower_uuid\": \"6e64724a-25fc-4e1a-8071-1ef29845ab1d\",         \"media_type\": \"application/pdf\"     }       The above request will create a new document record in Fincura and return a url to send the file to, as seen below.      {         \"uuid\": \"99917dd4-caec-4b3d-8f0c-ab3465369686\",         \"upload_url\": \"https://upload.fincura.com/99917dd4-caec-4b3d-8f0c-ab3465369686/document.pdf?signature=mWFg4xsgm4EtFEt\"     }  In a subsequent request, the file can be sent to the `upload_url` via [HTTP PUT](https://developer.mozilla.org/en-US/docs/Web/HTTP/Methods/PUT). The `Content-Length` and `Content-Type` headers are required. The `Content-Type` should match the `media_type` from the previous request.      PUT /99917dd4-caec-4b3d-8f0c-ab3465369686/document.pdf?signature=mWFg4xsgm4EtFEt HTTP/1.1     Host: upload.fincura.com     Content-Length: 18828     Content-Type: application/pdf          {FILE  DATA}  Fincura will begin processing the file once it has been completely uploaded.  Additional fields described below:  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.create_document_file(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                document_file_create (DocumentFileCreate): [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                DocumentFileCreate
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        self.create_document_file = Endpoint(
            settings={
                'response_type': (DocumentFileCreate,),
                'auth': [
                    'API_Key'
                ],
                'endpoint_path': '/v1/document-file',
                'operation_id': 'create_document_file',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'document_file_create',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'document_file_create':
                        (DocumentFileCreate,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'document_file_create': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json',
                    'application/x-www-form-urlencoded',
                    'multipart/form-data'
                ]
            },
            api_client=api_client,
            callable=__create_document_file
        )

        def __destroy_document_file(
            self,
            uuid,
            **kwargs
        ):
            """Delete a DocumentFile  # noqa: E501

            Delete a file from Fincura.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.destroy_document_file(uuid, async_req=True)
            >>> result = thread.get()

            Args:
                uuid (str):

            Keyword Args:
                borrower_uuid (str): Borrower to filter results for. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                None
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['uuid'] = \
                uuid
            return self.call_with_http_info(**kwargs)

        self.destroy_document_file = Endpoint(
            settings={
                'response_type': None,
                'auth': [
                    'API_Key'
                ],
                'endpoint_path': '/v1/document-file/{uuid}',
                'operation_id': 'destroy_document_file',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'uuid',
                    'borrower_uuid',
                ],
                'required': [
                    'uuid',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'uuid':
                        (str,),
                    'borrower_uuid':
                        (str,),
                },
                'attribute_map': {
                    'uuid': 'uuid',
                    'borrower_uuid': 'borrower_uuid',
                },
                'location_map': {
                    'uuid': 'path',
                    'borrower_uuid': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [],
                'content_type': [],
            },
            api_client=api_client,
            callable=__destroy_document_file
        )

        def __list_document_files(
            self,
            **kwargs
        ):
            """List DocumentFile records  # noqa: E501

            List files submitted to Fincura  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.list_document_files(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                limit (int): Number of results to return per page.. [optional]
                offset (int): The initial index from which to return the results.. [optional]
                borrower_uuid (str): Borrower to filter results for. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                InlineResponse200
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        self.list_document_files = Endpoint(
            settings={
                'response_type': (InlineResponse200,),
                'auth': [
                    'API_Key'
                ],
                'endpoint_path': '/v1/document-file',
                'operation_id': 'list_document_files',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'limit',
                    'offset',
                    'borrower_uuid',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'limit':
                        (int,),
                    'offset':
                        (int,),
                    'borrower_uuid':
                        (str,),
                },
                'attribute_map': {
                    'limit': 'limit',
                    'offset': 'offset',
                    'borrower_uuid': 'borrower_uuid',
                },
                'location_map': {
                    'limit': 'query',
                    'offset': 'query',
                    'borrower_uuid': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__list_document_files
        )

        def __retrieve_bulk_file(
            self,
            uuid,
            **kwargs
        ):
            """Retrieve a BulkFile  # noqa: E501

            Retrieve a bulk file submitted to Fincura  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.retrieve_bulk_file(uuid, async_req=True)
            >>> result = thread.get()

            Args:
                uuid (str):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                BulkFileRead
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['uuid'] = \
                uuid
            return self.call_with_http_info(**kwargs)

        self.retrieve_bulk_file = Endpoint(
            settings={
                'response_type': (BulkFileRead,),
                'auth': [
                    'API_Key'
                ],
                'endpoint_path': '/v1/bulk-file/{uuid}',
                'operation_id': 'retrieve_bulk_file',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'uuid',
                ],
                'required': [
                    'uuid',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'uuid':
                        (str,),
                },
                'attribute_map': {
                    'uuid': 'uuid',
                },
                'location_map': {
                    'uuid': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__retrieve_bulk_file
        )

        def __retrieve_document_file(
            self,
            uuid,
            **kwargs
        ):
            """Get a DocumentFile  # noqa: E501

            Retrieve a file submitted to Fincura  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.retrieve_document_file(uuid, async_req=True)
            >>> result = thread.get()

            Args:
                uuid (str):

            Keyword Args:
                borrower_uuid (str): Borrower to filter results for. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                DocumentFileRead
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['uuid'] = \
                uuid
            return self.call_with_http_info(**kwargs)

        self.retrieve_document_file = Endpoint(
            settings={
                'response_type': (DocumentFileRead,),
                'auth': [
                    'API_Key'
                ],
                'endpoint_path': '/v1/document-file/{uuid}',
                'operation_id': 'retrieve_document_file',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'uuid',
                    'borrower_uuid',
                ],
                'required': [
                    'uuid',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'uuid':
                        (str,),
                    'borrower_uuid':
                        (str,),
                },
                'attribute_map': {
                    'uuid': 'uuid',
                    'borrower_uuid': 'borrower_uuid',
                },
                'location_map': {
                    'uuid': 'path',
                    'borrower_uuid': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__retrieve_document_file
        )
