# coding: utf-8

"""
    Fincura API

    This [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer) allows you to interact with the Fincura processing and insights engine.   # Authentication  This API uses API keys generated from a Fincura User account. To get access to your User account, speak with you Fincura account manager.  # Accepted Media Types  | File&nbsp;Type&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | Extension(s)     | Content-Type(s) | | -------------------------------- |-------------- | ------------ | | PDF File | .pdf | `application/pdf` , `application/x-pdf` | | Excel File | .xls | `application/vnd.ms-excel`  | | Excel File | .xlsx | `application/vnd.openxmlformats-officedocument.spreadsheetml.sheet`  | | Excel File | .xlsm | `application/vnd.ms-excel.sheet.macroEnabled.12`  | | PNG Image | .png | `image/png`  | | GIF Image | .gif | `image/gif`  | | JPG Image | .jpg, .jpeg | `image/jpeg`  | | GIF Image | .gif | `image/gif`  |   # Getting Started  1. [Create a Borrower](#operation/createBorrower)  2. [Add a file](#operation/createDocumentFile) for that Borrower. 3. Analyze in the Fincura App  ****  # noqa: E501

    The version of the OpenAPI document: 1.2.6
    Contact: support@fincura.com
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from fincura.api_client import ApiClient, Endpoint
from fincura.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from fincura.model.data_view import DataView


class DataViewsApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

        def __retrieve_data_view_from_document_file(
            self,
            document_file_uuid,
            **kwargs
        ):
            """Get DataView from a DocumentFile  # noqa: E501

            Retrieve a DataView from the standardized output of a DocumentFile submitted to Fincura  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.retrieve_data_view_from_document_file(document_file_uuid, async_req=True)
            >>> result = thread.get()

            Args:
                document_file_uuid (str):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                DataView
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['document_file_uuid'] = \
                document_file_uuid
            return self.call_with_http_info(**kwargs)

        self.retrieve_data_view_from_document_file = Endpoint(
            settings={
                'response_type': (DataView,),
                'auth': [
                    'API_Key'
                ],
                'endpoint_path': '/v1/data-view/from_document_file/{document_file_uuid}',
                'operation_id': 'retrieve_data_view_from_document_file',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'document_file_uuid',
                ],
                'required': [
                    'document_file_uuid',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'document_file_uuid':
                        (str,),
                },
                'attribute_map': {
                    'document_file_uuid': 'document_file_uuid',
                },
                'location_map': {
                    'document_file_uuid': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__retrieve_data_view_from_document_file
        )

        def __retrieve_most_recent_data_view(
            self,
            borrower_uuid,
            **kwargs
        ):
            """Get the most recent period of data for a Borrower  # noqa: E501

            Retrieve a DataView from the most recent standardized data for a borrower  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.retrieve_most_recent_data_view(borrower_uuid, async_req=True)
            >>> result = thread.get()

            Args:
                borrower_uuid (str):

            Keyword Args:
                reporting_interval (str): Reporting Interval of the financial data. [optional]
                preparation_type (str): Preparation Type of the finanical data. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                DataView
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['borrower_uuid'] = \
                borrower_uuid
            return self.call_with_http_info(**kwargs)

        self.retrieve_most_recent_data_view = Endpoint(
            settings={
                'response_type': (DataView,),
                'auth': [
                    'API_Key'
                ],
                'endpoint_path': '/v1/data-view/most_recent/{borrower_uuid}',
                'operation_id': 'retrieve_most_recent_data_view',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'borrower_uuid',
                    'reporting_interval',
                    'preparation_type',
                ],
                'required': [
                    'borrower_uuid',
                ],
                'nullable': [
                ],
                'enum': [
                    'reporting_interval',
                    'preparation_type',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('reporting_interval',): {

                        "MONTHLY": "MONTHLY",
                        "QUARTERLY": "QUARTERLY",
                        "SEMI_ANNUALLY": "SEMI_ANNUALLY",
                        "ANNUALLY": "ANNUALLY",
                        "FISCAL_YTD": "FISCAL_YTD"
                    },
                    ('preparation_type',): {

                        "UNQUALIFIED": "UNQUALIFIED",
                        "QUALIFIED": "QUALIFIED",
                        "TAX_RETURN": "TAX_RETURN",
                        "REVIEWED": "REVIEWED",
                        "CPA_PREP": "CPA_PREP",
                        "NTR": "NTR",
                        "MANAGEMENT": "MANAGEMENT",
                        "UNKNOWN": "UNKNOWN",
                        "CALCULATED": "CALCULATED"
                    },
                },
                'openapi_types': {
                    'borrower_uuid':
                        (str,),
                    'reporting_interval':
                        (str,),
                    'preparation_type':
                        (str,),
                },
                'attribute_map': {
                    'borrower_uuid': 'borrower_uuid',
                    'reporting_interval': 'reporting_interval',
                    'preparation_type': 'preparation_type',
                },
                'location_map': {
                    'borrower_uuid': 'path',
                    'reporting_interval': 'query',
                    'preparation_type': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__retrieve_most_recent_data_view
        )
