# fincura-api-client
This [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer) allows you to interact with the Fincura processing and insights engine. 

# Authentication

This API uses API keys generated from a Fincura User account. To get access to your User account, speak with you Fincura account manager.

# Accepted Media Types

| File&nbsp;Type&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | Extension(s)     | Content-Type(s) |
| -------------------------------- |-------------- | ------------ |
| PDF File | .pdf | `application/pdf` , `application/x-pdf` |
| Excel File | .xls | `application/vnd.ms-excel`  |
| Excel File | .xlsx | `application/vnd.openxmlformats-officedocument.spreadsheetml.sheet`  |
| Excel File | .xlsm | `application/vnd.ms-excel.sheet.macroEnabled.12`  |
| PNG Image | .png | `image/png`  |
| GIF Image | .gif | `image/gif`  |
| JPG Image | .jpg, .jpeg | `image/jpeg`  |
| GIF Image | .gif | `image/gif`  |


# Getting Started

1. [Create a Borrower](#operation/createBorrower) 
2. [Add a file](#operation/createDocumentFile) for that Borrower.
3. Analyze in the Fincura App

****

This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: 1.2.6
- Package version: 1.0.1
- Build package: org.openapitools.codegen.languages.PythonClientCodegen

## Requirements.

Python >= 3.5

## Installation & Usage
### pip install

If the python package is hosted on a repository, you can install directly using:

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import fincura
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import fincura
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python

import time
import fincura
from pprint import pprint
from fincura.api import api_key_api
from fincura.model.api_key import ApiKey
# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = fincura.Configuration(
    host = "http://localhost"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure Bearer authorization (JWT): API_Key
configuration = fincura.Configuration(
    access_token = 'YOUR_BEARER_TOKEN'
)


# Enter a context with an instance of the API client
with fincura.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = api_key_api.ApiKeyApi(api_client)
    api_key = ApiKey(
        refresh_token="refresh_token_example",
        tenant_id="tenant_id_example",
        access_token="access_token_example",
        expiration_date=dateutil_parser('1970-01-01T00:00:00.00Z'),
    ) # ApiKey |  (optional)

    try:
        # Refresh Api Key
        api_response = api_instance.refresh_api_key(api_key=api_key)
        pprint(api_response)
    except fincura.ApiException as e:
        print("Exception when calling ApiKeyApi->refresh_api_key: %s\n" % e)
```

## Documentation for API Endpoints

All URIs are relative to *http://localhost*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*ApiKeyApi* | [**refresh_api_key**](docs/ApiKeyApi.md#refresh_api_key) | **POST** /v1/api-key/refresh | Refresh Api Key
*BorrowersApi* | [**create_borrower**](docs/BorrowersApi.md#create_borrower) | **POST** /v1/borrower | Create a new Borrower
*BorrowersApi* | [**list_borrowers**](docs/BorrowersApi.md#list_borrowers) | **GET** /v1/borrower | List Borrowers
*BorrowersApi* | [**partial_update_borrower**](docs/BorrowersApi.md#partial_update_borrower) | **PATCH** /v1/borrower/{uuid} | Update a Borrower
*BorrowersApi* | [**retrieve_borrower**](docs/BorrowersApi.md#retrieve_borrower) | **GET** /v1/borrower/{uuid} | Retrieve a Borrower
*CustomAttributesApi* | [**create_custom_attribute_definition**](docs/CustomAttributesApi.md#create_custom_attribute_definition) | **POST** /v1/custom-attribute-definition | Create a CustomAttributeDefinition
*CustomAttributesApi* | [**destroy_custom_attribute_definition**](docs/CustomAttributesApi.md#destroy_custom_attribute_definition) | **DELETE** /v1/custom-attribute-definition/{uuid} | Delete a CustomAttributeDefinition
*CustomAttributesApi* | [**list_custom_attribute_definitions**](docs/CustomAttributesApi.md#list_custom_attribute_definitions) | **GET** /v1/custom-attribute-definition | List CustomAttributeDefinitions
*CustomAttributesApi* | [**retrieve_custom_attribute_definition**](docs/CustomAttributesApi.md#retrieve_custom_attribute_definition) | **GET** /v1/custom-attribute-definition/{uuid} | Get CustomAttributeDefinition info
*DataViewsApi* | [**retrieve_data_view_from_document_file**](docs/DataViewsApi.md#retrieve_data_view_from_document_file) | **GET** /v1/data-view/from_document_file/{document_file_uuid} | Get DataView from a DocumentFile
*DataViewsApi* | [**retrieve_most_recent_data_view**](docs/DataViewsApi.md#retrieve_most_recent_data_view) | **GET** /v1/data-view/most_recent/{borrower_uuid} | Get the most recent period of data for a Borrower
*EmbeddedWorkflowsApi* | [**create_embedded_workflow**](docs/EmbeddedWorkflowsApi.md#create_embedded_workflow) | **POST** /v1/embedded-workflow | 
*EmbeddedWorkflowsApi* | [**retrieve_embedded_workflow**](docs/EmbeddedWorkflowsApi.md#retrieve_embedded_workflow) | **GET** /v1/embedded-workflow/{uuid} | 
*FilesApi* | [**create_bulk_file**](docs/FilesApi.md#create_bulk_file) | **POST** /v1/bulk-file | Submit a new BulkFile
*FilesApi* | [**create_document_file**](docs/FilesApi.md#create_document_file) | **POST** /v1/document-file | Submit a new DocumentFile
*FilesApi* | [**destroy_document_file**](docs/FilesApi.md#destroy_document_file) | **DELETE** /v1/document-file/{uuid} | Delete a DocumentFile
*FilesApi* | [**list_document_files**](docs/FilesApi.md#list_document_files) | **GET** /v1/document-file | List DocumentFile records
*FilesApi* | [**retrieve_bulk_file**](docs/FilesApi.md#retrieve_bulk_file) | **GET** /v1/bulk-file/{uuid} | Retrieve a BulkFile
*FilesApi* | [**retrieve_document_file**](docs/FilesApi.md#retrieve_document_file) | **GET** /v1/document-file/{uuid} | Get a DocumentFile
*LoansApi* | [**create_loan**](docs/LoansApi.md#create_loan) | **POST** /v1/loan | Create a new Loan
*LoansApi* | [**destroy_loan**](docs/LoansApi.md#destroy_loan) | **DELETE** /v1/loan/{uuid} | Delete a Loan
*LoansApi* | [**list_loans**](docs/LoansApi.md#list_loans) | **GET** /v1/loan | List Loans
*LoansApi* | [**partial_update_loan**](docs/LoansApi.md#partial_update_loan) | **PATCH** /v1/loan/{uuid} | Update a Loan
*LoansApi* | [**retrieve_loan**](docs/LoansApi.md#retrieve_loan) | **GET** /v1/loan/{uuid} | Retrieve a Loan
*PortfoliosApi* | [**create_portfolio**](docs/PortfoliosApi.md#create_portfolio) | **POST** /v1/portfolio | Create a new Portfolio
*PortfoliosApi* | [**list_portfolios**](docs/PortfoliosApi.md#list_portfolios) | **GET** /v1/portfolio | List Portfolios
*PortfoliosApi* | [**partial_update_portfolio**](docs/PortfoliosApi.md#partial_update_portfolio) | **PATCH** /v1/portfolio/{uuid} | Update a Portfolio
*RequirementsApi* | [**create_financial_requirement**](docs/RequirementsApi.md#create_financial_requirement) | **POST** /v1/financial-requirement | Create a new FinancialRequirement
*RequirementsApi* | [**list_financial_requirements**](docs/RequirementsApi.md#list_financial_requirements) | **GET** /v1/financial-requirement | List FinancialRequirements
*RequirementsApi* | [**partial_update_financial_requirement**](docs/RequirementsApi.md#partial_update_financial_requirement) | **PATCH** /v1/financial-requirement/{uuid} | Update a FinancialRequirement
*RequirementsApi* | [**retrieve_financial_requirement**](docs/RequirementsApi.md#retrieve_financial_requirement) | **GET** /v1/financial-requirement/{uuid} | Retrieve a FinancialRequirement
*TenantSettingsApi* | [**read_tenant_settings**](docs/TenantSettingsApi.md#read_tenant_settings) | **GET** /v1/tenant-settings/read | Get Tenant Settings
*WebhooksApi* | [**create_webhook**](docs/WebhooksApi.md#create_webhook) | **POST** /v1/webhook | Create a webhook
*WebhooksApi* | [**destroy_webhook**](docs/WebhooksApi.md#destroy_webhook) | **DELETE** /v1/webhook/{uuid} | Delete a webhook
*WebhooksApi* | [**list_webhooks**](docs/WebhooksApi.md#list_webhooks) | **GET** /v1/webhook | List webhooks
*WebhooksApi* | [**retrieve_webhook**](docs/WebhooksApi.md#retrieve_webhook) | **GET** /v1/webhook/{uuid} | Get webhook info


## Documentation For Models

 - [ApiKey](docs/ApiKey.md)
 - [Borrower](docs/Borrower.md)
 - [BulkFileCreate](docs/BulkFileCreate.md)
 - [BulkFileRead](docs/BulkFileRead.md)
 - [CustomAttributeDefinition](docs/CustomAttributeDefinition.md)
 - [DataView](docs/DataView.md)
 - [DataViewCalculatedValue](docs/DataViewCalculatedValue.md)
 - [DataViewCalculatedValueLineItem](docs/DataViewCalculatedValueLineItem.md)
 - [DataViewCellFormat](docs/DataViewCellFormat.md)
 - [DataViewCells](docs/DataViewCells.md)
 - [DataViewColumns](docs/DataViewColumns.md)
 - [DataViewRowFormat](docs/DataViewRowFormat.md)
 - [DataViewRows](docs/DataViewRows.md)
 - [DocumentFileCreate](docs/DocumentFileCreate.md)
 - [DocumentFileCreateStatements](docs/DocumentFileCreateStatements.md)
 - [DocumentFileRead](docs/DocumentFileRead.md)
 - [EmbeddedWorkflow](docs/EmbeddedWorkflow.md)
 - [EmbeddedWorkflowUiControls](docs/EmbeddedWorkflowUiControls.md)
 - [FinancialRequirement](docs/FinancialRequirement.md)
 - [FinancialRequirementRules](docs/FinancialRequirementRules.md)
 - [InlineResponse200](docs/InlineResponse200.md)
 - [InlineResponse2001](docs/InlineResponse2001.md)
 - [InlineResponse2002](docs/InlineResponse2002.md)
 - [InlineResponse2003](docs/InlineResponse2003.md)
 - [InlineResponse2004](docs/InlineResponse2004.md)
 - [InlineResponse2005](docs/InlineResponse2005.md)
 - [InlineResponse2006](docs/InlineResponse2006.md)
 - [Loan](docs/Loan.md)
 - [LoanBorrowerInfo](docs/LoanBorrowerInfo.md)
 - [LoanComplianceInfo](docs/LoanComplianceInfo.md)
 - [LoanDocuments](docs/LoanDocuments.md)
 - [LoanFinancials](docs/LoanFinancials.md)
 - [LoanFinancialsCalculatedValue](docs/LoanFinancialsCalculatedValue.md)
 - [LoanFinancialsCells](docs/LoanFinancialsCells.md)
 - [LoanFinancialsDataColumns](docs/LoanFinancialsDataColumns.md)
 - [LoanFinancialsTemplateItems](docs/LoanFinancialsTemplateItems.md)
 - [LoanGuarantors](docs/LoanGuarantors.md)
 - [LoanPeriods](docs/LoanPeriods.md)
 - [LoanPriorYearFinancials](docs/LoanPriorYearFinancials.md)
 - [Portfolio](docs/Portfolio.md)
 - [TenantSettings](docs/TenantSettings.md)
 - [Webhook](docs/Webhook.md)


## Documentation For Authorization


## API_Key

- **Type**: Bearer authentication (JWT)


## Author

support@fincura.com


## Notes for Large OpenAPI documents
If the OpenAPI document is large, imports in fincura.apis and fincura.models may fail with a
RecursionError indicating the maximum recursion limit has been exceeded. In that case, there are a couple of solutions:

Solution 1:
Use specific imports for apis and models like:
- `from fincura.api.default_api import DefaultApi`
- `from fincura.model.pet import Pet`

Solution 1:
Before importing the package, adjust the maximum recursion limit as shown below:
```
import sys
sys.setrecursionlimit(1500)
import fincura
from fincura.apis import *
from fincura.models import *
```

