/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib2.dexbacked.instruction;

import org.jf.dexlib2.Opcode;
import org.jf.dexlib2.ReferenceType;
import org.jf.dexlib2.dexbacked.DexBackedDexFile;
import org.jf.dexlib2.dexbacked.instruction.DexBackedInstruction;
import org.jf.dexlib2.dexbacked.reference.DexBackedReference;
import org.jf.dexlib2.iface.instruction.formats.Instruction20bc;
import org.jf.dexlib2.iface.reference.Reference;

public class DexBackedInstruction20bc
extends DexBackedInstruction
implements Instruction20bc {
    public DexBackedInstruction20bc(DexBackedDexFile dexFile, Opcode opcode, int instructionStart) {
        super(dexFile, opcode, instructionStart);
    }

    @Override
    public int getVerificationError() {
        return this.dexFile.getDataBuffer().readUbyte(this.instructionStart + 1) & 0x3F;
    }

    @Override
    public Reference getReference() {
        final int referenceIndex = this.dexFile.getDataBuffer().readUshort(this.instructionStart + 2);
        try {
            int referenceType = this.getReferenceType();
            return DexBackedReference.makeReference(this.dexFile, referenceType, referenceIndex);
        }
        catch (ReferenceType.InvalidReferenceTypeException ex) {
            return new Reference(){

                @Override
                public void validateReference() throws Reference.InvalidReferenceException {
                    throw new Reference.InvalidReferenceException(String.format("%d@%d", ex.getReferenceType(), referenceIndex), ex);
                }
            };
        }
    }

    @Override
    public int getReferenceType() {
        int referenceType = (this.dexFile.getDataBuffer().readUbyte(this.instructionStart + 1) >>> 6) + 1;
        ReferenceType.validateReferenceType(referenceType);
        return referenceType;
    }
}

