# Generated by cloudcoil-model-codegen v0.5.0
# DO NOT EDIT

from __future__ import annotations

from typing import (
    Annotated,
    Callable,
    Dict,
    List,
    Literal,
    Optional,
    Type,
    overload,
)

from pydantic import Field

from cloudcoil import apimachinery
from cloudcoil.pydantic import (
    BaseModel,
    BaseModelBuilder,
    BuilderContextBase,
    GenericListBuilder,
    ListBuilderContext,
    Never,
    Self,
)
from cloudcoil.resources import Resource, ResourceList

from ..core import v1


class TokenRequest(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["TokenRequest"]:
            return TokenRequest

        def build(self) -> "TokenRequest":
            return TokenRequest(**self._attrs)

        def audience(self, value: str, /) -> Self:
            """
            audience is the intended audience of the token in "TokenRequestSpec". It will default to the audiences of kube apiserver.
            """
            return self._set("audience", value)

        def expiration_seconds(self, value: Optional[int], /) -> Self:
            """
            expirationSeconds is the duration of validity of the token in "TokenRequestSpec". It has the same default value of "ExpirationSeconds" in "TokenRequestSpec".
            """
            return self._set("expiration_seconds", value)

    class BuilderContext(BuilderContextBase["TokenRequest.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = TokenRequest.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for TokenRequest."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["TokenRequest", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use TokenRequest.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    audience: str
    """
    audience is the intended audience of the token in "TokenRequestSpec". It will default to the audiences of kube apiserver.
    """
    expiration_seconds: Annotated[Optional[int], Field(alias="expirationSeconds")] = None
    """
    expirationSeconds is the duration of validity of the token in "TokenRequestSpec". It has the same default value of "ExpirationSeconds" in "TokenRequestSpec".
    """


class VolumeNodeResources(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["VolumeNodeResources"]:
            return VolumeNodeResources

        def build(self) -> "VolumeNodeResources":
            return VolumeNodeResources(**self._attrs)

        def count(self, value: Optional[int], /) -> Self:
            """
            count indicates the maximum number of unique volumes managed by the CSI driver that can be used on a node. A volume that is both attached and mounted on a node is considered to be used once, not twice. The same rule applies for a unique volume that is shared among multiple pods on the same node. If this field is not specified, then the supported number of volumes on this node is unbounded.
            """
            return self._set("count", value)

    class BuilderContext(BuilderContextBase["VolumeNodeResources.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = VolumeNodeResources.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for VolumeNodeResources."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["VolumeNodeResources", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use VolumeNodeResources.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    count: Optional[int] = None
    """
    count indicates the maximum number of unique volumes managed by the CSI driver that can be used on a node. A volume that is both attached and mounted on a node is considered to be used once, not twice. The same rule applies for a unique volume that is shared among multiple pods on the same node. If this field is not specified, then the supported number of volumes on this node is unbounded.
    """


class CSIDriverSpec(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["CSIDriverSpec"]:
            return CSIDriverSpec

        def build(self) -> "CSIDriverSpec":
            return CSIDriverSpec(**self._attrs)

        def attach_required(self, value: Optional[bool], /) -> Self:
            """
            attachRequired indicates this CSI volume driver requires an attach operation (because it implements the CSI ControllerPublishVolume() method), and that the Kubernetes attach detach controller should call the attach volume interface which checks the volumeattachment status and waits until the volume is attached before proceeding to mounting. The CSI external-attacher coordinates with CSI volume driver and updates the volumeattachment status when the attach operation is complete. If the CSIDriverRegistry feature gate is enabled and the value is specified to false, the attach operation will be skipped. Otherwise the attach operation will be called.

            This field is immutable.
            """
            return self._set("attach_required", value)

        def fs_group_policy(self, value: Optional[str], /) -> Self:
            """
            fsGroupPolicy defines if the underlying volume supports changing ownership and permission of the volume before being mounted. Refer to the specific FSGroupPolicy values for additional details.

            This field was immutable in Kubernetes < 1.29 and now is mutable.

            Defaults to ReadWriteOnceWithFSType, which will examine each volume to determine if Kubernetes should modify ownership and permissions of the volume. With the default policy the defined fsGroup will only be applied if a fstype is defined and the volume's access mode contains ReadWriteOnce.
            """
            return self._set("fs_group_policy", value)

        def pod_info_on_mount(self, value: Optional[bool], /) -> Self:
            """
            podInfoOnMount indicates this CSI volume driver requires additional pod information (like podName, podUID, etc.) during mount operations, if set to true. If set to false, pod information will not be passed on mount. Default is false.

            The CSI driver specifies podInfoOnMount as part of driver deployment. If true, Kubelet will pass pod information as VolumeContext in the CSI NodePublishVolume() calls. The CSI driver is responsible for parsing and validating the information passed in as VolumeContext.

            The following VolumeContext will be passed if podInfoOnMount is set to true. This list might grow, but the prefix will be used. "csi.storage.k8s.io/pod.name": pod.Name "csi.storage.k8s.io/pod.namespace": pod.Namespace "csi.storage.k8s.io/pod.uid": string(pod.UID) "csi.storage.k8s.io/ephemeral": "true" if the volume is an ephemeral inline volume
                                            defined by a CSIVolumeSource, otherwise "false"

            "csi.storage.k8s.io/ephemeral" is a new feature in Kubernetes 1.16. It is only required for drivers which support both the "Persistent" and "Ephemeral" VolumeLifecycleMode. Other drivers can leave pod info disabled and/or ignore this field. As Kubernetes 1.15 doesn't support this field, drivers can only support one mode when deployed on such a cluster and the deployment determines which mode that is, for example via a command line parameter of the driver.

            This field was immutable in Kubernetes < 1.29 and now is mutable.
            """
            return self._set("pod_info_on_mount", value)

        def requires_republish(self, value: Optional[bool], /) -> Self:
            """
            requiresRepublish indicates the CSI driver wants `NodePublishVolume` being periodically called to reflect any possible change in the mounted volume. This field defaults to false.

            Note: After a successful initial NodePublishVolume call, subsequent calls to NodePublishVolume should only update the contents of the volume. New mount points will not be seen by a running container.
            """
            return self._set("requires_republish", value)

        def se_linux_mount(self, value: Optional[bool], /) -> Self:
            """
            seLinuxMount specifies if the CSI driver supports "-o context" mount option.

            When "true", the CSI driver must ensure that all volumes provided by this CSI driver can be mounted separately with different `-o context` options. This is typical for storage backends that provide volumes as filesystems on block devices or as independent shared volumes. Kubernetes will call NodeStage / NodePublish with "-o context=xyz" mount option when mounting a ReadWriteOncePod volume used in Pod that has explicitly set SELinux context. In the future, it may be expanded to other volume AccessModes. In any case, Kubernetes will ensure that the volume is mounted only with a single SELinux context.

            When "false", Kubernetes won't pass any special SELinux mount options to the driver. This is typical for volumes that represent subdirectories of a bigger shared filesystem.

            Default is "false".
            """
            return self._set("se_linux_mount", value)

        def storage_capacity(self, value: Optional[bool], /) -> Self:
            """
            storageCapacity indicates that the CSI volume driver wants pod scheduling to consider the storage capacity that the driver deployment will report by creating CSIStorageCapacity objects with capacity information, if set to true.

            The check can be enabled immediately when deploying a driver. In that case, provisioning new volumes with late binding will pause until the driver deployment has published some suitable CSIStorageCapacity object.

            Alternatively, the driver can be deployed with the field unset or false and it can be flipped later when storage capacity information has been published.

            This field was immutable in Kubernetes <= 1.22 and now is mutable.
            """
            return self._set("storage_capacity", value)

        @overload
        def token_requests(
            self, value_or_callback: List[TokenRequest], /
        ) -> "CSIDriverSpec.Builder": ...

        @overload
        def token_requests(
            self,
            value_or_callback: Callable[
                [GenericListBuilder[TokenRequest, TokenRequest.Builder]],
                GenericListBuilder[TokenRequest, TokenRequest.Builder] | List[TokenRequest],
            ],
            /,
        ) -> "CSIDriverSpec.Builder": ...

        @overload
        def token_requests(
            self, value_or_callback: Never = ...
        ) -> ListBuilderContext[TokenRequest.Builder]: ...

        def token_requests(self, value_or_callback=None, /):
            """
            tokenRequests indicates the CSI driver needs pods' service account tokens it is mounting volume for to do necessary authentication. Kubelet will pass the tokens in VolumeContext in the CSI NodePublishVolume calls. The CSI driver should parse and validate the following VolumeContext: "csi.storage.k8s.io/serviceAccount.tokens": {
              "<audience>": {
                "token": <token>,
                "expirationTimestamp": <expiration timestamp in RFC3339>,
              },
              ...
            }

            Note: Audience in each TokenRequest should be different and at most one token is empty string. To receive a new token after expiry, RequiresRepublish can be used to trigger NodePublishVolume periodically.
            """
            if self._in_context and value_or_callback is None:
                context = ListBuilderContext[TokenRequest.Builder]()
                context._parent_builder = self
                context._field_name = "token_requests"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(TokenRequest.list_builder())
                if isinstance(output, GenericListBuilder):
                    value = output.build()
                else:
                    value = output
            return self._set("token_requests", value)

        def volume_lifecycle_modes(self, value: Optional[List[str]], /) -> Self:
            """
            volumeLifecycleModes defines what kind of volumes this CSI volume driver supports. The default if the list is empty is "Persistent", which is the usage defined by the CSI specification and implemented in Kubernetes via the usual PV/PVC mechanism.

            The other mode is "Ephemeral". In this mode, volumes are defined inline inside the pod spec with CSIVolumeSource and their lifecycle is tied to the lifecycle of that pod. A driver has to be aware of this because it is only going to get a NodePublishVolume call for such a volume.

            For more information about implementing this mode, see https://kubernetes-csi.github.io/docs/ephemeral-local-volumes.html A driver can support one or more of these modes and more modes may be added in the future.

            This field is beta. This field is immutable.
            """
            return self._set("volume_lifecycle_modes", value)

    class BuilderContext(BuilderContextBase["CSIDriverSpec.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = CSIDriverSpec.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for CSIDriverSpec."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["CSIDriverSpec", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use CSIDriverSpec.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    attach_required: Annotated[Optional[bool], Field(alias="attachRequired")] = None
    """
    attachRequired indicates this CSI volume driver requires an attach operation (because it implements the CSI ControllerPublishVolume() method), and that the Kubernetes attach detach controller should call the attach volume interface which checks the volumeattachment status and waits until the volume is attached before proceeding to mounting. The CSI external-attacher coordinates with CSI volume driver and updates the volumeattachment status when the attach operation is complete. If the CSIDriverRegistry feature gate is enabled and the value is specified to false, the attach operation will be skipped. Otherwise the attach operation will be called.

    This field is immutable.
    """
    fs_group_policy: Annotated[Optional[str], Field(alias="fsGroupPolicy")] = None
    """
    fsGroupPolicy defines if the underlying volume supports changing ownership and permission of the volume before being mounted. Refer to the specific FSGroupPolicy values for additional details.

    This field was immutable in Kubernetes < 1.29 and now is mutable.

    Defaults to ReadWriteOnceWithFSType, which will examine each volume to determine if Kubernetes should modify ownership and permissions of the volume. With the default policy the defined fsGroup will only be applied if a fstype is defined and the volume's access mode contains ReadWriteOnce.
    """
    pod_info_on_mount: Annotated[Optional[bool], Field(alias="podInfoOnMount")] = None
    """
    podInfoOnMount indicates this CSI volume driver requires additional pod information (like podName, podUID, etc.) during mount operations, if set to true. If set to false, pod information will not be passed on mount. Default is false.

    The CSI driver specifies podInfoOnMount as part of driver deployment. If true, Kubelet will pass pod information as VolumeContext in the CSI NodePublishVolume() calls. The CSI driver is responsible for parsing and validating the information passed in as VolumeContext.

    The following VolumeContext will be passed if podInfoOnMount is set to true. This list might grow, but the prefix will be used. "csi.storage.k8s.io/pod.name": pod.Name "csi.storage.k8s.io/pod.namespace": pod.Namespace "csi.storage.k8s.io/pod.uid": string(pod.UID) "csi.storage.k8s.io/ephemeral": "true" if the volume is an ephemeral inline volume
                                    defined by a CSIVolumeSource, otherwise "false"

    "csi.storage.k8s.io/ephemeral" is a new feature in Kubernetes 1.16. It is only required for drivers which support both the "Persistent" and "Ephemeral" VolumeLifecycleMode. Other drivers can leave pod info disabled and/or ignore this field. As Kubernetes 1.15 doesn't support this field, drivers can only support one mode when deployed on such a cluster and the deployment determines which mode that is, for example via a command line parameter of the driver.

    This field was immutable in Kubernetes < 1.29 and now is mutable.
    """
    requires_republish: Annotated[Optional[bool], Field(alias="requiresRepublish")] = None
    """
    requiresRepublish indicates the CSI driver wants `NodePublishVolume` being periodically called to reflect any possible change in the mounted volume. This field defaults to false.

    Note: After a successful initial NodePublishVolume call, subsequent calls to NodePublishVolume should only update the contents of the volume. New mount points will not be seen by a running container.
    """
    se_linux_mount: Annotated[Optional[bool], Field(alias="seLinuxMount")] = None
    """
    seLinuxMount specifies if the CSI driver supports "-o context" mount option.

    When "true", the CSI driver must ensure that all volumes provided by this CSI driver can be mounted separately with different `-o context` options. This is typical for storage backends that provide volumes as filesystems on block devices or as independent shared volumes. Kubernetes will call NodeStage / NodePublish with "-o context=xyz" mount option when mounting a ReadWriteOncePod volume used in Pod that has explicitly set SELinux context. In the future, it may be expanded to other volume AccessModes. In any case, Kubernetes will ensure that the volume is mounted only with a single SELinux context.

    When "false", Kubernetes won't pass any special SELinux mount options to the driver. This is typical for volumes that represent subdirectories of a bigger shared filesystem.

    Default is "false".
    """
    storage_capacity: Annotated[Optional[bool], Field(alias="storageCapacity")] = None
    """
    storageCapacity indicates that the CSI volume driver wants pod scheduling to consider the storage capacity that the driver deployment will report by creating CSIStorageCapacity objects with capacity information, if set to true.

    The check can be enabled immediately when deploying a driver. In that case, provisioning new volumes with late binding will pause until the driver deployment has published some suitable CSIStorageCapacity object.

    Alternatively, the driver can be deployed with the field unset or false and it can be flipped later when storage capacity information has been published.

    This field was immutable in Kubernetes <= 1.22 and now is mutable.
    """
    token_requests: Annotated[Optional[List[TokenRequest]], Field(alias="tokenRequests")] = None
    """
    tokenRequests indicates the CSI driver needs pods' service account tokens it is mounting volume for to do necessary authentication. Kubelet will pass the tokens in VolumeContext in the CSI NodePublishVolume calls. The CSI driver should parse and validate the following VolumeContext: "csi.storage.k8s.io/serviceAccount.tokens": {
      "<audience>": {
        "token": <token>,
        "expirationTimestamp": <expiration timestamp in RFC3339>,
      },
      ...
    }

    Note: Audience in each TokenRequest should be different and at most one token is empty string. To receive a new token after expiry, RequiresRepublish can be used to trigger NodePublishVolume periodically.
    """
    volume_lifecycle_modes: Annotated[Optional[List[str]], Field(alias="volumeLifecycleModes")] = (
        None
    )
    """
    volumeLifecycleModes defines what kind of volumes this CSI volume driver supports. The default if the list is empty is "Persistent", which is the usage defined by the CSI specification and implemented in Kubernetes via the usual PV/PVC mechanism.

    The other mode is "Ephemeral". In this mode, volumes are defined inline inside the pod spec with CSIVolumeSource and their lifecycle is tied to the lifecycle of that pod. A driver has to be aware of this because it is only going to get a NodePublishVolume call for such a volume.

    For more information about implementing this mode, see https://kubernetes-csi.github.io/docs/ephemeral-local-volumes.html A driver can support one or more of these modes and more modes may be added in the future.

    This field is beta. This field is immutable.
    """


class CSINodeDriver(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["CSINodeDriver"]:
            return CSINodeDriver

        def build(self) -> "CSINodeDriver":
            return CSINodeDriver(**self._attrs)

        @overload
        def allocatable(
            self, value_or_callback: Optional[VolumeNodeResources], /
        ) -> "CSINodeDriver.Builder": ...

        @overload
        def allocatable(
            self,
            value_or_callback: Callable[
                [VolumeNodeResources.Builder],
                VolumeNodeResources.Builder | VolumeNodeResources,
            ],
            /,
        ) -> "CSINodeDriver.Builder": ...

        @overload
        def allocatable(
            self, value_or_callback: Never = ...
        ) -> "VolumeNodeResources.BuilderContext": ...

        def allocatable(self, value_or_callback=None, /):
            """
            allocatable represents the volume resources of a node that are available for scheduling. This field is beta.
            """
            if self._in_context and value_or_callback is None:
                context = VolumeNodeResources.BuilderContext()
                context._parent_builder = self
                context._field_name = "allocatable"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(VolumeNodeResources.builder())
                if isinstance(output, VolumeNodeResources.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("allocatable", value)

        def name(self, value: str, /) -> Self:
            """
            name represents the name of the CSI driver that this object refers to. This MUST be the same name returned by the CSI GetPluginName() call for that driver.
            """
            return self._set("name", value)

        def node_id(self, value: str, /) -> Self:
            """
            nodeID of the node from the driver point of view. This field enables Kubernetes to communicate with storage systems that do not share the same nomenclature for nodes. For example, Kubernetes may refer to a given node as "node1", but the storage system may refer to the same node as "nodeA". When Kubernetes issues a command to the storage system to attach a volume to a specific node, it can use this field to refer to the node name using the ID that the storage system will understand, e.g. "nodeA" instead of "node1". This field is required.
            """
            return self._set("node_id", value)

        def topology_keys(self, value: Optional[List[str]], /) -> Self:
            """
            topologyKeys is the list of keys supported by the driver. When a driver is initialized on a cluster, it provides a set of topology keys that it understands (e.g. "company.com/zone", "company.com/region"). When a driver is initialized on a node, it provides the same topology keys along with values. Kubelet will expose these topology keys as labels on its own node object. When Kubernetes does topology aware provisioning, it can use this list to determine which labels it should retrieve from the node object and pass back to the driver. It is possible for different nodes to use different topology keys. This can be empty if driver does not support topology.
            """
            return self._set("topology_keys", value)

    class BuilderContext(BuilderContextBase["CSINodeDriver.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = CSINodeDriver.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for CSINodeDriver."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["CSINodeDriver", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use CSINodeDriver.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    allocatable: Optional[VolumeNodeResources] = None
    """
    allocatable represents the volume resources of a node that are available for scheduling. This field is beta.
    """
    name: str
    """
    name represents the name of the CSI driver that this object refers to. This MUST be the same name returned by the CSI GetPluginName() call for that driver.
    """
    node_id: Annotated[str, Field(alias="nodeID")]
    """
    nodeID of the node from the driver point of view. This field enables Kubernetes to communicate with storage systems that do not share the same nomenclature for nodes. For example, Kubernetes may refer to a given node as "node1", but the storage system may refer to the same node as "nodeA". When Kubernetes issues a command to the storage system to attach a volume to a specific node, it can use this field to refer to the node name using the ID that the storage system will understand, e.g. "nodeA" instead of "node1". This field is required.
    """
    topology_keys: Annotated[Optional[List[str]], Field(alias="topologyKeys")] = None
    """
    topologyKeys is the list of keys supported by the driver. When a driver is initialized on a cluster, it provides a set of topology keys that it understands (e.g. "company.com/zone", "company.com/region"). When a driver is initialized on a node, it provides the same topology keys along with values. Kubelet will expose these topology keys as labels on its own node object. When Kubernetes does topology aware provisioning, it can use this list to determine which labels it should retrieve from the node object and pass back to the driver. It is possible for different nodes to use different topology keys. This can be empty if driver does not support topology.
    """


class CSINodeSpec(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["CSINodeSpec"]:
            return CSINodeSpec

        def build(self) -> "CSINodeSpec":
            return CSINodeSpec(**self._attrs)

        @overload
        def drivers(self, value_or_callback: List[CSINodeDriver], /) -> "CSINodeSpec.Builder": ...

        @overload
        def drivers(
            self,
            value_or_callback: Callable[
                [GenericListBuilder[CSINodeDriver, CSINodeDriver.Builder]],
                GenericListBuilder[CSINodeDriver, CSINodeDriver.Builder] | List[CSINodeDriver],
            ],
            /,
        ) -> "CSINodeSpec.Builder": ...

        @overload
        def drivers(
            self, value_or_callback: Never = ...
        ) -> ListBuilderContext[CSINodeDriver.Builder]: ...

        def drivers(self, value_or_callback=None, /):
            """
            drivers is a list of information of all CSI Drivers existing on a node. If all drivers in the list are uninstalled, this can become empty.
            """
            if self._in_context and value_or_callback is None:
                context = ListBuilderContext[CSINodeDriver.Builder]()
                context._parent_builder = self
                context._field_name = "drivers"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(CSINodeDriver.list_builder())
                if isinstance(output, GenericListBuilder):
                    value = output.build()
                else:
                    value = output
            return self._set("drivers", value)

    class BuilderContext(BuilderContextBase["CSINodeSpec.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = CSINodeSpec.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for CSINodeSpec."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["CSINodeSpec", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use CSINodeSpec.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    drivers: List[CSINodeDriver]
    """
    drivers is a list of information of all CSI Drivers existing on a node. If all drivers in the list are uninstalled, this can become empty.
    """


class VolumeError(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["VolumeError"]:
            return VolumeError

        def build(self) -> "VolumeError":
            return VolumeError(**self._attrs)

        def message(self, value: Optional[str], /) -> Self:
            """
            message represents the error encountered during Attach or Detach operation. This string may be logged, so it should not contain sensitive information.
            """
            return self._set("message", value)

        @overload
        def time(
            self, value_or_callback: Optional[apimachinery.Time], /
        ) -> "VolumeError.Builder": ...

        @overload
        def time(
            self,
            value_or_callback: Callable[
                [apimachinery.Time.Builder],
                apimachinery.Time.Builder | apimachinery.Time,
            ],
            /,
        ) -> "VolumeError.Builder": ...

        @overload
        def time(self, value_or_callback: Never = ...) -> "apimachinery.Time.BuilderContext": ...

        def time(self, value_or_callback=None, /):
            """
            time represents the time the error was encountered.
            """
            if self._in_context and value_or_callback is None:
                context = apimachinery.Time.BuilderContext()
                context._parent_builder = self
                context._field_name = "time"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(apimachinery.Time.builder())
                if isinstance(output, apimachinery.Time.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("time", value)

    class BuilderContext(BuilderContextBase["VolumeError.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = VolumeError.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for VolumeError."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["VolumeError", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use VolumeError.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    message: Optional[str] = None
    """
    message represents the error encountered during Attach or Detach operation. This string may be logged, so it should not contain sensitive information.
    """
    time: Optional[apimachinery.Time] = None
    """
    time represents the time the error was encountered.
    """


class CSIDriver(Resource):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["CSIDriver"]:
            return CSIDriver

        def build(self) -> "CSIDriver":
            return CSIDriver(**self._attrs)

        def api_version(self, value: Optional[Literal["storage.k8s.io/v1"]], /) -> Self:
            """
            APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
            """
            return self._set("api_version", value)

        def kind(self, value: Optional[Literal["CSIDriver"]], /) -> Self:
            """
            Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
            """
            return self._set("kind", value)

        @overload
        def metadata(
            self, value_or_callback: Optional[apimachinery.ObjectMeta], /
        ) -> "CSIDriver.Builder": ...

        @overload
        def metadata(
            self,
            value_or_callback: Callable[
                [apimachinery.ObjectMeta.Builder],
                apimachinery.ObjectMeta.Builder | apimachinery.ObjectMeta,
            ],
            /,
        ) -> "CSIDriver.Builder": ...

        @overload
        def metadata(
            self, value_or_callback: Never = ...
        ) -> "apimachinery.ObjectMeta.BuilderContext": ...

        def metadata(self, value_or_callback=None, /):
            """
            Standard object metadata. metadata.Name indicates the name of the CSI driver that this object refers to; it MUST be the same name returned by the CSI GetPluginName() call for that driver. The driver name must be 63 characters or less, beginning and ending with an alphanumeric character ([a-z0-9A-Z]) with dashes (-), dots (.), and alphanumerics between. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
            """
            if self._in_context and value_or_callback is None:
                context = apimachinery.ObjectMeta.BuilderContext()
                context._parent_builder = self
                context._field_name = "metadata"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(apimachinery.ObjectMeta.builder())
                if isinstance(output, apimachinery.ObjectMeta.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("metadata", value)

        @overload
        def spec(self, value_or_callback: CSIDriverSpec, /) -> "CSIDriver.Builder": ...

        @overload
        def spec(
            self,
            value_or_callback: Callable[
                [CSIDriverSpec.Builder], CSIDriverSpec.Builder | CSIDriverSpec
            ],
            /,
        ) -> "CSIDriver.Builder": ...

        @overload
        def spec(self, value_or_callback: Never = ...) -> "CSIDriverSpec.BuilderContext": ...

        def spec(self, value_or_callback=None, /):
            """
            spec represents the specification of the CSI Driver.
            """
            if self._in_context and value_or_callback is None:
                context = CSIDriverSpec.BuilderContext()
                context._parent_builder = self
                context._field_name = "spec"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(CSIDriverSpec.builder())
                if isinstance(output, CSIDriverSpec.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("spec", value)

    class BuilderContext(BuilderContextBase["CSIDriver.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = CSIDriver.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for CSIDriver."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["CSIDriver", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use CSIDriver.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    api_version: Annotated[Optional[Literal["storage.k8s.io/v1"]], Field(alias="apiVersion")] = (
        "storage.k8s.io/v1"
    )
    """
    APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
    """
    kind: Optional[Literal["CSIDriver"]] = "CSIDriver"
    """
    Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
    """
    metadata: Optional[apimachinery.ObjectMeta] = None
    """
    Standard object metadata. metadata.Name indicates the name of the CSI driver that this object refers to; it MUST be the same name returned by the CSI GetPluginName() call for that driver. The driver name must be 63 characters or less, beginning and ending with an alphanumeric character ([a-z0-9A-Z]) with dashes (-), dots (.), and alphanumerics between. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
    """
    spec: CSIDriverSpec
    """
    spec represents the specification of the CSI Driver.
    """


CSIDriverList = ResourceList["CSIDriver"]


class CSINode(Resource):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["CSINode"]:
            return CSINode

        def build(self) -> "CSINode":
            return CSINode(**self._attrs)

        def api_version(self, value: Optional[Literal["storage.k8s.io/v1"]], /) -> Self:
            """
            APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
            """
            return self._set("api_version", value)

        def kind(self, value: Optional[Literal["CSINode"]], /) -> Self:
            """
            Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
            """
            return self._set("kind", value)

        @overload
        def metadata(
            self, value_or_callback: Optional[apimachinery.ObjectMeta], /
        ) -> "CSINode.Builder": ...

        @overload
        def metadata(
            self,
            value_or_callback: Callable[
                [apimachinery.ObjectMeta.Builder],
                apimachinery.ObjectMeta.Builder | apimachinery.ObjectMeta,
            ],
            /,
        ) -> "CSINode.Builder": ...

        @overload
        def metadata(
            self, value_or_callback: Never = ...
        ) -> "apimachinery.ObjectMeta.BuilderContext": ...

        def metadata(self, value_or_callback=None, /):
            """
            Standard object's metadata. metadata.name must be the Kubernetes node name.
            """
            if self._in_context and value_or_callback is None:
                context = apimachinery.ObjectMeta.BuilderContext()
                context._parent_builder = self
                context._field_name = "metadata"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(apimachinery.ObjectMeta.builder())
                if isinstance(output, apimachinery.ObjectMeta.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("metadata", value)

        @overload
        def spec(self, value_or_callback: CSINodeSpec, /) -> "CSINode.Builder": ...

        @overload
        def spec(
            self,
            value_or_callback: Callable[[CSINodeSpec.Builder], CSINodeSpec.Builder | CSINodeSpec],
            /,
        ) -> "CSINode.Builder": ...

        @overload
        def spec(self, value_or_callback: Never = ...) -> "CSINodeSpec.BuilderContext": ...

        def spec(self, value_or_callback=None, /):
            """
            spec is the specification of CSINode
            """
            if self._in_context and value_or_callback is None:
                context = CSINodeSpec.BuilderContext()
                context._parent_builder = self
                context._field_name = "spec"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(CSINodeSpec.builder())
                if isinstance(output, CSINodeSpec.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("spec", value)

    class BuilderContext(BuilderContextBase["CSINode.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = CSINode.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for CSINode."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["CSINode", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use CSINode.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    api_version: Annotated[Optional[Literal["storage.k8s.io/v1"]], Field(alias="apiVersion")] = (
        "storage.k8s.io/v1"
    )
    """
    APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
    """
    kind: Optional[Literal["CSINode"]] = "CSINode"
    """
    Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
    """
    metadata: Optional[apimachinery.ObjectMeta] = None
    """
    Standard object's metadata. metadata.name must be the Kubernetes node name.
    """
    spec: CSINodeSpec
    """
    spec is the specification of CSINode
    """


CSINodeList = ResourceList["CSINode"]


class CSIStorageCapacity(Resource):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["CSIStorageCapacity"]:
            return CSIStorageCapacity

        def build(self) -> "CSIStorageCapacity":
            return CSIStorageCapacity(**self._attrs)

        def api_version(self, value: Optional[Literal["storage.k8s.io/v1"]], /) -> Self:
            """
            APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
            """
            return self._set("api_version", value)

        @overload
        def capacity(
            self, value_or_callback: Optional[apimachinery.Quantity], /
        ) -> "CSIStorageCapacity.Builder": ...

        @overload
        def capacity(
            self,
            value_or_callback: Callable[
                [apimachinery.Quantity.Builder],
                apimachinery.Quantity.Builder | apimachinery.Quantity,
            ],
            /,
        ) -> "CSIStorageCapacity.Builder": ...

        @overload
        def capacity(
            self, value_or_callback: Never = ...
        ) -> "apimachinery.Quantity.BuilderContext": ...

        def capacity(self, value_or_callback=None, /):
            """
            capacity is the value reported by the CSI driver in its GetCapacityResponse for a GetCapacityRequest with topology and parameters that match the previous fields.

            The semantic is currently (CSI spec 1.2) defined as: The available capacity, in bytes, of the storage that can be used to provision volumes. If not set, that information is currently unavailable.
            """
            if self._in_context and value_or_callback is None:
                context = apimachinery.Quantity.BuilderContext()
                context._parent_builder = self
                context._field_name = "capacity"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(apimachinery.Quantity.builder())
                if isinstance(output, apimachinery.Quantity.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("capacity", value)

        def kind(self, value: Optional[Literal["CSIStorageCapacity"]], /) -> Self:
            """
            Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
            """
            return self._set("kind", value)

        @overload
        def maximum_volume_size(
            self, value_or_callback: Optional[apimachinery.Quantity], /
        ) -> "CSIStorageCapacity.Builder": ...

        @overload
        def maximum_volume_size(
            self,
            value_or_callback: Callable[
                [apimachinery.Quantity.Builder],
                apimachinery.Quantity.Builder | apimachinery.Quantity,
            ],
            /,
        ) -> "CSIStorageCapacity.Builder": ...

        @overload
        def maximum_volume_size(
            self, value_or_callback: Never = ...
        ) -> "apimachinery.Quantity.BuilderContext": ...

        def maximum_volume_size(self, value_or_callback=None, /):
            """
            maximumVolumeSize is the value reported by the CSI driver in its GetCapacityResponse for a GetCapacityRequest with topology and parameters that match the previous fields.

            This is defined since CSI spec 1.4.0 as the largest size that may be used in a CreateVolumeRequest.capacity_range.required_bytes field to create a volume with the same parameters as those in GetCapacityRequest. The corresponding value in the Kubernetes API is ResourceRequirements.Requests in a volume claim.
            """
            if self._in_context and value_or_callback is None:
                context = apimachinery.Quantity.BuilderContext()
                context._parent_builder = self
                context._field_name = "maximum_volume_size"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(apimachinery.Quantity.builder())
                if isinstance(output, apimachinery.Quantity.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("maximum_volume_size", value)

        @overload
        def metadata(
            self, value_or_callback: Optional[apimachinery.ObjectMeta], /
        ) -> "CSIStorageCapacity.Builder": ...

        @overload
        def metadata(
            self,
            value_or_callback: Callable[
                [apimachinery.ObjectMeta.Builder],
                apimachinery.ObjectMeta.Builder | apimachinery.ObjectMeta,
            ],
            /,
        ) -> "CSIStorageCapacity.Builder": ...

        @overload
        def metadata(
            self, value_or_callback: Never = ...
        ) -> "apimachinery.ObjectMeta.BuilderContext": ...

        def metadata(self, value_or_callback=None, /):
            """
            Standard object's metadata. The name has no particular meaning. It must be a DNS subdomain (dots allowed, 253 characters). To ensure that there are no conflicts with other CSI drivers on the cluster, the recommendation is to use csisc-<uuid>, a generated name, or a reverse-domain name which ends with the unique CSI driver name.

            Objects are namespaced.

            More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
            """
            if self._in_context and value_or_callback is None:
                context = apimachinery.ObjectMeta.BuilderContext()
                context._parent_builder = self
                context._field_name = "metadata"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(apimachinery.ObjectMeta.builder())
                if isinstance(output, apimachinery.ObjectMeta.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("metadata", value)

        @overload
        def node_topology(
            self, value_or_callback: Optional[apimachinery.LabelSelector], /
        ) -> "CSIStorageCapacity.Builder": ...

        @overload
        def node_topology(
            self,
            value_or_callback: Callable[
                [apimachinery.LabelSelector.Builder],
                apimachinery.LabelSelector.Builder | apimachinery.LabelSelector,
            ],
            /,
        ) -> "CSIStorageCapacity.Builder": ...

        @overload
        def node_topology(
            self, value_or_callback: Never = ...
        ) -> "apimachinery.LabelSelector.BuilderContext": ...

        def node_topology(self, value_or_callback=None, /):
            """
            nodeTopology defines which nodes have access to the storage for which capacity was reported. If not set, the storage is not accessible from any node in the cluster. If empty, the storage is accessible from all nodes. This field is immutable.
            """
            if self._in_context and value_or_callback is None:
                context = apimachinery.LabelSelector.BuilderContext()
                context._parent_builder = self
                context._field_name = "node_topology"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(apimachinery.LabelSelector.builder())
                if isinstance(output, apimachinery.LabelSelector.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("node_topology", value)

        def storage_class_name(self, value: str, /) -> Self:
            """
            storageClassName represents the name of the StorageClass that the reported capacity applies to. It must meet the same requirements as the name of a StorageClass object (non-empty, DNS subdomain). If that object no longer exists, the CSIStorageCapacity object is obsolete and should be removed by its creator. This field is immutable.
            """
            return self._set("storage_class_name", value)

    class BuilderContext(BuilderContextBase["CSIStorageCapacity.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = CSIStorageCapacity.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for CSIStorageCapacity."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["CSIStorageCapacity", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use CSIStorageCapacity.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    api_version: Annotated[Optional[Literal["storage.k8s.io/v1"]], Field(alias="apiVersion")] = (
        "storage.k8s.io/v1"
    )
    """
    APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
    """
    capacity: Optional[apimachinery.Quantity] = None
    """
    capacity is the value reported by the CSI driver in its GetCapacityResponse for a GetCapacityRequest with topology and parameters that match the previous fields.

    The semantic is currently (CSI spec 1.2) defined as: The available capacity, in bytes, of the storage that can be used to provision volumes. If not set, that information is currently unavailable.
    """
    kind: Optional[Literal["CSIStorageCapacity"]] = "CSIStorageCapacity"
    """
    Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
    """
    maximum_volume_size: Annotated[
        Optional[apimachinery.Quantity], Field(alias="maximumVolumeSize")
    ] = None
    """
    maximumVolumeSize is the value reported by the CSI driver in its GetCapacityResponse for a GetCapacityRequest with topology and parameters that match the previous fields.

    This is defined since CSI spec 1.4.0 as the largest size that may be used in a CreateVolumeRequest.capacity_range.required_bytes field to create a volume with the same parameters as those in GetCapacityRequest. The corresponding value in the Kubernetes API is ResourceRequirements.Requests in a volume claim.
    """
    metadata: Optional[apimachinery.ObjectMeta] = None
    """
    Standard object's metadata. The name has no particular meaning. It must be a DNS subdomain (dots allowed, 253 characters). To ensure that there are no conflicts with other CSI drivers on the cluster, the recommendation is to use csisc-<uuid>, a generated name, or a reverse-domain name which ends with the unique CSI driver name.

    Objects are namespaced.

    More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
    """
    node_topology: Annotated[Optional[apimachinery.LabelSelector], Field(alias="nodeTopology")] = (
        None
    )
    """
    nodeTopology defines which nodes have access to the storage for which capacity was reported. If not set, the storage is not accessible from any node in the cluster. If empty, the storage is accessible from all nodes. This field is immutable.
    """
    storage_class_name: Annotated[str, Field(alias="storageClassName")]
    """
    storageClassName represents the name of the StorageClass that the reported capacity applies to. It must meet the same requirements as the name of a StorageClass object (non-empty, DNS subdomain). If that object no longer exists, the CSIStorageCapacity object is obsolete and should be removed by its creator. This field is immutable.
    """


CSIStorageCapacityList = ResourceList["CSIStorageCapacity"]


class StorageClass(Resource):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["StorageClass"]:
            return StorageClass

        def build(self) -> "StorageClass":
            return StorageClass(**self._attrs)

        def allow_volume_expansion(self, value: Optional[bool], /) -> Self:
            """
            allowVolumeExpansion shows whether the storage class allow volume expand.
            """
            return self._set("allow_volume_expansion", value)

        @overload
        def allowed_topologies(
            self, value_or_callback: List[v1.TopologySelectorTerm], /
        ) -> "StorageClass.Builder": ...

        @overload
        def allowed_topologies(
            self,
            value_or_callback: Callable[
                [GenericListBuilder[v1.TopologySelectorTerm, v1.TopologySelectorTerm.Builder]],
                GenericListBuilder[v1.TopologySelectorTerm, v1.TopologySelectorTerm.Builder]
                | List[v1.TopologySelectorTerm],
            ],
            /,
        ) -> "StorageClass.Builder": ...

        @overload
        def allowed_topologies(
            self, value_or_callback: Never = ...
        ) -> ListBuilderContext[v1.TopologySelectorTerm.Builder]: ...

        def allowed_topologies(self, value_or_callback=None, /):
            """
            allowedTopologies restrict the node topologies where volumes can be dynamically provisioned. Each volume plugin defines its own supported topology specifications. An empty TopologySelectorTerm list means there is no topology restriction. This field is only honored by servers that enable the VolumeScheduling feature.
            """
            if self._in_context and value_or_callback is None:
                context = ListBuilderContext[v1.TopologySelectorTerm.Builder]()
                context._parent_builder = self
                context._field_name = "allowed_topologies"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(v1.TopologySelectorTerm.list_builder())
                if isinstance(output, GenericListBuilder):
                    value = output.build()
                else:
                    value = output
            return self._set("allowed_topologies", value)

        def api_version(self, value: Optional[Literal["storage.k8s.io/v1"]], /) -> Self:
            """
            APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
            """
            return self._set("api_version", value)

        def kind(self, value: Optional[Literal["StorageClass"]], /) -> Self:
            """
            Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
            """
            return self._set("kind", value)

        @overload
        def metadata(
            self, value_or_callback: Optional[apimachinery.ObjectMeta], /
        ) -> "StorageClass.Builder": ...

        @overload
        def metadata(
            self,
            value_or_callback: Callable[
                [apimachinery.ObjectMeta.Builder],
                apimachinery.ObjectMeta.Builder | apimachinery.ObjectMeta,
            ],
            /,
        ) -> "StorageClass.Builder": ...

        @overload
        def metadata(
            self, value_or_callback: Never = ...
        ) -> "apimachinery.ObjectMeta.BuilderContext": ...

        def metadata(self, value_or_callback=None, /):
            """
            Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
            """
            if self._in_context and value_or_callback is None:
                context = apimachinery.ObjectMeta.BuilderContext()
                context._parent_builder = self
                context._field_name = "metadata"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(apimachinery.ObjectMeta.builder())
                if isinstance(output, apimachinery.ObjectMeta.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("metadata", value)

        def mount_options(self, value: Optional[List[str]], /) -> Self:
            """
            mountOptions controls the mountOptions for dynamically provisioned PersistentVolumes of this storage class. e.g. ["ro", "soft"]. Not validated - mount of the PVs will simply fail if one is invalid.
            """
            return self._set("mount_options", value)

        def parameters(self, value: Optional[Dict[str, str]], /) -> Self:
            """
            parameters holds the parameters for the provisioner that should create volumes of this storage class.
            """
            return self._set("parameters", value)

        def provisioner(self, value: str, /) -> Self:
            """
            provisioner indicates the type of the provisioner.
            """
            return self._set("provisioner", value)

        def reclaim_policy(self, value: Optional[str], /) -> Self:
            """
            reclaimPolicy controls the reclaimPolicy for dynamically provisioned PersistentVolumes of this storage class. Defaults to Delete.
            """
            return self._set("reclaim_policy", value)

        def volume_binding_mode(self, value: Optional[str], /) -> Self:
            """
            volumeBindingMode indicates how PersistentVolumeClaims should be provisioned and bound.  When unset, VolumeBindingImmediate is used. This field is only honored by servers that enable the VolumeScheduling feature.
            """
            return self._set("volume_binding_mode", value)

    class BuilderContext(BuilderContextBase["StorageClass.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = StorageClass.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for StorageClass."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["StorageClass", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use StorageClass.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    allow_volume_expansion: Annotated[Optional[bool], Field(alias="allowVolumeExpansion")] = None
    """
    allowVolumeExpansion shows whether the storage class allow volume expand.
    """
    allowed_topologies: Annotated[
        Optional[List[v1.TopologySelectorTerm]], Field(alias="allowedTopologies")
    ] = None
    """
    allowedTopologies restrict the node topologies where volumes can be dynamically provisioned. Each volume plugin defines its own supported topology specifications. An empty TopologySelectorTerm list means there is no topology restriction. This field is only honored by servers that enable the VolumeScheduling feature.
    """
    api_version: Annotated[Optional[Literal["storage.k8s.io/v1"]], Field(alias="apiVersion")] = (
        "storage.k8s.io/v1"
    )
    """
    APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
    """
    kind: Optional[Literal["StorageClass"]] = "StorageClass"
    """
    Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
    """
    metadata: Optional[apimachinery.ObjectMeta] = None
    """
    Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
    """
    mount_options: Annotated[Optional[List[str]], Field(alias="mountOptions")] = None
    """
    mountOptions controls the mountOptions for dynamically provisioned PersistentVolumes of this storage class. e.g. ["ro", "soft"]. Not validated - mount of the PVs will simply fail if one is invalid.
    """
    parameters: Optional[Dict[str, str]] = None
    """
    parameters holds the parameters for the provisioner that should create volumes of this storage class.
    """
    provisioner: str
    """
    provisioner indicates the type of the provisioner.
    """
    reclaim_policy: Annotated[Optional[str], Field(alias="reclaimPolicy")] = None
    """
    reclaimPolicy controls the reclaimPolicy for dynamically provisioned PersistentVolumes of this storage class. Defaults to Delete.
    """
    volume_binding_mode: Annotated[Optional[str], Field(alias="volumeBindingMode")] = None
    """
    volumeBindingMode indicates how PersistentVolumeClaims should be provisioned and bound.  When unset, VolumeBindingImmediate is used. This field is only honored by servers that enable the VolumeScheduling feature.
    """


StorageClassList = ResourceList["StorageClass"]


class VolumeAttachmentSource(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["VolumeAttachmentSource"]:
            return VolumeAttachmentSource

        def build(self) -> "VolumeAttachmentSource":
            return VolumeAttachmentSource(**self._attrs)

        @overload
        def inline_volume_spec(
            self, value_or_callback: Optional[v1.PersistentVolumeSpec], /
        ) -> "VolumeAttachmentSource.Builder": ...

        @overload
        def inline_volume_spec(
            self,
            value_or_callback: Callable[
                [v1.PersistentVolumeSpec.Builder],
                v1.PersistentVolumeSpec.Builder | v1.PersistentVolumeSpec,
            ],
            /,
        ) -> "VolumeAttachmentSource.Builder": ...

        @overload
        def inline_volume_spec(
            self, value_or_callback: Never = ...
        ) -> "v1.PersistentVolumeSpec.BuilderContext": ...

        def inline_volume_spec(self, value_or_callback=None, /):
            """
            inlineVolumeSpec contains all the information necessary to attach a persistent volume defined by a pod's inline VolumeSource. This field is populated only for the CSIMigration feature. It contains translated fields from a pod's inline VolumeSource to a PersistentVolumeSpec. This field is beta-level and is only honored by servers that enabled the CSIMigration feature.
            """
            if self._in_context and value_or_callback is None:
                context = v1.PersistentVolumeSpec.BuilderContext()
                context._parent_builder = self
                context._field_name = "inline_volume_spec"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(v1.PersistentVolumeSpec.builder())
                if isinstance(output, v1.PersistentVolumeSpec.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("inline_volume_spec", value)

        def persistent_volume_name(self, value: Optional[str], /) -> Self:
            """
            persistentVolumeName represents the name of the persistent volume to attach.
            """
            return self._set("persistent_volume_name", value)

    class BuilderContext(BuilderContextBase["VolumeAttachmentSource.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = VolumeAttachmentSource.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for VolumeAttachmentSource."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["VolumeAttachmentSource", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use VolumeAttachmentSource.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    inline_volume_spec: Annotated[
        Optional[v1.PersistentVolumeSpec], Field(alias="inlineVolumeSpec")
    ] = None
    """
    inlineVolumeSpec contains all the information necessary to attach a persistent volume defined by a pod's inline VolumeSource. This field is populated only for the CSIMigration feature. It contains translated fields from a pod's inline VolumeSource to a PersistentVolumeSpec. This field is beta-level and is only honored by servers that enabled the CSIMigration feature.
    """
    persistent_volume_name: Annotated[Optional[str], Field(alias="persistentVolumeName")] = None
    """
    persistentVolumeName represents the name of the persistent volume to attach.
    """


class VolumeAttachmentSpec(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["VolumeAttachmentSpec"]:
            return VolumeAttachmentSpec

        def build(self) -> "VolumeAttachmentSpec":
            return VolumeAttachmentSpec(**self._attrs)

        def attacher(self, value: str, /) -> Self:
            """
            attacher indicates the name of the volume driver that MUST handle this request. This is the name returned by GetPluginName().
            """
            return self._set("attacher", value)

        def node_name(self, value: str, /) -> Self:
            """
            nodeName represents the node that the volume should be attached to.
            """
            return self._set("node_name", value)

        @overload
        def source(
            self, value_or_callback: VolumeAttachmentSource, /
        ) -> "VolumeAttachmentSpec.Builder": ...

        @overload
        def source(
            self,
            value_or_callback: Callable[
                [VolumeAttachmentSource.Builder],
                VolumeAttachmentSource.Builder | VolumeAttachmentSource,
            ],
            /,
        ) -> "VolumeAttachmentSpec.Builder": ...

        @overload
        def source(
            self, value_or_callback: Never = ...
        ) -> "VolumeAttachmentSource.BuilderContext": ...

        def source(self, value_or_callback=None, /):
            """
            source represents the volume that should be attached.
            """
            if self._in_context and value_or_callback is None:
                context = VolumeAttachmentSource.BuilderContext()
                context._parent_builder = self
                context._field_name = "source"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(VolumeAttachmentSource.builder())
                if isinstance(output, VolumeAttachmentSource.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("source", value)

    class BuilderContext(BuilderContextBase["VolumeAttachmentSpec.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = VolumeAttachmentSpec.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for VolumeAttachmentSpec."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["VolumeAttachmentSpec", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use VolumeAttachmentSpec.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    attacher: str
    """
    attacher indicates the name of the volume driver that MUST handle this request. This is the name returned by GetPluginName().
    """
    node_name: Annotated[str, Field(alias="nodeName")]
    """
    nodeName represents the node that the volume should be attached to.
    """
    source: VolumeAttachmentSource
    """
    source represents the volume that should be attached.
    """


class VolumeAttachmentStatus(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["VolumeAttachmentStatus"]:
            return VolumeAttachmentStatus

        def build(self) -> "VolumeAttachmentStatus":
            return VolumeAttachmentStatus(**self._attrs)

        @overload
        def attach_error(
            self, value_or_callback: Optional[VolumeError], /
        ) -> "VolumeAttachmentStatus.Builder": ...

        @overload
        def attach_error(
            self,
            value_or_callback: Callable[[VolumeError.Builder], VolumeError.Builder | VolumeError],
            /,
        ) -> "VolumeAttachmentStatus.Builder": ...

        @overload
        def attach_error(self, value_or_callback: Never = ...) -> "VolumeError.BuilderContext": ...

        def attach_error(self, value_or_callback=None, /):
            """
            attachError represents the last error encountered during attach operation, if any. This field must only be set by the entity completing the attach operation, i.e. the external-attacher.
            """
            if self._in_context and value_or_callback is None:
                context = VolumeError.BuilderContext()
                context._parent_builder = self
                context._field_name = "attach_error"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(VolumeError.builder())
                if isinstance(output, VolumeError.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("attach_error", value)

        def attached(self, value: bool, /) -> Self:
            """
            attached indicates the volume is successfully attached. This field must only be set by the entity completing the attach operation, i.e. the external-attacher.
            """
            return self._set("attached", value)

        def attachment_metadata(self, value: Optional[Dict[str, str]], /) -> Self:
            """
            attachmentMetadata is populated with any information returned by the attach operation, upon successful attach, that must be passed into subsequent WaitForAttach or Mount calls. This field must only be set by the entity completing the attach operation, i.e. the external-attacher.
            """
            return self._set("attachment_metadata", value)

        @overload
        def detach_error(
            self, value_or_callback: Optional[VolumeError], /
        ) -> "VolumeAttachmentStatus.Builder": ...

        @overload
        def detach_error(
            self,
            value_or_callback: Callable[[VolumeError.Builder], VolumeError.Builder | VolumeError],
            /,
        ) -> "VolumeAttachmentStatus.Builder": ...

        @overload
        def detach_error(self, value_or_callback: Never = ...) -> "VolumeError.BuilderContext": ...

        def detach_error(self, value_or_callback=None, /):
            """
            detachError represents the last error encountered during detach operation, if any. This field must only be set by the entity completing the detach operation, i.e. the external-attacher.
            """
            if self._in_context and value_or_callback is None:
                context = VolumeError.BuilderContext()
                context._parent_builder = self
                context._field_name = "detach_error"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(VolumeError.builder())
                if isinstance(output, VolumeError.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("detach_error", value)

    class BuilderContext(BuilderContextBase["VolumeAttachmentStatus.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = VolumeAttachmentStatus.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for VolumeAttachmentStatus."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["VolumeAttachmentStatus", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use VolumeAttachmentStatus.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    attach_error: Annotated[Optional[VolumeError], Field(alias="attachError")] = None
    """
    attachError represents the last error encountered during attach operation, if any. This field must only be set by the entity completing the attach operation, i.e. the external-attacher.
    """
    attached: bool
    """
    attached indicates the volume is successfully attached. This field must only be set by the entity completing the attach operation, i.e. the external-attacher.
    """
    attachment_metadata: Annotated[Optional[Dict[str, str]], Field(alias="attachmentMetadata")] = (
        None
    )
    """
    attachmentMetadata is populated with any information returned by the attach operation, upon successful attach, that must be passed into subsequent WaitForAttach or Mount calls. This field must only be set by the entity completing the attach operation, i.e. the external-attacher.
    """
    detach_error: Annotated[Optional[VolumeError], Field(alias="detachError")] = None
    """
    detachError represents the last error encountered during detach operation, if any. This field must only be set by the entity completing the detach operation, i.e. the external-attacher.
    """


class VolumeAttachment(Resource):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["VolumeAttachment"]:
            return VolumeAttachment

        def build(self) -> "VolumeAttachment":
            return VolumeAttachment(**self._attrs)

        def api_version(self, value: Optional[Literal["storage.k8s.io/v1"]], /) -> Self:
            """
            APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
            """
            return self._set("api_version", value)

        def kind(self, value: Optional[Literal["VolumeAttachment"]], /) -> Self:
            """
            Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
            """
            return self._set("kind", value)

        @overload
        def metadata(
            self, value_or_callback: Optional[apimachinery.ObjectMeta], /
        ) -> "VolumeAttachment.Builder": ...

        @overload
        def metadata(
            self,
            value_or_callback: Callable[
                [apimachinery.ObjectMeta.Builder],
                apimachinery.ObjectMeta.Builder | apimachinery.ObjectMeta,
            ],
            /,
        ) -> "VolumeAttachment.Builder": ...

        @overload
        def metadata(
            self, value_or_callback: Never = ...
        ) -> "apimachinery.ObjectMeta.BuilderContext": ...

        def metadata(self, value_or_callback=None, /):
            """
            Standard object metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
            """
            if self._in_context and value_or_callback is None:
                context = apimachinery.ObjectMeta.BuilderContext()
                context._parent_builder = self
                context._field_name = "metadata"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(apimachinery.ObjectMeta.builder())
                if isinstance(output, apimachinery.ObjectMeta.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("metadata", value)

        @overload
        def spec(
            self, value_or_callback: VolumeAttachmentSpec, /
        ) -> "VolumeAttachment.Builder": ...

        @overload
        def spec(
            self,
            value_or_callback: Callable[
                [VolumeAttachmentSpec.Builder],
                VolumeAttachmentSpec.Builder | VolumeAttachmentSpec,
            ],
            /,
        ) -> "VolumeAttachment.Builder": ...

        @overload
        def spec(self, value_or_callback: Never = ...) -> "VolumeAttachmentSpec.BuilderContext": ...

        def spec(self, value_or_callback=None, /):
            """
            spec represents specification of the desired attach/detach volume behavior. Populated by the Kubernetes system.
            """
            if self._in_context and value_or_callback is None:
                context = VolumeAttachmentSpec.BuilderContext()
                context._parent_builder = self
                context._field_name = "spec"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(VolumeAttachmentSpec.builder())
                if isinstance(output, VolumeAttachmentSpec.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("spec", value)

        @overload
        def status(
            self, value_or_callback: Optional[VolumeAttachmentStatus], /
        ) -> "VolumeAttachment.Builder": ...

        @overload
        def status(
            self,
            value_or_callback: Callable[
                [VolumeAttachmentStatus.Builder],
                VolumeAttachmentStatus.Builder | VolumeAttachmentStatus,
            ],
            /,
        ) -> "VolumeAttachment.Builder": ...

        @overload
        def status(
            self, value_or_callback: Never = ...
        ) -> "VolumeAttachmentStatus.BuilderContext": ...

        def status(self, value_or_callback=None, /):
            """
            status represents status of the VolumeAttachment request. Populated by the entity completing the attach or detach operation, i.e. the external-attacher.
            """
            if self._in_context and value_or_callback is None:
                context = VolumeAttachmentStatus.BuilderContext()
                context._parent_builder = self
                context._field_name = "status"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(VolumeAttachmentStatus.builder())
                if isinstance(output, VolumeAttachmentStatus.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("status", value)

    class BuilderContext(BuilderContextBase["VolumeAttachment.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = VolumeAttachment.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for VolumeAttachment."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["VolumeAttachment", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use VolumeAttachment.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    api_version: Annotated[Optional[Literal["storage.k8s.io/v1"]], Field(alias="apiVersion")] = (
        "storage.k8s.io/v1"
    )
    """
    APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
    """
    kind: Optional[Literal["VolumeAttachment"]] = "VolumeAttachment"
    """
    Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
    """
    metadata: Optional[apimachinery.ObjectMeta] = None
    """
    Standard object metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
    """
    spec: VolumeAttachmentSpec
    """
    spec represents specification of the desired attach/detach volume behavior. Populated by the Kubernetes system.
    """
    status: Optional[VolumeAttachmentStatus] = None
    """
    status represents status of the VolumeAttachment request. Populated by the entity completing the attach or detach operation, i.e. the external-attacher.
    """


VolumeAttachmentList = ResourceList["VolumeAttachment"]
