# Generated by cloudcoil-model-codegen v0.5.0
# DO NOT EDIT

from __future__ import annotations

from typing import (
    Annotated,
    Callable,
    Dict,
    List,
    Literal,
    Optional,
    Type,
    overload,
)

from pydantic import Field

from cloudcoil import apimachinery
from cloudcoil.pydantic import (
    BaseModel,
    BaseModelBuilder,
    BuilderContextBase,
    GenericListBuilder,
    ListBuilderContext,
    Never,
    Self,
)
from cloudcoil.resources import Resource, ResourceList

from ..core import v1


class CELDeviceSelector(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["CELDeviceSelector"]:
            return CELDeviceSelector

        def build(self) -> "CELDeviceSelector":
            return CELDeviceSelector(**self._attrs)

        def expression(self, value: str, /) -> Self:
            """
            Expression is a CEL expression which evaluates a single device. It must evaluate to true when the device under consideration satisfies the desired criteria, and false when it does not. Any other result is an error and causes allocation of devices to abort.

            The expression's input is an object named "device", which carries the following properties:
             - driver (string): the name of the driver which defines this device.
             - attributes (map[string]object): the device's attributes, grouped by prefix
               (e.g. device.attributes["dra.example.com"] evaluates to an object with all
               of the attributes which were prefixed by "dra.example.com".
             - capacity (map[string]object): the device's capacities, grouped by prefix.

            Example: Consider a device with driver="dra.example.com", which exposes two attributes named "model" and "ext.example.com/family" and which exposes one capacity named "modules". This input to this expression would have the following fields:

                device.driver
                device.attributes["dra.example.com"].model
                device.attributes["ext.example.com"].family
                device.capacity["dra.example.com"].modules

            The device.driver field can be used to check for a specific driver, either as a high-level precondition (i.e. you only want to consider devices from this driver) or as part of a multi-clause expression that is meant to consider devices from different drivers.

            The value type of each attribute is defined by the device definition, and users who write these expressions must consult the documentation for their specific drivers. The value type of each capacity is Quantity.

            If an unknown prefix is used as a lookup in either device.attributes or device.capacity, an empty map will be returned. Any reference to an unknown field will cause an evaluation error and allocation to abort.

            A robust expression should check for the existence of attributes before referencing them.

            For ease of use, the cel.bind() function is enabled, and can be used to simplify expressions that access multiple attributes with the same domain. For example:

                cel.bind(dra, device.attributes["dra.example.com"], dra.someBool && dra.anotherBool)
            """
            return self._set("expression", value)

    class BuilderContext(BuilderContextBase["CELDeviceSelector.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = CELDeviceSelector.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for CELDeviceSelector."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["CELDeviceSelector", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use CELDeviceSelector.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    expression: str
    """
    Expression is a CEL expression which evaluates a single device. It must evaluate to true when the device under consideration satisfies the desired criteria, and false when it does not. Any other result is an error and causes allocation of devices to abort.

    The expression's input is an object named "device", which carries the following properties:
     - driver (string): the name of the driver which defines this device.
     - attributes (map[string]object): the device's attributes, grouped by prefix
       (e.g. device.attributes["dra.example.com"] evaluates to an object with all
       of the attributes which were prefixed by "dra.example.com".
     - capacity (map[string]object): the device's capacities, grouped by prefix.

    Example: Consider a device with driver="dra.example.com", which exposes two attributes named "model" and "ext.example.com/family" and which exposes one capacity named "modules". This input to this expression would have the following fields:

        device.driver
        device.attributes["dra.example.com"].model
        device.attributes["ext.example.com"].family
        device.capacity["dra.example.com"].modules

    The device.driver field can be used to check for a specific driver, either as a high-level precondition (i.e. you only want to consider devices from this driver) or as part of a multi-clause expression that is meant to consider devices from different drivers.

    The value type of each attribute is defined by the device definition, and users who write these expressions must consult the documentation for their specific drivers. The value type of each capacity is Quantity.

    If an unknown prefix is used as a lookup in either device.attributes or device.capacity, an empty map will be returned. Any reference to an unknown field will cause an evaluation error and allocation to abort.

    A robust expression should check for the existence of attributes before referencing them.

    For ease of use, the cel.bind() function is enabled, and can be used to simplify expressions that access multiple attributes with the same domain. For example:

        cel.bind(dra, device.attributes["dra.example.com"], dra.someBool && dra.anotherBool)
    """


class DeviceAttribute(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["DeviceAttribute"]:
            return DeviceAttribute

        def build(self) -> "DeviceAttribute":
            return DeviceAttribute(**self._attrs)

        def bool(self, value: Optional[bool], /) -> Self:
            """
            BoolValue is a true/false value.
            """
            return self._set("bool", value)

        def int(self, value: Optional[int], /) -> Self:
            """
            IntValue is a number.
            """
            return self._set("int", value)

        def string(self, value: Optional[str], /) -> Self:
            """
            StringValue is a string. Must not be longer than 64 characters.
            """
            return self._set("string", value)

        def version(self, value: Optional[str], /) -> Self:
            """
            VersionValue is a semantic version according to semver.org spec 2.0.0. Must not be longer than 64 characters.
            """
            return self._set("version", value)

    class BuilderContext(BuilderContextBase["DeviceAttribute.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = DeviceAttribute.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for DeviceAttribute."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["DeviceAttribute", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use DeviceAttribute.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    bool: Optional[bool] = None
    """
    BoolValue is a true/false value.
    """
    int: Optional[int] = None
    """
    IntValue is a number.
    """
    string: Optional[str] = None
    """
    StringValue is a string. Must not be longer than 64 characters.
    """
    version: Optional[str] = None
    """
    VersionValue is a semantic version according to semver.org spec 2.0.0. Must not be longer than 64 characters.
    """


class DeviceConstraint(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["DeviceConstraint"]:
            return DeviceConstraint

        def build(self) -> "DeviceConstraint":
            return DeviceConstraint(**self._attrs)

        def match_attribute(self, value: Optional[str], /) -> Self:
            """
            MatchAttribute requires that all devices in question have this attribute and that its type and value are the same across those devices.

            For example, if you specified "dra.example.com/numa" (a hypothetical example!), then only devices in the same NUMA node will be chosen. A device which does not have that attribute will not be chosen. All devices should use a value of the same type for this attribute because that is part of its specification, but if one device doesn't, then it also will not be chosen.

            Must include the domain qualifier.
            """
            return self._set("match_attribute", value)

        def requests(self, value: Optional[List[str]], /) -> Self:
            """
            Requests is a list of the one or more requests in this claim which must co-satisfy this constraint. If a request is fulfilled by multiple devices, then all of the devices must satisfy the constraint. If this is not specified, this constraint applies to all requests in this claim.
            """
            return self._set("requests", value)

    class BuilderContext(BuilderContextBase["DeviceConstraint.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = DeviceConstraint.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for DeviceConstraint."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["DeviceConstraint", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use DeviceConstraint.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    match_attribute: Annotated[Optional[str], Field(alias="matchAttribute")] = None
    """
    MatchAttribute requires that all devices in question have this attribute and that its type and value are the same across those devices.

    For example, if you specified "dra.example.com/numa" (a hypothetical example!), then only devices in the same NUMA node will be chosen. A device which does not have that attribute will not be chosen. All devices should use a value of the same type for this attribute because that is part of its specification, but if one device doesn't, then it also will not be chosen.

    Must include the domain qualifier.
    """
    requests: Optional[List[str]] = None
    """
    Requests is a list of the one or more requests in this claim which must co-satisfy this constraint. If a request is fulfilled by multiple devices, then all of the devices must satisfy the constraint. If this is not specified, this constraint applies to all requests in this claim.
    """


class DeviceRequestAllocationResult(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["DeviceRequestAllocationResult"]:
            return DeviceRequestAllocationResult

        def build(self) -> "DeviceRequestAllocationResult":
            return DeviceRequestAllocationResult(**self._attrs)

        def device(self, value: str, /) -> Self:
            """
            Device references one device instance via its name in the driver's resource pool. It must be a DNS label.
            """
            return self._set("device", value)

        def driver(self, value: str, /) -> Self:
            """
            Driver specifies the name of the DRA driver whose kubelet plugin should be invoked to process the allocation once the claim is needed on a node.

            Must be a DNS subdomain and should end with a DNS domain owned by the vendor of the driver.
            """
            return self._set("driver", value)

        def pool(self, value: str, /) -> Self:
            """
            This name together with the driver name and the device name field identify which device was allocated (`<driver name>/<pool name>/<device name>`).

            Must not be longer than 253 characters and may contain one or more DNS sub-domains separated by slashes.
            """
            return self._set("pool", value)

        def request(self, value: str, /) -> Self:
            """
            Request is the name of the request in the claim which caused this device to be allocated. Multiple devices may have been allocated per request.
            """
            return self._set("request", value)

    class BuilderContext(BuilderContextBase["DeviceRequestAllocationResult.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = DeviceRequestAllocationResult.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for DeviceRequestAllocationResult."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["DeviceRequestAllocationResult", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use DeviceRequestAllocationResult.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    device: str
    """
    Device references one device instance via its name in the driver's resource pool. It must be a DNS label.
    """
    driver: str
    """
    Driver specifies the name of the DRA driver whose kubelet plugin should be invoked to process the allocation once the claim is needed on a node.

    Must be a DNS subdomain and should end with a DNS domain owned by the vendor of the driver.
    """
    pool: str
    """
    This name together with the driver name and the device name field identify which device was allocated (`<driver name>/<pool name>/<device name>`).

    Must not be longer than 253 characters and may contain one or more DNS sub-domains separated by slashes.
    """
    request: str
    """
    Request is the name of the request in the claim which caused this device to be allocated. Multiple devices may have been allocated per request.
    """


class DeviceSelector(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["DeviceSelector"]:
            return DeviceSelector

        def build(self) -> "DeviceSelector":
            return DeviceSelector(**self._attrs)

        @overload
        def cel(
            self, value_or_callback: Optional[CELDeviceSelector], /
        ) -> "DeviceSelector.Builder": ...

        @overload
        def cel(
            self,
            value_or_callback: Callable[
                [CELDeviceSelector.Builder],
                CELDeviceSelector.Builder | CELDeviceSelector,
            ],
            /,
        ) -> "DeviceSelector.Builder": ...

        @overload
        def cel(self, value_or_callback: Never = ...) -> "CELDeviceSelector.BuilderContext": ...

        def cel(self, value_or_callback=None, /):
            """
            CEL contains a CEL expression for selecting a device.
            """
            if self._in_context and value_or_callback is None:
                context = CELDeviceSelector.BuilderContext()
                context._parent_builder = self
                context._field_name = "cel"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(CELDeviceSelector.builder())
                if isinstance(output, CELDeviceSelector.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("cel", value)

    class BuilderContext(BuilderContextBase["DeviceSelector.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = DeviceSelector.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for DeviceSelector."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["DeviceSelector", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use DeviceSelector.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    cel: Optional[CELDeviceSelector] = None
    """
    CEL contains a CEL expression for selecting a device.
    """


class PodSchedulingContextSpec(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["PodSchedulingContextSpec"]:
            return PodSchedulingContextSpec

        def build(self) -> "PodSchedulingContextSpec":
            return PodSchedulingContextSpec(**self._attrs)

        def potential_nodes(self, value: Optional[List[str]], /) -> Self:
            """
            PotentialNodes lists nodes where the Pod might be able to run.

            The size of this field is limited to 128. This is large enough for many clusters. Larger clusters may need more attempts to find a node that suits all pending resources. This may get increased in the future, but not reduced.
            """
            return self._set("potential_nodes", value)

        def selected_node(self, value: Optional[str], /) -> Self:
            """
            SelectedNode is the node for which allocation of ResourceClaims that are referenced by the Pod and that use "WaitForFirstConsumer" allocation is to be attempted.
            """
            return self._set("selected_node", value)

    class BuilderContext(BuilderContextBase["PodSchedulingContextSpec.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = PodSchedulingContextSpec.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for PodSchedulingContextSpec."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["PodSchedulingContextSpec", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use PodSchedulingContextSpec.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    potential_nodes: Annotated[Optional[List[str]], Field(alias="potentialNodes")] = None
    """
    PotentialNodes lists nodes where the Pod might be able to run.

    The size of this field is limited to 128. This is large enough for many clusters. Larger clusters may need more attempts to find a node that suits all pending resources. This may get increased in the future, but not reduced.
    """
    selected_node: Annotated[Optional[str], Field(alias="selectedNode")] = None
    """
    SelectedNode is the node for which allocation of ResourceClaims that are referenced by the Pod and that use "WaitForFirstConsumer" allocation is to be attempted.
    """


class ResourceClaimConsumerReference(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["ResourceClaimConsumerReference"]:
            return ResourceClaimConsumerReference

        def build(self) -> "ResourceClaimConsumerReference":
            return ResourceClaimConsumerReference(**self._attrs)

        def api_group(self, value: Optional[str], /) -> Self:
            """
            APIGroup is the group for the resource being referenced. It is empty for the core API. This matches the group in the APIVersion that is used when creating the resources.
            """
            return self._set("api_group", value)

        def name(self, value: str, /) -> Self:
            """
            Name is the name of resource being referenced.
            """
            return self._set("name", value)

        def resource(self, value: str, /) -> Self:
            """
            Resource is the type of resource being referenced, for example "pods".
            """
            return self._set("resource", value)

        def uid(self, value: str, /) -> Self:
            """
            UID identifies exactly one incarnation of the resource.
            """
            return self._set("uid", value)

    class BuilderContext(BuilderContextBase["ResourceClaimConsumerReference.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = ResourceClaimConsumerReference.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for ResourceClaimConsumerReference."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["ResourceClaimConsumerReference", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use ResourceClaimConsumerReference.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    api_group: Annotated[Optional[str], Field(alias="apiGroup")] = None
    """
    APIGroup is the group for the resource being referenced. It is empty for the core API. This matches the group in the APIVersion that is used when creating the resources.
    """
    name: str
    """
    Name is the name of resource being referenced.
    """
    resource: str
    """
    Resource is the type of resource being referenced, for example "pods".
    """
    uid: str
    """
    UID identifies exactly one incarnation of the resource.
    """


class ResourceClaimSchedulingStatus(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["ResourceClaimSchedulingStatus"]:
            return ResourceClaimSchedulingStatus

        def build(self) -> "ResourceClaimSchedulingStatus":
            return ResourceClaimSchedulingStatus(**self._attrs)

        def name(self, value: str, /) -> Self:
            """
            Name matches the pod.spec.resourceClaims[*].Name field.
            """
            return self._set("name", value)

        def unsuitable_nodes(self, value: Optional[List[str]], /) -> Self:
            """
            UnsuitableNodes lists nodes that the ResourceClaim cannot be allocated for.

            The size of this field is limited to 128, the same as for PodSchedulingSpec.PotentialNodes. This may get increased in the future, but not reduced.
            """
            return self._set("unsuitable_nodes", value)

    class BuilderContext(BuilderContextBase["ResourceClaimSchedulingStatus.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = ResourceClaimSchedulingStatus.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for ResourceClaimSchedulingStatus."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["ResourceClaimSchedulingStatus", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use ResourceClaimSchedulingStatus.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    name: str
    """
    Name matches the pod.spec.resourceClaims[*].Name field.
    """
    unsuitable_nodes: Annotated[Optional[List[str]], Field(alias="unsuitableNodes")] = None
    """
    UnsuitableNodes lists nodes that the ResourceClaim cannot be allocated for.

    The size of this field is limited to 128, the same as for PodSchedulingSpec.PotentialNodes. This may get increased in the future, but not reduced.
    """


class ResourcePool(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["ResourcePool"]:
            return ResourcePool

        def build(self) -> "ResourcePool":
            return ResourcePool(**self._attrs)

        def generation(self, value: int, /) -> Self:
            """
            Generation tracks the change in a pool over time. Whenever a driver changes something about one or more of the resources in a pool, it must change the generation in all ResourceSlices which are part of that pool. Consumers of ResourceSlices should only consider resources from the pool with the highest generation number. The generation may be reset by drivers, which should be fine for consumers, assuming that all ResourceSlices in a pool are updated to match or deleted.

            Combined with ResourceSliceCount, this mechanism enables consumers to detect pools which are comprised of multiple ResourceSlices and are in an incomplete state.
            """
            return self._set("generation", value)

        def name(self, value: str, /) -> Self:
            """
            Name is used to identify the pool. For node-local devices, this is often the node name, but this is not required.

            It must not be longer than 253 characters and must consist of one or more DNS sub-domains separated by slashes. This field is immutable.
            """
            return self._set("name", value)

        def resource_slice_count(self, value: int, /) -> Self:
            """
            ResourceSliceCount is the total number of ResourceSlices in the pool at this generation number. Must be greater than zero.

            Consumers can use this to check whether they have seen all ResourceSlices belonging to the same pool.
            """
            return self._set("resource_slice_count", value)

    class BuilderContext(BuilderContextBase["ResourcePool.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = ResourcePool.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for ResourcePool."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["ResourcePool", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use ResourcePool.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    generation: int
    """
    Generation tracks the change in a pool over time. Whenever a driver changes something about one or more of the resources in a pool, it must change the generation in all ResourceSlices which are part of that pool. Consumers of ResourceSlices should only consider resources from the pool with the highest generation number. The generation may be reset by drivers, which should be fine for consumers, assuming that all ResourceSlices in a pool are updated to match or deleted.

    Combined with ResourceSliceCount, this mechanism enables consumers to detect pools which are comprised of multiple ResourceSlices and are in an incomplete state.
    """
    name: str
    """
    Name is used to identify the pool. For node-local devices, this is often the node name, but this is not required.

    It must not be longer than 253 characters and must consist of one or more DNS sub-domains separated by slashes. This field is immutable.
    """
    resource_slice_count: Annotated[int, Field(alias="resourceSliceCount")]
    """
    ResourceSliceCount is the total number of ResourceSlices in the pool at this generation number. Must be greater than zero.

    Consumers can use this to check whether they have seen all ResourceSlices belonging to the same pool.
    """


class BasicDevice(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["BasicDevice"]:
            return BasicDevice

        def build(self) -> "BasicDevice":
            return BasicDevice(**self._attrs)

        def attributes(self, value: Optional[Dict[str, DeviceAttribute]], /) -> Self:
            """
            Attributes defines the set of attributes for this device. The name of each attribute must be unique in that set.

            The maximum number of attributes and capacities combined is 32.
            """
            return self._set("attributes", value)

        def capacity(self, value: Optional[Dict[str, apimachinery.Quantity]], /) -> Self:
            """
            Capacity defines the set of capacities for this device. The name of each capacity must be unique in that set.

            The maximum number of attributes and capacities combined is 32.
            """
            return self._set("capacity", value)

    class BuilderContext(BuilderContextBase["BasicDevice.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = BasicDevice.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for BasicDevice."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["BasicDevice", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use BasicDevice.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    attributes: Optional[Dict[str, DeviceAttribute]] = None
    """
    Attributes defines the set of attributes for this device. The name of each attribute must be unique in that set.

    The maximum number of attributes and capacities combined is 32.
    """
    capacity: Optional[Dict[str, apimachinery.Quantity]] = None
    """
    Capacity defines the set of capacities for this device. The name of each capacity must be unique in that set.

    The maximum number of attributes and capacities combined is 32.
    """


class Device(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["Device"]:
            return Device

        def build(self) -> "Device":
            return Device(**self._attrs)

        @overload
        def basic(self, value_or_callback: Optional[BasicDevice], /) -> "Device.Builder": ...

        @overload
        def basic(
            self,
            value_or_callback: Callable[[BasicDevice.Builder], BasicDevice.Builder | BasicDevice],
            /,
        ) -> "Device.Builder": ...

        @overload
        def basic(self, value_or_callback: Never = ...) -> "BasicDevice.BuilderContext": ...

        def basic(self, value_or_callback=None, /):
            """
            Basic defines one device instance.
            """
            if self._in_context and value_or_callback is None:
                context = BasicDevice.BuilderContext()
                context._parent_builder = self
                context._field_name = "basic"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(BasicDevice.builder())
                if isinstance(output, BasicDevice.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("basic", value)

        def name(self, value: str, /) -> Self:
            """
            Name is unique identifier among all devices managed by the driver in the pool. It must be a DNS label.
            """
            return self._set("name", value)

    class BuilderContext(BuilderContextBase["Device.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = Device.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for Device."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["Device", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use Device.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    basic: Optional[BasicDevice] = None
    """
    Basic defines one device instance.
    """
    name: str
    """
    Name is unique identifier among all devices managed by the driver in the pool. It must be a DNS label.
    """


class DeviceRequest(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["DeviceRequest"]:
            return DeviceRequest

        def build(self) -> "DeviceRequest":
            return DeviceRequest(**self._attrs)

        def admin_access(self, value: Optional[bool], /) -> Self:
            """
            AdminAccess indicates that this is a claim for administrative access to the device(s). Claims with AdminAccess are expected to be used for monitoring or other management services for a device.  They ignore all ordinary claims to the device with respect to access modes and any resource allocations.
            """
            return self._set("admin_access", value)

        def allocation_mode(self, value: Optional[str], /) -> Self:
            """
            AllocationMode and its related fields define how devices are allocated to satisfy this request. Supported values are:

            - ExactCount: This request is for a specific number of devices.
              This is the default. The exact number is provided in the
              count field.

            - All: This request is for all of the matching devices in a pool.
              Allocation will fail if some devices are already allocated,
              unless adminAccess is requested.

            If AlloctionMode is not specified, the default mode is ExactCount. If the mode is ExactCount and count is not specified, the default count is one. Any other requests must specify this field.

            More modes may get added in the future. Clients must refuse to handle requests with unknown modes.
            """
            return self._set("allocation_mode", value)

        def count(self, value: Optional[int], /) -> Self:
            """
            Count is used only when the count mode is "ExactCount". Must be greater than zero. If AllocationMode is ExactCount and this field is not specified, the default is one.
            """
            return self._set("count", value)

        def device_class_name(self, value: str, /) -> Self:
            """
            DeviceClassName references a specific DeviceClass, which can define additional configuration and selectors to be inherited by this request.

            A class is required. Which classes are available depends on the cluster.

            Administrators may use this to restrict which devices may get requested by only installing classes with selectors for permitted devices. If users are free to request anything without restrictions, then administrators can create an empty DeviceClass for users to reference.
            """
            return self._set("device_class_name", value)

        def name(self, value: str, /) -> Self:
            """
            Name can be used to reference this request in a pod.spec.containers[].resources.claims entry and in a constraint of the claim.

            Must be a DNS label.
            """
            return self._set("name", value)

        @overload
        def selectors(
            self, value_or_callback: List[DeviceSelector], /
        ) -> "DeviceRequest.Builder": ...

        @overload
        def selectors(
            self,
            value_or_callback: Callable[
                [GenericListBuilder[DeviceSelector, DeviceSelector.Builder]],
                GenericListBuilder[DeviceSelector, DeviceSelector.Builder] | List[DeviceSelector],
            ],
            /,
        ) -> "DeviceRequest.Builder": ...

        @overload
        def selectors(
            self, value_or_callback: Never = ...
        ) -> ListBuilderContext[DeviceSelector.Builder]: ...

        def selectors(self, value_or_callback=None, /):
            """
            Selectors define criteria which must be satisfied by a specific device in order for that device to be considered for this request. All selectors must be satisfied for a device to be considered.
            """
            if self._in_context and value_or_callback is None:
                context = ListBuilderContext[DeviceSelector.Builder]()
                context._parent_builder = self
                context._field_name = "selectors"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(DeviceSelector.list_builder())
                if isinstance(output, GenericListBuilder):
                    value = output.build()
                else:
                    value = output
            return self._set("selectors", value)

    class BuilderContext(BuilderContextBase["DeviceRequest.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = DeviceRequest.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for DeviceRequest."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["DeviceRequest", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use DeviceRequest.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    admin_access: Annotated[Optional[bool], Field(alias="adminAccess")] = None
    """
    AdminAccess indicates that this is a claim for administrative access to the device(s). Claims with AdminAccess are expected to be used for monitoring or other management services for a device.  They ignore all ordinary claims to the device with respect to access modes and any resource allocations.
    """
    allocation_mode: Annotated[Optional[str], Field(alias="allocationMode")] = None
    """
    AllocationMode and its related fields define how devices are allocated to satisfy this request. Supported values are:

    - ExactCount: This request is for a specific number of devices.
      This is the default. The exact number is provided in the
      count field.

    - All: This request is for all of the matching devices in a pool.
      Allocation will fail if some devices are already allocated,
      unless adminAccess is requested.

    If AlloctionMode is not specified, the default mode is ExactCount. If the mode is ExactCount and count is not specified, the default count is one. Any other requests must specify this field.

    More modes may get added in the future. Clients must refuse to handle requests with unknown modes.
    """
    count: Optional[int] = None
    """
    Count is used only when the count mode is "ExactCount". Must be greater than zero. If AllocationMode is ExactCount and this field is not specified, the default is one.
    """
    device_class_name: Annotated[str, Field(alias="deviceClassName")]
    """
    DeviceClassName references a specific DeviceClass, which can define additional configuration and selectors to be inherited by this request.

    A class is required. Which classes are available depends on the cluster.

    Administrators may use this to restrict which devices may get requested by only installing classes with selectors for permitted devices. If users are free to request anything without restrictions, then administrators can create an empty DeviceClass for users to reference.
    """
    name: str
    """
    Name can be used to reference this request in a pod.spec.containers[].resources.claims entry and in a constraint of the claim.

    Must be a DNS label.
    """
    selectors: Optional[List[DeviceSelector]] = None
    """
    Selectors define criteria which must be satisfied by a specific device in order for that device to be considered for this request. All selectors must be satisfied for a device to be considered.
    """


class OpaqueDeviceConfiguration(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["OpaqueDeviceConfiguration"]:
            return OpaqueDeviceConfiguration

        def build(self) -> "OpaqueDeviceConfiguration":
            return OpaqueDeviceConfiguration(**self._attrs)

        def driver(self, value: str, /) -> Self:
            """
            Driver is used to determine which kubelet plugin needs to be passed these configuration parameters.

            An admission policy provided by the driver developer could use this to decide whether it needs to validate them.

            Must be a DNS subdomain and should end with a DNS domain owned by the vendor of the driver.
            """
            return self._set("driver", value)

        @overload
        def parameters(
            self, value_or_callback: apimachinery.RawExtension, /
        ) -> "OpaqueDeviceConfiguration.Builder": ...

        @overload
        def parameters(
            self,
            value_or_callback: Callable[
                [apimachinery.RawExtension.Builder],
                apimachinery.RawExtension.Builder | apimachinery.RawExtension,
            ],
            /,
        ) -> "OpaqueDeviceConfiguration.Builder": ...

        @overload
        def parameters(
            self, value_or_callback: Never = ...
        ) -> "apimachinery.RawExtension.BuilderContext": ...

        def parameters(self, value_or_callback=None, /):
            """
            Parameters can contain arbitrary data. It is the responsibility of the driver developer to handle validation and versioning. Typically this includes self-identification and a version ("kind" + "apiVersion" for Kubernetes types), with conversion between different versions.
            """
            if self._in_context and value_or_callback is None:
                context = apimachinery.RawExtension.BuilderContext()
                context._parent_builder = self
                context._field_name = "parameters"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(apimachinery.RawExtension.builder())
                if isinstance(output, apimachinery.RawExtension.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("parameters", value)

    class BuilderContext(BuilderContextBase["OpaqueDeviceConfiguration.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = OpaqueDeviceConfiguration.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for OpaqueDeviceConfiguration."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["OpaqueDeviceConfiguration", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use OpaqueDeviceConfiguration.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    driver: str
    """
    Driver is used to determine which kubelet plugin needs to be passed these configuration parameters.

    An admission policy provided by the driver developer could use this to decide whether it needs to validate them.

    Must be a DNS subdomain and should end with a DNS domain owned by the vendor of the driver.
    """
    parameters: apimachinery.RawExtension
    """
    Parameters can contain arbitrary data. It is the responsibility of the driver developer to handle validation and versioning. Typically this includes self-identification and a version ("kind" + "apiVersion" for Kubernetes types), with conversion between different versions.
    """


class PodSchedulingContextStatus(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["PodSchedulingContextStatus"]:
            return PodSchedulingContextStatus

        def build(self) -> "PodSchedulingContextStatus":
            return PodSchedulingContextStatus(**self._attrs)

        @overload
        def resource_claims(
            self, value_or_callback: List[ResourceClaimSchedulingStatus], /
        ) -> "PodSchedulingContextStatus.Builder": ...

        @overload
        def resource_claims(
            self,
            value_or_callback: Callable[
                [
                    GenericListBuilder[
                        ResourceClaimSchedulingStatus,
                        ResourceClaimSchedulingStatus.Builder,
                    ]
                ],
                GenericListBuilder[
                    ResourceClaimSchedulingStatus, ResourceClaimSchedulingStatus.Builder
                ]
                | List[ResourceClaimSchedulingStatus],
            ],
            /,
        ) -> "PodSchedulingContextStatus.Builder": ...

        @overload
        def resource_claims(
            self, value_or_callback: Never = ...
        ) -> ListBuilderContext[ResourceClaimSchedulingStatus.Builder]: ...

        def resource_claims(self, value_or_callback=None, /):
            """
            ResourceClaims describes resource availability for each pod.spec.resourceClaim entry where the corresponding ResourceClaim uses "WaitForFirstConsumer" allocation mode.
            """
            if self._in_context and value_or_callback is None:
                context = ListBuilderContext[ResourceClaimSchedulingStatus.Builder]()
                context._parent_builder = self
                context._field_name = "resource_claims"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(ResourceClaimSchedulingStatus.list_builder())
                if isinstance(output, GenericListBuilder):
                    value = output.build()
                else:
                    value = output
            return self._set("resource_claims", value)

    class BuilderContext(BuilderContextBase["PodSchedulingContextStatus.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = PodSchedulingContextStatus.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for PodSchedulingContextStatus."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["PodSchedulingContextStatus", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use PodSchedulingContextStatus.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    resource_claims: Annotated[
        Optional[List[ResourceClaimSchedulingStatus]], Field(alias="resourceClaims")
    ] = None
    """
    ResourceClaims describes resource availability for each pod.spec.resourceClaim entry where the corresponding ResourceClaim uses "WaitForFirstConsumer" allocation mode.
    """


class ResourceSliceSpec(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["ResourceSliceSpec"]:
            return ResourceSliceSpec

        def build(self) -> "ResourceSliceSpec":
            return ResourceSliceSpec(**self._attrs)

        def all_nodes(self, value: Optional[bool], /) -> Self:
            """
            AllNodes indicates that all nodes have access to the resources in the pool.

            Exactly one of NodeName, NodeSelector and AllNodes must be set.
            """
            return self._set("all_nodes", value)

        @overload
        def devices(self, value_or_callback: List[Device], /) -> "ResourceSliceSpec.Builder": ...

        @overload
        def devices(
            self,
            value_or_callback: Callable[
                [GenericListBuilder[Device, Device.Builder]],
                GenericListBuilder[Device, Device.Builder] | List[Device],
            ],
            /,
        ) -> "ResourceSliceSpec.Builder": ...

        @overload
        def devices(self, value_or_callback: Never = ...) -> ListBuilderContext[Device.Builder]: ...

        def devices(self, value_or_callback=None, /):
            """
            Devices lists some or all of the devices in this pool.

            Must not have more than 128 entries.
            """
            if self._in_context and value_or_callback is None:
                context = ListBuilderContext[Device.Builder]()
                context._parent_builder = self
                context._field_name = "devices"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(Device.list_builder())
                if isinstance(output, GenericListBuilder):
                    value = output.build()
                else:
                    value = output
            return self._set("devices", value)

        def driver(self, value: str, /) -> Self:
            """
            Driver identifies the DRA driver providing the capacity information. A field selector can be used to list only ResourceSlice objects with a certain driver name.

            Must be a DNS subdomain and should end with a DNS domain owned by the vendor of the driver. This field is immutable.
            """
            return self._set("driver", value)

        def node_name(self, value: Optional[str], /) -> Self:
            """
            NodeName identifies the node which provides the resources in this pool. A field selector can be used to list only ResourceSlice objects belonging to a certain node.

            This field can be used to limit access from nodes to ResourceSlices with the same node name. It also indicates to autoscalers that adding new nodes of the same type as some old node might also make new resources available.

            Exactly one of NodeName, NodeSelector and AllNodes must be set. This field is immutable.
            """
            return self._set("node_name", value)

        @overload
        def node_selector(
            self, value_or_callback: Optional[v1.NodeSelector], /
        ) -> "ResourceSliceSpec.Builder": ...

        @overload
        def node_selector(
            self,
            value_or_callback: Callable[
                [v1.NodeSelector.Builder], v1.NodeSelector.Builder | v1.NodeSelector
            ],
            /,
        ) -> "ResourceSliceSpec.Builder": ...

        @overload
        def node_selector(
            self, value_or_callback: Never = ...
        ) -> "v1.NodeSelector.BuilderContext": ...

        def node_selector(self, value_or_callback=None, /):
            """
            NodeSelector defines which nodes have access to the resources in the pool, when that pool is not limited to a single node.

            Must use exactly one term.

            Exactly one of NodeName, NodeSelector and AllNodes must be set.
            """
            if self._in_context and value_or_callback is None:
                context = v1.NodeSelector.BuilderContext()
                context._parent_builder = self
                context._field_name = "node_selector"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(v1.NodeSelector.builder())
                if isinstance(output, v1.NodeSelector.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("node_selector", value)

        @overload
        def pool(self, value_or_callback: ResourcePool, /) -> "ResourceSliceSpec.Builder": ...

        @overload
        def pool(
            self,
            value_or_callback: Callable[
                [ResourcePool.Builder], ResourcePool.Builder | ResourcePool
            ],
            /,
        ) -> "ResourceSliceSpec.Builder": ...

        @overload
        def pool(self, value_or_callback: Never = ...) -> "ResourcePool.BuilderContext": ...

        def pool(self, value_or_callback=None, /):
            """
            Pool describes the pool that this ResourceSlice belongs to.
            """
            if self._in_context and value_or_callback is None:
                context = ResourcePool.BuilderContext()
                context._parent_builder = self
                context._field_name = "pool"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(ResourcePool.builder())
                if isinstance(output, ResourcePool.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("pool", value)

    class BuilderContext(BuilderContextBase["ResourceSliceSpec.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = ResourceSliceSpec.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for ResourceSliceSpec."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["ResourceSliceSpec", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use ResourceSliceSpec.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    all_nodes: Annotated[Optional[bool], Field(alias="allNodes")] = None
    """
    AllNodes indicates that all nodes have access to the resources in the pool.

    Exactly one of NodeName, NodeSelector and AllNodes must be set.
    """
    devices: Optional[List[Device]] = None
    """
    Devices lists some or all of the devices in this pool.

    Must not have more than 128 entries.
    """
    driver: str
    """
    Driver identifies the DRA driver providing the capacity information. A field selector can be used to list only ResourceSlice objects with a certain driver name.

    Must be a DNS subdomain and should end with a DNS domain owned by the vendor of the driver. This field is immutable.
    """
    node_name: Annotated[Optional[str], Field(alias="nodeName")] = None
    """
    NodeName identifies the node which provides the resources in this pool. A field selector can be used to list only ResourceSlice objects belonging to a certain node.

    This field can be used to limit access from nodes to ResourceSlices with the same node name. It also indicates to autoscalers that adding new nodes of the same type as some old node might also make new resources available.

    Exactly one of NodeName, NodeSelector and AllNodes must be set. This field is immutable.
    """
    node_selector: Annotated[Optional[v1.NodeSelector], Field(alias="nodeSelector")] = None
    """
    NodeSelector defines which nodes have access to the resources in the pool, when that pool is not limited to a single node.

    Must use exactly one term.

    Exactly one of NodeName, NodeSelector and AllNodes must be set.
    """
    pool: ResourcePool
    """
    Pool describes the pool that this ResourceSlice belongs to.
    """


class DeviceAllocationConfiguration(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["DeviceAllocationConfiguration"]:
            return DeviceAllocationConfiguration

        def build(self) -> "DeviceAllocationConfiguration":
            return DeviceAllocationConfiguration(**self._attrs)

        @overload
        def opaque(
            self, value_or_callback: Optional[OpaqueDeviceConfiguration], /
        ) -> "DeviceAllocationConfiguration.Builder": ...

        @overload
        def opaque(
            self,
            value_or_callback: Callable[
                [OpaqueDeviceConfiguration.Builder],
                OpaqueDeviceConfiguration.Builder | OpaqueDeviceConfiguration,
            ],
            /,
        ) -> "DeviceAllocationConfiguration.Builder": ...

        @overload
        def opaque(
            self, value_or_callback: Never = ...
        ) -> "OpaqueDeviceConfiguration.BuilderContext": ...

        def opaque(self, value_or_callback=None, /):
            """
            Opaque provides driver-specific configuration parameters.
            """
            if self._in_context and value_or_callback is None:
                context = OpaqueDeviceConfiguration.BuilderContext()
                context._parent_builder = self
                context._field_name = "opaque"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(OpaqueDeviceConfiguration.builder())
                if isinstance(output, OpaqueDeviceConfiguration.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("opaque", value)

        def requests(self, value: Optional[List[str]], /) -> Self:
            """
            Requests lists the names of requests where the configuration applies. If empty, its applies to all requests.
            """
            return self._set("requests", value)

        def source(self, value: str, /) -> Self:
            """
            Source records whether the configuration comes from a class and thus is not something that a normal user would have been able to set or from a claim.
            """
            return self._set("source", value)

    class BuilderContext(BuilderContextBase["DeviceAllocationConfiguration.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = DeviceAllocationConfiguration.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for DeviceAllocationConfiguration."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["DeviceAllocationConfiguration", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use DeviceAllocationConfiguration.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    opaque: Optional[OpaqueDeviceConfiguration] = None
    """
    Opaque provides driver-specific configuration parameters.
    """
    requests: Optional[List[str]] = None
    """
    Requests lists the names of requests where the configuration applies. If empty, its applies to all requests.
    """
    source: str
    """
    Source records whether the configuration comes from a class and thus is not something that a normal user would have been able to set or from a claim.
    """


class DeviceAllocationResult(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["DeviceAllocationResult"]:
            return DeviceAllocationResult

        def build(self) -> "DeviceAllocationResult":
            return DeviceAllocationResult(**self._attrs)

        @overload
        def config(
            self, value_or_callback: List[DeviceAllocationConfiguration], /
        ) -> "DeviceAllocationResult.Builder": ...

        @overload
        def config(
            self,
            value_or_callback: Callable[
                [
                    GenericListBuilder[
                        DeviceAllocationConfiguration,
                        DeviceAllocationConfiguration.Builder,
                    ]
                ],
                GenericListBuilder[
                    DeviceAllocationConfiguration, DeviceAllocationConfiguration.Builder
                ]
                | List[DeviceAllocationConfiguration],
            ],
            /,
        ) -> "DeviceAllocationResult.Builder": ...

        @overload
        def config(
            self, value_or_callback: Never = ...
        ) -> ListBuilderContext[DeviceAllocationConfiguration.Builder]: ...

        def config(self, value_or_callback=None, /):
            """
            This field is a combination of all the claim and class configuration parameters. Drivers can distinguish between those based on a flag.

            This includes configuration parameters for drivers which have no allocated devices in the result because it is up to the drivers which configuration parameters they support. They can silently ignore unknown configuration parameters.
            """
            if self._in_context and value_or_callback is None:
                context = ListBuilderContext[DeviceAllocationConfiguration.Builder]()
                context._parent_builder = self
                context._field_name = "config"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(DeviceAllocationConfiguration.list_builder())
                if isinstance(output, GenericListBuilder):
                    value = output.build()
                else:
                    value = output
            return self._set("config", value)

        @overload
        def results(
            self, value_or_callback: List[DeviceRequestAllocationResult], /
        ) -> "DeviceAllocationResult.Builder": ...

        @overload
        def results(
            self,
            value_or_callback: Callable[
                [
                    GenericListBuilder[
                        DeviceRequestAllocationResult,
                        DeviceRequestAllocationResult.Builder,
                    ]
                ],
                GenericListBuilder[
                    DeviceRequestAllocationResult, DeviceRequestAllocationResult.Builder
                ]
                | List[DeviceRequestAllocationResult],
            ],
            /,
        ) -> "DeviceAllocationResult.Builder": ...

        @overload
        def results(
            self, value_or_callback: Never = ...
        ) -> ListBuilderContext[DeviceRequestAllocationResult.Builder]: ...

        def results(self, value_or_callback=None, /):
            """
            Results lists all allocated devices.
            """
            if self._in_context and value_or_callback is None:
                context = ListBuilderContext[DeviceRequestAllocationResult.Builder]()
                context._parent_builder = self
                context._field_name = "results"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(DeviceRequestAllocationResult.list_builder())
                if isinstance(output, GenericListBuilder):
                    value = output.build()
                else:
                    value = output
            return self._set("results", value)

    class BuilderContext(BuilderContextBase["DeviceAllocationResult.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = DeviceAllocationResult.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for DeviceAllocationResult."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["DeviceAllocationResult", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use DeviceAllocationResult.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    config: Optional[List[DeviceAllocationConfiguration]] = None
    """
    This field is a combination of all the claim and class configuration parameters. Drivers can distinguish between those based on a flag.

    This includes configuration parameters for drivers which have no allocated devices in the result because it is up to the drivers which configuration parameters they support. They can silently ignore unknown configuration parameters.
    """
    results: Optional[List[DeviceRequestAllocationResult]] = None
    """
    Results lists all allocated devices.
    """


class DeviceClaimConfiguration(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["DeviceClaimConfiguration"]:
            return DeviceClaimConfiguration

        def build(self) -> "DeviceClaimConfiguration":
            return DeviceClaimConfiguration(**self._attrs)

        @overload
        def opaque(
            self, value_or_callback: Optional[OpaqueDeviceConfiguration], /
        ) -> "DeviceClaimConfiguration.Builder": ...

        @overload
        def opaque(
            self,
            value_or_callback: Callable[
                [OpaqueDeviceConfiguration.Builder],
                OpaqueDeviceConfiguration.Builder | OpaqueDeviceConfiguration,
            ],
            /,
        ) -> "DeviceClaimConfiguration.Builder": ...

        @overload
        def opaque(
            self, value_or_callback: Never = ...
        ) -> "OpaqueDeviceConfiguration.BuilderContext": ...

        def opaque(self, value_or_callback=None, /):
            """
            Opaque provides driver-specific configuration parameters.
            """
            if self._in_context and value_or_callback is None:
                context = OpaqueDeviceConfiguration.BuilderContext()
                context._parent_builder = self
                context._field_name = "opaque"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(OpaqueDeviceConfiguration.builder())
                if isinstance(output, OpaqueDeviceConfiguration.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("opaque", value)

        def requests(self, value: Optional[List[str]], /) -> Self:
            """
            Requests lists the names of requests where the configuration applies. If empty, it applies to all requests.
            """
            return self._set("requests", value)

    class BuilderContext(BuilderContextBase["DeviceClaimConfiguration.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = DeviceClaimConfiguration.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for DeviceClaimConfiguration."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["DeviceClaimConfiguration", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use DeviceClaimConfiguration.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    opaque: Optional[OpaqueDeviceConfiguration] = None
    """
    Opaque provides driver-specific configuration parameters.
    """
    requests: Optional[List[str]] = None
    """
    Requests lists the names of requests where the configuration applies. If empty, it applies to all requests.
    """


class DeviceClassConfiguration(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["DeviceClassConfiguration"]:
            return DeviceClassConfiguration

        def build(self) -> "DeviceClassConfiguration":
            return DeviceClassConfiguration(**self._attrs)

        @overload
        def opaque(
            self, value_or_callback: Optional[OpaqueDeviceConfiguration], /
        ) -> "DeviceClassConfiguration.Builder": ...

        @overload
        def opaque(
            self,
            value_or_callback: Callable[
                [OpaqueDeviceConfiguration.Builder],
                OpaqueDeviceConfiguration.Builder | OpaqueDeviceConfiguration,
            ],
            /,
        ) -> "DeviceClassConfiguration.Builder": ...

        @overload
        def opaque(
            self, value_or_callback: Never = ...
        ) -> "OpaqueDeviceConfiguration.BuilderContext": ...

        def opaque(self, value_or_callback=None, /):
            """
            Opaque provides driver-specific configuration parameters.
            """
            if self._in_context and value_or_callback is None:
                context = OpaqueDeviceConfiguration.BuilderContext()
                context._parent_builder = self
                context._field_name = "opaque"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(OpaqueDeviceConfiguration.builder())
                if isinstance(output, OpaqueDeviceConfiguration.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("opaque", value)

    class BuilderContext(BuilderContextBase["DeviceClassConfiguration.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = DeviceClassConfiguration.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for DeviceClassConfiguration."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["DeviceClassConfiguration", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use DeviceClassConfiguration.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    opaque: Optional[OpaqueDeviceConfiguration] = None
    """
    Opaque provides driver-specific configuration parameters.
    """


class DeviceClassSpec(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["DeviceClassSpec"]:
            return DeviceClassSpec

        def build(self) -> "DeviceClassSpec":
            return DeviceClassSpec(**self._attrs)

        @overload
        def config(
            self, value_or_callback: List[DeviceClassConfiguration], /
        ) -> "DeviceClassSpec.Builder": ...

        @overload
        def config(
            self,
            value_or_callback: Callable[
                [GenericListBuilder[DeviceClassConfiguration, DeviceClassConfiguration.Builder]],
                GenericListBuilder[DeviceClassConfiguration, DeviceClassConfiguration.Builder]
                | List[DeviceClassConfiguration],
            ],
            /,
        ) -> "DeviceClassSpec.Builder": ...

        @overload
        def config(
            self, value_or_callback: Never = ...
        ) -> ListBuilderContext[DeviceClassConfiguration.Builder]: ...

        def config(self, value_or_callback=None, /):
            """
            Config defines configuration parameters that apply to each device that is claimed via this class. Some classses may potentially be satisfied by multiple drivers, so each instance of a vendor configuration applies to exactly one driver.

            They are passed to the driver, but are not considered while allocating the claim.
            """
            if self._in_context and value_or_callback is None:
                context = ListBuilderContext[DeviceClassConfiguration.Builder]()
                context._parent_builder = self
                context._field_name = "config"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(DeviceClassConfiguration.list_builder())
                if isinstance(output, GenericListBuilder):
                    value = output.build()
                else:
                    value = output
            return self._set("config", value)

        @overload
        def selectors(
            self, value_or_callback: List[DeviceSelector], /
        ) -> "DeviceClassSpec.Builder": ...

        @overload
        def selectors(
            self,
            value_or_callback: Callable[
                [GenericListBuilder[DeviceSelector, DeviceSelector.Builder]],
                GenericListBuilder[DeviceSelector, DeviceSelector.Builder] | List[DeviceSelector],
            ],
            /,
        ) -> "DeviceClassSpec.Builder": ...

        @overload
        def selectors(
            self, value_or_callback: Never = ...
        ) -> ListBuilderContext[DeviceSelector.Builder]: ...

        def selectors(self, value_or_callback=None, /):
            """
            Each selector must be satisfied by a device which is claimed via this class.
            """
            if self._in_context and value_or_callback is None:
                context = ListBuilderContext[DeviceSelector.Builder]()
                context._parent_builder = self
                context._field_name = "selectors"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(DeviceSelector.list_builder())
                if isinstance(output, GenericListBuilder):
                    value = output.build()
                else:
                    value = output
            return self._set("selectors", value)

        @overload
        def suitable_nodes(
            self, value_or_callback: Optional[v1.NodeSelector], /
        ) -> "DeviceClassSpec.Builder": ...

        @overload
        def suitable_nodes(
            self,
            value_or_callback: Callable[
                [v1.NodeSelector.Builder], v1.NodeSelector.Builder | v1.NodeSelector
            ],
            /,
        ) -> "DeviceClassSpec.Builder": ...

        @overload
        def suitable_nodes(
            self, value_or_callback: Never = ...
        ) -> "v1.NodeSelector.BuilderContext": ...

        def suitable_nodes(self, value_or_callback=None, /):
            """
            Only nodes matching the selector will be considered by the scheduler when trying to find a Node that fits a Pod when that Pod uses a claim that has not been allocated yet *and* that claim gets allocated through a control plane controller. It is ignored when the claim does not use a control plane controller for allocation.

            Setting this field is optional. If unset, all Nodes are candidates.

            This is an alpha field and requires enabling the DRAControlPlaneController feature gate.
            """
            if self._in_context and value_or_callback is None:
                context = v1.NodeSelector.BuilderContext()
                context._parent_builder = self
                context._field_name = "suitable_nodes"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(v1.NodeSelector.builder())
                if isinstance(output, v1.NodeSelector.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("suitable_nodes", value)

    class BuilderContext(BuilderContextBase["DeviceClassSpec.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = DeviceClassSpec.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for DeviceClassSpec."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["DeviceClassSpec", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use DeviceClassSpec.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    config: Optional[List[DeviceClassConfiguration]] = None
    """
    Config defines configuration parameters that apply to each device that is claimed via this class. Some classses may potentially be satisfied by multiple drivers, so each instance of a vendor configuration applies to exactly one driver.

    They are passed to the driver, but are not considered while allocating the claim.
    """
    selectors: Optional[List[DeviceSelector]] = None
    """
    Each selector must be satisfied by a device which is claimed via this class.
    """
    suitable_nodes: Annotated[Optional[v1.NodeSelector], Field(alias="suitableNodes")] = None
    """
    Only nodes matching the selector will be considered by the scheduler when trying to find a Node that fits a Pod when that Pod uses a claim that has not been allocated yet *and* that claim gets allocated through a control plane controller. It is ignored when the claim does not use a control plane controller for allocation.

    Setting this field is optional. If unset, all Nodes are candidates.

    This is an alpha field and requires enabling the DRAControlPlaneController feature gate.
    """


class PodSchedulingContext(Resource):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["PodSchedulingContext"]:
            return PodSchedulingContext

        def build(self) -> "PodSchedulingContext":
            return PodSchedulingContext(**self._attrs)

        def api_version(self, value: Optional[Literal["resource.k8s.io/v1alpha3"]], /) -> Self:
            """
            APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
            """
            return self._set("api_version", value)

        def kind(self, value: Optional[Literal["PodSchedulingContext"]], /) -> Self:
            """
            Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
            """
            return self._set("kind", value)

        @overload
        def metadata(
            self, value_or_callback: Optional[apimachinery.ObjectMeta], /
        ) -> "PodSchedulingContext.Builder": ...

        @overload
        def metadata(
            self,
            value_or_callback: Callable[
                [apimachinery.ObjectMeta.Builder],
                apimachinery.ObjectMeta.Builder | apimachinery.ObjectMeta,
            ],
            /,
        ) -> "PodSchedulingContext.Builder": ...

        @overload
        def metadata(
            self, value_or_callback: Never = ...
        ) -> "apimachinery.ObjectMeta.BuilderContext": ...

        def metadata(self, value_or_callback=None, /):
            """
            Standard object metadata
            """
            if self._in_context and value_or_callback is None:
                context = apimachinery.ObjectMeta.BuilderContext()
                context._parent_builder = self
                context._field_name = "metadata"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(apimachinery.ObjectMeta.builder())
                if isinstance(output, apimachinery.ObjectMeta.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("metadata", value)

        @overload
        def spec(
            self, value_or_callback: PodSchedulingContextSpec, /
        ) -> "PodSchedulingContext.Builder": ...

        @overload
        def spec(
            self,
            value_or_callback: Callable[
                [PodSchedulingContextSpec.Builder],
                PodSchedulingContextSpec.Builder | PodSchedulingContextSpec,
            ],
            /,
        ) -> "PodSchedulingContext.Builder": ...

        @overload
        def spec(
            self, value_or_callback: Never = ...
        ) -> "PodSchedulingContextSpec.BuilderContext": ...

        def spec(self, value_or_callback=None, /):
            """
            Spec describes where resources for the Pod are needed.
            """
            if self._in_context and value_or_callback is None:
                context = PodSchedulingContextSpec.BuilderContext()
                context._parent_builder = self
                context._field_name = "spec"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(PodSchedulingContextSpec.builder())
                if isinstance(output, PodSchedulingContextSpec.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("spec", value)

        @overload
        def status(
            self, value_or_callback: Optional[PodSchedulingContextStatus], /
        ) -> "PodSchedulingContext.Builder": ...

        @overload
        def status(
            self,
            value_or_callback: Callable[
                [PodSchedulingContextStatus.Builder],
                PodSchedulingContextStatus.Builder | PodSchedulingContextStatus,
            ],
            /,
        ) -> "PodSchedulingContext.Builder": ...

        @overload
        def status(
            self, value_or_callback: Never = ...
        ) -> "PodSchedulingContextStatus.BuilderContext": ...

        def status(self, value_or_callback=None, /):
            """
            Status describes where resources for the Pod can be allocated.
            """
            if self._in_context and value_or_callback is None:
                context = PodSchedulingContextStatus.BuilderContext()
                context._parent_builder = self
                context._field_name = "status"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(PodSchedulingContextStatus.builder())
                if isinstance(output, PodSchedulingContextStatus.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("status", value)

    class BuilderContext(BuilderContextBase["PodSchedulingContext.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = PodSchedulingContext.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for PodSchedulingContext."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["PodSchedulingContext", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use PodSchedulingContext.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    api_version: Annotated[
        Optional[Literal["resource.k8s.io/v1alpha3"]], Field(alias="apiVersion")
    ] = "resource.k8s.io/v1alpha3"
    """
    APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
    """
    kind: Optional[Literal["PodSchedulingContext"]] = "PodSchedulingContext"
    """
    Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
    """
    metadata: Optional[apimachinery.ObjectMeta] = None
    """
    Standard object metadata
    """
    spec: PodSchedulingContextSpec
    """
    Spec describes where resources for the Pod are needed.
    """
    status: Optional[PodSchedulingContextStatus] = None
    """
    Status describes where resources for the Pod can be allocated.
    """


PodSchedulingContextList = ResourceList["PodSchedulingContext"]


class ResourceSlice(Resource):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["ResourceSlice"]:
            return ResourceSlice

        def build(self) -> "ResourceSlice":
            return ResourceSlice(**self._attrs)

        def api_version(self, value: Optional[Literal["resource.k8s.io/v1alpha3"]], /) -> Self:
            """
            APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
            """
            return self._set("api_version", value)

        def kind(self, value: Optional[Literal["ResourceSlice"]], /) -> Self:
            """
            Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
            """
            return self._set("kind", value)

        @overload
        def metadata(
            self, value_or_callback: Optional[apimachinery.ObjectMeta], /
        ) -> "ResourceSlice.Builder": ...

        @overload
        def metadata(
            self,
            value_or_callback: Callable[
                [apimachinery.ObjectMeta.Builder],
                apimachinery.ObjectMeta.Builder | apimachinery.ObjectMeta,
            ],
            /,
        ) -> "ResourceSlice.Builder": ...

        @overload
        def metadata(
            self, value_or_callback: Never = ...
        ) -> "apimachinery.ObjectMeta.BuilderContext": ...

        def metadata(self, value_or_callback=None, /):
            """
            Standard object metadata
            """
            if self._in_context and value_or_callback is None:
                context = apimachinery.ObjectMeta.BuilderContext()
                context._parent_builder = self
                context._field_name = "metadata"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(apimachinery.ObjectMeta.builder())
                if isinstance(output, apimachinery.ObjectMeta.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("metadata", value)

        @overload
        def spec(self, value_or_callback: ResourceSliceSpec, /) -> "ResourceSlice.Builder": ...

        @overload
        def spec(
            self,
            value_or_callback: Callable[
                [ResourceSliceSpec.Builder],
                ResourceSliceSpec.Builder | ResourceSliceSpec,
            ],
            /,
        ) -> "ResourceSlice.Builder": ...

        @overload
        def spec(self, value_or_callback: Never = ...) -> "ResourceSliceSpec.BuilderContext": ...

        def spec(self, value_or_callback=None, /):
            """
            Contains the information published by the driver.

            Changing the spec automatically increments the metadata.generation number.
            """
            if self._in_context and value_or_callback is None:
                context = ResourceSliceSpec.BuilderContext()
                context._parent_builder = self
                context._field_name = "spec"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(ResourceSliceSpec.builder())
                if isinstance(output, ResourceSliceSpec.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("spec", value)

    class BuilderContext(BuilderContextBase["ResourceSlice.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = ResourceSlice.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for ResourceSlice."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["ResourceSlice", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use ResourceSlice.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    api_version: Annotated[
        Optional[Literal["resource.k8s.io/v1alpha3"]], Field(alias="apiVersion")
    ] = "resource.k8s.io/v1alpha3"
    """
    APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
    """
    kind: Optional[Literal["ResourceSlice"]] = "ResourceSlice"
    """
    Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
    """
    metadata: Optional[apimachinery.ObjectMeta] = None
    """
    Standard object metadata
    """
    spec: ResourceSliceSpec
    """
    Contains the information published by the driver.

    Changing the spec automatically increments the metadata.generation number.
    """


ResourceSliceList = ResourceList["ResourceSlice"]


class AllocationResult(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["AllocationResult"]:
            return AllocationResult

        def build(self) -> "AllocationResult":
            return AllocationResult(**self._attrs)

        def controller(self, value: Optional[str], /) -> Self:
            """
            Controller is the name of the DRA driver which handled the allocation. That driver is also responsible for deallocating the claim. It is empty when the claim can be deallocated without involving a driver.

            A driver may allocate devices provided by other drivers, so this driver name here can be different from the driver names listed for the results.

            This is an alpha field and requires enabling the DRAControlPlaneController feature gate.
            """
            return self._set("controller", value)

        @overload
        def devices(
            self, value_or_callback: Optional[DeviceAllocationResult], /
        ) -> "AllocationResult.Builder": ...

        @overload
        def devices(
            self,
            value_or_callback: Callable[
                [DeviceAllocationResult.Builder],
                DeviceAllocationResult.Builder | DeviceAllocationResult,
            ],
            /,
        ) -> "AllocationResult.Builder": ...

        @overload
        def devices(
            self, value_or_callback: Never = ...
        ) -> "DeviceAllocationResult.BuilderContext": ...

        def devices(self, value_or_callback=None, /):
            """
            Devices is the result of allocating devices.
            """
            if self._in_context and value_or_callback is None:
                context = DeviceAllocationResult.BuilderContext()
                context._parent_builder = self
                context._field_name = "devices"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(DeviceAllocationResult.builder())
                if isinstance(output, DeviceAllocationResult.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("devices", value)

        @overload
        def node_selector(
            self, value_or_callback: Optional[v1.NodeSelector], /
        ) -> "AllocationResult.Builder": ...

        @overload
        def node_selector(
            self,
            value_or_callback: Callable[
                [v1.NodeSelector.Builder], v1.NodeSelector.Builder | v1.NodeSelector
            ],
            /,
        ) -> "AllocationResult.Builder": ...

        @overload
        def node_selector(
            self, value_or_callback: Never = ...
        ) -> "v1.NodeSelector.BuilderContext": ...

        def node_selector(self, value_or_callback=None, /):
            """
            NodeSelector defines where the allocated resources are available. If unset, they are available everywhere.
            """
            if self._in_context and value_or_callback is None:
                context = v1.NodeSelector.BuilderContext()
                context._parent_builder = self
                context._field_name = "node_selector"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(v1.NodeSelector.builder())
                if isinstance(output, v1.NodeSelector.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("node_selector", value)

    class BuilderContext(BuilderContextBase["AllocationResult.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = AllocationResult.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for AllocationResult."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["AllocationResult", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use AllocationResult.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    controller: Optional[str] = None
    """
    Controller is the name of the DRA driver which handled the allocation. That driver is also responsible for deallocating the claim. It is empty when the claim can be deallocated without involving a driver.

    A driver may allocate devices provided by other drivers, so this driver name here can be different from the driver names listed for the results.

    This is an alpha field and requires enabling the DRAControlPlaneController feature gate.
    """
    devices: Optional[DeviceAllocationResult] = None
    """
    Devices is the result of allocating devices.
    """
    node_selector: Annotated[Optional[v1.NodeSelector], Field(alias="nodeSelector")] = None
    """
    NodeSelector defines where the allocated resources are available. If unset, they are available everywhere.
    """


class DeviceClaim(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["DeviceClaim"]:
            return DeviceClaim

        def build(self) -> "DeviceClaim":
            return DeviceClaim(**self._attrs)

        @overload
        def config(
            self, value_or_callback: List[DeviceClaimConfiguration], /
        ) -> "DeviceClaim.Builder": ...

        @overload
        def config(
            self,
            value_or_callback: Callable[
                [GenericListBuilder[DeviceClaimConfiguration, DeviceClaimConfiguration.Builder]],
                GenericListBuilder[DeviceClaimConfiguration, DeviceClaimConfiguration.Builder]
                | List[DeviceClaimConfiguration],
            ],
            /,
        ) -> "DeviceClaim.Builder": ...

        @overload
        def config(
            self, value_or_callback: Never = ...
        ) -> ListBuilderContext[DeviceClaimConfiguration.Builder]: ...

        def config(self, value_or_callback=None, /):
            """
            This field holds configuration for multiple potential drivers which could satisfy requests in this claim. It is ignored while allocating the claim.
            """
            if self._in_context and value_or_callback is None:
                context = ListBuilderContext[DeviceClaimConfiguration.Builder]()
                context._parent_builder = self
                context._field_name = "config"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(DeviceClaimConfiguration.list_builder())
                if isinstance(output, GenericListBuilder):
                    value = output.build()
                else:
                    value = output
            return self._set("config", value)

        @overload
        def constraints(
            self, value_or_callback: List[DeviceConstraint], /
        ) -> "DeviceClaim.Builder": ...

        @overload
        def constraints(
            self,
            value_or_callback: Callable[
                [GenericListBuilder[DeviceConstraint, DeviceConstraint.Builder]],
                GenericListBuilder[DeviceConstraint, DeviceConstraint.Builder]
                | List[DeviceConstraint],
            ],
            /,
        ) -> "DeviceClaim.Builder": ...

        @overload
        def constraints(
            self, value_or_callback: Never = ...
        ) -> ListBuilderContext[DeviceConstraint.Builder]: ...

        def constraints(self, value_or_callback=None, /):
            """
            These constraints must be satisfied by the set of devices that get allocated for the claim.
            """
            if self._in_context and value_or_callback is None:
                context = ListBuilderContext[DeviceConstraint.Builder]()
                context._parent_builder = self
                context._field_name = "constraints"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(DeviceConstraint.list_builder())
                if isinstance(output, GenericListBuilder):
                    value = output.build()
                else:
                    value = output
            return self._set("constraints", value)

        @overload
        def requests(self, value_or_callback: List[DeviceRequest], /) -> "DeviceClaim.Builder": ...

        @overload
        def requests(
            self,
            value_or_callback: Callable[
                [GenericListBuilder[DeviceRequest, DeviceRequest.Builder]],
                GenericListBuilder[DeviceRequest, DeviceRequest.Builder] | List[DeviceRequest],
            ],
            /,
        ) -> "DeviceClaim.Builder": ...

        @overload
        def requests(
            self, value_or_callback: Never = ...
        ) -> ListBuilderContext[DeviceRequest.Builder]: ...

        def requests(self, value_or_callback=None, /):
            """
            Requests represent individual requests for distinct devices which must all be satisfied. If empty, nothing needs to be allocated.
            """
            if self._in_context and value_or_callback is None:
                context = ListBuilderContext[DeviceRequest.Builder]()
                context._parent_builder = self
                context._field_name = "requests"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(DeviceRequest.list_builder())
                if isinstance(output, GenericListBuilder):
                    value = output.build()
                else:
                    value = output
            return self._set("requests", value)

    class BuilderContext(BuilderContextBase["DeviceClaim.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = DeviceClaim.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for DeviceClaim."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["DeviceClaim", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use DeviceClaim.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    config: Optional[List[DeviceClaimConfiguration]] = None
    """
    This field holds configuration for multiple potential drivers which could satisfy requests in this claim. It is ignored while allocating the claim.
    """
    constraints: Optional[List[DeviceConstraint]] = None
    """
    These constraints must be satisfied by the set of devices that get allocated for the claim.
    """
    requests: Optional[List[DeviceRequest]] = None
    """
    Requests represent individual requests for distinct devices which must all be satisfied. If empty, nothing needs to be allocated.
    """


class DeviceClass(Resource):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["DeviceClass"]:
            return DeviceClass

        def build(self) -> "DeviceClass":
            return DeviceClass(**self._attrs)

        def api_version(self, value: Optional[Literal["resource.k8s.io/v1alpha3"]], /) -> Self:
            """
            APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
            """
            return self._set("api_version", value)

        def kind(self, value: Optional[Literal["DeviceClass"]], /) -> Self:
            """
            Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
            """
            return self._set("kind", value)

        @overload
        def metadata(
            self, value_or_callback: Optional[apimachinery.ObjectMeta], /
        ) -> "DeviceClass.Builder": ...

        @overload
        def metadata(
            self,
            value_or_callback: Callable[
                [apimachinery.ObjectMeta.Builder],
                apimachinery.ObjectMeta.Builder | apimachinery.ObjectMeta,
            ],
            /,
        ) -> "DeviceClass.Builder": ...

        @overload
        def metadata(
            self, value_or_callback: Never = ...
        ) -> "apimachinery.ObjectMeta.BuilderContext": ...

        def metadata(self, value_or_callback=None, /):
            """
            Standard object metadata
            """
            if self._in_context and value_or_callback is None:
                context = apimachinery.ObjectMeta.BuilderContext()
                context._parent_builder = self
                context._field_name = "metadata"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(apimachinery.ObjectMeta.builder())
                if isinstance(output, apimachinery.ObjectMeta.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("metadata", value)

        @overload
        def spec(self, value_or_callback: DeviceClassSpec, /) -> "DeviceClass.Builder": ...

        @overload
        def spec(
            self,
            value_or_callback: Callable[
                [DeviceClassSpec.Builder], DeviceClassSpec.Builder | DeviceClassSpec
            ],
            /,
        ) -> "DeviceClass.Builder": ...

        @overload
        def spec(self, value_or_callback: Never = ...) -> "DeviceClassSpec.BuilderContext": ...

        def spec(self, value_or_callback=None, /):
            """
            Spec defines what can be allocated and how to configure it.

            This is mutable. Consumers have to be prepared for classes changing at any time, either because they get updated or replaced. Claim allocations are done once based on whatever was set in classes at the time of allocation.

            Changing the spec automatically increments the metadata.generation number.
            """
            if self._in_context and value_or_callback is None:
                context = DeviceClassSpec.BuilderContext()
                context._parent_builder = self
                context._field_name = "spec"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(DeviceClassSpec.builder())
                if isinstance(output, DeviceClassSpec.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("spec", value)

    class BuilderContext(BuilderContextBase["DeviceClass.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = DeviceClass.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for DeviceClass."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["DeviceClass", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use DeviceClass.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    api_version: Annotated[
        Optional[Literal["resource.k8s.io/v1alpha3"]], Field(alias="apiVersion")
    ] = "resource.k8s.io/v1alpha3"
    """
    APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
    """
    kind: Optional[Literal["DeviceClass"]] = "DeviceClass"
    """
    Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
    """
    metadata: Optional[apimachinery.ObjectMeta] = None
    """
    Standard object metadata
    """
    spec: DeviceClassSpec
    """
    Spec defines what can be allocated and how to configure it.

    This is mutable. Consumers have to be prepared for classes changing at any time, either because they get updated or replaced. Claim allocations are done once based on whatever was set in classes at the time of allocation.

    Changing the spec automatically increments the metadata.generation number.
    """


DeviceClassList = ResourceList["DeviceClass"]


class ResourceClaimSpec(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["ResourceClaimSpec"]:
            return ResourceClaimSpec

        def build(self) -> "ResourceClaimSpec":
            return ResourceClaimSpec(**self._attrs)

        def controller(self, value: Optional[str], /) -> Self:
            """
            Controller is the name of the DRA driver that is meant to handle allocation of this claim. If empty, allocation is handled by the scheduler while scheduling a pod.

            Must be a DNS subdomain and should end with a DNS domain owned by the vendor of the driver.

            This is an alpha field and requires enabling the DRAControlPlaneController feature gate.
            """
            return self._set("controller", value)

        @overload
        def devices(
            self, value_or_callback: Optional[DeviceClaim], /
        ) -> "ResourceClaimSpec.Builder": ...

        @overload
        def devices(
            self,
            value_or_callback: Callable[[DeviceClaim.Builder], DeviceClaim.Builder | DeviceClaim],
            /,
        ) -> "ResourceClaimSpec.Builder": ...

        @overload
        def devices(self, value_or_callback: Never = ...) -> "DeviceClaim.BuilderContext": ...

        def devices(self, value_or_callback=None, /):
            """
            Devices defines how to request devices.
            """
            if self._in_context and value_or_callback is None:
                context = DeviceClaim.BuilderContext()
                context._parent_builder = self
                context._field_name = "devices"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(DeviceClaim.builder())
                if isinstance(output, DeviceClaim.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("devices", value)

    class BuilderContext(BuilderContextBase["ResourceClaimSpec.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = ResourceClaimSpec.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for ResourceClaimSpec."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["ResourceClaimSpec", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use ResourceClaimSpec.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    controller: Optional[str] = None
    """
    Controller is the name of the DRA driver that is meant to handle allocation of this claim. If empty, allocation is handled by the scheduler while scheduling a pod.

    Must be a DNS subdomain and should end with a DNS domain owned by the vendor of the driver.

    This is an alpha field and requires enabling the DRAControlPlaneController feature gate.
    """
    devices: Optional[DeviceClaim] = None
    """
    Devices defines how to request devices.
    """


class ResourceClaimStatus(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["ResourceClaimStatus"]:
            return ResourceClaimStatus

        def build(self) -> "ResourceClaimStatus":
            return ResourceClaimStatus(**self._attrs)

        @overload
        def allocation(
            self, value_or_callback: Optional[AllocationResult], /
        ) -> "ResourceClaimStatus.Builder": ...

        @overload
        def allocation(
            self,
            value_or_callback: Callable[
                [AllocationResult.Builder], AllocationResult.Builder | AllocationResult
            ],
            /,
        ) -> "ResourceClaimStatus.Builder": ...

        @overload
        def allocation(
            self, value_or_callback: Never = ...
        ) -> "AllocationResult.BuilderContext": ...

        def allocation(self, value_or_callback=None, /):
            """
            Allocation is set once the claim has been allocated successfully.
            """
            if self._in_context and value_or_callback is None:
                context = AllocationResult.BuilderContext()
                context._parent_builder = self
                context._field_name = "allocation"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(AllocationResult.builder())
                if isinstance(output, AllocationResult.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("allocation", value)

        def deallocation_requested(self, value: Optional[bool], /) -> Self:
            """
            Indicates that a claim is to be deallocated. While this is set, no new consumers may be added to ReservedFor.

            This is only used if the claim needs to be deallocated by a DRA driver. That driver then must deallocate this claim and reset the field together with clearing the Allocation field.

            This is an alpha field and requires enabling the DRAControlPlaneController feature gate.
            """
            return self._set("deallocation_requested", value)

        @overload
        def reserved_for(
            self, value_or_callback: List[ResourceClaimConsumerReference], /
        ) -> "ResourceClaimStatus.Builder": ...

        @overload
        def reserved_for(
            self,
            value_or_callback: Callable[
                [
                    GenericListBuilder[
                        ResourceClaimConsumerReference,
                        ResourceClaimConsumerReference.Builder,
                    ]
                ],
                GenericListBuilder[
                    ResourceClaimConsumerReference,
                    ResourceClaimConsumerReference.Builder,
                ]
                | List[ResourceClaimConsumerReference],
            ],
            /,
        ) -> "ResourceClaimStatus.Builder": ...

        @overload
        def reserved_for(
            self, value_or_callback: Never = ...
        ) -> ListBuilderContext[ResourceClaimConsumerReference.Builder]: ...

        def reserved_for(self, value_or_callback=None, /):
            """
            ReservedFor indicates which entities are currently allowed to use the claim. A Pod which references a ResourceClaim which is not reserved for that Pod will not be started. A claim that is in use or might be in use because it has been reserved must not get deallocated.

            In a cluster with multiple scheduler instances, two pods might get scheduled concurrently by different schedulers. When they reference the same ResourceClaim which already has reached its maximum number of consumers, only one pod can be scheduled.

            Both schedulers try to add their pod to the claim.status.reservedFor field, but only the update that reaches the API server first gets stored. The other one fails with an error and the scheduler which issued it knows that it must put the pod back into the queue, waiting for the ResourceClaim to become usable again.

            There can be at most 32 such reservations. This may get increased in the future, but not reduced.
            """
            if self._in_context and value_or_callback is None:
                context = ListBuilderContext[ResourceClaimConsumerReference.Builder]()
                context._parent_builder = self
                context._field_name = "reserved_for"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(ResourceClaimConsumerReference.list_builder())
                if isinstance(output, GenericListBuilder):
                    value = output.build()
                else:
                    value = output
            return self._set("reserved_for", value)

    class BuilderContext(BuilderContextBase["ResourceClaimStatus.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = ResourceClaimStatus.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for ResourceClaimStatus."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["ResourceClaimStatus", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use ResourceClaimStatus.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    allocation: Optional[AllocationResult] = None
    """
    Allocation is set once the claim has been allocated successfully.
    """
    deallocation_requested: Annotated[Optional[bool], Field(alias="deallocationRequested")] = None
    """
    Indicates that a claim is to be deallocated. While this is set, no new consumers may be added to ReservedFor.

    This is only used if the claim needs to be deallocated by a DRA driver. That driver then must deallocate this claim and reset the field together with clearing the Allocation field.

    This is an alpha field and requires enabling the DRAControlPlaneController feature gate.
    """
    reserved_for: Annotated[
        Optional[List[ResourceClaimConsumerReference]], Field(alias="reservedFor")
    ] = None
    """
    ReservedFor indicates which entities are currently allowed to use the claim. A Pod which references a ResourceClaim which is not reserved for that Pod will not be started. A claim that is in use or might be in use because it has been reserved must not get deallocated.

    In a cluster with multiple scheduler instances, two pods might get scheduled concurrently by different schedulers. When they reference the same ResourceClaim which already has reached its maximum number of consumers, only one pod can be scheduled.

    Both schedulers try to add their pod to the claim.status.reservedFor field, but only the update that reaches the API server first gets stored. The other one fails with an error and the scheduler which issued it knows that it must put the pod back into the queue, waiting for the ResourceClaim to become usable again.

    There can be at most 32 such reservations. This may get increased in the future, but not reduced.
    """


class ResourceClaimTemplateSpec(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["ResourceClaimTemplateSpec"]:
            return ResourceClaimTemplateSpec

        def build(self) -> "ResourceClaimTemplateSpec":
            return ResourceClaimTemplateSpec(**self._attrs)

        @overload
        def metadata(
            self, value_or_callback: Optional[apimachinery.ObjectMeta], /
        ) -> "ResourceClaimTemplateSpec.Builder": ...

        @overload
        def metadata(
            self,
            value_or_callback: Callable[
                [apimachinery.ObjectMeta.Builder],
                apimachinery.ObjectMeta.Builder | apimachinery.ObjectMeta,
            ],
            /,
        ) -> "ResourceClaimTemplateSpec.Builder": ...

        @overload
        def metadata(
            self, value_or_callback: Never = ...
        ) -> "apimachinery.ObjectMeta.BuilderContext": ...

        def metadata(self, value_or_callback=None, /):
            """
            ObjectMeta may contain labels and annotations that will be copied into the PVC when creating it. No other fields are allowed and will be rejected during validation.
            """
            if self._in_context and value_or_callback is None:
                context = apimachinery.ObjectMeta.BuilderContext()
                context._parent_builder = self
                context._field_name = "metadata"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(apimachinery.ObjectMeta.builder())
                if isinstance(output, apimachinery.ObjectMeta.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("metadata", value)

        @overload
        def spec(
            self, value_or_callback: ResourceClaimSpec, /
        ) -> "ResourceClaimTemplateSpec.Builder": ...

        @overload
        def spec(
            self,
            value_or_callback: Callable[
                [ResourceClaimSpec.Builder],
                ResourceClaimSpec.Builder | ResourceClaimSpec,
            ],
            /,
        ) -> "ResourceClaimTemplateSpec.Builder": ...

        @overload
        def spec(self, value_or_callback: Never = ...) -> "ResourceClaimSpec.BuilderContext": ...

        def spec(self, value_or_callback=None, /):
            """
            Spec for the ResourceClaim. The entire content is copied unchanged into the ResourceClaim that gets created from this template. The same fields as in a ResourceClaim are also valid here.
            """
            if self._in_context and value_or_callback is None:
                context = ResourceClaimSpec.BuilderContext()
                context._parent_builder = self
                context._field_name = "spec"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(ResourceClaimSpec.builder())
                if isinstance(output, ResourceClaimSpec.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("spec", value)

    class BuilderContext(BuilderContextBase["ResourceClaimTemplateSpec.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = ResourceClaimTemplateSpec.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for ResourceClaimTemplateSpec."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["ResourceClaimTemplateSpec", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use ResourceClaimTemplateSpec.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    metadata: Optional[apimachinery.ObjectMeta] = None
    """
    ObjectMeta may contain labels and annotations that will be copied into the PVC when creating it. No other fields are allowed and will be rejected during validation.
    """
    spec: ResourceClaimSpec
    """
    Spec for the ResourceClaim. The entire content is copied unchanged into the ResourceClaim that gets created from this template. The same fields as in a ResourceClaim are also valid here.
    """


class ResourceClaim(Resource):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["ResourceClaim"]:
            return ResourceClaim

        def build(self) -> "ResourceClaim":
            return ResourceClaim(**self._attrs)

        def api_version(self, value: Optional[Literal["resource.k8s.io/v1alpha3"]], /) -> Self:
            """
            APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
            """
            return self._set("api_version", value)

        def kind(self, value: Optional[Literal["ResourceClaim"]], /) -> Self:
            """
            Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
            """
            return self._set("kind", value)

        @overload
        def metadata(
            self, value_or_callback: Optional[apimachinery.ObjectMeta], /
        ) -> "ResourceClaim.Builder": ...

        @overload
        def metadata(
            self,
            value_or_callback: Callable[
                [apimachinery.ObjectMeta.Builder],
                apimachinery.ObjectMeta.Builder | apimachinery.ObjectMeta,
            ],
            /,
        ) -> "ResourceClaim.Builder": ...

        @overload
        def metadata(
            self, value_or_callback: Never = ...
        ) -> "apimachinery.ObjectMeta.BuilderContext": ...

        def metadata(self, value_or_callback=None, /):
            """
            Standard object metadata
            """
            if self._in_context and value_or_callback is None:
                context = apimachinery.ObjectMeta.BuilderContext()
                context._parent_builder = self
                context._field_name = "metadata"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(apimachinery.ObjectMeta.builder())
                if isinstance(output, apimachinery.ObjectMeta.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("metadata", value)

        @overload
        def spec(self, value_or_callback: ResourceClaimSpec, /) -> "ResourceClaim.Builder": ...

        @overload
        def spec(
            self,
            value_or_callback: Callable[
                [ResourceClaimSpec.Builder],
                ResourceClaimSpec.Builder | ResourceClaimSpec,
            ],
            /,
        ) -> "ResourceClaim.Builder": ...

        @overload
        def spec(self, value_or_callback: Never = ...) -> "ResourceClaimSpec.BuilderContext": ...

        def spec(self, value_or_callback=None, /):
            """
            Spec describes what is being requested and how to configure it. The spec is immutable.
            """
            if self._in_context and value_or_callback is None:
                context = ResourceClaimSpec.BuilderContext()
                context._parent_builder = self
                context._field_name = "spec"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(ResourceClaimSpec.builder())
                if isinstance(output, ResourceClaimSpec.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("spec", value)

        @overload
        def status(
            self, value_or_callback: Optional[ResourceClaimStatus], /
        ) -> "ResourceClaim.Builder": ...

        @overload
        def status(
            self,
            value_or_callback: Callable[
                [ResourceClaimStatus.Builder],
                ResourceClaimStatus.Builder | ResourceClaimStatus,
            ],
            /,
        ) -> "ResourceClaim.Builder": ...

        @overload
        def status(
            self, value_or_callback: Never = ...
        ) -> "ResourceClaimStatus.BuilderContext": ...

        def status(self, value_or_callback=None, /):
            """
            Status describes whether the claim is ready to use and what has been allocated.
            """
            if self._in_context and value_or_callback is None:
                context = ResourceClaimStatus.BuilderContext()
                context._parent_builder = self
                context._field_name = "status"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(ResourceClaimStatus.builder())
                if isinstance(output, ResourceClaimStatus.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("status", value)

    class BuilderContext(BuilderContextBase["ResourceClaim.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = ResourceClaim.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for ResourceClaim."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["ResourceClaim", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use ResourceClaim.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    api_version: Annotated[
        Optional[Literal["resource.k8s.io/v1alpha3"]], Field(alias="apiVersion")
    ] = "resource.k8s.io/v1alpha3"
    """
    APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
    """
    kind: Optional[Literal["ResourceClaim"]] = "ResourceClaim"
    """
    Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
    """
    metadata: Optional[apimachinery.ObjectMeta] = None
    """
    Standard object metadata
    """
    spec: ResourceClaimSpec
    """
    Spec describes what is being requested and how to configure it. The spec is immutable.
    """
    status: Optional[ResourceClaimStatus] = None
    """
    Status describes whether the claim is ready to use and what has been allocated.
    """


ResourceClaimList = ResourceList["ResourceClaim"]


class ResourceClaimTemplate(Resource):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["ResourceClaimTemplate"]:
            return ResourceClaimTemplate

        def build(self) -> "ResourceClaimTemplate":
            return ResourceClaimTemplate(**self._attrs)

        def api_version(self, value: Optional[Literal["resource.k8s.io/v1alpha3"]], /) -> Self:
            """
            APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
            """
            return self._set("api_version", value)

        def kind(self, value: Optional[Literal["ResourceClaimTemplate"]], /) -> Self:
            """
            Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
            """
            return self._set("kind", value)

        @overload
        def metadata(
            self, value_or_callback: Optional[apimachinery.ObjectMeta], /
        ) -> "ResourceClaimTemplate.Builder": ...

        @overload
        def metadata(
            self,
            value_or_callback: Callable[
                [apimachinery.ObjectMeta.Builder],
                apimachinery.ObjectMeta.Builder | apimachinery.ObjectMeta,
            ],
            /,
        ) -> "ResourceClaimTemplate.Builder": ...

        @overload
        def metadata(
            self, value_or_callback: Never = ...
        ) -> "apimachinery.ObjectMeta.BuilderContext": ...

        def metadata(self, value_or_callback=None, /):
            """
            Standard object metadata
            """
            if self._in_context and value_or_callback is None:
                context = apimachinery.ObjectMeta.BuilderContext()
                context._parent_builder = self
                context._field_name = "metadata"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(apimachinery.ObjectMeta.builder())
                if isinstance(output, apimachinery.ObjectMeta.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("metadata", value)

        @overload
        def spec(
            self, value_or_callback: ResourceClaimTemplateSpec, /
        ) -> "ResourceClaimTemplate.Builder": ...

        @overload
        def spec(
            self,
            value_or_callback: Callable[
                [ResourceClaimTemplateSpec.Builder],
                ResourceClaimTemplateSpec.Builder | ResourceClaimTemplateSpec,
            ],
            /,
        ) -> "ResourceClaimTemplate.Builder": ...

        @overload
        def spec(
            self, value_or_callback: Never = ...
        ) -> "ResourceClaimTemplateSpec.BuilderContext": ...

        def spec(self, value_or_callback=None, /):
            """
            Describes the ResourceClaim that is to be generated.

            This field is immutable. A ResourceClaim will get created by the control plane for a Pod when needed and then not get updated anymore.
            """
            if self._in_context and value_or_callback is None:
                context = ResourceClaimTemplateSpec.BuilderContext()
                context._parent_builder = self
                context._field_name = "spec"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(ResourceClaimTemplateSpec.builder())
                if isinstance(output, ResourceClaimTemplateSpec.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("spec", value)

    class BuilderContext(BuilderContextBase["ResourceClaimTemplate.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = ResourceClaimTemplate.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for ResourceClaimTemplate."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["ResourceClaimTemplate", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use ResourceClaimTemplate.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    api_version: Annotated[
        Optional[Literal["resource.k8s.io/v1alpha3"]], Field(alias="apiVersion")
    ] = "resource.k8s.io/v1alpha3"
    """
    APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
    """
    kind: Optional[Literal["ResourceClaimTemplate"]] = "ResourceClaimTemplate"
    """
    Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
    """
    metadata: Optional[apimachinery.ObjectMeta] = None
    """
    Standard object metadata
    """
    spec: ResourceClaimTemplateSpec
    """
    Describes the ResourceClaim that is to be generated.

    This field is immutable. A ResourceClaim will get created by the control plane for a Pod when needed and then not get updated anymore.
    """


ResourceClaimTemplateList = ResourceList["ResourceClaimTemplate"]
