# Generated by cloudcoil-model-codegen v0.5.0
# DO NOT EDIT

from __future__ import annotations

from typing import (
    Annotated,
    Callable,
    List,
    Literal,
    Optional,
    Type,
    overload,
)

from pydantic import Field

from cloudcoil import apimachinery
from cloudcoil.pydantic import (
    BaseModel,
    BaseModelBuilder,
    BuilderContextBase,
    GenericListBuilder,
    ListBuilderContext,
    Never,
    Self,
)
from cloudcoil.resources import Resource, ResourceList


class PolicyRule(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["PolicyRule"]:
            return PolicyRule

        def build(self) -> "PolicyRule":
            return PolicyRule(**self._attrs)

        def api_groups(self, value: Optional[List[str]], /) -> Self:
            """
            APIGroups is the name of the APIGroup that contains the resources.  If multiple API groups are specified, any action requested against one of the enumerated resources in any API group will be allowed. "" represents the core API group and "*" represents all API groups.
            """
            return self._set("api_groups", value)

        def non_resource_ur_ls(self, value: Optional[List[str]], /) -> Self:
            """
            NonResourceURLs is a set of partial urls that a user should have access to.  *s are allowed, but only as the full, final step in the path Since non-resource URLs are not namespaced, this field is only applicable for ClusterRoles referenced from a ClusterRoleBinding. Rules can either apply to API resources (such as "pods" or "secrets") or non-resource URL paths (such as "/api"),  but not both.
            """
            return self._set("non_resource_ur_ls", value)

        def resource_names(self, value: Optional[List[str]], /) -> Self:
            """
            ResourceNames is an optional white list of names that the rule applies to.  An empty set means that everything is allowed.
            """
            return self._set("resource_names", value)

        def resources(self, value: Optional[List[str]], /) -> Self:
            """
            Resources is a list of resources this rule applies to. '*' represents all resources.
            """
            return self._set("resources", value)

        def verbs(self, value: List[str], /) -> Self:
            """
            Verbs is a list of Verbs that apply to ALL the ResourceKinds contained in this rule. '*' represents all verbs.
            """
            return self._set("verbs", value)

    class BuilderContext(BuilderContextBase["PolicyRule.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = PolicyRule.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for PolicyRule."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["PolicyRule", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use PolicyRule.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    api_groups: Annotated[Optional[List[str]], Field(alias="apiGroups")] = None
    """
    APIGroups is the name of the APIGroup that contains the resources.  If multiple API groups are specified, any action requested against one of the enumerated resources in any API group will be allowed. "" represents the core API group and "*" represents all API groups.
    """
    non_resource_ur_ls: Annotated[Optional[List[str]], Field(alias="nonResourceURLs")] = None
    """
    NonResourceURLs is a set of partial urls that a user should have access to.  *s are allowed, but only as the full, final step in the path Since non-resource URLs are not namespaced, this field is only applicable for ClusterRoles referenced from a ClusterRoleBinding. Rules can either apply to API resources (such as "pods" or "secrets") or non-resource URL paths (such as "/api"),  but not both.
    """
    resource_names: Annotated[Optional[List[str]], Field(alias="resourceNames")] = None
    """
    ResourceNames is an optional white list of names that the rule applies to.  An empty set means that everything is allowed.
    """
    resources: Optional[List[str]] = None
    """
    Resources is a list of resources this rule applies to. '*' represents all resources.
    """
    verbs: List[str]
    """
    Verbs is a list of Verbs that apply to ALL the ResourceKinds contained in this rule. '*' represents all verbs.
    """


class RoleRef(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["RoleRef"]:
            return RoleRef

        def build(self) -> "RoleRef":
            return RoleRef(**self._attrs)

        def api_group(self, value: str, /) -> Self:
            """
            APIGroup is the group for the resource being referenced
            """
            return self._set("api_group", value)

        def kind(self, value: str, /) -> Self:
            """
            Kind is the type of resource being referenced
            """
            return self._set("kind", value)

        def name(self, value: str, /) -> Self:
            """
            Name is the name of resource being referenced
            """
            return self._set("name", value)

    class BuilderContext(BuilderContextBase["RoleRef.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = RoleRef.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for RoleRef."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["RoleRef", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use RoleRef.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    api_group: Annotated[str, Field(alias="apiGroup")]
    """
    APIGroup is the group for the resource being referenced
    """
    kind: str
    """
    Kind is the type of resource being referenced
    """
    name: str
    """
    Name is the name of resource being referenced
    """


class Subject(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["Subject"]:
            return Subject

        def build(self) -> "Subject":
            return Subject(**self._attrs)

        def api_group(self, value: Optional[str], /) -> Self:
            """
            APIGroup holds the API group of the referenced subject. Defaults to "" for ServiceAccount subjects. Defaults to "rbac.authorization.k8s.io" for User and Group subjects.
            """
            return self._set("api_group", value)

        def kind(self, value: str, /) -> Self:
            """
            Kind of object being referenced. Values defined by this API group are "User", "Group", and "ServiceAccount". If the Authorizer does not recognized the kind value, the Authorizer should report an error.
            """
            return self._set("kind", value)

        def name(self, value: str, /) -> Self:
            """
            Name of the object being referenced.
            """
            return self._set("name", value)

        def namespace(self, value: Optional[str], /) -> Self:
            """
            Namespace of the referenced object.  If the object kind is non-namespace, such as "User" or "Group", and this value is not empty the Authorizer should report an error.
            """
            return self._set("namespace", value)

    class BuilderContext(BuilderContextBase["Subject.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = Subject.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for Subject."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["Subject", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use Subject.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    api_group: Annotated[Optional[str], Field(alias="apiGroup")] = None
    """
    APIGroup holds the API group of the referenced subject. Defaults to "" for ServiceAccount subjects. Defaults to "rbac.authorization.k8s.io" for User and Group subjects.
    """
    kind: str
    """
    Kind of object being referenced. Values defined by this API group are "User", "Group", and "ServiceAccount". If the Authorizer does not recognized the kind value, the Authorizer should report an error.
    """
    name: str
    """
    Name of the object being referenced.
    """
    namespace: Optional[str] = None
    """
    Namespace of the referenced object.  If the object kind is non-namespace, such as "User" or "Group", and this value is not empty the Authorizer should report an error.
    """


class AggregationRule(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["AggregationRule"]:
            return AggregationRule

        def build(self) -> "AggregationRule":
            return AggregationRule(**self._attrs)

        @overload
        def cluster_role_selectors(
            self, value_or_callback: List[apimachinery.LabelSelector], /
        ) -> "AggregationRule.Builder": ...

        @overload
        def cluster_role_selectors(
            self,
            value_or_callback: Callable[
                [
                    GenericListBuilder[
                        apimachinery.LabelSelector, apimachinery.LabelSelector.Builder
                    ]
                ],
                GenericListBuilder[apimachinery.LabelSelector, apimachinery.LabelSelector.Builder]
                | List[apimachinery.LabelSelector],
            ],
            /,
        ) -> "AggregationRule.Builder": ...

        @overload
        def cluster_role_selectors(
            self, value_or_callback: Never = ...
        ) -> ListBuilderContext[apimachinery.LabelSelector.Builder]: ...

        def cluster_role_selectors(self, value_or_callback=None, /):
            """
            ClusterRoleSelectors holds a list of selectors which will be used to find ClusterRoles and create the rules. If any of the selectors match, then the ClusterRole's permissions will be added
            """
            if self._in_context and value_or_callback is None:
                context = ListBuilderContext[apimachinery.LabelSelector.Builder]()
                context._parent_builder = self
                context._field_name = "cluster_role_selectors"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(apimachinery.LabelSelector.list_builder())
                if isinstance(output, GenericListBuilder):
                    value = output.build()
                else:
                    value = output
            return self._set("cluster_role_selectors", value)

    class BuilderContext(BuilderContextBase["AggregationRule.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = AggregationRule.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for AggregationRule."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["AggregationRule", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use AggregationRule.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    cluster_role_selectors: Annotated[
        Optional[List[apimachinery.LabelSelector]], Field(alias="clusterRoleSelectors")
    ] = None
    """
    ClusterRoleSelectors holds a list of selectors which will be used to find ClusterRoles and create the rules. If any of the selectors match, then the ClusterRole's permissions will be added
    """


class ClusterRole(Resource):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["ClusterRole"]:
            return ClusterRole

        def build(self) -> "ClusterRole":
            return ClusterRole(**self._attrs)

        @overload
        def aggregation_rule(
            self, value_or_callback: Optional[AggregationRule], /
        ) -> "ClusterRole.Builder": ...

        @overload
        def aggregation_rule(
            self,
            value_or_callback: Callable[
                [AggregationRule.Builder], AggregationRule.Builder | AggregationRule
            ],
            /,
        ) -> "ClusterRole.Builder": ...

        @overload
        def aggregation_rule(
            self, value_or_callback: Never = ...
        ) -> "AggregationRule.BuilderContext": ...

        def aggregation_rule(self, value_or_callback=None, /):
            """
            AggregationRule is an optional field that describes how to build the Rules for this ClusterRole. If AggregationRule is set, then the Rules are controller managed and direct changes to Rules will be stomped by the controller.
            """
            if self._in_context and value_or_callback is None:
                context = AggregationRule.BuilderContext()
                context._parent_builder = self
                context._field_name = "aggregation_rule"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(AggregationRule.builder())
                if isinstance(output, AggregationRule.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("aggregation_rule", value)

        def api_version(self, value: Optional[Literal["rbac.authorization.k8s.io/v1"]], /) -> Self:
            """
            APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
            """
            return self._set("api_version", value)

        def kind(self, value: Optional[Literal["ClusterRole"]], /) -> Self:
            """
            Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
            """
            return self._set("kind", value)

        @overload
        def metadata(
            self, value_or_callback: Optional[apimachinery.ObjectMeta], /
        ) -> "ClusterRole.Builder": ...

        @overload
        def metadata(
            self,
            value_or_callback: Callable[
                [apimachinery.ObjectMeta.Builder],
                apimachinery.ObjectMeta.Builder | apimachinery.ObjectMeta,
            ],
            /,
        ) -> "ClusterRole.Builder": ...

        @overload
        def metadata(
            self, value_or_callback: Never = ...
        ) -> "apimachinery.ObjectMeta.BuilderContext": ...

        def metadata(self, value_or_callback=None, /):
            """
            Standard object's metadata.
            """
            if self._in_context and value_or_callback is None:
                context = apimachinery.ObjectMeta.BuilderContext()
                context._parent_builder = self
                context._field_name = "metadata"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(apimachinery.ObjectMeta.builder())
                if isinstance(output, apimachinery.ObjectMeta.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("metadata", value)

        @overload
        def rules(self, value_or_callback: List[PolicyRule], /) -> "ClusterRole.Builder": ...

        @overload
        def rules(
            self,
            value_or_callback: Callable[
                [GenericListBuilder[PolicyRule, PolicyRule.Builder]],
                GenericListBuilder[PolicyRule, PolicyRule.Builder] | List[PolicyRule],
            ],
            /,
        ) -> "ClusterRole.Builder": ...

        @overload
        def rules(
            self, value_or_callback: Never = ...
        ) -> ListBuilderContext[PolicyRule.Builder]: ...

        def rules(self, value_or_callback=None, /):
            """
            Rules holds all the PolicyRules for this ClusterRole
            """
            if self._in_context and value_or_callback is None:
                context = ListBuilderContext[PolicyRule.Builder]()
                context._parent_builder = self
                context._field_name = "rules"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(PolicyRule.list_builder())
                if isinstance(output, GenericListBuilder):
                    value = output.build()
                else:
                    value = output
            return self._set("rules", value)

    class BuilderContext(BuilderContextBase["ClusterRole.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = ClusterRole.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for ClusterRole."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["ClusterRole", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use ClusterRole.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    aggregation_rule: Annotated[Optional[AggregationRule], Field(alias="aggregationRule")] = None
    """
    AggregationRule is an optional field that describes how to build the Rules for this ClusterRole. If AggregationRule is set, then the Rules are controller managed and direct changes to Rules will be stomped by the controller.
    """
    api_version: Annotated[
        Optional[Literal["rbac.authorization.k8s.io/v1"]], Field(alias="apiVersion")
    ] = "rbac.authorization.k8s.io/v1"
    """
    APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
    """
    kind: Optional[Literal["ClusterRole"]] = "ClusterRole"
    """
    Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
    """
    metadata: Optional[apimachinery.ObjectMeta] = None
    """
    Standard object's metadata.
    """
    rules: Optional[List[PolicyRule]] = None
    """
    Rules holds all the PolicyRules for this ClusterRole
    """


class ClusterRoleBinding(Resource):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["ClusterRoleBinding"]:
            return ClusterRoleBinding

        def build(self) -> "ClusterRoleBinding":
            return ClusterRoleBinding(**self._attrs)

        def api_version(self, value: Optional[Literal["rbac.authorization.k8s.io/v1"]], /) -> Self:
            """
            APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
            """
            return self._set("api_version", value)

        def kind(self, value: Optional[Literal["ClusterRoleBinding"]], /) -> Self:
            """
            Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
            """
            return self._set("kind", value)

        @overload
        def metadata(
            self, value_or_callback: Optional[apimachinery.ObjectMeta], /
        ) -> "ClusterRoleBinding.Builder": ...

        @overload
        def metadata(
            self,
            value_or_callback: Callable[
                [apimachinery.ObjectMeta.Builder],
                apimachinery.ObjectMeta.Builder | apimachinery.ObjectMeta,
            ],
            /,
        ) -> "ClusterRoleBinding.Builder": ...

        @overload
        def metadata(
            self, value_or_callback: Never = ...
        ) -> "apimachinery.ObjectMeta.BuilderContext": ...

        def metadata(self, value_or_callback=None, /):
            """
            Standard object's metadata.
            """
            if self._in_context and value_or_callback is None:
                context = apimachinery.ObjectMeta.BuilderContext()
                context._parent_builder = self
                context._field_name = "metadata"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(apimachinery.ObjectMeta.builder())
                if isinstance(output, apimachinery.ObjectMeta.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("metadata", value)

        @overload
        def role_ref(self, value_or_callback: RoleRef, /) -> "ClusterRoleBinding.Builder": ...

        @overload
        def role_ref(
            self,
            value_or_callback: Callable[[RoleRef.Builder], RoleRef.Builder | RoleRef],
            /,
        ) -> "ClusterRoleBinding.Builder": ...

        @overload
        def role_ref(self, value_or_callback: Never = ...) -> "RoleRef.BuilderContext": ...

        def role_ref(self, value_or_callback=None, /):
            """
            RoleRef can only reference a ClusterRole in the global namespace. If the RoleRef cannot be resolved, the Authorizer must return an error. This field is immutable.
            """
            if self._in_context and value_or_callback is None:
                context = RoleRef.BuilderContext()
                context._parent_builder = self
                context._field_name = "role_ref"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(RoleRef.builder())
                if isinstance(output, RoleRef.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("role_ref", value)

        @overload
        def subjects(self, value_or_callback: List[Subject], /) -> "ClusterRoleBinding.Builder": ...

        @overload
        def subjects(
            self,
            value_or_callback: Callable[
                [GenericListBuilder[Subject, Subject.Builder]],
                GenericListBuilder[Subject, Subject.Builder] | List[Subject],
            ],
            /,
        ) -> "ClusterRoleBinding.Builder": ...

        @overload
        def subjects(
            self, value_or_callback: Never = ...
        ) -> ListBuilderContext[Subject.Builder]: ...

        def subjects(self, value_or_callback=None, /):
            """
            Subjects holds references to the objects the role applies to.
            """
            if self._in_context and value_or_callback is None:
                context = ListBuilderContext[Subject.Builder]()
                context._parent_builder = self
                context._field_name = "subjects"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(Subject.list_builder())
                if isinstance(output, GenericListBuilder):
                    value = output.build()
                else:
                    value = output
            return self._set("subjects", value)

    class BuilderContext(BuilderContextBase["ClusterRoleBinding.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = ClusterRoleBinding.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for ClusterRoleBinding."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["ClusterRoleBinding", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use ClusterRoleBinding.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    api_version: Annotated[
        Optional[Literal["rbac.authorization.k8s.io/v1"]], Field(alias="apiVersion")
    ] = "rbac.authorization.k8s.io/v1"
    """
    APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
    """
    kind: Optional[Literal["ClusterRoleBinding"]] = "ClusterRoleBinding"
    """
    Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
    """
    metadata: Optional[apimachinery.ObjectMeta] = None
    """
    Standard object's metadata.
    """
    role_ref: Annotated[RoleRef, Field(alias="roleRef")]
    """
    RoleRef can only reference a ClusterRole in the global namespace. If the RoleRef cannot be resolved, the Authorizer must return an error. This field is immutable.
    """
    subjects: Optional[List[Subject]] = None
    """
    Subjects holds references to the objects the role applies to.
    """


ClusterRoleBindingList = ResourceList["ClusterRoleBinding"]


ClusterRoleList = ResourceList["ClusterRole"]


class Role(Resource):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["Role"]:
            return Role

        def build(self) -> "Role":
            return Role(**self._attrs)

        def api_version(self, value: Optional[Literal["rbac.authorization.k8s.io/v1"]], /) -> Self:
            """
            APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
            """
            return self._set("api_version", value)

        def kind(self, value: Optional[Literal["Role"]], /) -> Self:
            """
            Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
            """
            return self._set("kind", value)

        @overload
        def metadata(
            self, value_or_callback: Optional[apimachinery.ObjectMeta], /
        ) -> "Role.Builder": ...

        @overload
        def metadata(
            self,
            value_or_callback: Callable[
                [apimachinery.ObjectMeta.Builder],
                apimachinery.ObjectMeta.Builder | apimachinery.ObjectMeta,
            ],
            /,
        ) -> "Role.Builder": ...

        @overload
        def metadata(
            self, value_or_callback: Never = ...
        ) -> "apimachinery.ObjectMeta.BuilderContext": ...

        def metadata(self, value_or_callback=None, /):
            """
            Standard object's metadata.
            """
            if self._in_context and value_or_callback is None:
                context = apimachinery.ObjectMeta.BuilderContext()
                context._parent_builder = self
                context._field_name = "metadata"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(apimachinery.ObjectMeta.builder())
                if isinstance(output, apimachinery.ObjectMeta.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("metadata", value)

        @overload
        def rules(self, value_or_callback: List[PolicyRule], /) -> "Role.Builder": ...

        @overload
        def rules(
            self,
            value_or_callback: Callable[
                [GenericListBuilder[PolicyRule, PolicyRule.Builder]],
                GenericListBuilder[PolicyRule, PolicyRule.Builder] | List[PolicyRule],
            ],
            /,
        ) -> "Role.Builder": ...

        @overload
        def rules(
            self, value_or_callback: Never = ...
        ) -> ListBuilderContext[PolicyRule.Builder]: ...

        def rules(self, value_or_callback=None, /):
            """
            Rules holds all the PolicyRules for this Role
            """
            if self._in_context and value_or_callback is None:
                context = ListBuilderContext[PolicyRule.Builder]()
                context._parent_builder = self
                context._field_name = "rules"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(PolicyRule.list_builder())
                if isinstance(output, GenericListBuilder):
                    value = output.build()
                else:
                    value = output
            return self._set("rules", value)

    class BuilderContext(BuilderContextBase["Role.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = Role.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for Role."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["Role", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use Role.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    api_version: Annotated[
        Optional[Literal["rbac.authorization.k8s.io/v1"]], Field(alias="apiVersion")
    ] = "rbac.authorization.k8s.io/v1"
    """
    APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
    """
    kind: Optional[Literal["Role"]] = "Role"
    """
    Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
    """
    metadata: Optional[apimachinery.ObjectMeta] = None
    """
    Standard object's metadata.
    """
    rules: Optional[List[PolicyRule]] = None
    """
    Rules holds all the PolicyRules for this Role
    """


class RoleBinding(Resource):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["RoleBinding"]:
            return RoleBinding

        def build(self) -> "RoleBinding":
            return RoleBinding(**self._attrs)

        def api_version(self, value: Optional[Literal["rbac.authorization.k8s.io/v1"]], /) -> Self:
            """
            APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
            """
            return self._set("api_version", value)

        def kind(self, value: Optional[Literal["RoleBinding"]], /) -> Self:
            """
            Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
            """
            return self._set("kind", value)

        @overload
        def metadata(
            self, value_or_callback: Optional[apimachinery.ObjectMeta], /
        ) -> "RoleBinding.Builder": ...

        @overload
        def metadata(
            self,
            value_or_callback: Callable[
                [apimachinery.ObjectMeta.Builder],
                apimachinery.ObjectMeta.Builder | apimachinery.ObjectMeta,
            ],
            /,
        ) -> "RoleBinding.Builder": ...

        @overload
        def metadata(
            self, value_or_callback: Never = ...
        ) -> "apimachinery.ObjectMeta.BuilderContext": ...

        def metadata(self, value_or_callback=None, /):
            """
            Standard object's metadata.
            """
            if self._in_context and value_or_callback is None:
                context = apimachinery.ObjectMeta.BuilderContext()
                context._parent_builder = self
                context._field_name = "metadata"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(apimachinery.ObjectMeta.builder())
                if isinstance(output, apimachinery.ObjectMeta.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("metadata", value)

        @overload
        def role_ref(self, value_or_callback: RoleRef, /) -> "RoleBinding.Builder": ...

        @overload
        def role_ref(
            self,
            value_or_callback: Callable[[RoleRef.Builder], RoleRef.Builder | RoleRef],
            /,
        ) -> "RoleBinding.Builder": ...

        @overload
        def role_ref(self, value_or_callback: Never = ...) -> "RoleRef.BuilderContext": ...

        def role_ref(self, value_or_callback=None, /):
            """
            RoleRef can reference a Role in the current namespace or a ClusterRole in the global namespace. If the RoleRef cannot be resolved, the Authorizer must return an error. This field is immutable.
            """
            if self._in_context and value_or_callback is None:
                context = RoleRef.BuilderContext()
                context._parent_builder = self
                context._field_name = "role_ref"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(RoleRef.builder())
                if isinstance(output, RoleRef.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("role_ref", value)

        @overload
        def subjects(self, value_or_callback: List[Subject], /) -> "RoleBinding.Builder": ...

        @overload
        def subjects(
            self,
            value_or_callback: Callable[
                [GenericListBuilder[Subject, Subject.Builder]],
                GenericListBuilder[Subject, Subject.Builder] | List[Subject],
            ],
            /,
        ) -> "RoleBinding.Builder": ...

        @overload
        def subjects(
            self, value_or_callback: Never = ...
        ) -> ListBuilderContext[Subject.Builder]: ...

        def subjects(self, value_or_callback=None, /):
            """
            Subjects holds references to the objects the role applies to.
            """
            if self._in_context and value_or_callback is None:
                context = ListBuilderContext[Subject.Builder]()
                context._parent_builder = self
                context._field_name = "subjects"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(Subject.list_builder())
                if isinstance(output, GenericListBuilder):
                    value = output.build()
                else:
                    value = output
            return self._set("subjects", value)

    class BuilderContext(BuilderContextBase["RoleBinding.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = RoleBinding.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for RoleBinding."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["RoleBinding", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use RoleBinding.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    api_version: Annotated[
        Optional[Literal["rbac.authorization.k8s.io/v1"]], Field(alias="apiVersion")
    ] = "rbac.authorization.k8s.io/v1"
    """
    APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
    """
    kind: Optional[Literal["RoleBinding"]] = "RoleBinding"
    """
    Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
    """
    metadata: Optional[apimachinery.ObjectMeta] = None
    """
    Standard object's metadata.
    """
    role_ref: Annotated[RoleRef, Field(alias="roleRef")]
    """
    RoleRef can reference a Role in the current namespace or a ClusterRole in the global namespace. If the RoleRef cannot be resolved, the Authorizer must return an error. This field is immutable.
    """
    subjects: Optional[List[Subject]] = None
    """
    Subjects holds references to the objects the role applies to.
    """


RoleBindingList = ResourceList["RoleBinding"]


RoleList = ResourceList["Role"]
