# Generated by cloudcoil-model-codegen v0.5.0
# DO NOT EDIT

from __future__ import annotations

from typing import (
    Annotated,
    Callable,
    List,
    Literal,
    Optional,
    Type,
    overload,
)

from pydantic import Field

from cloudcoil import apimachinery
from cloudcoil.pydantic import (
    BaseModel,
    BaseModelBuilder,
    BuilderContextBase,
    GenericListBuilder,
    ListBuilderContext,
    Never,
    Self,
)
from cloudcoil.resources import Resource, ResourceList

from ..core import v1


class IPBlock(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["IPBlock"]:
            return IPBlock

        def build(self) -> "IPBlock":
            return IPBlock(**self._attrs)

        def cidr(self, value: str, /) -> Self:
            """
            cidr is a string representing the IPBlock Valid examples are "192.168.1.0/24" or "2001:db8::/64"
            """
            return self._set("cidr", value)

        def except_(self, value: Optional[List[str]], /) -> Self:
            """
            except is a slice of CIDRs that should not be included within an IPBlock Valid examples are "192.168.1.0/24" or "2001:db8::/64" Except values will be rejected if they are outside the cidr range
            """
            return self._set("except_", value)

    class BuilderContext(BuilderContextBase["IPBlock.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = IPBlock.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for IPBlock."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["IPBlock", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use IPBlock.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    cidr: str
    """
    cidr is a string representing the IPBlock Valid examples are "192.168.1.0/24" or "2001:db8::/64"
    """
    except_: Annotated[Optional[List[str]], Field(alias="except")] = None
    """
    except is a slice of CIDRs that should not be included within an IPBlock Valid examples are "192.168.1.0/24" or "2001:db8::/64" Except values will be rejected if they are outside the cidr range
    """


class IngressClassParametersReference(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["IngressClassParametersReference"]:
            return IngressClassParametersReference

        def build(self) -> "IngressClassParametersReference":
            return IngressClassParametersReference(**self._attrs)

        def api_group(self, value: Optional[str], /) -> Self:
            """
            apiGroup is the group for the resource being referenced. If APIGroup is not specified, the specified Kind must be in the core API group. For any other third-party types, APIGroup is required.
            """
            return self._set("api_group", value)

        def kind(self, value: str, /) -> Self:
            """
            kind is the type of resource being referenced.
            """
            return self._set("kind", value)

        def name(self, value: str, /) -> Self:
            """
            name is the name of resource being referenced.
            """
            return self._set("name", value)

        def namespace(self, value: Optional[str], /) -> Self:
            """
            namespace is the namespace of the resource being referenced. This field is required when scope is set to "Namespace" and must be unset when scope is set to "Cluster".
            """
            return self._set("namespace", value)

        def scope(self, value: Optional[str], /) -> Self:
            """
            scope represents if this refers to a cluster or namespace scoped resource. This may be set to "Cluster" (default) or "Namespace".
            """
            return self._set("scope", value)

    class BuilderContext(BuilderContextBase["IngressClassParametersReference.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = IngressClassParametersReference.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for IngressClassParametersReference."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["IngressClassParametersReference", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use IngressClassParametersReference.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    api_group: Annotated[Optional[str], Field(alias="apiGroup")] = None
    """
    apiGroup is the group for the resource being referenced. If APIGroup is not specified, the specified Kind must be in the core API group. For any other third-party types, APIGroup is required.
    """
    kind: str
    """
    kind is the type of resource being referenced.
    """
    name: str
    """
    name is the name of resource being referenced.
    """
    namespace: Optional[str] = None
    """
    namespace is the namespace of the resource being referenced. This field is required when scope is set to "Namespace" and must be unset when scope is set to "Cluster".
    """
    scope: Optional[str] = None
    """
    scope represents if this refers to a cluster or namespace scoped resource. This may be set to "Cluster" (default) or "Namespace".
    """


class IngressClassSpec(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["IngressClassSpec"]:
            return IngressClassSpec

        def build(self) -> "IngressClassSpec":
            return IngressClassSpec(**self._attrs)

        def controller(self, value: Optional[str], /) -> Self:
            """
            controller refers to the name of the controller that should handle this class. This allows for different "flavors" that are controlled by the same controller. For example, you may have different parameters for the same implementing controller. This should be specified as a domain-prefixed path no more than 250 characters in length, e.g. "acme.io/ingress-controller". This field is immutable.
            """
            return self._set("controller", value)

        @overload
        def parameters(
            self, value_or_callback: Optional[IngressClassParametersReference], /
        ) -> "IngressClassSpec.Builder": ...

        @overload
        def parameters(
            self,
            value_or_callback: Callable[
                [IngressClassParametersReference.Builder],
                IngressClassParametersReference.Builder | IngressClassParametersReference,
            ],
            /,
        ) -> "IngressClassSpec.Builder": ...

        @overload
        def parameters(
            self, value_or_callback: Never = ...
        ) -> "IngressClassParametersReference.BuilderContext": ...

        def parameters(self, value_or_callback=None, /):
            """
            parameters is a link to a custom resource containing additional configuration for the controller. This is optional if the controller does not require extra parameters.
            """
            if self._in_context and value_or_callback is None:
                context = IngressClassParametersReference.BuilderContext()
                context._parent_builder = self
                context._field_name = "parameters"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(IngressClassParametersReference.builder())
                if isinstance(output, IngressClassParametersReference.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("parameters", value)

    class BuilderContext(BuilderContextBase["IngressClassSpec.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = IngressClassSpec.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for IngressClassSpec."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["IngressClassSpec", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use IngressClassSpec.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    controller: Optional[str] = None
    """
    controller refers to the name of the controller that should handle this class. This allows for different "flavors" that are controlled by the same controller. For example, you may have different parameters for the same implementing controller. This should be specified as a domain-prefixed path no more than 250 characters in length, e.g. "acme.io/ingress-controller". This field is immutable.
    """
    parameters: Optional[IngressClassParametersReference] = None
    """
    parameters is a link to a custom resource containing additional configuration for the controller. This is optional if the controller does not require extra parameters.
    """


class IngressPortStatus(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["IngressPortStatus"]:
            return IngressPortStatus

        def build(self) -> "IngressPortStatus":
            return IngressPortStatus(**self._attrs)

        def error(self, value: Optional[str], /) -> Self:
            """
            error is to record the problem with the service port The format of the error shall comply with the following rules: - built-in error values shall be specified in this file and those shall use
              CamelCase names
            - cloud provider specific error values must have names that comply with the
              format foo.example.com/CamelCase.
            """
            return self._set("error", value)

        def port(self, value: int, /) -> Self:
            """
            port is the port number of the ingress port.
            """
            return self._set("port", value)

        def protocol(self, value: str, /) -> Self:
            """
            protocol is the protocol of the ingress port. The supported values are: "TCP", "UDP", "SCTP"
            """
            return self._set("protocol", value)

    class BuilderContext(BuilderContextBase["IngressPortStatus.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = IngressPortStatus.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for IngressPortStatus."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["IngressPortStatus", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use IngressPortStatus.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    error: Optional[str] = None
    """
    error is to record the problem with the service port The format of the error shall comply with the following rules: - built-in error values shall be specified in this file and those shall use
      CamelCase names
    - cloud provider specific error values must have names that comply with the
      format foo.example.com/CamelCase.
    """
    port: int
    """
    port is the port number of the ingress port.
    """
    protocol: str
    """
    protocol is the protocol of the ingress port. The supported values are: "TCP", "UDP", "SCTP"
    """


class IngressTLS(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["IngressTLS"]:
            return IngressTLS

        def build(self) -> "IngressTLS":
            return IngressTLS(**self._attrs)

        def hosts(self, value: Optional[List[str]], /) -> Self:
            """
            hosts is a list of hosts included in the TLS certificate. The values in this list must match the name/s used in the tlsSecret. Defaults to the wildcard host setting for the loadbalancer controller fulfilling this Ingress, if left unspecified.
            """
            return self._set("hosts", value)

        def secret_name(self, value: Optional[str], /) -> Self:
            """
            secretName is the name of the secret used to terminate TLS traffic on port 443. Field is left optional to allow TLS routing based on SNI hostname alone. If the SNI host in a listener conflicts with the "Host" header field used by an IngressRule, the SNI host is used for termination and value of the "Host" header is used for routing.
            """
            return self._set("secret_name", value)

    class BuilderContext(BuilderContextBase["IngressTLS.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = IngressTLS.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for IngressTLS."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["IngressTLS", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use IngressTLS.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    hosts: Optional[List[str]] = None
    """
    hosts is a list of hosts included in the TLS certificate. The values in this list must match the name/s used in the tlsSecret. Defaults to the wildcard host setting for the loadbalancer controller fulfilling this Ingress, if left unspecified.
    """
    secret_name: Annotated[Optional[str], Field(alias="secretName")] = None
    """
    secretName is the name of the secret used to terminate TLS traffic on port 443. Field is left optional to allow TLS routing based on SNI hostname alone. If the SNI host in a listener conflicts with the "Host" header field used by an IngressRule, the SNI host is used for termination and value of the "Host" header is used for routing.
    """


class ServiceBackendPort(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["ServiceBackendPort"]:
            return ServiceBackendPort

        def build(self) -> "ServiceBackendPort":
            return ServiceBackendPort(**self._attrs)

        def name(self, value: Optional[str], /) -> Self:
            """
            name is the name of the port on the Service. This is a mutually exclusive setting with "Number".
            """
            return self._set("name", value)

        def number(self, value: Optional[int], /) -> Self:
            """
            number is the numerical port number (e.g. 80) on the Service. This is a mutually exclusive setting with "Name".
            """
            return self._set("number", value)

    class BuilderContext(BuilderContextBase["ServiceBackendPort.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = ServiceBackendPort.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for ServiceBackendPort."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["ServiceBackendPort", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use ServiceBackendPort.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    name: Optional[str] = None
    """
    name is the name of the port on the Service. This is a mutually exclusive setting with "Number".
    """
    number: Optional[int] = None
    """
    number is the numerical port number (e.g. 80) on the Service. This is a mutually exclusive setting with "Name".
    """


class IngressLoadBalancerIngress(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["IngressLoadBalancerIngress"]:
            return IngressLoadBalancerIngress

        def build(self) -> "IngressLoadBalancerIngress":
            return IngressLoadBalancerIngress(**self._attrs)

        def hostname(self, value: Optional[str], /) -> Self:
            """
            hostname is set for load-balancer ingress points that are DNS based.
            """
            return self._set("hostname", value)

        def ip(self, value: Optional[str], /) -> Self:
            """
            ip is set for load-balancer ingress points that are IP based.
            """
            return self._set("ip", value)

        @overload
        def ports(
            self, value_or_callback: List[IngressPortStatus], /
        ) -> "IngressLoadBalancerIngress.Builder": ...

        @overload
        def ports(
            self,
            value_or_callback: Callable[
                [GenericListBuilder[IngressPortStatus, IngressPortStatus.Builder]],
                GenericListBuilder[IngressPortStatus, IngressPortStatus.Builder]
                | List[IngressPortStatus],
            ],
            /,
        ) -> "IngressLoadBalancerIngress.Builder": ...

        @overload
        def ports(
            self, value_or_callback: Never = ...
        ) -> ListBuilderContext[IngressPortStatus.Builder]: ...

        def ports(self, value_or_callback=None, /):
            """
            ports provides information about the ports exposed by this LoadBalancer.
            """
            if self._in_context and value_or_callback is None:
                context = ListBuilderContext[IngressPortStatus.Builder]()
                context._parent_builder = self
                context._field_name = "ports"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(IngressPortStatus.list_builder())
                if isinstance(output, GenericListBuilder):
                    value = output.build()
                else:
                    value = output
            return self._set("ports", value)

    class BuilderContext(BuilderContextBase["IngressLoadBalancerIngress.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = IngressLoadBalancerIngress.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for IngressLoadBalancerIngress."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["IngressLoadBalancerIngress", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use IngressLoadBalancerIngress.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    hostname: Optional[str] = None
    """
    hostname is set for load-balancer ingress points that are DNS based.
    """
    ip: Optional[str] = None
    """
    ip is set for load-balancer ingress points that are IP based.
    """
    ports: Optional[List[IngressPortStatus]] = None
    """
    ports provides information about the ports exposed by this LoadBalancer.
    """


class IngressLoadBalancerStatus(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["IngressLoadBalancerStatus"]:
            return IngressLoadBalancerStatus

        def build(self) -> "IngressLoadBalancerStatus":
            return IngressLoadBalancerStatus(**self._attrs)

        @overload
        def ingress(
            self, value_or_callback: List[IngressLoadBalancerIngress], /
        ) -> "IngressLoadBalancerStatus.Builder": ...

        @overload
        def ingress(
            self,
            value_or_callback: Callable[
                [
                    GenericListBuilder[
                        IngressLoadBalancerIngress, IngressLoadBalancerIngress.Builder
                    ]
                ],
                GenericListBuilder[IngressLoadBalancerIngress, IngressLoadBalancerIngress.Builder]
                | List[IngressLoadBalancerIngress],
            ],
            /,
        ) -> "IngressLoadBalancerStatus.Builder": ...

        @overload
        def ingress(
            self, value_or_callback: Never = ...
        ) -> ListBuilderContext[IngressLoadBalancerIngress.Builder]: ...

        def ingress(self, value_or_callback=None, /):
            """
            ingress is a list containing ingress points for the load-balancer.
            """
            if self._in_context and value_or_callback is None:
                context = ListBuilderContext[IngressLoadBalancerIngress.Builder]()
                context._parent_builder = self
                context._field_name = "ingress"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(IngressLoadBalancerIngress.list_builder())
                if isinstance(output, GenericListBuilder):
                    value = output.build()
                else:
                    value = output
            return self._set("ingress", value)

    class BuilderContext(BuilderContextBase["IngressLoadBalancerStatus.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = IngressLoadBalancerStatus.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for IngressLoadBalancerStatus."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["IngressLoadBalancerStatus", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use IngressLoadBalancerStatus.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    ingress: Optional[List[IngressLoadBalancerIngress]] = None
    """
    ingress is a list containing ingress points for the load-balancer.
    """


class IngressServiceBackend(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["IngressServiceBackend"]:
            return IngressServiceBackend

        def build(self) -> "IngressServiceBackend":
            return IngressServiceBackend(**self._attrs)

        def name(self, value: str, /) -> Self:
            """
            name is the referenced service. The service must exist in the same namespace as the Ingress object.
            """
            return self._set("name", value)

        @overload
        def port(
            self, value_or_callback: Optional[ServiceBackendPort], /
        ) -> "IngressServiceBackend.Builder": ...

        @overload
        def port(
            self,
            value_or_callback: Callable[
                [ServiceBackendPort.Builder],
                ServiceBackendPort.Builder | ServiceBackendPort,
            ],
            /,
        ) -> "IngressServiceBackend.Builder": ...

        @overload
        def port(self, value_or_callback: Never = ...) -> "ServiceBackendPort.BuilderContext": ...

        def port(self, value_or_callback=None, /):
            """
            port of the referenced service. A port name or port number is required for a IngressServiceBackend.
            """
            if self._in_context and value_or_callback is None:
                context = ServiceBackendPort.BuilderContext()
                context._parent_builder = self
                context._field_name = "port"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(ServiceBackendPort.builder())
                if isinstance(output, ServiceBackendPort.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("port", value)

    class BuilderContext(BuilderContextBase["IngressServiceBackend.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = IngressServiceBackend.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for IngressServiceBackend."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["IngressServiceBackend", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use IngressServiceBackend.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    name: str
    """
    name is the referenced service. The service must exist in the same namespace as the Ingress object.
    """
    port: Optional[ServiceBackendPort] = None
    """
    port of the referenced service. A port name or port number is required for a IngressServiceBackend.
    """


class IngressStatus(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["IngressStatus"]:
            return IngressStatus

        def build(self) -> "IngressStatus":
            return IngressStatus(**self._attrs)

        @overload
        def load_balancer(
            self, value_or_callback: Optional[IngressLoadBalancerStatus], /
        ) -> "IngressStatus.Builder": ...

        @overload
        def load_balancer(
            self,
            value_or_callback: Callable[
                [IngressLoadBalancerStatus.Builder],
                IngressLoadBalancerStatus.Builder | IngressLoadBalancerStatus,
            ],
            /,
        ) -> "IngressStatus.Builder": ...

        @overload
        def load_balancer(
            self, value_or_callback: Never = ...
        ) -> "IngressLoadBalancerStatus.BuilderContext": ...

        def load_balancer(self, value_or_callback=None, /):
            """
            loadBalancer contains the current status of the load-balancer.
            """
            if self._in_context and value_or_callback is None:
                context = IngressLoadBalancerStatus.BuilderContext()
                context._parent_builder = self
                context._field_name = "load_balancer"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(IngressLoadBalancerStatus.builder())
                if isinstance(output, IngressLoadBalancerStatus.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("load_balancer", value)

    class BuilderContext(BuilderContextBase["IngressStatus.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = IngressStatus.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for IngressStatus."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["IngressStatus", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use IngressStatus.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    load_balancer: Annotated[Optional[IngressLoadBalancerStatus], Field(alias="loadBalancer")] = (
        None
    )
    """
    loadBalancer contains the current status of the load-balancer.
    """


class NetworkPolicyPort(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["NetworkPolicyPort"]:
            return NetworkPolicyPort

        def build(self) -> "NetworkPolicyPort":
            return NetworkPolicyPort(**self._attrs)

        def end_port(self, value: Optional[int], /) -> Self:
            """
            endPort indicates that the range of ports from port to endPort if set, inclusive, should be allowed by the policy. This field cannot be defined if the port field is not defined or if the port field is defined as a named (string) port. The endPort must be equal or greater than port.
            """
            return self._set("end_port", value)

        @overload
        def port(
            self, value_or_callback: Optional[apimachinery.IntOrString], /
        ) -> "NetworkPolicyPort.Builder": ...

        @overload
        def port(
            self,
            value_or_callback: Callable[
                [apimachinery.IntOrString.Builder],
                apimachinery.IntOrString.Builder | apimachinery.IntOrString,
            ],
            /,
        ) -> "NetworkPolicyPort.Builder": ...

        @overload
        def port(
            self, value_or_callback: Never = ...
        ) -> "apimachinery.IntOrString.BuilderContext": ...

        def port(self, value_or_callback=None, /):
            """
            port represents the port on the given protocol. This can either be a numerical or named port on a pod. If this field is not provided, this matches all port names and numbers. If present, only traffic on the specified protocol AND port will be matched.
            """
            if self._in_context and value_or_callback is None:
                context = apimachinery.IntOrString.BuilderContext()
                context._parent_builder = self
                context._field_name = "port"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(apimachinery.IntOrString.builder())
                if isinstance(output, apimachinery.IntOrString.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("port", value)

        def protocol(self, value: Optional[str], /) -> Self:
            """
            protocol represents the protocol (TCP, UDP, or SCTP) which traffic must match. If not specified, this field defaults to TCP.
            """
            return self._set("protocol", value)

    class BuilderContext(BuilderContextBase["NetworkPolicyPort.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = NetworkPolicyPort.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for NetworkPolicyPort."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["NetworkPolicyPort", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use NetworkPolicyPort.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    end_port: Annotated[Optional[int], Field(alias="endPort")] = None
    """
    endPort indicates that the range of ports from port to endPort if set, inclusive, should be allowed by the policy. This field cannot be defined if the port field is not defined or if the port field is defined as a named (string) port. The endPort must be equal or greater than port.
    """
    port: Optional[apimachinery.IntOrString] = None
    """
    port represents the port on the given protocol. This can either be a numerical or named port on a pod. If this field is not provided, this matches all port names and numbers. If present, only traffic on the specified protocol AND port will be matched.
    """
    protocol: Optional[str] = None
    """
    protocol represents the protocol (TCP, UDP, or SCTP) which traffic must match. If not specified, this field defaults to TCP.
    """


class IngressBackend(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["IngressBackend"]:
            return IngressBackend

        def build(self) -> "IngressBackend":
            return IngressBackend(**self._attrs)

        @overload
        def resource(
            self, value_or_callback: Optional[v1.TypedLocalObjectReference], /
        ) -> "IngressBackend.Builder": ...

        @overload
        def resource(
            self,
            value_or_callback: Callable[
                [v1.TypedLocalObjectReference.Builder],
                v1.TypedLocalObjectReference.Builder | v1.TypedLocalObjectReference,
            ],
            /,
        ) -> "IngressBackend.Builder": ...

        @overload
        def resource(
            self, value_or_callback: Never = ...
        ) -> "v1.TypedLocalObjectReference.BuilderContext": ...

        def resource(self, value_or_callback=None, /):
            """
            resource is an ObjectRef to another Kubernetes resource in the namespace of the Ingress object. If resource is specified, a service.Name and service.Port must not be specified. This is a mutually exclusive setting with "Service".
            """
            if self._in_context and value_or_callback is None:
                context = v1.TypedLocalObjectReference.BuilderContext()
                context._parent_builder = self
                context._field_name = "resource"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(v1.TypedLocalObjectReference.builder())
                if isinstance(output, v1.TypedLocalObjectReference.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("resource", value)

        @overload
        def service(
            self, value_or_callback: Optional[IngressServiceBackend], /
        ) -> "IngressBackend.Builder": ...

        @overload
        def service(
            self,
            value_or_callback: Callable[
                [IngressServiceBackend.Builder],
                IngressServiceBackend.Builder | IngressServiceBackend,
            ],
            /,
        ) -> "IngressBackend.Builder": ...

        @overload
        def service(
            self, value_or_callback: Never = ...
        ) -> "IngressServiceBackend.BuilderContext": ...

        def service(self, value_or_callback=None, /):
            """
            service references a service as a backend. This is a mutually exclusive setting with "Resource".
            """
            if self._in_context and value_or_callback is None:
                context = IngressServiceBackend.BuilderContext()
                context._parent_builder = self
                context._field_name = "service"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(IngressServiceBackend.builder())
                if isinstance(output, IngressServiceBackend.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("service", value)

    class BuilderContext(BuilderContextBase["IngressBackend.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = IngressBackend.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for IngressBackend."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["IngressBackend", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use IngressBackend.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    resource: Optional[v1.TypedLocalObjectReference] = None
    """
    resource is an ObjectRef to another Kubernetes resource in the namespace of the Ingress object. If resource is specified, a service.Name and service.Port must not be specified. This is a mutually exclusive setting with "Service".
    """
    service: Optional[IngressServiceBackend] = None
    """
    service references a service as a backend. This is a mutually exclusive setting with "Resource".
    """


class IngressClass(Resource):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["IngressClass"]:
            return IngressClass

        def build(self) -> "IngressClass":
            return IngressClass(**self._attrs)

        def api_version(self, value: Optional[Literal["networking.k8s.io/v1"]], /) -> Self:
            """
            APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
            """
            return self._set("api_version", value)

        def kind(self, value: Optional[Literal["IngressClass"]], /) -> Self:
            """
            Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
            """
            return self._set("kind", value)

        @overload
        def metadata(
            self, value_or_callback: Optional[apimachinery.ObjectMeta], /
        ) -> "IngressClass.Builder": ...

        @overload
        def metadata(
            self,
            value_or_callback: Callable[
                [apimachinery.ObjectMeta.Builder],
                apimachinery.ObjectMeta.Builder | apimachinery.ObjectMeta,
            ],
            /,
        ) -> "IngressClass.Builder": ...

        @overload
        def metadata(
            self, value_or_callback: Never = ...
        ) -> "apimachinery.ObjectMeta.BuilderContext": ...

        def metadata(self, value_or_callback=None, /):
            """
            Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
            """
            if self._in_context and value_or_callback is None:
                context = apimachinery.ObjectMeta.BuilderContext()
                context._parent_builder = self
                context._field_name = "metadata"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(apimachinery.ObjectMeta.builder())
                if isinstance(output, apimachinery.ObjectMeta.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("metadata", value)

        @overload
        def spec(
            self, value_or_callback: Optional[IngressClassSpec], /
        ) -> "IngressClass.Builder": ...

        @overload
        def spec(
            self,
            value_or_callback: Callable[
                [IngressClassSpec.Builder], IngressClassSpec.Builder | IngressClassSpec
            ],
            /,
        ) -> "IngressClass.Builder": ...

        @overload
        def spec(self, value_or_callback: Never = ...) -> "IngressClassSpec.BuilderContext": ...

        def spec(self, value_or_callback=None, /):
            """
            spec is the desired state of the IngressClass. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
            """
            if self._in_context and value_or_callback is None:
                context = IngressClassSpec.BuilderContext()
                context._parent_builder = self
                context._field_name = "spec"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(IngressClassSpec.builder())
                if isinstance(output, IngressClassSpec.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("spec", value)

    class BuilderContext(BuilderContextBase["IngressClass.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = IngressClass.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for IngressClass."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["IngressClass", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use IngressClass.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    api_version: Annotated[Optional[Literal["networking.k8s.io/v1"]], Field(alias="apiVersion")] = (
        "networking.k8s.io/v1"
    )
    """
    APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
    """
    kind: Optional[Literal["IngressClass"]] = "IngressClass"
    """
    Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
    """
    metadata: Optional[apimachinery.ObjectMeta] = None
    """
    Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
    """
    spec: Optional[IngressClassSpec] = None
    """
    spec is the desired state of the IngressClass. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
    """


IngressClassList = ResourceList["IngressClass"]


class NetworkPolicyPeer(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["NetworkPolicyPeer"]:
            return NetworkPolicyPeer

        def build(self) -> "NetworkPolicyPeer":
            return NetworkPolicyPeer(**self._attrs)

        @overload
        def ip_block(
            self, value_or_callback: Optional[IPBlock], /
        ) -> "NetworkPolicyPeer.Builder": ...

        @overload
        def ip_block(
            self,
            value_or_callback: Callable[[IPBlock.Builder], IPBlock.Builder | IPBlock],
            /,
        ) -> "NetworkPolicyPeer.Builder": ...

        @overload
        def ip_block(self, value_or_callback: Never = ...) -> "IPBlock.BuilderContext": ...

        def ip_block(self, value_or_callback=None, /):
            """
            ipBlock defines policy on a particular IPBlock. If this field is set then neither of the other fields can be.
            """
            if self._in_context and value_or_callback is None:
                context = IPBlock.BuilderContext()
                context._parent_builder = self
                context._field_name = "ip_block"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(IPBlock.builder())
                if isinstance(output, IPBlock.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("ip_block", value)

        @overload
        def namespace_selector(
            self, value_or_callback: Optional[apimachinery.LabelSelector], /
        ) -> "NetworkPolicyPeer.Builder": ...

        @overload
        def namespace_selector(
            self,
            value_or_callback: Callable[
                [apimachinery.LabelSelector.Builder],
                apimachinery.LabelSelector.Builder | apimachinery.LabelSelector,
            ],
            /,
        ) -> "NetworkPolicyPeer.Builder": ...

        @overload
        def namespace_selector(
            self, value_or_callback: Never = ...
        ) -> "apimachinery.LabelSelector.BuilderContext": ...

        def namespace_selector(self, value_or_callback=None, /):
            """
            namespaceSelector selects namespaces using cluster-scoped labels. This field follows standard label selector semantics; if present but empty, it selects all namespaces.

            If podSelector is also set, then the NetworkPolicyPeer as a whole selects the pods matching podSelector in the namespaces selected by namespaceSelector. Otherwise it selects all pods in the namespaces selected by namespaceSelector.
            """
            if self._in_context and value_or_callback is None:
                context = apimachinery.LabelSelector.BuilderContext()
                context._parent_builder = self
                context._field_name = "namespace_selector"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(apimachinery.LabelSelector.builder())
                if isinstance(output, apimachinery.LabelSelector.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("namespace_selector", value)

        @overload
        def pod_selector(
            self, value_or_callback: Optional[apimachinery.LabelSelector], /
        ) -> "NetworkPolicyPeer.Builder": ...

        @overload
        def pod_selector(
            self,
            value_or_callback: Callable[
                [apimachinery.LabelSelector.Builder],
                apimachinery.LabelSelector.Builder | apimachinery.LabelSelector,
            ],
            /,
        ) -> "NetworkPolicyPeer.Builder": ...

        @overload
        def pod_selector(
            self, value_or_callback: Never = ...
        ) -> "apimachinery.LabelSelector.BuilderContext": ...

        def pod_selector(self, value_or_callback=None, /):
            """
            podSelector is a label selector which selects pods. This field follows standard label selector semantics; if present but empty, it selects all pods.

            If namespaceSelector is also set, then the NetworkPolicyPeer as a whole selects the pods matching podSelector in the Namespaces selected by NamespaceSelector. Otherwise it selects the pods matching podSelector in the policy's own namespace.
            """
            if self._in_context and value_or_callback is None:
                context = apimachinery.LabelSelector.BuilderContext()
                context._parent_builder = self
                context._field_name = "pod_selector"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(apimachinery.LabelSelector.builder())
                if isinstance(output, apimachinery.LabelSelector.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("pod_selector", value)

    class BuilderContext(BuilderContextBase["NetworkPolicyPeer.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = NetworkPolicyPeer.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for NetworkPolicyPeer."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["NetworkPolicyPeer", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use NetworkPolicyPeer.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    ip_block: Annotated[Optional[IPBlock], Field(alias="ipBlock")] = None
    """
    ipBlock defines policy on a particular IPBlock. If this field is set then neither of the other fields can be.
    """
    namespace_selector: Annotated[
        Optional[apimachinery.LabelSelector], Field(alias="namespaceSelector")
    ] = None
    """
    namespaceSelector selects namespaces using cluster-scoped labels. This field follows standard label selector semantics; if present but empty, it selects all namespaces.

    If podSelector is also set, then the NetworkPolicyPeer as a whole selects the pods matching podSelector in the namespaces selected by namespaceSelector. Otherwise it selects all pods in the namespaces selected by namespaceSelector.
    """
    pod_selector: Annotated[Optional[apimachinery.LabelSelector], Field(alias="podSelector")] = None
    """
    podSelector is a label selector which selects pods. This field follows standard label selector semantics; if present but empty, it selects all pods.

    If namespaceSelector is also set, then the NetworkPolicyPeer as a whole selects the pods matching podSelector in the Namespaces selected by NamespaceSelector. Otherwise it selects the pods matching podSelector in the policy's own namespace.
    """


class HTTPIngressPath(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["HTTPIngressPath"]:
            return HTTPIngressPath

        def build(self) -> "HTTPIngressPath":
            return HTTPIngressPath(**self._attrs)

        @overload
        def backend(self, value_or_callback: IngressBackend, /) -> "HTTPIngressPath.Builder": ...

        @overload
        def backend(
            self,
            value_or_callback: Callable[
                [IngressBackend.Builder], IngressBackend.Builder | IngressBackend
            ],
            /,
        ) -> "HTTPIngressPath.Builder": ...

        @overload
        def backend(self, value_or_callback: Never = ...) -> "IngressBackend.BuilderContext": ...

        def backend(self, value_or_callback=None, /):
            """
            backend defines the referenced service endpoint to which the traffic will be forwarded to.
            """
            if self._in_context and value_or_callback is None:
                context = IngressBackend.BuilderContext()
                context._parent_builder = self
                context._field_name = "backend"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(IngressBackend.builder())
                if isinstance(output, IngressBackend.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("backend", value)

        def path(self, value: Optional[str], /) -> Self:
            """
            path is matched against the path of an incoming request. Currently it can contain characters disallowed from the conventional "path" part of a URL as defined by RFC 3986. Paths must begin with a '/' and must be present when using PathType with value "Exact" or "Prefix".
            """
            return self._set("path", value)

        def path_type(self, value: str, /) -> Self:
            """
            pathType determines the interpretation of the path matching. PathType can be one of the following values: * Exact: Matches the URL path exactly. * Prefix: Matches based on a URL path prefix split by '/'. Matching is
              done on a path element by element basis. A path element refers is the
              list of labels in the path split by the '/' separator. A request is a
              match for path p if every p is an element-wise prefix of p of the
              request path. Note that if the last element of the path is a substring
              of the last element in request path, it is not a match (e.g. /foo/bar
              matches /foo/bar/baz, but does not match /foo/barbaz).
            * ImplementationSpecific: Interpretation of the Path matching is up to
              the IngressClass. Implementations can treat this as a separate PathType
              or treat it identically to Prefix or Exact path types.
            Implementations are required to support all path types.
            """
            return self._set("path_type", value)

    class BuilderContext(BuilderContextBase["HTTPIngressPath.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = HTTPIngressPath.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for HTTPIngressPath."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["HTTPIngressPath", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use HTTPIngressPath.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    backend: IngressBackend
    """
    backend defines the referenced service endpoint to which the traffic will be forwarded to.
    """
    path: Optional[str] = None
    """
    path is matched against the path of an incoming request. Currently it can contain characters disallowed from the conventional "path" part of a URL as defined by RFC 3986. Paths must begin with a '/' and must be present when using PathType with value "Exact" or "Prefix".
    """
    path_type: Annotated[str, Field(alias="pathType")]
    """
    pathType determines the interpretation of the path matching. PathType can be one of the following values: * Exact: Matches the URL path exactly. * Prefix: Matches based on a URL path prefix split by '/'. Matching is
      done on a path element by element basis. A path element refers is the
      list of labels in the path split by the '/' separator. A request is a
      match for path p if every p is an element-wise prefix of p of the
      request path. Note that if the last element of the path is a substring
      of the last element in request path, it is not a match (e.g. /foo/bar
      matches /foo/bar/baz, but does not match /foo/barbaz).
    * ImplementationSpecific: Interpretation of the Path matching is up to
      the IngressClass. Implementations can treat this as a separate PathType
      or treat it identically to Prefix or Exact path types.
    Implementations are required to support all path types.
    """


class HTTPIngressRuleValue(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["HTTPIngressRuleValue"]:
            return HTTPIngressRuleValue

        def build(self) -> "HTTPIngressRuleValue":
            return HTTPIngressRuleValue(**self._attrs)

        @overload
        def paths(
            self, value_or_callback: List[HTTPIngressPath], /
        ) -> "HTTPIngressRuleValue.Builder": ...

        @overload
        def paths(
            self,
            value_or_callback: Callable[
                [GenericListBuilder[HTTPIngressPath, HTTPIngressPath.Builder]],
                GenericListBuilder[HTTPIngressPath, HTTPIngressPath.Builder]
                | List[HTTPIngressPath],
            ],
            /,
        ) -> "HTTPIngressRuleValue.Builder": ...

        @overload
        def paths(
            self, value_or_callback: Never = ...
        ) -> ListBuilderContext[HTTPIngressPath.Builder]: ...

        def paths(self, value_or_callback=None, /):
            """
            paths is a collection of paths that map requests to backends.
            """
            if self._in_context and value_or_callback is None:
                context = ListBuilderContext[HTTPIngressPath.Builder]()
                context._parent_builder = self
                context._field_name = "paths"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(HTTPIngressPath.list_builder())
                if isinstance(output, GenericListBuilder):
                    value = output.build()
                else:
                    value = output
            return self._set("paths", value)

    class BuilderContext(BuilderContextBase["HTTPIngressRuleValue.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = HTTPIngressRuleValue.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for HTTPIngressRuleValue."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["HTTPIngressRuleValue", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use HTTPIngressRuleValue.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    paths: List[HTTPIngressPath]
    """
    paths is a collection of paths that map requests to backends.
    """


class IngressRule(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["IngressRule"]:
            return IngressRule

        def build(self) -> "IngressRule":
            return IngressRule(**self._attrs)

        def host(self, value: Optional[str], /) -> Self:
            """
            host is the fully qualified domain name of a network host, as defined by RFC 3986. Note the following deviations from the "host" part of the URI as defined in RFC 3986: 1. IPs are not allowed. Currently an IngressRuleValue can only apply to
               the IP in the Spec of the parent Ingress.
            2. The `:` delimiter is not respected because ports are not allowed.
                  Currently the port of an Ingress is implicitly :80 for http and
                  :443 for https.
            Both these may change in the future. Incoming requests are matched against the host before the IngressRuleValue. If the host is unspecified, the Ingress routes all traffic based on the specified IngressRuleValue.

            host can be "precise" which is a domain name without the terminating dot of a network host (e.g. "foo.bar.com") or "wildcard", which is a domain name prefixed with a single wildcard label (e.g. "*.foo.com"). The wildcard character '*' must appear by itself as the first DNS label and matches only a single label. You cannot have a wildcard label by itself (e.g. Host == "*"). Requests will be matched against the Host field in the following way: 1. If host is precise, the request matches this rule if the http host header is equal to Host. 2. If host is a wildcard, then the request matches this rule if the http host header is to equal to the suffix (removing the first label) of the wildcard rule.
            """
            return self._set("host", value)

        @overload
        def http(
            self, value_or_callback: Optional[HTTPIngressRuleValue], /
        ) -> "IngressRule.Builder": ...

        @overload
        def http(
            self,
            value_or_callback: Callable[
                [HTTPIngressRuleValue.Builder],
                HTTPIngressRuleValue.Builder | HTTPIngressRuleValue,
            ],
            /,
        ) -> "IngressRule.Builder": ...

        @overload
        def http(self, value_or_callback: Never = ...) -> "HTTPIngressRuleValue.BuilderContext": ...

        def http(self, value_or_callback=None, /):
            if self._in_context and value_or_callback is None:
                context = HTTPIngressRuleValue.BuilderContext()
                context._parent_builder = self
                context._field_name = "http"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(HTTPIngressRuleValue.builder())
                if isinstance(output, HTTPIngressRuleValue.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("http", value)

    class BuilderContext(BuilderContextBase["IngressRule.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = IngressRule.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for IngressRule."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["IngressRule", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use IngressRule.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    host: Optional[str] = None
    """
    host is the fully qualified domain name of a network host, as defined by RFC 3986. Note the following deviations from the "host" part of the URI as defined in RFC 3986: 1. IPs are not allowed. Currently an IngressRuleValue can only apply to
       the IP in the Spec of the parent Ingress.
    2. The `:` delimiter is not respected because ports are not allowed.
          Currently the port of an Ingress is implicitly :80 for http and
          :443 for https.
    Both these may change in the future. Incoming requests are matched against the host before the IngressRuleValue. If the host is unspecified, the Ingress routes all traffic based on the specified IngressRuleValue.

    host can be "precise" which is a domain name without the terminating dot of a network host (e.g. "foo.bar.com") or "wildcard", which is a domain name prefixed with a single wildcard label (e.g. "*.foo.com"). The wildcard character '*' must appear by itself as the first DNS label and matches only a single label. You cannot have a wildcard label by itself (e.g. Host == "*"). Requests will be matched against the Host field in the following way: 1. If host is precise, the request matches this rule if the http host header is equal to Host. 2. If host is a wildcard, then the request matches this rule if the http host header is to equal to the suffix (removing the first label) of the wildcard rule.
    """
    http: Optional[HTTPIngressRuleValue] = None


class IngressSpec(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["IngressSpec"]:
            return IngressSpec

        def build(self) -> "IngressSpec":
            return IngressSpec(**self._attrs)

        @overload
        def default_backend(
            self, value_or_callback: Optional[IngressBackend], /
        ) -> "IngressSpec.Builder": ...

        @overload
        def default_backend(
            self,
            value_or_callback: Callable[
                [IngressBackend.Builder], IngressBackend.Builder | IngressBackend
            ],
            /,
        ) -> "IngressSpec.Builder": ...

        @overload
        def default_backend(
            self, value_or_callback: Never = ...
        ) -> "IngressBackend.BuilderContext": ...

        def default_backend(self, value_or_callback=None, /):
            """
            defaultBackend is the backend that should handle requests that don't match any rule. If Rules are not specified, DefaultBackend must be specified. If DefaultBackend is not set, the handling of requests that do not match any of the rules will be up to the Ingress controller.
            """
            if self._in_context and value_or_callback is None:
                context = IngressBackend.BuilderContext()
                context._parent_builder = self
                context._field_name = "default_backend"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(IngressBackend.builder())
                if isinstance(output, IngressBackend.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("default_backend", value)

        def ingress_class_name(self, value: Optional[str], /) -> Self:
            """
            ingressClassName is the name of an IngressClass cluster resource. Ingress controller implementations use this field to know whether they should be serving this Ingress resource, by a transitive connection (controller -> IngressClass -> Ingress resource). Although the `kubernetes.io/ingress.class` annotation (simple constant name) was never formally defined, it was widely supported by Ingress controllers to create a direct binding between Ingress controller and Ingress resources. Newly created Ingress resources should prefer using the field. However, even though the annotation is officially deprecated, for backwards compatibility reasons, ingress controllers should still honor that annotation if present.
            """
            return self._set("ingress_class_name", value)

        @overload
        def rules(self, value_or_callback: List[IngressRule], /) -> "IngressSpec.Builder": ...

        @overload
        def rules(
            self,
            value_or_callback: Callable[
                [GenericListBuilder[IngressRule, IngressRule.Builder]],
                GenericListBuilder[IngressRule, IngressRule.Builder] | List[IngressRule],
            ],
            /,
        ) -> "IngressSpec.Builder": ...

        @overload
        def rules(
            self, value_or_callback: Never = ...
        ) -> ListBuilderContext[IngressRule.Builder]: ...

        def rules(self, value_or_callback=None, /):
            """
            rules is a list of host rules used to configure the Ingress. If unspecified, or no rule matches, all traffic is sent to the default backend.
            """
            if self._in_context and value_or_callback is None:
                context = ListBuilderContext[IngressRule.Builder]()
                context._parent_builder = self
                context._field_name = "rules"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(IngressRule.list_builder())
                if isinstance(output, GenericListBuilder):
                    value = output.build()
                else:
                    value = output
            return self._set("rules", value)

        @overload
        def tls(self, value_or_callback: List[IngressTLS], /) -> "IngressSpec.Builder": ...

        @overload
        def tls(
            self,
            value_or_callback: Callable[
                [GenericListBuilder[IngressTLS, IngressTLS.Builder]],
                GenericListBuilder[IngressTLS, IngressTLS.Builder] | List[IngressTLS],
            ],
            /,
        ) -> "IngressSpec.Builder": ...

        @overload
        def tls(self, value_or_callback: Never = ...) -> ListBuilderContext[IngressTLS.Builder]: ...

        def tls(self, value_or_callback=None, /):
            """
            tls represents the TLS configuration. Currently the Ingress only supports a single TLS port, 443. If multiple members of this list specify different hosts, they will be multiplexed on the same port according to the hostname specified through the SNI TLS extension, if the ingress controller fulfilling the ingress supports SNI.
            """
            if self._in_context and value_or_callback is None:
                context = ListBuilderContext[IngressTLS.Builder]()
                context._parent_builder = self
                context._field_name = "tls"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(IngressTLS.list_builder())
                if isinstance(output, GenericListBuilder):
                    value = output.build()
                else:
                    value = output
            return self._set("tls", value)

    class BuilderContext(BuilderContextBase["IngressSpec.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = IngressSpec.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for IngressSpec."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["IngressSpec", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use IngressSpec.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    default_backend: Annotated[Optional[IngressBackend], Field(alias="defaultBackend")] = None
    """
    defaultBackend is the backend that should handle requests that don't match any rule. If Rules are not specified, DefaultBackend must be specified. If DefaultBackend is not set, the handling of requests that do not match any of the rules will be up to the Ingress controller.
    """
    ingress_class_name: Annotated[Optional[str], Field(alias="ingressClassName")] = None
    """
    ingressClassName is the name of an IngressClass cluster resource. Ingress controller implementations use this field to know whether they should be serving this Ingress resource, by a transitive connection (controller -> IngressClass -> Ingress resource). Although the `kubernetes.io/ingress.class` annotation (simple constant name) was never formally defined, it was widely supported by Ingress controllers to create a direct binding between Ingress controller and Ingress resources. Newly created Ingress resources should prefer using the field. However, even though the annotation is officially deprecated, for backwards compatibility reasons, ingress controllers should still honor that annotation if present.
    """
    rules: Optional[List[IngressRule]] = None
    """
    rules is a list of host rules used to configure the Ingress. If unspecified, or no rule matches, all traffic is sent to the default backend.
    """
    tls: Optional[List[IngressTLS]] = None
    """
    tls represents the TLS configuration. Currently the Ingress only supports a single TLS port, 443. If multiple members of this list specify different hosts, they will be multiplexed on the same port according to the hostname specified through the SNI TLS extension, if the ingress controller fulfilling the ingress supports SNI.
    """


class NetworkPolicyEgressRule(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["NetworkPolicyEgressRule"]:
            return NetworkPolicyEgressRule

        def build(self) -> "NetworkPolicyEgressRule":
            return NetworkPolicyEgressRule(**self._attrs)

        @overload
        def ports(
            self, value_or_callback: List[NetworkPolicyPort], /
        ) -> "NetworkPolicyEgressRule.Builder": ...

        @overload
        def ports(
            self,
            value_or_callback: Callable[
                [GenericListBuilder[NetworkPolicyPort, NetworkPolicyPort.Builder]],
                GenericListBuilder[NetworkPolicyPort, NetworkPolicyPort.Builder]
                | List[NetworkPolicyPort],
            ],
            /,
        ) -> "NetworkPolicyEgressRule.Builder": ...

        @overload
        def ports(
            self, value_or_callback: Never = ...
        ) -> ListBuilderContext[NetworkPolicyPort.Builder]: ...

        def ports(self, value_or_callback=None, /):
            """
            ports is a list of destination ports for outgoing traffic. Each item in this list is combined using a logical OR. If this field is empty or missing, this rule matches all ports (traffic not restricted by port). If this field is present and contains at least one item, then this rule allows traffic only if the traffic matches at least one port in the list.
            """
            if self._in_context and value_or_callback is None:
                context = ListBuilderContext[NetworkPolicyPort.Builder]()
                context._parent_builder = self
                context._field_name = "ports"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(NetworkPolicyPort.list_builder())
                if isinstance(output, GenericListBuilder):
                    value = output.build()
                else:
                    value = output
            return self._set("ports", value)

        @overload
        def to(
            self, value_or_callback: List[NetworkPolicyPeer], /
        ) -> "NetworkPolicyEgressRule.Builder": ...

        @overload
        def to(
            self,
            value_or_callback: Callable[
                [GenericListBuilder[NetworkPolicyPeer, NetworkPolicyPeer.Builder]],
                GenericListBuilder[NetworkPolicyPeer, NetworkPolicyPeer.Builder]
                | List[NetworkPolicyPeer],
            ],
            /,
        ) -> "NetworkPolicyEgressRule.Builder": ...

        @overload
        def to(
            self, value_or_callback: Never = ...
        ) -> ListBuilderContext[NetworkPolicyPeer.Builder]: ...

        def to(self, value_or_callback=None, /):
            """
            to is a list of destinations for outgoing traffic of pods selected for this rule. Items in this list are combined using a logical OR operation. If this field is empty or missing, this rule matches all destinations (traffic not restricted by destination). If this field is present and contains at least one item, this rule allows traffic only if the traffic matches at least one item in the to list.
            """
            if self._in_context and value_or_callback is None:
                context = ListBuilderContext[NetworkPolicyPeer.Builder]()
                context._parent_builder = self
                context._field_name = "to"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(NetworkPolicyPeer.list_builder())
                if isinstance(output, GenericListBuilder):
                    value = output.build()
                else:
                    value = output
            return self._set("to", value)

    class BuilderContext(BuilderContextBase["NetworkPolicyEgressRule.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = NetworkPolicyEgressRule.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for NetworkPolicyEgressRule."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["NetworkPolicyEgressRule", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use NetworkPolicyEgressRule.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    ports: Optional[List[NetworkPolicyPort]] = None
    """
    ports is a list of destination ports for outgoing traffic. Each item in this list is combined using a logical OR. If this field is empty or missing, this rule matches all ports (traffic not restricted by port). If this field is present and contains at least one item, then this rule allows traffic only if the traffic matches at least one port in the list.
    """
    to: Optional[List[NetworkPolicyPeer]] = None
    """
    to is a list of destinations for outgoing traffic of pods selected for this rule. Items in this list are combined using a logical OR operation. If this field is empty or missing, this rule matches all destinations (traffic not restricted by destination). If this field is present and contains at least one item, this rule allows traffic only if the traffic matches at least one item in the to list.
    """


class NetworkPolicyIngressRule(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["NetworkPolicyIngressRule"]:
            return NetworkPolicyIngressRule

        def build(self) -> "NetworkPolicyIngressRule":
            return NetworkPolicyIngressRule(**self._attrs)

        @overload
        def from_(
            self, value_or_callback: List[NetworkPolicyPeer], /
        ) -> "NetworkPolicyIngressRule.Builder": ...

        @overload
        def from_(
            self,
            value_or_callback: Callable[
                [GenericListBuilder[NetworkPolicyPeer, NetworkPolicyPeer.Builder]],
                GenericListBuilder[NetworkPolicyPeer, NetworkPolicyPeer.Builder]
                | List[NetworkPolicyPeer],
            ],
            /,
        ) -> "NetworkPolicyIngressRule.Builder": ...

        @overload
        def from_(
            self, value_or_callback: Never = ...
        ) -> ListBuilderContext[NetworkPolicyPeer.Builder]: ...

        def from_(self, value_or_callback=None, /):
            """
            from is a list of sources which should be able to access the pods selected for this rule. Items in this list are combined using a logical OR operation. If this field is empty or missing, this rule matches all sources (traffic not restricted by source). If this field is present and contains at least one item, this rule allows traffic only if the traffic matches at least one item in the from list.
            """
            if self._in_context and value_or_callback is None:
                context = ListBuilderContext[NetworkPolicyPeer.Builder]()
                context._parent_builder = self
                context._field_name = "from_"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(NetworkPolicyPeer.list_builder())
                if isinstance(output, GenericListBuilder):
                    value = output.build()
                else:
                    value = output
            return self._set("from_", value)

        @overload
        def ports(
            self, value_or_callback: List[NetworkPolicyPort], /
        ) -> "NetworkPolicyIngressRule.Builder": ...

        @overload
        def ports(
            self,
            value_or_callback: Callable[
                [GenericListBuilder[NetworkPolicyPort, NetworkPolicyPort.Builder]],
                GenericListBuilder[NetworkPolicyPort, NetworkPolicyPort.Builder]
                | List[NetworkPolicyPort],
            ],
            /,
        ) -> "NetworkPolicyIngressRule.Builder": ...

        @overload
        def ports(
            self, value_or_callback: Never = ...
        ) -> ListBuilderContext[NetworkPolicyPort.Builder]: ...

        def ports(self, value_or_callback=None, /):
            """
            ports is a list of ports which should be made accessible on the pods selected for this rule. Each item in this list is combined using a logical OR. If this field is empty or missing, this rule matches all ports (traffic not restricted by port). If this field is present and contains at least one item, then this rule allows traffic only if the traffic matches at least one port in the list.
            """
            if self._in_context and value_or_callback is None:
                context = ListBuilderContext[NetworkPolicyPort.Builder]()
                context._parent_builder = self
                context._field_name = "ports"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(NetworkPolicyPort.list_builder())
                if isinstance(output, GenericListBuilder):
                    value = output.build()
                else:
                    value = output
            return self._set("ports", value)

    class BuilderContext(BuilderContextBase["NetworkPolicyIngressRule.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = NetworkPolicyIngressRule.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for NetworkPolicyIngressRule."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["NetworkPolicyIngressRule", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use NetworkPolicyIngressRule.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    from_: Annotated[Optional[List[NetworkPolicyPeer]], Field(alias="from")] = None
    """
    from is a list of sources which should be able to access the pods selected for this rule. Items in this list are combined using a logical OR operation. If this field is empty or missing, this rule matches all sources (traffic not restricted by source). If this field is present and contains at least one item, this rule allows traffic only if the traffic matches at least one item in the from list.
    """
    ports: Optional[List[NetworkPolicyPort]] = None
    """
    ports is a list of ports which should be made accessible on the pods selected for this rule. Each item in this list is combined using a logical OR. If this field is empty or missing, this rule matches all ports (traffic not restricted by port). If this field is present and contains at least one item, then this rule allows traffic only if the traffic matches at least one port in the list.
    """


class NetworkPolicySpec(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["NetworkPolicySpec"]:
            return NetworkPolicySpec

        def build(self) -> "NetworkPolicySpec":
            return NetworkPolicySpec(**self._attrs)

        @overload
        def egress(
            self, value_or_callback: List[NetworkPolicyEgressRule], /
        ) -> "NetworkPolicySpec.Builder": ...

        @overload
        def egress(
            self,
            value_or_callback: Callable[
                [GenericListBuilder[NetworkPolicyEgressRule, NetworkPolicyEgressRule.Builder]],
                GenericListBuilder[NetworkPolicyEgressRule, NetworkPolicyEgressRule.Builder]
                | List[NetworkPolicyEgressRule],
            ],
            /,
        ) -> "NetworkPolicySpec.Builder": ...

        @overload
        def egress(
            self, value_or_callback: Never = ...
        ) -> ListBuilderContext[NetworkPolicyEgressRule.Builder]: ...

        def egress(self, value_or_callback=None, /):
            """
            egress is a list of egress rules to be applied to the selected pods. Outgoing traffic is allowed if there are no NetworkPolicies selecting the pod (and cluster policy otherwise allows the traffic), OR if the traffic matches at least one egress rule across all of the NetworkPolicy objects whose podSelector matches the pod. If this field is empty then this NetworkPolicy limits all outgoing traffic (and serves solely to ensure that the pods it selects are isolated by default). This field is beta-level in 1.8
            """
            if self._in_context and value_or_callback is None:
                context = ListBuilderContext[NetworkPolicyEgressRule.Builder]()
                context._parent_builder = self
                context._field_name = "egress"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(NetworkPolicyEgressRule.list_builder())
                if isinstance(output, GenericListBuilder):
                    value = output.build()
                else:
                    value = output
            return self._set("egress", value)

        @overload
        def ingress(
            self, value_or_callback: List[NetworkPolicyIngressRule], /
        ) -> "NetworkPolicySpec.Builder": ...

        @overload
        def ingress(
            self,
            value_or_callback: Callable[
                [GenericListBuilder[NetworkPolicyIngressRule, NetworkPolicyIngressRule.Builder]],
                GenericListBuilder[NetworkPolicyIngressRule, NetworkPolicyIngressRule.Builder]
                | List[NetworkPolicyIngressRule],
            ],
            /,
        ) -> "NetworkPolicySpec.Builder": ...

        @overload
        def ingress(
            self, value_or_callback: Never = ...
        ) -> ListBuilderContext[NetworkPolicyIngressRule.Builder]: ...

        def ingress(self, value_or_callback=None, /):
            """
            ingress is a list of ingress rules to be applied to the selected pods. Traffic is allowed to a pod if there are no NetworkPolicies selecting the pod (and cluster policy otherwise allows the traffic), OR if the traffic source is the pod's local node, OR if the traffic matches at least one ingress rule across all of the NetworkPolicy objects whose podSelector matches the pod. If this field is empty then this NetworkPolicy does not allow any traffic (and serves solely to ensure that the pods it selects are isolated by default)
            """
            if self._in_context and value_or_callback is None:
                context = ListBuilderContext[NetworkPolicyIngressRule.Builder]()
                context._parent_builder = self
                context._field_name = "ingress"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(NetworkPolicyIngressRule.list_builder())
                if isinstance(output, GenericListBuilder):
                    value = output.build()
                else:
                    value = output
            return self._set("ingress", value)

        @overload
        def pod_selector(
            self, value_or_callback: apimachinery.LabelSelector, /
        ) -> "NetworkPolicySpec.Builder": ...

        @overload
        def pod_selector(
            self,
            value_or_callback: Callable[
                [apimachinery.LabelSelector.Builder],
                apimachinery.LabelSelector.Builder | apimachinery.LabelSelector,
            ],
            /,
        ) -> "NetworkPolicySpec.Builder": ...

        @overload
        def pod_selector(
            self, value_or_callback: Never = ...
        ) -> "apimachinery.LabelSelector.BuilderContext": ...

        def pod_selector(self, value_or_callback=None, /):
            """
            podSelector selects the pods to which this NetworkPolicy object applies. The array of ingress rules is applied to any pods selected by this field. Multiple network policies can select the same set of pods. In this case, the ingress rules for each are combined additively. This field is NOT optional and follows standard label selector semantics. An empty podSelector matches all pods in this namespace.
            """
            if self._in_context and value_or_callback is None:
                context = apimachinery.LabelSelector.BuilderContext()
                context._parent_builder = self
                context._field_name = "pod_selector"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(apimachinery.LabelSelector.builder())
                if isinstance(output, apimachinery.LabelSelector.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("pod_selector", value)

        def policy_types(self, value: Optional[List[str]], /) -> Self:
            """
            policyTypes is a list of rule types that the NetworkPolicy relates to. Valid options are ["Ingress"], ["Egress"], or ["Ingress", "Egress"]. If this field is not specified, it will default based on the existence of ingress or egress rules; policies that contain an egress section are assumed to affect egress, and all policies (whether or not they contain an ingress section) are assumed to affect ingress. If you want to write an egress-only policy, you must explicitly specify policyTypes [ "Egress" ]. Likewise, if you want to write a policy that specifies that no egress is allowed, you must specify a policyTypes value that include "Egress" (since such a policy would not include an egress section and would otherwise default to just [ "Ingress" ]). This field is beta-level in 1.8
            """
            return self._set("policy_types", value)

    class BuilderContext(BuilderContextBase["NetworkPolicySpec.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = NetworkPolicySpec.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for NetworkPolicySpec."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["NetworkPolicySpec", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use NetworkPolicySpec.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    egress: Optional[List[NetworkPolicyEgressRule]] = None
    """
    egress is a list of egress rules to be applied to the selected pods. Outgoing traffic is allowed if there are no NetworkPolicies selecting the pod (and cluster policy otherwise allows the traffic), OR if the traffic matches at least one egress rule across all of the NetworkPolicy objects whose podSelector matches the pod. If this field is empty then this NetworkPolicy limits all outgoing traffic (and serves solely to ensure that the pods it selects are isolated by default). This field is beta-level in 1.8
    """
    ingress: Optional[List[NetworkPolicyIngressRule]] = None
    """
    ingress is a list of ingress rules to be applied to the selected pods. Traffic is allowed to a pod if there are no NetworkPolicies selecting the pod (and cluster policy otherwise allows the traffic), OR if the traffic source is the pod's local node, OR if the traffic matches at least one ingress rule across all of the NetworkPolicy objects whose podSelector matches the pod. If this field is empty then this NetworkPolicy does not allow any traffic (and serves solely to ensure that the pods it selects are isolated by default)
    """
    pod_selector: Annotated[apimachinery.LabelSelector, Field(alias="podSelector")]
    """
    podSelector selects the pods to which this NetworkPolicy object applies. The array of ingress rules is applied to any pods selected by this field. Multiple network policies can select the same set of pods. In this case, the ingress rules for each are combined additively. This field is NOT optional and follows standard label selector semantics. An empty podSelector matches all pods in this namespace.
    """
    policy_types: Annotated[Optional[List[str]], Field(alias="policyTypes")] = None
    """
    policyTypes is a list of rule types that the NetworkPolicy relates to. Valid options are ["Ingress"], ["Egress"], or ["Ingress", "Egress"]. If this field is not specified, it will default based on the existence of ingress or egress rules; policies that contain an egress section are assumed to affect egress, and all policies (whether or not they contain an ingress section) are assumed to affect ingress. If you want to write an egress-only policy, you must explicitly specify policyTypes [ "Egress" ]. Likewise, if you want to write a policy that specifies that no egress is allowed, you must specify a policyTypes value that include "Egress" (since such a policy would not include an egress section and would otherwise default to just [ "Ingress" ]). This field is beta-level in 1.8
    """


class Ingress(Resource):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["Ingress"]:
            return Ingress

        def build(self) -> "Ingress":
            return Ingress(**self._attrs)

        def api_version(self, value: Optional[Literal["networking.k8s.io/v1"]], /) -> Self:
            """
            APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
            """
            return self._set("api_version", value)

        def kind(self, value: Optional[Literal["Ingress"]], /) -> Self:
            """
            Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
            """
            return self._set("kind", value)

        @overload
        def metadata(
            self, value_or_callback: Optional[apimachinery.ObjectMeta], /
        ) -> "Ingress.Builder": ...

        @overload
        def metadata(
            self,
            value_or_callback: Callable[
                [apimachinery.ObjectMeta.Builder],
                apimachinery.ObjectMeta.Builder | apimachinery.ObjectMeta,
            ],
            /,
        ) -> "Ingress.Builder": ...

        @overload
        def metadata(
            self, value_or_callback: Never = ...
        ) -> "apimachinery.ObjectMeta.BuilderContext": ...

        def metadata(self, value_or_callback=None, /):
            """
            Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
            """
            if self._in_context and value_or_callback is None:
                context = apimachinery.ObjectMeta.BuilderContext()
                context._parent_builder = self
                context._field_name = "metadata"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(apimachinery.ObjectMeta.builder())
                if isinstance(output, apimachinery.ObjectMeta.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("metadata", value)

        @overload
        def spec(self, value_or_callback: Optional[IngressSpec], /) -> "Ingress.Builder": ...

        @overload
        def spec(
            self,
            value_or_callback: Callable[[IngressSpec.Builder], IngressSpec.Builder | IngressSpec],
            /,
        ) -> "Ingress.Builder": ...

        @overload
        def spec(self, value_or_callback: Never = ...) -> "IngressSpec.BuilderContext": ...

        def spec(self, value_or_callback=None, /):
            """
            spec is the desired state of the Ingress. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
            """
            if self._in_context and value_or_callback is None:
                context = IngressSpec.BuilderContext()
                context._parent_builder = self
                context._field_name = "spec"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(IngressSpec.builder())
                if isinstance(output, IngressSpec.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("spec", value)

        @overload
        def status(self, value_or_callback: Optional[IngressStatus], /) -> "Ingress.Builder": ...

        @overload
        def status(
            self,
            value_or_callback: Callable[
                [IngressStatus.Builder], IngressStatus.Builder | IngressStatus
            ],
            /,
        ) -> "Ingress.Builder": ...

        @overload
        def status(self, value_or_callback: Never = ...) -> "IngressStatus.BuilderContext": ...

        def status(self, value_or_callback=None, /):
            """
            status is the current state of the Ingress. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
            """
            if self._in_context and value_or_callback is None:
                context = IngressStatus.BuilderContext()
                context._parent_builder = self
                context._field_name = "status"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(IngressStatus.builder())
                if isinstance(output, IngressStatus.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("status", value)

    class BuilderContext(BuilderContextBase["Ingress.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = Ingress.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for Ingress."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["Ingress", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use Ingress.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    api_version: Annotated[Optional[Literal["networking.k8s.io/v1"]], Field(alias="apiVersion")] = (
        "networking.k8s.io/v1"
    )
    """
    APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
    """
    kind: Optional[Literal["Ingress"]] = "Ingress"
    """
    Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
    """
    metadata: Optional[apimachinery.ObjectMeta] = None
    """
    Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
    """
    spec: Optional[IngressSpec] = None
    """
    spec is the desired state of the Ingress. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
    """
    status: Optional[IngressStatus] = None
    """
    status is the current state of the Ingress. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
    """


IngressList = ResourceList["Ingress"]


class NetworkPolicy(Resource):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["NetworkPolicy"]:
            return NetworkPolicy

        def build(self) -> "NetworkPolicy":
            return NetworkPolicy(**self._attrs)

        def api_version(self, value: Optional[Literal["networking.k8s.io/v1"]], /) -> Self:
            """
            APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
            """
            return self._set("api_version", value)

        def kind(self, value: Optional[Literal["NetworkPolicy"]], /) -> Self:
            """
            Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
            """
            return self._set("kind", value)

        @overload
        def metadata(
            self, value_or_callback: Optional[apimachinery.ObjectMeta], /
        ) -> "NetworkPolicy.Builder": ...

        @overload
        def metadata(
            self,
            value_or_callback: Callable[
                [apimachinery.ObjectMeta.Builder],
                apimachinery.ObjectMeta.Builder | apimachinery.ObjectMeta,
            ],
            /,
        ) -> "NetworkPolicy.Builder": ...

        @overload
        def metadata(
            self, value_or_callback: Never = ...
        ) -> "apimachinery.ObjectMeta.BuilderContext": ...

        def metadata(self, value_or_callback=None, /):
            """
            Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
            """
            if self._in_context and value_or_callback is None:
                context = apimachinery.ObjectMeta.BuilderContext()
                context._parent_builder = self
                context._field_name = "metadata"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(apimachinery.ObjectMeta.builder())
                if isinstance(output, apimachinery.ObjectMeta.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("metadata", value)

        @overload
        def spec(
            self, value_or_callback: Optional[NetworkPolicySpec], /
        ) -> "NetworkPolicy.Builder": ...

        @overload
        def spec(
            self,
            value_or_callback: Callable[
                [NetworkPolicySpec.Builder],
                NetworkPolicySpec.Builder | NetworkPolicySpec,
            ],
            /,
        ) -> "NetworkPolicy.Builder": ...

        @overload
        def spec(self, value_or_callback: Never = ...) -> "NetworkPolicySpec.BuilderContext": ...

        def spec(self, value_or_callback=None, /):
            """
            spec represents the specification of the desired behavior for this NetworkPolicy.
            """
            if self._in_context and value_or_callback is None:
                context = NetworkPolicySpec.BuilderContext()
                context._parent_builder = self
                context._field_name = "spec"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(NetworkPolicySpec.builder())
                if isinstance(output, NetworkPolicySpec.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("spec", value)

    class BuilderContext(BuilderContextBase["NetworkPolicy.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = NetworkPolicy.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for NetworkPolicy."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["NetworkPolicy", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use NetworkPolicy.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    api_version: Annotated[Optional[Literal["networking.k8s.io/v1"]], Field(alias="apiVersion")] = (
        "networking.k8s.io/v1"
    )
    """
    APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
    """
    kind: Optional[Literal["NetworkPolicy"]] = "NetworkPolicy"
    """
    Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
    """
    metadata: Optional[apimachinery.ObjectMeta] = None
    """
    Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
    """
    spec: Optional[NetworkPolicySpec] = None
    """
    spec represents the specification of the desired behavior for this NetworkPolicy.
    """


NetworkPolicyList = ResourceList["NetworkPolicy"]
