# Generated by cloudcoil-model-codegen v0.5.0
# DO NOT EDIT

from __future__ import annotations

from typing import (
    Annotated,
    Callable,
    List,
    Literal,
    Optional,
    Type,
    overload,
)

from pydantic import Field

from cloudcoil import apimachinery
from cloudcoil.pydantic import (
    BaseModel,
    BaseModelBuilder,
    BuilderContextBase,
    GenericListBuilder,
    ListBuilderContext,
    Never,
    Self,
)
from cloudcoil.resources import Resource, ResourceList


class ExemptPriorityLevelConfiguration(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["ExemptPriorityLevelConfiguration"]:
            return ExemptPriorityLevelConfiguration

        def build(self) -> "ExemptPriorityLevelConfiguration":
            return ExemptPriorityLevelConfiguration(**self._attrs)

        def lendable_percent(self, value: Optional[int], /) -> Self:
            """
            `lendablePercent` prescribes the fraction of the level's NominalCL that can be borrowed by other priority levels.  This value of this field must be between 0 and 100, inclusive, and it defaults to 0. The number of seats that other levels can borrow from this level, known as this level's LendableConcurrencyLimit (LendableCL), is defined as follows.

            LendableCL(i) = round( NominalCL(i) * lendablePercent(i)/100.0 )
            """
            return self._set("lendable_percent", value)

        def nominal_concurrency_shares(self, value: Optional[int], /) -> Self:
            """
            `nominalConcurrencyShares` (NCS) contributes to the computation of the NominalConcurrencyLimit (NominalCL) of this level. This is the number of execution seats nominally reserved for this priority level. This DOES NOT limit the dispatching from this priority level but affects the other priority levels through the borrowing mechanism. The server's concurrency limit (ServerCL) is divided among all the priority levels in proportion to their NCS values:

            NominalCL(i)  = ceil( ServerCL * NCS(i) / sum_ncs ) sum_ncs = sum[priority level k] NCS(k)

            Bigger numbers mean a larger nominal concurrency limit, at the expense of every other priority level. This field has a default value of zero.
            """
            return self._set("nominal_concurrency_shares", value)

    class BuilderContext(BuilderContextBase["ExemptPriorityLevelConfiguration.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = ExemptPriorityLevelConfiguration.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for ExemptPriorityLevelConfiguration."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["ExemptPriorityLevelConfiguration", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use ExemptPriorityLevelConfiguration.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    lendable_percent: Annotated[Optional[int], Field(alias="lendablePercent")] = None
    """
    `lendablePercent` prescribes the fraction of the level's NominalCL that can be borrowed by other priority levels.  This value of this field must be between 0 and 100, inclusive, and it defaults to 0. The number of seats that other levels can borrow from this level, known as this level's LendableConcurrencyLimit (LendableCL), is defined as follows.

    LendableCL(i) = round( NominalCL(i) * lendablePercent(i)/100.0 )
    """
    nominal_concurrency_shares: Annotated[
        Optional[int], Field(alias="nominalConcurrencyShares")
    ] = None
    """
    `nominalConcurrencyShares` (NCS) contributes to the computation of the NominalConcurrencyLimit (NominalCL) of this level. This is the number of execution seats nominally reserved for this priority level. This DOES NOT limit the dispatching from this priority level but affects the other priority levels through the borrowing mechanism. The server's concurrency limit (ServerCL) is divided among all the priority levels in proportion to their NCS values:

    NominalCL(i)  = ceil( ServerCL * NCS(i) / sum_ncs ) sum_ncs = sum[priority level k] NCS(k)

    Bigger numbers mean a larger nominal concurrency limit, at the expense of every other priority level. This field has a default value of zero.
    """


class FlowDistinguisherMethod(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["FlowDistinguisherMethod"]:
            return FlowDistinguisherMethod

        def build(self) -> "FlowDistinguisherMethod":
            return FlowDistinguisherMethod(**self._attrs)

        def type(self, value: str, /) -> Self:
            """
            `type` is the type of flow distinguisher method The supported types are "ByUser" and "ByNamespace". Required.
            """
            return self._set("type", value)

    class BuilderContext(BuilderContextBase["FlowDistinguisherMethod.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = FlowDistinguisherMethod.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for FlowDistinguisherMethod."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["FlowDistinguisherMethod", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use FlowDistinguisherMethod.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    type: str
    """
    `type` is the type of flow distinguisher method The supported types are "ByUser" and "ByNamespace". Required.
    """


class GroupSubject(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["GroupSubject"]:
            return GroupSubject

        def build(self) -> "GroupSubject":
            return GroupSubject(**self._attrs)

        def name(self, value: str, /) -> Self:
            """
            name is the user group that matches, or "*" to match all user groups. See https://github.com/kubernetes/apiserver/blob/master/pkg/authentication/user/user.go for some well-known group names. Required.
            """
            return self._set("name", value)

    class BuilderContext(BuilderContextBase["GroupSubject.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = GroupSubject.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for GroupSubject."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["GroupSubject", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use GroupSubject.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    name: str
    """
    name is the user group that matches, or "*" to match all user groups. See https://github.com/kubernetes/apiserver/blob/master/pkg/authentication/user/user.go for some well-known group names. Required.
    """


class NonResourcePolicyRule(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["NonResourcePolicyRule"]:
            return NonResourcePolicyRule

        def build(self) -> "NonResourcePolicyRule":
            return NonResourcePolicyRule(**self._attrs)

        def non_resource_ur_ls(self, value: List[str], /) -> Self:
            """
            `nonResourceURLs` is a set of url prefixes that a user should have access to and may not be empty. For example:
              - "/healthz" is legal
              - "/hea*" is illegal
              - "/hea" is legal but matches nothing
              - "/hea/*" also matches nothing
              - "/healthz/*" matches all per-component health checks.
            "*" matches all non-resource urls. if it is present, it must be the only entry. Required.
            """
            return self._set("non_resource_ur_ls", value)

        def verbs(self, value: List[str], /) -> Self:
            """
            `verbs` is a list of matching verbs and may not be empty. "*" matches all verbs. If it is present, it must be the only entry. Required.
            """
            return self._set("verbs", value)

    class BuilderContext(BuilderContextBase["NonResourcePolicyRule.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = NonResourcePolicyRule.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for NonResourcePolicyRule."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["NonResourcePolicyRule", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use NonResourcePolicyRule.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    non_resource_ur_ls: Annotated[List[str], Field(alias="nonResourceURLs")]
    """
    `nonResourceURLs` is a set of url prefixes that a user should have access to and may not be empty. For example:
      - "/healthz" is legal
      - "/hea*" is illegal
      - "/hea" is legal but matches nothing
      - "/hea/*" also matches nothing
      - "/healthz/*" matches all per-component health checks.
    "*" matches all non-resource urls. if it is present, it must be the only entry. Required.
    """
    verbs: List[str]
    """
    `verbs` is a list of matching verbs and may not be empty. "*" matches all verbs. If it is present, it must be the only entry. Required.
    """


class PriorityLevelConfigurationReference(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["PriorityLevelConfigurationReference"]:
            return PriorityLevelConfigurationReference

        def build(self) -> "PriorityLevelConfigurationReference":
            return PriorityLevelConfigurationReference(**self._attrs)

        def name(self, value: str, /) -> Self:
            """
            `name` is the name of the priority level configuration being referenced Required.
            """
            return self._set("name", value)

    class BuilderContext(BuilderContextBase["PriorityLevelConfigurationReference.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = PriorityLevelConfigurationReference.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for PriorityLevelConfigurationReference."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["PriorityLevelConfigurationReference", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use PriorityLevelConfigurationReference.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    name: str
    """
    `name` is the name of the priority level configuration being referenced Required.
    """


class QueuingConfiguration(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["QueuingConfiguration"]:
            return QueuingConfiguration

        def build(self) -> "QueuingConfiguration":
            return QueuingConfiguration(**self._attrs)

        def hand_size(self, value: Optional[int], /) -> Self:
            """
            `handSize` is a small positive number that configures the shuffle sharding of requests into queues.  When enqueuing a request at this priority level the request's flow identifier (a string pair) is hashed and the hash value is used to shuffle the list of queues and deal a hand of the size specified here.  The request is put into one of the shortest queues in that hand. `handSize` must be no larger than `queues`, and should be significantly smaller (so that a few heavy flows do not saturate most of the queues).  See the user-facing documentation for more extensive guidance on setting this field.  This field has a default value of 8.
            """
            return self._set("hand_size", value)

        def queue_length_limit(self, value: Optional[int], /) -> Self:
            """
            `queueLengthLimit` is the maximum number of requests allowed to be waiting in a given queue of this priority level at a time; excess requests are rejected.  This value must be positive.  If not specified, it will be defaulted to 50.
            """
            return self._set("queue_length_limit", value)

        def queues(self, value: Optional[int], /) -> Self:
            """
            `queues` is the number of queues for this priority level. The queues exist independently at each apiserver. The value must be positive.  Setting it to 1 effectively precludes shufflesharding and thus makes the distinguisher method of associated flow schemas irrelevant.  This field has a default value of 64.
            """
            return self._set("queues", value)

    class BuilderContext(BuilderContextBase["QueuingConfiguration.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = QueuingConfiguration.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for QueuingConfiguration."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["QueuingConfiguration", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use QueuingConfiguration.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    hand_size: Annotated[Optional[int], Field(alias="handSize")] = None
    """
    `handSize` is a small positive number that configures the shuffle sharding of requests into queues.  When enqueuing a request at this priority level the request's flow identifier (a string pair) is hashed and the hash value is used to shuffle the list of queues and deal a hand of the size specified here.  The request is put into one of the shortest queues in that hand. `handSize` must be no larger than `queues`, and should be significantly smaller (so that a few heavy flows do not saturate most of the queues).  See the user-facing documentation for more extensive guidance on setting this field.  This field has a default value of 8.
    """
    queue_length_limit: Annotated[Optional[int], Field(alias="queueLengthLimit")] = None
    """
    `queueLengthLimit` is the maximum number of requests allowed to be waiting in a given queue of this priority level at a time; excess requests are rejected.  This value must be positive.  If not specified, it will be defaulted to 50.
    """
    queues: Optional[int] = None
    """
    `queues` is the number of queues for this priority level. The queues exist independently at each apiserver. The value must be positive.  Setting it to 1 effectively precludes shufflesharding and thus makes the distinguisher method of associated flow schemas irrelevant.  This field has a default value of 64.
    """


class ResourcePolicyRule(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["ResourcePolicyRule"]:
            return ResourcePolicyRule

        def build(self) -> "ResourcePolicyRule":
            return ResourcePolicyRule(**self._attrs)

        def api_groups(self, value: List[str], /) -> Self:
            """
            `apiGroups` is a list of matching API groups and may not be empty. "*" matches all API groups and, if present, must be the only entry. Required.
            """
            return self._set("api_groups", value)

        def cluster_scope(self, value: Optional[bool], /) -> Self:
            """
            `clusterScope` indicates whether to match requests that do not specify a namespace (which happens either because the resource is not namespaced or the request targets all namespaces). If this field is omitted or false then the `namespaces` field must contain a non-empty list.
            """
            return self._set("cluster_scope", value)

        def namespaces(self, value: Optional[List[str]], /) -> Self:
            """
            `namespaces` is a list of target namespaces that restricts matches.  A request that specifies a target namespace matches only if either (a) this list contains that target namespace or (b) this list contains "*".  Note that "*" matches any specified namespace but does not match a request that _does not specify_ a namespace (see the `clusterScope` field for that). This list may be empty, but only if `clusterScope` is true.
            """
            return self._set("namespaces", value)

        def resources(self, value: List[str], /) -> Self:
            """
            `resources` is a list of matching resources (i.e., lowercase and plural) with, if desired, subresource.  For example, [ "services", "nodes/status" ].  This list may not be empty. "*" matches all resources and, if present, must be the only entry. Required.
            """
            return self._set("resources", value)

        def verbs(self, value: List[str], /) -> Self:
            """
            `verbs` is a list of matching verbs and may not be empty. "*" matches all verbs and, if present, must be the only entry. Required.
            """
            return self._set("verbs", value)

    class BuilderContext(BuilderContextBase["ResourcePolicyRule.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = ResourcePolicyRule.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for ResourcePolicyRule."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["ResourcePolicyRule", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use ResourcePolicyRule.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    api_groups: Annotated[List[str], Field(alias="apiGroups")]
    """
    `apiGroups` is a list of matching API groups and may not be empty. "*" matches all API groups and, if present, must be the only entry. Required.
    """
    cluster_scope: Annotated[Optional[bool], Field(alias="clusterScope")] = None
    """
    `clusterScope` indicates whether to match requests that do not specify a namespace (which happens either because the resource is not namespaced or the request targets all namespaces). If this field is omitted or false then the `namespaces` field must contain a non-empty list.
    """
    namespaces: Optional[List[str]] = None
    """
    `namespaces` is a list of target namespaces that restricts matches.  A request that specifies a target namespace matches only if either (a) this list contains that target namespace or (b) this list contains "*".  Note that "*" matches any specified namespace but does not match a request that _does not specify_ a namespace (see the `clusterScope` field for that). This list may be empty, but only if `clusterScope` is true.
    """
    resources: List[str]
    """
    `resources` is a list of matching resources (i.e., lowercase and plural) with, if desired, subresource.  For example, [ "services", "nodes/status" ].  This list may not be empty. "*" matches all resources and, if present, must be the only entry. Required.
    """
    verbs: List[str]
    """
    `verbs` is a list of matching verbs and may not be empty. "*" matches all verbs and, if present, must be the only entry. Required.
    """


class ServiceAccountSubject(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["ServiceAccountSubject"]:
            return ServiceAccountSubject

        def build(self) -> "ServiceAccountSubject":
            return ServiceAccountSubject(**self._attrs)

        def name(self, value: str, /) -> Self:
            """
            `name` is the name of matching ServiceAccount objects, or "*" to match regardless of name. Required.
            """
            return self._set("name", value)

        def namespace(self, value: str, /) -> Self:
            """
            `namespace` is the namespace of matching ServiceAccount objects. Required.
            """
            return self._set("namespace", value)

    class BuilderContext(BuilderContextBase["ServiceAccountSubject.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = ServiceAccountSubject.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for ServiceAccountSubject."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["ServiceAccountSubject", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use ServiceAccountSubject.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    name: str
    """
    `name` is the name of matching ServiceAccount objects, or "*" to match regardless of name. Required.
    """
    namespace: str
    """
    `namespace` is the namespace of matching ServiceAccount objects. Required.
    """


class UserSubject(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["UserSubject"]:
            return UserSubject

        def build(self) -> "UserSubject":
            return UserSubject(**self._attrs)

        def name(self, value: str, /) -> Self:
            """
            `name` is the username that matches, or "*" to match all usernames. Required.
            """
            return self._set("name", value)

    class BuilderContext(BuilderContextBase["UserSubject.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = UserSubject.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for UserSubject."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["UserSubject", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use UserSubject.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    name: str
    """
    `name` is the username that matches, or "*" to match all usernames. Required.
    """


class FlowSchemaCondition(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["FlowSchemaCondition"]:
            return FlowSchemaCondition

        def build(self) -> "FlowSchemaCondition":
            return FlowSchemaCondition(**self._attrs)

        @overload
        def last_transition_time(
            self, value_or_callback: Optional[apimachinery.Time], /
        ) -> "FlowSchemaCondition.Builder": ...

        @overload
        def last_transition_time(
            self,
            value_or_callback: Callable[
                [apimachinery.Time.Builder],
                apimachinery.Time.Builder | apimachinery.Time,
            ],
            /,
        ) -> "FlowSchemaCondition.Builder": ...

        @overload
        def last_transition_time(
            self, value_or_callback: Never = ...
        ) -> "apimachinery.Time.BuilderContext": ...

        def last_transition_time(self, value_or_callback=None, /):
            """
            `lastTransitionTime` is the last time the condition transitioned from one status to another.
            """
            if self._in_context and value_or_callback is None:
                context = apimachinery.Time.BuilderContext()
                context._parent_builder = self
                context._field_name = "last_transition_time"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(apimachinery.Time.builder())
                if isinstance(output, apimachinery.Time.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("last_transition_time", value)

        def message(self, value: Optional[str], /) -> Self:
            """
            `message` is a human-readable message indicating details about last transition.
            """
            return self._set("message", value)

        def reason(self, value: Optional[str], /) -> Self:
            """
            `reason` is a unique, one-word, CamelCase reason for the condition's last transition.
            """
            return self._set("reason", value)

        def status(self, value: Optional[str], /) -> Self:
            """
            `status` is the status of the condition. Can be True, False, Unknown. Required.
            """
            return self._set("status", value)

        def type(self, value: Optional[str], /) -> Self:
            """
            `type` is the type of the condition. Required.
            """
            return self._set("type", value)

    class BuilderContext(BuilderContextBase["FlowSchemaCondition.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = FlowSchemaCondition.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for FlowSchemaCondition."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["FlowSchemaCondition", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use FlowSchemaCondition.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    last_transition_time: Annotated[
        Optional[apimachinery.Time], Field(alias="lastTransitionTime")
    ] = None
    """
    `lastTransitionTime` is the last time the condition transitioned from one status to another.
    """
    message: Optional[str] = None
    """
    `message` is a human-readable message indicating details about last transition.
    """
    reason: Optional[str] = None
    """
    `reason` is a unique, one-word, CamelCase reason for the condition's last transition.
    """
    status: Optional[str] = None
    """
    `status` is the status of the condition. Can be True, False, Unknown. Required.
    """
    type: Optional[str] = None
    """
    `type` is the type of the condition. Required.
    """


class FlowSchemaStatus(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["FlowSchemaStatus"]:
            return FlowSchemaStatus

        def build(self) -> "FlowSchemaStatus":
            return FlowSchemaStatus(**self._attrs)

        @overload
        def conditions(
            self, value_or_callback: List[FlowSchemaCondition], /
        ) -> "FlowSchemaStatus.Builder": ...

        @overload
        def conditions(
            self,
            value_or_callback: Callable[
                [GenericListBuilder[FlowSchemaCondition, FlowSchemaCondition.Builder]],
                GenericListBuilder[FlowSchemaCondition, FlowSchemaCondition.Builder]
                | List[FlowSchemaCondition],
            ],
            /,
        ) -> "FlowSchemaStatus.Builder": ...

        @overload
        def conditions(
            self, value_or_callback: Never = ...
        ) -> ListBuilderContext[FlowSchemaCondition.Builder]: ...

        def conditions(self, value_or_callback=None, /):
            """
            `conditions` is a list of the current states of FlowSchema.
            """
            if self._in_context and value_or_callback is None:
                context = ListBuilderContext[FlowSchemaCondition.Builder]()
                context._parent_builder = self
                context._field_name = "conditions"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(FlowSchemaCondition.list_builder())
                if isinstance(output, GenericListBuilder):
                    value = output.build()
                else:
                    value = output
            return self._set("conditions", value)

    class BuilderContext(BuilderContextBase["FlowSchemaStatus.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = FlowSchemaStatus.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for FlowSchemaStatus."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["FlowSchemaStatus", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use FlowSchemaStatus.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    conditions: Optional[List[FlowSchemaCondition]] = None
    """
    `conditions` is a list of the current states of FlowSchema.
    """


class LimitResponse(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["LimitResponse"]:
            return LimitResponse

        def build(self) -> "LimitResponse":
            return LimitResponse(**self._attrs)

        @overload
        def queuing(
            self, value_or_callback: Optional[QueuingConfiguration], /
        ) -> "LimitResponse.Builder": ...

        @overload
        def queuing(
            self,
            value_or_callback: Callable[
                [QueuingConfiguration.Builder],
                QueuingConfiguration.Builder | QueuingConfiguration,
            ],
            /,
        ) -> "LimitResponse.Builder": ...

        @overload
        def queuing(
            self, value_or_callback: Never = ...
        ) -> "QueuingConfiguration.BuilderContext": ...

        def queuing(self, value_or_callback=None, /):
            """
            `queuing` holds the configuration parameters for queuing. This field may be non-empty only if `type` is `"Queue"`.
            """
            if self._in_context and value_or_callback is None:
                context = QueuingConfiguration.BuilderContext()
                context._parent_builder = self
                context._field_name = "queuing"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(QueuingConfiguration.builder())
                if isinstance(output, QueuingConfiguration.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("queuing", value)

        def type(self, value: str, /) -> Self:
            """
            `type` is "Queue" or "Reject". "Queue" means that requests that can not be executed upon arrival are held in a queue until they can be executed or a queuing limit is reached. "Reject" means that requests that can not be executed upon arrival are rejected. Required.
            """
            return self._set("type", value)

    class BuilderContext(BuilderContextBase["LimitResponse.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = LimitResponse.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for LimitResponse."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["LimitResponse", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use LimitResponse.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    queuing: Optional[QueuingConfiguration] = None
    """
    `queuing` holds the configuration parameters for queuing. This field may be non-empty only if `type` is `"Queue"`.
    """
    type: str
    """
    `type` is "Queue" or "Reject". "Queue" means that requests that can not be executed upon arrival are held in a queue until they can be executed or a queuing limit is reached. "Reject" means that requests that can not be executed upon arrival are rejected. Required.
    """


class LimitedPriorityLevelConfiguration(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["LimitedPriorityLevelConfiguration"]:
            return LimitedPriorityLevelConfiguration

        def build(self) -> "LimitedPriorityLevelConfiguration":
            return LimitedPriorityLevelConfiguration(**self._attrs)

        def borrowing_limit_percent(self, value: Optional[int], /) -> Self:
            """
            `borrowingLimitPercent`, if present, configures a limit on how many seats this priority level can borrow from other priority levels. The limit is known as this level's BorrowingConcurrencyLimit (BorrowingCL) and is a limit on the total number of seats that this level may borrow at any one time. This field holds the ratio of that limit to the level's nominal concurrency limit. When this field is non-nil, it must hold a non-negative integer and the limit is calculated as follows.

            BorrowingCL(i) = round( NominalCL(i) * borrowingLimitPercent(i)/100.0 )

            The value of this field can be more than 100, implying that this priority level can borrow a number of seats that is greater than its own nominal concurrency limit (NominalCL). When this field is left `nil`, the limit is effectively infinite.
            """
            return self._set("borrowing_limit_percent", value)

        def lendable_percent(self, value: Optional[int], /) -> Self:
            """
            `lendablePercent` prescribes the fraction of the level's NominalCL that can be borrowed by other priority levels. The value of this field must be between 0 and 100, inclusive, and it defaults to 0. The number of seats that other levels can borrow from this level, known as this level's LendableConcurrencyLimit (LendableCL), is defined as follows.

            LendableCL(i) = round( NominalCL(i) * lendablePercent(i)/100.0 )
            """
            return self._set("lendable_percent", value)

        @overload
        def limit_response(
            self, value_or_callback: Optional[LimitResponse], /
        ) -> "LimitedPriorityLevelConfiguration.Builder": ...

        @overload
        def limit_response(
            self,
            value_or_callback: Callable[
                [LimitResponse.Builder], LimitResponse.Builder | LimitResponse
            ],
            /,
        ) -> "LimitedPriorityLevelConfiguration.Builder": ...

        @overload
        def limit_response(
            self, value_or_callback: Never = ...
        ) -> "LimitResponse.BuilderContext": ...

        def limit_response(self, value_or_callback=None, /):
            """
            `limitResponse` indicates what to do with requests that can not be executed right now
            """
            if self._in_context and value_or_callback is None:
                context = LimitResponse.BuilderContext()
                context._parent_builder = self
                context._field_name = "limit_response"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(LimitResponse.builder())
                if isinstance(output, LimitResponse.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("limit_response", value)

        def nominal_concurrency_shares(self, value: Optional[int], /) -> Self:
            """
            `nominalConcurrencyShares` (NCS) contributes to the computation of the NominalConcurrencyLimit (NominalCL) of this level. This is the number of execution seats available at this priority level. This is used both for requests dispatched from this priority level as well as requests dispatched from other priority levels borrowing seats from this level. The server's concurrency limit (ServerCL) is divided among the Limited priority levels in proportion to their NCS values:

            NominalCL(i)  = ceil( ServerCL * NCS(i) / sum_ncs ) sum_ncs = sum[priority level k] NCS(k)

            Bigger numbers mean a larger nominal concurrency limit, at the expense of every other priority level. This field has a default value of 30.
            """
            return self._set("nominal_concurrency_shares", value)

    class BuilderContext(BuilderContextBase["LimitedPriorityLevelConfiguration.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = LimitedPriorityLevelConfiguration.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for LimitedPriorityLevelConfiguration."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["LimitedPriorityLevelConfiguration", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use LimitedPriorityLevelConfiguration.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    borrowing_limit_percent: Annotated[Optional[int], Field(alias="borrowingLimitPercent")] = None
    """
    `borrowingLimitPercent`, if present, configures a limit on how many seats this priority level can borrow from other priority levels. The limit is known as this level's BorrowingConcurrencyLimit (BorrowingCL) and is a limit on the total number of seats that this level may borrow at any one time. This field holds the ratio of that limit to the level's nominal concurrency limit. When this field is non-nil, it must hold a non-negative integer and the limit is calculated as follows.

    BorrowingCL(i) = round( NominalCL(i) * borrowingLimitPercent(i)/100.0 )

    The value of this field can be more than 100, implying that this priority level can borrow a number of seats that is greater than its own nominal concurrency limit (NominalCL). When this field is left `nil`, the limit is effectively infinite.
    """
    lendable_percent: Annotated[Optional[int], Field(alias="lendablePercent")] = None
    """
    `lendablePercent` prescribes the fraction of the level's NominalCL that can be borrowed by other priority levels. The value of this field must be between 0 and 100, inclusive, and it defaults to 0. The number of seats that other levels can borrow from this level, known as this level's LendableConcurrencyLimit (LendableCL), is defined as follows.

    LendableCL(i) = round( NominalCL(i) * lendablePercent(i)/100.0 )
    """
    limit_response: Annotated[Optional[LimitResponse], Field(alias="limitResponse")] = None
    """
    `limitResponse` indicates what to do with requests that can not be executed right now
    """
    nominal_concurrency_shares: Annotated[
        Optional[int], Field(alias="nominalConcurrencyShares")
    ] = None
    """
    `nominalConcurrencyShares` (NCS) contributes to the computation of the NominalConcurrencyLimit (NominalCL) of this level. This is the number of execution seats available at this priority level. This is used both for requests dispatched from this priority level as well as requests dispatched from other priority levels borrowing seats from this level. The server's concurrency limit (ServerCL) is divided among the Limited priority levels in proportion to their NCS values:

    NominalCL(i)  = ceil( ServerCL * NCS(i) / sum_ncs ) sum_ncs = sum[priority level k] NCS(k)

    Bigger numbers mean a larger nominal concurrency limit, at the expense of every other priority level. This field has a default value of 30.
    """


class PriorityLevelConfigurationCondition(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["PriorityLevelConfigurationCondition"]:
            return PriorityLevelConfigurationCondition

        def build(self) -> "PriorityLevelConfigurationCondition":
            return PriorityLevelConfigurationCondition(**self._attrs)

        @overload
        def last_transition_time(
            self, value_or_callback: Optional[apimachinery.Time], /
        ) -> "PriorityLevelConfigurationCondition.Builder": ...

        @overload
        def last_transition_time(
            self,
            value_or_callback: Callable[
                [apimachinery.Time.Builder],
                apimachinery.Time.Builder | apimachinery.Time,
            ],
            /,
        ) -> "PriorityLevelConfigurationCondition.Builder": ...

        @overload
        def last_transition_time(
            self, value_or_callback: Never = ...
        ) -> "apimachinery.Time.BuilderContext": ...

        def last_transition_time(self, value_or_callback=None, /):
            """
            `lastTransitionTime` is the last time the condition transitioned from one status to another.
            """
            if self._in_context and value_or_callback is None:
                context = apimachinery.Time.BuilderContext()
                context._parent_builder = self
                context._field_name = "last_transition_time"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(apimachinery.Time.builder())
                if isinstance(output, apimachinery.Time.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("last_transition_time", value)

        def message(self, value: Optional[str], /) -> Self:
            """
            `message` is a human-readable message indicating details about last transition.
            """
            return self._set("message", value)

        def reason(self, value: Optional[str], /) -> Self:
            """
            `reason` is a unique, one-word, CamelCase reason for the condition's last transition.
            """
            return self._set("reason", value)

        def status(self, value: Optional[str], /) -> Self:
            """
            `status` is the status of the condition. Can be True, False, Unknown. Required.
            """
            return self._set("status", value)

        def type(self, value: Optional[str], /) -> Self:
            """
            `type` is the type of the condition. Required.
            """
            return self._set("type", value)

    class BuilderContext(BuilderContextBase["PriorityLevelConfigurationCondition.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = PriorityLevelConfigurationCondition.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for PriorityLevelConfigurationCondition."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["PriorityLevelConfigurationCondition", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use PriorityLevelConfigurationCondition.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    last_transition_time: Annotated[
        Optional[apimachinery.Time], Field(alias="lastTransitionTime")
    ] = None
    """
    `lastTransitionTime` is the last time the condition transitioned from one status to another.
    """
    message: Optional[str] = None
    """
    `message` is a human-readable message indicating details about last transition.
    """
    reason: Optional[str] = None
    """
    `reason` is a unique, one-word, CamelCase reason for the condition's last transition.
    """
    status: Optional[str] = None
    """
    `status` is the status of the condition. Can be True, False, Unknown. Required.
    """
    type: Optional[str] = None
    """
    `type` is the type of the condition. Required.
    """


class PriorityLevelConfigurationSpec(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["PriorityLevelConfigurationSpec"]:
            return PriorityLevelConfigurationSpec

        def build(self) -> "PriorityLevelConfigurationSpec":
            return PriorityLevelConfigurationSpec(**self._attrs)

        @overload
        def exempt(
            self, value_or_callback: Optional[ExemptPriorityLevelConfiguration], /
        ) -> "PriorityLevelConfigurationSpec.Builder": ...

        @overload
        def exempt(
            self,
            value_or_callback: Callable[
                [ExemptPriorityLevelConfiguration.Builder],
                ExemptPriorityLevelConfiguration.Builder | ExemptPriorityLevelConfiguration,
            ],
            /,
        ) -> "PriorityLevelConfigurationSpec.Builder": ...

        @overload
        def exempt(
            self, value_or_callback: Never = ...
        ) -> "ExemptPriorityLevelConfiguration.BuilderContext": ...

        def exempt(self, value_or_callback=None, /):
            """
            `exempt` specifies how requests are handled for an exempt priority level. This field MUST be empty if `type` is `"Limited"`. This field MAY be non-empty if `type` is `"Exempt"`. If empty and `type` is `"Exempt"` then the default values for `ExemptPriorityLevelConfiguration` apply.
            """
            if self._in_context and value_or_callback is None:
                context = ExemptPriorityLevelConfiguration.BuilderContext()
                context._parent_builder = self
                context._field_name = "exempt"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(ExemptPriorityLevelConfiguration.builder())
                if isinstance(output, ExemptPriorityLevelConfiguration.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("exempt", value)

        @overload
        def limited(
            self, value_or_callback: Optional[LimitedPriorityLevelConfiguration], /
        ) -> "PriorityLevelConfigurationSpec.Builder": ...

        @overload
        def limited(
            self,
            value_or_callback: Callable[
                [LimitedPriorityLevelConfiguration.Builder],
                LimitedPriorityLevelConfiguration.Builder | LimitedPriorityLevelConfiguration,
            ],
            /,
        ) -> "PriorityLevelConfigurationSpec.Builder": ...

        @overload
        def limited(
            self, value_or_callback: Never = ...
        ) -> "LimitedPriorityLevelConfiguration.BuilderContext": ...

        def limited(self, value_or_callback=None, /):
            """
            `limited` specifies how requests are handled for a Limited priority level. This field must be non-empty if and only if `type` is `"Limited"`.
            """
            if self._in_context and value_or_callback is None:
                context = LimitedPriorityLevelConfiguration.BuilderContext()
                context._parent_builder = self
                context._field_name = "limited"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(LimitedPriorityLevelConfiguration.builder())
                if isinstance(output, LimitedPriorityLevelConfiguration.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("limited", value)

        def type(self, value: str, /) -> Self:
            """
            `type` indicates whether this priority level is subject to limitation on request execution.  A value of `"Exempt"` means that requests of this priority level are not subject to a limit (and thus are never queued) and do not detract from the capacity made available to other priority levels.  A value of `"Limited"` means that (a) requests of this priority level _are_ subject to limits and (b) some of the server's limited capacity is made available exclusively to this priority level. Required.
            """
            return self._set("type", value)

    class BuilderContext(BuilderContextBase["PriorityLevelConfigurationSpec.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = PriorityLevelConfigurationSpec.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for PriorityLevelConfigurationSpec."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["PriorityLevelConfigurationSpec", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use PriorityLevelConfigurationSpec.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    exempt: Optional[ExemptPriorityLevelConfiguration] = None
    """
    `exempt` specifies how requests are handled for an exempt priority level. This field MUST be empty if `type` is `"Limited"`. This field MAY be non-empty if `type` is `"Exempt"`. If empty and `type` is `"Exempt"` then the default values for `ExemptPriorityLevelConfiguration` apply.
    """
    limited: Optional[LimitedPriorityLevelConfiguration] = None
    """
    `limited` specifies how requests are handled for a Limited priority level. This field must be non-empty if and only if `type` is `"Limited"`.
    """
    type: str
    """
    `type` indicates whether this priority level is subject to limitation on request execution.  A value of `"Exempt"` means that requests of this priority level are not subject to a limit (and thus are never queued) and do not detract from the capacity made available to other priority levels.  A value of `"Limited"` means that (a) requests of this priority level _are_ subject to limits and (b) some of the server's limited capacity is made available exclusively to this priority level. Required.
    """


class PriorityLevelConfigurationStatus(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["PriorityLevelConfigurationStatus"]:
            return PriorityLevelConfigurationStatus

        def build(self) -> "PriorityLevelConfigurationStatus":
            return PriorityLevelConfigurationStatus(**self._attrs)

        @overload
        def conditions(
            self, value_or_callback: List[PriorityLevelConfigurationCondition], /
        ) -> "PriorityLevelConfigurationStatus.Builder": ...

        @overload
        def conditions(
            self,
            value_or_callback: Callable[
                [
                    GenericListBuilder[
                        PriorityLevelConfigurationCondition,
                        PriorityLevelConfigurationCondition.Builder,
                    ]
                ],
                GenericListBuilder[
                    PriorityLevelConfigurationCondition,
                    PriorityLevelConfigurationCondition.Builder,
                ]
                | List[PriorityLevelConfigurationCondition],
            ],
            /,
        ) -> "PriorityLevelConfigurationStatus.Builder": ...

        @overload
        def conditions(
            self, value_or_callback: Never = ...
        ) -> ListBuilderContext[PriorityLevelConfigurationCondition.Builder]: ...

        def conditions(self, value_or_callback=None, /):
            """
            `conditions` is the current state of "request-priority".
            """
            if self._in_context and value_or_callback is None:
                context = ListBuilderContext[PriorityLevelConfigurationCondition.Builder]()
                context._parent_builder = self
                context._field_name = "conditions"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(PriorityLevelConfigurationCondition.list_builder())
                if isinstance(output, GenericListBuilder):
                    value = output.build()
                else:
                    value = output
            return self._set("conditions", value)

    class BuilderContext(BuilderContextBase["PriorityLevelConfigurationStatus.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = PriorityLevelConfigurationStatus.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for PriorityLevelConfigurationStatus."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["PriorityLevelConfigurationStatus", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use PriorityLevelConfigurationStatus.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    conditions: Optional[List[PriorityLevelConfigurationCondition]] = None
    """
    `conditions` is the current state of "request-priority".
    """


class Subject(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["Subject"]:
            return Subject

        def build(self) -> "Subject":
            return Subject(**self._attrs)

        @overload
        def group(self, value_or_callback: Optional[GroupSubject], /) -> "Subject.Builder": ...

        @overload
        def group(
            self,
            value_or_callback: Callable[
                [GroupSubject.Builder], GroupSubject.Builder | GroupSubject
            ],
            /,
        ) -> "Subject.Builder": ...

        @overload
        def group(self, value_or_callback: Never = ...) -> "GroupSubject.BuilderContext": ...

        def group(self, value_or_callback=None, /):
            """
            `group` matches based on user group name.
            """
            if self._in_context and value_or_callback is None:
                context = GroupSubject.BuilderContext()
                context._parent_builder = self
                context._field_name = "group"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(GroupSubject.builder())
                if isinstance(output, GroupSubject.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("group", value)

        def kind(self, value: str, /) -> Self:
            """
            `kind` indicates which one of the other fields is non-empty. Required
            """
            return self._set("kind", value)

        @overload
        def service_account(
            self, value_or_callback: Optional[ServiceAccountSubject], /
        ) -> "Subject.Builder": ...

        @overload
        def service_account(
            self,
            value_or_callback: Callable[
                [ServiceAccountSubject.Builder],
                ServiceAccountSubject.Builder | ServiceAccountSubject,
            ],
            /,
        ) -> "Subject.Builder": ...

        @overload
        def service_account(
            self, value_or_callback: Never = ...
        ) -> "ServiceAccountSubject.BuilderContext": ...

        def service_account(self, value_or_callback=None, /):
            """
            `serviceAccount` matches ServiceAccounts.
            """
            if self._in_context and value_or_callback is None:
                context = ServiceAccountSubject.BuilderContext()
                context._parent_builder = self
                context._field_name = "service_account"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(ServiceAccountSubject.builder())
                if isinstance(output, ServiceAccountSubject.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("service_account", value)

        @overload
        def user(self, value_or_callback: Optional[UserSubject], /) -> "Subject.Builder": ...

        @overload
        def user(
            self,
            value_or_callback: Callable[[UserSubject.Builder], UserSubject.Builder | UserSubject],
            /,
        ) -> "Subject.Builder": ...

        @overload
        def user(self, value_or_callback: Never = ...) -> "UserSubject.BuilderContext": ...

        def user(self, value_or_callback=None, /):
            """
            `user` matches based on username.
            """
            if self._in_context and value_or_callback is None:
                context = UserSubject.BuilderContext()
                context._parent_builder = self
                context._field_name = "user"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(UserSubject.builder())
                if isinstance(output, UserSubject.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("user", value)

    class BuilderContext(BuilderContextBase["Subject.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = Subject.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for Subject."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["Subject", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use Subject.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    group: Optional[GroupSubject] = None
    """
    `group` matches based on user group name.
    """
    kind: str
    """
    `kind` indicates which one of the other fields is non-empty. Required
    """
    service_account: Annotated[Optional[ServiceAccountSubject], Field(alias="serviceAccount")] = (
        None
    )
    """
    `serviceAccount` matches ServiceAccounts.
    """
    user: Optional[UserSubject] = None
    """
    `user` matches based on username.
    """


class PolicyRulesWithSubjects(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["PolicyRulesWithSubjects"]:
            return PolicyRulesWithSubjects

        def build(self) -> "PolicyRulesWithSubjects":
            return PolicyRulesWithSubjects(**self._attrs)

        @overload
        def non_resource_rules(
            self, value_or_callback: List[NonResourcePolicyRule], /
        ) -> "PolicyRulesWithSubjects.Builder": ...

        @overload
        def non_resource_rules(
            self,
            value_or_callback: Callable[
                [GenericListBuilder[NonResourcePolicyRule, NonResourcePolicyRule.Builder]],
                GenericListBuilder[NonResourcePolicyRule, NonResourcePolicyRule.Builder]
                | List[NonResourcePolicyRule],
            ],
            /,
        ) -> "PolicyRulesWithSubjects.Builder": ...

        @overload
        def non_resource_rules(
            self, value_or_callback: Never = ...
        ) -> ListBuilderContext[NonResourcePolicyRule.Builder]: ...

        def non_resource_rules(self, value_or_callback=None, /):
            """
            `nonResourceRules` is a list of NonResourcePolicyRules that identify matching requests according to their verb and the target non-resource URL.
            """
            if self._in_context and value_or_callback is None:
                context = ListBuilderContext[NonResourcePolicyRule.Builder]()
                context._parent_builder = self
                context._field_name = "non_resource_rules"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(NonResourcePolicyRule.list_builder())
                if isinstance(output, GenericListBuilder):
                    value = output.build()
                else:
                    value = output
            return self._set("non_resource_rules", value)

        @overload
        def resource_rules(
            self, value_or_callback: List[ResourcePolicyRule], /
        ) -> "PolicyRulesWithSubjects.Builder": ...

        @overload
        def resource_rules(
            self,
            value_or_callback: Callable[
                [GenericListBuilder[ResourcePolicyRule, ResourcePolicyRule.Builder]],
                GenericListBuilder[ResourcePolicyRule, ResourcePolicyRule.Builder]
                | List[ResourcePolicyRule],
            ],
            /,
        ) -> "PolicyRulesWithSubjects.Builder": ...

        @overload
        def resource_rules(
            self, value_or_callback: Never = ...
        ) -> ListBuilderContext[ResourcePolicyRule.Builder]: ...

        def resource_rules(self, value_or_callback=None, /):
            """
            `resourceRules` is a slice of ResourcePolicyRules that identify matching requests according to their verb and the target resource. At least one of `resourceRules` and `nonResourceRules` has to be non-empty.
            """
            if self._in_context and value_or_callback is None:
                context = ListBuilderContext[ResourcePolicyRule.Builder]()
                context._parent_builder = self
                context._field_name = "resource_rules"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(ResourcePolicyRule.list_builder())
                if isinstance(output, GenericListBuilder):
                    value = output.build()
                else:
                    value = output
            return self._set("resource_rules", value)

        @overload
        def subjects(
            self, value_or_callback: List[Subject], /
        ) -> "PolicyRulesWithSubjects.Builder": ...

        @overload
        def subjects(
            self,
            value_or_callback: Callable[
                [GenericListBuilder[Subject, Subject.Builder]],
                GenericListBuilder[Subject, Subject.Builder] | List[Subject],
            ],
            /,
        ) -> "PolicyRulesWithSubjects.Builder": ...

        @overload
        def subjects(
            self, value_or_callback: Never = ...
        ) -> ListBuilderContext[Subject.Builder]: ...

        def subjects(self, value_or_callback=None, /):
            """
            subjects is the list of normal user, serviceaccount, or group that this rule cares about. There must be at least one member in this slice. A slice that includes both the system:authenticated and system:unauthenticated user groups matches every request. Required.
            """
            if self._in_context and value_or_callback is None:
                context = ListBuilderContext[Subject.Builder]()
                context._parent_builder = self
                context._field_name = "subjects"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(Subject.list_builder())
                if isinstance(output, GenericListBuilder):
                    value = output.build()
                else:
                    value = output
            return self._set("subjects", value)

    class BuilderContext(BuilderContextBase["PolicyRulesWithSubjects.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = PolicyRulesWithSubjects.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for PolicyRulesWithSubjects."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["PolicyRulesWithSubjects", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use PolicyRulesWithSubjects.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    non_resource_rules: Annotated[
        Optional[List[NonResourcePolicyRule]], Field(alias="nonResourceRules")
    ] = None
    """
    `nonResourceRules` is a list of NonResourcePolicyRules that identify matching requests according to their verb and the target non-resource URL.
    """
    resource_rules: Annotated[Optional[List[ResourcePolicyRule]], Field(alias="resourceRules")] = (
        None
    )
    """
    `resourceRules` is a slice of ResourcePolicyRules that identify matching requests according to their verb and the target resource. At least one of `resourceRules` and `nonResourceRules` has to be non-empty.
    """
    subjects: List[Subject]
    """
    subjects is the list of normal user, serviceaccount, or group that this rule cares about. There must be at least one member in this slice. A slice that includes both the system:authenticated and system:unauthenticated user groups matches every request. Required.
    """


class PriorityLevelConfiguration(Resource):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["PriorityLevelConfiguration"]:
            return PriorityLevelConfiguration

        def build(self) -> "PriorityLevelConfiguration":
            return PriorityLevelConfiguration(**self._attrs)

        def api_version(
            self, value: Optional[Literal["flowcontrol.apiserver.k8s.io/v1beta3"]], /
        ) -> Self:
            """
            APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
            """
            return self._set("api_version", value)

        def kind(self, value: Optional[Literal["PriorityLevelConfiguration"]], /) -> Self:
            """
            Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
            """
            return self._set("kind", value)

        @overload
        def metadata(
            self, value_or_callback: Optional[apimachinery.ObjectMeta], /
        ) -> "PriorityLevelConfiguration.Builder": ...

        @overload
        def metadata(
            self,
            value_or_callback: Callable[
                [apimachinery.ObjectMeta.Builder],
                apimachinery.ObjectMeta.Builder | apimachinery.ObjectMeta,
            ],
            /,
        ) -> "PriorityLevelConfiguration.Builder": ...

        @overload
        def metadata(
            self, value_or_callback: Never = ...
        ) -> "apimachinery.ObjectMeta.BuilderContext": ...

        def metadata(self, value_or_callback=None, /):
            """
            `metadata` is the standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
            """
            if self._in_context and value_or_callback is None:
                context = apimachinery.ObjectMeta.BuilderContext()
                context._parent_builder = self
                context._field_name = "metadata"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(apimachinery.ObjectMeta.builder())
                if isinstance(output, apimachinery.ObjectMeta.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("metadata", value)

        @overload
        def spec(
            self, value_or_callback: Optional[PriorityLevelConfigurationSpec], /
        ) -> "PriorityLevelConfiguration.Builder": ...

        @overload
        def spec(
            self,
            value_or_callback: Callable[
                [PriorityLevelConfigurationSpec.Builder],
                PriorityLevelConfigurationSpec.Builder | PriorityLevelConfigurationSpec,
            ],
            /,
        ) -> "PriorityLevelConfiguration.Builder": ...

        @overload
        def spec(
            self, value_or_callback: Never = ...
        ) -> "PriorityLevelConfigurationSpec.BuilderContext": ...

        def spec(self, value_or_callback=None, /):
            """
            `spec` is the specification of the desired behavior of a "request-priority". More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
            """
            if self._in_context and value_or_callback is None:
                context = PriorityLevelConfigurationSpec.BuilderContext()
                context._parent_builder = self
                context._field_name = "spec"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(PriorityLevelConfigurationSpec.builder())
                if isinstance(output, PriorityLevelConfigurationSpec.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("spec", value)

        @overload
        def status(
            self, value_or_callback: Optional[PriorityLevelConfigurationStatus], /
        ) -> "PriorityLevelConfiguration.Builder": ...

        @overload
        def status(
            self,
            value_or_callback: Callable[
                [PriorityLevelConfigurationStatus.Builder],
                PriorityLevelConfigurationStatus.Builder | PriorityLevelConfigurationStatus,
            ],
            /,
        ) -> "PriorityLevelConfiguration.Builder": ...

        @overload
        def status(
            self, value_or_callback: Never = ...
        ) -> "PriorityLevelConfigurationStatus.BuilderContext": ...

        def status(self, value_or_callback=None, /):
            """
            `status` is the current status of a "request-priority". More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
            """
            if self._in_context and value_or_callback is None:
                context = PriorityLevelConfigurationStatus.BuilderContext()
                context._parent_builder = self
                context._field_name = "status"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(PriorityLevelConfigurationStatus.builder())
                if isinstance(output, PriorityLevelConfigurationStatus.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("status", value)

    class BuilderContext(BuilderContextBase["PriorityLevelConfiguration.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = PriorityLevelConfiguration.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for PriorityLevelConfiguration."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["PriorityLevelConfiguration", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use PriorityLevelConfiguration.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    api_version: Annotated[
        Optional[Literal["flowcontrol.apiserver.k8s.io/v1beta3"]],
        Field(alias="apiVersion"),
    ] = "flowcontrol.apiserver.k8s.io/v1beta3"
    """
    APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
    """
    kind: Optional[Literal["PriorityLevelConfiguration"]] = "PriorityLevelConfiguration"
    """
    Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
    """
    metadata: Optional[apimachinery.ObjectMeta] = None
    """
    `metadata` is the standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
    """
    spec: Optional[PriorityLevelConfigurationSpec] = None
    """
    `spec` is the specification of the desired behavior of a "request-priority". More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
    """
    status: Optional[PriorityLevelConfigurationStatus] = None
    """
    `status` is the current status of a "request-priority". More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
    """


PriorityLevelConfigurationList = ResourceList["PriorityLevelConfiguration"]


class FlowSchemaSpec(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["FlowSchemaSpec"]:
            return FlowSchemaSpec

        def build(self) -> "FlowSchemaSpec":
            return FlowSchemaSpec(**self._attrs)

        @overload
        def distinguisher_method(
            self, value_or_callback: Optional[FlowDistinguisherMethod], /
        ) -> "FlowSchemaSpec.Builder": ...

        @overload
        def distinguisher_method(
            self,
            value_or_callback: Callable[
                [FlowDistinguisherMethod.Builder],
                FlowDistinguisherMethod.Builder | FlowDistinguisherMethod,
            ],
            /,
        ) -> "FlowSchemaSpec.Builder": ...

        @overload
        def distinguisher_method(
            self, value_or_callback: Never = ...
        ) -> "FlowDistinguisherMethod.BuilderContext": ...

        def distinguisher_method(self, value_or_callback=None, /):
            """
            `distinguisherMethod` defines how to compute the flow distinguisher for requests that match this schema. `nil` specifies that the distinguisher is disabled and thus will always be the empty string.
            """
            if self._in_context and value_or_callback is None:
                context = FlowDistinguisherMethod.BuilderContext()
                context._parent_builder = self
                context._field_name = "distinguisher_method"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(FlowDistinguisherMethod.builder())
                if isinstance(output, FlowDistinguisherMethod.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("distinguisher_method", value)

        def matching_precedence(self, value: Optional[int], /) -> Self:
            """
            `matchingPrecedence` is used to choose among the FlowSchemas that match a given request. The chosen FlowSchema is among those with the numerically lowest (which we take to be logically highest) MatchingPrecedence.  Each MatchingPrecedence value must be ranged in [1,10000]. Note that if the precedence is not specified, it will be set to 1000 as default.
            """
            return self._set("matching_precedence", value)

        @overload
        def priority_level_configuration(
            self, value_or_callback: PriorityLevelConfigurationReference, /
        ) -> "FlowSchemaSpec.Builder": ...

        @overload
        def priority_level_configuration(
            self,
            value_or_callback: Callable[
                [PriorityLevelConfigurationReference.Builder],
                PriorityLevelConfigurationReference.Builder | PriorityLevelConfigurationReference,
            ],
            /,
        ) -> "FlowSchemaSpec.Builder": ...

        @overload
        def priority_level_configuration(
            self, value_or_callback: Never = ...
        ) -> "PriorityLevelConfigurationReference.BuilderContext": ...

        def priority_level_configuration(self, value_or_callback=None, /):
            """
            `priorityLevelConfiguration` should reference a PriorityLevelConfiguration in the cluster. If the reference cannot be resolved, the FlowSchema will be ignored and marked as invalid in its status. Required.
            """
            if self._in_context and value_or_callback is None:
                context = PriorityLevelConfigurationReference.BuilderContext()
                context._parent_builder = self
                context._field_name = "priority_level_configuration"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(PriorityLevelConfigurationReference.builder())
                if isinstance(output, PriorityLevelConfigurationReference.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("priority_level_configuration", value)

        @overload
        def rules(
            self, value_or_callback: List[PolicyRulesWithSubjects], /
        ) -> "FlowSchemaSpec.Builder": ...

        @overload
        def rules(
            self,
            value_or_callback: Callable[
                [GenericListBuilder[PolicyRulesWithSubjects, PolicyRulesWithSubjects.Builder]],
                GenericListBuilder[PolicyRulesWithSubjects, PolicyRulesWithSubjects.Builder]
                | List[PolicyRulesWithSubjects],
            ],
            /,
        ) -> "FlowSchemaSpec.Builder": ...

        @overload
        def rules(
            self, value_or_callback: Never = ...
        ) -> ListBuilderContext[PolicyRulesWithSubjects.Builder]: ...

        def rules(self, value_or_callback=None, /):
            """
            `rules` describes which requests will match this flow schema. This FlowSchema matches a request if and only if at least one member of rules matches the request. if it is an empty slice, there will be no requests matching the FlowSchema.
            """
            if self._in_context and value_or_callback is None:
                context = ListBuilderContext[PolicyRulesWithSubjects.Builder]()
                context._parent_builder = self
                context._field_name = "rules"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(PolicyRulesWithSubjects.list_builder())
                if isinstance(output, GenericListBuilder):
                    value = output.build()
                else:
                    value = output
            return self._set("rules", value)

    class BuilderContext(BuilderContextBase["FlowSchemaSpec.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = FlowSchemaSpec.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for FlowSchemaSpec."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["FlowSchemaSpec", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use FlowSchemaSpec.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    distinguisher_method: Annotated[
        Optional[FlowDistinguisherMethod], Field(alias="distinguisherMethod")
    ] = None
    """
    `distinguisherMethod` defines how to compute the flow distinguisher for requests that match this schema. `nil` specifies that the distinguisher is disabled and thus will always be the empty string.
    """
    matching_precedence: Annotated[Optional[int], Field(alias="matchingPrecedence")] = None
    """
    `matchingPrecedence` is used to choose among the FlowSchemas that match a given request. The chosen FlowSchema is among those with the numerically lowest (which we take to be logically highest) MatchingPrecedence.  Each MatchingPrecedence value must be ranged in [1,10000]. Note that if the precedence is not specified, it will be set to 1000 as default.
    """
    priority_level_configuration: Annotated[
        PriorityLevelConfigurationReference, Field(alias="priorityLevelConfiguration")
    ]
    """
    `priorityLevelConfiguration` should reference a PriorityLevelConfiguration in the cluster. If the reference cannot be resolved, the FlowSchema will be ignored and marked as invalid in its status. Required.
    """
    rules: Optional[List[PolicyRulesWithSubjects]] = None
    """
    `rules` describes which requests will match this flow schema. This FlowSchema matches a request if and only if at least one member of rules matches the request. if it is an empty slice, there will be no requests matching the FlowSchema.
    """


class FlowSchema(Resource):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["FlowSchema"]:
            return FlowSchema

        def build(self) -> "FlowSchema":
            return FlowSchema(**self._attrs)

        def api_version(
            self, value: Optional[Literal["flowcontrol.apiserver.k8s.io/v1beta3"]], /
        ) -> Self:
            """
            APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
            """
            return self._set("api_version", value)

        def kind(self, value: Optional[Literal["FlowSchema"]], /) -> Self:
            """
            Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
            """
            return self._set("kind", value)

        @overload
        def metadata(
            self, value_or_callback: Optional[apimachinery.ObjectMeta], /
        ) -> "FlowSchema.Builder": ...

        @overload
        def metadata(
            self,
            value_or_callback: Callable[
                [apimachinery.ObjectMeta.Builder],
                apimachinery.ObjectMeta.Builder | apimachinery.ObjectMeta,
            ],
            /,
        ) -> "FlowSchema.Builder": ...

        @overload
        def metadata(
            self, value_or_callback: Never = ...
        ) -> "apimachinery.ObjectMeta.BuilderContext": ...

        def metadata(self, value_or_callback=None, /):
            """
            `metadata` is the standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
            """
            if self._in_context and value_or_callback is None:
                context = apimachinery.ObjectMeta.BuilderContext()
                context._parent_builder = self
                context._field_name = "metadata"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(apimachinery.ObjectMeta.builder())
                if isinstance(output, apimachinery.ObjectMeta.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("metadata", value)

        @overload
        def spec(self, value_or_callback: Optional[FlowSchemaSpec], /) -> "FlowSchema.Builder": ...

        @overload
        def spec(
            self,
            value_or_callback: Callable[
                [FlowSchemaSpec.Builder], FlowSchemaSpec.Builder | FlowSchemaSpec
            ],
            /,
        ) -> "FlowSchema.Builder": ...

        @overload
        def spec(self, value_or_callback: Never = ...) -> "FlowSchemaSpec.BuilderContext": ...

        def spec(self, value_or_callback=None, /):
            """
            `spec` is the specification of the desired behavior of a FlowSchema. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
            """
            if self._in_context and value_or_callback is None:
                context = FlowSchemaSpec.BuilderContext()
                context._parent_builder = self
                context._field_name = "spec"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(FlowSchemaSpec.builder())
                if isinstance(output, FlowSchemaSpec.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("spec", value)

        @overload
        def status(
            self, value_or_callback: Optional[FlowSchemaStatus], /
        ) -> "FlowSchema.Builder": ...

        @overload
        def status(
            self,
            value_or_callback: Callable[
                [FlowSchemaStatus.Builder], FlowSchemaStatus.Builder | FlowSchemaStatus
            ],
            /,
        ) -> "FlowSchema.Builder": ...

        @overload
        def status(self, value_or_callback: Never = ...) -> "FlowSchemaStatus.BuilderContext": ...

        def status(self, value_or_callback=None, /):
            """
            `status` is the current status of a FlowSchema. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
            """
            if self._in_context and value_or_callback is None:
                context = FlowSchemaStatus.BuilderContext()
                context._parent_builder = self
                context._field_name = "status"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(FlowSchemaStatus.builder())
                if isinstance(output, FlowSchemaStatus.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("status", value)

    class BuilderContext(BuilderContextBase["FlowSchema.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = FlowSchema.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for FlowSchema."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["FlowSchema", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use FlowSchema.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    api_version: Annotated[
        Optional[Literal["flowcontrol.apiserver.k8s.io/v1beta3"]],
        Field(alias="apiVersion"),
    ] = "flowcontrol.apiserver.k8s.io/v1beta3"
    """
    APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
    """
    kind: Optional[Literal["FlowSchema"]] = "FlowSchema"
    """
    Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
    """
    metadata: Optional[apimachinery.ObjectMeta] = None
    """
    `metadata` is the standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
    """
    spec: Optional[FlowSchemaSpec] = None
    """
    `spec` is the specification of the desired behavior of a FlowSchema. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
    """
    status: Optional[FlowSchemaStatus] = None
    """
    `status` is the current status of a FlowSchema. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
    """


FlowSchemaList = ResourceList["FlowSchema"]
