# Generated by cloudcoil-model-codegen v0.5.0
# DO NOT EDIT

from __future__ import annotations

from typing import (
    Annotated,
    Callable,
    Dict,
    List,
    Literal,
    Optional,
    Type,
    overload,
)

from pydantic import Field

from cloudcoil import apimachinery
from cloudcoil.pydantic import (
    BaseModel,
    BaseModelBuilder,
    BuilderContextBase,
    GenericListBuilder,
    ListBuilderContext,
    Never,
    Self,
)
from cloudcoil.resources import Resource, ResourceList


class AWSElasticBlockStoreVolumeSource(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["AWSElasticBlockStoreVolumeSource"]:
            return AWSElasticBlockStoreVolumeSource

        def build(self) -> "AWSElasticBlockStoreVolumeSource":
            return AWSElasticBlockStoreVolumeSource(**self._attrs)

        def fs_type(self, value: Optional[str], /) -> Self:
            """
            fsType is the filesystem type of the volume that you want to mount. Tip: Ensure that the filesystem type is supported by the host operating system. Examples: "ext4", "xfs", "ntfs". Implicitly inferred to be "ext4" if unspecified. More info: https://kubernetes.io/docs/concepts/storage/volumes#awselasticblockstore
            """
            return self._set("fs_type", value)

        def partition(self, value: Optional[int], /) -> Self:
            """
            partition is the partition in the volume that you want to mount. If omitted, the default is to mount by volume name. Examples: For volume /dev/sda1, you specify the partition as "1". Similarly, the volume partition for /dev/sda is "0" (or you can leave the property empty).
            """
            return self._set("partition", value)

        def read_only(self, value: Optional[bool], /) -> Self:
            """
            readOnly value true will force the readOnly setting in VolumeMounts. More info: https://kubernetes.io/docs/concepts/storage/volumes#awselasticblockstore
            """
            return self._set("read_only", value)

        def volume_id(self, value: str, /) -> Self:
            """
            volumeID is unique ID of the persistent disk resource in AWS (Amazon EBS volume). More info: https://kubernetes.io/docs/concepts/storage/volumes#awselasticblockstore
            """
            return self._set("volume_id", value)

    class BuilderContext(BuilderContextBase["AWSElasticBlockStoreVolumeSource.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = AWSElasticBlockStoreVolumeSource.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for AWSElasticBlockStoreVolumeSource."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["AWSElasticBlockStoreVolumeSource", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use AWSElasticBlockStoreVolumeSource.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    fs_type: Annotated[Optional[str], Field(alias="fsType")] = None
    """
    fsType is the filesystem type of the volume that you want to mount. Tip: Ensure that the filesystem type is supported by the host operating system. Examples: "ext4", "xfs", "ntfs". Implicitly inferred to be "ext4" if unspecified. More info: https://kubernetes.io/docs/concepts/storage/volumes#awselasticblockstore
    """
    partition: Optional[int] = None
    """
    partition is the partition in the volume that you want to mount. If omitted, the default is to mount by volume name. Examples: For volume /dev/sda1, you specify the partition as "1". Similarly, the volume partition for /dev/sda is "0" (or you can leave the property empty).
    """
    read_only: Annotated[Optional[bool], Field(alias="readOnly")] = None
    """
    readOnly value true will force the readOnly setting in VolumeMounts. More info: https://kubernetes.io/docs/concepts/storage/volumes#awselasticblockstore
    """
    volume_id: Annotated[str, Field(alias="volumeID")]
    """
    volumeID is unique ID of the persistent disk resource in AWS (Amazon EBS volume). More info: https://kubernetes.io/docs/concepts/storage/volumes#awselasticblockstore
    """


class AppArmorProfile(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["AppArmorProfile"]:
            return AppArmorProfile

        def build(self) -> "AppArmorProfile":
            return AppArmorProfile(**self._attrs)

        def localhost_profile(self, value: Optional[str], /) -> Self:
            """
            localhostProfile indicates a profile loaded on the node that should be used. The profile must be preconfigured on the node to work. Must match the loaded name of the profile. Must be set if and only if type is "Localhost".
            """
            return self._set("localhost_profile", value)

        def type(self, value: str, /) -> Self:
            """
            type indicates which kind of AppArmor profile will be applied. Valid options are:
              Localhost - a profile pre-loaded on the node.
              RuntimeDefault - the container runtime's default profile.
              Unconfined - no AppArmor enforcement.
            """
            return self._set("type", value)

    class BuilderContext(BuilderContextBase["AppArmorProfile.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = AppArmorProfile.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for AppArmorProfile."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["AppArmorProfile", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use AppArmorProfile.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    localhost_profile: Annotated[Optional[str], Field(alias="localhostProfile")] = None
    """
    localhostProfile indicates a profile loaded on the node that should be used. The profile must be preconfigured on the node to work. Must match the loaded name of the profile. Must be set if and only if type is "Localhost".
    """
    type: str
    """
    type indicates which kind of AppArmor profile will be applied. Valid options are:
      Localhost - a profile pre-loaded on the node.
      RuntimeDefault - the container runtime's default profile.
      Unconfined - no AppArmor enforcement.
    """


class AttachedVolume(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["AttachedVolume"]:
            return AttachedVolume

        def build(self) -> "AttachedVolume":
            return AttachedVolume(**self._attrs)

        def device_path(self, value: str, /) -> Self:
            """
            DevicePath represents the device path where the volume should be available
            """
            return self._set("device_path", value)

        def name(self, value: str, /) -> Self:
            """
            Name of the attached volume
            """
            return self._set("name", value)

    class BuilderContext(BuilderContextBase["AttachedVolume.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = AttachedVolume.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for AttachedVolume."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["AttachedVolume", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use AttachedVolume.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    device_path: Annotated[str, Field(alias="devicePath")]
    """
    DevicePath represents the device path where the volume should be available
    """
    name: str
    """
    Name of the attached volume
    """


class AzureDiskVolumeSource(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["AzureDiskVolumeSource"]:
            return AzureDiskVolumeSource

        def build(self) -> "AzureDiskVolumeSource":
            return AzureDiskVolumeSource(**self._attrs)

        def caching_mode(self, value: Optional[str], /) -> Self:
            """
            cachingMode is the Host Caching mode: None, Read Only, Read Write.
            """
            return self._set("caching_mode", value)

        def disk_name(self, value: str, /) -> Self:
            """
            diskName is the Name of the data disk in the blob storage
            """
            return self._set("disk_name", value)

        def disk_uri(self, value: str, /) -> Self:
            """
            diskURI is the URI of data disk in the blob storage
            """
            return self._set("disk_uri", value)

        def fs_type(self, value: Optional[str], /) -> Self:
            """
            fsType is Filesystem type to mount. Must be a filesystem type supported by the host operating system. Ex. "ext4", "xfs", "ntfs". Implicitly inferred to be "ext4" if unspecified.
            """
            return self._set("fs_type", value)

        def kind(self, value: Optional[str], /) -> Self:
            """
            kind expected values are Shared: multiple blob disks per storage account  Dedicated: single blob disk per storage account  Managed: azure managed data disk (only in managed availability set). defaults to shared
            """
            return self._set("kind", value)

        def read_only(self, value: Optional[bool], /) -> Self:
            """
            readOnly Defaults to false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts.
            """
            return self._set("read_only", value)

    class BuilderContext(BuilderContextBase["AzureDiskVolumeSource.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = AzureDiskVolumeSource.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for AzureDiskVolumeSource."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["AzureDiskVolumeSource", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use AzureDiskVolumeSource.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    caching_mode: Annotated[Optional[str], Field(alias="cachingMode")] = None
    """
    cachingMode is the Host Caching mode: None, Read Only, Read Write.
    """
    disk_name: Annotated[str, Field(alias="diskName")]
    """
    diskName is the Name of the data disk in the blob storage
    """
    disk_uri: Annotated[str, Field(alias="diskURI")]
    """
    diskURI is the URI of data disk in the blob storage
    """
    fs_type: Annotated[Optional[str], Field(alias="fsType")] = None
    """
    fsType is Filesystem type to mount. Must be a filesystem type supported by the host operating system. Ex. "ext4", "xfs", "ntfs". Implicitly inferred to be "ext4" if unspecified.
    """
    kind: Optional[str] = None
    """
    kind expected values are Shared: multiple blob disks per storage account  Dedicated: single blob disk per storage account  Managed: azure managed data disk (only in managed availability set). defaults to shared
    """
    read_only: Annotated[Optional[bool], Field(alias="readOnly")] = None
    """
    readOnly Defaults to false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts.
    """


class AzureFilePersistentVolumeSource(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["AzureFilePersistentVolumeSource"]:
            return AzureFilePersistentVolumeSource

        def build(self) -> "AzureFilePersistentVolumeSource":
            return AzureFilePersistentVolumeSource(**self._attrs)

        def read_only(self, value: Optional[bool], /) -> Self:
            """
            readOnly defaults to false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts.
            """
            return self._set("read_only", value)

        def secret_name(self, value: str, /) -> Self:
            """
            secretName is the name of secret that contains Azure Storage Account Name and Key
            """
            return self._set("secret_name", value)

        def secret_namespace(self, value: Optional[str], /) -> Self:
            """
            secretNamespace is the namespace of the secret that contains Azure Storage Account Name and Key default is the same as the Pod
            """
            return self._set("secret_namespace", value)

        def share_name(self, value: str, /) -> Self:
            """
            shareName is the azure Share Name
            """
            return self._set("share_name", value)

    class BuilderContext(BuilderContextBase["AzureFilePersistentVolumeSource.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = AzureFilePersistentVolumeSource.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for AzureFilePersistentVolumeSource."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["AzureFilePersistentVolumeSource", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use AzureFilePersistentVolumeSource.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    read_only: Annotated[Optional[bool], Field(alias="readOnly")] = None
    """
    readOnly defaults to false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts.
    """
    secret_name: Annotated[str, Field(alias="secretName")]
    """
    secretName is the name of secret that contains Azure Storage Account Name and Key
    """
    secret_namespace: Annotated[Optional[str], Field(alias="secretNamespace")] = None
    """
    secretNamespace is the namespace of the secret that contains Azure Storage Account Name and Key default is the same as the Pod
    """
    share_name: Annotated[str, Field(alias="shareName")]
    """
    shareName is the azure Share Name
    """


class AzureFileVolumeSource(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["AzureFileVolumeSource"]:
            return AzureFileVolumeSource

        def build(self) -> "AzureFileVolumeSource":
            return AzureFileVolumeSource(**self._attrs)

        def read_only(self, value: Optional[bool], /) -> Self:
            """
            readOnly defaults to false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts.
            """
            return self._set("read_only", value)

        def secret_name(self, value: str, /) -> Self:
            """
            secretName is the  name of secret that contains Azure Storage Account Name and Key
            """
            return self._set("secret_name", value)

        def share_name(self, value: str, /) -> Self:
            """
            shareName is the azure share Name
            """
            return self._set("share_name", value)

    class BuilderContext(BuilderContextBase["AzureFileVolumeSource.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = AzureFileVolumeSource.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for AzureFileVolumeSource."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["AzureFileVolumeSource", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use AzureFileVolumeSource.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    read_only: Annotated[Optional[bool], Field(alias="readOnly")] = None
    """
    readOnly defaults to false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts.
    """
    secret_name: Annotated[str, Field(alias="secretName")]
    """
    secretName is the  name of secret that contains Azure Storage Account Name and Key
    """
    share_name: Annotated[str, Field(alias="shareName")]
    """
    shareName is the azure share Name
    """


class Capabilities(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["Capabilities"]:
            return Capabilities

        def build(self) -> "Capabilities":
            return Capabilities(**self._attrs)

        def add(self, value: Optional[List[str]], /) -> Self:
            """
            Added capabilities
            """
            return self._set("add", value)

        def drop(self, value: Optional[List[str]], /) -> Self:
            """
            Removed capabilities
            """
            return self._set("drop", value)

    class BuilderContext(BuilderContextBase["Capabilities.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = Capabilities.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for Capabilities."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["Capabilities", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use Capabilities.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    add: Optional[List[str]] = None
    """
    Added capabilities
    """
    drop: Optional[List[str]] = None
    """
    Removed capabilities
    """


class ClientIPConfig(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["ClientIPConfig"]:
            return ClientIPConfig

        def build(self) -> "ClientIPConfig":
            return ClientIPConfig(**self._attrs)

        def timeout_seconds(self, value: Optional[int], /) -> Self:
            """
            timeoutSeconds specifies the seconds of ClientIP type session sticky time. The value must be >0 && <=86400(for 1 day) if ServiceAffinity == "ClientIP". Default value is 10800(for 3 hours).
            """
            return self._set("timeout_seconds", value)

    class BuilderContext(BuilderContextBase["ClientIPConfig.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = ClientIPConfig.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for ClientIPConfig."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["ClientIPConfig", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use ClientIPConfig.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    timeout_seconds: Annotated[Optional[int], Field(alias="timeoutSeconds")] = None
    """
    timeoutSeconds specifies the seconds of ClientIP type session sticky time. The value must be >0 && <=86400(for 1 day) if ServiceAffinity == "ClientIP". Default value is 10800(for 3 hours).
    """


class ComponentCondition(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["ComponentCondition"]:
            return ComponentCondition

        def build(self) -> "ComponentCondition":
            return ComponentCondition(**self._attrs)

        def error(self, value: Optional[str], /) -> Self:
            """
            Condition error code for a component. For example, a health check error code.
            """
            return self._set("error", value)

        def message(self, value: Optional[str], /) -> Self:
            """
            Message about the condition for a component. For example, information about a health check.
            """
            return self._set("message", value)

        def status(self, value: str, /) -> Self:
            """
            Status of the condition for a component. Valid values for "Healthy": "True", "False", or "Unknown".
            """
            return self._set("status", value)

        def type(self, value: str, /) -> Self:
            """
            Type of condition for a component. Valid value: "Healthy"
            """
            return self._set("type", value)

    class BuilderContext(BuilderContextBase["ComponentCondition.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = ComponentCondition.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for ComponentCondition."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["ComponentCondition", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use ComponentCondition.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    error: Optional[str] = None
    """
    Condition error code for a component. For example, a health check error code.
    """
    message: Optional[str] = None
    """
    Message about the condition for a component. For example, information about a health check.
    """
    status: str
    """
    Status of the condition for a component. Valid values for "Healthy": "True", "False", or "Unknown".
    """
    type: str
    """
    Type of condition for a component. Valid value: "Healthy"
    """


class ConfigMapEnvSource(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["ConfigMapEnvSource"]:
            return ConfigMapEnvSource

        def build(self) -> "ConfigMapEnvSource":
            return ConfigMapEnvSource(**self._attrs)

        def name(self, value: Optional[str], /) -> Self:
            """
            Name of the referent. This field is effectively required, but due to backwards compatibility is allowed to be empty. Instances of this type with an empty value here are almost certainly wrong. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names
            """
            return self._set("name", value)

        def optional(self, value: Optional[bool], /) -> Self:
            """
            Specify whether the ConfigMap must be defined
            """
            return self._set("optional", value)

    class BuilderContext(BuilderContextBase["ConfigMapEnvSource.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = ConfigMapEnvSource.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for ConfigMapEnvSource."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["ConfigMapEnvSource", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use ConfigMapEnvSource.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    name: Optional[str] = None
    """
    Name of the referent. This field is effectively required, but due to backwards compatibility is allowed to be empty. Instances of this type with an empty value here are almost certainly wrong. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names
    """
    optional: Optional[bool] = None
    """
    Specify whether the ConfigMap must be defined
    """


class ConfigMapKeySelector(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["ConfigMapKeySelector"]:
            return ConfigMapKeySelector

        def build(self) -> "ConfigMapKeySelector":
            return ConfigMapKeySelector(**self._attrs)

        def key(self, value: str, /) -> Self:
            """
            The key to select.
            """
            return self._set("key", value)

        def name(self, value: Optional[str], /) -> Self:
            """
            Name of the referent. This field is effectively required, but due to backwards compatibility is allowed to be empty. Instances of this type with an empty value here are almost certainly wrong. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names
            """
            return self._set("name", value)

        def optional(self, value: Optional[bool], /) -> Self:
            """
            Specify whether the ConfigMap or its key must be defined
            """
            return self._set("optional", value)

    class BuilderContext(BuilderContextBase["ConfigMapKeySelector.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = ConfigMapKeySelector.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for ConfigMapKeySelector."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["ConfigMapKeySelector", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use ConfigMapKeySelector.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    key: str
    """
    The key to select.
    """
    name: Optional[str] = None
    """
    Name of the referent. This field is effectively required, but due to backwards compatibility is allowed to be empty. Instances of this type with an empty value here are almost certainly wrong. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names
    """
    optional: Optional[bool] = None
    """
    Specify whether the ConfigMap or its key must be defined
    """


class ConfigMapNodeConfigSource(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["ConfigMapNodeConfigSource"]:
            return ConfigMapNodeConfigSource

        def build(self) -> "ConfigMapNodeConfigSource":
            return ConfigMapNodeConfigSource(**self._attrs)

        def kubelet_config_key(self, value: str, /) -> Self:
            """
            KubeletConfigKey declares which key of the referenced ConfigMap corresponds to the KubeletConfiguration structure This field is required in all cases.
            """
            return self._set("kubelet_config_key", value)

        def name(self, value: str, /) -> Self:
            """
            Name is the metadata.name of the referenced ConfigMap. This field is required in all cases.
            """
            return self._set("name", value)

        def namespace(self, value: str, /) -> Self:
            """
            Namespace is the metadata.namespace of the referenced ConfigMap. This field is required in all cases.
            """
            return self._set("namespace", value)

        def resource_version(self, value: Optional[str], /) -> Self:
            """
            ResourceVersion is the metadata.ResourceVersion of the referenced ConfigMap. This field is forbidden in Node.Spec, and required in Node.Status.
            """
            return self._set("resource_version", value)

        def uid(self, value: Optional[str], /) -> Self:
            """
            UID is the metadata.UID of the referenced ConfigMap. This field is forbidden in Node.Spec, and required in Node.Status.
            """
            return self._set("uid", value)

    class BuilderContext(BuilderContextBase["ConfigMapNodeConfigSource.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = ConfigMapNodeConfigSource.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for ConfigMapNodeConfigSource."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["ConfigMapNodeConfigSource", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use ConfigMapNodeConfigSource.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    kubelet_config_key: Annotated[str, Field(alias="kubeletConfigKey")]
    """
    KubeletConfigKey declares which key of the referenced ConfigMap corresponds to the KubeletConfiguration structure This field is required in all cases.
    """
    name: str
    """
    Name is the metadata.name of the referenced ConfigMap. This field is required in all cases.
    """
    namespace: str
    """
    Namespace is the metadata.namespace of the referenced ConfigMap. This field is required in all cases.
    """
    resource_version: Annotated[Optional[str], Field(alias="resourceVersion")] = None
    """
    ResourceVersion is the metadata.ResourceVersion of the referenced ConfigMap. This field is forbidden in Node.Spec, and required in Node.Status.
    """
    uid: Optional[str] = None
    """
    UID is the metadata.UID of the referenced ConfigMap. This field is forbidden in Node.Spec, and required in Node.Status.
    """


class ContainerImage(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["ContainerImage"]:
            return ContainerImage

        def build(self) -> "ContainerImage":
            return ContainerImage(**self._attrs)

        def names(self, value: Optional[List[str]], /) -> Self:
            """
            Names by which this image is known. e.g. ["kubernetes.example/hyperkube:v1.0.7", "cloud-vendor.registry.example/cloud-vendor/hyperkube:v1.0.7"]
            """
            return self._set("names", value)

        def size_bytes(self, value: Optional[int], /) -> Self:
            """
            The size of the image in bytes.
            """
            return self._set("size_bytes", value)

    class BuilderContext(BuilderContextBase["ContainerImage.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = ContainerImage.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for ContainerImage."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["ContainerImage", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use ContainerImage.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    names: Optional[List[str]] = None
    """
    Names by which this image is known. e.g. ["kubernetes.example/hyperkube:v1.0.7", "cloud-vendor.registry.example/cloud-vendor/hyperkube:v1.0.7"]
    """
    size_bytes: Annotated[Optional[int], Field(alias="sizeBytes")] = None
    """
    The size of the image in bytes.
    """


class ContainerPort(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["ContainerPort"]:
            return ContainerPort

        def build(self) -> "ContainerPort":
            return ContainerPort(**self._attrs)

        def container_port(self, value: int, /) -> Self:
            """
            Number of port to expose on the pod's IP address. This must be a valid port number, 0 < x < 65536.
            """
            return self._set("container_port", value)

        def host_ip(self, value: Optional[str], /) -> Self:
            """
            What host IP to bind the external port to.
            """
            return self._set("host_ip", value)

        def host_port(self, value: Optional[int], /) -> Self:
            """
            Number of port to expose on the host. If specified, this must be a valid port number, 0 < x < 65536. If HostNetwork is specified, this must match ContainerPort. Most containers do not need this.
            """
            return self._set("host_port", value)

        def name(self, value: Optional[str], /) -> Self:
            """
            If specified, this must be an IANA_SVC_NAME and unique within the pod. Each named port in a pod must have a unique name. Name for the port that can be referred to by services.
            """
            return self._set("name", value)

        def protocol(self, value: Optional[str], /) -> Self:
            """
            Protocol for port. Must be UDP, TCP, or SCTP. Defaults to "TCP".
            """
            return self._set("protocol", value)

    class BuilderContext(BuilderContextBase["ContainerPort.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = ContainerPort.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for ContainerPort."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["ContainerPort", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use ContainerPort.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    container_port: Annotated[int, Field(alias="containerPort")]
    """
    Number of port to expose on the pod's IP address. This must be a valid port number, 0 < x < 65536.
    """
    host_ip: Annotated[Optional[str], Field(alias="hostIP")] = None
    """
    What host IP to bind the external port to.
    """
    host_port: Annotated[Optional[int], Field(alias="hostPort")] = None
    """
    Number of port to expose on the host. If specified, this must be a valid port number, 0 < x < 65536. If HostNetwork is specified, this must match ContainerPort. Most containers do not need this.
    """
    name: Optional[str] = None
    """
    If specified, this must be an IANA_SVC_NAME and unique within the pod. Each named port in a pod must have a unique name. Name for the port that can be referred to by services.
    """
    protocol: Optional[str] = None
    """
    Protocol for port. Must be UDP, TCP, or SCTP. Defaults to "TCP".
    """


class ContainerResizePolicy(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["ContainerResizePolicy"]:
            return ContainerResizePolicy

        def build(self) -> "ContainerResizePolicy":
            return ContainerResizePolicy(**self._attrs)

        def resource_name(self, value: str, /) -> Self:
            """
            Name of the resource to which this resource resize policy applies. Supported values: cpu, memory.
            """
            return self._set("resource_name", value)

        def restart_policy(self, value: str, /) -> Self:
            """
            Restart policy to apply when specified resource is resized. If not specified, it defaults to NotRequired.
            """
            return self._set("restart_policy", value)

    class BuilderContext(BuilderContextBase["ContainerResizePolicy.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = ContainerResizePolicy.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for ContainerResizePolicy."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["ContainerResizePolicy", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use ContainerResizePolicy.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    resource_name: Annotated[str, Field(alias="resourceName")]
    """
    Name of the resource to which this resource resize policy applies. Supported values: cpu, memory.
    """
    restart_policy: Annotated[str, Field(alias="restartPolicy")]
    """
    Restart policy to apply when specified resource is resized. If not specified, it defaults to NotRequired.
    """


class ContainerStateWaiting(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["ContainerStateWaiting"]:
            return ContainerStateWaiting

        def build(self) -> "ContainerStateWaiting":
            return ContainerStateWaiting(**self._attrs)

        def message(self, value: Optional[str], /) -> Self:
            """
            Message regarding why the container is not yet running.
            """
            return self._set("message", value)

        def reason(self, value: Optional[str], /) -> Self:
            """
            (brief) reason the container is not yet running.
            """
            return self._set("reason", value)

    class BuilderContext(BuilderContextBase["ContainerStateWaiting.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = ContainerStateWaiting.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for ContainerStateWaiting."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["ContainerStateWaiting", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use ContainerStateWaiting.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    message: Optional[str] = None
    """
    Message regarding why the container is not yet running.
    """
    reason: Optional[str] = None
    """
    (brief) reason the container is not yet running.
    """


class DaemonEndpoint(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["DaemonEndpoint"]:
            return DaemonEndpoint

        def build(self) -> "DaemonEndpoint":
            return DaemonEndpoint(**self._attrs)

        def port(self, value: int, /) -> Self:
            """
            Port number of the given endpoint.
            """
            return self._set("port", value)

    class BuilderContext(BuilderContextBase["DaemonEndpoint.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = DaemonEndpoint.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for DaemonEndpoint."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["DaemonEndpoint", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use DaemonEndpoint.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    port: Annotated[int, Field(alias="Port")]
    """
    Port number of the given endpoint.
    """


class EndpointPort(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["EndpointPort"]:
            return EndpointPort

        def build(self) -> "EndpointPort":
            return EndpointPort(**self._attrs)

        def app_protocol(self, value: Optional[str], /) -> Self:
            """
            The application protocol for this port. This is used as a hint for implementations to offer richer behavior for protocols that they understand. This field follows standard Kubernetes label syntax. Valid values are either:

            * Un-prefixed protocol names - reserved for IANA standard service names (as per RFC-6335 and https://www.iana.org/assignments/service-names).

            * Kubernetes-defined prefixed names:
              * 'kubernetes.io/h2c' - HTTP/2 prior knowledge over cleartext as described in https://www.rfc-editor.org/rfc/rfc9113.html#name-starting-http-2-with-prior-
              * 'kubernetes.io/ws'  - WebSocket over cleartext as described in https://www.rfc-editor.org/rfc/rfc6455
              * 'kubernetes.io/wss' - WebSocket over TLS as described in https://www.rfc-editor.org/rfc/rfc6455

            * Other protocols should use implementation-defined prefixed names such as mycompany.com/my-custom-protocol.
            """
            return self._set("app_protocol", value)

        def name(self, value: Optional[str], /) -> Self:
            """
            The name of this port.  This must match the 'name' field in the corresponding ServicePort. Must be a DNS_LABEL. Optional only if one port is defined.
            """
            return self._set("name", value)

        def port(self, value: int, /) -> Self:
            """
            The port number of the endpoint.
            """
            return self._set("port", value)

        def protocol(self, value: Optional[str], /) -> Self:
            """
            The IP protocol for this port. Must be UDP, TCP, or SCTP. Default is TCP.
            """
            return self._set("protocol", value)

    class BuilderContext(BuilderContextBase["EndpointPort.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = EndpointPort.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for EndpointPort."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["EndpointPort", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use EndpointPort.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    app_protocol: Annotated[Optional[str], Field(alias="appProtocol")] = None
    """
    The application protocol for this port. This is used as a hint for implementations to offer richer behavior for protocols that they understand. This field follows standard Kubernetes label syntax. Valid values are either:

    * Un-prefixed protocol names - reserved for IANA standard service names (as per RFC-6335 and https://www.iana.org/assignments/service-names).

    * Kubernetes-defined prefixed names:
      * 'kubernetes.io/h2c' - HTTP/2 prior knowledge over cleartext as described in https://www.rfc-editor.org/rfc/rfc9113.html#name-starting-http-2-with-prior-
      * 'kubernetes.io/ws'  - WebSocket over cleartext as described in https://www.rfc-editor.org/rfc/rfc6455
      * 'kubernetes.io/wss' - WebSocket over TLS as described in https://www.rfc-editor.org/rfc/rfc6455

    * Other protocols should use implementation-defined prefixed names such as mycompany.com/my-custom-protocol.
    """
    name: Optional[str] = None
    """
    The name of this port.  This must match the 'name' field in the corresponding ServicePort. Must be a DNS_LABEL. Optional only if one port is defined.
    """
    port: int
    """
    The port number of the endpoint.
    """
    protocol: Optional[str] = None
    """
    The IP protocol for this port. Must be UDP, TCP, or SCTP. Default is TCP.
    """


class EventSource(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["EventSource"]:
            return EventSource

        def build(self) -> "EventSource":
            return EventSource(**self._attrs)

        def component(self, value: Optional[str], /) -> Self:
            """
            Component from which the event is generated.
            """
            return self._set("component", value)

        def host(self, value: Optional[str], /) -> Self:
            """
            Node name on which the event is generated.
            """
            return self._set("host", value)

    class BuilderContext(BuilderContextBase["EventSource.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = EventSource.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for EventSource."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["EventSource", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use EventSource.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    component: Optional[str] = None
    """
    Component from which the event is generated.
    """
    host: Optional[str] = None
    """
    Node name on which the event is generated.
    """


class ExecAction(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["ExecAction"]:
            return ExecAction

        def build(self) -> "ExecAction":
            return ExecAction(**self._attrs)

        def command(self, value: Optional[List[str]], /) -> Self:
            """
            Command is the command line to execute inside the container, the working directory for the command  is root ('/') in the container's filesystem. The command is simply exec'd, it is not run inside a shell, so traditional shell instructions ('|', etc) won't work. To use a shell, you need to explicitly call out to that shell. Exit status of 0 is treated as live/healthy and non-zero is unhealthy.
            """
            return self._set("command", value)

    class BuilderContext(BuilderContextBase["ExecAction.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = ExecAction.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for ExecAction."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["ExecAction", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use ExecAction.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    command: Optional[List[str]] = None
    """
    Command is the command line to execute inside the container, the working directory for the command  is root ('/') in the container's filesystem. The command is simply exec'd, it is not run inside a shell, so traditional shell instructions ('|', etc) won't work. To use a shell, you need to explicitly call out to that shell. Exit status of 0 is treated as live/healthy and non-zero is unhealthy.
    """


class FCVolumeSource(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["FCVolumeSource"]:
            return FCVolumeSource

        def build(self) -> "FCVolumeSource":
            return FCVolumeSource(**self._attrs)

        def fs_type(self, value: Optional[str], /) -> Self:
            """
            fsType is the filesystem type to mount. Must be a filesystem type supported by the host operating system. Ex. "ext4", "xfs", "ntfs". Implicitly inferred to be "ext4" if unspecified.
            """
            return self._set("fs_type", value)

        def lun(self, value: Optional[int], /) -> Self:
            """
            lun is Optional: FC target lun number
            """
            return self._set("lun", value)

        def read_only(self, value: Optional[bool], /) -> Self:
            """
            readOnly is Optional: Defaults to false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts.
            """
            return self._set("read_only", value)

        def target_ww_ns(self, value: Optional[List[str]], /) -> Self:
            """
            targetWWNs is Optional: FC target worldwide names (WWNs)
            """
            return self._set("target_ww_ns", value)

        def wwids(self, value: Optional[List[str]], /) -> Self:
            """
            wwids Optional: FC volume world wide identifiers (wwids) Either wwids or combination of targetWWNs and lun must be set, but not both simultaneously.
            """
            return self._set("wwids", value)

    class BuilderContext(BuilderContextBase["FCVolumeSource.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = FCVolumeSource.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for FCVolumeSource."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["FCVolumeSource", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use FCVolumeSource.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    fs_type: Annotated[Optional[str], Field(alias="fsType")] = None
    """
    fsType is the filesystem type to mount. Must be a filesystem type supported by the host operating system. Ex. "ext4", "xfs", "ntfs". Implicitly inferred to be "ext4" if unspecified.
    """
    lun: Optional[int] = None
    """
    lun is Optional: FC target lun number
    """
    read_only: Annotated[Optional[bool], Field(alias="readOnly")] = None
    """
    readOnly is Optional: Defaults to false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts.
    """
    target_ww_ns: Annotated[Optional[List[str]], Field(alias="targetWWNs")] = None
    """
    targetWWNs is Optional: FC target worldwide names (WWNs)
    """
    wwids: Optional[List[str]] = None
    """
    wwids Optional: FC volume world wide identifiers (wwids) Either wwids or combination of targetWWNs and lun must be set, but not both simultaneously.
    """


class FlockerVolumeSource(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["FlockerVolumeSource"]:
            return FlockerVolumeSource

        def build(self) -> "FlockerVolumeSource":
            return FlockerVolumeSource(**self._attrs)

        def dataset_name(self, value: Optional[str], /) -> Self:
            """
            datasetName is Name of the dataset stored as metadata -> name on the dataset for Flocker should be considered as deprecated
            """
            return self._set("dataset_name", value)

        def dataset_uuid(self, value: Optional[str], /) -> Self:
            """
            datasetUUID is the UUID of the dataset. This is unique identifier of a Flocker dataset
            """
            return self._set("dataset_uuid", value)

    class BuilderContext(BuilderContextBase["FlockerVolumeSource.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = FlockerVolumeSource.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for FlockerVolumeSource."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["FlockerVolumeSource", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use FlockerVolumeSource.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    dataset_name: Annotated[Optional[str], Field(alias="datasetName")] = None
    """
    datasetName is Name of the dataset stored as metadata -> name on the dataset for Flocker should be considered as deprecated
    """
    dataset_uuid: Annotated[Optional[str], Field(alias="datasetUUID")] = None
    """
    datasetUUID is the UUID of the dataset. This is unique identifier of a Flocker dataset
    """


class GCEPersistentDiskVolumeSource(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["GCEPersistentDiskVolumeSource"]:
            return GCEPersistentDiskVolumeSource

        def build(self) -> "GCEPersistentDiskVolumeSource":
            return GCEPersistentDiskVolumeSource(**self._attrs)

        def fs_type(self, value: Optional[str], /) -> Self:
            """
            fsType is filesystem type of the volume that you want to mount. Tip: Ensure that the filesystem type is supported by the host operating system. Examples: "ext4", "xfs", "ntfs". Implicitly inferred to be "ext4" if unspecified. More info: https://kubernetes.io/docs/concepts/storage/volumes#gcepersistentdisk
            """
            return self._set("fs_type", value)

        def partition(self, value: Optional[int], /) -> Self:
            """
            partition is the partition in the volume that you want to mount. If omitted, the default is to mount by volume name. Examples: For volume /dev/sda1, you specify the partition as "1". Similarly, the volume partition for /dev/sda is "0" (or you can leave the property empty). More info: https://kubernetes.io/docs/concepts/storage/volumes#gcepersistentdisk
            """
            return self._set("partition", value)

        def pd_name(self, value: str, /) -> Self:
            """
            pdName is unique name of the PD resource in GCE. Used to identify the disk in GCE. More info: https://kubernetes.io/docs/concepts/storage/volumes#gcepersistentdisk
            """
            return self._set("pd_name", value)

        def read_only(self, value: Optional[bool], /) -> Self:
            """
            readOnly here will force the ReadOnly setting in VolumeMounts. Defaults to false. More info: https://kubernetes.io/docs/concepts/storage/volumes#gcepersistentdisk
            """
            return self._set("read_only", value)

    class BuilderContext(BuilderContextBase["GCEPersistentDiskVolumeSource.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = GCEPersistentDiskVolumeSource.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for GCEPersistentDiskVolumeSource."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["GCEPersistentDiskVolumeSource", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use GCEPersistentDiskVolumeSource.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    fs_type: Annotated[Optional[str], Field(alias="fsType")] = None
    """
    fsType is filesystem type of the volume that you want to mount. Tip: Ensure that the filesystem type is supported by the host operating system. Examples: "ext4", "xfs", "ntfs". Implicitly inferred to be "ext4" if unspecified. More info: https://kubernetes.io/docs/concepts/storage/volumes#gcepersistentdisk
    """
    partition: Optional[int] = None
    """
    partition is the partition in the volume that you want to mount. If omitted, the default is to mount by volume name. Examples: For volume /dev/sda1, you specify the partition as "1". Similarly, the volume partition for /dev/sda is "0" (or you can leave the property empty). More info: https://kubernetes.io/docs/concepts/storage/volumes#gcepersistentdisk
    """
    pd_name: Annotated[str, Field(alias="pdName")]
    """
    pdName is unique name of the PD resource in GCE. Used to identify the disk in GCE. More info: https://kubernetes.io/docs/concepts/storage/volumes#gcepersistentdisk
    """
    read_only: Annotated[Optional[bool], Field(alias="readOnly")] = None
    """
    readOnly here will force the ReadOnly setting in VolumeMounts. Defaults to false. More info: https://kubernetes.io/docs/concepts/storage/volumes#gcepersistentdisk
    """


class GRPCAction(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["GRPCAction"]:
            return GRPCAction

        def build(self) -> "GRPCAction":
            return GRPCAction(**self._attrs)

        def port(self, value: int, /) -> Self:
            """
            Port number of the gRPC service. Number must be in the range 1 to 65535.
            """
            return self._set("port", value)

        def service(self, value: Optional[str], /) -> Self:
            """
            Service is the name of the service to place in the gRPC HealthCheckRequest (see https://github.com/grpc/grpc/blob/master/doc/health-checking.md).

            If this is not specified, the default behavior is defined by gRPC.
            """
            return self._set("service", value)

    class BuilderContext(BuilderContextBase["GRPCAction.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = GRPCAction.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for GRPCAction."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["GRPCAction", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use GRPCAction.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    port: int
    """
    Port number of the gRPC service. Number must be in the range 1 to 65535.
    """
    service: Optional[str] = None
    """
    Service is the name of the service to place in the gRPC HealthCheckRequest (see https://github.com/grpc/grpc/blob/master/doc/health-checking.md).

    If this is not specified, the default behavior is defined by gRPC.
    """


class GitRepoVolumeSource(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["GitRepoVolumeSource"]:
            return GitRepoVolumeSource

        def build(self) -> "GitRepoVolumeSource":
            return GitRepoVolumeSource(**self._attrs)

        def directory(self, value: Optional[str], /) -> Self:
            """
            directory is the target directory name. Must not contain or start with '..'.  If '.' is supplied, the volume directory will be the git repository.  Otherwise, if specified, the volume will contain the git repository in the subdirectory with the given name.
            """
            return self._set("directory", value)

        def repository(self, value: str, /) -> Self:
            """
            repository is the URL
            """
            return self._set("repository", value)

        def revision(self, value: Optional[str], /) -> Self:
            """
            revision is the commit hash for the specified revision.
            """
            return self._set("revision", value)

    class BuilderContext(BuilderContextBase["GitRepoVolumeSource.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = GitRepoVolumeSource.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for GitRepoVolumeSource."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["GitRepoVolumeSource", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use GitRepoVolumeSource.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    directory: Optional[str] = None
    """
    directory is the target directory name. Must not contain or start with '..'.  If '.' is supplied, the volume directory will be the git repository.  Otherwise, if specified, the volume will contain the git repository in the subdirectory with the given name.
    """
    repository: str
    """
    repository is the URL
    """
    revision: Optional[str] = None
    """
    revision is the commit hash for the specified revision.
    """


class GlusterfsPersistentVolumeSource(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["GlusterfsPersistentVolumeSource"]:
            return GlusterfsPersistentVolumeSource

        def build(self) -> "GlusterfsPersistentVolumeSource":
            return GlusterfsPersistentVolumeSource(**self._attrs)

        def endpoints(self, value: str, /) -> Self:
            """
            endpoints is the endpoint name that details Glusterfs topology. More info: https://examples.k8s.io/volumes/glusterfs/README.md#create-a-pod
            """
            return self._set("endpoints", value)

        def endpoints_namespace(self, value: Optional[str], /) -> Self:
            """
            endpointsNamespace is the namespace that contains Glusterfs endpoint. If this field is empty, the EndpointNamespace defaults to the same namespace as the bound PVC. More info: https://examples.k8s.io/volumes/glusterfs/README.md#create-a-pod
            """
            return self._set("endpoints_namespace", value)

        def path(self, value: str, /) -> Self:
            """
            path is the Glusterfs volume path. More info: https://examples.k8s.io/volumes/glusterfs/README.md#create-a-pod
            """
            return self._set("path", value)

        def read_only(self, value: Optional[bool], /) -> Self:
            """
            readOnly here will force the Glusterfs volume to be mounted with read-only permissions. Defaults to false. More info: https://examples.k8s.io/volumes/glusterfs/README.md#create-a-pod
            """
            return self._set("read_only", value)

    class BuilderContext(BuilderContextBase["GlusterfsPersistentVolumeSource.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = GlusterfsPersistentVolumeSource.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for GlusterfsPersistentVolumeSource."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["GlusterfsPersistentVolumeSource", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use GlusterfsPersistentVolumeSource.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    endpoints: str
    """
    endpoints is the endpoint name that details Glusterfs topology. More info: https://examples.k8s.io/volumes/glusterfs/README.md#create-a-pod
    """
    endpoints_namespace: Annotated[Optional[str], Field(alias="endpointsNamespace")] = None
    """
    endpointsNamespace is the namespace that contains Glusterfs endpoint. If this field is empty, the EndpointNamespace defaults to the same namespace as the bound PVC. More info: https://examples.k8s.io/volumes/glusterfs/README.md#create-a-pod
    """
    path: str
    """
    path is the Glusterfs volume path. More info: https://examples.k8s.io/volumes/glusterfs/README.md#create-a-pod
    """
    read_only: Annotated[Optional[bool], Field(alias="readOnly")] = None
    """
    readOnly here will force the Glusterfs volume to be mounted with read-only permissions. Defaults to false. More info: https://examples.k8s.io/volumes/glusterfs/README.md#create-a-pod
    """


class GlusterfsVolumeSource(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["GlusterfsVolumeSource"]:
            return GlusterfsVolumeSource

        def build(self) -> "GlusterfsVolumeSource":
            return GlusterfsVolumeSource(**self._attrs)

        def endpoints(self, value: str, /) -> Self:
            """
            endpoints is the endpoint name that details Glusterfs topology. More info: https://examples.k8s.io/volumes/glusterfs/README.md#create-a-pod
            """
            return self._set("endpoints", value)

        def path(self, value: str, /) -> Self:
            """
            path is the Glusterfs volume path. More info: https://examples.k8s.io/volumes/glusterfs/README.md#create-a-pod
            """
            return self._set("path", value)

        def read_only(self, value: Optional[bool], /) -> Self:
            """
            readOnly here will force the Glusterfs volume to be mounted with read-only permissions. Defaults to false. More info: https://examples.k8s.io/volumes/glusterfs/README.md#create-a-pod
            """
            return self._set("read_only", value)

    class BuilderContext(BuilderContextBase["GlusterfsVolumeSource.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = GlusterfsVolumeSource.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for GlusterfsVolumeSource."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["GlusterfsVolumeSource", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use GlusterfsVolumeSource.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    endpoints: str
    """
    endpoints is the endpoint name that details Glusterfs topology. More info: https://examples.k8s.io/volumes/glusterfs/README.md#create-a-pod
    """
    path: str
    """
    path is the Glusterfs volume path. More info: https://examples.k8s.io/volumes/glusterfs/README.md#create-a-pod
    """
    read_only: Annotated[Optional[bool], Field(alias="readOnly")] = None
    """
    readOnly here will force the Glusterfs volume to be mounted with read-only permissions. Defaults to false. More info: https://examples.k8s.io/volumes/glusterfs/README.md#create-a-pod
    """


class HTTPHeader(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["HTTPHeader"]:
            return HTTPHeader

        def build(self) -> "HTTPHeader":
            return HTTPHeader(**self._attrs)

        def name(self, value: str, /) -> Self:
            """
            The header field name. This will be canonicalized upon output, so case-variant names will be understood as the same header.
            """
            return self._set("name", value)

        def value(self, value: str, /) -> Self:
            """
            The header field value
            """
            return self._set("value", value)

    class BuilderContext(BuilderContextBase["HTTPHeader.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = HTTPHeader.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for HTTPHeader."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["HTTPHeader", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use HTTPHeader.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    name: str
    """
    The header field name. This will be canonicalized upon output, so case-variant names will be understood as the same header.
    """
    value: str
    """
    The header field value
    """


class HostAlias(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["HostAlias"]:
            return HostAlias

        def build(self) -> "HostAlias":
            return HostAlias(**self._attrs)

        def hostnames(self, value: Optional[List[str]], /) -> Self:
            """
            Hostnames for the above IP address.
            """
            return self._set("hostnames", value)

        def ip(self, value: str, /) -> Self:
            """
            IP address of the host file entry.
            """
            return self._set("ip", value)

    class BuilderContext(BuilderContextBase["HostAlias.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = HostAlias.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for HostAlias."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["HostAlias", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use HostAlias.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    hostnames: Optional[List[str]] = None
    """
    Hostnames for the above IP address.
    """
    ip: str
    """
    IP address of the host file entry.
    """


class HostIP(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["HostIP"]:
            return HostIP

        def build(self) -> "HostIP":
            return HostIP(**self._attrs)

        def ip(self, value: str, /) -> Self:
            """
            IP is the IP address assigned to the host
            """
            return self._set("ip", value)

    class BuilderContext(BuilderContextBase["HostIP.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = HostIP.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for HostIP."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["HostIP", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use HostIP.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    ip: str
    """
    IP is the IP address assigned to the host
    """


class HostPathVolumeSource(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["HostPathVolumeSource"]:
            return HostPathVolumeSource

        def build(self) -> "HostPathVolumeSource":
            return HostPathVolumeSource(**self._attrs)

        def path(self, value: str, /) -> Self:
            """
            path of the directory on the host. If the path is a symlink, it will follow the link to the real path. More info: https://kubernetes.io/docs/concepts/storage/volumes#hostpath
            """
            return self._set("path", value)

        def type(self, value: Optional[str], /) -> Self:
            """
            type for HostPath Volume Defaults to "" More info: https://kubernetes.io/docs/concepts/storage/volumes#hostpath
            """
            return self._set("type", value)

    class BuilderContext(BuilderContextBase["HostPathVolumeSource.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = HostPathVolumeSource.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for HostPathVolumeSource."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["HostPathVolumeSource", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use HostPathVolumeSource.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    path: str
    """
    path of the directory on the host. If the path is a symlink, it will follow the link to the real path. More info: https://kubernetes.io/docs/concepts/storage/volumes#hostpath
    """
    type: Optional[str] = None
    """
    type for HostPath Volume Defaults to "" More info: https://kubernetes.io/docs/concepts/storage/volumes#hostpath
    """


class ImageVolumeSource(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["ImageVolumeSource"]:
            return ImageVolumeSource

        def build(self) -> "ImageVolumeSource":
            return ImageVolumeSource(**self._attrs)

        def pull_policy(self, value: Optional[str], /) -> Self:
            """
            Policy for pulling OCI objects. Possible values are: Always: the kubelet always attempts to pull the reference. Container creation will fail If the pull fails. Never: the kubelet never pulls the reference and only uses a local image or artifact. Container creation will fail if the reference isn't present. IfNotPresent: the kubelet pulls if the reference isn't already present on disk. Container creation will fail if the reference isn't present and the pull fails. Defaults to Always if :latest tag is specified, or IfNotPresent otherwise.
            """
            return self._set("pull_policy", value)

        def reference(self, value: Optional[str], /) -> Self:
            """
            Required: Image or artifact reference to be used. Behaves in the same way as pod.spec.containers[*].image. Pull secrets will be assembled in the same way as for the container image by looking up node credentials, SA image pull secrets, and pod spec image pull secrets. More info: https://kubernetes.io/docs/concepts/containers/images This field is optional to allow higher level config management to default or override container images in workload controllers like Deployments and StatefulSets.
            """
            return self._set("reference", value)

    class BuilderContext(BuilderContextBase["ImageVolumeSource.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = ImageVolumeSource.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for ImageVolumeSource."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["ImageVolumeSource", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use ImageVolumeSource.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    pull_policy: Annotated[Optional[str], Field(alias="pullPolicy")] = None
    """
    Policy for pulling OCI objects. Possible values are: Always: the kubelet always attempts to pull the reference. Container creation will fail If the pull fails. Never: the kubelet never pulls the reference and only uses a local image or artifact. Container creation will fail if the reference isn't present. IfNotPresent: the kubelet pulls if the reference isn't already present on disk. Container creation will fail if the reference isn't present and the pull fails. Defaults to Always if :latest tag is specified, or IfNotPresent otherwise.
    """
    reference: Optional[str] = None
    """
    Required: Image or artifact reference to be used. Behaves in the same way as pod.spec.containers[*].image. Pull secrets will be assembled in the same way as for the container image by looking up node credentials, SA image pull secrets, and pod spec image pull secrets. More info: https://kubernetes.io/docs/concepts/containers/images This field is optional to allow higher level config management to default or override container images in workload controllers like Deployments and StatefulSets.
    """


class KeyToPath(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["KeyToPath"]:
            return KeyToPath

        def build(self) -> "KeyToPath":
            return KeyToPath(**self._attrs)

        def key(self, value: str, /) -> Self:
            """
            key is the key to project.
            """
            return self._set("key", value)

        def mode(self, value: Optional[int], /) -> Self:
            """
            mode is Optional: mode bits used to set permissions on this file. Must be an octal value between 0000 and 0777 or a decimal value between 0 and 511. YAML accepts both octal and decimal values, JSON requires decimal values for mode bits. If not specified, the volume defaultMode will be used. This might be in conflict with other options that affect the file mode, like fsGroup, and the result can be other mode bits set.
            """
            return self._set("mode", value)

        def path(self, value: str, /) -> Self:
            """
            path is the relative path of the file to map the key to. May not be an absolute path. May not contain the path element '..'. May not start with the string '..'.
            """
            return self._set("path", value)

    class BuilderContext(BuilderContextBase["KeyToPath.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = KeyToPath.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for KeyToPath."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["KeyToPath", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use KeyToPath.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    key: str
    """
    key is the key to project.
    """
    mode: Optional[int] = None
    """
    mode is Optional: mode bits used to set permissions on this file. Must be an octal value between 0000 and 0777 or a decimal value between 0 and 511. YAML accepts both octal and decimal values, JSON requires decimal values for mode bits. If not specified, the volume defaultMode will be used. This might be in conflict with other options that affect the file mode, like fsGroup, and the result can be other mode bits set.
    """
    path: str
    """
    path is the relative path of the file to map the key to. May not be an absolute path. May not contain the path element '..'. May not start with the string '..'.
    """


class LinuxContainerUser(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["LinuxContainerUser"]:
            return LinuxContainerUser

        def build(self) -> "LinuxContainerUser":
            return LinuxContainerUser(**self._attrs)

        def gid(self, value: int, /) -> Self:
            """
            GID is the primary gid initially attached to the first process in the container
            """
            return self._set("gid", value)

        def supplemental_groups(self, value: Optional[List[int]], /) -> Self:
            """
            SupplementalGroups are the supplemental groups initially attached to the first process in the container
            """
            return self._set("supplemental_groups", value)

        def uid(self, value: int, /) -> Self:
            """
            UID is the primary uid initially attached to the first process in the container
            """
            return self._set("uid", value)

    class BuilderContext(BuilderContextBase["LinuxContainerUser.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = LinuxContainerUser.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for LinuxContainerUser."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["LinuxContainerUser", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use LinuxContainerUser.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    gid: int
    """
    GID is the primary gid initially attached to the first process in the container
    """
    supplemental_groups: Annotated[Optional[List[int]], Field(alias="supplementalGroups")] = None
    """
    SupplementalGroups are the supplemental groups initially attached to the first process in the container
    """
    uid: int
    """
    UID is the primary uid initially attached to the first process in the container
    """


class LocalObjectReference(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["LocalObjectReference"]:
            return LocalObjectReference

        def build(self) -> "LocalObjectReference":
            return LocalObjectReference(**self._attrs)

        def name(self, value: Optional[str], /) -> Self:
            """
            Name of the referent. This field is effectively required, but due to backwards compatibility is allowed to be empty. Instances of this type with an empty value here are almost certainly wrong. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names
            """
            return self._set("name", value)

    class BuilderContext(BuilderContextBase["LocalObjectReference.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = LocalObjectReference.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for LocalObjectReference."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["LocalObjectReference", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use LocalObjectReference.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    name: Optional[str] = None
    """
    Name of the referent. This field is effectively required, but due to backwards compatibility is allowed to be empty. Instances of this type with an empty value here are almost certainly wrong. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names
    """


class LocalVolumeSource(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["LocalVolumeSource"]:
            return LocalVolumeSource

        def build(self) -> "LocalVolumeSource":
            return LocalVolumeSource(**self._attrs)

        def fs_type(self, value: Optional[str], /) -> Self:
            """
            fsType is the filesystem type to mount. It applies only when the Path is a block device. Must be a filesystem type supported by the host operating system. Ex. "ext4", "xfs", "ntfs". The default value is to auto-select a filesystem if unspecified.
            """
            return self._set("fs_type", value)

        def path(self, value: str, /) -> Self:
            """
            path of the full path to the volume on the node. It can be either a directory or block device (disk, partition, ...).
            """
            return self._set("path", value)

    class BuilderContext(BuilderContextBase["LocalVolumeSource.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = LocalVolumeSource.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for LocalVolumeSource."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["LocalVolumeSource", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use LocalVolumeSource.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    fs_type: Annotated[Optional[str], Field(alias="fsType")] = None
    """
    fsType is the filesystem type to mount. It applies only when the Path is a block device. Must be a filesystem type supported by the host operating system. Ex. "ext4", "xfs", "ntfs". The default value is to auto-select a filesystem if unspecified.
    """
    path: str
    """
    path of the full path to the volume on the node. It can be either a directory or block device (disk, partition, ...).
    """


class ModifyVolumeStatus(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["ModifyVolumeStatus"]:
            return ModifyVolumeStatus

        def build(self) -> "ModifyVolumeStatus":
            return ModifyVolumeStatus(**self._attrs)

        def status(self, value: str, /) -> Self:
            """
            status is the status of the ControllerModifyVolume operation. It can be in any of following states:
             - Pending
               Pending indicates that the PersistentVolumeClaim cannot be modified due to unmet requirements, such as
               the specified VolumeAttributesClass not existing.
             - InProgress
               InProgress indicates that the volume is being modified.
             - Infeasible
              Infeasible indicates that the request has been rejected as invalid by the CSI driver. To
                  resolve the error, a valid VolumeAttributesClass needs to be specified.
            Note: New statuses can be added in the future. Consumers should check for unknown statuses and fail appropriately.
            """
            return self._set("status", value)

        def target_volume_attributes_class_name(self, value: Optional[str], /) -> Self:
            """
            targetVolumeAttributesClassName is the name of the VolumeAttributesClass the PVC currently being reconciled
            """
            return self._set("target_volume_attributes_class_name", value)

    class BuilderContext(BuilderContextBase["ModifyVolumeStatus.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = ModifyVolumeStatus.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for ModifyVolumeStatus."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["ModifyVolumeStatus", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use ModifyVolumeStatus.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    status: str
    """
    status is the status of the ControllerModifyVolume operation. It can be in any of following states:
     - Pending
       Pending indicates that the PersistentVolumeClaim cannot be modified due to unmet requirements, such as
       the specified VolumeAttributesClass not existing.
     - InProgress
       InProgress indicates that the volume is being modified.
     - Infeasible
      Infeasible indicates that the request has been rejected as invalid by the CSI driver. To
          resolve the error, a valid VolumeAttributesClass needs to be specified.
    Note: New statuses can be added in the future. Consumers should check for unknown statuses and fail appropriately.
    """
    target_volume_attributes_class_name: Annotated[
        Optional[str], Field(alias="targetVolumeAttributesClassName")
    ] = None
    """
    targetVolumeAttributesClassName is the name of the VolumeAttributesClass the PVC currently being reconciled
    """


class NFSVolumeSource(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["NFSVolumeSource"]:
            return NFSVolumeSource

        def build(self) -> "NFSVolumeSource":
            return NFSVolumeSource(**self._attrs)

        def path(self, value: str, /) -> Self:
            """
            path that is exported by the NFS server. More info: https://kubernetes.io/docs/concepts/storage/volumes#nfs
            """
            return self._set("path", value)

        def read_only(self, value: Optional[bool], /) -> Self:
            """
            readOnly here will force the NFS export to be mounted with read-only permissions. Defaults to false. More info: https://kubernetes.io/docs/concepts/storage/volumes#nfs
            """
            return self._set("read_only", value)

        def server(self, value: str, /) -> Self:
            """
            server is the hostname or IP address of the NFS server. More info: https://kubernetes.io/docs/concepts/storage/volumes#nfs
            """
            return self._set("server", value)

    class BuilderContext(BuilderContextBase["NFSVolumeSource.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = NFSVolumeSource.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for NFSVolumeSource."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["NFSVolumeSource", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use NFSVolumeSource.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    path: str
    """
    path that is exported by the NFS server. More info: https://kubernetes.io/docs/concepts/storage/volumes#nfs
    """
    read_only: Annotated[Optional[bool], Field(alias="readOnly")] = None
    """
    readOnly here will force the NFS export to be mounted with read-only permissions. Defaults to false. More info: https://kubernetes.io/docs/concepts/storage/volumes#nfs
    """
    server: str
    """
    server is the hostname or IP address of the NFS server. More info: https://kubernetes.io/docs/concepts/storage/volumes#nfs
    """


class NamespaceSpec(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["NamespaceSpec"]:
            return NamespaceSpec

        def build(self) -> "NamespaceSpec":
            return NamespaceSpec(**self._attrs)

        def finalizers(self, value: Optional[List[str]], /) -> Self:
            """
            Finalizers is an opaque list of values that must be empty to permanently remove object from storage. More info: https://kubernetes.io/docs/tasks/administer-cluster/namespaces/
            """
            return self._set("finalizers", value)

    class BuilderContext(BuilderContextBase["NamespaceSpec.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = NamespaceSpec.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for NamespaceSpec."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["NamespaceSpec", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use NamespaceSpec.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    finalizers: Optional[List[str]] = None
    """
    Finalizers is an opaque list of values that must be empty to permanently remove object from storage. More info: https://kubernetes.io/docs/tasks/administer-cluster/namespaces/
    """


class NodeAddress(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["NodeAddress"]:
            return NodeAddress

        def build(self) -> "NodeAddress":
            return NodeAddress(**self._attrs)

        def address(self, value: str, /) -> Self:
            """
            The node address.
            """
            return self._set("address", value)

        def type(self, value: str, /) -> Self:
            """
            Node address type, one of Hostname, ExternalIP or InternalIP.
            """
            return self._set("type", value)

    class BuilderContext(BuilderContextBase["NodeAddress.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = NodeAddress.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for NodeAddress."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["NodeAddress", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use NodeAddress.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    address: str
    """
    The node address.
    """
    type: str
    """
    Node address type, one of Hostname, ExternalIP or InternalIP.
    """


class NodeConfigSource(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["NodeConfigSource"]:
            return NodeConfigSource

        def build(self) -> "NodeConfigSource":
            return NodeConfigSource(**self._attrs)

        @overload
        def config_map(
            self, value_or_callback: Optional[ConfigMapNodeConfigSource], /
        ) -> "NodeConfigSource.Builder": ...

        @overload
        def config_map(
            self,
            value_or_callback: Callable[
                [ConfigMapNodeConfigSource.Builder],
                ConfigMapNodeConfigSource.Builder | ConfigMapNodeConfigSource,
            ],
            /,
        ) -> "NodeConfigSource.Builder": ...

        @overload
        def config_map(
            self, value_or_callback: Never = ...
        ) -> "ConfigMapNodeConfigSource.BuilderContext": ...

        def config_map(self, value_or_callback=None, /):
            """
            ConfigMap is a reference to a Node's ConfigMap
            """
            if self._in_context and value_or_callback is None:
                context = ConfigMapNodeConfigSource.BuilderContext()
                context._parent_builder = self
                context._field_name = "config_map"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(ConfigMapNodeConfigSource.builder())
                if isinstance(output, ConfigMapNodeConfigSource.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("config_map", value)

    class BuilderContext(BuilderContextBase["NodeConfigSource.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = NodeConfigSource.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for NodeConfigSource."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["NodeConfigSource", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use NodeConfigSource.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    config_map: Annotated[Optional[ConfigMapNodeConfigSource], Field(alias="configMap")] = None
    """
    ConfigMap is a reference to a Node's ConfigMap
    """


class NodeConfigStatus(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["NodeConfigStatus"]:
            return NodeConfigStatus

        def build(self) -> "NodeConfigStatus":
            return NodeConfigStatus(**self._attrs)

        @overload
        def active(
            self, value_or_callback: Optional[NodeConfigSource], /
        ) -> "NodeConfigStatus.Builder": ...

        @overload
        def active(
            self,
            value_or_callback: Callable[
                [NodeConfigSource.Builder], NodeConfigSource.Builder | NodeConfigSource
            ],
            /,
        ) -> "NodeConfigStatus.Builder": ...

        @overload
        def active(self, value_or_callback: Never = ...) -> "NodeConfigSource.BuilderContext": ...

        def active(self, value_or_callback=None, /):
            """
            Active reports the checkpointed config the node is actively using. Active will represent either the current version of the Assigned config, or the current LastKnownGood config, depending on whether attempting to use the Assigned config results in an error.
            """
            if self._in_context and value_or_callback is None:
                context = NodeConfigSource.BuilderContext()
                context._parent_builder = self
                context._field_name = "active"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(NodeConfigSource.builder())
                if isinstance(output, NodeConfigSource.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("active", value)

        @overload
        def assigned(
            self, value_or_callback: Optional[NodeConfigSource], /
        ) -> "NodeConfigStatus.Builder": ...

        @overload
        def assigned(
            self,
            value_or_callback: Callable[
                [NodeConfigSource.Builder], NodeConfigSource.Builder | NodeConfigSource
            ],
            /,
        ) -> "NodeConfigStatus.Builder": ...

        @overload
        def assigned(self, value_or_callback: Never = ...) -> "NodeConfigSource.BuilderContext": ...

        def assigned(self, value_or_callback=None, /):
            """
            Assigned reports the checkpointed config the node will try to use. When Node.Spec.ConfigSource is updated, the node checkpoints the associated config payload to local disk, along with a record indicating intended config. The node refers to this record to choose its config checkpoint, and reports this record in Assigned. Assigned only updates in the status after the record has been checkpointed to disk. When the Kubelet is restarted, it tries to make the Assigned config the Active config by loading and validating the checkpointed payload identified by Assigned.
            """
            if self._in_context and value_or_callback is None:
                context = NodeConfigSource.BuilderContext()
                context._parent_builder = self
                context._field_name = "assigned"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(NodeConfigSource.builder())
                if isinstance(output, NodeConfigSource.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("assigned", value)

        def error(self, value: Optional[str], /) -> Self:
            """
            Error describes any problems reconciling the Spec.ConfigSource to the Active config. Errors may occur, for example, attempting to checkpoint Spec.ConfigSource to the local Assigned record, attempting to checkpoint the payload associated with Spec.ConfigSource, attempting to load or validate the Assigned config, etc. Errors may occur at different points while syncing config. Earlier errors (e.g. download or checkpointing errors) will not result in a rollback to LastKnownGood, and may resolve across Kubelet retries. Later errors (e.g. loading or validating a checkpointed config) will result in a rollback to LastKnownGood. In the latter case, it is usually possible to resolve the error by fixing the config assigned in Spec.ConfigSource. You can find additional information for debugging by searching the error message in the Kubelet log. Error is a human-readable description of the error state; machines can check whether or not Error is empty, but should not rely on the stability of the Error text across Kubelet versions.
            """
            return self._set("error", value)

        @overload
        def last_known_good(
            self, value_or_callback: Optional[NodeConfigSource], /
        ) -> "NodeConfigStatus.Builder": ...

        @overload
        def last_known_good(
            self,
            value_or_callback: Callable[
                [NodeConfigSource.Builder], NodeConfigSource.Builder | NodeConfigSource
            ],
            /,
        ) -> "NodeConfigStatus.Builder": ...

        @overload
        def last_known_good(
            self, value_or_callback: Never = ...
        ) -> "NodeConfigSource.BuilderContext": ...

        def last_known_good(self, value_or_callback=None, /):
            """
            LastKnownGood reports the checkpointed config the node will fall back to when it encounters an error attempting to use the Assigned config. The Assigned config becomes the LastKnownGood config when the node determines that the Assigned config is stable and correct. This is currently implemented as a 10-minute soak period starting when the local record of Assigned config is updated. If the Assigned config is Active at the end of this period, it becomes the LastKnownGood. Note that if Spec.ConfigSource is reset to nil (use local defaults), the LastKnownGood is also immediately reset to nil, because the local default config is always assumed good. You should not make assumptions about the node's method of determining config stability and correctness, as this may change or become configurable in the future.
            """
            if self._in_context and value_or_callback is None:
                context = NodeConfigSource.BuilderContext()
                context._parent_builder = self
                context._field_name = "last_known_good"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(NodeConfigSource.builder())
                if isinstance(output, NodeConfigSource.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("last_known_good", value)

    class BuilderContext(BuilderContextBase["NodeConfigStatus.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = NodeConfigStatus.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for NodeConfigStatus."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["NodeConfigStatus", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use NodeConfigStatus.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    active: Optional[NodeConfigSource] = None
    """
    Active reports the checkpointed config the node is actively using. Active will represent either the current version of the Assigned config, or the current LastKnownGood config, depending on whether attempting to use the Assigned config results in an error.
    """
    assigned: Optional[NodeConfigSource] = None
    """
    Assigned reports the checkpointed config the node will try to use. When Node.Spec.ConfigSource is updated, the node checkpoints the associated config payload to local disk, along with a record indicating intended config. The node refers to this record to choose its config checkpoint, and reports this record in Assigned. Assigned only updates in the status after the record has been checkpointed to disk. When the Kubelet is restarted, it tries to make the Assigned config the Active config by loading and validating the checkpointed payload identified by Assigned.
    """
    error: Optional[str] = None
    """
    Error describes any problems reconciling the Spec.ConfigSource to the Active config. Errors may occur, for example, attempting to checkpoint Spec.ConfigSource to the local Assigned record, attempting to checkpoint the payload associated with Spec.ConfigSource, attempting to load or validate the Assigned config, etc. Errors may occur at different points while syncing config. Earlier errors (e.g. download or checkpointing errors) will not result in a rollback to LastKnownGood, and may resolve across Kubelet retries. Later errors (e.g. loading or validating a checkpointed config) will result in a rollback to LastKnownGood. In the latter case, it is usually possible to resolve the error by fixing the config assigned in Spec.ConfigSource. You can find additional information for debugging by searching the error message in the Kubelet log. Error is a human-readable description of the error state; machines can check whether or not Error is empty, but should not rely on the stability of the Error text across Kubelet versions.
    """
    last_known_good: Annotated[Optional[NodeConfigSource], Field(alias="lastKnownGood")] = None
    """
    LastKnownGood reports the checkpointed config the node will fall back to when it encounters an error attempting to use the Assigned config. The Assigned config becomes the LastKnownGood config when the node determines that the Assigned config is stable and correct. This is currently implemented as a 10-minute soak period starting when the local record of Assigned config is updated. If the Assigned config is Active at the end of this period, it becomes the LastKnownGood. Note that if Spec.ConfigSource is reset to nil (use local defaults), the LastKnownGood is also immediately reset to nil, because the local default config is always assumed good. You should not make assumptions about the node's method of determining config stability and correctness, as this may change or become configurable in the future.
    """


class NodeDaemonEndpoints(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["NodeDaemonEndpoints"]:
            return NodeDaemonEndpoints

        def build(self) -> "NodeDaemonEndpoints":
            return NodeDaemonEndpoints(**self._attrs)

        @overload
        def kubelet_endpoint(
            self, value_or_callback: Optional[DaemonEndpoint], /
        ) -> "NodeDaemonEndpoints.Builder": ...

        @overload
        def kubelet_endpoint(
            self,
            value_or_callback: Callable[
                [DaemonEndpoint.Builder], DaemonEndpoint.Builder | DaemonEndpoint
            ],
            /,
        ) -> "NodeDaemonEndpoints.Builder": ...

        @overload
        def kubelet_endpoint(
            self, value_or_callback: Never = ...
        ) -> "DaemonEndpoint.BuilderContext": ...

        def kubelet_endpoint(self, value_or_callback=None, /):
            """
            Endpoint on which Kubelet is listening.
            """
            if self._in_context and value_or_callback is None:
                context = DaemonEndpoint.BuilderContext()
                context._parent_builder = self
                context._field_name = "kubelet_endpoint"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(DaemonEndpoint.builder())
                if isinstance(output, DaemonEndpoint.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("kubelet_endpoint", value)

    class BuilderContext(BuilderContextBase["NodeDaemonEndpoints.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = NodeDaemonEndpoints.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for NodeDaemonEndpoints."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["NodeDaemonEndpoints", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use NodeDaemonEndpoints.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    kubelet_endpoint: Annotated[Optional[DaemonEndpoint], Field(alias="kubeletEndpoint")] = None
    """
    Endpoint on which Kubelet is listening.
    """


class NodeFeatures(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["NodeFeatures"]:
            return NodeFeatures

        def build(self) -> "NodeFeatures":
            return NodeFeatures(**self._attrs)

        def supplemental_groups_policy(self, value: Optional[bool], /) -> Self:
            """
            SupplementalGroupsPolicy is set to true if the runtime supports SupplementalGroupsPolicy and ContainerUser.
            """
            return self._set("supplemental_groups_policy", value)

    class BuilderContext(BuilderContextBase["NodeFeatures.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = NodeFeatures.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for NodeFeatures."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["NodeFeatures", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use NodeFeatures.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    supplemental_groups_policy: Annotated[
        Optional[bool], Field(alias="supplementalGroupsPolicy")
    ] = None
    """
    SupplementalGroupsPolicy is set to true if the runtime supports SupplementalGroupsPolicy and ContainerUser.
    """


class NodeRuntimeHandlerFeatures(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["NodeRuntimeHandlerFeatures"]:
            return NodeRuntimeHandlerFeatures

        def build(self) -> "NodeRuntimeHandlerFeatures":
            return NodeRuntimeHandlerFeatures(**self._attrs)

        def recursive_read_only_mounts(self, value: Optional[bool], /) -> Self:
            """
            RecursiveReadOnlyMounts is set to true if the runtime handler supports RecursiveReadOnlyMounts.
            """
            return self._set("recursive_read_only_mounts", value)

        def user_namespaces(self, value: Optional[bool], /) -> Self:
            """
            UserNamespaces is set to true if the runtime handler supports UserNamespaces, including for volumes.
            """
            return self._set("user_namespaces", value)

    class BuilderContext(BuilderContextBase["NodeRuntimeHandlerFeatures.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = NodeRuntimeHandlerFeatures.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for NodeRuntimeHandlerFeatures."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["NodeRuntimeHandlerFeatures", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use NodeRuntimeHandlerFeatures.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    recursive_read_only_mounts: Annotated[
        Optional[bool], Field(alias="recursiveReadOnlyMounts")
    ] = None
    """
    RecursiveReadOnlyMounts is set to true if the runtime handler supports RecursiveReadOnlyMounts.
    """
    user_namespaces: Annotated[Optional[bool], Field(alias="userNamespaces")] = None
    """
    UserNamespaces is set to true if the runtime handler supports UserNamespaces, including for volumes.
    """


class NodeSelectorRequirement(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["NodeSelectorRequirement"]:
            return NodeSelectorRequirement

        def build(self) -> "NodeSelectorRequirement":
            return NodeSelectorRequirement(**self._attrs)

        def key(self, value: str, /) -> Self:
            """
            The label key that the selector applies to.
            """
            return self._set("key", value)

        def operator(self, value: str, /) -> Self:
            """
            Represents a key's relationship to a set of values. Valid operators are In, NotIn, Exists, DoesNotExist. Gt, and Lt.
            """
            return self._set("operator", value)

        def values(self, value: Optional[List[str]], /) -> Self:
            """
            An array of string values. If the operator is In or NotIn, the values array must be non-empty. If the operator is Exists or DoesNotExist, the values array must be empty. If the operator is Gt or Lt, the values array must have a single element, which will be interpreted as an integer. This array is replaced during a strategic merge patch.
            """
            return self._set("values", value)

    class BuilderContext(BuilderContextBase["NodeSelectorRequirement.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = NodeSelectorRequirement.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for NodeSelectorRequirement."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["NodeSelectorRequirement", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use NodeSelectorRequirement.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    key: str
    """
    The label key that the selector applies to.
    """
    operator: str
    """
    Represents a key's relationship to a set of values. Valid operators are In, NotIn, Exists, DoesNotExist. Gt, and Lt.
    """
    values: Optional[List[str]] = None
    """
    An array of string values. If the operator is In or NotIn, the values array must be non-empty. If the operator is Exists or DoesNotExist, the values array must be empty. If the operator is Gt or Lt, the values array must have a single element, which will be interpreted as an integer. This array is replaced during a strategic merge patch.
    """


class NodeSelectorTerm(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["NodeSelectorTerm"]:
            return NodeSelectorTerm

        def build(self) -> "NodeSelectorTerm":
            return NodeSelectorTerm(**self._attrs)

        @overload
        def match_expressions(
            self, value_or_callback: List[NodeSelectorRequirement], /
        ) -> "NodeSelectorTerm.Builder": ...

        @overload
        def match_expressions(
            self,
            value_or_callback: Callable[
                [GenericListBuilder[NodeSelectorRequirement, NodeSelectorRequirement.Builder]],
                GenericListBuilder[NodeSelectorRequirement, NodeSelectorRequirement.Builder]
                | List[NodeSelectorRequirement],
            ],
            /,
        ) -> "NodeSelectorTerm.Builder": ...

        @overload
        def match_expressions(
            self, value_or_callback: Never = ...
        ) -> ListBuilderContext[NodeSelectorRequirement.Builder]: ...

        def match_expressions(self, value_or_callback=None, /):
            """
            A list of node selector requirements by node's labels.
            """
            if self._in_context and value_or_callback is None:
                context = ListBuilderContext[NodeSelectorRequirement.Builder]()
                context._parent_builder = self
                context._field_name = "match_expressions"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(NodeSelectorRequirement.list_builder())
                if isinstance(output, GenericListBuilder):
                    value = output.build()
                else:
                    value = output
            return self._set("match_expressions", value)

        @overload
        def match_fields(
            self, value_or_callback: List[NodeSelectorRequirement], /
        ) -> "NodeSelectorTerm.Builder": ...

        @overload
        def match_fields(
            self,
            value_or_callback: Callable[
                [GenericListBuilder[NodeSelectorRequirement, NodeSelectorRequirement.Builder]],
                GenericListBuilder[NodeSelectorRequirement, NodeSelectorRequirement.Builder]
                | List[NodeSelectorRequirement],
            ],
            /,
        ) -> "NodeSelectorTerm.Builder": ...

        @overload
        def match_fields(
            self, value_or_callback: Never = ...
        ) -> ListBuilderContext[NodeSelectorRequirement.Builder]: ...

        def match_fields(self, value_or_callback=None, /):
            """
            A list of node selector requirements by node's fields.
            """
            if self._in_context and value_or_callback is None:
                context = ListBuilderContext[NodeSelectorRequirement.Builder]()
                context._parent_builder = self
                context._field_name = "match_fields"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(NodeSelectorRequirement.list_builder())
                if isinstance(output, GenericListBuilder):
                    value = output.build()
                else:
                    value = output
            return self._set("match_fields", value)

    class BuilderContext(BuilderContextBase["NodeSelectorTerm.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = NodeSelectorTerm.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for NodeSelectorTerm."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["NodeSelectorTerm", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use NodeSelectorTerm.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    match_expressions: Annotated[
        Optional[List[NodeSelectorRequirement]], Field(alias="matchExpressions")
    ] = None
    """
    A list of node selector requirements by node's labels.
    """
    match_fields: Annotated[Optional[List[NodeSelectorRequirement]], Field(alias="matchFields")] = (
        None
    )
    """
    A list of node selector requirements by node's fields.
    """


class NodeSystemInfo(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["NodeSystemInfo"]:
            return NodeSystemInfo

        def build(self) -> "NodeSystemInfo":
            return NodeSystemInfo(**self._attrs)

        def architecture(self, value: str, /) -> Self:
            """
            The Architecture reported by the node
            """
            return self._set("architecture", value)

        def boot_id(self, value: str, /) -> Self:
            """
            Boot ID reported by the node.
            """
            return self._set("boot_id", value)

        def container_runtime_version(self, value: str, /) -> Self:
            """
            ContainerRuntime Version reported by the node through runtime remote API (e.g. containerd://1.4.2).
            """
            return self._set("container_runtime_version", value)

        def kernel_version(self, value: str, /) -> Self:
            """
            Kernel Version reported by the node from 'uname -r' (e.g. 3.16.0-0.bpo.4-amd64).
            """
            return self._set("kernel_version", value)

        def kube_proxy_version(self, value: str, /) -> Self:
            """
            Deprecated: KubeProxy Version reported by the node.
            """
            return self._set("kube_proxy_version", value)

        def kubelet_version(self, value: str, /) -> Self:
            """
            Kubelet Version reported by the node.
            """
            return self._set("kubelet_version", value)

        def machine_id(self, value: str, /) -> Self:
            """
            MachineID reported by the node. For unique machine identification in the cluster this field is preferred. Learn more from man(5) machine-id: http://man7.org/linux/man-pages/man5/machine-id.5.html
            """
            return self._set("machine_id", value)

        def operating_system(self, value: str, /) -> Self:
            """
            The Operating System reported by the node
            """
            return self._set("operating_system", value)

        def os_image(self, value: str, /) -> Self:
            """
            OS Image reported by the node from /etc/os-release (e.g. Debian GNU/Linux 7 (wheezy)).
            """
            return self._set("os_image", value)

        def system_uuid(self, value: str, /) -> Self:
            """
            SystemUUID reported by the node. For unique machine identification MachineID is preferred. This field is specific to Red Hat hosts https://access.redhat.com/documentation/en-us/red_hat_subscription_management/1/html/rhsm/uuid
            """
            return self._set("system_uuid", value)

    class BuilderContext(BuilderContextBase["NodeSystemInfo.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = NodeSystemInfo.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for NodeSystemInfo."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["NodeSystemInfo", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use NodeSystemInfo.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    architecture: str
    """
    The Architecture reported by the node
    """
    boot_id: Annotated[str, Field(alias="bootID")]
    """
    Boot ID reported by the node.
    """
    container_runtime_version: Annotated[str, Field(alias="containerRuntimeVersion")]
    """
    ContainerRuntime Version reported by the node through runtime remote API (e.g. containerd://1.4.2).
    """
    kernel_version: Annotated[str, Field(alias="kernelVersion")]
    """
    Kernel Version reported by the node from 'uname -r' (e.g. 3.16.0-0.bpo.4-amd64).
    """
    kube_proxy_version: Annotated[str, Field(alias="kubeProxyVersion")]
    """
    Deprecated: KubeProxy Version reported by the node.
    """
    kubelet_version: Annotated[str, Field(alias="kubeletVersion")]
    """
    Kubelet Version reported by the node.
    """
    machine_id: Annotated[str, Field(alias="machineID")]
    """
    MachineID reported by the node. For unique machine identification in the cluster this field is preferred. Learn more from man(5) machine-id: http://man7.org/linux/man-pages/man5/machine-id.5.html
    """
    operating_system: Annotated[str, Field(alias="operatingSystem")]
    """
    The Operating System reported by the node
    """
    os_image: Annotated[str, Field(alias="osImage")]
    """
    OS Image reported by the node from /etc/os-release (e.g. Debian GNU/Linux 7 (wheezy)).
    """
    system_uuid: Annotated[str, Field(alias="systemUUID")]
    """
    SystemUUID reported by the node. For unique machine identification MachineID is preferred. This field is specific to Red Hat hosts https://access.redhat.com/documentation/en-us/red_hat_subscription_management/1/html/rhsm/uuid
    """


class ObjectFieldSelector(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["ObjectFieldSelector"]:
            return ObjectFieldSelector

        def build(self) -> "ObjectFieldSelector":
            return ObjectFieldSelector(**self._attrs)

        def api_version(self, value: Optional[str], /) -> Self:
            """
            Version of the schema the FieldPath is written in terms of, defaults to "v1".
            """
            return self._set("api_version", value)

        def field_path(self, value: str, /) -> Self:
            """
            Path of the field to select in the specified API version.
            """
            return self._set("field_path", value)

    class BuilderContext(BuilderContextBase["ObjectFieldSelector.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = ObjectFieldSelector.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for ObjectFieldSelector."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["ObjectFieldSelector", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use ObjectFieldSelector.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    api_version: Annotated[Optional[str], Field(alias="apiVersion")] = None
    """
    Version of the schema the FieldPath is written in terms of, defaults to "v1".
    """
    field_path: Annotated[str, Field(alias="fieldPath")]
    """
    Path of the field to select in the specified API version.
    """


class ObjectReference(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["ObjectReference"]:
            return ObjectReference

        def build(self) -> "ObjectReference":
            return ObjectReference(**self._attrs)

        def api_version(self, value: Optional[str], /) -> Self:
            """
            API version of the referent.
            """
            return self._set("api_version", value)

        def field_path(self, value: Optional[str], /) -> Self:
            """
            If referring to a piece of an object instead of an entire object, this string should contain a valid JSON/Go field access statement, such as desiredState.manifest.containers[2]. For example, if the object reference is to a container within a pod, this would take on a value like: "spec.containers{name}" (where "name" refers to the name of the container that triggered the event) or if no container name is specified "spec.containers[2]" (container with index 2 in this pod). This syntax is chosen only to have some well-defined way of referencing a part of an object.
            """
            return self._set("field_path", value)

        def kind(self, value: Optional[str], /) -> Self:
            """
            Kind of the referent. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
            """
            return self._set("kind", value)

        def name(self, value: Optional[str], /) -> Self:
            """
            Name of the referent. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names
            """
            return self._set("name", value)

        def namespace(self, value: Optional[str], /) -> Self:
            """
            Namespace of the referent. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/namespaces/
            """
            return self._set("namespace", value)

        def resource_version(self, value: Optional[str], /) -> Self:
            """
            Specific resourceVersion to which this reference is made, if any. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#concurrency-control-and-consistency
            """
            return self._set("resource_version", value)

        def uid(self, value: Optional[str], /) -> Self:
            """
            UID of the referent. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#uids
            """
            return self._set("uid", value)

    class BuilderContext(BuilderContextBase["ObjectReference.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = ObjectReference.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for ObjectReference."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["ObjectReference", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use ObjectReference.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    api_version: Annotated[Optional[str], Field(alias="apiVersion")] = None
    """
    API version of the referent.
    """
    field_path: Annotated[Optional[str], Field(alias="fieldPath")] = None
    """
    If referring to a piece of an object instead of an entire object, this string should contain a valid JSON/Go field access statement, such as desiredState.manifest.containers[2]. For example, if the object reference is to a container within a pod, this would take on a value like: "spec.containers{name}" (where "name" refers to the name of the container that triggered the event) or if no container name is specified "spec.containers[2]" (container with index 2 in this pod). This syntax is chosen only to have some well-defined way of referencing a part of an object.
    """
    kind: Optional[str] = None
    """
    Kind of the referent. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
    """
    name: Optional[str] = None
    """
    Name of the referent. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names
    """
    namespace: Optional[str] = None
    """
    Namespace of the referent. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/namespaces/
    """
    resource_version: Annotated[Optional[str], Field(alias="resourceVersion")] = None
    """
    Specific resourceVersion to which this reference is made, if any. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#concurrency-control-and-consistency
    """
    uid: Optional[str] = None
    """
    UID of the referent. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#uids
    """


class PersistentVolumeClaimVolumeSource(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["PersistentVolumeClaimVolumeSource"]:
            return PersistentVolumeClaimVolumeSource

        def build(self) -> "PersistentVolumeClaimVolumeSource":
            return PersistentVolumeClaimVolumeSource(**self._attrs)

        def claim_name(self, value: str, /) -> Self:
            """
            claimName is the name of a PersistentVolumeClaim in the same namespace as the pod using this volume. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#persistentvolumeclaims
            """
            return self._set("claim_name", value)

        def read_only(self, value: Optional[bool], /) -> Self:
            """
            readOnly Will force the ReadOnly setting in VolumeMounts. Default false.
            """
            return self._set("read_only", value)

    class BuilderContext(BuilderContextBase["PersistentVolumeClaimVolumeSource.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = PersistentVolumeClaimVolumeSource.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for PersistentVolumeClaimVolumeSource."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["PersistentVolumeClaimVolumeSource", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use PersistentVolumeClaimVolumeSource.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    claim_name: Annotated[str, Field(alias="claimName")]
    """
    claimName is the name of a PersistentVolumeClaim in the same namespace as the pod using this volume. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#persistentvolumeclaims
    """
    read_only: Annotated[Optional[bool], Field(alias="readOnly")] = None
    """
    readOnly Will force the ReadOnly setting in VolumeMounts. Default false.
    """


class PhotonPersistentDiskVolumeSource(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["PhotonPersistentDiskVolumeSource"]:
            return PhotonPersistentDiskVolumeSource

        def build(self) -> "PhotonPersistentDiskVolumeSource":
            return PhotonPersistentDiskVolumeSource(**self._attrs)

        def fs_type(self, value: Optional[str], /) -> Self:
            """
            fsType is the filesystem type to mount. Must be a filesystem type supported by the host operating system. Ex. "ext4", "xfs", "ntfs". Implicitly inferred to be "ext4" if unspecified.
            """
            return self._set("fs_type", value)

        def pd_id(self, value: str, /) -> Self:
            """
            pdID is the ID that identifies Photon Controller persistent disk
            """
            return self._set("pd_id", value)

    class BuilderContext(BuilderContextBase["PhotonPersistentDiskVolumeSource.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = PhotonPersistentDiskVolumeSource.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for PhotonPersistentDiskVolumeSource."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["PhotonPersistentDiskVolumeSource", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use PhotonPersistentDiskVolumeSource.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    fs_type: Annotated[Optional[str], Field(alias="fsType")] = None
    """
    fsType is the filesystem type to mount. Must be a filesystem type supported by the host operating system. Ex. "ext4", "xfs", "ntfs". Implicitly inferred to be "ext4" if unspecified.
    """
    pd_id: Annotated[str, Field(alias="pdID")]
    """
    pdID is the ID that identifies Photon Controller persistent disk
    """


class PodDNSConfigOption(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["PodDNSConfigOption"]:
            return PodDNSConfigOption

        def build(self) -> "PodDNSConfigOption":
            return PodDNSConfigOption(**self._attrs)

        def name(self, value: Optional[str], /) -> Self:
            """
            Required.
            """
            return self._set("name", value)

        def value(self, value: Optional[str], /) -> Self:
            return self._set("value", value)

    class BuilderContext(BuilderContextBase["PodDNSConfigOption.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = PodDNSConfigOption.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for PodDNSConfigOption."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["PodDNSConfigOption", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use PodDNSConfigOption.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    name: Optional[str] = None
    """
    Required.
    """
    value: Optional[str] = None


class PodIP(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["PodIP"]:
            return PodIP

        def build(self) -> "PodIP":
            return PodIP(**self._attrs)

        def ip(self, value: str, /) -> Self:
            """
            IP is the IP address assigned to the pod
            """
            return self._set("ip", value)

    class BuilderContext(BuilderContextBase["PodIP.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = PodIP.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for PodIP."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["PodIP", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use PodIP.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    ip: str
    """
    IP is the IP address assigned to the pod
    """


class PodOS(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["PodOS"]:
            return PodOS

        def build(self) -> "PodOS":
            return PodOS(**self._attrs)

        def name(self, value: str, /) -> Self:
            """
            Name is the name of the operating system. The currently supported values are linux and windows. Additional value may be defined in future and can be one of: https://github.com/opencontainers/runtime-spec/blob/master/config.md#platform-specific-configuration Clients should expect to handle additional values and treat unrecognized values in this field as os: null
            """
            return self._set("name", value)

    class BuilderContext(BuilderContextBase["PodOS.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = PodOS.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for PodOS."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["PodOS", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use PodOS.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    name: str
    """
    Name is the name of the operating system. The currently supported values are linux and windows. Additional value may be defined in future and can be one of: https://github.com/opencontainers/runtime-spec/blob/master/config.md#platform-specific-configuration Clients should expect to handle additional values and treat unrecognized values in this field as os: null
    """


class PodReadinessGate(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["PodReadinessGate"]:
            return PodReadinessGate

        def build(self) -> "PodReadinessGate":
            return PodReadinessGate(**self._attrs)

        def condition_type(self, value: str, /) -> Self:
            """
            ConditionType refers to a condition in the pod's condition list with matching type.
            """
            return self._set("condition_type", value)

    class BuilderContext(BuilderContextBase["PodReadinessGate.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = PodReadinessGate.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for PodReadinessGate."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["PodReadinessGate", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use PodReadinessGate.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    condition_type: Annotated[str, Field(alias="conditionType")]
    """
    ConditionType refers to a condition in the pod's condition list with matching type.
    """


class PodResourceClaim(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["PodResourceClaim"]:
            return PodResourceClaim

        def build(self) -> "PodResourceClaim":
            return PodResourceClaim(**self._attrs)

        def name(self, value: str, /) -> Self:
            """
            Name uniquely identifies this resource claim inside the pod. This must be a DNS_LABEL.
            """
            return self._set("name", value)

        def resource_claim_name(self, value: Optional[str], /) -> Self:
            """
            ResourceClaimName is the name of a ResourceClaim object in the same namespace as this pod.

            Exactly one of ResourceClaimName and ResourceClaimTemplateName must be set.
            """
            return self._set("resource_claim_name", value)

        def resource_claim_template_name(self, value: Optional[str], /) -> Self:
            """
            ResourceClaimTemplateName is the name of a ResourceClaimTemplate object in the same namespace as this pod.

            The template will be used to create a new ResourceClaim, which will be bound to this pod. When this pod is deleted, the ResourceClaim will also be deleted. The pod name and resource name, along with a generated component, will be used to form a unique name for the ResourceClaim, which will be recorded in pod.status.resourceClaimStatuses.

            This field is immutable and no changes will be made to the corresponding ResourceClaim by the control plane after creating the ResourceClaim.

            Exactly one of ResourceClaimName and ResourceClaimTemplateName must be set.
            """
            return self._set("resource_claim_template_name", value)

    class BuilderContext(BuilderContextBase["PodResourceClaim.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = PodResourceClaim.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for PodResourceClaim."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["PodResourceClaim", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use PodResourceClaim.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    name: str
    """
    Name uniquely identifies this resource claim inside the pod. This must be a DNS_LABEL.
    """
    resource_claim_name: Annotated[Optional[str], Field(alias="resourceClaimName")] = None
    """
    ResourceClaimName is the name of a ResourceClaim object in the same namespace as this pod.

    Exactly one of ResourceClaimName and ResourceClaimTemplateName must be set.
    """
    resource_claim_template_name: Annotated[
        Optional[str], Field(alias="resourceClaimTemplateName")
    ] = None
    """
    ResourceClaimTemplateName is the name of a ResourceClaimTemplate object in the same namespace as this pod.

    The template will be used to create a new ResourceClaim, which will be bound to this pod. When this pod is deleted, the ResourceClaim will also be deleted. The pod name and resource name, along with a generated component, will be used to form a unique name for the ResourceClaim, which will be recorded in pod.status.resourceClaimStatuses.

    This field is immutable and no changes will be made to the corresponding ResourceClaim by the control plane after creating the ResourceClaim.

    Exactly one of ResourceClaimName and ResourceClaimTemplateName must be set.
    """


class PodResourceClaimStatus(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["PodResourceClaimStatus"]:
            return PodResourceClaimStatus

        def build(self) -> "PodResourceClaimStatus":
            return PodResourceClaimStatus(**self._attrs)

        def name(self, value: str, /) -> Self:
            """
            Name uniquely identifies this resource claim inside the pod. This must match the name of an entry in pod.spec.resourceClaims, which implies that the string must be a DNS_LABEL.
            """
            return self._set("name", value)

        def resource_claim_name(self, value: Optional[str], /) -> Self:
            """
            ResourceClaimName is the name of the ResourceClaim that was generated for the Pod in the namespace of the Pod. If this is unset, then generating a ResourceClaim was not necessary. The pod.spec.resourceClaims entry can be ignored in this case.
            """
            return self._set("resource_claim_name", value)

    class BuilderContext(BuilderContextBase["PodResourceClaimStatus.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = PodResourceClaimStatus.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for PodResourceClaimStatus."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["PodResourceClaimStatus", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use PodResourceClaimStatus.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    name: str
    """
    Name uniquely identifies this resource claim inside the pod. This must match the name of an entry in pod.spec.resourceClaims, which implies that the string must be a DNS_LABEL.
    """
    resource_claim_name: Annotated[Optional[str], Field(alias="resourceClaimName")] = None
    """
    ResourceClaimName is the name of the ResourceClaim that was generated for the Pod in the namespace of the Pod. If this is unset, then generating a ResourceClaim was not necessary. The pod.spec.resourceClaims entry can be ignored in this case.
    """


class PodSchedulingGate(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["PodSchedulingGate"]:
            return PodSchedulingGate

        def build(self) -> "PodSchedulingGate":
            return PodSchedulingGate(**self._attrs)

        def name(self, value: str, /) -> Self:
            """
            Name of the scheduling gate. Each scheduling gate must have a unique name field.
            """
            return self._set("name", value)

    class BuilderContext(BuilderContextBase["PodSchedulingGate.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = PodSchedulingGate.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for PodSchedulingGate."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["PodSchedulingGate", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use PodSchedulingGate.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    name: str
    """
    Name of the scheduling gate. Each scheduling gate must have a unique name field.
    """


class PortStatus(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["PortStatus"]:
            return PortStatus

        def build(self) -> "PortStatus":
            return PortStatus(**self._attrs)

        def error(self, value: Optional[str], /) -> Self:
            """
            Error is to record the problem with the service port The format of the error shall comply with the following rules: - built-in error values shall be specified in this file and those shall use
              CamelCase names
            - cloud provider specific error values must have names that comply with the
              format foo.example.com/CamelCase.
            """
            return self._set("error", value)

        def port(self, value: int, /) -> Self:
            """
            Port is the port number of the service port of which status is recorded here
            """
            return self._set("port", value)

        def protocol(self, value: str, /) -> Self:
            """
            Protocol is the protocol of the service port of which status is recorded here The supported values are: "TCP", "UDP", "SCTP"
            """
            return self._set("protocol", value)

    class BuilderContext(BuilderContextBase["PortStatus.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = PortStatus.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for PortStatus."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["PortStatus", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use PortStatus.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    error: Optional[str] = None
    """
    Error is to record the problem with the service port The format of the error shall comply with the following rules: - built-in error values shall be specified in this file and those shall use
      CamelCase names
    - cloud provider specific error values must have names that comply with the
      format foo.example.com/CamelCase.
    """
    port: int
    """
    Port is the port number of the service port of which status is recorded here
    """
    protocol: str
    """
    Protocol is the protocol of the service port of which status is recorded here The supported values are: "TCP", "UDP", "SCTP"
    """


class PortworxVolumeSource(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["PortworxVolumeSource"]:
            return PortworxVolumeSource

        def build(self) -> "PortworxVolumeSource":
            return PortworxVolumeSource(**self._attrs)

        def fs_type(self, value: Optional[str], /) -> Self:
            """
            fSType represents the filesystem type to mount Must be a filesystem type supported by the host operating system. Ex. "ext4", "xfs". Implicitly inferred to be "ext4" if unspecified.
            """
            return self._set("fs_type", value)

        def read_only(self, value: Optional[bool], /) -> Self:
            """
            readOnly defaults to false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts.
            """
            return self._set("read_only", value)

        def volume_id(self, value: str, /) -> Self:
            """
            volumeID uniquely identifies a Portworx volume
            """
            return self._set("volume_id", value)

    class BuilderContext(BuilderContextBase["PortworxVolumeSource.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = PortworxVolumeSource.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for PortworxVolumeSource."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["PortworxVolumeSource", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use PortworxVolumeSource.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    fs_type: Annotated[Optional[str], Field(alias="fsType")] = None
    """
    fSType represents the filesystem type to mount Must be a filesystem type supported by the host operating system. Ex. "ext4", "xfs". Implicitly inferred to be "ext4" if unspecified.
    """
    read_only: Annotated[Optional[bool], Field(alias="readOnly")] = None
    """
    readOnly defaults to false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts.
    """
    volume_id: Annotated[str, Field(alias="volumeID")]
    """
    volumeID uniquely identifies a Portworx volume
    """


class PreferredSchedulingTerm(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["PreferredSchedulingTerm"]:
            return PreferredSchedulingTerm

        def build(self) -> "PreferredSchedulingTerm":
            return PreferredSchedulingTerm(**self._attrs)

        @overload
        def preference(
            self, value_or_callback: NodeSelectorTerm, /
        ) -> "PreferredSchedulingTerm.Builder": ...

        @overload
        def preference(
            self,
            value_or_callback: Callable[
                [NodeSelectorTerm.Builder], NodeSelectorTerm.Builder | NodeSelectorTerm
            ],
            /,
        ) -> "PreferredSchedulingTerm.Builder": ...

        @overload
        def preference(
            self, value_or_callback: Never = ...
        ) -> "NodeSelectorTerm.BuilderContext": ...

        def preference(self, value_or_callback=None, /):
            """
            A node selector term, associated with the corresponding weight.
            """
            if self._in_context and value_or_callback is None:
                context = NodeSelectorTerm.BuilderContext()
                context._parent_builder = self
                context._field_name = "preference"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(NodeSelectorTerm.builder())
                if isinstance(output, NodeSelectorTerm.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("preference", value)

        def weight(self, value: int, /) -> Self:
            """
            Weight associated with matching the corresponding nodeSelectorTerm, in the range 1-100.
            """
            return self._set("weight", value)

    class BuilderContext(BuilderContextBase["PreferredSchedulingTerm.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = PreferredSchedulingTerm.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for PreferredSchedulingTerm."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["PreferredSchedulingTerm", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use PreferredSchedulingTerm.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    preference: NodeSelectorTerm
    """
    A node selector term, associated with the corresponding weight.
    """
    weight: int
    """
    Weight associated with matching the corresponding nodeSelectorTerm, in the range 1-100.
    """


class QuobyteVolumeSource(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["QuobyteVolumeSource"]:
            return QuobyteVolumeSource

        def build(self) -> "QuobyteVolumeSource":
            return QuobyteVolumeSource(**self._attrs)

        def group(self, value: Optional[str], /) -> Self:
            """
            group to map volume access to Default is no group
            """
            return self._set("group", value)

        def read_only(self, value: Optional[bool], /) -> Self:
            """
            readOnly here will force the Quobyte volume to be mounted with read-only permissions. Defaults to false.
            """
            return self._set("read_only", value)

        def registry(self, value: str, /) -> Self:
            """
            registry represents a single or multiple Quobyte Registry services specified as a string as host:port pair (multiple entries are separated with commas) which acts as the central registry for volumes
            """
            return self._set("registry", value)

        def tenant(self, value: Optional[str], /) -> Self:
            """
            tenant owning the given Quobyte volume in the Backend Used with dynamically provisioned Quobyte volumes, value is set by the plugin
            """
            return self._set("tenant", value)

        def user(self, value: Optional[str], /) -> Self:
            """
            user to map volume access to Defaults to serivceaccount user
            """
            return self._set("user", value)

        def volume(self, value: str, /) -> Self:
            """
            volume is a string that references an already created Quobyte volume by name.
            """
            return self._set("volume", value)

    class BuilderContext(BuilderContextBase["QuobyteVolumeSource.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = QuobyteVolumeSource.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for QuobyteVolumeSource."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["QuobyteVolumeSource", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use QuobyteVolumeSource.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    group: Optional[str] = None
    """
    group to map volume access to Default is no group
    """
    read_only: Annotated[Optional[bool], Field(alias="readOnly")] = None
    """
    readOnly here will force the Quobyte volume to be mounted with read-only permissions. Defaults to false.
    """
    registry: str
    """
    registry represents a single or multiple Quobyte Registry services specified as a string as host:port pair (multiple entries are separated with commas) which acts as the central registry for volumes
    """
    tenant: Optional[str] = None
    """
    tenant owning the given Quobyte volume in the Backend Used with dynamically provisioned Quobyte volumes, value is set by the plugin
    """
    user: Optional[str] = None
    """
    user to map volume access to Defaults to serivceaccount user
    """
    volume: str
    """
    volume is a string that references an already created Quobyte volume by name.
    """


class RBDVolumeSource(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["RBDVolumeSource"]:
            return RBDVolumeSource

        def build(self) -> "RBDVolumeSource":
            return RBDVolumeSource(**self._attrs)

        def fs_type(self, value: Optional[str], /) -> Self:
            """
            fsType is the filesystem type of the volume that you want to mount. Tip: Ensure that the filesystem type is supported by the host operating system. Examples: "ext4", "xfs", "ntfs". Implicitly inferred to be "ext4" if unspecified. More info: https://kubernetes.io/docs/concepts/storage/volumes#rbd
            """
            return self._set("fs_type", value)

        def image(self, value: str, /) -> Self:
            """
            image is the rados image name. More info: https://examples.k8s.io/volumes/rbd/README.md#how-to-use-it
            """
            return self._set("image", value)

        def keyring(self, value: Optional[str], /) -> Self:
            """
            keyring is the path to key ring for RBDUser. Default is /etc/ceph/keyring. More info: https://examples.k8s.io/volumes/rbd/README.md#how-to-use-it
            """
            return self._set("keyring", value)

        def monitors(self, value: List[str], /) -> Self:
            """
            monitors is a collection of Ceph monitors. More info: https://examples.k8s.io/volumes/rbd/README.md#how-to-use-it
            """
            return self._set("monitors", value)

        def pool(self, value: Optional[str], /) -> Self:
            """
            pool is the rados pool name. Default is rbd. More info: https://examples.k8s.io/volumes/rbd/README.md#how-to-use-it
            """
            return self._set("pool", value)

        def read_only(self, value: Optional[bool], /) -> Self:
            """
            readOnly here will force the ReadOnly setting in VolumeMounts. Defaults to false. More info: https://examples.k8s.io/volumes/rbd/README.md#how-to-use-it
            """
            return self._set("read_only", value)

        @overload
        def secret_ref(
            self, value_or_callback: Optional[LocalObjectReference], /
        ) -> "RBDVolumeSource.Builder": ...

        @overload
        def secret_ref(
            self,
            value_or_callback: Callable[
                [LocalObjectReference.Builder],
                LocalObjectReference.Builder | LocalObjectReference,
            ],
            /,
        ) -> "RBDVolumeSource.Builder": ...

        @overload
        def secret_ref(
            self, value_or_callback: Never = ...
        ) -> "LocalObjectReference.BuilderContext": ...

        def secret_ref(self, value_or_callback=None, /):
            """
            secretRef is name of the authentication secret for RBDUser. If provided overrides keyring. Default is nil. More info: https://examples.k8s.io/volumes/rbd/README.md#how-to-use-it
            """
            if self._in_context and value_or_callback is None:
                context = LocalObjectReference.BuilderContext()
                context._parent_builder = self
                context._field_name = "secret_ref"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(LocalObjectReference.builder())
                if isinstance(output, LocalObjectReference.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("secret_ref", value)

        def user(self, value: Optional[str], /) -> Self:
            """
            user is the rados user name. Default is admin. More info: https://examples.k8s.io/volumes/rbd/README.md#how-to-use-it
            """
            return self._set("user", value)

    class BuilderContext(BuilderContextBase["RBDVolumeSource.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = RBDVolumeSource.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for RBDVolumeSource."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["RBDVolumeSource", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use RBDVolumeSource.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    fs_type: Annotated[Optional[str], Field(alias="fsType")] = None
    """
    fsType is the filesystem type of the volume that you want to mount. Tip: Ensure that the filesystem type is supported by the host operating system. Examples: "ext4", "xfs", "ntfs". Implicitly inferred to be "ext4" if unspecified. More info: https://kubernetes.io/docs/concepts/storage/volumes#rbd
    """
    image: str
    """
    image is the rados image name. More info: https://examples.k8s.io/volumes/rbd/README.md#how-to-use-it
    """
    keyring: Optional[str] = None
    """
    keyring is the path to key ring for RBDUser. Default is /etc/ceph/keyring. More info: https://examples.k8s.io/volumes/rbd/README.md#how-to-use-it
    """
    monitors: List[str]
    """
    monitors is a collection of Ceph monitors. More info: https://examples.k8s.io/volumes/rbd/README.md#how-to-use-it
    """
    pool: Optional[str] = None
    """
    pool is the rados pool name. Default is rbd. More info: https://examples.k8s.io/volumes/rbd/README.md#how-to-use-it
    """
    read_only: Annotated[Optional[bool], Field(alias="readOnly")] = None
    """
    readOnly here will force the ReadOnly setting in VolumeMounts. Defaults to false. More info: https://examples.k8s.io/volumes/rbd/README.md#how-to-use-it
    """
    secret_ref: Annotated[Optional[LocalObjectReference], Field(alias="secretRef")] = None
    """
    secretRef is name of the authentication secret for RBDUser. If provided overrides keyring. Default is nil. More info: https://examples.k8s.io/volumes/rbd/README.md#how-to-use-it
    """
    user: Optional[str] = None
    """
    user is the rados user name. Default is admin. More info: https://examples.k8s.io/volumes/rbd/README.md#how-to-use-it
    """


class ResourceClaim(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["ResourceClaim"]:
            return ResourceClaim

        def build(self) -> "ResourceClaim":
            return ResourceClaim(**self._attrs)

        def name(self, value: str, /) -> Self:
            """
            Name must match the name of one entry in pod.spec.resourceClaims of the Pod where this field is used. It makes that resource available inside a container.
            """
            return self._set("name", value)

        def request(self, value: Optional[str], /) -> Self:
            """
            Request is the name chosen for a request in the referenced claim. If empty, everything from the claim is made available, otherwise only the result of this request.
            """
            return self._set("request", value)

    class BuilderContext(BuilderContextBase["ResourceClaim.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = ResourceClaim.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for ResourceClaim."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["ResourceClaim", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use ResourceClaim.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    name: str
    """
    Name must match the name of one entry in pod.spec.resourceClaims of the Pod where this field is used. It makes that resource available inside a container.
    """
    request: Optional[str] = None
    """
    Request is the name chosen for a request in the referenced claim. If empty, everything from the claim is made available, otherwise only the result of this request.
    """


class ResourceHealth(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["ResourceHealth"]:
            return ResourceHealth

        def build(self) -> "ResourceHealth":
            return ResourceHealth(**self._attrs)

        def health(self, value: Optional[str], /) -> Self:
            """
            Health of the resource. can be one of:
             - Healthy: operates as normal
             - Unhealthy: reported unhealthy. We consider this a temporary health issue
                          since we do not have a mechanism today to distinguish
                          temporary and permanent issues.
             - Unknown: The status cannot be determined.
                        For example, Device Plugin got unregistered and hasn't been re-registered since.

            In future we may want to introduce the PermanentlyUnhealthy Status.
            """
            return self._set("health", value)

        def resource_id(self, value: str, /) -> Self:
            """
            ResourceID is the unique identifier of the resource. See the ResourceID type for more information.
            """
            return self._set("resource_id", value)

    class BuilderContext(BuilderContextBase["ResourceHealth.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = ResourceHealth.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for ResourceHealth."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["ResourceHealth", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use ResourceHealth.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    health: Optional[str] = None
    """
    Health of the resource. can be one of:
     - Healthy: operates as normal
     - Unhealthy: reported unhealthy. We consider this a temporary health issue
                  since we do not have a mechanism today to distinguish
                  temporary and permanent issues.
     - Unknown: The status cannot be determined.
                For example, Device Plugin got unregistered and hasn't been re-registered since.

    In future we may want to introduce the PermanentlyUnhealthy Status.
    """
    resource_id: Annotated[str, Field(alias="resourceID")]
    """
    ResourceID is the unique identifier of the resource. See the ResourceID type for more information.
    """


class ResourceStatus(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["ResourceStatus"]:
            return ResourceStatus

        def build(self) -> "ResourceStatus":
            return ResourceStatus(**self._attrs)

        def name(self, value: str, /) -> Self:
            """
            Name of the resource. Must be unique within the pod and match one of the resources from the pod spec.
            """
            return self._set("name", value)

        @overload
        def resources(
            self, value_or_callback: List[ResourceHealth], /
        ) -> "ResourceStatus.Builder": ...

        @overload
        def resources(
            self,
            value_or_callback: Callable[
                [GenericListBuilder[ResourceHealth, ResourceHealth.Builder]],
                GenericListBuilder[ResourceHealth, ResourceHealth.Builder] | List[ResourceHealth],
            ],
            /,
        ) -> "ResourceStatus.Builder": ...

        @overload
        def resources(
            self, value_or_callback: Never = ...
        ) -> ListBuilderContext[ResourceHealth.Builder]: ...

        def resources(self, value_or_callback=None, /):
            """
            List of unique Resources health. Each element in the list contains an unique resource ID and resource health. At a minimum, ResourceID must uniquely identify the Resource allocated to the Pod on the Node for the lifetime of a Pod. See ResourceID type for it's definition.
            """
            if self._in_context and value_or_callback is None:
                context = ListBuilderContext[ResourceHealth.Builder]()
                context._parent_builder = self
                context._field_name = "resources"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(ResourceHealth.list_builder())
                if isinstance(output, GenericListBuilder):
                    value = output.build()
                else:
                    value = output
            return self._set("resources", value)

    class BuilderContext(BuilderContextBase["ResourceStatus.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = ResourceStatus.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for ResourceStatus."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["ResourceStatus", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use ResourceStatus.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    name: str
    """
    Name of the resource. Must be unique within the pod and match one of the resources from the pod spec.
    """
    resources: Optional[List[ResourceHealth]] = None
    """
    List of unique Resources health. Each element in the list contains an unique resource ID and resource health. At a minimum, ResourceID must uniquely identify the Resource allocated to the Pod on the Node for the lifetime of a Pod. See ResourceID type for it's definition.
    """


class SELinuxOptions(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["SELinuxOptions"]:
            return SELinuxOptions

        def build(self) -> "SELinuxOptions":
            return SELinuxOptions(**self._attrs)

        def level(self, value: Optional[str], /) -> Self:
            """
            Level is SELinux level label that applies to the container.
            """
            return self._set("level", value)

        def role(self, value: Optional[str], /) -> Self:
            """
            Role is a SELinux role label that applies to the container.
            """
            return self._set("role", value)

        def type(self, value: Optional[str], /) -> Self:
            """
            Type is a SELinux type label that applies to the container.
            """
            return self._set("type", value)

        def user(self, value: Optional[str], /) -> Self:
            """
            User is a SELinux user label that applies to the container.
            """
            return self._set("user", value)

    class BuilderContext(BuilderContextBase["SELinuxOptions.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = SELinuxOptions.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for SELinuxOptions."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["SELinuxOptions", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use SELinuxOptions.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    level: Optional[str] = None
    """
    Level is SELinux level label that applies to the container.
    """
    role: Optional[str] = None
    """
    Role is a SELinux role label that applies to the container.
    """
    type: Optional[str] = None
    """
    Type is a SELinux type label that applies to the container.
    """
    user: Optional[str] = None
    """
    User is a SELinux user label that applies to the container.
    """


class ScaleIOVolumeSource(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["ScaleIOVolumeSource"]:
            return ScaleIOVolumeSource

        def build(self) -> "ScaleIOVolumeSource":
            return ScaleIOVolumeSource(**self._attrs)

        def fs_type(self, value: Optional[str], /) -> Self:
            """
            fsType is the filesystem type to mount. Must be a filesystem type supported by the host operating system. Ex. "ext4", "xfs", "ntfs". Default is "xfs".
            """
            return self._set("fs_type", value)

        def gateway(self, value: str, /) -> Self:
            """
            gateway is the host address of the ScaleIO API Gateway.
            """
            return self._set("gateway", value)

        def protection_domain(self, value: Optional[str], /) -> Self:
            """
            protectionDomain is the name of the ScaleIO Protection Domain for the configured storage.
            """
            return self._set("protection_domain", value)

        def read_only(self, value: Optional[bool], /) -> Self:
            """
            readOnly Defaults to false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts.
            """
            return self._set("read_only", value)

        @overload
        def secret_ref(
            self, value_or_callback: LocalObjectReference, /
        ) -> "ScaleIOVolumeSource.Builder": ...

        @overload
        def secret_ref(
            self,
            value_or_callback: Callable[
                [LocalObjectReference.Builder],
                LocalObjectReference.Builder | LocalObjectReference,
            ],
            /,
        ) -> "ScaleIOVolumeSource.Builder": ...

        @overload
        def secret_ref(
            self, value_or_callback: Never = ...
        ) -> "LocalObjectReference.BuilderContext": ...

        def secret_ref(self, value_or_callback=None, /):
            """
            secretRef references to the secret for ScaleIO user and other sensitive information. If this is not provided, Login operation will fail.
            """
            if self._in_context and value_or_callback is None:
                context = LocalObjectReference.BuilderContext()
                context._parent_builder = self
                context._field_name = "secret_ref"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(LocalObjectReference.builder())
                if isinstance(output, LocalObjectReference.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("secret_ref", value)

        def ssl_enabled(self, value: Optional[bool], /) -> Self:
            """
            sslEnabled Flag enable/disable SSL communication with Gateway, default false
            """
            return self._set("ssl_enabled", value)

        def storage_mode(self, value: Optional[str], /) -> Self:
            """
            storageMode indicates whether the storage for a volume should be ThickProvisioned or ThinProvisioned. Default is ThinProvisioned.
            """
            return self._set("storage_mode", value)

        def storage_pool(self, value: Optional[str], /) -> Self:
            """
            storagePool is the ScaleIO Storage Pool associated with the protection domain.
            """
            return self._set("storage_pool", value)

        def system(self, value: str, /) -> Self:
            """
            system is the name of the storage system as configured in ScaleIO.
            """
            return self._set("system", value)

        def volume_name(self, value: Optional[str], /) -> Self:
            """
            volumeName is the name of a volume already created in the ScaleIO system that is associated with this volume source.
            """
            return self._set("volume_name", value)

    class BuilderContext(BuilderContextBase["ScaleIOVolumeSource.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = ScaleIOVolumeSource.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for ScaleIOVolumeSource."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["ScaleIOVolumeSource", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use ScaleIOVolumeSource.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    fs_type: Annotated[Optional[str], Field(alias="fsType")] = None
    """
    fsType is the filesystem type to mount. Must be a filesystem type supported by the host operating system. Ex. "ext4", "xfs", "ntfs". Default is "xfs".
    """
    gateway: str
    """
    gateway is the host address of the ScaleIO API Gateway.
    """
    protection_domain: Annotated[Optional[str], Field(alias="protectionDomain")] = None
    """
    protectionDomain is the name of the ScaleIO Protection Domain for the configured storage.
    """
    read_only: Annotated[Optional[bool], Field(alias="readOnly")] = None
    """
    readOnly Defaults to false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts.
    """
    secret_ref: Annotated[LocalObjectReference, Field(alias="secretRef")]
    """
    secretRef references to the secret for ScaleIO user and other sensitive information. If this is not provided, Login operation will fail.
    """
    ssl_enabled: Annotated[Optional[bool], Field(alias="sslEnabled")] = None
    """
    sslEnabled Flag enable/disable SSL communication with Gateway, default false
    """
    storage_mode: Annotated[Optional[str], Field(alias="storageMode")] = None
    """
    storageMode indicates whether the storage for a volume should be ThickProvisioned or ThinProvisioned. Default is ThinProvisioned.
    """
    storage_pool: Annotated[Optional[str], Field(alias="storagePool")] = None
    """
    storagePool is the ScaleIO Storage Pool associated with the protection domain.
    """
    system: str
    """
    system is the name of the storage system as configured in ScaleIO.
    """
    volume_name: Annotated[Optional[str], Field(alias="volumeName")] = None
    """
    volumeName is the name of a volume already created in the ScaleIO system that is associated with this volume source.
    """


class ScopedResourceSelectorRequirement(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["ScopedResourceSelectorRequirement"]:
            return ScopedResourceSelectorRequirement

        def build(self) -> "ScopedResourceSelectorRequirement":
            return ScopedResourceSelectorRequirement(**self._attrs)

        def operator(self, value: str, /) -> Self:
            """
            Represents a scope's relationship to a set of values. Valid operators are In, NotIn, Exists, DoesNotExist.
            """
            return self._set("operator", value)

        def scope_name(self, value: str, /) -> Self:
            """
            The name of the scope that the selector applies to.
            """
            return self._set("scope_name", value)

        def values(self, value: Optional[List[str]], /) -> Self:
            """
            An array of string values. If the operator is In or NotIn, the values array must be non-empty. If the operator is Exists or DoesNotExist, the values array must be empty. This array is replaced during a strategic merge patch.
            """
            return self._set("values", value)

    class BuilderContext(BuilderContextBase["ScopedResourceSelectorRequirement.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = ScopedResourceSelectorRequirement.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for ScopedResourceSelectorRequirement."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["ScopedResourceSelectorRequirement", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use ScopedResourceSelectorRequirement.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    operator: str
    """
    Represents a scope's relationship to a set of values. Valid operators are In, NotIn, Exists, DoesNotExist.
    """
    scope_name: Annotated[str, Field(alias="scopeName")]
    """
    The name of the scope that the selector applies to.
    """
    values: Optional[List[str]] = None
    """
    An array of string values. If the operator is In or NotIn, the values array must be non-empty. If the operator is Exists or DoesNotExist, the values array must be empty. This array is replaced during a strategic merge patch.
    """


class SeccompProfile(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["SeccompProfile"]:
            return SeccompProfile

        def build(self) -> "SeccompProfile":
            return SeccompProfile(**self._attrs)

        def localhost_profile(self, value: Optional[str], /) -> Self:
            """
            localhostProfile indicates a profile defined in a file on the node should be used. The profile must be preconfigured on the node to work. Must be a descending path, relative to the kubelet's configured seccomp profile location. Must be set if type is "Localhost". Must NOT be set for any other type.
            """
            return self._set("localhost_profile", value)

        def type(self, value: str, /) -> Self:
            """
            type indicates which kind of seccomp profile will be applied. Valid options are:

            Localhost - a profile defined in a file on the node should be used. RuntimeDefault - the container runtime default profile should be used. Unconfined - no profile should be applied.
            """
            return self._set("type", value)

    class BuilderContext(BuilderContextBase["SeccompProfile.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = SeccompProfile.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for SeccompProfile."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["SeccompProfile", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use SeccompProfile.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    localhost_profile: Annotated[Optional[str], Field(alias="localhostProfile")] = None
    """
    localhostProfile indicates a profile defined in a file on the node should be used. The profile must be preconfigured on the node to work. Must be a descending path, relative to the kubelet's configured seccomp profile location. Must be set if type is "Localhost". Must NOT be set for any other type.
    """
    type: str
    """
    type indicates which kind of seccomp profile will be applied. Valid options are:

    Localhost - a profile defined in a file on the node should be used. RuntimeDefault - the container runtime default profile should be used. Unconfined - no profile should be applied.
    """


class SecretEnvSource(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["SecretEnvSource"]:
            return SecretEnvSource

        def build(self) -> "SecretEnvSource":
            return SecretEnvSource(**self._attrs)

        def name(self, value: Optional[str], /) -> Self:
            """
            Name of the referent. This field is effectively required, but due to backwards compatibility is allowed to be empty. Instances of this type with an empty value here are almost certainly wrong. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names
            """
            return self._set("name", value)

        def optional(self, value: Optional[bool], /) -> Self:
            """
            Specify whether the Secret must be defined
            """
            return self._set("optional", value)

    class BuilderContext(BuilderContextBase["SecretEnvSource.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = SecretEnvSource.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for SecretEnvSource."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["SecretEnvSource", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use SecretEnvSource.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    name: Optional[str] = None
    """
    Name of the referent. This field is effectively required, but due to backwards compatibility is allowed to be empty. Instances of this type with an empty value here are almost certainly wrong. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names
    """
    optional: Optional[bool] = None
    """
    Specify whether the Secret must be defined
    """


class SecretKeySelector(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["SecretKeySelector"]:
            return SecretKeySelector

        def build(self) -> "SecretKeySelector":
            return SecretKeySelector(**self._attrs)

        def key(self, value: str, /) -> Self:
            """
            The key of the secret to select from.  Must be a valid secret key.
            """
            return self._set("key", value)

        def name(self, value: Optional[str], /) -> Self:
            """
            Name of the referent. This field is effectively required, but due to backwards compatibility is allowed to be empty. Instances of this type with an empty value here are almost certainly wrong. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names
            """
            return self._set("name", value)

        def optional(self, value: Optional[bool], /) -> Self:
            """
            Specify whether the Secret or its key must be defined
            """
            return self._set("optional", value)

    class BuilderContext(BuilderContextBase["SecretKeySelector.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = SecretKeySelector.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for SecretKeySelector."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["SecretKeySelector", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use SecretKeySelector.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    key: str
    """
    The key of the secret to select from.  Must be a valid secret key.
    """
    name: Optional[str] = None
    """
    Name of the referent. This field is effectively required, but due to backwards compatibility is allowed to be empty. Instances of this type with an empty value here are almost certainly wrong. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names
    """
    optional: Optional[bool] = None
    """
    Specify whether the Secret or its key must be defined
    """


class SecretProjection(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["SecretProjection"]:
            return SecretProjection

        def build(self) -> "SecretProjection":
            return SecretProjection(**self._attrs)

        @overload
        def items(self, value_or_callback: List[KeyToPath], /) -> "SecretProjection.Builder": ...

        @overload
        def items(
            self,
            value_or_callback: Callable[
                [GenericListBuilder[KeyToPath, KeyToPath.Builder]],
                GenericListBuilder[KeyToPath, KeyToPath.Builder] | List[KeyToPath],
            ],
            /,
        ) -> "SecretProjection.Builder": ...

        @overload
        def items(
            self, value_or_callback: Never = ...
        ) -> ListBuilderContext[KeyToPath.Builder]: ...

        def items(self, value_or_callback=None, /):
            """
            items if unspecified, each key-value pair in the Data field of the referenced Secret will be projected into the volume as a file whose name is the key and content is the value. If specified, the listed keys will be projected into the specified paths, and unlisted keys will not be present. If a key is specified which is not present in the Secret, the volume setup will error unless it is marked optional. Paths must be relative and may not contain the '..' path or start with '..'.
            """
            if self._in_context and value_or_callback is None:
                context = ListBuilderContext[KeyToPath.Builder]()
                context._parent_builder = self
                context._field_name = "items"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(KeyToPath.list_builder())
                if isinstance(output, GenericListBuilder):
                    value = output.build()
                else:
                    value = output
            return self._set("items", value)

        def name(self, value: Optional[str], /) -> Self:
            """
            Name of the referent. This field is effectively required, but due to backwards compatibility is allowed to be empty. Instances of this type with an empty value here are almost certainly wrong. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names
            """
            return self._set("name", value)

        def optional(self, value: Optional[bool], /) -> Self:
            """
            optional field specify whether the Secret or its key must be defined
            """
            return self._set("optional", value)

    class BuilderContext(BuilderContextBase["SecretProjection.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = SecretProjection.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for SecretProjection."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["SecretProjection", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use SecretProjection.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    items: Optional[List[KeyToPath]] = None
    """
    items if unspecified, each key-value pair in the Data field of the referenced Secret will be projected into the volume as a file whose name is the key and content is the value. If specified, the listed keys will be projected into the specified paths, and unlisted keys will not be present. If a key is specified which is not present in the Secret, the volume setup will error unless it is marked optional. Paths must be relative and may not contain the '..' path or start with '..'.
    """
    name: Optional[str] = None
    """
    Name of the referent. This field is effectively required, but due to backwards compatibility is allowed to be empty. Instances of this type with an empty value here are almost certainly wrong. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names
    """
    optional: Optional[bool] = None
    """
    optional field specify whether the Secret or its key must be defined
    """


class SecretReference(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["SecretReference"]:
            return SecretReference

        def build(self) -> "SecretReference":
            return SecretReference(**self._attrs)

        def name(self, value: Optional[str], /) -> Self:
            """
            name is unique within a namespace to reference a secret resource.
            """
            return self._set("name", value)

        def namespace(self, value: Optional[str], /) -> Self:
            """
            namespace defines the space within which the secret name must be unique.
            """
            return self._set("namespace", value)

    class BuilderContext(BuilderContextBase["SecretReference.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = SecretReference.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for SecretReference."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["SecretReference", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use SecretReference.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    name: Optional[str] = None
    """
    name is unique within a namespace to reference a secret resource.
    """
    namespace: Optional[str] = None
    """
    namespace defines the space within which the secret name must be unique.
    """


class SecretVolumeSource(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["SecretVolumeSource"]:
            return SecretVolumeSource

        def build(self) -> "SecretVolumeSource":
            return SecretVolumeSource(**self._attrs)

        def default_mode(self, value: Optional[int], /) -> Self:
            """
            defaultMode is Optional: mode bits used to set permissions on created files by default. Must be an octal value between 0000 and 0777 or a decimal value between 0 and 511. YAML accepts both octal and decimal values, JSON requires decimal values for mode bits. Defaults to 0644. Directories within the path are not affected by this setting. This might be in conflict with other options that affect the file mode, like fsGroup, and the result can be other mode bits set.
            """
            return self._set("default_mode", value)

        @overload
        def items(self, value_or_callback: List[KeyToPath], /) -> "SecretVolumeSource.Builder": ...

        @overload
        def items(
            self,
            value_or_callback: Callable[
                [GenericListBuilder[KeyToPath, KeyToPath.Builder]],
                GenericListBuilder[KeyToPath, KeyToPath.Builder] | List[KeyToPath],
            ],
            /,
        ) -> "SecretVolumeSource.Builder": ...

        @overload
        def items(
            self, value_or_callback: Never = ...
        ) -> ListBuilderContext[KeyToPath.Builder]: ...

        def items(self, value_or_callback=None, /):
            """
            items If unspecified, each key-value pair in the Data field of the referenced Secret will be projected into the volume as a file whose name is the key and content is the value. If specified, the listed keys will be projected into the specified paths, and unlisted keys will not be present. If a key is specified which is not present in the Secret, the volume setup will error unless it is marked optional. Paths must be relative and may not contain the '..' path or start with '..'.
            """
            if self._in_context and value_or_callback is None:
                context = ListBuilderContext[KeyToPath.Builder]()
                context._parent_builder = self
                context._field_name = "items"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(KeyToPath.list_builder())
                if isinstance(output, GenericListBuilder):
                    value = output.build()
                else:
                    value = output
            return self._set("items", value)

        def optional(self, value: Optional[bool], /) -> Self:
            """
            optional field specify whether the Secret or its keys must be defined
            """
            return self._set("optional", value)

        def secret_name(self, value: Optional[str], /) -> Self:
            """
            secretName is the name of the secret in the pod's namespace to use. More info: https://kubernetes.io/docs/concepts/storage/volumes#secret
            """
            return self._set("secret_name", value)

    class BuilderContext(BuilderContextBase["SecretVolumeSource.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = SecretVolumeSource.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for SecretVolumeSource."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["SecretVolumeSource", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use SecretVolumeSource.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    default_mode: Annotated[Optional[int], Field(alias="defaultMode")] = None
    """
    defaultMode is Optional: mode bits used to set permissions on created files by default. Must be an octal value between 0000 and 0777 or a decimal value between 0 and 511. YAML accepts both octal and decimal values, JSON requires decimal values for mode bits. Defaults to 0644. Directories within the path are not affected by this setting. This might be in conflict with other options that affect the file mode, like fsGroup, and the result can be other mode bits set.
    """
    items: Optional[List[KeyToPath]] = None
    """
    items If unspecified, each key-value pair in the Data field of the referenced Secret will be projected into the volume as a file whose name is the key and content is the value. If specified, the listed keys will be projected into the specified paths, and unlisted keys will not be present. If a key is specified which is not present in the Secret, the volume setup will error unless it is marked optional. Paths must be relative and may not contain the '..' path or start with '..'.
    """
    optional: Optional[bool] = None
    """
    optional field specify whether the Secret or its keys must be defined
    """
    secret_name: Annotated[Optional[str], Field(alias="secretName")] = None
    """
    secretName is the name of the secret in the pod's namespace to use. More info: https://kubernetes.io/docs/concepts/storage/volumes#secret
    """


class ServiceAccountTokenProjection(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["ServiceAccountTokenProjection"]:
            return ServiceAccountTokenProjection

        def build(self) -> "ServiceAccountTokenProjection":
            return ServiceAccountTokenProjection(**self._attrs)

        def audience(self, value: Optional[str], /) -> Self:
            """
            audience is the intended audience of the token. A recipient of a token must identify itself with an identifier specified in the audience of the token, and otherwise should reject the token. The audience defaults to the identifier of the apiserver.
            """
            return self._set("audience", value)

        def expiration_seconds(self, value: Optional[int], /) -> Self:
            """
            expirationSeconds is the requested duration of validity of the service account token. As the token approaches expiration, the kubelet volume plugin will proactively rotate the service account token. The kubelet will start trying to rotate the token if the token is older than 80 percent of its time to live or if the token is older than 24 hours.Defaults to 1 hour and must be at least 10 minutes.
            """
            return self._set("expiration_seconds", value)

        def path(self, value: str, /) -> Self:
            """
            path is the path relative to the mount point of the file to project the token into.
            """
            return self._set("path", value)

    class BuilderContext(BuilderContextBase["ServiceAccountTokenProjection.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = ServiceAccountTokenProjection.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for ServiceAccountTokenProjection."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["ServiceAccountTokenProjection", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use ServiceAccountTokenProjection.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    audience: Optional[str] = None
    """
    audience is the intended audience of the token. A recipient of a token must identify itself with an identifier specified in the audience of the token, and otherwise should reject the token. The audience defaults to the identifier of the apiserver.
    """
    expiration_seconds: Annotated[Optional[int], Field(alias="expirationSeconds")] = None
    """
    expirationSeconds is the requested duration of validity of the service account token. As the token approaches expiration, the kubelet volume plugin will proactively rotate the service account token. The kubelet will start trying to rotate the token if the token is older than 80 percent of its time to live or if the token is older than 24 hours.Defaults to 1 hour and must be at least 10 minutes.
    """
    path: str
    """
    path is the path relative to the mount point of the file to project the token into.
    """


class SessionAffinityConfig(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["SessionAffinityConfig"]:
            return SessionAffinityConfig

        def build(self) -> "SessionAffinityConfig":
            return SessionAffinityConfig(**self._attrs)

        @overload
        def client_ip(
            self, value_or_callback: Optional[ClientIPConfig], /
        ) -> "SessionAffinityConfig.Builder": ...

        @overload
        def client_ip(
            self,
            value_or_callback: Callable[
                [ClientIPConfig.Builder], ClientIPConfig.Builder | ClientIPConfig
            ],
            /,
        ) -> "SessionAffinityConfig.Builder": ...

        @overload
        def client_ip(self, value_or_callback: Never = ...) -> "ClientIPConfig.BuilderContext": ...

        def client_ip(self, value_or_callback=None, /):
            """
            clientIP contains the configurations of Client IP based session affinity.
            """
            if self._in_context and value_or_callback is None:
                context = ClientIPConfig.BuilderContext()
                context._parent_builder = self
                context._field_name = "client_ip"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(ClientIPConfig.builder())
                if isinstance(output, ClientIPConfig.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("client_ip", value)

    class BuilderContext(BuilderContextBase["SessionAffinityConfig.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = SessionAffinityConfig.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for SessionAffinityConfig."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["SessionAffinityConfig", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use SessionAffinityConfig.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    client_ip: Annotated[Optional[ClientIPConfig], Field(alias="clientIP")] = None
    """
    clientIP contains the configurations of Client IP based session affinity.
    """


class SleepAction(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["SleepAction"]:
            return SleepAction

        def build(self) -> "SleepAction":
            return SleepAction(**self._attrs)

        def seconds(self, value: int, /) -> Self:
            """
            Seconds is the number of seconds to sleep.
            """
            return self._set("seconds", value)

    class BuilderContext(BuilderContextBase["SleepAction.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = SleepAction.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for SleepAction."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["SleepAction", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use SleepAction.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    seconds: int
    """
    Seconds is the number of seconds to sleep.
    """


class StorageOSPersistentVolumeSource(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["StorageOSPersistentVolumeSource"]:
            return StorageOSPersistentVolumeSource

        def build(self) -> "StorageOSPersistentVolumeSource":
            return StorageOSPersistentVolumeSource(**self._attrs)

        def fs_type(self, value: Optional[str], /) -> Self:
            """
            fsType is the filesystem type to mount. Must be a filesystem type supported by the host operating system. Ex. "ext4", "xfs", "ntfs". Implicitly inferred to be "ext4" if unspecified.
            """
            return self._set("fs_type", value)

        def read_only(self, value: Optional[bool], /) -> Self:
            """
            readOnly defaults to false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts.
            """
            return self._set("read_only", value)

        @overload
        def secret_ref(
            self, value_or_callback: Optional[ObjectReference], /
        ) -> "StorageOSPersistentVolumeSource.Builder": ...

        @overload
        def secret_ref(
            self,
            value_or_callback: Callable[
                [ObjectReference.Builder], ObjectReference.Builder | ObjectReference
            ],
            /,
        ) -> "StorageOSPersistentVolumeSource.Builder": ...

        @overload
        def secret_ref(
            self, value_or_callback: Never = ...
        ) -> "ObjectReference.BuilderContext": ...

        def secret_ref(self, value_or_callback=None, /):
            """
            secretRef specifies the secret to use for obtaining the StorageOS API credentials.  If not specified, default values will be attempted.
            """
            if self._in_context and value_or_callback is None:
                context = ObjectReference.BuilderContext()
                context._parent_builder = self
                context._field_name = "secret_ref"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(ObjectReference.builder())
                if isinstance(output, ObjectReference.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("secret_ref", value)

        def volume_name(self, value: Optional[str], /) -> Self:
            """
            volumeName is the human-readable name of the StorageOS volume.  Volume names are only unique within a namespace.
            """
            return self._set("volume_name", value)

        def volume_namespace(self, value: Optional[str], /) -> Self:
            """
            volumeNamespace specifies the scope of the volume within StorageOS.  If no namespace is specified then the Pod's namespace will be used.  This allows the Kubernetes name scoping to be mirrored within StorageOS for tighter integration. Set VolumeName to any name to override the default behaviour. Set to "default" if you are not using namespaces within StorageOS. Namespaces that do not pre-exist within StorageOS will be created.
            """
            return self._set("volume_namespace", value)

    class BuilderContext(BuilderContextBase["StorageOSPersistentVolumeSource.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = StorageOSPersistentVolumeSource.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for StorageOSPersistentVolumeSource."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["StorageOSPersistentVolumeSource", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use StorageOSPersistentVolumeSource.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    fs_type: Annotated[Optional[str], Field(alias="fsType")] = None
    """
    fsType is the filesystem type to mount. Must be a filesystem type supported by the host operating system. Ex. "ext4", "xfs", "ntfs". Implicitly inferred to be "ext4" if unspecified.
    """
    read_only: Annotated[Optional[bool], Field(alias="readOnly")] = None
    """
    readOnly defaults to false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts.
    """
    secret_ref: Annotated[Optional[ObjectReference], Field(alias="secretRef")] = None
    """
    secretRef specifies the secret to use for obtaining the StorageOS API credentials.  If not specified, default values will be attempted.
    """
    volume_name: Annotated[Optional[str], Field(alias="volumeName")] = None
    """
    volumeName is the human-readable name of the StorageOS volume.  Volume names are only unique within a namespace.
    """
    volume_namespace: Annotated[Optional[str], Field(alias="volumeNamespace")] = None
    """
    volumeNamespace specifies the scope of the volume within StorageOS.  If no namespace is specified then the Pod's namespace will be used.  This allows the Kubernetes name scoping to be mirrored within StorageOS for tighter integration. Set VolumeName to any name to override the default behaviour. Set to "default" if you are not using namespaces within StorageOS. Namespaces that do not pre-exist within StorageOS will be created.
    """


class StorageOSVolumeSource(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["StorageOSVolumeSource"]:
            return StorageOSVolumeSource

        def build(self) -> "StorageOSVolumeSource":
            return StorageOSVolumeSource(**self._attrs)

        def fs_type(self, value: Optional[str], /) -> Self:
            """
            fsType is the filesystem type to mount. Must be a filesystem type supported by the host operating system. Ex. "ext4", "xfs", "ntfs". Implicitly inferred to be "ext4" if unspecified.
            """
            return self._set("fs_type", value)

        def read_only(self, value: Optional[bool], /) -> Self:
            """
            readOnly defaults to false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts.
            """
            return self._set("read_only", value)

        @overload
        def secret_ref(
            self, value_or_callback: Optional[LocalObjectReference], /
        ) -> "StorageOSVolumeSource.Builder": ...

        @overload
        def secret_ref(
            self,
            value_or_callback: Callable[
                [LocalObjectReference.Builder],
                LocalObjectReference.Builder | LocalObjectReference,
            ],
            /,
        ) -> "StorageOSVolumeSource.Builder": ...

        @overload
        def secret_ref(
            self, value_or_callback: Never = ...
        ) -> "LocalObjectReference.BuilderContext": ...

        def secret_ref(self, value_or_callback=None, /):
            """
            secretRef specifies the secret to use for obtaining the StorageOS API credentials.  If not specified, default values will be attempted.
            """
            if self._in_context and value_or_callback is None:
                context = LocalObjectReference.BuilderContext()
                context._parent_builder = self
                context._field_name = "secret_ref"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(LocalObjectReference.builder())
                if isinstance(output, LocalObjectReference.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("secret_ref", value)

        def volume_name(self, value: Optional[str], /) -> Self:
            """
            volumeName is the human-readable name of the StorageOS volume.  Volume names are only unique within a namespace.
            """
            return self._set("volume_name", value)

        def volume_namespace(self, value: Optional[str], /) -> Self:
            """
            volumeNamespace specifies the scope of the volume within StorageOS.  If no namespace is specified then the Pod's namespace will be used.  This allows the Kubernetes name scoping to be mirrored within StorageOS for tighter integration. Set VolumeName to any name to override the default behaviour. Set to "default" if you are not using namespaces within StorageOS. Namespaces that do not pre-exist within StorageOS will be created.
            """
            return self._set("volume_namespace", value)

    class BuilderContext(BuilderContextBase["StorageOSVolumeSource.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = StorageOSVolumeSource.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for StorageOSVolumeSource."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["StorageOSVolumeSource", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use StorageOSVolumeSource.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    fs_type: Annotated[Optional[str], Field(alias="fsType")] = None
    """
    fsType is the filesystem type to mount. Must be a filesystem type supported by the host operating system. Ex. "ext4", "xfs", "ntfs". Implicitly inferred to be "ext4" if unspecified.
    """
    read_only: Annotated[Optional[bool], Field(alias="readOnly")] = None
    """
    readOnly defaults to false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts.
    """
    secret_ref: Annotated[Optional[LocalObjectReference], Field(alias="secretRef")] = None
    """
    secretRef specifies the secret to use for obtaining the StorageOS API credentials.  If not specified, default values will be attempted.
    """
    volume_name: Annotated[Optional[str], Field(alias="volumeName")] = None
    """
    volumeName is the human-readable name of the StorageOS volume.  Volume names are only unique within a namespace.
    """
    volume_namespace: Annotated[Optional[str], Field(alias="volumeNamespace")] = None
    """
    volumeNamespace specifies the scope of the volume within StorageOS.  If no namespace is specified then the Pod's namespace will be used.  This allows the Kubernetes name scoping to be mirrored within StorageOS for tighter integration. Set VolumeName to any name to override the default behaviour. Set to "default" if you are not using namespaces within StorageOS. Namespaces that do not pre-exist within StorageOS will be created.
    """


class Sysctl(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["Sysctl"]:
            return Sysctl

        def build(self) -> "Sysctl":
            return Sysctl(**self._attrs)

        def name(self, value: str, /) -> Self:
            """
            Name of a property to set
            """
            return self._set("name", value)

        def value(self, value: str, /) -> Self:
            """
            Value of a property to set
            """
            return self._set("value", value)

    class BuilderContext(BuilderContextBase["Sysctl.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = Sysctl.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for Sysctl."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["Sysctl", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use Sysctl.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    name: str
    """
    Name of a property to set
    """
    value: str
    """
    Value of a property to set
    """


class Toleration(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["Toleration"]:
            return Toleration

        def build(self) -> "Toleration":
            return Toleration(**self._attrs)

        def effect(self, value: Optional[str], /) -> Self:
            """
            Effect indicates the taint effect to match. Empty means match all taint effects. When specified, allowed values are NoSchedule, PreferNoSchedule and NoExecute.
            """
            return self._set("effect", value)

        def key(self, value: Optional[str], /) -> Self:
            """
            Key is the taint key that the toleration applies to. Empty means match all taint keys. If the key is empty, operator must be Exists; this combination means to match all values and all keys.
            """
            return self._set("key", value)

        def operator(self, value: Optional[str], /) -> Self:
            """
            Operator represents a key's relationship to the value. Valid operators are Exists and Equal. Defaults to Equal. Exists is equivalent to wildcard for value, so that a pod can tolerate all taints of a particular category.
            """
            return self._set("operator", value)

        def toleration_seconds(self, value: Optional[int], /) -> Self:
            """
            TolerationSeconds represents the period of time the toleration (which must be of effect NoExecute, otherwise this field is ignored) tolerates the taint. By default, it is not set, which means tolerate the taint forever (do not evict). Zero and negative values will be treated as 0 (evict immediately) by the system.
            """
            return self._set("toleration_seconds", value)

        def value(self, value: Optional[str], /) -> Self:
            """
            Value is the taint value the toleration matches to. If the operator is Exists, the value should be empty, otherwise just a regular string.
            """
            return self._set("value", value)

    class BuilderContext(BuilderContextBase["Toleration.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = Toleration.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for Toleration."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["Toleration", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use Toleration.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    effect: Optional[str] = None
    """
    Effect indicates the taint effect to match. Empty means match all taint effects. When specified, allowed values are NoSchedule, PreferNoSchedule and NoExecute.
    """
    key: Optional[str] = None
    """
    Key is the taint key that the toleration applies to. Empty means match all taint keys. If the key is empty, operator must be Exists; this combination means to match all values and all keys.
    """
    operator: Optional[str] = None
    """
    Operator represents a key's relationship to the value. Valid operators are Exists and Equal. Defaults to Equal. Exists is equivalent to wildcard for value, so that a pod can tolerate all taints of a particular category.
    """
    toleration_seconds: Annotated[Optional[int], Field(alias="tolerationSeconds")] = None
    """
    TolerationSeconds represents the period of time the toleration (which must be of effect NoExecute, otherwise this field is ignored) tolerates the taint. By default, it is not set, which means tolerate the taint forever (do not evict). Zero and negative values will be treated as 0 (evict immediately) by the system.
    """
    value: Optional[str] = None
    """
    Value is the taint value the toleration matches to. If the operator is Exists, the value should be empty, otherwise just a regular string.
    """


class TopologySelectorLabelRequirement(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["TopologySelectorLabelRequirement"]:
            return TopologySelectorLabelRequirement

        def build(self) -> "TopologySelectorLabelRequirement":
            return TopologySelectorLabelRequirement(**self._attrs)

        def key(self, value: str, /) -> Self:
            """
            The label key that the selector applies to.
            """
            return self._set("key", value)

        def values(self, value: List[str], /) -> Self:
            """
            An array of string values. One value must match the label to be selected. Each entry in Values is ORed.
            """
            return self._set("values", value)

    class BuilderContext(BuilderContextBase["TopologySelectorLabelRequirement.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = TopologySelectorLabelRequirement.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for TopologySelectorLabelRequirement."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["TopologySelectorLabelRequirement", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use TopologySelectorLabelRequirement.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    key: str
    """
    The label key that the selector applies to.
    """
    values: List[str]
    """
    An array of string values. One value must match the label to be selected. Each entry in Values is ORed.
    """


class TopologySelectorTerm(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["TopologySelectorTerm"]:
            return TopologySelectorTerm

        def build(self) -> "TopologySelectorTerm":
            return TopologySelectorTerm(**self._attrs)

        @overload
        def match_label_expressions(
            self, value_or_callback: List[TopologySelectorLabelRequirement], /
        ) -> "TopologySelectorTerm.Builder": ...

        @overload
        def match_label_expressions(
            self,
            value_or_callback: Callable[
                [
                    GenericListBuilder[
                        TopologySelectorLabelRequirement,
                        TopologySelectorLabelRequirement.Builder,
                    ]
                ],
                GenericListBuilder[
                    TopologySelectorLabelRequirement,
                    TopologySelectorLabelRequirement.Builder,
                ]
                | List[TopologySelectorLabelRequirement],
            ],
            /,
        ) -> "TopologySelectorTerm.Builder": ...

        @overload
        def match_label_expressions(
            self, value_or_callback: Never = ...
        ) -> ListBuilderContext[TopologySelectorLabelRequirement.Builder]: ...

        def match_label_expressions(self, value_or_callback=None, /):
            """
            A list of topology selector requirements by labels.
            """
            if self._in_context and value_or_callback is None:
                context = ListBuilderContext[TopologySelectorLabelRequirement.Builder]()
                context._parent_builder = self
                context._field_name = "match_label_expressions"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(TopologySelectorLabelRequirement.list_builder())
                if isinstance(output, GenericListBuilder):
                    value = output.build()
                else:
                    value = output
            return self._set("match_label_expressions", value)

    class BuilderContext(BuilderContextBase["TopologySelectorTerm.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = TopologySelectorTerm.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for TopologySelectorTerm."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["TopologySelectorTerm", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use TopologySelectorTerm.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    match_label_expressions: Annotated[
        Optional[List[TopologySelectorLabelRequirement]],
        Field(alias="matchLabelExpressions"),
    ] = None
    """
    A list of topology selector requirements by labels.
    """


class TypedLocalObjectReference(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["TypedLocalObjectReference"]:
            return TypedLocalObjectReference

        def build(self) -> "TypedLocalObjectReference":
            return TypedLocalObjectReference(**self._attrs)

        def api_group(self, value: Optional[str], /) -> Self:
            """
            APIGroup is the group for the resource being referenced. If APIGroup is not specified, the specified Kind must be in the core API group. For any other third-party types, APIGroup is required.
            """
            return self._set("api_group", value)

        def kind(self, value: str, /) -> Self:
            """
            Kind is the type of resource being referenced
            """
            return self._set("kind", value)

        def name(self, value: str, /) -> Self:
            """
            Name is the name of resource being referenced
            """
            return self._set("name", value)

    class BuilderContext(BuilderContextBase["TypedLocalObjectReference.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = TypedLocalObjectReference.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for TypedLocalObjectReference."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["TypedLocalObjectReference", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use TypedLocalObjectReference.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    api_group: Annotated[Optional[str], Field(alias="apiGroup")] = None
    """
    APIGroup is the group for the resource being referenced. If APIGroup is not specified, the specified Kind must be in the core API group. For any other third-party types, APIGroup is required.
    """
    kind: str
    """
    Kind is the type of resource being referenced
    """
    name: str
    """
    Name is the name of resource being referenced
    """


class TypedObjectReference(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["TypedObjectReference"]:
            return TypedObjectReference

        def build(self) -> "TypedObjectReference":
            return TypedObjectReference(**self._attrs)

        def api_group(self, value: Optional[str], /) -> Self:
            """
            APIGroup is the group for the resource being referenced. If APIGroup is not specified, the specified Kind must be in the core API group. For any other third-party types, APIGroup is required.
            """
            return self._set("api_group", value)

        def kind(self, value: str, /) -> Self:
            """
            Kind is the type of resource being referenced
            """
            return self._set("kind", value)

        def name(self, value: str, /) -> Self:
            """
            Name is the name of resource being referenced
            """
            return self._set("name", value)

        def namespace(self, value: Optional[str], /) -> Self:
            """
            Namespace is the namespace of resource being referenced Note that when a namespace is specified, a gateway.networking.k8s.io/ReferenceGrant object is required in the referent namespace to allow that namespace's owner to accept the reference. See the ReferenceGrant documentation for details. (Alpha) This field requires the CrossNamespaceVolumeDataSource feature gate to be enabled.
            """
            return self._set("namespace", value)

    class BuilderContext(BuilderContextBase["TypedObjectReference.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = TypedObjectReference.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for TypedObjectReference."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["TypedObjectReference", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use TypedObjectReference.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    api_group: Annotated[Optional[str], Field(alias="apiGroup")] = None
    """
    APIGroup is the group for the resource being referenced. If APIGroup is not specified, the specified Kind must be in the core API group. For any other third-party types, APIGroup is required.
    """
    kind: str
    """
    Kind is the type of resource being referenced
    """
    name: str
    """
    Name is the name of resource being referenced
    """
    namespace: Optional[str] = None
    """
    Namespace is the namespace of resource being referenced Note that when a namespace is specified, a gateway.networking.k8s.io/ReferenceGrant object is required in the referent namespace to allow that namespace's owner to accept the reference. See the ReferenceGrant documentation for details. (Alpha) This field requires the CrossNamespaceVolumeDataSource feature gate to be enabled.
    """


class VolumeDevice(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["VolumeDevice"]:
            return VolumeDevice

        def build(self) -> "VolumeDevice":
            return VolumeDevice(**self._attrs)

        def device_path(self, value: str, /) -> Self:
            """
            devicePath is the path inside of the container that the device will be mapped to.
            """
            return self._set("device_path", value)

        def name(self, value: str, /) -> Self:
            """
            name must match the name of a persistentVolumeClaim in the pod
            """
            return self._set("name", value)

    class BuilderContext(BuilderContextBase["VolumeDevice.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = VolumeDevice.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for VolumeDevice."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["VolumeDevice", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use VolumeDevice.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    device_path: Annotated[str, Field(alias="devicePath")]
    """
    devicePath is the path inside of the container that the device will be mapped to.
    """
    name: str
    """
    name must match the name of a persistentVolumeClaim in the pod
    """


class VolumeMount(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["VolumeMount"]:
            return VolumeMount

        def build(self) -> "VolumeMount":
            return VolumeMount(**self._attrs)

        def mount_path(self, value: str, /) -> Self:
            """
            Path within the container at which the volume should be mounted.  Must not contain ':'.
            """
            return self._set("mount_path", value)

        def mount_propagation(self, value: Optional[str], /) -> Self:
            """
            mountPropagation determines how mounts are propagated from the host to container and the other way around. When not set, MountPropagationNone is used. This field is beta in 1.10. When RecursiveReadOnly is set to IfPossible or to Enabled, MountPropagation must be None or unspecified (which defaults to None).
            """
            return self._set("mount_propagation", value)

        def name(self, value: str, /) -> Self:
            """
            This must match the Name of a Volume.
            """
            return self._set("name", value)

        def read_only(self, value: Optional[bool], /) -> Self:
            """
            Mounted read-only if true, read-write otherwise (false or unspecified). Defaults to false.
            """
            return self._set("read_only", value)

        def recursive_read_only(self, value: Optional[str], /) -> Self:
            """
            RecursiveReadOnly specifies whether read-only mounts should be handled recursively.

            If ReadOnly is false, this field has no meaning and must be unspecified.

            If ReadOnly is true, and this field is set to Disabled, the mount is not made recursively read-only.  If this field is set to IfPossible, the mount is made recursively read-only, if it is supported by the container runtime.  If this field is set to Enabled, the mount is made recursively read-only if it is supported by the container runtime, otherwise the pod will not be started and an error will be generated to indicate the reason.

            If this field is set to IfPossible or Enabled, MountPropagation must be set to None (or be unspecified, which defaults to None).

            If this field is not specified, it is treated as an equivalent of Disabled.
            """
            return self._set("recursive_read_only", value)

        def sub_path(self, value: Optional[str], /) -> Self:
            """
            Path within the volume from which the container's volume should be mounted. Defaults to "" (volume's root).
            """
            return self._set("sub_path", value)

        def sub_path_expr(self, value: Optional[str], /) -> Self:
            """
            Expanded path within the volume from which the container's volume should be mounted. Behaves similarly to SubPath but environment variable references $(VAR_NAME) are expanded using the container's environment. Defaults to "" (volume's root). SubPathExpr and SubPath are mutually exclusive.
            """
            return self._set("sub_path_expr", value)

    class BuilderContext(BuilderContextBase["VolumeMount.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = VolumeMount.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for VolumeMount."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["VolumeMount", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use VolumeMount.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    mount_path: Annotated[str, Field(alias="mountPath")]
    """
    Path within the container at which the volume should be mounted.  Must not contain ':'.
    """
    mount_propagation: Annotated[Optional[str], Field(alias="mountPropagation")] = None
    """
    mountPropagation determines how mounts are propagated from the host to container and the other way around. When not set, MountPropagationNone is used. This field is beta in 1.10. When RecursiveReadOnly is set to IfPossible or to Enabled, MountPropagation must be None or unspecified (which defaults to None).
    """
    name: str
    """
    This must match the Name of a Volume.
    """
    read_only: Annotated[Optional[bool], Field(alias="readOnly")] = None
    """
    Mounted read-only if true, read-write otherwise (false or unspecified). Defaults to false.
    """
    recursive_read_only: Annotated[Optional[str], Field(alias="recursiveReadOnly")] = None
    """
    RecursiveReadOnly specifies whether read-only mounts should be handled recursively.

    If ReadOnly is false, this field has no meaning and must be unspecified.

    If ReadOnly is true, and this field is set to Disabled, the mount is not made recursively read-only.  If this field is set to IfPossible, the mount is made recursively read-only, if it is supported by the container runtime.  If this field is set to Enabled, the mount is made recursively read-only if it is supported by the container runtime, otherwise the pod will not be started and an error will be generated to indicate the reason.

    If this field is set to IfPossible or Enabled, MountPropagation must be set to None (or be unspecified, which defaults to None).

    If this field is not specified, it is treated as an equivalent of Disabled.
    """
    sub_path: Annotated[Optional[str], Field(alias="subPath")] = None
    """
    Path within the volume from which the container's volume should be mounted. Defaults to "" (volume's root).
    """
    sub_path_expr: Annotated[Optional[str], Field(alias="subPathExpr")] = None
    """
    Expanded path within the volume from which the container's volume should be mounted. Behaves similarly to SubPath but environment variable references $(VAR_NAME) are expanded using the container's environment. Defaults to "" (volume's root). SubPathExpr and SubPath are mutually exclusive.
    """


class VolumeMountStatus(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["VolumeMountStatus"]:
            return VolumeMountStatus

        def build(self) -> "VolumeMountStatus":
            return VolumeMountStatus(**self._attrs)

        def mount_path(self, value: str, /) -> Self:
            """
            MountPath corresponds to the original VolumeMount.
            """
            return self._set("mount_path", value)

        def name(self, value: str, /) -> Self:
            """
            Name corresponds to the name of the original VolumeMount.
            """
            return self._set("name", value)

        def read_only(self, value: Optional[bool], /) -> Self:
            """
            ReadOnly corresponds to the original VolumeMount.
            """
            return self._set("read_only", value)

        def recursive_read_only(self, value: Optional[str], /) -> Self:
            """
            RecursiveReadOnly must be set to Disabled, Enabled, or unspecified (for non-readonly mounts). An IfPossible value in the original VolumeMount must be translated to Disabled or Enabled, depending on the mount result.
            """
            return self._set("recursive_read_only", value)

    class BuilderContext(BuilderContextBase["VolumeMountStatus.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = VolumeMountStatus.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for VolumeMountStatus."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["VolumeMountStatus", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use VolumeMountStatus.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    mount_path: Annotated[str, Field(alias="mountPath")]
    """
    MountPath corresponds to the original VolumeMount.
    """
    name: str
    """
    Name corresponds to the name of the original VolumeMount.
    """
    read_only: Annotated[Optional[bool], Field(alias="readOnly")] = None
    """
    ReadOnly corresponds to the original VolumeMount.
    """
    recursive_read_only: Annotated[Optional[str], Field(alias="recursiveReadOnly")] = None
    """
    RecursiveReadOnly must be set to Disabled, Enabled, or unspecified (for non-readonly mounts). An IfPossible value in the original VolumeMount must be translated to Disabled or Enabled, depending on the mount result.
    """


class VsphereVirtualDiskVolumeSource(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["VsphereVirtualDiskVolumeSource"]:
            return VsphereVirtualDiskVolumeSource

        def build(self) -> "VsphereVirtualDiskVolumeSource":
            return VsphereVirtualDiskVolumeSource(**self._attrs)

        def fs_type(self, value: Optional[str], /) -> Self:
            """
            fsType is filesystem type to mount. Must be a filesystem type supported by the host operating system. Ex. "ext4", "xfs", "ntfs". Implicitly inferred to be "ext4" if unspecified.
            """
            return self._set("fs_type", value)

        def storage_policy_id(self, value: Optional[str], /) -> Self:
            """
            storagePolicyID is the storage Policy Based Management (SPBM) profile ID associated with the StoragePolicyName.
            """
            return self._set("storage_policy_id", value)

        def storage_policy_name(self, value: Optional[str], /) -> Self:
            """
            storagePolicyName is the storage Policy Based Management (SPBM) profile name.
            """
            return self._set("storage_policy_name", value)

        def volume_path(self, value: str, /) -> Self:
            """
            volumePath is the path that identifies vSphere volume vmdk
            """
            return self._set("volume_path", value)

    class BuilderContext(BuilderContextBase["VsphereVirtualDiskVolumeSource.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = VsphereVirtualDiskVolumeSource.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for VsphereVirtualDiskVolumeSource."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["VsphereVirtualDiskVolumeSource", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use VsphereVirtualDiskVolumeSource.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    fs_type: Annotated[Optional[str], Field(alias="fsType")] = None
    """
    fsType is filesystem type to mount. Must be a filesystem type supported by the host operating system. Ex. "ext4", "xfs", "ntfs". Implicitly inferred to be "ext4" if unspecified.
    """
    storage_policy_id: Annotated[Optional[str], Field(alias="storagePolicyID")] = None
    """
    storagePolicyID is the storage Policy Based Management (SPBM) profile ID associated with the StoragePolicyName.
    """
    storage_policy_name: Annotated[Optional[str], Field(alias="storagePolicyName")] = None
    """
    storagePolicyName is the storage Policy Based Management (SPBM) profile name.
    """
    volume_path: Annotated[str, Field(alias="volumePath")]
    """
    volumePath is the path that identifies vSphere volume vmdk
    """


class WindowsSecurityContextOptions(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["WindowsSecurityContextOptions"]:
            return WindowsSecurityContextOptions

        def build(self) -> "WindowsSecurityContextOptions":
            return WindowsSecurityContextOptions(**self._attrs)

        def gmsa_credential_spec(self, value: Optional[str], /) -> Self:
            """
            GMSACredentialSpec is where the GMSA admission webhook (https://github.com/kubernetes-sigs/windows-gmsa) inlines the contents of the GMSA credential spec named by the GMSACredentialSpecName field.
            """
            return self._set("gmsa_credential_spec", value)

        def gmsa_credential_spec_name(self, value: Optional[str], /) -> Self:
            """
            GMSACredentialSpecName is the name of the GMSA credential spec to use.
            """
            return self._set("gmsa_credential_spec_name", value)

        def host_process(self, value: Optional[bool], /) -> Self:
            """
            HostProcess determines if a container should be run as a 'Host Process' container. All of a Pod's containers must have the same effective HostProcess value (it is not allowed to have a mix of HostProcess containers and non-HostProcess containers). In addition, if HostProcess is true then HostNetwork must also be set to true.
            """
            return self._set("host_process", value)

        def run_as_user_name(self, value: Optional[str], /) -> Self:
            """
            The UserName in Windows to run the entrypoint of the container process. Defaults to the user specified in image metadata if unspecified. May also be set in PodSecurityContext. If set in both SecurityContext and PodSecurityContext, the value specified in SecurityContext takes precedence.
            """
            return self._set("run_as_user_name", value)

    class BuilderContext(BuilderContextBase["WindowsSecurityContextOptions.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = WindowsSecurityContextOptions.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for WindowsSecurityContextOptions."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["WindowsSecurityContextOptions", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use WindowsSecurityContextOptions.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    gmsa_credential_spec: Annotated[Optional[str], Field(alias="gmsaCredentialSpec")] = None
    """
    GMSACredentialSpec is where the GMSA admission webhook (https://github.com/kubernetes-sigs/windows-gmsa) inlines the contents of the GMSA credential spec named by the GMSACredentialSpecName field.
    """
    gmsa_credential_spec_name: Annotated[Optional[str], Field(alias="gmsaCredentialSpecName")] = (
        None
    )
    """
    GMSACredentialSpecName is the name of the GMSA credential spec to use.
    """
    host_process: Annotated[Optional[bool], Field(alias="hostProcess")] = None
    """
    HostProcess determines if a container should be run as a 'Host Process' container. All of a Pod's containers must have the same effective HostProcess value (it is not allowed to have a mix of HostProcess containers and non-HostProcess containers). In addition, if HostProcess is true then HostNetwork must also be set to true.
    """
    run_as_user_name: Annotated[Optional[str], Field(alias="runAsUserName")] = None
    """
    The UserName in Windows to run the entrypoint of the container process. Defaults to the user specified in image metadata if unspecified. May also be set in PodSecurityContext. If set in both SecurityContext and PodSecurityContext, the value specified in SecurityContext takes precedence.
    """


class CSIPersistentVolumeSource(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["CSIPersistentVolumeSource"]:
            return CSIPersistentVolumeSource

        def build(self) -> "CSIPersistentVolumeSource":
            return CSIPersistentVolumeSource(**self._attrs)

        @overload
        def controller_expand_secret_ref(
            self, value_or_callback: Optional[SecretReference], /
        ) -> "CSIPersistentVolumeSource.Builder": ...

        @overload
        def controller_expand_secret_ref(
            self,
            value_or_callback: Callable[
                [SecretReference.Builder], SecretReference.Builder | SecretReference
            ],
            /,
        ) -> "CSIPersistentVolumeSource.Builder": ...

        @overload
        def controller_expand_secret_ref(
            self, value_or_callback: Never = ...
        ) -> "SecretReference.BuilderContext": ...

        def controller_expand_secret_ref(self, value_or_callback=None, /):
            """
            controllerExpandSecretRef is a reference to the secret object containing sensitive information to pass to the CSI driver to complete the CSI ControllerExpandVolume call. This field is optional, and may be empty if no secret is required. If the secret object contains more than one secret, all secrets are passed.
            """
            if self._in_context and value_or_callback is None:
                context = SecretReference.BuilderContext()
                context._parent_builder = self
                context._field_name = "controller_expand_secret_ref"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(SecretReference.builder())
                if isinstance(output, SecretReference.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("controller_expand_secret_ref", value)

        @overload
        def controller_publish_secret_ref(
            self, value_or_callback: Optional[SecretReference], /
        ) -> "CSIPersistentVolumeSource.Builder": ...

        @overload
        def controller_publish_secret_ref(
            self,
            value_or_callback: Callable[
                [SecretReference.Builder], SecretReference.Builder | SecretReference
            ],
            /,
        ) -> "CSIPersistentVolumeSource.Builder": ...

        @overload
        def controller_publish_secret_ref(
            self, value_or_callback: Never = ...
        ) -> "SecretReference.BuilderContext": ...

        def controller_publish_secret_ref(self, value_or_callback=None, /):
            """
            controllerPublishSecretRef is a reference to the secret object containing sensitive information to pass to the CSI driver to complete the CSI ControllerPublishVolume and ControllerUnpublishVolume calls. This field is optional, and may be empty if no secret is required. If the secret object contains more than one secret, all secrets are passed.
            """
            if self._in_context and value_or_callback is None:
                context = SecretReference.BuilderContext()
                context._parent_builder = self
                context._field_name = "controller_publish_secret_ref"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(SecretReference.builder())
                if isinstance(output, SecretReference.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("controller_publish_secret_ref", value)

        def driver(self, value: str, /) -> Self:
            """
            driver is the name of the driver to use for this volume. Required.
            """
            return self._set("driver", value)

        def fs_type(self, value: Optional[str], /) -> Self:
            """
            fsType to mount. Must be a filesystem type supported by the host operating system. Ex. "ext4", "xfs", "ntfs".
            """
            return self._set("fs_type", value)

        @overload
        def node_expand_secret_ref(
            self, value_or_callback: Optional[SecretReference], /
        ) -> "CSIPersistentVolumeSource.Builder": ...

        @overload
        def node_expand_secret_ref(
            self,
            value_or_callback: Callable[
                [SecretReference.Builder], SecretReference.Builder | SecretReference
            ],
            /,
        ) -> "CSIPersistentVolumeSource.Builder": ...

        @overload
        def node_expand_secret_ref(
            self, value_or_callback: Never = ...
        ) -> "SecretReference.BuilderContext": ...

        def node_expand_secret_ref(self, value_or_callback=None, /):
            """
            nodeExpandSecretRef is a reference to the secret object containing sensitive information to pass to the CSI driver to complete the CSI NodeExpandVolume call. This field is optional, may be omitted if no secret is required. If the secret object contains more than one secret, all secrets are passed.
            """
            if self._in_context and value_or_callback is None:
                context = SecretReference.BuilderContext()
                context._parent_builder = self
                context._field_name = "node_expand_secret_ref"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(SecretReference.builder())
                if isinstance(output, SecretReference.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("node_expand_secret_ref", value)

        @overload
        def node_publish_secret_ref(
            self, value_or_callback: Optional[SecretReference], /
        ) -> "CSIPersistentVolumeSource.Builder": ...

        @overload
        def node_publish_secret_ref(
            self,
            value_or_callback: Callable[
                [SecretReference.Builder], SecretReference.Builder | SecretReference
            ],
            /,
        ) -> "CSIPersistentVolumeSource.Builder": ...

        @overload
        def node_publish_secret_ref(
            self, value_or_callback: Never = ...
        ) -> "SecretReference.BuilderContext": ...

        def node_publish_secret_ref(self, value_or_callback=None, /):
            """
            nodePublishSecretRef is a reference to the secret object containing sensitive information to pass to the CSI driver to complete the CSI NodePublishVolume and NodeUnpublishVolume calls. This field is optional, and may be empty if no secret is required. If the secret object contains more than one secret, all secrets are passed.
            """
            if self._in_context and value_or_callback is None:
                context = SecretReference.BuilderContext()
                context._parent_builder = self
                context._field_name = "node_publish_secret_ref"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(SecretReference.builder())
                if isinstance(output, SecretReference.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("node_publish_secret_ref", value)

        @overload
        def node_stage_secret_ref(
            self, value_or_callback: Optional[SecretReference], /
        ) -> "CSIPersistentVolumeSource.Builder": ...

        @overload
        def node_stage_secret_ref(
            self,
            value_or_callback: Callable[
                [SecretReference.Builder], SecretReference.Builder | SecretReference
            ],
            /,
        ) -> "CSIPersistentVolumeSource.Builder": ...

        @overload
        def node_stage_secret_ref(
            self, value_or_callback: Never = ...
        ) -> "SecretReference.BuilderContext": ...

        def node_stage_secret_ref(self, value_or_callback=None, /):
            """
            nodeStageSecretRef is a reference to the secret object containing sensitive information to pass to the CSI driver to complete the CSI NodeStageVolume and NodeStageVolume and NodeUnstageVolume calls. This field is optional, and may be empty if no secret is required. If the secret object contains more than one secret, all secrets are passed.
            """
            if self._in_context and value_or_callback is None:
                context = SecretReference.BuilderContext()
                context._parent_builder = self
                context._field_name = "node_stage_secret_ref"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(SecretReference.builder())
                if isinstance(output, SecretReference.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("node_stage_secret_ref", value)

        def read_only(self, value: Optional[bool], /) -> Self:
            """
            readOnly value to pass to ControllerPublishVolumeRequest. Defaults to false (read/write).
            """
            return self._set("read_only", value)

        def volume_attributes(self, value: Optional[Dict[str, str]], /) -> Self:
            """
            volumeAttributes of the volume to publish.
            """
            return self._set("volume_attributes", value)

        def volume_handle(self, value: str, /) -> Self:
            """
            volumeHandle is the unique volume name returned by the CSI volume plugin’s CreateVolume to refer to the volume on all subsequent calls. Required.
            """
            return self._set("volume_handle", value)

    class BuilderContext(BuilderContextBase["CSIPersistentVolumeSource.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = CSIPersistentVolumeSource.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for CSIPersistentVolumeSource."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["CSIPersistentVolumeSource", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use CSIPersistentVolumeSource.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    controller_expand_secret_ref: Annotated[
        Optional[SecretReference], Field(alias="controllerExpandSecretRef")
    ] = None
    """
    controllerExpandSecretRef is a reference to the secret object containing sensitive information to pass to the CSI driver to complete the CSI ControllerExpandVolume call. This field is optional, and may be empty if no secret is required. If the secret object contains more than one secret, all secrets are passed.
    """
    controller_publish_secret_ref: Annotated[
        Optional[SecretReference], Field(alias="controllerPublishSecretRef")
    ] = None
    """
    controllerPublishSecretRef is a reference to the secret object containing sensitive information to pass to the CSI driver to complete the CSI ControllerPublishVolume and ControllerUnpublishVolume calls. This field is optional, and may be empty if no secret is required. If the secret object contains more than one secret, all secrets are passed.
    """
    driver: str
    """
    driver is the name of the driver to use for this volume. Required.
    """
    fs_type: Annotated[Optional[str], Field(alias="fsType")] = None
    """
    fsType to mount. Must be a filesystem type supported by the host operating system. Ex. "ext4", "xfs", "ntfs".
    """
    node_expand_secret_ref: Annotated[
        Optional[SecretReference], Field(alias="nodeExpandSecretRef")
    ] = None
    """
    nodeExpandSecretRef is a reference to the secret object containing sensitive information to pass to the CSI driver to complete the CSI NodeExpandVolume call. This field is optional, may be omitted if no secret is required. If the secret object contains more than one secret, all secrets are passed.
    """
    node_publish_secret_ref: Annotated[
        Optional[SecretReference], Field(alias="nodePublishSecretRef")
    ] = None
    """
    nodePublishSecretRef is a reference to the secret object containing sensitive information to pass to the CSI driver to complete the CSI NodePublishVolume and NodeUnpublishVolume calls. This field is optional, and may be empty if no secret is required. If the secret object contains more than one secret, all secrets are passed.
    """
    node_stage_secret_ref: Annotated[
        Optional[SecretReference], Field(alias="nodeStageSecretRef")
    ] = None
    """
    nodeStageSecretRef is a reference to the secret object containing sensitive information to pass to the CSI driver to complete the CSI NodeStageVolume and NodeStageVolume and NodeUnstageVolume calls. This field is optional, and may be empty if no secret is required. If the secret object contains more than one secret, all secrets are passed.
    """
    read_only: Annotated[Optional[bool], Field(alias="readOnly")] = None
    """
    readOnly value to pass to ControllerPublishVolumeRequest. Defaults to false (read/write).
    """
    volume_attributes: Annotated[Optional[Dict[str, str]], Field(alias="volumeAttributes")] = None
    """
    volumeAttributes of the volume to publish.
    """
    volume_handle: Annotated[str, Field(alias="volumeHandle")]
    """
    volumeHandle is the unique volume name returned by the CSI volume plugin’s CreateVolume to refer to the volume on all subsequent calls. Required.
    """


class CSIVolumeSource(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["CSIVolumeSource"]:
            return CSIVolumeSource

        def build(self) -> "CSIVolumeSource":
            return CSIVolumeSource(**self._attrs)

        def driver(self, value: str, /) -> Self:
            """
            driver is the name of the CSI driver that handles this volume. Consult with your admin for the correct name as registered in the cluster.
            """
            return self._set("driver", value)

        def fs_type(self, value: Optional[str], /) -> Self:
            """
            fsType to mount. Ex. "ext4", "xfs", "ntfs". If not provided, the empty value is passed to the associated CSI driver which will determine the default filesystem to apply.
            """
            return self._set("fs_type", value)

        @overload
        def node_publish_secret_ref(
            self, value_or_callback: Optional[LocalObjectReference], /
        ) -> "CSIVolumeSource.Builder": ...

        @overload
        def node_publish_secret_ref(
            self,
            value_or_callback: Callable[
                [LocalObjectReference.Builder],
                LocalObjectReference.Builder | LocalObjectReference,
            ],
            /,
        ) -> "CSIVolumeSource.Builder": ...

        @overload
        def node_publish_secret_ref(
            self, value_or_callback: Never = ...
        ) -> "LocalObjectReference.BuilderContext": ...

        def node_publish_secret_ref(self, value_or_callback=None, /):
            """
            nodePublishSecretRef is a reference to the secret object containing sensitive information to pass to the CSI driver to complete the CSI NodePublishVolume and NodeUnpublishVolume calls. This field is optional, and  may be empty if no secret is required. If the secret object contains more than one secret, all secret references are passed.
            """
            if self._in_context and value_or_callback is None:
                context = LocalObjectReference.BuilderContext()
                context._parent_builder = self
                context._field_name = "node_publish_secret_ref"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(LocalObjectReference.builder())
                if isinstance(output, LocalObjectReference.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("node_publish_secret_ref", value)

        def read_only(self, value: Optional[bool], /) -> Self:
            """
            readOnly specifies a read-only configuration for the volume. Defaults to false (read/write).
            """
            return self._set("read_only", value)

        def volume_attributes(self, value: Optional[Dict[str, str]], /) -> Self:
            """
            volumeAttributes stores driver-specific properties that are passed to the CSI driver. Consult your driver's documentation for supported values.
            """
            return self._set("volume_attributes", value)

    class BuilderContext(BuilderContextBase["CSIVolumeSource.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = CSIVolumeSource.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for CSIVolumeSource."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["CSIVolumeSource", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use CSIVolumeSource.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    driver: str
    """
    driver is the name of the CSI driver that handles this volume. Consult with your admin for the correct name as registered in the cluster.
    """
    fs_type: Annotated[Optional[str], Field(alias="fsType")] = None
    """
    fsType to mount. Ex. "ext4", "xfs", "ntfs". If not provided, the empty value is passed to the associated CSI driver which will determine the default filesystem to apply.
    """
    node_publish_secret_ref: Annotated[
        Optional[LocalObjectReference], Field(alias="nodePublishSecretRef")
    ] = None
    """
    nodePublishSecretRef is a reference to the secret object containing sensitive information to pass to the CSI driver to complete the CSI NodePublishVolume and NodeUnpublishVolume calls. This field is optional, and  may be empty if no secret is required. If the secret object contains more than one secret, all secret references are passed.
    """
    read_only: Annotated[Optional[bool], Field(alias="readOnly")] = None
    """
    readOnly specifies a read-only configuration for the volume. Defaults to false (read/write).
    """
    volume_attributes: Annotated[Optional[Dict[str, str]], Field(alias="volumeAttributes")] = None
    """
    volumeAttributes stores driver-specific properties that are passed to the CSI driver. Consult your driver's documentation for supported values.
    """


class CephFSPersistentVolumeSource(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["CephFSPersistentVolumeSource"]:
            return CephFSPersistentVolumeSource

        def build(self) -> "CephFSPersistentVolumeSource":
            return CephFSPersistentVolumeSource(**self._attrs)

        def monitors(self, value: List[str], /) -> Self:
            """
            monitors is Required: Monitors is a collection of Ceph monitors More info: https://examples.k8s.io/volumes/cephfs/README.md#how-to-use-it
            """
            return self._set("monitors", value)

        def path(self, value: Optional[str], /) -> Self:
            """
            path is Optional: Used as the mounted root, rather than the full Ceph tree, default is /
            """
            return self._set("path", value)

        def read_only(self, value: Optional[bool], /) -> Self:
            """
            readOnly is Optional: Defaults to false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts. More info: https://examples.k8s.io/volumes/cephfs/README.md#how-to-use-it
            """
            return self._set("read_only", value)

        def secret_file(self, value: Optional[str], /) -> Self:
            """
            secretFile is Optional: SecretFile is the path to key ring for User, default is /etc/ceph/user.secret More info: https://examples.k8s.io/volumes/cephfs/README.md#how-to-use-it
            """
            return self._set("secret_file", value)

        @overload
        def secret_ref(
            self, value_or_callback: Optional[SecretReference], /
        ) -> "CephFSPersistentVolumeSource.Builder": ...

        @overload
        def secret_ref(
            self,
            value_or_callback: Callable[
                [SecretReference.Builder], SecretReference.Builder | SecretReference
            ],
            /,
        ) -> "CephFSPersistentVolumeSource.Builder": ...

        @overload
        def secret_ref(
            self, value_or_callback: Never = ...
        ) -> "SecretReference.BuilderContext": ...

        def secret_ref(self, value_or_callback=None, /):
            """
            secretRef is Optional: SecretRef is reference to the authentication secret for User, default is empty. More info: https://examples.k8s.io/volumes/cephfs/README.md#how-to-use-it
            """
            if self._in_context and value_or_callback is None:
                context = SecretReference.BuilderContext()
                context._parent_builder = self
                context._field_name = "secret_ref"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(SecretReference.builder())
                if isinstance(output, SecretReference.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("secret_ref", value)

        def user(self, value: Optional[str], /) -> Self:
            """
            user is Optional: User is the rados user name, default is admin More info: https://examples.k8s.io/volumes/cephfs/README.md#how-to-use-it
            """
            return self._set("user", value)

    class BuilderContext(BuilderContextBase["CephFSPersistentVolumeSource.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = CephFSPersistentVolumeSource.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for CephFSPersistentVolumeSource."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["CephFSPersistentVolumeSource", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use CephFSPersistentVolumeSource.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    monitors: List[str]
    """
    monitors is Required: Monitors is a collection of Ceph monitors More info: https://examples.k8s.io/volumes/cephfs/README.md#how-to-use-it
    """
    path: Optional[str] = None
    """
    path is Optional: Used as the mounted root, rather than the full Ceph tree, default is /
    """
    read_only: Annotated[Optional[bool], Field(alias="readOnly")] = None
    """
    readOnly is Optional: Defaults to false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts. More info: https://examples.k8s.io/volumes/cephfs/README.md#how-to-use-it
    """
    secret_file: Annotated[Optional[str], Field(alias="secretFile")] = None
    """
    secretFile is Optional: SecretFile is the path to key ring for User, default is /etc/ceph/user.secret More info: https://examples.k8s.io/volumes/cephfs/README.md#how-to-use-it
    """
    secret_ref: Annotated[Optional[SecretReference], Field(alias="secretRef")] = None
    """
    secretRef is Optional: SecretRef is reference to the authentication secret for User, default is empty. More info: https://examples.k8s.io/volumes/cephfs/README.md#how-to-use-it
    """
    user: Optional[str] = None
    """
    user is Optional: User is the rados user name, default is admin More info: https://examples.k8s.io/volumes/cephfs/README.md#how-to-use-it
    """


class CephFSVolumeSource(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["CephFSVolumeSource"]:
            return CephFSVolumeSource

        def build(self) -> "CephFSVolumeSource":
            return CephFSVolumeSource(**self._attrs)

        def monitors(self, value: List[str], /) -> Self:
            """
            monitors is Required: Monitors is a collection of Ceph monitors More info: https://examples.k8s.io/volumes/cephfs/README.md#how-to-use-it
            """
            return self._set("monitors", value)

        def path(self, value: Optional[str], /) -> Self:
            """
            path is Optional: Used as the mounted root, rather than the full Ceph tree, default is /
            """
            return self._set("path", value)

        def read_only(self, value: Optional[bool], /) -> Self:
            """
            readOnly is Optional: Defaults to false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts. More info: https://examples.k8s.io/volumes/cephfs/README.md#how-to-use-it
            """
            return self._set("read_only", value)

        def secret_file(self, value: Optional[str], /) -> Self:
            """
            secretFile is Optional: SecretFile is the path to key ring for User, default is /etc/ceph/user.secret More info: https://examples.k8s.io/volumes/cephfs/README.md#how-to-use-it
            """
            return self._set("secret_file", value)

        @overload
        def secret_ref(
            self, value_or_callback: Optional[LocalObjectReference], /
        ) -> "CephFSVolumeSource.Builder": ...

        @overload
        def secret_ref(
            self,
            value_or_callback: Callable[
                [LocalObjectReference.Builder],
                LocalObjectReference.Builder | LocalObjectReference,
            ],
            /,
        ) -> "CephFSVolumeSource.Builder": ...

        @overload
        def secret_ref(
            self, value_or_callback: Never = ...
        ) -> "LocalObjectReference.BuilderContext": ...

        def secret_ref(self, value_or_callback=None, /):
            """
            secretRef is Optional: SecretRef is reference to the authentication secret for User, default is empty. More info: https://examples.k8s.io/volumes/cephfs/README.md#how-to-use-it
            """
            if self._in_context and value_or_callback is None:
                context = LocalObjectReference.BuilderContext()
                context._parent_builder = self
                context._field_name = "secret_ref"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(LocalObjectReference.builder())
                if isinstance(output, LocalObjectReference.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("secret_ref", value)

        def user(self, value: Optional[str], /) -> Self:
            """
            user is optional: User is the rados user name, default is admin More info: https://examples.k8s.io/volumes/cephfs/README.md#how-to-use-it
            """
            return self._set("user", value)

    class BuilderContext(BuilderContextBase["CephFSVolumeSource.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = CephFSVolumeSource.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for CephFSVolumeSource."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["CephFSVolumeSource", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use CephFSVolumeSource.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    monitors: List[str]
    """
    monitors is Required: Monitors is a collection of Ceph monitors More info: https://examples.k8s.io/volumes/cephfs/README.md#how-to-use-it
    """
    path: Optional[str] = None
    """
    path is Optional: Used as the mounted root, rather than the full Ceph tree, default is /
    """
    read_only: Annotated[Optional[bool], Field(alias="readOnly")] = None
    """
    readOnly is Optional: Defaults to false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts. More info: https://examples.k8s.io/volumes/cephfs/README.md#how-to-use-it
    """
    secret_file: Annotated[Optional[str], Field(alias="secretFile")] = None
    """
    secretFile is Optional: SecretFile is the path to key ring for User, default is /etc/ceph/user.secret More info: https://examples.k8s.io/volumes/cephfs/README.md#how-to-use-it
    """
    secret_ref: Annotated[Optional[LocalObjectReference], Field(alias="secretRef")] = None
    """
    secretRef is Optional: SecretRef is reference to the authentication secret for User, default is empty. More info: https://examples.k8s.io/volumes/cephfs/README.md#how-to-use-it
    """
    user: Optional[str] = None
    """
    user is optional: User is the rados user name, default is admin More info: https://examples.k8s.io/volumes/cephfs/README.md#how-to-use-it
    """


class CinderPersistentVolumeSource(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["CinderPersistentVolumeSource"]:
            return CinderPersistentVolumeSource

        def build(self) -> "CinderPersistentVolumeSource":
            return CinderPersistentVolumeSource(**self._attrs)

        def fs_type(self, value: Optional[str], /) -> Self:
            """
            fsType Filesystem type to mount. Must be a filesystem type supported by the host operating system. Examples: "ext4", "xfs", "ntfs". Implicitly inferred to be "ext4" if unspecified. More info: https://examples.k8s.io/mysql-cinder-pd/README.md
            """
            return self._set("fs_type", value)

        def read_only(self, value: Optional[bool], /) -> Self:
            """
            readOnly is Optional: Defaults to false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts. More info: https://examples.k8s.io/mysql-cinder-pd/README.md
            """
            return self._set("read_only", value)

        @overload
        def secret_ref(
            self, value_or_callback: Optional[SecretReference], /
        ) -> "CinderPersistentVolumeSource.Builder": ...

        @overload
        def secret_ref(
            self,
            value_or_callback: Callable[
                [SecretReference.Builder], SecretReference.Builder | SecretReference
            ],
            /,
        ) -> "CinderPersistentVolumeSource.Builder": ...

        @overload
        def secret_ref(
            self, value_or_callback: Never = ...
        ) -> "SecretReference.BuilderContext": ...

        def secret_ref(self, value_or_callback=None, /):
            """
            secretRef is Optional: points to a secret object containing parameters used to connect to OpenStack.
            """
            if self._in_context and value_or_callback is None:
                context = SecretReference.BuilderContext()
                context._parent_builder = self
                context._field_name = "secret_ref"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(SecretReference.builder())
                if isinstance(output, SecretReference.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("secret_ref", value)

        def volume_id(self, value: str, /) -> Self:
            """
            volumeID used to identify the volume in cinder. More info: https://examples.k8s.io/mysql-cinder-pd/README.md
            """
            return self._set("volume_id", value)

    class BuilderContext(BuilderContextBase["CinderPersistentVolumeSource.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = CinderPersistentVolumeSource.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for CinderPersistentVolumeSource."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["CinderPersistentVolumeSource", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use CinderPersistentVolumeSource.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    fs_type: Annotated[Optional[str], Field(alias="fsType")] = None
    """
    fsType Filesystem type to mount. Must be a filesystem type supported by the host operating system. Examples: "ext4", "xfs", "ntfs". Implicitly inferred to be "ext4" if unspecified. More info: https://examples.k8s.io/mysql-cinder-pd/README.md
    """
    read_only: Annotated[Optional[bool], Field(alias="readOnly")] = None
    """
    readOnly is Optional: Defaults to false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts. More info: https://examples.k8s.io/mysql-cinder-pd/README.md
    """
    secret_ref: Annotated[Optional[SecretReference], Field(alias="secretRef")] = None
    """
    secretRef is Optional: points to a secret object containing parameters used to connect to OpenStack.
    """
    volume_id: Annotated[str, Field(alias="volumeID")]
    """
    volumeID used to identify the volume in cinder. More info: https://examples.k8s.io/mysql-cinder-pd/README.md
    """


class CinderVolumeSource(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["CinderVolumeSource"]:
            return CinderVolumeSource

        def build(self) -> "CinderVolumeSource":
            return CinderVolumeSource(**self._attrs)

        def fs_type(self, value: Optional[str], /) -> Self:
            """
            fsType is the filesystem type to mount. Must be a filesystem type supported by the host operating system. Examples: "ext4", "xfs", "ntfs". Implicitly inferred to be "ext4" if unspecified. More info: https://examples.k8s.io/mysql-cinder-pd/README.md
            """
            return self._set("fs_type", value)

        def read_only(self, value: Optional[bool], /) -> Self:
            """
            readOnly defaults to false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts. More info: https://examples.k8s.io/mysql-cinder-pd/README.md
            """
            return self._set("read_only", value)

        @overload
        def secret_ref(
            self, value_or_callback: Optional[LocalObjectReference], /
        ) -> "CinderVolumeSource.Builder": ...

        @overload
        def secret_ref(
            self,
            value_or_callback: Callable[
                [LocalObjectReference.Builder],
                LocalObjectReference.Builder | LocalObjectReference,
            ],
            /,
        ) -> "CinderVolumeSource.Builder": ...

        @overload
        def secret_ref(
            self, value_or_callback: Never = ...
        ) -> "LocalObjectReference.BuilderContext": ...

        def secret_ref(self, value_or_callback=None, /):
            """
            secretRef is optional: points to a secret object containing parameters used to connect to OpenStack.
            """
            if self._in_context and value_or_callback is None:
                context = LocalObjectReference.BuilderContext()
                context._parent_builder = self
                context._field_name = "secret_ref"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(LocalObjectReference.builder())
                if isinstance(output, LocalObjectReference.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("secret_ref", value)

        def volume_id(self, value: str, /) -> Self:
            """
            volumeID used to identify the volume in cinder. More info: https://examples.k8s.io/mysql-cinder-pd/README.md
            """
            return self._set("volume_id", value)

    class BuilderContext(BuilderContextBase["CinderVolumeSource.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = CinderVolumeSource.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for CinderVolumeSource."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["CinderVolumeSource", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use CinderVolumeSource.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    fs_type: Annotated[Optional[str], Field(alias="fsType")] = None
    """
    fsType is the filesystem type to mount. Must be a filesystem type supported by the host operating system. Examples: "ext4", "xfs", "ntfs". Implicitly inferred to be "ext4" if unspecified. More info: https://examples.k8s.io/mysql-cinder-pd/README.md
    """
    read_only: Annotated[Optional[bool], Field(alias="readOnly")] = None
    """
    readOnly defaults to false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts. More info: https://examples.k8s.io/mysql-cinder-pd/README.md
    """
    secret_ref: Annotated[Optional[LocalObjectReference], Field(alias="secretRef")] = None
    """
    secretRef is optional: points to a secret object containing parameters used to connect to OpenStack.
    """
    volume_id: Annotated[str, Field(alias="volumeID")]
    """
    volumeID used to identify the volume in cinder. More info: https://examples.k8s.io/mysql-cinder-pd/README.md
    """


class ConfigMapProjection(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["ConfigMapProjection"]:
            return ConfigMapProjection

        def build(self) -> "ConfigMapProjection":
            return ConfigMapProjection(**self._attrs)

        @overload
        def items(self, value_or_callback: List[KeyToPath], /) -> "ConfigMapProjection.Builder": ...

        @overload
        def items(
            self,
            value_or_callback: Callable[
                [GenericListBuilder[KeyToPath, KeyToPath.Builder]],
                GenericListBuilder[KeyToPath, KeyToPath.Builder] | List[KeyToPath],
            ],
            /,
        ) -> "ConfigMapProjection.Builder": ...

        @overload
        def items(
            self, value_or_callback: Never = ...
        ) -> ListBuilderContext[KeyToPath.Builder]: ...

        def items(self, value_or_callback=None, /):
            """
            items if unspecified, each key-value pair in the Data field of the referenced ConfigMap will be projected into the volume as a file whose name is the key and content is the value. If specified, the listed keys will be projected into the specified paths, and unlisted keys will not be present. If a key is specified which is not present in the ConfigMap, the volume setup will error unless it is marked optional. Paths must be relative and may not contain the '..' path or start with '..'.
            """
            if self._in_context and value_or_callback is None:
                context = ListBuilderContext[KeyToPath.Builder]()
                context._parent_builder = self
                context._field_name = "items"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(KeyToPath.list_builder())
                if isinstance(output, GenericListBuilder):
                    value = output.build()
                else:
                    value = output
            return self._set("items", value)

        def name(self, value: Optional[str], /) -> Self:
            """
            Name of the referent. This field is effectively required, but due to backwards compatibility is allowed to be empty. Instances of this type with an empty value here are almost certainly wrong. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names
            """
            return self._set("name", value)

        def optional(self, value: Optional[bool], /) -> Self:
            """
            optional specify whether the ConfigMap or its keys must be defined
            """
            return self._set("optional", value)

    class BuilderContext(BuilderContextBase["ConfigMapProjection.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = ConfigMapProjection.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for ConfigMapProjection."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["ConfigMapProjection", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use ConfigMapProjection.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    items: Optional[List[KeyToPath]] = None
    """
    items if unspecified, each key-value pair in the Data field of the referenced ConfigMap will be projected into the volume as a file whose name is the key and content is the value. If specified, the listed keys will be projected into the specified paths, and unlisted keys will not be present. If a key is specified which is not present in the ConfigMap, the volume setup will error unless it is marked optional. Paths must be relative and may not contain the '..' path or start with '..'.
    """
    name: Optional[str] = None
    """
    Name of the referent. This field is effectively required, but due to backwards compatibility is allowed to be empty. Instances of this type with an empty value here are almost certainly wrong. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names
    """
    optional: Optional[bool] = None
    """
    optional specify whether the ConfigMap or its keys must be defined
    """


class ConfigMapVolumeSource(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["ConfigMapVolumeSource"]:
            return ConfigMapVolumeSource

        def build(self) -> "ConfigMapVolumeSource":
            return ConfigMapVolumeSource(**self._attrs)

        def default_mode(self, value: Optional[int], /) -> Self:
            """
            defaultMode is optional: mode bits used to set permissions on created files by default. Must be an octal value between 0000 and 0777 or a decimal value between 0 and 511. YAML accepts both octal and decimal values, JSON requires decimal values for mode bits. Defaults to 0644. Directories within the path are not affected by this setting. This might be in conflict with other options that affect the file mode, like fsGroup, and the result can be other mode bits set.
            """
            return self._set("default_mode", value)

        @overload
        def items(
            self, value_or_callback: List[KeyToPath], /
        ) -> "ConfigMapVolumeSource.Builder": ...

        @overload
        def items(
            self,
            value_or_callback: Callable[
                [GenericListBuilder[KeyToPath, KeyToPath.Builder]],
                GenericListBuilder[KeyToPath, KeyToPath.Builder] | List[KeyToPath],
            ],
            /,
        ) -> "ConfigMapVolumeSource.Builder": ...

        @overload
        def items(
            self, value_or_callback: Never = ...
        ) -> ListBuilderContext[KeyToPath.Builder]: ...

        def items(self, value_or_callback=None, /):
            """
            items if unspecified, each key-value pair in the Data field of the referenced ConfigMap will be projected into the volume as a file whose name is the key and content is the value. If specified, the listed keys will be projected into the specified paths, and unlisted keys will not be present. If a key is specified which is not present in the ConfigMap, the volume setup will error unless it is marked optional. Paths must be relative and may not contain the '..' path or start with '..'.
            """
            if self._in_context and value_or_callback is None:
                context = ListBuilderContext[KeyToPath.Builder]()
                context._parent_builder = self
                context._field_name = "items"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(KeyToPath.list_builder())
                if isinstance(output, GenericListBuilder):
                    value = output.build()
                else:
                    value = output
            return self._set("items", value)

        def name(self, value: Optional[str], /) -> Self:
            """
            Name of the referent. This field is effectively required, but due to backwards compatibility is allowed to be empty. Instances of this type with an empty value here are almost certainly wrong. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names
            """
            return self._set("name", value)

        def optional(self, value: Optional[bool], /) -> Self:
            """
            optional specify whether the ConfigMap or its keys must be defined
            """
            return self._set("optional", value)

    class BuilderContext(BuilderContextBase["ConfigMapVolumeSource.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = ConfigMapVolumeSource.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for ConfigMapVolumeSource."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["ConfigMapVolumeSource", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use ConfigMapVolumeSource.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    default_mode: Annotated[Optional[int], Field(alias="defaultMode")] = None
    """
    defaultMode is optional: mode bits used to set permissions on created files by default. Must be an octal value between 0000 and 0777 or a decimal value between 0 and 511. YAML accepts both octal and decimal values, JSON requires decimal values for mode bits. Defaults to 0644. Directories within the path are not affected by this setting. This might be in conflict with other options that affect the file mode, like fsGroup, and the result can be other mode bits set.
    """
    items: Optional[List[KeyToPath]] = None
    """
    items if unspecified, each key-value pair in the Data field of the referenced ConfigMap will be projected into the volume as a file whose name is the key and content is the value. If specified, the listed keys will be projected into the specified paths, and unlisted keys will not be present. If a key is specified which is not present in the ConfigMap, the volume setup will error unless it is marked optional. Paths must be relative and may not contain the '..' path or start with '..'.
    """
    name: Optional[str] = None
    """
    Name of the referent. This field is effectively required, but due to backwards compatibility is allowed to be empty. Instances of this type with an empty value here are almost certainly wrong. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names
    """
    optional: Optional[bool] = None
    """
    optional specify whether the ConfigMap or its keys must be defined
    """


class ContainerStateRunning(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["ContainerStateRunning"]:
            return ContainerStateRunning

        def build(self) -> "ContainerStateRunning":
            return ContainerStateRunning(**self._attrs)

        @overload
        def started_at(
            self, value_or_callback: Optional[apimachinery.Time], /
        ) -> "ContainerStateRunning.Builder": ...

        @overload
        def started_at(
            self,
            value_or_callback: Callable[
                [apimachinery.Time.Builder],
                apimachinery.Time.Builder | apimachinery.Time,
            ],
            /,
        ) -> "ContainerStateRunning.Builder": ...

        @overload
        def started_at(
            self, value_or_callback: Never = ...
        ) -> "apimachinery.Time.BuilderContext": ...

        def started_at(self, value_or_callback=None, /):
            """
            Time at which the container was last (re-)started
            """
            if self._in_context and value_or_callback is None:
                context = apimachinery.Time.BuilderContext()
                context._parent_builder = self
                context._field_name = "started_at"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(apimachinery.Time.builder())
                if isinstance(output, apimachinery.Time.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("started_at", value)

    class BuilderContext(BuilderContextBase["ContainerStateRunning.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = ContainerStateRunning.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for ContainerStateRunning."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["ContainerStateRunning", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use ContainerStateRunning.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    started_at: Annotated[Optional[apimachinery.Time], Field(alias="startedAt")] = None
    """
    Time at which the container was last (re-)started
    """


class ContainerStateTerminated(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["ContainerStateTerminated"]:
            return ContainerStateTerminated

        def build(self) -> "ContainerStateTerminated":
            return ContainerStateTerminated(**self._attrs)

        def container_id(self, value: Optional[str], /) -> Self:
            """
            Container's ID in the format '<type>://<container_id>'
            """
            return self._set("container_id", value)

        def exit_code(self, value: int, /) -> Self:
            """
            Exit status from the last termination of the container
            """
            return self._set("exit_code", value)

        @overload
        def finished_at(
            self, value_or_callback: Optional[apimachinery.Time], /
        ) -> "ContainerStateTerminated.Builder": ...

        @overload
        def finished_at(
            self,
            value_or_callback: Callable[
                [apimachinery.Time.Builder],
                apimachinery.Time.Builder | apimachinery.Time,
            ],
            /,
        ) -> "ContainerStateTerminated.Builder": ...

        @overload
        def finished_at(
            self, value_or_callback: Never = ...
        ) -> "apimachinery.Time.BuilderContext": ...

        def finished_at(self, value_or_callback=None, /):
            """
            Time at which the container last terminated
            """
            if self._in_context and value_or_callback is None:
                context = apimachinery.Time.BuilderContext()
                context._parent_builder = self
                context._field_name = "finished_at"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(apimachinery.Time.builder())
                if isinstance(output, apimachinery.Time.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("finished_at", value)

        def message(self, value: Optional[str], /) -> Self:
            """
            Message regarding the last termination of the container
            """
            return self._set("message", value)

        def reason(self, value: Optional[str], /) -> Self:
            """
            (brief) reason from the last termination of the container
            """
            return self._set("reason", value)

        def signal(self, value: Optional[int], /) -> Self:
            """
            Signal from the last termination of the container
            """
            return self._set("signal", value)

        @overload
        def started_at(
            self, value_or_callback: Optional[apimachinery.Time], /
        ) -> "ContainerStateTerminated.Builder": ...

        @overload
        def started_at(
            self,
            value_or_callback: Callable[
                [apimachinery.Time.Builder],
                apimachinery.Time.Builder | apimachinery.Time,
            ],
            /,
        ) -> "ContainerStateTerminated.Builder": ...

        @overload
        def started_at(
            self, value_or_callback: Never = ...
        ) -> "apimachinery.Time.BuilderContext": ...

        def started_at(self, value_or_callback=None, /):
            """
            Time at which previous execution of the container started
            """
            if self._in_context and value_or_callback is None:
                context = apimachinery.Time.BuilderContext()
                context._parent_builder = self
                context._field_name = "started_at"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(apimachinery.Time.builder())
                if isinstance(output, apimachinery.Time.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("started_at", value)

    class BuilderContext(BuilderContextBase["ContainerStateTerminated.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = ContainerStateTerminated.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for ContainerStateTerminated."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["ContainerStateTerminated", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use ContainerStateTerminated.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    container_id: Annotated[Optional[str], Field(alias="containerID")] = None
    """
    Container's ID in the format '<type>://<container_id>'
    """
    exit_code: Annotated[int, Field(alias="exitCode")]
    """
    Exit status from the last termination of the container
    """
    finished_at: Annotated[Optional[apimachinery.Time], Field(alias="finishedAt")] = None
    """
    Time at which the container last terminated
    """
    message: Optional[str] = None
    """
    Message regarding the last termination of the container
    """
    reason: Optional[str] = None
    """
    (brief) reason from the last termination of the container
    """
    signal: Optional[int] = None
    """
    Signal from the last termination of the container
    """
    started_at: Annotated[Optional[apimachinery.Time], Field(alias="startedAt")] = None
    """
    Time at which previous execution of the container started
    """


class ContainerUser(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["ContainerUser"]:
            return ContainerUser

        def build(self) -> "ContainerUser":
            return ContainerUser(**self._attrs)

        @overload
        def linux(
            self, value_or_callback: Optional[LinuxContainerUser], /
        ) -> "ContainerUser.Builder": ...

        @overload
        def linux(
            self,
            value_or_callback: Callable[
                [LinuxContainerUser.Builder],
                LinuxContainerUser.Builder | LinuxContainerUser,
            ],
            /,
        ) -> "ContainerUser.Builder": ...

        @overload
        def linux(self, value_or_callback: Never = ...) -> "LinuxContainerUser.BuilderContext": ...

        def linux(self, value_or_callback=None, /):
            """
            Linux holds user identity information initially attached to the first process of the containers in Linux. Note that the actual running identity can be changed if the process has enough privilege to do so.
            """
            if self._in_context and value_or_callback is None:
                context = LinuxContainerUser.BuilderContext()
                context._parent_builder = self
                context._field_name = "linux"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(LinuxContainerUser.builder())
                if isinstance(output, LinuxContainerUser.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("linux", value)

    class BuilderContext(BuilderContextBase["ContainerUser.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = ContainerUser.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for ContainerUser."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["ContainerUser", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use ContainerUser.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    linux: Optional[LinuxContainerUser] = None
    """
    Linux holds user identity information initially attached to the first process of the containers in Linux. Note that the actual running identity can be changed if the process has enough privilege to do so.
    """


class EmptyDirVolumeSource(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["EmptyDirVolumeSource"]:
            return EmptyDirVolumeSource

        def build(self) -> "EmptyDirVolumeSource":
            return EmptyDirVolumeSource(**self._attrs)

        def medium(self, value: Optional[str], /) -> Self:
            """
            medium represents what type of storage medium should back this directory. The default is "" which means to use the node's default medium. Must be an empty string (default) or Memory. More info: https://kubernetes.io/docs/concepts/storage/volumes#emptydir
            """
            return self._set("medium", value)

        @overload
        def size_limit(
            self, value_or_callback: Optional[apimachinery.Quantity], /
        ) -> "EmptyDirVolumeSource.Builder": ...

        @overload
        def size_limit(
            self,
            value_or_callback: Callable[
                [apimachinery.Quantity.Builder],
                apimachinery.Quantity.Builder | apimachinery.Quantity,
            ],
            /,
        ) -> "EmptyDirVolumeSource.Builder": ...

        @overload
        def size_limit(
            self, value_or_callback: Never = ...
        ) -> "apimachinery.Quantity.BuilderContext": ...

        def size_limit(self, value_or_callback=None, /):
            """
            sizeLimit is the total amount of local storage required for this EmptyDir volume. The size limit is also applicable for memory medium. The maximum usage on memory medium EmptyDir would be the minimum value between the SizeLimit specified here and the sum of memory limits of all containers in a pod. The default is nil which means that the limit is undefined. More info: https://kubernetes.io/docs/concepts/storage/volumes#emptydir
            """
            if self._in_context and value_or_callback is None:
                context = apimachinery.Quantity.BuilderContext()
                context._parent_builder = self
                context._field_name = "size_limit"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(apimachinery.Quantity.builder())
                if isinstance(output, apimachinery.Quantity.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("size_limit", value)

    class BuilderContext(BuilderContextBase["EmptyDirVolumeSource.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = EmptyDirVolumeSource.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for EmptyDirVolumeSource."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["EmptyDirVolumeSource", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use EmptyDirVolumeSource.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    medium: Optional[str] = None
    """
    medium represents what type of storage medium should back this directory. The default is "" which means to use the node's default medium. Must be an empty string (default) or Memory. More info: https://kubernetes.io/docs/concepts/storage/volumes#emptydir
    """
    size_limit: Annotated[Optional[apimachinery.Quantity], Field(alias="sizeLimit")] = None
    """
    sizeLimit is the total amount of local storage required for this EmptyDir volume. The size limit is also applicable for memory medium. The maximum usage on memory medium EmptyDir would be the minimum value between the SizeLimit specified here and the sum of memory limits of all containers in a pod. The default is nil which means that the limit is undefined. More info: https://kubernetes.io/docs/concepts/storage/volumes#emptydir
    """


class EndpointAddress(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["EndpointAddress"]:
            return EndpointAddress

        def build(self) -> "EndpointAddress":
            return EndpointAddress(**self._attrs)

        def hostname(self, value: Optional[str], /) -> Self:
            """
            The Hostname of this endpoint
            """
            return self._set("hostname", value)

        def ip(self, value: str, /) -> Self:
            """
            The IP of this endpoint. May not be loopback (127.0.0.0/8 or ::1), link-local (169.254.0.0/16 or fe80::/10), or link-local multicast (224.0.0.0/24 or ff02::/16).
            """
            return self._set("ip", value)

        def node_name(self, value: Optional[str], /) -> Self:
            """
            Optional: Node hosting this endpoint. This can be used to determine endpoints local to a node.
            """
            return self._set("node_name", value)

        @overload
        def target_ref(
            self, value_or_callback: Optional[ObjectReference], /
        ) -> "EndpointAddress.Builder": ...

        @overload
        def target_ref(
            self,
            value_or_callback: Callable[
                [ObjectReference.Builder], ObjectReference.Builder | ObjectReference
            ],
            /,
        ) -> "EndpointAddress.Builder": ...

        @overload
        def target_ref(
            self, value_or_callback: Never = ...
        ) -> "ObjectReference.BuilderContext": ...

        def target_ref(self, value_or_callback=None, /):
            """
            Reference to object providing the endpoint.
            """
            if self._in_context and value_or_callback is None:
                context = ObjectReference.BuilderContext()
                context._parent_builder = self
                context._field_name = "target_ref"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(ObjectReference.builder())
                if isinstance(output, ObjectReference.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("target_ref", value)

    class BuilderContext(BuilderContextBase["EndpointAddress.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = EndpointAddress.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for EndpointAddress."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["EndpointAddress", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use EndpointAddress.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    hostname: Optional[str] = None
    """
    The Hostname of this endpoint
    """
    ip: str
    """
    The IP of this endpoint. May not be loopback (127.0.0.0/8 or ::1), link-local (169.254.0.0/16 or fe80::/10), or link-local multicast (224.0.0.0/24 or ff02::/16).
    """
    node_name: Annotated[Optional[str], Field(alias="nodeName")] = None
    """
    Optional: Node hosting this endpoint. This can be used to determine endpoints local to a node.
    """
    target_ref: Annotated[Optional[ObjectReference], Field(alias="targetRef")] = None
    """
    Reference to object providing the endpoint.
    """


class EndpointSubset(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["EndpointSubset"]:
            return EndpointSubset

        def build(self) -> "EndpointSubset":
            return EndpointSubset(**self._attrs)

        @overload
        def addresses(
            self, value_or_callback: List[EndpointAddress], /
        ) -> "EndpointSubset.Builder": ...

        @overload
        def addresses(
            self,
            value_or_callback: Callable[
                [GenericListBuilder[EndpointAddress, EndpointAddress.Builder]],
                GenericListBuilder[EndpointAddress, EndpointAddress.Builder]
                | List[EndpointAddress],
            ],
            /,
        ) -> "EndpointSubset.Builder": ...

        @overload
        def addresses(
            self, value_or_callback: Never = ...
        ) -> ListBuilderContext[EndpointAddress.Builder]: ...

        def addresses(self, value_or_callback=None, /):
            """
            IP addresses which offer the related ports that are marked as ready. These endpoints should be considered safe for load balancers and clients to utilize.
            """
            if self._in_context and value_or_callback is None:
                context = ListBuilderContext[EndpointAddress.Builder]()
                context._parent_builder = self
                context._field_name = "addresses"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(EndpointAddress.list_builder())
                if isinstance(output, GenericListBuilder):
                    value = output.build()
                else:
                    value = output
            return self._set("addresses", value)

        @overload
        def not_ready_addresses(
            self, value_or_callback: List[EndpointAddress], /
        ) -> "EndpointSubset.Builder": ...

        @overload
        def not_ready_addresses(
            self,
            value_or_callback: Callable[
                [GenericListBuilder[EndpointAddress, EndpointAddress.Builder]],
                GenericListBuilder[EndpointAddress, EndpointAddress.Builder]
                | List[EndpointAddress],
            ],
            /,
        ) -> "EndpointSubset.Builder": ...

        @overload
        def not_ready_addresses(
            self, value_or_callback: Never = ...
        ) -> ListBuilderContext[EndpointAddress.Builder]: ...

        def not_ready_addresses(self, value_or_callback=None, /):
            """
            IP addresses which offer the related ports but are not currently marked as ready because they have not yet finished starting, have recently failed a readiness check, or have recently failed a liveness check.
            """
            if self._in_context and value_or_callback is None:
                context = ListBuilderContext[EndpointAddress.Builder]()
                context._parent_builder = self
                context._field_name = "not_ready_addresses"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(EndpointAddress.list_builder())
                if isinstance(output, GenericListBuilder):
                    value = output.build()
                else:
                    value = output
            return self._set("not_ready_addresses", value)

        @overload
        def ports(self, value_or_callback: List[EndpointPort], /) -> "EndpointSubset.Builder": ...

        @overload
        def ports(
            self,
            value_or_callback: Callable[
                [GenericListBuilder[EndpointPort, EndpointPort.Builder]],
                GenericListBuilder[EndpointPort, EndpointPort.Builder] | List[EndpointPort],
            ],
            /,
        ) -> "EndpointSubset.Builder": ...

        @overload
        def ports(
            self, value_or_callback: Never = ...
        ) -> ListBuilderContext[EndpointPort.Builder]: ...

        def ports(self, value_or_callback=None, /):
            """
            Port numbers available on the related IP addresses.
            """
            if self._in_context and value_or_callback is None:
                context = ListBuilderContext[EndpointPort.Builder]()
                context._parent_builder = self
                context._field_name = "ports"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(EndpointPort.list_builder())
                if isinstance(output, GenericListBuilder):
                    value = output.build()
                else:
                    value = output
            return self._set("ports", value)

    class BuilderContext(BuilderContextBase["EndpointSubset.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = EndpointSubset.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for EndpointSubset."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["EndpointSubset", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use EndpointSubset.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    addresses: Optional[List[EndpointAddress]] = None
    """
    IP addresses which offer the related ports that are marked as ready. These endpoints should be considered safe for load balancers and clients to utilize.
    """
    not_ready_addresses: Annotated[
        Optional[List[EndpointAddress]], Field(alias="notReadyAddresses")
    ] = None
    """
    IP addresses which offer the related ports but are not currently marked as ready because they have not yet finished starting, have recently failed a readiness check, or have recently failed a liveness check.
    """
    ports: Optional[List[EndpointPort]] = None
    """
    Port numbers available on the related IP addresses.
    """


class EnvFromSource(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["EnvFromSource"]:
            return EnvFromSource

        def build(self) -> "EnvFromSource":
            return EnvFromSource(**self._attrs)

        @overload
        def config_map_ref(
            self, value_or_callback: Optional[ConfigMapEnvSource], /
        ) -> "EnvFromSource.Builder": ...

        @overload
        def config_map_ref(
            self,
            value_or_callback: Callable[
                [ConfigMapEnvSource.Builder],
                ConfigMapEnvSource.Builder | ConfigMapEnvSource,
            ],
            /,
        ) -> "EnvFromSource.Builder": ...

        @overload
        def config_map_ref(
            self, value_or_callback: Never = ...
        ) -> "ConfigMapEnvSource.BuilderContext": ...

        def config_map_ref(self, value_or_callback=None, /):
            """
            The ConfigMap to select from
            """
            if self._in_context and value_or_callback is None:
                context = ConfigMapEnvSource.BuilderContext()
                context._parent_builder = self
                context._field_name = "config_map_ref"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(ConfigMapEnvSource.builder())
                if isinstance(output, ConfigMapEnvSource.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("config_map_ref", value)

        def prefix(self, value: Optional[str], /) -> Self:
            """
            An optional identifier to prepend to each key in the ConfigMap. Must be a C_IDENTIFIER.
            """
            return self._set("prefix", value)

        @overload
        def secret_ref(
            self, value_or_callback: Optional[SecretEnvSource], /
        ) -> "EnvFromSource.Builder": ...

        @overload
        def secret_ref(
            self,
            value_or_callback: Callable[
                [SecretEnvSource.Builder], SecretEnvSource.Builder | SecretEnvSource
            ],
            /,
        ) -> "EnvFromSource.Builder": ...

        @overload
        def secret_ref(
            self, value_or_callback: Never = ...
        ) -> "SecretEnvSource.BuilderContext": ...

        def secret_ref(self, value_or_callback=None, /):
            """
            The Secret to select from
            """
            if self._in_context and value_or_callback is None:
                context = SecretEnvSource.BuilderContext()
                context._parent_builder = self
                context._field_name = "secret_ref"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(SecretEnvSource.builder())
                if isinstance(output, SecretEnvSource.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("secret_ref", value)

    class BuilderContext(BuilderContextBase["EnvFromSource.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = EnvFromSource.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for EnvFromSource."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["EnvFromSource", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use EnvFromSource.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    config_map_ref: Annotated[Optional[ConfigMapEnvSource], Field(alias="configMapRef")] = None
    """
    The ConfigMap to select from
    """
    prefix: Optional[str] = None
    """
    An optional identifier to prepend to each key in the ConfigMap. Must be a C_IDENTIFIER.
    """
    secret_ref: Annotated[Optional[SecretEnvSource], Field(alias="secretRef")] = None
    """
    The Secret to select from
    """


class EventSeries(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["EventSeries"]:
            return EventSeries

        def build(self) -> "EventSeries":
            return EventSeries(**self._attrs)

        def count(self, value: Optional[int], /) -> Self:
            """
            Number of occurrences in this series up to the last heartbeat time
            """
            return self._set("count", value)

        @overload
        def last_observed_time(
            self, value_or_callback: Optional[apimachinery.MicroTime], /
        ) -> "EventSeries.Builder": ...

        @overload
        def last_observed_time(
            self,
            value_or_callback: Callable[
                [apimachinery.MicroTime.Builder],
                apimachinery.MicroTime.Builder | apimachinery.MicroTime,
            ],
            /,
        ) -> "EventSeries.Builder": ...

        @overload
        def last_observed_time(
            self, value_or_callback: Never = ...
        ) -> "apimachinery.MicroTime.BuilderContext": ...

        def last_observed_time(self, value_or_callback=None, /):
            """
            Time of the last occurrence observed
            """
            if self._in_context and value_or_callback is None:
                context = apimachinery.MicroTime.BuilderContext()
                context._parent_builder = self
                context._field_name = "last_observed_time"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(apimachinery.MicroTime.builder())
                if isinstance(output, apimachinery.MicroTime.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("last_observed_time", value)

    class BuilderContext(BuilderContextBase["EventSeries.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = EventSeries.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for EventSeries."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["EventSeries", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use EventSeries.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    count: Optional[int] = None
    """
    Number of occurrences in this series up to the last heartbeat time
    """
    last_observed_time: Annotated[
        Optional[apimachinery.MicroTime], Field(alias="lastObservedTime")
    ] = None
    """
    Time of the last occurrence observed
    """


class FlexPersistentVolumeSource(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["FlexPersistentVolumeSource"]:
            return FlexPersistentVolumeSource

        def build(self) -> "FlexPersistentVolumeSource":
            return FlexPersistentVolumeSource(**self._attrs)

        def driver(self, value: str, /) -> Self:
            """
            driver is the name of the driver to use for this volume.
            """
            return self._set("driver", value)

        def fs_type(self, value: Optional[str], /) -> Self:
            """
            fsType is the Filesystem type to mount. Must be a filesystem type supported by the host operating system. Ex. "ext4", "xfs", "ntfs". The default filesystem depends on FlexVolume script.
            """
            return self._set("fs_type", value)

        def options(self, value: Optional[Dict[str, str]], /) -> Self:
            """
            options is Optional: this field holds extra command options if any.
            """
            return self._set("options", value)

        def read_only(self, value: Optional[bool], /) -> Self:
            """
            readOnly is Optional: defaults to false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts.
            """
            return self._set("read_only", value)

        @overload
        def secret_ref(
            self, value_or_callback: Optional[SecretReference], /
        ) -> "FlexPersistentVolumeSource.Builder": ...

        @overload
        def secret_ref(
            self,
            value_or_callback: Callable[
                [SecretReference.Builder], SecretReference.Builder | SecretReference
            ],
            /,
        ) -> "FlexPersistentVolumeSource.Builder": ...

        @overload
        def secret_ref(
            self, value_or_callback: Never = ...
        ) -> "SecretReference.BuilderContext": ...

        def secret_ref(self, value_or_callback=None, /):
            """
            secretRef is Optional: SecretRef is reference to the secret object containing sensitive information to pass to the plugin scripts. This may be empty if no secret object is specified. If the secret object contains more than one secret, all secrets are passed to the plugin scripts.
            """
            if self._in_context and value_or_callback is None:
                context = SecretReference.BuilderContext()
                context._parent_builder = self
                context._field_name = "secret_ref"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(SecretReference.builder())
                if isinstance(output, SecretReference.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("secret_ref", value)

    class BuilderContext(BuilderContextBase["FlexPersistentVolumeSource.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = FlexPersistentVolumeSource.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for FlexPersistentVolumeSource."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["FlexPersistentVolumeSource", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use FlexPersistentVolumeSource.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    driver: str
    """
    driver is the name of the driver to use for this volume.
    """
    fs_type: Annotated[Optional[str], Field(alias="fsType")] = None
    """
    fsType is the Filesystem type to mount. Must be a filesystem type supported by the host operating system. Ex. "ext4", "xfs", "ntfs". The default filesystem depends on FlexVolume script.
    """
    options: Optional[Dict[str, str]] = None
    """
    options is Optional: this field holds extra command options if any.
    """
    read_only: Annotated[Optional[bool], Field(alias="readOnly")] = None
    """
    readOnly is Optional: defaults to false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts.
    """
    secret_ref: Annotated[Optional[SecretReference], Field(alias="secretRef")] = None
    """
    secretRef is Optional: SecretRef is reference to the secret object containing sensitive information to pass to the plugin scripts. This may be empty if no secret object is specified. If the secret object contains more than one secret, all secrets are passed to the plugin scripts.
    """


class FlexVolumeSource(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["FlexVolumeSource"]:
            return FlexVolumeSource

        def build(self) -> "FlexVolumeSource":
            return FlexVolumeSource(**self._attrs)

        def driver(self, value: str, /) -> Self:
            """
            driver is the name of the driver to use for this volume.
            """
            return self._set("driver", value)

        def fs_type(self, value: Optional[str], /) -> Self:
            """
            fsType is the filesystem type to mount. Must be a filesystem type supported by the host operating system. Ex. "ext4", "xfs", "ntfs". The default filesystem depends on FlexVolume script.
            """
            return self._set("fs_type", value)

        def options(self, value: Optional[Dict[str, str]], /) -> Self:
            """
            options is Optional: this field holds extra command options if any.
            """
            return self._set("options", value)

        def read_only(self, value: Optional[bool], /) -> Self:
            """
            readOnly is Optional: defaults to false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts.
            """
            return self._set("read_only", value)

        @overload
        def secret_ref(
            self, value_or_callback: Optional[LocalObjectReference], /
        ) -> "FlexVolumeSource.Builder": ...

        @overload
        def secret_ref(
            self,
            value_or_callback: Callable[
                [LocalObjectReference.Builder],
                LocalObjectReference.Builder | LocalObjectReference,
            ],
            /,
        ) -> "FlexVolumeSource.Builder": ...

        @overload
        def secret_ref(
            self, value_or_callback: Never = ...
        ) -> "LocalObjectReference.BuilderContext": ...

        def secret_ref(self, value_or_callback=None, /):
            """
            secretRef is Optional: secretRef is reference to the secret object containing sensitive information to pass to the plugin scripts. This may be empty if no secret object is specified. If the secret object contains more than one secret, all secrets are passed to the plugin scripts.
            """
            if self._in_context and value_or_callback is None:
                context = LocalObjectReference.BuilderContext()
                context._parent_builder = self
                context._field_name = "secret_ref"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(LocalObjectReference.builder())
                if isinstance(output, LocalObjectReference.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("secret_ref", value)

    class BuilderContext(BuilderContextBase["FlexVolumeSource.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = FlexVolumeSource.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for FlexVolumeSource."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["FlexVolumeSource", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use FlexVolumeSource.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    driver: str
    """
    driver is the name of the driver to use for this volume.
    """
    fs_type: Annotated[Optional[str], Field(alias="fsType")] = None
    """
    fsType is the filesystem type to mount. Must be a filesystem type supported by the host operating system. Ex. "ext4", "xfs", "ntfs". The default filesystem depends on FlexVolume script.
    """
    options: Optional[Dict[str, str]] = None
    """
    options is Optional: this field holds extra command options if any.
    """
    read_only: Annotated[Optional[bool], Field(alias="readOnly")] = None
    """
    readOnly is Optional: defaults to false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts.
    """
    secret_ref: Annotated[Optional[LocalObjectReference], Field(alias="secretRef")] = None
    """
    secretRef is Optional: secretRef is reference to the secret object containing sensitive information to pass to the plugin scripts. This may be empty if no secret object is specified. If the secret object contains more than one secret, all secrets are passed to the plugin scripts.
    """


class HTTPGetAction(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["HTTPGetAction"]:
            return HTTPGetAction

        def build(self) -> "HTTPGetAction":
            return HTTPGetAction(**self._attrs)

        def host(self, value: Optional[str], /) -> Self:
            """
            Host name to connect to, defaults to the pod IP. You probably want to set "Host" in httpHeaders instead.
            """
            return self._set("host", value)

        @overload
        def http_headers(
            self, value_or_callback: List[HTTPHeader], /
        ) -> "HTTPGetAction.Builder": ...

        @overload
        def http_headers(
            self,
            value_or_callback: Callable[
                [GenericListBuilder[HTTPHeader, HTTPHeader.Builder]],
                GenericListBuilder[HTTPHeader, HTTPHeader.Builder] | List[HTTPHeader],
            ],
            /,
        ) -> "HTTPGetAction.Builder": ...

        @overload
        def http_headers(
            self, value_or_callback: Never = ...
        ) -> ListBuilderContext[HTTPHeader.Builder]: ...

        def http_headers(self, value_or_callback=None, /):
            """
            Custom headers to set in the request. HTTP allows repeated headers.
            """
            if self._in_context and value_or_callback is None:
                context = ListBuilderContext[HTTPHeader.Builder]()
                context._parent_builder = self
                context._field_name = "http_headers"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(HTTPHeader.list_builder())
                if isinstance(output, GenericListBuilder):
                    value = output.build()
                else:
                    value = output
            return self._set("http_headers", value)

        def path(self, value: Optional[str], /) -> Self:
            """
            Path to access on the HTTP server.
            """
            return self._set("path", value)

        @overload
        def port(
            self, value_or_callback: apimachinery.IntOrString, /
        ) -> "HTTPGetAction.Builder": ...

        @overload
        def port(
            self,
            value_or_callback: Callable[
                [apimachinery.IntOrString.Builder],
                apimachinery.IntOrString.Builder | apimachinery.IntOrString,
            ],
            /,
        ) -> "HTTPGetAction.Builder": ...

        @overload
        def port(
            self, value_or_callback: Never = ...
        ) -> "apimachinery.IntOrString.BuilderContext": ...

        def port(self, value_or_callback=None, /):
            """
            Name or number of the port to access on the container. Number must be in the range 1 to 65535. Name must be an IANA_SVC_NAME.
            """
            if self._in_context and value_or_callback is None:
                context = apimachinery.IntOrString.BuilderContext()
                context._parent_builder = self
                context._field_name = "port"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(apimachinery.IntOrString.builder())
                if isinstance(output, apimachinery.IntOrString.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("port", value)

        def scheme(self, value: Optional[str], /) -> Self:
            """
            Scheme to use for connecting to the host. Defaults to HTTP.
            """
            return self._set("scheme", value)

    class BuilderContext(BuilderContextBase["HTTPGetAction.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = HTTPGetAction.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for HTTPGetAction."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["HTTPGetAction", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use HTTPGetAction.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    host: Optional[str] = None
    """
    Host name to connect to, defaults to the pod IP. You probably want to set "Host" in httpHeaders instead.
    """
    http_headers: Annotated[Optional[List[HTTPHeader]], Field(alias="httpHeaders")] = None
    """
    Custom headers to set in the request. HTTP allows repeated headers.
    """
    path: Optional[str] = None
    """
    Path to access on the HTTP server.
    """
    port: apimachinery.IntOrString
    """
    Name or number of the port to access on the container. Number must be in the range 1 to 65535. Name must be an IANA_SVC_NAME.
    """
    scheme: Optional[str] = None
    """
    Scheme to use for connecting to the host. Defaults to HTTP.
    """


class ISCSIPersistentVolumeSource(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["ISCSIPersistentVolumeSource"]:
            return ISCSIPersistentVolumeSource

        def build(self) -> "ISCSIPersistentVolumeSource":
            return ISCSIPersistentVolumeSource(**self._attrs)

        def chap_auth_discovery(self, value: Optional[bool], /) -> Self:
            """
            chapAuthDiscovery defines whether support iSCSI Discovery CHAP authentication
            """
            return self._set("chap_auth_discovery", value)

        def chap_auth_session(self, value: Optional[bool], /) -> Self:
            """
            chapAuthSession defines whether support iSCSI Session CHAP authentication
            """
            return self._set("chap_auth_session", value)

        def fs_type(self, value: Optional[str], /) -> Self:
            """
            fsType is the filesystem type of the volume that you want to mount. Tip: Ensure that the filesystem type is supported by the host operating system. Examples: "ext4", "xfs", "ntfs". Implicitly inferred to be "ext4" if unspecified. More info: https://kubernetes.io/docs/concepts/storage/volumes#iscsi
            """
            return self._set("fs_type", value)

        def initiator_name(self, value: Optional[str], /) -> Self:
            """
            initiatorName is the custom iSCSI Initiator Name. If initiatorName is specified with iscsiInterface simultaneously, new iSCSI interface <target portal>:<volume name> will be created for the connection.
            """
            return self._set("initiator_name", value)

        def iqn(self, value: str, /) -> Self:
            """
            iqn is Target iSCSI Qualified Name.
            """
            return self._set("iqn", value)

        def iscsi_interface(self, value: Optional[str], /) -> Self:
            """
            iscsiInterface is the interface Name that uses an iSCSI transport. Defaults to 'default' (tcp).
            """
            return self._set("iscsi_interface", value)

        def lun(self, value: int, /) -> Self:
            """
            lun is iSCSI Target Lun number.
            """
            return self._set("lun", value)

        def portals(self, value: Optional[List[str]], /) -> Self:
            """
            portals is the iSCSI Target Portal List. The Portal is either an IP or ip_addr:port if the port is other than default (typically TCP ports 860 and 3260).
            """
            return self._set("portals", value)

        def read_only(self, value: Optional[bool], /) -> Self:
            """
            readOnly here will force the ReadOnly setting in VolumeMounts. Defaults to false.
            """
            return self._set("read_only", value)

        @overload
        def secret_ref(
            self, value_or_callback: Optional[SecretReference], /
        ) -> "ISCSIPersistentVolumeSource.Builder": ...

        @overload
        def secret_ref(
            self,
            value_or_callback: Callable[
                [SecretReference.Builder], SecretReference.Builder | SecretReference
            ],
            /,
        ) -> "ISCSIPersistentVolumeSource.Builder": ...

        @overload
        def secret_ref(
            self, value_or_callback: Never = ...
        ) -> "SecretReference.BuilderContext": ...

        def secret_ref(self, value_or_callback=None, /):
            """
            secretRef is the CHAP Secret for iSCSI target and initiator authentication
            """
            if self._in_context and value_or_callback is None:
                context = SecretReference.BuilderContext()
                context._parent_builder = self
                context._field_name = "secret_ref"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(SecretReference.builder())
                if isinstance(output, SecretReference.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("secret_ref", value)

        def target_portal(self, value: str, /) -> Self:
            """
            targetPortal is iSCSI Target Portal. The Portal is either an IP or ip_addr:port if the port is other than default (typically TCP ports 860 and 3260).
            """
            return self._set("target_portal", value)

    class BuilderContext(BuilderContextBase["ISCSIPersistentVolumeSource.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = ISCSIPersistentVolumeSource.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for ISCSIPersistentVolumeSource."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["ISCSIPersistentVolumeSource", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use ISCSIPersistentVolumeSource.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    chap_auth_discovery: Annotated[Optional[bool], Field(alias="chapAuthDiscovery")] = None
    """
    chapAuthDiscovery defines whether support iSCSI Discovery CHAP authentication
    """
    chap_auth_session: Annotated[Optional[bool], Field(alias="chapAuthSession")] = None
    """
    chapAuthSession defines whether support iSCSI Session CHAP authentication
    """
    fs_type: Annotated[Optional[str], Field(alias="fsType")] = None
    """
    fsType is the filesystem type of the volume that you want to mount. Tip: Ensure that the filesystem type is supported by the host operating system. Examples: "ext4", "xfs", "ntfs". Implicitly inferred to be "ext4" if unspecified. More info: https://kubernetes.io/docs/concepts/storage/volumes#iscsi
    """
    initiator_name: Annotated[Optional[str], Field(alias="initiatorName")] = None
    """
    initiatorName is the custom iSCSI Initiator Name. If initiatorName is specified with iscsiInterface simultaneously, new iSCSI interface <target portal>:<volume name> will be created for the connection.
    """
    iqn: str
    """
    iqn is Target iSCSI Qualified Name.
    """
    iscsi_interface: Annotated[Optional[str], Field(alias="iscsiInterface")] = None
    """
    iscsiInterface is the interface Name that uses an iSCSI transport. Defaults to 'default' (tcp).
    """
    lun: int
    """
    lun is iSCSI Target Lun number.
    """
    portals: Optional[List[str]] = None
    """
    portals is the iSCSI Target Portal List. The Portal is either an IP or ip_addr:port if the port is other than default (typically TCP ports 860 and 3260).
    """
    read_only: Annotated[Optional[bool], Field(alias="readOnly")] = None
    """
    readOnly here will force the ReadOnly setting in VolumeMounts. Defaults to false.
    """
    secret_ref: Annotated[Optional[SecretReference], Field(alias="secretRef")] = None
    """
    secretRef is the CHAP Secret for iSCSI target and initiator authentication
    """
    target_portal: Annotated[str, Field(alias="targetPortal")]
    """
    targetPortal is iSCSI Target Portal. The Portal is either an IP or ip_addr:port if the port is other than default (typically TCP ports 860 and 3260).
    """


class ISCSIVolumeSource(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["ISCSIVolumeSource"]:
            return ISCSIVolumeSource

        def build(self) -> "ISCSIVolumeSource":
            return ISCSIVolumeSource(**self._attrs)

        def chap_auth_discovery(self, value: Optional[bool], /) -> Self:
            """
            chapAuthDiscovery defines whether support iSCSI Discovery CHAP authentication
            """
            return self._set("chap_auth_discovery", value)

        def chap_auth_session(self, value: Optional[bool], /) -> Self:
            """
            chapAuthSession defines whether support iSCSI Session CHAP authentication
            """
            return self._set("chap_auth_session", value)

        def fs_type(self, value: Optional[str], /) -> Self:
            """
            fsType is the filesystem type of the volume that you want to mount. Tip: Ensure that the filesystem type is supported by the host operating system. Examples: "ext4", "xfs", "ntfs". Implicitly inferred to be "ext4" if unspecified. More info: https://kubernetes.io/docs/concepts/storage/volumes#iscsi
            """
            return self._set("fs_type", value)

        def initiator_name(self, value: Optional[str], /) -> Self:
            """
            initiatorName is the custom iSCSI Initiator Name. If initiatorName is specified with iscsiInterface simultaneously, new iSCSI interface <target portal>:<volume name> will be created for the connection.
            """
            return self._set("initiator_name", value)

        def iqn(self, value: str, /) -> Self:
            """
            iqn is the target iSCSI Qualified Name.
            """
            return self._set("iqn", value)

        def iscsi_interface(self, value: Optional[str], /) -> Self:
            """
            iscsiInterface is the interface Name that uses an iSCSI transport. Defaults to 'default' (tcp).
            """
            return self._set("iscsi_interface", value)

        def lun(self, value: int, /) -> Self:
            """
            lun represents iSCSI Target Lun number.
            """
            return self._set("lun", value)

        def portals(self, value: Optional[List[str]], /) -> Self:
            """
            portals is the iSCSI Target Portal List. The portal is either an IP or ip_addr:port if the port is other than default (typically TCP ports 860 and 3260).
            """
            return self._set("portals", value)

        def read_only(self, value: Optional[bool], /) -> Self:
            """
            readOnly here will force the ReadOnly setting in VolumeMounts. Defaults to false.
            """
            return self._set("read_only", value)

        @overload
        def secret_ref(
            self, value_or_callback: Optional[LocalObjectReference], /
        ) -> "ISCSIVolumeSource.Builder": ...

        @overload
        def secret_ref(
            self,
            value_or_callback: Callable[
                [LocalObjectReference.Builder],
                LocalObjectReference.Builder | LocalObjectReference,
            ],
            /,
        ) -> "ISCSIVolumeSource.Builder": ...

        @overload
        def secret_ref(
            self, value_or_callback: Never = ...
        ) -> "LocalObjectReference.BuilderContext": ...

        def secret_ref(self, value_or_callback=None, /):
            """
            secretRef is the CHAP Secret for iSCSI target and initiator authentication
            """
            if self._in_context and value_or_callback is None:
                context = LocalObjectReference.BuilderContext()
                context._parent_builder = self
                context._field_name = "secret_ref"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(LocalObjectReference.builder())
                if isinstance(output, LocalObjectReference.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("secret_ref", value)

        def target_portal(self, value: str, /) -> Self:
            """
            targetPortal is iSCSI Target Portal. The Portal is either an IP or ip_addr:port if the port is other than default (typically TCP ports 860 and 3260).
            """
            return self._set("target_portal", value)

    class BuilderContext(BuilderContextBase["ISCSIVolumeSource.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = ISCSIVolumeSource.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for ISCSIVolumeSource."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["ISCSIVolumeSource", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use ISCSIVolumeSource.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    chap_auth_discovery: Annotated[Optional[bool], Field(alias="chapAuthDiscovery")] = None
    """
    chapAuthDiscovery defines whether support iSCSI Discovery CHAP authentication
    """
    chap_auth_session: Annotated[Optional[bool], Field(alias="chapAuthSession")] = None
    """
    chapAuthSession defines whether support iSCSI Session CHAP authentication
    """
    fs_type: Annotated[Optional[str], Field(alias="fsType")] = None
    """
    fsType is the filesystem type of the volume that you want to mount. Tip: Ensure that the filesystem type is supported by the host operating system. Examples: "ext4", "xfs", "ntfs". Implicitly inferred to be "ext4" if unspecified. More info: https://kubernetes.io/docs/concepts/storage/volumes#iscsi
    """
    initiator_name: Annotated[Optional[str], Field(alias="initiatorName")] = None
    """
    initiatorName is the custom iSCSI Initiator Name. If initiatorName is specified with iscsiInterface simultaneously, new iSCSI interface <target portal>:<volume name> will be created for the connection.
    """
    iqn: str
    """
    iqn is the target iSCSI Qualified Name.
    """
    iscsi_interface: Annotated[Optional[str], Field(alias="iscsiInterface")] = None
    """
    iscsiInterface is the interface Name that uses an iSCSI transport. Defaults to 'default' (tcp).
    """
    lun: int
    """
    lun represents iSCSI Target Lun number.
    """
    portals: Optional[List[str]] = None
    """
    portals is the iSCSI Target Portal List. The portal is either an IP or ip_addr:port if the port is other than default (typically TCP ports 860 and 3260).
    """
    read_only: Annotated[Optional[bool], Field(alias="readOnly")] = None
    """
    readOnly here will force the ReadOnly setting in VolumeMounts. Defaults to false.
    """
    secret_ref: Annotated[Optional[LocalObjectReference], Field(alias="secretRef")] = None
    """
    secretRef is the CHAP Secret for iSCSI target and initiator authentication
    """
    target_portal: Annotated[str, Field(alias="targetPortal")]
    """
    targetPortal is iSCSI Target Portal. The Portal is either an IP or ip_addr:port if the port is other than default (typically TCP ports 860 and 3260).
    """


class LimitRangeItem(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["LimitRangeItem"]:
            return LimitRangeItem

        def build(self) -> "LimitRangeItem":
            return LimitRangeItem(**self._attrs)

        def default(self, value: Optional[Dict[str, apimachinery.Quantity]], /) -> Self:
            """
            Default resource requirement limit value by resource name if resource limit is omitted.
            """
            return self._set("default", value)

        def default_request(self, value: Optional[Dict[str, apimachinery.Quantity]], /) -> Self:
            """
            DefaultRequest is the default resource requirement request value by resource name if resource request is omitted.
            """
            return self._set("default_request", value)

        def max(self, value: Optional[Dict[str, apimachinery.Quantity]], /) -> Self:
            """
            Max usage constraints on this kind by resource name.
            """
            return self._set("max", value)

        def max_limit_request_ratio(
            self, value: Optional[Dict[str, apimachinery.Quantity]], /
        ) -> Self:
            """
            MaxLimitRequestRatio if specified, the named resource must have a request and limit that are both non-zero where limit divided by request is less than or equal to the enumerated value; this represents the max burst for the named resource.
            """
            return self._set("max_limit_request_ratio", value)

        def min(self, value: Optional[Dict[str, apimachinery.Quantity]], /) -> Self:
            """
            Min usage constraints on this kind by resource name.
            """
            return self._set("min", value)

        def type(self, value: str, /) -> Self:
            """
            Type of resource that this limit applies to.
            """
            return self._set("type", value)

    class BuilderContext(BuilderContextBase["LimitRangeItem.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = LimitRangeItem.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for LimitRangeItem."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["LimitRangeItem", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use LimitRangeItem.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    default: Optional[Dict[str, apimachinery.Quantity]] = None
    """
    Default resource requirement limit value by resource name if resource limit is omitted.
    """
    default_request: Annotated[
        Optional[Dict[str, apimachinery.Quantity]], Field(alias="defaultRequest")
    ] = None
    """
    DefaultRequest is the default resource requirement request value by resource name if resource request is omitted.
    """
    max: Optional[Dict[str, apimachinery.Quantity]] = None
    """
    Max usage constraints on this kind by resource name.
    """
    max_limit_request_ratio: Annotated[
        Optional[Dict[str, apimachinery.Quantity]], Field(alias="maxLimitRequestRatio")
    ] = None
    """
    MaxLimitRequestRatio if specified, the named resource must have a request and limit that are both non-zero where limit divided by request is less than or equal to the enumerated value; this represents the max burst for the named resource.
    """
    min: Optional[Dict[str, apimachinery.Quantity]] = None
    """
    Min usage constraints on this kind by resource name.
    """
    type: str
    """
    Type of resource that this limit applies to.
    """


class LimitRangeSpec(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["LimitRangeSpec"]:
            return LimitRangeSpec

        def build(self) -> "LimitRangeSpec":
            return LimitRangeSpec(**self._attrs)

        @overload
        def limits(
            self, value_or_callback: List[LimitRangeItem], /
        ) -> "LimitRangeSpec.Builder": ...

        @overload
        def limits(
            self,
            value_or_callback: Callable[
                [GenericListBuilder[LimitRangeItem, LimitRangeItem.Builder]],
                GenericListBuilder[LimitRangeItem, LimitRangeItem.Builder] | List[LimitRangeItem],
            ],
            /,
        ) -> "LimitRangeSpec.Builder": ...

        @overload
        def limits(
            self, value_or_callback: Never = ...
        ) -> ListBuilderContext[LimitRangeItem.Builder]: ...

        def limits(self, value_or_callback=None, /):
            """
            Limits is the list of LimitRangeItem objects that are enforced.
            """
            if self._in_context and value_or_callback is None:
                context = ListBuilderContext[LimitRangeItem.Builder]()
                context._parent_builder = self
                context._field_name = "limits"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(LimitRangeItem.list_builder())
                if isinstance(output, GenericListBuilder):
                    value = output.build()
                else:
                    value = output
            return self._set("limits", value)

    class BuilderContext(BuilderContextBase["LimitRangeSpec.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = LimitRangeSpec.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for LimitRangeSpec."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["LimitRangeSpec", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use LimitRangeSpec.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    limits: List[LimitRangeItem]
    """
    Limits is the list of LimitRangeItem objects that are enforced.
    """


class LoadBalancerIngress(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["LoadBalancerIngress"]:
            return LoadBalancerIngress

        def build(self) -> "LoadBalancerIngress":
            return LoadBalancerIngress(**self._attrs)

        def hostname(self, value: Optional[str], /) -> Self:
            """
            Hostname is set for load-balancer ingress points that are DNS based (typically AWS load-balancers)
            """
            return self._set("hostname", value)

        def ip(self, value: Optional[str], /) -> Self:
            """
            IP is set for load-balancer ingress points that are IP based (typically GCE or OpenStack load-balancers)
            """
            return self._set("ip", value)

        def ip_mode(self, value: Optional[str], /) -> Self:
            """
            IPMode specifies how the load-balancer IP behaves, and may only be specified when the ip field is specified. Setting this to "VIP" indicates that traffic is delivered to the node with the destination set to the load-balancer's IP and port. Setting this to "Proxy" indicates that traffic is delivered to the node or pod with the destination set to the node's IP and node port or the pod's IP and port. Service implementations may use this information to adjust traffic routing.
            """
            return self._set("ip_mode", value)

        @overload
        def ports(
            self, value_or_callback: List[PortStatus], /
        ) -> "LoadBalancerIngress.Builder": ...

        @overload
        def ports(
            self,
            value_or_callback: Callable[
                [GenericListBuilder[PortStatus, PortStatus.Builder]],
                GenericListBuilder[PortStatus, PortStatus.Builder] | List[PortStatus],
            ],
            /,
        ) -> "LoadBalancerIngress.Builder": ...

        @overload
        def ports(
            self, value_or_callback: Never = ...
        ) -> ListBuilderContext[PortStatus.Builder]: ...

        def ports(self, value_or_callback=None, /):
            """
            Ports is a list of records of service ports If used, every port defined in the service should have an entry in it
            """
            if self._in_context and value_or_callback is None:
                context = ListBuilderContext[PortStatus.Builder]()
                context._parent_builder = self
                context._field_name = "ports"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(PortStatus.list_builder())
                if isinstance(output, GenericListBuilder):
                    value = output.build()
                else:
                    value = output
            return self._set("ports", value)

    class BuilderContext(BuilderContextBase["LoadBalancerIngress.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = LoadBalancerIngress.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for LoadBalancerIngress."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["LoadBalancerIngress", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use LoadBalancerIngress.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    hostname: Optional[str] = None
    """
    Hostname is set for load-balancer ingress points that are DNS based (typically AWS load-balancers)
    """
    ip: Optional[str] = None
    """
    IP is set for load-balancer ingress points that are IP based (typically GCE or OpenStack load-balancers)
    """
    ip_mode: Annotated[Optional[str], Field(alias="ipMode")] = None
    """
    IPMode specifies how the load-balancer IP behaves, and may only be specified when the ip field is specified. Setting this to "VIP" indicates that traffic is delivered to the node with the destination set to the load-balancer's IP and port. Setting this to "Proxy" indicates that traffic is delivered to the node or pod with the destination set to the node's IP and node port or the pod's IP and port. Service implementations may use this information to adjust traffic routing.
    """
    ports: Optional[List[PortStatus]] = None
    """
    Ports is a list of records of service ports If used, every port defined in the service should have an entry in it
    """


class LoadBalancerStatus(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["LoadBalancerStatus"]:
            return LoadBalancerStatus

        def build(self) -> "LoadBalancerStatus":
            return LoadBalancerStatus(**self._attrs)

        @overload
        def ingress(
            self, value_or_callback: List[LoadBalancerIngress], /
        ) -> "LoadBalancerStatus.Builder": ...

        @overload
        def ingress(
            self,
            value_or_callback: Callable[
                [GenericListBuilder[LoadBalancerIngress, LoadBalancerIngress.Builder]],
                GenericListBuilder[LoadBalancerIngress, LoadBalancerIngress.Builder]
                | List[LoadBalancerIngress],
            ],
            /,
        ) -> "LoadBalancerStatus.Builder": ...

        @overload
        def ingress(
            self, value_or_callback: Never = ...
        ) -> ListBuilderContext[LoadBalancerIngress.Builder]: ...

        def ingress(self, value_or_callback=None, /):
            """
            Ingress is a list containing ingress points for the load-balancer. Traffic intended for the service should be sent to these ingress points.
            """
            if self._in_context and value_or_callback is None:
                context = ListBuilderContext[LoadBalancerIngress.Builder]()
                context._parent_builder = self
                context._field_name = "ingress"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(LoadBalancerIngress.list_builder())
                if isinstance(output, GenericListBuilder):
                    value = output.build()
                else:
                    value = output
            return self._set("ingress", value)

    class BuilderContext(BuilderContextBase["LoadBalancerStatus.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = LoadBalancerStatus.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for LoadBalancerStatus."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["LoadBalancerStatus", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use LoadBalancerStatus.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    ingress: Optional[List[LoadBalancerIngress]] = None
    """
    Ingress is a list containing ingress points for the load-balancer. Traffic intended for the service should be sent to these ingress points.
    """


class NamespaceCondition(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["NamespaceCondition"]:
            return NamespaceCondition

        def build(self) -> "NamespaceCondition":
            return NamespaceCondition(**self._attrs)

        @overload
        def last_transition_time(
            self, value_or_callback: Optional[apimachinery.Time], /
        ) -> "NamespaceCondition.Builder": ...

        @overload
        def last_transition_time(
            self,
            value_or_callback: Callable[
                [apimachinery.Time.Builder],
                apimachinery.Time.Builder | apimachinery.Time,
            ],
            /,
        ) -> "NamespaceCondition.Builder": ...

        @overload
        def last_transition_time(
            self, value_or_callback: Never = ...
        ) -> "apimachinery.Time.BuilderContext": ...

        def last_transition_time(self, value_or_callback=None, /):
            if self._in_context and value_or_callback is None:
                context = apimachinery.Time.BuilderContext()
                context._parent_builder = self
                context._field_name = "last_transition_time"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(apimachinery.Time.builder())
                if isinstance(output, apimachinery.Time.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("last_transition_time", value)

        def message(self, value: Optional[str], /) -> Self:
            return self._set("message", value)

        def reason(self, value: Optional[str], /) -> Self:
            return self._set("reason", value)

        def status(self, value: str, /) -> Self:
            """
            Status of the condition, one of True, False, Unknown.
            """
            return self._set("status", value)

        def type(self, value: str, /) -> Self:
            """
            Type of namespace controller condition.
            """
            return self._set("type", value)

    class BuilderContext(BuilderContextBase["NamespaceCondition.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = NamespaceCondition.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for NamespaceCondition."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["NamespaceCondition", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use NamespaceCondition.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    last_transition_time: Annotated[
        Optional[apimachinery.Time], Field(alias="lastTransitionTime")
    ] = None
    message: Optional[str] = None
    reason: Optional[str] = None
    status: str
    """
    Status of the condition, one of True, False, Unknown.
    """
    type: str
    """
    Type of namespace controller condition.
    """


class NamespaceStatus(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["NamespaceStatus"]:
            return NamespaceStatus

        def build(self) -> "NamespaceStatus":
            return NamespaceStatus(**self._attrs)

        @overload
        def conditions(
            self, value_or_callback: List[NamespaceCondition], /
        ) -> "NamespaceStatus.Builder": ...

        @overload
        def conditions(
            self,
            value_or_callback: Callable[
                [GenericListBuilder[NamespaceCondition, NamespaceCondition.Builder]],
                GenericListBuilder[NamespaceCondition, NamespaceCondition.Builder]
                | List[NamespaceCondition],
            ],
            /,
        ) -> "NamespaceStatus.Builder": ...

        @overload
        def conditions(
            self, value_or_callback: Never = ...
        ) -> ListBuilderContext[NamespaceCondition.Builder]: ...

        def conditions(self, value_or_callback=None, /):
            """
            Represents the latest available observations of a namespace's current state.
            """
            if self._in_context and value_or_callback is None:
                context = ListBuilderContext[NamespaceCondition.Builder]()
                context._parent_builder = self
                context._field_name = "conditions"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(NamespaceCondition.list_builder())
                if isinstance(output, GenericListBuilder):
                    value = output.build()
                else:
                    value = output
            return self._set("conditions", value)

        def phase(self, value: Optional[str], /) -> Self:
            """
            Phase is the current lifecycle phase of the namespace. More info: https://kubernetes.io/docs/tasks/administer-cluster/namespaces/
            """
            return self._set("phase", value)

    class BuilderContext(BuilderContextBase["NamespaceStatus.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = NamespaceStatus.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for NamespaceStatus."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["NamespaceStatus", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use NamespaceStatus.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    conditions: Optional[List[NamespaceCondition]] = None
    """
    Represents the latest available observations of a namespace's current state.
    """
    phase: Optional[str] = None
    """
    Phase is the current lifecycle phase of the namespace. More info: https://kubernetes.io/docs/tasks/administer-cluster/namespaces/
    """


class NodeCondition(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["NodeCondition"]:
            return NodeCondition

        def build(self) -> "NodeCondition":
            return NodeCondition(**self._attrs)

        @overload
        def last_heartbeat_time(
            self, value_or_callback: Optional[apimachinery.Time], /
        ) -> "NodeCondition.Builder": ...

        @overload
        def last_heartbeat_time(
            self,
            value_or_callback: Callable[
                [apimachinery.Time.Builder],
                apimachinery.Time.Builder | apimachinery.Time,
            ],
            /,
        ) -> "NodeCondition.Builder": ...

        @overload
        def last_heartbeat_time(
            self, value_or_callback: Never = ...
        ) -> "apimachinery.Time.BuilderContext": ...

        def last_heartbeat_time(self, value_or_callback=None, /):
            """
            Last time we got an update on a given condition.
            """
            if self._in_context and value_or_callback is None:
                context = apimachinery.Time.BuilderContext()
                context._parent_builder = self
                context._field_name = "last_heartbeat_time"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(apimachinery.Time.builder())
                if isinstance(output, apimachinery.Time.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("last_heartbeat_time", value)

        @overload
        def last_transition_time(
            self, value_or_callback: Optional[apimachinery.Time], /
        ) -> "NodeCondition.Builder": ...

        @overload
        def last_transition_time(
            self,
            value_or_callback: Callable[
                [apimachinery.Time.Builder],
                apimachinery.Time.Builder | apimachinery.Time,
            ],
            /,
        ) -> "NodeCondition.Builder": ...

        @overload
        def last_transition_time(
            self, value_or_callback: Never = ...
        ) -> "apimachinery.Time.BuilderContext": ...

        def last_transition_time(self, value_or_callback=None, /):
            """
            Last time the condition transit from one status to another.
            """
            if self._in_context and value_or_callback is None:
                context = apimachinery.Time.BuilderContext()
                context._parent_builder = self
                context._field_name = "last_transition_time"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(apimachinery.Time.builder())
                if isinstance(output, apimachinery.Time.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("last_transition_time", value)

        def message(self, value: Optional[str], /) -> Self:
            """
            Human readable message indicating details about last transition.
            """
            return self._set("message", value)

        def reason(self, value: Optional[str], /) -> Self:
            """
            (brief) reason for the condition's last transition.
            """
            return self._set("reason", value)

        def status(self, value: str, /) -> Self:
            """
            Status of the condition, one of True, False, Unknown.
            """
            return self._set("status", value)

        def type(self, value: str, /) -> Self:
            """
            Type of node condition.
            """
            return self._set("type", value)

    class BuilderContext(BuilderContextBase["NodeCondition.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = NodeCondition.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for NodeCondition."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["NodeCondition", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use NodeCondition.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    last_heartbeat_time: Annotated[
        Optional[apimachinery.Time], Field(alias="lastHeartbeatTime")
    ] = None
    """
    Last time we got an update on a given condition.
    """
    last_transition_time: Annotated[
        Optional[apimachinery.Time], Field(alias="lastTransitionTime")
    ] = None
    """
    Last time the condition transit from one status to another.
    """
    message: Optional[str] = None
    """
    Human readable message indicating details about last transition.
    """
    reason: Optional[str] = None
    """
    (brief) reason for the condition's last transition.
    """
    status: str
    """
    Status of the condition, one of True, False, Unknown.
    """
    type: str
    """
    Type of node condition.
    """


class NodeRuntimeHandler(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["NodeRuntimeHandler"]:
            return NodeRuntimeHandler

        def build(self) -> "NodeRuntimeHandler":
            return NodeRuntimeHandler(**self._attrs)

        @overload
        def features(
            self, value_or_callback: Optional[NodeRuntimeHandlerFeatures], /
        ) -> "NodeRuntimeHandler.Builder": ...

        @overload
        def features(
            self,
            value_or_callback: Callable[
                [NodeRuntimeHandlerFeatures.Builder],
                NodeRuntimeHandlerFeatures.Builder | NodeRuntimeHandlerFeatures,
            ],
            /,
        ) -> "NodeRuntimeHandler.Builder": ...

        @overload
        def features(
            self, value_or_callback: Never = ...
        ) -> "NodeRuntimeHandlerFeatures.BuilderContext": ...

        def features(self, value_or_callback=None, /):
            """
            Supported features.
            """
            if self._in_context and value_or_callback is None:
                context = NodeRuntimeHandlerFeatures.BuilderContext()
                context._parent_builder = self
                context._field_name = "features"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(NodeRuntimeHandlerFeatures.builder())
                if isinstance(output, NodeRuntimeHandlerFeatures.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("features", value)

        def name(self, value: Optional[str], /) -> Self:
            """
            Runtime handler name. Empty for the default runtime handler.
            """
            return self._set("name", value)

    class BuilderContext(BuilderContextBase["NodeRuntimeHandler.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = NodeRuntimeHandler.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for NodeRuntimeHandler."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["NodeRuntimeHandler", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use NodeRuntimeHandler.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    features: Optional[NodeRuntimeHandlerFeatures] = None
    """
    Supported features.
    """
    name: Optional[str] = None
    """
    Runtime handler name. Empty for the default runtime handler.
    """


class NodeSelector(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["NodeSelector"]:
            return NodeSelector

        def build(self) -> "NodeSelector":
            return NodeSelector(**self._attrs)

        @overload
        def node_selector_terms(
            self, value_or_callback: List[NodeSelectorTerm], /
        ) -> "NodeSelector.Builder": ...

        @overload
        def node_selector_terms(
            self,
            value_or_callback: Callable[
                [GenericListBuilder[NodeSelectorTerm, NodeSelectorTerm.Builder]],
                GenericListBuilder[NodeSelectorTerm, NodeSelectorTerm.Builder]
                | List[NodeSelectorTerm],
            ],
            /,
        ) -> "NodeSelector.Builder": ...

        @overload
        def node_selector_terms(
            self, value_or_callback: Never = ...
        ) -> ListBuilderContext[NodeSelectorTerm.Builder]: ...

        def node_selector_terms(self, value_or_callback=None, /):
            """
            Required. A list of node selector terms. The terms are ORed.
            """
            if self._in_context and value_or_callback is None:
                context = ListBuilderContext[NodeSelectorTerm.Builder]()
                context._parent_builder = self
                context._field_name = "node_selector_terms"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(NodeSelectorTerm.list_builder())
                if isinstance(output, GenericListBuilder):
                    value = output.build()
                else:
                    value = output
            return self._set("node_selector_terms", value)

    class BuilderContext(BuilderContextBase["NodeSelector.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = NodeSelector.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for NodeSelector."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["NodeSelector", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use NodeSelector.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    node_selector_terms: Annotated[List[NodeSelectorTerm], Field(alias="nodeSelectorTerms")]
    """
    Required. A list of node selector terms. The terms are ORed.
    """


class NodeStatus(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["NodeStatus"]:
            return NodeStatus

        def build(self) -> "NodeStatus":
            return NodeStatus(**self._attrs)

        @overload
        def addresses(self, value_or_callback: List[NodeAddress], /) -> "NodeStatus.Builder": ...

        @overload
        def addresses(
            self,
            value_or_callback: Callable[
                [GenericListBuilder[NodeAddress, NodeAddress.Builder]],
                GenericListBuilder[NodeAddress, NodeAddress.Builder] | List[NodeAddress],
            ],
            /,
        ) -> "NodeStatus.Builder": ...

        @overload
        def addresses(
            self, value_or_callback: Never = ...
        ) -> ListBuilderContext[NodeAddress.Builder]: ...

        def addresses(self, value_or_callback=None, /):
            """
            List of addresses reachable to the node. Queried from cloud provider, if available. More info: https://kubernetes.io/docs/concepts/nodes/node/#addresses Note: This field is declared as mergeable, but the merge key is not sufficiently unique, which can cause data corruption when it is merged. Callers should instead use a full-replacement patch. See https://pr.k8s.io/79391 for an example. Consumers should assume that addresses can change during the lifetime of a Node. However, there are some exceptions where this may not be possible, such as Pods that inherit a Node's address in its own status or consumers of the downward API (status.hostIP).
            """
            if self._in_context and value_or_callback is None:
                context = ListBuilderContext[NodeAddress.Builder]()
                context._parent_builder = self
                context._field_name = "addresses"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(NodeAddress.list_builder())
                if isinstance(output, GenericListBuilder):
                    value = output.build()
                else:
                    value = output
            return self._set("addresses", value)

        def allocatable(self, value: Optional[Dict[str, apimachinery.Quantity]], /) -> Self:
            """
            Allocatable represents the resources of a node that are available for scheduling. Defaults to Capacity.
            """
            return self._set("allocatable", value)

        def capacity(self, value: Optional[Dict[str, apimachinery.Quantity]], /) -> Self:
            """
            Capacity represents the total resources of a node. More info: https://kubernetes.io/docs/reference/node/node-status/#capacity
            """
            return self._set("capacity", value)

        @overload
        def conditions(self, value_or_callback: List[NodeCondition], /) -> "NodeStatus.Builder": ...

        @overload
        def conditions(
            self,
            value_or_callback: Callable[
                [GenericListBuilder[NodeCondition, NodeCondition.Builder]],
                GenericListBuilder[NodeCondition, NodeCondition.Builder] | List[NodeCondition],
            ],
            /,
        ) -> "NodeStatus.Builder": ...

        @overload
        def conditions(
            self, value_or_callback: Never = ...
        ) -> ListBuilderContext[NodeCondition.Builder]: ...

        def conditions(self, value_or_callback=None, /):
            """
            Conditions is an array of current observed node conditions. More info: https://kubernetes.io/docs/concepts/nodes/node/#condition
            """
            if self._in_context and value_or_callback is None:
                context = ListBuilderContext[NodeCondition.Builder]()
                context._parent_builder = self
                context._field_name = "conditions"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(NodeCondition.list_builder())
                if isinstance(output, GenericListBuilder):
                    value = output.build()
                else:
                    value = output
            return self._set("conditions", value)

        @overload
        def config(
            self, value_or_callback: Optional[NodeConfigStatus], /
        ) -> "NodeStatus.Builder": ...

        @overload
        def config(
            self,
            value_or_callback: Callable[
                [NodeConfigStatus.Builder], NodeConfigStatus.Builder | NodeConfigStatus
            ],
            /,
        ) -> "NodeStatus.Builder": ...

        @overload
        def config(self, value_or_callback: Never = ...) -> "NodeConfigStatus.BuilderContext": ...

        def config(self, value_or_callback=None, /):
            """
            Status of the config assigned to the node via the dynamic Kubelet config feature.
            """
            if self._in_context and value_or_callback is None:
                context = NodeConfigStatus.BuilderContext()
                context._parent_builder = self
                context._field_name = "config"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(NodeConfigStatus.builder())
                if isinstance(output, NodeConfigStatus.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("config", value)

        @overload
        def daemon_endpoints(
            self, value_or_callback: Optional[NodeDaemonEndpoints], /
        ) -> "NodeStatus.Builder": ...

        @overload
        def daemon_endpoints(
            self,
            value_or_callback: Callable[
                [NodeDaemonEndpoints.Builder],
                NodeDaemonEndpoints.Builder | NodeDaemonEndpoints,
            ],
            /,
        ) -> "NodeStatus.Builder": ...

        @overload
        def daemon_endpoints(
            self, value_or_callback: Never = ...
        ) -> "NodeDaemonEndpoints.BuilderContext": ...

        def daemon_endpoints(self, value_or_callback=None, /):
            """
            Endpoints of daemons running on the Node.
            """
            if self._in_context and value_or_callback is None:
                context = NodeDaemonEndpoints.BuilderContext()
                context._parent_builder = self
                context._field_name = "daemon_endpoints"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(NodeDaemonEndpoints.builder())
                if isinstance(output, NodeDaemonEndpoints.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("daemon_endpoints", value)

        @overload
        def features(
            self, value_or_callback: Optional[NodeFeatures], /
        ) -> "NodeStatus.Builder": ...

        @overload
        def features(
            self,
            value_or_callback: Callable[
                [NodeFeatures.Builder], NodeFeatures.Builder | NodeFeatures
            ],
            /,
        ) -> "NodeStatus.Builder": ...

        @overload
        def features(self, value_or_callback: Never = ...) -> "NodeFeatures.BuilderContext": ...

        def features(self, value_or_callback=None, /):
            """
            Features describes the set of features implemented by the CRI implementation.
            """
            if self._in_context and value_or_callback is None:
                context = NodeFeatures.BuilderContext()
                context._parent_builder = self
                context._field_name = "features"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(NodeFeatures.builder())
                if isinstance(output, NodeFeatures.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("features", value)

        @overload
        def images(self, value_or_callback: List[ContainerImage], /) -> "NodeStatus.Builder": ...

        @overload
        def images(
            self,
            value_or_callback: Callable[
                [GenericListBuilder[ContainerImage, ContainerImage.Builder]],
                GenericListBuilder[ContainerImage, ContainerImage.Builder] | List[ContainerImage],
            ],
            /,
        ) -> "NodeStatus.Builder": ...

        @overload
        def images(
            self, value_or_callback: Never = ...
        ) -> ListBuilderContext[ContainerImage.Builder]: ...

        def images(self, value_or_callback=None, /):
            """
            List of container images on this node
            """
            if self._in_context and value_or_callback is None:
                context = ListBuilderContext[ContainerImage.Builder]()
                context._parent_builder = self
                context._field_name = "images"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(ContainerImage.list_builder())
                if isinstance(output, GenericListBuilder):
                    value = output.build()
                else:
                    value = output
            return self._set("images", value)

        @overload
        def node_info(
            self, value_or_callback: Optional[NodeSystemInfo], /
        ) -> "NodeStatus.Builder": ...

        @overload
        def node_info(
            self,
            value_or_callback: Callable[
                [NodeSystemInfo.Builder], NodeSystemInfo.Builder | NodeSystemInfo
            ],
            /,
        ) -> "NodeStatus.Builder": ...

        @overload
        def node_info(self, value_or_callback: Never = ...) -> "NodeSystemInfo.BuilderContext": ...

        def node_info(self, value_or_callback=None, /):
            """
            Set of ids/uuids to uniquely identify the node. More info: https://kubernetes.io/docs/concepts/nodes/node/#info
            """
            if self._in_context and value_or_callback is None:
                context = NodeSystemInfo.BuilderContext()
                context._parent_builder = self
                context._field_name = "node_info"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(NodeSystemInfo.builder())
                if isinstance(output, NodeSystemInfo.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("node_info", value)

        def phase(self, value: Optional[str], /) -> Self:
            """
            NodePhase is the recently observed lifecycle phase of the node. More info: https://kubernetes.io/docs/concepts/nodes/node/#phase The field is never populated, and now is deprecated.
            """
            return self._set("phase", value)

        @overload
        def runtime_handlers(
            self, value_or_callback: List[NodeRuntimeHandler], /
        ) -> "NodeStatus.Builder": ...

        @overload
        def runtime_handlers(
            self,
            value_or_callback: Callable[
                [GenericListBuilder[NodeRuntimeHandler, NodeRuntimeHandler.Builder]],
                GenericListBuilder[NodeRuntimeHandler, NodeRuntimeHandler.Builder]
                | List[NodeRuntimeHandler],
            ],
            /,
        ) -> "NodeStatus.Builder": ...

        @overload
        def runtime_handlers(
            self, value_or_callback: Never = ...
        ) -> ListBuilderContext[NodeRuntimeHandler.Builder]: ...

        def runtime_handlers(self, value_or_callback=None, /):
            """
            The available runtime handlers.
            """
            if self._in_context and value_or_callback is None:
                context = ListBuilderContext[NodeRuntimeHandler.Builder]()
                context._parent_builder = self
                context._field_name = "runtime_handlers"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(NodeRuntimeHandler.list_builder())
                if isinstance(output, GenericListBuilder):
                    value = output.build()
                else:
                    value = output
            return self._set("runtime_handlers", value)

        @overload
        def volumes_attached(
            self, value_or_callback: List[AttachedVolume], /
        ) -> "NodeStatus.Builder": ...

        @overload
        def volumes_attached(
            self,
            value_or_callback: Callable[
                [GenericListBuilder[AttachedVolume, AttachedVolume.Builder]],
                GenericListBuilder[AttachedVolume, AttachedVolume.Builder] | List[AttachedVolume],
            ],
            /,
        ) -> "NodeStatus.Builder": ...

        @overload
        def volumes_attached(
            self, value_or_callback: Never = ...
        ) -> ListBuilderContext[AttachedVolume.Builder]: ...

        def volumes_attached(self, value_or_callback=None, /):
            """
            List of volumes that are attached to the node.
            """
            if self._in_context and value_or_callback is None:
                context = ListBuilderContext[AttachedVolume.Builder]()
                context._parent_builder = self
                context._field_name = "volumes_attached"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(AttachedVolume.list_builder())
                if isinstance(output, GenericListBuilder):
                    value = output.build()
                else:
                    value = output
            return self._set("volumes_attached", value)

        def volumes_in_use(self, value: Optional[List[str]], /) -> Self:
            """
            List of attachable volumes in use (mounted) by the node.
            """
            return self._set("volumes_in_use", value)

    class BuilderContext(BuilderContextBase["NodeStatus.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = NodeStatus.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for NodeStatus."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["NodeStatus", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use NodeStatus.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    addresses: Optional[List[NodeAddress]] = None
    """
    List of addresses reachable to the node. Queried from cloud provider, if available. More info: https://kubernetes.io/docs/concepts/nodes/node/#addresses Note: This field is declared as mergeable, but the merge key is not sufficiently unique, which can cause data corruption when it is merged. Callers should instead use a full-replacement patch. See https://pr.k8s.io/79391 for an example. Consumers should assume that addresses can change during the lifetime of a Node. However, there are some exceptions where this may not be possible, such as Pods that inherit a Node's address in its own status or consumers of the downward API (status.hostIP).
    """
    allocatable: Optional[Dict[str, apimachinery.Quantity]] = None
    """
    Allocatable represents the resources of a node that are available for scheduling. Defaults to Capacity.
    """
    capacity: Optional[Dict[str, apimachinery.Quantity]] = None
    """
    Capacity represents the total resources of a node. More info: https://kubernetes.io/docs/reference/node/node-status/#capacity
    """
    conditions: Optional[List[NodeCondition]] = None
    """
    Conditions is an array of current observed node conditions. More info: https://kubernetes.io/docs/concepts/nodes/node/#condition
    """
    config: Optional[NodeConfigStatus] = None
    """
    Status of the config assigned to the node via the dynamic Kubelet config feature.
    """
    daemon_endpoints: Annotated[Optional[NodeDaemonEndpoints], Field(alias="daemonEndpoints")] = (
        None
    )
    """
    Endpoints of daemons running on the Node.
    """
    features: Optional[NodeFeatures] = None
    """
    Features describes the set of features implemented by the CRI implementation.
    """
    images: Optional[List[ContainerImage]] = None
    """
    List of container images on this node
    """
    node_info: Annotated[Optional[NodeSystemInfo], Field(alias="nodeInfo")] = None
    """
    Set of ids/uuids to uniquely identify the node. More info: https://kubernetes.io/docs/concepts/nodes/node/#info
    """
    phase: Optional[str] = None
    """
    NodePhase is the recently observed lifecycle phase of the node. More info: https://kubernetes.io/docs/concepts/nodes/node/#phase The field is never populated, and now is deprecated.
    """
    runtime_handlers: Annotated[
        Optional[List[NodeRuntimeHandler]], Field(alias="runtimeHandlers")
    ] = None
    """
    The available runtime handlers.
    """
    volumes_attached: Annotated[Optional[List[AttachedVolume]], Field(alias="volumesAttached")] = (
        None
    )
    """
    List of volumes that are attached to the node.
    """
    volumes_in_use: Annotated[Optional[List[str]], Field(alias="volumesInUse")] = None
    """
    List of attachable volumes in use (mounted) by the node.
    """


class PersistentVolumeClaimCondition(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["PersistentVolumeClaimCondition"]:
            return PersistentVolumeClaimCondition

        def build(self) -> "PersistentVolumeClaimCondition":
            return PersistentVolumeClaimCondition(**self._attrs)

        @overload
        def last_probe_time(
            self, value_or_callback: Optional[apimachinery.Time], /
        ) -> "PersistentVolumeClaimCondition.Builder": ...

        @overload
        def last_probe_time(
            self,
            value_or_callback: Callable[
                [apimachinery.Time.Builder],
                apimachinery.Time.Builder | apimachinery.Time,
            ],
            /,
        ) -> "PersistentVolumeClaimCondition.Builder": ...

        @overload
        def last_probe_time(
            self, value_or_callback: Never = ...
        ) -> "apimachinery.Time.BuilderContext": ...

        def last_probe_time(self, value_or_callback=None, /):
            """
            lastProbeTime is the time we probed the condition.
            """
            if self._in_context and value_or_callback is None:
                context = apimachinery.Time.BuilderContext()
                context._parent_builder = self
                context._field_name = "last_probe_time"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(apimachinery.Time.builder())
                if isinstance(output, apimachinery.Time.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("last_probe_time", value)

        @overload
        def last_transition_time(
            self, value_or_callback: Optional[apimachinery.Time], /
        ) -> "PersistentVolumeClaimCondition.Builder": ...

        @overload
        def last_transition_time(
            self,
            value_or_callback: Callable[
                [apimachinery.Time.Builder],
                apimachinery.Time.Builder | apimachinery.Time,
            ],
            /,
        ) -> "PersistentVolumeClaimCondition.Builder": ...

        @overload
        def last_transition_time(
            self, value_or_callback: Never = ...
        ) -> "apimachinery.Time.BuilderContext": ...

        def last_transition_time(self, value_or_callback=None, /):
            """
            lastTransitionTime is the time the condition transitioned from one status to another.
            """
            if self._in_context and value_or_callback is None:
                context = apimachinery.Time.BuilderContext()
                context._parent_builder = self
                context._field_name = "last_transition_time"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(apimachinery.Time.builder())
                if isinstance(output, apimachinery.Time.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("last_transition_time", value)

        def message(self, value: Optional[str], /) -> Self:
            """
            message is the human-readable message indicating details about last transition.
            """
            return self._set("message", value)

        def reason(self, value: Optional[str], /) -> Self:
            """
            reason is a unique, this should be a short, machine understandable string that gives the reason for condition's last transition. If it reports "Resizing" that means the underlying persistent volume is being resized.
            """
            return self._set("reason", value)

        def status(self, value: str, /) -> Self:
            return self._set("status", value)

        def type(self, value: str, /) -> Self:
            return self._set("type", value)

    class BuilderContext(BuilderContextBase["PersistentVolumeClaimCondition.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = PersistentVolumeClaimCondition.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for PersistentVolumeClaimCondition."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["PersistentVolumeClaimCondition", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use PersistentVolumeClaimCondition.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    last_probe_time: Annotated[Optional[apimachinery.Time], Field(alias="lastProbeTime")] = None
    """
    lastProbeTime is the time we probed the condition.
    """
    last_transition_time: Annotated[
        Optional[apimachinery.Time], Field(alias="lastTransitionTime")
    ] = None
    """
    lastTransitionTime is the time the condition transitioned from one status to another.
    """
    message: Optional[str] = None
    """
    message is the human-readable message indicating details about last transition.
    """
    reason: Optional[str] = None
    """
    reason is a unique, this should be a short, machine understandable string that gives the reason for condition's last transition. If it reports "Resizing" that means the underlying persistent volume is being resized.
    """
    status: str
    type: str


class PersistentVolumeClaimStatus(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["PersistentVolumeClaimStatus"]:
            return PersistentVolumeClaimStatus

        def build(self) -> "PersistentVolumeClaimStatus":
            return PersistentVolumeClaimStatus(**self._attrs)

        def access_modes(self, value: Optional[List[str]], /) -> Self:
            """
            accessModes contains the actual access modes the volume backing the PVC has. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#access-modes-1
            """
            return self._set("access_modes", value)

        def allocated_resource_statuses(self, value: Optional[Dict[str, str]], /) -> Self:
            """
            allocatedResourceStatuses stores status of resource being resized for the given PVC. Key names follow standard Kubernetes label syntax. Valid values are either:
                * Un-prefixed keys:
                    - storage - the capacity of the volume.
                * Custom resources must use implementation-defined prefixed names such as "example.com/my-custom-resource"
            Apart from above values - keys that are unprefixed or have kubernetes.io prefix are considered reserved and hence may not be used.

            ClaimResourceStatus can be in any of following states:
                - ControllerResizeInProgress:
                    State set when resize controller starts resizing the volume in control-plane.
                - ControllerResizeFailed:
                    State set when resize has failed in resize controller with a terminal error.
                - NodeResizePending:
                    State set when resize controller has finished resizing the volume but further resizing of
                    volume is needed on the node.
                - NodeResizeInProgress:
                    State set when kubelet starts resizing the volume.
                - NodeResizeFailed:
                    State set when resizing has failed in kubelet with a terminal error. Transient errors don't set
                    NodeResizeFailed.
            For example: if expanding a PVC for more capacity - this field can be one of the following states:
                - pvc.status.allocatedResourceStatus['storage'] = "ControllerResizeInProgress"
                 - pvc.status.allocatedResourceStatus['storage'] = "ControllerResizeFailed"
                 - pvc.status.allocatedResourceStatus['storage'] = "NodeResizePending"
                 - pvc.status.allocatedResourceStatus['storage'] = "NodeResizeInProgress"
                 - pvc.status.allocatedResourceStatus['storage'] = "NodeResizeFailed"
            When this field is not set, it means that no resize operation is in progress for the given PVC.

            A controller that receives PVC update with previously unknown resourceName or ClaimResourceStatus should ignore the update for the purpose it was designed. For example - a controller that only is responsible for resizing capacity of the volume, should ignore PVC updates that change other valid resources associated with PVC.

            This is an alpha field and requires enabling RecoverVolumeExpansionFailure feature.
            """
            return self._set("allocated_resource_statuses", value)

        def allocated_resources(self, value: Optional[Dict[str, apimachinery.Quantity]], /) -> Self:
            """
            allocatedResources tracks the resources allocated to a PVC including its capacity. Key names follow standard Kubernetes label syntax. Valid values are either:
                * Un-prefixed keys:
                    - storage - the capacity of the volume.
                * Custom resources must use implementation-defined prefixed names such as "example.com/my-custom-resource"
            Apart from above values - keys that are unprefixed or have kubernetes.io prefix are considered reserved and hence may not be used.

            Capacity reported here may be larger than the actual capacity when a volume expansion operation is requested. For storage quota, the larger value from allocatedResources and PVC.spec.resources is used. If allocatedResources is not set, PVC.spec.resources alone is used for quota calculation. If a volume expansion capacity request is lowered, allocatedResources is only lowered if there are no expansion operations in progress and if the actual volume capacity is equal or lower than the requested capacity.

            A controller that receives PVC update with previously unknown resourceName should ignore the update for the purpose it was designed. For example - a controller that only is responsible for resizing capacity of the volume, should ignore PVC updates that change other valid resources associated with PVC.

            This is an alpha field and requires enabling RecoverVolumeExpansionFailure feature.
            """
            return self._set("allocated_resources", value)

        def capacity(self, value: Optional[Dict[str, apimachinery.Quantity]], /) -> Self:
            """
            capacity represents the actual resources of the underlying volume.
            """
            return self._set("capacity", value)

        @overload
        def conditions(
            self, value_or_callback: List[PersistentVolumeClaimCondition], /
        ) -> "PersistentVolumeClaimStatus.Builder": ...

        @overload
        def conditions(
            self,
            value_or_callback: Callable[
                [
                    GenericListBuilder[
                        PersistentVolumeClaimCondition,
                        PersistentVolumeClaimCondition.Builder,
                    ]
                ],
                GenericListBuilder[
                    PersistentVolumeClaimCondition,
                    PersistentVolumeClaimCondition.Builder,
                ]
                | List[PersistentVolumeClaimCondition],
            ],
            /,
        ) -> "PersistentVolumeClaimStatus.Builder": ...

        @overload
        def conditions(
            self, value_or_callback: Never = ...
        ) -> ListBuilderContext[PersistentVolumeClaimCondition.Builder]: ...

        def conditions(self, value_or_callback=None, /):
            """
            conditions is the current Condition of persistent volume claim. If underlying persistent volume is being resized then the Condition will be set to 'Resizing'.
            """
            if self._in_context and value_or_callback is None:
                context = ListBuilderContext[PersistentVolumeClaimCondition.Builder]()
                context._parent_builder = self
                context._field_name = "conditions"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(PersistentVolumeClaimCondition.list_builder())
                if isinstance(output, GenericListBuilder):
                    value = output.build()
                else:
                    value = output
            return self._set("conditions", value)

        def current_volume_attributes_class_name(self, value: Optional[str], /) -> Self:
            """
            currentVolumeAttributesClassName is the current name of the VolumeAttributesClass the PVC is using. When unset, there is no VolumeAttributeClass applied to this PersistentVolumeClaim This is a beta field and requires enabling VolumeAttributesClass feature (off by default).
            """
            return self._set("current_volume_attributes_class_name", value)

        @overload
        def modify_volume_status(
            self, value_or_callback: Optional[ModifyVolumeStatus], /
        ) -> "PersistentVolumeClaimStatus.Builder": ...

        @overload
        def modify_volume_status(
            self,
            value_or_callback: Callable[
                [ModifyVolumeStatus.Builder],
                ModifyVolumeStatus.Builder | ModifyVolumeStatus,
            ],
            /,
        ) -> "PersistentVolumeClaimStatus.Builder": ...

        @overload
        def modify_volume_status(
            self, value_or_callback: Never = ...
        ) -> "ModifyVolumeStatus.BuilderContext": ...

        def modify_volume_status(self, value_or_callback=None, /):
            """
            ModifyVolumeStatus represents the status object of ControllerModifyVolume operation. When this is unset, there is no ModifyVolume operation being attempted. This is a beta field and requires enabling VolumeAttributesClass feature (off by default).
            """
            if self._in_context and value_or_callback is None:
                context = ModifyVolumeStatus.BuilderContext()
                context._parent_builder = self
                context._field_name = "modify_volume_status"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(ModifyVolumeStatus.builder())
                if isinstance(output, ModifyVolumeStatus.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("modify_volume_status", value)

        def phase(self, value: Optional[str], /) -> Self:
            """
            phase represents the current phase of PersistentVolumeClaim.
            """
            return self._set("phase", value)

    class BuilderContext(BuilderContextBase["PersistentVolumeClaimStatus.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = PersistentVolumeClaimStatus.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for PersistentVolumeClaimStatus."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["PersistentVolumeClaimStatus", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use PersistentVolumeClaimStatus.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    access_modes: Annotated[Optional[List[str]], Field(alias="accessModes")] = None
    """
    accessModes contains the actual access modes the volume backing the PVC has. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#access-modes-1
    """
    allocated_resource_statuses: Annotated[
        Optional[Dict[str, str]], Field(alias="allocatedResourceStatuses")
    ] = None
    """
    allocatedResourceStatuses stores status of resource being resized for the given PVC. Key names follow standard Kubernetes label syntax. Valid values are either:
        * Un-prefixed keys:
            - storage - the capacity of the volume.
        * Custom resources must use implementation-defined prefixed names such as "example.com/my-custom-resource"
    Apart from above values - keys that are unprefixed or have kubernetes.io prefix are considered reserved and hence may not be used.

    ClaimResourceStatus can be in any of following states:
        - ControllerResizeInProgress:
            State set when resize controller starts resizing the volume in control-plane.
        - ControllerResizeFailed:
            State set when resize has failed in resize controller with a terminal error.
        - NodeResizePending:
            State set when resize controller has finished resizing the volume but further resizing of
            volume is needed on the node.
        - NodeResizeInProgress:
            State set when kubelet starts resizing the volume.
        - NodeResizeFailed:
            State set when resizing has failed in kubelet with a terminal error. Transient errors don't set
            NodeResizeFailed.
    For example: if expanding a PVC for more capacity - this field can be one of the following states:
        - pvc.status.allocatedResourceStatus['storage'] = "ControllerResizeInProgress"
         - pvc.status.allocatedResourceStatus['storage'] = "ControllerResizeFailed"
         - pvc.status.allocatedResourceStatus['storage'] = "NodeResizePending"
         - pvc.status.allocatedResourceStatus['storage'] = "NodeResizeInProgress"
         - pvc.status.allocatedResourceStatus['storage'] = "NodeResizeFailed"
    When this field is not set, it means that no resize operation is in progress for the given PVC.

    A controller that receives PVC update with previously unknown resourceName or ClaimResourceStatus should ignore the update for the purpose it was designed. For example - a controller that only is responsible for resizing capacity of the volume, should ignore PVC updates that change other valid resources associated with PVC.

    This is an alpha field and requires enabling RecoverVolumeExpansionFailure feature.
    """
    allocated_resources: Annotated[
        Optional[Dict[str, apimachinery.Quantity]], Field(alias="allocatedResources")
    ] = None
    """
    allocatedResources tracks the resources allocated to a PVC including its capacity. Key names follow standard Kubernetes label syntax. Valid values are either:
        * Un-prefixed keys:
            - storage - the capacity of the volume.
        * Custom resources must use implementation-defined prefixed names such as "example.com/my-custom-resource"
    Apart from above values - keys that are unprefixed or have kubernetes.io prefix are considered reserved and hence may not be used.

    Capacity reported here may be larger than the actual capacity when a volume expansion operation is requested. For storage quota, the larger value from allocatedResources and PVC.spec.resources is used. If allocatedResources is not set, PVC.spec.resources alone is used for quota calculation. If a volume expansion capacity request is lowered, allocatedResources is only lowered if there are no expansion operations in progress and if the actual volume capacity is equal or lower than the requested capacity.

    A controller that receives PVC update with previously unknown resourceName should ignore the update for the purpose it was designed. For example - a controller that only is responsible for resizing capacity of the volume, should ignore PVC updates that change other valid resources associated with PVC.

    This is an alpha field and requires enabling RecoverVolumeExpansionFailure feature.
    """
    capacity: Optional[Dict[str, apimachinery.Quantity]] = None
    """
    capacity represents the actual resources of the underlying volume.
    """
    conditions: Optional[List[PersistentVolumeClaimCondition]] = None
    """
    conditions is the current Condition of persistent volume claim. If underlying persistent volume is being resized then the Condition will be set to 'Resizing'.
    """
    current_volume_attributes_class_name: Annotated[
        Optional[str], Field(alias="currentVolumeAttributesClassName")
    ] = None
    """
    currentVolumeAttributesClassName is the current name of the VolumeAttributesClass the PVC is using. When unset, there is no VolumeAttributeClass applied to this PersistentVolumeClaim This is a beta field and requires enabling VolumeAttributesClass feature (off by default).
    """
    modify_volume_status: Annotated[
        Optional[ModifyVolumeStatus], Field(alias="modifyVolumeStatus")
    ] = None
    """
    ModifyVolumeStatus represents the status object of ControllerModifyVolume operation. When this is unset, there is no ModifyVolume operation being attempted. This is a beta field and requires enabling VolumeAttributesClass feature (off by default).
    """
    phase: Optional[str] = None
    """
    phase represents the current phase of PersistentVolumeClaim.
    """


class PersistentVolumeStatus(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["PersistentVolumeStatus"]:
            return PersistentVolumeStatus

        def build(self) -> "PersistentVolumeStatus":
            return PersistentVolumeStatus(**self._attrs)

        @overload
        def last_phase_transition_time(
            self, value_or_callback: Optional[apimachinery.Time], /
        ) -> "PersistentVolumeStatus.Builder": ...

        @overload
        def last_phase_transition_time(
            self,
            value_or_callback: Callable[
                [apimachinery.Time.Builder],
                apimachinery.Time.Builder | apimachinery.Time,
            ],
            /,
        ) -> "PersistentVolumeStatus.Builder": ...

        @overload
        def last_phase_transition_time(
            self, value_or_callback: Never = ...
        ) -> "apimachinery.Time.BuilderContext": ...

        def last_phase_transition_time(self, value_or_callback=None, /):
            """
            lastPhaseTransitionTime is the time the phase transitioned from one to another and automatically resets to current time everytime a volume phase transitions.
            """
            if self._in_context and value_or_callback is None:
                context = apimachinery.Time.BuilderContext()
                context._parent_builder = self
                context._field_name = "last_phase_transition_time"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(apimachinery.Time.builder())
                if isinstance(output, apimachinery.Time.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("last_phase_transition_time", value)

        def message(self, value: Optional[str], /) -> Self:
            """
            message is a human-readable message indicating details about why the volume is in this state.
            """
            return self._set("message", value)

        def phase(self, value: Optional[str], /) -> Self:
            """
            phase indicates if a volume is available, bound to a claim, or released by a claim. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#phase
            """
            return self._set("phase", value)

        def reason(self, value: Optional[str], /) -> Self:
            """
            reason is a brief CamelCase string that describes any failure and is meant for machine parsing and tidy display in the CLI.
            """
            return self._set("reason", value)

    class BuilderContext(BuilderContextBase["PersistentVolumeStatus.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = PersistentVolumeStatus.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for PersistentVolumeStatus."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["PersistentVolumeStatus", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use PersistentVolumeStatus.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    last_phase_transition_time: Annotated[
        Optional[apimachinery.Time], Field(alias="lastPhaseTransitionTime")
    ] = None
    """
    lastPhaseTransitionTime is the time the phase transitioned from one to another and automatically resets to current time everytime a volume phase transitions.
    """
    message: Optional[str] = None
    """
    message is a human-readable message indicating details about why the volume is in this state.
    """
    phase: Optional[str] = None
    """
    phase indicates if a volume is available, bound to a claim, or released by a claim. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#phase
    """
    reason: Optional[str] = None
    """
    reason is a brief CamelCase string that describes any failure and is meant for machine parsing and tidy display in the CLI.
    """


class PodCondition(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["PodCondition"]:
            return PodCondition

        def build(self) -> "PodCondition":
            return PodCondition(**self._attrs)

        @overload
        def last_probe_time(
            self, value_or_callback: Optional[apimachinery.Time], /
        ) -> "PodCondition.Builder": ...

        @overload
        def last_probe_time(
            self,
            value_or_callback: Callable[
                [apimachinery.Time.Builder],
                apimachinery.Time.Builder | apimachinery.Time,
            ],
            /,
        ) -> "PodCondition.Builder": ...

        @overload
        def last_probe_time(
            self, value_or_callback: Never = ...
        ) -> "apimachinery.Time.BuilderContext": ...

        def last_probe_time(self, value_or_callback=None, /):
            """
            Last time we probed the condition.
            """
            if self._in_context and value_or_callback is None:
                context = apimachinery.Time.BuilderContext()
                context._parent_builder = self
                context._field_name = "last_probe_time"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(apimachinery.Time.builder())
                if isinstance(output, apimachinery.Time.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("last_probe_time", value)

        @overload
        def last_transition_time(
            self, value_or_callback: Optional[apimachinery.Time], /
        ) -> "PodCondition.Builder": ...

        @overload
        def last_transition_time(
            self,
            value_or_callback: Callable[
                [apimachinery.Time.Builder],
                apimachinery.Time.Builder | apimachinery.Time,
            ],
            /,
        ) -> "PodCondition.Builder": ...

        @overload
        def last_transition_time(
            self, value_or_callback: Never = ...
        ) -> "apimachinery.Time.BuilderContext": ...

        def last_transition_time(self, value_or_callback=None, /):
            """
            Last time the condition transitioned from one status to another.
            """
            if self._in_context and value_or_callback is None:
                context = apimachinery.Time.BuilderContext()
                context._parent_builder = self
                context._field_name = "last_transition_time"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(apimachinery.Time.builder())
                if isinstance(output, apimachinery.Time.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("last_transition_time", value)

        def message(self, value: Optional[str], /) -> Self:
            """
            Human-readable message indicating details about last transition.
            """
            return self._set("message", value)

        def reason(self, value: Optional[str], /) -> Self:
            """
            Unique, one-word, CamelCase reason for the condition's last transition.
            """
            return self._set("reason", value)

        def status(self, value: str, /) -> Self:
            """
            Status is the status of the condition. Can be True, False, Unknown. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#pod-conditions
            """
            return self._set("status", value)

        def type(self, value: str, /) -> Self:
            """
            Type is the type of the condition. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#pod-conditions
            """
            return self._set("type", value)

    class BuilderContext(BuilderContextBase["PodCondition.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = PodCondition.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for PodCondition."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["PodCondition", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use PodCondition.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    last_probe_time: Annotated[Optional[apimachinery.Time], Field(alias="lastProbeTime")] = None
    """
    Last time we probed the condition.
    """
    last_transition_time: Annotated[
        Optional[apimachinery.Time], Field(alias="lastTransitionTime")
    ] = None
    """
    Last time the condition transitioned from one status to another.
    """
    message: Optional[str] = None
    """
    Human-readable message indicating details about last transition.
    """
    reason: Optional[str] = None
    """
    Unique, one-word, CamelCase reason for the condition's last transition.
    """
    status: str
    """
    Status is the status of the condition. Can be True, False, Unknown. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#pod-conditions
    """
    type: str
    """
    Type is the type of the condition. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#pod-conditions
    """


class PodDNSConfig(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["PodDNSConfig"]:
            return PodDNSConfig

        def build(self) -> "PodDNSConfig":
            return PodDNSConfig(**self._attrs)

        def nameservers(self, value: Optional[List[str]], /) -> Self:
            """
            A list of DNS name server IP addresses. This will be appended to the base nameservers generated from DNSPolicy. Duplicated nameservers will be removed.
            """
            return self._set("nameservers", value)

        @overload
        def options(
            self, value_or_callback: List[PodDNSConfigOption], /
        ) -> "PodDNSConfig.Builder": ...

        @overload
        def options(
            self,
            value_or_callback: Callable[
                [GenericListBuilder[PodDNSConfigOption, PodDNSConfigOption.Builder]],
                GenericListBuilder[PodDNSConfigOption, PodDNSConfigOption.Builder]
                | List[PodDNSConfigOption],
            ],
            /,
        ) -> "PodDNSConfig.Builder": ...

        @overload
        def options(
            self, value_or_callback: Never = ...
        ) -> ListBuilderContext[PodDNSConfigOption.Builder]: ...

        def options(self, value_or_callback=None, /):
            """
            A list of DNS resolver options. This will be merged with the base options generated from DNSPolicy. Duplicated entries will be removed. Resolution options given in Options will override those that appear in the base DNSPolicy.
            """
            if self._in_context and value_or_callback is None:
                context = ListBuilderContext[PodDNSConfigOption.Builder]()
                context._parent_builder = self
                context._field_name = "options"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(PodDNSConfigOption.list_builder())
                if isinstance(output, GenericListBuilder):
                    value = output.build()
                else:
                    value = output
            return self._set("options", value)

        def searches(self, value: Optional[List[str]], /) -> Self:
            """
            A list of DNS search domains for host-name lookup. This will be appended to the base search paths generated from DNSPolicy. Duplicated search paths will be removed.
            """
            return self._set("searches", value)

    class BuilderContext(BuilderContextBase["PodDNSConfig.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = PodDNSConfig.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for PodDNSConfig."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["PodDNSConfig", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use PodDNSConfig.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    nameservers: Optional[List[str]] = None
    """
    A list of DNS name server IP addresses. This will be appended to the base nameservers generated from DNSPolicy. Duplicated nameservers will be removed.
    """
    options: Optional[List[PodDNSConfigOption]] = None
    """
    A list of DNS resolver options. This will be merged with the base options generated from DNSPolicy. Duplicated entries will be removed. Resolution options given in Options will override those that appear in the base DNSPolicy.
    """
    searches: Optional[List[str]] = None
    """
    A list of DNS search domains for host-name lookup. This will be appended to the base search paths generated from DNSPolicy. Duplicated search paths will be removed.
    """


class PodSecurityContext(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["PodSecurityContext"]:
            return PodSecurityContext

        def build(self) -> "PodSecurityContext":
            return PodSecurityContext(**self._attrs)

        @overload
        def app_armor_profile(
            self, value_or_callback: Optional[AppArmorProfile], /
        ) -> "PodSecurityContext.Builder": ...

        @overload
        def app_armor_profile(
            self,
            value_or_callback: Callable[
                [AppArmorProfile.Builder], AppArmorProfile.Builder | AppArmorProfile
            ],
            /,
        ) -> "PodSecurityContext.Builder": ...

        @overload
        def app_armor_profile(
            self, value_or_callback: Never = ...
        ) -> "AppArmorProfile.BuilderContext": ...

        def app_armor_profile(self, value_or_callback=None, /):
            """
            appArmorProfile is the AppArmor options to use by the containers in this pod. Note that this field cannot be set when spec.os.name is windows.
            """
            if self._in_context and value_or_callback is None:
                context = AppArmorProfile.BuilderContext()
                context._parent_builder = self
                context._field_name = "app_armor_profile"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(AppArmorProfile.builder())
                if isinstance(output, AppArmorProfile.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("app_armor_profile", value)

        def fs_group(self, value: Optional[int], /) -> Self:
            """
            A special supplemental group that applies to all containers in a pod. Some volume types allow the Kubelet to change the ownership of that volume to be owned by the pod:

            1. The owning GID will be the FSGroup 2. The setgid bit is set (new files created in the volume will be owned by FSGroup) 3. The permission bits are OR'd with rw-rw----

            If unset, the Kubelet will not modify the ownership and permissions of any volume. Note that this field cannot be set when spec.os.name is windows.
            """
            return self._set("fs_group", value)

        def fs_group_change_policy(self, value: Optional[str], /) -> Self:
            """
            fsGroupChangePolicy defines behavior of changing ownership and permission of the volume before being exposed inside Pod. This field will only apply to volume types which support fsGroup based ownership(and permissions). It will have no effect on ephemeral volume types such as: secret, configmaps and emptydir. Valid values are "OnRootMismatch" and "Always". If not specified, "Always" is used. Note that this field cannot be set when spec.os.name is windows.
            """
            return self._set("fs_group_change_policy", value)

        def run_as_group(self, value: Optional[int], /) -> Self:
            """
            The GID to run the entrypoint of the container process. Uses runtime default if unset. May also be set in SecurityContext.  If set in both SecurityContext and PodSecurityContext, the value specified in SecurityContext takes precedence for that container. Note that this field cannot be set when spec.os.name is windows.
            """
            return self._set("run_as_group", value)

        def run_as_non_root(self, value: Optional[bool], /) -> Self:
            """
            Indicates that the container must run as a non-root user. If true, the Kubelet will validate the image at runtime to ensure that it does not run as UID 0 (root) and fail to start the container if it does. If unset or false, no such validation will be performed. May also be set in SecurityContext.  If set in both SecurityContext and PodSecurityContext, the value specified in SecurityContext takes precedence.
            """
            return self._set("run_as_non_root", value)

        def run_as_user(self, value: Optional[int], /) -> Self:
            """
            The UID to run the entrypoint of the container process. Defaults to user specified in image metadata if unspecified. May also be set in SecurityContext.  If set in both SecurityContext and PodSecurityContext, the value specified in SecurityContext takes precedence for that container. Note that this field cannot be set when spec.os.name is windows.
            """
            return self._set("run_as_user", value)

        @overload
        def se_linux_options(
            self, value_or_callback: Optional[SELinuxOptions], /
        ) -> "PodSecurityContext.Builder": ...

        @overload
        def se_linux_options(
            self,
            value_or_callback: Callable[
                [SELinuxOptions.Builder], SELinuxOptions.Builder | SELinuxOptions
            ],
            /,
        ) -> "PodSecurityContext.Builder": ...

        @overload
        def se_linux_options(
            self, value_or_callback: Never = ...
        ) -> "SELinuxOptions.BuilderContext": ...

        def se_linux_options(self, value_or_callback=None, /):
            """
            The SELinux context to be applied to all containers. If unspecified, the container runtime will allocate a random SELinux context for each container.  May also be set in SecurityContext.  If set in both SecurityContext and PodSecurityContext, the value specified in SecurityContext takes precedence for that container. Note that this field cannot be set when spec.os.name is windows.
            """
            if self._in_context and value_or_callback is None:
                context = SELinuxOptions.BuilderContext()
                context._parent_builder = self
                context._field_name = "se_linux_options"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(SELinuxOptions.builder())
                if isinstance(output, SELinuxOptions.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("se_linux_options", value)

        @overload
        def seccomp_profile(
            self, value_or_callback: Optional[SeccompProfile], /
        ) -> "PodSecurityContext.Builder": ...

        @overload
        def seccomp_profile(
            self,
            value_or_callback: Callable[
                [SeccompProfile.Builder], SeccompProfile.Builder | SeccompProfile
            ],
            /,
        ) -> "PodSecurityContext.Builder": ...

        @overload
        def seccomp_profile(
            self, value_or_callback: Never = ...
        ) -> "SeccompProfile.BuilderContext": ...

        def seccomp_profile(self, value_or_callback=None, /):
            """
            The seccomp options to use by the containers in this pod. Note that this field cannot be set when spec.os.name is windows.
            """
            if self._in_context and value_or_callback is None:
                context = SeccompProfile.BuilderContext()
                context._parent_builder = self
                context._field_name = "seccomp_profile"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(SeccompProfile.builder())
                if isinstance(output, SeccompProfile.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("seccomp_profile", value)

        def supplemental_groups(self, value: Optional[List[int]], /) -> Self:
            """
            A list of groups applied to the first process run in each container, in addition to the container's primary GID and fsGroup (if specified).  If the SupplementalGroupsPolicy feature is enabled, the supplementalGroupsPolicy field determines whether these are in addition to or instead of any group memberships defined in the container image. If unspecified, no additional groups are added, though group memberships defined in the container image may still be used, depending on the supplementalGroupsPolicy field. Note that this field cannot be set when spec.os.name is windows.
            """
            return self._set("supplemental_groups", value)

        def supplemental_groups_policy(self, value: Optional[str], /) -> Self:
            """
            Defines how supplemental groups of the first container processes are calculated. Valid values are "Merge" and "Strict". If not specified, "Merge" is used. (Alpha) Using the field requires the SupplementalGroupsPolicy feature gate to be enabled and the container runtime must implement support for this feature. Note that this field cannot be set when spec.os.name is windows.
            """
            return self._set("supplemental_groups_policy", value)

        @overload
        def sysctls(self, value_or_callback: List[Sysctl], /) -> "PodSecurityContext.Builder": ...

        @overload
        def sysctls(
            self,
            value_or_callback: Callable[
                [GenericListBuilder[Sysctl, Sysctl.Builder]],
                GenericListBuilder[Sysctl, Sysctl.Builder] | List[Sysctl],
            ],
            /,
        ) -> "PodSecurityContext.Builder": ...

        @overload
        def sysctls(self, value_or_callback: Never = ...) -> ListBuilderContext[Sysctl.Builder]: ...

        def sysctls(self, value_or_callback=None, /):
            """
            Sysctls hold a list of namespaced sysctls used for the pod. Pods with unsupported sysctls (by the container runtime) might fail to launch. Note that this field cannot be set when spec.os.name is windows.
            """
            if self._in_context and value_or_callback is None:
                context = ListBuilderContext[Sysctl.Builder]()
                context._parent_builder = self
                context._field_name = "sysctls"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(Sysctl.list_builder())
                if isinstance(output, GenericListBuilder):
                    value = output.build()
                else:
                    value = output
            return self._set("sysctls", value)

        @overload
        def windows_options(
            self, value_or_callback: Optional[WindowsSecurityContextOptions], /
        ) -> "PodSecurityContext.Builder": ...

        @overload
        def windows_options(
            self,
            value_or_callback: Callable[
                [WindowsSecurityContextOptions.Builder],
                WindowsSecurityContextOptions.Builder | WindowsSecurityContextOptions,
            ],
            /,
        ) -> "PodSecurityContext.Builder": ...

        @overload
        def windows_options(
            self, value_or_callback: Never = ...
        ) -> "WindowsSecurityContextOptions.BuilderContext": ...

        def windows_options(self, value_or_callback=None, /):
            """
            The Windows specific settings applied to all containers. If unspecified, the options within a container's SecurityContext will be used. If set in both SecurityContext and PodSecurityContext, the value specified in SecurityContext takes precedence. Note that this field cannot be set when spec.os.name is linux.
            """
            if self._in_context and value_or_callback is None:
                context = WindowsSecurityContextOptions.BuilderContext()
                context._parent_builder = self
                context._field_name = "windows_options"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(WindowsSecurityContextOptions.builder())
                if isinstance(output, WindowsSecurityContextOptions.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("windows_options", value)

    class BuilderContext(BuilderContextBase["PodSecurityContext.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = PodSecurityContext.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for PodSecurityContext."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["PodSecurityContext", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use PodSecurityContext.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    app_armor_profile: Annotated[Optional[AppArmorProfile], Field(alias="appArmorProfile")] = None
    """
    appArmorProfile is the AppArmor options to use by the containers in this pod. Note that this field cannot be set when spec.os.name is windows.
    """
    fs_group: Annotated[Optional[int], Field(alias="fsGroup")] = None
    """
    A special supplemental group that applies to all containers in a pod. Some volume types allow the Kubelet to change the ownership of that volume to be owned by the pod:

    1. The owning GID will be the FSGroup 2. The setgid bit is set (new files created in the volume will be owned by FSGroup) 3. The permission bits are OR'd with rw-rw----

    If unset, the Kubelet will not modify the ownership and permissions of any volume. Note that this field cannot be set when spec.os.name is windows.
    """
    fs_group_change_policy: Annotated[Optional[str], Field(alias="fsGroupChangePolicy")] = None
    """
    fsGroupChangePolicy defines behavior of changing ownership and permission of the volume before being exposed inside Pod. This field will only apply to volume types which support fsGroup based ownership(and permissions). It will have no effect on ephemeral volume types such as: secret, configmaps and emptydir. Valid values are "OnRootMismatch" and "Always". If not specified, "Always" is used. Note that this field cannot be set when spec.os.name is windows.
    """
    run_as_group: Annotated[Optional[int], Field(alias="runAsGroup")] = None
    """
    The GID to run the entrypoint of the container process. Uses runtime default if unset. May also be set in SecurityContext.  If set in both SecurityContext and PodSecurityContext, the value specified in SecurityContext takes precedence for that container. Note that this field cannot be set when spec.os.name is windows.
    """
    run_as_non_root: Annotated[Optional[bool], Field(alias="runAsNonRoot")] = None
    """
    Indicates that the container must run as a non-root user. If true, the Kubelet will validate the image at runtime to ensure that it does not run as UID 0 (root) and fail to start the container if it does. If unset or false, no such validation will be performed. May also be set in SecurityContext.  If set in both SecurityContext and PodSecurityContext, the value specified in SecurityContext takes precedence.
    """
    run_as_user: Annotated[Optional[int], Field(alias="runAsUser")] = None
    """
    The UID to run the entrypoint of the container process. Defaults to user specified in image metadata if unspecified. May also be set in SecurityContext.  If set in both SecurityContext and PodSecurityContext, the value specified in SecurityContext takes precedence for that container. Note that this field cannot be set when spec.os.name is windows.
    """
    se_linux_options: Annotated[Optional[SELinuxOptions], Field(alias="seLinuxOptions")] = None
    """
    The SELinux context to be applied to all containers. If unspecified, the container runtime will allocate a random SELinux context for each container.  May also be set in SecurityContext.  If set in both SecurityContext and PodSecurityContext, the value specified in SecurityContext takes precedence for that container. Note that this field cannot be set when spec.os.name is windows.
    """
    seccomp_profile: Annotated[Optional[SeccompProfile], Field(alias="seccompProfile")] = None
    """
    The seccomp options to use by the containers in this pod. Note that this field cannot be set when spec.os.name is windows.
    """
    supplemental_groups: Annotated[Optional[List[int]], Field(alias="supplementalGroups")] = None
    """
    A list of groups applied to the first process run in each container, in addition to the container's primary GID and fsGroup (if specified).  If the SupplementalGroupsPolicy feature is enabled, the supplementalGroupsPolicy field determines whether these are in addition to or instead of any group memberships defined in the container image. If unspecified, no additional groups are added, though group memberships defined in the container image may still be used, depending on the supplementalGroupsPolicy field. Note that this field cannot be set when spec.os.name is windows.
    """
    supplemental_groups_policy: Annotated[
        Optional[str], Field(alias="supplementalGroupsPolicy")
    ] = None
    """
    Defines how supplemental groups of the first container processes are calculated. Valid values are "Merge" and "Strict". If not specified, "Merge" is used. (Alpha) Using the field requires the SupplementalGroupsPolicy feature gate to be enabled and the container runtime must implement support for this feature. Note that this field cannot be set when spec.os.name is windows.
    """
    sysctls: Optional[List[Sysctl]] = None
    """
    Sysctls hold a list of namespaced sysctls used for the pod. Pods with unsupported sysctls (by the container runtime) might fail to launch. Note that this field cannot be set when spec.os.name is windows.
    """
    windows_options: Annotated[
        Optional[WindowsSecurityContextOptions], Field(alias="windowsOptions")
    ] = None
    """
    The Windows specific settings applied to all containers. If unspecified, the options within a container's SecurityContext will be used. If set in both SecurityContext and PodSecurityContext, the value specified in SecurityContext takes precedence. Note that this field cannot be set when spec.os.name is linux.
    """


class RBDPersistentVolumeSource(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["RBDPersistentVolumeSource"]:
            return RBDPersistentVolumeSource

        def build(self) -> "RBDPersistentVolumeSource":
            return RBDPersistentVolumeSource(**self._attrs)

        def fs_type(self, value: Optional[str], /) -> Self:
            """
            fsType is the filesystem type of the volume that you want to mount. Tip: Ensure that the filesystem type is supported by the host operating system. Examples: "ext4", "xfs", "ntfs". Implicitly inferred to be "ext4" if unspecified. More info: https://kubernetes.io/docs/concepts/storage/volumes#rbd
            """
            return self._set("fs_type", value)

        def image(self, value: str, /) -> Self:
            """
            image is the rados image name. More info: https://examples.k8s.io/volumes/rbd/README.md#how-to-use-it
            """
            return self._set("image", value)

        def keyring(self, value: Optional[str], /) -> Self:
            """
            keyring is the path to key ring for RBDUser. Default is /etc/ceph/keyring. More info: https://examples.k8s.io/volumes/rbd/README.md#how-to-use-it
            """
            return self._set("keyring", value)

        def monitors(self, value: List[str], /) -> Self:
            """
            monitors is a collection of Ceph monitors. More info: https://examples.k8s.io/volumes/rbd/README.md#how-to-use-it
            """
            return self._set("monitors", value)

        def pool(self, value: Optional[str], /) -> Self:
            """
            pool is the rados pool name. Default is rbd. More info: https://examples.k8s.io/volumes/rbd/README.md#how-to-use-it
            """
            return self._set("pool", value)

        def read_only(self, value: Optional[bool], /) -> Self:
            """
            readOnly here will force the ReadOnly setting in VolumeMounts. Defaults to false. More info: https://examples.k8s.io/volumes/rbd/README.md#how-to-use-it
            """
            return self._set("read_only", value)

        @overload
        def secret_ref(
            self, value_or_callback: Optional[SecretReference], /
        ) -> "RBDPersistentVolumeSource.Builder": ...

        @overload
        def secret_ref(
            self,
            value_or_callback: Callable[
                [SecretReference.Builder], SecretReference.Builder | SecretReference
            ],
            /,
        ) -> "RBDPersistentVolumeSource.Builder": ...

        @overload
        def secret_ref(
            self, value_or_callback: Never = ...
        ) -> "SecretReference.BuilderContext": ...

        def secret_ref(self, value_or_callback=None, /):
            """
            secretRef is name of the authentication secret for RBDUser. If provided overrides keyring. Default is nil. More info: https://examples.k8s.io/volumes/rbd/README.md#how-to-use-it
            """
            if self._in_context and value_or_callback is None:
                context = SecretReference.BuilderContext()
                context._parent_builder = self
                context._field_name = "secret_ref"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(SecretReference.builder())
                if isinstance(output, SecretReference.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("secret_ref", value)

        def user(self, value: Optional[str], /) -> Self:
            """
            user is the rados user name. Default is admin. More info: https://examples.k8s.io/volumes/rbd/README.md#how-to-use-it
            """
            return self._set("user", value)

    class BuilderContext(BuilderContextBase["RBDPersistentVolumeSource.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = RBDPersistentVolumeSource.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for RBDPersistentVolumeSource."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["RBDPersistentVolumeSource", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use RBDPersistentVolumeSource.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    fs_type: Annotated[Optional[str], Field(alias="fsType")] = None
    """
    fsType is the filesystem type of the volume that you want to mount. Tip: Ensure that the filesystem type is supported by the host operating system. Examples: "ext4", "xfs", "ntfs". Implicitly inferred to be "ext4" if unspecified. More info: https://kubernetes.io/docs/concepts/storage/volumes#rbd
    """
    image: str
    """
    image is the rados image name. More info: https://examples.k8s.io/volumes/rbd/README.md#how-to-use-it
    """
    keyring: Optional[str] = None
    """
    keyring is the path to key ring for RBDUser. Default is /etc/ceph/keyring. More info: https://examples.k8s.io/volumes/rbd/README.md#how-to-use-it
    """
    monitors: List[str]
    """
    monitors is a collection of Ceph monitors. More info: https://examples.k8s.io/volumes/rbd/README.md#how-to-use-it
    """
    pool: Optional[str] = None
    """
    pool is the rados pool name. Default is rbd. More info: https://examples.k8s.io/volumes/rbd/README.md#how-to-use-it
    """
    read_only: Annotated[Optional[bool], Field(alias="readOnly")] = None
    """
    readOnly here will force the ReadOnly setting in VolumeMounts. Defaults to false. More info: https://examples.k8s.io/volumes/rbd/README.md#how-to-use-it
    """
    secret_ref: Annotated[Optional[SecretReference], Field(alias="secretRef")] = None
    """
    secretRef is name of the authentication secret for RBDUser. If provided overrides keyring. Default is nil. More info: https://examples.k8s.io/volumes/rbd/README.md#how-to-use-it
    """
    user: Optional[str] = None
    """
    user is the rados user name. Default is admin. More info: https://examples.k8s.io/volumes/rbd/README.md#how-to-use-it
    """


class ReplicationControllerCondition(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["ReplicationControllerCondition"]:
            return ReplicationControllerCondition

        def build(self) -> "ReplicationControllerCondition":
            return ReplicationControllerCondition(**self._attrs)

        @overload
        def last_transition_time(
            self, value_or_callback: Optional[apimachinery.Time], /
        ) -> "ReplicationControllerCondition.Builder": ...

        @overload
        def last_transition_time(
            self,
            value_or_callback: Callable[
                [apimachinery.Time.Builder],
                apimachinery.Time.Builder | apimachinery.Time,
            ],
            /,
        ) -> "ReplicationControllerCondition.Builder": ...

        @overload
        def last_transition_time(
            self, value_or_callback: Never = ...
        ) -> "apimachinery.Time.BuilderContext": ...

        def last_transition_time(self, value_or_callback=None, /):
            """
            The last time the condition transitioned from one status to another.
            """
            if self._in_context and value_or_callback is None:
                context = apimachinery.Time.BuilderContext()
                context._parent_builder = self
                context._field_name = "last_transition_time"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(apimachinery.Time.builder())
                if isinstance(output, apimachinery.Time.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("last_transition_time", value)

        def message(self, value: Optional[str], /) -> Self:
            """
            A human readable message indicating details about the transition.
            """
            return self._set("message", value)

        def reason(self, value: Optional[str], /) -> Self:
            """
            The reason for the condition's last transition.
            """
            return self._set("reason", value)

        def status(self, value: str, /) -> Self:
            """
            Status of the condition, one of True, False, Unknown.
            """
            return self._set("status", value)

        def type(self, value: str, /) -> Self:
            """
            Type of replication controller condition.
            """
            return self._set("type", value)

    class BuilderContext(BuilderContextBase["ReplicationControllerCondition.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = ReplicationControllerCondition.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for ReplicationControllerCondition."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["ReplicationControllerCondition", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use ReplicationControllerCondition.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    last_transition_time: Annotated[
        Optional[apimachinery.Time], Field(alias="lastTransitionTime")
    ] = None
    """
    The last time the condition transitioned from one status to another.
    """
    message: Optional[str] = None
    """
    A human readable message indicating details about the transition.
    """
    reason: Optional[str] = None
    """
    The reason for the condition's last transition.
    """
    status: str
    """
    Status of the condition, one of True, False, Unknown.
    """
    type: str
    """
    Type of replication controller condition.
    """


class ReplicationControllerStatus(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["ReplicationControllerStatus"]:
            return ReplicationControllerStatus

        def build(self) -> "ReplicationControllerStatus":
            return ReplicationControllerStatus(**self._attrs)

        def available_replicas(self, value: Optional[int], /) -> Self:
            """
            The number of available replicas (ready for at least minReadySeconds) for this replication controller.
            """
            return self._set("available_replicas", value)

        @overload
        def conditions(
            self, value_or_callback: List[ReplicationControllerCondition], /
        ) -> "ReplicationControllerStatus.Builder": ...

        @overload
        def conditions(
            self,
            value_or_callback: Callable[
                [
                    GenericListBuilder[
                        ReplicationControllerCondition,
                        ReplicationControllerCondition.Builder,
                    ]
                ],
                GenericListBuilder[
                    ReplicationControllerCondition,
                    ReplicationControllerCondition.Builder,
                ]
                | List[ReplicationControllerCondition],
            ],
            /,
        ) -> "ReplicationControllerStatus.Builder": ...

        @overload
        def conditions(
            self, value_or_callback: Never = ...
        ) -> ListBuilderContext[ReplicationControllerCondition.Builder]: ...

        def conditions(self, value_or_callback=None, /):
            """
            Represents the latest available observations of a replication controller's current state.
            """
            if self._in_context and value_or_callback is None:
                context = ListBuilderContext[ReplicationControllerCondition.Builder]()
                context._parent_builder = self
                context._field_name = "conditions"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(ReplicationControllerCondition.list_builder())
                if isinstance(output, GenericListBuilder):
                    value = output.build()
                else:
                    value = output
            return self._set("conditions", value)

        def fully_labeled_replicas(self, value: Optional[int], /) -> Self:
            """
            The number of pods that have labels matching the labels of the pod template of the replication controller.
            """
            return self._set("fully_labeled_replicas", value)

        def observed_generation(self, value: Optional[int], /) -> Self:
            """
            ObservedGeneration reflects the generation of the most recently observed replication controller.
            """
            return self._set("observed_generation", value)

        def ready_replicas(self, value: Optional[int], /) -> Self:
            """
            The number of ready replicas for this replication controller.
            """
            return self._set("ready_replicas", value)

        def replicas(self, value: int, /) -> Self:
            """
            Replicas is the most recently observed number of replicas. More info: https://kubernetes.io/docs/concepts/workloads/controllers/replicationcontroller#what-is-a-replicationcontroller
            """
            return self._set("replicas", value)

    class BuilderContext(BuilderContextBase["ReplicationControllerStatus.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = ReplicationControllerStatus.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for ReplicationControllerStatus."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["ReplicationControllerStatus", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use ReplicationControllerStatus.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    available_replicas: Annotated[Optional[int], Field(alias="availableReplicas")] = None
    """
    The number of available replicas (ready for at least minReadySeconds) for this replication controller.
    """
    conditions: Optional[List[ReplicationControllerCondition]] = None
    """
    Represents the latest available observations of a replication controller's current state.
    """
    fully_labeled_replicas: Annotated[Optional[int], Field(alias="fullyLabeledReplicas")] = None
    """
    The number of pods that have labels matching the labels of the pod template of the replication controller.
    """
    observed_generation: Annotated[Optional[int], Field(alias="observedGeneration")] = None
    """
    ObservedGeneration reflects the generation of the most recently observed replication controller.
    """
    ready_replicas: Annotated[Optional[int], Field(alias="readyReplicas")] = None
    """
    The number of ready replicas for this replication controller.
    """
    replicas: int
    """
    Replicas is the most recently observed number of replicas. More info: https://kubernetes.io/docs/concepts/workloads/controllers/replicationcontroller#what-is-a-replicationcontroller
    """


class ResourceFieldSelector(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["ResourceFieldSelector"]:
            return ResourceFieldSelector

        def build(self) -> "ResourceFieldSelector":
            return ResourceFieldSelector(**self._attrs)

        def container_name(self, value: Optional[str], /) -> Self:
            """
            Container name: required for volumes, optional for env vars
            """
            return self._set("container_name", value)

        @overload
        def divisor(
            self, value_or_callback: Optional[apimachinery.Quantity], /
        ) -> "ResourceFieldSelector.Builder": ...

        @overload
        def divisor(
            self,
            value_or_callback: Callable[
                [apimachinery.Quantity.Builder],
                apimachinery.Quantity.Builder | apimachinery.Quantity,
            ],
            /,
        ) -> "ResourceFieldSelector.Builder": ...

        @overload
        def divisor(
            self, value_or_callback: Never = ...
        ) -> "apimachinery.Quantity.BuilderContext": ...

        def divisor(self, value_or_callback=None, /):
            """
            Specifies the output format of the exposed resources, defaults to "1"
            """
            if self._in_context and value_or_callback is None:
                context = apimachinery.Quantity.BuilderContext()
                context._parent_builder = self
                context._field_name = "divisor"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(apimachinery.Quantity.builder())
                if isinstance(output, apimachinery.Quantity.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("divisor", value)

        def resource(self, value: str, /) -> Self:
            """
            Required: resource to select
            """
            return self._set("resource", value)

    class BuilderContext(BuilderContextBase["ResourceFieldSelector.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = ResourceFieldSelector.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for ResourceFieldSelector."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["ResourceFieldSelector", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use ResourceFieldSelector.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    container_name: Annotated[Optional[str], Field(alias="containerName")] = None
    """
    Container name: required for volumes, optional for env vars
    """
    divisor: Optional[apimachinery.Quantity] = None
    """
    Specifies the output format of the exposed resources, defaults to "1"
    """
    resource: str
    """
    Required: resource to select
    """


class ResourceQuotaStatus(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["ResourceQuotaStatus"]:
            return ResourceQuotaStatus

        def build(self) -> "ResourceQuotaStatus":
            return ResourceQuotaStatus(**self._attrs)

        def hard(self, value: Optional[Dict[str, apimachinery.Quantity]], /) -> Self:
            """
            Hard is the set of enforced hard limits for each named resource. More info: https://kubernetes.io/docs/concepts/policy/resource-quotas/
            """
            return self._set("hard", value)

        def used(self, value: Optional[Dict[str, apimachinery.Quantity]], /) -> Self:
            """
            Used is the current observed total usage of the resource in the namespace.
            """
            return self._set("used", value)

    class BuilderContext(BuilderContextBase["ResourceQuotaStatus.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = ResourceQuotaStatus.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for ResourceQuotaStatus."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["ResourceQuotaStatus", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use ResourceQuotaStatus.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    hard: Optional[Dict[str, apimachinery.Quantity]] = None
    """
    Hard is the set of enforced hard limits for each named resource. More info: https://kubernetes.io/docs/concepts/policy/resource-quotas/
    """
    used: Optional[Dict[str, apimachinery.Quantity]] = None
    """
    Used is the current observed total usage of the resource in the namespace.
    """


class ResourceRequirements(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["ResourceRequirements"]:
            return ResourceRequirements

        def build(self) -> "ResourceRequirements":
            return ResourceRequirements(**self._attrs)

        @overload
        def claims(
            self, value_or_callback: List[ResourceClaim], /
        ) -> "ResourceRequirements.Builder": ...

        @overload
        def claims(
            self,
            value_or_callback: Callable[
                [GenericListBuilder[ResourceClaim, ResourceClaim.Builder]],
                GenericListBuilder[ResourceClaim, ResourceClaim.Builder] | List[ResourceClaim],
            ],
            /,
        ) -> "ResourceRequirements.Builder": ...

        @overload
        def claims(
            self, value_or_callback: Never = ...
        ) -> ListBuilderContext[ResourceClaim.Builder]: ...

        def claims(self, value_or_callback=None, /):
            """
            Claims lists the names of resources, defined in spec.resourceClaims, that are used by this container.

            This is an alpha field and requires enabling the DynamicResourceAllocation feature gate.

            This field is immutable. It can only be set for containers.
            """
            if self._in_context and value_or_callback is None:
                context = ListBuilderContext[ResourceClaim.Builder]()
                context._parent_builder = self
                context._field_name = "claims"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(ResourceClaim.list_builder())
                if isinstance(output, GenericListBuilder):
                    value = output.build()
                else:
                    value = output
            return self._set("claims", value)

        def limits(self, value: Optional[Dict[str, apimachinery.Quantity]], /) -> Self:
            """
            Limits describes the maximum amount of compute resources allowed. More info: https://kubernetes.io/docs/concepts/configuration/manage-resources-containers/
            """
            return self._set("limits", value)

        def requests(self, value: Optional[Dict[str, apimachinery.Quantity]], /) -> Self:
            """
            Requests describes the minimum amount of compute resources required. If Requests is omitted for a container, it defaults to Limits if that is explicitly specified, otherwise to an implementation-defined value. Requests cannot exceed Limits. More info: https://kubernetes.io/docs/concepts/configuration/manage-resources-containers/
            """
            return self._set("requests", value)

    class BuilderContext(BuilderContextBase["ResourceRequirements.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = ResourceRequirements.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for ResourceRequirements."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["ResourceRequirements", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use ResourceRequirements.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    claims: Optional[List[ResourceClaim]] = None
    """
    Claims lists the names of resources, defined in spec.resourceClaims, that are used by this container.

    This is an alpha field and requires enabling the DynamicResourceAllocation feature gate.

    This field is immutable. It can only be set for containers.
    """
    limits: Optional[Dict[str, apimachinery.Quantity]] = None
    """
    Limits describes the maximum amount of compute resources allowed. More info: https://kubernetes.io/docs/concepts/configuration/manage-resources-containers/
    """
    requests: Optional[Dict[str, apimachinery.Quantity]] = None
    """
    Requests describes the minimum amount of compute resources required. If Requests is omitted for a container, it defaults to Limits if that is explicitly specified, otherwise to an implementation-defined value. Requests cannot exceed Limits. More info: https://kubernetes.io/docs/concepts/configuration/manage-resources-containers/
    """


class ScaleIOPersistentVolumeSource(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["ScaleIOPersistentVolumeSource"]:
            return ScaleIOPersistentVolumeSource

        def build(self) -> "ScaleIOPersistentVolumeSource":
            return ScaleIOPersistentVolumeSource(**self._attrs)

        def fs_type(self, value: Optional[str], /) -> Self:
            """
            fsType is the filesystem type to mount. Must be a filesystem type supported by the host operating system. Ex. "ext4", "xfs", "ntfs". Default is "xfs"
            """
            return self._set("fs_type", value)

        def gateway(self, value: str, /) -> Self:
            """
            gateway is the host address of the ScaleIO API Gateway.
            """
            return self._set("gateway", value)

        def protection_domain(self, value: Optional[str], /) -> Self:
            """
            protectionDomain is the name of the ScaleIO Protection Domain for the configured storage.
            """
            return self._set("protection_domain", value)

        def read_only(self, value: Optional[bool], /) -> Self:
            """
            readOnly defaults to false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts.
            """
            return self._set("read_only", value)

        @overload
        def secret_ref(
            self, value_or_callback: SecretReference, /
        ) -> "ScaleIOPersistentVolumeSource.Builder": ...

        @overload
        def secret_ref(
            self,
            value_or_callback: Callable[
                [SecretReference.Builder], SecretReference.Builder | SecretReference
            ],
            /,
        ) -> "ScaleIOPersistentVolumeSource.Builder": ...

        @overload
        def secret_ref(
            self, value_or_callback: Never = ...
        ) -> "SecretReference.BuilderContext": ...

        def secret_ref(self, value_or_callback=None, /):
            """
            secretRef references to the secret for ScaleIO user and other sensitive information. If this is not provided, Login operation will fail.
            """
            if self._in_context and value_or_callback is None:
                context = SecretReference.BuilderContext()
                context._parent_builder = self
                context._field_name = "secret_ref"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(SecretReference.builder())
                if isinstance(output, SecretReference.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("secret_ref", value)

        def ssl_enabled(self, value: Optional[bool], /) -> Self:
            """
            sslEnabled is the flag to enable/disable SSL communication with Gateway, default false
            """
            return self._set("ssl_enabled", value)

        def storage_mode(self, value: Optional[str], /) -> Self:
            """
            storageMode indicates whether the storage for a volume should be ThickProvisioned or ThinProvisioned. Default is ThinProvisioned.
            """
            return self._set("storage_mode", value)

        def storage_pool(self, value: Optional[str], /) -> Self:
            """
            storagePool is the ScaleIO Storage Pool associated with the protection domain.
            """
            return self._set("storage_pool", value)

        def system(self, value: str, /) -> Self:
            """
            system is the name of the storage system as configured in ScaleIO.
            """
            return self._set("system", value)

        def volume_name(self, value: Optional[str], /) -> Self:
            """
            volumeName is the name of a volume already created in the ScaleIO system that is associated with this volume source.
            """
            return self._set("volume_name", value)

    class BuilderContext(BuilderContextBase["ScaleIOPersistentVolumeSource.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = ScaleIOPersistentVolumeSource.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for ScaleIOPersistentVolumeSource."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["ScaleIOPersistentVolumeSource", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use ScaleIOPersistentVolumeSource.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    fs_type: Annotated[Optional[str], Field(alias="fsType")] = None
    """
    fsType is the filesystem type to mount. Must be a filesystem type supported by the host operating system. Ex. "ext4", "xfs", "ntfs". Default is "xfs"
    """
    gateway: str
    """
    gateway is the host address of the ScaleIO API Gateway.
    """
    protection_domain: Annotated[Optional[str], Field(alias="protectionDomain")] = None
    """
    protectionDomain is the name of the ScaleIO Protection Domain for the configured storage.
    """
    read_only: Annotated[Optional[bool], Field(alias="readOnly")] = None
    """
    readOnly defaults to false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts.
    """
    secret_ref: Annotated[SecretReference, Field(alias="secretRef")]
    """
    secretRef references to the secret for ScaleIO user and other sensitive information. If this is not provided, Login operation will fail.
    """
    ssl_enabled: Annotated[Optional[bool], Field(alias="sslEnabled")] = None
    """
    sslEnabled is the flag to enable/disable SSL communication with Gateway, default false
    """
    storage_mode: Annotated[Optional[str], Field(alias="storageMode")] = None
    """
    storageMode indicates whether the storage for a volume should be ThickProvisioned or ThinProvisioned. Default is ThinProvisioned.
    """
    storage_pool: Annotated[Optional[str], Field(alias="storagePool")] = None
    """
    storagePool is the ScaleIO Storage Pool associated with the protection domain.
    """
    system: str
    """
    system is the name of the storage system as configured in ScaleIO.
    """
    volume_name: Annotated[Optional[str], Field(alias="volumeName")] = None
    """
    volumeName is the name of a volume already created in the ScaleIO system that is associated with this volume source.
    """


class ScopeSelector(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["ScopeSelector"]:
            return ScopeSelector

        def build(self) -> "ScopeSelector":
            return ScopeSelector(**self._attrs)

        @overload
        def match_expressions(
            self, value_or_callback: List[ScopedResourceSelectorRequirement], /
        ) -> "ScopeSelector.Builder": ...

        @overload
        def match_expressions(
            self,
            value_or_callback: Callable[
                [
                    GenericListBuilder[
                        ScopedResourceSelectorRequirement,
                        ScopedResourceSelectorRequirement.Builder,
                    ]
                ],
                GenericListBuilder[
                    ScopedResourceSelectorRequirement,
                    ScopedResourceSelectorRequirement.Builder,
                ]
                | List[ScopedResourceSelectorRequirement],
            ],
            /,
        ) -> "ScopeSelector.Builder": ...

        @overload
        def match_expressions(
            self, value_or_callback: Never = ...
        ) -> ListBuilderContext[ScopedResourceSelectorRequirement.Builder]: ...

        def match_expressions(self, value_or_callback=None, /):
            """
            A list of scope selector requirements by scope of the resources.
            """
            if self._in_context and value_or_callback is None:
                context = ListBuilderContext[ScopedResourceSelectorRequirement.Builder]()
                context._parent_builder = self
                context._field_name = "match_expressions"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(ScopedResourceSelectorRequirement.list_builder())
                if isinstance(output, GenericListBuilder):
                    value = output.build()
                else:
                    value = output
            return self._set("match_expressions", value)

    class BuilderContext(BuilderContextBase["ScopeSelector.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = ScopeSelector.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for ScopeSelector."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["ScopeSelector", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use ScopeSelector.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    match_expressions: Annotated[
        Optional[List[ScopedResourceSelectorRequirement]],
        Field(alias="matchExpressions"),
    ] = None
    """
    A list of scope selector requirements by scope of the resources.
    """


class SecurityContext(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["SecurityContext"]:
            return SecurityContext

        def build(self) -> "SecurityContext":
            return SecurityContext(**self._attrs)

        def allow_privilege_escalation(self, value: Optional[bool], /) -> Self:
            """
            AllowPrivilegeEscalation controls whether a process can gain more privileges than its parent process. This bool directly controls if the no_new_privs flag will be set on the container process. AllowPrivilegeEscalation is true always when the container is: 1) run as Privileged 2) has CAP_SYS_ADMIN Note that this field cannot be set when spec.os.name is windows.
            """
            return self._set("allow_privilege_escalation", value)

        @overload
        def app_armor_profile(
            self, value_or_callback: Optional[AppArmorProfile], /
        ) -> "SecurityContext.Builder": ...

        @overload
        def app_armor_profile(
            self,
            value_or_callback: Callable[
                [AppArmorProfile.Builder], AppArmorProfile.Builder | AppArmorProfile
            ],
            /,
        ) -> "SecurityContext.Builder": ...

        @overload
        def app_armor_profile(
            self, value_or_callback: Never = ...
        ) -> "AppArmorProfile.BuilderContext": ...

        def app_armor_profile(self, value_or_callback=None, /):
            """
            appArmorProfile is the AppArmor options to use by this container. If set, this profile overrides the pod's appArmorProfile. Note that this field cannot be set when spec.os.name is windows.
            """
            if self._in_context and value_or_callback is None:
                context = AppArmorProfile.BuilderContext()
                context._parent_builder = self
                context._field_name = "app_armor_profile"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(AppArmorProfile.builder())
                if isinstance(output, AppArmorProfile.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("app_armor_profile", value)

        @overload
        def capabilities(
            self, value_or_callback: Optional[Capabilities], /
        ) -> "SecurityContext.Builder": ...

        @overload
        def capabilities(
            self,
            value_or_callback: Callable[
                [Capabilities.Builder], Capabilities.Builder | Capabilities
            ],
            /,
        ) -> "SecurityContext.Builder": ...

        @overload
        def capabilities(self, value_or_callback: Never = ...) -> "Capabilities.BuilderContext": ...

        def capabilities(self, value_or_callback=None, /):
            """
            The capabilities to add/drop when running containers. Defaults to the default set of capabilities granted by the container runtime. Note that this field cannot be set when spec.os.name is windows.
            """
            if self._in_context and value_or_callback is None:
                context = Capabilities.BuilderContext()
                context._parent_builder = self
                context._field_name = "capabilities"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(Capabilities.builder())
                if isinstance(output, Capabilities.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("capabilities", value)

        def privileged(self, value: Optional[bool], /) -> Self:
            """
            Run container in privileged mode. Processes in privileged containers are essentially equivalent to root on the host. Defaults to false. Note that this field cannot be set when spec.os.name is windows.
            """
            return self._set("privileged", value)

        def proc_mount(self, value: Optional[str], /) -> Self:
            """
            procMount denotes the type of proc mount to use for the containers. The default value is Default which uses the container runtime defaults for readonly paths and masked paths. This requires the ProcMountType feature flag to be enabled. Note that this field cannot be set when spec.os.name is windows.
            """
            return self._set("proc_mount", value)

        def read_only_root_filesystem(self, value: Optional[bool], /) -> Self:
            """
            Whether this container has a read-only root filesystem. Default is false. Note that this field cannot be set when spec.os.name is windows.
            """
            return self._set("read_only_root_filesystem", value)

        def run_as_group(self, value: Optional[int], /) -> Self:
            """
            The GID to run the entrypoint of the container process. Uses runtime default if unset. May also be set in PodSecurityContext.  If set in both SecurityContext and PodSecurityContext, the value specified in SecurityContext takes precedence. Note that this field cannot be set when spec.os.name is windows.
            """
            return self._set("run_as_group", value)

        def run_as_non_root(self, value: Optional[bool], /) -> Self:
            """
            Indicates that the container must run as a non-root user. If true, the Kubelet will validate the image at runtime to ensure that it does not run as UID 0 (root) and fail to start the container if it does. If unset or false, no such validation will be performed. May also be set in PodSecurityContext.  If set in both SecurityContext and PodSecurityContext, the value specified in SecurityContext takes precedence.
            """
            return self._set("run_as_non_root", value)

        def run_as_user(self, value: Optional[int], /) -> Self:
            """
            The UID to run the entrypoint of the container process. Defaults to user specified in image metadata if unspecified. May also be set in PodSecurityContext.  If set in both SecurityContext and PodSecurityContext, the value specified in SecurityContext takes precedence. Note that this field cannot be set when spec.os.name is windows.
            """
            return self._set("run_as_user", value)

        @overload
        def se_linux_options(
            self, value_or_callback: Optional[SELinuxOptions], /
        ) -> "SecurityContext.Builder": ...

        @overload
        def se_linux_options(
            self,
            value_or_callback: Callable[
                [SELinuxOptions.Builder], SELinuxOptions.Builder | SELinuxOptions
            ],
            /,
        ) -> "SecurityContext.Builder": ...

        @overload
        def se_linux_options(
            self, value_or_callback: Never = ...
        ) -> "SELinuxOptions.BuilderContext": ...

        def se_linux_options(self, value_or_callback=None, /):
            """
            The SELinux context to be applied to the container. If unspecified, the container runtime will allocate a random SELinux context for each container.  May also be set in PodSecurityContext.  If set in both SecurityContext and PodSecurityContext, the value specified in SecurityContext takes precedence. Note that this field cannot be set when spec.os.name is windows.
            """
            if self._in_context and value_or_callback is None:
                context = SELinuxOptions.BuilderContext()
                context._parent_builder = self
                context._field_name = "se_linux_options"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(SELinuxOptions.builder())
                if isinstance(output, SELinuxOptions.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("se_linux_options", value)

        @overload
        def seccomp_profile(
            self, value_or_callback: Optional[SeccompProfile], /
        ) -> "SecurityContext.Builder": ...

        @overload
        def seccomp_profile(
            self,
            value_or_callback: Callable[
                [SeccompProfile.Builder], SeccompProfile.Builder | SeccompProfile
            ],
            /,
        ) -> "SecurityContext.Builder": ...

        @overload
        def seccomp_profile(
            self, value_or_callback: Never = ...
        ) -> "SeccompProfile.BuilderContext": ...

        def seccomp_profile(self, value_or_callback=None, /):
            """
            The seccomp options to use by this container. If seccomp options are provided at both the pod & container level, the container options override the pod options. Note that this field cannot be set when spec.os.name is windows.
            """
            if self._in_context and value_or_callback is None:
                context = SeccompProfile.BuilderContext()
                context._parent_builder = self
                context._field_name = "seccomp_profile"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(SeccompProfile.builder())
                if isinstance(output, SeccompProfile.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("seccomp_profile", value)

        @overload
        def windows_options(
            self, value_or_callback: Optional[WindowsSecurityContextOptions], /
        ) -> "SecurityContext.Builder": ...

        @overload
        def windows_options(
            self,
            value_or_callback: Callable[
                [WindowsSecurityContextOptions.Builder],
                WindowsSecurityContextOptions.Builder | WindowsSecurityContextOptions,
            ],
            /,
        ) -> "SecurityContext.Builder": ...

        @overload
        def windows_options(
            self, value_or_callback: Never = ...
        ) -> "WindowsSecurityContextOptions.BuilderContext": ...

        def windows_options(self, value_or_callback=None, /):
            """
            The Windows specific settings applied to all containers. If unspecified, the options from the PodSecurityContext will be used. If set in both SecurityContext and PodSecurityContext, the value specified in SecurityContext takes precedence. Note that this field cannot be set when spec.os.name is linux.
            """
            if self._in_context and value_or_callback is None:
                context = WindowsSecurityContextOptions.BuilderContext()
                context._parent_builder = self
                context._field_name = "windows_options"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(WindowsSecurityContextOptions.builder())
                if isinstance(output, WindowsSecurityContextOptions.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("windows_options", value)

    class BuilderContext(BuilderContextBase["SecurityContext.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = SecurityContext.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for SecurityContext."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["SecurityContext", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use SecurityContext.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    allow_privilege_escalation: Annotated[
        Optional[bool], Field(alias="allowPrivilegeEscalation")
    ] = None
    """
    AllowPrivilegeEscalation controls whether a process can gain more privileges than its parent process. This bool directly controls if the no_new_privs flag will be set on the container process. AllowPrivilegeEscalation is true always when the container is: 1) run as Privileged 2) has CAP_SYS_ADMIN Note that this field cannot be set when spec.os.name is windows.
    """
    app_armor_profile: Annotated[Optional[AppArmorProfile], Field(alias="appArmorProfile")] = None
    """
    appArmorProfile is the AppArmor options to use by this container. If set, this profile overrides the pod's appArmorProfile. Note that this field cannot be set when spec.os.name is windows.
    """
    capabilities: Optional[Capabilities] = None
    """
    The capabilities to add/drop when running containers. Defaults to the default set of capabilities granted by the container runtime. Note that this field cannot be set when spec.os.name is windows.
    """
    privileged: Optional[bool] = None
    """
    Run container in privileged mode. Processes in privileged containers are essentially equivalent to root on the host. Defaults to false. Note that this field cannot be set when spec.os.name is windows.
    """
    proc_mount: Annotated[Optional[str], Field(alias="procMount")] = None
    """
    procMount denotes the type of proc mount to use for the containers. The default value is Default which uses the container runtime defaults for readonly paths and masked paths. This requires the ProcMountType feature flag to be enabled. Note that this field cannot be set when spec.os.name is windows.
    """
    read_only_root_filesystem: Annotated[Optional[bool], Field(alias="readOnlyRootFilesystem")] = (
        None
    )
    """
    Whether this container has a read-only root filesystem. Default is false. Note that this field cannot be set when spec.os.name is windows.
    """
    run_as_group: Annotated[Optional[int], Field(alias="runAsGroup")] = None
    """
    The GID to run the entrypoint of the container process. Uses runtime default if unset. May also be set in PodSecurityContext.  If set in both SecurityContext and PodSecurityContext, the value specified in SecurityContext takes precedence. Note that this field cannot be set when spec.os.name is windows.
    """
    run_as_non_root: Annotated[Optional[bool], Field(alias="runAsNonRoot")] = None
    """
    Indicates that the container must run as a non-root user. If true, the Kubelet will validate the image at runtime to ensure that it does not run as UID 0 (root) and fail to start the container if it does. If unset or false, no such validation will be performed. May also be set in PodSecurityContext.  If set in both SecurityContext and PodSecurityContext, the value specified in SecurityContext takes precedence.
    """
    run_as_user: Annotated[Optional[int], Field(alias="runAsUser")] = None
    """
    The UID to run the entrypoint of the container process. Defaults to user specified in image metadata if unspecified. May also be set in PodSecurityContext.  If set in both SecurityContext and PodSecurityContext, the value specified in SecurityContext takes precedence. Note that this field cannot be set when spec.os.name is windows.
    """
    se_linux_options: Annotated[Optional[SELinuxOptions], Field(alias="seLinuxOptions")] = None
    """
    The SELinux context to be applied to the container. If unspecified, the container runtime will allocate a random SELinux context for each container.  May also be set in PodSecurityContext.  If set in both SecurityContext and PodSecurityContext, the value specified in SecurityContext takes precedence. Note that this field cannot be set when spec.os.name is windows.
    """
    seccomp_profile: Annotated[Optional[SeccompProfile], Field(alias="seccompProfile")] = None
    """
    The seccomp options to use by this container. If seccomp options are provided at both the pod & container level, the container options override the pod options. Note that this field cannot be set when spec.os.name is windows.
    """
    windows_options: Annotated[
        Optional[WindowsSecurityContextOptions], Field(alias="windowsOptions")
    ] = None
    """
    The Windows specific settings applied to all containers. If unspecified, the options from the PodSecurityContext will be used. If set in both SecurityContext and PodSecurityContext, the value specified in SecurityContext takes precedence. Note that this field cannot be set when spec.os.name is linux.
    """


class ServicePort(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["ServicePort"]:
            return ServicePort

        def build(self) -> "ServicePort":
            return ServicePort(**self._attrs)

        def app_protocol(self, value: Optional[str], /) -> Self:
            """
            The application protocol for this port. This is used as a hint for implementations to offer richer behavior for protocols that they understand. This field follows standard Kubernetes label syntax. Valid values are either:

            * Un-prefixed protocol names - reserved for IANA standard service names (as per RFC-6335 and https://www.iana.org/assignments/service-names).

            * Kubernetes-defined prefixed names:
              * 'kubernetes.io/h2c' - HTTP/2 prior knowledge over cleartext as described in https://www.rfc-editor.org/rfc/rfc9113.html#name-starting-http-2-with-prior-
              * 'kubernetes.io/ws'  - WebSocket over cleartext as described in https://www.rfc-editor.org/rfc/rfc6455
              * 'kubernetes.io/wss' - WebSocket over TLS as described in https://www.rfc-editor.org/rfc/rfc6455

            * Other protocols should use implementation-defined prefixed names such as mycompany.com/my-custom-protocol.
            """
            return self._set("app_protocol", value)

        def name(self, value: Optional[str], /) -> Self:
            """
            The name of this port within the service. This must be a DNS_LABEL. All ports within a ServiceSpec must have unique names. When considering the endpoints for a Service, this must match the 'name' field in the EndpointPort. Optional if only one ServicePort is defined on this service.
            """
            return self._set("name", value)

        def node_port(self, value: Optional[int], /) -> Self:
            """
            The port on each node on which this service is exposed when type is NodePort or LoadBalancer.  Usually assigned by the system. If a value is specified, in-range, and not in use it will be used, otherwise the operation will fail.  If not specified, a port will be allocated if this Service requires one.  If this field is specified when creating a Service which does not need it, creation will fail. This field will be wiped when updating a Service to no longer need it (e.g. changing type from NodePort to ClusterIP). More info: https://kubernetes.io/docs/concepts/services-networking/service/#type-nodeport
            """
            return self._set("node_port", value)

        def port(self, value: int, /) -> Self:
            """
            The port that will be exposed by this service.
            """
            return self._set("port", value)

        def protocol(self, value: Optional[str], /) -> Self:
            """
            The IP protocol for this port. Supports "TCP", "UDP", and "SCTP". Default is TCP.
            """
            return self._set("protocol", value)

        @overload
        def target_port(
            self, value_or_callback: Optional[apimachinery.IntOrString], /
        ) -> "ServicePort.Builder": ...

        @overload
        def target_port(
            self,
            value_or_callback: Callable[
                [apimachinery.IntOrString.Builder],
                apimachinery.IntOrString.Builder | apimachinery.IntOrString,
            ],
            /,
        ) -> "ServicePort.Builder": ...

        @overload
        def target_port(
            self, value_or_callback: Never = ...
        ) -> "apimachinery.IntOrString.BuilderContext": ...

        def target_port(self, value_or_callback=None, /):
            """
            Number or name of the port to access on the pods targeted by the service. Number must be in the range 1 to 65535. Name must be an IANA_SVC_NAME. If this is a string, it will be looked up as a named port in the target Pod's container ports. If this is not specified, the value of the 'port' field is used (an identity map). This field is ignored for services with clusterIP=None, and should be omitted or set equal to the 'port' field. More info: https://kubernetes.io/docs/concepts/services-networking/service/#defining-a-service
            """
            if self._in_context and value_or_callback is None:
                context = apimachinery.IntOrString.BuilderContext()
                context._parent_builder = self
                context._field_name = "target_port"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(apimachinery.IntOrString.builder())
                if isinstance(output, apimachinery.IntOrString.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("target_port", value)

    class BuilderContext(BuilderContextBase["ServicePort.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = ServicePort.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for ServicePort."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["ServicePort", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use ServicePort.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    app_protocol: Annotated[Optional[str], Field(alias="appProtocol")] = None
    """
    The application protocol for this port. This is used as a hint for implementations to offer richer behavior for protocols that they understand. This field follows standard Kubernetes label syntax. Valid values are either:

    * Un-prefixed protocol names - reserved for IANA standard service names (as per RFC-6335 and https://www.iana.org/assignments/service-names).

    * Kubernetes-defined prefixed names:
      * 'kubernetes.io/h2c' - HTTP/2 prior knowledge over cleartext as described in https://www.rfc-editor.org/rfc/rfc9113.html#name-starting-http-2-with-prior-
      * 'kubernetes.io/ws'  - WebSocket over cleartext as described in https://www.rfc-editor.org/rfc/rfc6455
      * 'kubernetes.io/wss' - WebSocket over TLS as described in https://www.rfc-editor.org/rfc/rfc6455

    * Other protocols should use implementation-defined prefixed names such as mycompany.com/my-custom-protocol.
    """
    name: Optional[str] = None
    """
    The name of this port within the service. This must be a DNS_LABEL. All ports within a ServiceSpec must have unique names. When considering the endpoints for a Service, this must match the 'name' field in the EndpointPort. Optional if only one ServicePort is defined on this service.
    """
    node_port: Annotated[Optional[int], Field(alias="nodePort")] = None
    """
    The port on each node on which this service is exposed when type is NodePort or LoadBalancer.  Usually assigned by the system. If a value is specified, in-range, and not in use it will be used, otherwise the operation will fail.  If not specified, a port will be allocated if this Service requires one.  If this field is specified when creating a Service which does not need it, creation will fail. This field will be wiped when updating a Service to no longer need it (e.g. changing type from NodePort to ClusterIP). More info: https://kubernetes.io/docs/concepts/services-networking/service/#type-nodeport
    """
    port: int
    """
    The port that will be exposed by this service.
    """
    protocol: Optional[str] = None
    """
    The IP protocol for this port. Supports "TCP", "UDP", and "SCTP". Default is TCP.
    """
    target_port: Annotated[Optional[apimachinery.IntOrString], Field(alias="targetPort")] = None
    """
    Number or name of the port to access on the pods targeted by the service. Number must be in the range 1 to 65535. Name must be an IANA_SVC_NAME. If this is a string, it will be looked up as a named port in the target Pod's container ports. If this is not specified, the value of the 'port' field is used (an identity map). This field is ignored for services with clusterIP=None, and should be omitted or set equal to the 'port' field. More info: https://kubernetes.io/docs/concepts/services-networking/service/#defining-a-service
    """


class ServiceSpec(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["ServiceSpec"]:
            return ServiceSpec

        def build(self) -> "ServiceSpec":
            return ServiceSpec(**self._attrs)

        def allocate_load_balancer_node_ports(self, value: Optional[bool], /) -> Self:
            """
            allocateLoadBalancerNodePorts defines if NodePorts will be automatically allocated for services with type LoadBalancer.  Default is "true". It may be set to "false" if the cluster load-balancer does not rely on NodePorts.  If the caller requests specific NodePorts (by specifying a value), those requests will be respected, regardless of this field. This field may only be set for services with type LoadBalancer and will be cleared if the type is changed to any other type.
            """
            return self._set("allocate_load_balancer_node_ports", value)

        def cluster_ip(self, value: Optional[str], /) -> Self:
            """
            clusterIP is the IP address of the service and is usually assigned randomly. If an address is specified manually, is in-range (as per system configuration), and is not in use, it will be allocated to the service; otherwise creation of the service will fail. This field may not be changed through updates unless the type field is also being changed to ExternalName (which requires this field to be blank) or the type field is being changed from ExternalName (in which case this field may optionally be specified, as describe above).  Valid values are "None", empty string (""), or a valid IP address. Setting this to "None" makes a "headless service" (no virtual IP), which is useful when direct endpoint connections are preferred and proxying is not required.  Only applies to types ClusterIP, NodePort, and LoadBalancer. If this field is specified when creating a Service of type ExternalName, creation will fail. This field will be wiped when updating a Service to type ExternalName. More info: https://kubernetes.io/docs/concepts/services-networking/service/#virtual-ips-and-service-proxies
            """
            return self._set("cluster_ip", value)

        def cluster_i_ps(self, value: Optional[List[str]], /) -> Self:
            """
            ClusterIPs is a list of IP addresses assigned to this service, and are usually assigned randomly.  If an address is specified manually, is in-range (as per system configuration), and is not in use, it will be allocated to the service; otherwise creation of the service will fail. This field may not be changed through updates unless the type field is also being changed to ExternalName (which requires this field to be empty) or the type field is being changed from ExternalName (in which case this field may optionally be specified, as describe above).  Valid values are "None", empty string (""), or a valid IP address.  Setting this to "None" makes a "headless service" (no virtual IP), which is useful when direct endpoint connections are preferred and proxying is not required.  Only applies to types ClusterIP, NodePort, and LoadBalancer. If this field is specified when creating a Service of type ExternalName, creation will fail. This field will be wiped when updating a Service to type ExternalName.  If this field is not specified, it will be initialized from the clusterIP field.  If this field is specified, clients must ensure that clusterIPs[0] and clusterIP have the same value.

            This field may hold a maximum of two entries (dual-stack IPs, in either order). These IPs must correspond to the values of the ipFamilies field. Both clusterIPs and ipFamilies are governed by the ipFamilyPolicy field. More info: https://kubernetes.io/docs/concepts/services-networking/service/#virtual-ips-and-service-proxies
            """
            return self._set("cluster_i_ps", value)

        def external_i_ps(self, value: Optional[List[str]], /) -> Self:
            """
            externalIPs is a list of IP addresses for which nodes in the cluster will also accept traffic for this service.  These IPs are not managed by Kubernetes.  The user is responsible for ensuring that traffic arrives at a node with this IP.  A common example is external load-balancers that are not part of the Kubernetes system.
            """
            return self._set("external_i_ps", value)

        def external_name(self, value: Optional[str], /) -> Self:
            """
            externalName is the external reference that discovery mechanisms will return as an alias for this service (e.g. a DNS CNAME record). No proxying will be involved.  Must be a lowercase RFC-1123 hostname (https://tools.ietf.org/html/rfc1123) and requires `type` to be "ExternalName".
            """
            return self._set("external_name", value)

        def external_traffic_policy(self, value: Optional[str], /) -> Self:
            """
            externalTrafficPolicy describes how nodes distribute service traffic they receive on one of the Service's "externally-facing" addresses (NodePorts, ExternalIPs, and LoadBalancer IPs). If set to "Local", the proxy will configure the service in a way that assumes that external load balancers will take care of balancing the service traffic between nodes, and so each node will deliver traffic only to the node-local endpoints of the service, without masquerading the client source IP. (Traffic mistakenly sent to a node with no endpoints will be dropped.) The default value, "Cluster", uses the standard behavior of routing to all endpoints evenly (possibly modified by topology and other features). Note that traffic sent to an External IP or LoadBalancer IP from within the cluster will always get "Cluster" semantics, but clients sending to a NodePort from within the cluster may need to take traffic policy into account when picking a node.
            """
            return self._set("external_traffic_policy", value)

        def health_check_node_port(self, value: Optional[int], /) -> Self:
            """
            healthCheckNodePort specifies the healthcheck nodePort for the service. This only applies when type is set to LoadBalancer and externalTrafficPolicy is set to Local. If a value is specified, is in-range, and is not in use, it will be used.  If not specified, a value will be automatically allocated.  External systems (e.g. load-balancers) can use this port to determine if a given node holds endpoints for this service or not.  If this field is specified when creating a Service which does not need it, creation will fail. This field will be wiped when updating a Service to no longer need it (e.g. changing type). This field cannot be updated once set.
            """
            return self._set("health_check_node_port", value)

        def internal_traffic_policy(self, value: Optional[str], /) -> Self:
            """
            InternalTrafficPolicy describes how nodes distribute service traffic they receive on the ClusterIP. If set to "Local", the proxy will assume that pods only want to talk to endpoints of the service on the same node as the pod, dropping the traffic if there are no local endpoints. The default value, "Cluster", uses the standard behavior of routing to all endpoints evenly (possibly modified by topology and other features).
            """
            return self._set("internal_traffic_policy", value)

        def ip_families(self, value: Optional[List[str]], /) -> Self:
            """
            IPFamilies is a list of IP families (e.g. IPv4, IPv6) assigned to this service. This field is usually assigned automatically based on cluster configuration and the ipFamilyPolicy field. If this field is specified manually, the requested family is available in the cluster, and ipFamilyPolicy allows it, it will be used; otherwise creation of the service will fail. This field is conditionally mutable: it allows for adding or removing a secondary IP family, but it does not allow changing the primary IP family of the Service. Valid values are "IPv4" and "IPv6".  This field only applies to Services of types ClusterIP, NodePort, and LoadBalancer, and does apply to "headless" services. This field will be wiped when updating a Service to type ExternalName.

            This field may hold a maximum of two entries (dual-stack families, in either order).  These families must correspond to the values of the clusterIPs field, if specified. Both clusterIPs and ipFamilies are governed by the ipFamilyPolicy field.
            """
            return self._set("ip_families", value)

        def ip_family_policy(self, value: Optional[str], /) -> Self:
            """
            IPFamilyPolicy represents the dual-stack-ness requested or required by this Service. If there is no value provided, then this field will be set to SingleStack. Services can be "SingleStack" (a single IP family), "PreferDualStack" (two IP families on dual-stack configured clusters or a single IP family on single-stack clusters), or "RequireDualStack" (two IP families on dual-stack configured clusters, otherwise fail). The ipFamilies and clusterIPs fields depend on the value of this field. This field will be wiped when updating a service to type ExternalName.
            """
            return self._set("ip_family_policy", value)

        def load_balancer_class(self, value: Optional[str], /) -> Self:
            """
            loadBalancerClass is the class of the load balancer implementation this Service belongs to. If specified, the value of this field must be a label-style identifier, with an optional prefix, e.g. "internal-vip" or "example.com/internal-vip". Unprefixed names are reserved for end-users. This field can only be set when the Service type is 'LoadBalancer'. If not set, the default load balancer implementation is used, today this is typically done through the cloud provider integration, but should apply for any default implementation. If set, it is assumed that a load balancer implementation is watching for Services with a matching class. Any default load balancer implementation (e.g. cloud providers) should ignore Services that set this field. This field can only be set when creating or updating a Service to type 'LoadBalancer'. Once set, it can not be changed. This field will be wiped when a service is updated to a non 'LoadBalancer' type.
            """
            return self._set("load_balancer_class", value)

        def load_balancer_ip(self, value: Optional[str], /) -> Self:
            """
            Only applies to Service Type: LoadBalancer. This feature depends on whether the underlying cloud-provider supports specifying the loadBalancerIP when a load balancer is created. This field will be ignored if the cloud-provider does not support the feature. Deprecated: This field was under-specified and its meaning varies across implementations. Using it is non-portable and it may not support dual-stack. Users are encouraged to use implementation-specific annotations when available.
            """
            return self._set("load_balancer_ip", value)

        def load_balancer_source_ranges(self, value: Optional[List[str]], /) -> Self:
            """
            If specified and supported by the platform, this will restrict traffic through the cloud-provider load-balancer will be restricted to the specified client IPs. This field will be ignored if the cloud-provider does not support the feature." More info: https://kubernetes.io/docs/tasks/access-application-cluster/create-external-load-balancer/
            """
            return self._set("load_balancer_source_ranges", value)

        @overload
        def ports(self, value_or_callback: List[ServicePort], /) -> "ServiceSpec.Builder": ...

        @overload
        def ports(
            self,
            value_or_callback: Callable[
                [GenericListBuilder[ServicePort, ServicePort.Builder]],
                GenericListBuilder[ServicePort, ServicePort.Builder] | List[ServicePort],
            ],
            /,
        ) -> "ServiceSpec.Builder": ...

        @overload
        def ports(
            self, value_or_callback: Never = ...
        ) -> ListBuilderContext[ServicePort.Builder]: ...

        def ports(self, value_or_callback=None, /):
            """
            The list of ports that are exposed by this service. More info: https://kubernetes.io/docs/concepts/services-networking/service/#virtual-ips-and-service-proxies
            """
            if self._in_context and value_or_callback is None:
                context = ListBuilderContext[ServicePort.Builder]()
                context._parent_builder = self
                context._field_name = "ports"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(ServicePort.list_builder())
                if isinstance(output, GenericListBuilder):
                    value = output.build()
                else:
                    value = output
            return self._set("ports", value)

        def publish_not_ready_addresses(self, value: Optional[bool], /) -> Self:
            """
            publishNotReadyAddresses indicates that any agent which deals with endpoints for this Service should disregard any indications of ready/not-ready. The primary use case for setting this field is for a StatefulSet's Headless Service to propagate SRV DNS records for its Pods for the purpose of peer discovery. The Kubernetes controllers that generate Endpoints and EndpointSlice resources for Services interpret this to mean that all endpoints are considered "ready" even if the Pods themselves are not. Agents which consume only Kubernetes generated endpoints through the Endpoints or EndpointSlice resources can safely assume this behavior.
            """
            return self._set("publish_not_ready_addresses", value)

        def selector(self, value: Optional[Dict[str, str]], /) -> Self:
            """
            Route service traffic to pods with label keys and values matching this selector. If empty or not present, the service is assumed to have an external process managing its endpoints, which Kubernetes will not modify. Only applies to types ClusterIP, NodePort, and LoadBalancer. Ignored if type is ExternalName. More info: https://kubernetes.io/docs/concepts/services-networking/service/
            """
            return self._set("selector", value)

        def session_affinity(self, value: Optional[str], /) -> Self:
            """
            Supports "ClientIP" and "None". Used to maintain session affinity. Enable client IP based session affinity. Must be ClientIP or None. Defaults to None. More info: https://kubernetes.io/docs/concepts/services-networking/service/#virtual-ips-and-service-proxies
            """
            return self._set("session_affinity", value)

        @overload
        def session_affinity_config(
            self, value_or_callback: Optional[SessionAffinityConfig], /
        ) -> "ServiceSpec.Builder": ...

        @overload
        def session_affinity_config(
            self,
            value_or_callback: Callable[
                [SessionAffinityConfig.Builder],
                SessionAffinityConfig.Builder | SessionAffinityConfig,
            ],
            /,
        ) -> "ServiceSpec.Builder": ...

        @overload
        def session_affinity_config(
            self, value_or_callback: Never = ...
        ) -> "SessionAffinityConfig.BuilderContext": ...

        def session_affinity_config(self, value_or_callback=None, /):
            """
            sessionAffinityConfig contains the configurations of session affinity.
            """
            if self._in_context and value_or_callback is None:
                context = SessionAffinityConfig.BuilderContext()
                context._parent_builder = self
                context._field_name = "session_affinity_config"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(SessionAffinityConfig.builder())
                if isinstance(output, SessionAffinityConfig.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("session_affinity_config", value)

        def traffic_distribution(self, value: Optional[str], /) -> Self:
            """
            TrafficDistribution offers a way to express preferences for how traffic is distributed to Service endpoints. Implementations can use this field as a hint, but are not required to guarantee strict adherence. If the field is not set, the implementation will apply its default routing strategy. If set to "PreferClose", implementations should prioritize endpoints that are topologically close (e.g., same zone). This is an alpha field and requires enabling ServiceTrafficDistribution feature.
            """
            return self._set("traffic_distribution", value)

        def type(self, value: Optional[str], /) -> Self:
            """
            type determines how the Service is exposed. Defaults to ClusterIP. Valid options are ExternalName, ClusterIP, NodePort, and LoadBalancer. "ClusterIP" allocates a cluster-internal IP address for load-balancing to endpoints. Endpoints are determined by the selector or if that is not specified, by manual construction of an Endpoints object or EndpointSlice objects. If clusterIP is "None", no virtual IP is allocated and the endpoints are published as a set of endpoints rather than a virtual IP. "NodePort" builds on ClusterIP and allocates a port on every node which routes to the same endpoints as the clusterIP. "LoadBalancer" builds on NodePort and creates an external load-balancer (if supported in the current cloud) which routes to the same endpoints as the clusterIP. "ExternalName" aliases this service to the specified externalName. Several other fields do not apply to ExternalName services. More info: https://kubernetes.io/docs/concepts/services-networking/service/#publishing-services-service-types
            """
            return self._set("type", value)

    class BuilderContext(BuilderContextBase["ServiceSpec.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = ServiceSpec.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for ServiceSpec."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["ServiceSpec", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use ServiceSpec.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    allocate_load_balancer_node_ports: Annotated[
        Optional[bool], Field(alias="allocateLoadBalancerNodePorts")
    ] = None
    """
    allocateLoadBalancerNodePorts defines if NodePorts will be automatically allocated for services with type LoadBalancer.  Default is "true". It may be set to "false" if the cluster load-balancer does not rely on NodePorts.  If the caller requests specific NodePorts (by specifying a value), those requests will be respected, regardless of this field. This field may only be set for services with type LoadBalancer and will be cleared if the type is changed to any other type.
    """
    cluster_ip: Annotated[Optional[str], Field(alias="clusterIP")] = None
    """
    clusterIP is the IP address of the service and is usually assigned randomly. If an address is specified manually, is in-range (as per system configuration), and is not in use, it will be allocated to the service; otherwise creation of the service will fail. This field may not be changed through updates unless the type field is also being changed to ExternalName (which requires this field to be blank) or the type field is being changed from ExternalName (in which case this field may optionally be specified, as describe above).  Valid values are "None", empty string (""), or a valid IP address. Setting this to "None" makes a "headless service" (no virtual IP), which is useful when direct endpoint connections are preferred and proxying is not required.  Only applies to types ClusterIP, NodePort, and LoadBalancer. If this field is specified when creating a Service of type ExternalName, creation will fail. This field will be wiped when updating a Service to type ExternalName. More info: https://kubernetes.io/docs/concepts/services-networking/service/#virtual-ips-and-service-proxies
    """
    cluster_i_ps: Annotated[Optional[List[str]], Field(alias="clusterIPs")] = None
    """
    ClusterIPs is a list of IP addresses assigned to this service, and are usually assigned randomly.  If an address is specified manually, is in-range (as per system configuration), and is not in use, it will be allocated to the service; otherwise creation of the service will fail. This field may not be changed through updates unless the type field is also being changed to ExternalName (which requires this field to be empty) or the type field is being changed from ExternalName (in which case this field may optionally be specified, as describe above).  Valid values are "None", empty string (""), or a valid IP address.  Setting this to "None" makes a "headless service" (no virtual IP), which is useful when direct endpoint connections are preferred and proxying is not required.  Only applies to types ClusterIP, NodePort, and LoadBalancer. If this field is specified when creating a Service of type ExternalName, creation will fail. This field will be wiped when updating a Service to type ExternalName.  If this field is not specified, it will be initialized from the clusterIP field.  If this field is specified, clients must ensure that clusterIPs[0] and clusterIP have the same value.

    This field may hold a maximum of two entries (dual-stack IPs, in either order). These IPs must correspond to the values of the ipFamilies field. Both clusterIPs and ipFamilies are governed by the ipFamilyPolicy field. More info: https://kubernetes.io/docs/concepts/services-networking/service/#virtual-ips-and-service-proxies
    """
    external_i_ps: Annotated[Optional[List[str]], Field(alias="externalIPs")] = None
    """
    externalIPs is a list of IP addresses for which nodes in the cluster will also accept traffic for this service.  These IPs are not managed by Kubernetes.  The user is responsible for ensuring that traffic arrives at a node with this IP.  A common example is external load-balancers that are not part of the Kubernetes system.
    """
    external_name: Annotated[Optional[str], Field(alias="externalName")] = None
    """
    externalName is the external reference that discovery mechanisms will return as an alias for this service (e.g. a DNS CNAME record). No proxying will be involved.  Must be a lowercase RFC-1123 hostname (https://tools.ietf.org/html/rfc1123) and requires `type` to be "ExternalName".
    """
    external_traffic_policy: Annotated[Optional[str], Field(alias="externalTrafficPolicy")] = None
    """
    externalTrafficPolicy describes how nodes distribute service traffic they receive on one of the Service's "externally-facing" addresses (NodePorts, ExternalIPs, and LoadBalancer IPs). If set to "Local", the proxy will configure the service in a way that assumes that external load balancers will take care of balancing the service traffic between nodes, and so each node will deliver traffic only to the node-local endpoints of the service, without masquerading the client source IP. (Traffic mistakenly sent to a node with no endpoints will be dropped.) The default value, "Cluster", uses the standard behavior of routing to all endpoints evenly (possibly modified by topology and other features). Note that traffic sent to an External IP or LoadBalancer IP from within the cluster will always get "Cluster" semantics, but clients sending to a NodePort from within the cluster may need to take traffic policy into account when picking a node.
    """
    health_check_node_port: Annotated[Optional[int], Field(alias="healthCheckNodePort")] = None
    """
    healthCheckNodePort specifies the healthcheck nodePort for the service. This only applies when type is set to LoadBalancer and externalTrafficPolicy is set to Local. If a value is specified, is in-range, and is not in use, it will be used.  If not specified, a value will be automatically allocated.  External systems (e.g. load-balancers) can use this port to determine if a given node holds endpoints for this service or not.  If this field is specified when creating a Service which does not need it, creation will fail. This field will be wiped when updating a Service to no longer need it (e.g. changing type). This field cannot be updated once set.
    """
    internal_traffic_policy: Annotated[Optional[str], Field(alias="internalTrafficPolicy")] = None
    """
    InternalTrafficPolicy describes how nodes distribute service traffic they receive on the ClusterIP. If set to "Local", the proxy will assume that pods only want to talk to endpoints of the service on the same node as the pod, dropping the traffic if there are no local endpoints. The default value, "Cluster", uses the standard behavior of routing to all endpoints evenly (possibly modified by topology and other features).
    """
    ip_families: Annotated[Optional[List[str]], Field(alias="ipFamilies")] = None
    """
    IPFamilies is a list of IP families (e.g. IPv4, IPv6) assigned to this service. This field is usually assigned automatically based on cluster configuration and the ipFamilyPolicy field. If this field is specified manually, the requested family is available in the cluster, and ipFamilyPolicy allows it, it will be used; otherwise creation of the service will fail. This field is conditionally mutable: it allows for adding or removing a secondary IP family, but it does not allow changing the primary IP family of the Service. Valid values are "IPv4" and "IPv6".  This field only applies to Services of types ClusterIP, NodePort, and LoadBalancer, and does apply to "headless" services. This field will be wiped when updating a Service to type ExternalName.

    This field may hold a maximum of two entries (dual-stack families, in either order).  These families must correspond to the values of the clusterIPs field, if specified. Both clusterIPs and ipFamilies are governed by the ipFamilyPolicy field.
    """
    ip_family_policy: Annotated[Optional[str], Field(alias="ipFamilyPolicy")] = None
    """
    IPFamilyPolicy represents the dual-stack-ness requested or required by this Service. If there is no value provided, then this field will be set to SingleStack. Services can be "SingleStack" (a single IP family), "PreferDualStack" (two IP families on dual-stack configured clusters or a single IP family on single-stack clusters), or "RequireDualStack" (two IP families on dual-stack configured clusters, otherwise fail). The ipFamilies and clusterIPs fields depend on the value of this field. This field will be wiped when updating a service to type ExternalName.
    """
    load_balancer_class: Annotated[Optional[str], Field(alias="loadBalancerClass")] = None
    """
    loadBalancerClass is the class of the load balancer implementation this Service belongs to. If specified, the value of this field must be a label-style identifier, with an optional prefix, e.g. "internal-vip" or "example.com/internal-vip". Unprefixed names are reserved for end-users. This field can only be set when the Service type is 'LoadBalancer'. If not set, the default load balancer implementation is used, today this is typically done through the cloud provider integration, but should apply for any default implementation. If set, it is assumed that a load balancer implementation is watching for Services with a matching class. Any default load balancer implementation (e.g. cloud providers) should ignore Services that set this field. This field can only be set when creating or updating a Service to type 'LoadBalancer'. Once set, it can not be changed. This field will be wiped when a service is updated to a non 'LoadBalancer' type.
    """
    load_balancer_ip: Annotated[Optional[str], Field(alias="loadBalancerIP")] = None
    """
    Only applies to Service Type: LoadBalancer. This feature depends on whether the underlying cloud-provider supports specifying the loadBalancerIP when a load balancer is created. This field will be ignored if the cloud-provider does not support the feature. Deprecated: This field was under-specified and its meaning varies across implementations. Using it is non-portable and it may not support dual-stack. Users are encouraged to use implementation-specific annotations when available.
    """
    load_balancer_source_ranges: Annotated[
        Optional[List[str]], Field(alias="loadBalancerSourceRanges")
    ] = None
    """
    If specified and supported by the platform, this will restrict traffic through the cloud-provider load-balancer will be restricted to the specified client IPs. This field will be ignored if the cloud-provider does not support the feature." More info: https://kubernetes.io/docs/tasks/access-application-cluster/create-external-load-balancer/
    """
    ports: Optional[List[ServicePort]] = None
    """
    The list of ports that are exposed by this service. More info: https://kubernetes.io/docs/concepts/services-networking/service/#virtual-ips-and-service-proxies
    """
    publish_not_ready_addresses: Annotated[
        Optional[bool], Field(alias="publishNotReadyAddresses")
    ] = None
    """
    publishNotReadyAddresses indicates that any agent which deals with endpoints for this Service should disregard any indications of ready/not-ready. The primary use case for setting this field is for a StatefulSet's Headless Service to propagate SRV DNS records for its Pods for the purpose of peer discovery. The Kubernetes controllers that generate Endpoints and EndpointSlice resources for Services interpret this to mean that all endpoints are considered "ready" even if the Pods themselves are not. Agents which consume only Kubernetes generated endpoints through the Endpoints or EndpointSlice resources can safely assume this behavior.
    """
    selector: Optional[Dict[str, str]] = None
    """
    Route service traffic to pods with label keys and values matching this selector. If empty or not present, the service is assumed to have an external process managing its endpoints, which Kubernetes will not modify. Only applies to types ClusterIP, NodePort, and LoadBalancer. Ignored if type is ExternalName. More info: https://kubernetes.io/docs/concepts/services-networking/service/
    """
    session_affinity: Annotated[Optional[str], Field(alias="sessionAffinity")] = None
    """
    Supports "ClientIP" and "None". Used to maintain session affinity. Enable client IP based session affinity. Must be ClientIP or None. Defaults to None. More info: https://kubernetes.io/docs/concepts/services-networking/service/#virtual-ips-and-service-proxies
    """
    session_affinity_config: Annotated[
        Optional[SessionAffinityConfig], Field(alias="sessionAffinityConfig")
    ] = None
    """
    sessionAffinityConfig contains the configurations of session affinity.
    """
    traffic_distribution: Annotated[Optional[str], Field(alias="trafficDistribution")] = None
    """
    TrafficDistribution offers a way to express preferences for how traffic is distributed to Service endpoints. Implementations can use this field as a hint, but are not required to guarantee strict adherence. If the field is not set, the implementation will apply its default routing strategy. If set to "PreferClose", implementations should prioritize endpoints that are topologically close (e.g., same zone). This is an alpha field and requires enabling ServiceTrafficDistribution feature.
    """
    type: Optional[str] = None
    """
    type determines how the Service is exposed. Defaults to ClusterIP. Valid options are ExternalName, ClusterIP, NodePort, and LoadBalancer. "ClusterIP" allocates a cluster-internal IP address for load-balancing to endpoints. Endpoints are determined by the selector or if that is not specified, by manual construction of an Endpoints object or EndpointSlice objects. If clusterIP is "None", no virtual IP is allocated and the endpoints are published as a set of endpoints rather than a virtual IP. "NodePort" builds on ClusterIP and allocates a port on every node which routes to the same endpoints as the clusterIP. "LoadBalancer" builds on NodePort and creates an external load-balancer (if supported in the current cloud) which routes to the same endpoints as the clusterIP. "ExternalName" aliases this service to the specified externalName. Several other fields do not apply to ExternalName services. More info: https://kubernetes.io/docs/concepts/services-networking/service/#publishing-services-service-types
    """


class TCPSocketAction(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["TCPSocketAction"]:
            return TCPSocketAction

        def build(self) -> "TCPSocketAction":
            return TCPSocketAction(**self._attrs)

        def host(self, value: Optional[str], /) -> Self:
            """
            Optional: Host name to connect to, defaults to the pod IP.
            """
            return self._set("host", value)

        @overload
        def port(
            self, value_or_callback: apimachinery.IntOrString, /
        ) -> "TCPSocketAction.Builder": ...

        @overload
        def port(
            self,
            value_or_callback: Callable[
                [apimachinery.IntOrString.Builder],
                apimachinery.IntOrString.Builder | apimachinery.IntOrString,
            ],
            /,
        ) -> "TCPSocketAction.Builder": ...

        @overload
        def port(
            self, value_or_callback: Never = ...
        ) -> "apimachinery.IntOrString.BuilderContext": ...

        def port(self, value_or_callback=None, /):
            """
            Number or name of the port to access on the container. Number must be in the range 1 to 65535. Name must be an IANA_SVC_NAME.
            """
            if self._in_context and value_or_callback is None:
                context = apimachinery.IntOrString.BuilderContext()
                context._parent_builder = self
                context._field_name = "port"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(apimachinery.IntOrString.builder())
                if isinstance(output, apimachinery.IntOrString.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("port", value)

    class BuilderContext(BuilderContextBase["TCPSocketAction.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = TCPSocketAction.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for TCPSocketAction."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["TCPSocketAction", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use TCPSocketAction.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    host: Optional[str] = None
    """
    Optional: Host name to connect to, defaults to the pod IP.
    """
    port: apimachinery.IntOrString
    """
    Number or name of the port to access on the container. Number must be in the range 1 to 65535. Name must be an IANA_SVC_NAME.
    """


class Taint(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["Taint"]:
            return Taint

        def build(self) -> "Taint":
            return Taint(**self._attrs)

        def effect(self, value: str, /) -> Self:
            """
            Required. The effect of the taint on pods that do not tolerate the taint. Valid effects are NoSchedule, PreferNoSchedule and NoExecute.
            """
            return self._set("effect", value)

        def key(self, value: str, /) -> Self:
            """
            Required. The taint key to be applied to a node.
            """
            return self._set("key", value)

        @overload
        def time_added(
            self, value_or_callback: Optional[apimachinery.Time], /
        ) -> "Taint.Builder": ...

        @overload
        def time_added(
            self,
            value_or_callback: Callable[
                [apimachinery.Time.Builder],
                apimachinery.Time.Builder | apimachinery.Time,
            ],
            /,
        ) -> "Taint.Builder": ...

        @overload
        def time_added(
            self, value_or_callback: Never = ...
        ) -> "apimachinery.Time.BuilderContext": ...

        def time_added(self, value_or_callback=None, /):
            """
            TimeAdded represents the time at which the taint was added. It is only written for NoExecute taints.
            """
            if self._in_context and value_or_callback is None:
                context = apimachinery.Time.BuilderContext()
                context._parent_builder = self
                context._field_name = "time_added"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(apimachinery.Time.builder())
                if isinstance(output, apimachinery.Time.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("time_added", value)

        def value(self, value: Optional[str], /) -> Self:
            """
            The taint value corresponding to the taint key.
            """
            return self._set("value", value)

    class BuilderContext(BuilderContextBase["Taint.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = Taint.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for Taint."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["Taint", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use Taint.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    effect: str
    """
    Required. The effect of the taint on pods that do not tolerate the taint. Valid effects are NoSchedule, PreferNoSchedule and NoExecute.
    """
    key: str
    """
    Required. The taint key to be applied to a node.
    """
    time_added: Annotated[Optional[apimachinery.Time], Field(alias="timeAdded")] = None
    """
    TimeAdded represents the time at which the taint was added. It is only written for NoExecute taints.
    """
    value: Optional[str] = None
    """
    The taint value corresponding to the taint key.
    """


class VolumeNodeAffinity(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["VolumeNodeAffinity"]:
            return VolumeNodeAffinity

        def build(self) -> "VolumeNodeAffinity":
            return VolumeNodeAffinity(**self._attrs)

        @overload
        def required(
            self, value_or_callback: Optional[NodeSelector], /
        ) -> "VolumeNodeAffinity.Builder": ...

        @overload
        def required(
            self,
            value_or_callback: Callable[
                [NodeSelector.Builder], NodeSelector.Builder | NodeSelector
            ],
            /,
        ) -> "VolumeNodeAffinity.Builder": ...

        @overload
        def required(self, value_or_callback: Never = ...) -> "NodeSelector.BuilderContext": ...

        def required(self, value_or_callback=None, /):
            """
            required specifies hard node constraints that must be met.
            """
            if self._in_context and value_or_callback is None:
                context = NodeSelector.BuilderContext()
                context._parent_builder = self
                context._field_name = "required"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(NodeSelector.builder())
                if isinstance(output, NodeSelector.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("required", value)

    class BuilderContext(BuilderContextBase["VolumeNodeAffinity.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = VolumeNodeAffinity.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for VolumeNodeAffinity."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["VolumeNodeAffinity", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use VolumeNodeAffinity.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    required: Optional[NodeSelector] = None
    """
    required specifies hard node constraints that must be met.
    """


class VolumeResourceRequirements(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["VolumeResourceRequirements"]:
            return VolumeResourceRequirements

        def build(self) -> "VolumeResourceRequirements":
            return VolumeResourceRequirements(**self._attrs)

        def limits(self, value: Optional[Dict[str, apimachinery.Quantity]], /) -> Self:
            """
            Limits describes the maximum amount of compute resources allowed. More info: https://kubernetes.io/docs/concepts/configuration/manage-resources-containers/
            """
            return self._set("limits", value)

        def requests(self, value: Optional[Dict[str, apimachinery.Quantity]], /) -> Self:
            """
            Requests describes the minimum amount of compute resources required. If Requests is omitted for a container, it defaults to Limits if that is explicitly specified, otherwise to an implementation-defined value. Requests cannot exceed Limits. More info: https://kubernetes.io/docs/concepts/configuration/manage-resources-containers/
            """
            return self._set("requests", value)

    class BuilderContext(BuilderContextBase["VolumeResourceRequirements.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = VolumeResourceRequirements.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for VolumeResourceRequirements."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["VolumeResourceRequirements", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use VolumeResourceRequirements.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    limits: Optional[Dict[str, apimachinery.Quantity]] = None
    """
    Limits describes the maximum amount of compute resources allowed. More info: https://kubernetes.io/docs/concepts/configuration/manage-resources-containers/
    """
    requests: Optional[Dict[str, apimachinery.Quantity]] = None
    """
    Requests describes the minimum amount of compute resources required. If Requests is omitted for a container, it defaults to Limits if that is explicitly specified, otherwise to an implementation-defined value. Requests cannot exceed Limits. More info: https://kubernetes.io/docs/concepts/configuration/manage-resources-containers/
    """


class Binding(Resource):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["Binding"]:
            return Binding

        def build(self) -> "Binding":
            return Binding(**self._attrs)

        def api_version(self, value: Optional[Literal["v1"]], /) -> Self:
            """
            APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
            """
            return self._set("api_version", value)

        def kind(self, value: Optional[Literal["Binding"]], /) -> Self:
            """
            Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
            """
            return self._set("kind", value)

        @overload
        def metadata(
            self, value_or_callback: Optional[apimachinery.ObjectMeta], /
        ) -> "Binding.Builder": ...

        @overload
        def metadata(
            self,
            value_or_callback: Callable[
                [apimachinery.ObjectMeta.Builder],
                apimachinery.ObjectMeta.Builder | apimachinery.ObjectMeta,
            ],
            /,
        ) -> "Binding.Builder": ...

        @overload
        def metadata(
            self, value_or_callback: Never = ...
        ) -> "apimachinery.ObjectMeta.BuilderContext": ...

        def metadata(self, value_or_callback=None, /):
            """
            Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
            """
            if self._in_context and value_or_callback is None:
                context = apimachinery.ObjectMeta.BuilderContext()
                context._parent_builder = self
                context._field_name = "metadata"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(apimachinery.ObjectMeta.builder())
                if isinstance(output, apimachinery.ObjectMeta.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("metadata", value)

        @overload
        def target(self, value_or_callback: ObjectReference, /) -> "Binding.Builder": ...

        @overload
        def target(
            self,
            value_or_callback: Callable[
                [ObjectReference.Builder], ObjectReference.Builder | ObjectReference
            ],
            /,
        ) -> "Binding.Builder": ...

        @overload
        def target(self, value_or_callback: Never = ...) -> "ObjectReference.BuilderContext": ...

        def target(self, value_or_callback=None, /):
            """
            The target object that you want to bind to the standard object.
            """
            if self._in_context and value_or_callback is None:
                context = ObjectReference.BuilderContext()
                context._parent_builder = self
                context._field_name = "target"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(ObjectReference.builder())
                if isinstance(output, ObjectReference.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("target", value)

    class BuilderContext(BuilderContextBase["Binding.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = Binding.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for Binding."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["Binding", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use Binding.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    api_version: Annotated[Optional[Literal["v1"]], Field(alias="apiVersion")] = "v1"
    """
    APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
    """
    kind: Optional[Literal["Binding"]] = "Binding"
    """
    Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
    """
    metadata: Optional[apimachinery.ObjectMeta] = None
    """
    Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
    """
    target: ObjectReference
    """
    The target object that you want to bind to the standard object.
    """


class ClusterTrustBundleProjection(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["ClusterTrustBundleProjection"]:
            return ClusterTrustBundleProjection

        def build(self) -> "ClusterTrustBundleProjection":
            return ClusterTrustBundleProjection(**self._attrs)

        @overload
        def label_selector(
            self, value_or_callback: Optional[apimachinery.LabelSelector], /
        ) -> "ClusterTrustBundleProjection.Builder": ...

        @overload
        def label_selector(
            self,
            value_or_callback: Callable[
                [apimachinery.LabelSelector.Builder],
                apimachinery.LabelSelector.Builder | apimachinery.LabelSelector,
            ],
            /,
        ) -> "ClusterTrustBundleProjection.Builder": ...

        @overload
        def label_selector(
            self, value_or_callback: Never = ...
        ) -> "apimachinery.LabelSelector.BuilderContext": ...

        def label_selector(self, value_or_callback=None, /):
            """
            Select all ClusterTrustBundles that match this label selector.  Only has effect if signerName is set.  Mutually-exclusive with name.  If unset, interpreted as "match nothing".  If set but empty, interpreted as "match everything".
            """
            if self._in_context and value_or_callback is None:
                context = apimachinery.LabelSelector.BuilderContext()
                context._parent_builder = self
                context._field_name = "label_selector"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(apimachinery.LabelSelector.builder())
                if isinstance(output, apimachinery.LabelSelector.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("label_selector", value)

        def name(self, value: Optional[str], /) -> Self:
            """
            Select a single ClusterTrustBundle by object name.  Mutually-exclusive with signerName and labelSelector.
            """
            return self._set("name", value)

        def optional(self, value: Optional[bool], /) -> Self:
            """
            If true, don't block pod startup if the referenced ClusterTrustBundle(s) aren't available.  If using name, then the named ClusterTrustBundle is allowed not to exist.  If using signerName, then the combination of signerName and labelSelector is allowed to match zero ClusterTrustBundles.
            """
            return self._set("optional", value)

        def path(self, value: str, /) -> Self:
            """
            Relative path from the volume root to write the bundle.
            """
            return self._set("path", value)

        def signer_name(self, value: Optional[str], /) -> Self:
            """
            Select all ClusterTrustBundles that match this signer name. Mutually-exclusive with name.  The contents of all selected ClusterTrustBundles will be unified and deduplicated.
            """
            return self._set("signer_name", value)

    class BuilderContext(BuilderContextBase["ClusterTrustBundleProjection.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = ClusterTrustBundleProjection.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for ClusterTrustBundleProjection."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["ClusterTrustBundleProjection", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use ClusterTrustBundleProjection.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    label_selector: Annotated[
        Optional[apimachinery.LabelSelector], Field(alias="labelSelector")
    ] = None
    """
    Select all ClusterTrustBundles that match this label selector.  Only has effect if signerName is set.  Mutually-exclusive with name.  If unset, interpreted as "match nothing".  If set but empty, interpreted as "match everything".
    """
    name: Optional[str] = None
    """
    Select a single ClusterTrustBundle by object name.  Mutually-exclusive with signerName and labelSelector.
    """
    optional: Optional[bool] = None
    """
    If true, don't block pod startup if the referenced ClusterTrustBundle(s) aren't available.  If using name, then the named ClusterTrustBundle is allowed not to exist.  If using signerName, then the combination of signerName and labelSelector is allowed to match zero ClusterTrustBundles.
    """
    path: str
    """
    Relative path from the volume root to write the bundle.
    """
    signer_name: Annotated[Optional[str], Field(alias="signerName")] = None
    """
    Select all ClusterTrustBundles that match this signer name. Mutually-exclusive with name.  The contents of all selected ClusterTrustBundles will be unified and deduplicated.
    """


class ComponentStatus(Resource):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["ComponentStatus"]:
            return ComponentStatus

        def build(self) -> "ComponentStatus":
            return ComponentStatus(**self._attrs)

        def api_version(self, value: Optional[Literal["v1"]], /) -> Self:
            """
            APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
            """
            return self._set("api_version", value)

        @overload
        def conditions(
            self, value_or_callback: List[ComponentCondition], /
        ) -> "ComponentStatus.Builder": ...

        @overload
        def conditions(
            self,
            value_or_callback: Callable[
                [GenericListBuilder[ComponentCondition, ComponentCondition.Builder]],
                GenericListBuilder[ComponentCondition, ComponentCondition.Builder]
                | List[ComponentCondition],
            ],
            /,
        ) -> "ComponentStatus.Builder": ...

        @overload
        def conditions(
            self, value_or_callback: Never = ...
        ) -> ListBuilderContext[ComponentCondition.Builder]: ...

        def conditions(self, value_or_callback=None, /):
            """
            List of component conditions observed
            """
            if self._in_context and value_or_callback is None:
                context = ListBuilderContext[ComponentCondition.Builder]()
                context._parent_builder = self
                context._field_name = "conditions"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(ComponentCondition.list_builder())
                if isinstance(output, GenericListBuilder):
                    value = output.build()
                else:
                    value = output
            return self._set("conditions", value)

        def kind(self, value: Optional[Literal["ComponentStatus"]], /) -> Self:
            """
            Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
            """
            return self._set("kind", value)

        @overload
        def metadata(
            self, value_or_callback: Optional[apimachinery.ObjectMeta], /
        ) -> "ComponentStatus.Builder": ...

        @overload
        def metadata(
            self,
            value_or_callback: Callable[
                [apimachinery.ObjectMeta.Builder],
                apimachinery.ObjectMeta.Builder | apimachinery.ObjectMeta,
            ],
            /,
        ) -> "ComponentStatus.Builder": ...

        @overload
        def metadata(
            self, value_or_callback: Never = ...
        ) -> "apimachinery.ObjectMeta.BuilderContext": ...

        def metadata(self, value_or_callback=None, /):
            """
            Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
            """
            if self._in_context and value_or_callback is None:
                context = apimachinery.ObjectMeta.BuilderContext()
                context._parent_builder = self
                context._field_name = "metadata"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(apimachinery.ObjectMeta.builder())
                if isinstance(output, apimachinery.ObjectMeta.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("metadata", value)

    class BuilderContext(BuilderContextBase["ComponentStatus.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = ComponentStatus.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for ComponentStatus."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["ComponentStatus", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use ComponentStatus.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    api_version: Annotated[Optional[Literal["v1"]], Field(alias="apiVersion")] = "v1"
    """
    APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
    """
    conditions: Optional[List[ComponentCondition]] = None
    """
    List of component conditions observed
    """
    kind: Optional[Literal["ComponentStatus"]] = "ComponentStatus"
    """
    Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
    """
    metadata: Optional[apimachinery.ObjectMeta] = None
    """
    Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
    """


ComponentStatusList = ResourceList["ComponentStatus"]


class ConfigMap(Resource):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["ConfigMap"]:
            return ConfigMap

        def build(self) -> "ConfigMap":
            return ConfigMap(**self._attrs)

        def api_version(self, value: Optional[Literal["v1"]], /) -> Self:
            """
            APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
            """
            return self._set("api_version", value)

        def binary_data(self, value: Optional[Dict[str, str]], /) -> Self:
            """
            BinaryData contains the binary data. Each key must consist of alphanumeric characters, '-', '_' or '.'. BinaryData can contain byte sequences that are not in the UTF-8 range. The keys stored in BinaryData must not overlap with the ones in the Data field, this is enforced during validation process. Using this field will require 1.10+ apiserver and kubelet.
            """
            return self._set("binary_data", value)

        def data(self, value: Optional[Dict[str, str]], /) -> Self:
            """
            Data contains the configuration data. Each key must consist of alphanumeric characters, '-', '_' or '.'. Values with non-UTF-8 byte sequences must use the BinaryData field. The keys stored in Data must not overlap with the keys in the BinaryData field, this is enforced during validation process.
            """
            return self._set("data", value)

        def immutable(self, value: Optional[bool], /) -> Self:
            """
            Immutable, if set to true, ensures that data stored in the ConfigMap cannot be updated (only object metadata can be modified). If not set to true, the field can be modified at any time. Defaulted to nil.
            """
            return self._set("immutable", value)

        def kind(self, value: Optional[Literal["ConfigMap"]], /) -> Self:
            """
            Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
            """
            return self._set("kind", value)

        @overload
        def metadata(
            self, value_or_callback: Optional[apimachinery.ObjectMeta], /
        ) -> "ConfigMap.Builder": ...

        @overload
        def metadata(
            self,
            value_or_callback: Callable[
                [apimachinery.ObjectMeta.Builder],
                apimachinery.ObjectMeta.Builder | apimachinery.ObjectMeta,
            ],
            /,
        ) -> "ConfigMap.Builder": ...

        @overload
        def metadata(
            self, value_or_callback: Never = ...
        ) -> "apimachinery.ObjectMeta.BuilderContext": ...

        def metadata(self, value_or_callback=None, /):
            """
            Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
            """
            if self._in_context and value_or_callback is None:
                context = apimachinery.ObjectMeta.BuilderContext()
                context._parent_builder = self
                context._field_name = "metadata"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(apimachinery.ObjectMeta.builder())
                if isinstance(output, apimachinery.ObjectMeta.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("metadata", value)

    class BuilderContext(BuilderContextBase["ConfigMap.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = ConfigMap.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for ConfigMap."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["ConfigMap", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use ConfigMap.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    api_version: Annotated[Optional[Literal["v1"]], Field(alias="apiVersion")] = "v1"
    """
    APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
    """
    binary_data: Annotated[Optional[Dict[str, str]], Field(alias="binaryData")] = None
    """
    BinaryData contains the binary data. Each key must consist of alphanumeric characters, '-', '_' or '.'. BinaryData can contain byte sequences that are not in the UTF-8 range. The keys stored in BinaryData must not overlap with the ones in the Data field, this is enforced during validation process. Using this field will require 1.10+ apiserver and kubelet.
    """
    data: Optional[Dict[str, str]] = None
    """
    Data contains the configuration data. Each key must consist of alphanumeric characters, '-', '_' or '.'. Values with non-UTF-8 byte sequences must use the BinaryData field. The keys stored in Data must not overlap with the keys in the BinaryData field, this is enforced during validation process.
    """
    immutable: Optional[bool] = None
    """
    Immutable, if set to true, ensures that data stored in the ConfigMap cannot be updated (only object metadata can be modified). If not set to true, the field can be modified at any time. Defaulted to nil.
    """
    kind: Optional[Literal["ConfigMap"]] = "ConfigMap"
    """
    Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
    """
    metadata: Optional[apimachinery.ObjectMeta] = None
    """
    Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
    """


ConfigMapList = ResourceList["ConfigMap"]


class ContainerState(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["ContainerState"]:
            return ContainerState

        def build(self) -> "ContainerState":
            return ContainerState(**self._attrs)

        @overload
        def running(
            self, value_or_callback: Optional[ContainerStateRunning], /
        ) -> "ContainerState.Builder": ...

        @overload
        def running(
            self,
            value_or_callback: Callable[
                [ContainerStateRunning.Builder],
                ContainerStateRunning.Builder | ContainerStateRunning,
            ],
            /,
        ) -> "ContainerState.Builder": ...

        @overload
        def running(
            self, value_or_callback: Never = ...
        ) -> "ContainerStateRunning.BuilderContext": ...

        def running(self, value_or_callback=None, /):
            """
            Details about a running container
            """
            if self._in_context and value_or_callback is None:
                context = ContainerStateRunning.BuilderContext()
                context._parent_builder = self
                context._field_name = "running"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(ContainerStateRunning.builder())
                if isinstance(output, ContainerStateRunning.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("running", value)

        @overload
        def terminated(
            self, value_or_callback: Optional[ContainerStateTerminated], /
        ) -> "ContainerState.Builder": ...

        @overload
        def terminated(
            self,
            value_or_callback: Callable[
                [ContainerStateTerminated.Builder],
                ContainerStateTerminated.Builder | ContainerStateTerminated,
            ],
            /,
        ) -> "ContainerState.Builder": ...

        @overload
        def terminated(
            self, value_or_callback: Never = ...
        ) -> "ContainerStateTerminated.BuilderContext": ...

        def terminated(self, value_or_callback=None, /):
            """
            Details about a terminated container
            """
            if self._in_context and value_or_callback is None:
                context = ContainerStateTerminated.BuilderContext()
                context._parent_builder = self
                context._field_name = "terminated"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(ContainerStateTerminated.builder())
                if isinstance(output, ContainerStateTerminated.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("terminated", value)

        @overload
        def waiting(
            self, value_or_callback: Optional[ContainerStateWaiting], /
        ) -> "ContainerState.Builder": ...

        @overload
        def waiting(
            self,
            value_or_callback: Callable[
                [ContainerStateWaiting.Builder],
                ContainerStateWaiting.Builder | ContainerStateWaiting,
            ],
            /,
        ) -> "ContainerState.Builder": ...

        @overload
        def waiting(
            self, value_or_callback: Never = ...
        ) -> "ContainerStateWaiting.BuilderContext": ...

        def waiting(self, value_or_callback=None, /):
            """
            Details about a waiting container
            """
            if self._in_context and value_or_callback is None:
                context = ContainerStateWaiting.BuilderContext()
                context._parent_builder = self
                context._field_name = "waiting"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(ContainerStateWaiting.builder())
                if isinstance(output, ContainerStateWaiting.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("waiting", value)

    class BuilderContext(BuilderContextBase["ContainerState.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = ContainerState.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for ContainerState."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["ContainerState", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use ContainerState.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    running: Optional[ContainerStateRunning] = None
    """
    Details about a running container
    """
    terminated: Optional[ContainerStateTerminated] = None
    """
    Details about a terminated container
    """
    waiting: Optional[ContainerStateWaiting] = None
    """
    Details about a waiting container
    """


class ContainerStatus(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["ContainerStatus"]:
            return ContainerStatus

        def build(self) -> "ContainerStatus":
            return ContainerStatus(**self._attrs)

        def allocated_resources(self, value: Optional[Dict[str, apimachinery.Quantity]], /) -> Self:
            """
            AllocatedResources represents the compute resources allocated for this container by the node. Kubelet sets this value to Container.Resources.Requests upon successful pod admission and after successfully admitting desired pod resize.
            """
            return self._set("allocated_resources", value)

        @overload
        def allocated_resources_status(
            self, value_or_callback: List[ResourceStatus], /
        ) -> "ContainerStatus.Builder": ...

        @overload
        def allocated_resources_status(
            self,
            value_or_callback: Callable[
                [GenericListBuilder[ResourceStatus, ResourceStatus.Builder]],
                GenericListBuilder[ResourceStatus, ResourceStatus.Builder] | List[ResourceStatus],
            ],
            /,
        ) -> "ContainerStatus.Builder": ...

        @overload
        def allocated_resources_status(
            self, value_or_callback: Never = ...
        ) -> ListBuilderContext[ResourceStatus.Builder]: ...

        def allocated_resources_status(self, value_or_callback=None, /):
            """
            AllocatedResourcesStatus represents the status of various resources allocated for this Pod.
            """
            if self._in_context and value_or_callback is None:
                context = ListBuilderContext[ResourceStatus.Builder]()
                context._parent_builder = self
                context._field_name = "allocated_resources_status"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(ResourceStatus.list_builder())
                if isinstance(output, GenericListBuilder):
                    value = output.build()
                else:
                    value = output
            return self._set("allocated_resources_status", value)

        def container_id(self, value: Optional[str], /) -> Self:
            """
            ContainerID is the ID of the container in the format '<type>://<container_id>'. Where type is a container runtime identifier, returned from Version call of CRI API (for example "containerd").
            """
            return self._set("container_id", value)

        def image(self, value: str, /) -> Self:
            """
            Image is the name of container image that the container is running. The container image may not match the image used in the PodSpec, as it may have been resolved by the runtime. More info: https://kubernetes.io/docs/concepts/containers/images.
            """
            return self._set("image", value)

        def image_id(self, value: str, /) -> Self:
            """
            ImageID is the image ID of the container's image. The image ID may not match the image ID of the image used in the PodSpec, as it may have been resolved by the runtime.
            """
            return self._set("image_id", value)

        @overload
        def last_state(
            self, value_or_callback: Optional[ContainerState], /
        ) -> "ContainerStatus.Builder": ...

        @overload
        def last_state(
            self,
            value_or_callback: Callable[
                [ContainerState.Builder], ContainerState.Builder | ContainerState
            ],
            /,
        ) -> "ContainerStatus.Builder": ...

        @overload
        def last_state(self, value_or_callback: Never = ...) -> "ContainerState.BuilderContext": ...

        def last_state(self, value_or_callback=None, /):
            """
            LastTerminationState holds the last termination state of the container to help debug container crashes and restarts. This field is not populated if the container is still running and RestartCount is 0.
            """
            if self._in_context and value_or_callback is None:
                context = ContainerState.BuilderContext()
                context._parent_builder = self
                context._field_name = "last_state"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(ContainerState.builder())
                if isinstance(output, ContainerState.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("last_state", value)

        def name(self, value: str, /) -> Self:
            """
            Name is a DNS_LABEL representing the unique name of the container. Each container in a pod must have a unique name across all container types. Cannot be updated.
            """
            return self._set("name", value)

        def ready(self, value: bool, /) -> Self:
            """
            Ready specifies whether the container is currently passing its readiness check. The value will change as readiness probes keep executing. If no readiness probes are specified, this field defaults to true once the container is fully started (see Started field).

            The value is typically used to determine whether a container is ready to accept traffic.
            """
            return self._set("ready", value)

        @overload
        def resources(
            self, value_or_callback: Optional[ResourceRequirements], /
        ) -> "ContainerStatus.Builder": ...

        @overload
        def resources(
            self,
            value_or_callback: Callable[
                [ResourceRequirements.Builder],
                ResourceRequirements.Builder | ResourceRequirements,
            ],
            /,
        ) -> "ContainerStatus.Builder": ...

        @overload
        def resources(
            self, value_or_callback: Never = ...
        ) -> "ResourceRequirements.BuilderContext": ...

        def resources(self, value_or_callback=None, /):
            """
            Resources represents the compute resource requests and limits that have been successfully enacted on the running container after it has been started or has been successfully resized.
            """
            if self._in_context and value_or_callback is None:
                context = ResourceRequirements.BuilderContext()
                context._parent_builder = self
                context._field_name = "resources"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(ResourceRequirements.builder())
                if isinstance(output, ResourceRequirements.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("resources", value)

        def restart_count(self, value: int, /) -> Self:
            """
            RestartCount holds the number of times the container has been restarted. Kubelet makes an effort to always increment the value, but there are cases when the state may be lost due to node restarts and then the value may be reset to 0. The value is never negative.
            """
            return self._set("restart_count", value)

        def started(self, value: Optional[bool], /) -> Self:
            """
            Started indicates whether the container has finished its postStart lifecycle hook and passed its startup probe. Initialized as false, becomes true after startupProbe is considered successful. Resets to false when the container is restarted, or if kubelet loses state temporarily. In both cases, startup probes will run again. Is always true when no startupProbe is defined and container is running and has passed the postStart lifecycle hook. The null value must be treated the same as false.
            """
            return self._set("started", value)

        @overload
        def state(
            self, value_or_callback: Optional[ContainerState], /
        ) -> "ContainerStatus.Builder": ...

        @overload
        def state(
            self,
            value_or_callback: Callable[
                [ContainerState.Builder], ContainerState.Builder | ContainerState
            ],
            /,
        ) -> "ContainerStatus.Builder": ...

        @overload
        def state(self, value_or_callback: Never = ...) -> "ContainerState.BuilderContext": ...

        def state(self, value_or_callback=None, /):
            """
            State holds details about the container's current condition.
            """
            if self._in_context and value_or_callback is None:
                context = ContainerState.BuilderContext()
                context._parent_builder = self
                context._field_name = "state"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(ContainerState.builder())
                if isinstance(output, ContainerState.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("state", value)

        @overload
        def user(
            self, value_or_callback: Optional[ContainerUser], /
        ) -> "ContainerStatus.Builder": ...

        @overload
        def user(
            self,
            value_or_callback: Callable[
                [ContainerUser.Builder], ContainerUser.Builder | ContainerUser
            ],
            /,
        ) -> "ContainerStatus.Builder": ...

        @overload
        def user(self, value_or_callback: Never = ...) -> "ContainerUser.BuilderContext": ...

        def user(self, value_or_callback=None, /):
            """
            User represents user identity information initially attached to the first process of the container
            """
            if self._in_context and value_or_callback is None:
                context = ContainerUser.BuilderContext()
                context._parent_builder = self
                context._field_name = "user"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(ContainerUser.builder())
                if isinstance(output, ContainerUser.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("user", value)

        @overload
        def volume_mounts(
            self, value_or_callback: List[VolumeMountStatus], /
        ) -> "ContainerStatus.Builder": ...

        @overload
        def volume_mounts(
            self,
            value_or_callback: Callable[
                [GenericListBuilder[VolumeMountStatus, VolumeMountStatus.Builder]],
                GenericListBuilder[VolumeMountStatus, VolumeMountStatus.Builder]
                | List[VolumeMountStatus],
            ],
            /,
        ) -> "ContainerStatus.Builder": ...

        @overload
        def volume_mounts(
            self, value_or_callback: Never = ...
        ) -> ListBuilderContext[VolumeMountStatus.Builder]: ...

        def volume_mounts(self, value_or_callback=None, /):
            """
            Status of volume mounts.
            """
            if self._in_context and value_or_callback is None:
                context = ListBuilderContext[VolumeMountStatus.Builder]()
                context._parent_builder = self
                context._field_name = "volume_mounts"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(VolumeMountStatus.list_builder())
                if isinstance(output, GenericListBuilder):
                    value = output.build()
                else:
                    value = output
            return self._set("volume_mounts", value)

    class BuilderContext(BuilderContextBase["ContainerStatus.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = ContainerStatus.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for ContainerStatus."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["ContainerStatus", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use ContainerStatus.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    allocated_resources: Annotated[
        Optional[Dict[str, apimachinery.Quantity]], Field(alias="allocatedResources")
    ] = None
    """
    AllocatedResources represents the compute resources allocated for this container by the node. Kubelet sets this value to Container.Resources.Requests upon successful pod admission and after successfully admitting desired pod resize.
    """
    allocated_resources_status: Annotated[
        Optional[List[ResourceStatus]], Field(alias="allocatedResourcesStatus")
    ] = None
    """
    AllocatedResourcesStatus represents the status of various resources allocated for this Pod.
    """
    container_id: Annotated[Optional[str], Field(alias="containerID")] = None
    """
    ContainerID is the ID of the container in the format '<type>://<container_id>'. Where type is a container runtime identifier, returned from Version call of CRI API (for example "containerd").
    """
    image: str
    """
    Image is the name of container image that the container is running. The container image may not match the image used in the PodSpec, as it may have been resolved by the runtime. More info: https://kubernetes.io/docs/concepts/containers/images.
    """
    image_id: Annotated[str, Field(alias="imageID")]
    """
    ImageID is the image ID of the container's image. The image ID may not match the image ID of the image used in the PodSpec, as it may have been resolved by the runtime.
    """
    last_state: Annotated[Optional[ContainerState], Field(alias="lastState")] = None
    """
    LastTerminationState holds the last termination state of the container to help debug container crashes and restarts. This field is not populated if the container is still running and RestartCount is 0.
    """
    name: str
    """
    Name is a DNS_LABEL representing the unique name of the container. Each container in a pod must have a unique name across all container types. Cannot be updated.
    """
    ready: bool
    """
    Ready specifies whether the container is currently passing its readiness check. The value will change as readiness probes keep executing. If no readiness probes are specified, this field defaults to true once the container is fully started (see Started field).

    The value is typically used to determine whether a container is ready to accept traffic.
    """
    resources: Optional[ResourceRequirements] = None
    """
    Resources represents the compute resource requests and limits that have been successfully enacted on the running container after it has been started or has been successfully resized.
    """
    restart_count: Annotated[int, Field(alias="restartCount")]
    """
    RestartCount holds the number of times the container has been restarted. Kubelet makes an effort to always increment the value, but there are cases when the state may be lost due to node restarts and then the value may be reset to 0. The value is never negative.
    """
    started: Optional[bool] = None
    """
    Started indicates whether the container has finished its postStart lifecycle hook and passed its startup probe. Initialized as false, becomes true after startupProbe is considered successful. Resets to false when the container is restarted, or if kubelet loses state temporarily. In both cases, startup probes will run again. Is always true when no startupProbe is defined and container is running and has passed the postStart lifecycle hook. The null value must be treated the same as false.
    """
    state: Optional[ContainerState] = None
    """
    State holds details about the container's current condition.
    """
    user: Optional[ContainerUser] = None
    """
    User represents user identity information initially attached to the first process of the container
    """
    volume_mounts: Annotated[Optional[List[VolumeMountStatus]], Field(alias="volumeMounts")] = None
    """
    Status of volume mounts.
    """


class DownwardAPIVolumeFile(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["DownwardAPIVolumeFile"]:
            return DownwardAPIVolumeFile

        def build(self) -> "DownwardAPIVolumeFile":
            return DownwardAPIVolumeFile(**self._attrs)

        @overload
        def field_ref(
            self, value_or_callback: Optional[ObjectFieldSelector], /
        ) -> "DownwardAPIVolumeFile.Builder": ...

        @overload
        def field_ref(
            self,
            value_or_callback: Callable[
                [ObjectFieldSelector.Builder],
                ObjectFieldSelector.Builder | ObjectFieldSelector,
            ],
            /,
        ) -> "DownwardAPIVolumeFile.Builder": ...

        @overload
        def field_ref(
            self, value_or_callback: Never = ...
        ) -> "ObjectFieldSelector.BuilderContext": ...

        def field_ref(self, value_or_callback=None, /):
            """
            Required: Selects a field of the pod: only annotations, labels, name, namespace and uid are supported.
            """
            if self._in_context and value_or_callback is None:
                context = ObjectFieldSelector.BuilderContext()
                context._parent_builder = self
                context._field_name = "field_ref"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(ObjectFieldSelector.builder())
                if isinstance(output, ObjectFieldSelector.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("field_ref", value)

        def mode(self, value: Optional[int], /) -> Self:
            """
            Optional: mode bits used to set permissions on this file, must be an octal value between 0000 and 0777 or a decimal value between 0 and 511. YAML accepts both octal and decimal values, JSON requires decimal values for mode bits. If not specified, the volume defaultMode will be used. This might be in conflict with other options that affect the file mode, like fsGroup, and the result can be other mode bits set.
            """
            return self._set("mode", value)

        def path(self, value: str, /) -> Self:
            """
            Required: Path is  the relative path name of the file to be created. Must not be absolute or contain the '..' path. Must be utf-8 encoded. The first item of the relative path must not start with '..'
            """
            return self._set("path", value)

        @overload
        def resource_field_ref(
            self, value_or_callback: Optional[ResourceFieldSelector], /
        ) -> "DownwardAPIVolumeFile.Builder": ...

        @overload
        def resource_field_ref(
            self,
            value_or_callback: Callable[
                [ResourceFieldSelector.Builder],
                ResourceFieldSelector.Builder | ResourceFieldSelector,
            ],
            /,
        ) -> "DownwardAPIVolumeFile.Builder": ...

        @overload
        def resource_field_ref(
            self, value_or_callback: Never = ...
        ) -> "ResourceFieldSelector.BuilderContext": ...

        def resource_field_ref(self, value_or_callback=None, /):
            """
            Selects a resource of the container: only resources limits and requests (limits.cpu, limits.memory, requests.cpu and requests.memory) are currently supported.
            """
            if self._in_context and value_or_callback is None:
                context = ResourceFieldSelector.BuilderContext()
                context._parent_builder = self
                context._field_name = "resource_field_ref"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(ResourceFieldSelector.builder())
                if isinstance(output, ResourceFieldSelector.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("resource_field_ref", value)

    class BuilderContext(BuilderContextBase["DownwardAPIVolumeFile.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = DownwardAPIVolumeFile.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for DownwardAPIVolumeFile."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["DownwardAPIVolumeFile", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use DownwardAPIVolumeFile.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    field_ref: Annotated[Optional[ObjectFieldSelector], Field(alias="fieldRef")] = None
    """
    Required: Selects a field of the pod: only annotations, labels, name, namespace and uid are supported.
    """
    mode: Optional[int] = None
    """
    Optional: mode bits used to set permissions on this file, must be an octal value between 0000 and 0777 or a decimal value between 0 and 511. YAML accepts both octal and decimal values, JSON requires decimal values for mode bits. If not specified, the volume defaultMode will be used. This might be in conflict with other options that affect the file mode, like fsGroup, and the result can be other mode bits set.
    """
    path: str
    """
    Required: Path is  the relative path name of the file to be created. Must not be absolute or contain the '..' path. Must be utf-8 encoded. The first item of the relative path must not start with '..'
    """
    resource_field_ref: Annotated[
        Optional[ResourceFieldSelector], Field(alias="resourceFieldRef")
    ] = None
    """
    Selects a resource of the container: only resources limits and requests (limits.cpu, limits.memory, requests.cpu and requests.memory) are currently supported.
    """


class DownwardAPIVolumeSource(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["DownwardAPIVolumeSource"]:
            return DownwardAPIVolumeSource

        def build(self) -> "DownwardAPIVolumeSource":
            return DownwardAPIVolumeSource(**self._attrs)

        def default_mode(self, value: Optional[int], /) -> Self:
            """
            Optional: mode bits to use on created files by default. Must be a Optional: mode bits used to set permissions on created files by default. Must be an octal value between 0000 and 0777 or a decimal value between 0 and 511. YAML accepts both octal and decimal values, JSON requires decimal values for mode bits. Defaults to 0644. Directories within the path are not affected by this setting. This might be in conflict with other options that affect the file mode, like fsGroup, and the result can be other mode bits set.
            """
            return self._set("default_mode", value)

        @overload
        def items(
            self, value_or_callback: List[DownwardAPIVolumeFile], /
        ) -> "DownwardAPIVolumeSource.Builder": ...

        @overload
        def items(
            self,
            value_or_callback: Callable[
                [GenericListBuilder[DownwardAPIVolumeFile, DownwardAPIVolumeFile.Builder]],
                GenericListBuilder[DownwardAPIVolumeFile, DownwardAPIVolumeFile.Builder]
                | List[DownwardAPIVolumeFile],
            ],
            /,
        ) -> "DownwardAPIVolumeSource.Builder": ...

        @overload
        def items(
            self, value_or_callback: Never = ...
        ) -> ListBuilderContext[DownwardAPIVolumeFile.Builder]: ...

        def items(self, value_or_callback=None, /):
            """
            Items is a list of downward API volume file
            """
            if self._in_context and value_or_callback is None:
                context = ListBuilderContext[DownwardAPIVolumeFile.Builder]()
                context._parent_builder = self
                context._field_name = "items"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(DownwardAPIVolumeFile.list_builder())
                if isinstance(output, GenericListBuilder):
                    value = output.build()
                else:
                    value = output
            return self._set("items", value)

    class BuilderContext(BuilderContextBase["DownwardAPIVolumeSource.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = DownwardAPIVolumeSource.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for DownwardAPIVolumeSource."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["DownwardAPIVolumeSource", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use DownwardAPIVolumeSource.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    default_mode: Annotated[Optional[int], Field(alias="defaultMode")] = None
    """
    Optional: mode bits to use on created files by default. Must be a Optional: mode bits used to set permissions on created files by default. Must be an octal value between 0000 and 0777 or a decimal value between 0 and 511. YAML accepts both octal and decimal values, JSON requires decimal values for mode bits. Defaults to 0644. Directories within the path are not affected by this setting. This might be in conflict with other options that affect the file mode, like fsGroup, and the result can be other mode bits set.
    """
    items: Optional[List[DownwardAPIVolumeFile]] = None
    """
    Items is a list of downward API volume file
    """


class Endpoints(Resource):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["Endpoints"]:
            return Endpoints

        def build(self) -> "Endpoints":
            return Endpoints(**self._attrs)

        def api_version(self, value: Optional[Literal["v1"]], /) -> Self:
            """
            APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
            """
            return self._set("api_version", value)

        def kind(self, value: Optional[Literal["Endpoints"]], /) -> Self:
            """
            Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
            """
            return self._set("kind", value)

        @overload
        def metadata(
            self, value_or_callback: Optional[apimachinery.ObjectMeta], /
        ) -> "Endpoints.Builder": ...

        @overload
        def metadata(
            self,
            value_or_callback: Callable[
                [apimachinery.ObjectMeta.Builder],
                apimachinery.ObjectMeta.Builder | apimachinery.ObjectMeta,
            ],
            /,
        ) -> "Endpoints.Builder": ...

        @overload
        def metadata(
            self, value_or_callback: Never = ...
        ) -> "apimachinery.ObjectMeta.BuilderContext": ...

        def metadata(self, value_or_callback=None, /):
            """
            Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
            """
            if self._in_context and value_or_callback is None:
                context = apimachinery.ObjectMeta.BuilderContext()
                context._parent_builder = self
                context._field_name = "metadata"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(apimachinery.ObjectMeta.builder())
                if isinstance(output, apimachinery.ObjectMeta.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("metadata", value)

        @overload
        def subsets(self, value_or_callback: List[EndpointSubset], /) -> "Endpoints.Builder": ...

        @overload
        def subsets(
            self,
            value_or_callback: Callable[
                [GenericListBuilder[EndpointSubset, EndpointSubset.Builder]],
                GenericListBuilder[EndpointSubset, EndpointSubset.Builder] | List[EndpointSubset],
            ],
            /,
        ) -> "Endpoints.Builder": ...

        @overload
        def subsets(
            self, value_or_callback: Never = ...
        ) -> ListBuilderContext[EndpointSubset.Builder]: ...

        def subsets(self, value_or_callback=None, /):
            """
            The set of all endpoints is the union of all subsets. Addresses are placed into subsets according to the IPs they share. A single address with multiple ports, some of which are ready and some of which are not (because they come from different containers) will result in the address being displayed in different subsets for the different ports. No address will appear in both Addresses and NotReadyAddresses in the same subset. Sets of addresses and ports that comprise a service.
            """
            if self._in_context and value_or_callback is None:
                context = ListBuilderContext[EndpointSubset.Builder]()
                context._parent_builder = self
                context._field_name = "subsets"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(EndpointSubset.list_builder())
                if isinstance(output, GenericListBuilder):
                    value = output.build()
                else:
                    value = output
            return self._set("subsets", value)

    class BuilderContext(BuilderContextBase["Endpoints.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = Endpoints.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for Endpoints."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["Endpoints", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use Endpoints.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    api_version: Annotated[Optional[Literal["v1"]], Field(alias="apiVersion")] = "v1"
    """
    APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
    """
    kind: Optional[Literal["Endpoints"]] = "Endpoints"
    """
    Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
    """
    metadata: Optional[apimachinery.ObjectMeta] = None
    """
    Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
    """
    subsets: Optional[List[EndpointSubset]] = None
    """
    The set of all endpoints is the union of all subsets. Addresses are placed into subsets according to the IPs they share. A single address with multiple ports, some of which are ready and some of which are not (because they come from different containers) will result in the address being displayed in different subsets for the different ports. No address will appear in both Addresses and NotReadyAddresses in the same subset. Sets of addresses and ports that comprise a service.
    """


EndpointsList = ResourceList["Endpoints"]


class EnvVarSource(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["EnvVarSource"]:
            return EnvVarSource

        def build(self) -> "EnvVarSource":
            return EnvVarSource(**self._attrs)

        @overload
        def config_map_key_ref(
            self, value_or_callback: Optional[ConfigMapKeySelector], /
        ) -> "EnvVarSource.Builder": ...

        @overload
        def config_map_key_ref(
            self,
            value_or_callback: Callable[
                [ConfigMapKeySelector.Builder],
                ConfigMapKeySelector.Builder | ConfigMapKeySelector,
            ],
            /,
        ) -> "EnvVarSource.Builder": ...

        @overload
        def config_map_key_ref(
            self, value_or_callback: Never = ...
        ) -> "ConfigMapKeySelector.BuilderContext": ...

        def config_map_key_ref(self, value_or_callback=None, /):
            """
            Selects a key of a ConfigMap.
            """
            if self._in_context and value_or_callback is None:
                context = ConfigMapKeySelector.BuilderContext()
                context._parent_builder = self
                context._field_name = "config_map_key_ref"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(ConfigMapKeySelector.builder())
                if isinstance(output, ConfigMapKeySelector.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("config_map_key_ref", value)

        @overload
        def field_ref(
            self, value_or_callback: Optional[ObjectFieldSelector], /
        ) -> "EnvVarSource.Builder": ...

        @overload
        def field_ref(
            self,
            value_or_callback: Callable[
                [ObjectFieldSelector.Builder],
                ObjectFieldSelector.Builder | ObjectFieldSelector,
            ],
            /,
        ) -> "EnvVarSource.Builder": ...

        @overload
        def field_ref(
            self, value_or_callback: Never = ...
        ) -> "ObjectFieldSelector.BuilderContext": ...

        def field_ref(self, value_or_callback=None, /):
            """
            Selects a field of the pod: supports metadata.name, metadata.namespace, `metadata.labels['<KEY>']`, `metadata.annotations['<KEY>']`, spec.nodeName, spec.serviceAccountName, status.hostIP, status.podIP, status.podIPs.
            """
            if self._in_context and value_or_callback is None:
                context = ObjectFieldSelector.BuilderContext()
                context._parent_builder = self
                context._field_name = "field_ref"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(ObjectFieldSelector.builder())
                if isinstance(output, ObjectFieldSelector.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("field_ref", value)

        @overload
        def resource_field_ref(
            self, value_or_callback: Optional[ResourceFieldSelector], /
        ) -> "EnvVarSource.Builder": ...

        @overload
        def resource_field_ref(
            self,
            value_or_callback: Callable[
                [ResourceFieldSelector.Builder],
                ResourceFieldSelector.Builder | ResourceFieldSelector,
            ],
            /,
        ) -> "EnvVarSource.Builder": ...

        @overload
        def resource_field_ref(
            self, value_or_callback: Never = ...
        ) -> "ResourceFieldSelector.BuilderContext": ...

        def resource_field_ref(self, value_or_callback=None, /):
            """
            Selects a resource of the container: only resources limits and requests (limits.cpu, limits.memory, limits.ephemeral-storage, requests.cpu, requests.memory and requests.ephemeral-storage) are currently supported.
            """
            if self._in_context and value_or_callback is None:
                context = ResourceFieldSelector.BuilderContext()
                context._parent_builder = self
                context._field_name = "resource_field_ref"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(ResourceFieldSelector.builder())
                if isinstance(output, ResourceFieldSelector.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("resource_field_ref", value)

        @overload
        def secret_key_ref(
            self, value_or_callback: Optional[SecretKeySelector], /
        ) -> "EnvVarSource.Builder": ...

        @overload
        def secret_key_ref(
            self,
            value_or_callback: Callable[
                [SecretKeySelector.Builder],
                SecretKeySelector.Builder | SecretKeySelector,
            ],
            /,
        ) -> "EnvVarSource.Builder": ...

        @overload
        def secret_key_ref(
            self, value_or_callback: Never = ...
        ) -> "SecretKeySelector.BuilderContext": ...

        def secret_key_ref(self, value_or_callback=None, /):
            """
            Selects a key of a secret in the pod's namespace
            """
            if self._in_context and value_or_callback is None:
                context = SecretKeySelector.BuilderContext()
                context._parent_builder = self
                context._field_name = "secret_key_ref"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(SecretKeySelector.builder())
                if isinstance(output, SecretKeySelector.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("secret_key_ref", value)

    class BuilderContext(BuilderContextBase["EnvVarSource.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = EnvVarSource.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for EnvVarSource."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["EnvVarSource", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use EnvVarSource.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    config_map_key_ref: Annotated[
        Optional[ConfigMapKeySelector], Field(alias="configMapKeyRef")
    ] = None
    """
    Selects a key of a ConfigMap.
    """
    field_ref: Annotated[Optional[ObjectFieldSelector], Field(alias="fieldRef")] = None
    """
    Selects a field of the pod: supports metadata.name, metadata.namespace, `metadata.labels['<KEY>']`, `metadata.annotations['<KEY>']`, spec.nodeName, spec.serviceAccountName, status.hostIP, status.podIP, status.podIPs.
    """
    resource_field_ref: Annotated[
        Optional[ResourceFieldSelector], Field(alias="resourceFieldRef")
    ] = None
    """
    Selects a resource of the container: only resources limits and requests (limits.cpu, limits.memory, limits.ephemeral-storage, requests.cpu, requests.memory and requests.ephemeral-storage) are currently supported.
    """
    secret_key_ref: Annotated[Optional[SecretKeySelector], Field(alias="secretKeyRef")] = None
    """
    Selects a key of a secret in the pod's namespace
    """


class Event(Resource):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["Event"]:
            return Event

        def build(self) -> "Event":
            return Event(**self._attrs)

        def action(self, value: Optional[str], /) -> Self:
            """
            What action was taken/failed regarding to the Regarding object.
            """
            return self._set("action", value)

        def api_version(self, value: Optional[Literal["v1"]], /) -> Self:
            """
            APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
            """
            return self._set("api_version", value)

        def count(self, value: Optional[int], /) -> Self:
            """
            The number of times this event has occurred.
            """
            return self._set("count", value)

        @overload
        def event_time(
            self, value_or_callback: Optional[apimachinery.MicroTime], /
        ) -> "Event.Builder": ...

        @overload
        def event_time(
            self,
            value_or_callback: Callable[
                [apimachinery.MicroTime.Builder],
                apimachinery.MicroTime.Builder | apimachinery.MicroTime,
            ],
            /,
        ) -> "Event.Builder": ...

        @overload
        def event_time(
            self, value_or_callback: Never = ...
        ) -> "apimachinery.MicroTime.BuilderContext": ...

        def event_time(self, value_or_callback=None, /):
            """
            Time when this Event was first observed.
            """
            if self._in_context and value_or_callback is None:
                context = apimachinery.MicroTime.BuilderContext()
                context._parent_builder = self
                context._field_name = "event_time"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(apimachinery.MicroTime.builder())
                if isinstance(output, apimachinery.MicroTime.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("event_time", value)

        @overload
        def first_timestamp(
            self, value_or_callback: Optional[apimachinery.Time], /
        ) -> "Event.Builder": ...

        @overload
        def first_timestamp(
            self,
            value_or_callback: Callable[
                [apimachinery.Time.Builder],
                apimachinery.Time.Builder | apimachinery.Time,
            ],
            /,
        ) -> "Event.Builder": ...

        @overload
        def first_timestamp(
            self, value_or_callback: Never = ...
        ) -> "apimachinery.Time.BuilderContext": ...

        def first_timestamp(self, value_or_callback=None, /):
            """
            The time at which the event was first recorded. (Time of server receipt is in TypeMeta.)
            """
            if self._in_context and value_or_callback is None:
                context = apimachinery.Time.BuilderContext()
                context._parent_builder = self
                context._field_name = "first_timestamp"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(apimachinery.Time.builder())
                if isinstance(output, apimachinery.Time.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("first_timestamp", value)

        @overload
        def involved_object(self, value_or_callback: ObjectReference, /) -> "Event.Builder": ...

        @overload
        def involved_object(
            self,
            value_or_callback: Callable[
                [ObjectReference.Builder], ObjectReference.Builder | ObjectReference
            ],
            /,
        ) -> "Event.Builder": ...

        @overload
        def involved_object(
            self, value_or_callback: Never = ...
        ) -> "ObjectReference.BuilderContext": ...

        def involved_object(self, value_or_callback=None, /):
            """
            The object that this event is about.
            """
            if self._in_context and value_or_callback is None:
                context = ObjectReference.BuilderContext()
                context._parent_builder = self
                context._field_name = "involved_object"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(ObjectReference.builder())
                if isinstance(output, ObjectReference.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("involved_object", value)

        def kind(self, value: Optional[Literal["Event"]], /) -> Self:
            """
            Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
            """
            return self._set("kind", value)

        @overload
        def last_timestamp(
            self, value_or_callback: Optional[apimachinery.Time], /
        ) -> "Event.Builder": ...

        @overload
        def last_timestamp(
            self,
            value_or_callback: Callable[
                [apimachinery.Time.Builder],
                apimachinery.Time.Builder | apimachinery.Time,
            ],
            /,
        ) -> "Event.Builder": ...

        @overload
        def last_timestamp(
            self, value_or_callback: Never = ...
        ) -> "apimachinery.Time.BuilderContext": ...

        def last_timestamp(self, value_or_callback=None, /):
            """
            The time at which the most recent occurrence of this event was recorded.
            """
            if self._in_context and value_or_callback is None:
                context = apimachinery.Time.BuilderContext()
                context._parent_builder = self
                context._field_name = "last_timestamp"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(apimachinery.Time.builder())
                if isinstance(output, apimachinery.Time.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("last_timestamp", value)

        def message(self, value: Optional[str], /) -> Self:
            """
            A human-readable description of the status of this operation.
            """
            return self._set("message", value)

        @overload
        def metadata(
            self, value_or_callback: Optional[apimachinery.ObjectMeta], /
        ) -> "Event.Builder": ...

        @overload
        def metadata(
            self,
            value_or_callback: Callable[
                [apimachinery.ObjectMeta.Builder],
                apimachinery.ObjectMeta.Builder | apimachinery.ObjectMeta,
            ],
            /,
        ) -> "Event.Builder": ...

        @overload
        def metadata(
            self, value_or_callback: Never = ...
        ) -> "apimachinery.ObjectMeta.BuilderContext": ...

        def metadata(self, value_or_callback=None, /):
            """
            Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
            """
            if self._in_context and value_or_callback is None:
                context = apimachinery.ObjectMeta.BuilderContext()
                context._parent_builder = self
                context._field_name = "metadata"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(apimachinery.ObjectMeta.builder())
                if isinstance(output, apimachinery.ObjectMeta.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("metadata", value)

        def reason(self, value: Optional[str], /) -> Self:
            """
            This should be a short, machine understandable string that gives the reason for the transition into the object's current status.
            """
            return self._set("reason", value)

        @overload
        def related(self, value_or_callback: Optional[ObjectReference], /) -> "Event.Builder": ...

        @overload
        def related(
            self,
            value_or_callback: Callable[
                [ObjectReference.Builder], ObjectReference.Builder | ObjectReference
            ],
            /,
        ) -> "Event.Builder": ...

        @overload
        def related(self, value_or_callback: Never = ...) -> "ObjectReference.BuilderContext": ...

        def related(self, value_or_callback=None, /):
            """
            Optional secondary object for more complex actions.
            """
            if self._in_context and value_or_callback is None:
                context = ObjectReference.BuilderContext()
                context._parent_builder = self
                context._field_name = "related"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(ObjectReference.builder())
                if isinstance(output, ObjectReference.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("related", value)

        def reporting_component(self, value: Optional[str], /) -> Self:
            """
            Name of the controller that emitted this Event, e.g. `kubernetes.io/kubelet`.
            """
            return self._set("reporting_component", value)

        def reporting_instance(self, value: Optional[str], /) -> Self:
            """
            ID of the controller instance, e.g. `kubelet-xyzf`.
            """
            return self._set("reporting_instance", value)

        @overload
        def series(self, value_or_callback: Optional[EventSeries], /) -> "Event.Builder": ...

        @overload
        def series(
            self,
            value_or_callback: Callable[[EventSeries.Builder], EventSeries.Builder | EventSeries],
            /,
        ) -> "Event.Builder": ...

        @overload
        def series(self, value_or_callback: Never = ...) -> "EventSeries.BuilderContext": ...

        def series(self, value_or_callback=None, /):
            """
            Data about the Event series this event represents or nil if it's a singleton Event.
            """
            if self._in_context and value_or_callback is None:
                context = EventSeries.BuilderContext()
                context._parent_builder = self
                context._field_name = "series"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(EventSeries.builder())
                if isinstance(output, EventSeries.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("series", value)

        @overload
        def source(self, value_or_callback: Optional[EventSource], /) -> "Event.Builder": ...

        @overload
        def source(
            self,
            value_or_callback: Callable[[EventSource.Builder], EventSource.Builder | EventSource],
            /,
        ) -> "Event.Builder": ...

        @overload
        def source(self, value_or_callback: Never = ...) -> "EventSource.BuilderContext": ...

        def source(self, value_or_callback=None, /):
            """
            The component reporting this event. Should be a short machine understandable string.
            """
            if self._in_context and value_or_callback is None:
                context = EventSource.BuilderContext()
                context._parent_builder = self
                context._field_name = "source"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(EventSource.builder())
                if isinstance(output, EventSource.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("source", value)

        def type(self, value: Optional[str], /) -> Self:
            """
            Type of this event (Normal, Warning), new types could be added in the future
            """
            return self._set("type", value)

    class BuilderContext(BuilderContextBase["Event.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = Event.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for Event."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["Event", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use Event.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    action: Optional[str] = None
    """
    What action was taken/failed regarding to the Regarding object.
    """
    api_version: Annotated[Optional[Literal["v1"]], Field(alias="apiVersion")] = "v1"
    """
    APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
    """
    count: Optional[int] = None
    """
    The number of times this event has occurred.
    """
    event_time: Annotated[Optional[apimachinery.MicroTime], Field(alias="eventTime")] = None
    """
    Time when this Event was first observed.
    """
    first_timestamp: Annotated[Optional[apimachinery.Time], Field(alias="firstTimestamp")] = None
    """
    The time at which the event was first recorded. (Time of server receipt is in TypeMeta.)
    """
    involved_object: Annotated[ObjectReference, Field(alias="involvedObject")]
    """
    The object that this event is about.
    """
    kind: Optional[Literal["Event"]] = "Event"
    """
    Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
    """
    last_timestamp: Annotated[Optional[apimachinery.Time], Field(alias="lastTimestamp")] = None
    """
    The time at which the most recent occurrence of this event was recorded.
    """
    message: Optional[str] = None
    """
    A human-readable description of the status of this operation.
    """
    metadata: Optional[apimachinery.ObjectMeta] = None
    """
    Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
    """
    reason: Optional[str] = None
    """
    This should be a short, machine understandable string that gives the reason for the transition into the object's current status.
    """
    related: Optional[ObjectReference] = None
    """
    Optional secondary object for more complex actions.
    """
    reporting_component: Annotated[Optional[str], Field(alias="reportingComponent")] = None
    """
    Name of the controller that emitted this Event, e.g. `kubernetes.io/kubelet`.
    """
    reporting_instance: Annotated[Optional[str], Field(alias="reportingInstance")] = None
    """
    ID of the controller instance, e.g. `kubelet-xyzf`.
    """
    series: Optional[EventSeries] = None
    """
    Data about the Event series this event represents or nil if it's a singleton Event.
    """
    source: Optional[EventSource] = None
    """
    The component reporting this event. Should be a short machine understandable string.
    """
    type: Optional[str] = None
    """
    Type of this event (Normal, Warning), new types could be added in the future
    """


EventList = ResourceList["Event"]


class LifecycleHandler(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["LifecycleHandler"]:
            return LifecycleHandler

        def build(self) -> "LifecycleHandler":
            return LifecycleHandler(**self._attrs)

        @overload
        def exec(
            self, value_or_callback: Optional[ExecAction], /
        ) -> "LifecycleHandler.Builder": ...

        @overload
        def exec(
            self,
            value_or_callback: Callable[[ExecAction.Builder], ExecAction.Builder | ExecAction],
            /,
        ) -> "LifecycleHandler.Builder": ...

        @overload
        def exec(self, value_or_callback: Never = ...) -> "ExecAction.BuilderContext": ...

        def exec(self, value_or_callback=None, /):
            """
            Exec specifies the action to take.
            """
            if self._in_context and value_or_callback is None:
                context = ExecAction.BuilderContext()
                context._parent_builder = self
                context._field_name = "exec"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(ExecAction.builder())
                if isinstance(output, ExecAction.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("exec", value)

        @overload
        def http_get(
            self, value_or_callback: Optional[HTTPGetAction], /
        ) -> "LifecycleHandler.Builder": ...

        @overload
        def http_get(
            self,
            value_or_callback: Callable[
                [HTTPGetAction.Builder], HTTPGetAction.Builder | HTTPGetAction
            ],
            /,
        ) -> "LifecycleHandler.Builder": ...

        @overload
        def http_get(self, value_or_callback: Never = ...) -> "HTTPGetAction.BuilderContext": ...

        def http_get(self, value_or_callback=None, /):
            """
            HTTPGet specifies the http request to perform.
            """
            if self._in_context and value_or_callback is None:
                context = HTTPGetAction.BuilderContext()
                context._parent_builder = self
                context._field_name = "http_get"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(HTTPGetAction.builder())
                if isinstance(output, HTTPGetAction.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("http_get", value)

        @overload
        def sleep(
            self, value_or_callback: Optional[SleepAction], /
        ) -> "LifecycleHandler.Builder": ...

        @overload
        def sleep(
            self,
            value_or_callback: Callable[[SleepAction.Builder], SleepAction.Builder | SleepAction],
            /,
        ) -> "LifecycleHandler.Builder": ...

        @overload
        def sleep(self, value_or_callback: Never = ...) -> "SleepAction.BuilderContext": ...

        def sleep(self, value_or_callback=None, /):
            """
            Sleep represents the duration that the container should sleep before being terminated.
            """
            if self._in_context and value_or_callback is None:
                context = SleepAction.BuilderContext()
                context._parent_builder = self
                context._field_name = "sleep"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(SleepAction.builder())
                if isinstance(output, SleepAction.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("sleep", value)

        @overload
        def tcp_socket(
            self, value_or_callback: Optional[TCPSocketAction], /
        ) -> "LifecycleHandler.Builder": ...

        @overload
        def tcp_socket(
            self,
            value_or_callback: Callable[
                [TCPSocketAction.Builder], TCPSocketAction.Builder | TCPSocketAction
            ],
            /,
        ) -> "LifecycleHandler.Builder": ...

        @overload
        def tcp_socket(
            self, value_or_callback: Never = ...
        ) -> "TCPSocketAction.BuilderContext": ...

        def tcp_socket(self, value_or_callback=None, /):
            """
            Deprecated. TCPSocket is NOT supported as a LifecycleHandler and kept for the backward compatibility. There are no validation of this field and lifecycle hooks will fail in runtime when tcp handler is specified.
            """
            if self._in_context and value_or_callback is None:
                context = TCPSocketAction.BuilderContext()
                context._parent_builder = self
                context._field_name = "tcp_socket"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(TCPSocketAction.builder())
                if isinstance(output, TCPSocketAction.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("tcp_socket", value)

    class BuilderContext(BuilderContextBase["LifecycleHandler.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = LifecycleHandler.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for LifecycleHandler."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["LifecycleHandler", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use LifecycleHandler.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    exec: Optional[ExecAction] = None
    """
    Exec specifies the action to take.
    """
    http_get: Annotated[Optional[HTTPGetAction], Field(alias="httpGet")] = None
    """
    HTTPGet specifies the http request to perform.
    """
    sleep: Optional[SleepAction] = None
    """
    Sleep represents the duration that the container should sleep before being terminated.
    """
    tcp_socket: Annotated[Optional[TCPSocketAction], Field(alias="tcpSocket")] = None
    """
    Deprecated. TCPSocket is NOT supported as a LifecycleHandler and kept for the backward compatibility. There are no validation of this field and lifecycle hooks will fail in runtime when tcp handler is specified.
    """


class LimitRange(Resource):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["LimitRange"]:
            return LimitRange

        def build(self) -> "LimitRange":
            return LimitRange(**self._attrs)

        def api_version(self, value: Optional[Literal["v1"]], /) -> Self:
            """
            APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
            """
            return self._set("api_version", value)

        def kind(self, value: Optional[Literal["LimitRange"]], /) -> Self:
            """
            Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
            """
            return self._set("kind", value)

        @overload
        def metadata(
            self, value_or_callback: Optional[apimachinery.ObjectMeta], /
        ) -> "LimitRange.Builder": ...

        @overload
        def metadata(
            self,
            value_or_callback: Callable[
                [apimachinery.ObjectMeta.Builder],
                apimachinery.ObjectMeta.Builder | apimachinery.ObjectMeta,
            ],
            /,
        ) -> "LimitRange.Builder": ...

        @overload
        def metadata(
            self, value_or_callback: Never = ...
        ) -> "apimachinery.ObjectMeta.BuilderContext": ...

        def metadata(self, value_or_callback=None, /):
            """
            Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
            """
            if self._in_context and value_or_callback is None:
                context = apimachinery.ObjectMeta.BuilderContext()
                context._parent_builder = self
                context._field_name = "metadata"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(apimachinery.ObjectMeta.builder())
                if isinstance(output, apimachinery.ObjectMeta.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("metadata", value)

        @overload
        def spec(self, value_or_callback: Optional[LimitRangeSpec], /) -> "LimitRange.Builder": ...

        @overload
        def spec(
            self,
            value_or_callback: Callable[
                [LimitRangeSpec.Builder], LimitRangeSpec.Builder | LimitRangeSpec
            ],
            /,
        ) -> "LimitRange.Builder": ...

        @overload
        def spec(self, value_or_callback: Never = ...) -> "LimitRangeSpec.BuilderContext": ...

        def spec(self, value_or_callback=None, /):
            """
            Spec defines the limits enforced. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
            """
            if self._in_context and value_or_callback is None:
                context = LimitRangeSpec.BuilderContext()
                context._parent_builder = self
                context._field_name = "spec"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(LimitRangeSpec.builder())
                if isinstance(output, LimitRangeSpec.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("spec", value)

    class BuilderContext(BuilderContextBase["LimitRange.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = LimitRange.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for LimitRange."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["LimitRange", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use LimitRange.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    api_version: Annotated[Optional[Literal["v1"]], Field(alias="apiVersion")] = "v1"
    """
    APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
    """
    kind: Optional[Literal["LimitRange"]] = "LimitRange"
    """
    Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
    """
    metadata: Optional[apimachinery.ObjectMeta] = None
    """
    Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
    """
    spec: Optional[LimitRangeSpec] = None
    """
    Spec defines the limits enforced. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
    """


LimitRangeList = ResourceList["LimitRange"]


class Namespace(Resource):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["Namespace"]:
            return Namespace

        def build(self) -> "Namespace":
            return Namespace(**self._attrs)

        def api_version(self, value: Optional[Literal["v1"]], /) -> Self:
            """
            APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
            """
            return self._set("api_version", value)

        def kind(self, value: Optional[Literal["Namespace"]], /) -> Self:
            """
            Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
            """
            return self._set("kind", value)

        @overload
        def metadata(
            self, value_or_callback: Optional[apimachinery.ObjectMeta], /
        ) -> "Namespace.Builder": ...

        @overload
        def metadata(
            self,
            value_or_callback: Callable[
                [apimachinery.ObjectMeta.Builder],
                apimachinery.ObjectMeta.Builder | apimachinery.ObjectMeta,
            ],
            /,
        ) -> "Namespace.Builder": ...

        @overload
        def metadata(
            self, value_or_callback: Never = ...
        ) -> "apimachinery.ObjectMeta.BuilderContext": ...

        def metadata(self, value_or_callback=None, /):
            """
            Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
            """
            if self._in_context and value_or_callback is None:
                context = apimachinery.ObjectMeta.BuilderContext()
                context._parent_builder = self
                context._field_name = "metadata"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(apimachinery.ObjectMeta.builder())
                if isinstance(output, apimachinery.ObjectMeta.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("metadata", value)

        @overload
        def spec(self, value_or_callback: Optional[NamespaceSpec], /) -> "Namespace.Builder": ...

        @overload
        def spec(
            self,
            value_or_callback: Callable[
                [NamespaceSpec.Builder], NamespaceSpec.Builder | NamespaceSpec
            ],
            /,
        ) -> "Namespace.Builder": ...

        @overload
        def spec(self, value_or_callback: Never = ...) -> "NamespaceSpec.BuilderContext": ...

        def spec(self, value_or_callback=None, /):
            """
            Spec defines the behavior of the Namespace. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
            """
            if self._in_context and value_or_callback is None:
                context = NamespaceSpec.BuilderContext()
                context._parent_builder = self
                context._field_name = "spec"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(NamespaceSpec.builder())
                if isinstance(output, NamespaceSpec.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("spec", value)

        @overload
        def status(
            self, value_or_callback: Optional[NamespaceStatus], /
        ) -> "Namespace.Builder": ...

        @overload
        def status(
            self,
            value_or_callback: Callable[
                [NamespaceStatus.Builder], NamespaceStatus.Builder | NamespaceStatus
            ],
            /,
        ) -> "Namespace.Builder": ...

        @overload
        def status(self, value_or_callback: Never = ...) -> "NamespaceStatus.BuilderContext": ...

        def status(self, value_or_callback=None, /):
            """
            Status describes the current status of a Namespace. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
            """
            if self._in_context and value_or_callback is None:
                context = NamespaceStatus.BuilderContext()
                context._parent_builder = self
                context._field_name = "status"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(NamespaceStatus.builder())
                if isinstance(output, NamespaceStatus.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("status", value)

    class BuilderContext(BuilderContextBase["Namespace.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = Namespace.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for Namespace."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["Namespace", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use Namespace.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    api_version: Annotated[Optional[Literal["v1"]], Field(alias="apiVersion")] = "v1"
    """
    APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
    """
    kind: Optional[Literal["Namespace"]] = "Namespace"
    """
    Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
    """
    metadata: Optional[apimachinery.ObjectMeta] = None
    """
    Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
    """
    spec: Optional[NamespaceSpec] = None
    """
    Spec defines the behavior of the Namespace. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
    """
    status: Optional[NamespaceStatus] = None
    """
    Status describes the current status of a Namespace. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
    """


NamespaceList = ResourceList["Namespace"]


class NodeAffinity(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["NodeAffinity"]:
            return NodeAffinity

        def build(self) -> "NodeAffinity":
            return NodeAffinity(**self._attrs)

        @overload
        def preferred_during_scheduling_ignored_during_execution(
            self, value_or_callback: List[PreferredSchedulingTerm], /
        ) -> "NodeAffinity.Builder": ...

        @overload
        def preferred_during_scheduling_ignored_during_execution(
            self,
            value_or_callback: Callable[
                [GenericListBuilder[PreferredSchedulingTerm, PreferredSchedulingTerm.Builder]],
                GenericListBuilder[PreferredSchedulingTerm, PreferredSchedulingTerm.Builder]
                | List[PreferredSchedulingTerm],
            ],
            /,
        ) -> "NodeAffinity.Builder": ...

        @overload
        def preferred_during_scheduling_ignored_during_execution(
            self, value_or_callback: Never = ...
        ) -> ListBuilderContext[PreferredSchedulingTerm.Builder]: ...

        def preferred_during_scheduling_ignored_during_execution(self, value_or_callback=None, /):
            """
            The scheduler will prefer to schedule pods to nodes that satisfy the affinity expressions specified by this field, but it may choose a node that violates one or more of the expressions. The node that is most preferred is the one with the greatest sum of weights, i.e. for each node that meets all of the scheduling requirements (resource request, requiredDuringScheduling affinity expressions, etc.), compute a sum by iterating through the elements of this field and adding "weight" to the sum if the node matches the corresponding matchExpressions; the node(s) with the highest sum are the most preferred.
            """
            if self._in_context and value_or_callback is None:
                context = ListBuilderContext[PreferredSchedulingTerm.Builder]()
                context._parent_builder = self
                context._field_name = "preferred_during_scheduling_ignored_during_execution"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(PreferredSchedulingTerm.list_builder())
                if isinstance(output, GenericListBuilder):
                    value = output.build()
                else:
                    value = output
            return self._set("preferred_during_scheduling_ignored_during_execution", value)

        @overload
        def required_during_scheduling_ignored_during_execution(
            self, value_or_callback: Optional[NodeSelector], /
        ) -> "NodeAffinity.Builder": ...

        @overload
        def required_during_scheduling_ignored_during_execution(
            self,
            value_or_callback: Callable[
                [NodeSelector.Builder], NodeSelector.Builder | NodeSelector
            ],
            /,
        ) -> "NodeAffinity.Builder": ...

        @overload
        def required_during_scheduling_ignored_during_execution(
            self, value_or_callback: Never = ...
        ) -> "NodeSelector.BuilderContext": ...

        def required_during_scheduling_ignored_during_execution(self, value_or_callback=None, /):
            """
            If the affinity requirements specified by this field are not met at scheduling time, the pod will not be scheduled onto the node. If the affinity requirements specified by this field cease to be met at some point during pod execution (e.g. due to an update), the system may or may not try to eventually evict the pod from its node.
            """
            if self._in_context and value_or_callback is None:
                context = NodeSelector.BuilderContext()
                context._parent_builder = self
                context._field_name = "required_during_scheduling_ignored_during_execution"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(NodeSelector.builder())
                if isinstance(output, NodeSelector.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("required_during_scheduling_ignored_during_execution", value)

    class BuilderContext(BuilderContextBase["NodeAffinity.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = NodeAffinity.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for NodeAffinity."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["NodeAffinity", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use NodeAffinity.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    preferred_during_scheduling_ignored_during_execution: Annotated[
        Optional[List[PreferredSchedulingTerm]],
        Field(alias="preferredDuringSchedulingIgnoredDuringExecution"),
    ] = None
    """
    The scheduler will prefer to schedule pods to nodes that satisfy the affinity expressions specified by this field, but it may choose a node that violates one or more of the expressions. The node that is most preferred is the one with the greatest sum of weights, i.e. for each node that meets all of the scheduling requirements (resource request, requiredDuringScheduling affinity expressions, etc.), compute a sum by iterating through the elements of this field and adding "weight" to the sum if the node matches the corresponding matchExpressions; the node(s) with the highest sum are the most preferred.
    """
    required_during_scheduling_ignored_during_execution: Annotated[
        Optional[NodeSelector],
        Field(alias="requiredDuringSchedulingIgnoredDuringExecution"),
    ] = None
    """
    If the affinity requirements specified by this field are not met at scheduling time, the pod will not be scheduled onto the node. If the affinity requirements specified by this field cease to be met at some point during pod execution (e.g. due to an update), the system may or may not try to eventually evict the pod from its node.
    """


class NodeSpec(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["NodeSpec"]:
            return NodeSpec

        def build(self) -> "NodeSpec":
            return NodeSpec(**self._attrs)

        @overload
        def config_source(
            self, value_or_callback: Optional[NodeConfigSource], /
        ) -> "NodeSpec.Builder": ...

        @overload
        def config_source(
            self,
            value_or_callback: Callable[
                [NodeConfigSource.Builder], NodeConfigSource.Builder | NodeConfigSource
            ],
            /,
        ) -> "NodeSpec.Builder": ...

        @overload
        def config_source(
            self, value_or_callback: Never = ...
        ) -> "NodeConfigSource.BuilderContext": ...

        def config_source(self, value_or_callback=None, /):
            """
            Deprecated: Previously used to specify the source of the node's configuration for the DynamicKubeletConfig feature. This feature is removed.
            """
            if self._in_context and value_or_callback is None:
                context = NodeConfigSource.BuilderContext()
                context._parent_builder = self
                context._field_name = "config_source"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(NodeConfigSource.builder())
                if isinstance(output, NodeConfigSource.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("config_source", value)

        def external_id(self, value: Optional[str], /) -> Self:
            """
            Deprecated. Not all kubelets will set this field. Remove field after 1.13. see: https://issues.k8s.io/61966
            """
            return self._set("external_id", value)

        def pod_cidr(self, value: Optional[str], /) -> Self:
            """
            PodCIDR represents the pod IP range assigned to the node.
            """
            return self._set("pod_cidr", value)

        def pod_cid_rs(self, value: Optional[List[str]], /) -> Self:
            """
            podCIDRs represents the IP ranges assigned to the node for usage by Pods on that node. If this field is specified, the 0th entry must match the podCIDR field. It may contain at most 1 value for each of IPv4 and IPv6.
            """
            return self._set("pod_cid_rs", value)

        def provider_id(self, value: Optional[str], /) -> Self:
            """
            ID of the node assigned by the cloud provider in the format: <ProviderName>://<ProviderSpecificNodeID>
            """
            return self._set("provider_id", value)

        @overload
        def taints(self, value_or_callback: List[Taint], /) -> "NodeSpec.Builder": ...

        @overload
        def taints(
            self,
            value_or_callback: Callable[
                [GenericListBuilder[Taint, Taint.Builder]],
                GenericListBuilder[Taint, Taint.Builder] | List[Taint],
            ],
            /,
        ) -> "NodeSpec.Builder": ...

        @overload
        def taints(self, value_or_callback: Never = ...) -> ListBuilderContext[Taint.Builder]: ...

        def taints(self, value_or_callback=None, /):
            """
            If specified, the node's taints.
            """
            if self._in_context and value_or_callback is None:
                context = ListBuilderContext[Taint.Builder]()
                context._parent_builder = self
                context._field_name = "taints"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(Taint.list_builder())
                if isinstance(output, GenericListBuilder):
                    value = output.build()
                else:
                    value = output
            return self._set("taints", value)

        def unschedulable(self, value: Optional[bool], /) -> Self:
            """
            Unschedulable controls node schedulability of new pods. By default, node is schedulable. More info: https://kubernetes.io/docs/concepts/nodes/node/#manual-node-administration
            """
            return self._set("unschedulable", value)

    class BuilderContext(BuilderContextBase["NodeSpec.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = NodeSpec.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for NodeSpec."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["NodeSpec", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use NodeSpec.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    config_source: Annotated[Optional[NodeConfigSource], Field(alias="configSource")] = None
    """
    Deprecated: Previously used to specify the source of the node's configuration for the DynamicKubeletConfig feature. This feature is removed.
    """
    external_id: Annotated[Optional[str], Field(alias="externalID")] = None
    """
    Deprecated. Not all kubelets will set this field. Remove field after 1.13. see: https://issues.k8s.io/61966
    """
    pod_cidr: Annotated[Optional[str], Field(alias="podCIDR")] = None
    """
    PodCIDR represents the pod IP range assigned to the node.
    """
    pod_cid_rs: Annotated[Optional[List[str]], Field(alias="podCIDRs")] = None
    """
    podCIDRs represents the IP ranges assigned to the node for usage by Pods on that node. If this field is specified, the 0th entry must match the podCIDR field. It may contain at most 1 value for each of IPv4 and IPv6.
    """
    provider_id: Annotated[Optional[str], Field(alias="providerID")] = None
    """
    ID of the node assigned by the cloud provider in the format: <ProviderName>://<ProviderSpecificNodeID>
    """
    taints: Optional[List[Taint]] = None
    """
    If specified, the node's taints.
    """
    unschedulable: Optional[bool] = None
    """
    Unschedulable controls node schedulability of new pods. By default, node is schedulable. More info: https://kubernetes.io/docs/concepts/nodes/node/#manual-node-administration
    """


class PersistentVolumeClaimSpec(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["PersistentVolumeClaimSpec"]:
            return PersistentVolumeClaimSpec

        def build(self) -> "PersistentVolumeClaimSpec":
            return PersistentVolumeClaimSpec(**self._attrs)

        def access_modes(self, value: Optional[List[str]], /) -> Self:
            """
            accessModes contains the desired access modes the volume should have. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#access-modes-1
            """
            return self._set("access_modes", value)

        @overload
        def data_source(
            self, value_or_callback: Optional[TypedLocalObjectReference], /
        ) -> "PersistentVolumeClaimSpec.Builder": ...

        @overload
        def data_source(
            self,
            value_or_callback: Callable[
                [TypedLocalObjectReference.Builder],
                TypedLocalObjectReference.Builder | TypedLocalObjectReference,
            ],
            /,
        ) -> "PersistentVolumeClaimSpec.Builder": ...

        @overload
        def data_source(
            self, value_or_callback: Never = ...
        ) -> "TypedLocalObjectReference.BuilderContext": ...

        def data_source(self, value_or_callback=None, /):
            """
            dataSource field can be used to specify either: * An existing VolumeSnapshot object (snapshot.storage.k8s.io/VolumeSnapshot) * An existing PVC (PersistentVolumeClaim) If the provisioner or an external controller can support the specified data source, it will create a new volume based on the contents of the specified data source. When the AnyVolumeDataSource feature gate is enabled, dataSource contents will be copied to dataSourceRef, and dataSourceRef contents will be copied to dataSource when dataSourceRef.namespace is not specified. If the namespace is specified, then dataSourceRef will not be copied to dataSource.
            """
            if self._in_context and value_or_callback is None:
                context = TypedLocalObjectReference.BuilderContext()
                context._parent_builder = self
                context._field_name = "data_source"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(TypedLocalObjectReference.builder())
                if isinstance(output, TypedLocalObjectReference.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("data_source", value)

        @overload
        def data_source_ref(
            self, value_or_callback: Optional[TypedObjectReference], /
        ) -> "PersistentVolumeClaimSpec.Builder": ...

        @overload
        def data_source_ref(
            self,
            value_or_callback: Callable[
                [TypedObjectReference.Builder],
                TypedObjectReference.Builder | TypedObjectReference,
            ],
            /,
        ) -> "PersistentVolumeClaimSpec.Builder": ...

        @overload
        def data_source_ref(
            self, value_or_callback: Never = ...
        ) -> "TypedObjectReference.BuilderContext": ...

        def data_source_ref(self, value_or_callback=None, /):
            """
            dataSourceRef specifies the object from which to populate the volume with data, if a non-empty volume is desired. This may be any object from a non-empty API group (non core object) or a PersistentVolumeClaim object. When this field is specified, volume binding will only succeed if the type of the specified object matches some installed volume populator or dynamic provisioner. This field will replace the functionality of the dataSource field and as such if both fields are non-empty, they must have the same value. For backwards compatibility, when namespace isn't specified in dataSourceRef, both fields (dataSource and dataSourceRef) will be set to the same value automatically if one of them is empty and the other is non-empty. When namespace is specified in dataSourceRef, dataSource isn't set to the same value and must be empty. There are three important differences between dataSource and dataSourceRef: * While dataSource only allows two specific types of objects, dataSourceRef
              allows any non-core object, as well as PersistentVolumeClaim objects.
            * While dataSource ignores disallowed values (dropping them), dataSourceRef
              preserves all values, and generates an error if a disallowed value is
              specified.
            * While dataSource only allows local objects, dataSourceRef allows objects
              in any namespaces.
            (Beta) Using this field requires the AnyVolumeDataSource feature gate to be enabled. (Alpha) Using the namespace field of dataSourceRef requires the CrossNamespaceVolumeDataSource feature gate to be enabled.
            """
            if self._in_context and value_or_callback is None:
                context = TypedObjectReference.BuilderContext()
                context._parent_builder = self
                context._field_name = "data_source_ref"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(TypedObjectReference.builder())
                if isinstance(output, TypedObjectReference.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("data_source_ref", value)

        @overload
        def resources(
            self, value_or_callback: Optional[VolumeResourceRequirements], /
        ) -> "PersistentVolumeClaimSpec.Builder": ...

        @overload
        def resources(
            self,
            value_or_callback: Callable[
                [VolumeResourceRequirements.Builder],
                VolumeResourceRequirements.Builder | VolumeResourceRequirements,
            ],
            /,
        ) -> "PersistentVolumeClaimSpec.Builder": ...

        @overload
        def resources(
            self, value_or_callback: Never = ...
        ) -> "VolumeResourceRequirements.BuilderContext": ...

        def resources(self, value_or_callback=None, /):
            """
            resources represents the minimum resources the volume should have. If RecoverVolumeExpansionFailure feature is enabled users are allowed to specify resource requirements that are lower than previous value but must still be higher than capacity recorded in the status field of the claim. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#resources
            """
            if self._in_context and value_or_callback is None:
                context = VolumeResourceRequirements.BuilderContext()
                context._parent_builder = self
                context._field_name = "resources"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(VolumeResourceRequirements.builder())
                if isinstance(output, VolumeResourceRequirements.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("resources", value)

        @overload
        def selector(
            self, value_or_callback: Optional[apimachinery.LabelSelector], /
        ) -> "PersistentVolumeClaimSpec.Builder": ...

        @overload
        def selector(
            self,
            value_or_callback: Callable[
                [apimachinery.LabelSelector.Builder],
                apimachinery.LabelSelector.Builder | apimachinery.LabelSelector,
            ],
            /,
        ) -> "PersistentVolumeClaimSpec.Builder": ...

        @overload
        def selector(
            self, value_or_callback: Never = ...
        ) -> "apimachinery.LabelSelector.BuilderContext": ...

        def selector(self, value_or_callback=None, /):
            """
            selector is a label query over volumes to consider for binding.
            """
            if self._in_context and value_or_callback is None:
                context = apimachinery.LabelSelector.BuilderContext()
                context._parent_builder = self
                context._field_name = "selector"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(apimachinery.LabelSelector.builder())
                if isinstance(output, apimachinery.LabelSelector.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("selector", value)

        def storage_class_name(self, value: Optional[str], /) -> Self:
            """
            storageClassName is the name of the StorageClass required by the claim. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#class-1
            """
            return self._set("storage_class_name", value)

        def volume_attributes_class_name(self, value: Optional[str], /) -> Self:
            """
            volumeAttributesClassName may be used to set the VolumeAttributesClass used by this claim. If specified, the CSI driver will create or update the volume with the attributes defined in the corresponding VolumeAttributesClass. This has a different purpose than storageClassName, it can be changed after the claim is created. An empty string value means that no VolumeAttributesClass will be applied to the claim but it's not allowed to reset this field to empty string once it is set. If unspecified and the PersistentVolumeClaim is unbound, the default VolumeAttributesClass will be set by the persistentvolume controller if it exists. If the resource referred to by volumeAttributesClass does not exist, this PersistentVolumeClaim will be set to a Pending state, as reflected by the modifyVolumeStatus field, until such as a resource exists. More info: https://kubernetes.io/docs/concepts/storage/volume-attributes-classes/ (Beta) Using this field requires the VolumeAttributesClass feature gate to be enabled (off by default).
            """
            return self._set("volume_attributes_class_name", value)

        def volume_mode(self, value: Optional[str], /) -> Self:
            """
            volumeMode defines what type of volume is required by the claim. Value of Filesystem is implied when not included in claim spec.
            """
            return self._set("volume_mode", value)

        def volume_name(self, value: Optional[str], /) -> Self:
            """
            volumeName is the binding reference to the PersistentVolume backing this claim.
            """
            return self._set("volume_name", value)

    class BuilderContext(BuilderContextBase["PersistentVolumeClaimSpec.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = PersistentVolumeClaimSpec.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for PersistentVolumeClaimSpec."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["PersistentVolumeClaimSpec", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use PersistentVolumeClaimSpec.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    access_modes: Annotated[Optional[List[str]], Field(alias="accessModes")] = None
    """
    accessModes contains the desired access modes the volume should have. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#access-modes-1
    """
    data_source: Annotated[Optional[TypedLocalObjectReference], Field(alias="dataSource")] = None
    """
    dataSource field can be used to specify either: * An existing VolumeSnapshot object (snapshot.storage.k8s.io/VolumeSnapshot) * An existing PVC (PersistentVolumeClaim) If the provisioner or an external controller can support the specified data source, it will create a new volume based on the contents of the specified data source. When the AnyVolumeDataSource feature gate is enabled, dataSource contents will be copied to dataSourceRef, and dataSourceRef contents will be copied to dataSource when dataSourceRef.namespace is not specified. If the namespace is specified, then dataSourceRef will not be copied to dataSource.
    """
    data_source_ref: Annotated[Optional[TypedObjectReference], Field(alias="dataSourceRef")] = None
    """
    dataSourceRef specifies the object from which to populate the volume with data, if a non-empty volume is desired. This may be any object from a non-empty API group (non core object) or a PersistentVolumeClaim object. When this field is specified, volume binding will only succeed if the type of the specified object matches some installed volume populator or dynamic provisioner. This field will replace the functionality of the dataSource field and as such if both fields are non-empty, they must have the same value. For backwards compatibility, when namespace isn't specified in dataSourceRef, both fields (dataSource and dataSourceRef) will be set to the same value automatically if one of them is empty and the other is non-empty. When namespace is specified in dataSourceRef, dataSource isn't set to the same value and must be empty. There are three important differences between dataSource and dataSourceRef: * While dataSource only allows two specific types of objects, dataSourceRef
      allows any non-core object, as well as PersistentVolumeClaim objects.
    * While dataSource ignores disallowed values (dropping them), dataSourceRef
      preserves all values, and generates an error if a disallowed value is
      specified.
    * While dataSource only allows local objects, dataSourceRef allows objects
      in any namespaces.
    (Beta) Using this field requires the AnyVolumeDataSource feature gate to be enabled. (Alpha) Using the namespace field of dataSourceRef requires the CrossNamespaceVolumeDataSource feature gate to be enabled.
    """
    resources: Optional[VolumeResourceRequirements] = None
    """
    resources represents the minimum resources the volume should have. If RecoverVolumeExpansionFailure feature is enabled users are allowed to specify resource requirements that are lower than previous value but must still be higher than capacity recorded in the status field of the claim. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#resources
    """
    selector: Optional[apimachinery.LabelSelector] = None
    """
    selector is a label query over volumes to consider for binding.
    """
    storage_class_name: Annotated[Optional[str], Field(alias="storageClassName")] = None
    """
    storageClassName is the name of the StorageClass required by the claim. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#class-1
    """
    volume_attributes_class_name: Annotated[
        Optional[str], Field(alias="volumeAttributesClassName")
    ] = None
    """
    volumeAttributesClassName may be used to set the VolumeAttributesClass used by this claim. If specified, the CSI driver will create or update the volume with the attributes defined in the corresponding VolumeAttributesClass. This has a different purpose than storageClassName, it can be changed after the claim is created. An empty string value means that no VolumeAttributesClass will be applied to the claim but it's not allowed to reset this field to empty string once it is set. If unspecified and the PersistentVolumeClaim is unbound, the default VolumeAttributesClass will be set by the persistentvolume controller if it exists. If the resource referred to by volumeAttributesClass does not exist, this PersistentVolumeClaim will be set to a Pending state, as reflected by the modifyVolumeStatus field, until such as a resource exists. More info: https://kubernetes.io/docs/concepts/storage/volume-attributes-classes/ (Beta) Using this field requires the VolumeAttributesClass feature gate to be enabled (off by default).
    """
    volume_mode: Annotated[Optional[str], Field(alias="volumeMode")] = None
    """
    volumeMode defines what type of volume is required by the claim. Value of Filesystem is implied when not included in claim spec.
    """
    volume_name: Annotated[Optional[str], Field(alias="volumeName")] = None
    """
    volumeName is the binding reference to the PersistentVolume backing this claim.
    """


class PersistentVolumeClaimTemplate(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["PersistentVolumeClaimTemplate"]:
            return PersistentVolumeClaimTemplate

        def build(self) -> "PersistentVolumeClaimTemplate":
            return PersistentVolumeClaimTemplate(**self._attrs)

        @overload
        def metadata(
            self, value_or_callback: Optional[apimachinery.ObjectMeta], /
        ) -> "PersistentVolumeClaimTemplate.Builder": ...

        @overload
        def metadata(
            self,
            value_or_callback: Callable[
                [apimachinery.ObjectMeta.Builder],
                apimachinery.ObjectMeta.Builder | apimachinery.ObjectMeta,
            ],
            /,
        ) -> "PersistentVolumeClaimTemplate.Builder": ...

        @overload
        def metadata(
            self, value_or_callback: Never = ...
        ) -> "apimachinery.ObjectMeta.BuilderContext": ...

        def metadata(self, value_or_callback=None, /):
            """
            May contain labels and annotations that will be copied into the PVC when creating it. No other fields are allowed and will be rejected during validation.
            """
            if self._in_context and value_or_callback is None:
                context = apimachinery.ObjectMeta.BuilderContext()
                context._parent_builder = self
                context._field_name = "metadata"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(apimachinery.ObjectMeta.builder())
                if isinstance(output, apimachinery.ObjectMeta.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("metadata", value)

        @overload
        def spec(
            self, value_or_callback: PersistentVolumeClaimSpec, /
        ) -> "PersistentVolumeClaimTemplate.Builder": ...

        @overload
        def spec(
            self,
            value_or_callback: Callable[
                [PersistentVolumeClaimSpec.Builder],
                PersistentVolumeClaimSpec.Builder | PersistentVolumeClaimSpec,
            ],
            /,
        ) -> "PersistentVolumeClaimTemplate.Builder": ...

        @overload
        def spec(
            self, value_or_callback: Never = ...
        ) -> "PersistentVolumeClaimSpec.BuilderContext": ...

        def spec(self, value_or_callback=None, /):
            """
            The specification for the PersistentVolumeClaim. The entire content is copied unchanged into the PVC that gets created from this template. The same fields as in a PersistentVolumeClaim are also valid here.
            """
            if self._in_context and value_or_callback is None:
                context = PersistentVolumeClaimSpec.BuilderContext()
                context._parent_builder = self
                context._field_name = "spec"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(PersistentVolumeClaimSpec.builder())
                if isinstance(output, PersistentVolumeClaimSpec.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("spec", value)

    class BuilderContext(BuilderContextBase["PersistentVolumeClaimTemplate.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = PersistentVolumeClaimTemplate.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for PersistentVolumeClaimTemplate."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["PersistentVolumeClaimTemplate", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use PersistentVolumeClaimTemplate.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    metadata: Optional[apimachinery.ObjectMeta] = None
    """
    May contain labels and annotations that will be copied into the PVC when creating it. No other fields are allowed and will be rejected during validation.
    """
    spec: PersistentVolumeClaimSpec
    """
    The specification for the PersistentVolumeClaim. The entire content is copied unchanged into the PVC that gets created from this template. The same fields as in a PersistentVolumeClaim are also valid here.
    """


class PersistentVolumeSpec(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["PersistentVolumeSpec"]:
            return PersistentVolumeSpec

        def build(self) -> "PersistentVolumeSpec":
            return PersistentVolumeSpec(**self._attrs)

        def access_modes(self, value: Optional[List[str]], /) -> Self:
            """
            accessModes contains all ways the volume can be mounted. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#access-modes
            """
            return self._set("access_modes", value)

        @overload
        def aws_elastic_block_store(
            self, value_or_callback: Optional[AWSElasticBlockStoreVolumeSource], /
        ) -> "PersistentVolumeSpec.Builder": ...

        @overload
        def aws_elastic_block_store(
            self,
            value_or_callback: Callable[
                [AWSElasticBlockStoreVolumeSource.Builder],
                AWSElasticBlockStoreVolumeSource.Builder | AWSElasticBlockStoreVolumeSource,
            ],
            /,
        ) -> "PersistentVolumeSpec.Builder": ...

        @overload
        def aws_elastic_block_store(
            self, value_or_callback: Never = ...
        ) -> "AWSElasticBlockStoreVolumeSource.BuilderContext": ...

        def aws_elastic_block_store(self, value_or_callback=None, /):
            """
            awsElasticBlockStore represents an AWS Disk resource that is attached to a kubelet's host machine and then exposed to the pod. More info: https://kubernetes.io/docs/concepts/storage/volumes#awselasticblockstore
            """
            if self._in_context and value_or_callback is None:
                context = AWSElasticBlockStoreVolumeSource.BuilderContext()
                context._parent_builder = self
                context._field_name = "aws_elastic_block_store"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(AWSElasticBlockStoreVolumeSource.builder())
                if isinstance(output, AWSElasticBlockStoreVolumeSource.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("aws_elastic_block_store", value)

        @overload
        def azure_disk(
            self, value_or_callback: Optional[AzureDiskVolumeSource], /
        ) -> "PersistentVolumeSpec.Builder": ...

        @overload
        def azure_disk(
            self,
            value_or_callback: Callable[
                [AzureDiskVolumeSource.Builder],
                AzureDiskVolumeSource.Builder | AzureDiskVolumeSource,
            ],
            /,
        ) -> "PersistentVolumeSpec.Builder": ...

        @overload
        def azure_disk(
            self, value_or_callback: Never = ...
        ) -> "AzureDiskVolumeSource.BuilderContext": ...

        def azure_disk(self, value_or_callback=None, /):
            """
            azureDisk represents an Azure Data Disk mount on the host and bind mount to the pod.
            """
            if self._in_context and value_or_callback is None:
                context = AzureDiskVolumeSource.BuilderContext()
                context._parent_builder = self
                context._field_name = "azure_disk"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(AzureDiskVolumeSource.builder())
                if isinstance(output, AzureDiskVolumeSource.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("azure_disk", value)

        @overload
        def azure_file(
            self, value_or_callback: Optional[AzureFilePersistentVolumeSource], /
        ) -> "PersistentVolumeSpec.Builder": ...

        @overload
        def azure_file(
            self,
            value_or_callback: Callable[
                [AzureFilePersistentVolumeSource.Builder],
                AzureFilePersistentVolumeSource.Builder | AzureFilePersistentVolumeSource,
            ],
            /,
        ) -> "PersistentVolumeSpec.Builder": ...

        @overload
        def azure_file(
            self, value_or_callback: Never = ...
        ) -> "AzureFilePersistentVolumeSource.BuilderContext": ...

        def azure_file(self, value_or_callback=None, /):
            """
            azureFile represents an Azure File Service mount on the host and bind mount to the pod.
            """
            if self._in_context and value_or_callback is None:
                context = AzureFilePersistentVolumeSource.BuilderContext()
                context._parent_builder = self
                context._field_name = "azure_file"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(AzureFilePersistentVolumeSource.builder())
                if isinstance(output, AzureFilePersistentVolumeSource.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("azure_file", value)

        def capacity(self, value: Optional[Dict[str, apimachinery.Quantity]], /) -> Self:
            """
            capacity is the description of the persistent volume's resources and capacity. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#capacity
            """
            return self._set("capacity", value)

        @overload
        def cephfs(
            self, value_or_callback: Optional[CephFSPersistentVolumeSource], /
        ) -> "PersistentVolumeSpec.Builder": ...

        @overload
        def cephfs(
            self,
            value_or_callback: Callable[
                [CephFSPersistentVolumeSource.Builder],
                CephFSPersistentVolumeSource.Builder | CephFSPersistentVolumeSource,
            ],
            /,
        ) -> "PersistentVolumeSpec.Builder": ...

        @overload
        def cephfs(
            self, value_or_callback: Never = ...
        ) -> "CephFSPersistentVolumeSource.BuilderContext": ...

        def cephfs(self, value_or_callback=None, /):
            """
            cephFS represents a Ceph FS mount on the host that shares a pod's lifetime
            """
            if self._in_context and value_or_callback is None:
                context = CephFSPersistentVolumeSource.BuilderContext()
                context._parent_builder = self
                context._field_name = "cephfs"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(CephFSPersistentVolumeSource.builder())
                if isinstance(output, CephFSPersistentVolumeSource.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("cephfs", value)

        @overload
        def cinder(
            self, value_or_callback: Optional[CinderPersistentVolumeSource], /
        ) -> "PersistentVolumeSpec.Builder": ...

        @overload
        def cinder(
            self,
            value_or_callback: Callable[
                [CinderPersistentVolumeSource.Builder],
                CinderPersistentVolumeSource.Builder | CinderPersistentVolumeSource,
            ],
            /,
        ) -> "PersistentVolumeSpec.Builder": ...

        @overload
        def cinder(
            self, value_or_callback: Never = ...
        ) -> "CinderPersistentVolumeSource.BuilderContext": ...

        def cinder(self, value_or_callback=None, /):
            """
            cinder represents a cinder volume attached and mounted on kubelets host machine. More info: https://examples.k8s.io/mysql-cinder-pd/README.md
            """
            if self._in_context and value_or_callback is None:
                context = CinderPersistentVolumeSource.BuilderContext()
                context._parent_builder = self
                context._field_name = "cinder"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(CinderPersistentVolumeSource.builder())
                if isinstance(output, CinderPersistentVolumeSource.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("cinder", value)

        @overload
        def claim_ref(
            self, value_or_callback: Optional[ObjectReference], /
        ) -> "PersistentVolumeSpec.Builder": ...

        @overload
        def claim_ref(
            self,
            value_or_callback: Callable[
                [ObjectReference.Builder], ObjectReference.Builder | ObjectReference
            ],
            /,
        ) -> "PersistentVolumeSpec.Builder": ...

        @overload
        def claim_ref(self, value_or_callback: Never = ...) -> "ObjectReference.BuilderContext": ...

        def claim_ref(self, value_or_callback=None, /):
            """
            claimRef is part of a bi-directional binding between PersistentVolume and PersistentVolumeClaim. Expected to be non-nil when bound. claim.VolumeName is the authoritative bind between PV and PVC. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#binding
            """
            if self._in_context and value_or_callback is None:
                context = ObjectReference.BuilderContext()
                context._parent_builder = self
                context._field_name = "claim_ref"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(ObjectReference.builder())
                if isinstance(output, ObjectReference.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("claim_ref", value)

        @overload
        def csi(
            self, value_or_callback: Optional[CSIPersistentVolumeSource], /
        ) -> "PersistentVolumeSpec.Builder": ...

        @overload
        def csi(
            self,
            value_or_callback: Callable[
                [CSIPersistentVolumeSource.Builder],
                CSIPersistentVolumeSource.Builder | CSIPersistentVolumeSource,
            ],
            /,
        ) -> "PersistentVolumeSpec.Builder": ...

        @overload
        def csi(
            self, value_or_callback: Never = ...
        ) -> "CSIPersistentVolumeSource.BuilderContext": ...

        def csi(self, value_or_callback=None, /):
            """
            csi represents storage that is handled by an external CSI driver (Beta feature).
            """
            if self._in_context and value_or_callback is None:
                context = CSIPersistentVolumeSource.BuilderContext()
                context._parent_builder = self
                context._field_name = "csi"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(CSIPersistentVolumeSource.builder())
                if isinstance(output, CSIPersistentVolumeSource.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("csi", value)

        @overload
        def fc(
            self, value_or_callback: Optional[FCVolumeSource], /
        ) -> "PersistentVolumeSpec.Builder": ...

        @overload
        def fc(
            self,
            value_or_callback: Callable[
                [FCVolumeSource.Builder], FCVolumeSource.Builder | FCVolumeSource
            ],
            /,
        ) -> "PersistentVolumeSpec.Builder": ...

        @overload
        def fc(self, value_or_callback: Never = ...) -> "FCVolumeSource.BuilderContext": ...

        def fc(self, value_or_callback=None, /):
            """
            fc represents a Fibre Channel resource that is attached to a kubelet's host machine and then exposed to the pod.
            """
            if self._in_context and value_or_callback is None:
                context = FCVolumeSource.BuilderContext()
                context._parent_builder = self
                context._field_name = "fc"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(FCVolumeSource.builder())
                if isinstance(output, FCVolumeSource.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("fc", value)

        @overload
        def flex_volume(
            self, value_or_callback: Optional[FlexPersistentVolumeSource], /
        ) -> "PersistentVolumeSpec.Builder": ...

        @overload
        def flex_volume(
            self,
            value_or_callback: Callable[
                [FlexPersistentVolumeSource.Builder],
                FlexPersistentVolumeSource.Builder | FlexPersistentVolumeSource,
            ],
            /,
        ) -> "PersistentVolumeSpec.Builder": ...

        @overload
        def flex_volume(
            self, value_or_callback: Never = ...
        ) -> "FlexPersistentVolumeSource.BuilderContext": ...

        def flex_volume(self, value_or_callback=None, /):
            """
            flexVolume represents a generic volume resource that is provisioned/attached using an exec based plugin.
            """
            if self._in_context and value_or_callback is None:
                context = FlexPersistentVolumeSource.BuilderContext()
                context._parent_builder = self
                context._field_name = "flex_volume"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(FlexPersistentVolumeSource.builder())
                if isinstance(output, FlexPersistentVolumeSource.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("flex_volume", value)

        @overload
        def flocker(
            self, value_or_callback: Optional[FlockerVolumeSource], /
        ) -> "PersistentVolumeSpec.Builder": ...

        @overload
        def flocker(
            self,
            value_or_callback: Callable[
                [FlockerVolumeSource.Builder],
                FlockerVolumeSource.Builder | FlockerVolumeSource,
            ],
            /,
        ) -> "PersistentVolumeSpec.Builder": ...

        @overload
        def flocker(
            self, value_or_callback: Never = ...
        ) -> "FlockerVolumeSource.BuilderContext": ...

        def flocker(self, value_or_callback=None, /):
            """
            flocker represents a Flocker volume attached to a kubelet's host machine and exposed to the pod for its usage. This depends on the Flocker control service being running
            """
            if self._in_context and value_or_callback is None:
                context = FlockerVolumeSource.BuilderContext()
                context._parent_builder = self
                context._field_name = "flocker"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(FlockerVolumeSource.builder())
                if isinstance(output, FlockerVolumeSource.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("flocker", value)

        @overload
        def gce_persistent_disk(
            self, value_or_callback: Optional[GCEPersistentDiskVolumeSource], /
        ) -> "PersistentVolumeSpec.Builder": ...

        @overload
        def gce_persistent_disk(
            self,
            value_or_callback: Callable[
                [GCEPersistentDiskVolumeSource.Builder],
                GCEPersistentDiskVolumeSource.Builder | GCEPersistentDiskVolumeSource,
            ],
            /,
        ) -> "PersistentVolumeSpec.Builder": ...

        @overload
        def gce_persistent_disk(
            self, value_or_callback: Never = ...
        ) -> "GCEPersistentDiskVolumeSource.BuilderContext": ...

        def gce_persistent_disk(self, value_or_callback=None, /):
            """
            gcePersistentDisk represents a GCE Disk resource that is attached to a kubelet's host machine and then exposed to the pod. Provisioned by an admin. More info: https://kubernetes.io/docs/concepts/storage/volumes#gcepersistentdisk
            """
            if self._in_context and value_or_callback is None:
                context = GCEPersistentDiskVolumeSource.BuilderContext()
                context._parent_builder = self
                context._field_name = "gce_persistent_disk"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(GCEPersistentDiskVolumeSource.builder())
                if isinstance(output, GCEPersistentDiskVolumeSource.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("gce_persistent_disk", value)

        @overload
        def glusterfs(
            self, value_or_callback: Optional[GlusterfsPersistentVolumeSource], /
        ) -> "PersistentVolumeSpec.Builder": ...

        @overload
        def glusterfs(
            self,
            value_or_callback: Callable[
                [GlusterfsPersistentVolumeSource.Builder],
                GlusterfsPersistentVolumeSource.Builder | GlusterfsPersistentVolumeSource,
            ],
            /,
        ) -> "PersistentVolumeSpec.Builder": ...

        @overload
        def glusterfs(
            self, value_or_callback: Never = ...
        ) -> "GlusterfsPersistentVolumeSource.BuilderContext": ...

        def glusterfs(self, value_or_callback=None, /):
            """
            glusterfs represents a Glusterfs volume that is attached to a host and exposed to the pod. Provisioned by an admin. More info: https://examples.k8s.io/volumes/glusterfs/README.md
            """
            if self._in_context and value_or_callback is None:
                context = GlusterfsPersistentVolumeSource.BuilderContext()
                context._parent_builder = self
                context._field_name = "glusterfs"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(GlusterfsPersistentVolumeSource.builder())
                if isinstance(output, GlusterfsPersistentVolumeSource.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("glusterfs", value)

        @overload
        def host_path(
            self, value_or_callback: Optional[HostPathVolumeSource], /
        ) -> "PersistentVolumeSpec.Builder": ...

        @overload
        def host_path(
            self,
            value_or_callback: Callable[
                [HostPathVolumeSource.Builder],
                HostPathVolumeSource.Builder | HostPathVolumeSource,
            ],
            /,
        ) -> "PersistentVolumeSpec.Builder": ...

        @overload
        def host_path(
            self, value_or_callback: Never = ...
        ) -> "HostPathVolumeSource.BuilderContext": ...

        def host_path(self, value_or_callback=None, /):
            """
            hostPath represents a directory on the host. Provisioned by a developer or tester. This is useful for single-node development and testing only! On-host storage is not supported in any way and WILL NOT WORK in a multi-node cluster. More info: https://kubernetes.io/docs/concepts/storage/volumes#hostpath
            """
            if self._in_context and value_or_callback is None:
                context = HostPathVolumeSource.BuilderContext()
                context._parent_builder = self
                context._field_name = "host_path"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(HostPathVolumeSource.builder())
                if isinstance(output, HostPathVolumeSource.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("host_path", value)

        @overload
        def iscsi(
            self, value_or_callback: Optional[ISCSIPersistentVolumeSource], /
        ) -> "PersistentVolumeSpec.Builder": ...

        @overload
        def iscsi(
            self,
            value_or_callback: Callable[
                [ISCSIPersistentVolumeSource.Builder],
                ISCSIPersistentVolumeSource.Builder | ISCSIPersistentVolumeSource,
            ],
            /,
        ) -> "PersistentVolumeSpec.Builder": ...

        @overload
        def iscsi(
            self, value_or_callback: Never = ...
        ) -> "ISCSIPersistentVolumeSource.BuilderContext": ...

        def iscsi(self, value_or_callback=None, /):
            """
            iscsi represents an ISCSI Disk resource that is attached to a kubelet's host machine and then exposed to the pod. Provisioned by an admin.
            """
            if self._in_context and value_or_callback is None:
                context = ISCSIPersistentVolumeSource.BuilderContext()
                context._parent_builder = self
                context._field_name = "iscsi"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(ISCSIPersistentVolumeSource.builder())
                if isinstance(output, ISCSIPersistentVolumeSource.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("iscsi", value)

        @overload
        def local(
            self, value_or_callback: Optional[LocalVolumeSource], /
        ) -> "PersistentVolumeSpec.Builder": ...

        @overload
        def local(
            self,
            value_or_callback: Callable[
                [LocalVolumeSource.Builder],
                LocalVolumeSource.Builder | LocalVolumeSource,
            ],
            /,
        ) -> "PersistentVolumeSpec.Builder": ...

        @overload
        def local(self, value_or_callback: Never = ...) -> "LocalVolumeSource.BuilderContext": ...

        def local(self, value_or_callback=None, /):
            """
            local represents directly-attached storage with node affinity
            """
            if self._in_context and value_or_callback is None:
                context = LocalVolumeSource.BuilderContext()
                context._parent_builder = self
                context._field_name = "local"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(LocalVolumeSource.builder())
                if isinstance(output, LocalVolumeSource.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("local", value)

        def mount_options(self, value: Optional[List[str]], /) -> Self:
            """
            mountOptions is the list of mount options, e.g. ["ro", "soft"]. Not validated - mount will simply fail if one is invalid. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes/#mount-options
            """
            return self._set("mount_options", value)

        @overload
        def nfs(
            self, value_or_callback: Optional[NFSVolumeSource], /
        ) -> "PersistentVolumeSpec.Builder": ...

        @overload
        def nfs(
            self,
            value_or_callback: Callable[
                [NFSVolumeSource.Builder], NFSVolumeSource.Builder | NFSVolumeSource
            ],
            /,
        ) -> "PersistentVolumeSpec.Builder": ...

        @overload
        def nfs(self, value_or_callback: Never = ...) -> "NFSVolumeSource.BuilderContext": ...

        def nfs(self, value_or_callback=None, /):
            """
            nfs represents an NFS mount on the host. Provisioned by an admin. More info: https://kubernetes.io/docs/concepts/storage/volumes#nfs
            """
            if self._in_context and value_or_callback is None:
                context = NFSVolumeSource.BuilderContext()
                context._parent_builder = self
                context._field_name = "nfs"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(NFSVolumeSource.builder())
                if isinstance(output, NFSVolumeSource.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("nfs", value)

        @overload
        def node_affinity(
            self, value_or_callback: Optional[VolumeNodeAffinity], /
        ) -> "PersistentVolumeSpec.Builder": ...

        @overload
        def node_affinity(
            self,
            value_or_callback: Callable[
                [VolumeNodeAffinity.Builder],
                VolumeNodeAffinity.Builder | VolumeNodeAffinity,
            ],
            /,
        ) -> "PersistentVolumeSpec.Builder": ...

        @overload
        def node_affinity(
            self, value_or_callback: Never = ...
        ) -> "VolumeNodeAffinity.BuilderContext": ...

        def node_affinity(self, value_or_callback=None, /):
            """
            nodeAffinity defines constraints that limit what nodes this volume can be accessed from. This field influences the scheduling of pods that use this volume.
            """
            if self._in_context and value_or_callback is None:
                context = VolumeNodeAffinity.BuilderContext()
                context._parent_builder = self
                context._field_name = "node_affinity"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(VolumeNodeAffinity.builder())
                if isinstance(output, VolumeNodeAffinity.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("node_affinity", value)

        def persistent_volume_reclaim_policy(self, value: Optional[str], /) -> Self:
            """
            persistentVolumeReclaimPolicy defines what happens to a persistent volume when released from its claim. Valid options are Retain (default for manually created PersistentVolumes), Delete (default for dynamically provisioned PersistentVolumes), and Recycle (deprecated). Recycle must be supported by the volume plugin underlying this PersistentVolume. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#reclaiming
            """
            return self._set("persistent_volume_reclaim_policy", value)

        @overload
        def photon_persistent_disk(
            self, value_or_callback: Optional[PhotonPersistentDiskVolumeSource], /
        ) -> "PersistentVolumeSpec.Builder": ...

        @overload
        def photon_persistent_disk(
            self,
            value_or_callback: Callable[
                [PhotonPersistentDiskVolumeSource.Builder],
                PhotonPersistentDiskVolumeSource.Builder | PhotonPersistentDiskVolumeSource,
            ],
            /,
        ) -> "PersistentVolumeSpec.Builder": ...

        @overload
        def photon_persistent_disk(
            self, value_or_callback: Never = ...
        ) -> "PhotonPersistentDiskVolumeSource.BuilderContext": ...

        def photon_persistent_disk(self, value_or_callback=None, /):
            """
            photonPersistentDisk represents a PhotonController persistent disk attached and mounted on kubelets host machine
            """
            if self._in_context and value_or_callback is None:
                context = PhotonPersistentDiskVolumeSource.BuilderContext()
                context._parent_builder = self
                context._field_name = "photon_persistent_disk"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(PhotonPersistentDiskVolumeSource.builder())
                if isinstance(output, PhotonPersistentDiskVolumeSource.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("photon_persistent_disk", value)

        @overload
        def portworx_volume(
            self, value_or_callback: Optional[PortworxVolumeSource], /
        ) -> "PersistentVolumeSpec.Builder": ...

        @overload
        def portworx_volume(
            self,
            value_or_callback: Callable[
                [PortworxVolumeSource.Builder],
                PortworxVolumeSource.Builder | PortworxVolumeSource,
            ],
            /,
        ) -> "PersistentVolumeSpec.Builder": ...

        @overload
        def portworx_volume(
            self, value_or_callback: Never = ...
        ) -> "PortworxVolumeSource.BuilderContext": ...

        def portworx_volume(self, value_or_callback=None, /):
            """
            portworxVolume represents a portworx volume attached and mounted on kubelets host machine
            """
            if self._in_context and value_or_callback is None:
                context = PortworxVolumeSource.BuilderContext()
                context._parent_builder = self
                context._field_name = "portworx_volume"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(PortworxVolumeSource.builder())
                if isinstance(output, PortworxVolumeSource.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("portworx_volume", value)

        @overload
        def quobyte(
            self, value_or_callback: Optional[QuobyteVolumeSource], /
        ) -> "PersistentVolumeSpec.Builder": ...

        @overload
        def quobyte(
            self,
            value_or_callback: Callable[
                [QuobyteVolumeSource.Builder],
                QuobyteVolumeSource.Builder | QuobyteVolumeSource,
            ],
            /,
        ) -> "PersistentVolumeSpec.Builder": ...

        @overload
        def quobyte(
            self, value_or_callback: Never = ...
        ) -> "QuobyteVolumeSource.BuilderContext": ...

        def quobyte(self, value_or_callback=None, /):
            """
            quobyte represents a Quobyte mount on the host that shares a pod's lifetime
            """
            if self._in_context and value_or_callback is None:
                context = QuobyteVolumeSource.BuilderContext()
                context._parent_builder = self
                context._field_name = "quobyte"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(QuobyteVolumeSource.builder())
                if isinstance(output, QuobyteVolumeSource.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("quobyte", value)

        @overload
        def rbd(
            self, value_or_callback: Optional[RBDPersistentVolumeSource], /
        ) -> "PersistentVolumeSpec.Builder": ...

        @overload
        def rbd(
            self,
            value_or_callback: Callable[
                [RBDPersistentVolumeSource.Builder],
                RBDPersistentVolumeSource.Builder | RBDPersistentVolumeSource,
            ],
            /,
        ) -> "PersistentVolumeSpec.Builder": ...

        @overload
        def rbd(
            self, value_or_callback: Never = ...
        ) -> "RBDPersistentVolumeSource.BuilderContext": ...

        def rbd(self, value_or_callback=None, /):
            """
            rbd represents a Rados Block Device mount on the host that shares a pod's lifetime. More info: https://examples.k8s.io/volumes/rbd/README.md
            """
            if self._in_context and value_or_callback is None:
                context = RBDPersistentVolumeSource.BuilderContext()
                context._parent_builder = self
                context._field_name = "rbd"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(RBDPersistentVolumeSource.builder())
                if isinstance(output, RBDPersistentVolumeSource.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("rbd", value)

        @overload
        def scale_io(
            self, value_or_callback: Optional[ScaleIOPersistentVolumeSource], /
        ) -> "PersistentVolumeSpec.Builder": ...

        @overload
        def scale_io(
            self,
            value_or_callback: Callable[
                [ScaleIOPersistentVolumeSource.Builder],
                ScaleIOPersistentVolumeSource.Builder | ScaleIOPersistentVolumeSource,
            ],
            /,
        ) -> "PersistentVolumeSpec.Builder": ...

        @overload
        def scale_io(
            self, value_or_callback: Never = ...
        ) -> "ScaleIOPersistentVolumeSource.BuilderContext": ...

        def scale_io(self, value_or_callback=None, /):
            """
            scaleIO represents a ScaleIO persistent volume attached and mounted on Kubernetes nodes.
            """
            if self._in_context and value_or_callback is None:
                context = ScaleIOPersistentVolumeSource.BuilderContext()
                context._parent_builder = self
                context._field_name = "scale_io"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(ScaleIOPersistentVolumeSource.builder())
                if isinstance(output, ScaleIOPersistentVolumeSource.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("scale_io", value)

        def storage_class_name(self, value: Optional[str], /) -> Self:
            """
            storageClassName is the name of StorageClass to which this persistent volume belongs. Empty value means that this volume does not belong to any StorageClass.
            """
            return self._set("storage_class_name", value)

        @overload
        def storageos(
            self, value_or_callback: Optional[StorageOSPersistentVolumeSource], /
        ) -> "PersistentVolumeSpec.Builder": ...

        @overload
        def storageos(
            self,
            value_or_callback: Callable[
                [StorageOSPersistentVolumeSource.Builder],
                StorageOSPersistentVolumeSource.Builder | StorageOSPersistentVolumeSource,
            ],
            /,
        ) -> "PersistentVolumeSpec.Builder": ...

        @overload
        def storageos(
            self, value_or_callback: Never = ...
        ) -> "StorageOSPersistentVolumeSource.BuilderContext": ...

        def storageos(self, value_or_callback=None, /):
            """
            storageOS represents a StorageOS volume that is attached to the kubelet's host machine and mounted into the pod More info: https://examples.k8s.io/volumes/storageos/README.md
            """
            if self._in_context and value_or_callback is None:
                context = StorageOSPersistentVolumeSource.BuilderContext()
                context._parent_builder = self
                context._field_name = "storageos"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(StorageOSPersistentVolumeSource.builder())
                if isinstance(output, StorageOSPersistentVolumeSource.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("storageos", value)

        def volume_attributes_class_name(self, value: Optional[str], /) -> Self:
            """
            Name of VolumeAttributesClass to which this persistent volume belongs. Empty value is not allowed. When this field is not set, it indicates that this volume does not belong to any VolumeAttributesClass. This field is mutable and can be changed by the CSI driver after a volume has been updated successfully to a new class. For an unbound PersistentVolume, the volumeAttributesClassName will be matched with unbound PersistentVolumeClaims during the binding process. This is a beta field and requires enabling VolumeAttributesClass feature (off by default).
            """
            return self._set("volume_attributes_class_name", value)

        def volume_mode(self, value: Optional[str], /) -> Self:
            """
            volumeMode defines if a volume is intended to be used with a formatted filesystem or to remain in raw block state. Value of Filesystem is implied when not included in spec.
            """
            return self._set("volume_mode", value)

        @overload
        def vsphere_volume(
            self, value_or_callback: Optional[VsphereVirtualDiskVolumeSource], /
        ) -> "PersistentVolumeSpec.Builder": ...

        @overload
        def vsphere_volume(
            self,
            value_or_callback: Callable[
                [VsphereVirtualDiskVolumeSource.Builder],
                VsphereVirtualDiskVolumeSource.Builder | VsphereVirtualDiskVolumeSource,
            ],
            /,
        ) -> "PersistentVolumeSpec.Builder": ...

        @overload
        def vsphere_volume(
            self, value_or_callback: Never = ...
        ) -> "VsphereVirtualDiskVolumeSource.BuilderContext": ...

        def vsphere_volume(self, value_or_callback=None, /):
            """
            vsphereVolume represents a vSphere volume attached and mounted on kubelets host machine
            """
            if self._in_context and value_or_callback is None:
                context = VsphereVirtualDiskVolumeSource.BuilderContext()
                context._parent_builder = self
                context._field_name = "vsphere_volume"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(VsphereVirtualDiskVolumeSource.builder())
                if isinstance(output, VsphereVirtualDiskVolumeSource.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("vsphere_volume", value)

    class BuilderContext(BuilderContextBase["PersistentVolumeSpec.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = PersistentVolumeSpec.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for PersistentVolumeSpec."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["PersistentVolumeSpec", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use PersistentVolumeSpec.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    access_modes: Annotated[Optional[List[str]], Field(alias="accessModes")] = None
    """
    accessModes contains all ways the volume can be mounted. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#access-modes
    """
    aws_elastic_block_store: Annotated[
        Optional[AWSElasticBlockStoreVolumeSource], Field(alias="awsElasticBlockStore")
    ] = None
    """
    awsElasticBlockStore represents an AWS Disk resource that is attached to a kubelet's host machine and then exposed to the pod. More info: https://kubernetes.io/docs/concepts/storage/volumes#awselasticblockstore
    """
    azure_disk: Annotated[Optional[AzureDiskVolumeSource], Field(alias="azureDisk")] = None
    """
    azureDisk represents an Azure Data Disk mount on the host and bind mount to the pod.
    """
    azure_file: Annotated[Optional[AzureFilePersistentVolumeSource], Field(alias="azureFile")] = (
        None
    )
    """
    azureFile represents an Azure File Service mount on the host and bind mount to the pod.
    """
    capacity: Optional[Dict[str, apimachinery.Quantity]] = None
    """
    capacity is the description of the persistent volume's resources and capacity. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#capacity
    """
    cephfs: Optional[CephFSPersistentVolumeSource] = None
    """
    cephFS represents a Ceph FS mount on the host that shares a pod's lifetime
    """
    cinder: Optional[CinderPersistentVolumeSource] = None
    """
    cinder represents a cinder volume attached and mounted on kubelets host machine. More info: https://examples.k8s.io/mysql-cinder-pd/README.md
    """
    claim_ref: Annotated[Optional[ObjectReference], Field(alias="claimRef")] = None
    """
    claimRef is part of a bi-directional binding between PersistentVolume and PersistentVolumeClaim. Expected to be non-nil when bound. claim.VolumeName is the authoritative bind between PV and PVC. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#binding
    """
    csi: Optional[CSIPersistentVolumeSource] = None
    """
    csi represents storage that is handled by an external CSI driver (Beta feature).
    """
    fc: Optional[FCVolumeSource] = None
    """
    fc represents a Fibre Channel resource that is attached to a kubelet's host machine and then exposed to the pod.
    """
    flex_volume: Annotated[Optional[FlexPersistentVolumeSource], Field(alias="flexVolume")] = None
    """
    flexVolume represents a generic volume resource that is provisioned/attached using an exec based plugin.
    """
    flocker: Optional[FlockerVolumeSource] = None
    """
    flocker represents a Flocker volume attached to a kubelet's host machine and exposed to the pod for its usage. This depends on the Flocker control service being running
    """
    gce_persistent_disk: Annotated[
        Optional[GCEPersistentDiskVolumeSource], Field(alias="gcePersistentDisk")
    ] = None
    """
    gcePersistentDisk represents a GCE Disk resource that is attached to a kubelet's host machine and then exposed to the pod. Provisioned by an admin. More info: https://kubernetes.io/docs/concepts/storage/volumes#gcepersistentdisk
    """
    glusterfs: Optional[GlusterfsPersistentVolumeSource] = None
    """
    glusterfs represents a Glusterfs volume that is attached to a host and exposed to the pod. Provisioned by an admin. More info: https://examples.k8s.io/volumes/glusterfs/README.md
    """
    host_path: Annotated[Optional[HostPathVolumeSource], Field(alias="hostPath")] = None
    """
    hostPath represents a directory on the host. Provisioned by a developer or tester. This is useful for single-node development and testing only! On-host storage is not supported in any way and WILL NOT WORK in a multi-node cluster. More info: https://kubernetes.io/docs/concepts/storage/volumes#hostpath
    """
    iscsi: Optional[ISCSIPersistentVolumeSource] = None
    """
    iscsi represents an ISCSI Disk resource that is attached to a kubelet's host machine and then exposed to the pod. Provisioned by an admin.
    """
    local: Optional[LocalVolumeSource] = None
    """
    local represents directly-attached storage with node affinity
    """
    mount_options: Annotated[Optional[List[str]], Field(alias="mountOptions")] = None
    """
    mountOptions is the list of mount options, e.g. ["ro", "soft"]. Not validated - mount will simply fail if one is invalid. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes/#mount-options
    """
    nfs: Optional[NFSVolumeSource] = None
    """
    nfs represents an NFS mount on the host. Provisioned by an admin. More info: https://kubernetes.io/docs/concepts/storage/volumes#nfs
    """
    node_affinity: Annotated[Optional[VolumeNodeAffinity], Field(alias="nodeAffinity")] = None
    """
    nodeAffinity defines constraints that limit what nodes this volume can be accessed from. This field influences the scheduling of pods that use this volume.
    """
    persistent_volume_reclaim_policy: Annotated[
        Optional[str], Field(alias="persistentVolumeReclaimPolicy")
    ] = None
    """
    persistentVolumeReclaimPolicy defines what happens to a persistent volume when released from its claim. Valid options are Retain (default for manually created PersistentVolumes), Delete (default for dynamically provisioned PersistentVolumes), and Recycle (deprecated). Recycle must be supported by the volume plugin underlying this PersistentVolume. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#reclaiming
    """
    photon_persistent_disk: Annotated[
        Optional[PhotonPersistentDiskVolumeSource], Field(alias="photonPersistentDisk")
    ] = None
    """
    photonPersistentDisk represents a PhotonController persistent disk attached and mounted on kubelets host machine
    """
    portworx_volume: Annotated[Optional[PortworxVolumeSource], Field(alias="portworxVolume")] = None
    """
    portworxVolume represents a portworx volume attached and mounted on kubelets host machine
    """
    quobyte: Optional[QuobyteVolumeSource] = None
    """
    quobyte represents a Quobyte mount on the host that shares a pod's lifetime
    """
    rbd: Optional[RBDPersistentVolumeSource] = None
    """
    rbd represents a Rados Block Device mount on the host that shares a pod's lifetime. More info: https://examples.k8s.io/volumes/rbd/README.md
    """
    scale_io: Annotated[Optional[ScaleIOPersistentVolumeSource], Field(alias="scaleIO")] = None
    """
    scaleIO represents a ScaleIO persistent volume attached and mounted on Kubernetes nodes.
    """
    storage_class_name: Annotated[Optional[str], Field(alias="storageClassName")] = None
    """
    storageClassName is the name of StorageClass to which this persistent volume belongs. Empty value means that this volume does not belong to any StorageClass.
    """
    storageos: Optional[StorageOSPersistentVolumeSource] = None
    """
    storageOS represents a StorageOS volume that is attached to the kubelet's host machine and mounted into the pod More info: https://examples.k8s.io/volumes/storageos/README.md
    """
    volume_attributes_class_name: Annotated[
        Optional[str], Field(alias="volumeAttributesClassName")
    ] = None
    """
    Name of VolumeAttributesClass to which this persistent volume belongs. Empty value is not allowed. When this field is not set, it indicates that this volume does not belong to any VolumeAttributesClass. This field is mutable and can be changed by the CSI driver after a volume has been updated successfully to a new class. For an unbound PersistentVolume, the volumeAttributesClassName will be matched with unbound PersistentVolumeClaims during the binding process. This is a beta field and requires enabling VolumeAttributesClass feature (off by default).
    """
    volume_mode: Annotated[Optional[str], Field(alias="volumeMode")] = None
    """
    volumeMode defines if a volume is intended to be used with a formatted filesystem or to remain in raw block state. Value of Filesystem is implied when not included in spec.
    """
    vsphere_volume: Annotated[
        Optional[VsphereVirtualDiskVolumeSource], Field(alias="vsphereVolume")
    ] = None
    """
    vsphereVolume represents a vSphere volume attached and mounted on kubelets host machine
    """


class PodAffinityTerm(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["PodAffinityTerm"]:
            return PodAffinityTerm

        def build(self) -> "PodAffinityTerm":
            return PodAffinityTerm(**self._attrs)

        @overload
        def label_selector(
            self, value_or_callback: Optional[apimachinery.LabelSelector], /
        ) -> "PodAffinityTerm.Builder": ...

        @overload
        def label_selector(
            self,
            value_or_callback: Callable[
                [apimachinery.LabelSelector.Builder],
                apimachinery.LabelSelector.Builder | apimachinery.LabelSelector,
            ],
            /,
        ) -> "PodAffinityTerm.Builder": ...

        @overload
        def label_selector(
            self, value_or_callback: Never = ...
        ) -> "apimachinery.LabelSelector.BuilderContext": ...

        def label_selector(self, value_or_callback=None, /):
            """
            A label query over a set of resources, in this case pods. If it's null, this PodAffinityTerm matches with no Pods.
            """
            if self._in_context and value_or_callback is None:
                context = apimachinery.LabelSelector.BuilderContext()
                context._parent_builder = self
                context._field_name = "label_selector"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(apimachinery.LabelSelector.builder())
                if isinstance(output, apimachinery.LabelSelector.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("label_selector", value)

        def match_label_keys(self, value: Optional[List[str]], /) -> Self:
            """
            MatchLabelKeys is a set of pod label keys to select which pods will be taken into consideration. The keys are used to lookup values from the incoming pod labels, those key-value labels are merged with `labelSelector` as `key in (value)` to select the group of existing pods which pods will be taken into consideration for the incoming pod's pod (anti) affinity. Keys that don't exist in the incoming pod labels will be ignored. The default value is empty. The same key is forbidden to exist in both matchLabelKeys and labelSelector. Also, matchLabelKeys cannot be set when labelSelector isn't set. This is a beta field and requires enabling MatchLabelKeysInPodAffinity feature gate (enabled by default).
            """
            return self._set("match_label_keys", value)

        def mismatch_label_keys(self, value: Optional[List[str]], /) -> Self:
            """
            MismatchLabelKeys is a set of pod label keys to select which pods will be taken into consideration. The keys are used to lookup values from the incoming pod labels, those key-value labels are merged with `labelSelector` as `key notin (value)` to select the group of existing pods which pods will be taken into consideration for the incoming pod's pod (anti) affinity. Keys that don't exist in the incoming pod labels will be ignored. The default value is empty. The same key is forbidden to exist in both mismatchLabelKeys and labelSelector. Also, mismatchLabelKeys cannot be set when labelSelector isn't set. This is a beta field and requires enabling MatchLabelKeysInPodAffinity feature gate (enabled by default).
            """
            return self._set("mismatch_label_keys", value)

        @overload
        def namespace_selector(
            self, value_or_callback: Optional[apimachinery.LabelSelector], /
        ) -> "PodAffinityTerm.Builder": ...

        @overload
        def namespace_selector(
            self,
            value_or_callback: Callable[
                [apimachinery.LabelSelector.Builder],
                apimachinery.LabelSelector.Builder | apimachinery.LabelSelector,
            ],
            /,
        ) -> "PodAffinityTerm.Builder": ...

        @overload
        def namespace_selector(
            self, value_or_callback: Never = ...
        ) -> "apimachinery.LabelSelector.BuilderContext": ...

        def namespace_selector(self, value_or_callback=None, /):
            """
            A label query over the set of namespaces that the term applies to. The term is applied to the union of the namespaces selected by this field and the ones listed in the namespaces field. null selector and null or empty namespaces list means "this pod's namespace". An empty selector ({}) matches all namespaces.
            """
            if self._in_context and value_or_callback is None:
                context = apimachinery.LabelSelector.BuilderContext()
                context._parent_builder = self
                context._field_name = "namespace_selector"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(apimachinery.LabelSelector.builder())
                if isinstance(output, apimachinery.LabelSelector.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("namespace_selector", value)

        def namespaces(self, value: Optional[List[str]], /) -> Self:
            """
            namespaces specifies a static list of namespace names that the term applies to. The term is applied to the union of the namespaces listed in this field and the ones selected by namespaceSelector. null or empty namespaces list and null namespaceSelector means "this pod's namespace".
            """
            return self._set("namespaces", value)

        def topology_key(self, value: str, /) -> Self:
            """
            This pod should be co-located (affinity) or not co-located (anti-affinity) with the pods matching the labelSelector in the specified namespaces, where co-located is defined as running on a node whose value of the label with key topologyKey matches that of any node on which any of the selected pods is running. Empty topologyKey is not allowed.
            """
            return self._set("topology_key", value)

    class BuilderContext(BuilderContextBase["PodAffinityTerm.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = PodAffinityTerm.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for PodAffinityTerm."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["PodAffinityTerm", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use PodAffinityTerm.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    label_selector: Annotated[
        Optional[apimachinery.LabelSelector], Field(alias="labelSelector")
    ] = None
    """
    A label query over a set of resources, in this case pods. If it's null, this PodAffinityTerm matches with no Pods.
    """
    match_label_keys: Annotated[Optional[List[str]], Field(alias="matchLabelKeys")] = None
    """
    MatchLabelKeys is a set of pod label keys to select which pods will be taken into consideration. The keys are used to lookup values from the incoming pod labels, those key-value labels are merged with `labelSelector` as `key in (value)` to select the group of existing pods which pods will be taken into consideration for the incoming pod's pod (anti) affinity. Keys that don't exist in the incoming pod labels will be ignored. The default value is empty. The same key is forbidden to exist in both matchLabelKeys and labelSelector. Also, matchLabelKeys cannot be set when labelSelector isn't set. This is a beta field and requires enabling MatchLabelKeysInPodAffinity feature gate (enabled by default).
    """
    mismatch_label_keys: Annotated[Optional[List[str]], Field(alias="mismatchLabelKeys")] = None
    """
    MismatchLabelKeys is a set of pod label keys to select which pods will be taken into consideration. The keys are used to lookup values from the incoming pod labels, those key-value labels are merged with `labelSelector` as `key notin (value)` to select the group of existing pods which pods will be taken into consideration for the incoming pod's pod (anti) affinity. Keys that don't exist in the incoming pod labels will be ignored. The default value is empty. The same key is forbidden to exist in both mismatchLabelKeys and labelSelector. Also, mismatchLabelKeys cannot be set when labelSelector isn't set. This is a beta field and requires enabling MatchLabelKeysInPodAffinity feature gate (enabled by default).
    """
    namespace_selector: Annotated[
        Optional[apimachinery.LabelSelector], Field(alias="namespaceSelector")
    ] = None
    """
    A label query over the set of namespaces that the term applies to. The term is applied to the union of the namespaces selected by this field and the ones listed in the namespaces field. null selector and null or empty namespaces list means "this pod's namespace". An empty selector ({}) matches all namespaces.
    """
    namespaces: Optional[List[str]] = None
    """
    namespaces specifies a static list of namespace names that the term applies to. The term is applied to the union of the namespaces listed in this field and the ones selected by namespaceSelector. null or empty namespaces list and null namespaceSelector means "this pod's namespace".
    """
    topology_key: Annotated[str, Field(alias="topologyKey")]
    """
    This pod should be co-located (affinity) or not co-located (anti-affinity) with the pods matching the labelSelector in the specified namespaces, where co-located is defined as running on a node whose value of the label with key topologyKey matches that of any node on which any of the selected pods is running. Empty topologyKey is not allowed.
    """


class PodStatus(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["PodStatus"]:
            return PodStatus

        def build(self) -> "PodStatus":
            return PodStatus(**self._attrs)

        @overload
        def conditions(self, value_or_callback: List[PodCondition], /) -> "PodStatus.Builder": ...

        @overload
        def conditions(
            self,
            value_or_callback: Callable[
                [GenericListBuilder[PodCondition, PodCondition.Builder]],
                GenericListBuilder[PodCondition, PodCondition.Builder] | List[PodCondition],
            ],
            /,
        ) -> "PodStatus.Builder": ...

        @overload
        def conditions(
            self, value_or_callback: Never = ...
        ) -> ListBuilderContext[PodCondition.Builder]: ...

        def conditions(self, value_or_callback=None, /):
            """
            Current service state of pod. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#pod-conditions
            """
            if self._in_context and value_or_callback is None:
                context = ListBuilderContext[PodCondition.Builder]()
                context._parent_builder = self
                context._field_name = "conditions"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(PodCondition.list_builder())
                if isinstance(output, GenericListBuilder):
                    value = output.build()
                else:
                    value = output
            return self._set("conditions", value)

        @overload
        def container_statuses(
            self, value_or_callback: List[ContainerStatus], /
        ) -> "PodStatus.Builder": ...

        @overload
        def container_statuses(
            self,
            value_or_callback: Callable[
                [GenericListBuilder[ContainerStatus, ContainerStatus.Builder]],
                GenericListBuilder[ContainerStatus, ContainerStatus.Builder]
                | List[ContainerStatus],
            ],
            /,
        ) -> "PodStatus.Builder": ...

        @overload
        def container_statuses(
            self, value_or_callback: Never = ...
        ) -> ListBuilderContext[ContainerStatus.Builder]: ...

        def container_statuses(self, value_or_callback=None, /):
            """
            The list has one entry per container in the manifest. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#pod-and-container-status
            """
            if self._in_context and value_or_callback is None:
                context = ListBuilderContext[ContainerStatus.Builder]()
                context._parent_builder = self
                context._field_name = "container_statuses"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(ContainerStatus.list_builder())
                if isinstance(output, GenericListBuilder):
                    value = output.build()
                else:
                    value = output
            return self._set("container_statuses", value)

        @overload
        def ephemeral_container_statuses(
            self, value_or_callback: List[ContainerStatus], /
        ) -> "PodStatus.Builder": ...

        @overload
        def ephemeral_container_statuses(
            self,
            value_or_callback: Callable[
                [GenericListBuilder[ContainerStatus, ContainerStatus.Builder]],
                GenericListBuilder[ContainerStatus, ContainerStatus.Builder]
                | List[ContainerStatus],
            ],
            /,
        ) -> "PodStatus.Builder": ...

        @overload
        def ephemeral_container_statuses(
            self, value_or_callback: Never = ...
        ) -> ListBuilderContext[ContainerStatus.Builder]: ...

        def ephemeral_container_statuses(self, value_or_callback=None, /):
            """
            Status for any ephemeral containers that have run in this pod.
            """
            if self._in_context and value_or_callback is None:
                context = ListBuilderContext[ContainerStatus.Builder]()
                context._parent_builder = self
                context._field_name = "ephemeral_container_statuses"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(ContainerStatus.list_builder())
                if isinstance(output, GenericListBuilder):
                    value = output.build()
                else:
                    value = output
            return self._set("ephemeral_container_statuses", value)

        def host_ip(self, value: Optional[str], /) -> Self:
            """
            hostIP holds the IP address of the host to which the pod is assigned. Empty if the pod has not started yet. A pod can be assigned to a node that has a problem in kubelet which in turns mean that HostIP will not be updated even if there is a node is assigned to pod
            """
            return self._set("host_ip", value)

        @overload
        def host_i_ps(self, value_or_callback: List[HostIP], /) -> "PodStatus.Builder": ...

        @overload
        def host_i_ps(
            self,
            value_or_callback: Callable[
                [GenericListBuilder[HostIP, HostIP.Builder]],
                GenericListBuilder[HostIP, HostIP.Builder] | List[HostIP],
            ],
            /,
        ) -> "PodStatus.Builder": ...

        @overload
        def host_i_ps(
            self, value_or_callback: Never = ...
        ) -> ListBuilderContext[HostIP.Builder]: ...

        def host_i_ps(self, value_or_callback=None, /):
            """
            hostIPs holds the IP addresses allocated to the host. If this field is specified, the first entry must match the hostIP field. This list is empty if the pod has not started yet. A pod can be assigned to a node that has a problem in kubelet which in turns means that HostIPs will not be updated even if there is a node is assigned to this pod.
            """
            if self._in_context and value_or_callback is None:
                context = ListBuilderContext[HostIP.Builder]()
                context._parent_builder = self
                context._field_name = "host_i_ps"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(HostIP.list_builder())
                if isinstance(output, GenericListBuilder):
                    value = output.build()
                else:
                    value = output
            return self._set("host_i_ps", value)

        @overload
        def init_container_statuses(
            self, value_or_callback: List[ContainerStatus], /
        ) -> "PodStatus.Builder": ...

        @overload
        def init_container_statuses(
            self,
            value_or_callback: Callable[
                [GenericListBuilder[ContainerStatus, ContainerStatus.Builder]],
                GenericListBuilder[ContainerStatus, ContainerStatus.Builder]
                | List[ContainerStatus],
            ],
            /,
        ) -> "PodStatus.Builder": ...

        @overload
        def init_container_statuses(
            self, value_or_callback: Never = ...
        ) -> ListBuilderContext[ContainerStatus.Builder]: ...

        def init_container_statuses(self, value_or_callback=None, /):
            """
            The list has one entry per init container in the manifest. The most recent successful init container will have ready = true, the most recently started container will have startTime set. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#pod-and-container-status
            """
            if self._in_context and value_or_callback is None:
                context = ListBuilderContext[ContainerStatus.Builder]()
                context._parent_builder = self
                context._field_name = "init_container_statuses"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(ContainerStatus.list_builder())
                if isinstance(output, GenericListBuilder):
                    value = output.build()
                else:
                    value = output
            return self._set("init_container_statuses", value)

        def message(self, value: Optional[str], /) -> Self:
            """
            A human readable message indicating details about why the pod is in this condition.
            """
            return self._set("message", value)

        def nominated_node_name(self, value: Optional[str], /) -> Self:
            """
            nominatedNodeName is set only when this pod preempts other pods on the node, but it cannot be scheduled right away as preemption victims receive their graceful termination periods. This field does not guarantee that the pod will be scheduled on this node. Scheduler may decide to place the pod elsewhere if other nodes become available sooner. Scheduler may also decide to give the resources on this node to a higher priority pod that is created after preemption. As a result, this field may be different than PodSpec.nodeName when the pod is scheduled.
            """
            return self._set("nominated_node_name", value)

        def phase(self, value: Optional[str], /) -> Self:
            """
            The phase of a Pod is a simple, high-level summary of where the Pod is in its lifecycle. The conditions array, the reason and message fields, and the individual container status arrays contain more detail about the pod's status. There are five possible phase values:

            Pending: The pod has been accepted by the Kubernetes system, but one or more of the container images has not been created. This includes time before being scheduled as well as time spent downloading images over the network, which could take a while. Running: The pod has been bound to a node, and all of the containers have been created. At least one container is still running, or is in the process of starting or restarting. Succeeded: All containers in the pod have terminated in success, and will not be restarted. Failed: All containers in the pod have terminated, and at least one container has terminated in failure. The container either exited with non-zero status or was terminated by the system. Unknown: For some reason the state of the pod could not be obtained, typically due to an error in communicating with the host of the pod.

            More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#pod-phase
            """
            return self._set("phase", value)

        def pod_ip(self, value: Optional[str], /) -> Self:
            """
            podIP address allocated to the pod. Routable at least within the cluster. Empty if not yet allocated.
            """
            return self._set("pod_ip", value)

        @overload
        def pod_i_ps(self, value_or_callback: List[PodIP], /) -> "PodStatus.Builder": ...

        @overload
        def pod_i_ps(
            self,
            value_or_callback: Callable[
                [GenericListBuilder[PodIP, PodIP.Builder]],
                GenericListBuilder[PodIP, PodIP.Builder] | List[PodIP],
            ],
            /,
        ) -> "PodStatus.Builder": ...

        @overload
        def pod_i_ps(self, value_or_callback: Never = ...) -> ListBuilderContext[PodIP.Builder]: ...

        def pod_i_ps(self, value_or_callback=None, /):
            """
            podIPs holds the IP addresses allocated to the pod. If this field is specified, the 0th entry must match the podIP field. Pods may be allocated at most 1 value for each of IPv4 and IPv6. This list is empty if no IPs have been allocated yet.
            """
            if self._in_context and value_or_callback is None:
                context = ListBuilderContext[PodIP.Builder]()
                context._parent_builder = self
                context._field_name = "pod_i_ps"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(PodIP.list_builder())
                if isinstance(output, GenericListBuilder):
                    value = output.build()
                else:
                    value = output
            return self._set("pod_i_ps", value)

        def qos_class(self, value: Optional[str], /) -> Self:
            """
            The Quality of Service (QOS) classification assigned to the pod based on resource requirements See PodQOSClass type for available QOS classes More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-qos/#quality-of-service-classes
            """
            return self._set("qos_class", value)

        def reason(self, value: Optional[str], /) -> Self:
            """
            A brief CamelCase message indicating details about why the pod is in this state. e.g. 'Evicted'
            """
            return self._set("reason", value)

        def resize(self, value: Optional[str], /) -> Self:
            """
            Status of resources resize desired for pod's containers. It is empty if no resources resize is pending. Any changes to container resources will automatically set this to "Proposed"
            """
            return self._set("resize", value)

        @overload
        def resource_claim_statuses(
            self, value_or_callback: List[PodResourceClaimStatus], /
        ) -> "PodStatus.Builder": ...

        @overload
        def resource_claim_statuses(
            self,
            value_or_callback: Callable[
                [GenericListBuilder[PodResourceClaimStatus, PodResourceClaimStatus.Builder]],
                GenericListBuilder[PodResourceClaimStatus, PodResourceClaimStatus.Builder]
                | List[PodResourceClaimStatus],
            ],
            /,
        ) -> "PodStatus.Builder": ...

        @overload
        def resource_claim_statuses(
            self, value_or_callback: Never = ...
        ) -> ListBuilderContext[PodResourceClaimStatus.Builder]: ...

        def resource_claim_statuses(self, value_or_callback=None, /):
            """
            Status of resource claims.
            """
            if self._in_context and value_or_callback is None:
                context = ListBuilderContext[PodResourceClaimStatus.Builder]()
                context._parent_builder = self
                context._field_name = "resource_claim_statuses"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(PodResourceClaimStatus.list_builder())
                if isinstance(output, GenericListBuilder):
                    value = output.build()
                else:
                    value = output
            return self._set("resource_claim_statuses", value)

        @overload
        def start_time(
            self, value_or_callback: Optional[apimachinery.Time], /
        ) -> "PodStatus.Builder": ...

        @overload
        def start_time(
            self,
            value_or_callback: Callable[
                [apimachinery.Time.Builder],
                apimachinery.Time.Builder | apimachinery.Time,
            ],
            /,
        ) -> "PodStatus.Builder": ...

        @overload
        def start_time(
            self, value_or_callback: Never = ...
        ) -> "apimachinery.Time.BuilderContext": ...

        def start_time(self, value_or_callback=None, /):
            """
            RFC 3339 date and time at which the object was acknowledged by the Kubelet. This is before the Kubelet pulled the container image(s) for the pod.
            """
            if self._in_context and value_or_callback is None:
                context = apimachinery.Time.BuilderContext()
                context._parent_builder = self
                context._field_name = "start_time"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(apimachinery.Time.builder())
                if isinstance(output, apimachinery.Time.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("start_time", value)

    class BuilderContext(BuilderContextBase["PodStatus.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = PodStatus.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for PodStatus."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["PodStatus", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use PodStatus.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    conditions: Optional[List[PodCondition]] = None
    """
    Current service state of pod. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#pod-conditions
    """
    container_statuses: Annotated[
        Optional[List[ContainerStatus]], Field(alias="containerStatuses")
    ] = None
    """
    The list has one entry per container in the manifest. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#pod-and-container-status
    """
    ephemeral_container_statuses: Annotated[
        Optional[List[ContainerStatus]], Field(alias="ephemeralContainerStatuses")
    ] = None
    """
    Status for any ephemeral containers that have run in this pod.
    """
    host_ip: Annotated[Optional[str], Field(alias="hostIP")] = None
    """
    hostIP holds the IP address of the host to which the pod is assigned. Empty if the pod has not started yet. A pod can be assigned to a node that has a problem in kubelet which in turns mean that HostIP will not be updated even if there is a node is assigned to pod
    """
    host_i_ps: Annotated[Optional[List[HostIP]], Field(alias="hostIPs")] = None
    """
    hostIPs holds the IP addresses allocated to the host. If this field is specified, the first entry must match the hostIP field. This list is empty if the pod has not started yet. A pod can be assigned to a node that has a problem in kubelet which in turns means that HostIPs will not be updated even if there is a node is assigned to this pod.
    """
    init_container_statuses: Annotated[
        Optional[List[ContainerStatus]], Field(alias="initContainerStatuses")
    ] = None
    """
    The list has one entry per init container in the manifest. The most recent successful init container will have ready = true, the most recently started container will have startTime set. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#pod-and-container-status
    """
    message: Optional[str] = None
    """
    A human readable message indicating details about why the pod is in this condition.
    """
    nominated_node_name: Annotated[Optional[str], Field(alias="nominatedNodeName")] = None
    """
    nominatedNodeName is set only when this pod preempts other pods on the node, but it cannot be scheduled right away as preemption victims receive their graceful termination periods. This field does not guarantee that the pod will be scheduled on this node. Scheduler may decide to place the pod elsewhere if other nodes become available sooner. Scheduler may also decide to give the resources on this node to a higher priority pod that is created after preemption. As a result, this field may be different than PodSpec.nodeName when the pod is scheduled.
    """
    phase: Optional[str] = None
    """
    The phase of a Pod is a simple, high-level summary of where the Pod is in its lifecycle. The conditions array, the reason and message fields, and the individual container status arrays contain more detail about the pod's status. There are five possible phase values:

    Pending: The pod has been accepted by the Kubernetes system, but one or more of the container images has not been created. This includes time before being scheduled as well as time spent downloading images over the network, which could take a while. Running: The pod has been bound to a node, and all of the containers have been created. At least one container is still running, or is in the process of starting or restarting. Succeeded: All containers in the pod have terminated in success, and will not be restarted. Failed: All containers in the pod have terminated, and at least one container has terminated in failure. The container either exited with non-zero status or was terminated by the system. Unknown: For some reason the state of the pod could not be obtained, typically due to an error in communicating with the host of the pod.

    More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#pod-phase
    """
    pod_ip: Annotated[Optional[str], Field(alias="podIP")] = None
    """
    podIP address allocated to the pod. Routable at least within the cluster. Empty if not yet allocated.
    """
    pod_i_ps: Annotated[Optional[List[PodIP]], Field(alias="podIPs")] = None
    """
    podIPs holds the IP addresses allocated to the pod. If this field is specified, the 0th entry must match the podIP field. Pods may be allocated at most 1 value for each of IPv4 and IPv6. This list is empty if no IPs have been allocated yet.
    """
    qos_class: Annotated[Optional[str], Field(alias="qosClass")] = None
    """
    The Quality of Service (QOS) classification assigned to the pod based on resource requirements See PodQOSClass type for available QOS classes More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-qos/#quality-of-service-classes
    """
    reason: Optional[str] = None
    """
    A brief CamelCase message indicating details about why the pod is in this state. e.g. 'Evicted'
    """
    resize: Optional[str] = None
    """
    Status of resources resize desired for pod's containers. It is empty if no resources resize is pending. Any changes to container resources will automatically set this to "Proposed"
    """
    resource_claim_statuses: Annotated[
        Optional[List[PodResourceClaimStatus]], Field(alias="resourceClaimStatuses")
    ] = None
    """
    Status of resource claims.
    """
    start_time: Annotated[Optional[apimachinery.Time], Field(alias="startTime")] = None
    """
    RFC 3339 date and time at which the object was acknowledged by the Kubelet. This is before the Kubelet pulled the container image(s) for the pod.
    """


class Probe(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["Probe"]:
            return Probe

        def build(self) -> "Probe":
            return Probe(**self._attrs)

        @overload
        def exec(self, value_or_callback: Optional[ExecAction], /) -> "Probe.Builder": ...

        @overload
        def exec(
            self,
            value_or_callback: Callable[[ExecAction.Builder], ExecAction.Builder | ExecAction],
            /,
        ) -> "Probe.Builder": ...

        @overload
        def exec(self, value_or_callback: Never = ...) -> "ExecAction.BuilderContext": ...

        def exec(self, value_or_callback=None, /):
            """
            Exec specifies the action to take.
            """
            if self._in_context and value_or_callback is None:
                context = ExecAction.BuilderContext()
                context._parent_builder = self
                context._field_name = "exec"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(ExecAction.builder())
                if isinstance(output, ExecAction.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("exec", value)

        def failure_threshold(self, value: Optional[int], /) -> Self:
            """
            Minimum consecutive failures for the probe to be considered failed after having succeeded. Defaults to 3. Minimum value is 1.
            """
            return self._set("failure_threshold", value)

        @overload
        def grpc(self, value_or_callback: Optional[GRPCAction], /) -> "Probe.Builder": ...

        @overload
        def grpc(
            self,
            value_or_callback: Callable[[GRPCAction.Builder], GRPCAction.Builder | GRPCAction],
            /,
        ) -> "Probe.Builder": ...

        @overload
        def grpc(self, value_or_callback: Never = ...) -> "GRPCAction.BuilderContext": ...

        def grpc(self, value_or_callback=None, /):
            """
            GRPC specifies an action involving a GRPC port.
            """
            if self._in_context and value_or_callback is None:
                context = GRPCAction.BuilderContext()
                context._parent_builder = self
                context._field_name = "grpc"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(GRPCAction.builder())
                if isinstance(output, GRPCAction.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("grpc", value)

        @overload
        def http_get(self, value_or_callback: Optional[HTTPGetAction], /) -> "Probe.Builder": ...

        @overload
        def http_get(
            self,
            value_or_callback: Callable[
                [HTTPGetAction.Builder], HTTPGetAction.Builder | HTTPGetAction
            ],
            /,
        ) -> "Probe.Builder": ...

        @overload
        def http_get(self, value_or_callback: Never = ...) -> "HTTPGetAction.BuilderContext": ...

        def http_get(self, value_or_callback=None, /):
            """
            HTTPGet specifies the http request to perform.
            """
            if self._in_context and value_or_callback is None:
                context = HTTPGetAction.BuilderContext()
                context._parent_builder = self
                context._field_name = "http_get"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(HTTPGetAction.builder())
                if isinstance(output, HTTPGetAction.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("http_get", value)

        def initial_delay_seconds(self, value: Optional[int], /) -> Self:
            """
            Number of seconds after the container has started before liveness probes are initiated. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes
            """
            return self._set("initial_delay_seconds", value)

        def period_seconds(self, value: Optional[int], /) -> Self:
            """
            How often (in seconds) to perform the probe. Default to 10 seconds. Minimum value is 1.
            """
            return self._set("period_seconds", value)

        def success_threshold(self, value: Optional[int], /) -> Self:
            """
            Minimum consecutive successes for the probe to be considered successful after having failed. Defaults to 1. Must be 1 for liveness and startup. Minimum value is 1.
            """
            return self._set("success_threshold", value)

        @overload
        def tcp_socket(
            self, value_or_callback: Optional[TCPSocketAction], /
        ) -> "Probe.Builder": ...

        @overload
        def tcp_socket(
            self,
            value_or_callback: Callable[
                [TCPSocketAction.Builder], TCPSocketAction.Builder | TCPSocketAction
            ],
            /,
        ) -> "Probe.Builder": ...

        @overload
        def tcp_socket(
            self, value_or_callback: Never = ...
        ) -> "TCPSocketAction.BuilderContext": ...

        def tcp_socket(self, value_or_callback=None, /):
            """
            TCPSocket specifies an action involving a TCP port.
            """
            if self._in_context and value_or_callback is None:
                context = TCPSocketAction.BuilderContext()
                context._parent_builder = self
                context._field_name = "tcp_socket"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(TCPSocketAction.builder())
                if isinstance(output, TCPSocketAction.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("tcp_socket", value)

        def termination_grace_period_seconds(self, value: Optional[int], /) -> Self:
            """
            Optional duration in seconds the pod needs to terminate gracefully upon probe failure. The grace period is the duration in seconds after the processes running in the pod are sent a termination signal and the time when the processes are forcibly halted with a kill signal. Set this value longer than the expected cleanup time for your process. If this value is nil, the pod's terminationGracePeriodSeconds will be used. Otherwise, this value overrides the value provided by the pod spec. Value must be non-negative integer. The value zero indicates stop immediately via the kill signal (no opportunity to shut down). This is a beta field and requires enabling ProbeTerminationGracePeriod feature gate. Minimum value is 1. spec.terminationGracePeriodSeconds is used if unset.
            """
            return self._set("termination_grace_period_seconds", value)

        def timeout_seconds(self, value: Optional[int], /) -> Self:
            """
            Number of seconds after which the probe times out. Defaults to 1 second. Minimum value is 1. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes
            """
            return self._set("timeout_seconds", value)

    class BuilderContext(BuilderContextBase["Probe.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = Probe.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for Probe."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["Probe", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use Probe.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    exec: Optional[ExecAction] = None
    """
    Exec specifies the action to take.
    """
    failure_threshold: Annotated[Optional[int], Field(alias="failureThreshold")] = None
    """
    Minimum consecutive failures for the probe to be considered failed after having succeeded. Defaults to 3. Minimum value is 1.
    """
    grpc: Optional[GRPCAction] = None
    """
    GRPC specifies an action involving a GRPC port.
    """
    http_get: Annotated[Optional[HTTPGetAction], Field(alias="httpGet")] = None
    """
    HTTPGet specifies the http request to perform.
    """
    initial_delay_seconds: Annotated[Optional[int], Field(alias="initialDelaySeconds")] = None
    """
    Number of seconds after the container has started before liveness probes are initiated. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes
    """
    period_seconds: Annotated[Optional[int], Field(alias="periodSeconds")] = None
    """
    How often (in seconds) to perform the probe. Default to 10 seconds. Minimum value is 1.
    """
    success_threshold: Annotated[Optional[int], Field(alias="successThreshold")] = None
    """
    Minimum consecutive successes for the probe to be considered successful after having failed. Defaults to 1. Must be 1 for liveness and startup. Minimum value is 1.
    """
    tcp_socket: Annotated[Optional[TCPSocketAction], Field(alias="tcpSocket")] = None
    """
    TCPSocket specifies an action involving a TCP port.
    """
    termination_grace_period_seconds: Annotated[
        Optional[int], Field(alias="terminationGracePeriodSeconds")
    ] = None
    """
    Optional duration in seconds the pod needs to terminate gracefully upon probe failure. The grace period is the duration in seconds after the processes running in the pod are sent a termination signal and the time when the processes are forcibly halted with a kill signal. Set this value longer than the expected cleanup time for your process. If this value is nil, the pod's terminationGracePeriodSeconds will be used. Otherwise, this value overrides the value provided by the pod spec. Value must be non-negative integer. The value zero indicates stop immediately via the kill signal (no opportunity to shut down). This is a beta field and requires enabling ProbeTerminationGracePeriod feature gate. Minimum value is 1. spec.terminationGracePeriodSeconds is used if unset.
    """
    timeout_seconds: Annotated[Optional[int], Field(alias="timeoutSeconds")] = None
    """
    Number of seconds after which the probe times out. Defaults to 1 second. Minimum value is 1. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes
    """


class ResourceQuotaSpec(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["ResourceQuotaSpec"]:
            return ResourceQuotaSpec

        def build(self) -> "ResourceQuotaSpec":
            return ResourceQuotaSpec(**self._attrs)

        def hard(self, value: Optional[Dict[str, apimachinery.Quantity]], /) -> Self:
            """
            hard is the set of desired hard limits for each named resource. More info: https://kubernetes.io/docs/concepts/policy/resource-quotas/
            """
            return self._set("hard", value)

        @overload
        def scope_selector(
            self, value_or_callback: Optional[ScopeSelector], /
        ) -> "ResourceQuotaSpec.Builder": ...

        @overload
        def scope_selector(
            self,
            value_or_callback: Callable[
                [ScopeSelector.Builder], ScopeSelector.Builder | ScopeSelector
            ],
            /,
        ) -> "ResourceQuotaSpec.Builder": ...

        @overload
        def scope_selector(
            self, value_or_callback: Never = ...
        ) -> "ScopeSelector.BuilderContext": ...

        def scope_selector(self, value_or_callback=None, /):
            """
            scopeSelector is also a collection of filters like scopes that must match each object tracked by a quota but expressed using ScopeSelectorOperator in combination with possible values. For a resource to match, both scopes AND scopeSelector (if specified in spec), must be matched.
            """
            if self._in_context and value_or_callback is None:
                context = ScopeSelector.BuilderContext()
                context._parent_builder = self
                context._field_name = "scope_selector"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(ScopeSelector.builder())
                if isinstance(output, ScopeSelector.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("scope_selector", value)

        def scopes(self, value: Optional[List[str]], /) -> Self:
            """
            A collection of filters that must match each object tracked by a quota. If not specified, the quota matches all objects.
            """
            return self._set("scopes", value)

    class BuilderContext(BuilderContextBase["ResourceQuotaSpec.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = ResourceQuotaSpec.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for ResourceQuotaSpec."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["ResourceQuotaSpec", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use ResourceQuotaSpec.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    hard: Optional[Dict[str, apimachinery.Quantity]] = None
    """
    hard is the set of desired hard limits for each named resource. More info: https://kubernetes.io/docs/concepts/policy/resource-quotas/
    """
    scope_selector: Annotated[Optional[ScopeSelector], Field(alias="scopeSelector")] = None
    """
    scopeSelector is also a collection of filters like scopes that must match each object tracked by a quota but expressed using ScopeSelectorOperator in combination with possible values. For a resource to match, both scopes AND scopeSelector (if specified in spec), must be matched.
    """
    scopes: Optional[List[str]] = None
    """
    A collection of filters that must match each object tracked by a quota. If not specified, the quota matches all objects.
    """


class Secret(Resource):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["Secret"]:
            return Secret

        def build(self) -> "Secret":
            return Secret(**self._attrs)

        def api_version(self, value: Optional[Literal["v1"]], /) -> Self:
            """
            APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
            """
            return self._set("api_version", value)

        def data(self, value: Optional[Dict[str, str]], /) -> Self:
            """
            Data contains the secret data. Each key must consist of alphanumeric characters, '-', '_' or '.'. The serialized form of the secret data is a base64 encoded string, representing the arbitrary (possibly non-string) data value here. Described in https://tools.ietf.org/html/rfc4648#section-4
            """
            return self._set("data", value)

        def immutable(self, value: Optional[bool], /) -> Self:
            """
            Immutable, if set to true, ensures that data stored in the Secret cannot be updated (only object metadata can be modified). If not set to true, the field can be modified at any time. Defaulted to nil.
            """
            return self._set("immutable", value)

        def kind(self, value: Optional[Literal["Secret"]], /) -> Self:
            """
            Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
            """
            return self._set("kind", value)

        @overload
        def metadata(
            self, value_or_callback: Optional[apimachinery.ObjectMeta], /
        ) -> "Secret.Builder": ...

        @overload
        def metadata(
            self,
            value_or_callback: Callable[
                [apimachinery.ObjectMeta.Builder],
                apimachinery.ObjectMeta.Builder | apimachinery.ObjectMeta,
            ],
            /,
        ) -> "Secret.Builder": ...

        @overload
        def metadata(
            self, value_or_callback: Never = ...
        ) -> "apimachinery.ObjectMeta.BuilderContext": ...

        def metadata(self, value_or_callback=None, /):
            """
            Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
            """
            if self._in_context and value_or_callback is None:
                context = apimachinery.ObjectMeta.BuilderContext()
                context._parent_builder = self
                context._field_name = "metadata"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(apimachinery.ObjectMeta.builder())
                if isinstance(output, apimachinery.ObjectMeta.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("metadata", value)

        def string_data(self, value: Optional[Dict[str, str]], /) -> Self:
            """
            stringData allows specifying non-binary secret data in string form. It is provided as a write-only input field for convenience. All keys and values are merged into the data field on write, overwriting any existing values. The stringData field is never output when reading from the API.
            """
            return self._set("string_data", value)

        def type(self, value: Optional[str], /) -> Self:
            """
            Used to facilitate programmatic handling of secret data. More info: https://kubernetes.io/docs/concepts/configuration/secret/#secret-types
            """
            return self._set("type", value)

    class BuilderContext(BuilderContextBase["Secret.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = Secret.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for Secret."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["Secret", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use Secret.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    api_version: Annotated[Optional[Literal["v1"]], Field(alias="apiVersion")] = "v1"
    """
    APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
    """
    data: Optional[Dict[str, str]] = None
    """
    Data contains the secret data. Each key must consist of alphanumeric characters, '-', '_' or '.'. The serialized form of the secret data is a base64 encoded string, representing the arbitrary (possibly non-string) data value here. Described in https://tools.ietf.org/html/rfc4648#section-4
    """
    immutable: Optional[bool] = None
    """
    Immutable, if set to true, ensures that data stored in the Secret cannot be updated (only object metadata can be modified). If not set to true, the field can be modified at any time. Defaulted to nil.
    """
    kind: Optional[Literal["Secret"]] = "Secret"
    """
    Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
    """
    metadata: Optional[apimachinery.ObjectMeta] = None
    """
    Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
    """
    string_data: Annotated[Optional[Dict[str, str]], Field(alias="stringData")] = None
    """
    stringData allows specifying non-binary secret data in string form. It is provided as a write-only input field for convenience. All keys and values are merged into the data field on write, overwriting any existing values. The stringData field is never output when reading from the API.
    """
    type: Optional[str] = None
    """
    Used to facilitate programmatic handling of secret data. More info: https://kubernetes.io/docs/concepts/configuration/secret/#secret-types
    """


SecretList = ResourceList["Secret"]


class ServiceAccount(Resource):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["ServiceAccount"]:
            return ServiceAccount

        def build(self) -> "ServiceAccount":
            return ServiceAccount(**self._attrs)

        def api_version(self, value: Optional[Literal["v1"]], /) -> Self:
            """
            APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
            """
            return self._set("api_version", value)

        def automount_service_account_token(self, value: Optional[bool], /) -> Self:
            """
            AutomountServiceAccountToken indicates whether pods running as this service account should have an API token automatically mounted. Can be overridden at the pod level.
            """
            return self._set("automount_service_account_token", value)

        @overload
        def image_pull_secrets(
            self, value_or_callback: List[LocalObjectReference], /
        ) -> "ServiceAccount.Builder": ...

        @overload
        def image_pull_secrets(
            self,
            value_or_callback: Callable[
                [GenericListBuilder[LocalObjectReference, LocalObjectReference.Builder]],
                GenericListBuilder[LocalObjectReference, LocalObjectReference.Builder]
                | List[LocalObjectReference],
            ],
            /,
        ) -> "ServiceAccount.Builder": ...

        @overload
        def image_pull_secrets(
            self, value_or_callback: Never = ...
        ) -> ListBuilderContext[LocalObjectReference.Builder]: ...

        def image_pull_secrets(self, value_or_callback=None, /):
            """
            ImagePullSecrets is a list of references to secrets in the same namespace to use for pulling any images in pods that reference this ServiceAccount. ImagePullSecrets are distinct from Secrets because Secrets can be mounted in the pod, but ImagePullSecrets are only accessed by the kubelet. More info: https://kubernetes.io/docs/concepts/containers/images/#specifying-imagepullsecrets-on-a-pod
            """
            if self._in_context and value_or_callback is None:
                context = ListBuilderContext[LocalObjectReference.Builder]()
                context._parent_builder = self
                context._field_name = "image_pull_secrets"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(LocalObjectReference.list_builder())
                if isinstance(output, GenericListBuilder):
                    value = output.build()
                else:
                    value = output
            return self._set("image_pull_secrets", value)

        def kind(self, value: Optional[Literal["ServiceAccount"]], /) -> Self:
            """
            Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
            """
            return self._set("kind", value)

        @overload
        def metadata(
            self, value_or_callback: Optional[apimachinery.ObjectMeta], /
        ) -> "ServiceAccount.Builder": ...

        @overload
        def metadata(
            self,
            value_or_callback: Callable[
                [apimachinery.ObjectMeta.Builder],
                apimachinery.ObjectMeta.Builder | apimachinery.ObjectMeta,
            ],
            /,
        ) -> "ServiceAccount.Builder": ...

        @overload
        def metadata(
            self, value_or_callback: Never = ...
        ) -> "apimachinery.ObjectMeta.BuilderContext": ...

        def metadata(self, value_or_callback=None, /):
            """
            Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
            """
            if self._in_context and value_or_callback is None:
                context = apimachinery.ObjectMeta.BuilderContext()
                context._parent_builder = self
                context._field_name = "metadata"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(apimachinery.ObjectMeta.builder())
                if isinstance(output, apimachinery.ObjectMeta.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("metadata", value)

        @overload
        def secrets(
            self, value_or_callback: List[ObjectReference], /
        ) -> "ServiceAccount.Builder": ...

        @overload
        def secrets(
            self,
            value_or_callback: Callable[
                [GenericListBuilder[ObjectReference, ObjectReference.Builder]],
                GenericListBuilder[ObjectReference, ObjectReference.Builder]
                | List[ObjectReference],
            ],
            /,
        ) -> "ServiceAccount.Builder": ...

        @overload
        def secrets(
            self, value_or_callback: Never = ...
        ) -> ListBuilderContext[ObjectReference.Builder]: ...

        def secrets(self, value_or_callback=None, /):
            """
            Secrets is a list of the secrets in the same namespace that pods running using this ServiceAccount are allowed to use. Pods are only limited to this list if this service account has a "kubernetes.io/enforce-mountable-secrets" annotation set to "true". This field should not be used to find auto-generated service account token secrets for use outside of pods. Instead, tokens can be requested directly using the TokenRequest API, or service account token secrets can be manually created. More info: https://kubernetes.io/docs/concepts/configuration/secret
            """
            if self._in_context and value_or_callback is None:
                context = ListBuilderContext[ObjectReference.Builder]()
                context._parent_builder = self
                context._field_name = "secrets"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(ObjectReference.list_builder())
                if isinstance(output, GenericListBuilder):
                    value = output.build()
                else:
                    value = output
            return self._set("secrets", value)

    class BuilderContext(BuilderContextBase["ServiceAccount.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = ServiceAccount.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for ServiceAccount."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["ServiceAccount", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use ServiceAccount.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    api_version: Annotated[Optional[Literal["v1"]], Field(alias="apiVersion")] = "v1"
    """
    APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
    """
    automount_service_account_token: Annotated[
        Optional[bool], Field(alias="automountServiceAccountToken")
    ] = None
    """
    AutomountServiceAccountToken indicates whether pods running as this service account should have an API token automatically mounted. Can be overridden at the pod level.
    """
    image_pull_secrets: Annotated[
        Optional[List[LocalObjectReference]], Field(alias="imagePullSecrets")
    ] = None
    """
    ImagePullSecrets is a list of references to secrets in the same namespace to use for pulling any images in pods that reference this ServiceAccount. ImagePullSecrets are distinct from Secrets because Secrets can be mounted in the pod, but ImagePullSecrets are only accessed by the kubelet. More info: https://kubernetes.io/docs/concepts/containers/images/#specifying-imagepullsecrets-on-a-pod
    """
    kind: Optional[Literal["ServiceAccount"]] = "ServiceAccount"
    """
    Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
    """
    metadata: Optional[apimachinery.ObjectMeta] = None
    """
    Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
    """
    secrets: Optional[List[ObjectReference]] = None
    """
    Secrets is a list of the secrets in the same namespace that pods running using this ServiceAccount are allowed to use. Pods are only limited to this list if this service account has a "kubernetes.io/enforce-mountable-secrets" annotation set to "true". This field should not be used to find auto-generated service account token secrets for use outside of pods. Instead, tokens can be requested directly using the TokenRequest API, or service account token secrets can be manually created. More info: https://kubernetes.io/docs/concepts/configuration/secret
    """


ServiceAccountList = ResourceList["ServiceAccount"]


class ServiceStatus(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["ServiceStatus"]:
            return ServiceStatus

        def build(self) -> "ServiceStatus":
            return ServiceStatus(**self._attrs)

        @overload
        def conditions(
            self, value_or_callback: List[apimachinery.Condition], /
        ) -> "ServiceStatus.Builder": ...

        @overload
        def conditions(
            self,
            value_or_callback: Callable[
                [GenericListBuilder[apimachinery.Condition, apimachinery.Condition.Builder]],
                GenericListBuilder[apimachinery.Condition, apimachinery.Condition.Builder]
                | List[apimachinery.Condition],
            ],
            /,
        ) -> "ServiceStatus.Builder": ...

        @overload
        def conditions(
            self, value_or_callback: Never = ...
        ) -> ListBuilderContext[apimachinery.Condition.Builder]: ...

        def conditions(self, value_or_callback=None, /):
            """
            Current service state
            """
            if self._in_context and value_or_callback is None:
                context = ListBuilderContext[apimachinery.Condition.Builder]()
                context._parent_builder = self
                context._field_name = "conditions"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(apimachinery.Condition.list_builder())
                if isinstance(output, GenericListBuilder):
                    value = output.build()
                else:
                    value = output
            return self._set("conditions", value)

        @overload
        def load_balancer(
            self, value_or_callback: Optional[LoadBalancerStatus], /
        ) -> "ServiceStatus.Builder": ...

        @overload
        def load_balancer(
            self,
            value_or_callback: Callable[
                [LoadBalancerStatus.Builder],
                LoadBalancerStatus.Builder | LoadBalancerStatus,
            ],
            /,
        ) -> "ServiceStatus.Builder": ...

        @overload
        def load_balancer(
            self, value_or_callback: Never = ...
        ) -> "LoadBalancerStatus.BuilderContext": ...

        def load_balancer(self, value_or_callback=None, /):
            """
            LoadBalancer contains the current status of the load-balancer, if one is present.
            """
            if self._in_context and value_or_callback is None:
                context = LoadBalancerStatus.BuilderContext()
                context._parent_builder = self
                context._field_name = "load_balancer"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(LoadBalancerStatus.builder())
                if isinstance(output, LoadBalancerStatus.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("load_balancer", value)

    class BuilderContext(BuilderContextBase["ServiceStatus.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = ServiceStatus.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for ServiceStatus."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["ServiceStatus", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use ServiceStatus.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    conditions: Optional[List[apimachinery.Condition]] = None
    """
    Current service state
    """
    load_balancer: Annotated[Optional[LoadBalancerStatus], Field(alias="loadBalancer")] = None
    """
    LoadBalancer contains the current status of the load-balancer, if one is present.
    """


class TopologySpreadConstraint(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["TopologySpreadConstraint"]:
            return TopologySpreadConstraint

        def build(self) -> "TopologySpreadConstraint":
            return TopologySpreadConstraint(**self._attrs)

        @overload
        def label_selector(
            self, value_or_callback: Optional[apimachinery.LabelSelector], /
        ) -> "TopologySpreadConstraint.Builder": ...

        @overload
        def label_selector(
            self,
            value_or_callback: Callable[
                [apimachinery.LabelSelector.Builder],
                apimachinery.LabelSelector.Builder | apimachinery.LabelSelector,
            ],
            /,
        ) -> "TopologySpreadConstraint.Builder": ...

        @overload
        def label_selector(
            self, value_or_callback: Never = ...
        ) -> "apimachinery.LabelSelector.BuilderContext": ...

        def label_selector(self, value_or_callback=None, /):
            """
            LabelSelector is used to find matching pods. Pods that match this label selector are counted to determine the number of pods in their corresponding topology domain.
            """
            if self._in_context and value_or_callback is None:
                context = apimachinery.LabelSelector.BuilderContext()
                context._parent_builder = self
                context._field_name = "label_selector"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(apimachinery.LabelSelector.builder())
                if isinstance(output, apimachinery.LabelSelector.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("label_selector", value)

        def match_label_keys(self, value: Optional[List[str]], /) -> Self:
            """
            MatchLabelKeys is a set of pod label keys to select the pods over which spreading will be calculated. The keys are used to lookup values from the incoming pod labels, those key-value labels are ANDed with labelSelector to select the group of existing pods over which spreading will be calculated for the incoming pod. The same key is forbidden to exist in both MatchLabelKeys and LabelSelector. MatchLabelKeys cannot be set when LabelSelector isn't set. Keys that don't exist in the incoming pod labels will be ignored. A null or empty list means only match against labelSelector.

            This is a beta field and requires the MatchLabelKeysInPodTopologySpread feature gate to be enabled (enabled by default).
            """
            return self._set("match_label_keys", value)

        def max_skew(self, value: int, /) -> Self:
            """
            MaxSkew describes the degree to which pods may be unevenly distributed. When `whenUnsatisfiable=DoNotSchedule`, it is the maximum permitted difference between the number of matching pods in the target topology and the global minimum. The global minimum is the minimum number of matching pods in an eligible domain or zero if the number of eligible domains is less than MinDomains. For example, in a 3-zone cluster, MaxSkew is set to 1, and pods with the same labelSelector spread as 2/2/1: In this case, the global minimum is 1. | zone1 | zone2 | zone3 | |  P P  |  P P  |   P   | - if MaxSkew is 1, incoming pod can only be scheduled to zone3 to become 2/2/2; scheduling it onto zone1(zone2) would make the ActualSkew(3-1) on zone1(zone2) violate MaxSkew(1). - if MaxSkew is 2, incoming pod can be scheduled onto any zone. When `whenUnsatisfiable=ScheduleAnyway`, it is used to give higher precedence to topologies that satisfy it. It's a required field. Default value is 1 and 0 is not allowed.
            """
            return self._set("max_skew", value)

        def min_domains(self, value: Optional[int], /) -> Self:
            """
            MinDomains indicates a minimum number of eligible domains. When the number of eligible domains with matching topology keys is less than minDomains, Pod Topology Spread treats "global minimum" as 0, and then the calculation of Skew is performed. And when the number of eligible domains with matching topology keys equals or greater than minDomains, this value has no effect on scheduling. As a result, when the number of eligible domains is less than minDomains, scheduler won't schedule more than maxSkew Pods to those domains. If value is nil, the constraint behaves as if MinDomains is equal to 1. Valid values are integers greater than 0. When value is not nil, WhenUnsatisfiable must be DoNotSchedule.

            For example, in a 3-zone cluster, MaxSkew is set to 2, MinDomains is set to 5 and pods with the same labelSelector spread as 2/2/2: | zone1 | zone2 | zone3 | |  P P  |  P P  |  P P  | The number of domains is less than 5(MinDomains), so "global minimum" is treated as 0. In this situation, new pod with the same labelSelector cannot be scheduled, because computed skew will be 3(3 - 0) if new Pod is scheduled to any of the three zones, it will violate MaxSkew.
            """
            return self._set("min_domains", value)

        def node_affinity_policy(self, value: Optional[str], /) -> Self:
            """
            NodeAffinityPolicy indicates how we will treat Pod's nodeAffinity/nodeSelector when calculating pod topology spread skew. Options are: - Honor: only nodes matching nodeAffinity/nodeSelector are included in the calculations. - Ignore: nodeAffinity/nodeSelector are ignored. All nodes are included in the calculations.

            If this value is nil, the behavior is equivalent to the Honor policy. This is a beta-level feature default enabled by the NodeInclusionPolicyInPodTopologySpread feature flag.
            """
            return self._set("node_affinity_policy", value)

        def node_taints_policy(self, value: Optional[str], /) -> Self:
            """
            NodeTaintsPolicy indicates how we will treat node taints when calculating pod topology spread skew. Options are: - Honor: nodes without taints, along with tainted nodes for which the incoming pod has a toleration, are included. - Ignore: node taints are ignored. All nodes are included.

            If this value is nil, the behavior is equivalent to the Ignore policy. This is a beta-level feature default enabled by the NodeInclusionPolicyInPodTopologySpread feature flag.
            """
            return self._set("node_taints_policy", value)

        def topology_key(self, value: str, /) -> Self:
            """
            TopologyKey is the key of node labels. Nodes that have a label with this key and identical values are considered to be in the same topology. We consider each <key, value> as a "bucket", and try to put balanced number of pods into each bucket. We define a domain as a particular instance of a topology. Also, we define an eligible domain as a domain whose nodes meet the requirements of nodeAffinityPolicy and nodeTaintsPolicy. e.g. If TopologyKey is "kubernetes.io/hostname", each Node is a domain of that topology. And, if TopologyKey is "topology.kubernetes.io/zone", each zone is a domain of that topology. It's a required field.
            """
            return self._set("topology_key", value)

        def when_unsatisfiable(self, value: str, /) -> Self:
            """
            WhenUnsatisfiable indicates how to deal with a pod if it doesn't satisfy the spread constraint. - DoNotSchedule (default) tells the scheduler not to schedule it. - ScheduleAnyway tells the scheduler to schedule the pod in any location,
              but giving higher precedence to topologies that would help reduce the
              skew.
            A constraint is considered "Unsatisfiable" for an incoming pod if and only if every possible node assignment for that pod would violate "MaxSkew" on some topology. For example, in a 3-zone cluster, MaxSkew is set to 1, and pods with the same labelSelector spread as 3/1/1: | zone1 | zone2 | zone3 | | P P P |   P   |   P   | If WhenUnsatisfiable is set to DoNotSchedule, incoming pod can only be scheduled to zone2(zone3) to become 3/2/1(3/1/2) as ActualSkew(2-1) on zone2(zone3) satisfies MaxSkew(1). In other words, the cluster can still be imbalanced, but scheduler won't make it *more* imbalanced. It's a required field.
            """
            return self._set("when_unsatisfiable", value)

    class BuilderContext(BuilderContextBase["TopologySpreadConstraint.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = TopologySpreadConstraint.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for TopologySpreadConstraint."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["TopologySpreadConstraint", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use TopologySpreadConstraint.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    label_selector: Annotated[
        Optional[apimachinery.LabelSelector], Field(alias="labelSelector")
    ] = None
    """
    LabelSelector is used to find matching pods. Pods that match this label selector are counted to determine the number of pods in their corresponding topology domain.
    """
    match_label_keys: Annotated[Optional[List[str]], Field(alias="matchLabelKeys")] = None
    """
    MatchLabelKeys is a set of pod label keys to select the pods over which spreading will be calculated. The keys are used to lookup values from the incoming pod labels, those key-value labels are ANDed with labelSelector to select the group of existing pods over which spreading will be calculated for the incoming pod. The same key is forbidden to exist in both MatchLabelKeys and LabelSelector. MatchLabelKeys cannot be set when LabelSelector isn't set. Keys that don't exist in the incoming pod labels will be ignored. A null or empty list means only match against labelSelector.

    This is a beta field and requires the MatchLabelKeysInPodTopologySpread feature gate to be enabled (enabled by default).
    """
    max_skew: Annotated[int, Field(alias="maxSkew")]
    """
    MaxSkew describes the degree to which pods may be unevenly distributed. When `whenUnsatisfiable=DoNotSchedule`, it is the maximum permitted difference between the number of matching pods in the target topology and the global minimum. The global minimum is the minimum number of matching pods in an eligible domain or zero if the number of eligible domains is less than MinDomains. For example, in a 3-zone cluster, MaxSkew is set to 1, and pods with the same labelSelector spread as 2/2/1: In this case, the global minimum is 1. | zone1 | zone2 | zone3 | |  P P  |  P P  |   P   | - if MaxSkew is 1, incoming pod can only be scheduled to zone3 to become 2/2/2; scheduling it onto zone1(zone2) would make the ActualSkew(3-1) on zone1(zone2) violate MaxSkew(1). - if MaxSkew is 2, incoming pod can be scheduled onto any zone. When `whenUnsatisfiable=ScheduleAnyway`, it is used to give higher precedence to topologies that satisfy it. It's a required field. Default value is 1 and 0 is not allowed.
    """
    min_domains: Annotated[Optional[int], Field(alias="minDomains")] = None
    """
    MinDomains indicates a minimum number of eligible domains. When the number of eligible domains with matching topology keys is less than minDomains, Pod Topology Spread treats "global minimum" as 0, and then the calculation of Skew is performed. And when the number of eligible domains with matching topology keys equals or greater than minDomains, this value has no effect on scheduling. As a result, when the number of eligible domains is less than minDomains, scheduler won't schedule more than maxSkew Pods to those domains. If value is nil, the constraint behaves as if MinDomains is equal to 1. Valid values are integers greater than 0. When value is not nil, WhenUnsatisfiable must be DoNotSchedule.

    For example, in a 3-zone cluster, MaxSkew is set to 2, MinDomains is set to 5 and pods with the same labelSelector spread as 2/2/2: | zone1 | zone2 | zone3 | |  P P  |  P P  |  P P  | The number of domains is less than 5(MinDomains), so "global minimum" is treated as 0. In this situation, new pod with the same labelSelector cannot be scheduled, because computed skew will be 3(3 - 0) if new Pod is scheduled to any of the three zones, it will violate MaxSkew.
    """
    node_affinity_policy: Annotated[Optional[str], Field(alias="nodeAffinityPolicy")] = None
    """
    NodeAffinityPolicy indicates how we will treat Pod's nodeAffinity/nodeSelector when calculating pod topology spread skew. Options are: - Honor: only nodes matching nodeAffinity/nodeSelector are included in the calculations. - Ignore: nodeAffinity/nodeSelector are ignored. All nodes are included in the calculations.

    If this value is nil, the behavior is equivalent to the Honor policy. This is a beta-level feature default enabled by the NodeInclusionPolicyInPodTopologySpread feature flag.
    """
    node_taints_policy: Annotated[Optional[str], Field(alias="nodeTaintsPolicy")] = None
    """
    NodeTaintsPolicy indicates how we will treat node taints when calculating pod topology spread skew. Options are: - Honor: nodes without taints, along with tainted nodes for which the incoming pod has a toleration, are included. - Ignore: node taints are ignored. All nodes are included.

    If this value is nil, the behavior is equivalent to the Ignore policy. This is a beta-level feature default enabled by the NodeInclusionPolicyInPodTopologySpread feature flag.
    """
    topology_key: Annotated[str, Field(alias="topologyKey")]
    """
    TopologyKey is the key of node labels. Nodes that have a label with this key and identical values are considered to be in the same topology. We consider each <key, value> as a "bucket", and try to put balanced number of pods into each bucket. We define a domain as a particular instance of a topology. Also, we define an eligible domain as a domain whose nodes meet the requirements of nodeAffinityPolicy and nodeTaintsPolicy. e.g. If TopologyKey is "kubernetes.io/hostname", each Node is a domain of that topology. And, if TopologyKey is "topology.kubernetes.io/zone", each zone is a domain of that topology. It's a required field.
    """
    when_unsatisfiable: Annotated[str, Field(alias="whenUnsatisfiable")]
    """
    WhenUnsatisfiable indicates how to deal with a pod if it doesn't satisfy the spread constraint. - DoNotSchedule (default) tells the scheduler not to schedule it. - ScheduleAnyway tells the scheduler to schedule the pod in any location,
      but giving higher precedence to topologies that would help reduce the
      skew.
    A constraint is considered "Unsatisfiable" for an incoming pod if and only if every possible node assignment for that pod would violate "MaxSkew" on some topology. For example, in a 3-zone cluster, MaxSkew is set to 1, and pods with the same labelSelector spread as 3/1/1: | zone1 | zone2 | zone3 | | P P P |   P   |   P   | If WhenUnsatisfiable is set to DoNotSchedule, incoming pod can only be scheduled to zone2(zone3) to become 3/2/1(3/1/2) as ActualSkew(2-1) on zone2(zone3) satisfies MaxSkew(1). In other words, the cluster can still be imbalanced, but scheduler won't make it *more* imbalanced. It's a required field.
    """


class WeightedPodAffinityTerm(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["WeightedPodAffinityTerm"]:
            return WeightedPodAffinityTerm

        def build(self) -> "WeightedPodAffinityTerm":
            return WeightedPodAffinityTerm(**self._attrs)

        @overload
        def pod_affinity_term(
            self, value_or_callback: PodAffinityTerm, /
        ) -> "WeightedPodAffinityTerm.Builder": ...

        @overload
        def pod_affinity_term(
            self,
            value_or_callback: Callable[
                [PodAffinityTerm.Builder], PodAffinityTerm.Builder | PodAffinityTerm
            ],
            /,
        ) -> "WeightedPodAffinityTerm.Builder": ...

        @overload
        def pod_affinity_term(
            self, value_or_callback: Never = ...
        ) -> "PodAffinityTerm.BuilderContext": ...

        def pod_affinity_term(self, value_or_callback=None, /):
            """
            Required. A pod affinity term, associated with the corresponding weight.
            """
            if self._in_context and value_or_callback is None:
                context = PodAffinityTerm.BuilderContext()
                context._parent_builder = self
                context._field_name = "pod_affinity_term"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(PodAffinityTerm.builder())
                if isinstance(output, PodAffinityTerm.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("pod_affinity_term", value)

        def weight(self, value: int, /) -> Self:
            """
            weight associated with matching the corresponding podAffinityTerm, in the range 1-100.
            """
            return self._set("weight", value)

    class BuilderContext(BuilderContextBase["WeightedPodAffinityTerm.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = WeightedPodAffinityTerm.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for WeightedPodAffinityTerm."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["WeightedPodAffinityTerm", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use WeightedPodAffinityTerm.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    pod_affinity_term: Annotated[PodAffinityTerm, Field(alias="podAffinityTerm")]
    """
    Required. A pod affinity term, associated with the corresponding weight.
    """
    weight: int
    """
    weight associated with matching the corresponding podAffinityTerm, in the range 1-100.
    """


class DownwardAPIProjection(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["DownwardAPIProjection"]:
            return DownwardAPIProjection

        def build(self) -> "DownwardAPIProjection":
            return DownwardAPIProjection(**self._attrs)

        @overload
        def items(
            self, value_or_callback: List[DownwardAPIVolumeFile], /
        ) -> "DownwardAPIProjection.Builder": ...

        @overload
        def items(
            self,
            value_or_callback: Callable[
                [GenericListBuilder[DownwardAPIVolumeFile, DownwardAPIVolumeFile.Builder]],
                GenericListBuilder[DownwardAPIVolumeFile, DownwardAPIVolumeFile.Builder]
                | List[DownwardAPIVolumeFile],
            ],
            /,
        ) -> "DownwardAPIProjection.Builder": ...

        @overload
        def items(
            self, value_or_callback: Never = ...
        ) -> ListBuilderContext[DownwardAPIVolumeFile.Builder]: ...

        def items(self, value_or_callback=None, /):
            """
            Items is a list of DownwardAPIVolume file
            """
            if self._in_context and value_or_callback is None:
                context = ListBuilderContext[DownwardAPIVolumeFile.Builder]()
                context._parent_builder = self
                context._field_name = "items"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(DownwardAPIVolumeFile.list_builder())
                if isinstance(output, GenericListBuilder):
                    value = output.build()
                else:
                    value = output
            return self._set("items", value)

    class BuilderContext(BuilderContextBase["DownwardAPIProjection.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = DownwardAPIProjection.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for DownwardAPIProjection."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["DownwardAPIProjection", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use DownwardAPIProjection.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    items: Optional[List[DownwardAPIVolumeFile]] = None
    """
    Items is a list of DownwardAPIVolume file
    """


class EnvVar(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["EnvVar"]:
            return EnvVar

        def build(self) -> "EnvVar":
            return EnvVar(**self._attrs)

        def name(self, value: str, /) -> Self:
            """
            Name of the environment variable. Must be a C_IDENTIFIER.
            """
            return self._set("name", value)

        def value(self, value: Optional[str], /) -> Self:
            """
            Variable references $(VAR_NAME) are expanded using the previously defined environment variables in the container and any service environment variables. If a variable cannot be resolved, the reference in the input string will be unchanged. Double $$ are reduced to a single $, which allows for escaping the $(VAR_NAME) syntax: i.e. "$$(VAR_NAME)" will produce the string literal "$(VAR_NAME)". Escaped references will never be expanded, regardless of whether the variable exists or not. Defaults to "".
            """
            return self._set("value", value)

        @overload
        def value_from(self, value_or_callback: Optional[EnvVarSource], /) -> "EnvVar.Builder": ...

        @overload
        def value_from(
            self,
            value_or_callback: Callable[
                [EnvVarSource.Builder], EnvVarSource.Builder | EnvVarSource
            ],
            /,
        ) -> "EnvVar.Builder": ...

        @overload
        def value_from(self, value_or_callback: Never = ...) -> "EnvVarSource.BuilderContext": ...

        def value_from(self, value_or_callback=None, /):
            """
            Source for the environment variable's value. Cannot be used if value is not empty.
            """
            if self._in_context and value_or_callback is None:
                context = EnvVarSource.BuilderContext()
                context._parent_builder = self
                context._field_name = "value_from"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(EnvVarSource.builder())
                if isinstance(output, EnvVarSource.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("value_from", value)

    class BuilderContext(BuilderContextBase["EnvVar.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = EnvVar.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for EnvVar."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["EnvVar", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use EnvVar.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    name: str
    """
    Name of the environment variable. Must be a C_IDENTIFIER.
    """
    value: Optional[str] = None
    """
    Variable references $(VAR_NAME) are expanded using the previously defined environment variables in the container and any service environment variables. If a variable cannot be resolved, the reference in the input string will be unchanged. Double $$ are reduced to a single $, which allows for escaping the $(VAR_NAME) syntax: i.e. "$$(VAR_NAME)" will produce the string literal "$(VAR_NAME)". Escaped references will never be expanded, regardless of whether the variable exists or not. Defaults to "".
    """
    value_from: Annotated[Optional[EnvVarSource], Field(alias="valueFrom")] = None
    """
    Source for the environment variable's value. Cannot be used if value is not empty.
    """


class EphemeralVolumeSource(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["EphemeralVolumeSource"]:
            return EphemeralVolumeSource

        def build(self) -> "EphemeralVolumeSource":
            return EphemeralVolumeSource(**self._attrs)

        @overload
        def volume_claim_template(
            self, value_or_callback: Optional[PersistentVolumeClaimTemplate], /
        ) -> "EphemeralVolumeSource.Builder": ...

        @overload
        def volume_claim_template(
            self,
            value_or_callback: Callable[
                [PersistentVolumeClaimTemplate.Builder],
                PersistentVolumeClaimTemplate.Builder | PersistentVolumeClaimTemplate,
            ],
            /,
        ) -> "EphemeralVolumeSource.Builder": ...

        @overload
        def volume_claim_template(
            self, value_or_callback: Never = ...
        ) -> "PersistentVolumeClaimTemplate.BuilderContext": ...

        def volume_claim_template(self, value_or_callback=None, /):
            """
            Will be used to create a stand-alone PVC to provision the volume. The pod in which this EphemeralVolumeSource is embedded will be the owner of the PVC, i.e. the PVC will be deleted together with the pod.  The name of the PVC will be `<pod name>-<volume name>` where `<volume name>` is the name from the `PodSpec.Volumes` array entry. Pod validation will reject the pod if the concatenated name is not valid for a PVC (for example, too long).

            An existing PVC with that name that is not owned by the pod will *not* be used for the pod to avoid using an unrelated volume by mistake. Starting the pod is then blocked until the unrelated PVC is removed. If such a pre-created PVC is meant to be used by the pod, the PVC has to updated with an owner reference to the pod once the pod exists. Normally this should not be necessary, but it may be useful when manually reconstructing a broken cluster.

            This field is read-only and no changes will be made by Kubernetes to the PVC after it has been created.

            Required, must not be nil.
            """
            if self._in_context and value_or_callback is None:
                context = PersistentVolumeClaimTemplate.BuilderContext()
                context._parent_builder = self
                context._field_name = "volume_claim_template"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(PersistentVolumeClaimTemplate.builder())
                if isinstance(output, PersistentVolumeClaimTemplate.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("volume_claim_template", value)

    class BuilderContext(BuilderContextBase["EphemeralVolumeSource.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = EphemeralVolumeSource.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for EphemeralVolumeSource."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["EphemeralVolumeSource", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use EphemeralVolumeSource.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    volume_claim_template: Annotated[
        Optional[PersistentVolumeClaimTemplate], Field(alias="volumeClaimTemplate")
    ] = None
    """
    Will be used to create a stand-alone PVC to provision the volume. The pod in which this EphemeralVolumeSource is embedded will be the owner of the PVC, i.e. the PVC will be deleted together with the pod.  The name of the PVC will be `<pod name>-<volume name>` where `<volume name>` is the name from the `PodSpec.Volumes` array entry. Pod validation will reject the pod if the concatenated name is not valid for a PVC (for example, too long).

    An existing PVC with that name that is not owned by the pod will *not* be used for the pod to avoid using an unrelated volume by mistake. Starting the pod is then blocked until the unrelated PVC is removed. If such a pre-created PVC is meant to be used by the pod, the PVC has to updated with an owner reference to the pod once the pod exists. Normally this should not be necessary, but it may be useful when manually reconstructing a broken cluster.

    This field is read-only and no changes will be made by Kubernetes to the PVC after it has been created.

    Required, must not be nil.
    """


class Lifecycle(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["Lifecycle"]:
            return Lifecycle

        def build(self) -> "Lifecycle":
            return Lifecycle(**self._attrs)

        @overload
        def post_start(
            self, value_or_callback: Optional[LifecycleHandler], /
        ) -> "Lifecycle.Builder": ...

        @overload
        def post_start(
            self,
            value_or_callback: Callable[
                [LifecycleHandler.Builder], LifecycleHandler.Builder | LifecycleHandler
            ],
            /,
        ) -> "Lifecycle.Builder": ...

        @overload
        def post_start(
            self, value_or_callback: Never = ...
        ) -> "LifecycleHandler.BuilderContext": ...

        def post_start(self, value_or_callback=None, /):
            """
            PostStart is called immediately after a container is created. If the handler fails, the container is terminated and restarted according to its restart policy. Other management of the container blocks until the hook completes. More info: https://kubernetes.io/docs/concepts/containers/container-lifecycle-hooks/#container-hooks
            """
            if self._in_context and value_or_callback is None:
                context = LifecycleHandler.BuilderContext()
                context._parent_builder = self
                context._field_name = "post_start"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(LifecycleHandler.builder())
                if isinstance(output, LifecycleHandler.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("post_start", value)

        @overload
        def pre_stop(
            self, value_or_callback: Optional[LifecycleHandler], /
        ) -> "Lifecycle.Builder": ...

        @overload
        def pre_stop(
            self,
            value_or_callback: Callable[
                [LifecycleHandler.Builder], LifecycleHandler.Builder | LifecycleHandler
            ],
            /,
        ) -> "Lifecycle.Builder": ...

        @overload
        def pre_stop(self, value_or_callback: Never = ...) -> "LifecycleHandler.BuilderContext": ...

        def pre_stop(self, value_or_callback=None, /):
            """
            PreStop is called immediately before a container is terminated due to an API request or management event such as liveness/startup probe failure, preemption, resource contention, etc. The handler is not called if the container crashes or exits. The Pod's termination grace period countdown begins before the PreStop hook is executed. Regardless of the outcome of the handler, the container will eventually terminate within the Pod's termination grace period (unless delayed by finalizers). Other management of the container blocks until the hook completes or until the termination grace period is reached. More info: https://kubernetes.io/docs/concepts/containers/container-lifecycle-hooks/#container-hooks
            """
            if self._in_context and value_or_callback is None:
                context = LifecycleHandler.BuilderContext()
                context._parent_builder = self
                context._field_name = "pre_stop"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(LifecycleHandler.builder())
                if isinstance(output, LifecycleHandler.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("pre_stop", value)

    class BuilderContext(BuilderContextBase["Lifecycle.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = Lifecycle.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for Lifecycle."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["Lifecycle", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use Lifecycle.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    post_start: Annotated[Optional[LifecycleHandler], Field(alias="postStart")] = None
    """
    PostStart is called immediately after a container is created. If the handler fails, the container is terminated and restarted according to its restart policy. Other management of the container blocks until the hook completes. More info: https://kubernetes.io/docs/concepts/containers/container-lifecycle-hooks/#container-hooks
    """
    pre_stop: Annotated[Optional[LifecycleHandler], Field(alias="preStop")] = None
    """
    PreStop is called immediately before a container is terminated due to an API request or management event such as liveness/startup probe failure, preemption, resource contention, etc. The handler is not called if the container crashes or exits. The Pod's termination grace period countdown begins before the PreStop hook is executed. Regardless of the outcome of the handler, the container will eventually terminate within the Pod's termination grace period (unless delayed by finalizers). Other management of the container blocks until the hook completes or until the termination grace period is reached. More info: https://kubernetes.io/docs/concepts/containers/container-lifecycle-hooks/#container-hooks
    """


class Node(Resource):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["Node"]:
            return Node

        def build(self) -> "Node":
            return Node(**self._attrs)

        def api_version(self, value: Optional[Literal["v1"]], /) -> Self:
            """
            APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
            """
            return self._set("api_version", value)

        def kind(self, value: Optional[Literal["Node"]], /) -> Self:
            """
            Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
            """
            return self._set("kind", value)

        @overload
        def metadata(
            self, value_or_callback: Optional[apimachinery.ObjectMeta], /
        ) -> "Node.Builder": ...

        @overload
        def metadata(
            self,
            value_or_callback: Callable[
                [apimachinery.ObjectMeta.Builder],
                apimachinery.ObjectMeta.Builder | apimachinery.ObjectMeta,
            ],
            /,
        ) -> "Node.Builder": ...

        @overload
        def metadata(
            self, value_or_callback: Never = ...
        ) -> "apimachinery.ObjectMeta.BuilderContext": ...

        def metadata(self, value_or_callback=None, /):
            """
            Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
            """
            if self._in_context and value_or_callback is None:
                context = apimachinery.ObjectMeta.BuilderContext()
                context._parent_builder = self
                context._field_name = "metadata"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(apimachinery.ObjectMeta.builder())
                if isinstance(output, apimachinery.ObjectMeta.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("metadata", value)

        @overload
        def spec(self, value_or_callback: Optional[NodeSpec], /) -> "Node.Builder": ...

        @overload
        def spec(
            self,
            value_or_callback: Callable[[NodeSpec.Builder], NodeSpec.Builder | NodeSpec],
            /,
        ) -> "Node.Builder": ...

        @overload
        def spec(self, value_or_callback: Never = ...) -> "NodeSpec.BuilderContext": ...

        def spec(self, value_or_callback=None, /):
            """
            Spec defines the behavior of a node. https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
            """
            if self._in_context and value_or_callback is None:
                context = NodeSpec.BuilderContext()
                context._parent_builder = self
                context._field_name = "spec"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(NodeSpec.builder())
                if isinstance(output, NodeSpec.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("spec", value)

        @overload
        def status(self, value_or_callback: Optional[NodeStatus], /) -> "Node.Builder": ...

        @overload
        def status(
            self,
            value_or_callback: Callable[[NodeStatus.Builder], NodeStatus.Builder | NodeStatus],
            /,
        ) -> "Node.Builder": ...

        @overload
        def status(self, value_or_callback: Never = ...) -> "NodeStatus.BuilderContext": ...

        def status(self, value_or_callback=None, /):
            """
            Most recently observed status of the node. Populated by the system. Read-only. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
            """
            if self._in_context and value_or_callback is None:
                context = NodeStatus.BuilderContext()
                context._parent_builder = self
                context._field_name = "status"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(NodeStatus.builder())
                if isinstance(output, NodeStatus.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("status", value)

    class BuilderContext(BuilderContextBase["Node.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = Node.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for Node."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["Node", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use Node.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    api_version: Annotated[Optional[Literal["v1"]], Field(alias="apiVersion")] = "v1"
    """
    APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
    """
    kind: Optional[Literal["Node"]] = "Node"
    """
    Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
    """
    metadata: Optional[apimachinery.ObjectMeta] = None
    """
    Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
    """
    spec: Optional[NodeSpec] = None
    """
    Spec defines the behavior of a node. https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
    """
    status: Optional[NodeStatus] = None
    """
    Most recently observed status of the node. Populated by the system. Read-only. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
    """


NodeList = ResourceList["Node"]


class PersistentVolume(Resource):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["PersistentVolume"]:
            return PersistentVolume

        def build(self) -> "PersistentVolume":
            return PersistentVolume(**self._attrs)

        def api_version(self, value: Optional[Literal["v1"]], /) -> Self:
            """
            APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
            """
            return self._set("api_version", value)

        def kind(self, value: Optional[Literal["PersistentVolume"]], /) -> Self:
            """
            Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
            """
            return self._set("kind", value)

        @overload
        def metadata(
            self, value_or_callback: Optional[apimachinery.ObjectMeta], /
        ) -> "PersistentVolume.Builder": ...

        @overload
        def metadata(
            self,
            value_or_callback: Callable[
                [apimachinery.ObjectMeta.Builder],
                apimachinery.ObjectMeta.Builder | apimachinery.ObjectMeta,
            ],
            /,
        ) -> "PersistentVolume.Builder": ...

        @overload
        def metadata(
            self, value_or_callback: Never = ...
        ) -> "apimachinery.ObjectMeta.BuilderContext": ...

        def metadata(self, value_or_callback=None, /):
            """
            Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
            """
            if self._in_context and value_or_callback is None:
                context = apimachinery.ObjectMeta.BuilderContext()
                context._parent_builder = self
                context._field_name = "metadata"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(apimachinery.ObjectMeta.builder())
                if isinstance(output, apimachinery.ObjectMeta.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("metadata", value)

        @overload
        def spec(
            self, value_or_callback: Optional[PersistentVolumeSpec], /
        ) -> "PersistentVolume.Builder": ...

        @overload
        def spec(
            self,
            value_or_callback: Callable[
                [PersistentVolumeSpec.Builder],
                PersistentVolumeSpec.Builder | PersistentVolumeSpec,
            ],
            /,
        ) -> "PersistentVolume.Builder": ...

        @overload
        def spec(self, value_or_callback: Never = ...) -> "PersistentVolumeSpec.BuilderContext": ...

        def spec(self, value_or_callback=None, /):
            """
            spec defines a specification of a persistent volume owned by the cluster. Provisioned by an administrator. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#persistent-volumes
            """
            if self._in_context and value_or_callback is None:
                context = PersistentVolumeSpec.BuilderContext()
                context._parent_builder = self
                context._field_name = "spec"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(PersistentVolumeSpec.builder())
                if isinstance(output, PersistentVolumeSpec.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("spec", value)

        @overload
        def status(
            self, value_or_callback: Optional[PersistentVolumeStatus], /
        ) -> "PersistentVolume.Builder": ...

        @overload
        def status(
            self,
            value_or_callback: Callable[
                [PersistentVolumeStatus.Builder],
                PersistentVolumeStatus.Builder | PersistentVolumeStatus,
            ],
            /,
        ) -> "PersistentVolume.Builder": ...

        @overload
        def status(
            self, value_or_callback: Never = ...
        ) -> "PersistentVolumeStatus.BuilderContext": ...

        def status(self, value_or_callback=None, /):
            """
            status represents the current information/status for the persistent volume. Populated by the system. Read-only. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#persistent-volumes
            """
            if self._in_context and value_or_callback is None:
                context = PersistentVolumeStatus.BuilderContext()
                context._parent_builder = self
                context._field_name = "status"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(PersistentVolumeStatus.builder())
                if isinstance(output, PersistentVolumeStatus.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("status", value)

    class BuilderContext(BuilderContextBase["PersistentVolume.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = PersistentVolume.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for PersistentVolume."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["PersistentVolume", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use PersistentVolume.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    api_version: Annotated[Optional[Literal["v1"]], Field(alias="apiVersion")] = "v1"
    """
    APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
    """
    kind: Optional[Literal["PersistentVolume"]] = "PersistentVolume"
    """
    Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
    """
    metadata: Optional[apimachinery.ObjectMeta] = None
    """
    Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
    """
    spec: Optional[PersistentVolumeSpec] = None
    """
    spec defines a specification of a persistent volume owned by the cluster. Provisioned by an administrator. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#persistent-volumes
    """
    status: Optional[PersistentVolumeStatus] = None
    """
    status represents the current information/status for the persistent volume. Populated by the system. Read-only. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#persistent-volumes
    """


class PersistentVolumeClaim(Resource):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["PersistentVolumeClaim"]:
            return PersistentVolumeClaim

        def build(self) -> "PersistentVolumeClaim":
            return PersistentVolumeClaim(**self._attrs)

        def api_version(self, value: Optional[Literal["v1"]], /) -> Self:
            """
            APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
            """
            return self._set("api_version", value)

        def kind(self, value: Optional[Literal["PersistentVolumeClaim"]], /) -> Self:
            """
            Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
            """
            return self._set("kind", value)

        @overload
        def metadata(
            self, value_or_callback: Optional[apimachinery.ObjectMeta], /
        ) -> "PersistentVolumeClaim.Builder": ...

        @overload
        def metadata(
            self,
            value_or_callback: Callable[
                [apimachinery.ObjectMeta.Builder],
                apimachinery.ObjectMeta.Builder | apimachinery.ObjectMeta,
            ],
            /,
        ) -> "PersistentVolumeClaim.Builder": ...

        @overload
        def metadata(
            self, value_or_callback: Never = ...
        ) -> "apimachinery.ObjectMeta.BuilderContext": ...

        def metadata(self, value_or_callback=None, /):
            """
            Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
            """
            if self._in_context and value_or_callback is None:
                context = apimachinery.ObjectMeta.BuilderContext()
                context._parent_builder = self
                context._field_name = "metadata"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(apimachinery.ObjectMeta.builder())
                if isinstance(output, apimachinery.ObjectMeta.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("metadata", value)

        @overload
        def spec(
            self, value_or_callback: Optional[PersistentVolumeClaimSpec], /
        ) -> "PersistentVolumeClaim.Builder": ...

        @overload
        def spec(
            self,
            value_or_callback: Callable[
                [PersistentVolumeClaimSpec.Builder],
                PersistentVolumeClaimSpec.Builder | PersistentVolumeClaimSpec,
            ],
            /,
        ) -> "PersistentVolumeClaim.Builder": ...

        @overload
        def spec(
            self, value_or_callback: Never = ...
        ) -> "PersistentVolumeClaimSpec.BuilderContext": ...

        def spec(self, value_or_callback=None, /):
            """
            spec defines the desired characteristics of a volume requested by a pod author. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#persistentvolumeclaims
            """
            if self._in_context and value_or_callback is None:
                context = PersistentVolumeClaimSpec.BuilderContext()
                context._parent_builder = self
                context._field_name = "spec"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(PersistentVolumeClaimSpec.builder())
                if isinstance(output, PersistentVolumeClaimSpec.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("spec", value)

        @overload
        def status(
            self, value_or_callback: Optional[PersistentVolumeClaimStatus], /
        ) -> "PersistentVolumeClaim.Builder": ...

        @overload
        def status(
            self,
            value_or_callback: Callable[
                [PersistentVolumeClaimStatus.Builder],
                PersistentVolumeClaimStatus.Builder | PersistentVolumeClaimStatus,
            ],
            /,
        ) -> "PersistentVolumeClaim.Builder": ...

        @overload
        def status(
            self, value_or_callback: Never = ...
        ) -> "PersistentVolumeClaimStatus.BuilderContext": ...

        def status(self, value_or_callback=None, /):
            """
            status represents the current information/status of a persistent volume claim. Read-only. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#persistentvolumeclaims
            """
            if self._in_context and value_or_callback is None:
                context = PersistentVolumeClaimStatus.BuilderContext()
                context._parent_builder = self
                context._field_name = "status"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(PersistentVolumeClaimStatus.builder())
                if isinstance(output, PersistentVolumeClaimStatus.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("status", value)

    class BuilderContext(BuilderContextBase["PersistentVolumeClaim.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = PersistentVolumeClaim.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for PersistentVolumeClaim."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["PersistentVolumeClaim", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use PersistentVolumeClaim.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    api_version: Annotated[Optional[Literal["v1"]], Field(alias="apiVersion")] = "v1"
    """
    APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
    """
    kind: Optional[Literal["PersistentVolumeClaim"]] = "PersistentVolumeClaim"
    """
    Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
    """
    metadata: Optional[apimachinery.ObjectMeta] = None
    """
    Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
    """
    spec: Optional[PersistentVolumeClaimSpec] = None
    """
    spec defines the desired characteristics of a volume requested by a pod author. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#persistentvolumeclaims
    """
    status: Optional[PersistentVolumeClaimStatus] = None
    """
    status represents the current information/status of a persistent volume claim. Read-only. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#persistentvolumeclaims
    """


PersistentVolumeClaimList = ResourceList["PersistentVolumeClaim"]


PersistentVolumeList = ResourceList["PersistentVolume"]


class PodAffinity(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["PodAffinity"]:
            return PodAffinity

        def build(self) -> "PodAffinity":
            return PodAffinity(**self._attrs)

        @overload
        def preferred_during_scheduling_ignored_during_execution(
            self, value_or_callback: List[WeightedPodAffinityTerm], /
        ) -> "PodAffinity.Builder": ...

        @overload
        def preferred_during_scheduling_ignored_during_execution(
            self,
            value_or_callback: Callable[
                [GenericListBuilder[WeightedPodAffinityTerm, WeightedPodAffinityTerm.Builder]],
                GenericListBuilder[WeightedPodAffinityTerm, WeightedPodAffinityTerm.Builder]
                | List[WeightedPodAffinityTerm],
            ],
            /,
        ) -> "PodAffinity.Builder": ...

        @overload
        def preferred_during_scheduling_ignored_during_execution(
            self, value_or_callback: Never = ...
        ) -> ListBuilderContext[WeightedPodAffinityTerm.Builder]: ...

        def preferred_during_scheduling_ignored_during_execution(self, value_or_callback=None, /):
            """
            The scheduler will prefer to schedule pods to nodes that satisfy the affinity expressions specified by this field, but it may choose a node that violates one or more of the expressions. The node that is most preferred is the one with the greatest sum of weights, i.e. for each node that meets all of the scheduling requirements (resource request, requiredDuringScheduling affinity expressions, etc.), compute a sum by iterating through the elements of this field and adding "weight" to the sum if the node has pods which matches the corresponding podAffinityTerm; the node(s) with the highest sum are the most preferred.
            """
            if self._in_context and value_or_callback is None:
                context = ListBuilderContext[WeightedPodAffinityTerm.Builder]()
                context._parent_builder = self
                context._field_name = "preferred_during_scheduling_ignored_during_execution"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(WeightedPodAffinityTerm.list_builder())
                if isinstance(output, GenericListBuilder):
                    value = output.build()
                else:
                    value = output
            return self._set("preferred_during_scheduling_ignored_during_execution", value)

        @overload
        def required_during_scheduling_ignored_during_execution(
            self, value_or_callback: List[PodAffinityTerm], /
        ) -> "PodAffinity.Builder": ...

        @overload
        def required_during_scheduling_ignored_during_execution(
            self,
            value_or_callback: Callable[
                [GenericListBuilder[PodAffinityTerm, PodAffinityTerm.Builder]],
                GenericListBuilder[PodAffinityTerm, PodAffinityTerm.Builder]
                | List[PodAffinityTerm],
            ],
            /,
        ) -> "PodAffinity.Builder": ...

        @overload
        def required_during_scheduling_ignored_during_execution(
            self, value_or_callback: Never = ...
        ) -> ListBuilderContext[PodAffinityTerm.Builder]: ...

        def required_during_scheduling_ignored_during_execution(self, value_or_callback=None, /):
            """
            If the affinity requirements specified by this field are not met at scheduling time, the pod will not be scheduled onto the node. If the affinity requirements specified by this field cease to be met at some point during pod execution (e.g. due to a pod label update), the system may or may not try to eventually evict the pod from its node. When there are multiple elements, the lists of nodes corresponding to each podAffinityTerm are intersected, i.e. all terms must be satisfied.
            """
            if self._in_context and value_or_callback is None:
                context = ListBuilderContext[PodAffinityTerm.Builder]()
                context._parent_builder = self
                context._field_name = "required_during_scheduling_ignored_during_execution"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(PodAffinityTerm.list_builder())
                if isinstance(output, GenericListBuilder):
                    value = output.build()
                else:
                    value = output
            return self._set("required_during_scheduling_ignored_during_execution", value)

    class BuilderContext(BuilderContextBase["PodAffinity.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = PodAffinity.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for PodAffinity."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["PodAffinity", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use PodAffinity.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    preferred_during_scheduling_ignored_during_execution: Annotated[
        Optional[List[WeightedPodAffinityTerm]],
        Field(alias="preferredDuringSchedulingIgnoredDuringExecution"),
    ] = None
    """
    The scheduler will prefer to schedule pods to nodes that satisfy the affinity expressions specified by this field, but it may choose a node that violates one or more of the expressions. The node that is most preferred is the one with the greatest sum of weights, i.e. for each node that meets all of the scheduling requirements (resource request, requiredDuringScheduling affinity expressions, etc.), compute a sum by iterating through the elements of this field and adding "weight" to the sum if the node has pods which matches the corresponding podAffinityTerm; the node(s) with the highest sum are the most preferred.
    """
    required_during_scheduling_ignored_during_execution: Annotated[
        Optional[List[PodAffinityTerm]],
        Field(alias="requiredDuringSchedulingIgnoredDuringExecution"),
    ] = None
    """
    If the affinity requirements specified by this field are not met at scheduling time, the pod will not be scheduled onto the node. If the affinity requirements specified by this field cease to be met at some point during pod execution (e.g. due to a pod label update), the system may or may not try to eventually evict the pod from its node. When there are multiple elements, the lists of nodes corresponding to each podAffinityTerm are intersected, i.e. all terms must be satisfied.
    """


class PodAntiAffinity(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["PodAntiAffinity"]:
            return PodAntiAffinity

        def build(self) -> "PodAntiAffinity":
            return PodAntiAffinity(**self._attrs)

        @overload
        def preferred_during_scheduling_ignored_during_execution(
            self, value_or_callback: List[WeightedPodAffinityTerm], /
        ) -> "PodAntiAffinity.Builder": ...

        @overload
        def preferred_during_scheduling_ignored_during_execution(
            self,
            value_or_callback: Callable[
                [GenericListBuilder[WeightedPodAffinityTerm, WeightedPodAffinityTerm.Builder]],
                GenericListBuilder[WeightedPodAffinityTerm, WeightedPodAffinityTerm.Builder]
                | List[WeightedPodAffinityTerm],
            ],
            /,
        ) -> "PodAntiAffinity.Builder": ...

        @overload
        def preferred_during_scheduling_ignored_during_execution(
            self, value_or_callback: Never = ...
        ) -> ListBuilderContext[WeightedPodAffinityTerm.Builder]: ...

        def preferred_during_scheduling_ignored_during_execution(self, value_or_callback=None, /):
            """
            The scheduler will prefer to schedule pods to nodes that satisfy the anti-affinity expressions specified by this field, but it may choose a node that violates one or more of the expressions. The node that is most preferred is the one with the greatest sum of weights, i.e. for each node that meets all of the scheduling requirements (resource request, requiredDuringScheduling anti-affinity expressions, etc.), compute a sum by iterating through the elements of this field and adding "weight" to the sum if the node has pods which matches the corresponding podAffinityTerm; the node(s) with the highest sum are the most preferred.
            """
            if self._in_context and value_or_callback is None:
                context = ListBuilderContext[WeightedPodAffinityTerm.Builder]()
                context._parent_builder = self
                context._field_name = "preferred_during_scheduling_ignored_during_execution"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(WeightedPodAffinityTerm.list_builder())
                if isinstance(output, GenericListBuilder):
                    value = output.build()
                else:
                    value = output
            return self._set("preferred_during_scheduling_ignored_during_execution", value)

        @overload
        def required_during_scheduling_ignored_during_execution(
            self, value_or_callback: List[PodAffinityTerm], /
        ) -> "PodAntiAffinity.Builder": ...

        @overload
        def required_during_scheduling_ignored_during_execution(
            self,
            value_or_callback: Callable[
                [GenericListBuilder[PodAffinityTerm, PodAffinityTerm.Builder]],
                GenericListBuilder[PodAffinityTerm, PodAffinityTerm.Builder]
                | List[PodAffinityTerm],
            ],
            /,
        ) -> "PodAntiAffinity.Builder": ...

        @overload
        def required_during_scheduling_ignored_during_execution(
            self, value_or_callback: Never = ...
        ) -> ListBuilderContext[PodAffinityTerm.Builder]: ...

        def required_during_scheduling_ignored_during_execution(self, value_or_callback=None, /):
            """
            If the anti-affinity requirements specified by this field are not met at scheduling time, the pod will not be scheduled onto the node. If the anti-affinity requirements specified by this field cease to be met at some point during pod execution (e.g. due to a pod label update), the system may or may not try to eventually evict the pod from its node. When there are multiple elements, the lists of nodes corresponding to each podAffinityTerm are intersected, i.e. all terms must be satisfied.
            """
            if self._in_context and value_or_callback is None:
                context = ListBuilderContext[PodAffinityTerm.Builder]()
                context._parent_builder = self
                context._field_name = "required_during_scheduling_ignored_during_execution"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(PodAffinityTerm.list_builder())
                if isinstance(output, GenericListBuilder):
                    value = output.build()
                else:
                    value = output
            return self._set("required_during_scheduling_ignored_during_execution", value)

    class BuilderContext(BuilderContextBase["PodAntiAffinity.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = PodAntiAffinity.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for PodAntiAffinity."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["PodAntiAffinity", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use PodAntiAffinity.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    preferred_during_scheduling_ignored_during_execution: Annotated[
        Optional[List[WeightedPodAffinityTerm]],
        Field(alias="preferredDuringSchedulingIgnoredDuringExecution"),
    ] = None
    """
    The scheduler will prefer to schedule pods to nodes that satisfy the anti-affinity expressions specified by this field, but it may choose a node that violates one or more of the expressions. The node that is most preferred is the one with the greatest sum of weights, i.e. for each node that meets all of the scheduling requirements (resource request, requiredDuringScheduling anti-affinity expressions, etc.), compute a sum by iterating through the elements of this field and adding "weight" to the sum if the node has pods which matches the corresponding podAffinityTerm; the node(s) with the highest sum are the most preferred.
    """
    required_during_scheduling_ignored_during_execution: Annotated[
        Optional[List[PodAffinityTerm]],
        Field(alias="requiredDuringSchedulingIgnoredDuringExecution"),
    ] = None
    """
    If the anti-affinity requirements specified by this field are not met at scheduling time, the pod will not be scheduled onto the node. If the anti-affinity requirements specified by this field cease to be met at some point during pod execution (e.g. due to a pod label update), the system may or may not try to eventually evict the pod from its node. When there are multiple elements, the lists of nodes corresponding to each podAffinityTerm are intersected, i.e. all terms must be satisfied.
    """


class ResourceQuota(Resource):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["ResourceQuota"]:
            return ResourceQuota

        def build(self) -> "ResourceQuota":
            return ResourceQuota(**self._attrs)

        def api_version(self, value: Optional[Literal["v1"]], /) -> Self:
            """
            APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
            """
            return self._set("api_version", value)

        def kind(self, value: Optional[Literal["ResourceQuota"]], /) -> Self:
            """
            Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
            """
            return self._set("kind", value)

        @overload
        def metadata(
            self, value_or_callback: Optional[apimachinery.ObjectMeta], /
        ) -> "ResourceQuota.Builder": ...

        @overload
        def metadata(
            self,
            value_or_callback: Callable[
                [apimachinery.ObjectMeta.Builder],
                apimachinery.ObjectMeta.Builder | apimachinery.ObjectMeta,
            ],
            /,
        ) -> "ResourceQuota.Builder": ...

        @overload
        def metadata(
            self, value_or_callback: Never = ...
        ) -> "apimachinery.ObjectMeta.BuilderContext": ...

        def metadata(self, value_or_callback=None, /):
            """
            Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
            """
            if self._in_context and value_or_callback is None:
                context = apimachinery.ObjectMeta.BuilderContext()
                context._parent_builder = self
                context._field_name = "metadata"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(apimachinery.ObjectMeta.builder())
                if isinstance(output, apimachinery.ObjectMeta.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("metadata", value)

        @overload
        def spec(
            self, value_or_callback: Optional[ResourceQuotaSpec], /
        ) -> "ResourceQuota.Builder": ...

        @overload
        def spec(
            self,
            value_or_callback: Callable[
                [ResourceQuotaSpec.Builder],
                ResourceQuotaSpec.Builder | ResourceQuotaSpec,
            ],
            /,
        ) -> "ResourceQuota.Builder": ...

        @overload
        def spec(self, value_or_callback: Never = ...) -> "ResourceQuotaSpec.BuilderContext": ...

        def spec(self, value_or_callback=None, /):
            """
            Spec defines the desired quota. https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
            """
            if self._in_context and value_or_callback is None:
                context = ResourceQuotaSpec.BuilderContext()
                context._parent_builder = self
                context._field_name = "spec"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(ResourceQuotaSpec.builder())
                if isinstance(output, ResourceQuotaSpec.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("spec", value)

        @overload
        def status(
            self, value_or_callback: Optional[ResourceQuotaStatus], /
        ) -> "ResourceQuota.Builder": ...

        @overload
        def status(
            self,
            value_or_callback: Callable[
                [ResourceQuotaStatus.Builder],
                ResourceQuotaStatus.Builder | ResourceQuotaStatus,
            ],
            /,
        ) -> "ResourceQuota.Builder": ...

        @overload
        def status(
            self, value_or_callback: Never = ...
        ) -> "ResourceQuotaStatus.BuilderContext": ...

        def status(self, value_or_callback=None, /):
            """
            Status defines the actual enforced quota and its current usage. https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
            """
            if self._in_context and value_or_callback is None:
                context = ResourceQuotaStatus.BuilderContext()
                context._parent_builder = self
                context._field_name = "status"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(ResourceQuotaStatus.builder())
                if isinstance(output, ResourceQuotaStatus.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("status", value)

    class BuilderContext(BuilderContextBase["ResourceQuota.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = ResourceQuota.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for ResourceQuota."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["ResourceQuota", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use ResourceQuota.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    api_version: Annotated[Optional[Literal["v1"]], Field(alias="apiVersion")] = "v1"
    """
    APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
    """
    kind: Optional[Literal["ResourceQuota"]] = "ResourceQuota"
    """
    Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
    """
    metadata: Optional[apimachinery.ObjectMeta] = None
    """
    Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
    """
    spec: Optional[ResourceQuotaSpec] = None
    """
    Spec defines the desired quota. https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
    """
    status: Optional[ResourceQuotaStatus] = None
    """
    Status defines the actual enforced quota and its current usage. https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
    """


ResourceQuotaList = ResourceList["ResourceQuota"]


class Service(Resource):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["Service"]:
            return Service

        def build(self) -> "Service":
            return Service(**self._attrs)

        def api_version(self, value: Optional[Literal["v1"]], /) -> Self:
            """
            APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
            """
            return self._set("api_version", value)

        def kind(self, value: Optional[Literal["Service"]], /) -> Self:
            """
            Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
            """
            return self._set("kind", value)

        @overload
        def metadata(
            self, value_or_callback: Optional[apimachinery.ObjectMeta], /
        ) -> "Service.Builder": ...

        @overload
        def metadata(
            self,
            value_or_callback: Callable[
                [apimachinery.ObjectMeta.Builder],
                apimachinery.ObjectMeta.Builder | apimachinery.ObjectMeta,
            ],
            /,
        ) -> "Service.Builder": ...

        @overload
        def metadata(
            self, value_or_callback: Never = ...
        ) -> "apimachinery.ObjectMeta.BuilderContext": ...

        def metadata(self, value_or_callback=None, /):
            """
            Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
            """
            if self._in_context and value_or_callback is None:
                context = apimachinery.ObjectMeta.BuilderContext()
                context._parent_builder = self
                context._field_name = "metadata"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(apimachinery.ObjectMeta.builder())
                if isinstance(output, apimachinery.ObjectMeta.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("metadata", value)

        @overload
        def spec(self, value_or_callback: Optional[ServiceSpec], /) -> "Service.Builder": ...

        @overload
        def spec(
            self,
            value_or_callback: Callable[[ServiceSpec.Builder], ServiceSpec.Builder | ServiceSpec],
            /,
        ) -> "Service.Builder": ...

        @overload
        def spec(self, value_or_callback: Never = ...) -> "ServiceSpec.BuilderContext": ...

        def spec(self, value_or_callback=None, /):
            """
            Spec defines the behavior of a service. https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
            """
            if self._in_context and value_or_callback is None:
                context = ServiceSpec.BuilderContext()
                context._parent_builder = self
                context._field_name = "spec"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(ServiceSpec.builder())
                if isinstance(output, ServiceSpec.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("spec", value)

        @overload
        def status(self, value_or_callback: Optional[ServiceStatus], /) -> "Service.Builder": ...

        @overload
        def status(
            self,
            value_or_callback: Callable[
                [ServiceStatus.Builder], ServiceStatus.Builder | ServiceStatus
            ],
            /,
        ) -> "Service.Builder": ...

        @overload
        def status(self, value_or_callback: Never = ...) -> "ServiceStatus.BuilderContext": ...

        def status(self, value_or_callback=None, /):
            """
            Most recently observed status of the service. Populated by the system. Read-only. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
            """
            if self._in_context and value_or_callback is None:
                context = ServiceStatus.BuilderContext()
                context._parent_builder = self
                context._field_name = "status"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(ServiceStatus.builder())
                if isinstance(output, ServiceStatus.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("status", value)

    class BuilderContext(BuilderContextBase["Service.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = Service.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for Service."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["Service", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use Service.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    api_version: Annotated[Optional[Literal["v1"]], Field(alias="apiVersion")] = "v1"
    """
    APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
    """
    kind: Optional[Literal["Service"]] = "Service"
    """
    Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
    """
    metadata: Optional[apimachinery.ObjectMeta] = None
    """
    Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
    """
    spec: Optional[ServiceSpec] = None
    """
    Spec defines the behavior of a service. https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
    """
    status: Optional[ServiceStatus] = None
    """
    Most recently observed status of the service. Populated by the system. Read-only. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
    """


ServiceList = ResourceList["Service"]


class VolumeProjection(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["VolumeProjection"]:
            return VolumeProjection

        def build(self) -> "VolumeProjection":
            return VolumeProjection(**self._attrs)

        @overload
        def cluster_trust_bundle(
            self, value_or_callback: Optional[ClusterTrustBundleProjection], /
        ) -> "VolumeProjection.Builder": ...

        @overload
        def cluster_trust_bundle(
            self,
            value_or_callback: Callable[
                [ClusterTrustBundleProjection.Builder],
                ClusterTrustBundleProjection.Builder | ClusterTrustBundleProjection,
            ],
            /,
        ) -> "VolumeProjection.Builder": ...

        @overload
        def cluster_trust_bundle(
            self, value_or_callback: Never = ...
        ) -> "ClusterTrustBundleProjection.BuilderContext": ...

        def cluster_trust_bundle(self, value_or_callback=None, /):
            """
            ClusterTrustBundle allows a pod to access the `.spec.trustBundle` field of ClusterTrustBundle objects in an auto-updating file.

            Alpha, gated by the ClusterTrustBundleProjection feature gate.

            ClusterTrustBundle objects can either be selected by name, or by the combination of signer name and a label selector.

            Kubelet performs aggressive normalization of the PEM contents written into the pod filesystem.  Esoteric PEM features such as inter-block comments and block headers are stripped.  Certificates are deduplicated. The ordering of certificates within the file is arbitrary, and Kubelet may change the order over time.
            """
            if self._in_context and value_or_callback is None:
                context = ClusterTrustBundleProjection.BuilderContext()
                context._parent_builder = self
                context._field_name = "cluster_trust_bundle"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(ClusterTrustBundleProjection.builder())
                if isinstance(output, ClusterTrustBundleProjection.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("cluster_trust_bundle", value)

        @overload
        def config_map(
            self, value_or_callback: Optional[ConfigMapProjection], /
        ) -> "VolumeProjection.Builder": ...

        @overload
        def config_map(
            self,
            value_or_callback: Callable[
                [ConfigMapProjection.Builder],
                ConfigMapProjection.Builder | ConfigMapProjection,
            ],
            /,
        ) -> "VolumeProjection.Builder": ...

        @overload
        def config_map(
            self, value_or_callback: Never = ...
        ) -> "ConfigMapProjection.BuilderContext": ...

        def config_map(self, value_or_callback=None, /):
            """
            configMap information about the configMap data to project
            """
            if self._in_context and value_or_callback is None:
                context = ConfigMapProjection.BuilderContext()
                context._parent_builder = self
                context._field_name = "config_map"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(ConfigMapProjection.builder())
                if isinstance(output, ConfigMapProjection.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("config_map", value)

        @overload
        def downward_api(
            self, value_or_callback: Optional[DownwardAPIProjection], /
        ) -> "VolumeProjection.Builder": ...

        @overload
        def downward_api(
            self,
            value_or_callback: Callable[
                [DownwardAPIProjection.Builder],
                DownwardAPIProjection.Builder | DownwardAPIProjection,
            ],
            /,
        ) -> "VolumeProjection.Builder": ...

        @overload
        def downward_api(
            self, value_or_callback: Never = ...
        ) -> "DownwardAPIProjection.BuilderContext": ...

        def downward_api(self, value_or_callback=None, /):
            """
            downwardAPI information about the downwardAPI data to project
            """
            if self._in_context and value_or_callback is None:
                context = DownwardAPIProjection.BuilderContext()
                context._parent_builder = self
                context._field_name = "downward_api"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(DownwardAPIProjection.builder())
                if isinstance(output, DownwardAPIProjection.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("downward_api", value)

        @overload
        def secret(
            self, value_or_callback: Optional[SecretProjection], /
        ) -> "VolumeProjection.Builder": ...

        @overload
        def secret(
            self,
            value_or_callback: Callable[
                [SecretProjection.Builder], SecretProjection.Builder | SecretProjection
            ],
            /,
        ) -> "VolumeProjection.Builder": ...

        @overload
        def secret(self, value_or_callback: Never = ...) -> "SecretProjection.BuilderContext": ...

        def secret(self, value_or_callback=None, /):
            """
            secret information about the secret data to project
            """
            if self._in_context and value_or_callback is None:
                context = SecretProjection.BuilderContext()
                context._parent_builder = self
                context._field_name = "secret"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(SecretProjection.builder())
                if isinstance(output, SecretProjection.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("secret", value)

        @overload
        def service_account_token(
            self, value_or_callback: Optional[ServiceAccountTokenProjection], /
        ) -> "VolumeProjection.Builder": ...

        @overload
        def service_account_token(
            self,
            value_or_callback: Callable[
                [ServiceAccountTokenProjection.Builder],
                ServiceAccountTokenProjection.Builder | ServiceAccountTokenProjection,
            ],
            /,
        ) -> "VolumeProjection.Builder": ...

        @overload
        def service_account_token(
            self, value_or_callback: Never = ...
        ) -> "ServiceAccountTokenProjection.BuilderContext": ...

        def service_account_token(self, value_or_callback=None, /):
            """
            serviceAccountToken is information about the serviceAccountToken data to project
            """
            if self._in_context and value_or_callback is None:
                context = ServiceAccountTokenProjection.BuilderContext()
                context._parent_builder = self
                context._field_name = "service_account_token"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(ServiceAccountTokenProjection.builder())
                if isinstance(output, ServiceAccountTokenProjection.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("service_account_token", value)

    class BuilderContext(BuilderContextBase["VolumeProjection.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = VolumeProjection.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for VolumeProjection."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["VolumeProjection", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use VolumeProjection.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    cluster_trust_bundle: Annotated[
        Optional[ClusterTrustBundleProjection], Field(alias="clusterTrustBundle")
    ] = None
    """
    ClusterTrustBundle allows a pod to access the `.spec.trustBundle` field of ClusterTrustBundle objects in an auto-updating file.

    Alpha, gated by the ClusterTrustBundleProjection feature gate.

    ClusterTrustBundle objects can either be selected by name, or by the combination of signer name and a label selector.

    Kubelet performs aggressive normalization of the PEM contents written into the pod filesystem.  Esoteric PEM features such as inter-block comments and block headers are stripped.  Certificates are deduplicated. The ordering of certificates within the file is arbitrary, and Kubelet may change the order over time.
    """
    config_map: Annotated[Optional[ConfigMapProjection], Field(alias="configMap")] = None
    """
    configMap information about the configMap data to project
    """
    downward_api: Annotated[Optional[DownwardAPIProjection], Field(alias="downwardAPI")] = None
    """
    downwardAPI information about the downwardAPI data to project
    """
    secret: Optional[SecretProjection] = None
    """
    secret information about the secret data to project
    """
    service_account_token: Annotated[
        Optional[ServiceAccountTokenProjection], Field(alias="serviceAccountToken")
    ] = None
    """
    serviceAccountToken is information about the serviceAccountToken data to project
    """


class Affinity(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["Affinity"]:
            return Affinity

        def build(self) -> "Affinity":
            return Affinity(**self._attrs)

        @overload
        def node_affinity(
            self, value_or_callback: Optional[NodeAffinity], /
        ) -> "Affinity.Builder": ...

        @overload
        def node_affinity(
            self,
            value_or_callback: Callable[
                [NodeAffinity.Builder], NodeAffinity.Builder | NodeAffinity
            ],
            /,
        ) -> "Affinity.Builder": ...

        @overload
        def node_affinity(
            self, value_or_callback: Never = ...
        ) -> "NodeAffinity.BuilderContext": ...

        def node_affinity(self, value_or_callback=None, /):
            """
            Describes node affinity scheduling rules for the pod.
            """
            if self._in_context and value_or_callback is None:
                context = NodeAffinity.BuilderContext()
                context._parent_builder = self
                context._field_name = "node_affinity"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(NodeAffinity.builder())
                if isinstance(output, NodeAffinity.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("node_affinity", value)

        @overload
        def pod_affinity(
            self, value_or_callback: Optional[PodAffinity], /
        ) -> "Affinity.Builder": ...

        @overload
        def pod_affinity(
            self,
            value_or_callback: Callable[[PodAffinity.Builder], PodAffinity.Builder | PodAffinity],
            /,
        ) -> "Affinity.Builder": ...

        @overload
        def pod_affinity(self, value_or_callback: Never = ...) -> "PodAffinity.BuilderContext": ...

        def pod_affinity(self, value_or_callback=None, /):
            """
            Describes pod affinity scheduling rules (e.g. co-locate this pod in the same node, zone, etc. as some other pod(s)).
            """
            if self._in_context and value_or_callback is None:
                context = PodAffinity.BuilderContext()
                context._parent_builder = self
                context._field_name = "pod_affinity"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(PodAffinity.builder())
                if isinstance(output, PodAffinity.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("pod_affinity", value)

        @overload
        def pod_anti_affinity(
            self, value_or_callback: Optional[PodAntiAffinity], /
        ) -> "Affinity.Builder": ...

        @overload
        def pod_anti_affinity(
            self,
            value_or_callback: Callable[
                [PodAntiAffinity.Builder], PodAntiAffinity.Builder | PodAntiAffinity
            ],
            /,
        ) -> "Affinity.Builder": ...

        @overload
        def pod_anti_affinity(
            self, value_or_callback: Never = ...
        ) -> "PodAntiAffinity.BuilderContext": ...

        def pod_anti_affinity(self, value_or_callback=None, /):
            """
            Describes pod anti-affinity scheduling rules (e.g. avoid putting this pod in the same node, zone, etc. as some other pod(s)).
            """
            if self._in_context and value_or_callback is None:
                context = PodAntiAffinity.BuilderContext()
                context._parent_builder = self
                context._field_name = "pod_anti_affinity"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(PodAntiAffinity.builder())
                if isinstance(output, PodAntiAffinity.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("pod_anti_affinity", value)

    class BuilderContext(BuilderContextBase["Affinity.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = Affinity.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for Affinity."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["Affinity", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use Affinity.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    node_affinity: Annotated[Optional[NodeAffinity], Field(alias="nodeAffinity")] = None
    """
    Describes node affinity scheduling rules for the pod.
    """
    pod_affinity: Annotated[Optional[PodAffinity], Field(alias="podAffinity")] = None
    """
    Describes pod affinity scheduling rules (e.g. co-locate this pod in the same node, zone, etc. as some other pod(s)).
    """
    pod_anti_affinity: Annotated[Optional[PodAntiAffinity], Field(alias="podAntiAffinity")] = None
    """
    Describes pod anti-affinity scheduling rules (e.g. avoid putting this pod in the same node, zone, etc. as some other pod(s)).
    """


class Container(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["Container"]:
            return Container

        def build(self) -> "Container":
            return Container(**self._attrs)

        def args(self, value: Optional[List[str]], /) -> Self:
            """
            Arguments to the entrypoint. The container image's CMD is used if this is not provided. Variable references $(VAR_NAME) are expanded using the container's environment. If a variable cannot be resolved, the reference in the input string will be unchanged. Double $$ are reduced to a single $, which allows for escaping the $(VAR_NAME) syntax: i.e. "$$(VAR_NAME)" will produce the string literal "$(VAR_NAME)". Escaped references will never be expanded, regardless of whether the variable exists or not. Cannot be updated. More info: https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#running-a-command-in-a-shell
            """
            return self._set("args", value)

        def command(self, value: Optional[List[str]], /) -> Self:
            """
            Entrypoint array. Not executed within a shell. The container image's ENTRYPOINT is used if this is not provided. Variable references $(VAR_NAME) are expanded using the container's environment. If a variable cannot be resolved, the reference in the input string will be unchanged. Double $$ are reduced to a single $, which allows for escaping the $(VAR_NAME) syntax: i.e. "$$(VAR_NAME)" will produce the string literal "$(VAR_NAME)". Escaped references will never be expanded, regardless of whether the variable exists or not. Cannot be updated. More info: https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#running-a-command-in-a-shell
            """
            return self._set("command", value)

        @overload
        def env(self, value_or_callback: List[EnvVar], /) -> "Container.Builder": ...

        @overload
        def env(
            self,
            value_or_callback: Callable[
                [GenericListBuilder[EnvVar, EnvVar.Builder]],
                GenericListBuilder[EnvVar, EnvVar.Builder] | List[EnvVar],
            ],
            /,
        ) -> "Container.Builder": ...

        @overload
        def env(self, value_or_callback: Never = ...) -> ListBuilderContext[EnvVar.Builder]: ...

        def env(self, value_or_callback=None, /):
            """
            List of environment variables to set in the container. Cannot be updated.
            """
            if self._in_context and value_or_callback is None:
                context = ListBuilderContext[EnvVar.Builder]()
                context._parent_builder = self
                context._field_name = "env"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(EnvVar.list_builder())
                if isinstance(output, GenericListBuilder):
                    value = output.build()
                else:
                    value = output
            return self._set("env", value)

        @overload
        def env_from(self, value_or_callback: List[EnvFromSource], /) -> "Container.Builder": ...

        @overload
        def env_from(
            self,
            value_or_callback: Callable[
                [GenericListBuilder[EnvFromSource, EnvFromSource.Builder]],
                GenericListBuilder[EnvFromSource, EnvFromSource.Builder] | List[EnvFromSource],
            ],
            /,
        ) -> "Container.Builder": ...

        @overload
        def env_from(
            self, value_or_callback: Never = ...
        ) -> ListBuilderContext[EnvFromSource.Builder]: ...

        def env_from(self, value_or_callback=None, /):
            """
            List of sources to populate environment variables in the container. The keys defined within a source must be a C_IDENTIFIER. All invalid keys will be reported as an event when the container is starting. When a key exists in multiple sources, the value associated with the last source will take precedence. Values defined by an Env with a duplicate key will take precedence. Cannot be updated.
            """
            if self._in_context and value_or_callback is None:
                context = ListBuilderContext[EnvFromSource.Builder]()
                context._parent_builder = self
                context._field_name = "env_from"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(EnvFromSource.list_builder())
                if isinstance(output, GenericListBuilder):
                    value = output.build()
                else:
                    value = output
            return self._set("env_from", value)

        def image(self, value: Optional[str], /) -> Self:
            """
            Container image name. More info: https://kubernetes.io/docs/concepts/containers/images This field is optional to allow higher level config management to default or override container images in workload controllers like Deployments and StatefulSets.
            """
            return self._set("image", value)

        def image_pull_policy(self, value: Optional[str], /) -> Self:
            """
            Image pull policy. One of Always, Never, IfNotPresent. Defaults to Always if :latest tag is specified, or IfNotPresent otherwise. Cannot be updated. More info: https://kubernetes.io/docs/concepts/containers/images#updating-images
            """
            return self._set("image_pull_policy", value)

        @overload
        def lifecycle(self, value_or_callback: Optional[Lifecycle], /) -> "Container.Builder": ...

        @overload
        def lifecycle(
            self,
            value_or_callback: Callable[[Lifecycle.Builder], Lifecycle.Builder | Lifecycle],
            /,
        ) -> "Container.Builder": ...

        @overload
        def lifecycle(self, value_or_callback: Never = ...) -> "Lifecycle.BuilderContext": ...

        def lifecycle(self, value_or_callback=None, /):
            """
            Actions that the management system should take in response to container lifecycle events. Cannot be updated.
            """
            if self._in_context and value_or_callback is None:
                context = Lifecycle.BuilderContext()
                context._parent_builder = self
                context._field_name = "lifecycle"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(Lifecycle.builder())
                if isinstance(output, Lifecycle.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("lifecycle", value)

        @overload
        def liveness_probe(self, value_or_callback: Optional[Probe], /) -> "Container.Builder": ...

        @overload
        def liveness_probe(
            self, value_or_callback: Callable[[Probe.Builder], Probe.Builder | Probe], /
        ) -> "Container.Builder": ...

        @overload
        def liveness_probe(self, value_or_callback: Never = ...) -> "Probe.BuilderContext": ...

        def liveness_probe(self, value_or_callback=None, /):
            """
            Periodic probe of container liveness. Container will be restarted if the probe fails. Cannot be updated. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes
            """
            if self._in_context and value_or_callback is None:
                context = Probe.BuilderContext()
                context._parent_builder = self
                context._field_name = "liveness_probe"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(Probe.builder())
                if isinstance(output, Probe.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("liveness_probe", value)

        def name(self, value: str, /) -> Self:
            """
            Name of the container specified as a DNS_LABEL. Each container in a pod must have a unique name (DNS_LABEL). Cannot be updated.
            """
            return self._set("name", value)

        @overload
        def ports(self, value_or_callback: List[ContainerPort], /) -> "Container.Builder": ...

        @overload
        def ports(
            self,
            value_or_callback: Callable[
                [GenericListBuilder[ContainerPort, ContainerPort.Builder]],
                GenericListBuilder[ContainerPort, ContainerPort.Builder] | List[ContainerPort],
            ],
            /,
        ) -> "Container.Builder": ...

        @overload
        def ports(
            self, value_or_callback: Never = ...
        ) -> ListBuilderContext[ContainerPort.Builder]: ...

        def ports(self, value_or_callback=None, /):
            """
            List of ports to expose from the container. Not specifying a port here DOES NOT prevent that port from being exposed. Any port which is listening on the default "0.0.0.0" address inside a container will be accessible from the network. Modifying this array with strategic merge patch may corrupt the data. For more information See https://github.com/kubernetes/kubernetes/issues/108255. Cannot be updated.
            """
            if self._in_context and value_or_callback is None:
                context = ListBuilderContext[ContainerPort.Builder]()
                context._parent_builder = self
                context._field_name = "ports"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(ContainerPort.list_builder())
                if isinstance(output, GenericListBuilder):
                    value = output.build()
                else:
                    value = output
            return self._set("ports", value)

        @overload
        def readiness_probe(self, value_or_callback: Optional[Probe], /) -> "Container.Builder": ...

        @overload
        def readiness_probe(
            self, value_or_callback: Callable[[Probe.Builder], Probe.Builder | Probe], /
        ) -> "Container.Builder": ...

        @overload
        def readiness_probe(self, value_or_callback: Never = ...) -> "Probe.BuilderContext": ...

        def readiness_probe(self, value_or_callback=None, /):
            """
            Periodic probe of container service readiness. Container will be removed from service endpoints if the probe fails. Cannot be updated. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes
            """
            if self._in_context and value_or_callback is None:
                context = Probe.BuilderContext()
                context._parent_builder = self
                context._field_name = "readiness_probe"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(Probe.builder())
                if isinstance(output, Probe.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("readiness_probe", value)

        @overload
        def resize_policy(
            self, value_or_callback: List[ContainerResizePolicy], /
        ) -> "Container.Builder": ...

        @overload
        def resize_policy(
            self,
            value_or_callback: Callable[
                [GenericListBuilder[ContainerResizePolicy, ContainerResizePolicy.Builder]],
                GenericListBuilder[ContainerResizePolicy, ContainerResizePolicy.Builder]
                | List[ContainerResizePolicy],
            ],
            /,
        ) -> "Container.Builder": ...

        @overload
        def resize_policy(
            self, value_or_callback: Never = ...
        ) -> ListBuilderContext[ContainerResizePolicy.Builder]: ...

        def resize_policy(self, value_or_callback=None, /):
            """
            Resources resize policy for the container.
            """
            if self._in_context and value_or_callback is None:
                context = ListBuilderContext[ContainerResizePolicy.Builder]()
                context._parent_builder = self
                context._field_name = "resize_policy"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(ContainerResizePolicy.list_builder())
                if isinstance(output, GenericListBuilder):
                    value = output.build()
                else:
                    value = output
            return self._set("resize_policy", value)

        @overload
        def resources(
            self, value_or_callback: Optional[ResourceRequirements], /
        ) -> "Container.Builder": ...

        @overload
        def resources(
            self,
            value_or_callback: Callable[
                [ResourceRequirements.Builder],
                ResourceRequirements.Builder | ResourceRequirements,
            ],
            /,
        ) -> "Container.Builder": ...

        @overload
        def resources(
            self, value_or_callback: Never = ...
        ) -> "ResourceRequirements.BuilderContext": ...

        def resources(self, value_or_callback=None, /):
            """
            Compute Resources required by this container. Cannot be updated. More info: https://kubernetes.io/docs/concepts/configuration/manage-resources-containers/
            """
            if self._in_context and value_or_callback is None:
                context = ResourceRequirements.BuilderContext()
                context._parent_builder = self
                context._field_name = "resources"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(ResourceRequirements.builder())
                if isinstance(output, ResourceRequirements.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("resources", value)

        def restart_policy(self, value: Optional[str], /) -> Self:
            """
            RestartPolicy defines the restart behavior of individual containers in a pod. This field may only be set for init containers, and the only allowed value is "Always". For non-init containers or when this field is not specified, the restart behavior is defined by the Pod's restart policy and the container type. Setting the RestartPolicy as "Always" for the init container will have the following effect: this init container will be continually restarted on exit until all regular containers have terminated. Once all regular containers have completed, all init containers with restartPolicy "Always" will be shut down. This lifecycle differs from normal init containers and is often referred to as a "sidecar" container. Although this init container still starts in the init container sequence, it does not wait for the container to complete before proceeding to the next init container. Instead, the next init container starts immediately after this init container is started, or after any startupProbe has successfully completed.
            """
            return self._set("restart_policy", value)

        @overload
        def security_context(
            self, value_or_callback: Optional[SecurityContext], /
        ) -> "Container.Builder": ...

        @overload
        def security_context(
            self,
            value_or_callback: Callable[
                [SecurityContext.Builder], SecurityContext.Builder | SecurityContext
            ],
            /,
        ) -> "Container.Builder": ...

        @overload
        def security_context(
            self, value_or_callback: Never = ...
        ) -> "SecurityContext.BuilderContext": ...

        def security_context(self, value_or_callback=None, /):
            """
            SecurityContext defines the security options the container should be run with. If set, the fields of SecurityContext override the equivalent fields of PodSecurityContext. More info: https://kubernetes.io/docs/tasks/configure-pod-container/security-context/
            """
            if self._in_context and value_or_callback is None:
                context = SecurityContext.BuilderContext()
                context._parent_builder = self
                context._field_name = "security_context"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(SecurityContext.builder())
                if isinstance(output, SecurityContext.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("security_context", value)

        @overload
        def startup_probe(self, value_or_callback: Optional[Probe], /) -> "Container.Builder": ...

        @overload
        def startup_probe(
            self, value_or_callback: Callable[[Probe.Builder], Probe.Builder | Probe], /
        ) -> "Container.Builder": ...

        @overload
        def startup_probe(self, value_o