# Generated by cloudcoil-model-codegen v0.5.0
# DO NOT EDIT

from __future__ import annotations

from typing import (
    Annotated,
    Callable,
    List,
    Literal,
    Optional,
    Type,
    overload,
)

from pydantic import Field

from cloudcoil import apimachinery
from cloudcoil.pydantic import (
    BaseModel,
    BaseModelBuilder,
    BuilderContextBase,
    GenericListBuilder,
    ListBuilderContext,
    Never,
    Self,
)
from cloudcoil.resources import Resource, ResourceList

from ..core import v1


class PodFailurePolicyOnExitCodesRequirement(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["PodFailurePolicyOnExitCodesRequirement"]:
            return PodFailurePolicyOnExitCodesRequirement

        def build(self) -> "PodFailurePolicyOnExitCodesRequirement":
            return PodFailurePolicyOnExitCodesRequirement(**self._attrs)

        def container_name(self, value: Optional[str], /) -> Self:
            """
            Restricts the check for exit codes to the container with the specified name. When null, the rule applies to all containers. When specified, it should match one the container or initContainer names in the pod template.
            """
            return self._set("container_name", value)

        def operator(self, value: str, /) -> Self:
            """
            Represents the relationship between the container exit code(s) and the specified values. Containers completed with success (exit code 0) are excluded from the requirement check. Possible values are:

            - In: the requirement is satisfied if at least one container exit code
              (might be multiple if there are multiple containers not restricted
              by the 'containerName' field) is in the set of specified values.
            - NotIn: the requirement is satisfied if at least one container exit code
              (might be multiple if there are multiple containers not restricted
              by the 'containerName' field) is not in the set of specified values.
            Additional values are considered to be added in the future. Clients should react to an unknown operator by assuming the requirement is not satisfied.
            """
            return self._set("operator", value)

        def values(self, value: List[int], /) -> Self:
            """
            Specifies the set of values. Each returned container exit code (might be multiple in case of multiple containers) is checked against this set of values with respect to the operator. The list of values must be ordered and must not contain duplicates. Value '0' cannot be used for the In operator. At least one element is required. At most 255 elements are allowed.
            """
            return self._set("values", value)

    class BuilderContext(BuilderContextBase["PodFailurePolicyOnExitCodesRequirement.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = PodFailurePolicyOnExitCodesRequirement.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for PodFailurePolicyOnExitCodesRequirement."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["PodFailurePolicyOnExitCodesRequirement", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use PodFailurePolicyOnExitCodesRequirement.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    container_name: Annotated[Optional[str], Field(alias="containerName")] = None
    """
    Restricts the check for exit codes to the container with the specified name. When null, the rule applies to all containers. When specified, it should match one the container or initContainer names in the pod template.
    """
    operator: str
    """
    Represents the relationship between the container exit code(s) and the specified values. Containers completed with success (exit code 0) are excluded from the requirement check. Possible values are:

    - In: the requirement is satisfied if at least one container exit code
      (might be multiple if there are multiple containers not restricted
      by the 'containerName' field) is in the set of specified values.
    - NotIn: the requirement is satisfied if at least one container exit code
      (might be multiple if there are multiple containers not restricted
      by the 'containerName' field) is not in the set of specified values.
    Additional values are considered to be added in the future. Clients should react to an unknown operator by assuming the requirement is not satisfied.
    """
    values: List[int]
    """
    Specifies the set of values. Each returned container exit code (might be multiple in case of multiple containers) is checked against this set of values with respect to the operator. The list of values must be ordered and must not contain duplicates. Value '0' cannot be used for the In operator. At least one element is required. At most 255 elements are allowed.
    """


class PodFailurePolicyOnPodConditionsPattern(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["PodFailurePolicyOnPodConditionsPattern"]:
            return PodFailurePolicyOnPodConditionsPattern

        def build(self) -> "PodFailurePolicyOnPodConditionsPattern":
            return PodFailurePolicyOnPodConditionsPattern(**self._attrs)

        def status(self, value: str, /) -> Self:
            """
            Specifies the required Pod condition status. To match a pod condition it is required that the specified status equals the pod condition status. Defaults to True.
            """
            return self._set("status", value)

        def type(self, value: str, /) -> Self:
            """
            Specifies the required Pod condition type. To match a pod condition it is required that specified type equals the pod condition type.
            """
            return self._set("type", value)

    class BuilderContext(BuilderContextBase["PodFailurePolicyOnPodConditionsPattern.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = PodFailurePolicyOnPodConditionsPattern.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for PodFailurePolicyOnPodConditionsPattern."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["PodFailurePolicyOnPodConditionsPattern", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use PodFailurePolicyOnPodConditionsPattern.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    status: str
    """
    Specifies the required Pod condition status. To match a pod condition it is required that the specified status equals the pod condition status. Defaults to True.
    """
    type: str
    """
    Specifies the required Pod condition type. To match a pod condition it is required that specified type equals the pod condition type.
    """


class PodFailurePolicyRule(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["PodFailurePolicyRule"]:
            return PodFailurePolicyRule

        def build(self) -> "PodFailurePolicyRule":
            return PodFailurePolicyRule(**self._attrs)

        def action(self, value: str, /) -> Self:
            """
            Specifies the action taken on a pod failure when the requirements are satisfied. Possible values are:

            - FailJob: indicates that the pod's job is marked as Failed and all
              running pods are terminated.
            - FailIndex: indicates that the pod's index is marked as Failed and will
              not be restarted.
              This value is beta-level. It can be used when the
              `JobBackoffLimitPerIndex` feature gate is enabled (enabled by default).
            - Ignore: indicates that the counter towards the .backoffLimit is not
              incremented and a replacement pod is created.
            - Count: indicates that the pod is handled in the default way - the
              counter towards the .backoffLimit is incremented.
            Additional values are considered to be added in the future. Clients should react to an unknown action by skipping the rule.
            """
            return self._set("action", value)

        @overload
        def on_exit_codes(
            self, value_or_callback: Optional[PodFailurePolicyOnExitCodesRequirement], /
        ) -> "PodFailurePolicyRule.Builder": ...

        @overload
        def on_exit_codes(
            self,
            value_or_callback: Callable[
                [PodFailurePolicyOnExitCodesRequirement.Builder],
                PodFailurePolicyOnExitCodesRequirement.Builder
                | PodFailurePolicyOnExitCodesRequirement,
            ],
            /,
        ) -> "PodFailurePolicyRule.Builder": ...

        @overload
        def on_exit_codes(
            self, value_or_callback: Never = ...
        ) -> "PodFailurePolicyOnExitCodesRequirement.BuilderContext": ...

        def on_exit_codes(self, value_or_callback=None, /):
            """
            Represents the requirement on the container exit codes.
            """
            if self._in_context and value_or_callback is None:
                context = PodFailurePolicyOnExitCodesRequirement.BuilderContext()
                context._parent_builder = self
                context._field_name = "on_exit_codes"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(PodFailurePolicyOnExitCodesRequirement.builder())
                if isinstance(output, PodFailurePolicyOnExitCodesRequirement.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("on_exit_codes", value)

        @overload
        def on_pod_conditions(
            self, value_or_callback: List[PodFailurePolicyOnPodConditionsPattern], /
        ) -> "PodFailurePolicyRule.Builder": ...

        @overload
        def on_pod_conditions(
            self,
            value_or_callback: Callable[
                [
                    GenericListBuilder[
                        PodFailurePolicyOnPodConditionsPattern,
                        PodFailurePolicyOnPodConditionsPattern.Builder,
                    ]
                ],
                GenericListBuilder[
                    PodFailurePolicyOnPodConditionsPattern,
                    PodFailurePolicyOnPodConditionsPattern.Builder,
                ]
                | List[PodFailurePolicyOnPodConditionsPattern],
            ],
            /,
        ) -> "PodFailurePolicyRule.Builder": ...

        @overload
        def on_pod_conditions(
            self, value_or_callback: Never = ...
        ) -> ListBuilderContext[PodFailurePolicyOnPodConditionsPattern.Builder]: ...

        def on_pod_conditions(self, value_or_callback=None, /):
            """
            Represents the requirement on the pod conditions. The requirement is represented as a list of pod condition patterns. The requirement is satisfied if at least one pattern matches an actual pod condition. At most 20 elements are allowed.
            """
            if self._in_context and value_or_callback is None:
                context = ListBuilderContext[PodFailurePolicyOnPodConditionsPattern.Builder]()
                context._parent_builder = self
                context._field_name = "on_pod_conditions"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(PodFailurePolicyOnPodConditionsPattern.list_builder())
                if isinstance(output, GenericListBuilder):
                    value = output.build()
                else:
                    value = output
            return self._set("on_pod_conditions", value)

    class BuilderContext(BuilderContextBase["PodFailurePolicyRule.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = PodFailurePolicyRule.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for PodFailurePolicyRule."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["PodFailurePolicyRule", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use PodFailurePolicyRule.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    action: str
    """
    Specifies the action taken on a pod failure when the requirements are satisfied. Possible values are:

    - FailJob: indicates that the pod's job is marked as Failed and all
      running pods are terminated.
    - FailIndex: indicates that the pod's index is marked as Failed and will
      not be restarted.
      This value is beta-level. It can be used when the
      `JobBackoffLimitPerIndex` feature gate is enabled (enabled by default).
    - Ignore: indicates that the counter towards the .backoffLimit is not
      incremented and a replacement pod is created.
    - Count: indicates that the pod is handled in the default way - the
      counter towards the .backoffLimit is incremented.
    Additional values are considered to be added in the future. Clients should react to an unknown action by skipping the rule.
    """
    on_exit_codes: Annotated[
        Optional[PodFailurePolicyOnExitCodesRequirement], Field(alias="onExitCodes")
    ] = None
    """
    Represents the requirement on the container exit codes.
    """
    on_pod_conditions: Annotated[
        Optional[List[PodFailurePolicyOnPodConditionsPattern]],
        Field(alias="onPodConditions"),
    ] = None
    """
    Represents the requirement on the pod conditions. The requirement is represented as a list of pod condition patterns. The requirement is satisfied if at least one pattern matches an actual pod condition. At most 20 elements are allowed.
    """


class SuccessPolicyRule(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["SuccessPolicyRule"]:
            return SuccessPolicyRule

        def build(self) -> "SuccessPolicyRule":
            return SuccessPolicyRule(**self._attrs)

        def succeeded_count(self, value: Optional[int], /) -> Self:
            """
            succeededCount specifies the minimal required size of the actual set of the succeeded indexes for the Job. When succeededCount is used along with succeededIndexes, the check is constrained only to the set of indexes specified by succeededIndexes. For example, given that succeededIndexes is "1-4", succeededCount is "3", and completed indexes are "1", "3", and "5", the Job isn't declared as succeeded because only "1" and "3" indexes are considered in that rules. When this field is null, this doesn't default to any value and is never evaluated at any time. When specified it needs to be a positive integer.
            """
            return self._set("succeeded_count", value)

        def succeeded_indexes(self, value: Optional[str], /) -> Self:
            """
            succeededIndexes specifies the set of indexes which need to be contained in the actual set of the succeeded indexes for the Job. The list of indexes must be within 0 to ".spec.completions-1" and must not contain duplicates. At least one element is required. The indexes are represented as intervals separated by commas. The intervals can be a decimal integer or a pair of decimal integers separated by a hyphen. The number are listed in represented by the first and last element of the series, separated by a hyphen. For example, if the completed indexes are 1, 3, 4, 5 and 7, they are represented as "1,3-5,7". When this field is null, this field doesn't default to any value and is never evaluated at any time.
            """
            return self._set("succeeded_indexes", value)

    class BuilderContext(BuilderContextBase["SuccessPolicyRule.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = SuccessPolicyRule.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for SuccessPolicyRule."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["SuccessPolicyRule", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use SuccessPolicyRule.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    succeeded_count: Annotated[Optional[int], Field(alias="succeededCount")] = None
    """
    succeededCount specifies the minimal required size of the actual set of the succeeded indexes for the Job. When succeededCount is used along with succeededIndexes, the check is constrained only to the set of indexes specified by succeededIndexes. For example, given that succeededIndexes is "1-4", succeededCount is "3", and completed indexes are "1", "3", and "5", the Job isn't declared as succeeded because only "1" and "3" indexes are considered in that rules. When this field is null, this doesn't default to any value and is never evaluated at any time. When specified it needs to be a positive integer.
    """
    succeeded_indexes: Annotated[Optional[str], Field(alias="succeededIndexes")] = None
    """
    succeededIndexes specifies the set of indexes which need to be contained in the actual set of the succeeded indexes for the Job. The list of indexes must be within 0 to ".spec.completions-1" and must not contain duplicates. At least one element is required. The indexes are represented as intervals separated by commas. The intervals can be a decimal integer or a pair of decimal integers separated by a hyphen. The number are listed in represented by the first and last element of the series, separated by a hyphen. For example, if the completed indexes are 1, 3, 4, 5 and 7, they are represented as "1,3-5,7". When this field is null, this field doesn't default to any value and is never evaluated at any time.
    """


class UncountedTerminatedPods(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["UncountedTerminatedPods"]:
            return UncountedTerminatedPods

        def build(self) -> "UncountedTerminatedPods":
            return UncountedTerminatedPods(**self._attrs)

        def failed(self, value: Optional[List[str]], /) -> Self:
            """
            failed holds UIDs of failed Pods.
            """
            return self._set("failed", value)

        def succeeded(self, value: Optional[List[str]], /) -> Self:
            """
            succeeded holds UIDs of succeeded Pods.
            """
            return self._set("succeeded", value)

    class BuilderContext(BuilderContextBase["UncountedTerminatedPods.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = UncountedTerminatedPods.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for UncountedTerminatedPods."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["UncountedTerminatedPods", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use UncountedTerminatedPods.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    failed: Optional[List[str]] = None
    """
    failed holds UIDs of failed Pods.
    """
    succeeded: Optional[List[str]] = None
    """
    succeeded holds UIDs of succeeded Pods.
    """


class CronJobStatus(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["CronJobStatus"]:
            return CronJobStatus

        def build(self) -> "CronJobStatus":
            return CronJobStatus(**self._attrs)

        @overload
        def active(
            self, value_or_callback: List[v1.ObjectReference], /
        ) -> "CronJobStatus.Builder": ...

        @overload
        def active(
            self,
            value_or_callback: Callable[
                [GenericListBuilder[v1.ObjectReference, v1.ObjectReference.Builder]],
                GenericListBuilder[v1.ObjectReference, v1.ObjectReference.Builder]
                | List[v1.ObjectReference],
            ],
            /,
        ) -> "CronJobStatus.Builder": ...

        @overload
        def active(
            self, value_or_callback: Never = ...
        ) -> ListBuilderContext[v1.ObjectReference.Builder]: ...

        def active(self, value_or_callback=None, /):
            """
            A list of pointers to currently running jobs.
            """
            if self._in_context and value_or_callback is None:
                context = ListBuilderContext[v1.ObjectReference.Builder]()
                context._parent_builder = self
                context._field_name = "active"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(v1.ObjectReference.list_builder())
                if isinstance(output, GenericListBuilder):
                    value = output.build()
                else:
                    value = output
            return self._set("active", value)

        @overload
        def last_schedule_time(
            self, value_or_callback: Optional[apimachinery.Time], /
        ) -> "CronJobStatus.Builder": ...

        @overload
        def last_schedule_time(
            self,
            value_or_callback: Callable[
                [apimachinery.Time.Builder],
                apimachinery.Time.Builder | apimachinery.Time,
            ],
            /,
        ) -> "CronJobStatus.Builder": ...

        @overload
        def last_schedule_time(
            self, value_or_callback: Never = ...
        ) -> "apimachinery.Time.BuilderContext": ...

        def last_schedule_time(self, value_or_callback=None, /):
            """
            Information when was the last time the job was successfully scheduled.
            """
            if self._in_context and value_or_callback is None:
                context = apimachinery.Time.BuilderContext()
                context._parent_builder = self
                context._field_name = "last_schedule_time"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(apimachinery.Time.builder())
                if isinstance(output, apimachinery.Time.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("last_schedule_time", value)

        @overload
        def last_successful_time(
            self, value_or_callback: Optional[apimachinery.Time], /
        ) -> "CronJobStatus.Builder": ...

        @overload
        def last_successful_time(
            self,
            value_or_callback: Callable[
                [apimachinery.Time.Builder],
                apimachinery.Time.Builder | apimachinery.Time,
            ],
            /,
        ) -> "CronJobStatus.Builder": ...

        @overload
        def last_successful_time(
            self, value_or_callback: Never = ...
        ) -> "apimachinery.Time.BuilderContext": ...

        def last_successful_time(self, value_or_callback=None, /):
            """
            Information when was the last time the job successfully completed.
            """
            if self._in_context and value_or_callback is None:
                context = apimachinery.Time.BuilderContext()
                context._parent_builder = self
                context._field_name = "last_successful_time"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(apimachinery.Time.builder())
                if isinstance(output, apimachinery.Time.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("last_successful_time", value)

    class BuilderContext(BuilderContextBase["CronJobStatus.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = CronJobStatus.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for CronJobStatus."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["CronJobStatus", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use CronJobStatus.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    active: Optional[List[v1.ObjectReference]] = None
    """
    A list of pointers to currently running jobs.
    """
    last_schedule_time: Annotated[Optional[apimachinery.Time], Field(alias="lastScheduleTime")] = (
        None
    )
    """
    Information when was the last time the job was successfully scheduled.
    """
    last_successful_time: Annotated[
        Optional[apimachinery.Time], Field(alias="lastSuccessfulTime")
    ] = None
    """
    Information when was the last time the job successfully completed.
    """


class JobCondition(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["JobCondition"]:
            return JobCondition

        def build(self) -> "JobCondition":
            return JobCondition(**self._attrs)

        @overload
        def last_probe_time(
            self, value_or_callback: Optional[apimachinery.Time], /
        ) -> "JobCondition.Builder": ...

        @overload
        def last_probe_time(
            self,
            value_or_callback: Callable[
                [apimachinery.Time.Builder],
                apimachinery.Time.Builder | apimachinery.Time,
            ],
            /,
        ) -> "JobCondition.Builder": ...

        @overload
        def last_probe_time(
            self, value_or_callback: Never = ...
        ) -> "apimachinery.Time.BuilderContext": ...

        def last_probe_time(self, value_or_callback=None, /):
            """
            Last time the condition was checked.
            """
            if self._in_context and value_or_callback is None:
                context = apimachinery.Time.BuilderContext()
                context._parent_builder = self
                context._field_name = "last_probe_time"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(apimachinery.Time.builder())
                if isinstance(output, apimachinery.Time.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("last_probe_time", value)

        @overload
        def last_transition_time(
            self, value_or_callback: Optional[apimachinery.Time], /
        ) -> "JobCondition.Builder": ...

        @overload
        def last_transition_time(
            self,
            value_or_callback: Callable[
                [apimachinery.Time.Builder],
                apimachinery.Time.Builder | apimachinery.Time,
            ],
            /,
        ) -> "JobCondition.Builder": ...

        @overload
        def last_transition_time(
            self, value_or_callback: Never = ...
        ) -> "apimachinery.Time.BuilderContext": ...

        def last_transition_time(self, value_or_callback=None, /):
            """
            Last time the condition transit from one status to another.
            """
            if self._in_context and value_or_callback is None:
                context = apimachinery.Time.BuilderContext()
                context._parent_builder = self
                context._field_name = "last_transition_time"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(apimachinery.Time.builder())
                if isinstance(output, apimachinery.Time.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("last_transition_time", value)

        def message(self, value: Optional[str], /) -> Self:
            """
            Human readable message indicating details about last transition.
            """
            return self._set("message", value)

        def reason(self, value: Optional[str], /) -> Self:
            """
            (brief) reason for the condition's last transition.
            """
            return self._set("reason", value)

        def status(self, value: str, /) -> Self:
            """
            Status of the condition, one of True, False, Unknown.
            """
            return self._set("status", value)

        def type(self, value: str, /) -> Self:
            """
            Type of job condition, Complete or Failed.
            """
            return self._set("type", value)

    class BuilderContext(BuilderContextBase["JobCondition.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = JobCondition.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for JobCondition."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["JobCondition", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use JobCondition.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    last_probe_time: Annotated[Optional[apimachinery.Time], Field(alias="lastProbeTime")] = None
    """
    Last time the condition was checked.
    """
    last_transition_time: Annotated[
        Optional[apimachinery.Time], Field(alias="lastTransitionTime")
    ] = None
    """
    Last time the condition transit from one status to another.
    """
    message: Optional[str] = None
    """
    Human readable message indicating details about last transition.
    """
    reason: Optional[str] = None
    """
    (brief) reason for the condition's last transition.
    """
    status: str
    """
    Status of the condition, one of True, False, Unknown.
    """
    type: str
    """
    Type of job condition, Complete or Failed.
    """


class JobStatus(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["JobStatus"]:
            return JobStatus

        def build(self) -> "JobStatus":
            return JobStatus(**self._attrs)

        def active(self, value: Optional[int], /) -> Self:
            """
            The number of pending and running pods which are not terminating (without a deletionTimestamp). The value is zero for finished jobs.
            """
            return self._set("active", value)

        def completed_indexes(self, value: Optional[str], /) -> Self:
            """
            completedIndexes holds the completed indexes when .spec.completionMode = "Indexed" in a text format. The indexes are represented as decimal integers separated by commas. The numbers are listed in increasing order. Three or more consecutive numbers are compressed and represented by the first and last element of the series, separated by a hyphen. For example, if the completed indexes are 1, 3, 4, 5 and 7, they are represented as "1,3-5,7".
            """
            return self._set("completed_indexes", value)

        @overload
        def completion_time(
            self, value_or_callback: Optional[apimachinery.Time], /
        ) -> "JobStatus.Builder": ...

        @overload
        def completion_time(
            self,
            value_or_callback: Callable[
                [apimachinery.Time.Builder],
                apimachinery.Time.Builder | apimachinery.Time,
            ],
            /,
        ) -> "JobStatus.Builder": ...

        @overload
        def completion_time(
            self, value_or_callback: Never = ...
        ) -> "apimachinery.Time.BuilderContext": ...

        def completion_time(self, value_or_callback=None, /):
            """
            Represents time when the job was completed. It is not guaranteed to be set in happens-before order across separate operations. It is represented in RFC3339 form and is in UTC. The completion time is set when the job finishes successfully, and only then. The value cannot be updated or removed. The value indicates the same or later point in time as the startTime field.
            """
            if self._in_context and value_or_callback is None:
                context = apimachinery.Time.BuilderContext()
                context._parent_builder = self
                context._field_name = "completion_time"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(apimachinery.Time.builder())
                if isinstance(output, apimachinery.Time.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("completion_time", value)

        @overload
        def conditions(self, value_or_callback: List[JobCondition], /) -> "JobStatus.Builder": ...

        @overload
        def conditions(
            self,
            value_or_callback: Callable[
                [GenericListBuilder[JobCondition, JobCondition.Builder]],
                GenericListBuilder[JobCondition, JobCondition.Builder] | List[JobCondition],
            ],
            /,
        ) -> "JobStatus.Builder": ...

        @overload
        def conditions(
            self, value_or_callback: Never = ...
        ) -> ListBuilderContext[JobCondition.Builder]: ...

        def conditions(self, value_or_callback=None, /):
            """
            The latest available observations of an object's current state. When a Job fails, one of the conditions will have type "Failed" and status true. When a Job is suspended, one of the conditions will have type "Suspended" and status true; when the Job is resumed, the status of this condition will become false. When a Job is completed, one of the conditions will have type "Complete" and status true.

            A job is considered finished when it is in a terminal condition, either "Complete" or "Failed". A Job cannot have both the "Complete" and "Failed" conditions. Additionally, it cannot be in the "Complete" and "FailureTarget" conditions. The "Complete", "Failed" and "FailureTarget" conditions cannot be disabled.

            More info: https://kubernetes.io/docs/concepts/workloads/controllers/jobs-run-to-completion/
            """
            if self._in_context and value_or_callback is None:
                context = ListBuilderContext[JobCondition.Builder]()
                context._parent_builder = self
                context._field_name = "conditions"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(JobCondition.list_builder())
                if isinstance(output, GenericListBuilder):
                    value = output.build()
                else:
                    value = output
            return self._set("conditions", value)

        def failed(self, value: Optional[int], /) -> Self:
            """
            The number of pods which reached phase Failed. The value increases monotonically.
            """
            return self._set("failed", value)

        def failed_indexes(self, value: Optional[str], /) -> Self:
            """
            FailedIndexes holds the failed indexes when spec.backoffLimitPerIndex is set. The indexes are represented in the text format analogous as for the `completedIndexes` field, ie. they are kept as decimal integers separated by commas. The numbers are listed in increasing order. Three or more consecutive numbers are compressed and represented by the first and last element of the series, separated by a hyphen. For example, if the failed indexes are 1, 3, 4, 5 and 7, they are represented as "1,3-5,7". The set of failed indexes cannot overlap with the set of completed indexes.

            This field is beta-level. It can be used when the `JobBackoffLimitPerIndex` feature gate is enabled (enabled by default).
            """
            return self._set("failed_indexes", value)

        def ready(self, value: Optional[int], /) -> Self:
            """
            The number of active pods which have a Ready condition and are not terminating (without a deletionTimestamp).
            """
            return self._set("ready", value)

        @overload
        def start_time(
            self, value_or_callback: Optional[apimachinery.Time], /
        ) -> "JobStatus.Builder": ...

        @overload
        def start_time(
            self,
            value_or_callback: Callable[
                [apimachinery.Time.Builder],
                apimachinery.Time.Builder | apimachinery.Time,
            ],
            /,
        ) -> "JobStatus.Builder": ...

        @overload
        def start_time(
            self, value_or_callback: Never = ...
        ) -> "apimachinery.Time.BuilderContext": ...

        def start_time(self, value_or_callback=None, /):
            """
            Represents time when the job controller started processing a job. When a Job is created in the suspended state, this field is not set until the first time it is resumed. This field is reset every time a Job is resumed from suspension. It is represented in RFC3339 form and is in UTC.

            Once set, the field can only be removed when the job is suspended. The field cannot be modified while the job is unsuspended or finished.
            """
            if self._in_context and value_or_callback is None:
                context = apimachinery.Time.BuilderContext()
                context._parent_builder = self
                context._field_name = "start_time"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(apimachinery.Time.builder())
                if isinstance(output, apimachinery.Time.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("start_time", value)

        def succeeded(self, value: Optional[int], /) -> Self:
            """
            The number of pods which reached phase Succeeded. The value increases monotonically for a given spec. However, it may decrease in reaction to scale down of elastic indexed jobs.
            """
            return self._set("succeeded", value)

        def terminating(self, value: Optional[int], /) -> Self:
            """
            The number of pods which are terminating (in phase Pending or Running and have a deletionTimestamp).

            This field is beta-level. The job controller populates the field when the feature gate JobPodReplacementPolicy is enabled (enabled by default).
            """
            return self._set("terminating", value)

        @overload
        def uncounted_terminated_pods(
            self, value_or_callback: Optional[UncountedTerminatedPods], /
        ) -> "JobStatus.Builder": ...

        @overload
        def uncounted_terminated_pods(
            self,
            value_or_callback: Callable[
                [UncountedTerminatedPods.Builder],
                UncountedTerminatedPods.Builder | UncountedTerminatedPods,
            ],
            /,
        ) -> "JobStatus.Builder": ...

        @overload
        def uncounted_terminated_pods(
            self, value_or_callback: Never = ...
        ) -> "UncountedTerminatedPods.BuilderContext": ...

        def uncounted_terminated_pods(self, value_or_callback=None, /):
            """
            uncountedTerminatedPods holds the UIDs of Pods that have terminated but the job controller hasn't yet accounted for in the status counters.

            The job controller creates pods with a finalizer. When a pod terminates (succeeded or failed), the controller does three steps to account for it in the job status:

            1. Add the pod UID to the arrays in this field. 2. Remove the pod finalizer. 3. Remove the pod UID from the arrays while increasing the corresponding
                counter.

            Old jobs might not be tracked using this field, in which case the field remains null. The structure is empty for finished jobs.
            """
            if self._in_context and value_or_callback is None:
                context = UncountedTerminatedPods.BuilderContext()
                context._parent_builder = self
                context._field_name = "uncounted_terminated_pods"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(UncountedTerminatedPods.builder())
                if isinstance(output, UncountedTerminatedPods.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("uncounted_terminated_pods", value)

    class BuilderContext(BuilderContextBase["JobStatus.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = JobStatus.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for JobStatus."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["JobStatus", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use JobStatus.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    active: Optional[int] = None
    """
    The number of pending and running pods which are not terminating (without a deletionTimestamp). The value is zero for finished jobs.
    """
    completed_indexes: Annotated[Optional[str], Field(alias="completedIndexes")] = None
    """
    completedIndexes holds the completed indexes when .spec.completionMode = "Indexed" in a text format. The indexes are represented as decimal integers separated by commas. The numbers are listed in increasing order. Three or more consecutive numbers are compressed and represented by the first and last element of the series, separated by a hyphen. For example, if the completed indexes are 1, 3, 4, 5 and 7, they are represented as "1,3-5,7".
    """
    completion_time: Annotated[Optional[apimachinery.Time], Field(alias="completionTime")] = None
    """
    Represents time when the job was completed. It is not guaranteed to be set in happens-before order across separate operations. It is represented in RFC3339 form and is in UTC. The completion time is set when the job finishes successfully, and only then. The value cannot be updated or removed. The value indicates the same or later point in time as the startTime field.
    """
    conditions: Optional[List[JobCondition]] = None
    """
    The latest available observations of an object's current state. When a Job fails, one of the conditions will have type "Failed" and status true. When a Job is suspended, one of the conditions will have type "Suspended" and status true; when the Job is resumed, the status of this condition will become false. When a Job is completed, one of the conditions will have type "Complete" and status true.

    A job is considered finished when it is in a terminal condition, either "Complete" or "Failed". A Job cannot have both the "Complete" and "Failed" conditions. Additionally, it cannot be in the "Complete" and "FailureTarget" conditions. The "Complete", "Failed" and "FailureTarget" conditions cannot be disabled.

    More info: https://kubernetes.io/docs/concepts/workloads/controllers/jobs-run-to-completion/
    """
    failed: Optional[int] = None
    """
    The number of pods which reached phase Failed. The value increases monotonically.
    """
    failed_indexes: Annotated[Optional[str], Field(alias="failedIndexes")] = None
    """
    FailedIndexes holds the failed indexes when spec.backoffLimitPerIndex is set. The indexes are represented in the text format analogous as for the `completedIndexes` field, ie. they are kept as decimal integers separated by commas. The numbers are listed in increasing order. Three or more consecutive numbers are compressed and represented by the first and last element of the series, separated by a hyphen. For example, if the failed indexes are 1, 3, 4, 5 and 7, they are represented as "1,3-5,7". The set of failed indexes cannot overlap with the set of completed indexes.

    This field is beta-level. It can be used when the `JobBackoffLimitPerIndex` feature gate is enabled (enabled by default).
    """
    ready: Optional[int] = None
    """
    The number of active pods which have a Ready condition and are not terminating (without a deletionTimestamp).
    """
    start_time: Annotated[Optional[apimachinery.Time], Field(alias="startTime")] = None
    """
    Represents time when the job controller started processing a job. When a Job is created in the suspended state, this field is not set until the first time it is resumed. This field is reset every time a Job is resumed from suspension. It is represented in RFC3339 form and is in UTC.

    Once set, the field can only be removed when the job is suspended. The field cannot be modified while the job is unsuspended or finished.
    """
    succeeded: Optional[int] = None
    """
    The number of pods which reached phase Succeeded. The value increases monotonically for a given spec. However, it may decrease in reaction to scale down of elastic indexed jobs.
    """
    terminating: Optional[int] = None
    """
    The number of pods which are terminating (in phase Pending or Running and have a deletionTimestamp).

    This field is beta-level. The job controller populates the field when the feature gate JobPodReplacementPolicy is enabled (enabled by default).
    """
    uncounted_terminated_pods: Annotated[
        Optional[UncountedTerminatedPods], Field(alias="uncountedTerminatedPods")
    ] = None
    """
    uncountedTerminatedPods holds the UIDs of Pods that have terminated but the job controller hasn't yet accounted for in the status counters.

    The job controller creates pods with a finalizer. When a pod terminates (succeeded or failed), the controller does three steps to account for it in the job status:

    1. Add the pod UID to the arrays in this field. 2. Remove the pod finalizer. 3. Remove the pod UID from the arrays while increasing the corresponding
        counter.

    Old jobs might not be tracked using this field, in which case the field remains null. The structure is empty for finished jobs.
    """


class PodFailurePolicy(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["PodFailurePolicy"]:
            return PodFailurePolicy

        def build(self) -> "PodFailurePolicy":
            return PodFailurePolicy(**self._attrs)

        @overload
        def rules(
            self, value_or_callback: List[PodFailurePolicyRule], /
        ) -> "PodFailurePolicy.Builder": ...

        @overload
        def rules(
            self,
            value_or_callback: Callable[
                [GenericListBuilder[PodFailurePolicyRule, PodFailurePolicyRule.Builder]],
                GenericListBuilder[PodFailurePolicyRule, PodFailurePolicyRule.Builder]
                | List[PodFailurePolicyRule],
            ],
            /,
        ) -> "PodFailurePolicy.Builder": ...

        @overload
        def rules(
            self, value_or_callback: Never = ...
        ) -> ListBuilderContext[PodFailurePolicyRule.Builder]: ...

        def rules(self, value_or_callback=None, /):
            """
            A list of pod failure policy rules. The rules are evaluated in order. Once a rule matches a Pod failure, the remaining of the rules are ignored. When no rule matches the Pod failure, the default handling applies - the counter of pod failures is incremented and it is checked against the backoffLimit. At most 20 elements are allowed.
            """
            if self._in_context and value_or_callback is None:
                context = ListBuilderContext[PodFailurePolicyRule.Builder]()
                context._parent_builder = self
                context._field_name = "rules"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(PodFailurePolicyRule.list_builder())
                if isinstance(output, GenericListBuilder):
                    value = output.build()
                else:
                    value = output
            return self._set("rules", value)

    class BuilderContext(BuilderContextBase["PodFailurePolicy.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = PodFailurePolicy.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for PodFailurePolicy."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["PodFailurePolicy", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use PodFailurePolicy.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    rules: List[PodFailurePolicyRule]
    """
    A list of pod failure policy rules. The rules are evaluated in order. Once a rule matches a Pod failure, the remaining of the rules are ignored. When no rule matches the Pod failure, the default handling applies - the counter of pod failures is incremented and it is checked against the backoffLimit. At most 20 elements are allowed.
    """


class SuccessPolicy(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["SuccessPolicy"]:
            return SuccessPolicy

        def build(self) -> "SuccessPolicy":
            return SuccessPolicy(**self._attrs)

        @overload
        def rules(
            self, value_or_callback: List[SuccessPolicyRule], /
        ) -> "SuccessPolicy.Builder": ...

        @overload
        def rules(
            self,
            value_or_callback: Callable[
                [GenericListBuilder[SuccessPolicyRule, SuccessPolicyRule.Builder]],
                GenericListBuilder[SuccessPolicyRule, SuccessPolicyRule.Builder]
                | List[SuccessPolicyRule],
            ],
            /,
        ) -> "SuccessPolicy.Builder": ...

        @overload
        def rules(
            self, value_or_callback: Never = ...
        ) -> ListBuilderContext[SuccessPolicyRule.Builder]: ...

        def rules(self, value_or_callback=None, /):
            """
            rules represents the list of alternative rules for the declaring the Jobs as successful before `.status.succeeded >= .spec.completions`. Once any of the rules are met, the "SucceededCriteriaMet" condition is added, and the lingering pods are removed. The terminal state for such a Job has the "Complete" condition. Additionally, these rules are evaluated in order; Once the Job meets one of the rules, other rules are ignored. At most 20 elements are allowed.
            """
            if self._in_context and value_or_callback is None:
                context = ListBuilderContext[SuccessPolicyRule.Builder]()
                context._parent_builder = self
                context._field_name = "rules"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(SuccessPolicyRule.list_builder())
                if isinstance(output, GenericListBuilder):
                    value = output.build()
                else:
                    value = output
            return self._set("rules", value)

    class BuilderContext(BuilderContextBase["SuccessPolicy.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = SuccessPolicy.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for SuccessPolicy."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["SuccessPolicy", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use SuccessPolicy.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    rules: List[SuccessPolicyRule]
    """
    rules represents the list of alternative rules for the declaring the Jobs as successful before `.status.succeeded >= .spec.completions`. Once any of the rules are met, the "SucceededCriteriaMet" condition is added, and the lingering pods are removed. The terminal state for such a Job has the "Complete" condition. Additionally, these rules are evaluated in order; Once the Job meets one of the rules, other rules are ignored. At most 20 elements are allowed.
    """


class JobSpec(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["JobSpec"]:
            return JobSpec

        def build(self) -> "JobSpec":
            return JobSpec(**self._attrs)

        def active_deadline_seconds(self, value: Optional[int], /) -> Self:
            """
            Specifies the duration in seconds relative to the startTime that the job may be continuously active before the system tries to terminate it; value must be positive integer. If a Job is suspended (at creation or through an update), this timer will effectively be stopped and reset when the Job is resumed again.
            """
            return self._set("active_deadline_seconds", value)

        def backoff_limit(self, value: Optional[int], /) -> Self:
            """
            Specifies the number of retries before marking this job failed. Defaults to 6
            """
            return self._set("backoff_limit", value)

        def backoff_limit_per_index(self, value: Optional[int], /) -> Self:
            """
            Specifies the limit for the number of retries within an index before marking this index as failed. When enabled the number of failures per index is kept in the pod's batch.kubernetes.io/job-index-failure-count annotation. It can only be set when Job's completionMode=Indexed, and the Pod's restart policy is Never. The field is immutable. This field is beta-level. It can be used when the `JobBackoffLimitPerIndex` feature gate is enabled (enabled by default).
            """
            return self._set("backoff_limit_per_index", value)

        def completion_mode(self, value: Optional[str], /) -> Self:
            """
            completionMode specifies how Pod completions are tracked. It can be `NonIndexed` (default) or `Indexed`.

            `NonIndexed` means that the Job is considered complete when there have been .spec.completions successfully completed Pods. Each Pod completion is homologous to each other.

            `Indexed` means that the Pods of a Job get an associated completion index from 0 to (.spec.completions - 1), available in the annotation batch.kubernetes.io/job-completion-index. The Job is considered complete when there is one successfully completed Pod for each index. When value is `Indexed`, .spec.completions must be specified and `.spec.parallelism` must be less than or equal to 10^5. In addition, The Pod name takes the form `$(job-name)-$(index)-$(random-string)`, the Pod hostname takes the form `$(job-name)-$(index)`.

            More completion modes can be added in the future. If the Job controller observes a mode that it doesn't recognize, which is possible during upgrades due to version skew, the controller skips updates for the Job.
            """
            return self._set("completion_mode", value)

        def completions(self, value: Optional[int], /) -> Self:
            """
            Specifies the desired number of successfully finished pods the job should be run with.  Setting to null means that the success of any pod signals the success of all pods, and allows parallelism to have any positive value.  Setting to 1 means that parallelism is limited to 1 and the success of that pod signals the success of the job. More info: https://kubernetes.io/docs/concepts/workloads/controllers/jobs-run-to-completion/
            """
            return self._set("completions", value)

        def managed_by(self, value: Optional[str], /) -> Self:
            """
            ManagedBy field indicates the controller that manages a Job. The k8s Job controller reconciles jobs which don't have this field at all or the field value is the reserved string `kubernetes.io/job-controller`, but skips reconciling Jobs with a custom value for this field. The value must be a valid domain-prefixed path (e.g. acme.io/foo) - all characters before the first "/" must be a valid subdomain as defined by RFC 1123. All characters trailing the first "/" must be valid HTTP Path characters as defined by RFC 3986. The value cannot exceed 63 characters. This field is immutable.

            This field is alpha-level. The job controller accepts setting the field when the feature gate JobManagedBy is enabled (disabled by default).
            """
            return self._set("managed_by", value)

        def manual_selector(self, value: Optional[bool], /) -> Self:
            """
            manualSelector controls generation of pod labels and pod selectors. Leave `manualSelector` unset unless you are certain what you are doing. When false or unset, the system pick labels unique to this job and appends those labels to the pod template.  When true, the user is responsible for picking unique labels and specifying the selector.  Failure to pick a unique label may cause this and other jobs to not function correctly.  However, You may see `manualSelector=true` in jobs that were created with the old `extensions/v1beta1` API. More info: https://kubernetes.io/docs/concepts/workloads/controllers/jobs-run-to-completion/#specifying-your-own-pod-selector
            """
            return self._set("manual_selector", value)

        def max_failed_indexes(self, value: Optional[int], /) -> Self:
            """
            Specifies the maximal number of failed indexes before marking the Job as failed, when backoffLimitPerIndex is set. Once the number of failed indexes exceeds this number the entire Job is marked as Failed and its execution is terminated. When left as null the job continues execution of all of its indexes and is marked with the `Complete` Job condition. It can only be specified when backoffLimitPerIndex is set. It can be null or up to completions. It is required and must be less than or equal to 10^4 when is completions greater than 10^5. This field is beta-level. It can be used when the `JobBackoffLimitPerIndex` feature gate is enabled (enabled by default).
            """
            return self._set("max_failed_indexes", value)

        def parallelism(self, value: Optional[int], /) -> Self:
            """
            Specifies the maximum desired number of pods the job should run at any given time. The actual number of pods running in steady state will be less than this number when ((.spec.completions - .status.successful) < .spec.parallelism), i.e. when the work left to do is less than max parallelism. More info: https://kubernetes.io/docs/concepts/workloads/controllers/jobs-run-to-completion/
            """
            return self._set("parallelism", value)

        @overload
        def pod_failure_policy(
            self, value_or_callback: Optional[PodFailurePolicy], /
        ) -> "JobSpec.Builder": ...

        @overload
        def pod_failure_policy(
            self,
            value_or_callback: Callable[
                [PodFailurePolicy.Builder], PodFailurePolicy.Builder | PodFailurePolicy
            ],
            /,
        ) -> "JobSpec.Builder": ...

        @overload
        def pod_failure_policy(
            self, value_or_callback: Never = ...
        ) -> "PodFailurePolicy.BuilderContext": ...

        def pod_failure_policy(self, value_or_callback=None, /):
            """
            Specifies the policy of handling failed pods. In particular, it allows to specify the set of actions and conditions which need to be satisfied to take the associated action. If empty, the default behaviour applies - the counter of failed pods, represented by the jobs's .status.failed field, is incremented and it is checked against the backoffLimit. This field cannot be used in combination with restartPolicy=OnFailure.
            """
            if self._in_context and value_or_callback is None:
                context = PodFailurePolicy.BuilderContext()
                context._parent_builder = self
                context._field_name = "pod_failure_policy"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(PodFailurePolicy.builder())
                if isinstance(output, PodFailurePolicy.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("pod_failure_policy", value)

        def pod_replacement_policy(self, value: Optional[str], /) -> Self:
            """
            podReplacementPolicy specifies when to create replacement Pods. Possible values are: - TerminatingOrFailed means that we recreate pods
              when they are terminating (has a metadata.deletionTimestamp) or failed.
            - Failed means to wait until a previously created Pod is fully terminated (has phase
              Failed or Succeeded) before creating a replacement Pod.

            When using podFailurePolicy, Failed is the the only allowed value. TerminatingOrFailed and Failed are allowed values when podFailurePolicy is not in use. This is an beta field. To use this, enable the JobPodReplacementPolicy feature toggle. This is on by default.
            """
            return self._set("pod_replacement_policy", value)

        @overload
        def selector(
            self, value_or_callback: Optional[apimachinery.LabelSelector], /
        ) -> "JobSpec.Builder": ...

        @overload
        def selector(
            self,
            value_or_callback: Callable[
                [apimachinery.LabelSelector.Builder],
                apimachinery.LabelSelector.Builder | apimachinery.LabelSelector,
            ],
            /,
        ) -> "JobSpec.Builder": ...

        @overload
        def selector(
            self, value_or_callback: Never = ...
        ) -> "apimachinery.LabelSelector.BuilderContext": ...

        def selector(self, value_or_callback=None, /):
            """
            A label query over pods that should match the pod count. Normally, the system sets this field for you. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/labels/#label-selectors
            """
            if self._in_context and value_or_callback is None:
                context = apimachinery.LabelSelector.BuilderContext()
                context._parent_builder = self
                context._field_name = "selector"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(apimachinery.LabelSelector.builder())
                if isinstance(output, apimachinery.LabelSelector.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("selector", value)

        @overload
        def success_policy(
            self, value_or_callback: Optional[SuccessPolicy], /
        ) -> "JobSpec.Builder": ...

        @overload
        def success_policy(
            self,
            value_or_callback: Callable[
                [SuccessPolicy.Builder], SuccessPolicy.Builder | SuccessPolicy
            ],
            /,
        ) -> "JobSpec.Builder": ...

        @overload
        def success_policy(
            self, value_or_callback: Never = ...
        ) -> "SuccessPolicy.BuilderContext": ...

        def success_policy(self, value_or_callback=None, /):
            """
            successPolicy specifies the policy when the Job can be declared as succeeded. If empty, the default behavior applies - the Job is declared as succeeded only when the number of succeeded pods equals to the completions. When the field is specified, it must be immutable and works only for the Indexed Jobs. Once the Job meets the SuccessPolicy, the lingering pods are terminated.

            This field is beta-level. To use this field, you must enable the `JobSuccessPolicy` feature gate (enabled by default).
            """
            if self._in_context and value_or_callback is None:
                context = SuccessPolicy.BuilderContext()
                context._parent_builder = self
                context._field_name = "success_policy"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(SuccessPolicy.builder())
                if isinstance(output, SuccessPolicy.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("success_policy", value)

        def suspend(self, value: Optional[bool], /) -> Self:
            """
            suspend specifies whether the Job controller should create Pods or not. If a Job is created with suspend set to true, no Pods are created by the Job controller. If a Job is suspended after creation (i.e. the flag goes from false to true), the Job controller will delete all active Pods associated with this Job. Users must design their workload to gracefully handle this. Suspending a Job will reset the StartTime field of the Job, effectively resetting the ActiveDeadlineSeconds timer too. Defaults to false.
            """
            return self._set("suspend", value)

        @overload
        def template(self, value_or_callback: v1.PodTemplateSpec, /) -> "JobSpec.Builder": ...

        @overload
        def template(
            self,
            value_or_callback: Callable[
                [v1.PodTemplateSpec.Builder],
                v1.PodTemplateSpec.Builder | v1.PodTemplateSpec,
            ],
            /,
        ) -> "JobSpec.Builder": ...

        @overload
        def template(
            self, value_or_callback: Never = ...
        ) -> "v1.PodTemplateSpec.BuilderContext": ...

        def template(self, value_or_callback=None, /):
            """
            Describes the pod that will be created when executing a job. The only allowed template.spec.restartPolicy values are "Never" or "OnFailure". More info: https://kubernetes.io/docs/concepts/workloads/controllers/jobs-run-to-completion/
            """
            if self._in_context and value_or_callback is None:
                context = v1.PodTemplateSpec.BuilderContext()
                context._parent_builder = self
                context._field_name = "template"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(v1.PodTemplateSpec.builder())
                if isinstance(output, v1.PodTemplateSpec.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("template", value)

        def ttl_seconds_after_finished(self, value: Optional[int], /) -> Self:
            """
            ttlSecondsAfterFinished limits the lifetime of a Job that has finished execution (either Complete or Failed). If this field is set, ttlSecondsAfterFinished after the Job finishes, it is eligible to be automatically deleted. When the Job is being deleted, its lifecycle guarantees (e.g. finalizers) will be honored. If this field is unset, the Job won't be automatically deleted. If this field is set to zero, the Job becomes eligible to be deleted immediately after it finishes.
            """
            return self._set("ttl_seconds_after_finished", value)

    class BuilderContext(BuilderContextBase["JobSpec.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = JobSpec.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for JobSpec."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["JobSpec", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use JobSpec.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    active_deadline_seconds: Annotated[Optional[int], Field(alias="activeDeadlineSeconds")] = None
    """
    Specifies the duration in seconds relative to the startTime that the job may be continuously active before the system tries to terminate it; value must be positive integer. If a Job is suspended (at creation or through an update), this timer will effectively be stopped and reset when the Job is resumed again.
    """
    backoff_limit: Annotated[Optional[int], Field(alias="backoffLimit")] = None
    """
    Specifies the number of retries before marking this job failed. Defaults to 6
    """
    backoff_limit_per_index: Annotated[Optional[int], Field(alias="backoffLimitPerIndex")] = None
    """
    Specifies the limit for the number of retries within an index before marking this index as failed. When enabled the number of failures per index is kept in the pod's batch.kubernetes.io/job-index-failure-count annotation. It can only be set when Job's completionMode=Indexed, and the Pod's restart policy is Never. The field is immutable. This field is beta-level. It can be used when the `JobBackoffLimitPerIndex` feature gate is enabled (enabled by default).
    """
    completion_mode: Annotated[Optional[str], Field(alias="completionMode")] = None
    """
    completionMode specifies how Pod completions are tracked. It can be `NonIndexed` (default) or `Indexed`.

    `NonIndexed` means that the Job is considered complete when there have been .spec.completions successfully completed Pods. Each Pod completion is homologous to each other.

    `Indexed` means that the Pods of a Job get an associated completion index from 0 to (.spec.completions - 1), available in the annotation batch.kubernetes.io/job-completion-index. The Job is considered complete when there is one successfully completed Pod for each index. When value is `Indexed`, .spec.completions must be specified and `.spec.parallelism` must be less than or equal to 10^5. In addition, The Pod name takes the form `$(job-name)-$(index)-$(random-string)`, the Pod hostname takes the form `$(job-name)-$(index)`.

    More completion modes can be added in the future. If the Job controller observes a mode that it doesn't recognize, which is possible during upgrades due to version skew, the controller skips updates for the Job.
    """
    completions: Optional[int] = None
    """
    Specifies the desired number of successfully finished pods the job should be run with.  Setting to null means that the success of any pod signals the success of all pods, and allows parallelism to have any positive value.  Setting to 1 means that parallelism is limited to 1 and the success of that pod signals the success of the job. More info: https://kubernetes.io/docs/concepts/workloads/controllers/jobs-run-to-completion/
    """
    managed_by: Annotated[Optional[str], Field(alias="managedBy")] = None
    """
    ManagedBy field indicates the controller that manages a Job. The k8s Job controller reconciles jobs which don't have this field at all or the field value is the reserved string `kubernetes.io/job-controller`, but skips reconciling Jobs with a custom value for this field. The value must be a valid domain-prefixed path (e.g. acme.io/foo) - all characters before the first "/" must be a valid subdomain as defined by RFC 1123. All characters trailing the first "/" must be valid HTTP Path characters as defined by RFC 3986. The value cannot exceed 63 characters. This field is immutable.

    This field is alpha-level. The job controller accepts setting the field when the feature gate JobManagedBy is enabled (disabled by default).
    """
    manual_selector: Annotated[Optional[bool], Field(alias="manualSelector")] = None
    """
    manualSelector controls generation of pod labels and pod selectors. Leave `manualSelector` unset unless you are certain what you are doing. When false or unset, the system pick labels unique to this job and appends those labels to the pod template.  When true, the user is responsible for picking unique labels and specifying the selector.  Failure to pick a unique label may cause this and other jobs to not function correctly.  However, You may see `manualSelector=true` in jobs that were created with the old `extensions/v1beta1` API. More info: https://kubernetes.io/docs/concepts/workloads/controllers/jobs-run-to-completion/#specifying-your-own-pod-selector
    """
    max_failed_indexes: Annotated[Optional[int], Field(alias="maxFailedIndexes")] = None
    """
    Specifies the maximal number of failed indexes before marking the Job as failed, when backoffLimitPerIndex is set. Once the number of failed indexes exceeds this number the entire Job is marked as Failed and its execution is terminated. When left as null the job continues execution of all of its indexes and is marked with the `Complete` Job condition. It can only be specified when backoffLimitPerIndex is set. It can be null or up to completions. It is required and must be less than or equal to 10^4 when is completions greater than 10^5. This field is beta-level. It can be used when the `JobBackoffLimitPerIndex` feature gate is enabled (enabled by default).
    """
    parallelism: Optional[int] = None
    """
    Specifies the maximum desired number of pods the job should run at any given time. The actual number of pods running in steady state will be less than this number when ((.spec.completions - .status.successful) < .spec.parallelism), i.e. when the work left to do is less than max parallelism. More info: https://kubernetes.io/docs/concepts/workloads/controllers/jobs-run-to-completion/
    """
    pod_failure_policy: Annotated[Optional[PodFailurePolicy], Field(alias="podFailurePolicy")] = (
        None
    )
    """
    Specifies the policy of handling failed pods. In particular, it allows to specify the set of actions and conditions which need to be satisfied to take the associated action. If empty, the default behaviour applies - the counter of failed pods, represented by the jobs's .status.failed field, is incremented and it is checked against the backoffLimit. This field cannot be used in combination with restartPolicy=OnFailure.
    """
    pod_replacement_policy: Annotated[Optional[str], Field(alias="podReplacementPolicy")] = None
    """
    podReplacementPolicy specifies when to create replacement Pods. Possible values are: - TerminatingOrFailed means that we recreate pods
      when they are terminating (has a metadata.deletionTimestamp) or failed.
    - Failed means to wait until a previously created Pod is fully terminated (has phase
      Failed or Succeeded) before creating a replacement Pod.

    When using podFailurePolicy, Failed is the the only allowed value. TerminatingOrFailed and Failed are allowed values when podFailurePolicy is not in use. This is an beta field. To use this, enable the JobPodReplacementPolicy feature toggle. This is on by default.
    """
    selector: Optional[apimachinery.LabelSelector] = None
    """
    A label query over pods that should match the pod count. Normally, the system sets this field for you. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/labels/#label-selectors
    """
    success_policy: Annotated[Optional[SuccessPolicy], Field(alias="successPolicy")] = None
    """
    successPolicy specifies the policy when the Job can be declared as succeeded. If empty, the default behavior applies - the Job is declared as succeeded only when the number of succeeded pods equals to the completions. When the field is specified, it must be immutable and works only for the Indexed Jobs. Once the Job meets the SuccessPolicy, the lingering pods are terminated.

    This field is beta-level. To use this field, you must enable the `JobSuccessPolicy` feature gate (enabled by default).
    """
    suspend: Optional[bool] = None
    """
    suspend specifies whether the Job controller should create Pods or not. If a Job is created with suspend set to true, no Pods are created by the Job controller. If a Job is suspended after creation (i.e. the flag goes from false to true), the Job controller will delete all active Pods associated with this Job. Users must design their workload to gracefully handle this. Suspending a Job will reset the StartTime field of the Job, effectively resetting the ActiveDeadlineSeconds timer too. Defaults to false.
    """
    template: v1.PodTemplateSpec
    """
    Describes the pod that will be created when executing a job. The only allowed template.spec.restartPolicy values are "Never" or "OnFailure". More info: https://kubernetes.io/docs/concepts/workloads/controllers/jobs-run-to-completion/
    """
    ttl_seconds_after_finished: Annotated[Optional[int], Field(alias="ttlSecondsAfterFinished")] = (
        None
    )
    """
    ttlSecondsAfterFinished limits the lifetime of a Job that has finished execution (either Complete or Failed). If this field is set, ttlSecondsAfterFinished after the Job finishes, it is eligible to be automatically deleted. When the Job is being deleted, its lifecycle guarantees (e.g. finalizers) will be honored. If this field is unset, the Job won't be automatically deleted. If this field is set to zero, the Job becomes eligible to be deleted immediately after it finishes.
    """


class JobTemplateSpec(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["JobTemplateSpec"]:
            return JobTemplateSpec

        def build(self) -> "JobTemplateSpec":
            return JobTemplateSpec(**self._attrs)

        @overload
        def metadata(
            self, value_or_callback: Optional[apimachinery.ObjectMeta], /
        ) -> "JobTemplateSpec.Builder": ...

        @overload
        def metadata(
            self,
            value_or_callback: Callable[
                [apimachinery.ObjectMeta.Builder],
                apimachinery.ObjectMeta.Builder | apimachinery.ObjectMeta,
            ],
            /,
        ) -> "JobTemplateSpec.Builder": ...

        @overload
        def metadata(
            self, value_or_callback: Never = ...
        ) -> "apimachinery.ObjectMeta.BuilderContext": ...

        def metadata(self, value_or_callback=None, /):
            """
            Standard object's metadata of the jobs created from this template. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
            """
            if self._in_context and value_or_callback is None:
                context = apimachinery.ObjectMeta.BuilderContext()
                context._parent_builder = self
                context._field_name = "metadata"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(apimachinery.ObjectMeta.builder())
                if isinstance(output, apimachinery.ObjectMeta.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("metadata", value)

        @overload
        def spec(self, value_or_callback: Optional[JobSpec], /) -> "JobTemplateSpec.Builder": ...

        @overload
        def spec(
            self,
            value_or_callback: Callable[[JobSpec.Builder], JobSpec.Builder | JobSpec],
            /,
        ) -> "JobTemplateSpec.Builder": ...

        @overload
        def spec(self, value_or_callback: Never = ...) -> "JobSpec.BuilderContext": ...

        def spec(self, value_or_callback=None, /):
            """
            Specification of the desired behavior of the job. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
            """
            if self._in_context and value_or_callback is None:
                context = JobSpec.BuilderContext()
                context._parent_builder = self
                context._field_name = "spec"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(JobSpec.builder())
                if isinstance(output, JobSpec.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("spec", value)

    class BuilderContext(BuilderContextBase["JobTemplateSpec.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = JobTemplateSpec.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for JobTemplateSpec."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["JobTemplateSpec", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use JobTemplateSpec.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    metadata: Optional[apimachinery.ObjectMeta] = None
    """
    Standard object's metadata of the jobs created from this template. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
    """
    spec: Optional[JobSpec] = None
    """
    Specification of the desired behavior of the job. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
    """


class CronJobSpec(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["CronJobSpec"]:
            return CronJobSpec

        def build(self) -> "CronJobSpec":
            return CronJobSpec(**self._attrs)

        def concurrency_policy(self, value: Optional[str], /) -> Self:
            """
            Specifies how to treat concurrent executions of a Job. Valid values are:

            - "Allow" (default): allows CronJobs to run concurrently; - "Forbid": forbids concurrent runs, skipping next run if previous run hasn't finished yet; - "Replace": cancels currently running job and replaces it with a new one
            """
            return self._set("concurrency_policy", value)

        def failed_jobs_history_limit(self, value: Optional[int], /) -> Self:
            """
            The number of failed finished jobs to retain. Value must be non-negative integer. Defaults to 1.
            """
            return self._set("failed_jobs_history_limit", value)

        @overload
        def job_template(self, value_or_callback: JobTemplateSpec, /) -> "CronJobSpec.Builder": ...

        @overload
        def job_template(
            self,
            value_or_callback: Callable[
                [JobTemplateSpec.Builder], JobTemplateSpec.Builder | JobTemplateSpec
            ],
            /,
        ) -> "CronJobSpec.Builder": ...

        @overload
        def job_template(
            self, value_or_callback: Never = ...
        ) -> "JobTemplateSpec.BuilderContext": ...

        def job_template(self, value_or_callback=None, /):
            """
            Specifies the job that will be created when executing a CronJob.
            """
            if self._in_context and value_or_callback is None:
                context = JobTemplateSpec.BuilderContext()
                context._parent_builder = self
                context._field_name = "job_template"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(JobTemplateSpec.builder())
                if isinstance(output, JobTemplateSpec.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("job_template", value)

        def schedule(self, value: str, /) -> Self:
            """
            The schedule in Cron format, see https://en.wikipedia.org/wiki/Cron.
            """
            return self._set("schedule", value)

        def starting_deadline_seconds(self, value: Optional[int], /) -> Self:
            """
            Optional deadline in seconds for starting the job if it misses scheduled time for any reason.  Missed jobs executions will be counted as failed ones.
            """
            return self._set("starting_deadline_seconds", value)

        def successful_jobs_history_limit(self, value: Optional[int], /) -> Self:
            """
            The number of successful finished jobs to retain. Value must be non-negative integer. Defaults to 3.
            """
            return self._set("successful_jobs_history_limit", value)

        def suspend(self, value: Optional[bool], /) -> Self:
            """
            This flag tells the controller to suspend subsequent executions, it does not apply to already started executions.  Defaults to false.
            """
            return self._set("suspend", value)

        def time_zone(self, value: Optional[str], /) -> Self:
            """
            The time zone name for the given schedule, see https://en.wikipedia.org/wiki/List_of_tz_database_time_zones. If not specified, this will default to the time zone of the kube-controller-manager process. The set of valid time zone names and the time zone offset is loaded from the system-wide time zone database by the API server during CronJob validation and the controller manager during execution. If no system-wide time zone database can be found a bundled version of the database is used instead. If the time zone name becomes invalid during the lifetime of a CronJob or due to a change in host configuration, the controller will stop creating new new Jobs and will create a system event with the reason UnknownTimeZone. More information can be found in https://kubernetes.io/docs/concepts/workloads/controllers/cron-jobs/#time-zones
            """
            return self._set("time_zone", value)

    class BuilderContext(BuilderContextBase["CronJobSpec.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = CronJobSpec.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for CronJobSpec."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["CronJobSpec", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use CronJobSpec.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    concurrency_policy: Annotated[Optional[str], Field(alias="concurrencyPolicy")] = None
    """
    Specifies how to treat concurrent executions of a Job. Valid values are:

    - "Allow" (default): allows CronJobs to run concurrently; - "Forbid": forbids concurrent runs, skipping next run if previous run hasn't finished yet; - "Replace": cancels currently running job and replaces it with a new one
    """
    failed_jobs_history_limit: Annotated[Optional[int], Field(alias="failedJobsHistoryLimit")] = (
        None
    )
    """
    The number of failed finished jobs to retain. Value must be non-negative integer. Defaults to 1.
    """
    job_template: Annotated[JobTemplateSpec, Field(alias="jobTemplate")]
    """
    Specifies the job that will be created when executing a CronJob.
    """
    schedule: str
    """
    The schedule in Cron format, see https://en.wikipedia.org/wiki/Cron.
    """
    starting_deadline_seconds: Annotated[Optional[int], Field(alias="startingDeadlineSeconds")] = (
        None
    )
    """
    Optional deadline in seconds for starting the job if it misses scheduled time for any reason.  Missed jobs executions will be counted as failed ones.
    """
    successful_jobs_history_limit: Annotated[
        Optional[int], Field(alias="successfulJobsHistoryLimit")
    ] = None
    """
    The number of successful finished jobs to retain. Value must be non-negative integer. Defaults to 3.
    """
    suspend: Optional[bool] = None
    """
    This flag tells the controller to suspend subsequent executions, it does not apply to already started executions.  Defaults to false.
    """
    time_zone: Annotated[Optional[str], Field(alias="timeZone")] = None
    """
    The time zone name for the given schedule, see https://en.wikipedia.org/wiki/List_of_tz_database_time_zones. If not specified, this will default to the time zone of the kube-controller-manager process. The set of valid time zone names and the time zone offset is loaded from the system-wide time zone database by the API server during CronJob validation and the controller manager during execution. If no system-wide time zone database can be found a bundled version of the database is used instead. If the time zone name becomes invalid during the lifetime of a CronJob or due to a change in host configuration, the controller will stop creating new new Jobs and will create a system event with the reason UnknownTimeZone. More information can be found in https://kubernetes.io/docs/concepts/workloads/controllers/cron-jobs/#time-zones
    """


class Job(Resource):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["Job"]:
            return Job

        def build(self) -> "Job":
            return Job(**self._attrs)

        def api_version(self, value: Optional[Literal["batch/v1"]], /) -> Self:
            """
            APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
            """
            return self._set("api_version", value)

        def kind(self, value: Optional[Literal["Job"]], /) -> Self:
            """
            Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
            """
            return self._set("kind", value)

        @overload
        def metadata(
            self, value_or_callback: Optional[apimachinery.ObjectMeta], /
        ) -> "Job.Builder": ...

        @overload
        def metadata(
            self,
            value_or_callback: Callable[
                [apimachinery.ObjectMeta.Builder],
                apimachinery.ObjectMeta.Builder | apimachinery.ObjectMeta,
            ],
            /,
        ) -> "Job.Builder": ...

        @overload
        def metadata(
            self, value_or_callback: Never = ...
        ) -> "apimachinery.ObjectMeta.BuilderContext": ...

        def metadata(self, value_or_callback=None, /):
            """
            Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
            """
            if self._in_context and value_or_callback is None:
                context = apimachinery.ObjectMeta.BuilderContext()
                context._parent_builder = self
                context._field_name = "metadata"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(apimachinery.ObjectMeta.builder())
                if isinstance(output, apimachinery.ObjectMeta.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("metadata", value)

        @overload
        def spec(self, value_or_callback: Optional[JobSpec], /) -> "Job.Builder": ...

        @overload
        def spec(
            self,
            value_or_callback: Callable[[JobSpec.Builder], JobSpec.Builder | JobSpec],
            /,
        ) -> "Job.Builder": ...

        @overload
        def spec(self, value_or_callback: Never = ...) -> "JobSpec.BuilderContext": ...

        def spec(self, value_or_callback=None, /):
            """
            Specification of the desired behavior of a job. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
            """
            if self._in_context and value_or_callback is None:
                context = JobSpec.BuilderContext()
                context._parent_builder = self
                context._field_name = "spec"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(JobSpec.builder())
                if isinstance(output, JobSpec.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("spec", value)

        @overload
        def status(self, value_or_callback: Optional[JobStatus], /) -> "Job.Builder": ...

        @overload
        def status(
            self,
            value_or_callback: Callable[[JobStatus.Builder], JobStatus.Builder | JobStatus],
            /,
        ) -> "Job.Builder": ...

        @overload
        def status(self, value_or_callback: Never = ...) -> "JobStatus.BuilderContext": ...

        def status(self, value_or_callback=None, /):
            """
            Current status of a job. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
            """
            if self._in_context and value_or_callback is None:
                context = JobStatus.BuilderContext()
                context._parent_builder = self
                context._field_name = "status"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(JobStatus.builder())
                if isinstance(output, JobStatus.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("status", value)

    class BuilderContext(BuilderContextBase["Job.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = Job.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for Job."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["Job", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use Job.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    api_version: Annotated[Optional[Literal["batch/v1"]], Field(alias="apiVersion")] = "batch/v1"
    """
    APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
    """
    kind: Optional[Literal["Job"]] = "Job"
    """
    Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
    """
    metadata: Optional[apimachinery.ObjectMeta] = None
    """
    Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
    """
    spec: Optional[JobSpec] = None
    """
    Specification of the desired behavior of a job. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
    """
    status: Optional[JobStatus] = None
    """
    Current status of a job. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
    """


JobList = ResourceList["Job"]


class CronJob(Resource):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["CronJob"]:
            return CronJob

        def build(self) -> "CronJob":
            return CronJob(**self._attrs)

        def api_version(self, value: Optional[Literal["batch/v1"]], /) -> Self:
            """
            APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
            """
            return self._set("api_version", value)

        def kind(self, value: Optional[Literal["CronJob"]], /) -> Self:
            """
            Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
            """
            return self._set("kind", value)

        @overload
        def metadata(
            self, value_or_callback: Optional[apimachinery.ObjectMeta], /
        ) -> "CronJob.Builder": ...

        @overload
        def metadata(
            self,
            value_or_callback: Callable[
                [apimachinery.ObjectMeta.Builder],
                apimachinery.ObjectMeta.Builder | apimachinery.ObjectMeta,
            ],
            /,
        ) -> "CronJob.Builder": ...

        @overload
        def metadata(
            self, value_or_callback: Never = ...
        ) -> "apimachinery.ObjectMeta.BuilderContext": ...

        def metadata(self, value_or_callback=None, /):
            """
            Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
            """
            if self._in_context and value_or_callback is None:
                context = apimachinery.ObjectMeta.BuilderContext()
                context._parent_builder = self
                context._field_name = "metadata"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(apimachinery.ObjectMeta.builder())
                if isinstance(output, apimachinery.ObjectMeta.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("metadata", value)

        @overload
        def spec(self, value_or_callback: Optional[CronJobSpec], /) -> "CronJob.Builder": ...

        @overload
        def spec(
            self,
            value_or_callback: Callable[[CronJobSpec.Builder], CronJobSpec.Builder | CronJobSpec],
            /,
        ) -> "CronJob.Builder": ...

        @overload
        def spec(self, value_or_callback: Never = ...) -> "CronJobSpec.BuilderContext": ...

        def spec(self, value_or_callback=None, /):
            """
            Specification of the desired behavior of a cron job, including the schedule. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
            """
            if self._in_context and value_or_callback is None:
                context = CronJobSpec.BuilderContext()
                context._parent_builder = self
                context._field_name = "spec"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(CronJobSpec.builder())
                if isinstance(output, CronJobSpec.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("spec", value)

        @overload
        def status(self, value_or_callback: Optional[CronJobStatus], /) -> "CronJob.Builder": ...

        @overload
        def status(
            self,
            value_or_callback: Callable[
                [CronJobStatus.Builder], CronJobStatus.Builder | CronJobStatus
            ],
            /,
        ) -> "CronJob.Builder": ...

        @overload
        def status(self, value_or_callback: Never = ...) -> "CronJobStatus.BuilderContext": ...

        def status(self, value_or_callback=None, /):
            """
            Current status of a cron job. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
            """
            if self._in_context and value_or_callback is None:
                context = CronJobStatus.BuilderContext()
                context._parent_builder = self
                context._field_name = "status"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(CronJobStatus.builder())
                if isinstance(output, CronJobStatus.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("status", value)

    class BuilderContext(BuilderContextBase["CronJob.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = CronJob.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for CronJob."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["CronJob", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use CronJob.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    api_version: Annotated[Optional[Literal["batch/v1"]], Field(alias="apiVersion")] = "batch/v1"
    """
    APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
    """
    kind: Optional[Literal["CronJob"]] = "CronJob"
    """
    Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
    """
    metadata: Optional[apimachinery.ObjectMeta] = None
    """
    Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
    """
    spec: Optional[CronJobSpec] = None
    """
    Specification of the desired behavior of a cron job, including the schedule. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
    """
    status: Optional[CronJobStatus] = None
    """
    Current status of a cron job. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
    """


CronJobList = ResourceList["CronJob"]
