# Generated by cloudcoil-model-codegen v0.5.0
# DO NOT EDIT

from __future__ import annotations

from typing import (
    Annotated,
    Callable,
    List,
    Literal,
    Optional,
    Type,
    overload,
)

from pydantic import Field

from cloudcoil import apimachinery
from cloudcoil.pydantic import (
    BaseModel,
    BaseModelBuilder,
    BuilderContextBase,
    GenericListBuilder,
    ListBuilderContext,
    Never,
    Self,
)
from cloudcoil.resources import Resource, ResourceList


class CrossVersionObjectReference(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["CrossVersionObjectReference"]:
            return CrossVersionObjectReference

        def build(self) -> "CrossVersionObjectReference":
            return CrossVersionObjectReference(**self._attrs)

        def api_version(self, value: Optional[str], /) -> Self:
            """
            apiVersion is the API version of the referent
            """
            return self._set("api_version", value)

        def kind(self, value: str, /) -> Self:
            """
            kind is the kind of the referent; More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
            """
            return self._set("kind", value)

        def name(self, value: str, /) -> Self:
            """
            name is the name of the referent; More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names
            """
            return self._set("name", value)

    class BuilderContext(BuilderContextBase["CrossVersionObjectReference.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = CrossVersionObjectReference.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for CrossVersionObjectReference."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["CrossVersionObjectReference", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use CrossVersionObjectReference.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    api_version: Annotated[Optional[str], Field(alias="apiVersion")] = None
    """
    apiVersion is the API version of the referent
    """
    kind: str
    """
    kind is the kind of the referent; More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
    """
    name: str
    """
    name is the name of the referent; More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names
    """


class HPAScalingPolicy(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["HPAScalingPolicy"]:
            return HPAScalingPolicy

        def build(self) -> "HPAScalingPolicy":
            return HPAScalingPolicy(**self._attrs)

        def period_seconds(self, value: int, /) -> Self:
            """
            periodSeconds specifies the window of time for which the policy should hold true. PeriodSeconds must be greater than zero and less than or equal to 1800 (30 min).
            """
            return self._set("period_seconds", value)

        def type(self, value: str, /) -> Self:
            """
            type is used to specify the scaling policy.
            """
            return self._set("type", value)

        def value(self, value: int, /) -> Self:
            """
            value contains the amount of change which is permitted by the policy. It must be greater than zero
            """
            return self._set("value", value)

    class BuilderContext(BuilderContextBase["HPAScalingPolicy.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = HPAScalingPolicy.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for HPAScalingPolicy."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["HPAScalingPolicy", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use HPAScalingPolicy.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    period_seconds: Annotated[int, Field(alias="periodSeconds")]
    """
    periodSeconds specifies the window of time for which the policy should hold true. PeriodSeconds must be greater than zero and less than or equal to 1800 (30 min).
    """
    type: str
    """
    type is used to specify the scaling policy.
    """
    value: int
    """
    value contains the amount of change which is permitted by the policy. It must be greater than zero
    """


class HPAScalingRules(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["HPAScalingRules"]:
            return HPAScalingRules

        def build(self) -> "HPAScalingRules":
            return HPAScalingRules(**self._attrs)

        @overload
        def policies(
            self, value_or_callback: List[HPAScalingPolicy], /
        ) -> "HPAScalingRules.Builder": ...

        @overload
        def policies(
            self,
            value_or_callback: Callable[
                [GenericListBuilder[HPAScalingPolicy, HPAScalingPolicy.Builder]],
                GenericListBuilder[HPAScalingPolicy, HPAScalingPolicy.Builder]
                | List[HPAScalingPolicy],
            ],
            /,
        ) -> "HPAScalingRules.Builder": ...

        @overload
        def policies(
            self, value_or_callback: Never = ...
        ) -> ListBuilderContext[HPAScalingPolicy.Builder]: ...

        def policies(self, value_or_callback=None, /):
            """
            policies is a list of potential scaling polices which can be used during scaling. At least one policy must be specified, otherwise the HPAScalingRules will be discarded as invalid
            """
            if self._in_context and value_or_callback is None:
                context = ListBuilderContext[HPAScalingPolicy.Builder]()
                context._parent_builder = self
                context._field_name = "policies"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(HPAScalingPolicy.list_builder())
                if isinstance(output, GenericListBuilder):
                    value = output.build()
                else:
                    value = output
            return self._set("policies", value)

        def select_policy(self, value: Optional[str], /) -> Self:
            """
            selectPolicy is used to specify which policy should be used. If not set, the default value Max is used.
            """
            return self._set("select_policy", value)

        def stabilization_window_seconds(self, value: Optional[int], /) -> Self:
            """
            stabilizationWindowSeconds is the number of seconds for which past recommendations should be considered while scaling up or scaling down. StabilizationWindowSeconds must be greater than or equal to zero and less than or equal to 3600 (one hour). If not set, use the default values: - For scale up: 0 (i.e. no stabilization is done). - For scale down: 300 (i.e. the stabilization window is 300 seconds long).
            """
            return self._set("stabilization_window_seconds", value)

    class BuilderContext(BuilderContextBase["HPAScalingRules.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = HPAScalingRules.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for HPAScalingRules."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["HPAScalingRules", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use HPAScalingRules.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    policies: Optional[List[HPAScalingPolicy]] = None
    """
    policies is a list of potential scaling polices which can be used during scaling. At least one policy must be specified, otherwise the HPAScalingRules will be discarded as invalid
    """
    select_policy: Annotated[Optional[str], Field(alias="selectPolicy")] = None
    """
    selectPolicy is used to specify which policy should be used. If not set, the default value Max is used.
    """
    stabilization_window_seconds: Annotated[
        Optional[int], Field(alias="stabilizationWindowSeconds")
    ] = None
    """
    stabilizationWindowSeconds is the number of seconds for which past recommendations should be considered while scaling up or scaling down. StabilizationWindowSeconds must be greater than or equal to zero and less than or equal to 3600 (one hour). If not set, use the default values: - For scale up: 0 (i.e. no stabilization is done). - For scale down: 300 (i.e. the stabilization window is 300 seconds long).
    """


class HorizontalPodAutoscalerBehavior(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["HorizontalPodAutoscalerBehavior"]:
            return HorizontalPodAutoscalerBehavior

        def build(self) -> "HorizontalPodAutoscalerBehavior":
            return HorizontalPodAutoscalerBehavior(**self._attrs)

        @overload
        def scale_down(
            self, value_or_callback: Optional[HPAScalingRules], /
        ) -> "HorizontalPodAutoscalerBehavior.Builder": ...

        @overload
        def scale_down(
            self,
            value_or_callback: Callable[
                [HPAScalingRules.Builder], HPAScalingRules.Builder | HPAScalingRules
            ],
            /,
        ) -> "HorizontalPodAutoscalerBehavior.Builder": ...

        @overload
        def scale_down(
            self, value_or_callback: Never = ...
        ) -> "HPAScalingRules.BuilderContext": ...

        def scale_down(self, value_or_callback=None, /):
            """
            scaleDown is scaling policy for scaling Down. If not set, the default value is to allow to scale down to minReplicas pods, with a 300 second stabilization window (i.e., the highest recommendation for the last 300sec is used).
            """
            if self._in_context and value_or_callback is None:
                context = HPAScalingRules.BuilderContext()
                context._parent_builder = self
                context._field_name = "scale_down"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(HPAScalingRules.builder())
                if isinstance(output, HPAScalingRules.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("scale_down", value)

        @overload
        def scale_up(
            self, value_or_callback: Optional[HPAScalingRules], /
        ) -> "HorizontalPodAutoscalerBehavior.Builder": ...

        @overload
        def scale_up(
            self,
            value_or_callback: Callable[
                [HPAScalingRules.Builder], HPAScalingRules.Builder | HPAScalingRules
            ],
            /,
        ) -> "HorizontalPodAutoscalerBehavior.Builder": ...

        @overload
        def scale_up(self, value_or_callback: Never = ...) -> "HPAScalingRules.BuilderContext": ...

        def scale_up(self, value_or_callback=None, /):
            """
            scaleUp is scaling policy for scaling Up. If not set, the default value is the higher of:
              * increase no more than 4 pods per 60 seconds
              * double the number of pods per 60 seconds
            No stabilization is used.
            """
            if self._in_context and value_or_callback is None:
                context = HPAScalingRules.BuilderContext()
                context._parent_builder = self
                context._field_name = "scale_up"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(HPAScalingRules.builder())
                if isinstance(output, HPAScalingRules.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("scale_up", value)

    class BuilderContext(BuilderContextBase["HorizontalPodAutoscalerBehavior.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = HorizontalPodAutoscalerBehavior.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for HorizontalPodAutoscalerBehavior."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["HorizontalPodAutoscalerBehavior", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use HorizontalPodAutoscalerBehavior.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    scale_down: Annotated[Optional[HPAScalingRules], Field(alias="scaleDown")] = None
    """
    scaleDown is scaling policy for scaling Down. If not set, the default value is to allow to scale down to minReplicas pods, with a 300 second stabilization window (i.e., the highest recommendation for the last 300sec is used).
    """
    scale_up: Annotated[Optional[HPAScalingRules], Field(alias="scaleUp")] = None
    """
    scaleUp is scaling policy for scaling Up. If not set, the default value is the higher of:
      * increase no more than 4 pods per 60 seconds
      * double the number of pods per 60 seconds
    No stabilization is used.
    """


class HorizontalPodAutoscalerCondition(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["HorizontalPodAutoscalerCondition"]:
            return HorizontalPodAutoscalerCondition

        def build(self) -> "HorizontalPodAutoscalerCondition":
            return HorizontalPodAutoscalerCondition(**self._attrs)

        @overload
        def last_transition_time(
            self, value_or_callback: Optional[apimachinery.Time], /
        ) -> "HorizontalPodAutoscalerCondition.Builder": ...

        @overload
        def last_transition_time(
            self,
            value_or_callback: Callable[
                [apimachinery.Time.Builder],
                apimachinery.Time.Builder | apimachinery.Time,
            ],
            /,
        ) -> "HorizontalPodAutoscalerCondition.Builder": ...

        @overload
        def last_transition_time(
            self, value_or_callback: Never = ...
        ) -> "apimachinery.Time.BuilderContext": ...

        def last_transition_time(self, value_or_callback=None, /):
            """
            lastTransitionTime is the last time the condition transitioned from one status to another
            """
            if self._in_context and value_or_callback is None:
                context = apimachinery.Time.BuilderContext()
                context._parent_builder = self
                context._field_name = "last_transition_time"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(apimachinery.Time.builder())
                if isinstance(output, apimachinery.Time.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("last_transition_time", value)

        def message(self, value: Optional[str], /) -> Self:
            """
            message is a human-readable explanation containing details about the transition
            """
            return self._set("message", value)

        def reason(self, value: Optional[str], /) -> Self:
            """
            reason is the reason for the condition's last transition.
            """
            return self._set("reason", value)

        def status(self, value: str, /) -> Self:
            """
            status is the status of the condition (True, False, Unknown)
            """
            return self._set("status", value)

        def type(self, value: str, /) -> Self:
            """
            type describes the current condition
            """
            return self._set("type", value)

    class BuilderContext(BuilderContextBase["HorizontalPodAutoscalerCondition.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = HorizontalPodAutoscalerCondition.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for HorizontalPodAutoscalerCondition."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["HorizontalPodAutoscalerCondition", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use HorizontalPodAutoscalerCondition.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    last_transition_time: Annotated[
        Optional[apimachinery.Time], Field(alias="lastTransitionTime")
    ] = None
    """
    lastTransitionTime is the last time the condition transitioned from one status to another
    """
    message: Optional[str] = None
    """
    message is a human-readable explanation containing details about the transition
    """
    reason: Optional[str] = None
    """
    reason is the reason for the condition's last transition.
    """
    status: str
    """
    status is the status of the condition (True, False, Unknown)
    """
    type: str
    """
    type describes the current condition
    """


class MetricTarget(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["MetricTarget"]:
            return MetricTarget

        def build(self) -> "MetricTarget":
            return MetricTarget(**self._attrs)

        def average_utilization(self, value: Optional[int], /) -> Self:
            """
            averageUtilization is the target value of the average of the resource metric across all relevant pods, represented as a percentage of the requested value of the resource for the pods. Currently only valid for Resource metric source type
            """
            return self._set("average_utilization", value)

        @overload
        def average_value(
            self, value_or_callback: Optional[apimachinery.Quantity], /
        ) -> "MetricTarget.Builder": ...

        @overload
        def average_value(
            self,
            value_or_callback: Callable[
                [apimachinery.Quantity.Builder],
                apimachinery.Quantity.Builder | apimachinery.Quantity,
            ],
            /,
        ) -> "MetricTarget.Builder": ...

        @overload
        def average_value(
            self, value_or_callback: Never = ...
        ) -> "apimachinery.Quantity.BuilderContext": ...

        def average_value(self, value_or_callback=None, /):
            """
            averageValue is the target value of the average of the metric across all relevant pods (as a quantity)
            """
            if self._in_context and value_or_callback is None:
                context = apimachinery.Quantity.BuilderContext()
                context._parent_builder = self
                context._field_name = "average_value"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(apimachinery.Quantity.builder())
                if isinstance(output, apimachinery.Quantity.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("average_value", value)

        def type(self, value: str, /) -> Self:
            """
            type represents whether the metric type is Utilization, Value, or AverageValue
            """
            return self._set("type", value)

        @overload
        def value(
            self, value_or_callback: Optional[apimachinery.Quantity], /
        ) -> "MetricTarget.Builder": ...

        @overload
        def value(
            self,
            value_or_callback: Callable[
                [apimachinery.Quantity.Builder],
                apimachinery.Quantity.Builder | apimachinery.Quantity,
            ],
            /,
        ) -> "MetricTarget.Builder": ...

        @overload
        def value(
            self, value_or_callback: Never = ...
        ) -> "apimachinery.Quantity.BuilderContext": ...

        def value(self, value_or_callback=None, /):
            """
            value is the target value of the metric (as a quantity).
            """
            if self._in_context and value_or_callback is None:
                context = apimachinery.Quantity.BuilderContext()
                context._parent_builder = self
                context._field_name = "value"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(apimachinery.Quantity.builder())
                if isinstance(output, apimachinery.Quantity.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("value", value)

    class BuilderContext(BuilderContextBase["MetricTarget.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = MetricTarget.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for MetricTarget."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["MetricTarget", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use MetricTarget.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    average_utilization: Annotated[Optional[int], Field(alias="averageUtilization")] = None
    """
    averageUtilization is the target value of the average of the resource metric across all relevant pods, represented as a percentage of the requested value of the resource for the pods. Currently only valid for Resource metric source type
    """
    average_value: Annotated[Optional[apimachinery.Quantity], Field(alias="averageValue")] = None
    """
    averageValue is the target value of the average of the metric across all relevant pods (as a quantity)
    """
    type: str
    """
    type represents whether the metric type is Utilization, Value, or AverageValue
    """
    value: Optional[apimachinery.Quantity] = None
    """
    value is the target value of the metric (as a quantity).
    """


class MetricValueStatus(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["MetricValueStatus"]:
            return MetricValueStatus

        def build(self) -> "MetricValueStatus":
            return MetricValueStatus(**self._attrs)

        def average_utilization(self, value: Optional[int], /) -> Self:
            """
            currentAverageUtilization is the current value of the average of the resource metric across all relevant pods, represented as a percentage of the requested value of the resource for the pods.
            """
            return self._set("average_utilization", value)

        @overload
        def average_value(
            self, value_or_callback: Optional[apimachinery.Quantity], /
        ) -> "MetricValueStatus.Builder": ...

        @overload
        def average_value(
            self,
            value_or_callback: Callable[
                [apimachinery.Quantity.Builder],
                apimachinery.Quantity.Builder | apimachinery.Quantity,
            ],
            /,
        ) -> "MetricValueStatus.Builder": ...

        @overload
        def average_value(
            self, value_or_callback: Never = ...
        ) -> "apimachinery.Quantity.BuilderContext": ...

        def average_value(self, value_or_callback=None, /):
            """
            averageValue is the current value of the average of the metric across all relevant pods (as a quantity)
            """
            if self._in_context and value_or_callback is None:
                context = apimachinery.Quantity.BuilderContext()
                context._parent_builder = self
                context._field_name = "average_value"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(apimachinery.Quantity.builder())
                if isinstance(output, apimachinery.Quantity.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("average_value", value)

        @overload
        def value(
            self, value_or_callback: Optional[apimachinery.Quantity], /
        ) -> "MetricValueStatus.Builder": ...

        @overload
        def value(
            self,
            value_or_callback: Callable[
                [apimachinery.Quantity.Builder],
                apimachinery.Quantity.Builder | apimachinery.Quantity,
            ],
            /,
        ) -> "MetricValueStatus.Builder": ...

        @overload
        def value(
            self, value_or_callback: Never = ...
        ) -> "apimachinery.Quantity.BuilderContext": ...

        def value(self, value_or_callback=None, /):
            """
            value is the current value of the metric (as a quantity).
            """
            if self._in_context and value_or_callback is None:
                context = apimachinery.Quantity.BuilderContext()
                context._parent_builder = self
                context._field_name = "value"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(apimachinery.Quantity.builder())
                if isinstance(output, apimachinery.Quantity.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("value", value)

    class BuilderContext(BuilderContextBase["MetricValueStatus.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = MetricValueStatus.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for MetricValueStatus."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["MetricValueStatus", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use MetricValueStatus.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    average_utilization: Annotated[Optional[int], Field(alias="averageUtilization")] = None
    """
    currentAverageUtilization is the current value of the average of the resource metric across all relevant pods, represented as a percentage of the requested value of the resource for the pods.
    """
    average_value: Annotated[Optional[apimachinery.Quantity], Field(alias="averageValue")] = None
    """
    averageValue is the current value of the average of the metric across all relevant pods (as a quantity)
    """
    value: Optional[apimachinery.Quantity] = None
    """
    value is the current value of the metric (as a quantity).
    """


class ResourceMetricSource(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["ResourceMetricSource"]:
            return ResourceMetricSource

        def build(self) -> "ResourceMetricSource":
            return ResourceMetricSource(**self._attrs)

        def name(self, value: str, /) -> Self:
            """
            name is the name of the resource in question.
            """
            return self._set("name", value)

        @overload
        def target(self, value_or_callback: MetricTarget, /) -> "ResourceMetricSource.Builder": ...

        @overload
        def target(
            self,
            value_or_callback: Callable[
                [MetricTarget.Builder], MetricTarget.Builder | MetricTarget
            ],
            /,
        ) -> "ResourceMetricSource.Builder": ...

        @overload
        def target(self, value_or_callback: Never = ...) -> "MetricTarget.BuilderContext": ...

        def target(self, value_or_callback=None, /):
            """
            target specifies the target value for the given metric
            """
            if self._in_context and value_or_callback is None:
                context = MetricTarget.BuilderContext()
                context._parent_builder = self
                context._field_name = "target"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(MetricTarget.builder())
                if isinstance(output, MetricTarget.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("target", value)

    class BuilderContext(BuilderContextBase["ResourceMetricSource.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = ResourceMetricSource.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for ResourceMetricSource."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["ResourceMetricSource", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use ResourceMetricSource.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    name: str
    """
    name is the name of the resource in question.
    """
    target: MetricTarget
    """
    target specifies the target value for the given metric
    """


class ResourceMetricStatus(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["ResourceMetricStatus"]:
            return ResourceMetricStatus

        def build(self) -> "ResourceMetricStatus":
            return ResourceMetricStatus(**self._attrs)

        @overload
        def current(
            self, value_or_callback: MetricValueStatus, /
        ) -> "ResourceMetricStatus.Builder": ...

        @overload
        def current(
            self,
            value_or_callback: Callable[
                [MetricValueStatus.Builder],
                MetricValueStatus.Builder | MetricValueStatus,
            ],
            /,
        ) -> "ResourceMetricStatus.Builder": ...

        @overload
        def current(self, value_or_callback: Never = ...) -> "MetricValueStatus.BuilderContext": ...

        def current(self, value_or_callback=None, /):
            """
            current contains the current value for the given metric
            """
            if self._in_context and value_or_callback is None:
                context = MetricValueStatus.BuilderContext()
                context._parent_builder = self
                context._field_name = "current"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(MetricValueStatus.builder())
                if isinstance(output, MetricValueStatus.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("current", value)

        def name(self, value: str, /) -> Self:
            """
            name is the name of the resource in question.
            """
            return self._set("name", value)

    class BuilderContext(BuilderContextBase["ResourceMetricStatus.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = ResourceMetricStatus.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for ResourceMetricStatus."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["ResourceMetricStatus", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use ResourceMetricStatus.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    current: MetricValueStatus
    """
    current contains the current value for the given metric
    """
    name: str
    """
    name is the name of the resource in question.
    """


class ContainerResourceMetricSource(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["ContainerResourceMetricSource"]:
            return ContainerResourceMetricSource

        def build(self) -> "ContainerResourceMetricSource":
            return ContainerResourceMetricSource(**self._attrs)

        def container(self, value: str, /) -> Self:
            """
            container is the name of the container in the pods of the scaling target
            """
            return self._set("container", value)

        def name(self, value: str, /) -> Self:
            """
            name is the name of the resource in question.
            """
            return self._set("name", value)

        @overload
        def target(
            self, value_or_callback: MetricTarget, /
        ) -> "ContainerResourceMetricSource.Builder": ...

        @overload
        def target(
            self,
            value_or_callback: Callable[
                [MetricTarget.Builder], MetricTarget.Builder | MetricTarget
            ],
            /,
        ) -> "ContainerResourceMetricSource.Builder": ...

        @overload
        def target(self, value_or_callback: Never = ...) -> "MetricTarget.BuilderContext": ...

        def target(self, value_or_callback=None, /):
            """
            target specifies the target value for the given metric
            """
            if self._in_context and value_or_callback is None:
                context = MetricTarget.BuilderContext()
                context._parent_builder = self
                context._field_name = "target"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(MetricTarget.builder())
                if isinstance(output, MetricTarget.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("target", value)

    class BuilderContext(BuilderContextBase["ContainerResourceMetricSource.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = ContainerResourceMetricSource.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for ContainerResourceMetricSource."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["ContainerResourceMetricSource", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use ContainerResourceMetricSource.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    container: str
    """
    container is the name of the container in the pods of the scaling target
    """
    name: str
    """
    name is the name of the resource in question.
    """
    target: MetricTarget
    """
    target specifies the target value for the given metric
    """


class ContainerResourceMetricStatus(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["ContainerResourceMetricStatus"]:
            return ContainerResourceMetricStatus

        def build(self) -> "ContainerResourceMetricStatus":
            return ContainerResourceMetricStatus(**self._attrs)

        def container(self, value: str, /) -> Self:
            """
            container is the name of the container in the pods of the scaling target
            """
            return self._set("container", value)

        @overload
        def current(
            self, value_or_callback: MetricValueStatus, /
        ) -> "ContainerResourceMetricStatus.Builder": ...

        @overload
        def current(
            self,
            value_or_callback: Callable[
                [MetricValueStatus.Builder],
                MetricValueStatus.Builder | MetricValueStatus,
            ],
            /,
        ) -> "ContainerResourceMetricStatus.Builder": ...

        @overload
        def current(self, value_or_callback: Never = ...) -> "MetricValueStatus.BuilderContext": ...

        def current(self, value_or_callback=None, /):
            """
            current contains the current value for the given metric
            """
            if self._in_context and value_or_callback is None:
                context = MetricValueStatus.BuilderContext()
                context._parent_builder = self
                context._field_name = "current"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(MetricValueStatus.builder())
                if isinstance(output, MetricValueStatus.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("current", value)

        def name(self, value: str, /) -> Self:
            """
            name is the name of the resource in question.
            """
            return self._set("name", value)

    class BuilderContext(BuilderContextBase["ContainerResourceMetricStatus.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = ContainerResourceMetricStatus.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for ContainerResourceMetricStatus."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["ContainerResourceMetricStatus", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use ContainerResourceMetricStatus.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    container: str
    """
    container is the name of the container in the pods of the scaling target
    """
    current: MetricValueStatus
    """
    current contains the current value for the given metric
    """
    name: str
    """
    name is the name of the resource in question.
    """


class MetricIdentifier(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["MetricIdentifier"]:
            return MetricIdentifier

        def build(self) -> "MetricIdentifier":
            return MetricIdentifier(**self._attrs)

        def name(self, value: str, /) -> Self:
            """
            name is the name of the given metric
            """
            return self._set("name", value)

        @overload
        def selector(
            self, value_or_callback: Optional[apimachinery.LabelSelector], /
        ) -> "MetricIdentifier.Builder": ...

        @overload
        def selector(
            self,
            value_or_callback: Callable[
                [apimachinery.LabelSelector.Builder],
                apimachinery.LabelSelector.Builder | apimachinery.LabelSelector,
            ],
            /,
        ) -> "MetricIdentifier.Builder": ...

        @overload
        def selector(
            self, value_or_callback: Never = ...
        ) -> "apimachinery.LabelSelector.BuilderContext": ...

        def selector(self, value_or_callback=None, /):
            """
            selector is the string-encoded form of a standard kubernetes label selector for the given metric When set, it is passed as an additional parameter to the metrics server for more specific metrics scoping. When unset, just the metricName will be used to gather metrics.
            """
            if self._in_context and value_or_callback is None:
                context = apimachinery.LabelSelector.BuilderContext()
                context._parent_builder = self
                context._field_name = "selector"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(apimachinery.LabelSelector.builder())
                if isinstance(output, apimachinery.LabelSelector.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("selector", value)

    class BuilderContext(BuilderContextBase["MetricIdentifier.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = MetricIdentifier.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for MetricIdentifier."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["MetricIdentifier", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use MetricIdentifier.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    name: str
    """
    name is the name of the given metric
    """
    selector: Optional[apimachinery.LabelSelector] = None
    """
    selector is the string-encoded form of a standard kubernetes label selector for the given metric When set, it is passed as an additional parameter to the metrics server for more specific metrics scoping. When unset, just the metricName will be used to gather metrics.
    """


class ObjectMetricSource(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["ObjectMetricSource"]:
            return ObjectMetricSource

        def build(self) -> "ObjectMetricSource":
            return ObjectMetricSource(**self._attrs)

        @overload
        def described_object(
            self, value_or_callback: CrossVersionObjectReference, /
        ) -> "ObjectMetricSource.Builder": ...

        @overload
        def described_object(
            self,
            value_or_callback: Callable[
                [CrossVersionObjectReference.Builder],
                CrossVersionObjectReference.Builder | CrossVersionObjectReference,
            ],
            /,
        ) -> "ObjectMetricSource.Builder": ...

        @overload
        def described_object(
            self, value_or_callback: Never = ...
        ) -> "CrossVersionObjectReference.BuilderContext": ...

        def described_object(self, value_or_callback=None, /):
            """
            describedObject specifies the descriptions of a object,such as kind,name apiVersion
            """
            if self._in_context and value_or_callback is None:
                context = CrossVersionObjectReference.BuilderContext()
                context._parent_builder = self
                context._field_name = "described_object"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(CrossVersionObjectReference.builder())
                if isinstance(output, CrossVersionObjectReference.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("described_object", value)

        @overload
        def metric(
            self, value_or_callback: MetricIdentifier, /
        ) -> "ObjectMetricSource.Builder": ...

        @overload
        def metric(
            self,
            value_or_callback: Callable[
                [MetricIdentifier.Builder], MetricIdentifier.Builder | MetricIdentifier
            ],
            /,
        ) -> "ObjectMetricSource.Builder": ...

        @overload
        def metric(self, value_or_callback: Never = ...) -> "MetricIdentifier.BuilderContext": ...

        def metric(self, value_or_callback=None, /):
            """
            metric identifies the target metric by name and selector
            """
            if self._in_context and value_or_callback is None:
                context = MetricIdentifier.BuilderContext()
                context._parent_builder = self
                context._field_name = "metric"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(MetricIdentifier.builder())
                if isinstance(output, MetricIdentifier.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("metric", value)

        @overload
        def target(self, value_or_callback: MetricTarget, /) -> "ObjectMetricSource.Builder": ...

        @overload
        def target(
            self,
            value_or_callback: Callable[
                [MetricTarget.Builder], MetricTarget.Builder | MetricTarget
            ],
            /,
        ) -> "ObjectMetricSource.Builder": ...

        @overload
        def target(self, value_or_callback: Never = ...) -> "MetricTarget.BuilderContext": ...

        def target(self, value_or_callback=None, /):
            """
            target specifies the target value for the given metric
            """
            if self._in_context and value_or_callback is None:
                context = MetricTarget.BuilderContext()
                context._parent_builder = self
                context._field_name = "target"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(MetricTarget.builder())
                if isinstance(output, MetricTarget.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("target", value)

    class BuilderContext(BuilderContextBase["ObjectMetricSource.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = ObjectMetricSource.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for ObjectMetricSource."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["ObjectMetricSource", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use ObjectMetricSource.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    described_object: Annotated[CrossVersionObjectReference, Field(alias="describedObject")]
    """
    describedObject specifies the descriptions of a object,such as kind,name apiVersion
    """
    metric: MetricIdentifier
    """
    metric identifies the target metric by name and selector
    """
    target: MetricTarget
    """
    target specifies the target value for the given metric
    """


class ObjectMetricStatus(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["ObjectMetricStatus"]:
            return ObjectMetricStatus

        def build(self) -> "ObjectMetricStatus":
            return ObjectMetricStatus(**self._attrs)

        @overload
        def current(
            self, value_or_callback: MetricValueStatus, /
        ) -> "ObjectMetricStatus.Builder": ...

        @overload
        def current(
            self,
            value_or_callback: Callable[
                [MetricValueStatus.Builder],
                MetricValueStatus.Builder | MetricValueStatus,
            ],
            /,
        ) -> "ObjectMetricStatus.Builder": ...

        @overload
        def current(self, value_or_callback: Never = ...) -> "MetricValueStatus.BuilderContext": ...

        def current(self, value_or_callback=None, /):
            """
            current contains the current value for the given metric
            """
            if self._in_context and value_or_callback is None:
                context = MetricValueStatus.BuilderContext()
                context._parent_builder = self
                context._field_name = "current"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(MetricValueStatus.builder())
                if isinstance(output, MetricValueStatus.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("current", value)

        @overload
        def described_object(
            self, value_or_callback: CrossVersionObjectReference, /
        ) -> "ObjectMetricStatus.Builder": ...

        @overload
        def described_object(
            self,
            value_or_callback: Callable[
                [CrossVersionObjectReference.Builder],
                CrossVersionObjectReference.Builder | CrossVersionObjectReference,
            ],
            /,
        ) -> "ObjectMetricStatus.Builder": ...

        @overload
        def described_object(
            self, value_or_callback: Never = ...
        ) -> "CrossVersionObjectReference.BuilderContext": ...

        def described_object(self, value_or_callback=None, /):
            """
            DescribedObject specifies the descriptions of a object,such as kind,name apiVersion
            """
            if self._in_context and value_or_callback is None:
                context = CrossVersionObjectReference.BuilderContext()
                context._parent_builder = self
                context._field_name = "described_object"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(CrossVersionObjectReference.builder())
                if isinstance(output, CrossVersionObjectReference.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("described_object", value)

        @overload
        def metric(
            self, value_or_callback: MetricIdentifier, /
        ) -> "ObjectMetricStatus.Builder": ...

        @overload
        def metric(
            self,
            value_or_callback: Callable[
                [MetricIdentifier.Builder], MetricIdentifier.Builder | MetricIdentifier
            ],
            /,
        ) -> "ObjectMetricStatus.Builder": ...

        @overload
        def metric(self, value_or_callback: Never = ...) -> "MetricIdentifier.BuilderContext": ...

        def metric(self, value_or_callback=None, /):
            """
            metric identifies the target metric by name and selector
            """
            if self._in_context and value_or_callback is None:
                context = MetricIdentifier.BuilderContext()
                context._parent_builder = self
                context._field_name = "metric"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(MetricIdentifier.builder())
                if isinstance(output, MetricIdentifier.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("metric", value)

    class BuilderContext(BuilderContextBase["ObjectMetricStatus.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = ObjectMetricStatus.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for ObjectMetricStatus."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["ObjectMetricStatus", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use ObjectMetricStatus.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    current: MetricValueStatus
    """
    current contains the current value for the given metric
    """
    described_object: Annotated[CrossVersionObjectReference, Field(alias="describedObject")]
    """
    DescribedObject specifies the descriptions of a object,such as kind,name apiVersion
    """
    metric: MetricIdentifier
    """
    metric identifies the target metric by name and selector
    """


class PodsMetricSource(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["PodsMetricSource"]:
            return PodsMetricSource

        def build(self) -> "PodsMetricSource":
            return PodsMetricSource(**self._attrs)

        @overload
        def metric(self, value_or_callback: MetricIdentifier, /) -> "PodsMetricSource.Builder": ...

        @overload
        def metric(
            self,
            value_or_callback: Callable[
                [MetricIdentifier.Builder], MetricIdentifier.Builder | MetricIdentifier
            ],
            /,
        ) -> "PodsMetricSource.Builder": ...

        @overload
        def metric(self, value_or_callback: Never = ...) -> "MetricIdentifier.BuilderContext": ...

        def metric(self, value_or_callback=None, /):
            """
            metric identifies the target metric by name and selector
            """
            if self._in_context and value_or_callback is None:
                context = MetricIdentifier.BuilderContext()
                context._parent_builder = self
                context._field_name = "metric"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(MetricIdentifier.builder())
                if isinstance(output, MetricIdentifier.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("metric", value)

        @overload
        def target(self, value_or_callback: MetricTarget, /) -> "PodsMetricSource.Builder": ...

        @overload
        def target(
            self,
            value_or_callback: Callable[
                [MetricTarget.Builder], MetricTarget.Builder | MetricTarget
            ],
            /,
        ) -> "PodsMetricSource.Builder": ...

        @overload
        def target(self, value_or_callback: Never = ...) -> "MetricTarget.BuilderContext": ...

        def target(self, value_or_callback=None, /):
            """
            target specifies the target value for the given metric
            """
            if self._in_context and value_or_callback is None:
                context = MetricTarget.BuilderContext()
                context._parent_builder = self
                context._field_name = "target"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(MetricTarget.builder())
                if isinstance(output, MetricTarget.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("target", value)

    class BuilderContext(BuilderContextBase["PodsMetricSource.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = PodsMetricSource.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for PodsMetricSource."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["PodsMetricSource", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use PodsMetricSource.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    metric: MetricIdentifier
    """
    metric identifies the target metric by name and selector
    """
    target: MetricTarget
    """
    target specifies the target value for the given metric
    """


class PodsMetricStatus(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["PodsMetricStatus"]:
            return PodsMetricStatus

        def build(self) -> "PodsMetricStatus":
            return PodsMetricStatus(**self._attrs)

        @overload
        def current(
            self, value_or_callback: MetricValueStatus, /
        ) -> "PodsMetricStatus.Builder": ...

        @overload
        def current(
            self,
            value_or_callback: Callable[
                [MetricValueStatus.Builder],
                MetricValueStatus.Builder | MetricValueStatus,
            ],
            /,
        ) -> "PodsMetricStatus.Builder": ...

        @overload
        def current(self, value_or_callback: Never = ...) -> "MetricValueStatus.BuilderContext": ...

        def current(self, value_or_callback=None, /):
            """
            current contains the current value for the given metric
            """
            if self._in_context and value_or_callback is None:
                context = MetricValueStatus.BuilderContext()
                context._parent_builder = self
                context._field_name = "current"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(MetricValueStatus.builder())
                if isinstance(output, MetricValueStatus.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("current", value)

        @overload
        def metric(self, value_or_callback: MetricIdentifier, /) -> "PodsMetricStatus.Builder": ...

        @overload
        def metric(
            self,
            value_or_callback: Callable[
                [MetricIdentifier.Builder], MetricIdentifier.Builder | MetricIdentifier
            ],
            /,
        ) -> "PodsMetricStatus.Builder": ...

        @overload
        def metric(self, value_or_callback: Never = ...) -> "MetricIdentifier.BuilderContext": ...

        def metric(self, value_or_callback=None, /):
            """
            metric identifies the target metric by name and selector
            """
            if self._in_context and value_or_callback is None:
                context = MetricIdentifier.BuilderContext()
                context._parent_builder = self
                context._field_name = "metric"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(MetricIdentifier.builder())
                if isinstance(output, MetricIdentifier.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("metric", value)

    class BuilderContext(BuilderContextBase["PodsMetricStatus.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = PodsMetricStatus.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for PodsMetricStatus."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["PodsMetricStatus", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use PodsMetricStatus.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    current: MetricValueStatus
    """
    current contains the current value for the given metric
    """
    metric: MetricIdentifier
    """
    metric identifies the target metric by name and selector
    """


class ExternalMetricSource(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["ExternalMetricSource"]:
            return ExternalMetricSource

        def build(self) -> "ExternalMetricSource":
            return ExternalMetricSource(**self._attrs)

        @overload
        def metric(
            self, value_or_callback: MetricIdentifier, /
        ) -> "ExternalMetricSource.Builder": ...

        @overload
        def metric(
            self,
            value_or_callback: Callable[
                [MetricIdentifier.Builder], MetricIdentifier.Builder | MetricIdentifier
            ],
            /,
        ) -> "ExternalMetricSource.Builder": ...

        @overload
        def metric(self, value_or_callback: Never = ...) -> "MetricIdentifier.BuilderContext": ...

        def metric(self, value_or_callback=None, /):
            """
            metric identifies the target metric by name and selector
            """
            if self._in_context and value_or_callback is None:
                context = MetricIdentifier.BuilderContext()
                context._parent_builder = self
                context._field_name = "metric"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(MetricIdentifier.builder())
                if isinstance(output, MetricIdentifier.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("metric", value)

        @overload
        def target(self, value_or_callback: MetricTarget, /) -> "ExternalMetricSource.Builder": ...

        @overload
        def target(
            self,
            value_or_callback: Callable[
                [MetricTarget.Builder], MetricTarget.Builder | MetricTarget
            ],
            /,
        ) -> "ExternalMetricSource.Builder": ...

        @overload
        def target(self, value_or_callback: Never = ...) -> "MetricTarget.BuilderContext": ...

        def target(self, value_or_callback=None, /):
            """
            target specifies the target value for the given metric
            """
            if self._in_context and value_or_callback is None:
                context = MetricTarget.BuilderContext()
                context._parent_builder = self
                context._field_name = "target"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(MetricTarget.builder())
                if isinstance(output, MetricTarget.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("target", value)

    class BuilderContext(BuilderContextBase["ExternalMetricSource.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = ExternalMetricSource.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for ExternalMetricSource."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["ExternalMetricSource", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use ExternalMetricSource.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    metric: MetricIdentifier
    """
    metric identifies the target metric by name and selector
    """
    target: MetricTarget
    """
    target specifies the target value for the given metric
    """


class ExternalMetricStatus(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["ExternalMetricStatus"]:
            return ExternalMetricStatus

        def build(self) -> "ExternalMetricStatus":
            return ExternalMetricStatus(**self._attrs)

        @overload
        def current(
            self, value_or_callback: MetricValueStatus, /
        ) -> "ExternalMetricStatus.Builder": ...

        @overload
        def current(
            self,
            value_or_callback: Callable[
                [MetricValueStatus.Builder],
                MetricValueStatus.Builder | MetricValueStatus,
            ],
            /,
        ) -> "ExternalMetricStatus.Builder": ...

        @overload
        def current(self, value_or_callback: Never = ...) -> "MetricValueStatus.BuilderContext": ...

        def current(self, value_or_callback=None, /):
            """
            current contains the current value for the given metric
            """
            if self._in_context and value_or_callback is None:
                context = MetricValueStatus.BuilderContext()
                context._parent_builder = self
                context._field_name = "current"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(MetricValueStatus.builder())
                if isinstance(output, MetricValueStatus.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("current", value)

        @overload
        def metric(
            self, value_or_callback: MetricIdentifier, /
        ) -> "ExternalMetricStatus.Builder": ...

        @overload
        def metric(
            self,
            value_or_callback: Callable[
                [MetricIdentifier.Builder], MetricIdentifier.Builder | MetricIdentifier
            ],
            /,
        ) -> "ExternalMetricStatus.Builder": ...

        @overload
        def metric(self, value_or_callback: Never = ...) -> "MetricIdentifier.BuilderContext": ...

        def metric(self, value_or_callback=None, /):
            """
            metric identifies the target metric by name and selector
            """
            if self._in_context and value_or_callback is None:
                context = MetricIdentifier.BuilderContext()
                context._parent_builder = self
                context._field_name = "metric"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(MetricIdentifier.builder())
                if isinstance(output, MetricIdentifier.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("metric", value)

    class BuilderContext(BuilderContextBase["ExternalMetricStatus.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = ExternalMetricStatus.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for ExternalMetricStatus."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["ExternalMetricStatus", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use ExternalMetricStatus.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    current: MetricValueStatus
    """
    current contains the current value for the given metric
    """
    metric: MetricIdentifier
    """
    metric identifies the target metric by name and selector
    """


class MetricSpec(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["MetricSpec"]:
            return MetricSpec

        def build(self) -> "MetricSpec":
            return MetricSpec(**self._attrs)

        @overload
        def container_resource(
            self, value_or_callback: Optional[ContainerResourceMetricSource], /
        ) -> "MetricSpec.Builder": ...

        @overload
        def container_resource(
            self,
            value_or_callback: Callable[
                [ContainerResourceMetricSource.Builder],
                ContainerResourceMetricSource.Builder | ContainerResourceMetricSource,
            ],
            /,
        ) -> "MetricSpec.Builder": ...

        @overload
        def container_resource(
            self, value_or_callback: Never = ...
        ) -> "ContainerResourceMetricSource.BuilderContext": ...

        def container_resource(self, value_or_callback=None, /):
            """
            containerResource refers to a resource metric (such as those specified in requests and limits) known to Kubernetes describing a single container in each pod of the current scale target (e.g. CPU or memory). Such metrics are built in to Kubernetes, and have special scaling options on top of those available to normal per-pod metrics using the "pods" source. This is an alpha feature and can be enabled by the HPAContainerMetrics feature flag.
            """
            if self._in_context and value_or_callback is None:
                context = ContainerResourceMetricSource.BuilderContext()
                context._parent_builder = self
                context._field_name = "container_resource"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(ContainerResourceMetricSource.builder())
                if isinstance(output, ContainerResourceMetricSource.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("container_resource", value)

        @overload
        def external(
            self, value_or_callback: Optional[ExternalMetricSource], /
        ) -> "MetricSpec.Builder": ...

        @overload
        def external(
            self,
            value_or_callback: Callable[
                [ExternalMetricSource.Builder],
                ExternalMetricSource.Builder | ExternalMetricSource,
            ],
            /,
        ) -> "MetricSpec.Builder": ...

        @overload
        def external(
            self, value_or_callback: Never = ...
        ) -> "ExternalMetricSource.BuilderContext": ...

        def external(self, value_or_callback=None, /):
            """
            external refers to a global metric that is not associated with any Kubernetes object. It allows autoscaling based on information coming from components running outside of cluster (for example length of queue in cloud messaging service, or QPS from loadbalancer running outside of cluster).
            """
            if self._in_context and value_or_callback is None:
                context = ExternalMetricSource.BuilderContext()
                context._parent_builder = self
                context._field_name = "external"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(ExternalMetricSource.builder())
                if isinstance(output, ExternalMetricSource.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("external", value)

        @overload
        def object(
            self, value_or_callback: Optional[ObjectMetricSource], /
        ) -> "MetricSpec.Builder": ...

        @overload
        def object(
            self,
            value_or_callback: Callable[
                [ObjectMetricSource.Builder],
                ObjectMetricSource.Builder | ObjectMetricSource,
            ],
            /,
        ) -> "MetricSpec.Builder": ...

        @overload
        def object(self, value_or_callback: Never = ...) -> "ObjectMetricSource.BuilderContext": ...

        def object(self, value_or_callback=None, /):
            """
            object refers to a metric describing a single kubernetes object (for example, hits-per-second on an Ingress object).
            """
            if self._in_context and value_or_callback is None:
                context = ObjectMetricSource.BuilderContext()
                context._parent_builder = self
                context._field_name = "object"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(ObjectMetricSource.builder())
                if isinstance(output, ObjectMetricSource.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("object", value)

        @overload
        def pods(
            self, value_or_callback: Optional[PodsMetricSource], /
        ) -> "MetricSpec.Builder": ...

        @overload
        def pods(
            self,
            value_or_callback: Callable[
                [PodsMetricSource.Builder], PodsMetricSource.Builder | PodsMetricSource
            ],
            /,
        ) -> "MetricSpec.Builder": ...

        @overload
        def pods(self, value_or_callback: Never = ...) -> "PodsMetricSource.BuilderContext": ...

        def pods(self, value_or_callback=None, /):
            """
            pods refers to a metric describing each pod in the current scale target (for example, transactions-processed-per-second).  The values will be averaged together before being compared to the target value.
            """
            if self._in_context and value_or_callback is None:
                context = PodsMetricSource.BuilderContext()
                context._parent_builder = self
                context._field_name = "pods"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(PodsMetricSource.builder())
                if isinstance(output, PodsMetricSource.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("pods", value)

        @overload
        def resource(
            self, value_or_callback: Optional[ResourceMetricSource], /
        ) -> "MetricSpec.Builder": ...

        @overload
        def resource(
            self,
            value_or_callback: Callable[
                [ResourceMetricSource.Builder],
                ResourceMetricSource.Builder | ResourceMetricSource,
            ],
            /,
        ) -> "MetricSpec.Builder": ...

        @overload
        def resource(
            self, value_or_callback: Never = ...
        ) -> "ResourceMetricSource.BuilderContext": ...

        def resource(self, value_or_callback=None, /):
            """
            resource refers to a resource metric (such as those specified in requests and limits) known to Kubernetes describing each pod in the current scale target (e.g. CPU or memory). Such metrics are built in to Kubernetes, and have special scaling options on top of those available to normal per-pod metrics using the "pods" source.
            """
            if self._in_context and value_or_callback is None:
                context = ResourceMetricSource.BuilderContext()
                context._parent_builder = self
                context._field_name = "resource"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(ResourceMetricSource.builder())
                if isinstance(output, ResourceMetricSource.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("resource", value)

        def type(self, value: str, /) -> Self:
            """
            type is the type of metric source.  It should be one of "ContainerResource", "External", "Object", "Pods" or "Resource", each mapping to a matching field in the object. Note: "ContainerResource" type is available on when the feature-gate HPAContainerMetrics is enabled
            """
            return self._set("type", value)

    class BuilderContext(BuilderContextBase["MetricSpec.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = MetricSpec.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for MetricSpec."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["MetricSpec", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use MetricSpec.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    container_resource: Annotated[
        Optional[ContainerResourceMetricSource], Field(alias="containerResource")
    ] = None
    """
    containerResource refers to a resource metric (such as those specified in requests and limits) known to Kubernetes describing a single container in each pod of the current scale target (e.g. CPU or memory). Such metrics are built in to Kubernetes, and have special scaling options on top of those available to normal per-pod metrics using the "pods" source. This is an alpha feature and can be enabled by the HPAContainerMetrics feature flag.
    """
    external: Optional[ExternalMetricSource] = None
    """
    external refers to a global metric that is not associated with any Kubernetes object. It allows autoscaling based on information coming from components running outside of cluster (for example length of queue in cloud messaging service, or QPS from loadbalancer running outside of cluster).
    """
    object: Optional[ObjectMetricSource] = None
    """
    object refers to a metric describing a single kubernetes object (for example, hits-per-second on an Ingress object).
    """
    pods: Optional[PodsMetricSource] = None
    """
    pods refers to a metric describing each pod in the current scale target (for example, transactions-processed-per-second).  The values will be averaged together before being compared to the target value.
    """
    resource: Optional[ResourceMetricSource] = None
    """
    resource refers to a resource metric (such as those specified in requests and limits) known to Kubernetes describing each pod in the current scale target (e.g. CPU or memory). Such metrics are built in to Kubernetes, and have special scaling options on top of those available to normal per-pod metrics using the "pods" source.
    """
    type: str
    """
    type is the type of metric source.  It should be one of "ContainerResource", "External", "Object", "Pods" or "Resource", each mapping to a matching field in the object. Note: "ContainerResource" type is available on when the feature-gate HPAContainerMetrics is enabled
    """


class MetricStatus(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["MetricStatus"]:
            return MetricStatus

        def build(self) -> "MetricStatus":
            return MetricStatus(**self._attrs)

        @overload
        def container_resource(
            self, value_or_callback: Optional[ContainerResourceMetricStatus], /
        ) -> "MetricStatus.Builder": ...

        @overload
        def container_resource(
            self,
            value_or_callback: Callable[
                [ContainerResourceMetricStatus.Builder],
                ContainerResourceMetricStatus.Builder | ContainerResourceMetricStatus,
            ],
            /,
        ) -> "MetricStatus.Builder": ...

        @overload
        def container_resource(
            self, value_or_callback: Never = ...
        ) -> "ContainerResourceMetricStatus.BuilderContext": ...

        def container_resource(self, value_or_callback=None, /):
            """
            container resource refers to a resource metric (such as those specified in requests and limits) known to Kubernetes describing a single container in each pod in the current scale target (e.g. CPU or memory). Such metrics are built in to Kubernetes, and have special scaling options on top of those available to normal per-pod metrics using the "pods" source.
            """
            if self._in_context and value_or_callback is None:
                context = ContainerResourceMetricStatus.BuilderContext()
                context._parent_builder = self
                context._field_name = "container_resource"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(ContainerResourceMetricStatus.builder())
                if isinstance(output, ContainerResourceMetricStatus.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("container_resource", value)

        @overload
        def external(
            self, value_or_callback: Optional[ExternalMetricStatus], /
        ) -> "MetricStatus.Builder": ...

        @overload
        def external(
            self,
            value_or_callback: Callable[
                [ExternalMetricStatus.Builder],
                ExternalMetricStatus.Builder | ExternalMetricStatus,
            ],
            /,
        ) -> "MetricStatus.Builder": ...

        @overload
        def external(
            self, value_or_callback: Never = ...
        ) -> "ExternalMetricStatus.BuilderContext": ...

        def external(self, value_or_callback=None, /):
            """
            external refers to a global metric that is not associated with any Kubernetes object. It allows autoscaling based on information coming from components running outside of cluster (for example length of queue in cloud messaging service, or QPS from loadbalancer running outside of cluster).
            """
            if self._in_context and value_or_callback is None:
                context = ExternalMetricStatus.BuilderContext()
                context._parent_builder = self
                context._field_name = "external"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(ExternalMetricStatus.builder())
                if isinstance(output, ExternalMetricStatus.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("external", value)

        @overload
        def object(
            self, value_or_callback: Optional[ObjectMetricStatus], /
        ) -> "MetricStatus.Builder": ...

        @overload
        def object(
            self,
            value_or_callback: Callable[
                [ObjectMetricStatus.Builder],
                ObjectMetricStatus.Builder | ObjectMetricStatus,
            ],
            /,
        ) -> "MetricStatus.Builder": ...

        @overload
        def object(self, value_or_callback: Never = ...) -> "ObjectMetricStatus.BuilderContext": ...

        def object(self, value_or_callback=None, /):
            """
            object refers to a metric describing a single kubernetes object (for example, hits-per-second on an Ingress object).
            """
            if self._in_context and value_or_callback is None:
                context = ObjectMetricStatus.BuilderContext()
                context._parent_builder = self
                context._field_name = "object"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(ObjectMetricStatus.builder())
                if isinstance(output, ObjectMetricStatus.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("object", value)

        @overload
        def pods(
            self, value_or_callback: Optional[PodsMetricStatus], /
        ) -> "MetricStatus.Builder": ...

        @overload
        def pods(
            self,
            value_or_callback: Callable[
                [PodsMetricStatus.Builder], PodsMetricStatus.Builder | PodsMetricStatus
            ],
            /,
        ) -> "MetricStatus.Builder": ...

        @overload
        def pods(self, value_or_callback: Never = ...) -> "PodsMetricStatus.BuilderContext": ...

        def pods(self, value_or_callback=None, /):
            """
            pods refers to a metric describing each pod in the current scale target (for example, transactions-processed-per-second).  The values will be averaged together before being compared to the target value.
            """
            if self._in_context and value_or_callback is None:
                context = PodsMetricStatus.BuilderContext()
                context._parent_builder = self
                context._field_name = "pods"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(PodsMetricStatus.builder())
                if isinstance(output, PodsMetricStatus.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("pods", value)

        @overload
        def resource(
            self, value_or_callback: Optional[ResourceMetricStatus], /
        ) -> "MetricStatus.Builder": ...

        @overload
        def resource(
            self,
            value_or_callback: Callable[
                [ResourceMetricStatus.Builder],
                ResourceMetricStatus.Builder | ResourceMetricStatus,
            ],
            /,
        ) -> "MetricStatus.Builder": ...

        @overload
        def resource(
            self, value_or_callback: Never = ...
        ) -> "ResourceMetricStatus.BuilderContext": ...

        def resource(self, value_or_callback=None, /):
            """
            resource refers to a resource metric (such as those specified in requests and limits) known to Kubernetes describing each pod in the current scale target (e.g. CPU or memory). Such metrics are built in to Kubernetes, and have special scaling options on top of those available to normal per-pod metrics using the "pods" source.
            """
            if self._in_context and value_or_callback is None:
                context = ResourceMetricStatus.BuilderContext()
                context._parent_builder = self
                context._field_name = "resource"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(ResourceMetricStatus.builder())
                if isinstance(output, ResourceMetricStatus.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("resource", value)

        def type(self, value: str, /) -> Self:
            """
            type is the type of metric source.  It will be one of "ContainerResource", "External", "Object", "Pods" or "Resource", each corresponds to a matching field in the object. Note: "ContainerResource" type is available on when the feature-gate HPAContainerMetrics is enabled
            """
            return self._set("type", value)

    class BuilderContext(BuilderContextBase["MetricStatus.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = MetricStatus.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for MetricStatus."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["MetricStatus", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use MetricStatus.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    container_resource: Annotated[
        Optional[ContainerResourceMetricStatus], Field(alias="containerResource")
    ] = None
    """
    container resource refers to a resource metric (such as those specified in requests and limits) known to Kubernetes describing a single container in each pod in the current scale target (e.g. CPU or memory). Such metrics are built in to Kubernetes, and have special scaling options on top of those available to normal per-pod metrics using the "pods" source.
    """
    external: Optional[ExternalMetricStatus] = None
    """
    external refers to a global metric that is not associated with any Kubernetes object. It allows autoscaling based on information coming from components running outside of cluster (for example length of queue in cloud messaging service, or QPS from loadbalancer running outside of cluster).
    """
    object: Optional[ObjectMetricStatus] = None
    """
    object refers to a metric describing a single kubernetes object (for example, hits-per-second on an Ingress object).
    """
    pods: Optional[PodsMetricStatus] = None
    """
    pods refers to a metric describing each pod in the current scale target (for example, transactions-processed-per-second).  The values will be averaged together before being compared to the target value.
    """
    resource: Optional[ResourceMetricStatus] = None
    """
    resource refers to a resource metric (such as those specified in requests and limits) known to Kubernetes describing each pod in the current scale target (e.g. CPU or memory). Such metrics are built in to Kubernetes, and have special scaling options on top of those available to normal per-pod metrics using the "pods" source.
    """
    type: str
    """
    type is the type of metric source.  It will be one of "ContainerResource", "External", "Object", "Pods" or "Resource", each corresponds to a matching field in the object. Note: "ContainerResource" type is available on when the feature-gate HPAContainerMetrics is enabled
    """


class HorizontalPodAutoscalerSpec(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["HorizontalPodAutoscalerSpec"]:
            return HorizontalPodAutoscalerSpec

        def build(self) -> "HorizontalPodAutoscalerSpec":
            return HorizontalPodAutoscalerSpec(**self._attrs)

        @overload
        def behavior(
            self, value_or_callback: Optional[HorizontalPodAutoscalerBehavior], /
        ) -> "HorizontalPodAutoscalerSpec.Builder": ...

        @overload
        def behavior(
            self,
            value_or_callback: Callable[
                [HorizontalPodAutoscalerBehavior.Builder],
                HorizontalPodAutoscalerBehavior.Builder | HorizontalPodAutoscalerBehavior,
            ],
            /,
        ) -> "HorizontalPodAutoscalerSpec.Builder": ...

        @overload
        def behavior(
            self, value_or_callback: Never = ...
        ) -> "HorizontalPodAutoscalerBehavior.BuilderContext": ...

        def behavior(self, value_or_callback=None, /):
            """
            behavior configures the scaling behavior of the target in both Up and Down directions (scaleUp and scaleDown fields respectively). If not set, the default HPAScalingRules for scale up and scale down are used.
            """
            if self._in_context and value_or_callback is None:
                context = HorizontalPodAutoscalerBehavior.BuilderContext()
                context._parent_builder = self
                context._field_name = "behavior"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(HorizontalPodAutoscalerBehavior.builder())
                if isinstance(output, HorizontalPodAutoscalerBehavior.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("behavior", value)

        def max_replicas(self, value: int, /) -> Self:
            """
            maxReplicas is the upper limit for the number of replicas to which the autoscaler can scale up. It cannot be less that minReplicas.
            """
            return self._set("max_replicas", value)

        @overload
        def metrics(
            self, value_or_callback: List[MetricSpec], /
        ) -> "HorizontalPodAutoscalerSpec.Builder": ...

        @overload
        def metrics(
            self,
            value_or_callback: Callable[
                [GenericListBuilder[MetricSpec, MetricSpec.Builder]],
                GenericListBuilder[MetricSpec, MetricSpec.Builder] | List[MetricSpec],
            ],
            /,
        ) -> "HorizontalPodAutoscalerSpec.Builder": ...

        @overload
        def metrics(
            self, value_or_callback: Never = ...
        ) -> ListBuilderContext[MetricSpec.Builder]: ...

        def metrics(self, value_or_callback=None, /):
            """
            metrics contains the specifications for which to use to calculate the desired replica count (the maximum replica count across all metrics will be used).  The desired replica count is calculated multiplying the ratio between the target value and the current value by the current number of pods.  Ergo, metrics used must decrease as the pod count is increased, and vice-versa.  See the individual metric source types for more information about how each type of metric must respond. If not set, the default metric will be set to 80% average CPU utilization.
            """
            if self._in_context and value_or_callback is None:
                context = ListBuilderContext[MetricSpec.Builder]()
                context._parent_builder = self
                context._field_name = "metrics"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(MetricSpec.list_builder())
                if isinstance(output, GenericListBuilder):
                    value = output.build()
                else:
                    value = output
            return self._set("metrics", value)

        def min_replicas(self, value: Optional[int], /) -> Self:
            """
            minReplicas is the lower limit for the number of replicas to which the autoscaler can scale down.  It defaults to 1 pod.  minReplicas is allowed to be 0 if the alpha feature gate HPAScaleToZero is enabled and at least one Object or External metric is configured.  Scaling is active as long as at least one metric value is available.
            """
            return self._set("min_replicas", value)

        @overload
        def scale_target_ref(
            self, value_or_callback: CrossVersionObjectReference, /
        ) -> "HorizontalPodAutoscalerSpec.Builder": ...

        @overload
        def scale_target_ref(
            self,
            value_or_callback: Callable[
                [CrossVersionObjectReference.Builder],
                CrossVersionObjectReference.Builder | CrossVersionObjectReference,
            ],
            /,
        ) -> "HorizontalPodAutoscalerSpec.Builder": ...

        @overload
        def scale_target_ref(
            self, value_or_callback: Never = ...
        ) -> "CrossVersionObjectReference.BuilderContext": ...

        def scale_target_ref(self, value_or_callback=None, /):
            """
            scaleTargetRef points to the target resource to scale, and is used to the pods for which metrics should be collected, as well as to actually change the replica count.
            """
            if self._in_context and value_or_callback is None:
                context = CrossVersionObjectReference.BuilderContext()
                context._parent_builder = self
                context._field_name = "scale_target_ref"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(CrossVersionObjectReference.builder())
                if isinstance(output, CrossVersionObjectReference.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("scale_target_ref", value)

    class BuilderContext(BuilderContextBase["HorizontalPodAutoscalerSpec.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = HorizontalPodAutoscalerSpec.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for HorizontalPodAutoscalerSpec."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["HorizontalPodAutoscalerSpec", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use HorizontalPodAutoscalerSpec.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    behavior: Optional[HorizontalPodAutoscalerBehavior] = None
    """
    behavior configures the scaling behavior of the target in both Up and Down directions (scaleUp and scaleDown fields respectively). If not set, the default HPAScalingRules for scale up and scale down are used.
    """
    max_replicas: Annotated[int, Field(alias="maxReplicas")]
    """
    maxReplicas is the upper limit for the number of replicas to which the autoscaler can scale up. It cannot be less that minReplicas.
    """
    metrics: Optional[List[MetricSpec]] = None
    """
    metrics contains the specifications for which to use to calculate the desired replica count (the maximum replica count across all metrics will be used).  The desired replica count is calculated multiplying the ratio between the target value and the current value by the current number of pods.  Ergo, metrics used must decrease as the pod count is increased, and vice-versa.  See the individual metric source types for more information about how each type of metric must respond. If not set, the default metric will be set to 80% average CPU utilization.
    """
    min_replicas: Annotated[Optional[int], Field(alias="minReplicas")] = None
    """
    minReplicas is the lower limit for the number of replicas to which the autoscaler can scale down.  It defaults to 1 pod.  minReplicas is allowed to be 0 if the alpha feature gate HPAScaleToZero is enabled and at least one Object or External metric is configured.  Scaling is active as long as at least one metric value is available.
    """
    scale_target_ref: Annotated[CrossVersionObjectReference, Field(alias="scaleTargetRef")]
    """
    scaleTargetRef points to the target resource to scale, and is used to the pods for which metrics should be collected, as well as to actually change the replica count.
    """


class HorizontalPodAutoscalerStatus(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["HorizontalPodAutoscalerStatus"]:
            return HorizontalPodAutoscalerStatus

        def build(self) -> "HorizontalPodAutoscalerStatus":
            return HorizontalPodAutoscalerStatus(**self._attrs)

        @overload
        def conditions(
            self, value_or_callback: List[HorizontalPodAutoscalerCondition], /
        ) -> "HorizontalPodAutoscalerStatus.Builder": ...

        @overload
        def conditions(
            self,
            value_or_callback: Callable[
                [
                    GenericListBuilder[
                        HorizontalPodAutoscalerCondition,
                        HorizontalPodAutoscalerCondition.Builder,
                    ]
                ],
                GenericListBuilder[
                    HorizontalPodAutoscalerCondition,
                    HorizontalPodAutoscalerCondition.Builder,
                ]
                | List[HorizontalPodAutoscalerCondition],
            ],
            /,
        ) -> "HorizontalPodAutoscalerStatus.Builder": ...

        @overload
        def conditions(
            self, value_or_callback: Never = ...
        ) -> ListBuilderContext[HorizontalPodAutoscalerCondition.Builder]: ...

        def conditions(self, value_or_callback=None, /):
            """
            conditions is the set of conditions required for this autoscaler to scale its target, and indicates whether or not those conditions are met.
            """
            if self._in_context and value_or_callback is None:
                context = ListBuilderContext[HorizontalPodAutoscalerCondition.Builder]()
                context._parent_builder = self
                context._field_name = "conditions"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(HorizontalPodAutoscalerCondition.list_builder())
                if isinstance(output, GenericListBuilder):
                    value = output.build()
                else:
                    value = output
            return self._set("conditions", value)

        @overload
        def current_metrics(
            self, value_or_callback: List[MetricStatus], /
        ) -> "HorizontalPodAutoscalerStatus.Builder": ...

        @overload
        def current_metrics(
            self,
            value_or_callback: Callable[
                [GenericListBuilder[MetricStatus, MetricStatus.Builder]],
                GenericListBuilder[MetricStatus, MetricStatus.Builder] | List[MetricStatus],
            ],
            /,
        ) -> "HorizontalPodAutoscalerStatus.Builder": ...

        @overload
        def current_metrics(
            self, value_or_callback: Never = ...
        ) -> ListBuilderContext[MetricStatus.Builder]: ...

        def current_metrics(self, value_or_callback=None, /):
            """
            currentMetrics is the last read state of the metrics used by this autoscaler.
            """
            if self._in_context and value_or_callback is None:
                context = ListBuilderContext[MetricStatus.Builder]()
                context._parent_builder = self
                context._field_name = "current_metrics"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(MetricStatus.list_builder())
                if isinstance(output, GenericListBuilder):
                    value = output.build()
                else:
                    value = output
            return self._set("current_metrics", value)

        def current_replicas(self, value: Optional[int], /) -> Self:
            """
            currentReplicas is current number of replicas of pods managed by this autoscaler, as last seen by the autoscaler.
            """
            return self._set("current_replicas", value)

        def desired_replicas(self, value: int, /) -> Self:
            """
            desiredReplicas is the desired number of replicas of pods managed by this autoscaler, as last calculated by the autoscaler.
            """
            return self._set("desired_replicas", value)

        @overload
        def last_scale_time(
            self, value_or_callback: Optional[apimachinery.Time], /
        ) -> "HorizontalPodAutoscalerStatus.Builder": ...

        @overload
        def last_scale_time(
            self,
            value_or_callback: Callable[
                [apimachinery.Time.Builder],
                apimachinery.Time.Builder | apimachinery.Time,
            ],
            /,
        ) -> "HorizontalPodAutoscalerStatus.Builder": ...

        @overload
        def last_scale_time(
            self, value_or_callback: Never = ...
        ) -> "apimachinery.Time.BuilderContext": ...

        def last_scale_time(self, value_or_callback=None, /):
            """
            lastScaleTime is the last time the HorizontalPodAutoscaler scaled the number of pods, used by the autoscaler to control how often the number of pods is changed.
            """
            if self._in_context and value_or_callback is None:
                context = apimachinery.Time.BuilderContext()
                context._parent_builder = self
                context._field_name = "last_scale_time"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(apimachinery.Time.builder())
                if isinstance(output, apimachinery.Time.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("last_scale_time", value)

        def observed_generation(self, value: Optional[int], /) -> Self:
            """
            observedGeneration is the most recent generation observed by this autoscaler.
            """
            return self._set("observed_generation", value)

    class BuilderContext(BuilderContextBase["HorizontalPodAutoscalerStatus.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = HorizontalPodAutoscalerStatus.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for HorizontalPodAutoscalerStatus."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["HorizontalPodAutoscalerStatus", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use HorizontalPodAutoscalerStatus.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    conditions: Optional[List[HorizontalPodAutoscalerCondition]] = None
    """
    conditions is the set of conditions required for this autoscaler to scale its target, and indicates whether or not those conditions are met.
    """
    current_metrics: Annotated[Optional[List[MetricStatus]], Field(alias="currentMetrics")] = None
    """
    currentMetrics is the last read state of the metrics used by this autoscaler.
    """
    current_replicas: Annotated[Optional[int], Field(alias="currentReplicas")] = None
    """
    currentReplicas is current number of replicas of pods managed by this autoscaler, as last seen by the autoscaler.
    """
    desired_replicas: Annotated[int, Field(alias="desiredReplicas")]
    """
    desiredReplicas is the desired number of replicas of pods managed by this autoscaler, as last calculated by the autoscaler.
    """
    last_scale_time: Annotated[Optional[apimachinery.Time], Field(alias="lastScaleTime")] = None
    """
    lastScaleTime is the last time the HorizontalPodAutoscaler scaled the number of pods, used by the autoscaler to control how often the number of pods is changed.
    """
    observed_generation: Annotated[Optional[int], Field(alias="observedGeneration")] = None
    """
    observedGeneration is the most recent generation observed by this autoscaler.
    """


class HorizontalPodAutoscaler(Resource):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["HorizontalPodAutoscaler"]:
            return HorizontalPodAutoscaler

        def build(self) -> "HorizontalPodAutoscaler":
            return HorizontalPodAutoscaler(**self._attrs)

        def api_version(self, value: Optional[Literal["autoscaling/v2"]], /) -> Self:
            """
            APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
            """
            return self._set("api_version", value)

        def kind(self, value: Optional[Literal["HorizontalPodAutoscaler"]], /) -> Self:
            """
            Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
            """
            return self._set("kind", value)

        @overload
        def metadata(
            self, value_or_callback: Optional[apimachinery.ObjectMeta], /
        ) -> "HorizontalPodAutoscaler.Builder": ...

        @overload
        def metadata(
            self,
            value_or_callback: Callable[
                [apimachinery.ObjectMeta.Builder],
                apimachinery.ObjectMeta.Builder | apimachinery.ObjectMeta,
            ],
            /,
        ) -> "HorizontalPodAutoscaler.Builder": ...

        @overload
        def metadata(
            self, value_or_callback: Never = ...
        ) -> "apimachinery.ObjectMeta.BuilderContext": ...

        def metadata(self, value_or_callback=None, /):
            """
            metadata is the standard object metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
            """
            if self._in_context and value_or_callback is None:
                context = apimachinery.ObjectMeta.BuilderContext()
                context._parent_builder = self
                context._field_name = "metadata"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(apimachinery.ObjectMeta.builder())
                if isinstance(output, apimachinery.ObjectMeta.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("metadata", value)

        @overload
        def spec(
            self, value_or_callback: Optional[HorizontalPodAutoscalerSpec], /
        ) -> "HorizontalPodAutoscaler.Builder": ...

        @overload
        def spec(
            self,
            value_or_callback: Callable[
                [HorizontalPodAutoscalerSpec.Builder],
                HorizontalPodAutoscalerSpec.Builder | HorizontalPodAutoscalerSpec,
            ],
            /,
        ) -> "HorizontalPodAutoscaler.Builder": ...

        @overload
        def spec(
            self, value_or_callback: Never = ...
        ) -> "HorizontalPodAutoscalerSpec.BuilderContext": ...

        def spec(self, value_or_callback=None, /):
            """
            spec is the specification for the behaviour of the autoscaler. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status.
            """
            if self._in_context and value_or_callback is None:
                context = HorizontalPodAutoscalerSpec.BuilderContext()
                context._parent_builder = self
                context._field_name = "spec"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(HorizontalPodAutoscalerSpec.builder())
                if isinstance(output, HorizontalPodAutoscalerSpec.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("spec", value)

        @overload
        def status(
            self, value_or_callback: Optional[HorizontalPodAutoscalerStatus], /
        ) -> "HorizontalPodAutoscaler.Builder": ...

        @overload
        def status(
            self,
            value_or_callback: Callable[
                [HorizontalPodAutoscalerStatus.Builder],
                HorizontalPodAutoscalerStatus.Builder | HorizontalPodAutoscalerStatus,
            ],
            /,
        ) -> "HorizontalPodAutoscaler.Builder": ...

        @overload
        def status(
            self, value_or_callback: Never = ...
        ) -> "HorizontalPodAutoscalerStatus.BuilderContext": ...

        def status(self, value_or_callback=None, /):
            """
            status is the current information about the autoscaler.
            """
            if self._in_context and value_or_callback is None:
                context = HorizontalPodAutoscalerStatus.BuilderContext()
                context._parent_builder = self
                context._field_name = "status"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(HorizontalPodAutoscalerStatus.builder())
                if isinstance(output, HorizontalPodAutoscalerStatus.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("status", value)

    class BuilderContext(BuilderContextBase["HorizontalPodAutoscaler.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = HorizontalPodAutoscaler.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for HorizontalPodAutoscaler."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["HorizontalPodAutoscaler", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use HorizontalPodAutoscaler.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    api_version: Annotated[Optional[Literal["autoscaling/v2"]], Field(alias="apiVersion")] = (
        "autoscaling/v2"
    )
    """
    APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
    """
    kind: Optional[Literal["HorizontalPodAutoscaler"]] = "HorizontalPodAutoscaler"
    """
    Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
    """
    metadata: Optional[apimachinery.ObjectMeta] = None
    """
    metadata is the standard object metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
    """
    spec: Optional[HorizontalPodAutoscalerSpec] = None
    """
    spec is the specification for the behaviour of the autoscaler. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status.
    """
    status: Optional[HorizontalPodAutoscalerStatus] = None
    """
    status is the current information about the autoscaler.
    """


HorizontalPodAutoscalerList = ResourceList["HorizontalPodAutoscaler"]
