# Generated by cloudcoil-model-codegen v0.5.0
# DO NOT EDIT

from __future__ import annotations

from typing import (
    Annotated,
    Callable,
    Dict,
    List,
    Literal,
    Optional,
    Type,
    overload,
)

from pydantic import Field

from cloudcoil import apimachinery
from cloudcoil.pydantic import (
    BaseModel,
    BaseModelBuilder,
    BuilderContextBase,
    GenericListBuilder,
    ListBuilderContext,
    Never,
    Self,
)
from cloudcoil.resources import Resource


class NonResourceAttributes(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["NonResourceAttributes"]:
            return NonResourceAttributes

        def build(self) -> "NonResourceAttributes":
            return NonResourceAttributes(**self._attrs)

        def path(self, value: Optional[str], /) -> Self:
            """
            Path is the URL path of the request
            """
            return self._set("path", value)

        def verb(self, value: Optional[str], /) -> Self:
            """
            Verb is the standard HTTP verb
            """
            return self._set("verb", value)

    class BuilderContext(BuilderContextBase["NonResourceAttributes.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = NonResourceAttributes.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for NonResourceAttributes."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["NonResourceAttributes", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use NonResourceAttributes.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    path: Optional[str] = None
    """
    Path is the URL path of the request
    """
    verb: Optional[str] = None
    """
    Verb is the standard HTTP verb
    """


class NonResourceRule(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["NonResourceRule"]:
            return NonResourceRule

        def build(self) -> "NonResourceRule":
            return NonResourceRule(**self._attrs)

        def non_resource_ur_ls(self, value: Optional[List[str]], /) -> Self:
            """
            NonResourceURLs is a set of partial urls that a user should have access to.  *s are allowed, but only as the full, final step in the path.  "*" means all.
            """
            return self._set("non_resource_ur_ls", value)

        def verbs(self, value: List[str], /) -> Self:
            """
            Verb is a list of kubernetes non-resource API verbs, like: get, post, put, delete, patch, head, options.  "*" means all.
            """
            return self._set("verbs", value)

    class BuilderContext(BuilderContextBase["NonResourceRule.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = NonResourceRule.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for NonResourceRule."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["NonResourceRule", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use NonResourceRule.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    non_resource_ur_ls: Annotated[Optional[List[str]], Field(alias="nonResourceURLs")] = None
    """
    NonResourceURLs is a set of partial urls that a user should have access to.  *s are allowed, but only as the full, final step in the path.  "*" means all.
    """
    verbs: List[str]
    """
    Verb is a list of kubernetes non-resource API verbs, like: get, post, put, delete, patch, head, options.  "*" means all.
    """


class ResourceRule(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["ResourceRule"]:
            return ResourceRule

        def build(self) -> "ResourceRule":
            return ResourceRule(**self._attrs)

        def api_groups(self, value: Optional[List[str]], /) -> Self:
            """
            APIGroups is the name of the APIGroup that contains the resources.  If multiple API groups are specified, any action requested against one of the enumerated resources in any API group will be allowed.  "*" means all.
            """
            return self._set("api_groups", value)

        def resource_names(self, value: Optional[List[str]], /) -> Self:
            """
            ResourceNames is an optional white list of names that the rule applies to.  An empty set means that everything is allowed.  "*" means all.
            """
            return self._set("resource_names", value)

        def resources(self, value: Optional[List[str]], /) -> Self:
            """
            Resources is a list of resources this rule applies to.  "*" means all in the specified apiGroups.
             "*/foo" represents the subresource 'foo' for all resources in the specified apiGroups.
            """
            return self._set("resources", value)

        def verbs(self, value: List[str], /) -> Self:
            """
            Verb is a list of kubernetes resource API verbs, like: get, list, watch, create, update, delete, proxy.  "*" means all.
            """
            return self._set("verbs", value)

    class BuilderContext(BuilderContextBase["ResourceRule.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = ResourceRule.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for ResourceRule."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["ResourceRule", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use ResourceRule.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    api_groups: Annotated[Optional[List[str]], Field(alias="apiGroups")] = None
    """
    APIGroups is the name of the APIGroup that contains the resources.  If multiple API groups are specified, any action requested against one of the enumerated resources in any API group will be allowed.  "*" means all.
    """
    resource_names: Annotated[Optional[List[str]], Field(alias="resourceNames")] = None
    """
    ResourceNames is an optional white list of names that the rule applies to.  An empty set means that everything is allowed.  "*" means all.
    """
    resources: Optional[List[str]] = None
    """
    Resources is a list of resources this rule applies to.  "*" means all in the specified apiGroups.
     "*/foo" represents the subresource 'foo' for all resources in the specified apiGroups.
    """
    verbs: List[str]
    """
    Verb is a list of kubernetes resource API verbs, like: get, list, watch, create, update, delete, proxy.  "*" means all.
    """


class SelfSubjectRulesReviewSpec(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["SelfSubjectRulesReviewSpec"]:
            return SelfSubjectRulesReviewSpec

        def build(self) -> "SelfSubjectRulesReviewSpec":
            return SelfSubjectRulesReviewSpec(**self._attrs)

        def namespace(self, value: Optional[str], /) -> Self:
            """
            Namespace to evaluate rules for. Required.
            """
            return self._set("namespace", value)

    class BuilderContext(BuilderContextBase["SelfSubjectRulesReviewSpec.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = SelfSubjectRulesReviewSpec.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for SelfSubjectRulesReviewSpec."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["SelfSubjectRulesReviewSpec", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use SelfSubjectRulesReviewSpec.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    namespace: Optional[str] = None
    """
    Namespace to evaluate rules for. Required.
    """


class SubjectAccessReviewStatus(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["SubjectAccessReviewStatus"]:
            return SubjectAccessReviewStatus

        def build(self) -> "SubjectAccessReviewStatus":
            return SubjectAccessReviewStatus(**self._attrs)

        def allowed(self, value: bool, /) -> Self:
            """
            Allowed is required. True if the action would be allowed, false otherwise.
            """
            return self._set("allowed", value)

        def denied(self, value: Optional[bool], /) -> Self:
            """
            Denied is optional. True if the action would be denied, otherwise false. If both allowed is false and denied is false, then the authorizer has no opinion on whether to authorize the action. Denied may not be true if Allowed is true.
            """
            return self._set("denied", value)

        def evaluation_error(self, value: Optional[str], /) -> Self:
            """
            EvaluationError is an indication that some error occurred during the authorization check. It is entirely possible to get an error and be able to continue determine authorization status in spite of it. For instance, RBAC can be missing a role, but enough roles are still present and bound to reason about the request.
            """
            return self._set("evaluation_error", value)

        def reason(self, value: Optional[str], /) -> Self:
            """
            Reason is optional.  It indicates why a request was allowed or denied.
            """
            return self._set("reason", value)

    class BuilderContext(BuilderContextBase["SubjectAccessReviewStatus.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = SubjectAccessReviewStatus.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for SubjectAccessReviewStatus."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["SubjectAccessReviewStatus", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use SubjectAccessReviewStatus.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    allowed: bool
    """
    Allowed is required. True if the action would be allowed, false otherwise.
    """
    denied: Optional[bool] = None
    """
    Denied is optional. True if the action would be denied, otherwise false. If both allowed is false and denied is false, then the authorizer has no opinion on whether to authorize the action. Denied may not be true if Allowed is true.
    """
    evaluation_error: Annotated[Optional[str], Field(alias="evaluationError")] = None
    """
    EvaluationError is an indication that some error occurred during the authorization check. It is entirely possible to get an error and be able to continue determine authorization status in spite of it. For instance, RBAC can be missing a role, but enough roles are still present and bound to reason about the request.
    """
    reason: Optional[str] = None
    """
    Reason is optional.  It indicates why a request was allowed or denied.
    """


class SubjectRulesReviewStatus(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["SubjectRulesReviewStatus"]:
            return SubjectRulesReviewStatus

        def build(self) -> "SubjectRulesReviewStatus":
            return SubjectRulesReviewStatus(**self._attrs)

        def evaluation_error(self, value: Optional[str], /) -> Self:
            """
            EvaluationError can appear in combination with Rules. It indicates an error occurred during rule evaluation, such as an authorizer that doesn't support rule evaluation, and that ResourceRules and/or NonResourceRules may be incomplete.
            """
            return self._set("evaluation_error", value)

        def incomplete(self, value: bool, /) -> Self:
            """
            Incomplete is true when the rules returned by this call are incomplete. This is most commonly encountered when an authorizer, such as an external authorizer, doesn't support rules evaluation.
            """
            return self._set("incomplete", value)

        @overload
        def non_resource_rules(
            self, value_or_callback: List[NonResourceRule], /
        ) -> "SubjectRulesReviewStatus.Builder": ...

        @overload
        def non_resource_rules(
            self,
            value_or_callback: Callable[
                [GenericListBuilder[NonResourceRule, NonResourceRule.Builder]],
                GenericListBuilder[NonResourceRule, NonResourceRule.Builder]
                | List[NonResourceRule],
            ],
            /,
        ) -> "SubjectRulesReviewStatus.Builder": ...

        @overload
        def non_resource_rules(
            self, value_or_callback: Never = ...
        ) -> ListBuilderContext[NonResourceRule.Builder]: ...

        def non_resource_rules(self, value_or_callback=None, /):
            """
            NonResourceRules is the list of actions the subject is allowed to perform on non-resources. The list ordering isn't significant, may contain duplicates, and possibly be incomplete.
            """
            if self._in_context and value_or_callback is None:
                context = ListBuilderContext[NonResourceRule.Builder]()
                context._parent_builder = self
                context._field_name = "non_resource_rules"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(NonResourceRule.list_builder())
                if isinstance(output, GenericListBuilder):
                    value = output.build()
                else:
                    value = output
            return self._set("non_resource_rules", value)

        @overload
        def resource_rules(
            self, value_or_callback: List[ResourceRule], /
        ) -> "SubjectRulesReviewStatus.Builder": ...

        @overload
        def resource_rules(
            self,
            value_or_callback: Callable[
                [GenericListBuilder[ResourceRule, ResourceRule.Builder]],
                GenericListBuilder[ResourceRule, ResourceRule.Builder] | List[ResourceRule],
            ],
            /,
        ) -> "SubjectRulesReviewStatus.Builder": ...

        @overload
        def resource_rules(
            self, value_or_callback: Never = ...
        ) -> ListBuilderContext[ResourceRule.Builder]: ...

        def resource_rules(self, value_or_callback=None, /):
            """
            ResourceRules is the list of actions the subject is allowed to perform on resources. The list ordering isn't significant, may contain duplicates, and possibly be incomplete.
            """
            if self._in_context and value_or_callback is None:
                context = ListBuilderContext[ResourceRule.Builder]()
                context._parent_builder = self
                context._field_name = "resource_rules"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(ResourceRule.list_builder())
                if isinstance(output, GenericListBuilder):
                    value = output.build()
                else:
                    value = output
            return self._set("resource_rules", value)

    class BuilderContext(BuilderContextBase["SubjectRulesReviewStatus.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = SubjectRulesReviewStatus.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for SubjectRulesReviewStatus."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["SubjectRulesReviewStatus", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use SubjectRulesReviewStatus.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    evaluation_error: Annotated[Optional[str], Field(alias="evaluationError")] = None
    """
    EvaluationError can appear in combination with Rules. It indicates an error occurred during rule evaluation, such as an authorizer that doesn't support rule evaluation, and that ResourceRules and/or NonResourceRules may be incomplete.
    """
    incomplete: bool
    """
    Incomplete is true when the rules returned by this call are incomplete. This is most commonly encountered when an authorizer, such as an external authorizer, doesn't support rules evaluation.
    """
    non_resource_rules: Annotated[List[NonResourceRule], Field(alias="nonResourceRules")]
    """
    NonResourceRules is the list of actions the subject is allowed to perform on non-resources. The list ordering isn't significant, may contain duplicates, and possibly be incomplete.
    """
    resource_rules: Annotated[List[ResourceRule], Field(alias="resourceRules")]
    """
    ResourceRules is the list of actions the subject is allowed to perform on resources. The list ordering isn't significant, may contain duplicates, and possibly be incomplete.
    """


class FieldSelectorAttributes(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["FieldSelectorAttributes"]:
            return FieldSelectorAttributes

        def build(self) -> "FieldSelectorAttributes":
            return FieldSelectorAttributes(**self._attrs)

        def raw_selector(self, value: Optional[str], /) -> Self:
            """
            rawSelector is the serialization of a field selector that would be included in a query parameter. Webhook implementations are encouraged to ignore rawSelector. The kube-apiserver's *SubjectAccessReview will parse the rawSelector as long as the requirements are not present.
            """
            return self._set("raw_selector", value)

        @overload
        def requirements(
            self, value_or_callback: List[apimachinery.FieldSelectorRequirement], /
        ) -> "FieldSelectorAttributes.Builder": ...

        @overload
        def requirements(
            self,
            value_or_callback: Callable[
                [
                    GenericListBuilder[
                        apimachinery.FieldSelectorRequirement,
                        apimachinery.FieldSelectorRequirement.Builder,
                    ]
                ],
                GenericListBuilder[
                    apimachinery.FieldSelectorRequirement,
                    apimachinery.FieldSelectorRequirement.Builder,
                ]
                | List[apimachinery.FieldSelectorRequirement],
            ],
            /,
        ) -> "FieldSelectorAttributes.Builder": ...

        @overload
        def requirements(
            self, value_or_callback: Never = ...
        ) -> ListBuilderContext[apimachinery.FieldSelectorRequirement.Builder]: ...

        def requirements(self, value_or_callback=None, /):
            """
            requirements is the parsed interpretation of a field selector. All requirements must be met for a resource instance to match the selector. Webhook implementations should handle requirements, but how to handle them is up to the webhook. Since requirements can only limit the request, it is safe to authorize as unlimited request if the requirements are not understood.
            """
            if self._in_context and value_or_callback is None:
                context = ListBuilderContext[apimachinery.FieldSelectorRequirement.Builder]()
                context._parent_builder = self
                context._field_name = "requirements"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(apimachinery.FieldSelectorRequirement.list_builder())
                if isinstance(output, GenericListBuilder):
                    value = output.build()
                else:
                    value = output
            return self._set("requirements", value)

    class BuilderContext(BuilderContextBase["FieldSelectorAttributes.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = FieldSelectorAttributes.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for FieldSelectorAttributes."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["FieldSelectorAttributes", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use FieldSelectorAttributes.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    raw_selector: Annotated[Optional[str], Field(alias="rawSelector")] = None
    """
    rawSelector is the serialization of a field selector that would be included in a query parameter. Webhook implementations are encouraged to ignore rawSelector. The kube-apiserver's *SubjectAccessReview will parse the rawSelector as long as the requirements are not present.
    """
    requirements: Optional[List[apimachinery.FieldSelectorRequirement]] = None
    """
    requirements is the parsed interpretation of a field selector. All requirements must be met for a resource instance to match the selector. Webhook implementations should handle requirements, but how to handle them is up to the webhook. Since requirements can only limit the request, it is safe to authorize as unlimited request if the requirements are not understood.
    """


class LabelSelectorAttributes(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["LabelSelectorAttributes"]:
            return LabelSelectorAttributes

        def build(self) -> "LabelSelectorAttributes":
            return LabelSelectorAttributes(**self._attrs)

        def raw_selector(self, value: Optional[str], /) -> Self:
            """
            rawSelector is the serialization of a field selector that would be included in a query parameter. Webhook implementations are encouraged to ignore rawSelector. The kube-apiserver's *SubjectAccessReview will parse the rawSelector as long as the requirements are not present.
            """
            return self._set("raw_selector", value)

        @overload
        def requirements(
            self, value_or_callback: List[apimachinery.LabelSelectorRequirement], /
        ) -> "LabelSelectorAttributes.Builder": ...

        @overload
        def requirements(
            self,
            value_or_callback: Callable[
                [
                    GenericListBuilder[
                        apimachinery.LabelSelectorRequirement,
                        apimachinery.LabelSelectorRequirement.Builder,
                    ]
                ],
                GenericListBuilder[
                    apimachinery.LabelSelectorRequirement,
                    apimachinery.LabelSelectorRequirement.Builder,
                ]
                | List[apimachinery.LabelSelectorRequirement],
            ],
            /,
        ) -> "LabelSelectorAttributes.Builder": ...

        @overload
        def requirements(
            self, value_or_callback: Never = ...
        ) -> ListBuilderContext[apimachinery.LabelSelectorRequirement.Builder]: ...

        def requirements(self, value_or_callback=None, /):
            """
            requirements is the parsed interpretation of a label selector. All requirements must be met for a resource instance to match the selector. Webhook implementations should handle requirements, but how to handle them is up to the webhook. Since requirements can only limit the request, it is safe to authorize as unlimited request if the requirements are not understood.
            """
            if self._in_context and value_or_callback is None:
                context = ListBuilderContext[apimachinery.LabelSelectorRequirement.Builder]()
                context._parent_builder = self
                context._field_name = "requirements"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(apimachinery.LabelSelectorRequirement.list_builder())
                if isinstance(output, GenericListBuilder):
                    value = output.build()
                else:
                    value = output
            return self._set("requirements", value)

    class BuilderContext(BuilderContextBase["LabelSelectorAttributes.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = LabelSelectorAttributes.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for LabelSelectorAttributes."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["LabelSelectorAttributes", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use LabelSelectorAttributes.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    raw_selector: Annotated[Optional[str], Field(alias="rawSelector")] = None
    """
    rawSelector is the serialization of a field selector that would be included in a query parameter. Webhook implementations are encouraged to ignore rawSelector. The kube-apiserver's *SubjectAccessReview will parse the rawSelector as long as the requirements are not present.
    """
    requirements: Optional[List[apimachinery.LabelSelectorRequirement]] = None
    """
    requirements is the parsed interpretation of a label selector. All requirements must be met for a resource instance to match the selector. Webhook implementations should handle requirements, but how to handle them is up to the webhook. Since requirements can only limit the request, it is safe to authorize as unlimited request if the requirements are not understood.
    """


class ResourceAttributes(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["ResourceAttributes"]:
            return ResourceAttributes

        def build(self) -> "ResourceAttributes":
            return ResourceAttributes(**self._attrs)

        @overload
        def field_selector(
            self, value_or_callback: Optional[FieldSelectorAttributes], /
        ) -> "ResourceAttributes.Builder": ...

        @overload
        def field_selector(
            self,
            value_or_callback: Callable[
                [FieldSelectorAttributes.Builder],
                FieldSelectorAttributes.Builder | FieldSelectorAttributes,
            ],
            /,
        ) -> "ResourceAttributes.Builder": ...

        @overload
        def field_selector(
            self, value_or_callback: Never = ...
        ) -> "FieldSelectorAttributes.BuilderContext": ...

        def field_selector(self, value_or_callback=None, /):
            """
            fieldSelector describes the limitation on access based on field.  It can only limit access, not broaden it.

            This field  is alpha-level. To use this field, you must enable the `AuthorizeWithSelectors` feature gate (disabled by default).
            """
            if self._in_context and value_or_callback is None:
                context = FieldSelectorAttributes.BuilderContext()
                context._parent_builder = self
                context._field_name = "field_selector"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(FieldSelectorAttributes.builder())
                if isinstance(output, FieldSelectorAttributes.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("field_selector", value)

        def group(self, value: Optional[str], /) -> Self:
            """
            Group is the API Group of the Resource.  "*" means all.
            """
            return self._set("group", value)

        @overload
        def label_selector(
            self, value_or_callback: Optional[LabelSelectorAttributes], /
        ) -> "ResourceAttributes.Builder": ...

        @overload
        def label_selector(
            self,
            value_or_callback: Callable[
                [LabelSelectorAttributes.Builder],
                LabelSelectorAttributes.Builder | LabelSelectorAttributes,
            ],
            /,
        ) -> "ResourceAttributes.Builder": ...

        @overload
        def label_selector(
            self, value_or_callback: Never = ...
        ) -> "LabelSelectorAttributes.BuilderContext": ...

        def label_selector(self, value_or_callback=None, /):
            """
            labelSelector describes the limitation on access based on labels.  It can only limit access, not broaden it.

            This field  is alpha-level. To use this field, you must enable the `AuthorizeWithSelectors` feature gate (disabled by default).
            """
            if self._in_context and value_or_callback is None:
                context = LabelSelectorAttributes.BuilderContext()
                context._parent_builder = self
                context._field_name = "label_selector"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(LabelSelectorAttributes.builder())
                if isinstance(output, LabelSelectorAttributes.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("label_selector", value)

        def name(self, value: Optional[str], /) -> Self:
            """
            Name is the name of the resource being requested for a "get" or deleted for a "delete". "" (empty) means all.
            """
            return self._set("name", value)

        def namespace(self, value: Optional[str], /) -> Self:
            """
            Namespace is the namespace of the action being requested.  Currently, there is no distinction between no namespace and all namespaces "" (empty) is defaulted for LocalSubjectAccessReviews "" (empty) is empty for cluster-scoped resources "" (empty) means "all" for namespace scoped resources from a SubjectAccessReview or SelfSubjectAccessReview
            """
            return self._set("namespace", value)

        def resource(self, value: Optional[str], /) -> Self:
            """
            Resource is one of the existing resource types.  "*" means all.
            """
            return self._set("resource", value)

        def subresource(self, value: Optional[str], /) -> Self:
            """
            Subresource is one of the existing resource types.  "" means none.
            """
            return self._set("subresource", value)

        def verb(self, value: Optional[str], /) -> Self:
            """
            Verb is a kubernetes resource API verb, like: get, list, watch, create, update, delete, proxy.  "*" means all.
            """
            return self._set("verb", value)

        def version(self, value: Optional[str], /) -> Self:
            """
            Version is the API Version of the Resource.  "*" means all.
            """
            return self._set("version", value)

    class BuilderContext(BuilderContextBase["ResourceAttributes.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = ResourceAttributes.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for ResourceAttributes."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["ResourceAttributes", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use ResourceAttributes.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    field_selector: Annotated[Optional[FieldSelectorAttributes], Field(alias="fieldSelector")] = (
        None
    )
    """
    fieldSelector describes the limitation on access based on field.  It can only limit access, not broaden it.

    This field  is alpha-level. To use this field, you must enable the `AuthorizeWithSelectors` feature gate (disabled by default).
    """
    group: Optional[str] = None
    """
    Group is the API Group of the Resource.  "*" means all.
    """
    label_selector: Annotated[Optional[LabelSelectorAttributes], Field(alias="labelSelector")] = (
        None
    )
    """
    labelSelector describes the limitation on access based on labels.  It can only limit access, not broaden it.

    This field  is alpha-level. To use this field, you must enable the `AuthorizeWithSelectors` feature gate (disabled by default).
    """
    name: Optional[str] = None
    """
    Name is the name of the resource being requested for a "get" or deleted for a "delete". "" (empty) means all.
    """
    namespace: Optional[str] = None
    """
    Namespace is the namespace of the action being requested.  Currently, there is no distinction between no namespace and all namespaces "" (empty) is defaulted for LocalSubjectAccessReviews "" (empty) is empty for cluster-scoped resources "" (empty) means "all" for namespace scoped resources from a SubjectAccessReview or SelfSubjectAccessReview
    """
    resource: Optional[str] = None
    """
    Resource is one of the existing resource types.  "*" means all.
    """
    subresource: Optional[str] = None
    """
    Subresource is one of the existing resource types.  "" means none.
    """
    verb: Optional[str] = None
    """
    Verb is a kubernetes resource API verb, like: get, list, watch, create, update, delete, proxy.  "*" means all.
    """
    version: Optional[str] = None
    """
    Version is the API Version of the Resource.  "*" means all.
    """


class SelfSubjectAccessReviewSpec(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["SelfSubjectAccessReviewSpec"]:
            return SelfSubjectAccessReviewSpec

        def build(self) -> "SelfSubjectAccessReviewSpec":
            return SelfSubjectAccessReviewSpec(**self._attrs)

        @overload
        def non_resource_attributes(
            self, value_or_callback: Optional[NonResourceAttributes], /
        ) -> "SelfSubjectAccessReviewSpec.Builder": ...

        @overload
        def non_resource_attributes(
            self,
            value_or_callback: Callable[
                [NonResourceAttributes.Builder],
                NonResourceAttributes.Builder | NonResourceAttributes,
            ],
            /,
        ) -> "SelfSubjectAccessReviewSpec.Builder": ...

        @overload
        def non_resource_attributes(
            self, value_or_callback: Never = ...
        ) -> "NonResourceAttributes.BuilderContext": ...

        def non_resource_attributes(self, value_or_callback=None, /):
            """
            NonResourceAttributes describes information for a non-resource access request
            """
            if self._in_context and value_or_callback is None:
                context = NonResourceAttributes.BuilderContext()
                context._parent_builder = self
                context._field_name = "non_resource_attributes"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(NonResourceAttributes.builder())
                if isinstance(output, NonResourceAttributes.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("non_resource_attributes", value)

        @overload
        def resource_attributes(
            self, value_or_callback: Optional[ResourceAttributes], /
        ) -> "SelfSubjectAccessReviewSpec.Builder": ...

        @overload
        def resource_attributes(
            self,
            value_or_callback: Callable[
                [ResourceAttributes.Builder],
                ResourceAttributes.Builder | ResourceAttributes,
            ],
            /,
        ) -> "SelfSubjectAccessReviewSpec.Builder": ...

        @overload
        def resource_attributes(
            self, value_or_callback: Never = ...
        ) -> "ResourceAttributes.BuilderContext": ...

        def resource_attributes(self, value_or_callback=None, /):
            """
            ResourceAuthorizationAttributes describes information for a resource access request
            """
            if self._in_context and value_or_callback is None:
                context = ResourceAttributes.BuilderContext()
                context._parent_builder = self
                context._field_name = "resource_attributes"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(ResourceAttributes.builder())
                if isinstance(output, ResourceAttributes.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("resource_attributes", value)

    class BuilderContext(BuilderContextBase["SelfSubjectAccessReviewSpec.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = SelfSubjectAccessReviewSpec.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for SelfSubjectAccessReviewSpec."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["SelfSubjectAccessReviewSpec", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use SelfSubjectAccessReviewSpec.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    non_resource_attributes: Annotated[
        Optional[NonResourceAttributes], Field(alias="nonResourceAttributes")
    ] = None
    """
    NonResourceAttributes describes information for a non-resource access request
    """
    resource_attributes: Annotated[
        Optional[ResourceAttributes], Field(alias="resourceAttributes")
    ] = None
    """
    ResourceAuthorizationAttributes describes information for a resource access request
    """


class SubjectAccessReviewSpec(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["SubjectAccessReviewSpec"]:
            return SubjectAccessReviewSpec

        def build(self) -> "SubjectAccessReviewSpec":
            return SubjectAccessReviewSpec(**self._attrs)

        def extra(self, value: Optional[Dict[str, List[str]]], /) -> Self:
            """
            Extra corresponds to the user.Info.GetExtra() method from the authenticator.  Since that is input to the authorizer it needs a reflection here.
            """
            return self._set("extra", value)

        def groups(self, value: Optional[List[str]], /) -> Self:
            """
            Groups is the groups you're testing for.
            """
            return self._set("groups", value)

        @overload
        def non_resource_attributes(
            self, value_or_callback: Optional[NonResourceAttributes], /
        ) -> "SubjectAccessReviewSpec.Builder": ...

        @overload
        def non_resource_attributes(
            self,
            value_or_callback: Callable[
                [NonResourceAttributes.Builder],
                NonResourceAttributes.Builder | NonResourceAttributes,
            ],
            /,
        ) -> "SubjectAccessReviewSpec.Builder": ...

        @overload
        def non_resource_attributes(
            self, value_or_callback: Never = ...
        ) -> "NonResourceAttributes.BuilderContext": ...

        def non_resource_attributes(self, value_or_callback=None, /):
            """
            NonResourceAttributes describes information for a non-resource access request
            """
            if self._in_context and value_or_callback is None:
                context = NonResourceAttributes.BuilderContext()
                context._parent_builder = self
                context._field_name = "non_resource_attributes"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(NonResourceAttributes.builder())
                if isinstance(output, NonResourceAttributes.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("non_resource_attributes", value)

        @overload
        def resource_attributes(
            self, value_or_callback: Optional[ResourceAttributes], /
        ) -> "SubjectAccessReviewSpec.Builder": ...

        @overload
        def resource_attributes(
            self,
            value_or_callback: Callable[
                [ResourceAttributes.Builder],
                ResourceAttributes.Builder | ResourceAttributes,
            ],
            /,
        ) -> "SubjectAccessReviewSpec.Builder": ...

        @overload
        def resource_attributes(
            self, value_or_callback: Never = ...
        ) -> "ResourceAttributes.BuilderContext": ...

        def resource_attributes(self, value_or_callback=None, /):
            """
            ResourceAuthorizationAttributes describes information for a resource access request
            """
            if self._in_context and value_or_callback is None:
                context = ResourceAttributes.BuilderContext()
                context._parent_builder = self
                context._field_name = "resource_attributes"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(ResourceAttributes.builder())
                if isinstance(output, ResourceAttributes.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("resource_attributes", value)

        def uid(self, value: Optional[str], /) -> Self:
            """
            UID information about the requesting user.
            """
            return self._set("uid", value)

        def user(self, value: Optional[str], /) -> Self:
            """
            User is the user you're testing for. If you specify "User" but not "Groups", then is it interpreted as "What if User were not a member of any groups
            """
            return self._set("user", value)

    class BuilderContext(BuilderContextBase["SubjectAccessReviewSpec.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = SubjectAccessReviewSpec.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for SubjectAccessReviewSpec."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["SubjectAccessReviewSpec", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use SubjectAccessReviewSpec.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    extra: Optional[Dict[str, List[str]]] = None
    """
    Extra corresponds to the user.Info.GetExtra() method from the authenticator.  Since that is input to the authorizer it needs a reflection here.
    """
    groups: Optional[List[str]] = None
    """
    Groups is the groups you're testing for.
    """
    non_resource_attributes: Annotated[
        Optional[NonResourceAttributes], Field(alias="nonResourceAttributes")
    ] = None
    """
    NonResourceAttributes describes information for a non-resource access request
    """
    resource_attributes: Annotated[
        Optional[ResourceAttributes], Field(alias="resourceAttributes")
    ] = None
    """
    ResourceAuthorizationAttributes describes information for a resource access request
    """
    uid: Optional[str] = None
    """
    UID information about the requesting user.
    """
    user: Optional[str] = None
    """
    User is the user you're testing for. If you specify "User" but not "Groups", then is it interpreted as "What if User were not a member of any groups
    """


class LocalSubjectAccessReview(Resource):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["LocalSubjectAccessReview"]:
            return LocalSubjectAccessReview

        def build(self) -> "LocalSubjectAccessReview":
            return LocalSubjectAccessReview(**self._attrs)

        def api_version(self, value: Optional[Literal["authorization.k8s.io/v1"]], /) -> Self:
            """
            APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
            """
            return self._set("api_version", value)

        def kind(self, value: Optional[Literal["LocalSubjectAccessReview"]], /) -> Self:
            """
            Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
            """
            return self._set("kind", value)

        @overload
        def metadata(
            self, value_or_callback: Optional[apimachinery.ObjectMeta], /
        ) -> "LocalSubjectAccessReview.Builder": ...

        @overload
        def metadata(
            self,
            value_or_callback: Callable[
                [apimachinery.ObjectMeta.Builder],
                apimachinery.ObjectMeta.Builder | apimachinery.ObjectMeta,
            ],
            /,
        ) -> "LocalSubjectAccessReview.Builder": ...

        @overload
        def metadata(
            self, value_or_callback: Never = ...
        ) -> "apimachinery.ObjectMeta.BuilderContext": ...

        def metadata(self, value_or_callback=None, /):
            """
            Standard list metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
            """
            if self._in_context and value_or_callback is None:
                context = apimachinery.ObjectMeta.BuilderContext()
                context._parent_builder = self
                context._field_name = "metadata"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(apimachinery.ObjectMeta.builder())
                if isinstance(output, apimachinery.ObjectMeta.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("metadata", value)

        @overload
        def spec(
            self, value_or_callback: SubjectAccessReviewSpec, /
        ) -> "LocalSubjectAccessReview.Builder": ...

        @overload
        def spec(
            self,
            value_or_callback: Callable[
                [SubjectAccessReviewSpec.Builder],
                SubjectAccessReviewSpec.Builder | SubjectAccessReviewSpec,
            ],
            /,
        ) -> "LocalSubjectAccessReview.Builder": ...

        @overload
        def spec(
            self, value_or_callback: Never = ...
        ) -> "SubjectAccessReviewSpec.BuilderContext": ...

        def spec(self, value_or_callback=None, /):
            """
            Spec holds information about the request being evaluated.  spec.namespace must be equal to the namespace you made the request against.  If empty, it is defaulted.
            """
            if self._in_context and value_or_callback is None:
                context = SubjectAccessReviewSpec.BuilderContext()
                context._parent_builder = self
                context._field_name = "spec"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(SubjectAccessReviewSpec.builder())
                if isinstance(output, SubjectAccessReviewSpec.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("spec", value)

        @overload
        def status(
            self, value_or_callback: Optional[SubjectAccessReviewStatus], /
        ) -> "LocalSubjectAccessReview.Builder": ...

        @overload
        def status(
            self,
            value_or_callback: Callable[
                [SubjectAccessReviewStatus.Builder],
                SubjectAccessReviewStatus.Builder | SubjectAccessReviewStatus,
            ],
            /,
        ) -> "LocalSubjectAccessReview.Builder": ...

        @overload
        def status(
            self, value_or_callback: Never = ...
        ) -> "SubjectAccessReviewStatus.BuilderContext": ...

        def status(self, value_or_callback=None, /):
            """
            Status is filled in by the server and indicates whether the request is allowed or not
            """
            if self._in_context and value_or_callback is None:
                context = SubjectAccessReviewStatus.BuilderContext()
                context._parent_builder = self
                context._field_name = "status"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(SubjectAccessReviewStatus.builder())
                if isinstance(output, SubjectAccessReviewStatus.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("status", value)

    class BuilderContext(BuilderContextBase["LocalSubjectAccessReview.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = LocalSubjectAccessReview.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for LocalSubjectAccessReview."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["LocalSubjectAccessReview", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use LocalSubjectAccessReview.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    api_version: Annotated[
        Optional[Literal["authorization.k8s.io/v1"]], Field(alias="apiVersion")
    ] = "authorization.k8s.io/v1"
    """
    APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
    """
    kind: Optional[Literal["LocalSubjectAccessReview"]] = "LocalSubjectAccessReview"
    """
    Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
    """
    metadata: Optional[apimachinery.ObjectMeta] = None
    """
    Standard list metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
    """
    spec: SubjectAccessReviewSpec
    """
    Spec holds information about the request being evaluated.  spec.namespace must be equal to the namespace you made the request against.  If empty, it is defaulted.
    """
    status: Optional[SubjectAccessReviewStatus] = None
    """
    Status is filled in by the server and indicates whether the request is allowed or not
    """


class SelfSubjectAccessReview(Resource):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["SelfSubjectAccessReview"]:
            return SelfSubjectAccessReview

        def build(self) -> "SelfSubjectAccessReview":
            return SelfSubjectAccessReview(**self._attrs)

        def api_version(self, value: Optional[Literal["authorization.k8s.io/v1"]], /) -> Self:
            """
            APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
            """
            return self._set("api_version", value)

        def kind(self, value: Optional[Literal["SelfSubjectAccessReview"]], /) -> Self:
            """
            Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
            """
            return self._set("kind", value)

        @overload
        def metadata(
            self, value_or_callback: Optional[apimachinery.ObjectMeta], /
        ) -> "SelfSubjectAccessReview.Builder": ...

        @overload
        def metadata(
            self,
            value_or_callback: Callable[
                [apimachinery.ObjectMeta.Builder],
                apimachinery.ObjectMeta.Builder | apimachinery.ObjectMeta,
            ],
            /,
        ) -> "SelfSubjectAccessReview.Builder": ...

        @overload
        def metadata(
            self, value_or_callback: Never = ...
        ) -> "apimachinery.ObjectMeta.BuilderContext": ...

        def metadata(self, value_or_callback=None, /):
            """
            Standard list metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
            """
            if self._in_context and value_or_callback is None:
                context = apimachinery.ObjectMeta.BuilderContext()
                context._parent_builder = self
                context._field_name = "metadata"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(apimachinery.ObjectMeta.builder())
                if isinstance(output, apimachinery.ObjectMeta.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("metadata", value)

        @overload
        def spec(
            self, value_or_callback: SelfSubjectAccessReviewSpec, /
        ) -> "SelfSubjectAccessReview.Builder": ...

        @overload
        def spec(
            self,
            value_or_callback: Callable[
                [SelfSubjectAccessReviewSpec.Builder],
                SelfSubjectAccessReviewSpec.Builder | SelfSubjectAccessReviewSpec,
            ],
            /,
        ) -> "SelfSubjectAccessReview.Builder": ...

        @overload
        def spec(
            self, value_or_callback: Never = ...
        ) -> "SelfSubjectAccessReviewSpec.BuilderContext": ...

        def spec(self, value_or_callback=None, /):
            """
            Spec holds information about the request being evaluated.  user and groups must be empty
            """
            if self._in_context and value_or_callback is None:
                context = SelfSubjectAccessReviewSpec.BuilderContext()
                context._parent_builder = self
                context._field_name = "spec"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(SelfSubjectAccessReviewSpec.builder())
                if isinstance(output, SelfSubjectAccessReviewSpec.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("spec", value)

        @overload
        def status(
            self, value_or_callback: Optional[SubjectAccessReviewStatus], /
        ) -> "SelfSubjectAccessReview.Builder": ...

        @overload
        def status(
            self,
            value_or_callback: Callable[
                [SubjectAccessReviewStatus.Builder],
                SubjectAccessReviewStatus.Builder | SubjectAccessReviewStatus,
            ],
            /,
        ) -> "SelfSubjectAccessReview.Builder": ...

        @overload
        def status(
            self, value_or_callback: Never = ...
        ) -> "SubjectAccessReviewStatus.BuilderContext": ...

        def status(self, value_or_callback=None, /):
            """
            Status is filled in by the server and indicates whether the request is allowed or not
            """
            if self._in_context and value_or_callback is None:
                context = SubjectAccessReviewStatus.BuilderContext()
                context._parent_builder = self
                context._field_name = "status"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(SubjectAccessReviewStatus.builder())
                if isinstance(output, SubjectAccessReviewStatus.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("status", value)

    class BuilderContext(BuilderContextBase["SelfSubjectAccessReview.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = SelfSubjectAccessReview.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for SelfSubjectAccessReview."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["SelfSubjectAccessReview", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use SelfSubjectAccessReview.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    api_version: Annotated[
        Optional[Literal["authorization.k8s.io/v1"]], Field(alias="apiVersion")
    ] = "authorization.k8s.io/v1"
    """
    APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
    """
    kind: Optional[Literal["SelfSubjectAccessReview"]] = "SelfSubjectAccessReview"
    """
    Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
    """
    metadata: Optional[apimachinery.ObjectMeta] = None
    """
    Standard list metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
    """
    spec: SelfSubjectAccessReviewSpec
    """
    Spec holds information about the request being evaluated.  user and groups must be empty
    """
    status: Optional[SubjectAccessReviewStatus] = None
    """
    Status is filled in by the server and indicates whether the request is allowed or not
    """


class SelfSubjectRulesReview(Resource):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["SelfSubjectRulesReview"]:
            return SelfSubjectRulesReview

        def build(self) -> "SelfSubjectRulesReview":
            return SelfSubjectRulesReview(**self._attrs)

        def api_version(self, value: Optional[Literal["authorization.k8s.io/v1"]], /) -> Self:
            """
            APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
            """
            return self._set("api_version", value)

        def kind(self, value: Optional[Literal["SelfSubjectRulesReview"]], /) -> Self:
            """
            Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
            """
            return self._set("kind", value)

        @overload
        def metadata(
            self, value_or_callback: Optional[apimachinery.ObjectMeta], /
        ) -> "SelfSubjectRulesReview.Builder": ...

        @overload
        def metadata(
            self,
            value_or_callback: Callable[
                [apimachinery.ObjectMeta.Builder],
                apimachinery.ObjectMeta.Builder | apimachinery.ObjectMeta,
            ],
            /,
        ) -> "SelfSubjectRulesReview.Builder": ...

        @overload
        def metadata(
            self, value_or_callback: Never = ...
        ) -> "apimachinery.ObjectMeta.BuilderContext": ...

        def metadata(self, value_or_callback=None, /):
            """
            Standard list metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
            """
            if self._in_context and value_or_callback is None:
                context = apimachinery.ObjectMeta.BuilderContext()
                context._parent_builder = self
                context._field_name = "metadata"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(apimachinery.ObjectMeta.builder())
                if isinstance(output, apimachinery.ObjectMeta.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("metadata", value)

        @overload
        def spec(
            self, value_or_callback: SelfSubjectRulesReviewSpec, /
        ) -> "SelfSubjectRulesReview.Builder": ...

        @overload
        def spec(
            self,
            value_or_callback: Callable[
                [SelfSubjectRulesReviewSpec.Builder],
                SelfSubjectRulesReviewSpec.Builder | SelfSubjectRulesReviewSpec,
            ],
            /,
        ) -> "SelfSubjectRulesReview.Builder": ...

        @overload
        def spec(
            self, value_or_callback: Never = ...
        ) -> "SelfSubjectRulesReviewSpec.BuilderContext": ...

        def spec(self, value_or_callback=None, /):
            """
            Spec holds information about the request being evaluated.
            """
            if self._in_context and value_or_callback is None:
                context = SelfSubjectRulesReviewSpec.BuilderContext()
                context._parent_builder = self
                context._field_name = "spec"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(SelfSubjectRulesReviewSpec.builder())
                if isinstance(output, SelfSubjectRulesReviewSpec.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("spec", value)

        @overload
        def status(
            self, value_or_callback: Optional[SubjectRulesReviewStatus], /
        ) -> "SelfSubjectRulesReview.Builder": ...

        @overload
        def status(
            self,
            value_or_callback: Callable[
                [SubjectRulesReviewStatus.Builder],
                SubjectRulesReviewStatus.Builder | SubjectRulesReviewStatus,
            ],
            /,
        ) -> "SelfSubjectRulesReview.Builder": ...

        @overload
        def status(
            self, value_or_callback: Never = ...
        ) -> "SubjectRulesReviewStatus.BuilderContext": ...

        def status(self, value_or_callback=None, /):
            """
            Status is filled in by the server and indicates the set of actions a user can perform.
            """
            if self._in_context and value_or_callback is None:
                context = SubjectRulesReviewStatus.BuilderContext()
                context._parent_builder = self
                context._field_name = "status"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(SubjectRulesReviewStatus.builder())
                if isinstance(output, SubjectRulesReviewStatus.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("status", value)

    class BuilderContext(BuilderContextBase["SelfSubjectRulesReview.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = SelfSubjectRulesReview.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for SelfSubjectRulesReview."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["SelfSubjectRulesReview", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use SelfSubjectRulesReview.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    api_version: Annotated[
        Optional[Literal["authorization.k8s.io/v1"]], Field(alias="apiVersion")
    ] = "authorization.k8s.io/v1"
    """
    APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
    """
    kind: Optional[Literal["SelfSubjectRulesReview"]] = "SelfSubjectRulesReview"
    """
    Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
    """
    metadata: Optional[apimachinery.ObjectMeta] = None
    """
    Standard list metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
    """
    spec: SelfSubjectRulesReviewSpec
    """
    Spec holds information about the request being evaluated.
    """
    status: Optional[SubjectRulesReviewStatus] = None
    """
    Status is filled in by the server and indicates the set of actions a user can perform.
    """


class SubjectAccessReview(Resource):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["SubjectAccessReview"]:
            return SubjectAccessReview

        def build(self) -> "SubjectAccessReview":
            return SubjectAccessReview(**self._attrs)

        def api_version(self, value: Optional[Literal["authorization.k8s.io/v1"]], /) -> Self:
            """
            APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
            """
            return self._set("api_version", value)

        def kind(self, value: Optional[Literal["SubjectAccessReview"]], /) -> Self:
            """
            Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
            """
            return self._set("kind", value)

        @overload
        def metadata(
            self, value_or_callback: Optional[apimachinery.ObjectMeta], /
        ) -> "SubjectAccessReview.Builder": ...

        @overload
        def metadata(
            self,
            value_or_callback: Callable[
                [apimachinery.ObjectMeta.Builder],
                apimachinery.ObjectMeta.Builder | apimachinery.ObjectMeta,
            ],
            /,
        ) -> "SubjectAccessReview.Builder": ...

        @overload
        def metadata(
            self, value_or_callback: Never = ...
        ) -> "apimachinery.ObjectMeta.BuilderContext": ...

        def metadata(self, value_or_callback=None, /):
            """
            Standard list metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
            """
            if self._in_context and value_or_callback is None:
                context = apimachinery.ObjectMeta.BuilderContext()
                context._parent_builder = self
                context._field_name = "metadata"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(apimachinery.ObjectMeta.builder())
                if isinstance(output, apimachinery.ObjectMeta.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("metadata", value)

        @overload
        def spec(
            self, value_or_callback: SubjectAccessReviewSpec, /
        ) -> "SubjectAccessReview.Builder": ...

        @overload
        def spec(
            self,
            value_or_callback: Callable[
                [SubjectAccessReviewSpec.Builder],
                SubjectAccessReviewSpec.Builder | SubjectAccessReviewSpec,
            ],
            /,
        ) -> "SubjectAccessReview.Builder": ...

        @overload
        def spec(
            self, value_or_callback: Never = ...
        ) -> "SubjectAccessReviewSpec.BuilderContext": ...

        def spec(self, value_or_callback=None, /):
            """
            Spec holds information about the request being evaluated
            """
            if self._in_context and value_or_callback is None:
                context = SubjectAccessReviewSpec.BuilderContext()
                context._parent_builder = self
                context._field_name = "spec"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(SubjectAccessReviewSpec.builder())
                if isinstance(output, SubjectAccessReviewSpec.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("spec", value)

        @overload
        def status(
            self, value_or_callback: Optional[SubjectAccessReviewStatus], /
        ) -> "SubjectAccessReview.Builder": ...

        @overload
        def status(
            self,
            value_or_callback: Callable[
                [SubjectAccessReviewStatus.Builder],
                SubjectAccessReviewStatus.Builder | SubjectAccessReviewStatus,
            ],
            /,
        ) -> "SubjectAccessReview.Builder": ...

        @overload
        def status(
            self, value_or_callback: Never = ...
        ) -> "SubjectAccessReviewStatus.BuilderContext": ...

        def status(self, value_or_callback=None, /):
            """
            Status is filled in by the server and indicates whether the request is allowed or not
            """
            if self._in_context and value_or_callback is None:
                context = SubjectAccessReviewStatus.BuilderContext()
                context._parent_builder = self
                context._field_name = "status"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(SubjectAccessReviewStatus.builder())
                if isinstance(output, SubjectAccessReviewStatus.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("status", value)

    class BuilderContext(BuilderContextBase["SubjectAccessReview.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = SubjectAccessReview.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for SubjectAccessReview."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["SubjectAccessReview", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use SubjectAccessReview.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    api_version: Annotated[
        Optional[Literal["authorization.k8s.io/v1"]], Field(alias="apiVersion")
    ] = "authorization.k8s.io/v1"
    """
    APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
    """
    kind: Optional[Literal["SubjectAccessReview"]] = "SubjectAccessReview"
    """
    Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
    """
    metadata: Optional[apimachinery.ObjectMeta] = None
    """
    Standard list metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
    """
    spec: SubjectAccessReviewSpec
    """
    Spec holds information about the request being evaluated
    """
    status: Optional[SubjectAccessReviewStatus] = None
    """
    Status is filled in by the server and indicates whether the request is allowed or not
    """
