# Generated by cloudcoil-model-codegen v0.5.0
# DO NOT EDIT

from __future__ import annotations

from typing import (
    Annotated,
    Callable,
    Dict,
    List,
    Literal,
    Optional,
    Type,
    overload,
)

from pydantic import Field

from cloudcoil import apimachinery
from cloudcoil.pydantic import (
    BaseModel,
    BaseModelBuilder,
    BuilderContextBase,
    GenericListBuilder,
    Never,
    Self,
)
from cloudcoil.resources import Resource


class BoundObjectReference(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["BoundObjectReference"]:
            return BoundObjectReference

        def build(self) -> "BoundObjectReference":
            return BoundObjectReference(**self._attrs)

        def api_version(self, value: Optional[str], /) -> Self:
            """
            API version of the referent.
            """
            return self._set("api_version", value)

        def kind(self, value: Optional[str], /) -> Self:
            """
            Kind of the referent. Valid kinds are 'Pod' and 'Secret'.
            """
            return self._set("kind", value)

        def name(self, value: Optional[str], /) -> Self:
            """
            Name of the referent.
            """
            return self._set("name", value)

        def uid(self, value: Optional[str], /) -> Self:
            """
            UID of the referent.
            """
            return self._set("uid", value)

    class BuilderContext(BuilderContextBase["BoundObjectReference.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = BoundObjectReference.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for BoundObjectReference."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["BoundObjectReference", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use BoundObjectReference.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    api_version: Annotated[Optional[str], Field(alias="apiVersion")] = None
    """
    API version of the referent.
    """
    kind: Optional[str] = None
    """
    Kind of the referent. Valid kinds are 'Pod' and 'Secret'.
    """
    name: Optional[str] = None
    """
    Name of the referent.
    """
    uid: Optional[str] = None
    """
    UID of the referent.
    """


class TokenRequestSpec(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["TokenRequestSpec"]:
            return TokenRequestSpec

        def build(self) -> "TokenRequestSpec":
            return TokenRequestSpec(**self._attrs)

        def audiences(self, value: List[str], /) -> Self:
            """
            Audiences are the intendend audiences of the token. A recipient of a token must identify themself with an identifier in the list of audiences of the token, and otherwise should reject the token. A token issued for multiple audiences may be used to authenticate against any of the audiences listed but implies a high degree of trust between the target audiences.
            """
            return self._set("audiences", value)

        @overload
        def bound_object_ref(
            self, value_or_callback: Optional[BoundObjectReference], /
        ) -> "TokenRequestSpec.Builder": ...

        @overload
        def bound_object_ref(
            self,
            value_or_callback: Callable[
                [BoundObjectReference.Builder],
                BoundObjectReference.Builder | BoundObjectReference,
            ],
            /,
        ) -> "TokenRequestSpec.Builder": ...

        @overload
        def bound_object_ref(
            self, value_or_callback: Never = ...
        ) -> "BoundObjectReference.BuilderContext": ...

        def bound_object_ref(self, value_or_callback=None, /):
            """
            BoundObjectRef is a reference to an object that the token will be bound to. The token will only be valid for as long as the bound object exists. NOTE: The API server's TokenReview endpoint will validate the BoundObjectRef, but other audiences may not. Keep ExpirationSeconds small if you want prompt revocation.
            """
            if self._in_context and value_or_callback is None:
                context = BoundObjectReference.BuilderContext()
                context._parent_builder = self
                context._field_name = "bound_object_ref"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(BoundObjectReference.builder())
                if isinstance(output, BoundObjectReference.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("bound_object_ref", value)

        def expiration_seconds(self, value: Optional[int], /) -> Self:
            """
            ExpirationSeconds is the requested duration of validity of the request. The token issuer may return a token with a different validity duration so a client needs to check the 'expiration' field in a response.
            """
            return self._set("expiration_seconds", value)

    class BuilderContext(BuilderContextBase["TokenRequestSpec.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = TokenRequestSpec.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for TokenRequestSpec."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["TokenRequestSpec", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use TokenRequestSpec.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    audiences: List[str]
    """
    Audiences are the intendend audiences of the token. A recipient of a token must identify themself with an identifier in the list of audiences of the token, and otherwise should reject the token. A token issued for multiple audiences may be used to authenticate against any of the audiences listed but implies a high degree of trust between the target audiences.
    """
    bound_object_ref: Annotated[Optional[BoundObjectReference], Field(alias="boundObjectRef")] = (
        None
    )
    """
    BoundObjectRef is a reference to an object that the token will be bound to. The token will only be valid for as long as the bound object exists. NOTE: The API server's TokenReview endpoint will validate the BoundObjectRef, but other audiences may not. Keep ExpirationSeconds small if you want prompt revocation.
    """
    expiration_seconds: Annotated[Optional[int], Field(alias="expirationSeconds")] = None
    """
    ExpirationSeconds is the requested duration of validity of the request. The token issuer may return a token with a different validity duration so a client needs to check the 'expiration' field in a response.
    """


class TokenReviewSpec(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["TokenReviewSpec"]:
            return TokenReviewSpec

        def build(self) -> "TokenReviewSpec":
            return TokenReviewSpec(**self._attrs)

        def audiences(self, value: Optional[List[str]], /) -> Self:
            """
            Audiences is a list of the identifiers that the resource server presented with the token identifies as. Audience-aware token authenticators will verify that the token was intended for at least one of the audiences in this list. If no audiences are provided, the audience will default to the audience of the Kubernetes apiserver.
            """
            return self._set("audiences", value)

        def token(self, value: Optional[str], /) -> Self:
            """
            Token is the opaque bearer token.
            """
            return self._set("token", value)

    class BuilderContext(BuilderContextBase["TokenReviewSpec.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = TokenReviewSpec.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for TokenReviewSpec."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["TokenReviewSpec", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use TokenReviewSpec.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    audiences: Optional[List[str]] = None
    """
    Audiences is a list of the identifiers that the resource server presented with the token identifies as. Audience-aware token authenticators will verify that the token was intended for at least one of the audiences in this list. If no audiences are provided, the audience will default to the audience of the Kubernetes apiserver.
    """
    token: Optional[str] = None
    """
    Token is the opaque bearer token.
    """


class UserInfo(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["UserInfo"]:
            return UserInfo

        def build(self) -> "UserInfo":
            return UserInfo(**self._attrs)

        def extra(self, value: Optional[Dict[str, List[str]]], /) -> Self:
            """
            Any additional information provided by the authenticator.
            """
            return self._set("extra", value)

        def groups(self, value: Optional[List[str]], /) -> Self:
            """
            The names of groups this user is a part of.
            """
            return self._set("groups", value)

        def uid(self, value: Optional[str], /) -> Self:
            """
            A unique value that identifies this user across time. If this user is deleted and another user by the same name is added, they will have different UIDs.
            """
            return self._set("uid", value)

        def username(self, value: Optional[str], /) -> Self:
            """
            The name that uniquely identifies this user among all active users.
            """
            return self._set("username", value)

    class BuilderContext(BuilderContextBase["UserInfo.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = UserInfo.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for UserInfo."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["UserInfo", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use UserInfo.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    extra: Optional[Dict[str, List[str]]] = None
    """
    Any additional information provided by the authenticator.
    """
    groups: Optional[List[str]] = None
    """
    The names of groups this user is a part of.
    """
    uid: Optional[str] = None
    """
    A unique value that identifies this user across time. If this user is deleted and another user by the same name is added, they will have different UIDs.
    """
    username: Optional[str] = None
    """
    The name that uniquely identifies this user among all active users.
    """


class SelfSubjectReviewStatus(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["SelfSubjectReviewStatus"]:
            return SelfSubjectReviewStatus

        def build(self) -> "SelfSubjectReviewStatus":
            return SelfSubjectReviewStatus(**self._attrs)

        @overload
        def user_info(
            self, value_or_callback: Optional[UserInfo], /
        ) -> "SelfSubjectReviewStatus.Builder": ...

        @overload
        def user_info(
            self,
            value_or_callback: Callable[[UserInfo.Builder], UserInfo.Builder | UserInfo],
            /,
        ) -> "SelfSubjectReviewStatus.Builder": ...

        @overload
        def user_info(self, value_or_callback: Never = ...) -> "UserInfo.BuilderContext": ...

        def user_info(self, value_or_callback=None, /):
            """
            User attributes of the user making this request.
            """
            if self._in_context and value_or_callback is None:
                context = UserInfo.BuilderContext()
                context._parent_builder = self
                context._field_name = "user_info"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(UserInfo.builder())
                if isinstance(output, UserInfo.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("user_info", value)

    class BuilderContext(BuilderContextBase["SelfSubjectReviewStatus.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = SelfSubjectReviewStatus.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for SelfSubjectReviewStatus."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["SelfSubjectReviewStatus", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use SelfSubjectReviewStatus.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    user_info: Annotated[Optional[UserInfo], Field(alias="userInfo")] = None
    """
    User attributes of the user making this request.
    """


class TokenRequestStatus(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["TokenRequestStatus"]:
            return TokenRequestStatus

        def build(self) -> "TokenRequestStatus":
            return TokenRequestStatus(**self._attrs)

        @overload
        def expiration_timestamp(
            self, value_or_callback: apimachinery.Time, /
        ) -> "TokenRequestStatus.Builder": ...

        @overload
        def expiration_timestamp(
            self,
            value_or_callback: Callable[
                [apimachinery.Time.Builder],
                apimachinery.Time.Builder | apimachinery.Time,
            ],
            /,
        ) -> "TokenRequestStatus.Builder": ...

        @overload
        def expiration_timestamp(
            self, value_or_callback: Never = ...
        ) -> "apimachinery.Time.BuilderContext": ...

        def expiration_timestamp(self, value_or_callback=None, /):
            """
            ExpirationTimestamp is the time of expiration of the returned token.
            """
            if self._in_context and value_or_callback is None:
                context = apimachinery.Time.BuilderContext()
                context._parent_builder = self
                context._field_name = "expiration_timestamp"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(apimachinery.Time.builder())
                if isinstance(output, apimachinery.Time.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("expiration_timestamp", value)

        def token(self, value: str, /) -> Self:
            """
            Token is the opaque bearer token.
            """
            return self._set("token", value)

    class BuilderContext(BuilderContextBase["TokenRequestStatus.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = TokenRequestStatus.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for TokenRequestStatus."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["TokenRequestStatus", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use TokenRequestStatus.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    expiration_timestamp: Annotated[apimachinery.Time, Field(alias="expirationTimestamp")]
    """
    ExpirationTimestamp is the time of expiration of the returned token.
    """
    token: str
    """
    Token is the opaque bearer token.
    """


class TokenReviewStatus(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["TokenReviewStatus"]:
            return TokenReviewStatus

        def build(self) -> "TokenReviewStatus":
            return TokenReviewStatus(**self._attrs)

        def audiences(self, value: Optional[List[str]], /) -> Self:
            """
            Audiences are audience identifiers chosen by the authenticator that are compatible with both the TokenReview and token. An identifier is any identifier in the intersection of the TokenReviewSpec audiences and the token's audiences. A client of the TokenReview API that sets the spec.audiences field should validate that a compatible audience identifier is returned in the status.audiences field to ensure that the TokenReview server is audience aware. If a TokenReview returns an empty status.audience field where status.authenticated is "true", the token is valid against the audience of the Kubernetes API server.
            """
            return self._set("audiences", value)

        def authenticated(self, value: Optional[bool], /) -> Self:
            """
            Authenticated indicates that the token was associated with a known user.
            """
            return self._set("authenticated", value)

        def error(self, value: Optional[str], /) -> Self:
            """
            Error indicates that the token couldn't be checked
            """
            return self._set("error", value)

        @overload
        def user(self, value_or_callback: Optional[UserInfo], /) -> "TokenReviewStatus.Builder": ...

        @overload
        def user(
            self,
            value_or_callback: Callable[[UserInfo.Builder], UserInfo.Builder | UserInfo],
            /,
        ) -> "TokenReviewStatus.Builder": ...

        @overload
        def user(self, value_or_callback: Never = ...) -> "UserInfo.BuilderContext": ...

        def user(self, value_or_callback=None, /):
            """
            User is the UserInfo associated with the provided token.
            """
            if self._in_context and value_or_callback is None:
                context = UserInfo.BuilderContext()
                context._parent_builder = self
                context._field_name = "user"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(UserInfo.builder())
                if isinstance(output, UserInfo.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("user", value)

    class BuilderContext(BuilderContextBase["TokenReviewStatus.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = TokenReviewStatus.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for TokenReviewStatus."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["TokenReviewStatus", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use TokenReviewStatus.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    audiences: Optional[List[str]] = None
    """
    Audiences are audience identifiers chosen by the authenticator that are compatible with both the TokenReview and token. An identifier is any identifier in the intersection of the TokenReviewSpec audiences and the token's audiences. A client of the TokenReview API that sets the spec.audiences field should validate that a compatible audience identifier is returned in the status.audiences field to ensure that the TokenReview server is audience aware. If a TokenReview returns an empty status.audience field where status.authenticated is "true", the token is valid against the audience of the Kubernetes API server.
    """
    authenticated: Optional[bool] = None
    """
    Authenticated indicates that the token was associated with a known user.
    """
    error: Optional[str] = None
    """
    Error indicates that the token couldn't be checked
    """
    user: Optional[UserInfo] = None
    """
    User is the UserInfo associated with the provided token.
    """


class SelfSubjectReview(Resource):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["SelfSubjectReview"]:
            return SelfSubjectReview

        def build(self) -> "SelfSubjectReview":
            return SelfSubjectReview(**self._attrs)

        def api_version(self, value: Optional[Literal["authentication.k8s.io/v1"]], /) -> Self:
            """
            APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
            """
            return self._set("api_version", value)

        def kind(self, value: Optional[Literal["SelfSubjectReview"]], /) -> Self:
            """
            Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
            """
            return self._set("kind", value)

        @overload
        def metadata(
            self, value_or_callback: Optional[apimachinery.ObjectMeta], /
        ) -> "SelfSubjectReview.Builder": ...

        @overload
        def metadata(
            self,
            value_or_callback: Callable[
                [apimachinery.ObjectMeta.Builder],
                apimachinery.ObjectMeta.Builder | apimachinery.ObjectMeta,
            ],
            /,
        ) -> "SelfSubjectReview.Builder": ...

        @overload
        def metadata(
            self, value_or_callback: Never = ...
        ) -> "apimachinery.ObjectMeta.BuilderContext": ...

        def metadata(self, value_or_callback=None, /):
            """
            Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
            """
            if self._in_context and value_or_callback is None:
                context = apimachinery.ObjectMeta.BuilderContext()
                context._parent_builder = self
                context._field_name = "metadata"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(apimachinery.ObjectMeta.builder())
                if isinstance(output, apimachinery.ObjectMeta.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("metadata", value)

        @overload
        def status(
            self, value_or_callback: Optional[SelfSubjectReviewStatus], /
        ) -> "SelfSubjectReview.Builder": ...

        @overload
        def status(
            self,
            value_or_callback: Callable[
                [SelfSubjectReviewStatus.Builder],
                SelfSubjectReviewStatus.Builder | SelfSubjectReviewStatus,
            ],
            /,
        ) -> "SelfSubjectReview.Builder": ...

        @overload
        def status(
            self, value_or_callback: Never = ...
        ) -> "SelfSubjectReviewStatus.BuilderContext": ...

        def status(self, value_or_callback=None, /):
            """
            Status is filled in by the server with the user attributes.
            """
            if self._in_context and value_or_callback is None:
                context = SelfSubjectReviewStatus.BuilderContext()
                context._parent_builder = self
                context._field_name = "status"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(SelfSubjectReviewStatus.builder())
                if isinstance(output, SelfSubjectReviewStatus.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("status", value)

    class BuilderContext(BuilderContextBase["SelfSubjectReview.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = SelfSubjectReview.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for SelfSubjectReview."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["SelfSubjectReview", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use SelfSubjectReview.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    api_version: Annotated[
        Optional[Literal["authentication.k8s.io/v1"]], Field(alias="apiVersion")
    ] = "authentication.k8s.io/v1"
    """
    APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
    """
    kind: Optional[Literal["SelfSubjectReview"]] = "SelfSubjectReview"
    """
    Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
    """
    metadata: Optional[apimachinery.ObjectMeta] = None
    """
    Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
    """
    status: Optional[SelfSubjectReviewStatus] = None
    """
    Status is filled in by the server with the user attributes.
    """


class TokenRequest(Resource):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["TokenRequest"]:
            return TokenRequest

        def build(self) -> "TokenRequest":
            return TokenRequest(**self._attrs)

        def api_version(self, value: Optional[Literal["authentication.k8s.io/v1"]], /) -> Self:
            """
            APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
            """
            return self._set("api_version", value)

        def kind(self, value: Optional[Literal["TokenRequest"]], /) -> Self:
            """
            Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
            """
            return self._set("kind", value)

        @overload
        def metadata(
            self, value_or_callback: Optional[apimachinery.ObjectMeta], /
        ) -> "TokenRequest.Builder": ...

        @overload
        def metadata(
            self,
            value_or_callback: Callable[
                [apimachinery.ObjectMeta.Builder],
                apimachinery.ObjectMeta.Builder | apimachinery.ObjectMeta,
            ],
            /,
        ) -> "TokenRequest.Builder": ...

        @overload
        def metadata(
            self, value_or_callback: Never = ...
        ) -> "apimachinery.ObjectMeta.BuilderContext": ...

        def metadata(self, value_or_callback=None, /):
            """
            Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
            """
            if self._in_context and value_or_callback is None:
                context = apimachinery.ObjectMeta.BuilderContext()
                context._parent_builder = self
                context._field_name = "metadata"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(apimachinery.ObjectMeta.builder())
                if isinstance(output, apimachinery.ObjectMeta.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("metadata", value)

        @overload
        def spec(self, value_or_callback: TokenRequestSpec, /) -> "TokenRequest.Builder": ...

        @overload
        def spec(
            self,
            value_or_callback: Callable[
                [TokenRequestSpec.Builder], TokenRequestSpec.Builder | TokenRequestSpec
            ],
            /,
        ) -> "TokenRequest.Builder": ...

        @overload
        def spec(self, value_or_callback: Never = ...) -> "TokenRequestSpec.BuilderContext": ...

        def spec(self, value_or_callback=None, /):
            """
            Spec holds information about the request being evaluated
            """
            if self._in_context and value_or_callback is None:
                context = TokenRequestSpec.BuilderContext()
                context._parent_builder = self
                context._field_name = "spec"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(TokenRequestSpec.builder())
                if isinstance(output, TokenRequestSpec.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("spec", value)

        @overload
        def status(
            self, value_or_callback: Optional[TokenRequestStatus], /
        ) -> "TokenRequest.Builder": ...

        @overload
        def status(
            self,
            value_or_callback: Callable[
                [TokenRequestStatus.Builder],
                TokenRequestStatus.Builder | TokenRequestStatus,
            ],
            /,
        ) -> "TokenRequest.Builder": ...

        @overload
        def status(self, value_or_callback: Never = ...) -> "TokenRequestStatus.BuilderContext": ...

        def status(self, value_or_callback=None, /):
            """
            Status is filled in by the server and indicates whether the token can be authenticated.
            """
            if self._in_context and value_or_callback is None:
                context = TokenRequestStatus.BuilderContext()
                context._parent_builder = self
                context._field_name = "status"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(TokenRequestStatus.builder())
                if isinstance(output, TokenRequestStatus.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("status", value)

    class BuilderContext(BuilderContextBase["TokenRequest.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = TokenRequest.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for TokenRequest."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["TokenRequest", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use TokenRequest.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    api_version: Annotated[
        Optional[Literal["authentication.k8s.io/v1"]], Field(alias="apiVersion")
    ] = "authentication.k8s.io/v1"
    """
    APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
    """
    kind: Optional[Literal["TokenRequest"]] = "TokenRequest"
    """
    Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
    """
    metadata: Optional[apimachinery.ObjectMeta] = None
    """
    Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
    """
    spec: TokenRequestSpec
    """
    Spec holds information about the request being evaluated
    """
    status: Optional[TokenRequestStatus] = None
    """
    Status is filled in by the server and indicates whether the token can be authenticated.
    """


class TokenReview(Resource):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["TokenReview"]:
            return TokenReview

        def build(self) -> "TokenReview":
            return TokenReview(**self._attrs)

        def api_version(self, value: Optional[Literal["authentication.k8s.io/v1"]], /) -> Self:
            """
            APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
            """
            return self._set("api_version", value)

        def kind(self, value: Optional[Literal["TokenReview"]], /) -> Self:
            """
            Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
            """
            return self._set("kind", value)

        @overload
        def metadata(
            self, value_or_callback: Optional[apimachinery.ObjectMeta], /
        ) -> "TokenReview.Builder": ...

        @overload
        def metadata(
            self,
            value_or_callback: Callable[
                [apimachinery.ObjectMeta.Builder],
                apimachinery.ObjectMeta.Builder | apimachinery.ObjectMeta,
            ],
            /,
        ) -> "TokenReview.Builder": ...

        @overload
        def metadata(
            self, value_or_callback: Never = ...
        ) -> "apimachinery.ObjectMeta.BuilderContext": ...

        def metadata(self, value_or_callback=None, /):
            """
            Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
            """
            if self._in_context and value_or_callback is None:
                context = apimachinery.ObjectMeta.BuilderContext()
                context._parent_builder = self
                context._field_name = "metadata"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(apimachinery.ObjectMeta.builder())
                if isinstance(output, apimachinery.ObjectMeta.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("metadata", value)

        @overload
        def spec(self, value_or_callback: TokenReviewSpec, /) -> "TokenReview.Builder": ...

        @overload
        def spec(
            self,
            value_or_callback: Callable[
                [TokenReviewSpec.Builder], TokenReviewSpec.Builder | TokenReviewSpec
            ],
            /,
        ) -> "TokenReview.Builder": ...

        @overload
        def spec(self, value_or_callback: Never = ...) -> "TokenReviewSpec.BuilderContext": ...

        def spec(self, value_or_callback=None, /):
            """
            Spec holds information about the request being evaluated
            """
            if self._in_context and value_or_callback is None:
                context = TokenReviewSpec.BuilderContext()
                context._parent_builder = self
                context._field_name = "spec"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(TokenReviewSpec.builder())
                if isinstance(output, TokenReviewSpec.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("spec", value)

        @overload
        def status(
            self, value_or_callback: Optional[TokenReviewStatus], /
        ) -> "TokenReview.Builder": ...

        @overload
        def status(
            self,
            value_or_callback: Callable[
                [TokenReviewStatus.Builder],
                TokenReviewStatus.Builder | TokenReviewStatus,
            ],
            /,
        ) -> "TokenReview.Builder": ...

        @overload
        def status(self, value_or_callback: Never = ...) -> "TokenReviewStatus.BuilderContext": ...

        def status(self, value_or_callback=None, /):
            """
            Status is filled in by the server and indicates whether the request can be authenticated.
            """
            if self._in_context and value_or_callback is None:
                context = TokenReviewStatus.BuilderContext()
                context._parent_builder = self
                context._field_name = "status"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(TokenReviewStatus.builder())
                if isinstance(output, TokenReviewStatus.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("status", value)

    class BuilderContext(BuilderContextBase["TokenReview.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = TokenReview.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for TokenReview."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["TokenReview", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use TokenReview.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    api_version: Annotated[
        Optional[Literal["authentication.k8s.io/v1"]], Field(alias="apiVersion")
    ] = "authentication.k8s.io/v1"
    """
    APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
    """
    kind: Optional[Literal["TokenReview"]] = "TokenReview"
    """
    Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
    """
    metadata: Optional[apimachinery.ObjectMeta] = None
    """
    Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
    """
    spec: TokenReviewSpec
    """
    Spec holds information about the request being evaluated
    """
    status: Optional[TokenReviewStatus] = None
    """
    Status is filled in by the server and indicates whether the request can be authenticated.
    """
