# Generated by cloudcoil-model-codegen v0.5.0
# DO NOT EDIT

from __future__ import annotations

from typing import (
    Annotated,
    Callable,
    List,
    Literal,
    Optional,
    Type,
    overload,
)

from pydantic import Field

from cloudcoil import apimachinery
from cloudcoil.pydantic import (
    BaseModel,
    BaseModelBuilder,
    BuilderContextBase,
    GenericListBuilder,
    ListBuilderContext,
    Never,
    Self,
)
from cloudcoil.resources import Resource, ResourceList

from ..core import v1


class StatefulSetOrdinals(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["StatefulSetOrdinals"]:
            return StatefulSetOrdinals

        def build(self) -> "StatefulSetOrdinals":
            return StatefulSetOrdinals(**self._attrs)

        def start(self, value: Optional[int], /) -> Self:
            """
            start is the number representing the first replica's index. It may be used to number replicas from an alternate index (eg: 1-indexed) over the default 0-indexed names, or to orchestrate progressive movement of replicas from one StatefulSet to another. If set, replica indices will be in the range:
              [.spec.ordinals.start, .spec.ordinals.start + .spec.replicas).
            If unset, defaults to 0. Replica indices will be in the range:
              [0, .spec.replicas).
            """
            return self._set("start", value)

    class BuilderContext(BuilderContextBase["StatefulSetOrdinals.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = StatefulSetOrdinals.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for StatefulSetOrdinals."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["StatefulSetOrdinals", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use StatefulSetOrdinals.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    start: Optional[int] = None
    """
    start is the number representing the first replica's index. It may be used to number replicas from an alternate index (eg: 1-indexed) over the default 0-indexed names, or to orchestrate progressive movement of replicas from one StatefulSet to another. If set, replica indices will be in the range:
      [.spec.ordinals.start, .spec.ordinals.start + .spec.replicas).
    If unset, defaults to 0. Replica indices will be in the range:
      [0, .spec.replicas).
    """


class StatefulSetPersistentVolumeClaimRetentionPolicy(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["StatefulSetPersistentVolumeClaimRetentionPolicy"]:
            return StatefulSetPersistentVolumeClaimRetentionPolicy

        def build(self) -> "StatefulSetPersistentVolumeClaimRetentionPolicy":
            return StatefulSetPersistentVolumeClaimRetentionPolicy(**self._attrs)

        def when_deleted(self, value: Optional[str], /) -> Self:
            """
            WhenDeleted specifies what happens to PVCs created from StatefulSet VolumeClaimTemplates when the StatefulSet is deleted. The default policy of `Retain` causes PVCs to not be affected by StatefulSet deletion. The `Delete` policy causes those PVCs to be deleted.
            """
            return self._set("when_deleted", value)

        def when_scaled(self, value: Optional[str], /) -> Self:
            """
            WhenScaled specifies what happens to PVCs created from StatefulSet VolumeClaimTemplates when the StatefulSet is scaled down. The default policy of `Retain` causes PVCs to not be affected by a scaledown. The `Delete` policy causes the associated PVCs for any excess pods above the replica count to be deleted.
            """
            return self._set("when_scaled", value)

    class BuilderContext(
        BuilderContextBase["StatefulSetPersistentVolumeClaimRetentionPolicy.Builder"]
    ):
        def model_post_init(self, __context) -> None:
            self._builder = StatefulSetPersistentVolumeClaimRetentionPolicy.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for StatefulSetPersistentVolumeClaimRetentionPolicy."""
        return cls.BuilderContext()

    class ListBuilder(
        GenericListBuilder["StatefulSetPersistentVolumeClaimRetentionPolicy", Builder]
    ):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use StatefulSetPersistentVolumeClaimRetentionPolicy.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    when_deleted: Annotated[Optional[str], Field(alias="whenDeleted")] = None
    """
    WhenDeleted specifies what happens to PVCs created from StatefulSet VolumeClaimTemplates when the StatefulSet is deleted. The default policy of `Retain` causes PVCs to not be affected by StatefulSet deletion. The `Delete` policy causes those PVCs to be deleted.
    """
    when_scaled: Annotated[Optional[str], Field(alias="whenScaled")] = None
    """
    WhenScaled specifies what happens to PVCs created from StatefulSet VolumeClaimTemplates when the StatefulSet is scaled down. The default policy of `Retain` causes PVCs to not be affected by a scaledown. The `Delete` policy causes the associated PVCs for any excess pods above the replica count to be deleted.
    """


class DaemonSetCondition(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["DaemonSetCondition"]:
            return DaemonSetCondition

        def build(self) -> "DaemonSetCondition":
            return DaemonSetCondition(**self._attrs)

        @overload
        def last_transition_time(
            self, value_or_callback: Optional[apimachinery.Time], /
        ) -> "DaemonSetCondition.Builder": ...

        @overload
        def last_transition_time(
            self,
            value_or_callback: Callable[
                [apimachinery.Time.Builder],
                apimachinery.Time.Builder | apimachinery.Time,
            ],
            /,
        ) -> "DaemonSetCondition.Builder": ...

        @overload
        def last_transition_time(
            self, value_or_callback: Never = ...
        ) -> "apimachinery.Time.BuilderContext": ...

        def last_transition_time(self, value_or_callback=None, /):
            """
            Last time the condition transitioned from one status to another.
            """
            if self._in_context and value_or_callback is None:
                context = apimachinery.Time.BuilderContext()
                context._parent_builder = self
                context._field_name = "last_transition_time"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(apimachinery.Time.builder())
                if isinstance(output, apimachinery.Time.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("last_transition_time", value)

        def message(self, value: Optional[str], /) -> Self:
            """
            A human readable message indicating details about the transition.
            """
            return self._set("message", value)

        def reason(self, value: Optional[str], /) -> Self:
            """
            The reason for the condition's last transition.
            """
            return self._set("reason", value)

        def status(self, value: str, /) -> Self:
            """
            Status of the condition, one of True, False, Unknown.
            """
            return self._set("status", value)

        def type(self, value: str, /) -> Self:
            """
            Type of DaemonSet condition.
            """
            return self._set("type", value)

    class BuilderContext(BuilderContextBase["DaemonSetCondition.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = DaemonSetCondition.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for DaemonSetCondition."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["DaemonSetCondition", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use DaemonSetCondition.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    last_transition_time: Annotated[
        Optional[apimachinery.Time], Field(alias="lastTransitionTime")
    ] = None
    """
    Last time the condition transitioned from one status to another.
    """
    message: Optional[str] = None
    """
    A human readable message indicating details about the transition.
    """
    reason: Optional[str] = None
    """
    The reason for the condition's last transition.
    """
    status: str
    """
    Status of the condition, one of True, False, Unknown.
    """
    type: str
    """
    Type of DaemonSet condition.
    """


class DaemonSetStatus(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["DaemonSetStatus"]:
            return DaemonSetStatus

        def build(self) -> "DaemonSetStatus":
            return DaemonSetStatus(**self._attrs)

        def collision_count(self, value: Optional[int], /) -> Self:
            """
            Count of hash collisions for the DaemonSet. The DaemonSet controller uses this field as a collision avoidance mechanism when it needs to create the name for the newest ControllerRevision.
            """
            return self._set("collision_count", value)

        @overload
        def conditions(
            self, value_or_callback: List[DaemonSetCondition], /
        ) -> "DaemonSetStatus.Builder": ...

        @overload
        def conditions(
            self,
            value_or_callback: Callable[
                [GenericListBuilder[DaemonSetCondition, DaemonSetCondition.Builder]],
                GenericListBuilder[DaemonSetCondition, DaemonSetCondition.Builder]
                | List[DaemonSetCondition],
            ],
            /,
        ) -> "DaemonSetStatus.Builder": ...

        @overload
        def conditions(
            self, value_or_callback: Never = ...
        ) -> ListBuilderContext[DaemonSetCondition.Builder]: ...

        def conditions(self, value_or_callback=None, /):
            """
            Represents the latest available observations of a DaemonSet's current state.
            """
            if self._in_context and value_or_callback is None:
                context = ListBuilderContext[DaemonSetCondition.Builder]()
                context._parent_builder = self
                context._field_name = "conditions"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(DaemonSetCondition.list_builder())
                if isinstance(output, GenericListBuilder):
                    value = output.build()
                else:
                    value = output
            return self._set("conditions", value)

        def current_number_scheduled(self, value: int, /) -> Self:
            """
            The number of nodes that are running at least 1 daemon pod and are supposed to run the daemon pod. More info: https://kubernetes.io/docs/concepts/workloads/controllers/daemonset/
            """
            return self._set("current_number_scheduled", value)

        def desired_number_scheduled(self, value: int, /) -> Self:
            """
            The total number of nodes that should be running the daemon pod (including nodes correctly running the daemon pod). More info: https://kubernetes.io/docs/concepts/workloads/controllers/daemonset/
            """
            return self._set("desired_number_scheduled", value)

        def number_available(self, value: Optional[int], /) -> Self:
            """
            The number of nodes that should be running the daemon pod and have one or more of the daemon pod running and available (ready for at least spec.minReadySeconds)
            """
            return self._set("number_available", value)

        def number_misscheduled(self, value: int, /) -> Self:
            """
            The number of nodes that are running the daemon pod, but are not supposed to run the daemon pod. More info: https://kubernetes.io/docs/concepts/workloads/controllers/daemonset/
            """
            return self._set("number_misscheduled", value)

        def number_ready(self, value: int, /) -> Self:
            """
            numberReady is the number of nodes that should be running the daemon pod and have one or more of the daemon pod running with a Ready Condition.
            """
            return self._set("number_ready", value)

        def number_unavailable(self, value: Optional[int], /) -> Self:
            """
            The number of nodes that should be running the daemon pod and have none of the daemon pod running and available (ready for at least spec.minReadySeconds)
            """
            return self._set("number_unavailable", value)

        def observed_generation(self, value: Optional[int], /) -> Self:
            """
            The most recent generation observed by the daemon set controller.
            """
            return self._set("observed_generation", value)

        def updated_number_scheduled(self, value: Optional[int], /) -> Self:
            """
            The total number of nodes that are running updated daemon pod
            """
            return self._set("updated_number_scheduled", value)

    class BuilderContext(BuilderContextBase["DaemonSetStatus.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = DaemonSetStatus.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for DaemonSetStatus."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["DaemonSetStatus", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use DaemonSetStatus.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    collision_count: Annotated[Optional[int], Field(alias="collisionCount")] = None
    """
    Count of hash collisions for the DaemonSet. The DaemonSet controller uses this field as a collision avoidance mechanism when it needs to create the name for the newest ControllerRevision.
    """
    conditions: Optional[List[DaemonSetCondition]] = None
    """
    Represents the latest available observations of a DaemonSet's current state.
    """
    current_number_scheduled: Annotated[int, Field(alias="currentNumberScheduled")]
    """
    The number of nodes that are running at least 1 daemon pod and are supposed to run the daemon pod. More info: https://kubernetes.io/docs/concepts/workloads/controllers/daemonset/
    """
    desired_number_scheduled: Annotated[int, Field(alias="desiredNumberScheduled")]
    """
    The total number of nodes that should be running the daemon pod (including nodes correctly running the daemon pod). More info: https://kubernetes.io/docs/concepts/workloads/controllers/daemonset/
    """
    number_available: Annotated[Optional[int], Field(alias="numberAvailable")] = None
    """
    The number of nodes that should be running the daemon pod and have one or more of the daemon pod running and available (ready for at least spec.minReadySeconds)
    """
    number_misscheduled: Annotated[int, Field(alias="numberMisscheduled")]
    """
    The number of nodes that are running the daemon pod, but are not supposed to run the daemon pod. More info: https://kubernetes.io/docs/concepts/workloads/controllers/daemonset/
    """
    number_ready: Annotated[int, Field(alias="numberReady")]
    """
    numberReady is the number of nodes that should be running the daemon pod and have one or more of the daemon pod running with a Ready Condition.
    """
    number_unavailable: Annotated[Optional[int], Field(alias="numberUnavailable")] = None
    """
    The number of nodes that should be running the daemon pod and have none of the daemon pod running and available (ready for at least spec.minReadySeconds)
    """
    observed_generation: Annotated[Optional[int], Field(alias="observedGeneration")] = None
    """
    The most recent generation observed by the daemon set controller.
    """
    updated_number_scheduled: Annotated[Optional[int], Field(alias="updatedNumberScheduled")] = None
    """
    The total number of nodes that are running updated daemon pod
    """


class DeploymentCondition(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["DeploymentCondition"]:
            return DeploymentCondition

        def build(self) -> "DeploymentCondition":
            return DeploymentCondition(**self._attrs)

        @overload
        def last_transition_time(
            self, value_or_callback: Optional[apimachinery.Time], /
        ) -> "DeploymentCondition.Builder": ...

        @overload
        def last_transition_time(
            self,
            value_or_callback: Callable[
                [apimachinery.Time.Builder],
                apimachinery.Time.Builder | apimachinery.Time,
            ],
            /,
        ) -> "DeploymentCondition.Builder": ...

        @overload
        def last_transition_time(
            self, value_or_callback: Never = ...
        ) -> "apimachinery.Time.BuilderContext": ...

        def last_transition_time(self, value_or_callback=None, /):
            """
            Last time the condition transitioned from one status to another.
            """
            if self._in_context and value_or_callback is None:
                context = apimachinery.Time.BuilderContext()
                context._parent_builder = self
                context._field_name = "last_transition_time"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(apimachinery.Time.builder())
                if isinstance(output, apimachinery.Time.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("last_transition_time", value)

        @overload
        def last_update_time(
            self, value_or_callback: Optional[apimachinery.Time], /
        ) -> "DeploymentCondition.Builder": ...

        @overload
        def last_update_time(
            self,
            value_or_callback: Callable[
                [apimachinery.Time.Builder],
                apimachinery.Time.Builder | apimachinery.Time,
            ],
            /,
        ) -> "DeploymentCondition.Builder": ...

        @overload
        def last_update_time(
            self, value_or_callback: Never = ...
        ) -> "apimachinery.Time.BuilderContext": ...

        def last_update_time(self, value_or_callback=None, /):
            """
            The last time this condition was updated.
            """
            if self._in_context and value_or_callback is None:
                context = apimachinery.Time.BuilderContext()
                context._parent_builder = self
                context._field_name = "last_update_time"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(apimachinery.Time.builder())
                if isinstance(output, apimachinery.Time.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("last_update_time", value)

        def message(self, value: Optional[str], /) -> Self:
            """
            A human readable message indicating details about the transition.
            """
            return self._set("message", value)

        def reason(self, value: Optional[str], /) -> Self:
            """
            The reason for the condition's last transition.
            """
            return self._set("reason", value)

        def status(self, value: str, /) -> Self:
            """
            Status of the condition, one of True, False, Unknown.
            """
            return self._set("status", value)

        def type(self, value: str, /) -> Self:
            """
            Type of deployment condition.
            """
            return self._set("type", value)

    class BuilderContext(BuilderContextBase["DeploymentCondition.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = DeploymentCondition.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for DeploymentCondition."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["DeploymentCondition", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use DeploymentCondition.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    last_transition_time: Annotated[
        Optional[apimachinery.Time], Field(alias="lastTransitionTime")
    ] = None
    """
    Last time the condition transitioned from one status to another.
    """
    last_update_time: Annotated[Optional[apimachinery.Time], Field(alias="lastUpdateTime")] = None
    """
    The last time this condition was updated.
    """
    message: Optional[str] = None
    """
    A human readable message indicating details about the transition.
    """
    reason: Optional[str] = None
    """
    The reason for the condition's last transition.
    """
    status: str
    """
    Status of the condition, one of True, False, Unknown.
    """
    type: str
    """
    Type of deployment condition.
    """


class DeploymentStatus(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["DeploymentStatus"]:
            return DeploymentStatus

        def build(self) -> "DeploymentStatus":
            return DeploymentStatus(**self._attrs)

        def available_replicas(self, value: Optional[int], /) -> Self:
            """
            Total number of available pods (ready for at least minReadySeconds) targeted by this deployment.
            """
            return self._set("available_replicas", value)

        def collision_count(self, value: Optional[int], /) -> Self:
            """
            Count of hash collisions for the Deployment. The Deployment controller uses this field as a collision avoidance mechanism when it needs to create the name for the newest ReplicaSet.
            """
            return self._set("collision_count", value)

        @overload
        def conditions(
            self, value_or_callback: List[DeploymentCondition], /
        ) -> "DeploymentStatus.Builder": ...

        @overload
        def conditions(
            self,
            value_or_callback: Callable[
                [GenericListBuilder[DeploymentCondition, DeploymentCondition.Builder]],
                GenericListBuilder[DeploymentCondition, DeploymentCondition.Builder]
                | List[DeploymentCondition],
            ],
            /,
        ) -> "DeploymentStatus.Builder": ...

        @overload
        def conditions(
            self, value_or_callback: Never = ...
        ) -> ListBuilderContext[DeploymentCondition.Builder]: ...

        def conditions(self, value_or_callback=None, /):
            """
            Represents the latest available observations of a deployment's current state.
            """
            if self._in_context and value_or_callback is None:
                context = ListBuilderContext[DeploymentCondition.Builder]()
                context._parent_builder = self
                context._field_name = "conditions"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(DeploymentCondition.list_builder())
                if isinstance(output, GenericListBuilder):
                    value = output.build()
                else:
                    value = output
            return self._set("conditions", value)

        def observed_generation(self, value: Optional[int], /) -> Self:
            """
            The generation observed by the deployment controller.
            """
            return self._set("observed_generation", value)

        def ready_replicas(self, value: Optional[int], /) -> Self:
            """
            readyReplicas is the number of pods targeted by this Deployment with a Ready Condition.
            """
            return self._set("ready_replicas", value)

        def replicas(self, value: Optional[int], /) -> Self:
            """
            Total number of non-terminated pods targeted by this deployment (their labels match the selector).
            """
            return self._set("replicas", value)

        def unavailable_replicas(self, value: Optional[int], /) -> Self:
            """
            Total number of unavailable pods targeted by this deployment. This is the total number of pods that are still required for the deployment to have 100% available capacity. They may either be pods that are running but not yet available or pods that still have not been created.
            """
            return self._set("unavailable_replicas", value)

        def updated_replicas(self, value: Optional[int], /) -> Self:
            """
            Total number of non-terminated pods targeted by this deployment that have the desired template spec.
            """
            return self._set("updated_replicas", value)

    class BuilderContext(BuilderContextBase["DeploymentStatus.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = DeploymentStatus.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for DeploymentStatus."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["DeploymentStatus", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use DeploymentStatus.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    available_replicas: Annotated[Optional[int], Field(alias="availableReplicas")] = None
    """
    Total number of available pods (ready for at least minReadySeconds) targeted by this deployment.
    """
    collision_count: Annotated[Optional[int], Field(alias="collisionCount")] = None
    """
    Count of hash collisions for the Deployment. The Deployment controller uses this field as a collision avoidance mechanism when it needs to create the name for the newest ReplicaSet.
    """
    conditions: Optional[List[DeploymentCondition]] = None
    """
    Represents the latest available observations of a deployment's current state.
    """
    observed_generation: Annotated[Optional[int], Field(alias="observedGeneration")] = None
    """
    The generation observed by the deployment controller.
    """
    ready_replicas: Annotated[Optional[int], Field(alias="readyReplicas")] = None
    """
    readyReplicas is the number of pods targeted by this Deployment with a Ready Condition.
    """
    replicas: Optional[int] = None
    """
    Total number of non-terminated pods targeted by this deployment (their labels match the selector).
    """
    unavailable_replicas: Annotated[Optional[int], Field(alias="unavailableReplicas")] = None
    """
    Total number of unavailable pods targeted by this deployment. This is the total number of pods that are still required for the deployment to have 100% available capacity. They may either be pods that are running but not yet available or pods that still have not been created.
    """
    updated_replicas: Annotated[Optional[int], Field(alias="updatedReplicas")] = None
    """
    Total number of non-terminated pods targeted by this deployment that have the desired template spec.
    """


class ReplicaSetCondition(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["ReplicaSetCondition"]:
            return ReplicaSetCondition

        def build(self) -> "ReplicaSetCondition":
            return ReplicaSetCondition(**self._attrs)

        @overload
        def last_transition_time(
            self, value_or_callback: Optional[apimachinery.Time], /
        ) -> "ReplicaSetCondition.Builder": ...

        @overload
        def last_transition_time(
            self,
            value_or_callback: Callable[
                [apimachinery.Time.Builder],
                apimachinery.Time.Builder | apimachinery.Time,
            ],
            /,
        ) -> "ReplicaSetCondition.Builder": ...

        @overload
        def last_transition_time(
            self, value_or_callback: Never = ...
        ) -> "apimachinery.Time.BuilderContext": ...

        def last_transition_time(self, value_or_callback=None, /):
            """
            The last time the condition transitioned from one status to another.
            """
            if self._in_context and value_or_callback is None:
                context = apimachinery.Time.BuilderContext()
                context._parent_builder = self
                context._field_name = "last_transition_time"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(apimachinery.Time.builder())
                if isinstance(output, apimachinery.Time.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("last_transition_time", value)

        def message(self, value: Optional[str], /) -> Self:
            """
            A human readable message indicating details about the transition.
            """
            return self._set("message", value)

        def reason(self, value: Optional[str], /) -> Self:
            """
            The reason for the condition's last transition.
            """
            return self._set("reason", value)

        def status(self, value: str, /) -> Self:
            """
            Status of the condition, one of True, False, Unknown.
            """
            return self._set("status", value)

        def type(self, value: str, /) -> Self:
            """
            Type of replica set condition.
            """
            return self._set("type", value)

    class BuilderContext(BuilderContextBase["ReplicaSetCondition.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = ReplicaSetCondition.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for ReplicaSetCondition."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["ReplicaSetCondition", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use ReplicaSetCondition.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    last_transition_time: Annotated[
        Optional[apimachinery.Time], Field(alias="lastTransitionTime")
    ] = None
    """
    The last time the condition transitioned from one status to another.
    """
    message: Optional[str] = None
    """
    A human readable message indicating details about the transition.
    """
    reason: Optional[str] = None
    """
    The reason for the condition's last transition.
    """
    status: str
    """
    Status of the condition, one of True, False, Unknown.
    """
    type: str
    """
    Type of replica set condition.
    """


class ReplicaSetStatus(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["ReplicaSetStatus"]:
            return ReplicaSetStatus

        def build(self) -> "ReplicaSetStatus":
            return ReplicaSetStatus(**self._attrs)

        def available_replicas(self, value: Optional[int], /) -> Self:
            """
            The number of available replicas (ready for at least minReadySeconds) for this replica set.
            """
            return self._set("available_replicas", value)

        @overload
        def conditions(
            self, value_or_callback: List[ReplicaSetCondition], /
        ) -> "ReplicaSetStatus.Builder": ...

        @overload
        def conditions(
            self,
            value_or_callback: Callable[
                [GenericListBuilder[ReplicaSetCondition, ReplicaSetCondition.Builder]],
                GenericListBuilder[ReplicaSetCondition, ReplicaSetCondition.Builder]
                | List[ReplicaSetCondition],
            ],
            /,
        ) -> "ReplicaSetStatus.Builder": ...

        @overload
        def conditions(
            self, value_or_callback: Never = ...
        ) -> ListBuilderContext[ReplicaSetCondition.Builder]: ...

        def conditions(self, value_or_callback=None, /):
            """
            Represents the latest available observations of a replica set's current state.
            """
            if self._in_context and value_or_callback is None:
                context = ListBuilderContext[ReplicaSetCondition.Builder]()
                context._parent_builder = self
                context._field_name = "conditions"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(ReplicaSetCondition.list_builder())
                if isinstance(output, GenericListBuilder):
                    value = output.build()
                else:
                    value = output
            return self._set("conditions", value)

        def fully_labeled_replicas(self, value: Optional[int], /) -> Self:
            """
            The number of pods that have labels matching the labels of the pod template of the replicaset.
            """
            return self._set("fully_labeled_replicas", value)

        def observed_generation(self, value: Optional[int], /) -> Self:
            """
            ObservedGeneration reflects the generation of the most recently observed ReplicaSet.
            """
            return self._set("observed_generation", value)

        def ready_replicas(self, value: Optional[int], /) -> Self:
            """
            readyReplicas is the number of pods targeted by this ReplicaSet with a Ready Condition.
            """
            return self._set("ready_replicas", value)

        def replicas(self, value: int, /) -> Self:
            """
            Replicas is the most recently observed number of replicas. More info: https://kubernetes.io/docs/concepts/workloads/controllers/replicationcontroller/#what-is-a-replicationcontroller
            """
            return self._set("replicas", value)

    class BuilderContext(BuilderContextBase["ReplicaSetStatus.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = ReplicaSetStatus.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for ReplicaSetStatus."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["ReplicaSetStatus", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use ReplicaSetStatus.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    available_replicas: Annotated[Optional[int], Field(alias="availableReplicas")] = None
    """
    The number of available replicas (ready for at least minReadySeconds) for this replica set.
    """
    conditions: Optional[List[ReplicaSetCondition]] = None
    """
    Represents the latest available observations of a replica set's current state.
    """
    fully_labeled_replicas: Annotated[Optional[int], Field(alias="fullyLabeledReplicas")] = None
    """
    The number of pods that have labels matching the labels of the pod template of the replicaset.
    """
    observed_generation: Annotated[Optional[int], Field(alias="observedGeneration")] = None
    """
    ObservedGeneration reflects the generation of the most recently observed ReplicaSet.
    """
    ready_replicas: Annotated[Optional[int], Field(alias="readyReplicas")] = None
    """
    readyReplicas is the number of pods targeted by this ReplicaSet with a Ready Condition.
    """
    replicas: int
    """
    Replicas is the most recently observed number of replicas. More info: https://kubernetes.io/docs/concepts/workloads/controllers/replicationcontroller/#what-is-a-replicationcontroller
    """


class RollingUpdateDaemonSet(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["RollingUpdateDaemonSet"]:
            return RollingUpdateDaemonSet

        def build(self) -> "RollingUpdateDaemonSet":
            return RollingUpdateDaemonSet(**self._attrs)

        @overload
        def max_surge(
            self, value_or_callback: Optional[apimachinery.IntOrString], /
        ) -> "RollingUpdateDaemonSet.Builder": ...

        @overload
        def max_surge(
            self,
            value_or_callback: Callable[
                [apimachinery.IntOrString.Builder],
                apimachinery.IntOrString.Builder | apimachinery.IntOrString,
            ],
            /,
        ) -> "RollingUpdateDaemonSet.Builder": ...

        @overload
        def max_surge(
            self, value_or_callback: Never = ...
        ) -> "apimachinery.IntOrString.BuilderContext": ...

        def max_surge(self, value_or_callback=None, /):
            """
            The maximum number of nodes with an existing available DaemonSet pod that can have an updated DaemonSet pod during during an update. Value can be an absolute number (ex: 5) or a percentage of desired pods (ex: 10%). This can not be 0 if MaxUnavailable is 0. Absolute number is calculated from percentage by rounding up to a minimum of 1. Default value is 0. Example: when this is set to 30%, at most 30% of the total number of nodes that should be running the daemon pod (i.e. status.desiredNumberScheduled) can have their a new pod created before the old pod is marked as deleted. The update starts by launching new pods on 30% of nodes. Once an updated pod is available (Ready for at least minReadySeconds) the old DaemonSet pod on that node is marked deleted. If the old pod becomes unavailable for any reason (Ready transitions to false, is evicted, or is drained) an updated pod is immediatedly created on that node without considering surge limits. Allowing surge implies the possibility that the resources consumed by the daemonset on any given node can double if the readiness check fails, and so resource intensive daemonsets should take into account that they may cause evictions during disruption.
            """
            if self._in_context and value_or_callback is None:
                context = apimachinery.IntOrString.BuilderContext()
                context._parent_builder = self
                context._field_name = "max_surge"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(apimachinery.IntOrString.builder())
                if isinstance(output, apimachinery.IntOrString.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("max_surge", value)

        @overload
        def max_unavailable(
            self, value_or_callback: Optional[apimachinery.IntOrString], /
        ) -> "RollingUpdateDaemonSet.Builder": ...

        @overload
        def max_unavailable(
            self,
            value_or_callback: Callable[
                [apimachinery.IntOrString.Builder],
                apimachinery.IntOrString.Builder | apimachinery.IntOrString,
            ],
            /,
        ) -> "RollingUpdateDaemonSet.Builder": ...

        @overload
        def max_unavailable(
            self, value_or_callback: Never = ...
        ) -> "apimachinery.IntOrString.BuilderContext": ...

        def max_unavailable(self, value_or_callback=None, /):
            """
            The maximum number of DaemonSet pods that can be unavailable during the update. Value can be an absolute number (ex: 5) or a percentage of total number of DaemonSet pods at the start of the update (ex: 10%). Absolute number is calculated from percentage by rounding up. This cannot be 0 if MaxSurge is 0 Default value is 1. Example: when this is set to 30%, at most 30% of the total number of nodes that should be running the daemon pod (i.e. status.desiredNumberScheduled) can have their pods stopped for an update at any given time. The update starts by stopping at most 30% of those DaemonSet pods and then brings up new DaemonSet pods in their place. Once the new pods are available, it then proceeds onto other DaemonSet pods, thus ensuring that at least 70% of original number of DaemonSet pods are available at all times during the update.
            """
            if self._in_context and value_or_callback is None:
                context = apimachinery.IntOrString.BuilderContext()
                context._parent_builder = self
                context._field_name = "max_unavailable"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(apimachinery.IntOrString.builder())
                if isinstance(output, apimachinery.IntOrString.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("max_unavailable", value)

    class BuilderContext(BuilderContextBase["RollingUpdateDaemonSet.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = RollingUpdateDaemonSet.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for RollingUpdateDaemonSet."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["RollingUpdateDaemonSet", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use RollingUpdateDaemonSet.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    max_surge: Annotated[Optional[apimachinery.IntOrString], Field(alias="maxSurge")] = None
    """
    The maximum number of nodes with an existing available DaemonSet pod that can have an updated DaemonSet pod during during an update. Value can be an absolute number (ex: 5) or a percentage of desired pods (ex: 10%). This can not be 0 if MaxUnavailable is 0. Absolute number is calculated from percentage by rounding up to a minimum of 1. Default value is 0. Example: when this is set to 30%, at most 30% of the total number of nodes that should be running the daemon pod (i.e. status.desiredNumberScheduled) can have their a new pod created before the old pod is marked as deleted. The update starts by launching new pods on 30% of nodes. Once an updated pod is available (Ready for at least minReadySeconds) the old DaemonSet pod on that node is marked deleted. If the old pod becomes unavailable for any reason (Ready transitions to false, is evicted, or is drained) an updated pod is immediatedly created on that node without considering surge limits. Allowing surge implies the possibility that the resources consumed by the daemonset on any given node can double if the readiness check fails, and so resource intensive daemonsets should take into account that they may cause evictions during disruption.
    """
    max_unavailable: Annotated[
        Optional[apimachinery.IntOrString], Field(alias="maxUnavailable")
    ] = None
    """
    The maximum number of DaemonSet pods that can be unavailable during the update. Value can be an absolute number (ex: 5) or a percentage of total number of DaemonSet pods at the start of the update (ex: 10%). Absolute number is calculated from percentage by rounding up. This cannot be 0 if MaxSurge is 0 Default value is 1. Example: when this is set to 30%, at most 30% of the total number of nodes that should be running the daemon pod (i.e. status.desiredNumberScheduled) can have their pods stopped for an update at any given time. The update starts by stopping at most 30% of those DaemonSet pods and then brings up new DaemonSet pods in their place. Once the new pods are available, it then proceeds onto other DaemonSet pods, thus ensuring that at least 70% of original number of DaemonSet pods are available at all times during the update.
    """


class RollingUpdateDeployment(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["RollingUpdateDeployment"]:
            return RollingUpdateDeployment

        def build(self) -> "RollingUpdateDeployment":
            return RollingUpdateDeployment(**self._attrs)

        @overload
        def max_surge(
            self, value_or_callback: Optional[apimachinery.IntOrString], /
        ) -> "RollingUpdateDeployment.Builder": ...

        @overload
        def max_surge(
            self,
            value_or_callback: Callable[
                [apimachinery.IntOrString.Builder],
                apimachinery.IntOrString.Builder | apimachinery.IntOrString,
            ],
            /,
        ) -> "RollingUpdateDeployment.Builder": ...

        @overload
        def max_surge(
            self, value_or_callback: Never = ...
        ) -> "apimachinery.IntOrString.BuilderContext": ...

        def max_surge(self, value_or_callback=None, /):
            """
            The maximum number of pods that can be scheduled above the desired number of pods. Value can be an absolute number (ex: 5) or a percentage of desired pods (ex: 10%). This can not be 0 if MaxUnavailable is 0. Absolute number is calculated from percentage by rounding up. Defaults to 25%. Example: when this is set to 30%, the new ReplicaSet can be scaled up immediately when the rolling update starts, such that the total number of old and new pods do not exceed 130% of desired pods. Once old pods have been killed, new ReplicaSet can be scaled up further, ensuring that total number of pods running at any time during the update is at most 130% of desired pods.
            """
            if self._in_context and value_or_callback is None:
                context = apimachinery.IntOrString.BuilderContext()
                context._parent_builder = self
                context._field_name = "max_surge"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(apimachinery.IntOrString.builder())
                if isinstance(output, apimachinery.IntOrString.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("max_surge", value)

        @overload
        def max_unavailable(
            self, value_or_callback: Optional[apimachinery.IntOrString], /
        ) -> "RollingUpdateDeployment.Builder": ...

        @overload
        def max_unavailable(
            self,
            value_or_callback: Callable[
                [apimachinery.IntOrString.Builder],
                apimachinery.IntOrString.Builder | apimachinery.IntOrString,
            ],
            /,
        ) -> "RollingUpdateDeployment.Builder": ...

        @overload
        def max_unavailable(
            self, value_or_callback: Never = ...
        ) -> "apimachinery.IntOrString.BuilderContext": ...

        def max_unavailable(self, value_or_callback=None, /):
            """
            The maximum number of pods that can be unavailable during the update. Value can be an absolute number (ex: 5) or a percentage of desired pods (ex: 10%). Absolute number is calculated from percentage by rounding down. This can not be 0 if MaxSurge is 0. Defaults to 25%. Example: when this is set to 30%, the old ReplicaSet can be scaled down to 70% of desired pods immediately when the rolling update starts. Once new pods are ready, old ReplicaSet can be scaled down further, followed by scaling up the new ReplicaSet, ensuring that the total number of pods available at all times during the update is at least 70% of desired pods.
            """
            if self._in_context and value_or_callback is None:
                context = apimachinery.IntOrString.BuilderContext()
                context._parent_builder = self
                context._field_name = "max_unavailable"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(apimachinery.IntOrString.builder())
                if isinstance(output, apimachinery.IntOrString.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("max_unavailable", value)

    class BuilderContext(BuilderContextBase["RollingUpdateDeployment.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = RollingUpdateDeployment.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for RollingUpdateDeployment."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["RollingUpdateDeployment", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use RollingUpdateDeployment.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    max_surge: Annotated[Optional[apimachinery.IntOrString], Field(alias="maxSurge")] = None
    """
    The maximum number of pods that can be scheduled above the desired number of pods. Value can be an absolute number (ex: 5) or a percentage of desired pods (ex: 10%). This can not be 0 if MaxUnavailable is 0. Absolute number is calculated from percentage by rounding up. Defaults to 25%. Example: when this is set to 30%, the new ReplicaSet can be scaled up immediately when the rolling update starts, such that the total number of old and new pods do not exceed 130% of desired pods. Once old pods have been killed, new ReplicaSet can be scaled up further, ensuring that total number of pods running at any time during the update is at most 130% of desired pods.
    """
    max_unavailable: Annotated[
        Optional[apimachinery.IntOrString], Field(alias="maxUnavailable")
    ] = None
    """
    The maximum number of pods that can be unavailable during the update. Value can be an absolute number (ex: 5) or a percentage of desired pods (ex: 10%). Absolute number is calculated from percentage by rounding down. This can not be 0 if MaxSurge is 0. Defaults to 25%. Example: when this is set to 30%, the old ReplicaSet can be scaled down to 70% of desired pods immediately when the rolling update starts. Once new pods are ready, old ReplicaSet can be scaled down further, followed by scaling up the new ReplicaSet, ensuring that the total number of pods available at all times during the update is at least 70% of desired pods.
    """


class RollingUpdateStatefulSetStrategy(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["RollingUpdateStatefulSetStrategy"]:
            return RollingUpdateStatefulSetStrategy

        def build(self) -> "RollingUpdateStatefulSetStrategy":
            return RollingUpdateStatefulSetStrategy(**self._attrs)

        @overload
        def max_unavailable(
            self, value_or_callback: Optional[apimachinery.IntOrString], /
        ) -> "RollingUpdateStatefulSetStrategy.Builder": ...

        @overload
        def max_unavailable(
            self,
            value_or_callback: Callable[
                [apimachinery.IntOrString.Builder],
                apimachinery.IntOrString.Builder | apimachinery.IntOrString,
            ],
            /,
        ) -> "RollingUpdateStatefulSetStrategy.Builder": ...

        @overload
        def max_unavailable(
            self, value_or_callback: Never = ...
        ) -> "apimachinery.IntOrString.BuilderContext": ...

        def max_unavailable(self, value_or_callback=None, /):
            """
            The maximum number of pods that can be unavailable during the update. Value can be an absolute number (ex: 5) or a percentage of desired pods (ex: 10%). Absolute number is calculated from percentage by rounding up. This can not be 0. Defaults to 1. This field is alpha-level and is only honored by servers that enable the MaxUnavailableStatefulSet feature. The field applies to all pods in the range 0 to Replicas-1. That means if there is any unavailable pod in the range 0 to Replicas-1, it will be counted towards MaxUnavailable.
            """
            if self._in_context and value_or_callback is None:
                context = apimachinery.IntOrString.BuilderContext()
                context._parent_builder = self
                context._field_name = "max_unavailable"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(apimachinery.IntOrString.builder())
                if isinstance(output, apimachinery.IntOrString.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("max_unavailable", value)

        def partition(self, value: Optional[int], /) -> Self:
            """
            Partition indicates the ordinal at which the StatefulSet should be partitioned for updates. During a rolling update, all pods from ordinal Replicas-1 to Partition are updated. All pods from ordinal Partition-1 to 0 remain untouched. This is helpful in being able to do a canary based deployment. The default value is 0.
            """
            return self._set("partition", value)

    class BuilderContext(BuilderContextBase["RollingUpdateStatefulSetStrategy.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = RollingUpdateStatefulSetStrategy.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for RollingUpdateStatefulSetStrategy."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["RollingUpdateStatefulSetStrategy", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use RollingUpdateStatefulSetStrategy.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    max_unavailable: Annotated[
        Optional[apimachinery.IntOrString], Field(alias="maxUnavailable")
    ] = None
    """
    The maximum number of pods that can be unavailable during the update. Value can be an absolute number (ex: 5) or a percentage of desired pods (ex: 10%). Absolute number is calculated from percentage by rounding up. This can not be 0. Defaults to 1. This field is alpha-level and is only honored by servers that enable the MaxUnavailableStatefulSet feature. The field applies to all pods in the range 0 to Replicas-1. That means if there is any unavailable pod in the range 0 to Replicas-1, it will be counted towards MaxUnavailable.
    """
    partition: Optional[int] = None
    """
    Partition indicates the ordinal at which the StatefulSet should be partitioned for updates. During a rolling update, all pods from ordinal Replicas-1 to Partition are updated. All pods from ordinal Partition-1 to 0 remain untouched. This is helpful in being able to do a canary based deployment. The default value is 0.
    """


class StatefulSetCondition(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["StatefulSetCondition"]:
            return StatefulSetCondition

        def build(self) -> "StatefulSetCondition":
            return StatefulSetCondition(**self._attrs)

        @overload
        def last_transition_time(
            self, value_or_callback: Optional[apimachinery.Time], /
        ) -> "StatefulSetCondition.Builder": ...

        @overload
        def last_transition_time(
            self,
            value_or_callback: Callable[
                [apimachinery.Time.Builder],
                apimachinery.Time.Builder | apimachinery.Time,
            ],
            /,
        ) -> "StatefulSetCondition.Builder": ...

        @overload
        def last_transition_time(
            self, value_or_callback: Never = ...
        ) -> "apimachinery.Time.BuilderContext": ...

        def last_transition_time(self, value_or_callback=None, /):
            """
            Last time the condition transitioned from one status to another.
            """
            if self._in_context and value_or_callback is None:
                context = apimachinery.Time.BuilderContext()
                context._parent_builder = self
                context._field_name = "last_transition_time"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(apimachinery.Time.builder())
                if isinstance(output, apimachinery.Time.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("last_transition_time", value)

        def message(self, value: Optional[str], /) -> Self:
            """
            A human readable message indicating details about the transition.
            """
            return self._set("message", value)

        def reason(self, value: Optional[str], /) -> Self:
            """
            The reason for the condition's last transition.
            """
            return self._set("reason", value)

        def status(self, value: str, /) -> Self:
            """
            Status of the condition, one of True, False, Unknown.
            """
            return self._set("status", value)

        def type(self, value: str, /) -> Self:
            """
            Type of statefulset condition.
            """
            return self._set("type", value)

    class BuilderContext(BuilderContextBase["StatefulSetCondition.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = StatefulSetCondition.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for StatefulSetCondition."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["StatefulSetCondition", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use StatefulSetCondition.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    last_transition_time: Annotated[
        Optional[apimachinery.Time], Field(alias="lastTransitionTime")
    ] = None
    """
    Last time the condition transitioned from one status to another.
    """
    message: Optional[str] = None
    """
    A human readable message indicating details about the transition.
    """
    reason: Optional[str] = None
    """
    The reason for the condition's last transition.
    """
    status: str
    """
    Status of the condition, one of True, False, Unknown.
    """
    type: str
    """
    Type of statefulset condition.
    """


class StatefulSetStatus(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["StatefulSetStatus"]:
            return StatefulSetStatus

        def build(self) -> "StatefulSetStatus":
            return StatefulSetStatus(**self._attrs)

        def available_replicas(self, value: Optional[int], /) -> Self:
            """
            Total number of available pods (ready for at least minReadySeconds) targeted by this statefulset.
            """
            return self._set("available_replicas", value)

        def collision_count(self, value: Optional[int], /) -> Self:
            """
            collisionCount is the count of hash collisions for the StatefulSet. The StatefulSet controller uses this field as a collision avoidance mechanism when it needs to create the name for the newest ControllerRevision.
            """
            return self._set("collision_count", value)

        @overload
        def conditions(
            self, value_or_callback: List[StatefulSetCondition], /
        ) -> "StatefulSetStatus.Builder": ...

        @overload
        def conditions(
            self,
            value_or_callback: Callable[
                [GenericListBuilder[StatefulSetCondition, StatefulSetCondition.Builder]],
                GenericListBuilder[StatefulSetCondition, StatefulSetCondition.Builder]
                | List[StatefulSetCondition],
            ],
            /,
        ) -> "StatefulSetStatus.Builder": ...

        @overload
        def conditions(
            self, value_or_callback: Never = ...
        ) -> ListBuilderContext[StatefulSetCondition.Builder]: ...

        def conditions(self, value_or_callback=None, /):
            """
            Represents the latest available observations of a statefulset's current state.
            """
            if self._in_context and value_or_callback is None:
                context = ListBuilderContext[StatefulSetCondition.Builder]()
                context._parent_builder = self
                context._field_name = "conditions"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(StatefulSetCondition.list_builder())
                if isinstance(output, GenericListBuilder):
                    value = output.build()
                else:
                    value = output
            return self._set("conditions", value)

        def current_replicas(self, value: Optional[int], /) -> Self:
            """
            currentReplicas is the number of Pods created by the StatefulSet controller from the StatefulSet version indicated by currentRevision.
            """
            return self._set("current_replicas", value)

        def current_revision(self, value: Optional[str], /) -> Self:
            """
            currentRevision, if not empty, indicates the version of the StatefulSet used to generate Pods in the sequence [0,currentReplicas).
            """
            return self._set("current_revision", value)

        def observed_generation(self, value: Optional[int], /) -> Self:
            """
            observedGeneration is the most recent generation observed for this StatefulSet. It corresponds to the StatefulSet's generation, which is updated on mutation by the API Server.
            """
            return self._set("observed_generation", value)

        def ready_replicas(self, value: Optional[int], /) -> Self:
            """
            readyReplicas is the number of pods created for this StatefulSet with a Ready Condition.
            """
            return self._set("ready_replicas", value)

        def replicas(self, value: int, /) -> Self:
            """
            replicas is the number of Pods created by the StatefulSet controller.
            """
            return self._set("replicas", value)

        def update_revision(self, value: Optional[str], /) -> Self:
            """
            updateRevision, if not empty, indicates the version of the StatefulSet used to generate Pods in the sequence [replicas-updatedReplicas,replicas)
            """
            return self._set("update_revision", value)

        def updated_replicas(self, value: Optional[int], /) -> Self:
            """
            updatedReplicas is the number of Pods created by the StatefulSet controller from the StatefulSet version indicated by updateRevision.
            """
            return self._set("updated_replicas", value)

    class BuilderContext(BuilderContextBase["StatefulSetStatus.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = StatefulSetStatus.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for StatefulSetStatus."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["StatefulSetStatus", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use StatefulSetStatus.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    available_replicas: Annotated[Optional[int], Field(alias="availableReplicas")] = None
    """
    Total number of available pods (ready for at least minReadySeconds) targeted by this statefulset.
    """
    collision_count: Annotated[Optional[int], Field(alias="collisionCount")] = None
    """
    collisionCount is the count of hash collisions for the StatefulSet. The StatefulSet controller uses this field as a collision avoidance mechanism when it needs to create the name for the newest ControllerRevision.
    """
    conditions: Optional[List[StatefulSetCondition]] = None
    """
    Represents the latest available observations of a statefulset's current state.
    """
    current_replicas: Annotated[Optional[int], Field(alias="currentReplicas")] = None
    """
    currentReplicas is the number of Pods created by the StatefulSet controller from the StatefulSet version indicated by currentRevision.
    """
    current_revision: Annotated[Optional[str], Field(alias="currentRevision")] = None
    """
    currentRevision, if not empty, indicates the version of the StatefulSet used to generate Pods in the sequence [0,currentReplicas).
    """
    observed_generation: Annotated[Optional[int], Field(alias="observedGeneration")] = None
    """
    observedGeneration is the most recent generation observed for this StatefulSet. It corresponds to the StatefulSet's generation, which is updated on mutation by the API Server.
    """
    ready_replicas: Annotated[Optional[int], Field(alias="readyReplicas")] = None
    """
    readyReplicas is the number of pods created for this StatefulSet with a Ready Condition.
    """
    replicas: int
    """
    replicas is the number of Pods created by the StatefulSet controller.
    """
    update_revision: Annotated[Optional[str], Field(alias="updateRevision")] = None
    """
    updateRevision, if not empty, indicates the version of the StatefulSet used to generate Pods in the sequence [replicas-updatedReplicas,replicas)
    """
    updated_replicas: Annotated[Optional[int], Field(alias="updatedReplicas")] = None
    """
    updatedReplicas is the number of Pods created by the StatefulSet controller from the StatefulSet version indicated by updateRevision.
    """


class StatefulSetUpdateStrategy(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["StatefulSetUpdateStrategy"]:
            return StatefulSetUpdateStrategy

        def build(self) -> "StatefulSetUpdateStrategy":
            return StatefulSetUpdateStrategy(**self._attrs)

        @overload
        def rolling_update(
            self, value_or_callback: Optional[RollingUpdateStatefulSetStrategy], /
        ) -> "StatefulSetUpdateStrategy.Builder": ...

        @overload
        def rolling_update(
            self,
            value_or_callback: Callable[
                [RollingUpdateStatefulSetStrategy.Builder],
                RollingUpdateStatefulSetStrategy.Builder | RollingUpdateStatefulSetStrategy,
            ],
            /,
        ) -> "StatefulSetUpdateStrategy.Builder": ...

        @overload
        def rolling_update(
            self, value_or_callback: Never = ...
        ) -> "RollingUpdateStatefulSetStrategy.BuilderContext": ...

        def rolling_update(self, value_or_callback=None, /):
            """
            RollingUpdate is used to communicate parameters when Type is RollingUpdateStatefulSetStrategyType.
            """
            if self._in_context and value_or_callback is None:
                context = RollingUpdateStatefulSetStrategy.BuilderContext()
                context._parent_builder = self
                context._field_name = "rolling_update"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(RollingUpdateStatefulSetStrategy.builder())
                if isinstance(output, RollingUpdateStatefulSetStrategy.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("rolling_update", value)

        def type(self, value: Optional[str], /) -> Self:
            """
            Type indicates the type of the StatefulSetUpdateStrategy. Default is RollingUpdate.
            """
            return self._set("type", value)

    class BuilderContext(BuilderContextBase["StatefulSetUpdateStrategy.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = StatefulSetUpdateStrategy.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for StatefulSetUpdateStrategy."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["StatefulSetUpdateStrategy", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use StatefulSetUpdateStrategy.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    rolling_update: Annotated[
        Optional[RollingUpdateStatefulSetStrategy], Field(alias="rollingUpdate")
    ] = None
    """
    RollingUpdate is used to communicate parameters when Type is RollingUpdateStatefulSetStrategyType.
    """
    type: Optional[str] = None
    """
    Type indicates the type of the StatefulSetUpdateStrategy. Default is RollingUpdate.
    """


class ControllerRevision(Resource):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["ControllerRevision"]:
            return ControllerRevision

        def build(self) -> "ControllerRevision":
            return ControllerRevision(**self._attrs)

        def api_version(self, value: Optional[Literal["apps/v1"]], /) -> Self:
            """
            APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
            """
            return self._set("api_version", value)

        @overload
        def data(
            self, value_or_callback: Optional[apimachinery.RawExtension], /
        ) -> "ControllerRevision.Builder": ...

        @overload
        def data(
            self,
            value_or_callback: Callable[
                [apimachinery.RawExtension.Builder],
                apimachinery.RawExtension.Builder | apimachinery.RawExtension,
            ],
            /,
        ) -> "ControllerRevision.Builder": ...

        @overload
        def data(
            self, value_or_callback: Never = ...
        ) -> "apimachinery.RawExtension.BuilderContext": ...

        def data(self, value_or_callback=None, /):
            """
            Data is the serialized representation of the state.
            """
            if self._in_context and value_or_callback is None:
                context = apimachinery.RawExtension.BuilderContext()
                context._parent_builder = self
                context._field_name = "data"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(apimachinery.RawExtension.builder())
                if isinstance(output, apimachinery.RawExtension.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("data", value)

        def kind(self, value: Optional[Literal["ControllerRevision"]], /) -> Self:
            """
            Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
            """
            return self._set("kind", value)

        @overload
        def metadata(
            self, value_or_callback: Optional[apimachinery.ObjectMeta], /
        ) -> "ControllerRevision.Builder": ...

        @overload
        def metadata(
            self,
            value_or_callback: Callable[
                [apimachinery.ObjectMeta.Builder],
                apimachinery.ObjectMeta.Builder | apimachinery.ObjectMeta,
            ],
            /,
        ) -> "ControllerRevision.Builder": ...

        @overload
        def metadata(
            self, value_or_callback: Never = ...
        ) -> "apimachinery.ObjectMeta.BuilderContext": ...

        def metadata(self, value_or_callback=None, /):
            """
            Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
            """
            if self._in_context and value_or_callback is None:
                context = apimachinery.ObjectMeta.BuilderContext()
                context._parent_builder = self
                context._field_name = "metadata"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(apimachinery.ObjectMeta.builder())
                if isinstance(output, apimachinery.ObjectMeta.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("metadata", value)

        def revision(self, value: int, /) -> Self:
            """
            Revision indicates the revision of the state represented by Data.
            """
            return self._set("revision", value)

    class BuilderContext(BuilderContextBase["ControllerRevision.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = ControllerRevision.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for ControllerRevision."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["ControllerRevision", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use ControllerRevision.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    api_version: Annotated[Optional[Literal["apps/v1"]], Field(alias="apiVersion")] = "apps/v1"
    """
    APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
    """
    data: Optional[apimachinery.RawExtension] = None
    """
    Data is the serialized representation of the state.
    """
    kind: Optional[Literal["ControllerRevision"]] = "ControllerRevision"
    """
    Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
    """
    metadata: Optional[apimachinery.ObjectMeta] = None
    """
    Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
    """
    revision: int
    """
    Revision indicates the revision of the state represented by Data.
    """


ControllerRevisionList = ResourceList["ControllerRevision"]


class DaemonSetUpdateStrategy(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["DaemonSetUpdateStrategy"]:
            return DaemonSetUpdateStrategy

        def build(self) -> "DaemonSetUpdateStrategy":
            return DaemonSetUpdateStrategy(**self._attrs)

        @overload
        def rolling_update(
            self, value_or_callback: Optional[RollingUpdateDaemonSet], /
        ) -> "DaemonSetUpdateStrategy.Builder": ...

        @overload
        def rolling_update(
            self,
            value_or_callback: Callable[
                [RollingUpdateDaemonSet.Builder],
                RollingUpdateDaemonSet.Builder | RollingUpdateDaemonSet,
            ],
            /,
        ) -> "DaemonSetUpdateStrategy.Builder": ...

        @overload
        def rolling_update(
            self, value_or_callback: Never = ...
        ) -> "RollingUpdateDaemonSet.BuilderContext": ...

        def rolling_update(self, value_or_callback=None, /):
            """
            Rolling update config params. Present only if type = "RollingUpdate".
            """
            if self._in_context and value_or_callback is None:
                context = RollingUpdateDaemonSet.BuilderContext()
                context._parent_builder = self
                context._field_name = "rolling_update"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(RollingUpdateDaemonSet.builder())
                if isinstance(output, RollingUpdateDaemonSet.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("rolling_update", value)

        def type(self, value: Optional[str], /) -> Self:
            """
            Type of daemon set update. Can be "RollingUpdate" or "OnDelete". Default is RollingUpdate.
            """
            return self._set("type", value)

    class BuilderContext(BuilderContextBase["DaemonSetUpdateStrategy.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = DaemonSetUpdateStrategy.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for DaemonSetUpdateStrategy."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["DaemonSetUpdateStrategy", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use DaemonSetUpdateStrategy.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    rolling_update: Annotated[Optional[RollingUpdateDaemonSet], Field(alias="rollingUpdate")] = None
    """
    Rolling update config params. Present only if type = "RollingUpdate".
    """
    type: Optional[str] = None
    """
    Type of daemon set update. Can be "RollingUpdate" or "OnDelete". Default is RollingUpdate.
    """


class DeploymentStrategy(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["DeploymentStrategy"]:
            return DeploymentStrategy

        def build(self) -> "DeploymentStrategy":
            return DeploymentStrategy(**self._attrs)

        @overload
        def rolling_update(
            self, value_or_callback: Optional[RollingUpdateDeployment], /
        ) -> "DeploymentStrategy.Builder": ...

        @overload
        def rolling_update(
            self,
            value_or_callback: Callable[
                [RollingUpdateDeployment.Builder],
                RollingUpdateDeployment.Builder | RollingUpdateDeployment,
            ],
            /,
        ) -> "DeploymentStrategy.Builder": ...

        @overload
        def rolling_update(
            self, value_or_callback: Never = ...
        ) -> "RollingUpdateDeployment.BuilderContext": ...

        def rolling_update(self, value_or_callback=None, /):
            """
            Rolling update config params. Present only if DeploymentStrategyType = RollingUpdate.
            """
            if self._in_context and value_or_callback is None:
                context = RollingUpdateDeployment.BuilderContext()
                context._parent_builder = self
                context._field_name = "rolling_update"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(RollingUpdateDeployment.builder())
                if isinstance(output, RollingUpdateDeployment.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("rolling_update", value)

        def type(self, value: Optional[str], /) -> Self:
            """
            Type of deployment. Can be "Recreate" or "RollingUpdate". Default is RollingUpdate.
            """
            return self._set("type", value)

    class BuilderContext(BuilderContextBase["DeploymentStrategy.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = DeploymentStrategy.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for DeploymentStrategy."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["DeploymentStrategy", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use DeploymentStrategy.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    rolling_update: Annotated[Optional[RollingUpdateDeployment], Field(alias="rollingUpdate")] = (
        None
    )
    """
    Rolling update config params. Present only if DeploymentStrategyType = RollingUpdate.
    """
    type: Optional[str] = None
    """
    Type of deployment. Can be "Recreate" or "RollingUpdate". Default is RollingUpdate.
    """


class DaemonSetSpec(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["DaemonSetSpec"]:
            return DaemonSetSpec

        def build(self) -> "DaemonSetSpec":
            return DaemonSetSpec(**self._attrs)

        def min_ready_seconds(self, value: Optional[int], /) -> Self:
            """
            The minimum number of seconds for which a newly created DaemonSet pod should be ready without any of its container crashing, for it to be considered available. Defaults to 0 (pod will be considered available as soon as it is ready).
            """
            return self._set("min_ready_seconds", value)

        def revision_history_limit(self, value: Optional[int], /) -> Self:
            """
            The number of old history to retain to allow rollback. This is a pointer to distinguish between explicit zero and not specified. Defaults to 10.
            """
            return self._set("revision_history_limit", value)

        @overload
        def selector(
            self, value_or_callback: apimachinery.LabelSelector, /
        ) -> "DaemonSetSpec.Builder": ...

        @overload
        def selector(
            self,
            value_or_callback: Callable[
                [apimachinery.LabelSelector.Builder],
                apimachinery.LabelSelector.Builder | apimachinery.LabelSelector,
            ],
            /,
        ) -> "DaemonSetSpec.Builder": ...

        @overload
        def selector(
            self, value_or_callback: Never = ...
        ) -> "apimachinery.LabelSelector.BuilderContext": ...

        def selector(self, value_or_callback=None, /):
            """
            A label query over pods that are managed by the daemon set. Must match in order to be controlled. It must match the pod template's labels. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/labels/#label-selectors
            """
            if self._in_context and value_or_callback is None:
                context = apimachinery.LabelSelector.BuilderContext()
                context._parent_builder = self
                context._field_name = "selector"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(apimachinery.LabelSelector.builder())
                if isinstance(output, apimachinery.LabelSelector.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("selector", value)

        @overload
        def template(self, value_or_callback: v1.PodTemplateSpec, /) -> "DaemonSetSpec.Builder": ...

        @overload
        def template(
            self,
            value_or_callback: Callable[
                [v1.PodTemplateSpec.Builder],
                v1.PodTemplateSpec.Builder | v1.PodTemplateSpec,
            ],
            /,
        ) -> "DaemonSetSpec.Builder": ...

        @overload
        def template(
            self, value_or_callback: Never = ...
        ) -> "v1.PodTemplateSpec.BuilderContext": ...

        def template(self, value_or_callback=None, /):
            """
            An object that describes the pod that will be created. The DaemonSet will create exactly one copy of this pod on every node that matches the template's node selector (or on every node if no node selector is specified). The only allowed template.spec.restartPolicy value is "Always". More info: https://kubernetes.io/docs/concepts/workloads/controllers/replicationcontroller#pod-template
            """
            if self._in_context and value_or_callback is None:
                context = v1.PodTemplateSpec.BuilderContext()
                context._parent_builder = self
                context._field_name = "template"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(v1.PodTemplateSpec.builder())
                if isinstance(output, v1.PodTemplateSpec.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("template", value)

        @overload
        def update_strategy(
            self, value_or_callback: Optional[DaemonSetUpdateStrategy], /
        ) -> "DaemonSetSpec.Builder": ...

        @overload
        def update_strategy(
            self,
            value_or_callback: Callable[
                [DaemonSetUpdateStrategy.Builder],
                DaemonSetUpdateStrategy.Builder | DaemonSetUpdateStrategy,
            ],
            /,
        ) -> "DaemonSetSpec.Builder": ...

        @overload
        def update_strategy(
            self, value_or_callback: Never = ...
        ) -> "DaemonSetUpdateStrategy.BuilderContext": ...

        def update_strategy(self, value_or_callback=None, /):
            """
            An update strategy to replace existing DaemonSet pods with new pods.
            """
            if self._in_context and value_or_callback is None:
                context = DaemonSetUpdateStrategy.BuilderContext()
                context._parent_builder = self
                context._field_name = "update_strategy"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(DaemonSetUpdateStrategy.builder())
                if isinstance(output, DaemonSetUpdateStrategy.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("update_strategy", value)

    class BuilderContext(BuilderContextBase["DaemonSetSpec.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = DaemonSetSpec.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for DaemonSetSpec."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["DaemonSetSpec", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use DaemonSetSpec.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    min_ready_seconds: Annotated[Optional[int], Field(alias="minReadySeconds")] = None
    """
    The minimum number of seconds for which a newly created DaemonSet pod should be ready without any of its container crashing, for it to be considered available. Defaults to 0 (pod will be considered available as soon as it is ready).
    """
    revision_history_limit: Annotated[Optional[int], Field(alias="revisionHistoryLimit")] = None
    """
    The number of old history to retain to allow rollback. This is a pointer to distinguish between explicit zero and not specified. Defaults to 10.
    """
    selector: apimachinery.LabelSelector
    """
    A label query over pods that are managed by the daemon set. Must match in order to be controlled. It must match the pod template's labels. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/labels/#label-selectors
    """
    template: v1.PodTemplateSpec
    """
    An object that describes the pod that will be created. The DaemonSet will create exactly one copy of this pod on every node that matches the template's node selector (or on every node if no node selector is specified). The only allowed template.spec.restartPolicy value is "Always". More info: https://kubernetes.io/docs/concepts/workloads/controllers/replicationcontroller#pod-template
    """
    update_strategy: Annotated[Optional[DaemonSetUpdateStrategy], Field(alias="updateStrategy")] = (
        None
    )
    """
    An update strategy to replace existing DaemonSet pods with new pods.
    """


class DeploymentSpec(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["DeploymentSpec"]:
            return DeploymentSpec

        def build(self) -> "DeploymentSpec":
            return DeploymentSpec(**self._attrs)

        def min_ready_seconds(self, value: Optional[int], /) -> Self:
            """
            Minimum number of seconds for which a newly created pod should be ready without any of its container crashing, for it to be considered available. Defaults to 0 (pod will be considered available as soon as it is ready)
            """
            return self._set("min_ready_seconds", value)

        def paused(self, value: Optional[bool], /) -> Self:
            """
            Indicates that the deployment is paused.
            """
            return self._set("paused", value)

        def progress_deadline_seconds(self, value: Optional[int], /) -> Self:
            """
            The maximum time in seconds for a deployment to make progress before it is considered to be failed. The deployment controller will continue to process failed deployments and a condition with a ProgressDeadlineExceeded reason will be surfaced in the deployment status. Note that progress will not be estimated during the time a deployment is paused. Defaults to 600s.
            """
            return self._set("progress_deadline_seconds", value)

        def replicas(self, value: Optional[int], /) -> Self:
            """
            Number of desired pods. This is a pointer to distinguish between explicit zero and not specified. Defaults to 1.
            """
            return self._set("replicas", value)

        def revision_history_limit(self, value: Optional[int], /) -> Self:
            """
            The number of old ReplicaSets to retain to allow rollback. This is a pointer to distinguish between explicit zero and not specified. Defaults to 10.
            """
            return self._set("revision_history_limit", value)

        @overload
        def selector(
            self, value_or_callback: apimachinery.LabelSelector, /
        ) -> "DeploymentSpec.Builder": ...

        @overload
        def selector(
            self,
            value_or_callback: Callable[
                [apimachinery.LabelSelector.Builder],
                apimachinery.LabelSelector.Builder | apimachinery.LabelSelector,
            ],
            /,
        ) -> "DeploymentSpec.Builder": ...

        @overload
        def selector(
            self, value_or_callback: Never = ...
        ) -> "apimachinery.LabelSelector.BuilderContext": ...

        def selector(self, value_or_callback=None, /):
            """
            Label selector for pods. Existing ReplicaSets whose pods are selected by this will be the ones affected by this deployment. It must match the pod template's labels.
            """
            if self._in_context and value_or_callback is None:
                context = apimachinery.LabelSelector.BuilderContext()
                context._parent_builder = self
                context._field_name = "selector"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(apimachinery.LabelSelector.builder())
                if isinstance(output, apimachinery.LabelSelector.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("selector", value)

        @overload
        def strategy(
            self, value_or_callback: Optional[DeploymentStrategy], /
        ) -> "DeploymentSpec.Builder": ...

        @overload
        def strategy(
            self,
            value_or_callback: Callable[
                [DeploymentStrategy.Builder],
                DeploymentStrategy.Builder | DeploymentStrategy,
            ],
            /,
        ) -> "DeploymentSpec.Builder": ...

        @overload
        def strategy(
            self, value_or_callback: Never = ...
        ) -> "DeploymentStrategy.BuilderContext": ...

        def strategy(self, value_or_callback=None, /):
            """
            The deployment strategy to use to replace existing pods with new ones.
            """
            if self._in_context and value_or_callback is None:
                context = DeploymentStrategy.BuilderContext()
                context._parent_builder = self
                context._field_name = "strategy"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(DeploymentStrategy.builder())
                if isinstance(output, DeploymentStrategy.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("strategy", value)

        @overload
        def template(
            self, value_or_callback: v1.PodTemplateSpec, /
        ) -> "DeploymentSpec.Builder": ...

        @overload
        def template(
            self,
            value_or_callback: Callable[
                [v1.PodTemplateSpec.Builder],
                v1.PodTemplateSpec.Builder | v1.PodTemplateSpec,
            ],
            /,
        ) -> "DeploymentSpec.Builder": ...

        @overload
        def template(
            self, value_or_callback: Never = ...
        ) -> "v1.PodTemplateSpec.BuilderContext": ...

        def template(self, value_or_callback=None, /):
            """
            Template describes the pods that will be created. The only allowed template.spec.restartPolicy value is "Always".
            """
            if self._in_context and value_or_callback is None:
                context = v1.PodTemplateSpec.BuilderContext()
                context._parent_builder = self
                context._field_name = "template"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(v1.PodTemplateSpec.builder())
                if isinstance(output, v1.PodTemplateSpec.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("template", value)

    class BuilderContext(BuilderContextBase["DeploymentSpec.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = DeploymentSpec.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for DeploymentSpec."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["DeploymentSpec", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use DeploymentSpec.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    min_ready_seconds: Annotated[Optional[int], Field(alias="minReadySeconds")] = None
    """
    Minimum number of seconds for which a newly created pod should be ready without any of its container crashing, for it to be considered available. Defaults to 0 (pod will be considered available as soon as it is ready)
    """
    paused: Optional[bool] = None
    """
    Indicates that the deployment is paused.
    """
    progress_deadline_seconds: Annotated[Optional[int], Field(alias="progressDeadlineSeconds")] = (
        None
    )
    """
    The maximum time in seconds for a deployment to make progress before it is considered to be failed. The deployment controller will continue to process failed deployments and a condition with a ProgressDeadlineExceeded reason will be surfaced in the deployment status. Note that progress will not be estimated during the time a deployment is paused. Defaults to 600s.
    """
    replicas: Optional[int] = None
    """
    Number of desired pods. This is a pointer to distinguish between explicit zero and not specified. Defaults to 1.
    """
    revision_history_limit: Annotated[Optional[int], Field(alias="revisionHistoryLimit")] = None
    """
    The number of old ReplicaSets to retain to allow rollback. This is a pointer to distinguish between explicit zero and not specified. Defaults to 10.
    """
    selector: apimachinery.LabelSelector
    """
    Label selector for pods. Existing ReplicaSets whose pods are selected by this will be the ones affected by this deployment. It must match the pod template's labels.
    """
    strategy: Optional[DeploymentStrategy] = None
    """
    The deployment strategy to use to replace existing pods with new ones.
    """
    template: v1.PodTemplateSpec
    """
    Template describes the pods that will be created. The only allowed template.spec.restartPolicy value is "Always".
    """


class ReplicaSetSpec(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["ReplicaSetSpec"]:
            return ReplicaSetSpec

        def build(self) -> "ReplicaSetSpec":
            return ReplicaSetSpec(**self._attrs)

        def min_ready_seconds(self, value: Optional[int], /) -> Self:
            """
            Minimum number of seconds for which a newly created pod should be ready without any of its container crashing, for it to be considered available. Defaults to 0 (pod will be considered available as soon as it is ready)
            """
            return self._set("min_ready_seconds", value)

        def replicas(self, value: Optional[int], /) -> Self:
            """
            Replicas is the number of desired replicas. This is a pointer to distinguish between explicit zero and unspecified. Defaults to 1. More info: https://kubernetes.io/docs/concepts/workloads/controllers/replicationcontroller/#what-is-a-replicationcontroller
            """
            return self._set("replicas", value)

        @overload
        def selector(
            self, value_or_callback: apimachinery.LabelSelector, /
        ) -> "ReplicaSetSpec.Builder": ...

        @overload
        def selector(
            self,
            value_or_callback: Callable[
                [apimachinery.LabelSelector.Builder],
                apimachinery.LabelSelector.Builder | apimachinery.LabelSelector,
            ],
            /,
        ) -> "ReplicaSetSpec.Builder": ...

        @overload
        def selector(
            self, value_or_callback: Never = ...
        ) -> "apimachinery.LabelSelector.BuilderContext": ...

        def selector(self, value_or_callback=None, /):
            """
            Selector is a label query over pods that should match the replica count. Label keys and values that must match in order to be controlled by this replica set. It must match the pod template's labels. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/labels/#label-selectors
            """
            if self._in_context and value_or_callback is None:
                context = apimachinery.LabelSelector.BuilderContext()
                context._parent_builder = self
                context._field_name = "selector"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(apimachinery.LabelSelector.builder())
                if isinstance(output, apimachinery.LabelSelector.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("selector", value)

        @overload
        def template(
            self, value_or_callback: Optional[v1.PodTemplateSpec], /
        ) -> "ReplicaSetSpec.Builder": ...

        @overload
        def template(
            self,
            value_or_callback: Callable[
                [v1.PodTemplateSpec.Builder],
                v1.PodTemplateSpec.Builder | v1.PodTemplateSpec,
            ],
            /,
        ) -> "ReplicaSetSpec.Builder": ...

        @overload
        def template(
            self, value_or_callback: Never = ...
        ) -> "v1.PodTemplateSpec.BuilderContext": ...

        def template(self, value_or_callback=None, /):
            """
            Template is the object that describes the pod that will be created if insufficient replicas are detected. More info: https://kubernetes.io/docs/concepts/workloads/controllers/replicationcontroller#pod-template
            """
            if self._in_context and value_or_callback is None:
                context = v1.PodTemplateSpec.BuilderContext()
                context._parent_builder = self
                context._field_name = "template"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(v1.PodTemplateSpec.builder())
                if isinstance(output, v1.PodTemplateSpec.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("template", value)

    class BuilderContext(BuilderContextBase["ReplicaSetSpec.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = ReplicaSetSpec.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for ReplicaSetSpec."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["ReplicaSetSpec", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use ReplicaSetSpec.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    min_ready_seconds: Annotated[Optional[int], Field(alias="minReadySeconds")] = None
    """
    Minimum number of seconds for which a newly created pod should be ready without any of its container crashing, for it to be considered available. Defaults to 0 (pod will be considered available as soon as it is ready)
    """
    replicas: Optional[int] = None
    """
    Replicas is the number of desired replicas. This is a pointer to distinguish between explicit zero and unspecified. Defaults to 1. More info: https://kubernetes.io/docs/concepts/workloads/controllers/replicationcontroller/#what-is-a-replicationcontroller
    """
    selector: apimachinery.LabelSelector
    """
    Selector is a label query over pods that should match the replica count. Label keys and values that must match in order to be controlled by this replica set. It must match the pod template's labels. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/labels/#label-selectors
    """
    template: Optional[v1.PodTemplateSpec] = None
    """
    Template is the object that describes the pod that will be created if insufficient replicas are detected. More info: https://kubernetes.io/docs/concepts/workloads/controllers/replicationcontroller#pod-template
    """


class StatefulSetSpec(BaseModel):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["StatefulSetSpec"]:
            return StatefulSetSpec

        def build(self) -> "StatefulSetSpec":
            return StatefulSetSpec(**self._attrs)

        def min_ready_seconds(self, value: Optional[int], /) -> Self:
            """
            Minimum number of seconds for which a newly created pod should be ready without any of its container crashing for it to be considered available. Defaults to 0 (pod will be considered available as soon as it is ready)
            """
            return self._set("min_ready_seconds", value)

        @overload
        def ordinals(
            self, value_or_callback: Optional[StatefulSetOrdinals], /
        ) -> "StatefulSetSpec.Builder": ...

        @overload
        def ordinals(
            self,
            value_or_callback: Callable[
                [StatefulSetOrdinals.Builder],
                StatefulSetOrdinals.Builder | StatefulSetOrdinals,
            ],
            /,
        ) -> "StatefulSetSpec.Builder": ...

        @overload
        def ordinals(
            self, value_or_callback: Never = ...
        ) -> "StatefulSetOrdinals.BuilderContext": ...

        def ordinals(self, value_or_callback=None, /):
            """
            ordinals controls the numbering of replica indices in a StatefulSet. The default ordinals behavior assigns a "0" index to the first replica and increments the index by one for each additional replica requested.
            """
            if self._in_context and value_or_callback is None:
                context = StatefulSetOrdinals.BuilderContext()
                context._parent_builder = self
                context._field_name = "ordinals"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(StatefulSetOrdinals.builder())
                if isinstance(output, StatefulSetOrdinals.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("ordinals", value)

        @overload
        def persistent_volume_claim_retention_policy(
            self,
            value_or_callback: Optional[StatefulSetPersistentVolumeClaimRetentionPolicy],
            /,
        ) -> "StatefulSetSpec.Builder": ...

        @overload
        def persistent_volume_claim_retention_policy(
            self,
            value_or_callback: Callable[
                [StatefulSetPersistentVolumeClaimRetentionPolicy.Builder],
                StatefulSetPersistentVolumeClaimRetentionPolicy.Builder
                | StatefulSetPersistentVolumeClaimRetentionPolicy,
            ],
            /,
        ) -> "StatefulSetSpec.Builder": ...

        @overload
        def persistent_volume_claim_retention_policy(
            self, value_or_callback: Never = ...
        ) -> "StatefulSetPersistentVolumeClaimRetentionPolicy.BuilderContext": ...

        def persistent_volume_claim_retention_policy(self, value_or_callback=None, /):
            """
            persistentVolumeClaimRetentionPolicy describes the lifecycle of persistent volume claims created from volumeClaimTemplates. By default, all persistent volume claims are created as needed and retained until manually deleted. This policy allows the lifecycle to be altered, for example by deleting persistent volume claims when their stateful set is deleted, or when their pod is scaled down. This requires the StatefulSetAutoDeletePVC feature gate to be enabled, which is beta.
            """
            if self._in_context and value_or_callback is None:
                context = StatefulSetPersistentVolumeClaimRetentionPolicy.BuilderContext()
                context._parent_builder = self
                context._field_name = "persistent_volume_claim_retention_policy"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(
                    StatefulSetPersistentVolumeClaimRetentionPolicy.builder()
                )
                if isinstance(output, StatefulSetPersistentVolumeClaimRetentionPolicy.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("persistent_volume_claim_retention_policy", value)

        def pod_management_policy(self, value: Optional[str], /) -> Self:
            """
            podManagementPolicy controls how pods are created during initial scale up, when replacing pods on nodes, or when scaling down. The default policy is `OrderedReady`, where pods are created in increasing order (pod-0, then pod-1, etc) and the controller will wait until each pod is ready before continuing. When scaling down, the pods are removed in the opposite order. The alternative policy is `Parallel` which will create pods in parallel to match the desired scale without waiting, and on scale down will delete all pods at once.
            """
            return self._set("pod_management_policy", value)

        def replicas(self, value: Optional[int], /) -> Self:
            """
            replicas is the desired number of replicas of the given Template. These are replicas in the sense that they are instantiations of the same Template, but individual replicas also have a consistent identity. If unspecified, defaults to 1.
            """
            return self._set("replicas", value)

        def revision_history_limit(self, value: Optional[int], /) -> Self:
            """
            revisionHistoryLimit is the maximum number of revisions that will be maintained in the StatefulSet's revision history. The revision history consists of all revisions not represented by a currently applied StatefulSetSpec version. The default value is 10.
            """
            return self._set("revision_history_limit", value)

        @overload
        def selector(
            self, value_or_callback: apimachinery.LabelSelector, /
        ) -> "StatefulSetSpec.Builder": ...

        @overload
        def selector(
            self,
            value_or_callback: Callable[
                [apimachinery.LabelSelector.Builder],
                apimachinery.LabelSelector.Builder | apimachinery.LabelSelector,
            ],
            /,
        ) -> "StatefulSetSpec.Builder": ...

        @overload
        def selector(
            self, value_or_callback: Never = ...
        ) -> "apimachinery.LabelSelector.BuilderContext": ...

        def selector(self, value_or_callback=None, /):
            """
            selector is a label query over pods that should match the replica count. It must match the pod template's labels. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/labels/#label-selectors
            """
            if self._in_context and value_or_callback is None:
                context = apimachinery.LabelSelector.BuilderContext()
                context._parent_builder = self
                context._field_name = "selector"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(apimachinery.LabelSelector.builder())
                if isinstance(output, apimachinery.LabelSelector.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("selector", value)

        def service_name(self, value: str, /) -> Self:
            """
            serviceName is the name of the service that governs this StatefulSet. This service must exist before the StatefulSet, and is responsible for the network identity of the set. Pods get DNS/hostnames that follow the pattern: pod-specific-string.serviceName.default.svc.cluster.local where "pod-specific-string" is managed by the StatefulSet controller.
            """
            return self._set("service_name", value)

        @overload
        def template(
            self, value_or_callback: v1.PodTemplateSpec, /
        ) -> "StatefulSetSpec.Builder": ...

        @overload
        def template(
            self,
            value_or_callback: Callable[
                [v1.PodTemplateSpec.Builder],
                v1.PodTemplateSpec.Builder | v1.PodTemplateSpec,
            ],
            /,
        ) -> "StatefulSetSpec.Builder": ...

        @overload
        def template(
            self, value_or_callback: Never = ...
        ) -> "v1.PodTemplateSpec.BuilderContext": ...

        def template(self, value_or_callback=None, /):
            """
            template is the object that describes the pod that will be created if insufficient replicas are detected. Each pod stamped out by the StatefulSet will fulfill this Template, but have a unique identity from the rest of the StatefulSet. Each pod will be named with the format <statefulsetname>-<podindex>. For example, a pod in a StatefulSet named "web" with index number "3" would be named "web-3". The only allowed template.spec.restartPolicy value is "Always".
            """
            if self._in_context and value_or_callback is None:
                context = v1.PodTemplateSpec.BuilderContext()
                context._parent_builder = self
                context._field_name = "template"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(v1.PodTemplateSpec.builder())
                if isinstance(output, v1.PodTemplateSpec.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("template", value)

        @overload
        def update_strategy(
            self, value_or_callback: Optional[StatefulSetUpdateStrategy], /
        ) -> "StatefulSetSpec.Builder": ...

        @overload
        def update_strategy(
            self,
            value_or_callback: Callable[
                [StatefulSetUpdateStrategy.Builder],
                StatefulSetUpdateStrategy.Builder | StatefulSetUpdateStrategy,
            ],
            /,
        ) -> "StatefulSetSpec.Builder": ...

        @overload
        def update_strategy(
            self, value_or_callback: Never = ...
        ) -> "StatefulSetUpdateStrategy.BuilderContext": ...

        def update_strategy(self, value_or_callback=None, /):
            """
            updateStrategy indicates the StatefulSetUpdateStrategy that will be employed to update Pods in the StatefulSet when a revision is made to Template.
            """
            if self._in_context and value_or_callback is None:
                context = StatefulSetUpdateStrategy.BuilderContext()
                context._parent_builder = self
                context._field_name = "update_strategy"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(StatefulSetUpdateStrategy.builder())
                if isinstance(output, StatefulSetUpdateStrategy.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("update_strategy", value)

        @overload
        def volume_claim_templates(
            self, value_or_callback: List[v1.PersistentVolumeClaim], /
        ) -> "StatefulSetSpec.Builder": ...

        @overload
        def volume_claim_templates(
            self,
            value_or_callback: Callable[
                [GenericListBuilder[v1.PersistentVolumeClaim, v1.PersistentVolumeClaim.Builder]],
                GenericListBuilder[v1.PersistentVolumeClaim, v1.PersistentVolumeClaim.Builder]
                | List[v1.PersistentVolumeClaim],
            ],
            /,
        ) -> "StatefulSetSpec.Builder": ...

        @overload
        def volume_claim_templates(
            self, value_or_callback: Never = ...
        ) -> ListBuilderContext[v1.PersistentVolumeClaim.Builder]: ...

        def volume_claim_templates(self, value_or_callback=None, /):
            """
            volumeClaimTemplates is a list of claims that pods are allowed to reference. The StatefulSet controller is responsible for mapping network identities to claims in a way that maintains the identity of a pod. Every claim in this list must have at least one matching (by name) volumeMount in one container in the template. A claim in this list takes precedence over any volumes in the template, with the same name.
            """
            if self._in_context and value_or_callback is None:
                context = ListBuilderContext[v1.PersistentVolumeClaim.Builder]()
                context._parent_builder = self
                context._field_name = "volume_claim_templates"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(v1.PersistentVolumeClaim.list_builder())
                if isinstance(output, GenericListBuilder):
                    value = output.build()
                else:
                    value = output
            return self._set("volume_claim_templates", value)

    class BuilderContext(BuilderContextBase["StatefulSetSpec.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = StatefulSetSpec.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for StatefulSetSpec."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["StatefulSetSpec", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use StatefulSetSpec.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    min_ready_seconds: Annotated[Optional[int], Field(alias="minReadySeconds")] = None
    """
    Minimum number of seconds for which a newly created pod should be ready without any of its container crashing for it to be considered available. Defaults to 0 (pod will be considered available as soon as it is ready)
    """
    ordinals: Optional[StatefulSetOrdinals] = None
    """
    ordinals controls the numbering of replica indices in a StatefulSet. The default ordinals behavior assigns a "0" index to the first replica and increments the index by one for each additional replica requested.
    """
    persistent_volume_claim_retention_policy: Annotated[
        Optional[StatefulSetPersistentVolumeClaimRetentionPolicy],
        Field(alias="persistentVolumeClaimRetentionPolicy"),
    ] = None
    """
    persistentVolumeClaimRetentionPolicy describes the lifecycle of persistent volume claims created from volumeClaimTemplates. By default, all persistent volume claims are created as needed and retained until manually deleted. This policy allows the lifecycle to be altered, for example by deleting persistent volume claims when their stateful set is deleted, or when their pod is scaled down. This requires the StatefulSetAutoDeletePVC feature gate to be enabled, which is beta.
    """
    pod_management_policy: Annotated[Optional[str], Field(alias="podManagementPolicy")] = None
    """
    podManagementPolicy controls how pods are created during initial scale up, when replacing pods on nodes, or when scaling down. The default policy is `OrderedReady`, where pods are created in increasing order (pod-0, then pod-1, etc) and the controller will wait until each pod is ready before continuing. When scaling down, the pods are removed in the opposite order. The alternative policy is `Parallel` which will create pods in parallel to match the desired scale without waiting, and on scale down will delete all pods at once.
    """
    replicas: Optional[int] = None
    """
    replicas is the desired number of replicas of the given Template. These are replicas in the sense that they are instantiations of the same Template, but individual replicas also have a consistent identity. If unspecified, defaults to 1.
    """
    revision_history_limit: Annotated[Optional[int], Field(alias="revisionHistoryLimit")] = None
    """
    revisionHistoryLimit is the maximum number of revisions that will be maintained in the StatefulSet's revision history. The revision history consists of all revisions not represented by a currently applied StatefulSetSpec version. The default value is 10.
    """
    selector: apimachinery.LabelSelector
    """
    selector is a label query over pods that should match the replica count. It must match the pod template's labels. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/labels/#label-selectors
    """
    service_name: Annotated[str, Field(alias="serviceName")]
    """
    serviceName is the name of the service that governs this StatefulSet. This service must exist before the StatefulSet, and is responsible for the network identity of the set. Pods get DNS/hostnames that follow the pattern: pod-specific-string.serviceName.default.svc.cluster.local where "pod-specific-string" is managed by the StatefulSet controller.
    """
    template: v1.PodTemplateSpec
    """
    template is the object that describes the pod that will be created if insufficient replicas are detected. Each pod stamped out by the StatefulSet will fulfill this Template, but have a unique identity from the rest of the StatefulSet. Each pod will be named with the format <statefulsetname>-<podindex>. For example, a pod in a StatefulSet named "web" with index number "3" would be named "web-3". The only allowed template.spec.restartPolicy value is "Always".
    """
    update_strategy: Annotated[
        Optional[StatefulSetUpdateStrategy], Field(alias="updateStrategy")
    ] = None
    """
    updateStrategy indicates the StatefulSetUpdateStrategy that will be employed to update Pods in the StatefulSet when a revision is made to Template.
    """
    volume_claim_templates: Annotated[
        Optional[List[v1.PersistentVolumeClaim]], Field(alias="volumeClaimTemplates")
    ] = None
    """
    volumeClaimTemplates is a list of claims that pods are allowed to reference. The StatefulSet controller is responsible for mapping network identities to claims in a way that maintains the identity of a pod. Every claim in this list must have at least one matching (by name) volumeMount in one container in the template. A claim in this list takes precedence over any volumes in the template, with the same name.
    """


class DaemonSet(Resource):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["DaemonSet"]:
            return DaemonSet

        def build(self) -> "DaemonSet":
            return DaemonSet(**self._attrs)

        def api_version(self, value: Optional[Literal["apps/v1"]], /) -> Self:
            """
            APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
            """
            return self._set("api_version", value)

        def kind(self, value: Optional[Literal["DaemonSet"]], /) -> Self:
            """
            Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
            """
            return self._set("kind", value)

        @overload
        def metadata(
            self, value_or_callback: Optional[apimachinery.ObjectMeta], /
        ) -> "DaemonSet.Builder": ...

        @overload
        def metadata(
            self,
            value_or_callback: Callable[
                [apimachinery.ObjectMeta.Builder],
                apimachinery.ObjectMeta.Builder | apimachinery.ObjectMeta,
            ],
            /,
        ) -> "DaemonSet.Builder": ...

        @overload
        def metadata(
            self, value_or_callback: Never = ...
        ) -> "apimachinery.ObjectMeta.BuilderContext": ...

        def metadata(self, value_or_callback=None, /):
            """
            Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
            """
            if self._in_context and value_or_callback is None:
                context = apimachinery.ObjectMeta.BuilderContext()
                context._parent_builder = self
                context._field_name = "metadata"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(apimachinery.ObjectMeta.builder())
                if isinstance(output, apimachinery.ObjectMeta.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("metadata", value)

        @overload
        def spec(self, value_or_callback: Optional[DaemonSetSpec], /) -> "DaemonSet.Builder": ...

        @overload
        def spec(
            self,
            value_or_callback: Callable[
                [DaemonSetSpec.Builder], DaemonSetSpec.Builder | DaemonSetSpec
            ],
            /,
        ) -> "DaemonSet.Builder": ...

        @overload
        def spec(self, value_or_callback: Never = ...) -> "DaemonSetSpec.BuilderContext": ...

        def spec(self, value_or_callback=None, /):
            """
            The desired behavior of this daemon set. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
            """
            if self._in_context and value_or_callback is None:
                context = DaemonSetSpec.BuilderContext()
                context._parent_builder = self
                context._field_name = "spec"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(DaemonSetSpec.builder())
                if isinstance(output, DaemonSetSpec.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("spec", value)

        @overload
        def status(
            self, value_or_callback: Optional[DaemonSetStatus], /
        ) -> "DaemonSet.Builder": ...

        @overload
        def status(
            self,
            value_or_callback: Callable[
                [DaemonSetStatus.Builder], DaemonSetStatus.Builder | DaemonSetStatus
            ],
            /,
        ) -> "DaemonSet.Builder": ...

        @overload
        def status(self, value_or_callback: Never = ...) -> "DaemonSetStatus.BuilderContext": ...

        def status(self, value_or_callback=None, /):
            """
            The current status of this daemon set. This data may be out of date by some window of time. Populated by the system. Read-only. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
            """
            if self._in_context and value_or_callback is None:
                context = DaemonSetStatus.BuilderContext()
                context._parent_builder = self
                context._field_name = "status"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(DaemonSetStatus.builder())
                if isinstance(output, DaemonSetStatus.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("status", value)

    class BuilderContext(BuilderContextBase["DaemonSet.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = DaemonSet.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for DaemonSet."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["DaemonSet", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use DaemonSet.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    api_version: Annotated[Optional[Literal["apps/v1"]], Field(alias="apiVersion")] = "apps/v1"
    """
    APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
    """
    kind: Optional[Literal["DaemonSet"]] = "DaemonSet"
    """
    Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
    """
    metadata: Optional[apimachinery.ObjectMeta] = None
    """
    Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
    """
    spec: Optional[DaemonSetSpec] = None
    """
    The desired behavior of this daemon set. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
    """
    status: Optional[DaemonSetStatus] = None
    """
    The current status of this daemon set. This data may be out of date by some window of time. Populated by the system. Read-only. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
    """


DaemonSetList = ResourceList["DaemonSet"]


class Deployment(Resource):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["Deployment"]:
            return Deployment

        def build(self) -> "Deployment":
            return Deployment(**self._attrs)

        def api_version(self, value: Optional[Literal["apps/v1"]], /) -> Self:
            """
            APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
            """
            return self._set("api_version", value)

        def kind(self, value: Optional[Literal["Deployment"]], /) -> Self:
            """
            Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
            """
            return self._set("kind", value)

        @overload
        def metadata(
            self, value_or_callback: Optional[apimachinery.ObjectMeta], /
        ) -> "Deployment.Builder": ...

        @overload
        def metadata(
            self,
            value_or_callback: Callable[
                [apimachinery.ObjectMeta.Builder],
                apimachinery.ObjectMeta.Builder | apimachinery.ObjectMeta,
            ],
            /,
        ) -> "Deployment.Builder": ...

        @overload
        def metadata(
            self, value_or_callback: Never = ...
        ) -> "apimachinery.ObjectMeta.BuilderContext": ...

        def metadata(self, value_or_callback=None, /):
            """
            Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
            """
            if self._in_context and value_or_callback is None:
                context = apimachinery.ObjectMeta.BuilderContext()
                context._parent_builder = self
                context._field_name = "metadata"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(apimachinery.ObjectMeta.builder())
                if isinstance(output, apimachinery.ObjectMeta.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("metadata", value)

        @overload
        def spec(self, value_or_callback: Optional[DeploymentSpec], /) -> "Deployment.Builder": ...

        @overload
        def spec(
            self,
            value_or_callback: Callable[
                [DeploymentSpec.Builder], DeploymentSpec.Builder | DeploymentSpec
            ],
            /,
        ) -> "Deployment.Builder": ...

        @overload
        def spec(self, value_or_callback: Never = ...) -> "DeploymentSpec.BuilderContext": ...

        def spec(self, value_or_callback=None, /):
            """
            Specification of the desired behavior of the Deployment.
            """
            if self._in_context and value_or_callback is None:
                context = DeploymentSpec.BuilderContext()
                context._parent_builder = self
                context._field_name = "spec"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(DeploymentSpec.builder())
                if isinstance(output, DeploymentSpec.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("spec", value)

        @overload
        def status(
            self, value_or_callback: Optional[DeploymentStatus], /
        ) -> "Deployment.Builder": ...

        @overload
        def status(
            self,
            value_or_callback: Callable[
                [DeploymentStatus.Builder], DeploymentStatus.Builder | DeploymentStatus
            ],
            /,
        ) -> "Deployment.Builder": ...

        @overload
        def status(self, value_or_callback: Never = ...) -> "DeploymentStatus.BuilderContext": ...

        def status(self, value_or_callback=None, /):
            """
            Most recently observed status of the Deployment.
            """
            if self._in_context and value_or_callback is None:
                context = DeploymentStatus.BuilderContext()
                context._parent_builder = self
                context._field_name = "status"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(DeploymentStatus.builder())
                if isinstance(output, DeploymentStatus.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("status", value)

    class BuilderContext(BuilderContextBase["Deployment.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = Deployment.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for Deployment."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["Deployment", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use Deployment.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    api_version: Annotated[Optional[Literal["apps/v1"]], Field(alias="apiVersion")] = "apps/v1"
    """
    APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
    """
    kind: Optional[Literal["Deployment"]] = "Deployment"
    """
    Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
    """
    metadata: Optional[apimachinery.ObjectMeta] = None
    """
    Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
    """
    spec: Optional[DeploymentSpec] = None
    """
    Specification of the desired behavior of the Deployment.
    """
    status: Optional[DeploymentStatus] = None
    """
    Most recently observed status of the Deployment.
    """


DeploymentList = ResourceList["Deployment"]


class ReplicaSet(Resource):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["ReplicaSet"]:
            return ReplicaSet

        def build(self) -> "ReplicaSet":
            return ReplicaSet(**self._attrs)

        def api_version(self, value: Optional[Literal["apps/v1"]], /) -> Self:
            """
            APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
            """
            return self._set("api_version", value)

        def kind(self, value: Optional[Literal["ReplicaSet"]], /) -> Self:
            """
            Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
            """
            return self._set("kind", value)

        @overload
        def metadata(
            self, value_or_callback: Optional[apimachinery.ObjectMeta], /
        ) -> "ReplicaSet.Builder": ...

        @overload
        def metadata(
            self,
            value_or_callback: Callable[
                [apimachinery.ObjectMeta.Builder],
                apimachinery.ObjectMeta.Builder | apimachinery.ObjectMeta,
            ],
            /,
        ) -> "ReplicaSet.Builder": ...

        @overload
        def metadata(
            self, value_or_callback: Never = ...
        ) -> "apimachinery.ObjectMeta.BuilderContext": ...

        def metadata(self, value_or_callback=None, /):
            """
            If the Labels of a ReplicaSet are empty, they are defaulted to be the same as the Pod(s) that the ReplicaSet manages. Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
            """
            if self._in_context and value_or_callback is None:
                context = apimachinery.ObjectMeta.BuilderContext()
                context._parent_builder = self
                context._field_name = "metadata"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(apimachinery.ObjectMeta.builder())
                if isinstance(output, apimachinery.ObjectMeta.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("metadata", value)

        @overload
        def spec(self, value_or_callback: Optional[ReplicaSetSpec], /) -> "ReplicaSet.Builder": ...

        @overload
        def spec(
            self,
            value_or_callback: Callable[
                [ReplicaSetSpec.Builder], ReplicaSetSpec.Builder | ReplicaSetSpec
            ],
            /,
        ) -> "ReplicaSet.Builder": ...

        @overload
        def spec(self, value_or_callback: Never = ...) -> "ReplicaSetSpec.BuilderContext": ...

        def spec(self, value_or_callback=None, /):
            """
            Spec defines the specification of the desired behavior of the ReplicaSet. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
            """
            if self._in_context and value_or_callback is None:
                context = ReplicaSetSpec.BuilderContext()
                context._parent_builder = self
                context._field_name = "spec"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(ReplicaSetSpec.builder())
                if isinstance(output, ReplicaSetSpec.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("spec", value)

        @overload
        def status(
            self, value_or_callback: Optional[ReplicaSetStatus], /
        ) -> "ReplicaSet.Builder": ...

        @overload
        def status(
            self,
            value_or_callback: Callable[
                [ReplicaSetStatus.Builder], ReplicaSetStatus.Builder | ReplicaSetStatus
            ],
            /,
        ) -> "ReplicaSet.Builder": ...

        @overload
        def status(self, value_or_callback: Never = ...) -> "ReplicaSetStatus.BuilderContext": ...

        def status(self, value_or_callback=None, /):
            """
            Status is the most recently observed status of the ReplicaSet. This data may be out of date by some window of time. Populated by the system. Read-only. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
            """
            if self._in_context and value_or_callback is None:
                context = ReplicaSetStatus.BuilderContext()
                context._parent_builder = self
                context._field_name = "status"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(ReplicaSetStatus.builder())
                if isinstance(output, ReplicaSetStatus.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("status", value)

    class BuilderContext(BuilderContextBase["ReplicaSet.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = ReplicaSet.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for ReplicaSet."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["ReplicaSet", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use ReplicaSet.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    api_version: Annotated[Optional[Literal["apps/v1"]], Field(alias="apiVersion")] = "apps/v1"
    """
    APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
    """
    kind: Optional[Literal["ReplicaSet"]] = "ReplicaSet"
    """
    Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
    """
    metadata: Optional[apimachinery.ObjectMeta] = None
    """
    If the Labels of a ReplicaSet are empty, they are defaulted to be the same as the Pod(s) that the ReplicaSet manages. Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
    """
    spec: Optional[ReplicaSetSpec] = None
    """
    Spec defines the specification of the desired behavior of the ReplicaSet. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
    """
    status: Optional[ReplicaSetStatus] = None
    """
    Status is the most recently observed status of the ReplicaSet. This data may be out of date by some window of time. Populated by the system. Read-only. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
    """


ReplicaSetList = ResourceList["ReplicaSet"]


class StatefulSet(Resource):
    class Builder(BaseModelBuilder):
        @property
        def cls(self) -> Type["StatefulSet"]:
            return StatefulSet

        def build(self) -> "StatefulSet":
            return StatefulSet(**self._attrs)

        def api_version(self, value: Optional[Literal["apps/v1"]], /) -> Self:
            """
            APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
            """
            return self._set("api_version", value)

        def kind(self, value: Optional[Literal["StatefulSet"]], /) -> Self:
            """
            Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
            """
            return self._set("kind", value)

        @overload
        def metadata(
            self, value_or_callback: Optional[apimachinery.ObjectMeta], /
        ) -> "StatefulSet.Builder": ...

        @overload
        def metadata(
            self,
            value_or_callback: Callable[
                [apimachinery.ObjectMeta.Builder],
                apimachinery.ObjectMeta.Builder | apimachinery.ObjectMeta,
            ],
            /,
        ) -> "StatefulSet.Builder": ...

        @overload
        def metadata(
            self, value_or_callback: Never = ...
        ) -> "apimachinery.ObjectMeta.BuilderContext": ...

        def metadata(self, value_or_callback=None, /):
            """
            Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
            """
            if self._in_context and value_or_callback is None:
                context = apimachinery.ObjectMeta.BuilderContext()
                context._parent_builder = self
                context._field_name = "metadata"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(apimachinery.ObjectMeta.builder())
                if isinstance(output, apimachinery.ObjectMeta.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("metadata", value)

        @overload
        def spec(
            self, value_or_callback: Optional[StatefulSetSpec], /
        ) -> "StatefulSet.Builder": ...

        @overload
        def spec(
            self,
            value_or_callback: Callable[
                [StatefulSetSpec.Builder], StatefulSetSpec.Builder | StatefulSetSpec
            ],
            /,
        ) -> "StatefulSet.Builder": ...

        @overload
        def spec(self, value_or_callback: Never = ...) -> "StatefulSetSpec.BuilderContext": ...

        def spec(self, value_or_callback=None, /):
            """
            Spec defines the desired identities of pods in this set.
            """
            if self._in_context and value_or_callback is None:
                context = StatefulSetSpec.BuilderContext()
                context._parent_builder = self
                context._field_name = "spec"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(StatefulSetSpec.builder())
                if isinstance(output, StatefulSetSpec.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("spec", value)

        @overload
        def status(
            self, value_or_callback: Optional[StatefulSetStatus], /
        ) -> "StatefulSet.Builder": ...

        @overload
        def status(
            self,
            value_or_callback: Callable[
                [StatefulSetStatus.Builder],
                StatefulSetStatus.Builder | StatefulSetStatus,
            ],
            /,
        ) -> "StatefulSet.Builder": ...

        @overload
        def status(self, value_or_callback: Never = ...) -> "StatefulSetStatus.BuilderContext": ...

        def status(self, value_or_callback=None, /):
            """
            Status is the current status of Pods in this StatefulSet. This data may be out of date by some window of time.
            """
            if self._in_context and value_or_callback is None:
                context = StatefulSetStatus.BuilderContext()
                context._parent_builder = self
                context._field_name = "status"
                return context

            value = value_or_callback
            if callable(value_or_callback):
                output = value_or_callback(StatefulSetStatus.builder())
                if isinstance(output, StatefulSetStatus.Builder):
                    value = output.build()
                else:
                    value = output
            return self._set("status", value)

    class BuilderContext(BuilderContextBase["StatefulSet.Builder"]):
        def model_post_init(self, __context) -> None:
            self._builder = StatefulSet.Builder()
            self._builder._in_context = True
            self._parent_builder = None
            self._field_name = None

    @classmethod
    def builder(cls) -> Builder:
        return cls.Builder()

    @classmethod
    def new(cls) -> BuilderContext:
        """Creates a new context manager builder for StatefulSet."""
        return cls.BuilderContext()

    class ListBuilder(GenericListBuilder["StatefulSet", Builder]):
        def __init__(self):
            raise NotImplementedError(
                "This class is not meant to be instantiated. Use StatefulSet.list_builder() instead."
            )

    @classmethod
    def list_builder(cls) -> ListBuilder:
        return GenericListBuilder[cls, cls.Builder]()  # type: ignore

    api_version: Annotated[Optional[Literal["apps/v1"]], Field(alias="apiVersion")] = "apps/v1"
    """
    APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
    """
    kind: Optional[Literal["StatefulSet"]] = "StatefulSet"
    """
    Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
    """
    metadata: Optional[apimachinery.ObjectMeta] = None
    """
    Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
    """
    spec: Optional[StatefulSetSpec] = None
    """
    Spec defines the desired identities of pods in this set.
    """
    status: Optional[StatefulSetStatus] = None
    """
    Status is the current status of Pods in this StatefulSet. This data may be out of date by some window of time.
    """


StatefulSetList = ResourceList["StatefulSet"]
